#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"


//lint -e750
#define FC_VEHICLE_FUNCTION_S_IMPORT_INTERFACE_DP 
#include "../../di_cfc/components/FC_VehicleFunctions/interfaces/vehfunc_dp_if.h"
//lint +e750


#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"

tVoid vInitVehFunc(tU8 u8Bank)
{
   dp_tclDatapool* pDp = dp_tclDatapool::pGetInstance();
   u8Bank=DP_U8_NO_BANK_ACTION;
   if (pDp) pDp->vInitDp(DP_U32_POOL_ID_VEHFUNC, "VehFunc",0x0001,eDpLocation_FILE_SYSTEM,u8Bank,eDpModeEndUserNo);  

   {
      dp_tclBaseElement myEcoScoreHistoryElem("EcoScoreHistory", (tU8)0x00, (tS32)0xbbd72671, sizeof(TEcoScoreHistory), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);
                  
      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myEcoScoreHistoryElem);
   }

   {
      dp_tclBaseElement myHEVHistoryElem("HEVHistory", (tU8)0x00, (tS32)0xa7b1a61, sizeof(THEVConsumptionHistory), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);
                  
      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myHEVHistoryElem);
   }

   {      
      dp_tclBaseElement myMexRestartModeElem("MexRestartMode", (tU8)0x00, (tS32)0x3c4ca470, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_TEF);      
      
     tU8 tMexRestartMode = {0};
      
      DP_s32GetConfigItem("MEXConfig","CFMEXRestart",(tU8*)&tMexRestartMode, sizeof(tU8),TRUE);   
      (tVoid)myMexRestartModeElem.bSetDefaultData((tVoid*)&tMexRestartMode, (tU32)sizeof(tU8));
      (tVoid)myMexRestartModeElem.bFillData((tVoid*)&tMexRestartMode, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myMexRestartModeElem);
   }

   {      
      dp_tclBaseElement myVehicleModeElem("VehicleMode", (tU8)0x00, (tS32)0x40d80191, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_TEF);      
      
     tU8 tVehicleMode = {0};
      
      DP_s32GetConfigItem("HMIConfig","CFGVehicleMode",(tU8*)&tVehicleMode, sizeof(tU8),TRUE);   
      (tVoid)myVehicleModeElem.bSetDefaultData((tVoid*)&tVehicleMode, (tU32)sizeof(tU8));
      (tVoid)myVehicleModeElem.bFillData((tVoid*)&tVehicleMode, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myVehicleModeElem);
   }

   {      
      dp_tclBaseElement myEcoTripDataElem("EcoTripData", (tU8)0x00, (tS32)0x36cb6900, sizeof(TEcoTripData), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);      
      
     TEcoTripData tEcoTripData = {0};
      
         
      (tVoid)myEcoTripDataElem.bSetDefaultData((tVoid*)&tEcoTripData, (tU32)sizeof(TEcoTripData));
      (tVoid)myEcoTripDataElem.bFillData((tVoid*)&tEcoTripData, (tU32)sizeof(TEcoTripData));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myEcoTripDataElem);
   }

   {      
      dp_tclBaseElement myDrivingEcoDataElem("DrivingEcoData", (tU8)0x00, (tS32)0x54325984, sizeof(TEcoData), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);      
      
     TEcoData tDrivingEcoData = {0};
      
         
      (tVoid)myDrivingEcoDataElem.bSetDefaultData((tVoid*)&tDrivingEcoData, (tU32)sizeof(TEcoData));
      (tVoid)myDrivingEcoDataElem.bFillData((tVoid*)&tDrivingEcoData, (tU32)sizeof(TEcoData));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myDrivingEcoDataElem);
   }

   {
      dp_tclBaseElement myDrivingEcoHistoryElem("DrivingEcoHistory", (tU8)0x00, (tS32)0x1c971fa0, sizeof(TDrivingEcoHistory), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);
                  
      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myDrivingEcoHistoryElem);
   }

   {
      dp_tclBaseElement myDrivingEcoTripHistory_Home_WorkElem("DrivingEcoTripHistory_Home_Work", (tU8)0x00, (tS32)0x90bfc759L, sizeof(TDrivingEcoHistory), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);
                  
      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myDrivingEcoTripHistory_Home_WorkElem);
   }

   {
      dp_tclBaseElement myDrivingEcoTripHistory_JourneyElem("DrivingEcoTripHistory_Journey", (tU8)0x00, (tS32)0x61f3c68eL, sizeof(TDrivingEcoHistory), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);
                  
      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myDrivingEcoTripHistory_JourneyElem);
   }

   {
      dp_tclBaseElement myDrivingEcoTripHistory_PersonalElem("DrivingEcoTripHistory_Personal", (tU8)0x00, (tS32)0xe9c7849eL, sizeof(TDrivingEcoHistory), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);
                  
      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myDrivingEcoTripHistory_PersonalElem);
   }

   {      
      dp_tclBaseElement myEcoChallengeData_Home_WorkElem("EcoChallengeData_Home_Work", (tU8)0x00, (tS32)0x13eb2af6L, sizeof(TEcoChallengeScreenData), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);      
      
     TEcoChallengeScreenData tEcoChallengeData_Home_Work = {0};
      
         
      (tVoid)myEcoChallengeData_Home_WorkElem.bSetDefaultData((tVoid*)&tEcoChallengeData_Home_Work, (tU32)sizeof(TEcoChallengeScreenData));
      (tVoid)myEcoChallengeData_Home_WorkElem.bFillData((tVoid*)&tEcoChallengeData_Home_Work, (tU32)sizeof(TEcoChallengeScreenData));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myEcoChallengeData_Home_WorkElem);
   }

   {      
      dp_tclBaseElement myEcoChallengeData_JourneyElem("EcoChallengeData_Journey", (tU8)0x00, (tS32)0x9a6626b3, sizeof(TEcoChallengeScreenData), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);      
      
     TEcoChallengeScreenData tEcoChallengeData_Journey = {0};
      
         
      (tVoid)myEcoChallengeData_JourneyElem.bSetDefaultData((tVoid*)&tEcoChallengeData_Journey, (tU32)sizeof(TEcoChallengeScreenData));
      (tVoid)myEcoChallengeData_JourneyElem.bFillData((tVoid*)&tEcoChallengeData_Journey, (tU32)sizeof(TEcoChallengeScreenData));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myEcoChallengeData_JourneyElem);
   }

   {      
      dp_tclBaseElement myEcoChallengeData_PersonalElem("EcoChallengeData_Personal", (tU8)0x00, (tS32)0x4036557, sizeof(TEcoChallengeScreenData), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);      
      
     TEcoChallengeScreenData tEcoChallengeData_Personal = {0};
      
         
      (tVoid)myEcoChallengeData_PersonalElem.bSetDefaultData((tVoid*)&tEcoChallengeData_Personal, (tU32)sizeof(TEcoChallengeScreenData));
      (tVoid)myEcoChallengeData_PersonalElem.bFillData((tVoid*)&tEcoChallengeData_Personal, (tU32)sizeof(TEcoChallengeScreenData));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myEcoChallengeData_PersonalElem);
   }

   {      
      dp_tclBaseElement myLast_EcoTrip_Reset_TimeElem("Last_EcoTrip_Reset_Time", (tU8)0x00, (tS32)0xb1cdd14d, sizeof(TLastResetTime), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);      
      
     TLastResetTime tLast_EcoTrip_Reset_Time = {0};
      
         
      (tVoid)myLast_EcoTrip_Reset_TimeElem.bSetDefaultData((tVoid*)&tLast_EcoTrip_Reset_Time, (tU32)sizeof(TLastResetTime));
      (tVoid)myLast_EcoTrip_Reset_TimeElem.bFillData((tVoid*)&tLast_EcoTrip_Reset_Time, (tU32)sizeof(TLastResetTime));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myLast_EcoTrip_Reset_TimeElem);
   }

   {      
      dp_tclBaseElement myMainInfoData_OilFilterElem("MainInfoData_OilFilter", (tU8)0x00, (tS32)0x9212e914, sizeof(TMainInfoData), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);      
      
     TMainInfoData tMainInfoData_OilFilter = {0};
      
         
      (tVoid)myMainInfoData_OilFilterElem.bSetDefaultData((tVoid*)&tMainInfoData_OilFilter, (tU32)sizeof(TMainInfoData));
      (tVoid)myMainInfoData_OilFilterElem.bFillData((tVoid*)&tMainInfoData_OilFilter, (tU32)sizeof(TMainInfoData));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myMainInfoData_OilFilterElem);
   }

   {      
      dp_tclBaseElement myMainInfoData_TireElem("MainInfoData_Tire", (tU8)0x00, (tS32)0xfc1d57ee, sizeof(TMainInfoData), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);      
      
     TMainInfoData tMainInfoData_Tire = {0};
      
         
      (tVoid)myMainInfoData_TireElem.bSetDefaultData((tVoid*)&tMainInfoData_Tire, (tU32)sizeof(TMainInfoData));
      (tVoid)myMainInfoData_TireElem.bFillData((tVoid*)&tMainInfoData_Tire, (tU32)sizeof(TMainInfoData));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myMainInfoData_TireElem);
   }

   {      
      dp_tclBaseElement myMainInfoData_UserElem("MainInfoData_User", (tU8)0x00, (tS32)0xfc1d5931, sizeof(TMainInfoData), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);      
      
     TMainInfoData tMainInfoData_User = {0};
      
         
      (tVoid)myMainInfoData_UserElem.bSetDefaultData((tVoid*)&tMainInfoData_User, (tU32)sizeof(TMainInfoData));
      (tVoid)myMainInfoData_UserElem.bFillData((tVoid*)&tMainInfoData_User, (tU32)sizeof(TMainInfoData));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myMainInfoData_UserElem);
   }

   {      
      dp_tclBaseElement myMainInfoData_MileageElem("MainInfoData_Mileage", (tU8)0x00, (tS32)0x1a524132, sizeof(tU32), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U32,
      DP_DEFSET_TEF);      
      
     tU32 tMainInfoData_Mileage = {0};
      
         
      (tVoid)myMainInfoData_MileageElem.bSetDefaultData((tVoid*)&tMainInfoData_Mileage, (tU32)sizeof(tU32));
      (tVoid)myMainInfoData_MileageElem.bFillData((tVoid*)&tMainInfoData_Mileage, (tU32)sizeof(tU32));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myMainInfoData_MileageElem);
   }

   {      
      dp_tclBaseElement myMainInfoResetFlagElem("MainInfoResetFlag", (tU8)0x00, (tS32)0xfc75af22, sizeof(tBool), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_TEF);      
      
     tBool tMainInfoResetFlag = {false};
      
         
      (tVoid)myMainInfoResetFlagElem.bSetDefaultData((tVoid*)&tMainInfoResetFlag, (tU32)sizeof(tBool));
      (tVoid)myMainInfoResetFlagElem.bFillData((tVoid*)&tMainInfoResetFlag, (tU32)sizeof(tBool));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myMainInfoResetFlagElem);
   }

   {      
      dp_tclBaseElement myClinoMeter_AngleValuesElem("ClinoMeter_AngleValues", (tU8)0x00, (tS32)0x6a37bd7c, sizeof(TClinometerAngleData), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);      
      
     TClinometerAngleData tClinoMeter_AngleValues = {0};
      
         
      (tVoid)myClinoMeter_AngleValuesElem.bSetDefaultData((tVoid*)&tClinoMeter_AngleValues, (tU32)sizeof(TClinometerAngleData));
      (tVoid)myClinoMeter_AngleValuesElem.bFillData((tVoid*)&tClinoMeter_AngleValues, (tU32)sizeof(TClinometerAngleData));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myClinoMeter_AngleValuesElem);
   }

   {      
      dp_tclBaseElement myDriverAssistMemDisStateElem("DriverAssistMemDisState", (tU8)0x00, (tS32)0x2b73f81b, sizeof(TDriverAssistMemDisState), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);      
      
     TDriverAssistMemDisState tDriverAssistMemDisState = {0};
      
         
      (tVoid)myDriverAssistMemDisStateElem.bSetDefaultData((tVoid*)&tDriverAssistMemDisState, (tU32)sizeof(TDriverAssistMemDisState));
      (tVoid)myDriverAssistMemDisStateElem.bFillData((tVoid*)&tDriverAssistMemDisState, (tU32)sizeof(TDriverAssistMemDisState));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myDriverAssistMemDisStateElem);
   }

   {      
      dp_tclBaseElement myFuelConsumptionAverageElem("FuelConsumptionAverage", (tU8)0x00, (tS32)0x97ba3fc2, sizeof(tU32), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U32,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU32 tFuelConsumptionAverage = {0};
      
         
      (tVoid)myFuelConsumptionAverageElem.bSetDefaultData((tVoid*)&tFuelConsumptionAverage, (tU32)sizeof(tU32));
      (tVoid)myFuelConsumptionAverageElem.bFillData((tVoid*)&tFuelConsumptionAverage, (tU32)sizeof(tU32));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myFuelConsumptionAverageElem);
   }

   {
      dp_tclBaseElement myConsumptionHistoryElem("ConsumptionHistory", (tU8)0x00, (tS32)0x2be2c121, sizeof(TVehFuncConsumption), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);
                  
      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myConsumptionHistoryElem);
   }

   {      
      dp_tclBaseElement myDistance_Without_Acc_Current_TripElem("Distance_Without_Acc_Current_Trip", (tU8)0x00, (tS32)0x8e790518L, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_TEF);      
      
     tU8 tDistance_Without_Acc_Current_Trip = {0};
      
         
      (tVoid)myDistance_Without_Acc_Current_TripElem.bSetDefaultData((tVoid*)&tDistance_Without_Acc_Current_Trip, (tU32)sizeof(tU8));
      (tVoid)myDistance_Without_Acc_Current_TripElem.bFillData((tVoid*)&tDistance_Without_Acc_Current_Trip, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myDistance_Without_Acc_Current_TripElem);
   }

   {
      dp_tclBaseElement myDistance_Without_Acc_HistoryElem("Distance_Without_Acc_History", (tU8)0x00, (tS32)0x6af4245dL, sizeof(TDistance_WO_Acc_History), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_TEF);
                  
      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myDistance_Without_Acc_HistoryElem);
   }

   {      
      dp_tclBaseElement myEV_CatalogBatteryChargeElem("EV_CatalogBatteryCharge", (tU8)0x00, (tS32)0xa40831aa, sizeof(tU16), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U16,
      DP_DEFSET_TEF);      
      
     tU16 tEV_CatalogBatteryCharge = {0};
      
         
      (tVoid)myEV_CatalogBatteryChargeElem.bSetDefaultData((tVoid*)&tEV_CatalogBatteryCharge, (tU32)sizeof(tU16));
      (tVoid)myEV_CatalogBatteryChargeElem.bFillData((tVoid*)&tEV_CatalogBatteryCharge, (tU32)sizeof(tU16));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &myEV_CatalogBatteryChargeElem);
   }

   {      
      dp_tclBaseElement mySettingResetActivationElem("SettingResetActivation", (tU8)0x00, (tS32)0x9c35fb7f, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingResetActivation = {0};
      
         
      (tVoid)mySettingResetActivationElem.bSetDefaultData((tVoid*)&tSettingResetActivation, (tU32)sizeof(tU8));
      (tVoid)mySettingResetActivationElem.bFillData((tVoid*)&tSettingResetActivation, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingResetActivationElem);
   }

   {      
      dp_tclBaseElement mySettingADBElem("SettingADB", (tU8)0x00, (tS32)0xcafd281, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingADB = {0};
      
         
      (tVoid)mySettingADBElem.bSetDefaultData((tVoid*)&tSettingADB, (tU32)sizeof(tU8));
      (tVoid)mySettingADBElem.bFillData((tVoid*)&tSettingADB, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingADBElem);
   }

   {      
      dp_tclBaseElement mySettingDrivingSideElem("SettingDrivingSide", (tU8)0x00, (tS32)0x90310186, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingDrivingSide = {0};
      
         
      (tVoid)mySettingDrivingSideElem.bSetDefaultData((tVoid*)&tSettingDrivingSide, (tU32)sizeof(tU8));
      (tVoid)mySettingDrivingSideElem.bFillData((tVoid*)&tSettingDrivingSide, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingDrivingSideElem);
   }

   {      
      dp_tclBaseElement mySettingRearWiperElem("SettingRearWiper", (tU8)0x00, (tS32)0x57f1b6ff, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingRearWiper = {0};
      
         
      (tVoid)mySettingRearWiperElem.bSetDefaultData((tVoid*)&tSettingRearWiper, (tU32)sizeof(tU8));
      (tVoid)mySettingRearWiperElem.bFillData((tVoid*)&tSettingRearWiper, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingRearWiperElem);
   }

   {      
      dp_tclBaseElement mySettingAutoRelockElem("SettingAutoRelock", (tU8)0x00, (tS32)0xb632f4eb, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingAutoRelock = {0};
      
         
      (tVoid)mySettingAutoRelockElem.bSetDefaultData((tVoid*)&tSettingAutoRelock, (tU32)sizeof(tU8));
      (tVoid)mySettingAutoRelockElem.bFillData((tVoid*)&tSettingAutoRelock, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingAutoRelockElem);
   }

   {      
      dp_tclBaseElement mySettingIkeyAccessElem("SettingIkeyAccess", (tU8)0x00, (tS32)0xb6d56c92, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingIkeyAccess = {0};
      
         
      (tVoid)mySettingIkeyAccessElem.bSetDefaultData((tVoid*)&tSettingIkeyAccess, (tU32)sizeof(tU8));
      (tVoid)mySettingIkeyAccessElem.bFillData((tVoid*)&tSettingIkeyAccess, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingIkeyAccessElem);
   }

   {      
      dp_tclBaseElement mySettingSingleDoorOpeningElem("SettingSingleDoorOpening", (tU8)0x00, (tS32)0x8c8aa350, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingSingleDoorOpening = {0};
      
         
      (tVoid)mySettingSingleDoorOpeningElem.bSetDefaultData((tVoid*)&tSettingSingleDoorOpening, (tU32)sizeof(tU8));
      (tVoid)mySettingSingleDoorOpeningElem.bFillData((tVoid*)&tSettingSingleDoorOpening, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingSingleDoorOpeningElem);
   }

   {      
      dp_tclBaseElement mySettingStorageFormatElem("SettingStorageFormat", (tU8)0x00, (tS32)0xf7b07368, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingStorageFormat = {0};
      
         
      (tVoid)mySettingStorageFormatElem.bSetDefaultData((tVoid*)&tSettingStorageFormat, (tU32)sizeof(tU8));
      (tVoid)mySettingStorageFormatElem.bFillData((tVoid*)&tSettingStorageFormat, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingStorageFormatElem);
   }

   {      
      dp_tclBaseElement mySettingAmbientLightingDayIntensityElem("SettingAmbientLightingDayIntensity", (tU8)0x00, (tS32)0x99ce86fdL, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingAmbientLightingDayIntensity = {0};
      
         
      (tVoid)mySettingAmbientLightingDayIntensityElem.bSetDefaultData((tVoid*)&tSettingAmbientLightingDayIntensity, (tU32)sizeof(tU8));
      (tVoid)mySettingAmbientLightingDayIntensityElem.bFillData((tVoid*)&tSettingAmbientLightingDayIntensity, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingAmbientLightingDayIntensityElem);
   }

   {      
      dp_tclBaseElement mySettingAmbientLightingNightIntensityElem("SettingAmbientLightingNightIntensity", (tU8)0x00, (tS32)0x2e946409L, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingAmbientLightingNightIntensity = {0};
      
         
      (tVoid)mySettingAmbientLightingNightIntensityElem.bSetDefaultData((tVoid*)&tSettingAmbientLightingNightIntensity, (tU32)sizeof(tU8));
      (tVoid)mySettingAmbientLightingNightIntensityElem.bFillData((tVoid*)&tSettingAmbientLightingNightIntensity, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingAmbientLightingNightIntensityElem);
   }

   {      
      dp_tclBaseElement mySettingAmbientLightingArea1Elem("SettingAmbientLightingArea1", (tU8)0x00, (tS32)0x543b6ae2L, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingAmbientLightingArea1 = {0};
      
         
      (tVoid)mySettingAmbientLightingArea1Elem.bSetDefaultData((tVoid*)&tSettingAmbientLightingArea1, (tU32)sizeof(tU8));
      (tVoid)mySettingAmbientLightingArea1Elem.bFillData((tVoid*)&tSettingAmbientLightingArea1, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingAmbientLightingArea1Elem);
   }

   {      
      dp_tclBaseElement mySettingAmbientLightingArea2Elem("SettingAmbientLightingArea2", (tU8)0x00, (tS32)0x543b6ae3L, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingAmbientLightingArea2 = {0};
      
         
      (tVoid)mySettingAmbientLightingArea2Elem.bSetDefaultData((tVoid*)&tSettingAmbientLightingArea2, (tU32)sizeof(tU8));
      (tVoid)mySettingAmbientLightingArea2Elem.bFillData((tVoid*)&tSettingAmbientLightingArea2, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingAmbientLightingArea2Elem);
   }

   {      
      dp_tclBaseElement mySettingAmbientLightingArea3Elem("SettingAmbientLightingArea3", (tU8)0x00, (tS32)0x543b6ae4L, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingAmbientLightingArea3 = {0};
      
         
      (tVoid)mySettingAmbientLightingArea3Elem.bSetDefaultData((tVoid*)&tSettingAmbientLightingArea3, (tU32)sizeof(tU8));
      (tVoid)mySettingAmbientLightingArea3Elem.bFillData((tVoid*)&tSettingAmbientLightingArea3, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingAmbientLightingArea3Elem);
   }

   {      
      dp_tclBaseElement mySettingAmbientLightingPatternElem("SettingAmbientLightingPattern", (tU8)0x00, (tS32)0x39d069b6L, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingAmbientLightingPattern = {0};
      
         
      (tVoid)mySettingAmbientLightingPatternElem.bSetDefaultData((tVoid*)&tSettingAmbientLightingPattern, (tU32)sizeof(tU8));
      (tVoid)mySettingAmbientLightingPatternElem.bFillData((tVoid*)&tSettingAmbientLightingPattern, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingAmbientLightingPatternElem);
   }

   {      
      dp_tclBaseElement mySettingAmbientLightingActivationElem("SettingAmbientLightingActivation", (tU8)0x00, (tS32)0x390e971eL, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingAmbientLightingActivation = {0};
      
         
      (tVoid)mySettingAmbientLightingActivationElem.bSetDefaultData((tVoid*)&tSettingAmbientLightingActivation, (tU32)sizeof(tU8));
      (tVoid)mySettingAmbientLightingActivationElem.bFillData((tVoid*)&tSettingAmbientLightingActivation, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingAmbientLightingActivationElem);
   }

   {      
      dp_tclBaseElement mySettingAmbientLightingColorElem("SettingAmbientLightingColor", (tU8)0x01, (tS32)0x543b6f83L, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingAmbientLightingColor = {1};
      
         
      (tVoid)mySettingAmbientLightingColorElem.bSetDefaultData((tVoid*)&tSettingAmbientLightingColor, (tU32)sizeof(tU8));
      (tVoid)mySettingAmbientLightingColorElem.bFillData((tVoid*)&tSettingAmbientLightingColor, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingAmbientLightingColorElem);
   }

   {      
      dp_tclBaseElement mySettingClusterSkinElem("SettingClusterSkin", (tU8)0x00, (tS32)0x8f2f6de9, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingClusterSkin = {0};
      
         
      (tVoid)mySettingClusterSkinElem.bSetDefaultData((tVoid*)&tSettingClusterSkin, (tU32)sizeof(tU8));
      (tVoid)mySettingClusterSkinElem.bFillData((tVoid*)&tSettingClusterSkin, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingClusterSkinElem);
   }

   {      
      dp_tclBaseElement mySettingSailingActivationIdleElem("SettingSailingActivationIdle", (tU8)0x00, (tS32)0xb3c46621L, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingSailingActivationIdle = {0};
      
         
      (tVoid)mySettingSailingActivationIdleElem.bSetDefaultData((tVoid*)&tSettingSailingActivationIdle, (tU32)sizeof(tU8));
      (tVoid)mySettingSailingActivationIdleElem.bFillData((tVoid*)&tSettingSailingActivationIdle, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingSailingActivationIdleElem);
   }

   {      
      dp_tclBaseElement mySettingLKAElem("SettingLKA", (tU8)0x01, (tS32)0xcafd3b6, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingLKA = {1};
      
         
      (tVoid)mySettingLKAElem.bSetDefaultData((tVoid*)&tSettingLKA, (tU32)sizeof(tU8));
      (tVoid)mySettingLKAElem.bFillData((tVoid*)&tSettingLKA, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingLKAElem);
   }

   {      
      dp_tclBaseElement mySettingAutoInternalLightsElem("SettingAutoInternalLights", (tU8)0x00, (tS32)0xb7c03afb, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingAutoInternalLights = {0};
      
         
      (tVoid)mySettingAutoInternalLightsElem.bSetDefaultData((tVoid*)&tSettingAutoInternalLights, (tU32)sizeof(tU8));
      (tVoid)mySettingAutoInternalLightsElem.bFillData((tVoid*)&tSettingAutoInternalLights, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingAutoInternalLightsElem);
   }

   {      
      dp_tclBaseElement mySettingDriverMassageActivationSettingElem("SettingDriverMassageActivationSetting", (tU8)0x00, (tS32)0x2570f83bL, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingDriverMassageActivationSetting = {0};
      
         
      (tVoid)mySettingDriverMassageActivationSettingElem.bSetDefaultData((tVoid*)&tSettingDriverMassageActivationSetting, (tU32)sizeof(tU8));
      (tVoid)mySettingDriverMassageActivationSettingElem.bFillData((tVoid*)&tSettingDriverMassageActivationSetting, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingDriverMassageActivationSettingElem);
   }

   {      
      dp_tclBaseElement mySettingDriverEasyAccessElem("SettingDriverEasyAccess", (tU8)0x00, (tS32)0x1955f8b6, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingDriverEasyAccess = {0};
      
         
      (tVoid)mySettingDriverEasyAccessElem.bSetDefaultData((tVoid*)&tSettingDriverEasyAccess, (tU32)sizeof(tU8));
      (tVoid)mySettingDriverEasyAccessElem.bFillData((tVoid*)&tSettingDriverEasyAccess, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingDriverEasyAccessElem);
   }

   {      
      dp_tclBaseElement mySettingPassengerMassageActivationElem("SettingPassengerMassageActivation", (tU8)0x00, (tS32)0x9079737dL, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingPassengerMassageActivation = {0};
      
         
      (tVoid)mySettingPassengerMassageActivationElem.bSetDefaultData((tVoid*)&tSettingPassengerMassageActivation, (tU32)sizeof(tU8));
      (tVoid)mySettingPassengerMassageActivationElem.bFillData((tVoid*)&tSettingPassengerMassageActivation, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingPassengerMassageActivationElem);
   }

   {      
      dp_tclBaseElement mySettingPassengerMassageProgramStateElem("SettingPassengerMassageProgramState", (tU8)0x00, (tS32)0x4f9917fcL, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingPassengerMassageProgramState = {0};
      
         
      (tVoid)mySettingPassengerMassageProgramStateElem.bSetDefaultData((tVoid*)&tSettingPassengerMassageProgramState, (tU32)sizeof(tU8));
      (tVoid)mySettingPassengerMassageProgramStateElem.bFillData((tVoid*)&tSettingPassengerMassageProgramState, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingPassengerMassageProgramStateElem);
   }

   {      
      dp_tclBaseElement mySettingPassengerMassageVelocityElem("SettingPassengerMassageVelocity", (tU8)0x00, (tS32)0x9f7a2bd6L, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingPassengerMassageVelocity = {0};
      
         
      (tVoid)mySettingPassengerMassageVelocityElem.bSetDefaultData((tVoid*)&tSettingPassengerMassageVelocity, (tU32)sizeof(tU8));
      (tVoid)mySettingPassengerMassageVelocityElem.bFillData((tVoid*)&tSettingPassengerMassageVelocity, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingPassengerMassageVelocityElem);
   }

   {      
      dp_tclBaseElement mySettingPassengerMassageIntensityElem("SettingPassengerMassageIntensity", (tU8)0x00, (tS32)0x1d21a696L, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingPassengerMassageIntensity = {0};
      
         
      (tVoid)mySettingPassengerMassageIntensityElem.bSetDefaultData((tVoid*)&tSettingPassengerMassageIntensity, (tU32)sizeof(tU8));
      (tVoid)mySettingPassengerMassageIntensityElem.bFillData((tVoid*)&tSettingPassengerMassageIntensity, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingPassengerMassageIntensityElem);
   }

   {      
      dp_tclBaseElement mySettingPassengerVentilElem("SettingPassengerVentil", (tU8)0x00, (tS32)0xc6db03f4, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingPassengerVentil = {0};
      
         
      (tVoid)mySettingPassengerVentilElem.bSetDefaultData((tVoid*)&tSettingPassengerVentil, (tU32)sizeof(tU8));
      (tVoid)mySettingPassengerVentilElem.bFillData((tVoid*)&tSettingPassengerVentil, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingPassengerVentilElem);
   }

   {      
      dp_tclBaseElement mySettingPassengerHeatingElem("SettingPassengerHeating", (tU8)0x00, (tS32)0xe2439dfa, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingPassengerHeating = {0};
      
         
      (tVoid)mySettingPassengerHeatingElem.bSetDefaultData((tVoid*)&tSettingPassengerHeating, (tU32)sizeof(tU8));
      (tVoid)mySettingPassengerHeatingElem.bFillData((tVoid*)&tSettingPassengerHeating, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingPassengerHeatingElem);
   }

   {      
      dp_tclBaseElement mySettingPassengerEasyAccessElem("SettingPassengerEasyAccess", (tU8)0x00, (tS32)0x7aa7912eL, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingPassengerEasyAccess = {0};
      
         
      (tVoid)mySettingPassengerEasyAccessElem.bSetDefaultData((tVoid*)&tSettingPassengerEasyAccess, (tU32)sizeof(tU8));
      (tVoid)mySettingPassengerEasyAccessElem.bFillData((tVoid*)&tSettingPassengerEasyAccess, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingPassengerEasyAccessElem);
   }

   {      
      dp_tclBaseElement mySettingSeat1_FoldingElem("SettingSeat1_Folding", (tU8)0x00, (tS32)0xc2f0e416, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingSeat1_Folding = {0};
      
         
      (tVoid)mySettingSeat1_FoldingElem.bSetDefaultData((tVoid*)&tSettingSeat1_Folding, (tU32)sizeof(tU8));
      (tVoid)mySettingSeat1_FoldingElem.bFillData((tVoid*)&tSettingSeat1_Folding, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingSeat1_FoldingElem);
   }

   {      
      dp_tclBaseElement mySettingSeat2_FoldingElem("SettingSeat2_Folding", (tU8)0x00, (tS32)0xc2f6d9f7, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingSeat2_Folding = {0};
      
         
      (tVoid)mySettingSeat2_FoldingElem.bSetDefaultData((tVoid*)&tSettingSeat2_Folding, (tU32)sizeof(tU8));
      (tVoid)mySettingSeat2_FoldingElem.bFillData((tVoid*)&tSettingSeat2_Folding, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingSeat2_FoldingElem);
   }

   {      
      dp_tclBaseElement mySettingSeat3_FoldingElem("SettingSeat3_Folding", (tU8)0x00, (tS32)0xc2fccfd8, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingSeat3_Folding = {0};
      
         
      (tVoid)mySettingSeat3_FoldingElem.bSetDefaultData((tVoid*)&tSettingSeat3_Folding, (tU32)sizeof(tU8));
      (tVoid)mySettingSeat3_FoldingElem.bFillData((tVoid*)&tSettingSeat3_Folding, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingSeat3_FoldingElem);
   }

   {      
      dp_tclBaseElement mySettingSeat4_FoldingElem("SettingSeat4_Folding", (tU8)0x00, (tS32)0xc302c5b9, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingSeat4_Folding = {0};
      
         
      (tVoid)mySettingSeat4_FoldingElem.bSetDefaultData((tVoid*)&tSettingSeat4_Folding, (tU32)sizeof(tU8));
      (tVoid)mySettingSeat4_FoldingElem.bFillData((tVoid*)&tSettingSeat4_Folding, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingSeat4_FoldingElem);
   }

   {      
      dp_tclBaseElement mySettingSeat5_FoldingElem("SettingSeat5_Folding", (tU8)0x00, (tS32)0xc308bb9a, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingSeat5_Folding = {0};
      
         
      (tVoid)mySettingSeat5_FoldingElem.bSetDefaultData((tVoid*)&tSettingSeat5_Folding, (tU32)sizeof(tU8));
      (tVoid)mySettingSeat5_FoldingElem.bFillData((tVoid*)&tSettingSeat5_Folding, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingSeat5_FoldingElem);
   }

   {      
      dp_tclBaseElement mySettingCourtesyActivationElem("SettingCourtesyActivation", (tU8)0x00, (tS32)0xea7b04c6, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeShutdown , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF);      
      
     tU8 tSettingCourtesyActivation = {0};
      
         
      (tVoid)mySettingCourtesyActivationElem.bSetDefaultData((tVoid*)&tSettingCourtesyActivation, (tU32)sizeof(tU8));
      (tVoid)mySettingCourtesyActivationElem.bFillData((tVoid*)&tSettingCourtesyActivation, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_VEHFUNC, &mySettingCourtesyActivationElem);
   }
   if (pDp) pDp->vInitUnknownCodingElements(DP_U32_POOL_ID_VEHFUNC);
}
