
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclprofileMngr.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Profiles"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileMngrProfiles::dp_tclprofileMngrProfiles(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclprofileMngrProfiles::s32SetData( tU8* tProfilesParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Profiles", (tS32)0x811050);
   (tVoid)myDpElem.bFillData((tVoid*)tProfilesParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclprofileMngrProfiles::s32GetData(tU8* tProfilesParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Profiles", (tS32)0x811050);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tProfilesParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclprofileMngrProfiles::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclprofileMngrProfiles::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclprofileMngrProfiles::u16GetData(tU8* tProfilesParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tProfilesParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclprofileMngrProfiles::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_PROFILEMNGR, "Profiles", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclprofileMngrProfiles::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEMNGR, "Profiles", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclprofileMngrProfiles::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Profiles", DP_U32_POOL_ID_PROFILEMNGR);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEMNGR);
		}
		else
		{
			fprintf(stdout,"Element Profiles has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "StartClients"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileMngrStartClients::dp_tclprofileMngrStartClients(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclprofileMngrStartClients::s32SetData( tU8* tStartClientsParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("StartClients", (tS32)0x43a8232c);
   (tVoid)myDpElem.bFillData((tVoid*)tStartClientsParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclprofileMngrStartClients::s32GetData(tU8* tStartClientsParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("StartClients", (tS32)0x43a8232c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tStartClientsParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclprofileMngrStartClients::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclprofileMngrStartClients::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclprofileMngrStartClients::u16GetData(tU8* tStartClientsParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tStartClientsParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclprofileMngrStartClients::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_PROFILEMNGR, "StartClients", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclprofileMngrStartClients::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEMNGR, "StartClients", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclprofileMngrStartClients::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: StartClients", DP_U32_POOL_ID_PROFILEMNGR);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEMNGR);
		}
		else
		{
			fprintf(stdout,"Element StartClients has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PrivacyMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileMngrPrivacyMode::dp_tclprofileMngrPrivacyMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPrivacyMode,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclprofileMngrPrivacyMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PrivacyMode",(tS32) 0x3ef21beb);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tPrivacyMode = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclprofileMngrPrivacyMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PrivacyMode", (tS32)0x3ef21beb);
   (tVoid)myDpElem.bFillData((tVoid*)&tPrivacyMode, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclprofileMngrPrivacyMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclprofileMngrPrivacyMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclprofileMngrPrivacyMode::tGetData() {
   vUpdate();
   return tPrivacyMode;
};
tS32 dp_tclprofileMngrPrivacyMode::s32GetData(tU32& tPrivacyModeParam) { 
   vUpdate();
   tPrivacyModeParam = tPrivacyMode;
   return _s32Status;
}
tS32 dp_tclprofileMngrPrivacyMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PrivacyMode", (tS32)0x3ef21beb);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclprofileMngrPrivacyMode::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclprofileMngrPrivacyMode::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclprofileMngrPrivacyMode::s32SetData(tU32 &tPrivacyModeParam) {
   //init parameter
   (tVoid)memcpy(&tPrivacyMode,(tVoid*)&tPrivacyModeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPrivacyModeParam' in function 'dp_tclprofileMngrPrivacyMode::vSetData(tU32)' could be made const reference
tS32 dp_tclprofileMngrPrivacyMode::s32SetData(const tU32 &tPrivacyModeParam) {
   //init parameter
   (tVoid)memcpy(&tPrivacyMode,(tVoid*)&tPrivacyModeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPrivacyModeParam' in function 'dp_tclprofileMngrPrivacyMode::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclprofileMngrPrivacyMode::u8GetData(tU32& tPrivacyModeParam) {  
   vUpdate();
   tPrivacyModeParam = tPrivacyMode;
   return _u8DataStatus;
}
tVoid dp_tclprofileMngrPrivacyMode::vSetData(tU32 &tPrivacyModeParam) { 
   //init parameter
   (tVoid)memcpy(&tPrivacyMode,(tVoid*)&tPrivacyModeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tPrivacyModeParam' in function 'dp_tclprofileMngrPrivacyMode::vSetData(tU32)' could be made const reference
tVoid dp_tclprofileMngrPrivacyMode::vSetData(const tU32 &tPrivacyModeParam) { 
   //init parameter
   (tVoid)memcpy(&tPrivacyMode,(tVoid*)&tPrivacyModeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tPrivacyModeParam' in function 'dp_tclprofileMngrPrivacyMode::vSetData(tU32)' could be made const reference
tU8   dp_tclprofileMngrPrivacyMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclprofileMngrPrivacyMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PROFILEMNGR, "PrivacyMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrPrivacyMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEMNGR, "PrivacyMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrPrivacyMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PrivacyMode", DP_U32_POOL_ID_PROFILEMNGR);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEMNGR);
   }
   else
   {
      fprintf(stdout,"Element PrivacyMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PinHash"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileMngrPinHash::dp_tclprofileMngrPinHash(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclprofileMngrPinHash::s32SetData( tU8* tPinHashParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("PinHash", (tS32)0x195063);
   (tVoid)myDpElem.bFillData((tVoid*)tPinHashParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclprofileMngrPinHash::s32GetData(tU8* tPinHashParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("PinHash", (tS32)0x195063);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tPinHashParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclprofileMngrPinHash::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclprofileMngrPinHash::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclprofileMngrPinHash::u16GetData(tU8* tPinHashParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tPinHashParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclprofileMngrPinHash::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_PROFILEMNGR, "PinHash", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclprofileMngrPinHash::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEMNGR, "PinHash", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclprofileMngrPinHash::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PinHash", DP_U32_POOL_ID_PROFILEMNGR);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEMNGR);
		}
		else
		{
			fprintf(stdout,"Element PinHash has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PinCounter"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileMngrPinCounter::dp_tclprofileMngrPinCounter(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclprofileMngrPinCounter::s32SetData( tU8* tPinCounterParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("PinCounter", (tS32)0xc5bcf9f);
   (tVoid)myDpElem.bFillData((tVoid*)tPinCounterParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclprofileMngrPinCounter::s32GetData(tU8* tPinCounterParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("PinCounter", (tS32)0xc5bcf9f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tPinCounterParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclprofileMngrPinCounter::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclprofileMngrPinCounter::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclprofileMngrPinCounter::u16GetData(tU8* tPinCounterParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tPinCounterParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclprofileMngrPinCounter::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_PROFILEMNGR, "PinCounter", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclprofileMngrPinCounter::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEMNGR, "PinCounter", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclprofileMngrPinCounter::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PinCounter", DP_U32_POOL_ID_PROFILEMNGR);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEMNGR);
		}
		else
		{
			fprintf(stdout,"Element PinCounter has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MaxPINAttemptsTotal"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileMngrMaxPINAttemptsTotal::dp_tclprofileMngrMaxPINAttemptsTotal(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMaxPINAttemptsTotal,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclprofileMngrMaxPINAttemptsTotal::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MaxPINAttemptsTotal",(tS32) 0x558cd5f7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMaxPINAttemptsTotal = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclprofileMngrMaxPINAttemptsTotal::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MaxPINAttemptsTotal", (tS32)0x558cd5f7);
   (tVoid)myDpElem.bFillData((tVoid*)&tMaxPINAttemptsTotal, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclprofileMngrMaxPINAttemptsTotal::s32GetStatus() const {return _s32Status;};
tU8   dp_tclprofileMngrMaxPINAttemptsTotal::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclprofileMngrMaxPINAttemptsTotal::tGetData() {
   vUpdate();
   return tMaxPINAttemptsTotal;
};
tS32 dp_tclprofileMngrMaxPINAttemptsTotal::s32GetData(tU8& tMaxPINAttemptsTotalParam) { 
   vUpdate();
   tMaxPINAttemptsTotalParam = tMaxPINAttemptsTotal;
   return _s32Status;
}
tS32 dp_tclprofileMngrMaxPINAttemptsTotal::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MaxPINAttemptsTotal", (tS32)0x558cd5f7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclprofileMngrMaxPINAttemptsTotal::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclprofileMngrMaxPINAttemptsTotal::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclprofileMngrMaxPINAttemptsTotal::s32SetData(tU8 &tMaxPINAttemptsTotalParam) {
   //init parameter
   (tVoid)memcpy(&tMaxPINAttemptsTotal,(tVoid*)&tMaxPINAttemptsTotalParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMaxPINAttemptsTotalParam' in function 'dp_tclprofileMngrMaxPINAttemptsTotal::vSetData(tU8)' could be made const reference
tS32 dp_tclprofileMngrMaxPINAttemptsTotal::s32SetData(const tU8 &tMaxPINAttemptsTotalParam) {
   //init parameter
   (tVoid)memcpy(&tMaxPINAttemptsTotal,(tVoid*)&tMaxPINAttemptsTotalParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMaxPINAttemptsTotalParam' in function 'dp_tclprofileMngrMaxPINAttemptsTotal::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclprofileMngrMaxPINAttemptsTotal::u8GetData(tU8& tMaxPINAttemptsTotalParam) {  
   vUpdate();
   tMaxPINAttemptsTotalParam = tMaxPINAttemptsTotal;
   return _u8DataStatus;
}
tVoid dp_tclprofileMngrMaxPINAttemptsTotal::vSetData(tU8 &tMaxPINAttemptsTotalParam) { 
   //init parameter
   (tVoid)memcpy(&tMaxPINAttemptsTotal,(tVoid*)&tMaxPINAttemptsTotalParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMaxPINAttemptsTotalParam' in function 'dp_tclprofileMngrMaxPINAttemptsTotal::vSetData(tU8)' could be made const reference
tVoid dp_tclprofileMngrMaxPINAttemptsTotal::vSetData(const tU8 &tMaxPINAttemptsTotalParam) { 
   //init parameter
   (tVoid)memcpy(&tMaxPINAttemptsTotal,(tVoid*)&tMaxPINAttemptsTotalParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMaxPINAttemptsTotalParam' in function 'dp_tclprofileMngrMaxPINAttemptsTotal::vSetData(tU8)' could be made const reference
tU8   dp_tclprofileMngrMaxPINAttemptsTotal::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclprofileMngrMaxPINAttemptsTotal::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PROFILEMNGR, "MaxPINAttemptsTotal", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrMaxPINAttemptsTotal::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEMNGR, "MaxPINAttemptsTotal", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrMaxPINAttemptsTotal::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MaxPINAttemptsTotal", DP_U32_POOL_ID_PROFILEMNGR);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEMNGR);
   }
   else
   {
      fprintf(stdout,"Element MaxPINAttemptsTotal has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MaxPINAttemptsBeforeDelay"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileMngrMaxPINAttemptsBeforeDelay::dp_tclprofileMngrMaxPINAttemptsBeforeDelay(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMaxPINAttemptsBeforeDelay,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclprofileMngrMaxPINAttemptsBeforeDelay::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MaxPINAttemptsBeforeDelay",(tS32) 0x850f86c1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMaxPINAttemptsBeforeDelay = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclprofileMngrMaxPINAttemptsBeforeDelay::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MaxPINAttemptsBeforeDelay", (tS32)0x850f86c1);
   (tVoid)myDpElem.bFillData((tVoid*)&tMaxPINAttemptsBeforeDelay, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclprofileMngrMaxPINAttemptsBeforeDelay::s32GetStatus() const {return _s32Status;};
tU8   dp_tclprofileMngrMaxPINAttemptsBeforeDelay::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclprofileMngrMaxPINAttemptsBeforeDelay::tGetData() {
   vUpdate();
   return tMaxPINAttemptsBeforeDelay;
};
tS32 dp_tclprofileMngrMaxPINAttemptsBeforeDelay::s32GetData(tU8& tMaxPINAttemptsBeforeDelayParam) { 
   vUpdate();
   tMaxPINAttemptsBeforeDelayParam = tMaxPINAttemptsBeforeDelay;
   return _s32Status;
}
tS32 dp_tclprofileMngrMaxPINAttemptsBeforeDelay::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MaxPINAttemptsBeforeDelay", (tS32)0x850f86c1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclprofileMngrMaxPINAttemptsBeforeDelay::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclprofileMngrMaxPINAttemptsBeforeDelay::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclprofileMngrMaxPINAttemptsBeforeDelay::s32SetData(tU8 &tMaxPINAttemptsBeforeDelayParam) {
   //init parameter
   (tVoid)memcpy(&tMaxPINAttemptsBeforeDelay,(tVoid*)&tMaxPINAttemptsBeforeDelayParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMaxPINAttemptsBeforeDelayParam' in function 'dp_tclprofileMngrMaxPINAttemptsBeforeDelay::vSetData(tU8)' could be made const reference
tS32 dp_tclprofileMngrMaxPINAttemptsBeforeDelay::s32SetData(const tU8 &tMaxPINAttemptsBeforeDelayParam) {
   //init parameter
   (tVoid)memcpy(&tMaxPINAttemptsBeforeDelay,(tVoid*)&tMaxPINAttemptsBeforeDelayParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMaxPINAttemptsBeforeDelayParam' in function 'dp_tclprofileMngrMaxPINAttemptsBeforeDelay::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclprofileMngrMaxPINAttemptsBeforeDelay::u8GetData(tU8& tMaxPINAttemptsBeforeDelayParam) {  
   vUpdate();
   tMaxPINAttemptsBeforeDelayParam = tMaxPINAttemptsBeforeDelay;
   return _u8DataStatus;
}
tVoid dp_tclprofileMngrMaxPINAttemptsBeforeDelay::vSetData(tU8 &tMaxPINAttemptsBeforeDelayParam) { 
   //init parameter
   (tVoid)memcpy(&tMaxPINAttemptsBeforeDelay,(tVoid*)&tMaxPINAttemptsBeforeDelayParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMaxPINAttemptsBeforeDelayParam' in function 'dp_tclprofileMngrMaxPINAttemptsBeforeDelay::vSetData(tU8)' could be made const reference
tVoid dp_tclprofileMngrMaxPINAttemptsBeforeDelay::vSetData(const tU8 &tMaxPINAttemptsBeforeDelayParam) { 
   //init parameter
   (tVoid)memcpy(&tMaxPINAttemptsBeforeDelay,(tVoid*)&tMaxPINAttemptsBeforeDelayParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMaxPINAttemptsBeforeDelayParam' in function 'dp_tclprofileMngrMaxPINAttemptsBeforeDelay::vSetData(tU8)' could be made const reference
tU8   dp_tclprofileMngrMaxPINAttemptsBeforeDelay::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclprofileMngrMaxPINAttemptsBeforeDelay::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PROFILEMNGR, "MaxPINAttemptsBeforeDelay", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrMaxPINAttemptsBeforeDelay::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEMNGR, "MaxPINAttemptsBeforeDelay", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrMaxPINAttemptsBeforeDelay::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MaxPINAttemptsBeforeDelay", DP_U32_POOL_ID_PROFILEMNGR);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEMNGR);
   }
   else
   {
      fprintf(stdout,"Element MaxPINAttemptsBeforeDelay has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PINAuthenticationDelay"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileMngrPINAuthenticationDelay::dp_tclprofileMngrPINAuthenticationDelay(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPINAuthenticationDelay,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclprofileMngrPINAuthenticationDelay::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PINAuthenticationDelay",(tS32) 0x582fdf2e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tPINAuthenticationDelay = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclprofileMngrPINAuthenticationDelay::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PINAuthenticationDelay", (tS32)0x582fdf2e);
   (tVoid)myDpElem.bFillData((tVoid*)&tPINAuthenticationDelay, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclprofileMngrPINAuthenticationDelay::s32GetStatus() const {return _s32Status;};
tU8   dp_tclprofileMngrPINAuthenticationDelay::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclprofileMngrPINAuthenticationDelay::tGetData() {
   vUpdate();
   return tPINAuthenticationDelay;
};
tS32 dp_tclprofileMngrPINAuthenticationDelay::s32GetData(tU32& tPINAuthenticationDelayParam) { 
   vUpdate();
   tPINAuthenticationDelayParam = tPINAuthenticationDelay;
   return _s32Status;
}
tS32 dp_tclprofileMngrPINAuthenticationDelay::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PINAuthenticationDelay", (tS32)0x582fdf2e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclprofileMngrPINAuthenticationDelay::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclprofileMngrPINAuthenticationDelay::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclprofileMngrPINAuthenticationDelay::s32SetData(tU32 &tPINAuthenticationDelayParam) {
   //init parameter
   (tVoid)memcpy(&tPINAuthenticationDelay,(tVoid*)&tPINAuthenticationDelayParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPINAuthenticationDelayParam' in function 'dp_tclprofileMngrPINAuthenticationDelay::vSetData(tU32)' could be made const reference
tS32 dp_tclprofileMngrPINAuthenticationDelay::s32SetData(const tU32 &tPINAuthenticationDelayParam) {
   //init parameter
   (tVoid)memcpy(&tPINAuthenticationDelay,(tVoid*)&tPINAuthenticationDelayParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPINAuthenticationDelayParam' in function 'dp_tclprofileMngrPINAuthenticationDelay::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclprofileMngrPINAuthenticationDelay::u8GetData(tU32& tPINAuthenticationDelayParam) {  
   vUpdate();
   tPINAuthenticationDelayParam = tPINAuthenticationDelay;
   return _u8DataStatus;
}
tVoid dp_tclprofileMngrPINAuthenticationDelay::vSetData(tU32 &tPINAuthenticationDelayParam) { 
   //init parameter
   (tVoid)memcpy(&tPINAuthenticationDelay,(tVoid*)&tPINAuthenticationDelayParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tPINAuthenticationDelayParam' in function 'dp_tclprofileMngrPINAuthenticationDelay::vSetData(tU32)' could be made const reference
tVoid dp_tclprofileMngrPINAuthenticationDelay::vSetData(const tU32 &tPINAuthenticationDelayParam) { 
   //init parameter
   (tVoid)memcpy(&tPINAuthenticationDelay,(tVoid*)&tPINAuthenticationDelayParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tPINAuthenticationDelayParam' in function 'dp_tclprofileMngrPINAuthenticationDelay::vSetData(tU32)' could be made const reference
tU8   dp_tclprofileMngrPINAuthenticationDelay::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclprofileMngrPINAuthenticationDelay::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PROFILEMNGR, "PINAuthenticationDelay", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrPINAuthenticationDelay::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEMNGR, "PINAuthenticationDelay", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrPINAuthenticationDelay::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PINAuthenticationDelay", DP_U32_POOL_ID_PROFILEMNGR);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEMNGR);
   }
   else
   {
      fprintf(stdout,"Element PINAuthenticationDelay has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PinVerificationValidity"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileMngrPinVerificationValidity::dp_tclprofileMngrPinVerificationValidity(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPinVerificationValidity,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclprofileMngrPinVerificationValidity::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PinVerificationValidity",(tS32) 0x31df4734);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tPinVerificationValidity = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclprofileMngrPinVerificationValidity::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PinVerificationValidity", (tS32)0x31df4734);
   (tVoid)myDpElem.bFillData((tVoid*)&tPinVerificationValidity, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclprofileMngrPinVerificationValidity::s32GetStatus() const {return _s32Status;};
tU8   dp_tclprofileMngrPinVerificationValidity::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclprofileMngrPinVerificationValidity::tGetData() {
   vUpdate();
   return tPinVerificationValidity;
};
tS32 dp_tclprofileMngrPinVerificationValidity::s32GetData(tU32& tPinVerificationValidityParam) { 
   vUpdate();
   tPinVerificationValidityParam = tPinVerificationValidity;
   return _s32Status;
}
tS32 dp_tclprofileMngrPinVerificationValidity::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PinVerificationValidity", (tS32)0x31df4734);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclprofileMngrPinVerificationValidity::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclprofileMngrPinVerificationValidity::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclprofileMngrPinVerificationValidity::s32SetData(tU32 &tPinVerificationValidityParam) {
   //init parameter
   (tVoid)memcpy(&tPinVerificationValidity,(tVoid*)&tPinVerificationValidityParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPinVerificationValidityParam' in function 'dp_tclprofileMngrPinVerificationValidity::vSetData(tU32)' could be made const reference
tS32 dp_tclprofileMngrPinVerificationValidity::s32SetData(const tU32 &tPinVerificationValidityParam) {
   //init parameter
   (tVoid)memcpy(&tPinVerificationValidity,(tVoid*)&tPinVerificationValidityParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPinVerificationValidityParam' in function 'dp_tclprofileMngrPinVerificationValidity::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclprofileMngrPinVerificationValidity::u8GetData(tU32& tPinVerificationValidityParam) {  
   vUpdate();
   tPinVerificationValidityParam = tPinVerificationValidity;
   return _u8DataStatus;
}
tVoid dp_tclprofileMngrPinVerificationValidity::vSetData(tU32 &tPinVerificationValidityParam) { 
   //init parameter
   (tVoid)memcpy(&tPinVerificationValidity,(tVoid*)&tPinVerificationValidityParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tPinVerificationValidityParam' in function 'dp_tclprofileMngrPinVerificationValidity::vSetData(tU32)' could be made const reference
tVoid dp_tclprofileMngrPinVerificationValidity::vSetData(const tU32 &tPinVerificationValidityParam) { 
   //init parameter
   (tVoid)memcpy(&tPinVerificationValidity,(tVoid*)&tPinVerificationValidityParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tPinVerificationValidityParam' in function 'dp_tclprofileMngrPinVerificationValidity::vSetData(tU32)' could be made const reference
tU8   dp_tclprofileMngrPinVerificationValidity::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclprofileMngrPinVerificationValidity::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PROFILEMNGR, "PinVerificationValidity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrPinVerificationValidity::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEMNGR, "PinVerificationValidity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrPinVerificationValidity::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PinVerificationValidity", DP_U32_POOL_ID_PROFILEMNGR);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEMNGR);
   }
   else
   {
      fprintf(stdout,"Element PinVerificationValidity has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AuthenticationValidTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileMngrAuthenticationValidTime::dp_tclprofileMngrAuthenticationValidTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAuthenticationValidTime,0,sizeof(uint32_t));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclprofileMngrAuthenticationValidTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AuthenticationValidTime",(tS32) 0x675a0beb);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(uint32_t)) 
      {
         tAuthenticationValidTime = *((uint32_t*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclprofileMngrAuthenticationValidTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AuthenticationValidTime", (tS32)0x675a0beb);
   (tVoid)myDpElem.bFillData((tVoid*)&tAuthenticationValidTime, (tU32)sizeof(uint32_t));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclprofileMngrAuthenticationValidTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclprofileMngrAuthenticationValidTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
uint32_t dp_tclprofileMngrAuthenticationValidTime::tGetData() {
   vUpdate();
   return tAuthenticationValidTime;
};
tS32 dp_tclprofileMngrAuthenticationValidTime::s32GetData(uint32_t& tAuthenticationValidTimeParam) { 
   vUpdate();
   tAuthenticationValidTimeParam = tAuthenticationValidTime;
   return _s32Status;
}
tS32 dp_tclprofileMngrAuthenticationValidTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AuthenticationValidTime", (tS32)0x675a0beb);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclprofileMngrAuthenticationValidTime::operator>>(uint32_t& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclprofileMngrAuthenticationValidTime::operator<<(uint32_t oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclprofileMngrAuthenticationValidTime::s32SetData(uint32_t &tAuthenticationValidTimeParam) {
   //init parameter
   (tVoid)memcpy(&tAuthenticationValidTime,(tVoid*)&tAuthenticationValidTimeParam, sizeof(uint32_t));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAuthenticationValidTimeParam' in function 'dp_tclprofileMngrAuthenticationValidTime::vSetData(uint32_t)' could be made const reference
tS32 dp_tclprofileMngrAuthenticationValidTime::s32SetData(const uint32_t &tAuthenticationValidTimeParam) {
   //init parameter
   (tVoid)memcpy(&tAuthenticationValidTime,(tVoid*)&tAuthenticationValidTimeParam, sizeof(uint32_t));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAuthenticationValidTimeParam' in function 'dp_tclprofileMngrAuthenticationValidTime::vSetData(uint32_t)' could be made const reference
// do not use --> old interface
tU8 dp_tclprofileMngrAuthenticationValidTime::u8GetData(uint32_t& tAuthenticationValidTimeParam) {  
   vUpdate();
   tAuthenticationValidTimeParam = tAuthenticationValidTime;
   return _u8DataStatus;
}
tVoid dp_tclprofileMngrAuthenticationValidTime::vSetData(uint32_t &tAuthenticationValidTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tAuthenticationValidTime,(tVoid*)&tAuthenticationValidTimeParam, sizeof(uint32_t));
   vStore();
}//lint !e1746: parameter 'tAuthenticationValidTimeParam' in function 'dp_tclprofileMngrAuthenticationValidTime::vSetData(uint32_t)' could be made const reference
tVoid dp_tclprofileMngrAuthenticationValidTime::vSetData(const uint32_t &tAuthenticationValidTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tAuthenticationValidTime,(tVoid*)&tAuthenticationValidTimeParam, sizeof(uint32_t));
   vStore();
}//lint !e1746: parameter 'tAuthenticationValidTimeParam' in function 'dp_tclprofileMngrAuthenticationValidTime::vSetData(uint32_t)' could be made const reference
tU8   dp_tclprofileMngrAuthenticationValidTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclprofileMngrAuthenticationValidTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PROFILEMNGR, "AuthenticationValidTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrAuthenticationValidTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEMNGR, "AuthenticationValidTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrAuthenticationValidTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AuthenticationValidTime", DP_U32_POOL_ID_PROFILEMNGR);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEMNGR);
   }
   else
   {
      fprintf(stdout,"Element AuthenticationValidTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "profileOperation"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileMngrprofileOperation::dp_tclprofileMngrprofileOperation(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tprofileOperation,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclprofileMngrprofileOperation::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("profileOperation",(tS32) 0xa712be72);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tprofileOperation = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclprofileMngrprofileOperation::vStore(tVoid) {
   dp_tclBaseElement myDpElem("profileOperation", (tS32)0xa712be72);
   (tVoid)myDpElem.bFillData((tVoid*)&tprofileOperation, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclprofileMngrprofileOperation::s32GetStatus() const {return _s32Status;};
tU8   dp_tclprofileMngrprofileOperation::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclprofileMngrprofileOperation::tGetData() {
   vUpdate();
   return tprofileOperation;
};
tS32 dp_tclprofileMngrprofileOperation::s32GetData(tU32& tprofileOperationParam) { 
   vUpdate();
   tprofileOperationParam = tprofileOperation;
   return _s32Status;
}
tS32 dp_tclprofileMngrprofileOperation::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("profileOperation", (tS32)0xa712be72);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclprofileMngrprofileOperation::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclprofileMngrprofileOperation::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclprofileMngrprofileOperation::s32SetData(tU32 &tprofileOperationParam) {
   //init parameter
   (tVoid)memcpy(&tprofileOperation,(tVoid*)&tprofileOperationParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tprofileOperationParam' in function 'dp_tclprofileMngrprofileOperation::vSetData(tU32)' could be made const reference
tS32 dp_tclprofileMngrprofileOperation::s32SetData(const tU32 &tprofileOperationParam) {
   //init parameter
   (tVoid)memcpy(&tprofileOperation,(tVoid*)&tprofileOperationParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tprofileOperationParam' in function 'dp_tclprofileMngrprofileOperation::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclprofileMngrprofileOperation::u8GetData(tU32& tprofileOperationParam) {  
   vUpdate();
   tprofileOperationParam = tprofileOperation;
   return _u8DataStatus;
}
tVoid dp_tclprofileMngrprofileOperation::vSetData(tU32 &tprofileOperationParam) { 
   //init parameter
   (tVoid)memcpy(&tprofileOperation,(tVoid*)&tprofileOperationParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tprofileOperationParam' in function 'dp_tclprofileMngrprofileOperation::vSetData(tU32)' could be made const reference
tVoid dp_tclprofileMngrprofileOperation::vSetData(const tU32 &tprofileOperationParam) { 
   //init parameter
   (tVoid)memcpy(&tprofileOperation,(tVoid*)&tprofileOperationParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tprofileOperationParam' in function 'dp_tclprofileMngrprofileOperation::vSetData(tU32)' could be made const reference
tU8   dp_tclprofileMngrprofileOperation::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclprofileMngrprofileOperation::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PROFILEMNGR, "profileOperation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrprofileOperation::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEMNGR, "profileOperation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrprofileOperation::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: profileOperation", DP_U32_POOL_ID_PROFILEMNGR);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEMNGR);
   }
   else
   {
      fprintf(stdout,"Element profileOperation has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ValetModeStatus"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileMngrValetModeStatus::dp_tclprofileMngrValetModeStatus(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tValetModeStatus,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclprofileMngrValetModeStatus::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ValetModeStatus",(tS32) 0x61807bcd);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tValetModeStatus = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclprofileMngrValetModeStatus::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ValetModeStatus", (tS32)0x61807bcd);
   (tVoid)myDpElem.bFillData((tVoid*)&tValetModeStatus, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclprofileMngrValetModeStatus::s32GetStatus() const {return _s32Status;};
tU8   dp_tclprofileMngrValetModeStatus::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclprofileMngrValetModeStatus::tGetData() {
   vUpdate();
   return tValetModeStatus;
};
tS32 dp_tclprofileMngrValetModeStatus::s32GetData(tBool& tValetModeStatusParam) { 
   vUpdate();
   tValetModeStatusParam = tValetModeStatus;
   return _s32Status;
}
tS32 dp_tclprofileMngrValetModeStatus::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ValetModeStatus", (tS32)0x61807bcd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclprofileMngrValetModeStatus::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclprofileMngrValetModeStatus::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclprofileMngrValetModeStatus::s32SetData(tBool &tValetModeStatusParam) {
   //init parameter
   (tVoid)memcpy(&tValetModeStatus,(tVoid*)&tValetModeStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tValetModeStatusParam' in function 'dp_tclprofileMngrValetModeStatus::vSetData(tBool)' could be made const reference
tS32 dp_tclprofileMngrValetModeStatus::s32SetData(const tBool &tValetModeStatusParam) {
   //init parameter
   (tVoid)memcpy(&tValetModeStatus,(tVoid*)&tValetModeStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tValetModeStatusParam' in function 'dp_tclprofileMngrValetModeStatus::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclprofileMngrValetModeStatus::u8GetData(tBool& tValetModeStatusParam) {  
   vUpdate();
   tValetModeStatusParam = tValetModeStatus;
   return _u8DataStatus;
}
tVoid dp_tclprofileMngrValetModeStatus::vSetData(tBool &tValetModeStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tValetModeStatus,(tVoid*)&tValetModeStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tValetModeStatusParam' in function 'dp_tclprofileMngrValetModeStatus::vSetData(tBool)' could be made const reference
tVoid dp_tclprofileMngrValetModeStatus::vSetData(const tBool &tValetModeStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tValetModeStatus,(tVoid*)&tValetModeStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tValetModeStatusParam' in function 'dp_tclprofileMngrValetModeStatus::vSetData(tBool)' could be made const reference
tU8   dp_tclprofileMngrValetModeStatus::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclprofileMngrValetModeStatus::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PROFILEMNGR, "ValetModeStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrValetModeStatus::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEMNGR, "ValetModeStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrValetModeStatus::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ValetModeStatus", DP_U32_POOL_ID_PROFILEMNGR);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEMNGR);
   }
   else
   {
      fprintf(stdout,"Element ValetModeStatus has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LastActiveUser"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileMngrLastActiveUser::dp_tclprofileMngrLastActiveUser(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLastActiveUser,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclprofileMngrLastActiveUser::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LastActiveUser",(tS32) 0xba03daef);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tLastActiveUser = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclprofileMngrLastActiveUser::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LastActiveUser", (tS32)0xba03daef);
   (tVoid)myDpElem.bFillData((tVoid*)&tLastActiveUser, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclprofileMngrLastActiveUser::s32GetStatus() const {return _s32Status;};
tU8   dp_tclprofileMngrLastActiveUser::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclprofileMngrLastActiveUser::tGetData() {
   vUpdate();
   return tLastActiveUser;
};
tS32 dp_tclprofileMngrLastActiveUser::s32GetData(tU8& tLastActiveUserParam) { 
   vUpdate();
   tLastActiveUserParam = tLastActiveUser;
   return _s32Status;
}
tS32 dp_tclprofileMngrLastActiveUser::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LastActiveUser", (tS32)0xba03daef);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclprofileMngrLastActiveUser::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclprofileMngrLastActiveUser::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclprofileMngrLastActiveUser::s32SetData(tU8 &tLastActiveUserParam) {
   //init parameter
   (tVoid)memcpy(&tLastActiveUser,(tVoid*)&tLastActiveUserParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLastActiveUserParam' in function 'dp_tclprofileMngrLastActiveUser::vSetData(tU8)' could be made const reference
tS32 dp_tclprofileMngrLastActiveUser::s32SetData(const tU8 &tLastActiveUserParam) {
   //init parameter
   (tVoid)memcpy(&tLastActiveUser,(tVoid*)&tLastActiveUserParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLastActiveUserParam' in function 'dp_tclprofileMngrLastActiveUser::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclprofileMngrLastActiveUser::u8GetData(tU8& tLastActiveUserParam) {  
   vUpdate();
   tLastActiveUserParam = tLastActiveUser;
   return _u8DataStatus;
}
tVoid dp_tclprofileMngrLastActiveUser::vSetData(tU8 &tLastActiveUserParam) { 
   //init parameter
   (tVoid)memcpy(&tLastActiveUser,(tVoid*)&tLastActiveUserParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLastActiveUserParam' in function 'dp_tclprofileMngrLastActiveUser::vSetData(tU8)' could be made const reference
tVoid dp_tclprofileMngrLastActiveUser::vSetData(const tU8 &tLastActiveUserParam) { 
   //init parameter
   (tVoid)memcpy(&tLastActiveUser,(tVoid*)&tLastActiveUserParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLastActiveUserParam' in function 'dp_tclprofileMngrLastActiveUser::vSetData(tU8)' could be made const reference
tU8   dp_tclprofileMngrLastActiveUser::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclprofileMngrLastActiveUser::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PROFILEMNGR, "LastActiveUser", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrLastActiveUser::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEMNGR, "LastActiveUser", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrLastActiveUser::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LastActiveUser", DP_U32_POOL_ID_PROFILEMNGR);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEMNGR);
   }
   else
   {
      fprintf(stdout,"Element LastActiveUser has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "logoffTimestamp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclprofileMngrlogoffTimestamp::dp_tclprofileMngrlogoffTimestamp(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tlogoffTimestamp,0,sizeof(uint64_t));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclprofileMngrlogoffTimestamp::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("logoffTimestamp",(tS32) 0x6e334e3d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(uint64_t)) 
      {
         tlogoffTimestamp = *((uint64_t*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclprofileMngrlogoffTimestamp::vStore(tVoid) {
   dp_tclBaseElement myDpElem("logoffTimestamp", (tS32)0x6e334e3d);
   (tVoid)myDpElem.bFillData((tVoid*)&tlogoffTimestamp, (tU32)sizeof(uint64_t));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclprofileMngrlogoffTimestamp::s32GetStatus() const {return _s32Status;};
tU8   dp_tclprofileMngrlogoffTimestamp::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
uint64_t dp_tclprofileMngrlogoffTimestamp::tGetData() {
   vUpdate();
   return tlogoffTimestamp;
};
tS32 dp_tclprofileMngrlogoffTimestamp::s32GetData(uint64_t& tlogoffTimestampParam) { 
   vUpdate();
   tlogoffTimestampParam = tlogoffTimestamp;
   return _s32Status;
}
tS32 dp_tclprofileMngrlogoffTimestamp::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("logoffTimestamp", (tS32)0x6e334e3d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PROFILEMNGR, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclprofileMngrlogoffTimestamp::operator>>(uint64_t& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclprofileMngrlogoffTimestamp::operator<<(uint64_t oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclprofileMngrlogoffTimestamp::s32SetData(uint64_t &tlogoffTimestampParam) {
   //init parameter
   (tVoid)memcpy(&tlogoffTimestamp,(tVoid*)&tlogoffTimestampParam, sizeof(uint64_t));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tlogoffTimestampParam' in function 'dp_tclprofileMngrlogoffTimestamp::vSetData(uint64_t)' could be made const reference
tS32 dp_tclprofileMngrlogoffTimestamp::s32SetData(const uint64_t &tlogoffTimestampParam) {
   //init parameter
   (tVoid)memcpy(&tlogoffTimestamp,(tVoid*)&tlogoffTimestampParam, sizeof(uint64_t));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tlogoffTimestampParam' in function 'dp_tclprofileMngrlogoffTimestamp::vSetData(uint64_t)' could be made const reference
// do not use --> old interface
tU8 dp_tclprofileMngrlogoffTimestamp::u8GetData(uint64_t& tlogoffTimestampParam) {  
   vUpdate();
   tlogoffTimestampParam = tlogoffTimestamp;
   return _u8DataStatus;
}
tVoid dp_tclprofileMngrlogoffTimestamp::vSetData(uint64_t &tlogoffTimestampParam) { 
   //init parameter
   (tVoid)memcpy(&tlogoffTimestamp,(tVoid*)&tlogoffTimestampParam, sizeof(uint64_t));
   vStore();
}//lint !e1746: parameter 'tlogoffTimestampParam' in function 'dp_tclprofileMngrlogoffTimestamp::vSetData(uint64_t)' could be made const reference
tVoid dp_tclprofileMngrlogoffTimestamp::vSetData(const uint64_t &tlogoffTimestampParam) { 
   //init parameter
   (tVoid)memcpy(&tlogoffTimestamp,(tVoid*)&tlogoffTimestampParam, sizeof(uint64_t));
   vStore();
}//lint !e1746: parameter 'tlogoffTimestampParam' in function 'dp_tclprofileMngrlogoffTimestamp::vSetData(uint64_t)' could be made const reference
tU8   dp_tclprofileMngrlogoffTimestamp::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclprofileMngrlogoffTimestamp::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PROFILEMNGR, "logoffTimestamp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrlogoffTimestamp::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PROFILEMNGR, "logoffTimestamp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclprofileMngrlogoffTimestamp::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: logoffTimestamp", DP_U32_POOL_ID_PROFILEMNGR);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PROFILEMNGR);
   }
   else
   {
      fprintf(stdout,"Element logoffTimestamp has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
