
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclFCUsbTcuDp.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AutoDownloadInterval"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpAutoDownloadInterval::dp_tclFCUsbTcuDpAutoDownloadInterval(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAutoDownloadInterval,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCUsbTcuDpAutoDownloadInterval::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AutoDownloadInterval",(tS32) 0xa1e69f52);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAutoDownloadInterval = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCUsbTcuDpAutoDownloadInterval::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AutoDownloadInterval", (tS32)0xa1e69f52);
   (tVoid)myDpElem.bFillData((tVoid*)&tAutoDownloadInterval, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCUsbTcuDpAutoDownloadInterval::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCUsbTcuDpAutoDownloadInterval::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCUsbTcuDpAutoDownloadInterval::tGetData() {
   vUpdate();
   return tAutoDownloadInterval;
};
tS32 dp_tclFCUsbTcuDpAutoDownloadInterval::s32GetData(tU8& tAutoDownloadIntervalParam) { 
   vUpdate();
   tAutoDownloadIntervalParam = tAutoDownloadInterval;
   return _s32Status;
}
tS32 dp_tclFCUsbTcuDpAutoDownloadInterval::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AutoDownloadInterval", (tS32)0xa1e69f52);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCUsbTcuDpAutoDownloadInterval::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCUsbTcuDpAutoDownloadInterval::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCUsbTcuDpAutoDownloadInterval::s32SetData(tU8 &tAutoDownloadIntervalParam) {
   //init parameter
   (tVoid)memcpy(&tAutoDownloadInterval,(tVoid*)&tAutoDownloadIntervalParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAutoDownloadIntervalParam' in function 'dp_tclFCUsbTcuDpAutoDownloadInterval::vSetData(tU8)' could be made const reference
tS32 dp_tclFCUsbTcuDpAutoDownloadInterval::s32SetData(const tU8 &tAutoDownloadIntervalParam) {
   //init parameter
   (tVoid)memcpy(&tAutoDownloadInterval,(tVoid*)&tAutoDownloadIntervalParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAutoDownloadIntervalParam' in function 'dp_tclFCUsbTcuDpAutoDownloadInterval::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCUsbTcuDpAutoDownloadInterval::u8GetData(tU8& tAutoDownloadIntervalParam) {  
   vUpdate();
   tAutoDownloadIntervalParam = tAutoDownloadInterval;
   return _u8DataStatus;
}
tVoid dp_tclFCUsbTcuDpAutoDownloadInterval::vSetData(tU8 &tAutoDownloadIntervalParam) { 
   //init parameter
   (tVoid)memcpy(&tAutoDownloadInterval,(tVoid*)&tAutoDownloadIntervalParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAutoDownloadIntervalParam' in function 'dp_tclFCUsbTcuDpAutoDownloadInterval::vSetData(tU8)' could be made const reference
tVoid dp_tclFCUsbTcuDpAutoDownloadInterval::vSetData(const tU8 &tAutoDownloadIntervalParam) { 
   //init parameter
   (tVoid)memcpy(&tAutoDownloadInterval,(tVoid*)&tAutoDownloadIntervalParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAutoDownloadIntervalParam' in function 'dp_tclFCUsbTcuDpAutoDownloadInterval::vSetData(tU8)' could be made const reference
tU8   dp_tclFCUsbTcuDpAutoDownloadInterval::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCUsbTcuDpAutoDownloadInterval::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "AutoDownloadInterval", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpAutoDownloadInterval::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "AutoDownloadInterval", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpAutoDownloadInterval::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AutoDownloadInterval", DP_U32_POOL_ID_FCUSBTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
   }
   else
   {
      fprintf(stdout,"Element AutoDownloadInterval has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AuthenticationResult"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpAuthenticationResult::dp_tclFCUsbTcuDpAuthenticationResult(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAuthenticationResult,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCUsbTcuDpAuthenticationResult::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AuthenticationResult",(tS32) 0xbd3e06c3);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAuthenticationResult = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCUsbTcuDpAuthenticationResult::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AuthenticationResult", (tS32)0xbd3e06c3);
   (tVoid)myDpElem.bFillData((tVoid*)&tAuthenticationResult, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCUsbTcuDpAuthenticationResult::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCUsbTcuDpAuthenticationResult::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCUsbTcuDpAuthenticationResult::tGetData() {
   vUpdate();
   return tAuthenticationResult;
};
tS32 dp_tclFCUsbTcuDpAuthenticationResult::s32GetData(tU8& tAuthenticationResultParam) { 
   vUpdate();
   tAuthenticationResultParam = tAuthenticationResult;
   return _s32Status;
}
tS32 dp_tclFCUsbTcuDpAuthenticationResult::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AuthenticationResult", (tS32)0xbd3e06c3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCUsbTcuDpAuthenticationResult::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCUsbTcuDpAuthenticationResult::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCUsbTcuDpAuthenticationResult::s32SetData(tU8 &tAuthenticationResultParam) {
   //init parameter
   (tVoid)memcpy(&tAuthenticationResult,(tVoid*)&tAuthenticationResultParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAuthenticationResultParam' in function 'dp_tclFCUsbTcuDpAuthenticationResult::vSetData(tU8)' could be made const reference
tS32 dp_tclFCUsbTcuDpAuthenticationResult::s32SetData(const tU8 &tAuthenticationResultParam) {
   //init parameter
   (tVoid)memcpy(&tAuthenticationResult,(tVoid*)&tAuthenticationResultParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAuthenticationResultParam' in function 'dp_tclFCUsbTcuDpAuthenticationResult::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCUsbTcuDpAuthenticationResult::u8GetData(tU8& tAuthenticationResultParam) {  
   vUpdate();
   tAuthenticationResultParam = tAuthenticationResult;
   return _u8DataStatus;
}
tVoid dp_tclFCUsbTcuDpAuthenticationResult::vSetData(tU8 &tAuthenticationResultParam) { 
   //init parameter
   (tVoid)memcpy(&tAuthenticationResult,(tVoid*)&tAuthenticationResultParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAuthenticationResultParam' in function 'dp_tclFCUsbTcuDpAuthenticationResult::vSetData(tU8)' could be made const reference
tVoid dp_tclFCUsbTcuDpAuthenticationResult::vSetData(const tU8 &tAuthenticationResultParam) { 
   //init parameter
   (tVoid)memcpy(&tAuthenticationResult,(tVoid*)&tAuthenticationResultParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAuthenticationResultParam' in function 'dp_tclFCUsbTcuDpAuthenticationResult::vSetData(tU8)' could be made const reference
tU8   dp_tclFCUsbTcuDpAuthenticationResult::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCUsbTcuDpAuthenticationResult::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "AuthenticationResult", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpAuthenticationResult::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "AuthenticationResult", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpAuthenticationResult::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AuthenticationResult", DP_U32_POOL_ID_FCUSBTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
   }
   else
   {
      fprintf(stdout,"Element AuthenticationResult has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MonthlyProbeData"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpMonthlyProbeData::dp_tclFCUsbTcuDpMonthlyProbeData(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMonthlyProbeData,0,sizeof(TDPMonthlyProbeData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCUsbTcuDpMonthlyProbeData::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MonthlyProbeData",(tS32) 0x35796d2d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TDPMonthlyProbeData)) 
      {
         tMonthlyProbeData = *((TDPMonthlyProbeData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCUsbTcuDpMonthlyProbeData::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MonthlyProbeData", (tS32)0x35796d2d);
   (tVoid)myDpElem.bFillData((tVoid*)&tMonthlyProbeData, (tU32)sizeof(TDPMonthlyProbeData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCUsbTcuDpMonthlyProbeData::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCUsbTcuDpMonthlyProbeData::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TDPMonthlyProbeData dp_tclFCUsbTcuDpMonthlyProbeData::tGetData() {
   vUpdate();
   return tMonthlyProbeData;
};
tS32 dp_tclFCUsbTcuDpMonthlyProbeData::s32GetData(TDPMonthlyProbeData& tMonthlyProbeDataParam) { 
   vUpdate();
   tMonthlyProbeDataParam = tMonthlyProbeData;
   return _s32Status;
}
tS32 dp_tclFCUsbTcuDpMonthlyProbeData::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MonthlyProbeData", (tS32)0x35796d2d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCUsbTcuDpMonthlyProbeData::operator>>(TDPMonthlyProbeData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCUsbTcuDpMonthlyProbeData::operator<<(TDPMonthlyProbeData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCUsbTcuDpMonthlyProbeData::s32SetData(TDPMonthlyProbeData &tMonthlyProbeDataParam) {
   //init parameter
   (tVoid)memcpy(&tMonthlyProbeData,(tVoid*)&tMonthlyProbeDataParam, sizeof(TDPMonthlyProbeData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMonthlyProbeDataParam' in function 'dp_tclFCUsbTcuDpMonthlyProbeData::vSetData(TDPMonthlyProbeData)' could be made const reference
tS32 dp_tclFCUsbTcuDpMonthlyProbeData::s32SetData(const TDPMonthlyProbeData &tMonthlyProbeDataParam) {
   //init parameter
   (tVoid)memcpy(&tMonthlyProbeData,(tVoid*)&tMonthlyProbeDataParam, sizeof(TDPMonthlyProbeData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMonthlyProbeDataParam' in function 'dp_tclFCUsbTcuDpMonthlyProbeData::vSetData(TDPMonthlyProbeData)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCUsbTcuDpMonthlyProbeData::u8GetData(TDPMonthlyProbeData& tMonthlyProbeDataParam) {  
   vUpdate();
   tMonthlyProbeDataParam = tMonthlyProbeData;
   return _u8DataStatus;
}
tVoid dp_tclFCUsbTcuDpMonthlyProbeData::vSetData(TDPMonthlyProbeData &tMonthlyProbeDataParam) { 
   //init parameter
   (tVoid)memcpy(&tMonthlyProbeData,(tVoid*)&tMonthlyProbeDataParam, sizeof(TDPMonthlyProbeData));
   vStore();
}//lint !e1746: parameter 'tMonthlyProbeDataParam' in function 'dp_tclFCUsbTcuDpMonthlyProbeData::vSetData(TDPMonthlyProbeData)' could be made const reference
tVoid dp_tclFCUsbTcuDpMonthlyProbeData::vSetData(const TDPMonthlyProbeData &tMonthlyProbeDataParam) { 
   //init parameter
   (tVoid)memcpy(&tMonthlyProbeData,(tVoid*)&tMonthlyProbeDataParam, sizeof(TDPMonthlyProbeData));
   vStore();
}//lint !e1746: parameter 'tMonthlyProbeDataParam' in function 'dp_tclFCUsbTcuDpMonthlyProbeData::vSetData(TDPMonthlyProbeData)' could be made const reference
tU8   dp_tclFCUsbTcuDpMonthlyProbeData::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCUsbTcuDpMonthlyProbeData::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "MonthlyProbeData", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpMonthlyProbeData::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "MonthlyProbeData", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpMonthlyProbeData::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MonthlyProbeData", DP_U32_POOL_ID_FCUSBTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
   }
   else
   {
      fprintf(stdout,"Element MonthlyProbeData has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LifeTimeProbeData"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpLifeTimeProbeData::dp_tclFCUsbTcuDpLifeTimeProbeData(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLifeTimeProbeData,0,sizeof(TDPLifeTimeProbeData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCUsbTcuDpLifeTimeProbeData::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LifeTimeProbeData",(tS32) 0xfa30049);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TDPLifeTimeProbeData)) 
      {
         tLifeTimeProbeData = *((TDPLifeTimeProbeData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCUsbTcuDpLifeTimeProbeData::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LifeTimeProbeData", (tS32)0xfa30049);
   (tVoid)myDpElem.bFillData((tVoid*)&tLifeTimeProbeData, (tU32)sizeof(TDPLifeTimeProbeData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCUsbTcuDpLifeTimeProbeData::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCUsbTcuDpLifeTimeProbeData::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TDPLifeTimeProbeData dp_tclFCUsbTcuDpLifeTimeProbeData::tGetData() {
   vUpdate();
   return tLifeTimeProbeData;
};
tS32 dp_tclFCUsbTcuDpLifeTimeProbeData::s32GetData(TDPLifeTimeProbeData& tLifeTimeProbeDataParam) { 
   vUpdate();
   tLifeTimeProbeDataParam = tLifeTimeProbeData;
   return _s32Status;
}
tS32 dp_tclFCUsbTcuDpLifeTimeProbeData::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LifeTimeProbeData", (tS32)0xfa30049);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCUsbTcuDpLifeTimeProbeData::operator>>(TDPLifeTimeProbeData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCUsbTcuDpLifeTimeProbeData::operator<<(TDPLifeTimeProbeData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCUsbTcuDpLifeTimeProbeData::s32SetData(TDPLifeTimeProbeData &tLifeTimeProbeDataParam) {
   //init parameter
   (tVoid)memcpy(&tLifeTimeProbeData,(tVoid*)&tLifeTimeProbeDataParam, sizeof(TDPLifeTimeProbeData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLifeTimeProbeDataParam' in function 'dp_tclFCUsbTcuDpLifeTimeProbeData::vSetData(TDPLifeTimeProbeData)' could be made const reference
tS32 dp_tclFCUsbTcuDpLifeTimeProbeData::s32SetData(const TDPLifeTimeProbeData &tLifeTimeProbeDataParam) {
   //init parameter
   (tVoid)memcpy(&tLifeTimeProbeData,(tVoid*)&tLifeTimeProbeDataParam, sizeof(TDPLifeTimeProbeData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLifeTimeProbeDataParam' in function 'dp_tclFCUsbTcuDpLifeTimeProbeData::vSetData(TDPLifeTimeProbeData)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCUsbTcuDpLifeTimeProbeData::u8GetData(TDPLifeTimeProbeData& tLifeTimeProbeDataParam) {  
   vUpdate();
   tLifeTimeProbeDataParam = tLifeTimeProbeData;
   return _u8DataStatus;
}
tVoid dp_tclFCUsbTcuDpLifeTimeProbeData::vSetData(TDPLifeTimeProbeData &tLifeTimeProbeDataParam) { 
   //init parameter
   (tVoid)memcpy(&tLifeTimeProbeData,(tVoid*)&tLifeTimeProbeDataParam, sizeof(TDPLifeTimeProbeData));
   vStore();
}//lint !e1746: parameter 'tLifeTimeProbeDataParam' in function 'dp_tclFCUsbTcuDpLifeTimeProbeData::vSetData(TDPLifeTimeProbeData)' could be made const reference
tVoid dp_tclFCUsbTcuDpLifeTimeProbeData::vSetData(const TDPLifeTimeProbeData &tLifeTimeProbeDataParam) { 
   //init parameter
   (tVoid)memcpy(&tLifeTimeProbeData,(tVoid*)&tLifeTimeProbeDataParam, sizeof(TDPLifeTimeProbeData));
   vStore();
}//lint !e1746: parameter 'tLifeTimeProbeDataParam' in function 'dp_tclFCUsbTcuDpLifeTimeProbeData::vSetData(TDPLifeTimeProbeData)' could be made const reference
tU8   dp_tclFCUsbTcuDpLifeTimeProbeData::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCUsbTcuDpLifeTimeProbeData::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "LifeTimeProbeData", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpLifeTimeProbeData::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "LifeTimeProbeData", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpLifeTimeProbeData::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LifeTimeProbeData", DP_U32_POOL_ID_FCUSBTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
   }
   else
   {
      fprintf(stdout,"Element LifeTimeProbeData has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TripProbeData"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpTripProbeData::dp_tclFCUsbTcuDpTripProbeData(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTripProbeData,0,sizeof(TDPTripData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCUsbTcuDpTripProbeData::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TripProbeData",(tS32) 0x5ed218c1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TDPTripData)) 
      {
         tTripProbeData = *((TDPTripData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCUsbTcuDpTripProbeData::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TripProbeData", (tS32)0x5ed218c1);
   (tVoid)myDpElem.bFillData((tVoid*)&tTripProbeData, (tU32)sizeof(TDPTripData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCUsbTcuDpTripProbeData::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCUsbTcuDpTripProbeData::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TDPTripData dp_tclFCUsbTcuDpTripProbeData::tGetData() {
   vUpdate();
   return tTripProbeData;
};
tS32 dp_tclFCUsbTcuDpTripProbeData::s32GetData(TDPTripData& tTripProbeDataParam) { 
   vUpdate();
   tTripProbeDataParam = tTripProbeData;
   return _s32Status;
}
tS32 dp_tclFCUsbTcuDpTripProbeData::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TripProbeData", (tS32)0x5ed218c1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCUsbTcuDpTripProbeData::operator>>(TDPTripData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCUsbTcuDpTripProbeData::operator<<(TDPTripData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCUsbTcuDpTripProbeData::s32SetData(TDPTripData &tTripProbeDataParam) {
   //init parameter
   (tVoid)memcpy(&tTripProbeData,(tVoid*)&tTripProbeDataParam, sizeof(TDPTripData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTripProbeDataParam' in function 'dp_tclFCUsbTcuDpTripProbeData::vSetData(TDPTripData)' could be made const reference
tS32 dp_tclFCUsbTcuDpTripProbeData::s32SetData(const TDPTripData &tTripProbeDataParam) {
   //init parameter
   (tVoid)memcpy(&tTripProbeData,(tVoid*)&tTripProbeDataParam, sizeof(TDPTripData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTripProbeDataParam' in function 'dp_tclFCUsbTcuDpTripProbeData::vSetData(TDPTripData)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCUsbTcuDpTripProbeData::u8GetData(TDPTripData& tTripProbeDataParam) {  
   vUpdate();
   tTripProbeDataParam = tTripProbeData;
   return _u8DataStatus;
}
tVoid dp_tclFCUsbTcuDpTripProbeData::vSetData(TDPTripData &tTripProbeDataParam) { 
   //init parameter
   (tVoid)memcpy(&tTripProbeData,(tVoid*)&tTripProbeDataParam, sizeof(TDPTripData));
   vStore();
}//lint !e1746: parameter 'tTripProbeDataParam' in function 'dp_tclFCUsbTcuDpTripProbeData::vSetData(TDPTripData)' could be made const reference
tVoid dp_tclFCUsbTcuDpTripProbeData::vSetData(const TDPTripData &tTripProbeDataParam) { 
   //init parameter
   (tVoid)memcpy(&tTripProbeData,(tVoid*)&tTripProbeDataParam, sizeof(TDPTripData));
   vStore();
}//lint !e1746: parameter 'tTripProbeDataParam' in function 'dp_tclFCUsbTcuDpTripProbeData::vSetData(TDPTripData)' could be made const reference
tU8   dp_tclFCUsbTcuDpTripProbeData::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCUsbTcuDpTripProbeData::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "TripProbeData", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpTripProbeData::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "TripProbeData", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpTripProbeData::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TripProbeData", DP_U32_POOL_ID_FCUSBTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
   }
   else
   {
      fprintf(stdout,"Element TripProbeData has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FirstStarup"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpFirstStarup::dp_tclFCUsbTcuDpFirstStarup(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFirstStarup,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCUsbTcuDpFirstStarup::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("FirstStarup",(tS32) 0x3849999b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tFirstStarup = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCUsbTcuDpFirstStarup::vStore(tVoid) {
   dp_tclBaseElement myDpElem("FirstStarup", (tS32)0x3849999b);
   (tVoid)myDpElem.bFillData((tVoid*)&tFirstStarup, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCUsbTcuDpFirstStarup::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCUsbTcuDpFirstStarup::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclFCUsbTcuDpFirstStarup::tGetData() {
   vUpdate();
   return tFirstStarup;
};
tS32 dp_tclFCUsbTcuDpFirstStarup::s32GetData(tBool& tFirstStarupParam) { 
   vUpdate();
   tFirstStarupParam = tFirstStarup;
   return _s32Status;
}
tS32 dp_tclFCUsbTcuDpFirstStarup::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("FirstStarup", (tS32)0x3849999b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCUsbTcuDpFirstStarup::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCUsbTcuDpFirstStarup::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCUsbTcuDpFirstStarup::s32SetData(tBool &tFirstStarupParam) {
   //init parameter
   (tVoid)memcpy(&tFirstStarup,(tVoid*)&tFirstStarupParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFirstStarupParam' in function 'dp_tclFCUsbTcuDpFirstStarup::vSetData(tBool)' could be made const reference
tS32 dp_tclFCUsbTcuDpFirstStarup::s32SetData(const tBool &tFirstStarupParam) {
   //init parameter
   (tVoid)memcpy(&tFirstStarup,(tVoid*)&tFirstStarupParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFirstStarupParam' in function 'dp_tclFCUsbTcuDpFirstStarup::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCUsbTcuDpFirstStarup::u8GetData(tBool& tFirstStarupParam) {  
   vUpdate();
   tFirstStarupParam = tFirstStarup;
   return _u8DataStatus;
}
tVoid dp_tclFCUsbTcuDpFirstStarup::vSetData(tBool &tFirstStarupParam) { 
   //init parameter
   (tVoid)memcpy(&tFirstStarup,(tVoid*)&tFirstStarupParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tFirstStarupParam' in function 'dp_tclFCUsbTcuDpFirstStarup::vSetData(tBool)' could be made const reference
tVoid dp_tclFCUsbTcuDpFirstStarup::vSetData(const tBool &tFirstStarupParam) { 
   //init parameter
   (tVoid)memcpy(&tFirstStarup,(tVoid*)&tFirstStarupParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tFirstStarupParam' in function 'dp_tclFCUsbTcuDpFirstStarup::vSetData(tBool)' could be made const reference
tU8   dp_tclFCUsbTcuDpFirstStarup::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCUsbTcuDpFirstStarup::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "FirstStarup", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpFirstStarup::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "FirstStarup", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpFirstStarup::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: FirstStarup", DP_U32_POOL_ID_FCUSBTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
   }
   else
   {
      fprintf(stdout,"Element FirstStarup has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SystemTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpSystemTime::dp_tclFCUsbTcuDpSystemTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSystemTime,0,sizeof(TDatetime));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCUsbTcuDpSystemTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SystemTime",(tS32) 0xd259f34);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TDatetime)) 
      {
         tSystemTime = *((TDatetime*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCUsbTcuDpSystemTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SystemTime", (tS32)0xd259f34);
   (tVoid)myDpElem.bFillData((tVoid*)&tSystemTime, (tU32)sizeof(TDatetime));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCUsbTcuDpSystemTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCUsbTcuDpSystemTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TDatetime dp_tclFCUsbTcuDpSystemTime::tGetData() {
   vUpdate();
   return tSystemTime;
};
tS32 dp_tclFCUsbTcuDpSystemTime::s32GetData(TDatetime& tSystemTimeParam) { 
   vUpdate();
   tSystemTimeParam = tSystemTime;
   return _s32Status;
}
tS32 dp_tclFCUsbTcuDpSystemTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SystemTime", (tS32)0xd259f34);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCUsbTcuDpSystemTime::operator>>(TDatetime& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCUsbTcuDpSystemTime::operator<<(TDatetime oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCUsbTcuDpSystemTime::s32SetData(TDatetime &tSystemTimeParam) {
   //init parameter
   (tVoid)memcpy(&tSystemTime,(tVoid*)&tSystemTimeParam, sizeof(TDatetime));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSystemTimeParam' in function 'dp_tclFCUsbTcuDpSystemTime::vSetData(TDatetime)' could be made const reference
tS32 dp_tclFCUsbTcuDpSystemTime::s32SetData(const TDatetime &tSystemTimeParam) {
   //init parameter
   (tVoid)memcpy(&tSystemTime,(tVoid*)&tSystemTimeParam, sizeof(TDatetime));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSystemTimeParam' in function 'dp_tclFCUsbTcuDpSystemTime::vSetData(TDatetime)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCUsbTcuDpSystemTime::u8GetData(TDatetime& tSystemTimeParam) {  
   vUpdate();
   tSystemTimeParam = tSystemTime;
   return _u8DataStatus;
}
tVoid dp_tclFCUsbTcuDpSystemTime::vSetData(TDatetime &tSystemTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tSystemTime,(tVoid*)&tSystemTimeParam, sizeof(TDatetime));
   vStore();
}//lint !e1746: parameter 'tSystemTimeParam' in function 'dp_tclFCUsbTcuDpSystemTime::vSetData(TDatetime)' could be made const reference
tVoid dp_tclFCUsbTcuDpSystemTime::vSetData(const TDatetime &tSystemTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tSystemTime,(tVoid*)&tSystemTimeParam, sizeof(TDatetime));
   vStore();
}//lint !e1746: parameter 'tSystemTimeParam' in function 'dp_tclFCUsbTcuDpSystemTime::vSetData(TDatetime)' could be made const reference
tU8   dp_tclFCUsbTcuDpSystemTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCUsbTcuDpSystemTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "SystemTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpSystemTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "SystemTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpSystemTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SystemTime", DP_U32_POOL_ID_FCUSBTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
   }
   else
   {
      fprintf(stdout,"Element SystemTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LastSystemDate"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpLastSystemDate::dp_tclFCUsbTcuDpLastSystemDate(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLastSystemDate,0,sizeof(TDate));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCUsbTcuDpLastSystemDate::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LastSystemDate",(tS32) 0xbca015c7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TDate)) 
      {
         tLastSystemDate = *((TDate*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCUsbTcuDpLastSystemDate::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LastSystemDate", (tS32)0xbca015c7);
   (tVoid)myDpElem.bFillData((tVoid*)&tLastSystemDate, (tU32)sizeof(TDate));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCUsbTcuDpLastSystemDate::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCUsbTcuDpLastSystemDate::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TDate dp_tclFCUsbTcuDpLastSystemDate::tGetData() {
   vUpdate();
   return tLastSystemDate;
};
tS32 dp_tclFCUsbTcuDpLastSystemDate::s32GetData(TDate& tLastSystemDateParam) { 
   vUpdate();
   tLastSystemDateParam = tLastSystemDate;
   return _s32Status;
}
tS32 dp_tclFCUsbTcuDpLastSystemDate::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LastSystemDate", (tS32)0xbca015c7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCUsbTcuDpLastSystemDate::operator>>(TDate& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCUsbTcuDpLastSystemDate::operator<<(TDate oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCUsbTcuDpLastSystemDate::s32SetData(TDate &tLastSystemDateParam) {
   //init parameter
   (tVoid)memcpy(&tLastSystemDate,(tVoid*)&tLastSystemDateParam, sizeof(TDate));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLastSystemDateParam' in function 'dp_tclFCUsbTcuDpLastSystemDate::vSetData(TDate)' could be made const reference
tS32 dp_tclFCUsbTcuDpLastSystemDate::s32SetData(const TDate &tLastSystemDateParam) {
   //init parameter
   (tVoid)memcpy(&tLastSystemDate,(tVoid*)&tLastSystemDateParam, sizeof(TDate));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLastSystemDateParam' in function 'dp_tclFCUsbTcuDpLastSystemDate::vSetData(TDate)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCUsbTcuDpLastSystemDate::u8GetData(TDate& tLastSystemDateParam) {  
   vUpdate();
   tLastSystemDateParam = tLastSystemDate;
   return _u8DataStatus;
}
tVoid dp_tclFCUsbTcuDpLastSystemDate::vSetData(TDate &tLastSystemDateParam) { 
   //init parameter
   (tVoid)memcpy(&tLastSystemDate,(tVoid*)&tLastSystemDateParam, sizeof(TDate));
   vStore();
}//lint !e1746: parameter 'tLastSystemDateParam' in function 'dp_tclFCUsbTcuDpLastSystemDate::vSetData(TDate)' could be made const reference
tVoid dp_tclFCUsbTcuDpLastSystemDate::vSetData(const TDate &tLastSystemDateParam) { 
   //init parameter
   (tVoid)memcpy(&tLastSystemDate,(tVoid*)&tLastSystemDateParam, sizeof(TDate));
   vStore();
}//lint !e1746: parameter 'tLastSystemDateParam' in function 'dp_tclFCUsbTcuDpLastSystemDate::vSetData(TDate)' could be made const reference
tU8   dp_tclFCUsbTcuDpLastSystemDate::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCUsbTcuDpLastSystemDate::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "LastSystemDate", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpLastSystemDate::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "LastSystemDate", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpLastSystemDate::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LastSystemDate", DP_U32_POOL_ID_FCUSBTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
   }
   else
   {
      fprintf(stdout,"Element LastSystemDate has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ProbeSetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpProbeSetting::dp_tclFCUsbTcuDpProbeSetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tProbeSetting,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCUsbTcuDpProbeSetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ProbeSetting",(tS32) 0x3af6891a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tProbeSetting = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCUsbTcuDpProbeSetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ProbeSetting", (tS32)0x3af6891a);
   (tVoid)myDpElem.bFillData((tVoid*)&tProbeSetting, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCUsbTcuDpProbeSetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCUsbTcuDpProbeSetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclFCUsbTcuDpProbeSetting::tGetData() {
   vUpdate();
   return tProbeSetting;
};
tS32 dp_tclFCUsbTcuDpProbeSetting::s32GetData(tBool& tProbeSettingParam) { 
   vUpdate();
   tProbeSettingParam = tProbeSetting;
   return _s32Status;
}
tS32 dp_tclFCUsbTcuDpProbeSetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ProbeSetting", (tS32)0x3af6891a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCUsbTcuDpProbeSetting::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCUsbTcuDpProbeSetting::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCUsbTcuDpProbeSetting::s32SetData(tBool &tProbeSettingParam) {
   //init parameter
   (tVoid)memcpy(&tProbeSetting,(tVoid*)&tProbeSettingParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tProbeSettingParam' in function 'dp_tclFCUsbTcuDpProbeSetting::vSetData(tBool)' could be made const reference
tS32 dp_tclFCUsbTcuDpProbeSetting::s32SetData(const tBool &tProbeSettingParam) {
   //init parameter
   (tVoid)memcpy(&tProbeSetting,(tVoid*)&tProbeSettingParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tProbeSettingParam' in function 'dp_tclFCUsbTcuDpProbeSetting::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCUsbTcuDpProbeSetting::u8GetData(tBool& tProbeSettingParam) {  
   vUpdate();
   tProbeSettingParam = tProbeSetting;
   return _u8DataStatus;
}
tVoid dp_tclFCUsbTcuDpProbeSetting::vSetData(tBool &tProbeSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tProbeSetting,(tVoid*)&tProbeSettingParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tProbeSettingParam' in function 'dp_tclFCUsbTcuDpProbeSetting::vSetData(tBool)' could be made const reference
tVoid dp_tclFCUsbTcuDpProbeSetting::vSetData(const tBool &tProbeSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tProbeSetting,(tVoid*)&tProbeSettingParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tProbeSettingParam' in function 'dp_tclFCUsbTcuDpProbeSetting::vSetData(tBool)' could be made const reference
tU8   dp_tclFCUsbTcuDpProbeSetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCUsbTcuDpProbeSetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "ProbeSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpProbeSetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "ProbeSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpProbeSetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ProbeSetting", DP_U32_POOL_ID_FCUSBTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
   }
   else
   {
      fprintf(stdout,"Element ProbeSetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CautionHaltStatus"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpCautionHaltStatus::dp_tclFCUsbTcuDpCautionHaltStatus(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCautionHaltStatus,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCUsbTcuDpCautionHaltStatus::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CautionHaltStatus",(tS32) 0x4e307484);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCautionHaltStatus = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCUsbTcuDpCautionHaltStatus::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CautionHaltStatus", (tS32)0x4e307484);
   (tVoid)myDpElem.bFillData((tVoid*)&tCautionHaltStatus, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCUsbTcuDpCautionHaltStatus::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCUsbTcuDpCautionHaltStatus::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCUsbTcuDpCautionHaltStatus::tGetData() {
   vUpdate();
   return tCautionHaltStatus;
};
tS32 dp_tclFCUsbTcuDpCautionHaltStatus::s32GetData(tU8& tCautionHaltStatusParam) { 
   vUpdate();
   tCautionHaltStatusParam = tCautionHaltStatus;
   return _s32Status;
}
tS32 dp_tclFCUsbTcuDpCautionHaltStatus::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CautionHaltStatus", (tS32)0x4e307484);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCUsbTcuDpCautionHaltStatus::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCUsbTcuDpCautionHaltStatus::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCUsbTcuDpCautionHaltStatus::s32SetData(tU8 &tCautionHaltStatusParam) {
   //init parameter
   (tVoid)memcpy(&tCautionHaltStatus,(tVoid*)&tCautionHaltStatusParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCautionHaltStatusParam' in function 'dp_tclFCUsbTcuDpCautionHaltStatus::vSetData(tU8)' could be made const reference
tS32 dp_tclFCUsbTcuDpCautionHaltStatus::s32SetData(const tU8 &tCautionHaltStatusParam) {
   //init parameter
   (tVoid)memcpy(&tCautionHaltStatus,(tVoid*)&tCautionHaltStatusParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCautionHaltStatusParam' in function 'dp_tclFCUsbTcuDpCautionHaltStatus::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCUsbTcuDpCautionHaltStatus::u8GetData(tU8& tCautionHaltStatusParam) {  
   vUpdate();
   tCautionHaltStatusParam = tCautionHaltStatus;
   return _u8DataStatus;
}
tVoid dp_tclFCUsbTcuDpCautionHaltStatus::vSetData(tU8 &tCautionHaltStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tCautionHaltStatus,(tVoid*)&tCautionHaltStatusParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCautionHaltStatusParam' in function 'dp_tclFCUsbTcuDpCautionHaltStatus::vSetData(tU8)' could be made const reference
tVoid dp_tclFCUsbTcuDpCautionHaltStatus::vSetData(const tU8 &tCautionHaltStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tCautionHaltStatus,(tVoid*)&tCautionHaltStatusParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCautionHaltStatusParam' in function 'dp_tclFCUsbTcuDpCautionHaltStatus::vSetData(tU8)' could be made const reference
tU8   dp_tclFCUsbTcuDpCautionHaltStatus::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCUsbTcuDpCautionHaltStatus::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "CautionHaltStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpCautionHaltStatus::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "CautionHaltStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpCautionHaltStatus::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CautionHaltStatus", DP_U32_POOL_ID_FCUSBTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
   }
   else
   {
      fprintf(stdout,"Element CautionHaltStatus has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CautionHaltCause"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpCautionHaltCause::dp_tclFCUsbTcuDpCautionHaltCause(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCautionHaltCause,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCUsbTcuDpCautionHaltCause::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CautionHaltCause",(tS32) 0x42d64f25);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCautionHaltCause = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCUsbTcuDpCautionHaltCause::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CautionHaltCause", (tS32)0x42d64f25);
   (tVoid)myDpElem.bFillData((tVoid*)&tCautionHaltCause, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCUsbTcuDpCautionHaltCause::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCUsbTcuDpCautionHaltCause::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCUsbTcuDpCautionHaltCause::tGetData() {
   vUpdate();
   return tCautionHaltCause;
};
tS32 dp_tclFCUsbTcuDpCautionHaltCause::s32GetData(tU8& tCautionHaltCauseParam) { 
   vUpdate();
   tCautionHaltCauseParam = tCautionHaltCause;
   return _s32Status;
}
tS32 dp_tclFCUsbTcuDpCautionHaltCause::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CautionHaltCause", (tS32)0x42d64f25);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCUsbTcuDpCautionHaltCause::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCUsbTcuDpCautionHaltCause::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCUsbTcuDpCautionHaltCause::s32SetData(tU8 &tCautionHaltCauseParam) {
   //init parameter
   (tVoid)memcpy(&tCautionHaltCause,(tVoid*)&tCautionHaltCauseParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCautionHaltCauseParam' in function 'dp_tclFCUsbTcuDpCautionHaltCause::vSetData(tU8)' could be made const reference
tS32 dp_tclFCUsbTcuDpCautionHaltCause::s32SetData(const tU8 &tCautionHaltCauseParam) {
   //init parameter
   (tVoid)memcpy(&tCautionHaltCause,(tVoid*)&tCautionHaltCauseParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCautionHaltCauseParam' in function 'dp_tclFCUsbTcuDpCautionHaltCause::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCUsbTcuDpCautionHaltCause::u8GetData(tU8& tCautionHaltCauseParam) {  
   vUpdate();
   tCautionHaltCauseParam = tCautionHaltCause;
   return _u8DataStatus;
}
tVoid dp_tclFCUsbTcuDpCautionHaltCause::vSetData(tU8 &tCautionHaltCauseParam) { 
   //init parameter
   (tVoid)memcpy(&tCautionHaltCause,(tVoid*)&tCautionHaltCauseParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCautionHaltCauseParam' in function 'dp_tclFCUsbTcuDpCautionHaltCause::vSetData(tU8)' could be made const reference
tVoid dp_tclFCUsbTcuDpCautionHaltCause::vSetData(const tU8 &tCautionHaltCauseParam) { 
   //init parameter
   (tVoid)memcpy(&tCautionHaltCause,(tVoid*)&tCautionHaltCauseParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCautionHaltCauseParam' in function 'dp_tclFCUsbTcuDpCautionHaltCause::vSetData(tU8)' could be made const reference
tU8   dp_tclFCUsbTcuDpCautionHaltCause::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCUsbTcuDpCautionHaltCause::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "CautionHaltCause", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpCautionHaltCause::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "CautionHaltCause", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpCautionHaltCause::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CautionHaltCause", DP_U32_POOL_ID_FCUSBTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
   }
   else
   {
      fprintf(stdout,"Element CautionHaltCause has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UserAuthentication_UserID"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpUserAuthentication_UserID::dp_tclFCUsbTcuDpUserAuthentication_UserID(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclFCUsbTcuDpUserAuthentication_UserID::s32SetData(tString &tUserAuthentication_UserIDParam) {
   tU32 u32Len = (tU32)strlen(tUserAuthentication_UserIDParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("UserAuthentication_UserID", (tS32)0x2a183a7a);
      (tVoid)myDpElem.bFillData((tVoid*)tUserAuthentication_UserIDParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCUsbTcuDpUserAuthentication_UserID::s32SetData(const tString &tUserAuthentication_UserIDParam) {
   tU32 u32Len = (tU32)strlen(tUserAuthentication_UserIDParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("UserAuthentication_UserID", (tS32)0x2a183a7a);
      (tVoid)myDpElem.bFillData((tVoid*)tUserAuthentication_UserIDParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCUsbTcuDpUserAuthentication_UserID::s32GetData(tString &tUserAuthentication_UserIDParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("UserAuthentication_UserID", (tS32)0x2a183a7a);
   (tVoid)memset(tUserAuthentication_UserIDParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tUserAuthentication_UserIDParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclFCUsbTcuDpUserAuthentication_UserID::s32GetData(const tString &tUserAuthentication_UserIDParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("UserAuthentication_UserID", (tS32)0x2a183a7a);
   (tVoid)memset(tUserAuthentication_UserIDParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tUserAuthentication_UserIDParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclFCUsbTcuDpUserAuthentication_UserID::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFCUsbTcuDpUserAuthentication_UserID::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclFCUsbTcuDpUserAuthentication_UserID::u32GetData(tString &tUserAuthentication_UserIDParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tUserAuthentication_UserIDParam, u32StringBufLen);
   };
    tU32  dp_tclFCUsbTcuDpUserAuthentication_UserID::u32GetData(const tString &tUserAuthentication_UserIDParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tUserAuthentication_UserIDParam, u32StringBufLen);
   };
   tVoid dp_tclFCUsbTcuDpUserAuthentication_UserID::vSetData(tString &tUserAuthentication_UserIDParam){(tVoid)s32SetData(tUserAuthentication_UserIDParam);};
   tVoid dp_tclFCUsbTcuDpUserAuthentication_UserID::vSetData(const tString &tUserAuthentication_UserIDParam){(tVoid)s32SetData(tUserAuthentication_UserIDParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclFCUsbTcuDpUserAuthentication_UserID::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "UserAuthentication_UserID", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCUsbTcuDpUserAuthentication_UserID::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "UserAuthentication_UserID", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCUsbTcuDpUserAuthentication_UserID::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: UserAuthentication_UserID", DP_U32_POOL_ID_FCUSBTCUDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
		}
		else
		{
			fprintf(stdout,"Element UserAuthentication_UserID has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UserAuthentication_Password"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpUserAuthentication_Password::dp_tclFCUsbTcuDpUserAuthentication_Password(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclFCUsbTcuDpUserAuthentication_Password::s32SetData(tString &tUserAuthentication_PasswordParam) {
   tU32 u32Len = (tU32)strlen(tUserAuthentication_PasswordParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("UserAuthentication_Password", (tS32)0x1c544005L);
      (tVoid)myDpElem.bFillData((tVoid*)tUserAuthentication_PasswordParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCUsbTcuDpUserAuthentication_Password::s32SetData(const tString &tUserAuthentication_PasswordParam) {
   tU32 u32Len = (tU32)strlen(tUserAuthentication_PasswordParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("UserAuthentication_Password", (tS32)0x1c544005L);
      (tVoid)myDpElem.bFillData((tVoid*)tUserAuthentication_PasswordParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCUsbTcuDpUserAuthentication_Password::s32GetData(tString &tUserAuthentication_PasswordParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("UserAuthentication_Password", (tS32)0x1c544005L);
   (tVoid)memset(tUserAuthentication_PasswordParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tUserAuthentication_PasswordParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclFCUsbTcuDpUserAuthentication_Password::s32GetData(const tString &tUserAuthentication_PasswordParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("UserAuthentication_Password", (tS32)0x1c544005L);
   (tVoid)memset(tUserAuthentication_PasswordParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tUserAuthentication_PasswordParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclFCUsbTcuDpUserAuthentication_Password::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFCUsbTcuDpUserAuthentication_Password::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclFCUsbTcuDpUserAuthentication_Password::u32GetData(tString &tUserAuthentication_PasswordParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tUserAuthentication_PasswordParam, u32StringBufLen);
   };
    tU32  dp_tclFCUsbTcuDpUserAuthentication_Password::u32GetData(const tString &tUserAuthentication_PasswordParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tUserAuthentication_PasswordParam, u32StringBufLen);
   };
   tVoid dp_tclFCUsbTcuDpUserAuthentication_Password::vSetData(tString &tUserAuthentication_PasswordParam){(tVoid)s32SetData(tUserAuthentication_PasswordParam);};
   tVoid dp_tclFCUsbTcuDpUserAuthentication_Password::vSetData(const tString &tUserAuthentication_PasswordParam){(tVoid)s32SetData(tUserAuthentication_PasswordParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclFCUsbTcuDpUserAuthentication_Password::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "UserAuthentication_Password", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCUsbTcuDpUserAuthentication_Password::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "UserAuthentication_Password", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCUsbTcuDpUserAuthentication_Password::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: UserAuthentication_Password", DP_U32_POOL_ID_FCUSBTCUDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
		}
		else
		{
			fprintf(stdout,"Element UserAuthentication_Password has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PartAuthentication_PartID"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpPartAuthentication_PartID::dp_tclFCUsbTcuDpPartAuthentication_PartID(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclFCUsbTcuDpPartAuthentication_PartID::s32SetData(tString &tPartAuthentication_PartIDParam) {
   tU32 u32Len = (tU32)strlen(tPartAuthentication_PartIDParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("PartAuthentication_PartID", (tS32)0x483ef35a);
      (tVoid)myDpElem.bFillData((tVoid*)tPartAuthentication_PartIDParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCUsbTcuDpPartAuthentication_PartID::s32SetData(const tString &tPartAuthentication_PartIDParam) {
   tU32 u32Len = (tU32)strlen(tPartAuthentication_PartIDParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("PartAuthentication_PartID", (tS32)0x483ef35a);
      (tVoid)myDpElem.bFillData((tVoid*)tPartAuthentication_PartIDParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCUsbTcuDpPartAuthentication_PartID::s32GetData(tString &tPartAuthentication_PartIDParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("PartAuthentication_PartID", (tS32)0x483ef35a);
   (tVoid)memset(tPartAuthentication_PartIDParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tPartAuthentication_PartIDParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclFCUsbTcuDpPartAuthentication_PartID::s32GetData(const tString &tPartAuthentication_PartIDParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("PartAuthentication_PartID", (tS32)0x483ef35a);
   (tVoid)memset(tPartAuthentication_PartIDParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tPartAuthentication_PartIDParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclFCUsbTcuDpPartAuthentication_PartID::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFCUsbTcuDpPartAuthentication_PartID::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclFCUsbTcuDpPartAuthentication_PartID::u32GetData(tString &tPartAuthentication_PartIDParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tPartAuthentication_PartIDParam, u32StringBufLen);
   };
    tU32  dp_tclFCUsbTcuDpPartAuthentication_PartID::u32GetData(const tString &tPartAuthentication_PartIDParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tPartAuthentication_PartIDParam, u32StringBufLen);
   };
   tVoid dp_tclFCUsbTcuDpPartAuthentication_PartID::vSetData(tString &tPartAuthentication_PartIDParam){(tVoid)s32SetData(tPartAuthentication_PartIDParam);};
   tVoid dp_tclFCUsbTcuDpPartAuthentication_PartID::vSetData(const tString &tPartAuthentication_PartIDParam){(tVoid)s32SetData(tPartAuthentication_PartIDParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclFCUsbTcuDpPartAuthentication_PartID::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "PartAuthentication_PartID", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCUsbTcuDpPartAuthentication_PartID::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "PartAuthentication_PartID", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCUsbTcuDpPartAuthentication_PartID::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PartAuthentication_PartID", DP_U32_POOL_ID_FCUSBTCUDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
		}
		else
		{
			fprintf(stdout,"Element PartAuthentication_PartID has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PartAuthentication_Region"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpPartAuthentication_Region::dp_tclFCUsbTcuDpPartAuthentication_Region(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclFCUsbTcuDpPartAuthentication_Region::s32SetData(tString &tPartAuthentication_RegionParam) {
   tU32 u32Len = (tU32)strlen(tPartAuthentication_RegionParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("PartAuthentication_Region", (tS32)0x483f0ffe);
      (tVoid)myDpElem.bFillData((tVoid*)tPartAuthentication_RegionParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCUsbTcuDpPartAuthentication_Region::s32SetData(const tString &tPartAuthentication_RegionParam) {
   tU32 u32Len = (tU32)strlen(tPartAuthentication_RegionParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("PartAuthentication_Region", (tS32)0x483f0ffe);
      (tVoid)myDpElem.bFillData((tVoid*)tPartAuthentication_RegionParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCUsbTcuDpPartAuthentication_Region::s32GetData(tString &tPartAuthentication_RegionParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("PartAuthentication_Region", (tS32)0x483f0ffe);
   (tVoid)memset(tPartAuthentication_RegionParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tPartAuthentication_RegionParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclFCUsbTcuDpPartAuthentication_Region::s32GetData(const tString &tPartAuthentication_RegionParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("PartAuthentication_Region", (tS32)0x483f0ffe);
   (tVoid)memset(tPartAuthentication_RegionParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tPartAuthentication_RegionParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclFCUsbTcuDpPartAuthentication_Region::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFCUsbTcuDpPartAuthentication_Region::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclFCUsbTcuDpPartAuthentication_Region::u32GetData(tString &tPartAuthentication_RegionParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tPartAuthentication_RegionParam, u32StringBufLen);
   };
    tU32  dp_tclFCUsbTcuDpPartAuthentication_Region::u32GetData(const tString &tPartAuthentication_RegionParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tPartAuthentication_RegionParam, u32StringBufLen);
   };
   tVoid dp_tclFCUsbTcuDpPartAuthentication_Region::vSetData(tString &tPartAuthentication_RegionParam){(tVoid)s32SetData(tPartAuthentication_RegionParam);};
   tVoid dp_tclFCUsbTcuDpPartAuthentication_Region::vSetData(const tString &tPartAuthentication_RegionParam){(tVoid)s32SetData(tPartAuthentication_RegionParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclFCUsbTcuDpPartAuthentication_Region::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "PartAuthentication_Region", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCUsbTcuDpPartAuthentication_Region::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "PartAuthentication_Region", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCUsbTcuDpPartAuthentication_Region::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PartAuthentication_Region", DP_U32_POOL_ID_FCUSBTCUDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
		}
		else
		{
			fprintf(stdout,"Element PartAuthentication_Region has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PartAuthentication_Bootstrapping"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPartAuthentication_Bootstrapping,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PartAuthentication_Bootstrapping",(tS32) 0xf9969eeL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tPartAuthentication_Bootstrapping = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PartAuthentication_Bootstrapping", (tS32)0xf9969eeL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPartAuthentication_Bootstrapping, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::tGetData() {
   vUpdate();
   return tPartAuthentication_Bootstrapping;
};
tS32 dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::s32GetData(tBool& tPartAuthentication_BootstrappingParam) { 
   vUpdate();
   tPartAuthentication_BootstrappingParam = tPartAuthentication_Bootstrapping;
   return _s32Status;
}
tS32 dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PartAuthentication_Bootstrapping", (tS32)0xf9969eeL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::s32SetData(tBool &tPartAuthentication_BootstrappingParam) {
   //init parameter
   (tVoid)memcpy(&tPartAuthentication_Bootstrapping,(tVoid*)&tPartAuthentication_BootstrappingParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPartAuthentication_BootstrappingParam' in function 'dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::vSetData(tBool)' could be made const reference
tS32 dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::s32SetData(const tBool &tPartAuthentication_BootstrappingParam) {
   //init parameter
   (tVoid)memcpy(&tPartAuthentication_Bootstrapping,(tVoid*)&tPartAuthentication_BootstrappingParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPartAuthentication_BootstrappingParam' in function 'dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::u8GetData(tBool& tPartAuthentication_BootstrappingParam) {  
   vUpdate();
   tPartAuthentication_BootstrappingParam = tPartAuthentication_Bootstrapping;
   return _u8DataStatus;
}
tVoid dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::vSetData(tBool &tPartAuthentication_BootstrappingParam) { 
   //init parameter
   (tVoid)memcpy(&tPartAuthentication_Bootstrapping,(tVoid*)&tPartAuthentication_BootstrappingParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tPartAuthentication_BootstrappingParam' in function 'dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::vSetData(tBool)' could be made const reference
tVoid dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::vSetData(const tBool &tPartAuthentication_BootstrappingParam) { 
   //init parameter
   (tVoid)memcpy(&tPartAuthentication_Bootstrapping,(tVoid*)&tPartAuthentication_BootstrappingParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tPartAuthentication_BootstrappingParam' in function 'dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::vSetData(tBool)' could be made const reference
tU8   dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "PartAuthentication_Bootstrapping", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "PartAuthentication_Bootstrapping", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpPartAuthentication_Bootstrapping::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PartAuthentication_Bootstrapping", DP_U32_POOL_ID_FCUSBTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
   }
   else
   {
      fprintf(stdout,"Element PartAuthentication_Bootstrapping has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CredentialsValidationTimeout"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpCredentialsValidationTimeout::dp_tclFCUsbTcuDpCredentialsValidationTimeout(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCredentialsValidationTimeout,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCUsbTcuDpCredentialsValidationTimeout::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CredentialsValidationTimeout",(tS32) 0xda3dda00L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCredentialsValidationTimeout = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCUsbTcuDpCredentialsValidationTimeout::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CredentialsValidationTimeout", (tS32)0xda3dda00L);
   (tVoid)myDpElem.bFillData((tVoid*)&tCredentialsValidationTimeout, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCUsbTcuDpCredentialsValidationTimeout::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCUsbTcuDpCredentialsValidationTimeout::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCUsbTcuDpCredentialsValidationTimeout::tGetData() {
   vUpdate();
   return tCredentialsValidationTimeout;
};
tS32 dp_tclFCUsbTcuDpCredentialsValidationTimeout::s32GetData(tU8& tCredentialsValidationTimeoutParam) { 
   vUpdate();
   tCredentialsValidationTimeoutParam = tCredentialsValidationTimeout;
   return _s32Status;
}
tS32 dp_tclFCUsbTcuDpCredentialsValidationTimeout::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CredentialsValidationTimeout", (tS32)0xda3dda00L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCUsbTcuDpCredentialsValidationTimeout::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCUsbTcuDpCredentialsValidationTimeout::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCUsbTcuDpCredentialsValidationTimeout::s32SetData(tU8 &tCredentialsValidationTimeoutParam) {
   //init parameter
   (tVoid)memcpy(&tCredentialsValidationTimeout,(tVoid*)&tCredentialsValidationTimeoutParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCredentialsValidationTimeoutParam' in function 'dp_tclFCUsbTcuDpCredentialsValidationTimeout::vSetData(tU8)' could be made const reference
tS32 dp_tclFCUsbTcuDpCredentialsValidationTimeout::s32SetData(const tU8 &tCredentialsValidationTimeoutParam) {
   //init parameter
   (tVoid)memcpy(&tCredentialsValidationTimeout,(tVoid*)&tCredentialsValidationTimeoutParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCredentialsValidationTimeoutParam' in function 'dp_tclFCUsbTcuDpCredentialsValidationTimeout::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCUsbTcuDpCredentialsValidationTimeout::u8GetData(tU8& tCredentialsValidationTimeoutParam) {  
   vUpdate();
   tCredentialsValidationTimeoutParam = tCredentialsValidationTimeout;
   return _u8DataStatus;
}
tVoid dp_tclFCUsbTcuDpCredentialsValidationTimeout::vSetData(tU8 &tCredentialsValidationTimeoutParam) { 
   //init parameter
   (tVoid)memcpy(&tCredentialsValidationTimeout,(tVoid*)&tCredentialsValidationTimeoutParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCredentialsValidationTimeoutParam' in function 'dp_tclFCUsbTcuDpCredentialsValidationTimeout::vSetData(tU8)' could be made const reference
tVoid dp_tclFCUsbTcuDpCredentialsValidationTimeout::vSetData(const tU8 &tCredentialsValidationTimeoutParam) { 
   //init parameter
   (tVoid)memcpy(&tCredentialsValidationTimeout,(tVoid*)&tCredentialsValidationTimeoutParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCredentialsValidationTimeoutParam' in function 'dp_tclFCUsbTcuDpCredentialsValidationTimeout::vSetData(tU8)' could be made const reference
tU8   dp_tclFCUsbTcuDpCredentialsValidationTimeout::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCUsbTcuDpCredentialsValidationTimeout::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "CredentialsValidationTimeout", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpCredentialsValidationTimeout::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "CredentialsValidationTimeout", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpCredentialsValidationTimeout::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CredentialsValidationTimeout", DP_U32_POOL_ID_FCUSBTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
   }
   else
   {
      fprintf(stdout,"Element CredentialsValidationTimeout has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RefreshAccessTokenTimeout"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::dp_tclFCUsbTcuDpRefreshAccessTokenTimeout(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRefreshAccessTokenTimeout,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RefreshAccessTokenTimeout",(tS32) 0x5080ca15);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tRefreshAccessTokenTimeout = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RefreshAccessTokenTimeout", (tS32)0x5080ca15);
   (tVoid)myDpElem.bFillData((tVoid*)&tRefreshAccessTokenTimeout, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::tGetData() {
   vUpdate();
   return tRefreshAccessTokenTimeout;
};
tS32 dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::s32GetData(tU8& tRefreshAccessTokenTimeoutParam) { 
   vUpdate();
   tRefreshAccessTokenTimeoutParam = tRefreshAccessTokenTimeout;
   return _s32Status;
}
tS32 dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RefreshAccessTokenTimeout", (tS32)0x5080ca15);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCUSBTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::s32SetData(tU8 &tRefreshAccessTokenTimeoutParam) {
   //init parameter
   (tVoid)memcpy(&tRefreshAccessTokenTimeout,(tVoid*)&tRefreshAccessTokenTimeoutParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRefreshAccessTokenTimeoutParam' in function 'dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::vSetData(tU8)' could be made const reference
tS32 dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::s32SetData(const tU8 &tRefreshAccessTokenTimeoutParam) {
   //init parameter
   (tVoid)memcpy(&tRefreshAccessTokenTimeout,(tVoid*)&tRefreshAccessTokenTimeoutParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRefreshAccessTokenTimeoutParam' in function 'dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::u8GetData(tU8& tRefreshAccessTokenTimeoutParam) {  
   vUpdate();
   tRefreshAccessTokenTimeoutParam = tRefreshAccessTokenTimeout;
   return _u8DataStatus;
}
tVoid dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::vSetData(tU8 &tRefreshAccessTokenTimeoutParam) { 
   //init parameter
   (tVoid)memcpy(&tRefreshAccessTokenTimeout,(tVoid*)&tRefreshAccessTokenTimeoutParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRefreshAccessTokenTimeoutParam' in function 'dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::vSetData(tU8)' could be made const reference
tVoid dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::vSetData(const tU8 &tRefreshAccessTokenTimeoutParam) { 
   //init parameter
   (tVoid)memcpy(&tRefreshAccessTokenTimeout,(tVoid*)&tRefreshAccessTokenTimeoutParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRefreshAccessTokenTimeoutParam' in function 'dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::vSetData(tU8)' could be made const reference
tU8   dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCUSBTCUDP, "RefreshAccessTokenTimeout", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCUSBTCUDP, "RefreshAccessTokenTimeout", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCUsbTcuDpRefreshAccessTokenTimeout::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RefreshAccessTokenTimeout", DP_U32_POOL_ID_FCUSBTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCUSBTCUDP);
   }
   else
   {
      fprintf(stdout,"Element RefreshAccessTokenTimeout has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
