
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclFcSxmDPUser.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DpEndUserData"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFcSxmDPUserDpEndUserData::dp_tclFcSxmDPUserDpEndUserData(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclFcSxmDPUserDpEndUserData::s32SetData( signed short* tDpEndUserDataParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("DpEndUserData", (tS32)0x5b512c24);
   (tVoid)myDpElem.bFillData((tVoid*)tDpEndUserDataParam, ((tU32)sizeof(signed short))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCSXMDPUSER, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclFcSxmDPUserDpEndUserData::s32GetData(signed short* tDpEndUserDataParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("DpEndUserData", (tS32)0x5b512c24);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCSXMDPUSER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(signed short)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(signed short));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tDpEndUserDataParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(signed short));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclFcSxmDPUserDpEndUserData::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFcSxmDPUserDpEndUserData::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclFcSxmDPUserDpEndUserData::u16GetData(signed short* tDpEndUserDataParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tDpEndUserDataParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclFcSxmDPUserDpEndUserData::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCSXMDPUSER, "DpEndUserData", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFcSxmDPUserDpEndUserData::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCSXMDPUSER, "DpEndUserData", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclFcSxmDPUserDpEndUserData::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DpEndUserData", DP_U32_POOL_ID_FCSXMDPUSER);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCSXMDPUSER);
		}
		else
		{
			fprintf(stdout,"Element DpEndUserData has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 

