#ifndef _DP_FI_FCSXMDP_H
#define _DP_FI_FCSXMDP_H

extern tVoid vInitFcSxmDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);





//lint -e750
#define FC_SXM_S_IMPORT_INTERFACE_DP_FC_SXM 
#include "fc_sxm_if.h"
//lint +e750




class dp_tclFcSxmDPRADIOID{
private:
   tU8 _u8DataStatus;
public:
   dp_tclFcSxmDPRADIOID(): 
       _u8DataStatus(DP_U8_ELEM_STATUS_INITVAL)
   {};
   virtual ~dp_tclFcSxmDPRADIOID(){
   };
   
   tU8   u8GetData(tString &tRADIOIDParam, tU32 u32StringBufLen);
   tU8   u8GetData(const tString &tRADIOIDParam, tU32 u32StringBufLen);
   tU8   u8DataValid() const;
   

    tVoid vSetData(tString &tRADIOIDParam);
    tVoid vSetData(const tString &tRADIOIDParam);
    tVoid vSetData(tString &tRADIOIDParam, tU16 u16Len);    //lint !e715: Symbol 'u16Len' (line 560) not referenced
    tVoid vSetData(const tString &tRADIOIDParam, tU16 u16Len);

};

class dp_tclFcSxmDPHWREV{
private:
   tU8 _u8DataStatus;
public:
   dp_tclFcSxmDPHWREV(): 
       _u8DataStatus(DP_U8_ELEM_STATUS_INITVAL)
   {};
   virtual ~dp_tclFcSxmDPHWREV(){
   };
   
   tU8   u8GetData(tString &tHWREVParam, tU32 u32StringBufLen);
   tU8   u8GetData(const tString &tHWREVParam, tU32 u32StringBufLen);
   tU8   u8DataValid() const;
   

    tVoid vSetData(tString &tHWREVParam);
    tVoid vSetData(const tString &tHWREVParam);
    tVoid vSetData(tString &tHWREVParam, tU16 u16Len);    //lint !e715: Symbol 'u16Len' (line 560) not referenced
    tVoid vSetData(const tString &tHWREVParam, tU16 u16Len);

};

class dp_tclFcSxmDPSWREV{
private:
   tU8 _u8DataStatus;
public:
   dp_tclFcSxmDPSWREV(): 
       _u8DataStatus(DP_U8_ELEM_STATUS_INITVAL)
   {};
   virtual ~dp_tclFcSxmDPSWREV(){
   };
   
   tU8   u8GetData(tString &tSWREVParam, tU32 u32StringBufLen);
   tU8   u8GetData(const tString &tSWREVParam, tU32 u32StringBufLen);
   tU8   u8DataValid() const;
   

    tVoid vSetData(tString &tSWREVParam);
    tVoid vSetData(const tString &tSWREVParam);
    tVoid vSetData(tString &tSWREVParam, tU16 u16Len);    //lint !e715: Symbol 'u16Len' (line 560) not referenced
    tVoid vSetData(const tString &tSWREVParam, tU16 u16Len);

};

class dp_tclFcSxmDPSportsListSize{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tSportsListSize;
   
public:
   dp_tclFcSxmDPSportsListSize(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPSportsListSize() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tSportsListSizeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tSportsListSizeParam);
   tS32  s32SetData(const tU32 &tSportsListSizeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tSportsListSizeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tSportsListSizeParam);
   tVoid vSetData(const tU32& tSportsListSizeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPSportsList{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclFcSxmDPSportsList(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPSportsList() {};

   //read access for pool element 
   tS32  s32GetData(dpSportListElement* tSportsListParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(dpSportListElement* tSportsListParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(dpSportListElement* tSportsListParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclFcSxmDPSportsRootListSize{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tSportsRootListSize;
   
public:
   dp_tclFcSxmDPSportsRootListSize(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPSportsRootListSize() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tSportsRootListSizeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tSportsRootListSizeParam);
   tS32  s32SetData(const tU32 &tSportsRootListSizeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tSportsRootListSizeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tSportsRootListSizeParam);
   tVoid vSetData(const tU32& tSportsRootListSizeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPSportsRootList{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclFcSxmDPSportsRootList(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPSportsRootList() {};

   //read access for pool element 
   tS32  s32GetData(dpRootListElement* tSportsRootListParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(dpRootListElement* tSportsRootListParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(dpRootListElement* tSportsRootListParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclFcSxmDPSportsFavoriteListSize{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tSportsFavoriteListSize;
   
public:
   dp_tclFcSxmDPSportsFavoriteListSize(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPSportsFavoriteListSize() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tSportsFavoriteListSizeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tSportsFavoriteListSizeParam);
   tS32  s32SetData(const tU32 &tSportsFavoriteListSizeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tSportsFavoriteListSizeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tSportsFavoriteListSizeParam);
   tVoid vSetData(const tU32& tSportsFavoriteListSizeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPSportsFavoriteList{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclFcSxmDPSportsFavoriteList(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPSportsFavoriteList() {};

   //read access for pool element 
   tS32  s32GetData(dpFavoriteListElement* tSportsFavoriteListParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(dpFavoriteListElement* tSportsFavoriteListParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(dpFavoriteListElement* tSportsFavoriteListParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclFcSxmDPDBErrorConfig{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclFcSxmDPDBErrorConfig(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPDBErrorConfig() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tDBErrorConfigParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tDBErrorConfigParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tDBErrorConfigParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclFcSxmDPMoviesFavoriteList{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclFcSxmDPMoviesFavoriteList(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPMoviesFavoriteList() {};

   //read access for pool element 
   tS32  s32GetData(dpAppListElement* tMoviesFavoriteListParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(dpAppListElement* tMoviesFavoriteListParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(dpAppListElement* tMoviesFavoriteListParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclFcSxmDPMoviesFavoriteListSize{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tMoviesFavoriteListSize;
   
public:
   dp_tclFcSxmDPMoviesFavoriteListSize(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPMoviesFavoriteListSize() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tMoviesFavoriteListSizeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tMoviesFavoriteListSizeParam);
   tS32  s32SetData(const tU32 &tMoviesFavoriteListSizeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tMoviesFavoriteListSizeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tMoviesFavoriteListSizeParam);
   tVoid vSetData(const tU32& tMoviesFavoriteListSizeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPFuelFavoriteList{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclFcSxmDPFuelFavoriteList(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPFuelFavoriteList() {};

   //read access for pool element 
   tS32  s32GetData(dpAppListElement* tFuelFavoriteListParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(dpAppListElement* tFuelFavoriteListParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(dpAppListElement* tFuelFavoriteListParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclFcSxmDPFuelFavoriteListSize{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tFuelFavoriteListSize;
   
public:
   dp_tclFcSxmDPFuelFavoriteListSize(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPFuelFavoriteListSize() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tFuelFavoriteListSizeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tFuelFavoriteListSizeParam);
   tS32  s32SetData(const tU32 &tFuelFavoriteListSizeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tFuelFavoriteListSizeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tFuelFavoriteListSizeParam);
   tVoid vSetData(const tU32& tFuelFavoriteListSizeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPCanadianFuelFavoriteList{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclFcSxmDPCanadianFuelFavoriteList(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPCanadianFuelFavoriteList() {};

   //read access for pool element 
   tS32  s32GetData(dpAppListElement* tCanadianFuelFavoriteListParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(dpAppListElement* tCanadianFuelFavoriteListParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(dpAppListElement* tCanadianFuelFavoriteListParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclFcSxmDPCanadianFuelFavoriteListSize{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tCanadianFuelFavoriteListSize;
   
public:
   dp_tclFcSxmDPCanadianFuelFavoriteListSize(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPCanadianFuelFavoriteListSize() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tCanadianFuelFavoriteListSizeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tCanadianFuelFavoriteListSizeParam);
   tS32  s32SetData(const tU32 &tCanadianFuelFavoriteListSizeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tCanadianFuelFavoriteListSizeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tCanadianFuelFavoriteListSizeParam);
   tVoid vSetData(const tU32& tCanadianFuelFavoriteListSizeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPStocksFavoriteList{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclFcSxmDPStocksFavoriteList(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPStocksFavoriteList() {};

   //read access for pool element 
   tS32  s32GetData(dpStockListElement* tStocksFavoriteListParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(dpStockListElement* tStocksFavoriteListParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(dpStockListElement* tStocksFavoriteListParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclFcSxmDPStocksFavoriteListSize{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tStocksFavoriteListSize;
   
public:
   dp_tclFcSxmDPStocksFavoriteListSize(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPStocksFavoriteListSize() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tStocksFavoriteListSizeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tStocksFavoriteListSizeParam);
   tS32  s32SetData(const tU32 &tStocksFavoriteListSizeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tStocksFavoriteListSizeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tStocksFavoriteListSizeParam);
   tVoid vSetData(const tU32& tStocksFavoriteListSizeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPSmsCfgVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tSmsCfgVersion;
   
public:
   dp_tclFcSxmDPSmsCfgVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPSmsCfgVersion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tSmsCfgVersionParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tSmsCfgVersionParam);
   tS32  s32SetData(const tU32 &tSmsCfgVersionParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tSmsCfgVersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tSmsCfgVersionParam);
   tVoid vSetData(const tU32& tSmsCfgVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPFuelVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tFuelVersion;
   
public:
   dp_tclFcSxmDPFuelVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPFuelVersion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tFuelVersionParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tFuelVersionParam);
   tS32  s32SetData(const tU32 &tFuelVersionParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tFuelVersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tFuelVersionParam);
   tVoid vSetData(const tU32& tFuelVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPTrafficVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tTrafficVersion;
   
public:
   dp_tclFcSxmDPTrafficVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPTrafficVersion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tTrafficVersionParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tTrafficVersionParam);
   tS32  s32SetData(const tU32 &tTrafficVersionParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tTrafficVersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tTrafficVersionParam);
   tVoid vSetData(const tU32& tTrafficVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPMoviesVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tMoviesVersion;
   
public:
   dp_tclFcSxmDPMoviesVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPMoviesVersion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tMoviesVersionParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tMoviesVersionParam);
   tS32  s32SetData(const tU32 &tMoviesVersionParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tMoviesVersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tMoviesVersionParam);
   tVoid vSetData(const tU32& tMoviesVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPAgwVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tAgwVersion;
   
public:
   dp_tclFcSxmDPAgwVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPAgwVersion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tAgwVersionParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tAgwVersionParam);
   tS32  s32SetData(const tU32 &tAgwVersionParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tAgwVersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tAgwVersionParam);
   tVoid vSetData(const tU32& tAgwVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPTabWeatherVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tTabWeatherVersion;
   
public:
   dp_tclFcSxmDPTabWeatherVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPTabWeatherVersion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tTabWeatherVersionParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tTabWeatherVersionParam);
   tS32  s32SetData(const tU32 &tTabWeatherVersionParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tTabWeatherVersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tTabWeatherVersionParam);
   tVoid vSetData(const tU32& tTabWeatherVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPStocksVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tStocksVersion;
   
public:
   dp_tclFcSxmDPStocksVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPStocksVersion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tStocksVersionParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tStocksVersionParam);
   tS32  s32SetData(const tU32 &tStocksVersionParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tStocksVersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tStocksVersionParam);
   tVoid vSetData(const tU32& tStocksVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPSportsVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tSportsVersion;
   
public:
   dp_tclFcSxmDPSportsVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPSportsVersion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tSportsVersionParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tSportsVersionParam);
   tS32  s32SetData(const tU32 &tSportsVersionParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tSportsVersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tSportsVersionParam);
   tVoid vSetData(const tU32& tSportsVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPCanadianFuelVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tCanadianFuelVersion;
   
public:
   dp_tclFcSxmDPCanadianFuelVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPCanadianFuelVersion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tCanadianFuelVersionParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tCanadianFuelVersionParam);
   tS32  s32SetData(const tU32 &tCanadianFuelVersionParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tCanadianFuelVersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tCanadianFuelVersionParam);
   tVoid vSetData(const tU32& tCanadianFuelVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPWsAlertsVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tWsAlertsVersion;
   
public:
   dp_tclFcSxmDPWsAlertsVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPWsAlertsVersion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tWsAlertsVersionParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tWsAlertsVersionParam);
   tS32  s32SetData(const tU32 &tWsAlertsVersionParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tWsAlertsVersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tWsAlertsVersionParam);
   tVoid vSetData(const tU32& tWsAlertsVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPParkingVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tParkingVersion;
   
public:
   dp_tclFcSxmDPParkingVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPParkingVersion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tParkingVersionParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tParkingVersionParam);
   tS32  s32SetData(const tU32 &tParkingVersionParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tParkingVersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tParkingVersionParam);
   tVoid vSetData(const tU32& tParkingVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPPhoneticsVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tPhoneticsVersion;
   
public:
   dp_tclFcSxmDPPhoneticsVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPPhoneticsVersion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tPhoneticsVersionParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tPhoneticsVersionParam);
   tS32  s32SetData(const tU32 &tPhoneticsVersionParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tPhoneticsVersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tPhoneticsVersionParam);
   tVoid vSetData(const tU32& tPhoneticsVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPChannelArtVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tChannelArtVersion;
   
public:
   dp_tclFcSxmDPChannelArtVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPChannelArtVersion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tChannelArtVersionParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tChannelArtVersionParam);
   tS32  s32SetData(const tU32 &tChannelArtVersionParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tChannelArtVersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tChannelArtVersionParam);
   tVoid vSetData(const tU32& tChannelArtVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPStatesVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tStatesVersion;
   
public:
   dp_tclFcSxmDPStatesVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPStatesVersion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tStatesVersionParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tStatesVersionParam);
   tS32  s32SetData(const tU32 &tStatesVersionParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tStatesVersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tStatesVersionParam);
   tVoid vSetData(const tU32& tStatesVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPPresetType{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPresetType;
   
public:
   dp_tclFcSxmDPPresetType(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPPresetType() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPresetTypeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPresetTypeParam);
   tS32  s32SetData(const tU8 &tPresetTypeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPresetTypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPresetTypeParam);
   tVoid vSetData(const tU8& tPresetTypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFcSxmDPDpEndUserCurrent{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDpEndUserCurrent;
   
public:
   dp_tclFcSxmDPDpEndUserCurrent(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFcSxmDPDpEndUserCurrent() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDpEndUserCurrentParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDpEndUserCurrentParam);
   tS32  s32SetData(const tU8 &tDpEndUserCurrentParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDpEndUserCurrentParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDpEndUserCurrentParam);
   tVoid vSetData(const tU8& tDpEndUserCurrentParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
