#ifndef _DP_FI_PARKASDP_H
#define _DP_FI_PARKASDP_H

extern tVoid vInitParkasDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define FC_PARKASSIST_S_IMPORT_INTERFACE_DP_PARKAS 
#include "../../di_middleware_server/components/fc_ParkAssist/sources/appl/parkas_datapool.h"
//lint +e750




class dp_tclParkasDPSonar_ChangeRequest{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tenSensorSettingsChangeRequest tSonar_ChangeRequest;
   
public:
   dp_tclParkasDPSonar_ChangeRequest(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPSonar_ChangeRequest() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tenSensorSettingsChangeRequest tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tenSensorSettingsChangeRequest& tSonar_ChangeRequestParam);
   tVoid operator>>(tenSensorSettingsChangeRequest& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tenSensorSettingsChangeRequest &tSonar_ChangeRequestParam);
   tS32  s32SetData(const tenSensorSettingsChangeRequest &tSonar_ChangeRequestParam);
   tVoid operator<<(tenSensorSettingsChangeRequest oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tenSensorSettingsChangeRequest& tSonar_ChangeRequestParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tenSensorSettingsChangeRequest& tSonar_ChangeRequestParam);
   tVoid vSetData(const tenSensorSettingsChangeRequest& tSonar_ChangeRequestParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPSonar_Configuration{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSonar_SonarConfiguration tSonar_Configuration;
   
public:
   dp_tclParkasDPSonar_Configuration(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPSonar_Configuration() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSonar_SonarConfiguration tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSonar_SonarConfiguration& tSonar_ConfigurationParam);
   tVoid operator>>(TSonar_SonarConfiguration& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSonar_SonarConfiguration &tSonar_ConfigurationParam);
   tS32  s32SetData(const TSonar_SonarConfiguration &tSonar_ConfigurationParam);
   tVoid operator<<(TSonar_SonarConfiguration oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSonar_SonarConfiguration& tSonar_ConfigurationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSonar_SonarConfiguration& tSonar_ConfigurationParam);
   tVoid vSetData(const TSonar_SonarConfiguration& tSonar_ConfigurationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPSonar_Settings{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSonar_SonarSettings tSonar_Settings;
   
public:
   dp_tclParkasDPSonar_Settings(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPSonar_Settings() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSonar_SonarSettings tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSonar_SonarSettings& tSonar_SettingsParam);
   tVoid operator>>(TSonar_SonarSettings& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSonar_SonarSettings &tSonar_SettingsParam);
   tS32  s32SetData(const TSonar_SonarSettings &tSonar_SettingsParam);
   tVoid operator<<(TSonar_SonarSettings oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSonar_SonarSettings& tSonar_SettingsParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSonar_SonarSettings& tSonar_SettingsParam);
   tVoid vSetData(const TSonar_SonarSettings& tSonar_SettingsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPSonar_Display{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSonar_SonarDisplay tSonar_Display;
   
public:
   dp_tclParkasDPSonar_Display(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPSonar_Display() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSonar_SonarDisplay tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSonar_SonarDisplay& tSonar_DisplayParam);
   tVoid operator>>(TSonar_SonarDisplay& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSonar_SonarDisplay &tSonar_DisplayParam);
   tS32  s32SetData(const TSonar_SonarDisplay &tSonar_DisplayParam);
   tVoid operator<<(TSonar_SonarDisplay oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSonar_SonarDisplay& tSonar_DisplayParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSonar_SonarDisplay& tSonar_DisplayParam);
   tVoid vSetData(const TSonar_SonarDisplay& tSonar_DisplayParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPSonar_SensorsFront{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSonar_SonarSensors tSonar_SensorsFront;
   
public:
   dp_tclParkasDPSonar_SensorsFront(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPSonar_SensorsFront() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSonar_SonarSensors tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSonar_SonarSensors& tSonar_SensorsFrontParam);
   tVoid operator>>(TSonar_SonarSensors& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSonar_SonarSensors &tSonar_SensorsFrontParam);
   tS32  s32SetData(const TSonar_SonarSensors &tSonar_SensorsFrontParam);
   tVoid operator<<(TSonar_SonarSensors oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSonar_SonarSensors& tSonar_SensorsFrontParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSonar_SonarSensors& tSonar_SensorsFrontParam);
   tVoid vSetData(const TSonar_SonarSensors& tSonar_SensorsFrontParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPSonar_SensorsRear{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TSonar_SonarSensors tSonar_SensorsRear;
   
public:
   dp_tclParkasDPSonar_SensorsRear(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPSonar_SensorsRear() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TSonar_SonarSensors tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TSonar_SonarSensors& tSonar_SensorsRearParam);
   tVoid operator>>(TSonar_SonarSensors& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TSonar_SonarSensors &tSonar_SensorsRearParam);
   tS32  s32SetData(const TSonar_SonarSensors &tSonar_SensorsRearParam);
   tVoid operator<<(TSonar_SonarSensors oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TSonar_SonarSensors& tSonar_SensorsRearParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TSonar_SonarSensors& tSonar_SensorsRearParam);
   tVoid vSetData(const TSonar_SonarSensors& tSonar_SensorsRearParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPUPA_ChangeRequest{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tenUPASettingsChangeRequest tUPA_ChangeRequest;
   
public:
   dp_tclParkasDPUPA_ChangeRequest(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPUPA_ChangeRequest() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tenUPASettingsChangeRequest tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tenUPASettingsChangeRequest& tUPA_ChangeRequestParam);
   tVoid operator>>(tenUPASettingsChangeRequest& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tenUPASettingsChangeRequest &tUPA_ChangeRequestParam);
   tS32  s32SetData(const tenUPASettingsChangeRequest &tUPA_ChangeRequestParam);
   tVoid operator<<(tenUPASettingsChangeRequest oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tenUPASettingsChangeRequest& tUPA_ChangeRequestParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tenUPASettingsChangeRequest& tUPA_ChangeRequestParam);
   tVoid vSetData(const tenUPASettingsChangeRequest& tUPA_ChangeRequestParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPUPA_UPAConfig{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TUPA_UPAConfig tUPA_UPAConfig;
   
public:
   dp_tclParkasDPUPA_UPAConfig(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPUPA_UPAConfig() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TUPA_UPAConfig tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TUPA_UPAConfig& tUPA_UPAConfigParam);
   tVoid operator>>(TUPA_UPAConfig& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TUPA_UPAConfig &tUPA_UPAConfigParam);
   tS32  s32SetData(const TUPA_UPAConfig &tUPA_UPAConfigParam);
   tVoid operator<<(TUPA_UPAConfig oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TUPA_UPAConfig& tUPA_UPAConfigParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TUPA_UPAConfig& tUPA_UPAConfigParam);
   tVoid vSetData(const TUPA_UPAConfig& tUPA_UPAConfigParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPUPA_UPAStatus{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TUPA_UPAStatus tUPA_UPAStatus;
   
public:
   dp_tclParkasDPUPA_UPAStatus(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPUPA_UPAStatus() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TUPA_UPAStatus tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TUPA_UPAStatus& tUPA_UPAStatusParam);
   tVoid operator>>(TUPA_UPAStatus& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TUPA_UPAStatus &tUPA_UPAStatusParam);
   tS32  s32SetData(const TUPA_UPAStatus &tUPA_UPAStatusParam);
   tVoid operator<<(TUPA_UPAStatus oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TUPA_UPAStatus& tUPA_UPAStatusParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TUPA_UPAStatus& tUPA_UPAStatusParam);
   tVoid vSetData(const TUPA_UPAStatus& tUPA_UPAStatusParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPUPA_UPASensors{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TUPA_UPASensors tUPA_UPASensors;
   
public:
   dp_tclParkasDPUPA_UPASensors(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPUPA_UPASensors() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TUPA_UPASensors tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TUPA_UPASensors& tUPA_UPASensorsParam);
   tVoid operator>>(TUPA_UPASensors& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TUPA_UPASensors &tUPA_UPASensorsParam);
   tS32  s32SetData(const TUPA_UPASensors &tUPA_UPASensorsParam);
   tVoid operator<<(TUPA_UPASensors oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TUPA_UPASensors& tUPA_UPASensorsParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TUPA_UPASensors& tUPA_UPASensorsParam);
   tVoid vSetData(const TUPA_UPASensors& tUPA_UPASensorsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPUPA_UPAHatch{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TUPA_UPAHatch tUPA_UPAHatch;
   
public:
   dp_tclParkasDPUPA_UPAHatch(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPUPA_UPAHatch() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TUPA_UPAHatch tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TUPA_UPAHatch& tUPA_UPAHatchParam);
   tVoid operator>>(TUPA_UPAHatch& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TUPA_UPAHatch &tUPA_UPAHatchParam);
   tS32  s32SetData(const TUPA_UPAHatch &tUPA_UPAHatchParam);
   tVoid operator<<(TUPA_UPAHatch oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TUPA_UPAHatch& tUPA_UPAHatchParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TUPA_UPAHatch& tUPA_UPAHatchParam);
   tVoid vSetData(const TUPA_UPAHatch& tUPA_UPAHatchParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPUPA_UPAFKPSensors{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TUPA_UPAFKPSensors tUPA_UPAFKPSensors;
   
public:
   dp_tclParkasDPUPA_UPAFKPSensors(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPUPA_UPAFKPSensors() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TUPA_UPAFKPSensors tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TUPA_UPAFKPSensors& tUPA_UPAFKPSensorsParam);
   tVoid operator>>(TUPA_UPAFKPSensors& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TUPA_UPAFKPSensors &tUPA_UPAFKPSensorsParam);
   tS32  s32SetData(const TUPA_UPAFKPSensors &tUPA_UPAFKPSensorsParam);
   tVoid operator<<(TUPA_UPAFKPSensors oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TUPA_UPAFKPSensors& tUPA_UPAFKPSensorsParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TUPA_UPAFKPSensors& tUPA_UPAFKPSensorsParam);
   tVoid vSetData(const TUPA_UPAFKPSensors& tUPA_UPAFKPSensorsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPUPA_UPAFKPScan{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TUPA_UPAFKPScan tUPA_UPAFKPScan;
   
public:
   dp_tclParkasDPUPA_UPAFKPScan(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPUPA_UPAFKPScan() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TUPA_UPAFKPScan tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TUPA_UPAFKPScan& tUPA_UPAFKPScanParam);
   tVoid operator>>(TUPA_UPAFKPScan& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TUPA_UPAFKPScan &tUPA_UPAFKPScanParam);
   tS32  s32SetData(const TUPA_UPAFKPScan &tUPA_UPAFKPScanParam);
   tVoid operator<<(TUPA_UPAFKPScan oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TUPA_UPAFKPScan& tUPA_UPAFKPScanParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TUPA_UPAFKPScan& tUPA_UPAFKPScanParam);
   tVoid vSetData(const TUPA_UPAFKPScan& tUPA_UPAFKPScanParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPUPA_UPAFKPHatch{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TUPA_UPAFKPHatch tUPA_UPAFKPHatch;
   
public:
   dp_tclParkasDPUPA_UPAFKPHatch(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPUPA_UPAFKPHatch() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TUPA_UPAFKPHatch tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TUPA_UPAFKPHatch& tUPA_UPAFKPHatchParam);
   tVoid operator>>(TUPA_UPAFKPHatch& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TUPA_UPAFKPHatch &tUPA_UPAFKPHatchParam);
   tS32  s32SetData(const TUPA_UPAFKPHatch &tUPA_UPAFKPHatchParam);
   tVoid operator<<(TUPA_UPAFKPHatch oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TUPA_UPAFKPHatch& tUPA_UPAFKPHatchParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TUPA_UPAFKPHatch& tUPA_UPAFKPHatchParam);
   tVoid vSetData(const TUPA_UPAFKPHatch& tUPA_UPAFKPHatchParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPSettingRearParkAssist{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingRearParkAssist;
   
public:
   dp_tclParkasDPSettingRearParkAssist(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPSettingRearParkAssist() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingRearParkAssistParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingRearParkAssistParam);
   tS32  s32SetData(const tU8 &tSettingRearParkAssistParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingRearParkAssistParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingRearParkAssistParam);
   tVoid vSetData(const tU8& tSettingRearParkAssistParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPSettingFrontParkAssist{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingFrontParkAssist;
   
public:
   dp_tclParkasDPSettingFrontParkAssist(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPSettingFrontParkAssist() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingFrontParkAssistParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingFrontParkAssistParam);
   tS32  s32SetData(const tU8 &tSettingFrontParkAssistParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingFrontParkAssistParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingFrontParkAssistParam);
   tVoid vSetData(const tU8& tSettingFrontParkAssistParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPSettingFKP_Activation{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingFKP_Activation;
   
public:
   dp_tclParkasDPSettingFKP_Activation(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPSettingFKP_Activation() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingFKP_ActivationParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingFKP_ActivationParam);
   tS32  s32SetData(const tU8 &tSettingFKP_ActivationParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingFKP_ActivationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingFKP_ActivationParam);
   tVoid vSetData(const tU8& tSettingFKP_ActivationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPSettingHFP_DefaultManeuver{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingHFP_DefaultManeuver;
   
public:
   dp_tclParkasDPSettingHFP_DefaultManeuver(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPSettingHFP_DefaultManeuver() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingHFP_DefaultManeuverParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingHFP_DefaultManeuverParam);
   tS32  s32SetData(const tU8 &tSettingHFP_DefaultManeuverParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingHFP_DefaultManeuverParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingHFP_DefaultManeuverParam);
   tVoid vSetData(const tU8& tSettingHFP_DefaultManeuverParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPParkAssistVolumeState{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tParkAssistVolumeState;
   
public:
   dp_tclParkasDPParkAssistVolumeState(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPParkAssistVolumeState() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tParkAssistVolumeStateParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tParkAssistVolumeStateParam);
   tS32  s32SetData(const tU8 &tParkAssistVolumeStateParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tParkAssistVolumeStateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tParkAssistVolumeStateParam);
   tVoid vSetData(const tU8& tParkAssistVolumeStateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPUPA_SoundCollectionState{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tUPA_SoundCollectionState;
   
public:
   dp_tclParkasDPUPA_SoundCollectionState(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPUPA_SoundCollectionState() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tUPA_SoundCollectionStateParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tUPA_SoundCollectionStateParam);
   tS32  s32SetData(const tU8 &tUPA_SoundCollectionStateParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tUPA_SoundCollectionStateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tUPA_SoundCollectionStateParam);
   tVoid vSetData(const tU8& tUPA_SoundCollectionStateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPUPA_SoundStatus{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tUPA_SoundStatus;
   
public:
   dp_tclParkasDPUPA_SoundStatus(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPUPA_SoundStatus() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tUPA_SoundStatusParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tUPA_SoundStatusParam);
   tS32  s32SetData(const tBool &tUPA_SoundStatusParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tUPA_SoundStatusParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tUPA_SoundStatusParam);
   tVoid vSetData(const tBool& tUPA_SoundStatusParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPSettingSonarSystemPause{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingSonarSystemPause;
   
public:
   dp_tclParkasDPSettingSonarSystemPause(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPSettingSonarSystemPause() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingSonarSystemPauseParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingSonarSystemPauseParam);
   tS32  s32SetData(const tU8 &tSettingSonarSystemPauseParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingSonarSystemPauseParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingSonarSystemPauseParam);
   tVoid vSetData(const tU8& tSettingSonarSystemPauseParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPRctaActivation{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tRctaActivation;
   
public:
   dp_tclParkasDPRctaActivation(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPRctaActivation() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tRctaActivationParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tRctaActivationParam);
   tS32  s32SetData(const tU8 &tRctaActivationParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tRctaActivationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tRctaActivationParam);
   tVoid vSetData(const tU8& tRctaActivationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPRearParkAssistState{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tRearParkAssistState;
   
public:
   dp_tclParkasDPRearParkAssistState(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPRearParkAssistState() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tRearParkAssistStateParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tRearParkAssistStateParam);
   tS32  s32SetData(const tU8 &tRearParkAssistStateParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tRearParkAssistStateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tRearParkAssistStateParam);
   tVoid vSetData(const tU8& tRearParkAssistStateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPFrontParkAssistState{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tFrontParkAssistState;
   
public:
   dp_tclParkasDPFrontParkAssistState(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPFrontParkAssistState() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tFrontParkAssistStateParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tFrontParkAssistStateParam);
   tS32  s32SetData(const tU8 &tFrontParkAssistStateParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tFrontParkAssistStateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tFrontParkAssistStateParam);
   tVoid vSetData(const tU8& tFrontParkAssistStateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclParkasDPFKP_ActivationParkAssistState{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tFKP_ActivationParkAssistState;
   
public:
   dp_tclParkasDPFKP_ActivationParkAssistState(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclParkasDPFKP_ActivationParkAssistState() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tFKP_ActivationParkAssistStateParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tFKP_ActivationParkAssistStateParam);
   tS32  s32SetData(const tU8 &tFKP_ActivationParkAssistStateParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tFKP_ActivationParkAssistStateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tFKP_ActivationParkAssistStateParam);
   tVoid vSetData(const tU8& tFKP_ActivationParkAssistStateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
