
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclParkasDP.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Sonar_ChangeRequest"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPSonar_ChangeRequest::dp_tclParkasDPSonar_ChangeRequest(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSonar_ChangeRequest,0,sizeof(tenSensorSettingsChangeRequest));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPSonar_ChangeRequest::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Sonar_ChangeRequest",(tS32) 0xdbd0248d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tenSensorSettingsChangeRequest)) 
      {
         tSonar_ChangeRequest = *((tenSensorSettingsChangeRequest*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPSonar_ChangeRequest::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Sonar_ChangeRequest", (tS32)0xdbd0248d);
   (tVoid)myDpElem.bFillData((tVoid*)&tSonar_ChangeRequest, (tU32)sizeof(tenSensorSettingsChangeRequest));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPSonar_ChangeRequest::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPSonar_ChangeRequest::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tenSensorSettingsChangeRequest dp_tclParkasDPSonar_ChangeRequest::tGetData() {
   vUpdate();
   return tSonar_ChangeRequest;
};
tS32 dp_tclParkasDPSonar_ChangeRequest::s32GetData(tenSensorSettingsChangeRequest& tSonar_ChangeRequestParam) { 
   vUpdate();
   tSonar_ChangeRequestParam = tSonar_ChangeRequest;
   return _s32Status;
}
tS32 dp_tclParkasDPSonar_ChangeRequest::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Sonar_ChangeRequest", (tS32)0xdbd0248d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPSonar_ChangeRequest::operator>>(tenSensorSettingsChangeRequest& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPSonar_ChangeRequest::operator<<(tenSensorSettingsChangeRequest oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPSonar_ChangeRequest::s32SetData(tenSensorSettingsChangeRequest &tSonar_ChangeRequestParam) {
   //init parameter
   (tVoid)memcpy(&tSonar_ChangeRequest,(tVoid*)&tSonar_ChangeRequestParam, sizeof(tenSensorSettingsChangeRequest));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSonar_ChangeRequestParam' in function 'dp_tclParkasDPSonar_ChangeRequest::vSetData(tenSensorSettingsChangeRequest)' could be made const reference
tS32 dp_tclParkasDPSonar_ChangeRequest::s32SetData(const tenSensorSettingsChangeRequest &tSonar_ChangeRequestParam) {
   //init parameter
   (tVoid)memcpy(&tSonar_ChangeRequest,(tVoid*)&tSonar_ChangeRequestParam, sizeof(tenSensorSettingsChangeRequest));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSonar_ChangeRequestParam' in function 'dp_tclParkasDPSonar_ChangeRequest::vSetData(tenSensorSettingsChangeRequest)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPSonar_ChangeRequest::u8GetData(tenSensorSettingsChangeRequest& tSonar_ChangeRequestParam) {  
   vUpdate();
   tSonar_ChangeRequestParam = tSonar_ChangeRequest;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPSonar_ChangeRequest::vSetData(tenSensorSettingsChangeRequest &tSonar_ChangeRequestParam) { 
   //init parameter
   (tVoid)memcpy(&tSonar_ChangeRequest,(tVoid*)&tSonar_ChangeRequestParam, sizeof(tenSensorSettingsChangeRequest));
   vStore();
}//lint !e1746: parameter 'tSonar_ChangeRequestParam' in function 'dp_tclParkasDPSonar_ChangeRequest::vSetData(tenSensorSettingsChangeRequest)' could be made const reference
tVoid dp_tclParkasDPSonar_ChangeRequest::vSetData(const tenSensorSettingsChangeRequest &tSonar_ChangeRequestParam) { 
   //init parameter
   (tVoid)memcpy(&tSonar_ChangeRequest,(tVoid*)&tSonar_ChangeRequestParam, sizeof(tenSensorSettingsChangeRequest));
   vStore();
}//lint !e1746: parameter 'tSonar_ChangeRequestParam' in function 'dp_tclParkasDPSonar_ChangeRequest::vSetData(tenSensorSettingsChangeRequest)' could be made const reference
tU8   dp_tclParkasDPSonar_ChangeRequest::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPSonar_ChangeRequest::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "Sonar_ChangeRequest", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSonar_ChangeRequest::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "Sonar_ChangeRequest", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSonar_ChangeRequest::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Sonar_ChangeRequest", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element Sonar_ChangeRequest has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Sonar_Configuration"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPSonar_Configuration::dp_tclParkasDPSonar_Configuration(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSonar_Configuration,0,sizeof(TSonar_SonarConfiguration));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPSonar_Configuration::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Sonar_Configuration",(tS32) 0xf6e965da);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSonar_SonarConfiguration)) 
      {
         tSonar_Configuration = *((TSonar_SonarConfiguration*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPSonar_Configuration::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Sonar_Configuration", (tS32)0xf6e965da);
   (tVoid)myDpElem.bFillData((tVoid*)&tSonar_Configuration, (tU32)sizeof(TSonar_SonarConfiguration));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPSonar_Configuration::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPSonar_Configuration::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSonar_SonarConfiguration dp_tclParkasDPSonar_Configuration::tGetData() {
   vUpdate();
   return tSonar_Configuration;
};
tS32 dp_tclParkasDPSonar_Configuration::s32GetData(TSonar_SonarConfiguration& tSonar_ConfigurationParam) { 
   vUpdate();
   tSonar_ConfigurationParam = tSonar_Configuration;
   return _s32Status;
}
tS32 dp_tclParkasDPSonar_Configuration::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Sonar_Configuration", (tS32)0xf6e965da);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPSonar_Configuration::operator>>(TSonar_SonarConfiguration& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPSonar_Configuration::operator<<(TSonar_SonarConfiguration oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPSonar_Configuration::s32SetData(TSonar_SonarConfiguration &tSonar_ConfigurationParam) {
   //init parameter
   (tVoid)memcpy(&tSonar_Configuration,(tVoid*)&tSonar_ConfigurationParam, sizeof(TSonar_SonarConfiguration));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSonar_ConfigurationParam' in function 'dp_tclParkasDPSonar_Configuration::vSetData(TSonar_SonarConfiguration)' could be made const reference
tS32 dp_tclParkasDPSonar_Configuration::s32SetData(const TSonar_SonarConfiguration &tSonar_ConfigurationParam) {
   //init parameter
   (tVoid)memcpy(&tSonar_Configuration,(tVoid*)&tSonar_ConfigurationParam, sizeof(TSonar_SonarConfiguration));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSonar_ConfigurationParam' in function 'dp_tclParkasDPSonar_Configuration::vSetData(TSonar_SonarConfiguration)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPSonar_Configuration::u8GetData(TSonar_SonarConfiguration& tSonar_ConfigurationParam) {  
   vUpdate();
   tSonar_ConfigurationParam = tSonar_Configuration;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPSonar_Configuration::vSetData(TSonar_SonarConfiguration &tSonar_ConfigurationParam) { 
   //init parameter
   (tVoid)memcpy(&tSonar_Configuration,(tVoid*)&tSonar_ConfigurationParam, sizeof(TSonar_SonarConfiguration));
   vStore();
}//lint !e1746: parameter 'tSonar_ConfigurationParam' in function 'dp_tclParkasDPSonar_Configuration::vSetData(TSonar_SonarConfiguration)' could be made const reference
tVoid dp_tclParkasDPSonar_Configuration::vSetData(const TSonar_SonarConfiguration &tSonar_ConfigurationParam) { 
   //init parameter
   (tVoid)memcpy(&tSonar_Configuration,(tVoid*)&tSonar_ConfigurationParam, sizeof(TSonar_SonarConfiguration));
   vStore();
}//lint !e1746: parameter 'tSonar_ConfigurationParam' in function 'dp_tclParkasDPSonar_Configuration::vSetData(TSonar_SonarConfiguration)' could be made const reference
tU8   dp_tclParkasDPSonar_Configuration::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPSonar_Configuration::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "Sonar_Configuration", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSonar_Configuration::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "Sonar_Configuration", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSonar_Configuration::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Sonar_Configuration", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element Sonar_Configuration has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Sonar_Settings"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPSonar_Settings::dp_tclParkasDPSonar_Settings(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSonar_Settings,0,sizeof(TSonar_SonarSettings));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPSonar_Settings::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Sonar_Settings",(tS32) 0x6ee6d50b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSonar_SonarSettings)) 
      {
         tSonar_Settings = *((TSonar_SonarSettings*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPSonar_Settings::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Sonar_Settings", (tS32)0x6ee6d50b);
   (tVoid)myDpElem.bFillData((tVoid*)&tSonar_Settings, (tU32)sizeof(TSonar_SonarSettings));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPSonar_Settings::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPSonar_Settings::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSonar_SonarSettings dp_tclParkasDPSonar_Settings::tGetData() {
   vUpdate();
   return tSonar_Settings;
};
tS32 dp_tclParkasDPSonar_Settings::s32GetData(TSonar_SonarSettings& tSonar_SettingsParam) { 
   vUpdate();
   tSonar_SettingsParam = tSonar_Settings;
   return _s32Status;
}
tS32 dp_tclParkasDPSonar_Settings::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Sonar_Settings", (tS32)0x6ee6d50b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPSonar_Settings::operator>>(TSonar_SonarSettings& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPSonar_Settings::operator<<(TSonar_SonarSettings oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPSonar_Settings::s32SetData(TSonar_SonarSettings &tSonar_SettingsParam) {
   //init parameter
   (tVoid)memcpy(&tSonar_Settings,(tVoid*)&tSonar_SettingsParam, sizeof(TSonar_SonarSettings));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSonar_SettingsParam' in function 'dp_tclParkasDPSonar_Settings::vSetData(TSonar_SonarSettings)' could be made const reference
tS32 dp_tclParkasDPSonar_Settings::s32SetData(const TSonar_SonarSettings &tSonar_SettingsParam) {
   //init parameter
   (tVoid)memcpy(&tSonar_Settings,(tVoid*)&tSonar_SettingsParam, sizeof(TSonar_SonarSettings));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSonar_SettingsParam' in function 'dp_tclParkasDPSonar_Settings::vSetData(TSonar_SonarSettings)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPSonar_Settings::u8GetData(TSonar_SonarSettings& tSonar_SettingsParam) {  
   vUpdate();
   tSonar_SettingsParam = tSonar_Settings;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPSonar_Settings::vSetData(TSonar_SonarSettings &tSonar_SettingsParam) { 
   //init parameter
   (tVoid)memcpy(&tSonar_Settings,(tVoid*)&tSonar_SettingsParam, sizeof(TSonar_SonarSettings));
   vStore();
}//lint !e1746: parameter 'tSonar_SettingsParam' in function 'dp_tclParkasDPSonar_Settings::vSetData(TSonar_SonarSettings)' could be made const reference
tVoid dp_tclParkasDPSonar_Settings::vSetData(const TSonar_SonarSettings &tSonar_SettingsParam) { 
   //init parameter
   (tVoid)memcpy(&tSonar_Settings,(tVoid*)&tSonar_SettingsParam, sizeof(TSonar_SonarSettings));
   vStore();
}//lint !e1746: parameter 'tSonar_SettingsParam' in function 'dp_tclParkasDPSonar_Settings::vSetData(TSonar_SonarSettings)' could be made const reference
tU8   dp_tclParkasDPSonar_Settings::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPSonar_Settings::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "Sonar_Settings", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSonar_Settings::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "Sonar_Settings", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSonar_Settings::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Sonar_Settings", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element Sonar_Settings has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Sonar_Display"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPSonar_Display::dp_tclParkasDPSonar_Display(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSonar_Display,0,sizeof(TSonar_SonarDisplay));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPSonar_Display::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Sonar_Display",(tS32) 0x495df6bc);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSonar_SonarDisplay)) 
      {
         tSonar_Display = *((TSonar_SonarDisplay*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPSonar_Display::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Sonar_Display", (tS32)0x495df6bc);
   (tVoid)myDpElem.bFillData((tVoid*)&tSonar_Display, (tU32)sizeof(TSonar_SonarDisplay));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPSonar_Display::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPSonar_Display::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSonar_SonarDisplay dp_tclParkasDPSonar_Display::tGetData() {
   vUpdate();
   return tSonar_Display;
};
tS32 dp_tclParkasDPSonar_Display::s32GetData(TSonar_SonarDisplay& tSonar_DisplayParam) { 
   vUpdate();
   tSonar_DisplayParam = tSonar_Display;
   return _s32Status;
}
tS32 dp_tclParkasDPSonar_Display::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Sonar_Display", (tS32)0x495df6bc);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPSonar_Display::operator>>(TSonar_SonarDisplay& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPSonar_Display::operator<<(TSonar_SonarDisplay oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPSonar_Display::s32SetData(TSonar_SonarDisplay &tSonar_DisplayParam) {
   //init parameter
   (tVoid)memcpy(&tSonar_Display,(tVoid*)&tSonar_DisplayParam, sizeof(TSonar_SonarDisplay));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSonar_DisplayParam' in function 'dp_tclParkasDPSonar_Display::vSetData(TSonar_SonarDisplay)' could be made const reference
tS32 dp_tclParkasDPSonar_Display::s32SetData(const TSonar_SonarDisplay &tSonar_DisplayParam) {
   //init parameter
   (tVoid)memcpy(&tSonar_Display,(tVoid*)&tSonar_DisplayParam, sizeof(TSonar_SonarDisplay));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSonar_DisplayParam' in function 'dp_tclParkasDPSonar_Display::vSetData(TSonar_SonarDisplay)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPSonar_Display::u8GetData(TSonar_SonarDisplay& tSonar_DisplayParam) {  
   vUpdate();
   tSonar_DisplayParam = tSonar_Display;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPSonar_Display::vSetData(TSonar_SonarDisplay &tSonar_DisplayParam) { 
   //init parameter
   (tVoid)memcpy(&tSonar_Display,(tVoid*)&tSonar_DisplayParam, sizeof(TSonar_SonarDisplay));
   vStore();
}//lint !e1746: parameter 'tSonar_DisplayParam' in function 'dp_tclParkasDPSonar_Display::vSetData(TSonar_SonarDisplay)' could be made const reference
tVoid dp_tclParkasDPSonar_Display::vSetData(const TSonar_SonarDisplay &tSonar_DisplayParam) { 
   //init parameter
   (tVoid)memcpy(&tSonar_Display,(tVoid*)&tSonar_DisplayParam, sizeof(TSonar_SonarDisplay));
   vStore();
}//lint !e1746: parameter 'tSonar_DisplayParam' in function 'dp_tclParkasDPSonar_Display::vSetData(TSonar_SonarDisplay)' could be made const reference
tU8   dp_tclParkasDPSonar_Display::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPSonar_Display::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "Sonar_Display", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSonar_Display::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "Sonar_Display", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSonar_Display::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Sonar_Display", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element Sonar_Display has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Sonar_SensorsFront"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPSonar_SensorsFront::dp_tclParkasDPSonar_SensorsFront(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSonar_SensorsFront,0,sizeof(TSonar_SonarSensors));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPSonar_SensorsFront::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Sonar_SensorsFront",(tS32) 0xc0ddde88);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSonar_SonarSensors)) 
      {
         tSonar_SensorsFront = *((TSonar_SonarSensors*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPSonar_SensorsFront::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Sonar_SensorsFront", (tS32)0xc0ddde88);
   (tVoid)myDpElem.bFillData((tVoid*)&tSonar_SensorsFront, (tU32)sizeof(TSonar_SonarSensors));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPSonar_SensorsFront::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPSonar_SensorsFront::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSonar_SonarSensors dp_tclParkasDPSonar_SensorsFront::tGetData() {
   vUpdate();
   return tSonar_SensorsFront;
};
tS32 dp_tclParkasDPSonar_SensorsFront::s32GetData(TSonar_SonarSensors& tSonar_SensorsFrontParam) { 
   vUpdate();
   tSonar_SensorsFrontParam = tSonar_SensorsFront;
   return _s32Status;
}
tS32 dp_tclParkasDPSonar_SensorsFront::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Sonar_SensorsFront", (tS32)0xc0ddde88);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPSonar_SensorsFront::operator>>(TSonar_SonarSensors& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPSonar_SensorsFront::operator<<(TSonar_SonarSensors oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPSonar_SensorsFront::s32SetData(TSonar_SonarSensors &tSonar_SensorsFrontParam) {
   //init parameter
   (tVoid)memcpy(&tSonar_SensorsFront,(tVoid*)&tSonar_SensorsFrontParam, sizeof(TSonar_SonarSensors));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSonar_SensorsFrontParam' in function 'dp_tclParkasDPSonar_SensorsFront::vSetData(TSonar_SonarSensors)' could be made const reference
tS32 dp_tclParkasDPSonar_SensorsFront::s32SetData(const TSonar_SonarSensors &tSonar_SensorsFrontParam) {
   //init parameter
   (tVoid)memcpy(&tSonar_SensorsFront,(tVoid*)&tSonar_SensorsFrontParam, sizeof(TSonar_SonarSensors));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSonar_SensorsFrontParam' in function 'dp_tclParkasDPSonar_SensorsFront::vSetData(TSonar_SonarSensors)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPSonar_SensorsFront::u8GetData(TSonar_SonarSensors& tSonar_SensorsFrontParam) {  
   vUpdate();
   tSonar_SensorsFrontParam = tSonar_SensorsFront;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPSonar_SensorsFront::vSetData(TSonar_SonarSensors &tSonar_SensorsFrontParam) { 
   //init parameter
   (tVoid)memcpy(&tSonar_SensorsFront,(tVoid*)&tSonar_SensorsFrontParam, sizeof(TSonar_SonarSensors));
   vStore();
}//lint !e1746: parameter 'tSonar_SensorsFrontParam' in function 'dp_tclParkasDPSonar_SensorsFront::vSetData(TSonar_SonarSensors)' could be made const reference
tVoid dp_tclParkasDPSonar_SensorsFront::vSetData(const TSonar_SonarSensors &tSonar_SensorsFrontParam) { 
   //init parameter
   (tVoid)memcpy(&tSonar_SensorsFront,(tVoid*)&tSonar_SensorsFrontParam, sizeof(TSonar_SonarSensors));
   vStore();
}//lint !e1746: parameter 'tSonar_SensorsFrontParam' in function 'dp_tclParkasDPSonar_SensorsFront::vSetData(TSonar_SonarSensors)' could be made const reference
tU8   dp_tclParkasDPSonar_SensorsFront::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPSonar_SensorsFront::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "Sonar_SensorsFront", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSonar_SensorsFront::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "Sonar_SensorsFront", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSonar_SensorsFront::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Sonar_SensorsFront", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element Sonar_SensorsFront has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Sonar_SensorsRear"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPSonar_SensorsRear::dp_tclParkasDPSonar_SensorsRear(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSonar_SensorsRear,0,sizeof(TSonar_SonarSensors));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPSonar_SensorsRear::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Sonar_SensorsRear",(tS32) 0x2692ca59);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSonar_SonarSensors)) 
      {
         tSonar_SensorsRear = *((TSonar_SonarSensors*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPSonar_SensorsRear::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Sonar_SensorsRear", (tS32)0x2692ca59);
   (tVoid)myDpElem.bFillData((tVoid*)&tSonar_SensorsRear, (tU32)sizeof(TSonar_SonarSensors));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPSonar_SensorsRear::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPSonar_SensorsRear::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSonar_SonarSensors dp_tclParkasDPSonar_SensorsRear::tGetData() {
   vUpdate();
   return tSonar_SensorsRear;
};
tS32 dp_tclParkasDPSonar_SensorsRear::s32GetData(TSonar_SonarSensors& tSonar_SensorsRearParam) { 
   vUpdate();
   tSonar_SensorsRearParam = tSonar_SensorsRear;
   return _s32Status;
}
tS32 dp_tclParkasDPSonar_SensorsRear::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Sonar_SensorsRear", (tS32)0x2692ca59);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPSonar_SensorsRear::operator>>(TSonar_SonarSensors& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPSonar_SensorsRear::operator<<(TSonar_SonarSensors oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPSonar_SensorsRear::s32SetData(TSonar_SonarSensors &tSonar_SensorsRearParam) {
   //init parameter
   (tVoid)memcpy(&tSonar_SensorsRear,(tVoid*)&tSonar_SensorsRearParam, sizeof(TSonar_SonarSensors));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSonar_SensorsRearParam' in function 'dp_tclParkasDPSonar_SensorsRear::vSetData(TSonar_SonarSensors)' could be made const reference
tS32 dp_tclParkasDPSonar_SensorsRear::s32SetData(const TSonar_SonarSensors &tSonar_SensorsRearParam) {
   //init parameter
   (tVoid)memcpy(&tSonar_SensorsRear,(tVoid*)&tSonar_SensorsRearParam, sizeof(TSonar_SonarSensors));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSonar_SensorsRearParam' in function 'dp_tclParkasDPSonar_SensorsRear::vSetData(TSonar_SonarSensors)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPSonar_SensorsRear::u8GetData(TSonar_SonarSensors& tSonar_SensorsRearParam) {  
   vUpdate();
   tSonar_SensorsRearParam = tSonar_SensorsRear;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPSonar_SensorsRear::vSetData(TSonar_SonarSensors &tSonar_SensorsRearParam) { 
   //init parameter
   (tVoid)memcpy(&tSonar_SensorsRear,(tVoid*)&tSonar_SensorsRearParam, sizeof(TSonar_SonarSensors));
   vStore();
}//lint !e1746: parameter 'tSonar_SensorsRearParam' in function 'dp_tclParkasDPSonar_SensorsRear::vSetData(TSonar_SonarSensors)' could be made const reference
tVoid dp_tclParkasDPSonar_SensorsRear::vSetData(const TSonar_SonarSensors &tSonar_SensorsRearParam) { 
   //init parameter
   (tVoid)memcpy(&tSonar_SensorsRear,(tVoid*)&tSonar_SensorsRearParam, sizeof(TSonar_SonarSensors));
   vStore();
}//lint !e1746: parameter 'tSonar_SensorsRearParam' in function 'dp_tclParkasDPSonar_SensorsRear::vSetData(TSonar_SonarSensors)' could be made const reference
tU8   dp_tclParkasDPSonar_SensorsRear::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPSonar_SensorsRear::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "Sonar_SensorsRear", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSonar_SensorsRear::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "Sonar_SensorsRear", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSonar_SensorsRear::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Sonar_SensorsRear", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element Sonar_SensorsRear has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UPA_ChangeRequest"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPUPA_ChangeRequest::dp_tclParkasDPUPA_ChangeRequest(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tUPA_ChangeRequest,0,sizeof(tenUPASettingsChangeRequest));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPUPA_ChangeRequest::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("UPA_ChangeRequest",(tS32) 0xe290a1f8);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tenUPASettingsChangeRequest)) 
      {
         tUPA_ChangeRequest = *((tenUPASettingsChangeRequest*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPUPA_ChangeRequest::vStore(tVoid) {
   dp_tclBaseElement myDpElem("UPA_ChangeRequest", (tS32)0xe290a1f8);
   (tVoid)myDpElem.bFillData((tVoid*)&tUPA_ChangeRequest, (tU32)sizeof(tenUPASettingsChangeRequest));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPUPA_ChangeRequest::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPUPA_ChangeRequest::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tenUPASettingsChangeRequest dp_tclParkasDPUPA_ChangeRequest::tGetData() {
   vUpdate();
   return tUPA_ChangeRequest;
};
tS32 dp_tclParkasDPUPA_ChangeRequest::s32GetData(tenUPASettingsChangeRequest& tUPA_ChangeRequestParam) { 
   vUpdate();
   tUPA_ChangeRequestParam = tUPA_ChangeRequest;
   return _s32Status;
}
tS32 dp_tclParkasDPUPA_ChangeRequest::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("UPA_ChangeRequest", (tS32)0xe290a1f8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPUPA_ChangeRequest::operator>>(tenUPASettingsChangeRequest& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPUPA_ChangeRequest::operator<<(tenUPASettingsChangeRequest oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPUPA_ChangeRequest::s32SetData(tenUPASettingsChangeRequest &tUPA_ChangeRequestParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_ChangeRequest,(tVoid*)&tUPA_ChangeRequestParam, sizeof(tenUPASettingsChangeRequest));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_ChangeRequestParam' in function 'dp_tclParkasDPUPA_ChangeRequest::vSetData(tenUPASettingsChangeRequest)' could be made const reference
tS32 dp_tclParkasDPUPA_ChangeRequest::s32SetData(const tenUPASettingsChangeRequest &tUPA_ChangeRequestParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_ChangeRequest,(tVoid*)&tUPA_ChangeRequestParam, sizeof(tenUPASettingsChangeRequest));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_ChangeRequestParam' in function 'dp_tclParkasDPUPA_ChangeRequest::vSetData(tenUPASettingsChangeRequest)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPUPA_ChangeRequest::u8GetData(tenUPASettingsChangeRequest& tUPA_ChangeRequestParam) {  
   vUpdate();
   tUPA_ChangeRequestParam = tUPA_ChangeRequest;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPUPA_ChangeRequest::vSetData(tenUPASettingsChangeRequest &tUPA_ChangeRequestParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_ChangeRequest,(tVoid*)&tUPA_ChangeRequestParam, sizeof(tenUPASettingsChangeRequest));
   vStore();
}//lint !e1746: parameter 'tUPA_ChangeRequestParam' in function 'dp_tclParkasDPUPA_ChangeRequest::vSetData(tenUPASettingsChangeRequest)' could be made const reference
tVoid dp_tclParkasDPUPA_ChangeRequest::vSetData(const tenUPASettingsChangeRequest &tUPA_ChangeRequestParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_ChangeRequest,(tVoid*)&tUPA_ChangeRequestParam, sizeof(tenUPASettingsChangeRequest));
   vStore();
}//lint !e1746: parameter 'tUPA_ChangeRequestParam' in function 'dp_tclParkasDPUPA_ChangeRequest::vSetData(tenUPASettingsChangeRequest)' could be made const reference
tU8   dp_tclParkasDPUPA_ChangeRequest::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPUPA_ChangeRequest::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "UPA_ChangeRequest", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_ChangeRequest::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "UPA_ChangeRequest", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_ChangeRequest::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: UPA_ChangeRequest", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element UPA_ChangeRequest has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UPA_UPAConfig"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPUPA_UPAConfig::dp_tclParkasDPUPA_UPAConfig(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tUPA_UPAConfig,0,sizeof(TUPA_UPAConfig));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPUPA_UPAConfig::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("UPA_UPAConfig",(tS32) 0xf1114fb5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TUPA_UPAConfig)) 
      {
         tUPA_UPAConfig = *((TUPA_UPAConfig*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPUPA_UPAConfig::vStore(tVoid) {
   dp_tclBaseElement myDpElem("UPA_UPAConfig", (tS32)0xf1114fb5);
   (tVoid)myDpElem.bFillData((tVoid*)&tUPA_UPAConfig, (tU32)sizeof(TUPA_UPAConfig));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPUPA_UPAConfig::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPUPA_UPAConfig::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TUPA_UPAConfig dp_tclParkasDPUPA_UPAConfig::tGetData() {
   vUpdate();
   return tUPA_UPAConfig;
};
tS32 dp_tclParkasDPUPA_UPAConfig::s32GetData(TUPA_UPAConfig& tUPA_UPAConfigParam) { 
   vUpdate();
   tUPA_UPAConfigParam = tUPA_UPAConfig;
   return _s32Status;
}
tS32 dp_tclParkasDPUPA_UPAConfig::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("UPA_UPAConfig", (tS32)0xf1114fb5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPUPA_UPAConfig::operator>>(TUPA_UPAConfig& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPUPA_UPAConfig::operator<<(TUPA_UPAConfig oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPUPA_UPAConfig::s32SetData(TUPA_UPAConfig &tUPA_UPAConfigParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_UPAConfig,(tVoid*)&tUPA_UPAConfigParam, sizeof(TUPA_UPAConfig));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_UPAConfigParam' in function 'dp_tclParkasDPUPA_UPAConfig::vSetData(TUPA_UPAConfig)' could be made const reference
tS32 dp_tclParkasDPUPA_UPAConfig::s32SetData(const TUPA_UPAConfig &tUPA_UPAConfigParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_UPAConfig,(tVoid*)&tUPA_UPAConfigParam, sizeof(TUPA_UPAConfig));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_UPAConfigParam' in function 'dp_tclParkasDPUPA_UPAConfig::vSetData(TUPA_UPAConfig)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPUPA_UPAConfig::u8GetData(TUPA_UPAConfig& tUPA_UPAConfigParam) {  
   vUpdate();
   tUPA_UPAConfigParam = tUPA_UPAConfig;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPUPA_UPAConfig::vSetData(TUPA_UPAConfig &tUPA_UPAConfigParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_UPAConfig,(tVoid*)&tUPA_UPAConfigParam, sizeof(TUPA_UPAConfig));
   vStore();
}//lint !e1746: parameter 'tUPA_UPAConfigParam' in function 'dp_tclParkasDPUPA_UPAConfig::vSetData(TUPA_UPAConfig)' could be made const reference
tVoid dp_tclParkasDPUPA_UPAConfig::vSetData(const TUPA_UPAConfig &tUPA_UPAConfigParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_UPAConfig,(tVoid*)&tUPA_UPAConfigParam, sizeof(TUPA_UPAConfig));
   vStore();
}//lint !e1746: parameter 'tUPA_UPAConfigParam' in function 'dp_tclParkasDPUPA_UPAConfig::vSetData(TUPA_UPAConfig)' could be made const reference
tU8   dp_tclParkasDPUPA_UPAConfig::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPUPA_UPAConfig::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "UPA_UPAConfig", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_UPAConfig::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "UPA_UPAConfig", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_UPAConfig::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: UPA_UPAConfig", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element UPA_UPAConfig has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UPA_UPAStatus"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPUPA_UPAStatus::dp_tclParkasDPUPA_UPAStatus(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tUPA_UPAStatus,0,sizeof(TUPA_UPAStatus));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPUPA_UPAStatus::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("UPA_UPAStatus",(tS32) 0xf1121a87);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TUPA_UPAStatus)) 
      {
         tUPA_UPAStatus = *((TUPA_UPAStatus*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPUPA_UPAStatus::vStore(tVoid) {
   dp_tclBaseElement myDpElem("UPA_UPAStatus", (tS32)0xf1121a87);
   (tVoid)myDpElem.bFillData((tVoid*)&tUPA_UPAStatus, (tU32)sizeof(TUPA_UPAStatus));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPUPA_UPAStatus::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPUPA_UPAStatus::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TUPA_UPAStatus dp_tclParkasDPUPA_UPAStatus::tGetData() {
   vUpdate();
   return tUPA_UPAStatus;
};
tS32 dp_tclParkasDPUPA_UPAStatus::s32GetData(TUPA_UPAStatus& tUPA_UPAStatusParam) { 
   vUpdate();
   tUPA_UPAStatusParam = tUPA_UPAStatus;
   return _s32Status;
}
tS32 dp_tclParkasDPUPA_UPAStatus::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("UPA_UPAStatus", (tS32)0xf1121a87);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPUPA_UPAStatus::operator>>(TUPA_UPAStatus& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPUPA_UPAStatus::operator<<(TUPA_UPAStatus oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPUPA_UPAStatus::s32SetData(TUPA_UPAStatus &tUPA_UPAStatusParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_UPAStatus,(tVoid*)&tUPA_UPAStatusParam, sizeof(TUPA_UPAStatus));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_UPAStatusParam' in function 'dp_tclParkasDPUPA_UPAStatus::vSetData(TUPA_UPAStatus)' could be made const reference
tS32 dp_tclParkasDPUPA_UPAStatus::s32SetData(const TUPA_UPAStatus &tUPA_UPAStatusParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_UPAStatus,(tVoid*)&tUPA_UPAStatusParam, sizeof(TUPA_UPAStatus));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_UPAStatusParam' in function 'dp_tclParkasDPUPA_UPAStatus::vSetData(TUPA_UPAStatus)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPUPA_UPAStatus::u8GetData(TUPA_UPAStatus& tUPA_UPAStatusParam) {  
   vUpdate();
   tUPA_UPAStatusParam = tUPA_UPAStatus;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPUPA_UPAStatus::vSetData(TUPA_UPAStatus &tUPA_UPAStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_UPAStatus,(tVoid*)&tUPA_UPAStatusParam, sizeof(TUPA_UPAStatus));
   vStore();
}//lint !e1746: parameter 'tUPA_UPAStatusParam' in function 'dp_tclParkasDPUPA_UPAStatus::vSetData(TUPA_UPAStatus)' could be made const reference
tVoid dp_tclParkasDPUPA_UPAStatus::vSetData(const TUPA_UPAStatus &tUPA_UPAStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_UPAStatus,(tVoid*)&tUPA_UPAStatusParam, sizeof(TUPA_UPAStatus));
   vStore();
}//lint !e1746: parameter 'tUPA_UPAStatusParam' in function 'dp_tclParkasDPUPA_UPAStatus::vSetData(TUPA_UPAStatus)' could be made const reference
tU8   dp_tclParkasDPUPA_UPAStatus::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPUPA_UPAStatus::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "UPA_UPAStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_UPAStatus::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "UPA_UPAStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_UPAStatus::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: UPA_UPAStatus", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element UPA_UPAStatus has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UPA_UPASensors"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPUPA_UPASensors::dp_tclParkasDPUPA_UPASensors(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tUPA_UPASensors,0,sizeof(TUPA_UPASensors));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPUPA_UPASensors::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("UPA_UPASensors",(tS32) 0xb559eca0);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TUPA_UPASensors)) 
      {
         tUPA_UPASensors = *((TUPA_UPASensors*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPUPA_UPASensors::vStore(tVoid) {
   dp_tclBaseElement myDpElem("UPA_UPASensors", (tS32)0xb559eca0);
   (tVoid)myDpElem.bFillData((tVoid*)&tUPA_UPASensors, (tU32)sizeof(TUPA_UPASensors));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPUPA_UPASensors::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPUPA_UPASensors::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TUPA_UPASensors dp_tclParkasDPUPA_UPASensors::tGetData() {
   vUpdate();
   return tUPA_UPASensors;
};
tS32 dp_tclParkasDPUPA_UPASensors::s32GetData(TUPA_UPASensors& tUPA_UPASensorsParam) { 
   vUpdate();
   tUPA_UPASensorsParam = tUPA_UPASensors;
   return _s32Status;
}
tS32 dp_tclParkasDPUPA_UPASensors::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("UPA_UPASensors", (tS32)0xb559eca0);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPUPA_UPASensors::operator>>(TUPA_UPASensors& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPUPA_UPASensors::operator<<(TUPA_UPASensors oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPUPA_UPASensors::s32SetData(TUPA_UPASensors &tUPA_UPASensorsParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_UPASensors,(tVoid*)&tUPA_UPASensorsParam, sizeof(TUPA_UPASensors));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_UPASensorsParam' in function 'dp_tclParkasDPUPA_UPASensors::vSetData(TUPA_UPASensors)' could be made const reference
tS32 dp_tclParkasDPUPA_UPASensors::s32SetData(const TUPA_UPASensors &tUPA_UPASensorsParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_UPASensors,(tVoid*)&tUPA_UPASensorsParam, sizeof(TUPA_UPASensors));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_UPASensorsParam' in function 'dp_tclParkasDPUPA_UPASensors::vSetData(TUPA_UPASensors)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPUPA_UPASensors::u8GetData(TUPA_UPASensors& tUPA_UPASensorsParam) {  
   vUpdate();
   tUPA_UPASensorsParam = tUPA_UPASensors;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPUPA_UPASensors::vSetData(TUPA_UPASensors &tUPA_UPASensorsParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_UPASensors,(tVoid*)&tUPA_UPASensorsParam, sizeof(TUPA_UPASensors));
   vStore();
}//lint !e1746: parameter 'tUPA_UPASensorsParam' in function 'dp_tclParkasDPUPA_UPASensors::vSetData(TUPA_UPASensors)' could be made const reference
tVoid dp_tclParkasDPUPA_UPASensors::vSetData(const TUPA_UPASensors &tUPA_UPASensorsParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_UPASensors,(tVoid*)&tUPA_UPASensorsParam, sizeof(TUPA_UPASensors));
   vStore();
}//lint !e1746: parameter 'tUPA_UPASensorsParam' in function 'dp_tclParkasDPUPA_UPASensors::vSetData(TUPA_UPASensors)' could be made const reference
tU8   dp_tclParkasDPUPA_UPASensors::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPUPA_UPASensors::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "UPA_UPASensors", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_UPASensors::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "UPA_UPASensors", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_UPASensors::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: UPA_UPASensors", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element UPA_UPASensors has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UPA_UPAHatch"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPUPA_UPAHatch::dp_tclParkasDPUPA_UPAHatch(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tUPA_UPAHatch,0,sizeof(TUPA_UPAHatch));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPUPA_UPAHatch::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("UPA_UPAHatch",(tS32) 0x3036af5b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TUPA_UPAHatch)) 
      {
         tUPA_UPAHatch = *((TUPA_UPAHatch*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPUPA_UPAHatch::vStore(tVoid) {
   dp_tclBaseElement myDpElem("UPA_UPAHatch", (tS32)0x3036af5b);
   (tVoid)myDpElem.bFillData((tVoid*)&tUPA_UPAHatch, (tU32)sizeof(TUPA_UPAHatch));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPUPA_UPAHatch::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPUPA_UPAHatch::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TUPA_UPAHatch dp_tclParkasDPUPA_UPAHatch::tGetData() {
   vUpdate();
   return tUPA_UPAHatch;
};
tS32 dp_tclParkasDPUPA_UPAHatch::s32GetData(TUPA_UPAHatch& tUPA_UPAHatchParam) { 
   vUpdate();
   tUPA_UPAHatchParam = tUPA_UPAHatch;
   return _s32Status;
}
tS32 dp_tclParkasDPUPA_UPAHatch::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("UPA_UPAHatch", (tS32)0x3036af5b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPUPA_UPAHatch::operator>>(TUPA_UPAHatch& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPUPA_UPAHatch::operator<<(TUPA_UPAHatch oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPUPA_UPAHatch::s32SetData(TUPA_UPAHatch &tUPA_UPAHatchParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_UPAHatch,(tVoid*)&tUPA_UPAHatchParam, sizeof(TUPA_UPAHatch));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_UPAHatchParam' in function 'dp_tclParkasDPUPA_UPAHatch::vSetData(TUPA_UPAHatch)' could be made const reference
tS32 dp_tclParkasDPUPA_UPAHatch::s32SetData(const TUPA_UPAHatch &tUPA_UPAHatchParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_UPAHatch,(tVoid*)&tUPA_UPAHatchParam, sizeof(TUPA_UPAHatch));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_UPAHatchParam' in function 'dp_tclParkasDPUPA_UPAHatch::vSetData(TUPA_UPAHatch)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPUPA_UPAHatch::u8GetData(TUPA_UPAHatch& tUPA_UPAHatchParam) {  
   vUpdate();
   tUPA_UPAHatchParam = tUPA_UPAHatch;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPUPA_UPAHatch::vSetData(TUPA_UPAHatch &tUPA_UPAHatchParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_UPAHatch,(tVoid*)&tUPA_UPAHatchParam, sizeof(TUPA_UPAHatch));
   vStore();
}//lint !e1746: parameter 'tUPA_UPAHatchParam' in function 'dp_tclParkasDPUPA_UPAHatch::vSetData(TUPA_UPAHatch)' could be made const reference
tVoid dp_tclParkasDPUPA_UPAHatch::vSetData(const TUPA_UPAHatch &tUPA_UPAHatchParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_UPAHatch,(tVoid*)&tUPA_UPAHatchParam, sizeof(TUPA_UPAHatch));
   vStore();
}//lint !e1746: parameter 'tUPA_UPAHatchParam' in function 'dp_tclParkasDPUPA_UPAHatch::vSetData(TUPA_UPAHatch)' could be made const reference
tU8   dp_tclParkasDPUPA_UPAHatch::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPUPA_UPAHatch::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "UPA_UPAHatch", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_UPAHatch::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "UPA_UPAHatch", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_UPAHatch::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: UPA_UPAHatch", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element UPA_UPAHatch has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UPA_UPAFKPSensors"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPUPA_UPAFKPSensors::dp_tclParkasDPUPA_UPAFKPSensors(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tUPA_UPAFKPSensors,0,sizeof(TUPA_UPAFKPSensors));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPUPA_UPAFKPSensors::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("UPA_UPAFKPSensors",(tS32) 0x8a9e486d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TUPA_UPAFKPSensors)) 
      {
         tUPA_UPAFKPSensors = *((TUPA_UPAFKPSensors*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPUPA_UPAFKPSensors::vStore(tVoid) {
   dp_tclBaseElement myDpElem("UPA_UPAFKPSensors", (tS32)0x8a9e486d);
   (tVoid)myDpElem.bFillData((tVoid*)&tUPA_UPAFKPSensors, (tU32)sizeof(TUPA_UPAFKPSensors));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPUPA_UPAFKPSensors::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPUPA_UPAFKPSensors::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TUPA_UPAFKPSensors dp_tclParkasDPUPA_UPAFKPSensors::tGetData() {
   vUpdate();
   return tUPA_UPAFKPSensors;
};
tS32 dp_tclParkasDPUPA_UPAFKPSensors::s32GetData(TUPA_UPAFKPSensors& tUPA_UPAFKPSensorsParam) { 
   vUpdate();
   tUPA_UPAFKPSensorsParam = tUPA_UPAFKPSensors;
   return _s32Status;
}
tS32 dp_tclParkasDPUPA_UPAFKPSensors::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("UPA_UPAFKPSensors", (tS32)0x8a9e486d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPUPA_UPAFKPSensors::operator>>(TUPA_UPAFKPSensors& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPUPA_UPAFKPSensors::operator<<(TUPA_UPAFKPSensors oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPUPA_UPAFKPSensors::s32SetData(TUPA_UPAFKPSensors &tUPA_UPAFKPSensorsParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_UPAFKPSensors,(tVoid*)&tUPA_UPAFKPSensorsParam, sizeof(TUPA_UPAFKPSensors));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_UPAFKPSensorsParam' in function 'dp_tclParkasDPUPA_UPAFKPSensors::vSetData(TUPA_UPAFKPSensors)' could be made const reference
tS32 dp_tclParkasDPUPA_UPAFKPSensors::s32SetData(const TUPA_UPAFKPSensors &tUPA_UPAFKPSensorsParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_UPAFKPSensors,(tVoid*)&tUPA_UPAFKPSensorsParam, sizeof(TUPA_UPAFKPSensors));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_UPAFKPSensorsParam' in function 'dp_tclParkasDPUPA_UPAFKPSensors::vSetData(TUPA_UPAFKPSensors)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPUPA_UPAFKPSensors::u8GetData(TUPA_UPAFKPSensors& tUPA_UPAFKPSensorsParam) {  
   vUpdate();
   tUPA_UPAFKPSensorsParam = tUPA_UPAFKPSensors;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPUPA_UPAFKPSensors::vSetData(TUPA_UPAFKPSensors &tUPA_UPAFKPSensorsParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_UPAFKPSensors,(tVoid*)&tUPA_UPAFKPSensorsParam, sizeof(TUPA_UPAFKPSensors));
   vStore();
}//lint !e1746: parameter 'tUPA_UPAFKPSensorsParam' in function 'dp_tclParkasDPUPA_UPAFKPSensors::vSetData(TUPA_UPAFKPSensors)' could be made const reference
tVoid dp_tclParkasDPUPA_UPAFKPSensors::vSetData(const TUPA_UPAFKPSensors &tUPA_UPAFKPSensorsParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_UPAFKPSensors,(tVoid*)&tUPA_UPAFKPSensorsParam, sizeof(TUPA_UPAFKPSensors));
   vStore();
}//lint !e1746: parameter 'tUPA_UPAFKPSensorsParam' in function 'dp_tclParkasDPUPA_UPAFKPSensors::vSetData(TUPA_UPAFKPSensors)' could be made const reference
tU8   dp_tclParkasDPUPA_UPAFKPSensors::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPUPA_UPAFKPSensors::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "UPA_UPAFKPSensors", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_UPAFKPSensors::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "UPA_UPAFKPSensors", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_UPAFKPSensors::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: UPA_UPAFKPSensors", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element UPA_UPAFKPSensors has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UPA_UPAFKPScan"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPUPA_UPAFKPScan::dp_tclParkasDPUPA_UPAFKPScan(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tUPA_UPAFKPScan,0,sizeof(TUPA_UPAFKPScan));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPUPA_UPAFKPScan::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("UPA_UPAFKPScan",(tS32) 0xb5553b65);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TUPA_UPAFKPScan)) 
      {
         tUPA_UPAFKPScan = *((TUPA_UPAFKPScan*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPUPA_UPAFKPScan::vStore(tVoid) {
   dp_tclBaseElement myDpElem("UPA_UPAFKPScan", (tS32)0xb5553b65);
   (tVoid)myDpElem.bFillData((tVoid*)&tUPA_UPAFKPScan, (tU32)sizeof(TUPA_UPAFKPScan));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPUPA_UPAFKPScan::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPUPA_UPAFKPScan::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TUPA_UPAFKPScan dp_tclParkasDPUPA_UPAFKPScan::tGetData() {
   vUpdate();
   return tUPA_UPAFKPScan;
};
tS32 dp_tclParkasDPUPA_UPAFKPScan::s32GetData(TUPA_UPAFKPScan& tUPA_UPAFKPScanParam) { 
   vUpdate();
   tUPA_UPAFKPScanParam = tUPA_UPAFKPScan;
   return _s32Status;
}
tS32 dp_tclParkasDPUPA_UPAFKPScan::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("UPA_UPAFKPScan", (tS32)0xb5553b65);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPUPA_UPAFKPScan::operator>>(TUPA_UPAFKPScan& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPUPA_UPAFKPScan::operator<<(TUPA_UPAFKPScan oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPUPA_UPAFKPScan::s32SetData(TUPA_UPAFKPScan &tUPA_UPAFKPScanParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_UPAFKPScan,(tVoid*)&tUPA_UPAFKPScanParam, sizeof(TUPA_UPAFKPScan));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_UPAFKPScanParam' in function 'dp_tclParkasDPUPA_UPAFKPScan::vSetData(TUPA_UPAFKPScan)' could be made const reference
tS32 dp_tclParkasDPUPA_UPAFKPScan::s32SetData(const TUPA_UPAFKPScan &tUPA_UPAFKPScanParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_UPAFKPScan,(tVoid*)&tUPA_UPAFKPScanParam, sizeof(TUPA_UPAFKPScan));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_UPAFKPScanParam' in function 'dp_tclParkasDPUPA_UPAFKPScan::vSetData(TUPA_UPAFKPScan)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPUPA_UPAFKPScan::u8GetData(TUPA_UPAFKPScan& tUPA_UPAFKPScanParam) {  
   vUpdate();
   tUPA_UPAFKPScanParam = tUPA_UPAFKPScan;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPUPA_UPAFKPScan::vSetData(TUPA_UPAFKPScan &tUPA_UPAFKPScanParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_UPAFKPScan,(tVoid*)&tUPA_UPAFKPScanParam, sizeof(TUPA_UPAFKPScan));
   vStore();
}//lint !e1746: parameter 'tUPA_UPAFKPScanParam' in function 'dp_tclParkasDPUPA_UPAFKPScan::vSetData(TUPA_UPAFKPScan)' could be made const reference
tVoid dp_tclParkasDPUPA_UPAFKPScan::vSetData(const TUPA_UPAFKPScan &tUPA_UPAFKPScanParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_UPAFKPScan,(tVoid*)&tUPA_UPAFKPScanParam, sizeof(TUPA_UPAFKPScan));
   vStore();
}//lint !e1746: parameter 'tUPA_UPAFKPScanParam' in function 'dp_tclParkasDPUPA_UPAFKPScan::vSetData(TUPA_UPAFKPScan)' could be made const reference
tU8   dp_tclParkasDPUPA_UPAFKPScan::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPUPA_UPAFKPScan::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "UPA_UPAFKPScan", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_UPAFKPScan::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "UPA_UPAFKPScan", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_UPAFKPScan::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: UPA_UPAFKPScan", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element UPA_UPAFKPScan has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UPA_UPAFKPHatch"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPUPA_UPAFKPHatch::dp_tclParkasDPUPA_UPAFKPHatch(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tUPA_UPAFKPHatch,0,sizeof(TUPA_UPAFKPHatch));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPUPA_UPAFKPHatch::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("UPA_UPAFKPHatch",(tS32) 0x8aaa0f30);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TUPA_UPAFKPHatch)) 
      {
         tUPA_UPAFKPHatch = *((TUPA_UPAFKPHatch*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPUPA_UPAFKPHatch::vStore(tVoid) {
   dp_tclBaseElement myDpElem("UPA_UPAFKPHatch", (tS32)0x8aaa0f30);
   (tVoid)myDpElem.bFillData((tVoid*)&tUPA_UPAFKPHatch, (tU32)sizeof(TUPA_UPAFKPHatch));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPUPA_UPAFKPHatch::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPUPA_UPAFKPHatch::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TUPA_UPAFKPHatch dp_tclParkasDPUPA_UPAFKPHatch::tGetData() {
   vUpdate();
   return tUPA_UPAFKPHatch;
};
tS32 dp_tclParkasDPUPA_UPAFKPHatch::s32GetData(TUPA_UPAFKPHatch& tUPA_UPAFKPHatchParam) { 
   vUpdate();
   tUPA_UPAFKPHatchParam = tUPA_UPAFKPHatch;
   return _s32Status;
}
tS32 dp_tclParkasDPUPA_UPAFKPHatch::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("UPA_UPAFKPHatch", (tS32)0x8aaa0f30);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPUPA_UPAFKPHatch::operator>>(TUPA_UPAFKPHatch& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPUPA_UPAFKPHatch::operator<<(TUPA_UPAFKPHatch oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPUPA_UPAFKPHatch::s32SetData(TUPA_UPAFKPHatch &tUPA_UPAFKPHatchParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_UPAFKPHatch,(tVoid*)&tUPA_UPAFKPHatchParam, sizeof(TUPA_UPAFKPHatch));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_UPAFKPHatchParam' in function 'dp_tclParkasDPUPA_UPAFKPHatch::vSetData(TUPA_UPAFKPHatch)' could be made const reference
tS32 dp_tclParkasDPUPA_UPAFKPHatch::s32SetData(const TUPA_UPAFKPHatch &tUPA_UPAFKPHatchParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_UPAFKPHatch,(tVoid*)&tUPA_UPAFKPHatchParam, sizeof(TUPA_UPAFKPHatch));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_UPAFKPHatchParam' in function 'dp_tclParkasDPUPA_UPAFKPHatch::vSetData(TUPA_UPAFKPHatch)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPUPA_UPAFKPHatch::u8GetData(TUPA_UPAFKPHatch& tUPA_UPAFKPHatchParam) {  
   vUpdate();
   tUPA_UPAFKPHatchParam = tUPA_UPAFKPHatch;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPUPA_UPAFKPHatch::vSetData(TUPA_UPAFKPHatch &tUPA_UPAFKPHatchParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_UPAFKPHatch,(tVoid*)&tUPA_UPAFKPHatchParam, sizeof(TUPA_UPAFKPHatch));
   vStore();
}//lint !e1746: parameter 'tUPA_UPAFKPHatchParam' in function 'dp_tclParkasDPUPA_UPAFKPHatch::vSetData(TUPA_UPAFKPHatch)' could be made const reference
tVoid dp_tclParkasDPUPA_UPAFKPHatch::vSetData(const TUPA_UPAFKPHatch &tUPA_UPAFKPHatchParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_UPAFKPHatch,(tVoid*)&tUPA_UPAFKPHatchParam, sizeof(TUPA_UPAFKPHatch));
   vStore();
}//lint !e1746: parameter 'tUPA_UPAFKPHatchParam' in function 'dp_tclParkasDPUPA_UPAFKPHatch::vSetData(TUPA_UPAFKPHatch)' could be made const reference
tU8   dp_tclParkasDPUPA_UPAFKPHatch::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPUPA_UPAFKPHatch::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "UPA_UPAFKPHatch", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_UPAFKPHatch::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "UPA_UPAFKPHatch", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_UPAFKPHatch::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: UPA_UPAFKPHatch", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element UPA_UPAFKPHatch has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingRearParkAssist"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPSettingRearParkAssist::dp_tclParkasDPSettingRearParkAssist(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingRearParkAssist,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPSettingRearParkAssist::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingRearParkAssist",(tS32) 0x88a16249);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingRearParkAssist = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPSettingRearParkAssist::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingRearParkAssist", (tS32)0x88a16249);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingRearParkAssist, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPSettingRearParkAssist::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPSettingRearParkAssist::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclParkasDPSettingRearParkAssist::tGetData() {
   vUpdate();
   return tSettingRearParkAssist;
};
tS32 dp_tclParkasDPSettingRearParkAssist::s32GetData(tU8& tSettingRearParkAssistParam) { 
   vUpdate();
   tSettingRearParkAssistParam = tSettingRearParkAssist;
   return _s32Status;
}
tS32 dp_tclParkasDPSettingRearParkAssist::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingRearParkAssist", (tS32)0x88a16249);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPSettingRearParkAssist::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPSettingRearParkAssist::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPSettingRearParkAssist::s32SetData(tU8 &tSettingRearParkAssistParam) {
   //init parameter
   (tVoid)memcpy(&tSettingRearParkAssist,(tVoid*)&tSettingRearParkAssistParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingRearParkAssistParam' in function 'dp_tclParkasDPSettingRearParkAssist::vSetData(tU8)' could be made const reference
tS32 dp_tclParkasDPSettingRearParkAssist::s32SetData(const tU8 &tSettingRearParkAssistParam) {
   //init parameter
   (tVoid)memcpy(&tSettingRearParkAssist,(tVoid*)&tSettingRearParkAssistParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingRearParkAssistParam' in function 'dp_tclParkasDPSettingRearParkAssist::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPSettingRearParkAssist::u8GetData(tU8& tSettingRearParkAssistParam) {  
   vUpdate();
   tSettingRearParkAssistParam = tSettingRearParkAssist;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPSettingRearParkAssist::vSetData(tU8 &tSettingRearParkAssistParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingRearParkAssist,(tVoid*)&tSettingRearParkAssistParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingRearParkAssistParam' in function 'dp_tclParkasDPSettingRearParkAssist::vSetData(tU8)' could be made const reference
tVoid dp_tclParkasDPSettingRearParkAssist::vSetData(const tU8 &tSettingRearParkAssistParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingRearParkAssist,(tVoid*)&tSettingRearParkAssistParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingRearParkAssistParam' in function 'dp_tclParkasDPSettingRearParkAssist::vSetData(tU8)' could be made const reference
tU8   dp_tclParkasDPSettingRearParkAssist::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPSettingRearParkAssist::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "SettingRearParkAssist", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSettingRearParkAssist::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "SettingRearParkAssist", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSettingRearParkAssist::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingRearParkAssist", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element SettingRearParkAssist has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingFrontParkAssist"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPSettingFrontParkAssist::dp_tclParkasDPSettingFrontParkAssist(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingFrontParkAssist,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPSettingFrontParkAssist::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingFrontParkAssist",(tS32) 0x222df91c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingFrontParkAssist = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPSettingFrontParkAssist::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingFrontParkAssist", (tS32)0x222df91c);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingFrontParkAssist, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPSettingFrontParkAssist::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPSettingFrontParkAssist::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclParkasDPSettingFrontParkAssist::tGetData() {
   vUpdate();
   return tSettingFrontParkAssist;
};
tS32 dp_tclParkasDPSettingFrontParkAssist::s32GetData(tU8& tSettingFrontParkAssistParam) { 
   vUpdate();
   tSettingFrontParkAssistParam = tSettingFrontParkAssist;
   return _s32Status;
}
tS32 dp_tclParkasDPSettingFrontParkAssist::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingFrontParkAssist", (tS32)0x222df91c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPSettingFrontParkAssist::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPSettingFrontParkAssist::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPSettingFrontParkAssist::s32SetData(tU8 &tSettingFrontParkAssistParam) {
   //init parameter
   (tVoid)memcpy(&tSettingFrontParkAssist,(tVoid*)&tSettingFrontParkAssistParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingFrontParkAssistParam' in function 'dp_tclParkasDPSettingFrontParkAssist::vSetData(tU8)' could be made const reference
tS32 dp_tclParkasDPSettingFrontParkAssist::s32SetData(const tU8 &tSettingFrontParkAssistParam) {
   //init parameter
   (tVoid)memcpy(&tSettingFrontParkAssist,(tVoid*)&tSettingFrontParkAssistParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingFrontParkAssistParam' in function 'dp_tclParkasDPSettingFrontParkAssist::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPSettingFrontParkAssist::u8GetData(tU8& tSettingFrontParkAssistParam) {  
   vUpdate();
   tSettingFrontParkAssistParam = tSettingFrontParkAssist;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPSettingFrontParkAssist::vSetData(tU8 &tSettingFrontParkAssistParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingFrontParkAssist,(tVoid*)&tSettingFrontParkAssistParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingFrontParkAssistParam' in function 'dp_tclParkasDPSettingFrontParkAssist::vSetData(tU8)' could be made const reference
tVoid dp_tclParkasDPSettingFrontParkAssist::vSetData(const tU8 &tSettingFrontParkAssistParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingFrontParkAssist,(tVoid*)&tSettingFrontParkAssistParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingFrontParkAssistParam' in function 'dp_tclParkasDPSettingFrontParkAssist::vSetData(tU8)' could be made const reference
tU8   dp_tclParkasDPSettingFrontParkAssist::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPSettingFrontParkAssist::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "SettingFrontParkAssist", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSettingFrontParkAssist::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "SettingFrontParkAssist", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSettingFrontParkAssist::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingFrontParkAssist", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element SettingFrontParkAssist has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingFKP_Activation"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPSettingFKP_Activation::dp_tclParkasDPSettingFKP_Activation(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingFKP_Activation,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPSettingFKP_Activation::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingFKP_Activation",(tS32) 0x66f25c74);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingFKP_Activation = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPSettingFKP_Activation::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingFKP_Activation", (tS32)0x66f25c74);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingFKP_Activation, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPSettingFKP_Activation::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPSettingFKP_Activation::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclParkasDPSettingFKP_Activation::tGetData() {
   vUpdate();
   return tSettingFKP_Activation;
};
tS32 dp_tclParkasDPSettingFKP_Activation::s32GetData(tU8& tSettingFKP_ActivationParam) { 
   vUpdate();
   tSettingFKP_ActivationParam = tSettingFKP_Activation;
   return _s32Status;
}
tS32 dp_tclParkasDPSettingFKP_Activation::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingFKP_Activation", (tS32)0x66f25c74);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPSettingFKP_Activation::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPSettingFKP_Activation::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPSettingFKP_Activation::s32SetData(tU8 &tSettingFKP_ActivationParam) {
   //init parameter
   (tVoid)memcpy(&tSettingFKP_Activation,(tVoid*)&tSettingFKP_ActivationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingFKP_ActivationParam' in function 'dp_tclParkasDPSettingFKP_Activation::vSetData(tU8)' could be made const reference
tS32 dp_tclParkasDPSettingFKP_Activation::s32SetData(const tU8 &tSettingFKP_ActivationParam) {
   //init parameter
   (tVoid)memcpy(&tSettingFKP_Activation,(tVoid*)&tSettingFKP_ActivationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingFKP_ActivationParam' in function 'dp_tclParkasDPSettingFKP_Activation::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPSettingFKP_Activation::u8GetData(tU8& tSettingFKP_ActivationParam) {  
   vUpdate();
   tSettingFKP_ActivationParam = tSettingFKP_Activation;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPSettingFKP_Activation::vSetData(tU8 &tSettingFKP_ActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingFKP_Activation,(tVoid*)&tSettingFKP_ActivationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingFKP_ActivationParam' in function 'dp_tclParkasDPSettingFKP_Activation::vSetData(tU8)' could be made const reference
tVoid dp_tclParkasDPSettingFKP_Activation::vSetData(const tU8 &tSettingFKP_ActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingFKP_Activation,(tVoid*)&tSettingFKP_ActivationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingFKP_ActivationParam' in function 'dp_tclParkasDPSettingFKP_Activation::vSetData(tU8)' could be made const reference
tU8   dp_tclParkasDPSettingFKP_Activation::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPSettingFKP_Activation::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "SettingFKP_Activation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSettingFKP_Activation::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "SettingFKP_Activation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSettingFKP_Activation::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingFKP_Activation", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element SettingFKP_Activation has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingHFP_DefaultManeuver"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPSettingHFP_DefaultManeuver::dp_tclParkasDPSettingHFP_DefaultManeuver(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingHFP_DefaultManeuver,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPSettingHFP_DefaultManeuver::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingHFP_DefaultManeuver",(tS32) 0xcca5fa07L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingHFP_DefaultManeuver = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPSettingHFP_DefaultManeuver::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingHFP_DefaultManeuver", (tS32)0xcca5fa07L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingHFP_DefaultManeuver, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPSettingHFP_DefaultManeuver::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPSettingHFP_DefaultManeuver::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclParkasDPSettingHFP_DefaultManeuver::tGetData() {
   vUpdate();
   return tSettingHFP_DefaultManeuver;
};
tS32 dp_tclParkasDPSettingHFP_DefaultManeuver::s32GetData(tU8& tSettingHFP_DefaultManeuverParam) { 
   vUpdate();
   tSettingHFP_DefaultManeuverParam = tSettingHFP_DefaultManeuver;
   return _s32Status;
}
tS32 dp_tclParkasDPSettingHFP_DefaultManeuver::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingHFP_DefaultManeuver", (tS32)0xcca5fa07L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPSettingHFP_DefaultManeuver::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPSettingHFP_DefaultManeuver::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPSettingHFP_DefaultManeuver::s32SetData(tU8 &tSettingHFP_DefaultManeuverParam) {
   //init parameter
   (tVoid)memcpy(&tSettingHFP_DefaultManeuver,(tVoid*)&tSettingHFP_DefaultManeuverParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingHFP_DefaultManeuverParam' in function 'dp_tclParkasDPSettingHFP_DefaultManeuver::vSetData(tU8)' could be made const reference
tS32 dp_tclParkasDPSettingHFP_DefaultManeuver::s32SetData(const tU8 &tSettingHFP_DefaultManeuverParam) {
   //init parameter
   (tVoid)memcpy(&tSettingHFP_DefaultManeuver,(tVoid*)&tSettingHFP_DefaultManeuverParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingHFP_DefaultManeuverParam' in function 'dp_tclParkasDPSettingHFP_DefaultManeuver::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPSettingHFP_DefaultManeuver::u8GetData(tU8& tSettingHFP_DefaultManeuverParam) {  
   vUpdate();
   tSettingHFP_DefaultManeuverParam = tSettingHFP_DefaultManeuver;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPSettingHFP_DefaultManeuver::vSetData(tU8 &tSettingHFP_DefaultManeuverParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingHFP_DefaultManeuver,(tVoid*)&tSettingHFP_DefaultManeuverParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingHFP_DefaultManeuverParam' in function 'dp_tclParkasDPSettingHFP_DefaultManeuver::vSetData(tU8)' could be made const reference
tVoid dp_tclParkasDPSettingHFP_DefaultManeuver::vSetData(const tU8 &tSettingHFP_DefaultManeuverParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingHFP_DefaultManeuver,(tVoid*)&tSettingHFP_DefaultManeuverParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingHFP_DefaultManeuverParam' in function 'dp_tclParkasDPSettingHFP_DefaultManeuver::vSetData(tU8)' could be made const reference
tU8   dp_tclParkasDPSettingHFP_DefaultManeuver::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPSettingHFP_DefaultManeuver::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "SettingHFP_DefaultManeuver", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSettingHFP_DefaultManeuver::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "SettingHFP_DefaultManeuver", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSettingHFP_DefaultManeuver::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingHFP_DefaultManeuver", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element SettingHFP_DefaultManeuver has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ParkAssistVolumeState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPParkAssistVolumeState::dp_tclParkasDPParkAssistVolumeState(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tParkAssistVolumeState,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPParkAssistVolumeState::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ParkAssistVolumeState",(tS32) 0x80385322);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tParkAssistVolumeState = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPParkAssistVolumeState::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ParkAssistVolumeState", (tS32)0x80385322);
   (tVoid)myDpElem.bFillData((tVoid*)&tParkAssistVolumeState, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPParkAssistVolumeState::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPParkAssistVolumeState::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclParkasDPParkAssistVolumeState::tGetData() {
   vUpdate();
   return tParkAssistVolumeState;
};
tS32 dp_tclParkasDPParkAssistVolumeState::s32GetData(tU8& tParkAssistVolumeStateParam) { 
   vUpdate();
   tParkAssistVolumeStateParam = tParkAssistVolumeState;
   return _s32Status;
}
tS32 dp_tclParkasDPParkAssistVolumeState::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ParkAssistVolumeState", (tS32)0x80385322);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPParkAssistVolumeState::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPParkAssistVolumeState::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPParkAssistVolumeState::s32SetData(tU8 &tParkAssistVolumeStateParam) {
   //init parameter
   (tVoid)memcpy(&tParkAssistVolumeState,(tVoid*)&tParkAssistVolumeStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tParkAssistVolumeStateParam' in function 'dp_tclParkasDPParkAssistVolumeState::vSetData(tU8)' could be made const reference
tS32 dp_tclParkasDPParkAssistVolumeState::s32SetData(const tU8 &tParkAssistVolumeStateParam) {
   //init parameter
   (tVoid)memcpy(&tParkAssistVolumeState,(tVoid*)&tParkAssistVolumeStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tParkAssistVolumeStateParam' in function 'dp_tclParkasDPParkAssistVolumeState::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPParkAssistVolumeState::u8GetData(tU8& tParkAssistVolumeStateParam) {  
   vUpdate();
   tParkAssistVolumeStateParam = tParkAssistVolumeState;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPParkAssistVolumeState::vSetData(tU8 &tParkAssistVolumeStateParam) { 
   //init parameter
   (tVoid)memcpy(&tParkAssistVolumeState,(tVoid*)&tParkAssistVolumeStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tParkAssistVolumeStateParam' in function 'dp_tclParkasDPParkAssistVolumeState::vSetData(tU8)' could be made const reference
tVoid dp_tclParkasDPParkAssistVolumeState::vSetData(const tU8 &tParkAssistVolumeStateParam) { 
   //init parameter
   (tVoid)memcpy(&tParkAssistVolumeState,(tVoid*)&tParkAssistVolumeStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tParkAssistVolumeStateParam' in function 'dp_tclParkasDPParkAssistVolumeState::vSetData(tU8)' could be made const reference
tU8   dp_tclParkasDPParkAssistVolumeState::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPParkAssistVolumeState::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "ParkAssistVolumeState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPParkAssistVolumeState::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "ParkAssistVolumeState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPParkAssistVolumeState::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ParkAssistVolumeState", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element ParkAssistVolumeState has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UPA_SoundCollectionState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPUPA_SoundCollectionState::dp_tclParkasDPUPA_SoundCollectionState(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tUPA_SoundCollectionState,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPUPA_SoundCollectionState::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("UPA_SoundCollectionState",(tS32) 0x4aa81c97);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tUPA_SoundCollectionState = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPUPA_SoundCollectionState::vStore(tVoid) {
   dp_tclBaseElement myDpElem("UPA_SoundCollectionState", (tS32)0x4aa81c97);
   (tVoid)myDpElem.bFillData((tVoid*)&tUPA_SoundCollectionState, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPUPA_SoundCollectionState::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPUPA_SoundCollectionState::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclParkasDPUPA_SoundCollectionState::tGetData() {
   vUpdate();
   return tUPA_SoundCollectionState;
};
tS32 dp_tclParkasDPUPA_SoundCollectionState::s32GetData(tU8& tUPA_SoundCollectionStateParam) { 
   vUpdate();
   tUPA_SoundCollectionStateParam = tUPA_SoundCollectionState;
   return _s32Status;
}
tS32 dp_tclParkasDPUPA_SoundCollectionState::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("UPA_SoundCollectionState", (tS32)0x4aa81c97);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPUPA_SoundCollectionState::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPUPA_SoundCollectionState::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPUPA_SoundCollectionState::s32SetData(tU8 &tUPA_SoundCollectionStateParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_SoundCollectionState,(tVoid*)&tUPA_SoundCollectionStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_SoundCollectionStateParam' in function 'dp_tclParkasDPUPA_SoundCollectionState::vSetData(tU8)' could be made const reference
tS32 dp_tclParkasDPUPA_SoundCollectionState::s32SetData(const tU8 &tUPA_SoundCollectionStateParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_SoundCollectionState,(tVoid*)&tUPA_SoundCollectionStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_SoundCollectionStateParam' in function 'dp_tclParkasDPUPA_SoundCollectionState::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPUPA_SoundCollectionState::u8GetData(tU8& tUPA_SoundCollectionStateParam) {  
   vUpdate();
   tUPA_SoundCollectionStateParam = tUPA_SoundCollectionState;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPUPA_SoundCollectionState::vSetData(tU8 &tUPA_SoundCollectionStateParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_SoundCollectionState,(tVoid*)&tUPA_SoundCollectionStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tUPA_SoundCollectionStateParam' in function 'dp_tclParkasDPUPA_SoundCollectionState::vSetData(tU8)' could be made const reference
tVoid dp_tclParkasDPUPA_SoundCollectionState::vSetData(const tU8 &tUPA_SoundCollectionStateParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_SoundCollectionState,(tVoid*)&tUPA_SoundCollectionStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tUPA_SoundCollectionStateParam' in function 'dp_tclParkasDPUPA_SoundCollectionState::vSetData(tU8)' could be made const reference
tU8   dp_tclParkasDPUPA_SoundCollectionState::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPUPA_SoundCollectionState::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "UPA_SoundCollectionState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_SoundCollectionState::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "UPA_SoundCollectionState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_SoundCollectionState::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: UPA_SoundCollectionState", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element UPA_SoundCollectionState has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UPA_SoundStatus"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPUPA_SoundStatus::dp_tclParkasDPUPA_SoundStatus(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tUPA_SoundStatus,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPUPA_SoundStatus::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("UPA_SoundStatus",(tS32) 0x8e880f86);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tUPA_SoundStatus = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPUPA_SoundStatus::vStore(tVoid) {
   dp_tclBaseElement myDpElem("UPA_SoundStatus", (tS32)0x8e880f86);
   (tVoid)myDpElem.bFillData((tVoid*)&tUPA_SoundStatus, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPUPA_SoundStatus::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPUPA_SoundStatus::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclParkasDPUPA_SoundStatus::tGetData() {
   vUpdate();
   return tUPA_SoundStatus;
};
tS32 dp_tclParkasDPUPA_SoundStatus::s32GetData(tBool& tUPA_SoundStatusParam) { 
   vUpdate();
   tUPA_SoundStatusParam = tUPA_SoundStatus;
   return _s32Status;
}
tS32 dp_tclParkasDPUPA_SoundStatus::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("UPA_SoundStatus", (tS32)0x8e880f86);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPUPA_SoundStatus::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPUPA_SoundStatus::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPUPA_SoundStatus::s32SetData(tBool &tUPA_SoundStatusParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_SoundStatus,(tVoid*)&tUPA_SoundStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_SoundStatusParam' in function 'dp_tclParkasDPUPA_SoundStatus::vSetData(tBool)' could be made const reference
tS32 dp_tclParkasDPUPA_SoundStatus::s32SetData(const tBool &tUPA_SoundStatusParam) {
   //init parameter
   (tVoid)memcpy(&tUPA_SoundStatus,(tVoid*)&tUPA_SoundStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tUPA_SoundStatusParam' in function 'dp_tclParkasDPUPA_SoundStatus::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPUPA_SoundStatus::u8GetData(tBool& tUPA_SoundStatusParam) {  
   vUpdate();
   tUPA_SoundStatusParam = tUPA_SoundStatus;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPUPA_SoundStatus::vSetData(tBool &tUPA_SoundStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_SoundStatus,(tVoid*)&tUPA_SoundStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tUPA_SoundStatusParam' in function 'dp_tclParkasDPUPA_SoundStatus::vSetData(tBool)' could be made const reference
tVoid dp_tclParkasDPUPA_SoundStatus::vSetData(const tBool &tUPA_SoundStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tUPA_SoundStatus,(tVoid*)&tUPA_SoundStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tUPA_SoundStatusParam' in function 'dp_tclParkasDPUPA_SoundStatus::vSetData(tBool)' could be made const reference
tU8   dp_tclParkasDPUPA_SoundStatus::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPUPA_SoundStatus::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "UPA_SoundStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_SoundStatus::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "UPA_SoundStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPUPA_SoundStatus::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: UPA_SoundStatus", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element UPA_SoundStatus has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingSonarSystemPause"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPSettingSonarSystemPause::dp_tclParkasDPSettingSonarSystemPause(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingSonarSystemPause,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPSettingSonarSystemPause::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingSonarSystemPause",(tS32) 0xbf3f6aa4);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingSonarSystemPause = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPSettingSonarSystemPause::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingSonarSystemPause", (tS32)0xbf3f6aa4);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingSonarSystemPause, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPSettingSonarSystemPause::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPSettingSonarSystemPause::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclParkasDPSettingSonarSystemPause::tGetData() {
   vUpdate();
   return tSettingSonarSystemPause;
};
tS32 dp_tclParkasDPSettingSonarSystemPause::s32GetData(tU8& tSettingSonarSystemPauseParam) { 
   vUpdate();
   tSettingSonarSystemPauseParam = tSettingSonarSystemPause;
   return _s32Status;
}
tS32 dp_tclParkasDPSettingSonarSystemPause::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingSonarSystemPause", (tS32)0xbf3f6aa4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPSettingSonarSystemPause::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPSettingSonarSystemPause::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPSettingSonarSystemPause::s32SetData(tU8 &tSettingSonarSystemPauseParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSonarSystemPause,(tVoid*)&tSettingSonarSystemPauseParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSonarSystemPauseParam' in function 'dp_tclParkasDPSettingSonarSystemPause::vSetData(tU8)' could be made const reference
tS32 dp_tclParkasDPSettingSonarSystemPause::s32SetData(const tU8 &tSettingSonarSystemPauseParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSonarSystemPause,(tVoid*)&tSettingSonarSystemPauseParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSonarSystemPauseParam' in function 'dp_tclParkasDPSettingSonarSystemPause::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPSettingSonarSystemPause::u8GetData(tU8& tSettingSonarSystemPauseParam) {  
   vUpdate();
   tSettingSonarSystemPauseParam = tSettingSonarSystemPause;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPSettingSonarSystemPause::vSetData(tU8 &tSettingSonarSystemPauseParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSonarSystemPause,(tVoid*)&tSettingSonarSystemPauseParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSonarSystemPauseParam' in function 'dp_tclParkasDPSettingSonarSystemPause::vSetData(tU8)' could be made const reference
tVoid dp_tclParkasDPSettingSonarSystemPause::vSetData(const tU8 &tSettingSonarSystemPauseParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSonarSystemPause,(tVoid*)&tSettingSonarSystemPauseParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSonarSystemPauseParam' in function 'dp_tclParkasDPSettingSonarSystemPause::vSetData(tU8)' could be made const reference
tU8   dp_tclParkasDPSettingSonarSystemPause::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPSettingSonarSystemPause::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "SettingSonarSystemPause", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSettingSonarSystemPause::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "SettingSonarSystemPause", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPSettingSonarSystemPause::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingSonarSystemPause", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element SettingSonarSystemPause has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RctaActivation"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPRctaActivation::dp_tclParkasDPRctaActivation(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRctaActivation,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPRctaActivation::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RctaActivation",(tS32) 0x83870004);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tRctaActivation = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPRctaActivation::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RctaActivation", (tS32)0x83870004);
   (tVoid)myDpElem.bFillData((tVoid*)&tRctaActivation, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPRctaActivation::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPRctaActivation::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclParkasDPRctaActivation::tGetData() {
   vUpdate();
   return tRctaActivation;
};
tS32 dp_tclParkasDPRctaActivation::s32GetData(tU8& tRctaActivationParam) { 
   vUpdate();
   tRctaActivationParam = tRctaActivation;
   return _s32Status;
}
tS32 dp_tclParkasDPRctaActivation::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RctaActivation", (tS32)0x83870004);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPRctaActivation::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPRctaActivation::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPRctaActivation::s32SetData(tU8 &tRctaActivationParam) {
   //init parameter
   (tVoid)memcpy(&tRctaActivation,(tVoid*)&tRctaActivationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRctaActivationParam' in function 'dp_tclParkasDPRctaActivation::vSetData(tU8)' could be made const reference
tS32 dp_tclParkasDPRctaActivation::s32SetData(const tU8 &tRctaActivationParam) {
   //init parameter
   (tVoid)memcpy(&tRctaActivation,(tVoid*)&tRctaActivationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRctaActivationParam' in function 'dp_tclParkasDPRctaActivation::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPRctaActivation::u8GetData(tU8& tRctaActivationParam) {  
   vUpdate();
   tRctaActivationParam = tRctaActivation;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPRctaActivation::vSetData(tU8 &tRctaActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tRctaActivation,(tVoid*)&tRctaActivationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRctaActivationParam' in function 'dp_tclParkasDPRctaActivation::vSetData(tU8)' could be made const reference
tVoid dp_tclParkasDPRctaActivation::vSetData(const tU8 &tRctaActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tRctaActivation,(tVoid*)&tRctaActivationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRctaActivationParam' in function 'dp_tclParkasDPRctaActivation::vSetData(tU8)' could be made const reference
tU8   dp_tclParkasDPRctaActivation::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPRctaActivation::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "RctaActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPRctaActivation::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "RctaActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPRctaActivation::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RctaActivation", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element RctaActivation has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RearParkAssistState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPRearParkAssistState::dp_tclParkasDPRearParkAssistState(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRearParkAssistState,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPRearParkAssistState::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RearParkAssistState",(tS32) 0x26a4ce74);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tRearParkAssistState = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPRearParkAssistState::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RearParkAssistState", (tS32)0x26a4ce74);
   (tVoid)myDpElem.bFillData((tVoid*)&tRearParkAssistState, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPRearParkAssistState::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPRearParkAssistState::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclParkasDPRearParkAssistState::tGetData() {
   vUpdate();
   return tRearParkAssistState;
};
tS32 dp_tclParkasDPRearParkAssistState::s32GetData(tU8& tRearParkAssistStateParam) { 
   vUpdate();
   tRearParkAssistStateParam = tRearParkAssistState;
   return _s32Status;
}
tS32 dp_tclParkasDPRearParkAssistState::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RearParkAssistState", (tS32)0x26a4ce74);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPRearParkAssistState::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPRearParkAssistState::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPRearParkAssistState::s32SetData(tU8 &tRearParkAssistStateParam) {
   //init parameter
   (tVoid)memcpy(&tRearParkAssistState,(tVoid*)&tRearParkAssistStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRearParkAssistStateParam' in function 'dp_tclParkasDPRearParkAssistState::vSetData(tU8)' could be made const reference
tS32 dp_tclParkasDPRearParkAssistState::s32SetData(const tU8 &tRearParkAssistStateParam) {
   //init parameter
   (tVoid)memcpy(&tRearParkAssistState,(tVoid*)&tRearParkAssistStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRearParkAssistStateParam' in function 'dp_tclParkasDPRearParkAssistState::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPRearParkAssistState::u8GetData(tU8& tRearParkAssistStateParam) {  
   vUpdate();
   tRearParkAssistStateParam = tRearParkAssistState;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPRearParkAssistState::vSetData(tU8 &tRearParkAssistStateParam) { 
   //init parameter
   (tVoid)memcpy(&tRearParkAssistState,(tVoid*)&tRearParkAssistStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRearParkAssistStateParam' in function 'dp_tclParkasDPRearParkAssistState::vSetData(tU8)' could be made const reference
tVoid dp_tclParkasDPRearParkAssistState::vSetData(const tU8 &tRearParkAssistStateParam) { 
   //init parameter
   (tVoid)memcpy(&tRearParkAssistState,(tVoid*)&tRearParkAssistStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRearParkAssistStateParam' in function 'dp_tclParkasDPRearParkAssistState::vSetData(tU8)' could be made const reference
tU8   dp_tclParkasDPRearParkAssistState::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPRearParkAssistState::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "RearParkAssistState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPRearParkAssistState::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "RearParkAssistState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPRearParkAssistState::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RearParkAssistState", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element RearParkAssistState has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FrontParkAssistState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPFrontParkAssistState::dp_tclParkasDPFrontParkAssistState(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFrontParkAssistState,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPFrontParkAssistState::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("FrontParkAssistState",(tS32) 0xba4dd3db);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tFrontParkAssistState = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPFrontParkAssistState::vStore(tVoid) {
   dp_tclBaseElement myDpElem("FrontParkAssistState", (tS32)0xba4dd3db);
   (tVoid)myDpElem.bFillData((tVoid*)&tFrontParkAssistState, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPFrontParkAssistState::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPFrontParkAssistState::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclParkasDPFrontParkAssistState::tGetData() {
   vUpdate();
   return tFrontParkAssistState;
};
tS32 dp_tclParkasDPFrontParkAssistState::s32GetData(tU8& tFrontParkAssistStateParam) { 
   vUpdate();
   tFrontParkAssistStateParam = tFrontParkAssistState;
   return _s32Status;
}
tS32 dp_tclParkasDPFrontParkAssistState::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("FrontParkAssistState", (tS32)0xba4dd3db);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPFrontParkAssistState::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPFrontParkAssistState::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPFrontParkAssistState::s32SetData(tU8 &tFrontParkAssistStateParam) {
   //init parameter
   (tVoid)memcpy(&tFrontParkAssistState,(tVoid*)&tFrontParkAssistStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFrontParkAssistStateParam' in function 'dp_tclParkasDPFrontParkAssistState::vSetData(tU8)' could be made const reference
tS32 dp_tclParkasDPFrontParkAssistState::s32SetData(const tU8 &tFrontParkAssistStateParam) {
   //init parameter
   (tVoid)memcpy(&tFrontParkAssistState,(tVoid*)&tFrontParkAssistStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFrontParkAssistStateParam' in function 'dp_tclParkasDPFrontParkAssistState::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPFrontParkAssistState::u8GetData(tU8& tFrontParkAssistStateParam) {  
   vUpdate();
   tFrontParkAssistStateParam = tFrontParkAssistState;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPFrontParkAssistState::vSetData(tU8 &tFrontParkAssistStateParam) { 
   //init parameter
   (tVoid)memcpy(&tFrontParkAssistState,(tVoid*)&tFrontParkAssistStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFrontParkAssistStateParam' in function 'dp_tclParkasDPFrontParkAssistState::vSetData(tU8)' could be made const reference
tVoid dp_tclParkasDPFrontParkAssistState::vSetData(const tU8 &tFrontParkAssistStateParam) { 
   //init parameter
   (tVoid)memcpy(&tFrontParkAssistState,(tVoid*)&tFrontParkAssistStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFrontParkAssistStateParam' in function 'dp_tclParkasDPFrontParkAssistState::vSetData(tU8)' could be made const reference
tU8   dp_tclParkasDPFrontParkAssistState::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPFrontParkAssistState::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "FrontParkAssistState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPFrontParkAssistState::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "FrontParkAssistState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPFrontParkAssistState::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: FrontParkAssistState", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element FrontParkAssistState has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FKP_ActivationParkAssistState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclParkasDPFKP_ActivationParkAssistState::dp_tclParkasDPFKP_ActivationParkAssistState(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFKP_ActivationParkAssistState,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclParkasDPFKP_ActivationParkAssistState::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("FKP_ActivationParkAssistState",(tS32) 0x5cf54eb0L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tFKP_ActivationParkAssistState = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclParkasDPFKP_ActivationParkAssistState::vStore(tVoid) {
   dp_tclBaseElement myDpElem("FKP_ActivationParkAssistState", (tS32)0x5cf54eb0L);
   (tVoid)myDpElem.bFillData((tVoid*)&tFKP_ActivationParkAssistState, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclParkasDPFKP_ActivationParkAssistState::s32GetStatus() const {return _s32Status;};
tU8   dp_tclParkasDPFKP_ActivationParkAssistState::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclParkasDPFKP_ActivationParkAssistState::tGetData() {
   vUpdate();
   return tFKP_ActivationParkAssistState;
};
tS32 dp_tclParkasDPFKP_ActivationParkAssistState::s32GetData(tU8& tFKP_ActivationParkAssistStateParam) { 
   vUpdate();
   tFKP_ActivationParkAssistStateParam = tFKP_ActivationParkAssistState;
   return _s32Status;
}
tS32 dp_tclParkasDPFKP_ActivationParkAssistState::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("FKP_ActivationParkAssistState", (tS32)0x5cf54eb0L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_PARKASDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclParkasDPFKP_ActivationParkAssistState::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclParkasDPFKP_ActivationParkAssistState::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclParkasDPFKP_ActivationParkAssistState::s32SetData(tU8 &tFKP_ActivationParkAssistStateParam) {
   //init parameter
   (tVoid)memcpy(&tFKP_ActivationParkAssistState,(tVoid*)&tFKP_ActivationParkAssistStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFKP_ActivationParkAssistStateParam' in function 'dp_tclParkasDPFKP_ActivationParkAssistState::vSetData(tU8)' could be made const reference
tS32 dp_tclParkasDPFKP_ActivationParkAssistState::s32SetData(const tU8 &tFKP_ActivationParkAssistStateParam) {
   //init parameter
   (tVoid)memcpy(&tFKP_ActivationParkAssistState,(tVoid*)&tFKP_ActivationParkAssistStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFKP_ActivationParkAssistStateParam' in function 'dp_tclParkasDPFKP_ActivationParkAssistState::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclParkasDPFKP_ActivationParkAssistState::u8GetData(tU8& tFKP_ActivationParkAssistStateParam) {  
   vUpdate();
   tFKP_ActivationParkAssistStateParam = tFKP_ActivationParkAssistState;
   return _u8DataStatus;
}
tVoid dp_tclParkasDPFKP_ActivationParkAssistState::vSetData(tU8 &tFKP_ActivationParkAssistStateParam) { 
   //init parameter
   (tVoid)memcpy(&tFKP_ActivationParkAssistState,(tVoid*)&tFKP_ActivationParkAssistStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFKP_ActivationParkAssistStateParam' in function 'dp_tclParkasDPFKP_ActivationParkAssistState::vSetData(tU8)' could be made const reference
tVoid dp_tclParkasDPFKP_ActivationParkAssistState::vSetData(const tU8 &tFKP_ActivationParkAssistStateParam) { 
   //init parameter
   (tVoid)memcpy(&tFKP_ActivationParkAssistState,(tVoid*)&tFKP_ActivationParkAssistStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFKP_ActivationParkAssistStateParam' in function 'dp_tclParkasDPFKP_ActivationParkAssistState::vSetData(tU8)' could be made const reference
tU8   dp_tclParkasDPFKP_ActivationParkAssistState::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclParkasDPFKP_ActivationParkAssistState::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_PARKASDP, "FKP_ActivationParkAssistState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPFKP_ActivationParkAssistState::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_PARKASDP, "FKP_ActivationParkAssistState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclParkasDPFKP_ActivationParkAssistState::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: FKP_ActivationParkAssistState", DP_U32_POOL_ID_PARKASDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_PARKASDP);
   }
   else
   {
      fprintf(stdout,"Element FKP_ActivationParkAssistState has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
