
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclFCMcanTcuDp.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DriverUploadPermitDate"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCMcanTcuDpDriverUploadPermitDate::dp_tclFCMcanTcuDpDriverUploadPermitDate(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDriverUploadPermitDate,0,sizeof(TDriverUploadPermitDate));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCMcanTcuDpDriverUploadPermitDate::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DriverUploadPermitDate",(tS32) 0x9763d5d4);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TDriverUploadPermitDate)) 
      {
         tDriverUploadPermitDate = *((TDriverUploadPermitDate*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCMcanTcuDpDriverUploadPermitDate::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DriverUploadPermitDate", (tS32)0x9763d5d4);
   (tVoid)myDpElem.bFillData((tVoid*)&tDriverUploadPermitDate, (tU32)sizeof(TDriverUploadPermitDate));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCMcanTcuDpDriverUploadPermitDate::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCMcanTcuDpDriverUploadPermitDate::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TDriverUploadPermitDate dp_tclFCMcanTcuDpDriverUploadPermitDate::tGetData() {
   vUpdate();
   return tDriverUploadPermitDate;
};
tS32 dp_tclFCMcanTcuDpDriverUploadPermitDate::s32GetData(TDriverUploadPermitDate& tDriverUploadPermitDateParam) { 
   vUpdate();
   tDriverUploadPermitDateParam = tDriverUploadPermitDate;
   return _s32Status;
}
tS32 dp_tclFCMcanTcuDpDriverUploadPermitDate::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DriverUploadPermitDate", (tS32)0x9763d5d4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCMcanTcuDpDriverUploadPermitDate::operator>>(TDriverUploadPermitDate& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCMcanTcuDpDriverUploadPermitDate::operator<<(TDriverUploadPermitDate oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCMcanTcuDpDriverUploadPermitDate::s32SetData(TDriverUploadPermitDate &tDriverUploadPermitDateParam) {
   //init parameter
   (tVoid)memcpy(&tDriverUploadPermitDate,(tVoid*)&tDriverUploadPermitDateParam, sizeof(TDriverUploadPermitDate));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDriverUploadPermitDateParam' in function 'dp_tclFCMcanTcuDpDriverUploadPermitDate::vSetData(TDriverUploadPermitDate)' could be made const reference
tS32 dp_tclFCMcanTcuDpDriverUploadPermitDate::s32SetData(const TDriverUploadPermitDate &tDriverUploadPermitDateParam) {
   //init parameter
   (tVoid)memcpy(&tDriverUploadPermitDate,(tVoid*)&tDriverUploadPermitDateParam, sizeof(TDriverUploadPermitDate));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDriverUploadPermitDateParam' in function 'dp_tclFCMcanTcuDpDriverUploadPermitDate::vSetData(TDriverUploadPermitDate)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCMcanTcuDpDriverUploadPermitDate::u8GetData(TDriverUploadPermitDate& tDriverUploadPermitDateParam) {  
   vUpdate();
   tDriverUploadPermitDateParam = tDriverUploadPermitDate;
   return _u8DataStatus;
}
tVoid dp_tclFCMcanTcuDpDriverUploadPermitDate::vSetData(TDriverUploadPermitDate &tDriverUploadPermitDateParam) { 
   //init parameter
   (tVoid)memcpy(&tDriverUploadPermitDate,(tVoid*)&tDriverUploadPermitDateParam, sizeof(TDriverUploadPermitDate));
   vStore();
}//lint !e1746: parameter 'tDriverUploadPermitDateParam' in function 'dp_tclFCMcanTcuDpDriverUploadPermitDate::vSetData(TDriverUploadPermitDate)' could be made const reference
tVoid dp_tclFCMcanTcuDpDriverUploadPermitDate::vSetData(const TDriverUploadPermitDate &tDriverUploadPermitDateParam) { 
   //init parameter
   (tVoid)memcpy(&tDriverUploadPermitDate,(tVoid*)&tDriverUploadPermitDateParam, sizeof(TDriverUploadPermitDate));
   vStore();
}//lint !e1746: parameter 'tDriverUploadPermitDateParam' in function 'dp_tclFCMcanTcuDpDriverUploadPermitDate::vSetData(TDriverUploadPermitDate)' could be made const reference
tU8   dp_tclFCMcanTcuDpDriverUploadPermitDate::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCMcanTcuDpDriverUploadPermitDate::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCMCANTCUDP, "DriverUploadPermitDate", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCMcanTcuDpDriverUploadPermitDate::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCMCANTCUDP, "DriverUploadPermitDate", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCMcanTcuDpDriverUploadPermitDate::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DriverUploadPermitDate", DP_U32_POOL_ID_FCMCANTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCMCANTCUDP);
   }
   else
   {
      fprintf(stdout,"Element DriverUploadPermitDate has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DriverUploadPermitStatus"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCMcanTcuDpDriverUploadPermitStatus::dp_tclFCMcanTcuDpDriverUploadPermitStatus(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDriverUploadPermitStatus,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCMcanTcuDpDriverUploadPermitStatus::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DriverUploadPermitStatus",(tS32) 0xc8c0c21e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tDriverUploadPermitStatus = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCMcanTcuDpDriverUploadPermitStatus::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DriverUploadPermitStatus", (tS32)0xc8c0c21e);
   (tVoid)myDpElem.bFillData((tVoid*)&tDriverUploadPermitStatus, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCMcanTcuDpDriverUploadPermitStatus::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCMcanTcuDpDriverUploadPermitStatus::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclFCMcanTcuDpDriverUploadPermitStatus::tGetData() {
   vUpdate();
   return tDriverUploadPermitStatus;
};
tS32 dp_tclFCMcanTcuDpDriverUploadPermitStatus::s32GetData(tBool& tDriverUploadPermitStatusParam) { 
   vUpdate();
   tDriverUploadPermitStatusParam = tDriverUploadPermitStatus;
   return _s32Status;
}
tS32 dp_tclFCMcanTcuDpDriverUploadPermitStatus::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DriverUploadPermitStatus", (tS32)0xc8c0c21e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCMcanTcuDpDriverUploadPermitStatus::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCMcanTcuDpDriverUploadPermitStatus::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCMcanTcuDpDriverUploadPermitStatus::s32SetData(tBool &tDriverUploadPermitStatusParam) {
   //init parameter
   (tVoid)memcpy(&tDriverUploadPermitStatus,(tVoid*)&tDriverUploadPermitStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDriverUploadPermitStatusParam' in function 'dp_tclFCMcanTcuDpDriverUploadPermitStatus::vSetData(tBool)' could be made const reference
tS32 dp_tclFCMcanTcuDpDriverUploadPermitStatus::s32SetData(const tBool &tDriverUploadPermitStatusParam) {
   //init parameter
   (tVoid)memcpy(&tDriverUploadPermitStatus,(tVoid*)&tDriverUploadPermitStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDriverUploadPermitStatusParam' in function 'dp_tclFCMcanTcuDpDriverUploadPermitStatus::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCMcanTcuDpDriverUploadPermitStatus::u8GetData(tBool& tDriverUploadPermitStatusParam) {  
   vUpdate();
   tDriverUploadPermitStatusParam = tDriverUploadPermitStatus;
   return _u8DataStatus;
}
tVoid dp_tclFCMcanTcuDpDriverUploadPermitStatus::vSetData(tBool &tDriverUploadPermitStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tDriverUploadPermitStatus,(tVoid*)&tDriverUploadPermitStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tDriverUploadPermitStatusParam' in function 'dp_tclFCMcanTcuDpDriverUploadPermitStatus::vSetData(tBool)' could be made const reference
tVoid dp_tclFCMcanTcuDpDriverUploadPermitStatus::vSetData(const tBool &tDriverUploadPermitStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tDriverUploadPermitStatus,(tVoid*)&tDriverUploadPermitStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tDriverUploadPermitStatusParam' in function 'dp_tclFCMcanTcuDpDriverUploadPermitStatus::vSetData(tBool)' could be made const reference
tU8   dp_tclFCMcanTcuDpDriverUploadPermitStatus::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCMcanTcuDpDriverUploadPermitStatus::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCMCANTCUDP, "DriverUploadPermitStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCMcanTcuDpDriverUploadPermitStatus::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCMCANTCUDP, "DriverUploadPermitStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCMcanTcuDpDriverUploadPermitStatus::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DriverUploadPermitStatus", DP_U32_POOL_ID_FCMCANTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCMCANTCUDP);
   }
   else
   {
      fprintf(stdout,"Element DriverUploadPermitStatus has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PrivacyModeStatus"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCMcanTcuDpPrivacyModeStatus::dp_tclFCMcanTcuDpPrivacyModeStatus(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPrivacyModeStatus,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCMcanTcuDpPrivacyModeStatus::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PrivacyModeStatus",(tS32) 0xe72f4813);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tPrivacyModeStatus = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCMcanTcuDpPrivacyModeStatus::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PrivacyModeStatus", (tS32)0xe72f4813);
   (tVoid)myDpElem.bFillData((tVoid*)&tPrivacyModeStatus, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCMcanTcuDpPrivacyModeStatus::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCMcanTcuDpPrivacyModeStatus::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclFCMcanTcuDpPrivacyModeStatus::tGetData() {
   vUpdate();
   return tPrivacyModeStatus;
};
tS32 dp_tclFCMcanTcuDpPrivacyModeStatus::s32GetData(tBool& tPrivacyModeStatusParam) { 
   vUpdate();
   tPrivacyModeStatusParam = tPrivacyModeStatus;
   return _s32Status;
}
tS32 dp_tclFCMcanTcuDpPrivacyModeStatus::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PrivacyModeStatus", (tS32)0xe72f4813);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCMcanTcuDpPrivacyModeStatus::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCMcanTcuDpPrivacyModeStatus::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCMcanTcuDpPrivacyModeStatus::s32SetData(tBool &tPrivacyModeStatusParam) {
   //init parameter
   (tVoid)memcpy(&tPrivacyModeStatus,(tVoid*)&tPrivacyModeStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPrivacyModeStatusParam' in function 'dp_tclFCMcanTcuDpPrivacyModeStatus::vSetData(tBool)' could be made const reference
tS32 dp_tclFCMcanTcuDpPrivacyModeStatus::s32SetData(const tBool &tPrivacyModeStatusParam) {
   //init parameter
   (tVoid)memcpy(&tPrivacyModeStatus,(tVoid*)&tPrivacyModeStatusParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPrivacyModeStatusParam' in function 'dp_tclFCMcanTcuDpPrivacyModeStatus::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCMcanTcuDpPrivacyModeStatus::u8GetData(tBool& tPrivacyModeStatusParam) {  
   vUpdate();
   tPrivacyModeStatusParam = tPrivacyModeStatus;
   return _u8DataStatus;
}
tVoid dp_tclFCMcanTcuDpPrivacyModeStatus::vSetData(tBool &tPrivacyModeStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tPrivacyModeStatus,(tVoid*)&tPrivacyModeStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tPrivacyModeStatusParam' in function 'dp_tclFCMcanTcuDpPrivacyModeStatus::vSetData(tBool)' could be made const reference
tVoid dp_tclFCMcanTcuDpPrivacyModeStatus::vSetData(const tBool &tPrivacyModeStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tPrivacyModeStatus,(tVoid*)&tPrivacyModeStatusParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tPrivacyModeStatusParam' in function 'dp_tclFCMcanTcuDpPrivacyModeStatus::vSetData(tBool)' could be made const reference
tU8   dp_tclFCMcanTcuDpPrivacyModeStatus::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCMcanTcuDpPrivacyModeStatus::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCMCANTCUDP, "PrivacyModeStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCMcanTcuDpPrivacyModeStatus::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCMCANTCUDP, "PrivacyModeStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCMcanTcuDpPrivacyModeStatus::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PrivacyModeStatus", DP_U32_POOL_ID_FCMCANTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCMCANTCUDP);
   }
   else
   {
      fprintf(stdout,"Element PrivacyModeStatus has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ConnectionHistory"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCMcanTcuDpConnectionHistory::dp_tclFCMcanTcuDpConnectionHistory(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tConnectionHistory,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCMcanTcuDpConnectionHistory::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ConnectionHistory",(tS32) 0xcb661192);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tConnectionHistory = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCMcanTcuDpConnectionHistory::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ConnectionHistory", (tS32)0xcb661192);
   (tVoid)myDpElem.bFillData((tVoid*)&tConnectionHistory, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCMcanTcuDpConnectionHistory::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCMcanTcuDpConnectionHistory::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclFCMcanTcuDpConnectionHistory::tGetData() {
   vUpdate();
   return tConnectionHistory;
};
tS32 dp_tclFCMcanTcuDpConnectionHistory::s32GetData(tBool& tConnectionHistoryParam) { 
   vUpdate();
   tConnectionHistoryParam = tConnectionHistory;
   return _s32Status;
}
tS32 dp_tclFCMcanTcuDpConnectionHistory::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ConnectionHistory", (tS32)0xcb661192);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCMcanTcuDpConnectionHistory::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCMcanTcuDpConnectionHistory::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCMcanTcuDpConnectionHistory::s32SetData(tBool &tConnectionHistoryParam) {
   //init parameter
   (tVoid)memcpy(&tConnectionHistory,(tVoid*)&tConnectionHistoryParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tConnectionHistoryParam' in function 'dp_tclFCMcanTcuDpConnectionHistory::vSetData(tBool)' could be made const reference
tS32 dp_tclFCMcanTcuDpConnectionHistory::s32SetData(const tBool &tConnectionHistoryParam) {
   //init parameter
   (tVoid)memcpy(&tConnectionHistory,(tVoid*)&tConnectionHistoryParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tConnectionHistoryParam' in function 'dp_tclFCMcanTcuDpConnectionHistory::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCMcanTcuDpConnectionHistory::u8GetData(tBool& tConnectionHistoryParam) {  
   vUpdate();
   tConnectionHistoryParam = tConnectionHistory;
   return _u8DataStatus;
}
tVoid dp_tclFCMcanTcuDpConnectionHistory::vSetData(tBool &tConnectionHistoryParam) { 
   //init parameter
   (tVoid)memcpy(&tConnectionHistory,(tVoid*)&tConnectionHistoryParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tConnectionHistoryParam' in function 'dp_tclFCMcanTcuDpConnectionHistory::vSetData(tBool)' could be made const reference
tVoid dp_tclFCMcanTcuDpConnectionHistory::vSetData(const tBool &tConnectionHistoryParam) { 
   //init parameter
   (tVoid)memcpy(&tConnectionHistory,(tVoid*)&tConnectionHistoryParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tConnectionHistoryParam' in function 'dp_tclFCMcanTcuDpConnectionHistory::vSetData(tBool)' could be made const reference
tU8   dp_tclFCMcanTcuDpConnectionHistory::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCMcanTcuDpConnectionHistory::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCMCANTCUDP, "ConnectionHistory", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCMcanTcuDpConnectionHistory::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCMCANTCUDP, "ConnectionHistory", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCMcanTcuDpConnectionHistory::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ConnectionHistory", DP_U32_POOL_ID_FCMCANTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCMCANTCUDP);
   }
   else
   {
      fprintf(stdout,"Element ConnectionHistory has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SimulatedDate"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCMcanTcuDpSimulatedDate::dp_tclFCMcanTcuDpSimulatedDate(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSimulatedDate,0,sizeof(TSimulatedDate));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCMcanTcuDpSimulatedDate::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SimulatedDate",(tS32) 0x39904b86);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TSimulatedDate)) 
      {
         tSimulatedDate = *((TSimulatedDate*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCMcanTcuDpSimulatedDate::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SimulatedDate", (tS32)0x39904b86);
   (tVoid)myDpElem.bFillData((tVoid*)&tSimulatedDate, (tU32)sizeof(TSimulatedDate));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCMcanTcuDpSimulatedDate::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCMcanTcuDpSimulatedDate::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TSimulatedDate dp_tclFCMcanTcuDpSimulatedDate::tGetData() {
   vUpdate();
   return tSimulatedDate;
};
tS32 dp_tclFCMcanTcuDpSimulatedDate::s32GetData(TSimulatedDate& tSimulatedDateParam) { 
   vUpdate();
   tSimulatedDateParam = tSimulatedDate;
   return _s32Status;
}
tS32 dp_tclFCMcanTcuDpSimulatedDate::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SimulatedDate", (tS32)0x39904b86);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCMcanTcuDpSimulatedDate::operator>>(TSimulatedDate& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCMcanTcuDpSimulatedDate::operator<<(TSimulatedDate oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCMcanTcuDpSimulatedDate::s32SetData(TSimulatedDate &tSimulatedDateParam) {
   //init parameter
   (tVoid)memcpy(&tSimulatedDate,(tVoid*)&tSimulatedDateParam, sizeof(TSimulatedDate));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSimulatedDateParam' in function 'dp_tclFCMcanTcuDpSimulatedDate::vSetData(TSimulatedDate)' could be made const reference
tS32 dp_tclFCMcanTcuDpSimulatedDate::s32SetData(const TSimulatedDate &tSimulatedDateParam) {
   //init parameter
   (tVoid)memcpy(&tSimulatedDate,(tVoid*)&tSimulatedDateParam, sizeof(TSimulatedDate));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSimulatedDateParam' in function 'dp_tclFCMcanTcuDpSimulatedDate::vSetData(TSimulatedDate)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCMcanTcuDpSimulatedDate::u8GetData(TSimulatedDate& tSimulatedDateParam) {  
   vUpdate();
   tSimulatedDateParam = tSimulatedDate;
   return _u8DataStatus;
}
tVoid dp_tclFCMcanTcuDpSimulatedDate::vSetData(TSimulatedDate &tSimulatedDateParam) { 
   //init parameter
   (tVoid)memcpy(&tSimulatedDate,(tVoid*)&tSimulatedDateParam, sizeof(TSimulatedDate));
   vStore();
}//lint !e1746: parameter 'tSimulatedDateParam' in function 'dp_tclFCMcanTcuDpSimulatedDate::vSetData(TSimulatedDate)' could be made const reference
tVoid dp_tclFCMcanTcuDpSimulatedDate::vSetData(const TSimulatedDate &tSimulatedDateParam) { 
   //init parameter
   (tVoid)memcpy(&tSimulatedDate,(tVoid*)&tSimulatedDateParam, sizeof(TSimulatedDate));
   vStore();
}//lint !e1746: parameter 'tSimulatedDateParam' in function 'dp_tclFCMcanTcuDpSimulatedDate::vSetData(TSimulatedDate)' could be made const reference
tU8   dp_tclFCMcanTcuDpSimulatedDate::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCMcanTcuDpSimulatedDate::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCMCANTCUDP, "SimulatedDate", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCMcanTcuDpSimulatedDate::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCMCANTCUDP, "SimulatedDate", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCMcanTcuDpSimulatedDate::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SimulatedDate", DP_U32_POOL_ID_FCMCANTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCMCANTCUDP);
   }
   else
   {
      fprintf(stdout,"Element SimulatedDate has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DistanceUnit"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCMcanTcuDpDistanceUnit::dp_tclFCMcanTcuDpDistanceUnit(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDistanceUnit,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFCMcanTcuDpDistanceUnit::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DistanceUnit",(tS32) 0x13b09ae7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDistanceUnit = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFCMcanTcuDpDistanceUnit::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DistanceUnit", (tS32)0x13b09ae7);
   (tVoid)myDpElem.bFillData((tVoid*)&tDistanceUnit, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFCMcanTcuDpDistanceUnit::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFCMcanTcuDpDistanceUnit::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclFCMcanTcuDpDistanceUnit::tGetData() {
   vUpdate();
   return tDistanceUnit;
};
tS32 dp_tclFCMcanTcuDpDistanceUnit::s32GetData(tU8& tDistanceUnitParam) { 
   vUpdate();
   tDistanceUnitParam = tDistanceUnit;
   return _s32Status;
}
tS32 dp_tclFCMcanTcuDpDistanceUnit::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DistanceUnit", (tS32)0x13b09ae7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFCMcanTcuDpDistanceUnit::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFCMcanTcuDpDistanceUnit::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFCMcanTcuDpDistanceUnit::s32SetData(tU8 &tDistanceUnitParam) {
   //init parameter
   (tVoid)memcpy(&tDistanceUnit,(tVoid*)&tDistanceUnitParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDistanceUnitParam' in function 'dp_tclFCMcanTcuDpDistanceUnit::vSetData(tU8)' could be made const reference
tS32 dp_tclFCMcanTcuDpDistanceUnit::s32SetData(const tU8 &tDistanceUnitParam) {
   //init parameter
   (tVoid)memcpy(&tDistanceUnit,(tVoid*)&tDistanceUnitParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDistanceUnitParam' in function 'dp_tclFCMcanTcuDpDistanceUnit::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclFCMcanTcuDpDistanceUnit::u8GetData(tU8& tDistanceUnitParam) {  
   vUpdate();
   tDistanceUnitParam = tDistanceUnit;
   return _u8DataStatus;
}
tVoid dp_tclFCMcanTcuDpDistanceUnit::vSetData(tU8 &tDistanceUnitParam) { 
   //init parameter
   (tVoid)memcpy(&tDistanceUnit,(tVoid*)&tDistanceUnitParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDistanceUnitParam' in function 'dp_tclFCMcanTcuDpDistanceUnit::vSetData(tU8)' could be made const reference
tVoid dp_tclFCMcanTcuDpDistanceUnit::vSetData(const tU8 &tDistanceUnitParam) { 
   //init parameter
   (tVoid)memcpy(&tDistanceUnit,(tVoid*)&tDistanceUnitParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDistanceUnitParam' in function 'dp_tclFCMcanTcuDpDistanceUnit::vSetData(tU8)' could be made const reference
tU8   dp_tclFCMcanTcuDpDistanceUnit::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFCMcanTcuDpDistanceUnit::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FCMCANTCUDP, "DistanceUnit", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCMcanTcuDpDistanceUnit::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FCMCANTCUDP, "DistanceUnit", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFCMcanTcuDpDistanceUnit::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DistanceUnit", DP_U32_POOL_ID_FCMCANTCUDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FCMCANTCUDP);
   }
   else
   {
      fprintf(stdout,"Element DistanceUnit has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MapVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFCMcanTcuDpMapVersion::dp_tclFCMcanTcuDpMapVersion(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclFCMcanTcuDpMapVersion::s32SetData(tString &tMapVersionParam) {
   tU32 u32Len = (tU32)strlen(tMapVersionParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("MapVersion", (tS32)0xbd92294);
      (tVoid)myDpElem.bFillData((tVoid*)tMapVersionParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCMcanTcuDpMapVersion::s32SetData(const tString &tMapVersionParam) {
   tU32 u32Len = (tU32)strlen(tMapVersionParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("MapVersion", (tS32)0xbd92294);
      (tVoid)myDpElem.bFillData((tVoid*)tMapVersionParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclFCMcanTcuDpMapVersion::s32GetData(tString &tMapVersionParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("MapVersion", (tS32)0xbd92294);
   (tVoid)memset(tMapVersionParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tMapVersionParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclFCMcanTcuDpMapVersion::s32GetData(const tString &tMapVersionParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("MapVersion", (tS32)0xbd92294);
   (tVoid)memset(tMapVersionParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FCMCANTCUDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tMapVersionParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclFCMcanTcuDpMapVersion::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclFCMcanTcuDpMapVersion::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclFCMcanTcuDpMapVersion::u32GetData(tString &tMapVersionParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tMapVersionParam, u32StringBufLen);
   };
    tU32  dp_tclFCMcanTcuDpMapVersion::u32GetData(const tString &tMapVersionParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tMapVersionParam, u32StringBufLen);
   };
   tVoid dp_tclFCMcanTcuDpMapVersion::vSetData(tString &tMapVersionParam){(tVoid)s32SetData(tMapVersionParam);};
   tVoid dp_tclFCMcanTcuDpMapVersion::vSetData(const tString &tMapVersionParam){(tVoid)s32SetData(tMapVersionParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclFCMcanTcuDpMapVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_FCMCANTCUDP, "MapVersion", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCMcanTcuDpMapVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_FCMCANTCUDP, "MapVersion", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclFCMcanTcuDpMapVersion::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MapVersion", DP_U32_POOL_ID_FCMCANTCUDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_FCMCANTCUDP);
		}
		else
		{
			fprintf(stdout,"Element MapVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


tU8 dp_tclFCMcanTcuDpTcuHw::u8GetData(tString &tTcuHwParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("TCUHW", tTcuHwParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclFCMcanTcuDpTcuHw::u8GetData(const tString &tTcuHwParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("TCUHW", tTcuHwParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclFCMcanTcuDpTcuHw::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclFCMcanTcuDpTcuHw::vSetData(tString &tTcuHwParam) {
   tU32 u32Len = (tU32)strlen(tTcuHwParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("TCUHW", tTcuHwParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclFCMcanTcuDpTcuHw::vSetData(const tString &tTcuHwParam) {
   tU32 u32Len = (tU32)strlen(tTcuHwParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("TCUHW", tTcuHwParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclFCMcanTcuDpTcuHw::vSetData(tString &tTcuHwParam, tU16 u16Len) 
{
    vSetData(tTcuHwParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclFCMcanTcuDpTcuHw::vSetData(const tString &tTcuHwParam, tU16 u16Len) 
{
    vSetData(tTcuHwParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclFCMcanTcuDpTcuSw::u8GetData(tString &tTcuSwParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("TCUSW", tTcuSwParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclFCMcanTcuDpTcuSw::u8GetData(const tString &tTcuSwParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("TCUSW", tTcuSwParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclFCMcanTcuDpTcuSw::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclFCMcanTcuDpTcuSw::vSetData(tString &tTcuSwParam) {
   tU32 u32Len = (tU32)strlen(tTcuSwParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("TCUSW", tTcuSwParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclFCMcanTcuDpTcuSw::vSetData(const tString &tTcuSwParam) {
   tU32 u32Len = (tU32)strlen(tTcuSwParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("TCUSW", tTcuSwParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclFCMcanTcuDpTcuSw::vSetData(tString &tTcuSwParam, tU16 u16Len) 
{
    vSetData(tTcuSwParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclFCMcanTcuDpTcuSw::vSetData(const tString &tTcuSwParam, tU16 u16Len) 
{
    vSetData(tTcuSwParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced

