#ifndef _DP_FI_THMDPPDD_H
#define _DP_FI_THMDPPDD_H

extern tVoid vInitThmDpPDD(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclThmDpPDDPDD_THM_Version{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_Version;
   
public:
   dp_tclThmDpPDDPDD_THM_Version(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_Version() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_VersionParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_VersionParam);
   tS32  s32SetData(const tU16 &tPDD_THM_VersionParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_VersionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_VersionParam);
   tVoid vSetData(const tU16& tPDD_THM_VersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_SensorID_1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_SensorID_1;
   
public:
   dp_tclThmDpPDDPDD_THM_SensorID_1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_SensorID_1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_SensorID_1Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_SensorID_1Param);
   tS32  s32SetData(const tU8 &tPDD_THM_SensorID_1Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_SensorID_1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_SensorID_1Param);
   tVoid vSetData(const tU8& tPDD_THM_SensorID_1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_MaximumTemperature_1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_MaximumTemperature_1;
   
public:
   dp_tclThmDpPDDPDD_THM_MaximumTemperature_1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_MaximumTemperature_1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_MaximumTemperature_1Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_MaximumTemperature_1Param);
   tS32  s32SetData(const tS16 &tPDD_THM_MaximumTemperature_1Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_MaximumTemperature_1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_MaximumTemperature_1Param);
   tVoid vSetData(const tS16& tPDD_THM_MaximumTemperature_1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_MinimumTemperature_1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_MinimumTemperature_1;
   
public:
   dp_tclThmDpPDDPDD_THM_MinimumTemperature_1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_MinimumTemperature_1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_MinimumTemperature_1Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_MinimumTemperature_1Param);
   tS32  s32SetData(const tS16 &tPDD_THM_MinimumTemperature_1Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_MinimumTemperature_1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_MinimumTemperature_1Param);
   tVoid vSetData(const tS16& tPDD_THM_MinimumTemperature_1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_CriticalHighTemperature_1;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_CriticalHighTemperature_1Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_CriticalHighTemperature_1Param);
   tS32  s32SetData(const tS16 &tPDD_THM_CriticalHighTemperature_1Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_CriticalHighTemperature_1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_CriticalHighTemperature_1Param);
   tVoid vSetData(const tS16& tPDD_THM_CriticalHighTemperature_1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_CriticalHighTemperatureHysteresis_1;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_1Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_1Param);
   tS32  s32SetData(const tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_1Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_1Param);
   tVoid vSetData(const tU8& tPDD_THM_CriticalHighTemperatureHysteresis_1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_CriticalHighTemperatureTimeDelay_1;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_1Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_1Param);
   tS32  s32SetData(const tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_1Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_1Param);
   tVoid vSetData(const tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_HighTemperature_1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_HighTemperature_1;
   
public:
   dp_tclThmDpPDDPDD_THM_HighTemperature_1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_HighTemperature_1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_HighTemperature_1Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_HighTemperature_1Param);
   tS32  s32SetData(const tS16 &tPDD_THM_HighTemperature_1Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_HighTemperature_1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_HighTemperature_1Param);
   tVoid vSetData(const tS16& tPDD_THM_HighTemperature_1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_HighTemperatureHysteresis_1;
   
public:
   dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_HighTemperatureHysteresis_1Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_HighTemperatureHysteresis_1Param);
   tS32  s32SetData(const tU8 &tPDD_THM_HighTemperatureHysteresis_1Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_HighTemperatureHysteresis_1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_HighTemperatureHysteresis_1Param);
   tVoid vSetData(const tU8& tPDD_THM_HighTemperatureHysteresis_1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_HighTemperatureTimeDelay_1;
   
public:
   dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_1Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_HighTemperatureTimeDelay_1Param);
   tS32  s32SetData(const tU16 &tPDD_THM_HighTemperatureTimeDelay_1Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_HighTemperatureTimeDelay_1Param);
   tVoid vSetData(const tU16& tPDD_THM_HighTemperatureTimeDelay_1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_LowTemperature_1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_LowTemperature_1;
   
public:
   dp_tclThmDpPDDPDD_THM_LowTemperature_1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_LowTemperature_1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_LowTemperature_1Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_LowTemperature_1Param);
   tS32  s32SetData(const tS16 &tPDD_THM_LowTemperature_1Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_LowTemperature_1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_LowTemperature_1Param);
   tVoid vSetData(const tS16& tPDD_THM_LowTemperature_1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_LowTemperatureHysteresis_1;
   
public:
   dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_LowTemperatureHysteresis_1Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_LowTemperatureHysteresis_1Param);
   tS32  s32SetData(const tU8 &tPDD_THM_LowTemperatureHysteresis_1Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_LowTemperatureHysteresis_1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_LowTemperatureHysteresis_1Param);
   tVoid vSetData(const tU8& tPDD_THM_LowTemperatureHysteresis_1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_LowTemperatureTimeDelay_1;
   
public:
   dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_1Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_LowTemperatureTimeDelay_1Param);
   tS32  s32SetData(const tU16 &tPDD_THM_LowTemperatureTimeDelay_1Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_LowTemperatureTimeDelay_1Param);
   tVoid vSetData(const tU16& tPDD_THM_LowTemperatureTimeDelay_1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_CriticalLowTemperature_1;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_CriticalLowTemperature_1Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_CriticalLowTemperature_1Param);
   tS32  s32SetData(const tS16 &tPDD_THM_CriticalLowTemperature_1Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_CriticalLowTemperature_1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_CriticalLowTemperature_1Param);
   tVoid vSetData(const tS16& tPDD_THM_CriticalLowTemperature_1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_CriticalLowTemperatureHysteresis_1;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_1Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_1Param);
   tS32  s32SetData(const tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_1Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_1Param);
   tVoid vSetData(const tU8& tPDD_THM_CriticalLowTemperatureHysteresis_1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_CriticalLowTemperatureTimeDelay_1;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_1Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_1Param);
   tS32  s32SetData(const tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_1Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_1Param);
   tVoid vSetData(const tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_SensorID_2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_SensorID_2;
   
public:
   dp_tclThmDpPDDPDD_THM_SensorID_2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_SensorID_2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_SensorID_2Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_SensorID_2Param);
   tS32  s32SetData(const tU8 &tPDD_THM_SensorID_2Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_SensorID_2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_SensorID_2Param);
   tVoid vSetData(const tU8& tPDD_THM_SensorID_2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_MaximumTemperature_2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_MaximumTemperature_2;
   
public:
   dp_tclThmDpPDDPDD_THM_MaximumTemperature_2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_MaximumTemperature_2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_MaximumTemperature_2Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_MaximumTemperature_2Param);
   tS32  s32SetData(const tS16 &tPDD_THM_MaximumTemperature_2Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_MaximumTemperature_2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_MaximumTemperature_2Param);
   tVoid vSetData(const tS16& tPDD_THM_MaximumTemperature_2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_MinimumTemperature_2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_MinimumTemperature_2;
   
public:
   dp_tclThmDpPDDPDD_THM_MinimumTemperature_2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_MinimumTemperature_2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_MinimumTemperature_2Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_MinimumTemperature_2Param);
   tS32  s32SetData(const tS16 &tPDD_THM_MinimumTemperature_2Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_MinimumTemperature_2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_MinimumTemperature_2Param);
   tVoid vSetData(const tS16& tPDD_THM_MinimumTemperature_2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_CriticalHighTemperature_2;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_CriticalHighTemperature_2Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_CriticalHighTemperature_2Param);
   tS32  s32SetData(const tS16 &tPDD_THM_CriticalHighTemperature_2Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_CriticalHighTemperature_2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_CriticalHighTemperature_2Param);
   tVoid vSetData(const tS16& tPDD_THM_CriticalHighTemperature_2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_CriticalHighTemperatureHysteresis_2;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_2Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_2Param);
   tS32  s32SetData(const tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_2Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_2Param);
   tVoid vSetData(const tU8& tPDD_THM_CriticalHighTemperatureHysteresis_2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_CriticalHighTemperatureTimeDelay_2;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_2Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_2Param);
   tS32  s32SetData(const tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_2Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_2Param);
   tVoid vSetData(const tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_HighTemperature_2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_HighTemperature_2;
   
public:
   dp_tclThmDpPDDPDD_THM_HighTemperature_2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_HighTemperature_2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_HighTemperature_2Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_HighTemperature_2Param);
   tS32  s32SetData(const tS16 &tPDD_THM_HighTemperature_2Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_HighTemperature_2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_HighTemperature_2Param);
   tVoid vSetData(const tS16& tPDD_THM_HighTemperature_2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_HighTemperatureHysteresis_2;
   
public:
   dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_HighTemperatureHysteresis_2Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_HighTemperatureHysteresis_2Param);
   tS32  s32SetData(const tU8 &tPDD_THM_HighTemperatureHysteresis_2Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_HighTemperatureHysteresis_2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_HighTemperatureHysteresis_2Param);
   tVoid vSetData(const tU8& tPDD_THM_HighTemperatureHysteresis_2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_HighTemperatureTimeDelay_2;
   
public:
   dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_2Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_HighTemperatureTimeDelay_2Param);
   tS32  s32SetData(const tU16 &tPDD_THM_HighTemperatureTimeDelay_2Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_HighTemperatureTimeDelay_2Param);
   tVoid vSetData(const tU16& tPDD_THM_HighTemperatureTimeDelay_2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_LowTemperature_2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_LowTemperature_2;
   
public:
   dp_tclThmDpPDDPDD_THM_LowTemperature_2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_LowTemperature_2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_LowTemperature_2Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_LowTemperature_2Param);
   tS32  s32SetData(const tS16 &tPDD_THM_LowTemperature_2Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_LowTemperature_2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_LowTemperature_2Param);
   tVoid vSetData(const tS16& tPDD_THM_LowTemperature_2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_LowTemperatureHysteresis_2;
   
public:
   dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_LowTemperatureHysteresis_2Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_LowTemperatureHysteresis_2Param);
   tS32  s32SetData(const tU8 &tPDD_THM_LowTemperatureHysteresis_2Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_LowTemperatureHysteresis_2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_LowTemperatureHysteresis_2Param);
   tVoid vSetData(const tU8& tPDD_THM_LowTemperatureHysteresis_2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_LowTemperatureTimeDelay_2;
   
public:
   dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_2Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_LowTemperatureTimeDelay_2Param);
   tS32  s32SetData(const tU16 &tPDD_THM_LowTemperatureTimeDelay_2Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_LowTemperatureTimeDelay_2Param);
   tVoid vSetData(const tU16& tPDD_THM_LowTemperatureTimeDelay_2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_CriticalLowTemperature_2;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_CriticalLowTemperature_2Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_CriticalLowTemperature_2Param);
   tS32  s32SetData(const tS16 &tPDD_THM_CriticalLowTemperature_2Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_CriticalLowTemperature_2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_CriticalLowTemperature_2Param);
   tVoid vSetData(const tS16& tPDD_THM_CriticalLowTemperature_2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_CriticalLowTemperatureHysteresis_2;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_2Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_2Param);
   tS32  s32SetData(const tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_2Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_2Param);
   tVoid vSetData(const tU8& tPDD_THM_CriticalLowTemperatureHysteresis_2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_CriticalLowTemperatureTimeDelay_2;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_2Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_2Param);
   tS32  s32SetData(const tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_2Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_2Param);
   tVoid vSetData(const tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_SensorID_3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_SensorID_3;
   
public:
   dp_tclThmDpPDDPDD_THM_SensorID_3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_SensorID_3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_SensorID_3Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_SensorID_3Param);
   tS32  s32SetData(const tU8 &tPDD_THM_SensorID_3Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_SensorID_3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_SensorID_3Param);
   tVoid vSetData(const tU8& tPDD_THM_SensorID_3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_MaximumTemperature_3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_MaximumTemperature_3;
   
public:
   dp_tclThmDpPDDPDD_THM_MaximumTemperature_3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_MaximumTemperature_3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_MaximumTemperature_3Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_MaximumTemperature_3Param);
   tS32  s32SetData(const tS16 &tPDD_THM_MaximumTemperature_3Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_MaximumTemperature_3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_MaximumTemperature_3Param);
   tVoid vSetData(const tS16& tPDD_THM_MaximumTemperature_3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_MinimumTemperature_3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_MinimumTemperature_3;
   
public:
   dp_tclThmDpPDDPDD_THM_MinimumTemperature_3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_MinimumTemperature_3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_MinimumTemperature_3Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_MinimumTemperature_3Param);
   tS32  s32SetData(const tS16 &tPDD_THM_MinimumTemperature_3Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_MinimumTemperature_3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_MinimumTemperature_3Param);
   tVoid vSetData(const tS16& tPDD_THM_MinimumTemperature_3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_CriticalHighTemperature_3;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_CriticalHighTemperature_3Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_CriticalHighTemperature_3Param);
   tS32  s32SetData(const tS16 &tPDD_THM_CriticalHighTemperature_3Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_CriticalHighTemperature_3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_CriticalHighTemperature_3Param);
   tVoid vSetData(const tS16& tPDD_THM_CriticalHighTemperature_3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_CriticalHighTemperatureHysteresis_3;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_3Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_3Param);
   tS32  s32SetData(const tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_3Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_3Param);
   tVoid vSetData(const tU8& tPDD_THM_CriticalHighTemperatureHysteresis_3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_CriticalHighTemperatureTimeDelay_3;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_3Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_3Param);
   tS32  s32SetData(const tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_3Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_3Param);
   tVoid vSetData(const tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_HighTemperature_3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_HighTemperature_3;
   
public:
   dp_tclThmDpPDDPDD_THM_HighTemperature_3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_HighTemperature_3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_HighTemperature_3Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_HighTemperature_3Param);
   tS32  s32SetData(const tS16 &tPDD_THM_HighTemperature_3Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_HighTemperature_3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_HighTemperature_3Param);
   tVoid vSetData(const tS16& tPDD_THM_HighTemperature_3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_HighTemperatureHysteresis_3;
   
public:
   dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_HighTemperatureHysteresis_3Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_HighTemperatureHysteresis_3Param);
   tS32  s32SetData(const tU8 &tPDD_THM_HighTemperatureHysteresis_3Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_HighTemperatureHysteresis_3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_HighTemperatureHysteresis_3Param);
   tVoid vSetData(const tU8& tPDD_THM_HighTemperatureHysteresis_3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_HighTemperatureTimeDelay_3;
   
public:
   dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_3Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_HighTemperatureTimeDelay_3Param);
   tS32  s32SetData(const tU16 &tPDD_THM_HighTemperatureTimeDelay_3Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_HighTemperatureTimeDelay_3Param);
   tVoid vSetData(const tU16& tPDD_THM_HighTemperatureTimeDelay_3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_LowTemperature_3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_LowTemperature_3;
   
public:
   dp_tclThmDpPDDPDD_THM_LowTemperature_3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_LowTemperature_3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_LowTemperature_3Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_LowTemperature_3Param);
   tS32  s32SetData(const tS16 &tPDD_THM_LowTemperature_3Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_LowTemperature_3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_LowTemperature_3Param);
   tVoid vSetData(const tS16& tPDD_THM_LowTemperature_3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_LowTemperatureHysteresis_3;
   
public:
   dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_LowTemperatureHysteresis_3Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_LowTemperatureHysteresis_3Param);
   tS32  s32SetData(const tU8 &tPDD_THM_LowTemperatureHysteresis_3Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_LowTemperatureHysteresis_3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_LowTemperatureHysteresis_3Param);
   tVoid vSetData(const tU8& tPDD_THM_LowTemperatureHysteresis_3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_LowTemperatureTimeDelay_3;
   
public:
   dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_3Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_LowTemperatureTimeDelay_3Param);
   tS32  s32SetData(const tU16 &tPDD_THM_LowTemperatureTimeDelay_3Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_LowTemperatureTimeDelay_3Param);
   tVoid vSetData(const tU16& tPDD_THM_LowTemperatureTimeDelay_3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_CriticalLowTemperature_3;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_CriticalLowTemperature_3Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_CriticalLowTemperature_3Param);
   tS32  s32SetData(const tS16 &tPDD_THM_CriticalLowTemperature_3Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_CriticalLowTemperature_3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_CriticalLowTemperature_3Param);
   tVoid vSetData(const tS16& tPDD_THM_CriticalLowTemperature_3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_CriticalLowTemperatureHysteresis_3;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_3Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_3Param);
   tS32  s32SetData(const tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_3Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_3Param);
   tVoid vSetData(const tU8& tPDD_THM_CriticalLowTemperatureHysteresis_3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_CriticalLowTemperatureTimeDelay_3;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_3Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_3Param);
   tS32  s32SetData(const tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_3Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_3Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_3Param);
   tVoid vSetData(const tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_3Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_SensorID_4{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_SensorID_4;
   
public:
   dp_tclThmDpPDDPDD_THM_SensorID_4(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_SensorID_4() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_SensorID_4Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_SensorID_4Param);
   tS32  s32SetData(const tU8 &tPDD_THM_SensorID_4Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_SensorID_4Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_SensorID_4Param);
   tVoid vSetData(const tU8& tPDD_THM_SensorID_4Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_MaximumTemperature_4{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_MaximumTemperature_4;
   
public:
   dp_tclThmDpPDDPDD_THM_MaximumTemperature_4(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_MaximumTemperature_4() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_MaximumTemperature_4Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_MaximumTemperature_4Param);
   tS32  s32SetData(const tS16 &tPDD_THM_MaximumTemperature_4Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_MaximumTemperature_4Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_MaximumTemperature_4Param);
   tVoid vSetData(const tS16& tPDD_THM_MaximumTemperature_4Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_MinimumTemperature_4{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_MinimumTemperature_4;
   
public:
   dp_tclThmDpPDDPDD_THM_MinimumTemperature_4(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_MinimumTemperature_4() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_MinimumTemperature_4Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_MinimumTemperature_4Param);
   tS32  s32SetData(const tS16 &tPDD_THM_MinimumTemperature_4Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_MinimumTemperature_4Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_MinimumTemperature_4Param);
   tVoid vSetData(const tS16& tPDD_THM_MinimumTemperature_4Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_CriticalHighTemperature_4;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_CriticalHighTemperature_4Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_CriticalHighTemperature_4Param);
   tS32  s32SetData(const tS16 &tPDD_THM_CriticalHighTemperature_4Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_CriticalHighTemperature_4Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_CriticalHighTemperature_4Param);
   tVoid vSetData(const tS16& tPDD_THM_CriticalHighTemperature_4Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_CriticalHighTemperatureHysteresis_4;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_4Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_4Param);
   tS32  s32SetData(const tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_4Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_4Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_4Param);
   tVoid vSetData(const tU8& tPDD_THM_CriticalHighTemperatureHysteresis_4Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_CriticalHighTemperatureTimeDelay_4;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_4Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_4Param);
   tS32  s32SetData(const tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_4Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_4Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_4Param);
   tVoid vSetData(const tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_4Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_HighTemperature_4{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_HighTemperature_4;
   
public:
   dp_tclThmDpPDDPDD_THM_HighTemperature_4(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_HighTemperature_4() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_HighTemperature_4Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_HighTemperature_4Param);
   tS32  s32SetData(const tS16 &tPDD_THM_HighTemperature_4Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_HighTemperature_4Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_HighTemperature_4Param);
   tVoid vSetData(const tS16& tPDD_THM_HighTemperature_4Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_HighTemperatureHysteresis_4;
   
public:
   dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_HighTemperatureHysteresis_4Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_HighTemperatureHysteresis_4Param);
   tS32  s32SetData(const tU8 &tPDD_THM_HighTemperatureHysteresis_4Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_HighTemperatureHysteresis_4Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_HighTemperatureHysteresis_4Param);
   tVoid vSetData(const tU8& tPDD_THM_HighTemperatureHysteresis_4Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_HighTemperatureTimeDelay_4;
   
public:
   dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_4Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_HighTemperatureTimeDelay_4Param);
   tS32  s32SetData(const tU16 &tPDD_THM_HighTemperatureTimeDelay_4Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_4Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_HighTemperatureTimeDelay_4Param);
   tVoid vSetData(const tU16& tPDD_THM_HighTemperatureTimeDelay_4Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_LowTemperature_4{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_LowTemperature_4;
   
public:
   dp_tclThmDpPDDPDD_THM_LowTemperature_4(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_LowTemperature_4() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_LowTemperature_4Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_LowTemperature_4Param);
   tS32  s32SetData(const tS16 &tPDD_THM_LowTemperature_4Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_LowTemperature_4Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_LowTemperature_4Param);
   tVoid vSetData(const tS16& tPDD_THM_LowTemperature_4Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_LowTemperatureHysteresis_4;
   
public:
   dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_LowTemperatureHysteresis_4Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_LowTemperatureHysteresis_4Param);
   tS32  s32SetData(const tU8 &tPDD_THM_LowTemperatureHysteresis_4Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_LowTemperatureHysteresis_4Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_LowTemperatureHysteresis_4Param);
   tVoid vSetData(const tU8& tPDD_THM_LowTemperatureHysteresis_4Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_LowTemperatureTimeDelay_4;
   
public:
   dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_4Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_LowTemperatureTimeDelay_4Param);
   tS32  s32SetData(const tU16 &tPDD_THM_LowTemperatureTimeDelay_4Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_4Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_LowTemperatureTimeDelay_4Param);
   tVoid vSetData(const tU16& tPDD_THM_LowTemperatureTimeDelay_4Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_CriticalLowTemperature_4;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_CriticalLowTemperature_4Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_CriticalLowTemperature_4Param);
   tS32  s32SetData(const tS16 &tPDD_THM_CriticalLowTemperature_4Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_CriticalLowTemperature_4Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_CriticalLowTemperature_4Param);
   tVoid vSetData(const tS16& tPDD_THM_CriticalLowTemperature_4Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_CriticalLowTemperatureHysteresis_4;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_4Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_4Param);
   tS32  s32SetData(const tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_4Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_4Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_4Param);
   tVoid vSetData(const tU8& tPDD_THM_CriticalLowTemperatureHysteresis_4Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_CriticalLowTemperatureTimeDelay_4;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_4Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_4Param);
   tS32  s32SetData(const tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_4Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_4Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_4Param);
   tVoid vSetData(const tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_4Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_SensorID_5{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_SensorID_5;
   
public:
   dp_tclThmDpPDDPDD_THM_SensorID_5(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_SensorID_5() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_SensorID_5Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_SensorID_5Param);
   tS32  s32SetData(const tU8 &tPDD_THM_SensorID_5Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_SensorID_5Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_SensorID_5Param);
   tVoid vSetData(const tU8& tPDD_THM_SensorID_5Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_MaximumTemperature_5{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_MaximumTemperature_5;
   
public:
   dp_tclThmDpPDDPDD_THM_MaximumTemperature_5(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_MaximumTemperature_5() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_MaximumTemperature_5Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_MaximumTemperature_5Param);
   tS32  s32SetData(const tS16 &tPDD_THM_MaximumTemperature_5Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_MaximumTemperature_5Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_MaximumTemperature_5Param);
   tVoid vSetData(const tS16& tPDD_THM_MaximumTemperature_5Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_MinimumTemperature_5{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_MinimumTemperature_5;
   
public:
   dp_tclThmDpPDDPDD_THM_MinimumTemperature_5(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_MinimumTemperature_5() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_MinimumTemperature_5Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_MinimumTemperature_5Param);
   tS32  s32SetData(const tS16 &tPDD_THM_MinimumTemperature_5Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_MinimumTemperature_5Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_MinimumTemperature_5Param);
   tVoid vSetData(const tS16& tPDD_THM_MinimumTemperature_5Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_CriticalHighTemperature_5;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_CriticalHighTemperature_5Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_CriticalHighTemperature_5Param);
   tS32  s32SetData(const tS16 &tPDD_THM_CriticalHighTemperature_5Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_CriticalHighTemperature_5Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_CriticalHighTemperature_5Param);
   tVoid vSetData(const tS16& tPDD_THM_CriticalHighTemperature_5Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_CriticalHighTemperatureHysteresis_5;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_5Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_5Param);
   tS32  s32SetData(const tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_5Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_5Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_5Param);
   tVoid vSetData(const tU8& tPDD_THM_CriticalHighTemperatureHysteresis_5Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_CriticalHighTemperatureTimeDelay_5;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_5Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_5Param);
   tS32  s32SetData(const tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_5Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_5Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_5Param);
   tVoid vSetData(const tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_5Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_HighTemperature_5{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_HighTemperature_5;
   
public:
   dp_tclThmDpPDDPDD_THM_HighTemperature_5(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_HighTemperature_5() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_HighTemperature_5Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_HighTemperature_5Param);
   tS32  s32SetData(const tS16 &tPDD_THM_HighTemperature_5Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_HighTemperature_5Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_HighTemperature_5Param);
   tVoid vSetData(const tS16& tPDD_THM_HighTemperature_5Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_HighTemperatureHysteresis_5;
   
public:
   dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_HighTemperatureHysteresis_5Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_HighTemperatureHysteresis_5Param);
   tS32  s32SetData(const tU8 &tPDD_THM_HighTemperatureHysteresis_5Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_HighTemperatureHysteresis_5Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_HighTemperatureHysteresis_5Param);
   tVoid vSetData(const tU8& tPDD_THM_HighTemperatureHysteresis_5Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_HighTemperatureTimeDelay_5;
   
public:
   dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_5Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_HighTemperatureTimeDelay_5Param);
   tS32  s32SetData(const tU16 &tPDD_THM_HighTemperatureTimeDelay_5Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_5Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_HighTemperatureTimeDelay_5Param);
   tVoid vSetData(const tU16& tPDD_THM_HighTemperatureTimeDelay_5Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_LowTemperature_5{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_LowTemperature_5;
   
public:
   dp_tclThmDpPDDPDD_THM_LowTemperature_5(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_LowTemperature_5() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_LowTemperature_5Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_LowTemperature_5Param);
   tS32  s32SetData(const tS16 &tPDD_THM_LowTemperature_5Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_LowTemperature_5Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_LowTemperature_5Param);
   tVoid vSetData(const tS16& tPDD_THM_LowTemperature_5Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_LowTemperatureHysteresis_5;
   
public:
   dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_LowTemperatureHysteresis_5Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_LowTemperatureHysteresis_5Param);
   tS32  s32SetData(const tU8 &tPDD_THM_LowTemperatureHysteresis_5Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_LowTemperatureHysteresis_5Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_LowTemperatureHysteresis_5Param);
   tVoid vSetData(const tU8& tPDD_THM_LowTemperatureHysteresis_5Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_LowTemperatureTimeDelay_5;
   
public:
   dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_5Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_LowTemperatureTimeDelay_5Param);
   tS32  s32SetData(const tU16 &tPDD_THM_LowTemperatureTimeDelay_5Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_5Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_LowTemperatureTimeDelay_5Param);
   tVoid vSetData(const tU16& tPDD_THM_LowTemperatureTimeDelay_5Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tPDD_THM_CriticalLowTemperature_5;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tPDD_THM_CriticalLowTemperature_5Param);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tPDD_THM_CriticalLowTemperature_5Param);
   tS32  s32SetData(const tS16 &tPDD_THM_CriticalLowTemperature_5Param);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tPDD_THM_CriticalLowTemperature_5Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tPDD_THM_CriticalLowTemperature_5Param);
   tVoid vSetData(const tS16& tPDD_THM_CriticalLowTemperature_5Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_CriticalLowTemperatureHysteresis_5;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_5Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_5Param);
   tS32  s32SetData(const tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_5Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_5Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_5Param);
   tVoid vSetData(const tU8& tPDD_THM_CriticalLowTemperatureHysteresis_5Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPDD_THM_CriticalLowTemperatureTimeDelay_5;
   
public:
   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_5Param);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_5Param);
   tS32  s32SetData(const tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_5Param);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_5Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_5Param);
   tVoid vSetData(const tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_5Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclThmDpPDDPDD_THM_RESERVED{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPDD_THM_RESERVED;
   
public:
   dp_tclThmDpPDDPDD_THM_RESERVED(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclThmDpPDDPDD_THM_RESERVED() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPDD_THM_RESERVEDParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPDD_THM_RESERVEDParam);
   tS32  s32SetData(const tU8 &tPDD_THM_RESERVEDParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPDD_THM_RESERVEDParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPDD_THM_RESERVEDParam);
   tVoid vSetData(const tU8& tPDD_THM_RESERVEDParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
