
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclThmDpPDD.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_Version"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_Version::dp_tclThmDpPDDPDD_THM_Version(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_Version,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_Version::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_Version",(tS32) 0x311d2da9);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_Version = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_Version::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_Version", (tS32)0x311d2da9);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_Version, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_Version::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_Version::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_Version::tGetData() {
   vUpdate();
   return tPDD_THM_Version;
};
tS32 dp_tclThmDpPDDPDD_THM_Version::s32GetData(tU16& tPDD_THM_VersionParam) { 
   vUpdate();
   tPDD_THM_VersionParam = tPDD_THM_Version;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_Version::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_Version", (tS32)0x311d2da9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_Version::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_Version::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_Version::s32SetData(tU16 &tPDD_THM_VersionParam) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_Version,(tVoid*)&tPDD_THM_VersionParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_VersionParam' in function 'dp_tclThmDpPDDPDD_THM_Version::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_Version::s32SetData(const tU16 &tPDD_THM_VersionParam) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_Version,(tVoid*)&tPDD_THM_VersionParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_VersionParam' in function 'dp_tclThmDpPDDPDD_THM_Version::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_Version::u8GetData(tU16& tPDD_THM_VersionParam) {  
   vUpdate();
   tPDD_THM_VersionParam = tPDD_THM_Version;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_Version::vSetData(tU16 &tPDD_THM_VersionParam) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_Version,(tVoid*)&tPDD_THM_VersionParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_VersionParam' in function 'dp_tclThmDpPDDPDD_THM_Version::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_Version::vSetData(const tU16 &tPDD_THM_VersionParam) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_Version,(tVoid*)&tPDD_THM_VersionParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_VersionParam' in function 'dp_tclThmDpPDDPDD_THM_Version::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_Version::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_Version::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_Version", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_Version::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_Version", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_Version::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_Version", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_Version has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_SensorID_1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_SensorID_1::dp_tclThmDpPDDPDD_THM_SensorID_1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_SensorID_1,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_SensorID_1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_SensorID_1",(tS32) 0xfae165d2);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_SensorID_1 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_SensorID_1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_SensorID_1", (tS32)0xfae165d2);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_SensorID_1, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_SensorID_1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_SensorID_1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_SensorID_1::tGetData() {
   vUpdate();
   return tPDD_THM_SensorID_1;
};
tS32 dp_tclThmDpPDDPDD_THM_SensorID_1::s32GetData(tU8& tPDD_THM_SensorID_1Param) { 
   vUpdate();
   tPDD_THM_SensorID_1Param = tPDD_THM_SensorID_1;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_SensorID_1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_SensorID_1", (tS32)0xfae165d2);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_SensorID_1::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_SensorID_1::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_SensorID_1::s32SetData(tU8 &tPDD_THM_SensorID_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_1,(tVoid*)&tPDD_THM_SensorID_1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_SensorID_1Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_1::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_SensorID_1::s32SetData(const tU8 &tPDD_THM_SensorID_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_1,(tVoid*)&tPDD_THM_SensorID_1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_SensorID_1Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_1::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_SensorID_1::u8GetData(tU8& tPDD_THM_SensorID_1Param) {  
   vUpdate();
   tPDD_THM_SensorID_1Param = tPDD_THM_SensorID_1;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_SensorID_1::vSetData(tU8 &tPDD_THM_SensorID_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_1,(tVoid*)&tPDD_THM_SensorID_1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_SensorID_1Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_1::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_SensorID_1::vSetData(const tU8 &tPDD_THM_SensorID_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_1,(tVoid*)&tPDD_THM_SensorID_1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_SensorID_1Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_1::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_SensorID_1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_SensorID_1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_SensorID_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_SensorID_1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_SensorID_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_SensorID_1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_SensorID_1", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_SensorID_1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_MaximumTemperature_1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::dp_tclThmDpPDDPDD_THM_MaximumTemperature_1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_MaximumTemperature_1,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_MaximumTemperature_1",(tS32) 0x8630066bL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_MaximumTemperature_1 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_MaximumTemperature_1", (tS32)0x8630066bL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_MaximumTemperature_1, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::tGetData() {
   vUpdate();
   return tPDD_THM_MaximumTemperature_1;
};
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::s32GetData(tS16& tPDD_THM_MaximumTemperature_1Param) { 
   vUpdate();
   tPDD_THM_MaximumTemperature_1Param = tPDD_THM_MaximumTemperature_1;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_MaximumTemperature_1", (tS32)0x8630066bL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::s32SetData(tS16 &tPDD_THM_MaximumTemperature_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_1,(tVoid*)&tPDD_THM_MaximumTemperature_1Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::s32SetData(const tS16 &tPDD_THM_MaximumTemperature_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_1,(tVoid*)&tPDD_THM_MaximumTemperature_1Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::u8GetData(tS16& tPDD_THM_MaximumTemperature_1Param) {  
   vUpdate();
   tPDD_THM_MaximumTemperature_1Param = tPDD_THM_MaximumTemperature_1;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::vSetData(tS16 &tPDD_THM_MaximumTemperature_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_1,(tVoid*)&tPDD_THM_MaximumTemperature_1Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::vSetData(const tS16 &tPDD_THM_MaximumTemperature_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_1,(tVoid*)&tPDD_THM_MaximumTemperature_1Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MaximumTemperature_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MaximumTemperature_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MaximumTemperature_1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_MaximumTemperature_1", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_MaximumTemperature_1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_MinimumTemperature_1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::dp_tclThmDpPDDPDD_THM_MinimumTemperature_1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_MinimumTemperature_1,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_MinimumTemperature_1",(tS32) 0x983d8181L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_MinimumTemperature_1 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_MinimumTemperature_1", (tS32)0x983d8181L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_MinimumTemperature_1, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::tGetData() {
   vUpdate();
   return tPDD_THM_MinimumTemperature_1;
};
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::s32GetData(tS16& tPDD_THM_MinimumTemperature_1Param) { 
   vUpdate();
   tPDD_THM_MinimumTemperature_1Param = tPDD_THM_MinimumTemperature_1;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_MinimumTemperature_1", (tS32)0x983d8181L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::s32SetData(tS16 &tPDD_THM_MinimumTemperature_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_1,(tVoid*)&tPDD_THM_MinimumTemperature_1Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::s32SetData(const tS16 &tPDD_THM_MinimumTemperature_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_1,(tVoid*)&tPDD_THM_MinimumTemperature_1Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::u8GetData(tS16& tPDD_THM_MinimumTemperature_1Param) {  
   vUpdate();
   tPDD_THM_MinimumTemperature_1Param = tPDD_THM_MinimumTemperature_1;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::vSetData(tS16 &tPDD_THM_MinimumTemperature_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_1,(tVoid*)&tPDD_THM_MinimumTemperature_1Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::vSetData(const tS16 &tPDD_THM_MinimumTemperature_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_1,(tVoid*)&tPDD_THM_MinimumTemperature_1Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MinimumTemperature_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MinimumTemperature_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MinimumTemperature_1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_MinimumTemperature_1", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_MinimumTemperature_1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalHighTemperature_1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalHighTemperature_1,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperature_1",(tS32) 0x8b2dd48L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_CriticalHighTemperature_1 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperature_1", (tS32)0x8b2dd48L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalHighTemperature_1, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalHighTemperature_1;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::s32GetData(tS16& tPDD_THM_CriticalHighTemperature_1Param) { 
   vUpdate();
   tPDD_THM_CriticalHighTemperature_1Param = tPDD_THM_CriticalHighTemperature_1;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperature_1", (tS32)0x8b2dd48L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::s32SetData(tS16 &tPDD_THM_CriticalHighTemperature_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_1,(tVoid*)&tPDD_THM_CriticalHighTemperature_1Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::s32SetData(const tS16 &tPDD_THM_CriticalHighTemperature_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_1,(tVoid*)&tPDD_THM_CriticalHighTemperature_1Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::u8GetData(tS16& tPDD_THM_CriticalHighTemperature_1Param) {  
   vUpdate();
   tPDD_THM_CriticalHighTemperature_1Param = tPDD_THM_CriticalHighTemperature_1;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::vSetData(tS16 &tPDD_THM_CriticalHighTemperature_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_1,(tVoid*)&tPDD_THM_CriticalHighTemperature_1Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::vSetData(const tS16 &tPDD_THM_CriticalHighTemperature_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_1,(tVoid*)&tPDD_THM_CriticalHighTemperature_1Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperature_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperature_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalHighTemperature_1", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalHighTemperature_1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalHighTemperatureHysteresis_1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalHighTemperatureHysteresis_1,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureHysteresis_1",(tS32) 0x9e44b883L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_CriticalHighTemperatureHysteresis_1 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureHysteresis_1", (tS32)0x9e44b883L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_1, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalHighTemperatureHysteresis_1;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::s32GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_1Param) { 
   vUpdate();
   tPDD_THM_CriticalHighTemperatureHysteresis_1Param = tPDD_THM_CriticalHighTemperatureHysteresis_1;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureHysteresis_1", (tS32)0x9e44b883L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::s32SetData(tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_1,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::s32SetData(const tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_1,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::u8GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_1Param) {  
   vUpdate();
   tPDD_THM_CriticalHighTemperatureHysteresis_1Param = tPDD_THM_CriticalHighTemperatureHysteresis_1;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::vSetData(tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_1,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::vSetData(const tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_1,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureHysteresis_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureHysteresis_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalHighTemperatureHysteresis_1", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalHighTemperatureHysteresis_1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalHighTemperatureTimeDelay_1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalHighTemperatureTimeDelay_1,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureTimeDelay_1",(tS32) 0xbe22268eL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_CriticalHighTemperatureTimeDelay_1 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureTimeDelay_1", (tS32)0xbe22268eL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_1, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalHighTemperatureTimeDelay_1;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::s32GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_1Param) { 
   vUpdate();
   tPDD_THM_CriticalHighTemperatureTimeDelay_1Param = tPDD_THM_CriticalHighTemperatureTimeDelay_1;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureTimeDelay_1", (tS32)0xbe22268eL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::s32SetData(tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::s32SetData(const tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::u8GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_1Param) {  
   vUpdate();
   tPDD_THM_CriticalHighTemperatureTimeDelay_1Param = tPDD_THM_CriticalHighTemperatureTimeDelay_1;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::vSetData(tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::vSetData(const tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureTimeDelay_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureTimeDelay_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalHighTemperatureTimeDelay_1", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalHighTemperatureTimeDelay_1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_HighTemperature_1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_HighTemperature_1::dp_tclThmDpPDDPDD_THM_HighTemperature_1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_HighTemperature_1,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperature_1",(tS32) 0x9c6e1601);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_HighTemperature_1 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperature_1", (tS32)0x9c6e1601);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_HighTemperature_1, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_HighTemperature_1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_HighTemperature_1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_HighTemperature_1::tGetData() {
   vUpdate();
   return tPDD_THM_HighTemperature_1;
};
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_1::s32GetData(tS16& tPDD_THM_HighTemperature_1Param) { 
   vUpdate();
   tPDD_THM_HighTemperature_1Param = tPDD_THM_HighTemperature_1;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperature_1", (tS32)0x9c6e1601);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_1::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_1::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_1::s32SetData(tS16 &tPDD_THM_HighTemperature_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_1,(tVoid*)&tPDD_THM_HighTemperature_1Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_1::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_1::s32SetData(const tS16 &tPDD_THM_HighTemperature_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_1,(tVoid*)&tPDD_THM_HighTemperature_1Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_1::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_HighTemperature_1::u8GetData(tS16& tPDD_THM_HighTemperature_1Param) {  
   vUpdate();
   tPDD_THM_HighTemperature_1Param = tPDD_THM_HighTemperature_1;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_1::vSetData(tS16 &tPDD_THM_HighTemperature_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_1,(tVoid*)&tPDD_THM_HighTemperature_1Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_1::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_1::vSetData(const tS16 &tPDD_THM_HighTemperature_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_1,(tVoid*)&tPDD_THM_HighTemperature_1Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_1::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_HighTemperature_1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_HighTemperature_1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperature_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperature_1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperature_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperature_1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_HighTemperature_1", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_HighTemperature_1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_HighTemperatureHysteresis_1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_HighTemperatureHysteresis_1,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureHysteresis_1",(tS32) 0xc97d5674L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_HighTemperatureHysteresis_1 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureHysteresis_1", (tS32)0xc97d5674L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_HighTemperatureHysteresis_1, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::tGetData() {
   vUpdate();
   return tPDD_THM_HighTemperatureHysteresis_1;
};
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::s32GetData(tU8& tPDD_THM_HighTemperatureHysteresis_1Param) { 
   vUpdate();
   tPDD_THM_HighTemperatureHysteresis_1Param = tPDD_THM_HighTemperatureHysteresis_1;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureHysteresis_1", (tS32)0xc97d5674L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::s32SetData(tU8 &tPDD_THM_HighTemperatureHysteresis_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_1,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::s32SetData(const tU8 &tPDD_THM_HighTemperatureHysteresis_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_1,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::u8GetData(tU8& tPDD_THM_HighTemperatureHysteresis_1Param) {  
   vUpdate();
   tPDD_THM_HighTemperatureHysteresis_1Param = tPDD_THM_HighTemperatureHysteresis_1;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::vSetData(tU8 &tPDD_THM_HighTemperatureHysteresis_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_1,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::vSetData(const tU8 &tPDD_THM_HighTemperatureHysteresis_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_1,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureHysteresis_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureHysteresis_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_HighTemperatureHysteresis_1", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_HighTemperatureHysteresis_1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_HighTemperatureTimeDelay_1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_HighTemperatureTimeDelay_1,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureTimeDelay_1",(tS32) 0x6060ac8bL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_HighTemperatureTimeDelay_1 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureTimeDelay_1", (tS32)0x6060ac8bL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_HighTemperatureTimeDelay_1, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::tGetData() {
   vUpdate();
   return tPDD_THM_HighTemperatureTimeDelay_1;
};
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::s32GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_1Param) { 
   vUpdate();
   tPDD_THM_HighTemperatureTimeDelay_1Param = tPDD_THM_HighTemperatureTimeDelay_1;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureTimeDelay_1", (tS32)0x6060ac8bL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::s32SetData(tU16 &tPDD_THM_HighTemperatureTimeDelay_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::s32SetData(const tU16 &tPDD_THM_HighTemperatureTimeDelay_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::u8GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_1Param) {  
   vUpdate();
   tPDD_THM_HighTemperatureTimeDelay_1Param = tPDD_THM_HighTemperatureTimeDelay_1;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::vSetData(tU16 &tPDD_THM_HighTemperatureTimeDelay_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::vSetData(const tU16 &tPDD_THM_HighTemperatureTimeDelay_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureTimeDelay_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureTimeDelay_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_HighTemperatureTimeDelay_1", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_HighTemperatureTimeDelay_1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_LowTemperature_1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_LowTemperature_1::dp_tclThmDpPDDPDD_THM_LowTemperature_1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_LowTemperature_1,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperature_1",(tS32) 0xb16b9937);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_LowTemperature_1 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperature_1", (tS32)0xb16b9937);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_LowTemperature_1, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_LowTemperature_1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_LowTemperature_1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_LowTemperature_1::tGetData() {
   vUpdate();
   return tPDD_THM_LowTemperature_1;
};
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_1::s32GetData(tS16& tPDD_THM_LowTemperature_1Param) { 
   vUpdate();
   tPDD_THM_LowTemperature_1Param = tPDD_THM_LowTemperature_1;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperature_1", (tS32)0xb16b9937);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_1::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_1::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_1::s32SetData(tS16 &tPDD_THM_LowTemperature_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_1,(tVoid*)&tPDD_THM_LowTemperature_1Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_1::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_1::s32SetData(const tS16 &tPDD_THM_LowTemperature_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_1,(tVoid*)&tPDD_THM_LowTemperature_1Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_1::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_LowTemperature_1::u8GetData(tS16& tPDD_THM_LowTemperature_1Param) {  
   vUpdate();
   tPDD_THM_LowTemperature_1Param = tPDD_THM_LowTemperature_1;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_1::vSetData(tS16 &tPDD_THM_LowTemperature_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_1,(tVoid*)&tPDD_THM_LowTemperature_1Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_1::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_1::vSetData(const tS16 &tPDD_THM_LowTemperature_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_1,(tVoid*)&tPDD_THM_LowTemperature_1Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_1::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_LowTemperature_1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_LowTemperature_1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperature_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperature_1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperature_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperature_1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_LowTemperature_1", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_LowTemperature_1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_LowTemperatureHysteresis_1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_LowTemperatureHysteresis_1,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureHysteresis_1",(tS32) 0x8d8661faL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_LowTemperatureHysteresis_1 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureHysteresis_1", (tS32)0x8d8661faL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_LowTemperatureHysteresis_1, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::tGetData() {
   vUpdate();
   return tPDD_THM_LowTemperatureHysteresis_1;
};
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::s32GetData(tU8& tPDD_THM_LowTemperatureHysteresis_1Param) { 
   vUpdate();
   tPDD_THM_LowTemperatureHysteresis_1Param = tPDD_THM_LowTemperatureHysteresis_1;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureHysteresis_1", (tS32)0x8d8661faL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::s32SetData(tU8 &tPDD_THM_LowTemperatureHysteresis_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_1,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::s32SetData(const tU8 &tPDD_THM_LowTemperatureHysteresis_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_1,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::u8GetData(tU8& tPDD_THM_LowTemperatureHysteresis_1Param) {  
   vUpdate();
   tPDD_THM_LowTemperatureHysteresis_1Param = tPDD_THM_LowTemperatureHysteresis_1;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::vSetData(tU8 &tPDD_THM_LowTemperatureHysteresis_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_1,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::vSetData(const tU8 &tPDD_THM_LowTemperatureHysteresis_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_1,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureHysteresis_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureHysteresis_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_LowTemperatureHysteresis_1", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_LowTemperatureHysteresis_1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_LowTemperatureTimeDelay_1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_LowTemperatureTimeDelay_1,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureTimeDelay_1",(tS32) 0x8795aed9L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_LowTemperatureTimeDelay_1 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureTimeDelay_1", (tS32)0x8795aed9L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_LowTemperatureTimeDelay_1, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::tGetData() {
   vUpdate();
   return tPDD_THM_LowTemperatureTimeDelay_1;
};
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::s32GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_1Param) { 
   vUpdate();
   tPDD_THM_LowTemperatureTimeDelay_1Param = tPDD_THM_LowTemperatureTimeDelay_1;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureTimeDelay_1", (tS32)0x8795aed9L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::s32SetData(tU16 &tPDD_THM_LowTemperatureTimeDelay_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::s32SetData(const tU16 &tPDD_THM_LowTemperatureTimeDelay_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::u8GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_1Param) {  
   vUpdate();
   tPDD_THM_LowTemperatureTimeDelay_1Param = tPDD_THM_LowTemperatureTimeDelay_1;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::vSetData(tU16 &tPDD_THM_LowTemperatureTimeDelay_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::vSetData(const tU16 &tPDD_THM_LowTemperatureTimeDelay_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureTimeDelay_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureTimeDelay_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_LowTemperatureTimeDelay_1", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_LowTemperatureTimeDelay_1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalLowTemperature_1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalLowTemperature_1,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperature_1",(tS32) 0x93dfc112L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_CriticalLowTemperature_1 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperature_1", (tS32)0x93dfc112L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalLowTemperature_1, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalLowTemperature_1;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::s32GetData(tS16& tPDD_THM_CriticalLowTemperature_1Param) { 
   vUpdate();
   tPDD_THM_CriticalLowTemperature_1Param = tPDD_THM_CriticalLowTemperature_1;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperature_1", (tS32)0x93dfc112L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::s32SetData(tS16 &tPDD_THM_CriticalLowTemperature_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_1,(tVoid*)&tPDD_THM_CriticalLowTemperature_1Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::s32SetData(const tS16 &tPDD_THM_CriticalLowTemperature_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_1,(tVoid*)&tPDD_THM_CriticalLowTemperature_1Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::u8GetData(tS16& tPDD_THM_CriticalLowTemperature_1Param) {  
   vUpdate();
   tPDD_THM_CriticalLowTemperature_1Param = tPDD_THM_CriticalLowTemperature_1;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::vSetData(tS16 &tPDD_THM_CriticalLowTemperature_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_1,(tVoid*)&tPDD_THM_CriticalLowTemperature_1Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::vSetData(const tS16 &tPDD_THM_CriticalLowTemperature_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_1,(tVoid*)&tPDD_THM_CriticalLowTemperature_1Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperature_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperature_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalLowTemperature_1", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalLowTemperature_1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalLowTemperatureHysteresis_1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalLowTemperatureHysteresis_1,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureHysteresis_1",(tS32) 0xeb47dbfdL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_CriticalLowTemperatureHysteresis_1 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureHysteresis_1", (tS32)0xeb47dbfdL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_1, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalLowTemperatureHysteresis_1;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::s32GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_1Param) { 
   vUpdate();
   tPDD_THM_CriticalLowTemperatureHysteresis_1Param = tPDD_THM_CriticalLowTemperatureHysteresis_1;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureHysteresis_1", (tS32)0xeb47dbfdL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::s32SetData(tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_1,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::s32SetData(const tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_1,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::u8GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_1Param) {  
   vUpdate();
   tPDD_THM_CriticalLowTemperatureHysteresis_1Param = tPDD_THM_CriticalLowTemperatureHysteresis_1;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::vSetData(tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_1,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::vSetData(const tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_1,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureHysteresis_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureHysteresis_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalLowTemperatureHysteresis_1", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalLowTemperatureHysteresis_1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalLowTemperatureTimeDelay_1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalLowTemperatureTimeDelay_1,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureTimeDelay_1",(tS32) 0x6722c740L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_CriticalLowTemperatureTimeDelay_1 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureTimeDelay_1", (tS32)0x6722c740L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_1, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalLowTemperatureTimeDelay_1;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::s32GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_1Param) { 
   vUpdate();
   tPDD_THM_CriticalLowTemperatureTimeDelay_1Param = tPDD_THM_CriticalLowTemperatureTimeDelay_1;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureTimeDelay_1", (tS32)0x6722c740L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::s32SetData(tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::s32SetData(const tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_1Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::u8GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_1Param) {  
   vUpdate();
   tPDD_THM_CriticalLowTemperatureTimeDelay_1Param = tPDD_THM_CriticalLowTemperatureTimeDelay_1;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::vSetData(tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::vSetData(const tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_1Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_1,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_1Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_1Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureTimeDelay_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureTimeDelay_1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalLowTemperatureTimeDelay_1", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalLowTemperatureTimeDelay_1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_SensorID_2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_SensorID_2::dp_tclThmDpPDDPDD_THM_SensorID_2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_SensorID_2,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_SensorID_2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_SensorID_2",(tS32) 0xfae165d3);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_SensorID_2 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_SensorID_2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_SensorID_2", (tS32)0xfae165d3);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_SensorID_2, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_SensorID_2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_SensorID_2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_SensorID_2::tGetData() {
   vUpdate();
   return tPDD_THM_SensorID_2;
};
tS32 dp_tclThmDpPDDPDD_THM_SensorID_2::s32GetData(tU8& tPDD_THM_SensorID_2Param) { 
   vUpdate();
   tPDD_THM_SensorID_2Param = tPDD_THM_SensorID_2;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_SensorID_2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_SensorID_2", (tS32)0xfae165d3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_SensorID_2::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_SensorID_2::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_SensorID_2::s32SetData(tU8 &tPDD_THM_SensorID_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_2,(tVoid*)&tPDD_THM_SensorID_2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_SensorID_2Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_2::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_SensorID_2::s32SetData(const tU8 &tPDD_THM_SensorID_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_2,(tVoid*)&tPDD_THM_SensorID_2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_SensorID_2Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_2::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_SensorID_2::u8GetData(tU8& tPDD_THM_SensorID_2Param) {  
   vUpdate();
   tPDD_THM_SensorID_2Param = tPDD_THM_SensorID_2;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_SensorID_2::vSetData(tU8 &tPDD_THM_SensorID_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_2,(tVoid*)&tPDD_THM_SensorID_2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_SensorID_2Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_2::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_SensorID_2::vSetData(const tU8 &tPDD_THM_SensorID_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_2,(tVoid*)&tPDD_THM_SensorID_2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_SensorID_2Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_2::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_SensorID_2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_SensorID_2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_SensorID_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_SensorID_2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_SensorID_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_SensorID_2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_SensorID_2", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_SensorID_2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_MaximumTemperature_2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::dp_tclThmDpPDDPDD_THM_MaximumTemperature_2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_MaximumTemperature_2,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_MaximumTemperature_2",(tS32) 0x8630066cL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_MaximumTemperature_2 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_MaximumTemperature_2", (tS32)0x8630066cL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_MaximumTemperature_2, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::tGetData() {
   vUpdate();
   return tPDD_THM_MaximumTemperature_2;
};
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::s32GetData(tS16& tPDD_THM_MaximumTemperature_2Param) { 
   vUpdate();
   tPDD_THM_MaximumTemperature_2Param = tPDD_THM_MaximumTemperature_2;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_MaximumTemperature_2", (tS32)0x8630066cL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::s32SetData(tS16 &tPDD_THM_MaximumTemperature_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_2,(tVoid*)&tPDD_THM_MaximumTemperature_2Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::s32SetData(const tS16 &tPDD_THM_MaximumTemperature_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_2,(tVoid*)&tPDD_THM_MaximumTemperature_2Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::u8GetData(tS16& tPDD_THM_MaximumTemperature_2Param) {  
   vUpdate();
   tPDD_THM_MaximumTemperature_2Param = tPDD_THM_MaximumTemperature_2;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::vSetData(tS16 &tPDD_THM_MaximumTemperature_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_2,(tVoid*)&tPDD_THM_MaximumTemperature_2Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::vSetData(const tS16 &tPDD_THM_MaximumTemperature_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_2,(tVoid*)&tPDD_THM_MaximumTemperature_2Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MaximumTemperature_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MaximumTemperature_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MaximumTemperature_2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_MaximumTemperature_2", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_MaximumTemperature_2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_MinimumTemperature_2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::dp_tclThmDpPDDPDD_THM_MinimumTemperature_2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_MinimumTemperature_2,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_MinimumTemperature_2",(tS32) 0x983d8182L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_MinimumTemperature_2 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_MinimumTemperature_2", (tS32)0x983d8182L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_MinimumTemperature_2, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::tGetData() {
   vUpdate();
   return tPDD_THM_MinimumTemperature_2;
};
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::s32GetData(tS16& tPDD_THM_MinimumTemperature_2Param) { 
   vUpdate();
   tPDD_THM_MinimumTemperature_2Param = tPDD_THM_MinimumTemperature_2;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_MinimumTemperature_2", (tS32)0x983d8182L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::s32SetData(tS16 &tPDD_THM_MinimumTemperature_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_2,(tVoid*)&tPDD_THM_MinimumTemperature_2Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::s32SetData(const tS16 &tPDD_THM_MinimumTemperature_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_2,(tVoid*)&tPDD_THM_MinimumTemperature_2Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::u8GetData(tS16& tPDD_THM_MinimumTemperature_2Param) {  
   vUpdate();
   tPDD_THM_MinimumTemperature_2Param = tPDD_THM_MinimumTemperature_2;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::vSetData(tS16 &tPDD_THM_MinimumTemperature_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_2,(tVoid*)&tPDD_THM_MinimumTemperature_2Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::vSetData(const tS16 &tPDD_THM_MinimumTemperature_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_2,(tVoid*)&tPDD_THM_MinimumTemperature_2Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MinimumTemperature_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MinimumTemperature_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MinimumTemperature_2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_MinimumTemperature_2", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_MinimumTemperature_2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalHighTemperature_2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalHighTemperature_2,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperature_2",(tS32) 0x8b2dd49L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_CriticalHighTemperature_2 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperature_2", (tS32)0x8b2dd49L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalHighTemperature_2, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalHighTemperature_2;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::s32GetData(tS16& tPDD_THM_CriticalHighTemperature_2Param) { 
   vUpdate();
   tPDD_THM_CriticalHighTemperature_2Param = tPDD_THM_CriticalHighTemperature_2;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperature_2", (tS32)0x8b2dd49L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::s32SetData(tS16 &tPDD_THM_CriticalHighTemperature_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_2,(tVoid*)&tPDD_THM_CriticalHighTemperature_2Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::s32SetData(const tS16 &tPDD_THM_CriticalHighTemperature_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_2,(tVoid*)&tPDD_THM_CriticalHighTemperature_2Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::u8GetData(tS16& tPDD_THM_CriticalHighTemperature_2Param) {  
   vUpdate();
   tPDD_THM_CriticalHighTemperature_2Param = tPDD_THM_CriticalHighTemperature_2;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::vSetData(tS16 &tPDD_THM_CriticalHighTemperature_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_2,(tVoid*)&tPDD_THM_CriticalHighTemperature_2Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::vSetData(const tS16 &tPDD_THM_CriticalHighTemperature_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_2,(tVoid*)&tPDD_THM_CriticalHighTemperature_2Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperature_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperature_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalHighTemperature_2", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalHighTemperature_2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalHighTemperatureHysteresis_2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalHighTemperatureHysteresis_2,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureHysteresis_2",(tS32) 0x9e44b884L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_CriticalHighTemperatureHysteresis_2 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureHysteresis_2", (tS32)0x9e44b884L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_2, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalHighTemperatureHysteresis_2;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::s32GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_2Param) { 
   vUpdate();
   tPDD_THM_CriticalHighTemperatureHysteresis_2Param = tPDD_THM_CriticalHighTemperatureHysteresis_2;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureHysteresis_2", (tS32)0x9e44b884L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::s32SetData(tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_2,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::s32SetData(const tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_2,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::u8GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_2Param) {  
   vUpdate();
   tPDD_THM_CriticalHighTemperatureHysteresis_2Param = tPDD_THM_CriticalHighTemperatureHysteresis_2;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::vSetData(tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_2,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::vSetData(const tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_2,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureHysteresis_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureHysteresis_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalHighTemperatureHysteresis_2", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalHighTemperatureHysteresis_2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalHighTemperatureTimeDelay_2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalHighTemperatureTimeDelay_2,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureTimeDelay_2",(tS32) 0xbe22268fL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_CriticalHighTemperatureTimeDelay_2 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureTimeDelay_2", (tS32)0xbe22268fL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_2, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalHighTemperatureTimeDelay_2;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::s32GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_2Param) { 
   vUpdate();
   tPDD_THM_CriticalHighTemperatureTimeDelay_2Param = tPDD_THM_CriticalHighTemperatureTimeDelay_2;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureTimeDelay_2", (tS32)0xbe22268fL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::s32SetData(tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::s32SetData(const tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::u8GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_2Param) {  
   vUpdate();
   tPDD_THM_CriticalHighTemperatureTimeDelay_2Param = tPDD_THM_CriticalHighTemperatureTimeDelay_2;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::vSetData(tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::vSetData(const tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureTimeDelay_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureTimeDelay_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalHighTemperatureTimeDelay_2", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalHighTemperatureTimeDelay_2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_HighTemperature_2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_HighTemperature_2::dp_tclThmDpPDDPDD_THM_HighTemperature_2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_HighTemperature_2,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperature_2",(tS32) 0x9c6e1602);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_HighTemperature_2 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperature_2", (tS32)0x9c6e1602);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_HighTemperature_2, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_HighTemperature_2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_HighTemperature_2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_HighTemperature_2::tGetData() {
   vUpdate();
   return tPDD_THM_HighTemperature_2;
};
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_2::s32GetData(tS16& tPDD_THM_HighTemperature_2Param) { 
   vUpdate();
   tPDD_THM_HighTemperature_2Param = tPDD_THM_HighTemperature_2;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperature_2", (tS32)0x9c6e1602);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_2::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_2::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_2::s32SetData(tS16 &tPDD_THM_HighTemperature_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_2,(tVoid*)&tPDD_THM_HighTemperature_2Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_2::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_2::s32SetData(const tS16 &tPDD_THM_HighTemperature_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_2,(tVoid*)&tPDD_THM_HighTemperature_2Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_2::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_HighTemperature_2::u8GetData(tS16& tPDD_THM_HighTemperature_2Param) {  
   vUpdate();
   tPDD_THM_HighTemperature_2Param = tPDD_THM_HighTemperature_2;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_2::vSetData(tS16 &tPDD_THM_HighTemperature_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_2,(tVoid*)&tPDD_THM_HighTemperature_2Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_2::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_2::vSetData(const tS16 &tPDD_THM_HighTemperature_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_2,(tVoid*)&tPDD_THM_HighTemperature_2Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_2::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_HighTemperature_2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_HighTemperature_2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperature_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperature_2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperature_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperature_2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_HighTemperature_2", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_HighTemperature_2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_HighTemperatureHysteresis_2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_HighTemperatureHysteresis_2,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureHysteresis_2",(tS32) 0xc97d5675L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_HighTemperatureHysteresis_2 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureHysteresis_2", (tS32)0xc97d5675L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_HighTemperatureHysteresis_2, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::tGetData() {
   vUpdate();
   return tPDD_THM_HighTemperatureHysteresis_2;
};
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::s32GetData(tU8& tPDD_THM_HighTemperatureHysteresis_2Param) { 
   vUpdate();
   tPDD_THM_HighTemperatureHysteresis_2Param = tPDD_THM_HighTemperatureHysteresis_2;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureHysteresis_2", (tS32)0xc97d5675L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::s32SetData(tU8 &tPDD_THM_HighTemperatureHysteresis_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_2,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::s32SetData(const tU8 &tPDD_THM_HighTemperatureHysteresis_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_2,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::u8GetData(tU8& tPDD_THM_HighTemperatureHysteresis_2Param) {  
   vUpdate();
   tPDD_THM_HighTemperatureHysteresis_2Param = tPDD_THM_HighTemperatureHysteresis_2;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::vSetData(tU8 &tPDD_THM_HighTemperatureHysteresis_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_2,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::vSetData(const tU8 &tPDD_THM_HighTemperatureHysteresis_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_2,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureHysteresis_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureHysteresis_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_HighTemperatureHysteresis_2", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_HighTemperatureHysteresis_2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_HighTemperatureTimeDelay_2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_HighTemperatureTimeDelay_2,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureTimeDelay_2",(tS32) 0x6060ac8cL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_HighTemperatureTimeDelay_2 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureTimeDelay_2", (tS32)0x6060ac8cL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_HighTemperatureTimeDelay_2, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::tGetData() {
   vUpdate();
   return tPDD_THM_HighTemperatureTimeDelay_2;
};
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::s32GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_2Param) { 
   vUpdate();
   tPDD_THM_HighTemperatureTimeDelay_2Param = tPDD_THM_HighTemperatureTimeDelay_2;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureTimeDelay_2", (tS32)0x6060ac8cL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::s32SetData(tU16 &tPDD_THM_HighTemperatureTimeDelay_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::s32SetData(const tU16 &tPDD_THM_HighTemperatureTimeDelay_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::u8GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_2Param) {  
   vUpdate();
   tPDD_THM_HighTemperatureTimeDelay_2Param = tPDD_THM_HighTemperatureTimeDelay_2;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::vSetData(tU16 &tPDD_THM_HighTemperatureTimeDelay_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::vSetData(const tU16 &tPDD_THM_HighTemperatureTimeDelay_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureTimeDelay_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureTimeDelay_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_HighTemperatureTimeDelay_2", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_HighTemperatureTimeDelay_2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_LowTemperature_2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_LowTemperature_2::dp_tclThmDpPDDPDD_THM_LowTemperature_2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_LowTemperature_2,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperature_2",(tS32) 0xb16b9938);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_LowTemperature_2 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperature_2", (tS32)0xb16b9938);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_LowTemperature_2, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_LowTemperature_2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_LowTemperature_2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_LowTemperature_2::tGetData() {
   vUpdate();
   return tPDD_THM_LowTemperature_2;
};
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_2::s32GetData(tS16& tPDD_THM_LowTemperature_2Param) { 
   vUpdate();
   tPDD_THM_LowTemperature_2Param = tPDD_THM_LowTemperature_2;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperature_2", (tS32)0xb16b9938);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_2::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_2::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_2::s32SetData(tS16 &tPDD_THM_LowTemperature_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_2,(tVoid*)&tPDD_THM_LowTemperature_2Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_2::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_2::s32SetData(const tS16 &tPDD_THM_LowTemperature_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_2,(tVoid*)&tPDD_THM_LowTemperature_2Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_2::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_LowTemperature_2::u8GetData(tS16& tPDD_THM_LowTemperature_2Param) {  
   vUpdate();
   tPDD_THM_LowTemperature_2Param = tPDD_THM_LowTemperature_2;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_2::vSetData(tS16 &tPDD_THM_LowTemperature_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_2,(tVoid*)&tPDD_THM_LowTemperature_2Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_2::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_2::vSetData(const tS16 &tPDD_THM_LowTemperature_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_2,(tVoid*)&tPDD_THM_LowTemperature_2Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_2::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_LowTemperature_2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_LowTemperature_2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperature_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperature_2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperature_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperature_2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_LowTemperature_2", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_LowTemperature_2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_LowTemperatureHysteresis_2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_LowTemperatureHysteresis_2,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureHysteresis_2",(tS32) 0x8d8661fbL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_LowTemperatureHysteresis_2 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureHysteresis_2", (tS32)0x8d8661fbL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_LowTemperatureHysteresis_2, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::tGetData() {
   vUpdate();
   return tPDD_THM_LowTemperatureHysteresis_2;
};
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::s32GetData(tU8& tPDD_THM_LowTemperatureHysteresis_2Param) { 
   vUpdate();
   tPDD_THM_LowTemperatureHysteresis_2Param = tPDD_THM_LowTemperatureHysteresis_2;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureHysteresis_2", (tS32)0x8d8661fbL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::s32SetData(tU8 &tPDD_THM_LowTemperatureHysteresis_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_2,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::s32SetData(const tU8 &tPDD_THM_LowTemperatureHysteresis_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_2,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::u8GetData(tU8& tPDD_THM_LowTemperatureHysteresis_2Param) {  
   vUpdate();
   tPDD_THM_LowTemperatureHysteresis_2Param = tPDD_THM_LowTemperatureHysteresis_2;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::vSetData(tU8 &tPDD_THM_LowTemperatureHysteresis_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_2,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::vSetData(const tU8 &tPDD_THM_LowTemperatureHysteresis_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_2,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureHysteresis_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureHysteresis_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_LowTemperatureHysteresis_2", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_LowTemperatureHysteresis_2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_LowTemperatureTimeDelay_2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_LowTemperatureTimeDelay_2,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureTimeDelay_2",(tS32) 0x8795aedaL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_LowTemperatureTimeDelay_2 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureTimeDelay_2", (tS32)0x8795aedaL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_LowTemperatureTimeDelay_2, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::tGetData() {
   vUpdate();
   return tPDD_THM_LowTemperatureTimeDelay_2;
};
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::s32GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_2Param) { 
   vUpdate();
   tPDD_THM_LowTemperatureTimeDelay_2Param = tPDD_THM_LowTemperatureTimeDelay_2;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureTimeDelay_2", (tS32)0x8795aedaL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::s32SetData(tU16 &tPDD_THM_LowTemperatureTimeDelay_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::s32SetData(const tU16 &tPDD_THM_LowTemperatureTimeDelay_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::u8GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_2Param) {  
   vUpdate();
   tPDD_THM_LowTemperatureTimeDelay_2Param = tPDD_THM_LowTemperatureTimeDelay_2;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::vSetData(tU16 &tPDD_THM_LowTemperatureTimeDelay_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::vSetData(const tU16 &tPDD_THM_LowTemperatureTimeDelay_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureTimeDelay_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureTimeDelay_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_LowTemperatureTimeDelay_2", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_LowTemperatureTimeDelay_2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalLowTemperature_2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalLowTemperature_2,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperature_2",(tS32) 0x93dfc113L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_CriticalLowTemperature_2 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperature_2", (tS32)0x93dfc113L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalLowTemperature_2, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalLowTemperature_2;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::s32GetData(tS16& tPDD_THM_CriticalLowTemperature_2Param) { 
   vUpdate();
   tPDD_THM_CriticalLowTemperature_2Param = tPDD_THM_CriticalLowTemperature_2;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperature_2", (tS32)0x93dfc113L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::s32SetData(tS16 &tPDD_THM_CriticalLowTemperature_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_2,(tVoid*)&tPDD_THM_CriticalLowTemperature_2Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::s32SetData(const tS16 &tPDD_THM_CriticalLowTemperature_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_2,(tVoid*)&tPDD_THM_CriticalLowTemperature_2Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::u8GetData(tS16& tPDD_THM_CriticalLowTemperature_2Param) {  
   vUpdate();
   tPDD_THM_CriticalLowTemperature_2Param = tPDD_THM_CriticalLowTemperature_2;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::vSetData(tS16 &tPDD_THM_CriticalLowTemperature_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_2,(tVoid*)&tPDD_THM_CriticalLowTemperature_2Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::vSetData(const tS16 &tPDD_THM_CriticalLowTemperature_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_2,(tVoid*)&tPDD_THM_CriticalLowTemperature_2Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperature_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperature_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalLowTemperature_2", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalLowTemperature_2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalLowTemperatureHysteresis_2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalLowTemperatureHysteresis_2,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureHysteresis_2",(tS32) 0xeb47dbfeL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_CriticalLowTemperatureHysteresis_2 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureHysteresis_2", (tS32)0xeb47dbfeL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_2, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalLowTemperatureHysteresis_2;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::s32GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_2Param) { 
   vUpdate();
   tPDD_THM_CriticalLowTemperatureHysteresis_2Param = tPDD_THM_CriticalLowTemperatureHysteresis_2;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureHysteresis_2", (tS32)0xeb47dbfeL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::s32SetData(tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_2,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::s32SetData(const tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_2,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::u8GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_2Param) {  
   vUpdate();
   tPDD_THM_CriticalLowTemperatureHysteresis_2Param = tPDD_THM_CriticalLowTemperatureHysteresis_2;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::vSetData(tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_2,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::vSetData(const tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_2,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureHysteresis_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureHysteresis_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalLowTemperatureHysteresis_2", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalLowTemperatureHysteresis_2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalLowTemperatureTimeDelay_2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalLowTemperatureTimeDelay_2,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureTimeDelay_2",(tS32) 0x6722c741L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_CriticalLowTemperatureTimeDelay_2 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureTimeDelay_2", (tS32)0x6722c741L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_2, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalLowTemperatureTimeDelay_2;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::s32GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_2Param) { 
   vUpdate();
   tPDD_THM_CriticalLowTemperatureTimeDelay_2Param = tPDD_THM_CriticalLowTemperatureTimeDelay_2;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureTimeDelay_2", (tS32)0x6722c741L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::s32SetData(tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::s32SetData(const tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_2Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::u8GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_2Param) {  
   vUpdate();
   tPDD_THM_CriticalLowTemperatureTimeDelay_2Param = tPDD_THM_CriticalLowTemperatureTimeDelay_2;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::vSetData(tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::vSetData(const tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_2Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_2,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_2Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_2Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureTimeDelay_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureTimeDelay_2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalLowTemperatureTimeDelay_2", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalLowTemperatureTimeDelay_2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_SensorID_3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_SensorID_3::dp_tclThmDpPDDPDD_THM_SensorID_3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_SensorID_3,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_SensorID_3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_SensorID_3",(tS32) 0xfae165d4);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_SensorID_3 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_SensorID_3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_SensorID_3", (tS32)0xfae165d4);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_SensorID_3, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_SensorID_3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_SensorID_3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_SensorID_3::tGetData() {
   vUpdate();
   return tPDD_THM_SensorID_3;
};
tS32 dp_tclThmDpPDDPDD_THM_SensorID_3::s32GetData(tU8& tPDD_THM_SensorID_3Param) { 
   vUpdate();
   tPDD_THM_SensorID_3Param = tPDD_THM_SensorID_3;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_SensorID_3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_SensorID_3", (tS32)0xfae165d4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_SensorID_3::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_SensorID_3::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_SensorID_3::s32SetData(tU8 &tPDD_THM_SensorID_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_3,(tVoid*)&tPDD_THM_SensorID_3Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_SensorID_3Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_3::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_SensorID_3::s32SetData(const tU8 &tPDD_THM_SensorID_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_3,(tVoid*)&tPDD_THM_SensorID_3Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_SensorID_3Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_3::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_SensorID_3::u8GetData(tU8& tPDD_THM_SensorID_3Param) {  
   vUpdate();
   tPDD_THM_SensorID_3Param = tPDD_THM_SensorID_3;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_SensorID_3::vSetData(tU8 &tPDD_THM_SensorID_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_3,(tVoid*)&tPDD_THM_SensorID_3Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_SensorID_3Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_3::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_SensorID_3::vSetData(const tU8 &tPDD_THM_SensorID_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_3,(tVoid*)&tPDD_THM_SensorID_3Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_SensorID_3Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_3::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_SensorID_3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_SensorID_3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_SensorID_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_SensorID_3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_SensorID_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_SensorID_3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_SensorID_3", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_SensorID_3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_MaximumTemperature_3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::dp_tclThmDpPDDPDD_THM_MaximumTemperature_3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_MaximumTemperature_3,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_MaximumTemperature_3",(tS32) 0x8630066dL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_MaximumTemperature_3 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_MaximumTemperature_3", (tS32)0x8630066dL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_MaximumTemperature_3, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::tGetData() {
   vUpdate();
   return tPDD_THM_MaximumTemperature_3;
};
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::s32GetData(tS16& tPDD_THM_MaximumTemperature_3Param) { 
   vUpdate();
   tPDD_THM_MaximumTemperature_3Param = tPDD_THM_MaximumTemperature_3;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_MaximumTemperature_3", (tS32)0x8630066dL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::s32SetData(tS16 &tPDD_THM_MaximumTemperature_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_3,(tVoid*)&tPDD_THM_MaximumTemperature_3Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::s32SetData(const tS16 &tPDD_THM_MaximumTemperature_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_3,(tVoid*)&tPDD_THM_MaximumTemperature_3Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::u8GetData(tS16& tPDD_THM_MaximumTemperature_3Param) {  
   vUpdate();
   tPDD_THM_MaximumTemperature_3Param = tPDD_THM_MaximumTemperature_3;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::vSetData(tS16 &tPDD_THM_MaximumTemperature_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_3,(tVoid*)&tPDD_THM_MaximumTemperature_3Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::vSetData(const tS16 &tPDD_THM_MaximumTemperature_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_3,(tVoid*)&tPDD_THM_MaximumTemperature_3Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MaximumTemperature_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MaximumTemperature_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MaximumTemperature_3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_MaximumTemperature_3", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_MaximumTemperature_3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_MinimumTemperature_3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::dp_tclThmDpPDDPDD_THM_MinimumTemperature_3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_MinimumTemperature_3,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_MinimumTemperature_3",(tS32) 0x983d8183L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_MinimumTemperature_3 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_MinimumTemperature_3", (tS32)0x983d8183L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_MinimumTemperature_3, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::tGetData() {
   vUpdate();
   return tPDD_THM_MinimumTemperature_3;
};
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::s32GetData(tS16& tPDD_THM_MinimumTemperature_3Param) { 
   vUpdate();
   tPDD_THM_MinimumTemperature_3Param = tPDD_THM_MinimumTemperature_3;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_MinimumTemperature_3", (tS32)0x983d8183L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::s32SetData(tS16 &tPDD_THM_MinimumTemperature_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_3,(tVoid*)&tPDD_THM_MinimumTemperature_3Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::s32SetData(const tS16 &tPDD_THM_MinimumTemperature_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_3,(tVoid*)&tPDD_THM_MinimumTemperature_3Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::u8GetData(tS16& tPDD_THM_MinimumTemperature_3Param) {  
   vUpdate();
   tPDD_THM_MinimumTemperature_3Param = tPDD_THM_MinimumTemperature_3;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::vSetData(tS16 &tPDD_THM_MinimumTemperature_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_3,(tVoid*)&tPDD_THM_MinimumTemperature_3Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::vSetData(const tS16 &tPDD_THM_MinimumTemperature_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_3,(tVoid*)&tPDD_THM_MinimumTemperature_3Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MinimumTemperature_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MinimumTemperature_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MinimumTemperature_3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_MinimumTemperature_3", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_MinimumTemperature_3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalHighTemperature_3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalHighTemperature_3,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperature_3",(tS32) 0x8b2dd4aL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_CriticalHighTemperature_3 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperature_3", (tS32)0x8b2dd4aL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalHighTemperature_3, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalHighTemperature_3;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::s32GetData(tS16& tPDD_THM_CriticalHighTemperature_3Param) { 
   vUpdate();
   tPDD_THM_CriticalHighTemperature_3Param = tPDD_THM_CriticalHighTemperature_3;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperature_3", (tS32)0x8b2dd4aL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::s32SetData(tS16 &tPDD_THM_CriticalHighTemperature_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_3,(tVoid*)&tPDD_THM_CriticalHighTemperature_3Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::s32SetData(const tS16 &tPDD_THM_CriticalHighTemperature_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_3,(tVoid*)&tPDD_THM_CriticalHighTemperature_3Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::u8GetData(tS16& tPDD_THM_CriticalHighTemperature_3Param) {  
   vUpdate();
   tPDD_THM_CriticalHighTemperature_3Param = tPDD_THM_CriticalHighTemperature_3;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::vSetData(tS16 &tPDD_THM_CriticalHighTemperature_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_3,(tVoid*)&tPDD_THM_CriticalHighTemperature_3Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::vSetData(const tS16 &tPDD_THM_CriticalHighTemperature_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_3,(tVoid*)&tPDD_THM_CriticalHighTemperature_3Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperature_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperature_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalHighTemperature_3", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalHighTemperature_3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalHighTemperatureHysteresis_3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalHighTemperatureHysteresis_3,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureHysteresis_3",(tS32) 0x9e44b885L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_CriticalHighTemperatureHysteresis_3 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureHysteresis_3", (tS32)0x9e44b885L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_3, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalHighTemperatureHysteresis_3;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::s32GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_3Param) { 
   vUpdate();
   tPDD_THM_CriticalHighTemperatureHysteresis_3Param = tPDD_THM_CriticalHighTemperatureHysteresis_3;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureHysteresis_3", (tS32)0x9e44b885L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::s32SetData(tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_3,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::s32SetData(const tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_3,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::u8GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_3Param) {  
   vUpdate();
   tPDD_THM_CriticalHighTemperatureHysteresis_3Param = tPDD_THM_CriticalHighTemperatureHysteresis_3;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::vSetData(tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_3,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::vSetData(const tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_3,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureHysteresis_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureHysteresis_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalHighTemperatureHysteresis_3", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalHighTemperatureHysteresis_3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalHighTemperatureTimeDelay_3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalHighTemperatureTimeDelay_3,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureTimeDelay_3",(tS32) 0xbe222690L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_CriticalHighTemperatureTimeDelay_3 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureTimeDelay_3", (tS32)0xbe222690L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_3, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalHighTemperatureTimeDelay_3;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::s32GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_3Param) { 
   vUpdate();
   tPDD_THM_CriticalHighTemperatureTimeDelay_3Param = tPDD_THM_CriticalHighTemperatureTimeDelay_3;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureTimeDelay_3", (tS32)0xbe222690L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::s32SetData(tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::s32SetData(const tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::u8GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_3Param) {  
   vUpdate();
   tPDD_THM_CriticalHighTemperatureTimeDelay_3Param = tPDD_THM_CriticalHighTemperatureTimeDelay_3;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::vSetData(tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::vSetData(const tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureTimeDelay_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureTimeDelay_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalHighTemperatureTimeDelay_3", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalHighTemperatureTimeDelay_3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_HighTemperature_3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_HighTemperature_3::dp_tclThmDpPDDPDD_THM_HighTemperature_3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_HighTemperature_3,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperature_3",(tS32) 0x9c6e1603);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_HighTemperature_3 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperature_3", (tS32)0x9c6e1603);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_HighTemperature_3, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_HighTemperature_3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_HighTemperature_3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_HighTemperature_3::tGetData() {
   vUpdate();
   return tPDD_THM_HighTemperature_3;
};
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_3::s32GetData(tS16& tPDD_THM_HighTemperature_3Param) { 
   vUpdate();
   tPDD_THM_HighTemperature_3Param = tPDD_THM_HighTemperature_3;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperature_3", (tS32)0x9c6e1603);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_3::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_3::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_3::s32SetData(tS16 &tPDD_THM_HighTemperature_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_3,(tVoid*)&tPDD_THM_HighTemperature_3Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_3::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_3::s32SetData(const tS16 &tPDD_THM_HighTemperature_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_3,(tVoid*)&tPDD_THM_HighTemperature_3Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_3::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_HighTemperature_3::u8GetData(tS16& tPDD_THM_HighTemperature_3Param) {  
   vUpdate();
   tPDD_THM_HighTemperature_3Param = tPDD_THM_HighTemperature_3;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_3::vSetData(tS16 &tPDD_THM_HighTemperature_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_3,(tVoid*)&tPDD_THM_HighTemperature_3Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_3::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_3::vSetData(const tS16 &tPDD_THM_HighTemperature_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_3,(tVoid*)&tPDD_THM_HighTemperature_3Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_3::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_HighTemperature_3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_HighTemperature_3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperature_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperature_3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperature_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperature_3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_HighTemperature_3", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_HighTemperature_3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_HighTemperatureHysteresis_3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_HighTemperatureHysteresis_3,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureHysteresis_3",(tS32) 0xc97d5676L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_HighTemperatureHysteresis_3 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureHysteresis_3", (tS32)0xc97d5676L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_HighTemperatureHysteresis_3, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::tGetData() {
   vUpdate();
   return tPDD_THM_HighTemperatureHysteresis_3;
};
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::s32GetData(tU8& tPDD_THM_HighTemperatureHysteresis_3Param) { 
   vUpdate();
   tPDD_THM_HighTemperatureHysteresis_3Param = tPDD_THM_HighTemperatureHysteresis_3;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureHysteresis_3", (tS32)0xc97d5676L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::s32SetData(tU8 &tPDD_THM_HighTemperatureHysteresis_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_3,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::s32SetData(const tU8 &tPDD_THM_HighTemperatureHysteresis_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_3,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::u8GetData(tU8& tPDD_THM_HighTemperatureHysteresis_3Param) {  
   vUpdate();
   tPDD_THM_HighTemperatureHysteresis_3Param = tPDD_THM_HighTemperatureHysteresis_3;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::vSetData(tU8 &tPDD_THM_HighTemperatureHysteresis_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_3,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::vSetData(const tU8 &tPDD_THM_HighTemperatureHysteresis_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_3,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureHysteresis_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureHysteresis_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_HighTemperatureHysteresis_3", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_HighTemperatureHysteresis_3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_HighTemperatureTimeDelay_3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_HighTemperatureTimeDelay_3,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureTimeDelay_3",(tS32) 0x6060ac8dL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_HighTemperatureTimeDelay_3 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureTimeDelay_3", (tS32)0x6060ac8dL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_HighTemperatureTimeDelay_3, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::tGetData() {
   vUpdate();
   return tPDD_THM_HighTemperatureTimeDelay_3;
};
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::s32GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_3Param) { 
   vUpdate();
   tPDD_THM_HighTemperatureTimeDelay_3Param = tPDD_THM_HighTemperatureTimeDelay_3;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureTimeDelay_3", (tS32)0x6060ac8dL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::s32SetData(tU16 &tPDD_THM_HighTemperatureTimeDelay_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::s32SetData(const tU16 &tPDD_THM_HighTemperatureTimeDelay_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::u8GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_3Param) {  
   vUpdate();
   tPDD_THM_HighTemperatureTimeDelay_3Param = tPDD_THM_HighTemperatureTimeDelay_3;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::vSetData(tU16 &tPDD_THM_HighTemperatureTimeDelay_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::vSetData(const tU16 &tPDD_THM_HighTemperatureTimeDelay_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureTimeDelay_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureTimeDelay_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_HighTemperatureTimeDelay_3", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_HighTemperatureTimeDelay_3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_LowTemperature_3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_LowTemperature_3::dp_tclThmDpPDDPDD_THM_LowTemperature_3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_LowTemperature_3,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperature_3",(tS32) 0xb16b9939);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_LowTemperature_3 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperature_3", (tS32)0xb16b9939);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_LowTemperature_3, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_LowTemperature_3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_LowTemperature_3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_LowTemperature_3::tGetData() {
   vUpdate();
   return tPDD_THM_LowTemperature_3;
};
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_3::s32GetData(tS16& tPDD_THM_LowTemperature_3Param) { 
   vUpdate();
   tPDD_THM_LowTemperature_3Param = tPDD_THM_LowTemperature_3;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperature_3", (tS32)0xb16b9939);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_3::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_3::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_3::s32SetData(tS16 &tPDD_THM_LowTemperature_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_3,(tVoid*)&tPDD_THM_LowTemperature_3Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_3::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_3::s32SetData(const tS16 &tPDD_THM_LowTemperature_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_3,(tVoid*)&tPDD_THM_LowTemperature_3Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_3::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_LowTemperature_3::u8GetData(tS16& tPDD_THM_LowTemperature_3Param) {  
   vUpdate();
   tPDD_THM_LowTemperature_3Param = tPDD_THM_LowTemperature_3;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_3::vSetData(tS16 &tPDD_THM_LowTemperature_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_3,(tVoid*)&tPDD_THM_LowTemperature_3Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_3::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_3::vSetData(const tS16 &tPDD_THM_LowTemperature_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_3,(tVoid*)&tPDD_THM_LowTemperature_3Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_3::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_LowTemperature_3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_LowTemperature_3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperature_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperature_3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperature_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperature_3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_LowTemperature_3", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_LowTemperature_3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_LowTemperatureHysteresis_3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_LowTemperatureHysteresis_3,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureHysteresis_3",(tS32) 0x8d8661fcL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_LowTemperatureHysteresis_3 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureHysteresis_3", (tS32)0x8d8661fcL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_LowTemperatureHysteresis_3, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::tGetData() {
   vUpdate();
   return tPDD_THM_LowTemperatureHysteresis_3;
};
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::s32GetData(tU8& tPDD_THM_LowTemperatureHysteresis_3Param) { 
   vUpdate();
   tPDD_THM_LowTemperatureHysteresis_3Param = tPDD_THM_LowTemperatureHysteresis_3;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureHysteresis_3", (tS32)0x8d8661fcL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::s32SetData(tU8 &tPDD_THM_LowTemperatureHysteresis_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_3,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::s32SetData(const tU8 &tPDD_THM_LowTemperatureHysteresis_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_3,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::u8GetData(tU8& tPDD_THM_LowTemperatureHysteresis_3Param) {  
   vUpdate();
   tPDD_THM_LowTemperatureHysteresis_3Param = tPDD_THM_LowTemperatureHysteresis_3;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::vSetData(tU8 &tPDD_THM_LowTemperatureHysteresis_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_3,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::vSetData(const tU8 &tPDD_THM_LowTemperatureHysteresis_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_3,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureHysteresis_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureHysteresis_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_LowTemperatureHysteresis_3", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_LowTemperatureHysteresis_3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_LowTemperatureTimeDelay_3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_LowTemperatureTimeDelay_3,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureTimeDelay_3",(tS32) 0x8795aedbL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_LowTemperatureTimeDelay_3 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureTimeDelay_3", (tS32)0x8795aedbL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_LowTemperatureTimeDelay_3, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::tGetData() {
   vUpdate();
   return tPDD_THM_LowTemperatureTimeDelay_3;
};
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::s32GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_3Param) { 
   vUpdate();
   tPDD_THM_LowTemperatureTimeDelay_3Param = tPDD_THM_LowTemperatureTimeDelay_3;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureTimeDelay_3", (tS32)0x8795aedbL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::s32SetData(tU16 &tPDD_THM_LowTemperatureTimeDelay_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::s32SetData(const tU16 &tPDD_THM_LowTemperatureTimeDelay_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::u8GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_3Param) {  
   vUpdate();
   tPDD_THM_LowTemperatureTimeDelay_3Param = tPDD_THM_LowTemperatureTimeDelay_3;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::vSetData(tU16 &tPDD_THM_LowTemperatureTimeDelay_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::vSetData(const tU16 &tPDD_THM_LowTemperatureTimeDelay_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureTimeDelay_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureTimeDelay_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_LowTemperatureTimeDelay_3", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_LowTemperatureTimeDelay_3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalLowTemperature_3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalLowTemperature_3,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperature_3",(tS32) 0x93dfc114L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_CriticalLowTemperature_3 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperature_3", (tS32)0x93dfc114L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalLowTemperature_3, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalLowTemperature_3;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::s32GetData(tS16& tPDD_THM_CriticalLowTemperature_3Param) { 
   vUpdate();
   tPDD_THM_CriticalLowTemperature_3Param = tPDD_THM_CriticalLowTemperature_3;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperature_3", (tS32)0x93dfc114L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::s32SetData(tS16 &tPDD_THM_CriticalLowTemperature_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_3,(tVoid*)&tPDD_THM_CriticalLowTemperature_3Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::s32SetData(const tS16 &tPDD_THM_CriticalLowTemperature_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_3,(tVoid*)&tPDD_THM_CriticalLowTemperature_3Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::u8GetData(tS16& tPDD_THM_CriticalLowTemperature_3Param) {  
   vUpdate();
   tPDD_THM_CriticalLowTemperature_3Param = tPDD_THM_CriticalLowTemperature_3;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::vSetData(tS16 &tPDD_THM_CriticalLowTemperature_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_3,(tVoid*)&tPDD_THM_CriticalLowTemperature_3Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::vSetData(const tS16 &tPDD_THM_CriticalLowTemperature_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_3,(tVoid*)&tPDD_THM_CriticalLowTemperature_3Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperature_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperature_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalLowTemperature_3", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalLowTemperature_3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalLowTemperatureHysteresis_3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalLowTemperatureHysteresis_3,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureHysteresis_3",(tS32) 0xeb47dbffL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_CriticalLowTemperatureHysteresis_3 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureHysteresis_3", (tS32)0xeb47dbffL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_3, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalLowTemperatureHysteresis_3;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::s32GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_3Param) { 
   vUpdate();
   tPDD_THM_CriticalLowTemperatureHysteresis_3Param = tPDD_THM_CriticalLowTemperatureHysteresis_3;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureHysteresis_3", (tS32)0xeb47dbffL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::s32SetData(tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_3,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::s32SetData(const tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_3,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::u8GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_3Param) {  
   vUpdate();
   tPDD_THM_CriticalLowTemperatureHysteresis_3Param = tPDD_THM_CriticalLowTemperatureHysteresis_3;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::vSetData(tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_3,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::vSetData(const tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_3,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_3Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureHysteresis_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureHysteresis_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalLowTemperatureHysteresis_3", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalLowTemperatureHysteresis_3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalLowTemperatureTimeDelay_3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalLowTemperatureTimeDelay_3,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureTimeDelay_3",(tS32) 0x6722c742L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_CriticalLowTemperatureTimeDelay_3 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureTimeDelay_3", (tS32)0x6722c742L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_3, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalLowTemperatureTimeDelay_3;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::s32GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_3Param) { 
   vUpdate();
   tPDD_THM_CriticalLowTemperatureTimeDelay_3Param = tPDD_THM_CriticalLowTemperatureTimeDelay_3;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureTimeDelay_3", (tS32)0x6722c742L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::s32SetData(tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::s32SetData(const tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_3Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::u8GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_3Param) {  
   vUpdate();
   tPDD_THM_CriticalLowTemperatureTimeDelay_3Param = tPDD_THM_CriticalLowTemperatureTimeDelay_3;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::vSetData(tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::vSetData(const tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_3Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_3,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_3Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_3Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureTimeDelay_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureTimeDelay_3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalLowTemperatureTimeDelay_3", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalLowTemperatureTimeDelay_3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_SensorID_4"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_SensorID_4::dp_tclThmDpPDDPDD_THM_SensorID_4(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_SensorID_4,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_SensorID_4::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_SensorID_4",(tS32) 0xfae165d5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_SensorID_4 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_SensorID_4::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_SensorID_4", (tS32)0xfae165d5);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_SensorID_4, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_SensorID_4::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_SensorID_4::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_SensorID_4::tGetData() {
   vUpdate();
   return tPDD_THM_SensorID_4;
};
tS32 dp_tclThmDpPDDPDD_THM_SensorID_4::s32GetData(tU8& tPDD_THM_SensorID_4Param) { 
   vUpdate();
   tPDD_THM_SensorID_4Param = tPDD_THM_SensorID_4;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_SensorID_4::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_SensorID_4", (tS32)0xfae165d5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_SensorID_4::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_SensorID_4::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_SensorID_4::s32SetData(tU8 &tPDD_THM_SensorID_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_4,(tVoid*)&tPDD_THM_SensorID_4Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_SensorID_4Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_4::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_SensorID_4::s32SetData(const tU8 &tPDD_THM_SensorID_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_4,(tVoid*)&tPDD_THM_SensorID_4Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_SensorID_4Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_4::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_SensorID_4::u8GetData(tU8& tPDD_THM_SensorID_4Param) {  
   vUpdate();
   tPDD_THM_SensorID_4Param = tPDD_THM_SensorID_4;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_SensorID_4::vSetData(tU8 &tPDD_THM_SensorID_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_4,(tVoid*)&tPDD_THM_SensorID_4Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_SensorID_4Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_4::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_SensorID_4::vSetData(const tU8 &tPDD_THM_SensorID_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_4,(tVoid*)&tPDD_THM_SensorID_4Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_SensorID_4Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_4::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_SensorID_4::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_SensorID_4::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_SensorID_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_SensorID_4::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_SensorID_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_SensorID_4::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_SensorID_4", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_SensorID_4 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_MaximumTemperature_4"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::dp_tclThmDpPDDPDD_THM_MaximumTemperature_4(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_MaximumTemperature_4,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_MaximumTemperature_4",(tS32) 0x8630066eL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_MaximumTemperature_4 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_MaximumTemperature_4", (tS32)0x8630066eL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_MaximumTemperature_4, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::tGetData() {
   vUpdate();
   return tPDD_THM_MaximumTemperature_4;
};
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::s32GetData(tS16& tPDD_THM_MaximumTemperature_4Param) { 
   vUpdate();
   tPDD_THM_MaximumTemperature_4Param = tPDD_THM_MaximumTemperature_4;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_MaximumTemperature_4", (tS32)0x8630066eL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::s32SetData(tS16 &tPDD_THM_MaximumTemperature_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_4,(tVoid*)&tPDD_THM_MaximumTemperature_4Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::s32SetData(const tS16 &tPDD_THM_MaximumTemperature_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_4,(tVoid*)&tPDD_THM_MaximumTemperature_4Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::u8GetData(tS16& tPDD_THM_MaximumTemperature_4Param) {  
   vUpdate();
   tPDD_THM_MaximumTemperature_4Param = tPDD_THM_MaximumTemperature_4;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::vSetData(tS16 &tPDD_THM_MaximumTemperature_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_4,(tVoid*)&tPDD_THM_MaximumTemperature_4Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::vSetData(const tS16 &tPDD_THM_MaximumTemperature_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_4,(tVoid*)&tPDD_THM_MaximumTemperature_4Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MaximumTemperature_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MaximumTemperature_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MaximumTemperature_4::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_MaximumTemperature_4", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_MaximumTemperature_4 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_MinimumTemperature_4"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::dp_tclThmDpPDDPDD_THM_MinimumTemperature_4(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_MinimumTemperature_4,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_MinimumTemperature_4",(tS32) 0x983d8184L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_MinimumTemperature_4 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_MinimumTemperature_4", (tS32)0x983d8184L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_MinimumTemperature_4, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::tGetData() {
   vUpdate();
   return tPDD_THM_MinimumTemperature_4;
};
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::s32GetData(tS16& tPDD_THM_MinimumTemperature_4Param) { 
   vUpdate();
   tPDD_THM_MinimumTemperature_4Param = tPDD_THM_MinimumTemperature_4;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_MinimumTemperature_4", (tS32)0x983d8184L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::s32SetData(tS16 &tPDD_THM_MinimumTemperature_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_4,(tVoid*)&tPDD_THM_MinimumTemperature_4Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::s32SetData(const tS16 &tPDD_THM_MinimumTemperature_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_4,(tVoid*)&tPDD_THM_MinimumTemperature_4Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::u8GetData(tS16& tPDD_THM_MinimumTemperature_4Param) {  
   vUpdate();
   tPDD_THM_MinimumTemperature_4Param = tPDD_THM_MinimumTemperature_4;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::vSetData(tS16 &tPDD_THM_MinimumTemperature_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_4,(tVoid*)&tPDD_THM_MinimumTemperature_4Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::vSetData(const tS16 &tPDD_THM_MinimumTemperature_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_4,(tVoid*)&tPDD_THM_MinimumTemperature_4Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MinimumTemperature_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MinimumTemperature_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MinimumTemperature_4::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_MinimumTemperature_4", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_MinimumTemperature_4 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalHighTemperature_4"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalHighTemperature_4,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperature_4",(tS32) 0x8b2dd4bL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_CriticalHighTemperature_4 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperature_4", (tS32)0x8b2dd4bL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalHighTemperature_4, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalHighTemperature_4;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::s32GetData(tS16& tPDD_THM_CriticalHighTemperature_4Param) { 
   vUpdate();
   tPDD_THM_CriticalHighTemperature_4Param = tPDD_THM_CriticalHighTemperature_4;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperature_4", (tS32)0x8b2dd4bL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::s32SetData(tS16 &tPDD_THM_CriticalHighTemperature_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_4,(tVoid*)&tPDD_THM_CriticalHighTemperature_4Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::s32SetData(const tS16 &tPDD_THM_CriticalHighTemperature_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_4,(tVoid*)&tPDD_THM_CriticalHighTemperature_4Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::u8GetData(tS16& tPDD_THM_CriticalHighTemperature_4Param) {  
   vUpdate();
   tPDD_THM_CriticalHighTemperature_4Param = tPDD_THM_CriticalHighTemperature_4;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::vSetData(tS16 &tPDD_THM_CriticalHighTemperature_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_4,(tVoid*)&tPDD_THM_CriticalHighTemperature_4Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::vSetData(const tS16 &tPDD_THM_CriticalHighTemperature_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_4,(tVoid*)&tPDD_THM_CriticalHighTemperature_4Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperature_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperature_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_4::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalHighTemperature_4", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalHighTemperature_4 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalHighTemperatureHysteresis_4"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalHighTemperatureHysteresis_4,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureHysteresis_4",(tS32) 0x9e44b886L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_CriticalHighTemperatureHysteresis_4 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureHysteresis_4", (tS32)0x9e44b886L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_4, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalHighTemperatureHysteresis_4;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::s32GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_4Param) { 
   vUpdate();
   tPDD_THM_CriticalHighTemperatureHysteresis_4Param = tPDD_THM_CriticalHighTemperatureHysteresis_4;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureHysteresis_4", (tS32)0x9e44b886L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::s32SetData(tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_4,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::s32SetData(const tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_4,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::u8GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_4Param) {  
   vUpdate();
   tPDD_THM_CriticalHighTemperatureHysteresis_4Param = tPDD_THM_CriticalHighTemperatureHysteresis_4;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::vSetData(tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_4,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::vSetData(const tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_4,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureHysteresis_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureHysteresis_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_4::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalHighTemperatureHysteresis_4", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalHighTemperatureHysteresis_4 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalHighTemperatureTimeDelay_4"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalHighTemperatureTimeDelay_4,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureTimeDelay_4",(tS32) 0xbe222691L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_CriticalHighTemperatureTimeDelay_4 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureTimeDelay_4", (tS32)0xbe222691L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_4, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalHighTemperatureTimeDelay_4;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::s32GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_4Param) { 
   vUpdate();
   tPDD_THM_CriticalHighTemperatureTimeDelay_4Param = tPDD_THM_CriticalHighTemperatureTimeDelay_4;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureTimeDelay_4", (tS32)0xbe222691L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::s32SetData(tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::s32SetData(const tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::u8GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_4Param) {  
   vUpdate();
   tPDD_THM_CriticalHighTemperatureTimeDelay_4Param = tPDD_THM_CriticalHighTemperatureTimeDelay_4;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::vSetData(tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::vSetData(const tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureTimeDelay_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureTimeDelay_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_4::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalHighTemperatureTimeDelay_4", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalHighTemperatureTimeDelay_4 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_HighTemperature_4"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_HighTemperature_4::dp_tclThmDpPDDPDD_THM_HighTemperature_4(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_HighTemperature_4,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_4::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperature_4",(tS32) 0x9c6e1604);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_HighTemperature_4 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_4::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperature_4", (tS32)0x9c6e1604);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_HighTemperature_4, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_HighTemperature_4::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_HighTemperature_4::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_HighTemperature_4::tGetData() {
   vUpdate();
   return tPDD_THM_HighTemperature_4;
};
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_4::s32GetData(tS16& tPDD_THM_HighTemperature_4Param) { 
   vUpdate();
   tPDD_THM_HighTemperature_4Param = tPDD_THM_HighTemperature_4;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_4::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperature_4", (tS32)0x9c6e1604);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_4::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_4::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_4::s32SetData(tS16 &tPDD_THM_HighTemperature_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_4,(tVoid*)&tPDD_THM_HighTemperature_4Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_4::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_4::s32SetData(const tS16 &tPDD_THM_HighTemperature_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_4,(tVoid*)&tPDD_THM_HighTemperature_4Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_4::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_HighTemperature_4::u8GetData(tS16& tPDD_THM_HighTemperature_4Param) {  
   vUpdate();
   tPDD_THM_HighTemperature_4Param = tPDD_THM_HighTemperature_4;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_4::vSetData(tS16 &tPDD_THM_HighTemperature_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_4,(tVoid*)&tPDD_THM_HighTemperature_4Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_4::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_4::vSetData(const tS16 &tPDD_THM_HighTemperature_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_4,(tVoid*)&tPDD_THM_HighTemperature_4Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_4::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_HighTemperature_4::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_HighTemperature_4::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperature_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperature_4::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperature_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperature_4::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_HighTemperature_4", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_HighTemperature_4 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_HighTemperatureHysteresis_4"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_HighTemperatureHysteresis_4,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureHysteresis_4",(tS32) 0xc97d5677L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_HighTemperatureHysteresis_4 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureHysteresis_4", (tS32)0xc97d5677L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_HighTemperatureHysteresis_4, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::tGetData() {
   vUpdate();
   return tPDD_THM_HighTemperatureHysteresis_4;
};
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::s32GetData(tU8& tPDD_THM_HighTemperatureHysteresis_4Param) { 
   vUpdate();
   tPDD_THM_HighTemperatureHysteresis_4Param = tPDD_THM_HighTemperatureHysteresis_4;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureHysteresis_4", (tS32)0xc97d5677L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::s32SetData(tU8 &tPDD_THM_HighTemperatureHysteresis_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_4,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::s32SetData(const tU8 &tPDD_THM_HighTemperatureHysteresis_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_4,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::u8GetData(tU8& tPDD_THM_HighTemperatureHysteresis_4Param) {  
   vUpdate();
   tPDD_THM_HighTemperatureHysteresis_4Param = tPDD_THM_HighTemperatureHysteresis_4;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::vSetData(tU8 &tPDD_THM_HighTemperatureHysteresis_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_4,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::vSetData(const tU8 &tPDD_THM_HighTemperatureHysteresis_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_4,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureHysteresis_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureHysteresis_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_4::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_HighTemperatureHysteresis_4", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_HighTemperatureHysteresis_4 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_HighTemperatureTimeDelay_4"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_HighTemperatureTimeDelay_4,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureTimeDelay_4",(tS32) 0x6060ac8eL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_HighTemperatureTimeDelay_4 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureTimeDelay_4", (tS32)0x6060ac8eL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_HighTemperatureTimeDelay_4, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::tGetData() {
   vUpdate();
   return tPDD_THM_HighTemperatureTimeDelay_4;
};
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::s32GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_4Param) { 
   vUpdate();
   tPDD_THM_HighTemperatureTimeDelay_4Param = tPDD_THM_HighTemperatureTimeDelay_4;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureTimeDelay_4", (tS32)0x6060ac8eL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::s32SetData(tU16 &tPDD_THM_HighTemperatureTimeDelay_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::s32SetData(const tU16 &tPDD_THM_HighTemperatureTimeDelay_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::u8GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_4Param) {  
   vUpdate();
   tPDD_THM_HighTemperatureTimeDelay_4Param = tPDD_THM_HighTemperatureTimeDelay_4;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::vSetData(tU16 &tPDD_THM_HighTemperatureTimeDelay_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::vSetData(const tU16 &tPDD_THM_HighTemperatureTimeDelay_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureTimeDelay_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureTimeDelay_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_4::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_HighTemperatureTimeDelay_4", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_HighTemperatureTimeDelay_4 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_LowTemperature_4"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_LowTemperature_4::dp_tclThmDpPDDPDD_THM_LowTemperature_4(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_LowTemperature_4,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_4::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperature_4",(tS32) 0xb16b993a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_LowTemperature_4 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_4::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperature_4", (tS32)0xb16b993a);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_LowTemperature_4, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_LowTemperature_4::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_LowTemperature_4::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_LowTemperature_4::tGetData() {
   vUpdate();
   return tPDD_THM_LowTemperature_4;
};
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_4::s32GetData(tS16& tPDD_THM_LowTemperature_4Param) { 
   vUpdate();
   tPDD_THM_LowTemperature_4Param = tPDD_THM_LowTemperature_4;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_4::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperature_4", (tS32)0xb16b993a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_4::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_4::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_4::s32SetData(tS16 &tPDD_THM_LowTemperature_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_4,(tVoid*)&tPDD_THM_LowTemperature_4Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_4::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_4::s32SetData(const tS16 &tPDD_THM_LowTemperature_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_4,(tVoid*)&tPDD_THM_LowTemperature_4Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_4::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_LowTemperature_4::u8GetData(tS16& tPDD_THM_LowTemperature_4Param) {  
   vUpdate();
   tPDD_THM_LowTemperature_4Param = tPDD_THM_LowTemperature_4;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_4::vSetData(tS16 &tPDD_THM_LowTemperature_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_4,(tVoid*)&tPDD_THM_LowTemperature_4Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_4::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_4::vSetData(const tS16 &tPDD_THM_LowTemperature_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_4,(tVoid*)&tPDD_THM_LowTemperature_4Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_4::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_LowTemperature_4::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_LowTemperature_4::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperature_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperature_4::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperature_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperature_4::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_LowTemperature_4", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_LowTemperature_4 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_LowTemperatureHysteresis_4"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_LowTemperatureHysteresis_4,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureHysteresis_4",(tS32) 0x8d8661fdL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_LowTemperatureHysteresis_4 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureHysteresis_4", (tS32)0x8d8661fdL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_LowTemperatureHysteresis_4, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::tGetData() {
   vUpdate();
   return tPDD_THM_LowTemperatureHysteresis_4;
};
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::s32GetData(tU8& tPDD_THM_LowTemperatureHysteresis_4Param) { 
   vUpdate();
   tPDD_THM_LowTemperatureHysteresis_4Param = tPDD_THM_LowTemperatureHysteresis_4;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureHysteresis_4", (tS32)0x8d8661fdL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::s32SetData(tU8 &tPDD_THM_LowTemperatureHysteresis_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_4,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::s32SetData(const tU8 &tPDD_THM_LowTemperatureHysteresis_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_4,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::u8GetData(tU8& tPDD_THM_LowTemperatureHysteresis_4Param) {  
   vUpdate();
   tPDD_THM_LowTemperatureHysteresis_4Param = tPDD_THM_LowTemperatureHysteresis_4;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::vSetData(tU8 &tPDD_THM_LowTemperatureHysteresis_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_4,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::vSetData(const tU8 &tPDD_THM_LowTemperatureHysteresis_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_4,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureHysteresis_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureHysteresis_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_4::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_LowTemperatureHysteresis_4", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_LowTemperatureHysteresis_4 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_LowTemperatureTimeDelay_4"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_LowTemperatureTimeDelay_4,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureTimeDelay_4",(tS32) 0x8795aedcL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_LowTemperatureTimeDelay_4 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureTimeDelay_4", (tS32)0x8795aedcL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_LowTemperatureTimeDelay_4, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::tGetData() {
   vUpdate();
   return tPDD_THM_LowTemperatureTimeDelay_4;
};
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::s32GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_4Param) { 
   vUpdate();
   tPDD_THM_LowTemperatureTimeDelay_4Param = tPDD_THM_LowTemperatureTimeDelay_4;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureTimeDelay_4", (tS32)0x8795aedcL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::s32SetData(tU16 &tPDD_THM_LowTemperatureTimeDelay_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::s32SetData(const tU16 &tPDD_THM_LowTemperatureTimeDelay_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::u8GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_4Param) {  
   vUpdate();
   tPDD_THM_LowTemperatureTimeDelay_4Param = tPDD_THM_LowTemperatureTimeDelay_4;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::vSetData(tU16 &tPDD_THM_LowTemperatureTimeDelay_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::vSetData(const tU16 &tPDD_THM_LowTemperatureTimeDelay_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureTimeDelay_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureTimeDelay_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_4::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_LowTemperatureTimeDelay_4", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_LowTemperatureTimeDelay_4 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalLowTemperature_4"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalLowTemperature_4,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperature_4",(tS32) 0x93dfc115L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_CriticalLowTemperature_4 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperature_4", (tS32)0x93dfc115L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalLowTemperature_4, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalLowTemperature_4;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::s32GetData(tS16& tPDD_THM_CriticalLowTemperature_4Param) { 
   vUpdate();
   tPDD_THM_CriticalLowTemperature_4Param = tPDD_THM_CriticalLowTemperature_4;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperature_4", (tS32)0x93dfc115L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::s32SetData(tS16 &tPDD_THM_CriticalLowTemperature_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_4,(tVoid*)&tPDD_THM_CriticalLowTemperature_4Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::s32SetData(const tS16 &tPDD_THM_CriticalLowTemperature_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_4,(tVoid*)&tPDD_THM_CriticalLowTemperature_4Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::u8GetData(tS16& tPDD_THM_CriticalLowTemperature_4Param) {  
   vUpdate();
   tPDD_THM_CriticalLowTemperature_4Param = tPDD_THM_CriticalLowTemperature_4;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::vSetData(tS16 &tPDD_THM_CriticalLowTemperature_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_4,(tVoid*)&tPDD_THM_CriticalLowTemperature_4Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::vSetData(const tS16 &tPDD_THM_CriticalLowTemperature_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_4,(tVoid*)&tPDD_THM_CriticalLowTemperature_4Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperature_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperature_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_4::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalLowTemperature_4", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalLowTemperature_4 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalLowTemperatureHysteresis_4"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalLowTemperatureHysteresis_4,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureHysteresis_4",(tS32) 0xeb47dc00L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_CriticalLowTemperatureHysteresis_4 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureHysteresis_4", (tS32)0xeb47dc00L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_4, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalLowTemperatureHysteresis_4;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::s32GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_4Param) { 
   vUpdate();
   tPDD_THM_CriticalLowTemperatureHysteresis_4Param = tPDD_THM_CriticalLowTemperatureHysteresis_4;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureHysteresis_4", (tS32)0xeb47dc00L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::s32SetData(tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_4,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::s32SetData(const tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_4,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::u8GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_4Param) {  
   vUpdate();
   tPDD_THM_CriticalLowTemperatureHysteresis_4Param = tPDD_THM_CriticalLowTemperatureHysteresis_4;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::vSetData(tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_4,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::vSetData(const tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_4,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_4Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureHysteresis_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureHysteresis_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_4::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalLowTemperatureHysteresis_4", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalLowTemperatureHysteresis_4 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalLowTemperatureTimeDelay_4"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalLowTemperatureTimeDelay_4,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureTimeDelay_4",(tS32) 0x6722c743L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_CriticalLowTemperatureTimeDelay_4 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureTimeDelay_4", (tS32)0x6722c743L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_4, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalLowTemperatureTimeDelay_4;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::s32GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_4Param) { 
   vUpdate();
   tPDD_THM_CriticalLowTemperatureTimeDelay_4Param = tPDD_THM_CriticalLowTemperatureTimeDelay_4;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureTimeDelay_4", (tS32)0x6722c743L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::s32SetData(tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::s32SetData(const tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_4Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::u8GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_4Param) {  
   vUpdate();
   tPDD_THM_CriticalLowTemperatureTimeDelay_4Param = tPDD_THM_CriticalLowTemperatureTimeDelay_4;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::vSetData(tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::vSetData(const tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_4Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_4,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_4Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_4Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureTimeDelay_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureTimeDelay_4", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_4::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalLowTemperatureTimeDelay_4", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalLowTemperatureTimeDelay_4 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_SensorID_5"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_SensorID_5::dp_tclThmDpPDDPDD_THM_SensorID_5(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_SensorID_5,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_SensorID_5::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_SensorID_5",(tS32) 0xfae165d6);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_SensorID_5 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_SensorID_5::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_SensorID_5", (tS32)0xfae165d6);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_SensorID_5, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_SensorID_5::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_SensorID_5::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_SensorID_5::tGetData() {
   vUpdate();
   return tPDD_THM_SensorID_5;
};
tS32 dp_tclThmDpPDDPDD_THM_SensorID_5::s32GetData(tU8& tPDD_THM_SensorID_5Param) { 
   vUpdate();
   tPDD_THM_SensorID_5Param = tPDD_THM_SensorID_5;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_SensorID_5::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_SensorID_5", (tS32)0xfae165d6);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_SensorID_5::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_SensorID_5::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_SensorID_5::s32SetData(tU8 &tPDD_THM_SensorID_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_5,(tVoid*)&tPDD_THM_SensorID_5Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_SensorID_5Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_5::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_SensorID_5::s32SetData(const tU8 &tPDD_THM_SensorID_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_5,(tVoid*)&tPDD_THM_SensorID_5Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_SensorID_5Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_5::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_SensorID_5::u8GetData(tU8& tPDD_THM_SensorID_5Param) {  
   vUpdate();
   tPDD_THM_SensorID_5Param = tPDD_THM_SensorID_5;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_SensorID_5::vSetData(tU8 &tPDD_THM_SensorID_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_5,(tVoid*)&tPDD_THM_SensorID_5Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_SensorID_5Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_5::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_SensorID_5::vSetData(const tU8 &tPDD_THM_SensorID_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_SensorID_5,(tVoid*)&tPDD_THM_SensorID_5Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_SensorID_5Param' in function 'dp_tclThmDpPDDPDD_THM_SensorID_5::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_SensorID_5::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_SensorID_5::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_SensorID_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_SensorID_5::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_SensorID_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_SensorID_5::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_SensorID_5", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_SensorID_5 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_MaximumTemperature_5"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::dp_tclThmDpPDDPDD_THM_MaximumTemperature_5(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_MaximumTemperature_5,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_MaximumTemperature_5",(tS32) 0x8630066fL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_MaximumTemperature_5 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_MaximumTemperature_5", (tS32)0x8630066fL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_MaximumTemperature_5, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::tGetData() {
   vUpdate();
   return tPDD_THM_MaximumTemperature_5;
};
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::s32GetData(tS16& tPDD_THM_MaximumTemperature_5Param) { 
   vUpdate();
   tPDD_THM_MaximumTemperature_5Param = tPDD_THM_MaximumTemperature_5;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_MaximumTemperature_5", (tS32)0x8630066fL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::s32SetData(tS16 &tPDD_THM_MaximumTemperature_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_5,(tVoid*)&tPDD_THM_MaximumTemperature_5Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::s32SetData(const tS16 &tPDD_THM_MaximumTemperature_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_5,(tVoid*)&tPDD_THM_MaximumTemperature_5Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::u8GetData(tS16& tPDD_THM_MaximumTemperature_5Param) {  
   vUpdate();
   tPDD_THM_MaximumTemperature_5Param = tPDD_THM_MaximumTemperature_5;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::vSetData(tS16 &tPDD_THM_MaximumTemperature_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_5,(tVoid*)&tPDD_THM_MaximumTemperature_5Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::vSetData(const tS16 &tPDD_THM_MaximumTemperature_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MaximumTemperature_5,(tVoid*)&tPDD_THM_MaximumTemperature_5Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MaximumTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MaximumTemperature_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MaximumTemperature_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MaximumTemperature_5::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_MaximumTemperature_5", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_MaximumTemperature_5 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_MinimumTemperature_5"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::dp_tclThmDpPDDPDD_THM_MinimumTemperature_5(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_MinimumTemperature_5,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_MinimumTemperature_5",(tS32) 0x983d8185L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_MinimumTemperature_5 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_MinimumTemperature_5", (tS32)0x983d8185L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_MinimumTemperature_5, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::tGetData() {
   vUpdate();
   return tPDD_THM_MinimumTemperature_5;
};
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::s32GetData(tS16& tPDD_THM_MinimumTemperature_5Param) { 
   vUpdate();
   tPDD_THM_MinimumTemperature_5Param = tPDD_THM_MinimumTemperature_5;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_MinimumTemperature_5", (tS32)0x983d8185L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::s32SetData(tS16 &tPDD_THM_MinimumTemperature_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_5,(tVoid*)&tPDD_THM_MinimumTemperature_5Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::s32SetData(const tS16 &tPDD_THM_MinimumTemperature_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_5,(tVoid*)&tPDD_THM_MinimumTemperature_5Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::u8GetData(tS16& tPDD_THM_MinimumTemperature_5Param) {  
   vUpdate();
   tPDD_THM_MinimumTemperature_5Param = tPDD_THM_MinimumTemperature_5;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::vSetData(tS16 &tPDD_THM_MinimumTemperature_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_5,(tVoid*)&tPDD_THM_MinimumTemperature_5Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::vSetData(const tS16 &tPDD_THM_MinimumTemperature_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_MinimumTemperature_5,(tVoid*)&tPDD_THM_MinimumTemperature_5Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_MinimumTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MinimumTemperature_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_MinimumTemperature_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_MinimumTemperature_5::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_MinimumTemperature_5", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_MinimumTemperature_5 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalHighTemperature_5"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalHighTemperature_5,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperature_5",(tS32) 0x8b2dd4cL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_CriticalHighTemperature_5 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperature_5", (tS32)0x8b2dd4cL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalHighTemperature_5, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalHighTemperature_5;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::s32GetData(tS16& tPDD_THM_CriticalHighTemperature_5Param) { 
   vUpdate();
   tPDD_THM_CriticalHighTemperature_5Param = tPDD_THM_CriticalHighTemperature_5;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperature_5", (tS32)0x8b2dd4cL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::s32SetData(tS16 &tPDD_THM_CriticalHighTemperature_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_5,(tVoid*)&tPDD_THM_CriticalHighTemperature_5Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::s32SetData(const tS16 &tPDD_THM_CriticalHighTemperature_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_5,(tVoid*)&tPDD_THM_CriticalHighTemperature_5Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::u8GetData(tS16& tPDD_THM_CriticalHighTemperature_5Param) {  
   vUpdate();
   tPDD_THM_CriticalHighTemperature_5Param = tPDD_THM_CriticalHighTemperature_5;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::vSetData(tS16 &tPDD_THM_CriticalHighTemperature_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_5,(tVoid*)&tPDD_THM_CriticalHighTemperature_5Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::vSetData(const tS16 &tPDD_THM_CriticalHighTemperature_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperature_5,(tVoid*)&tPDD_THM_CriticalHighTemperature_5Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperature_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperature_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperature_5::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalHighTemperature_5", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalHighTemperature_5 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalHighTemperatureHysteresis_5"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalHighTemperatureHysteresis_5,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureHysteresis_5",(tS32) 0x9e44b887L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_CriticalHighTemperatureHysteresis_5 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureHysteresis_5", (tS32)0x9e44b887L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_5, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalHighTemperatureHysteresis_5;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::s32GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_5Param) { 
   vUpdate();
   tPDD_THM_CriticalHighTemperatureHysteresis_5Param = tPDD_THM_CriticalHighTemperatureHysteresis_5;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureHysteresis_5", (tS32)0x9e44b887L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::s32SetData(tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_5,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::s32SetData(const tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_5,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::u8GetData(tU8& tPDD_THM_CriticalHighTemperatureHysteresis_5Param) {  
   vUpdate();
   tPDD_THM_CriticalHighTemperatureHysteresis_5Param = tPDD_THM_CriticalHighTemperatureHysteresis_5;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::vSetData(tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_5,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::vSetData(const tU8 &tPDD_THM_CriticalHighTemperatureHysteresis_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureHysteresis_5,(tVoid*)&tPDD_THM_CriticalHighTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureHysteresis_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureHysteresis_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureHysteresis_5::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalHighTemperatureHysteresis_5", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalHighTemperatureHysteresis_5 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalHighTemperatureTimeDelay_5"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalHighTemperatureTimeDelay_5,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureTimeDelay_5",(tS32) 0xbe222692L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_CriticalHighTemperatureTimeDelay_5 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureTimeDelay_5", (tS32)0xbe222692L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_5, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalHighTemperatureTimeDelay_5;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::s32GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_5Param) { 
   vUpdate();
   tPDD_THM_CriticalHighTemperatureTimeDelay_5Param = tPDD_THM_CriticalHighTemperatureTimeDelay_5;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalHighTemperatureTimeDelay_5", (tS32)0xbe222692L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::s32SetData(tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::s32SetData(const tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::u8GetData(tU16& tPDD_THM_CriticalHighTemperatureTimeDelay_5Param) {  
   vUpdate();
   tPDD_THM_CriticalHighTemperatureTimeDelay_5Param = tPDD_THM_CriticalHighTemperatureTimeDelay_5;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::vSetData(tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::vSetData(const tU16 &tPDD_THM_CriticalHighTemperatureTimeDelay_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalHighTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_CriticalHighTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalHighTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureTimeDelay_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalHighTemperatureTimeDelay_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalHighTemperatureTimeDelay_5::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalHighTemperatureTimeDelay_5", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalHighTemperatureTimeDelay_5 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_HighTemperature_5"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_HighTemperature_5::dp_tclThmDpPDDPDD_THM_HighTemperature_5(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_HighTemperature_5,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_5::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperature_5",(tS32) 0x9c6e1605);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_HighTemperature_5 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_5::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperature_5", (tS32)0x9c6e1605);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_HighTemperature_5, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_HighTemperature_5::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_HighTemperature_5::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_HighTemperature_5::tGetData() {
   vUpdate();
   return tPDD_THM_HighTemperature_5;
};
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_5::s32GetData(tS16& tPDD_THM_HighTemperature_5Param) { 
   vUpdate();
   tPDD_THM_HighTemperature_5Param = tPDD_THM_HighTemperature_5;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_5::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperature_5", (tS32)0x9c6e1605);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_5::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_5::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_5::s32SetData(tS16 &tPDD_THM_HighTemperature_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_5,(tVoid*)&tPDD_THM_HighTemperature_5Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_5::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_HighTemperature_5::s32SetData(const tS16 &tPDD_THM_HighTemperature_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_5,(tVoid*)&tPDD_THM_HighTemperature_5Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_5::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_HighTemperature_5::u8GetData(tS16& tPDD_THM_HighTemperature_5Param) {  
   vUpdate();
   tPDD_THM_HighTemperature_5Param = tPDD_THM_HighTemperature_5;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_5::vSetData(tS16 &tPDD_THM_HighTemperature_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_5,(tVoid*)&tPDD_THM_HighTemperature_5Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_5::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_HighTemperature_5::vSetData(const tS16 &tPDD_THM_HighTemperature_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperature_5,(tVoid*)&tPDD_THM_HighTemperature_5Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperature_5::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_HighTemperature_5::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_HighTemperature_5::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperature_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperature_5::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperature_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperature_5::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_HighTemperature_5", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_HighTemperature_5 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_HighTemperatureHysteresis_5"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_HighTemperatureHysteresis_5,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureHysteresis_5",(tS32) 0xc97d5678L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_HighTemperatureHysteresis_5 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureHysteresis_5", (tS32)0xc97d5678L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_HighTemperatureHysteresis_5, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::tGetData() {
   vUpdate();
   return tPDD_THM_HighTemperatureHysteresis_5;
};
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::s32GetData(tU8& tPDD_THM_HighTemperatureHysteresis_5Param) { 
   vUpdate();
   tPDD_THM_HighTemperatureHysteresis_5Param = tPDD_THM_HighTemperatureHysteresis_5;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureHysteresis_5", (tS32)0xc97d5678L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::s32SetData(tU8 &tPDD_THM_HighTemperatureHysteresis_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_5,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::s32SetData(const tU8 &tPDD_THM_HighTemperatureHysteresis_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_5,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::u8GetData(tU8& tPDD_THM_HighTemperatureHysteresis_5Param) {  
   vUpdate();
   tPDD_THM_HighTemperatureHysteresis_5Param = tPDD_THM_HighTemperatureHysteresis_5;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::vSetData(tU8 &tPDD_THM_HighTemperatureHysteresis_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_5,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::vSetData(const tU8 &tPDD_THM_HighTemperatureHysteresis_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureHysteresis_5,(tVoid*)&tPDD_THM_HighTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureHysteresis_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureHysteresis_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureHysteresis_5::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_HighTemperatureHysteresis_5", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_HighTemperatureHysteresis_5 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_HighTemperatureTimeDelay_5"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_HighTemperatureTimeDelay_5,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureTimeDelay_5",(tS32) 0x6060ac8fL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_HighTemperatureTimeDelay_5 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureTimeDelay_5", (tS32)0x6060ac8fL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_HighTemperatureTimeDelay_5, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::tGetData() {
   vUpdate();
   return tPDD_THM_HighTemperatureTimeDelay_5;
};
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::s32GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_5Param) { 
   vUpdate();
   tPDD_THM_HighTemperatureTimeDelay_5Param = tPDD_THM_HighTemperatureTimeDelay_5;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_HighTemperatureTimeDelay_5", (tS32)0x6060ac8fL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::s32SetData(tU16 &tPDD_THM_HighTemperatureTimeDelay_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::s32SetData(const tU16 &tPDD_THM_HighTemperatureTimeDelay_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::u8GetData(tU16& tPDD_THM_HighTemperatureTimeDelay_5Param) {  
   vUpdate();
   tPDD_THM_HighTemperatureTimeDelay_5Param = tPDD_THM_HighTemperatureTimeDelay_5;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::vSetData(tU16 &tPDD_THM_HighTemperatureTimeDelay_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::vSetData(const tU16 &tPDD_THM_HighTemperatureTimeDelay_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_HighTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_HighTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_HighTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureTimeDelay_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_HighTemperatureTimeDelay_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_HighTemperatureTimeDelay_5::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_HighTemperatureTimeDelay_5", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_HighTemperatureTimeDelay_5 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_LowTemperature_5"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_LowTemperature_5::dp_tclThmDpPDDPDD_THM_LowTemperature_5(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_LowTemperature_5,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_5::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperature_5",(tS32) 0xb16b993b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_LowTemperature_5 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_5::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperature_5", (tS32)0xb16b993b);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_LowTemperature_5, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_LowTemperature_5::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_LowTemperature_5::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_LowTemperature_5::tGetData() {
   vUpdate();
   return tPDD_THM_LowTemperature_5;
};
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_5::s32GetData(tS16& tPDD_THM_LowTemperature_5Param) { 
   vUpdate();
   tPDD_THM_LowTemperature_5Param = tPDD_THM_LowTemperature_5;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_5::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperature_5", (tS32)0xb16b993b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_5::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_5::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_5::s32SetData(tS16 &tPDD_THM_LowTemperature_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_5,(tVoid*)&tPDD_THM_LowTemperature_5Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_5::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_LowTemperature_5::s32SetData(const tS16 &tPDD_THM_LowTemperature_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_5,(tVoid*)&tPDD_THM_LowTemperature_5Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_5::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_LowTemperature_5::u8GetData(tS16& tPDD_THM_LowTemperature_5Param) {  
   vUpdate();
   tPDD_THM_LowTemperature_5Param = tPDD_THM_LowTemperature_5;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_5::vSetData(tS16 &tPDD_THM_LowTemperature_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_5,(tVoid*)&tPDD_THM_LowTemperature_5Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_5::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_LowTemperature_5::vSetData(const tS16 &tPDD_THM_LowTemperature_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperature_5,(tVoid*)&tPDD_THM_LowTemperature_5Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperature_5::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_LowTemperature_5::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_LowTemperature_5::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperature_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperature_5::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperature_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperature_5::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_LowTemperature_5", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_LowTemperature_5 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_LowTemperatureHysteresis_5"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_LowTemperatureHysteresis_5,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureHysteresis_5",(tS32) 0x8d8661feL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_LowTemperatureHysteresis_5 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureHysteresis_5", (tS32)0x8d8661feL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_LowTemperatureHysteresis_5, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::tGetData() {
   vUpdate();
   return tPDD_THM_LowTemperatureHysteresis_5;
};
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::s32GetData(tU8& tPDD_THM_LowTemperatureHysteresis_5Param) { 
   vUpdate();
   tPDD_THM_LowTemperatureHysteresis_5Param = tPDD_THM_LowTemperatureHysteresis_5;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureHysteresis_5", (tS32)0x8d8661feL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::s32SetData(tU8 &tPDD_THM_LowTemperatureHysteresis_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_5,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::s32SetData(const tU8 &tPDD_THM_LowTemperatureHysteresis_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_5,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::u8GetData(tU8& tPDD_THM_LowTemperatureHysteresis_5Param) {  
   vUpdate();
   tPDD_THM_LowTemperatureHysteresis_5Param = tPDD_THM_LowTemperatureHysteresis_5;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::vSetData(tU8 &tPDD_THM_LowTemperatureHysteresis_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_5,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::vSetData(const tU8 &tPDD_THM_LowTemperatureHysteresis_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureHysteresis_5,(tVoid*)&tPDD_THM_LowTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureHysteresis_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureHysteresis_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureHysteresis_5::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_LowTemperatureHysteresis_5", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_LowTemperatureHysteresis_5 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_LowTemperatureTimeDelay_5"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_LowTemperatureTimeDelay_5,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureTimeDelay_5",(tS32) 0x8795aeddL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_LowTemperatureTimeDelay_5 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureTimeDelay_5", (tS32)0x8795aeddL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_LowTemperatureTimeDelay_5, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::tGetData() {
   vUpdate();
   return tPDD_THM_LowTemperatureTimeDelay_5;
};
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::s32GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_5Param) { 
   vUpdate();
   tPDD_THM_LowTemperatureTimeDelay_5Param = tPDD_THM_LowTemperatureTimeDelay_5;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_LowTemperatureTimeDelay_5", (tS32)0x8795aeddL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::s32SetData(tU16 &tPDD_THM_LowTemperatureTimeDelay_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::s32SetData(const tU16 &tPDD_THM_LowTemperatureTimeDelay_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::u8GetData(tU16& tPDD_THM_LowTemperatureTimeDelay_5Param) {  
   vUpdate();
   tPDD_THM_LowTemperatureTimeDelay_5Param = tPDD_THM_LowTemperatureTimeDelay_5;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::vSetData(tU16 &tPDD_THM_LowTemperatureTimeDelay_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::vSetData(const tU16 &tPDD_THM_LowTemperatureTimeDelay_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_LowTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_LowTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_LowTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureTimeDelay_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_LowTemperatureTimeDelay_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_LowTemperatureTimeDelay_5::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_LowTemperatureTimeDelay_5", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_LowTemperatureTimeDelay_5 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalLowTemperature_5"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalLowTemperature_5,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperature_5",(tS32) 0x93dfc116L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPDD_THM_CriticalLowTemperature_5 = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperature_5", (tS32)0x93dfc116L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalLowTemperature_5, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalLowTemperature_5;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::s32GetData(tS16& tPDD_THM_CriticalLowTemperature_5Param) { 
   vUpdate();
   tPDD_THM_CriticalLowTemperature_5Param = tPDD_THM_CriticalLowTemperature_5;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperature_5", (tS32)0x93dfc116L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::s32SetData(tS16 &tPDD_THM_CriticalLowTemperature_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_5,(tVoid*)&tPDD_THM_CriticalLowTemperature_5Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::vSetData(tS16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::s32SetData(const tS16 &tPDD_THM_CriticalLowTemperature_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_5,(tVoid*)&tPDD_THM_CriticalLowTemperature_5Param, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::u8GetData(tS16& tPDD_THM_CriticalLowTemperature_5Param) {  
   vUpdate();
   tPDD_THM_CriticalLowTemperature_5Param = tPDD_THM_CriticalLowTemperature_5;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::vSetData(tS16 &tPDD_THM_CriticalLowTemperature_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_5,(tVoid*)&tPDD_THM_CriticalLowTemperature_5Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::vSetData(tS16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::vSetData(const tS16 &tPDD_THM_CriticalLowTemperature_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperature_5,(tVoid*)&tPDD_THM_CriticalLowTemperature_5Param, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperature_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::vSetData(tS16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperature_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperature_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperature_5::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalLowTemperature_5", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalLowTemperature_5 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalLowTemperatureHysteresis_5"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalLowTemperatureHysteresis_5,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureHysteresis_5",(tS32) 0xeb47dc01L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_CriticalLowTemperatureHysteresis_5 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureHysteresis_5", (tS32)0xeb47dc01L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_5, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalLowTemperatureHysteresis_5;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::s32GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_5Param) { 
   vUpdate();
   tPDD_THM_CriticalLowTemperatureHysteresis_5Param = tPDD_THM_CriticalLowTemperatureHysteresis_5;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureHysteresis_5", (tS32)0xeb47dc01L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::s32SetData(tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_5,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::s32SetData(const tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_5,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::u8GetData(tU8& tPDD_THM_CriticalLowTemperatureHysteresis_5Param) {  
   vUpdate();
   tPDD_THM_CriticalLowTemperatureHysteresis_5Param = tPDD_THM_CriticalLowTemperatureHysteresis_5;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::vSetData(tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_5,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::vSetData(const tU8 &tPDD_THM_CriticalLowTemperatureHysteresis_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureHysteresis_5,(tVoid*)&tPDD_THM_CriticalLowTemperatureHysteresis_5Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureHysteresis_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureHysteresis_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureHysteresis_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureHysteresis_5::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalLowTemperatureHysteresis_5", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalLowTemperatureHysteresis_5 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_CriticalLowTemperatureTimeDelay_5"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_CriticalLowTemperatureTimeDelay_5,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureTimeDelay_5",(tS32) 0x6722c744L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPDD_THM_CriticalLowTemperatureTimeDelay_5 = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureTimeDelay_5", (tS32)0x6722c744L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_5, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::tGetData() {
   vUpdate();
   return tPDD_THM_CriticalLowTemperatureTimeDelay_5;
};
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::s32GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_5Param) { 
   vUpdate();
   tPDD_THM_CriticalLowTemperatureTimeDelay_5Param = tPDD_THM_CriticalLowTemperatureTimeDelay_5;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_CriticalLowTemperatureTimeDelay_5", (tS32)0x6722c744L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::s32SetData(tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::s32SetData(const tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_5Param) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::u8GetData(tU16& tPDD_THM_CriticalLowTemperatureTimeDelay_5Param) {  
   vUpdate();
   tPDD_THM_CriticalLowTemperatureTimeDelay_5Param = tPDD_THM_CriticalLowTemperatureTimeDelay_5;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::vSetData(tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::vSetData(const tU16 &tPDD_THM_CriticalLowTemperatureTimeDelay_5Param) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_CriticalLowTemperatureTimeDelay_5,(tVoid*)&tPDD_THM_CriticalLowTemperatureTimeDelay_5Param, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_CriticalLowTemperatureTimeDelay_5Param' in function 'dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::vSetData(tU16)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureTimeDelay_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_CriticalLowTemperatureTimeDelay_5", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_CriticalLowTemperatureTimeDelay_5::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_CriticalLowTemperatureTimeDelay_5", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_CriticalLowTemperatureTimeDelay_5 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PDD_THM_RESERVED"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclThmDpPDDPDD_THM_RESERVED::dp_tclThmDpPDDPDD_THM_RESERVED(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPDD_THM_RESERVED,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclThmDpPDDPDD_THM_RESERVED::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PDD_THM_RESERVED",(tS32) 0xf583858b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPDD_THM_RESERVED = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclThmDpPDDPDD_THM_RESERVED::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PDD_THM_RESERVED", (tS32)0xf583858b);
   (tVoid)myDpElem.bFillData((tVoid*)&tPDD_THM_RESERVED, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclThmDpPDDPDD_THM_RESERVED::s32GetStatus() const {return _s32Status;};
tU8   dp_tclThmDpPDDPDD_THM_RESERVED::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclThmDpPDDPDD_THM_RESERVED::tGetData() {
   vUpdate();
   return tPDD_THM_RESERVED;
};
tS32 dp_tclThmDpPDDPDD_THM_RESERVED::s32GetData(tU8& tPDD_THM_RESERVEDParam) { 
   vUpdate();
   tPDD_THM_RESERVEDParam = tPDD_THM_RESERVED;
   return _s32Status;
}
tS32 dp_tclThmDpPDDPDD_THM_RESERVED::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PDD_THM_RESERVED", (tS32)0xf583858b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_THMDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclThmDpPDDPDD_THM_RESERVED::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclThmDpPDDPDD_THM_RESERVED::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclThmDpPDDPDD_THM_RESERVED::s32SetData(tU8 &tPDD_THM_RESERVEDParam) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_RESERVED,(tVoid*)&tPDD_THM_RESERVEDParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_RESERVEDParam' in function 'dp_tclThmDpPDDPDD_THM_RESERVED::vSetData(tU8)' could be made const reference
tS32 dp_tclThmDpPDDPDD_THM_RESERVED::s32SetData(const tU8 &tPDD_THM_RESERVEDParam) {
   //init parameter
   (tVoid)memcpy(&tPDD_THM_RESERVED,(tVoid*)&tPDD_THM_RESERVEDParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPDD_THM_RESERVEDParam' in function 'dp_tclThmDpPDDPDD_THM_RESERVED::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclThmDpPDDPDD_THM_RESERVED::u8GetData(tU8& tPDD_THM_RESERVEDParam) {  
   vUpdate();
   tPDD_THM_RESERVEDParam = tPDD_THM_RESERVED;
   return _u8DataStatus;
}
tVoid dp_tclThmDpPDDPDD_THM_RESERVED::vSetData(tU8 &tPDD_THM_RESERVEDParam) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_RESERVED,(tVoid*)&tPDD_THM_RESERVEDParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_RESERVEDParam' in function 'dp_tclThmDpPDDPDD_THM_RESERVED::vSetData(tU8)' could be made const reference
tVoid dp_tclThmDpPDDPDD_THM_RESERVED::vSetData(const tU8 &tPDD_THM_RESERVEDParam) { 
   //init parameter
   (tVoid)memcpy(&tPDD_THM_RESERVED,(tVoid*)&tPDD_THM_RESERVEDParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPDD_THM_RESERVEDParam' in function 'dp_tclThmDpPDDPDD_THM_RESERVED::vSetData(tU8)' could be made const reference
tU8   dp_tclThmDpPDDPDD_THM_RESERVED::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclThmDpPDDPDD_THM_RESERVED::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_RESERVED", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_RESERVED::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_THMDPPDD, "PDD_THM_RESERVED", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclThmDpPDDPDD_THM_RESERVED::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PDD_THM_RESERVED", DP_U32_POOL_ID_THMDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_THMDPPDD);
   }
   else
   {
      fprintf(stdout,"Element PDD_THM_RESERVED has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
