
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclHeatCtrlDP.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SYSTEMSHUTDOWN_ENABLE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE::dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tSYSTEMSHUTDOWN_ENABLE(FALSE)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/EF/SYSTEMSHUTDOWN";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("ENABLE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tSYSTEMSHUTDOWN_ENABLE = (tBool)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE::u8GetData(tBool& tSYSTEMSHUTDOWN_ENABLEParam) {
   vUpdate();
   tSYSTEMSHUTDOWN_ENABLEParam = tSYSTEMSHUTDOWN_ENABLE;
   return _u8DataStatus;
}
tBool dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE::tGetData() {
   vUpdate();
   return tSYSTEMSHUTDOWN_ENABLE;
};

tU8 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SYSTEMSHUTDOWN_DELAY"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY::dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tSYSTEMSHUTDOWN_DELAY(5)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/EF/SYSTEMSHUTDOWN";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("DELAY",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tSYSTEMSHUTDOWN_DELAY = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY::u8GetData(tU8& tSYSTEMSHUTDOWN_DELAYParam) {
   vUpdate();
   tSYSTEMSHUTDOWN_DELAYParam = tSYSTEMSHUTDOWN_DELAY;
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY::tGetData() {
   vUpdate();
   return tSYSTEMSHUTDOWN_DELAY;
};

tU8 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SYSTEMSHUTDOWN_ENABLE_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSYSTEMSHUTDOWN_ENABLE_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SYSTEMSHUTDOWN_ENABLE_Develop",(tS32) 0x9494d109L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSYSTEMSHUTDOWN_ENABLE_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SYSTEMSHUTDOWN_ENABLE_Develop", (tS32)0x9494d109L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSYSTEMSHUTDOWN_ENABLE_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::tGetData() {
   vUpdate();
   return tSYSTEMSHUTDOWN_ENABLE_Develop;
};
tS32 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::s32GetData(tU8& tSYSTEMSHUTDOWN_ENABLE_DevelopParam) { 
   vUpdate();
   tSYSTEMSHUTDOWN_ENABLE_DevelopParam = tSYSTEMSHUTDOWN_ENABLE_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SYSTEMSHUTDOWN_ENABLE_Develop", (tS32)0x9494d109L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::s32SetData(tU8 &tSYSTEMSHUTDOWN_ENABLE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tSYSTEMSHUTDOWN_ENABLE_Develop,(tVoid*)&tSYSTEMSHUTDOWN_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSYSTEMSHUTDOWN_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::s32SetData(const tU8 &tSYSTEMSHUTDOWN_ENABLE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tSYSTEMSHUTDOWN_ENABLE_Develop,(tVoid*)&tSYSTEMSHUTDOWN_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSYSTEMSHUTDOWN_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::u8GetData(tU8& tSYSTEMSHUTDOWN_ENABLE_DevelopParam) {  
   vUpdate();
   tSYSTEMSHUTDOWN_ENABLE_DevelopParam = tSYSTEMSHUTDOWN_ENABLE_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::vSetData(tU8 &tSYSTEMSHUTDOWN_ENABLE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tSYSTEMSHUTDOWN_ENABLE_Develop,(tVoid*)&tSYSTEMSHUTDOWN_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSYSTEMSHUTDOWN_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::vSetData(const tU8 &tSYSTEMSHUTDOWN_ENABLE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tSYSTEMSHUTDOWN_ENABLE_Develop,(tVoid*)&tSYSTEMSHUTDOWN_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSYSTEMSHUTDOWN_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSTEMSHUTDOWN_ENABLE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSTEMSHUTDOWN_ENABLE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPSYSTEMSHUTDOWN_ENABLE_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SYSTEMSHUTDOWN_ENABLE_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element SYSTEMSHUTDOWN_ENABLE_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SYSTEMSHUTDOWN_DELAY_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSYSTEMSHUTDOWN_DELAY_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SYSTEMSHUTDOWN_DELAY_Develop",(tS32) 0x95433991L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSYSTEMSHUTDOWN_DELAY_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SYSTEMSHUTDOWN_DELAY_Develop", (tS32)0x95433991L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSYSTEMSHUTDOWN_DELAY_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::tGetData() {
   vUpdate();
   return tSYSTEMSHUTDOWN_DELAY_Develop;
};
tS32 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::s32GetData(tU8& tSYSTEMSHUTDOWN_DELAY_DevelopParam) { 
   vUpdate();
   tSYSTEMSHUTDOWN_DELAY_DevelopParam = tSYSTEMSHUTDOWN_DELAY_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SYSTEMSHUTDOWN_DELAY_Develop", (tS32)0x95433991L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::s32SetData(tU8 &tSYSTEMSHUTDOWN_DELAY_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tSYSTEMSHUTDOWN_DELAY_Develop,(tVoid*)&tSYSTEMSHUTDOWN_DELAY_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSYSTEMSHUTDOWN_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::s32SetData(const tU8 &tSYSTEMSHUTDOWN_DELAY_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tSYSTEMSHUTDOWN_DELAY_Develop,(tVoid*)&tSYSTEMSHUTDOWN_DELAY_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSYSTEMSHUTDOWN_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::u8GetData(tU8& tSYSTEMSHUTDOWN_DELAY_DevelopParam) {  
   vUpdate();
   tSYSTEMSHUTDOWN_DELAY_DevelopParam = tSYSTEMSHUTDOWN_DELAY_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::vSetData(tU8 &tSYSTEMSHUTDOWN_DELAY_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tSYSTEMSHUTDOWN_DELAY_Develop,(tVoid*)&tSYSTEMSHUTDOWN_DELAY_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSYSTEMSHUTDOWN_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::vSetData(const tU8 &tSYSTEMSHUTDOWN_DELAY_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tSYSTEMSHUTDOWN_DELAY_Develop,(tVoid*)&tSYSTEMSHUTDOWN_DELAY_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSYSTEMSHUTDOWN_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSTEMSHUTDOWN_DELAY_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSTEMSHUTDOWN_DELAY_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPSYSTEMSHUTDOWN_DELAY_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SYSTEMSHUTDOWN_DELAY_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element SYSTEMSHUTDOWN_DELAY_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BACKLIGHT_OFF_ENABLE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE::dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tBACKLIGHT_OFF_ENABLE(FALSE)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/EF/BACKLIGHTOFF";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("ENABLE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tBACKLIGHT_OFF_ENABLE = (tBool)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE::u8GetData(tBool& tBACKLIGHT_OFF_ENABLEParam) {
   vUpdate();
   tBACKLIGHT_OFF_ENABLEParam = tBACKLIGHT_OFF_ENABLE;
   return _u8DataStatus;
}
tBool dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE::tGetData() {
   vUpdate();
   return tBACKLIGHT_OFF_ENABLE;
};

tU8 dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BACKLIGHT_OFF_DELAY"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY::dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tBACKLIGHT_OFF_DELAY(5)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/EF/BACKLIGHTOFF";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("DELAY",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tBACKLIGHT_OFF_DELAY = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY::u8GetData(tU8& tBACKLIGHT_OFF_DELAYParam) {
   vUpdate();
   tBACKLIGHT_OFF_DELAYParam = tBACKLIGHT_OFF_DELAY;
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY::tGetData() {
   vUpdate();
   return tBACKLIGHT_OFF_DELAY;
};

tU8 dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BACKLIGHT_OFF_ENABLE_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBACKLIGHT_OFF_ENABLE_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("BACKLIGHT_OFF_ENABLE_Develop",(tS32) 0x71aee12bL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tBACKLIGHT_OFF_ENABLE_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("BACKLIGHT_OFF_ENABLE_Develop", (tS32)0x71aee12bL);
   (tVoid)myDpElem.bFillData((tVoid*)&tBACKLIGHT_OFF_ENABLE_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::tGetData() {
   vUpdate();
   return tBACKLIGHT_OFF_ENABLE_Develop;
};
tS32 dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::s32GetData(tU8& tBACKLIGHT_OFF_ENABLE_DevelopParam) { 
   vUpdate();
   tBACKLIGHT_OFF_ENABLE_DevelopParam = tBACKLIGHT_OFF_ENABLE_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("BACKLIGHT_OFF_ENABLE_Develop", (tS32)0x71aee12bL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::s32SetData(tU8 &tBACKLIGHT_OFF_ENABLE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tBACKLIGHT_OFF_ENABLE_Develop,(tVoid*)&tBACKLIGHT_OFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBACKLIGHT_OFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::s32SetData(const tU8 &tBACKLIGHT_OFF_ENABLE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tBACKLIGHT_OFF_ENABLE_Develop,(tVoid*)&tBACKLIGHT_OFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBACKLIGHT_OFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::u8GetData(tU8& tBACKLIGHT_OFF_ENABLE_DevelopParam) {  
   vUpdate();
   tBACKLIGHT_OFF_ENABLE_DevelopParam = tBACKLIGHT_OFF_ENABLE_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::vSetData(tU8 &tBACKLIGHT_OFF_ENABLE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tBACKLIGHT_OFF_ENABLE_Develop,(tVoid*)&tBACKLIGHT_OFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tBACKLIGHT_OFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::vSetData(const tU8 &tBACKLIGHT_OFF_ENABLE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tBACKLIGHT_OFF_ENABLE_Develop,(tVoid*)&tBACKLIGHT_OFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tBACKLIGHT_OFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "BACKLIGHT_OFF_ENABLE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "BACKLIGHT_OFF_ENABLE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPBACKLIGHT_OFF_ENABLE_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BACKLIGHT_OFF_ENABLE_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element BACKLIGHT_OFF_ENABLE_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BACKLIGHT_OFF_DELAY_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBACKLIGHT_OFF_DELAY_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("BACKLIGHT_OFF_DELAY_Develop",(tS32) 0x5b153ccbL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tBACKLIGHT_OFF_DELAY_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("BACKLIGHT_OFF_DELAY_Develop", (tS32)0x5b153ccbL);
   (tVoid)myDpElem.bFillData((tVoid*)&tBACKLIGHT_OFF_DELAY_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::tGetData() {
   vUpdate();
   return tBACKLIGHT_OFF_DELAY_Develop;
};
tS32 dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::s32GetData(tU8& tBACKLIGHT_OFF_DELAY_DevelopParam) { 
   vUpdate();
   tBACKLIGHT_OFF_DELAY_DevelopParam = tBACKLIGHT_OFF_DELAY_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("BACKLIGHT_OFF_DELAY_Develop", (tS32)0x5b153ccbL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::s32SetData(tU8 &tBACKLIGHT_OFF_DELAY_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tBACKLIGHT_OFF_DELAY_Develop,(tVoid*)&tBACKLIGHT_OFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBACKLIGHT_OFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::s32SetData(const tU8 &tBACKLIGHT_OFF_DELAY_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tBACKLIGHT_OFF_DELAY_Develop,(tVoid*)&tBACKLIGHT_OFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBACKLIGHT_OFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::u8GetData(tU8& tBACKLIGHT_OFF_DELAY_DevelopParam) {  
   vUpdate();
   tBACKLIGHT_OFF_DELAY_DevelopParam = tBACKLIGHT_OFF_DELAY_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::vSetData(tU8 &tBACKLIGHT_OFF_DELAY_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tBACKLIGHT_OFF_DELAY_Develop,(tVoid*)&tBACKLIGHT_OFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tBACKLIGHT_OFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::vSetData(const tU8 &tBACKLIGHT_OFF_DELAY_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tBACKLIGHT_OFF_DELAY_Develop,(tVoid*)&tBACKLIGHT_OFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tBACKLIGHT_OFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "BACKLIGHT_OFF_DELAY_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "BACKLIGHT_OFF_DELAY_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPBACKLIGHT_OFF_DELAY_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BACKLIGHT_OFF_DELAY_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element BACKLIGHT_OFF_DELAY_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ATTENUATION_ENABLE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPATTENUATION_ENABLE::dp_tclHeatCtrlDPATTENUATION_ENABLE() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tATTENUATION_ENABLE(FALSE)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPATTENUATION_ENABLE::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/EF/ATTENUATION";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("ENABLE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tATTENUATION_ENABLE = (tBool)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPATTENUATION_ENABLE::u8GetData(tBool& tATTENUATION_ENABLEParam) {
   vUpdate();
   tATTENUATION_ENABLEParam = tATTENUATION_ENABLE;
   return _u8DataStatus;
}
tBool dp_tclHeatCtrlDPATTENUATION_ENABLE::tGetData() {
   vUpdate();
   return tATTENUATION_ENABLE;
};

tU8 dp_tclHeatCtrlDPATTENUATION_ENABLE::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPATTENUATION_ENABLE::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ATTENUATION_DELAY"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPATTENUATION_DELAY::dp_tclHeatCtrlDPATTENUATION_DELAY() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tATTENUATION_DELAY(0)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPATTENUATION_DELAY::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/EF/ATTENUATION";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("DELAY",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tATTENUATION_DELAY = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPATTENUATION_DELAY::u8GetData(tU8& tATTENUATION_DELAYParam) {
   vUpdate();
   tATTENUATION_DELAYParam = tATTENUATION_DELAY;
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPATTENUATION_DELAY::tGetData() {
   vUpdate();
   return tATTENUATION_DELAY;
};

tU8 dp_tclHeatCtrlDPATTENUATION_DELAY::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPATTENUATION_DELAY::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ATTENUATION_CYCLETIME"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPATTENUATION_CYCLETIME::dp_tclHeatCtrlDPATTENUATION_CYCLETIME() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tATTENUATION_CYCLETIME(60)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPATTENUATION_CYCLETIME::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/EF/ATTENUATION";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CYCLETIME",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tATTENUATION_CYCLETIME = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPATTENUATION_CYCLETIME::u8GetData(tU8& tATTENUATION_CYCLETIMEParam) {
   vUpdate();
   tATTENUATION_CYCLETIMEParam = tATTENUATION_CYCLETIME;
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPATTENUATION_CYCLETIME::tGetData() {
   vUpdate();
   return tATTENUATION_CYCLETIME;
};

tU8 dp_tclHeatCtrlDPATTENUATION_CYCLETIME::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPATTENUATION_CYCLETIME::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ATTENUATION_ENABLE_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tATTENUATION_ENABLE_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ATTENUATION_ENABLE_Develop",(tS32) 0xe05f1544L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tATTENUATION_ENABLE_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ATTENUATION_ENABLE_Develop", (tS32)0xe05f1544L);
   (tVoid)myDpElem.bFillData((tVoid*)&tATTENUATION_ENABLE_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::tGetData() {
   vUpdate();
   return tATTENUATION_ENABLE_Develop;
};
tS32 dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::s32GetData(tU8& tATTENUATION_ENABLE_DevelopParam) { 
   vUpdate();
   tATTENUATION_ENABLE_DevelopParam = tATTENUATION_ENABLE_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ATTENUATION_ENABLE_Develop", (tS32)0xe05f1544L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::s32SetData(tU8 &tATTENUATION_ENABLE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tATTENUATION_ENABLE_Develop,(tVoid*)&tATTENUATION_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tATTENUATION_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::s32SetData(const tU8 &tATTENUATION_ENABLE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tATTENUATION_ENABLE_Develop,(tVoid*)&tATTENUATION_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tATTENUATION_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::u8GetData(tU8& tATTENUATION_ENABLE_DevelopParam) {  
   vUpdate();
   tATTENUATION_ENABLE_DevelopParam = tATTENUATION_ENABLE_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::vSetData(tU8 &tATTENUATION_ENABLE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tATTENUATION_ENABLE_Develop,(tVoid*)&tATTENUATION_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tATTENUATION_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::vSetData(const tU8 &tATTENUATION_ENABLE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tATTENUATION_ENABLE_Develop,(tVoid*)&tATTENUATION_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tATTENUATION_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "ATTENUATION_ENABLE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "ATTENUATION_ENABLE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPATTENUATION_ENABLE_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ATTENUATION_ENABLE_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element ATTENUATION_ENABLE_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ATTENUATION_DELAY_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::dp_tclHeatCtrlDPATTENUATION_DELAY_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tATTENUATION_DELAY_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ATTENUATION_DELAY_Develop",(tS32) 0xd79ee0d0);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tATTENUATION_DELAY_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ATTENUATION_DELAY_Develop", (tS32)0xd79ee0d0);
   (tVoid)myDpElem.bFillData((tVoid*)&tATTENUATION_DELAY_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::tGetData() {
   vUpdate();
   return tATTENUATION_DELAY_Develop;
};
tS32 dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::s32GetData(tU8& tATTENUATION_DELAY_DevelopParam) { 
   vUpdate();
   tATTENUATION_DELAY_DevelopParam = tATTENUATION_DELAY_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ATTENUATION_DELAY_Develop", (tS32)0xd79ee0d0);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::s32SetData(tU8 &tATTENUATION_DELAY_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tATTENUATION_DELAY_Develop,(tVoid*)&tATTENUATION_DELAY_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tATTENUATION_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::s32SetData(const tU8 &tATTENUATION_DELAY_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tATTENUATION_DELAY_Develop,(tVoid*)&tATTENUATION_DELAY_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tATTENUATION_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::u8GetData(tU8& tATTENUATION_DELAY_DevelopParam) {  
   vUpdate();
   tATTENUATION_DELAY_DevelopParam = tATTENUATION_DELAY_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::vSetData(tU8 &tATTENUATION_DELAY_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tATTENUATION_DELAY_Develop,(tVoid*)&tATTENUATION_DELAY_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tATTENUATION_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::vSetData(const tU8 &tATTENUATION_DELAY_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tATTENUATION_DELAY_Develop,(tVoid*)&tATTENUATION_DELAY_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tATTENUATION_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "ATTENUATION_DELAY_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "ATTENUATION_DELAY_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPATTENUATION_DELAY_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ATTENUATION_DELAY_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element ATTENUATION_DELAY_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ATTENUATION_CYCLETIME_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tATTENUATION_CYCLETIME_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ATTENUATION_CYCLETIME_Develop",(tS32) 0x11c23f60L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tATTENUATION_CYCLETIME_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ATTENUATION_CYCLETIME_Develop", (tS32)0x11c23f60L);
   (tVoid)myDpElem.bFillData((tVoid*)&tATTENUATION_CYCLETIME_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::tGetData() {
   vUpdate();
   return tATTENUATION_CYCLETIME_Develop;
};
tS32 dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::s32GetData(tU8& tATTENUATION_CYCLETIME_DevelopParam) { 
   vUpdate();
   tATTENUATION_CYCLETIME_DevelopParam = tATTENUATION_CYCLETIME_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ATTENUATION_CYCLETIME_Develop", (tS32)0x11c23f60L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::s32SetData(tU8 &tATTENUATION_CYCLETIME_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tATTENUATION_CYCLETIME_Develop,(tVoid*)&tATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::s32SetData(const tU8 &tATTENUATION_CYCLETIME_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tATTENUATION_CYCLETIME_Develop,(tVoid*)&tATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::u8GetData(tU8& tATTENUATION_CYCLETIME_DevelopParam) {  
   vUpdate();
   tATTENUATION_CYCLETIME_DevelopParam = tATTENUATION_CYCLETIME_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::vSetData(tU8 &tATTENUATION_CYCLETIME_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tATTENUATION_CYCLETIME_Develop,(tVoid*)&tATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::vSetData(const tU8 &tATTENUATION_CYCLETIME_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tATTENUATION_CYCLETIME_Develop,(tVoid*)&tATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "ATTENUATION_CYCLETIME_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "ATTENUATION_CYCLETIME_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPATTENUATION_CYCLETIME_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ATTENUATION_CYCLETIME_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element ATTENUATION_CYCLETIME_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CDDRIVEOFF_ENABLE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE::dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCDDRIVEOFF_ENABLE(FALSE)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/EF/CDDRIVEOFF";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("ENABLE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCDDRIVEOFF_ENABLE = (tBool)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE::u8GetData(tBool& tCDDRIVEOFF_ENABLEParam) {
   vUpdate();
   tCDDRIVEOFF_ENABLEParam = tCDDRIVEOFF_ENABLE;
   return _u8DataStatus;
}
tBool dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE::tGetData() {
   vUpdate();
   return tCDDRIVEOFF_ENABLE;
};

tU8 dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CDDRIVEOFF_DELAY"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCDDRIVEOFF_DELAY::dp_tclHeatCtrlDPCDDRIVEOFF_DELAY() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCDDRIVEOFF_DELAY(0)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCDDRIVEOFF_DELAY::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/EF/CDDRIVEOFF";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("DELAY",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCDDRIVEOFF_DELAY = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCDDRIVEOFF_DELAY::u8GetData(tU8& tCDDRIVEOFF_DELAYParam) {
   vUpdate();
   tCDDRIVEOFF_DELAYParam = tCDDRIVEOFF_DELAY;
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPCDDRIVEOFF_DELAY::tGetData() {
   vUpdate();
   return tCDDRIVEOFF_DELAY;
};

tU8 dp_tclHeatCtrlDPCDDRIVEOFF_DELAY::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCDDRIVEOFF_DELAY::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CDDRIVEOFF_ENABLE_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCDDRIVEOFF_ENABLE_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CDDRIVEOFF_ENABLE_Develop",(tS32) 0x13231cd4);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCDDRIVEOFF_ENABLE_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CDDRIVEOFF_ENABLE_Develop", (tS32)0x13231cd4);
   (tVoid)myDpElem.bFillData((tVoid*)&tCDDRIVEOFF_ENABLE_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::tGetData() {
   vUpdate();
   return tCDDRIVEOFF_ENABLE_Develop;
};
tS32 dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::s32GetData(tU8& tCDDRIVEOFF_ENABLE_DevelopParam) { 
   vUpdate();
   tCDDRIVEOFF_ENABLE_DevelopParam = tCDDRIVEOFF_ENABLE_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CDDRIVEOFF_ENABLE_Develop", (tS32)0x13231cd4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::s32SetData(tU8 &tCDDRIVEOFF_ENABLE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCDDRIVEOFF_ENABLE_Develop,(tVoid*)&tCDDRIVEOFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCDDRIVEOFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::s32SetData(const tU8 &tCDDRIVEOFF_ENABLE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCDDRIVEOFF_ENABLE_Develop,(tVoid*)&tCDDRIVEOFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCDDRIVEOFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::u8GetData(tU8& tCDDRIVEOFF_ENABLE_DevelopParam) {  
   vUpdate();
   tCDDRIVEOFF_ENABLE_DevelopParam = tCDDRIVEOFF_ENABLE_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::vSetData(tU8 &tCDDRIVEOFF_ENABLE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCDDRIVEOFF_ENABLE_Develop,(tVoid*)&tCDDRIVEOFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCDDRIVEOFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::vSetData(const tU8 &tCDDRIVEOFF_ENABLE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCDDRIVEOFF_ENABLE_Develop,(tVoid*)&tCDDRIVEOFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCDDRIVEOFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CDDRIVEOFF_ENABLE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CDDRIVEOFF_ENABLE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCDDRIVEOFF_ENABLE_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CDDRIVEOFF_ENABLE_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CDDRIVEOFF_ENABLE_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CDDRIVEOFF_DELAY_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCDDRIVEOFF_DELAY_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CDDRIVEOFF_DELAY_Develop",(tS32) 0x7b5faf20);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCDDRIVEOFF_DELAY_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CDDRIVEOFF_DELAY_Develop", (tS32)0x7b5faf20);
   (tVoid)myDpElem.bFillData((tVoid*)&tCDDRIVEOFF_DELAY_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::tGetData() {
   vUpdate();
   return tCDDRIVEOFF_DELAY_Develop;
};
tS32 dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::s32GetData(tU8& tCDDRIVEOFF_DELAY_DevelopParam) { 
   vUpdate();
   tCDDRIVEOFF_DELAY_DevelopParam = tCDDRIVEOFF_DELAY_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CDDRIVEOFF_DELAY_Develop", (tS32)0x7b5faf20);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::s32SetData(tU8 &tCDDRIVEOFF_DELAY_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCDDRIVEOFF_DELAY_Develop,(tVoid*)&tCDDRIVEOFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCDDRIVEOFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::s32SetData(const tU8 &tCDDRIVEOFF_DELAY_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCDDRIVEOFF_DELAY_Develop,(tVoid*)&tCDDRIVEOFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCDDRIVEOFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::u8GetData(tU8& tCDDRIVEOFF_DELAY_DevelopParam) {  
   vUpdate();
   tCDDRIVEOFF_DELAY_DevelopParam = tCDDRIVEOFF_DELAY_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::vSetData(tU8 &tCDDRIVEOFF_DELAY_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCDDRIVEOFF_DELAY_Develop,(tVoid*)&tCDDRIVEOFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCDDRIVEOFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::vSetData(const tU8 &tCDDRIVEOFF_DELAY_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCDDRIVEOFF_DELAY_Develop,(tVoid*)&tCDDRIVEOFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCDDRIVEOFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CDDRIVEOFF_DELAY_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CDDRIVEOFF_DELAY_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCDDRIVEOFF_DELAY_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CDDRIVEOFF_DELAY_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CDDRIVEOFF_DELAY_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVDDRIVEOFF_ENABLE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE::dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVDDRIVEOFF_ENABLE(FALSE)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/EF/DVDDRIVEOFF";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("ENABLE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVDDRIVEOFF_ENABLE = (tBool)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE::u8GetData(tBool& tDVDDRIVEOFF_ENABLEParam) {
   vUpdate();
   tDVDDRIVEOFF_ENABLEParam = tDVDDRIVEOFF_ENABLE;
   return _u8DataStatus;
}
tBool dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE::tGetData() {
   vUpdate();
   return tDVDDRIVEOFF_ENABLE;
};

tU8 dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVDDRIVEOFF_DELAY"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY::dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVDDRIVEOFF_DELAY(0)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/EF/DVDDRIVEOFF";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("DELAY",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVDDRIVEOFF_DELAY = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY::u8GetData(tU8& tDVDDRIVEOFF_DELAYParam) {
   vUpdate();
   tDVDDRIVEOFF_DELAYParam = tDVDDRIVEOFF_DELAY;
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY::tGetData() {
   vUpdate();
   return tDVDDRIVEOFF_DELAY;
};

tU8 dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVDDRIVEOFF_ENABLE_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVDDRIVEOFF_ENABLE_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVDDRIVEOFF_ENABLE_Develop",(tS32) 0x1484599bL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDVDDRIVEOFF_ENABLE_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVDDRIVEOFF_ENABLE_Develop", (tS32)0x1484599bL);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVDDRIVEOFF_ENABLE_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::tGetData() {
   vUpdate();
   return tDVDDRIVEOFF_ENABLE_Develop;
};
tS32 dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::s32GetData(tU8& tDVDDRIVEOFF_ENABLE_DevelopParam) { 
   vUpdate();
   tDVDDRIVEOFF_ENABLE_DevelopParam = tDVDDRIVEOFF_ENABLE_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVDDRIVEOFF_ENABLE_Develop", (tS32)0x1484599bL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::s32SetData(tU8 &tDVDDRIVEOFF_ENABLE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVDDRIVEOFF_ENABLE_Develop,(tVoid*)&tDVDDRIVEOFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVDDRIVEOFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::s32SetData(const tU8 &tDVDDRIVEOFF_ENABLE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVDDRIVEOFF_ENABLE_Develop,(tVoid*)&tDVDDRIVEOFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVDDRIVEOFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::u8GetData(tU8& tDVDDRIVEOFF_ENABLE_DevelopParam) {  
   vUpdate();
   tDVDDRIVEOFF_ENABLE_DevelopParam = tDVDDRIVEOFF_ENABLE_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::vSetData(tU8 &tDVDDRIVEOFF_ENABLE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVDDRIVEOFF_ENABLE_Develop,(tVoid*)&tDVDDRIVEOFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDVDDRIVEOFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::vSetData(const tU8 &tDVDDRIVEOFF_ENABLE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVDDRIVEOFF_ENABLE_Develop,(tVoid*)&tDVDDRIVEOFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDVDDRIVEOFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVDDRIVEOFF_ENABLE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVDDRIVEOFF_ENABLE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVDDRIVEOFF_ENABLE_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVDDRIVEOFF_ENABLE_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVDDRIVEOFF_ENABLE_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVDDRIVEOFF_DELAY_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVDDRIVEOFF_DELAY_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVDDRIVEOFF_DELAY_Develop",(tS32) 0x153fee7b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDVDDRIVEOFF_DELAY_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVDDRIVEOFF_DELAY_Develop", (tS32)0x153fee7b);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVDDRIVEOFF_DELAY_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::tGetData() {
   vUpdate();
   return tDVDDRIVEOFF_DELAY_Develop;
};
tS32 dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::s32GetData(tU8& tDVDDRIVEOFF_DELAY_DevelopParam) { 
   vUpdate();
   tDVDDRIVEOFF_DELAY_DevelopParam = tDVDDRIVEOFF_DELAY_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVDDRIVEOFF_DELAY_Develop", (tS32)0x153fee7b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::s32SetData(tU8 &tDVDDRIVEOFF_DELAY_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVDDRIVEOFF_DELAY_Develop,(tVoid*)&tDVDDRIVEOFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVDDRIVEOFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::s32SetData(const tU8 &tDVDDRIVEOFF_DELAY_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVDDRIVEOFF_DELAY_Develop,(tVoid*)&tDVDDRIVEOFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVDDRIVEOFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::u8GetData(tU8& tDVDDRIVEOFF_DELAY_DevelopParam) {  
   vUpdate();
   tDVDDRIVEOFF_DELAY_DevelopParam = tDVDDRIVEOFF_DELAY_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::vSetData(tU8 &tDVDDRIVEOFF_DELAY_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVDDRIVEOFF_DELAY_Develop,(tVoid*)&tDVDDRIVEOFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDVDDRIVEOFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::vSetData(const tU8 &tDVDDRIVEOFF_DELAY_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVDDRIVEOFF_DELAY_Develop,(tVoid*)&tDVDDRIVEOFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDVDDRIVEOFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVDDRIVEOFF_DELAY_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVDDRIVEOFF_DELAY_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVDDRIVEOFF_DELAY_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVDDRIVEOFF_DELAY_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVDDRIVEOFF_DELAY_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TVMODULEOFF_ENABLE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPTVMODULEOFF_ENABLE::dp_tclHeatCtrlDPTVMODULEOFF_ENABLE() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tTVMODULEOFF_ENABLE(FALSE)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPTVMODULEOFF_ENABLE::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/EF/TVMODULEOFF";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("ENABLE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tTVMODULEOFF_ENABLE = (tBool)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPTVMODULEOFF_ENABLE::u8GetData(tBool& tTVMODULEOFF_ENABLEParam) {
   vUpdate();
   tTVMODULEOFF_ENABLEParam = tTVMODULEOFF_ENABLE;
   return _u8DataStatus;
}
tBool dp_tclHeatCtrlDPTVMODULEOFF_ENABLE::tGetData() {
   vUpdate();
   return tTVMODULEOFF_ENABLE;
};

tU8 dp_tclHeatCtrlDPTVMODULEOFF_ENABLE::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPTVMODULEOFF_ENABLE::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TVMODULEOFF_DELAY"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPTVMODULEOFF_DELAY::dp_tclHeatCtrlDPTVMODULEOFF_DELAY() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tTVMODULEOFF_DELAY(0)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPTVMODULEOFF_DELAY::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/EF/TVMODULEOFF";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("DELAY",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tTVMODULEOFF_DELAY = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPTVMODULEOFF_DELAY::u8GetData(tU8& tTVMODULEOFF_DELAYParam) {
   vUpdate();
   tTVMODULEOFF_DELAYParam = tTVMODULEOFF_DELAY;
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPTVMODULEOFF_DELAY::tGetData() {
   vUpdate();
   return tTVMODULEOFF_DELAY;
};

tU8 dp_tclHeatCtrlDPTVMODULEOFF_DELAY::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPTVMODULEOFF_DELAY::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TVMODULEOFF_ENABLE_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTVMODULEOFF_ENABLE_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TVMODULEOFF_ENABLE_Develop",(tS32) 0xc3e7c467L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tTVMODULEOFF_ENABLE_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TVMODULEOFF_ENABLE_Develop", (tS32)0xc3e7c467L);
   (tVoid)myDpElem.bFillData((tVoid*)&tTVMODULEOFF_ENABLE_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::tGetData() {
   vUpdate();
   return tTVMODULEOFF_ENABLE_Develop;
};
tS32 dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::s32GetData(tU8& tTVMODULEOFF_ENABLE_DevelopParam) { 
   vUpdate();
   tTVMODULEOFF_ENABLE_DevelopParam = tTVMODULEOFF_ENABLE_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TVMODULEOFF_ENABLE_Develop", (tS32)0xc3e7c467L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::s32SetData(tU8 &tTVMODULEOFF_ENABLE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tTVMODULEOFF_ENABLE_Develop,(tVoid*)&tTVMODULEOFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTVMODULEOFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::s32SetData(const tU8 &tTVMODULEOFF_ENABLE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tTVMODULEOFF_ENABLE_Develop,(tVoid*)&tTVMODULEOFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTVMODULEOFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::u8GetData(tU8& tTVMODULEOFF_ENABLE_DevelopParam) {  
   vUpdate();
   tTVMODULEOFF_ENABLE_DevelopParam = tTVMODULEOFF_ENABLE_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::vSetData(tU8 &tTVMODULEOFF_ENABLE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tTVMODULEOFF_ENABLE_Develop,(tVoid*)&tTVMODULEOFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTVMODULEOFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::vSetData(const tU8 &tTVMODULEOFF_ENABLE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tTVMODULEOFF_ENABLE_Develop,(tVoid*)&tTVMODULEOFF_ENABLE_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTVMODULEOFF_ENABLE_DevelopParam' in function 'dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "TVMODULEOFF_ENABLE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "TVMODULEOFF_ENABLE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPTVMODULEOFF_ENABLE_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TVMODULEOFF_ENABLE_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element TVMODULEOFF_ENABLE_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TVMODULEOFF_DELAY_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTVMODULEOFF_DELAY_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TVMODULEOFF_DELAY_Develop",(tS32) 0x6b8703d7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tTVMODULEOFF_DELAY_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TVMODULEOFF_DELAY_Develop", (tS32)0x6b8703d7);
   (tVoid)myDpElem.bFillData((tVoid*)&tTVMODULEOFF_DELAY_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::tGetData() {
   vUpdate();
   return tTVMODULEOFF_DELAY_Develop;
};
tS32 dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::s32GetData(tU8& tTVMODULEOFF_DELAY_DevelopParam) { 
   vUpdate();
   tTVMODULEOFF_DELAY_DevelopParam = tTVMODULEOFF_DELAY_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TVMODULEOFF_DELAY_Develop", (tS32)0x6b8703d7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::s32SetData(tU8 &tTVMODULEOFF_DELAY_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tTVMODULEOFF_DELAY_Develop,(tVoid*)&tTVMODULEOFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTVMODULEOFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::s32SetData(const tU8 &tTVMODULEOFF_DELAY_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tTVMODULEOFF_DELAY_Develop,(tVoid*)&tTVMODULEOFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTVMODULEOFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::u8GetData(tU8& tTVMODULEOFF_DELAY_DevelopParam) {  
   vUpdate();
   tTVMODULEOFF_DELAY_DevelopParam = tTVMODULEOFF_DELAY_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::vSetData(tU8 &tTVMODULEOFF_DELAY_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tTVMODULEOFF_DELAY_Develop,(tVoid*)&tTVMODULEOFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTVMODULEOFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::vSetData(const tU8 &tTVMODULEOFF_DELAY_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tTVMODULEOFF_DELAY_Develop,(tVoid*)&tTVMODULEOFF_DELAY_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTVMODULEOFF_DELAY_DevelopParam' in function 'dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "TVMODULEOFF_DELAY_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "TVMODULEOFF_DELAY_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPTVMODULEOFF_DELAY_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TVMODULEOFF_DELAY_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element TVMODULEOFF_DELAY_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

tU8 dp_tclHeatCtrlDPI2CAdapter_Device::u8GetData(tString &tI2CAdapter_DeviceParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/DISPLAY/I2C_ADAPTER";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("DEVICE", tI2CAdapter_DeviceParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPI2CAdapter_Device::u8GetData(const tString &tI2CAdapter_DeviceParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/DISPLAY/I2C_ADAPTER";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("DEVICE", tI2CAdapter_DeviceParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclHeatCtrlDPI2CAdapter_Device::u8DataValid() const {return _u8DataStatus;};



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "I2CAdapter_DeviceAddress"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPI2CAdapter_DeviceAddress::dp_tclHeatCtrlDPI2CAdapter_DeviceAddress() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tI2CAdapter_DeviceAddress(0x0048)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPI2CAdapter_DeviceAddress::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/DISPLAY/I2C_ADAPTER";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("DEVICE_ADDRESS",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tI2CAdapter_DeviceAddress = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPI2CAdapter_DeviceAddress::u8GetData(tU16& tI2CAdapter_DeviceAddressParam) {
   vUpdate();
   tI2CAdapter_DeviceAddressParam = tI2CAdapter_DeviceAddress;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPI2CAdapter_DeviceAddress::tGetData() {
   vUpdate();
   return tI2CAdapter_DeviceAddress;
};

tU8 dp_tclHeatCtrlDPI2CAdapter_DeviceAddress::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPI2CAdapter_DeviceAddress::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "I2CAdapter_DataAddress"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPI2CAdapter_DataAddress::dp_tclHeatCtrlDPI2CAdapter_DataAddress() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tI2CAdapter_DataAddress(0)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPI2CAdapter_DataAddress::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/DISPLAY/I2C_ADAPTER";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("DATA_ADDRESS",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tI2CAdapter_DataAddress = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPI2CAdapter_DataAddress::u8GetData(tU16& tI2CAdapter_DataAddressParam) {
   vUpdate();
   tI2CAdapter_DataAddressParam = tI2CAdapter_DataAddress;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPI2CAdapter_DataAddress::tGetData() {
   vUpdate();
   return tI2CAdapter_DataAddress;
};

tU8 dp_tclHeatCtrlDPI2CAdapter_DataAddress::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPI2CAdapter_DataAddress::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "I2CAdapter_Period"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPI2CAdapter_Period::dp_tclHeatCtrlDPI2CAdapter_Period() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tI2CAdapter_Period(60)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPI2CAdapter_Period::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/DISPLAY/I2C_ADAPTER";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("PERIOD",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tI2CAdapter_Period = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPI2CAdapter_Period::u8GetData(tU16& tI2CAdapter_PeriodParam) {
   vUpdate();
   tI2CAdapter_PeriodParam = tI2CAdapter_Period;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPI2CAdapter_Period::tGetData() {
   vUpdate();
   return tI2CAdapter_Period;
};

tU8 dp_tclHeatCtrlDPI2CAdapter_Period::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPI2CAdapter_Period::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


tU8 dp_tclHeatCtrlDPIMXAdapter_Device::u8GetData(tString &tIMXAdapter_DeviceParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/IMX/IMX_ADAPTER";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("DEVICE", tIMXAdapter_DeviceParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPIMXAdapter_Device::u8GetData(const tString &tIMXAdapter_DeviceParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/IMX/IMX_ADAPTER";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("DEVICE", tIMXAdapter_DeviceParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclHeatCtrlDPIMXAdapter_Device::u8DataValid() const {return _u8DataStatus;};



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "IMXAdapter_Period"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPIMXAdapter_Period::dp_tclHeatCtrlDPIMXAdapter_Period() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tIMXAdapter_Period(20)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPIMXAdapter_Period::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/IMX/IMX_ADAPTER";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("PERIOD",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tIMXAdapter_Period = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPIMXAdapter_Period::u8GetData(tU8& tIMXAdapter_PeriodParam) {
   vUpdate();
   tIMXAdapter_PeriodParam = tIMXAdapter_Period;
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPIMXAdapter_Period::tGetData() {
   vUpdate();
   return tIMXAdapter_Period;
};

tU8 dp_tclHeatCtrlDPIMXAdapter_Period::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPIMXAdapter_Period::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};


tU8 dp_tclHeatCtrlDPTVModule_I2CAdapter_Device::u8GetData(tString &tTVModule_I2CAdapter_DeviceParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/TVMODULE/I2C_ADAPTER";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("DEVICE", tTVModule_I2CAdapter_DeviceParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPTVModule_I2CAdapter_Device::u8GetData(const tString &tTVModule_I2CAdapter_DeviceParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/TVMODULE/I2C_ADAPTER";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("DEVICE", tTVModule_I2CAdapter_DeviceParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclHeatCtrlDPTVModule_I2CAdapter_Device::u8DataValid() const {return _u8DataStatus;};



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TVModule_I2CAdapter_DeviceAddress"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPTVModule_I2CAdapter_DeviceAddress::dp_tclHeatCtrlDPTVModule_I2CAdapter_DeviceAddress() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tTVModule_I2CAdapter_DeviceAddress(0x0049)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPTVModule_I2CAdapter_DeviceAddress::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/TVMODULE/I2C_ADAPTER";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("DEVICE_ADDRESS",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tTVModule_I2CAdapter_DeviceAddress = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPTVModule_I2CAdapter_DeviceAddress::u8GetData(tU16& tTVModule_I2CAdapter_DeviceAddressParam) {
   vUpdate();
   tTVModule_I2CAdapter_DeviceAddressParam = tTVModule_I2CAdapter_DeviceAddress;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPTVModule_I2CAdapter_DeviceAddress::tGetData() {
   vUpdate();
   return tTVModule_I2CAdapter_DeviceAddress;
};

tU8 dp_tclHeatCtrlDPTVModule_I2CAdapter_DeviceAddress::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPTVModule_I2CAdapter_DeviceAddress::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TVModule_I2CAdapter_DataAddress"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPTVModule_I2CAdapter_DataAddress::dp_tclHeatCtrlDPTVModule_I2CAdapter_DataAddress() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tTVModule_I2CAdapter_DataAddress(0)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPTVModule_I2CAdapter_DataAddress::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/TVMODULE/I2C_ADAPTER";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("DATA_ADDRESS",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tTVModule_I2CAdapter_DataAddress = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPTVModule_I2CAdapter_DataAddress::u8GetData(tU16& tTVModule_I2CAdapter_DataAddressParam) {
   vUpdate();
   tTVModule_I2CAdapter_DataAddressParam = tTVModule_I2CAdapter_DataAddress;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPTVModule_I2CAdapter_DataAddress::tGetData() {
   vUpdate();
   return tTVModule_I2CAdapter_DataAddress;
};

tU8 dp_tclHeatCtrlDPTVModule_I2CAdapter_DataAddress::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPTVModule_I2CAdapter_DataAddress::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TVModule_I2CAdapter_Period"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPTVModule_I2CAdapter_Period::dp_tclHeatCtrlDPTVModule_I2CAdapter_Period() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tTVModule_I2CAdapter_Period(30)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPTVModule_I2CAdapter_Period::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/TVMODULE/I2C_ADAPTER";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("PERIOD",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tTVModule_I2CAdapter_Period = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPTVModule_I2CAdapter_Period::u8GetData(tU16& tTVModule_I2CAdapter_PeriodParam) {
   vUpdate();
   tTVModule_I2CAdapter_PeriodParam = tTVModule_I2CAdapter_Period;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPTVModule_I2CAdapter_Period::tGetData() {
   vUpdate();
   return tTVModule_I2CAdapter_Period;
};

tU8 dp_tclHeatCtrlDPTVModule_I2CAdapter_Period::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPTVModule_I2CAdapter_Period::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Fan_Mounted"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPFan_Mounted::dp_tclHeatCtrlDPFan_Mounted() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tFan_Mounted(FALSE)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPFan_Mounted::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/FAN";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MOUNTED",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tFan_Mounted = (tBool)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPFan_Mounted::u8GetData(tBool& tFan_MountedParam) {
   vUpdate();
   tFan_MountedParam = tFan_Mounted;
   return _u8DataStatus;
}
tBool dp_tclHeatCtrlDPFan_Mounted::tGetData() {
   vUpdate();
   return tFan_Mounted;
};

tU8 dp_tclHeatCtrlDPFan_Mounted::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPFan_Mounted::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Fan_Mounted_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPFan_Mounted_Develop::dp_tclHeatCtrlDPFan_Mounted_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFan_Mounted_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPFan_Mounted_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Fan_Mounted_Develop",(tS32) 0x585a5806);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tFan_Mounted_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPFan_Mounted_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Fan_Mounted_Develop", (tS32)0x585a5806);
   (tVoid)myDpElem.bFillData((tVoid*)&tFan_Mounted_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPFan_Mounted_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPFan_Mounted_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPFan_Mounted_Develop::tGetData() {
   vUpdate();
   return tFan_Mounted_Develop;
};
tS32 dp_tclHeatCtrlDPFan_Mounted_Develop::s32GetData(tU8& tFan_Mounted_DevelopParam) { 
   vUpdate();
   tFan_Mounted_DevelopParam = tFan_Mounted_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPFan_Mounted_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Fan_Mounted_Develop", (tS32)0x585a5806);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPFan_Mounted_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPFan_Mounted_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPFan_Mounted_Develop::s32SetData(tU8 &tFan_Mounted_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tFan_Mounted_Develop,(tVoid*)&tFan_Mounted_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFan_Mounted_DevelopParam' in function 'dp_tclHeatCtrlDPFan_Mounted_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPFan_Mounted_Develop::s32SetData(const tU8 &tFan_Mounted_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tFan_Mounted_Develop,(tVoid*)&tFan_Mounted_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFan_Mounted_DevelopParam' in function 'dp_tclHeatCtrlDPFan_Mounted_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPFan_Mounted_Develop::u8GetData(tU8& tFan_Mounted_DevelopParam) {  
   vUpdate();
   tFan_Mounted_DevelopParam = tFan_Mounted_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPFan_Mounted_Develop::vSetData(tU8 &tFan_Mounted_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tFan_Mounted_Develop,(tVoid*)&tFan_Mounted_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFan_Mounted_DevelopParam' in function 'dp_tclHeatCtrlDPFan_Mounted_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPFan_Mounted_Develop::vSetData(const tU8 &tFan_Mounted_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tFan_Mounted_Develop,(tVoid*)&tFan_Mounted_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFan_Mounted_DevelopParam' in function 'dp_tclHeatCtrlDPFan_Mounted_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPFan_Mounted_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPFan_Mounted_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "Fan_Mounted_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPFan_Mounted_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "Fan_Mounted_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPFan_Mounted_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Fan_Mounted_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element Fan_Mounted_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Fan_Mounted_KDS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPFan_Mounted_KDS::dp_tclHeatCtrlDPFan_Mounted_KDS(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFan_Mounted_KDS,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPFan_Mounted_KDS::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Fan_Mounted_KDS",(tS32) 0x9dd65d55);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tFan_Mounted_KDS = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPFan_Mounted_KDS::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Fan_Mounted_KDS", (tS32)0x9dd65d55);
   (tVoid)myDpElem.bFillData((tVoid*)&tFan_Mounted_KDS, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPFan_Mounted_KDS::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPFan_Mounted_KDS::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPFan_Mounted_KDS::tGetData() {
   vUpdate();
   return tFan_Mounted_KDS;
};
tS32 dp_tclHeatCtrlDPFan_Mounted_KDS::s32GetData(tU8& tFan_Mounted_KDSParam) { 
   vUpdate();
   tFan_Mounted_KDSParam = tFan_Mounted_KDS;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPFan_Mounted_KDS::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Fan_Mounted_KDS", (tS32)0x9dd65d55);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPFan_Mounted_KDS::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPFan_Mounted_KDS::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPFan_Mounted_KDS::s32SetData(tU8 &tFan_Mounted_KDSParam) {
   //init parameter
   (tVoid)memcpy(&tFan_Mounted_KDS,(tVoid*)&tFan_Mounted_KDSParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFan_Mounted_KDSParam' in function 'dp_tclHeatCtrlDPFan_Mounted_KDS::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPFan_Mounted_KDS::s32SetData(const tU8 &tFan_Mounted_KDSParam) {
   //init parameter
   (tVoid)memcpy(&tFan_Mounted_KDS,(tVoid*)&tFan_Mounted_KDSParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFan_Mounted_KDSParam' in function 'dp_tclHeatCtrlDPFan_Mounted_KDS::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPFan_Mounted_KDS::u8GetData(tU8& tFan_Mounted_KDSParam) {  
   vUpdate();
   tFan_Mounted_KDSParam = tFan_Mounted_KDS;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPFan_Mounted_KDS::vSetData(tU8 &tFan_Mounted_KDSParam) { 
   //init parameter
   (tVoid)memcpy(&tFan_Mounted_KDS,(tVoid*)&tFan_Mounted_KDSParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFan_Mounted_KDSParam' in function 'dp_tclHeatCtrlDPFan_Mounted_KDS::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPFan_Mounted_KDS::vSetData(const tU8 &tFan_Mounted_KDSParam) { 
   //init parameter
   (tVoid)memcpy(&tFan_Mounted_KDS,(tVoid*)&tFan_Mounted_KDSParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFan_Mounted_KDSParam' in function 'dp_tclHeatCtrlDPFan_Mounted_KDS::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPFan_Mounted_KDS::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPFan_Mounted_KDS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "Fan_Mounted_KDS", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPFan_Mounted_KDS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "Fan_Mounted_KDS", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPFan_Mounted_KDS::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Fan_Mounted_KDS", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element Fan_Mounted_KDS has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Fan_Period"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPFan_Period::dp_tclHeatCtrlDPFan_Period() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tFan_Period(1)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPFan_Period::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/FAN";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("PERIOD",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tFan_Period = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPFan_Period::u8GetData(tU8& tFan_PeriodParam) {
   vUpdate();
   tFan_PeriodParam = tFan_Period;
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPFan_Period::tGetData() {
   vUpdate();
   return tFan_Period;
};

tU8 dp_tclHeatCtrlDPFan_Period::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPFan_Period::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Fan_Period_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPFan_Period_Develop::dp_tclHeatCtrlDPFan_Period_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFan_Period_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPFan_Period_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Fan_Period_Develop",(tS32) 0x4e243959);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tFan_Period_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPFan_Period_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Fan_Period_Develop", (tS32)0x4e243959);
   (tVoid)myDpElem.bFillData((tVoid*)&tFan_Period_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPFan_Period_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPFan_Period_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPFan_Period_Develop::tGetData() {
   vUpdate();
   return tFan_Period_Develop;
};
tS32 dp_tclHeatCtrlDPFan_Period_Develop::s32GetData(tU8& tFan_Period_DevelopParam) { 
   vUpdate();
   tFan_Period_DevelopParam = tFan_Period_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPFan_Period_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Fan_Period_Develop", (tS32)0x4e243959);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPFan_Period_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPFan_Period_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPFan_Period_Develop::s32SetData(tU8 &tFan_Period_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tFan_Period_Develop,(tVoid*)&tFan_Period_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFan_Period_DevelopParam' in function 'dp_tclHeatCtrlDPFan_Period_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPFan_Period_Develop::s32SetData(const tU8 &tFan_Period_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tFan_Period_Develop,(tVoid*)&tFan_Period_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFan_Period_DevelopParam' in function 'dp_tclHeatCtrlDPFan_Period_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPFan_Period_Develop::u8GetData(tU8& tFan_Period_DevelopParam) {  
   vUpdate();
   tFan_Period_DevelopParam = tFan_Period_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPFan_Period_Develop::vSetData(tU8 &tFan_Period_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tFan_Period_Develop,(tVoid*)&tFan_Period_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFan_Period_DevelopParam' in function 'dp_tclHeatCtrlDPFan_Period_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPFan_Period_Develop::vSetData(const tU8 &tFan_Period_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tFan_Period_Develop,(tVoid*)&tFan_Period_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tFan_Period_DevelopParam' in function 'dp_tclHeatCtrlDPFan_Period_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPFan_Period_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPFan_Period_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "Fan_Period_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPFan_Period_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "Fan_Period_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPFan_Period_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Fan_Period_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element Fan_Period_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FanAdc_Enable"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPFanAdc_Enable::dp_tclHeatCtrlDPFanAdc_Enable() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tFanAdc_Enable(FALSE)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPFanAdc_Enable::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/FAN/FAN_ADC";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("ENABLE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tFanAdc_Enable = (tBool)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPFanAdc_Enable::u8GetData(tBool& tFanAdc_EnableParam) {
   vUpdate();
   tFanAdc_EnableParam = tFanAdc_Enable;
   return _u8DataStatus;
}
tBool dp_tclHeatCtrlDPFanAdc_Enable::tGetData() {
   vUpdate();
   return tFanAdc_Enable;
};

tU8 dp_tclHeatCtrlDPFanAdc_Enable::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPFanAdc_Enable::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};


tU8 dp_tclHeatCtrlDPFanAdc_Device::u8GetData(tString &tFanAdc_DeviceParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/FAN/FAN_ADC";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("DEVICE", tFanAdc_DeviceParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPFanAdc_Device::u8GetData(const tString &tFanAdc_DeviceParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/FAN/FAN_ADC";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("DEVICE", tFanAdc_DeviceParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclHeatCtrlDPFanAdc_Device::u8DataValid() const {return _u8DataStatus;};



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FanAdc_MaxResolution"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPFanAdc_MaxResolution::dp_tclHeatCtrlDPFanAdc_MaxResolution() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tFanAdc_MaxResolution(0x0FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPFanAdc_MaxResolution::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/FAN/FAN_ADC";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MAX_RESOLUTION",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tFanAdc_MaxResolution = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPFanAdc_MaxResolution::u8GetData(tU16& tFanAdc_MaxResolutionParam) {
   vUpdate();
   tFanAdc_MaxResolutionParam = tFanAdc_MaxResolution;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPFanAdc_MaxResolution::tGetData() {
   vUpdate();
   return tFanAdc_MaxResolution;
};

tU8 dp_tclHeatCtrlDPFanAdc_MaxResolution::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPFanAdc_MaxResolution::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FanAdc_URef"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPFanAdc_URef::dp_tclHeatCtrlDPFanAdc_URef() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tFanAdc_URef(3420)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPFanAdc_URef::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/FAN/FAN_ADC";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("UREF",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tFanAdc_URef = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPFanAdc_URef::u8GetData(tU16& tFanAdc_URefParam) {
   vUpdate();
   tFanAdc_URefParam = tFanAdc_URef;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPFanAdc_URef::tGetData() {
   vUpdate();
   return tFanAdc_URef;
};

tU8 dp_tclHeatCtrlDPFanAdc_URef::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPFanAdc_URef::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FanAdc_URef_KDS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPFanAdc_URef_KDS::dp_tclHeatCtrlDPFanAdc_URef_KDS(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFanAdc_URef_KDS,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPFanAdc_URef_KDS::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("FanAdc_URef_KDS",(tS32) 0x51db3e07);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tFanAdc_URef_KDS = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPFanAdc_URef_KDS::vStore(tVoid) {
   dp_tclBaseElement myDpElem("FanAdc_URef_KDS", (tS32)0x51db3e07);
   (tVoid)myDpElem.bFillData((tVoid*)&tFanAdc_URef_KDS, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPFanAdc_URef_KDS::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPFanAdc_URef_KDS::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclHeatCtrlDPFanAdc_URef_KDS::tGetData() {
   vUpdate();
   return tFanAdc_URef_KDS;
};
tS32 dp_tclHeatCtrlDPFanAdc_URef_KDS::s32GetData(tU16& tFanAdc_URef_KDSParam) { 
   vUpdate();
   tFanAdc_URef_KDSParam = tFanAdc_URef_KDS;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPFanAdc_URef_KDS::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("FanAdc_URef_KDS", (tS32)0x51db3e07);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPFanAdc_URef_KDS::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPFanAdc_URef_KDS::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPFanAdc_URef_KDS::s32SetData(tU16 &tFanAdc_URef_KDSParam) {
   //init parameter
   (tVoid)memcpy(&tFanAdc_URef_KDS,(tVoid*)&tFanAdc_URef_KDSParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFanAdc_URef_KDSParam' in function 'dp_tclHeatCtrlDPFanAdc_URef_KDS::vSetData(tU16)' could be made const reference
tS32 dp_tclHeatCtrlDPFanAdc_URef_KDS::s32SetData(const tU16 &tFanAdc_URef_KDSParam) {
   //init parameter
   (tVoid)memcpy(&tFanAdc_URef_KDS,(tVoid*)&tFanAdc_URef_KDSParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFanAdc_URef_KDSParam' in function 'dp_tclHeatCtrlDPFanAdc_URef_KDS::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPFanAdc_URef_KDS::u8GetData(tU16& tFanAdc_URef_KDSParam) {  
   vUpdate();
   tFanAdc_URef_KDSParam = tFanAdc_URef_KDS;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPFanAdc_URef_KDS::vSetData(tU16 &tFanAdc_URef_KDSParam) { 
   //init parameter
   (tVoid)memcpy(&tFanAdc_URef_KDS,(tVoid*)&tFanAdc_URef_KDSParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tFanAdc_URef_KDSParam' in function 'dp_tclHeatCtrlDPFanAdc_URef_KDS::vSetData(tU16)' could be made const reference
tVoid dp_tclHeatCtrlDPFanAdc_URef_KDS::vSetData(const tU16 &tFanAdc_URef_KDSParam) { 
   //init parameter
   (tVoid)memcpy(&tFanAdc_URef_KDS,(tVoid*)&tFanAdc_URef_KDSParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tFanAdc_URef_KDSParam' in function 'dp_tclHeatCtrlDPFanAdc_URef_KDS::vSetData(tU16)' could be made const reference
tU8   dp_tclHeatCtrlDPFanAdc_URef_KDS::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPFanAdc_URef_KDS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "FanAdc_URef_KDS", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPFanAdc_URef_KDS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "FanAdc_URef_KDS", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPFanAdc_URef_KDS::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: FanAdc_URef_KDS", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element FanAdc_URef_KDS has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

tU8 dp_tclHeatCtrlDPFanGpio_Device::u8GetData(tString &tFanGpio_DeviceParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/FAN/FAN_GPIO";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("DEVICE", tFanGpio_DeviceParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPFanGpio_Device::u8GetData(const tString &tFanGpio_DeviceParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/FAN/FAN_GPIO";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("DEVICE", tFanGpio_DeviceParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclHeatCtrlDPFanGpio_Device::u8DataValid() const {return _u8DataStatus;};



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FanGpio_PinNumber"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPFanGpio_PinNumber::dp_tclHeatCtrlDPFanGpio_PinNumber() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tFanGpio_PinNumber(0xFFFFFFFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPFanGpio_PinNumber::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/DEV/FAN/FAN_GPIO";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("PIN",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tFanGpio_PinNumber = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPFanGpio_PinNumber::u8GetData(tU32& tFanGpio_PinNumberParam) {
   vUpdate();
   tFanGpio_PinNumberParam = tFanGpio_PinNumber;
   return _u8DataStatus;
}
tU32 dp_tclHeatCtrlDPFanGpio_PinNumber::tGetData() {
   vUpdate();
   return tFanGpio_PinNumber;
};

tU8 dp_tclHeatCtrlDPFanGpio_PinNumber::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPFanGpio_PinNumber::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SYSFAN_ActivationDurationArray_OperationTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_OperationTime::dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_OperationTime(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_OperationTime::s32SetData( tU32* tSYSFAN_ActivationDurationArray_OperationTimeParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("SYSFAN_ActivationDurationArray_OperationTime", (tS32)0xd10f0265L);
   (tVoid)myDpElem.bFillData((tVoid*)tSYSFAN_ActivationDurationArray_OperationTimeParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_OperationTime::s32GetData(tU32* tSYSFAN_ActivationDurationArray_OperationTimeParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("SYSFAN_ActivationDurationArray_OperationTime", (tS32)0xd10f0265L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tSYSFAN_ActivationDurationArray_OperationTimeParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_OperationTime::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_OperationTime::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_OperationTime::u16GetData(tU32* tSYSFAN_ActivationDurationArray_OperationTimeParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tSYSFAN_ActivationDurationArray_OperationTimeParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_OperationTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ActivationDurationArray_OperationTime", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_OperationTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ActivationDurationArray_OperationTime", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_OperationTime::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SYSFAN_ActivationDurationArray_OperationTime", DP_U32_POOL_ID_HEATCTRLDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
		}
		else
		{
			fprintf(stdout,"Element SYSFAN_ActivationDurationArray_OperationTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SYSFAN_ActivationDurationArray_LiveTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_LiveTime::dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_LiveTime(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_LiveTime::s32SetData( tU32* tSYSFAN_ActivationDurationArray_LiveTimeParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("SYSFAN_ActivationDurationArray_LiveTime", (tS32)0xd698f2fcL);
   (tVoid)myDpElem.bFillData((tVoid*)tSYSFAN_ActivationDurationArray_LiveTimeParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_LiveTime::s32GetData(tU32* tSYSFAN_ActivationDurationArray_LiveTimeParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("SYSFAN_ActivationDurationArray_LiveTime", (tS32)0xd698f2fcL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tSYSFAN_ActivationDurationArray_LiveTimeParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_LiveTime::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_LiveTime::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_LiveTime::u16GetData(tU32* tSYSFAN_ActivationDurationArray_LiveTimeParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tSYSFAN_ActivationDurationArray_LiveTimeParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_LiveTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ActivationDurationArray_LiveTime", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_LiveTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ActivationDurationArray_LiveTime", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclHeatCtrlDPSYSFAN_ActivationDurationArray_LiveTime::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SYSFAN_ActivationDurationArray_LiveTime", DP_U32_POOL_ID_HEATCTRLDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
		}
		else
		{
			fprintf(stdout,"Element SYSFAN_ActivationDurationArray_LiveTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SYSFAN_ActivationCounterArray_OperationTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_OperationTime::dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_OperationTime(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_OperationTime::s32SetData( tU32* tSYSFAN_ActivationCounterArray_OperationTimeParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("SYSFAN_ActivationCounterArray_OperationTime", (tS32)0xbedc55ffL);
   (tVoid)myDpElem.bFillData((tVoid*)tSYSFAN_ActivationCounterArray_OperationTimeParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_OperationTime::s32GetData(tU32* tSYSFAN_ActivationCounterArray_OperationTimeParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("SYSFAN_ActivationCounterArray_OperationTime", (tS32)0xbedc55ffL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tSYSFAN_ActivationCounterArray_OperationTimeParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_OperationTime::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_OperationTime::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_OperationTime::u16GetData(tU32* tSYSFAN_ActivationCounterArray_OperationTimeParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tSYSFAN_ActivationCounterArray_OperationTimeParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_OperationTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ActivationCounterArray_OperationTime", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_OperationTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ActivationCounterArray_OperationTime", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_OperationTime::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SYSFAN_ActivationCounterArray_OperationTime", DP_U32_POOL_ID_HEATCTRLDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
		}
		else
		{
			fprintf(stdout,"Element SYSFAN_ActivationCounterArray_OperationTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SYSFAN_ActivationCounterArray_LiveTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_LiveTime::dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_LiveTime(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_LiveTime::s32SetData( tU32* tSYSFAN_ActivationCounterArray_LiveTimeParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("SYSFAN_ActivationCounterArray_LiveTime", (tS32)0x2915c76eL);
   (tVoid)myDpElem.bFillData((tVoid*)tSYSFAN_ActivationCounterArray_LiveTimeParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_LiveTime::s32GetData(tU32* tSYSFAN_ActivationCounterArray_LiveTimeParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("SYSFAN_ActivationCounterArray_LiveTime", (tS32)0x2915c76eL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tSYSFAN_ActivationCounterArray_LiveTimeParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_LiveTime::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_LiveTime::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_LiveTime::u16GetData(tU32* tSYSFAN_ActivationCounterArray_LiveTimeParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tSYSFAN_ActivationCounterArray_LiveTimeParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_LiveTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ActivationCounterArray_LiveTime", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_LiveTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ActivationCounterArray_LiveTime", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclHeatCtrlDPSYSFAN_ActivationCounterArray_LiveTime::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SYSFAN_ActivationCounterArray_LiveTime", DP_U32_POOL_ID_HEATCTRLDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
		}
		else
		{
			fprintf(stdout,"Element SYSFAN_ActivationCounterArray_LiveTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SYSFAN_ControlModeDurationArray_OperationTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_OperationTime::dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_OperationTime(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_OperationTime::s32SetData( tU32* tSYSFAN_ControlModeDurationArray_OperationTimeParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("SYSFAN_ControlModeDurationArray_OperationTime", (tS32)0xbc137db1L);
   (tVoid)myDpElem.bFillData((tVoid*)tSYSFAN_ControlModeDurationArray_OperationTimeParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_OperationTime::s32GetData(tU32* tSYSFAN_ControlModeDurationArray_OperationTimeParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("SYSFAN_ControlModeDurationArray_OperationTime", (tS32)0xbc137db1L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tSYSFAN_ControlModeDurationArray_OperationTimeParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_OperationTime::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_OperationTime::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_OperationTime::u16GetData(tU32* tSYSFAN_ControlModeDurationArray_OperationTimeParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tSYSFAN_ControlModeDurationArray_OperationTimeParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_OperationTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ControlModeDurationArray_OperationTime", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_OperationTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ControlModeDurationArray_OperationTime", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_OperationTime::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SYSFAN_ControlModeDurationArray_OperationTime", DP_U32_POOL_ID_HEATCTRLDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
		}
		else
		{
			fprintf(stdout,"Element SYSFAN_ControlModeDurationArray_OperationTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SYSFAN_ControlModeDurationArray_LiveTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_LiveTime::dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_LiveTime(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_LiveTime::s32SetData( tU32* tSYSFAN_ControlModeDurationArray_LiveTimeParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("SYSFAN_ControlModeDurationArray_LiveTime", (tS32)0x86253298L);
   (tVoid)myDpElem.bFillData((tVoid*)tSYSFAN_ControlModeDurationArray_LiveTimeParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_LiveTime::s32GetData(tU32* tSYSFAN_ControlModeDurationArray_LiveTimeParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("SYSFAN_ControlModeDurationArray_LiveTime", (tS32)0x86253298L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tSYSFAN_ControlModeDurationArray_LiveTimeParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_LiveTime::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_LiveTime::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_LiveTime::u16GetData(tU32* tSYSFAN_ControlModeDurationArray_LiveTimeParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tSYSFAN_ControlModeDurationArray_LiveTimeParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_LiveTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ControlModeDurationArray_LiveTime", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_LiveTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ControlModeDurationArray_LiveTime", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclHeatCtrlDPSYSFAN_ControlModeDurationArray_LiveTime::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SYSFAN_ControlModeDurationArray_LiveTime", DP_U32_POOL_ID_HEATCTRLDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
		}
		else
		{
			fprintf(stdout,"Element SYSFAN_ControlModeDurationArray_LiveTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SYSFAN_ControlModeCounterArray_OperationTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_OperationTime::dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_OperationTime(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_OperationTime::s32SetData( tU32* tSYSFAN_ControlModeCounterArray_OperationTimeParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("SYSFAN_ControlModeCounterArray_OperationTime", (tS32)0x5443a1dbL);
   (tVoid)myDpElem.bFillData((tVoid*)tSYSFAN_ControlModeCounterArray_OperationTimeParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_OperationTime::s32GetData(tU32* tSYSFAN_ControlModeCounterArray_OperationTimeParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("SYSFAN_ControlModeCounterArray_OperationTime", (tS32)0x5443a1dbL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tSYSFAN_ControlModeCounterArray_OperationTimeParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_OperationTime::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_OperationTime::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_OperationTime::u16GetData(tU32* tSYSFAN_ControlModeCounterArray_OperationTimeParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tSYSFAN_ControlModeCounterArray_OperationTimeParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_OperationTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ControlModeCounterArray_OperationTime", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_OperationTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ControlModeCounterArray_OperationTime", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_OperationTime::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SYSFAN_ControlModeCounterArray_OperationTime", DP_U32_POOL_ID_HEATCTRLDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
		}
		else
		{
			fprintf(stdout,"Element SYSFAN_ControlModeCounterArray_OperationTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SYSFAN_ControlModeCounterArray_LiveTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_LiveTime::dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_LiveTime(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_LiveTime::s32SetData( tU32* tSYSFAN_ControlModeCounterArray_LiveTimeParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("SYSFAN_ControlModeCounterArray_LiveTime", (tS32)0x7f65075aL);
   (tVoid)myDpElem.bFillData((tVoid*)tSYSFAN_ControlModeCounterArray_LiveTimeParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_LiveTime::s32GetData(tU32* tSYSFAN_ControlModeCounterArray_LiveTimeParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("SYSFAN_ControlModeCounterArray_LiveTime", (tS32)0x7f65075aL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tSYSFAN_ControlModeCounterArray_LiveTimeParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_LiveTime::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_LiveTime::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_LiveTime::u16GetData(tU32* tSYSFAN_ControlModeCounterArray_LiveTimeParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tSYSFAN_ControlModeCounterArray_LiveTimeParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_LiveTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ControlModeCounterArray_LiveTime", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_LiveTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "SYSFAN_ControlModeCounterArray_LiveTime", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclHeatCtrlDPSYSFAN_ControlModeCounterArray_LiveTime::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SYSFAN_ControlModeCounterArray_LiveTime", DP_U32_POOL_ID_HEATCTRLDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
		}
		else
		{
			fprintf(stdout,"Element SYSFAN_ControlModeCounterArray_LiveTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SENSORSTATISTICS_MINTEMPSTEPSIZE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE::dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tSENSORSTATISTICS_MINTEMPSTEPSIZE(10)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/STATISTICS";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MINTEMPSTEPSIZE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tSENSORSTATISTICS_MINTEMPSTEPSIZE = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE::u8GetData(tU16& tSENSORSTATISTICS_MINTEMPSTEPSIZEParam) {
   vUpdate();
   tSENSORSTATISTICS_MINTEMPSTEPSIZEParam = tSENSORSTATISTICS_MINTEMPSTEPSIZE;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE::tGetData() {
   vUpdate();
   return tSENSORSTATISTICS_MINTEMPSTEPSIZE;
};

tU8 dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPSENSORSTATISTICS_MINTEMPSTEPSIZE::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_AVAIL"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_AVAIL::dp_tclHeatCtrlDPV850_AVAIL() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_AVAIL(TRUE)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_AVAIL::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("AVAIL",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_AVAIL = (tBool)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_AVAIL::u8GetData(tBool& tV850_AVAILParam) {
   vUpdate();
   tV850_AVAILParam = tV850_AVAIL;
   return _u8DataStatus;
}
tBool dp_tclHeatCtrlDPV850_AVAIL::tGetData() {
   vUpdate();
   return tV850_AVAIL;
};

tU8 dp_tclHeatCtrlDPV850_AVAIL::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_AVAIL::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_AVAIL_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_AVAIL_Develop::dp_tclHeatCtrlDPV850_AVAIL_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_AVAIL_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_AVAIL_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_AVAIL_Develop",(tS32) 0xd9f276c1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tV850_AVAIL_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_AVAIL_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_AVAIL_Develop", (tS32)0xd9f276c1);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_AVAIL_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_AVAIL_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_AVAIL_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPV850_AVAIL_Develop::tGetData() {
   vUpdate();
   return tV850_AVAIL_Develop;
};
tS32 dp_tclHeatCtrlDPV850_AVAIL_Develop::s32GetData(tU8& tV850_AVAIL_DevelopParam) { 
   vUpdate();
   tV850_AVAIL_DevelopParam = tV850_AVAIL_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_AVAIL_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_AVAIL_Develop", (tS32)0xd9f276c1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_AVAIL_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_AVAIL_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_AVAIL_Develop::s32SetData(tU8 &tV850_AVAIL_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_AVAIL_Develop,(tVoid*)&tV850_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPV850_AVAIL_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_AVAIL_Develop::s32SetData(const tU8 &tV850_AVAIL_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_AVAIL_Develop,(tVoid*)&tV850_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPV850_AVAIL_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_AVAIL_Develop::u8GetData(tU8& tV850_AVAIL_DevelopParam) {  
   vUpdate();
   tV850_AVAIL_DevelopParam = tV850_AVAIL_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_AVAIL_Develop::vSetData(tU8 &tV850_AVAIL_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_AVAIL_Develop,(tVoid*)&tV850_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tV850_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPV850_AVAIL_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_AVAIL_Develop::vSetData(const tU8 &tV850_AVAIL_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_AVAIL_Develop,(tVoid*)&tV850_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tV850_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPV850_AVAIL_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_AVAIL_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_AVAIL_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_AVAIL_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_AVAIL_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_AVAIL_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_AVAIL_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_AVAIL_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_AVAIL_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_MinTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_MinTemp::dp_tclHeatCtrlDPV850_MinTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_MinTemp(-500)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_MinTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MIN_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_MinTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_MinTemp::u8GetData(tS16& tV850_MinTempParam) {
   vUpdate();
   tV850_MinTempParam = tV850_MinTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_MinTemp::tGetData() {
   vUpdate();
   return tV850_MinTemp;
};

tU8 dp_tclHeatCtrlDPV850_MinTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_MinTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_MaxTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_MaxTemp::dp_tclHeatCtrlDPV850_MaxTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_MaxTemp(1500)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_MaxTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MAX_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_MaxTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_MaxTemp::u8GetData(tS16& tV850_MaxTempParam) {
   vUpdate();
   tV850_MaxTempParam = tV850_MaxTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_MaxTemp::tGetData() {
   vUpdate();
   return tV850_MaxTemp;
};

tU8 dp_tclHeatCtrlDPV850_MaxTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_MaxTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_EmergencyHighTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_EmergencyHighTemp::dp_tclHeatCtrlDPV850_EmergencyHighTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_EmergencyHighTemp(1450)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_EmergencyHighTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("EMERGHIGH_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_EmergencyHighTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_EmergencyHighTemp::u8GetData(tS16& tV850_EmergencyHighTempParam) {
   vUpdate();
   tV850_EmergencyHighTempParam = tV850_EmergencyHighTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_EmergencyHighTemp::tGetData() {
   vUpdate();
   return tV850_EmergencyHighTemp;
};

tU8 dp_tclHeatCtrlDPV850_EmergencyHighTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_EmergencyHighTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_EmergencyHighTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_EmergencyHighTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_EmergencyHighTemp_Develop",(tS32) 0xc9961229L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_EmergencyHighTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_EmergencyHighTemp_Develop", (tS32)0xc9961229L);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_EmergencyHighTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::tGetData() {
   vUpdate();
   return tV850_EmergencyHighTemp_Develop;
};
tS32 dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::s32GetData(tS16& tV850_EmergencyHighTemp_DevelopParam) { 
   vUpdate();
   tV850_EmergencyHighTemp_DevelopParam = tV850_EmergencyHighTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_EmergencyHighTemp_Develop", (tS32)0xc9961229L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::s32SetData(tS16 &tV850_EmergencyHighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_EmergencyHighTemp_Develop,(tVoid*)&tV850_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::s32SetData(const tS16 &tV850_EmergencyHighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_EmergencyHighTemp_Develop,(tVoid*)&tV850_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::u8GetData(tS16& tV850_EmergencyHighTemp_DevelopParam) {  
   vUpdate();
   tV850_EmergencyHighTemp_DevelopParam = tV850_EmergencyHighTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::vSetData(tS16 &tV850_EmergencyHighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_EmergencyHighTemp_Develop,(tVoid*)&tV850_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::vSetData(const tS16 &tV850_EmergencyHighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_EmergencyHighTemp_Develop,(tVoid*)&tV850_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_EmergencyHighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_EmergencyHighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_EmergencyHighTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_EmergencyHighTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_EmergencyHighTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_EmergencyHigh2HighTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp::dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_EmergencyHigh2HighTemp(1450)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("EMERGHIGH2HIGH_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_EmergencyHigh2HighTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp::u8GetData(tS16& tV850_EmergencyHigh2HighTempParam) {
   vUpdate();
   tV850_EmergencyHigh2HighTempParam = tV850_EmergencyHigh2HighTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp::tGetData() {
   vUpdate();
   return tV850_EmergencyHigh2HighTemp;
};

tU8 dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_EmergencyHigh2HighTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_EmergencyHigh2HighTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_EmergencyHigh2HighTemp_Develop",(tS32) 0x3ca56543L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_EmergencyHigh2HighTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_EmergencyHigh2HighTemp_Develop", (tS32)0x3ca56543L);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_EmergencyHigh2HighTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::tGetData() {
   vUpdate();
   return tV850_EmergencyHigh2HighTemp_Develop;
};
tS32 dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::s32GetData(tS16& tV850_EmergencyHigh2HighTemp_DevelopParam) { 
   vUpdate();
   tV850_EmergencyHigh2HighTemp_DevelopParam = tV850_EmergencyHigh2HighTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_EmergencyHigh2HighTemp_Develop", (tS32)0x3ca56543L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::s32SetData(tS16 &tV850_EmergencyHigh2HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_EmergencyHigh2HighTemp_Develop,(tVoid*)&tV850_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::s32SetData(const tS16 &tV850_EmergencyHigh2HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_EmergencyHigh2HighTemp_Develop,(tVoid*)&tV850_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::u8GetData(tS16& tV850_EmergencyHigh2HighTemp_DevelopParam) {  
   vUpdate();
   tV850_EmergencyHigh2HighTemp_DevelopParam = tV850_EmergencyHigh2HighTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::vSetData(tS16 &tV850_EmergencyHigh2HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_EmergencyHigh2HighTemp_Develop,(tVoid*)&tV850_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::vSetData(const tS16 &tV850_EmergencyHigh2HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_EmergencyHigh2HighTemp_Develop,(tVoid*)&tV850_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_EmergencyHigh2HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_EmergencyHigh2HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_EmergencyHigh2HighTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_EmergencyHigh2HighTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_EmergencyHigh2HighTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_HighTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_HighTemp::dp_tclHeatCtrlDPV850_HighTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_HighTemp(900)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_HighTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("HIGH_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_HighTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_HighTemp::u8GetData(tS16& tV850_HighTempParam) {
   vUpdate();
   tV850_HighTempParam = tV850_HighTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_HighTemp::tGetData() {
   vUpdate();
   return tV850_HighTemp;
};

tU8 dp_tclHeatCtrlDPV850_HighTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_HighTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_HighTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_HighTemp_Develop::dp_tclHeatCtrlDPV850_HighTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_HighTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_HighTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_HighTemp_Develop",(tS32) 0xd81d841e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_HighTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_HighTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_HighTemp_Develop", (tS32)0xd81d841e);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_HighTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_HighTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_HighTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_HighTemp_Develop::tGetData() {
   vUpdate();
   return tV850_HighTemp_Develop;
};
tS32 dp_tclHeatCtrlDPV850_HighTemp_Develop::s32GetData(tS16& tV850_HighTemp_DevelopParam) { 
   vUpdate();
   tV850_HighTemp_DevelopParam = tV850_HighTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_HighTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_HighTemp_Develop", (tS32)0xd81d841e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_HighTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_HighTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_HighTemp_Develop::s32SetData(tS16 &tV850_HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_HighTemp_Develop,(tVoid*)&tV850_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_HighTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_HighTemp_Develop::s32SetData(const tS16 &tV850_HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_HighTemp_Develop,(tVoid*)&tV850_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_HighTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_HighTemp_Develop::u8GetData(tS16& tV850_HighTemp_DevelopParam) {  
   vUpdate();
   tV850_HighTemp_DevelopParam = tV850_HighTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_HighTemp_Develop::vSetData(tS16 &tV850_HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_HighTemp_Develop,(tVoid*)&tV850_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_HighTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_HighTemp_Develop::vSetData(const tS16 &tV850_HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_HighTemp_Develop,(tVoid*)&tV850_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_HighTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_HighTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_HighTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_HighTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_HighTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_HighTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_HighTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_High2WarmTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_High2WarmTemp::dp_tclHeatCtrlDPV850_High2WarmTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_High2WarmTemp(900)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_High2WarmTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("HIGH2WARM_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_High2WarmTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_High2WarmTemp::u8GetData(tS16& tV850_High2WarmTempParam) {
   vUpdate();
   tV850_High2WarmTempParam = tV850_High2WarmTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_High2WarmTemp::tGetData() {
   vUpdate();
   return tV850_High2WarmTemp;
};

tU8 dp_tclHeatCtrlDPV850_High2WarmTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_High2WarmTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_High2WarmTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::dp_tclHeatCtrlDPV850_High2WarmTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_High2WarmTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_High2WarmTemp_Develop",(tS32) 0x379a23f3L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_High2WarmTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_High2WarmTemp_Develop", (tS32)0x379a23f3L);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_High2WarmTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::tGetData() {
   vUpdate();
   return tV850_High2WarmTemp_Develop;
};
tS32 dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::s32GetData(tS16& tV850_High2WarmTemp_DevelopParam) { 
   vUpdate();
   tV850_High2WarmTemp_DevelopParam = tV850_High2WarmTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_High2WarmTemp_Develop", (tS32)0x379a23f3L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::s32SetData(tS16 &tV850_High2WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_High2WarmTemp_Develop,(tVoid*)&tV850_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::s32SetData(const tS16 &tV850_High2WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_High2WarmTemp_Develop,(tVoid*)&tV850_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::u8GetData(tS16& tV850_High2WarmTemp_DevelopParam) {  
   vUpdate();
   tV850_High2WarmTemp_DevelopParam = tV850_High2WarmTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::vSetData(tS16 &tV850_High2WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_High2WarmTemp_Develop,(tVoid*)&tV850_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::vSetData(const tS16 &tV850_High2WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_High2WarmTemp_Develop,(tVoid*)&tV850_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_High2WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_High2WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_High2WarmTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_High2WarmTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_High2WarmTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_WarmTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_WarmTemp::dp_tclHeatCtrlDPV850_WarmTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_WarmTemp(600)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_WarmTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("WARM_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_WarmTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_WarmTemp::u8GetData(tS16& tV850_WarmTempParam) {
   vUpdate();
   tV850_WarmTempParam = tV850_WarmTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_WarmTemp::tGetData() {
   vUpdate();
   return tV850_WarmTemp;
};

tU8 dp_tclHeatCtrlDPV850_WarmTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_WarmTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_WarmTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_WarmTemp_Develop::dp_tclHeatCtrlDPV850_WarmTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_WarmTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_WarmTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_WarmTemp_Develop",(tS32) 0x77b02f15);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_WarmTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_WarmTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_WarmTemp_Develop", (tS32)0x77b02f15);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_WarmTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_WarmTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_WarmTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_WarmTemp_Develop::tGetData() {
   vUpdate();
   return tV850_WarmTemp_Develop;
};
tS32 dp_tclHeatCtrlDPV850_WarmTemp_Develop::s32GetData(tS16& tV850_WarmTemp_DevelopParam) { 
   vUpdate();
   tV850_WarmTemp_DevelopParam = tV850_WarmTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_WarmTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_WarmTemp_Develop", (tS32)0x77b02f15);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_WarmTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_WarmTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_WarmTemp_Develop::s32SetData(tS16 &tV850_WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_WarmTemp_Develop,(tVoid*)&tV850_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_WarmTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_WarmTemp_Develop::s32SetData(const tS16 &tV850_WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_WarmTemp_Develop,(tVoid*)&tV850_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_WarmTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_WarmTemp_Develop::u8GetData(tS16& tV850_WarmTemp_DevelopParam) {  
   vUpdate();
   tV850_WarmTemp_DevelopParam = tV850_WarmTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_WarmTemp_Develop::vSetData(tS16 &tV850_WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_WarmTemp_Develop,(tVoid*)&tV850_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_WarmTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_WarmTemp_Develop::vSetData(const tS16 &tV850_WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_WarmTemp_Develop,(tVoid*)&tV850_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_WarmTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_WarmTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_WarmTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_WarmTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_WarmTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_WarmTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_WarmTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_Warm2NormalTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_Warm2NormalTemp::dp_tclHeatCtrlDPV850_Warm2NormalTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_Warm2NormalTemp(600)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_Warm2NormalTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("WARM2NORMAL_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_Warm2NormalTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_Warm2NormalTemp::u8GetData(tS16& tV850_Warm2NormalTempParam) {
   vUpdate();
   tV850_Warm2NormalTempParam = tV850_Warm2NormalTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_Warm2NormalTemp::tGetData() {
   vUpdate();
   return tV850_Warm2NormalTemp;
};

tU8 dp_tclHeatCtrlDPV850_Warm2NormalTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_Warm2NormalTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_Warm2NormalTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_Warm2NormalTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_Warm2NormalTemp_Develop",(tS32) 0xac522268L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_Warm2NormalTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_Warm2NormalTemp_Develop", (tS32)0xac522268L);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_Warm2NormalTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::tGetData() {
   vUpdate();
   return tV850_Warm2NormalTemp_Develop;
};
tS32 dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::s32GetData(tS16& tV850_Warm2NormalTemp_DevelopParam) { 
   vUpdate();
   tV850_Warm2NormalTemp_DevelopParam = tV850_Warm2NormalTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_Warm2NormalTemp_Develop", (tS32)0xac522268L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::s32SetData(tS16 &tV850_Warm2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_Warm2NormalTemp_Develop,(tVoid*)&tV850_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::s32SetData(const tS16 &tV850_Warm2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_Warm2NormalTemp_Develop,(tVoid*)&tV850_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::u8GetData(tS16& tV850_Warm2NormalTemp_DevelopParam) {  
   vUpdate();
   tV850_Warm2NormalTemp_DevelopParam = tV850_Warm2NormalTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::vSetData(tS16 &tV850_Warm2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_Warm2NormalTemp_Develop,(tVoid*)&tV850_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::vSetData(const tS16 &tV850_Warm2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_Warm2NormalTemp_Develop,(tVoid*)&tV850_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_Warm2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_Warm2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_Warm2NormalTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_Warm2NormalTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_Warm2NormalTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_Cold2NormalTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_Cold2NormalTemp::dp_tclHeatCtrlDPV850_Cold2NormalTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_Cold2NormalTemp(-100)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_Cold2NormalTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("COLD2NORMAL_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_Cold2NormalTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_Cold2NormalTemp::u8GetData(tS16& tV850_Cold2NormalTempParam) {
   vUpdate();
   tV850_Cold2NormalTempParam = tV850_Cold2NormalTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_Cold2NormalTemp::tGetData() {
   vUpdate();
   return tV850_Cold2NormalTemp;
};

tU8 dp_tclHeatCtrlDPV850_Cold2NormalTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_Cold2NormalTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_Cold2NormalTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_Cold2NormalTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_Cold2NormalTemp_Develop",(tS32) 0xde983bcfL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_Cold2NormalTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_Cold2NormalTemp_Develop", (tS32)0xde983bcfL);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_Cold2NormalTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::tGetData() {
   vUpdate();
   return tV850_Cold2NormalTemp_Develop;
};
tS32 dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::s32GetData(tS16& tV850_Cold2NormalTemp_DevelopParam) { 
   vUpdate();
   tV850_Cold2NormalTemp_DevelopParam = tV850_Cold2NormalTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_Cold2NormalTemp_Develop", (tS32)0xde983bcfL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::s32SetData(tS16 &tV850_Cold2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_Cold2NormalTemp_Develop,(tVoid*)&tV850_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::s32SetData(const tS16 &tV850_Cold2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_Cold2NormalTemp_Develop,(tVoid*)&tV850_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::u8GetData(tS16& tV850_Cold2NormalTemp_DevelopParam) {  
   vUpdate();
   tV850_Cold2NormalTemp_DevelopParam = tV850_Cold2NormalTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::vSetData(tS16 &tV850_Cold2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_Cold2NormalTemp_Develop,(tVoid*)&tV850_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::vSetData(const tS16 &tV850_Cold2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_Cold2NormalTemp_Develop,(tVoid*)&tV850_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_Cold2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_Cold2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_Cold2NormalTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_Cold2NormalTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_Cold2NormalTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_ColdTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_ColdTemp::dp_tclHeatCtrlDPV850_ColdTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_ColdTemp(-100)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_ColdTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("COLD_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_ColdTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_ColdTemp::u8GetData(tS16& tV850_ColdTempParam) {
   vUpdate();
   tV850_ColdTempParam = tV850_ColdTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_ColdTemp::tGetData() {
   vUpdate();
   return tV850_ColdTemp;
};

tU8 dp_tclHeatCtrlDPV850_ColdTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_ColdTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_ColdTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_ColdTemp_Develop::dp_tclHeatCtrlDPV850_ColdTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_ColdTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_ColdTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_ColdTemp_Develop",(tS32) 0x98bb878);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_ColdTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_ColdTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_ColdTemp_Develop", (tS32)0x98bb878);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_ColdTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_ColdTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_ColdTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_ColdTemp_Develop::tGetData() {
   vUpdate();
   return tV850_ColdTemp_Develop;
};
tS32 dp_tclHeatCtrlDPV850_ColdTemp_Develop::s32GetData(tS16& tV850_ColdTemp_DevelopParam) { 
   vUpdate();
   tV850_ColdTemp_DevelopParam = tV850_ColdTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_ColdTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_ColdTemp_Develop", (tS32)0x98bb878);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_ColdTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_ColdTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_ColdTemp_Develop::s32SetData(tS16 &tV850_ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_ColdTemp_Develop,(tVoid*)&tV850_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_ColdTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_ColdTemp_Develop::s32SetData(const tS16 &tV850_ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_ColdTemp_Develop,(tVoid*)&tV850_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_ColdTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_ColdTemp_Develop::u8GetData(tS16& tV850_ColdTemp_DevelopParam) {  
   vUpdate();
   tV850_ColdTemp_DevelopParam = tV850_ColdTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_ColdTemp_Develop::vSetData(tS16 &tV850_ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_ColdTemp_Develop,(tVoid*)&tV850_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_ColdTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_ColdTemp_Develop::vSetData(const tS16 &tV850_ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_ColdTemp_Develop,(tVoid*)&tV850_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_ColdTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_ColdTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_ColdTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_ColdTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_ColdTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_ColdTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_ColdTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_Low2ColdTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_Low2ColdTemp::dp_tclHeatCtrlDPV850_Low2ColdTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_Low2ColdTemp(-200)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_Low2ColdTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("LOW2COLD_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_Low2ColdTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_Low2ColdTemp::u8GetData(tS16& tV850_Low2ColdTempParam) {
   vUpdate();
   tV850_Low2ColdTempParam = tV850_Low2ColdTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_Low2ColdTemp::tGetData() {
   vUpdate();
   return tV850_Low2ColdTemp;
};

tU8 dp_tclHeatCtrlDPV850_Low2ColdTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_Low2ColdTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_Low2ColdTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_Low2ColdTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_Low2ColdTemp_Develop",(tS32) 0x5ff0f150);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_Low2ColdTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_Low2ColdTemp_Develop", (tS32)0x5ff0f150);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_Low2ColdTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::tGetData() {
   vUpdate();
   return tV850_Low2ColdTemp_Develop;
};
tS32 dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::s32GetData(tS16& tV850_Low2ColdTemp_DevelopParam) { 
   vUpdate();
   tV850_Low2ColdTemp_DevelopParam = tV850_Low2ColdTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_Low2ColdTemp_Develop", (tS32)0x5ff0f150);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::s32SetData(tS16 &tV850_Low2ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_Low2ColdTemp_Develop,(tVoid*)&tV850_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::s32SetData(const tS16 &tV850_Low2ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_Low2ColdTemp_Develop,(tVoid*)&tV850_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::u8GetData(tS16& tV850_Low2ColdTemp_DevelopParam) {  
   vUpdate();
   tV850_Low2ColdTemp_DevelopParam = tV850_Low2ColdTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::vSetData(tS16 &tV850_Low2ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_Low2ColdTemp_Develop,(tVoid*)&tV850_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::vSetData(const tS16 &tV850_Low2ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_Low2ColdTemp_Develop,(tVoid*)&tV850_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_Low2ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_Low2ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_Low2ColdTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_Low2ColdTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_Low2ColdTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_LowTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_LowTemp::dp_tclHeatCtrlDPV850_LowTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_LowTemp(-200)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_LowTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("LOW_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_LowTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_LowTemp::u8GetData(tS16& tV850_LowTempParam) {
   vUpdate();
   tV850_LowTempParam = tV850_LowTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_LowTemp::tGetData() {
   vUpdate();
   return tV850_LowTemp;
};

tU8 dp_tclHeatCtrlDPV850_LowTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_LowTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_LowTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_LowTemp_Develop::dp_tclHeatCtrlDPV850_LowTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_LowTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_LowTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_LowTemp_Develop",(tS32) 0x4864d370);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_LowTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_LowTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_LowTemp_Develop", (tS32)0x4864d370);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_LowTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_LowTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_LowTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_LowTemp_Develop::tGetData() {
   vUpdate();
   return tV850_LowTemp_Develop;
};
tS32 dp_tclHeatCtrlDPV850_LowTemp_Develop::s32GetData(tS16& tV850_LowTemp_DevelopParam) { 
   vUpdate();
   tV850_LowTemp_DevelopParam = tV850_LowTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_LowTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_LowTemp_Develop", (tS32)0x4864d370);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_LowTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_LowTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_LowTemp_Develop::s32SetData(tS16 &tV850_LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_LowTemp_Develop,(tVoid*)&tV850_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_LowTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_LowTemp_Develop::s32SetData(const tS16 &tV850_LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_LowTemp_Develop,(tVoid*)&tV850_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_LowTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_LowTemp_Develop::u8GetData(tS16& tV850_LowTemp_DevelopParam) {  
   vUpdate();
   tV850_LowTemp_DevelopParam = tV850_LowTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_LowTemp_Develop::vSetData(tS16 &tV850_LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_LowTemp_Develop,(tVoid*)&tV850_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_LowTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_LowTemp_Develop::vSetData(const tS16 &tV850_LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_LowTemp_Develop,(tVoid*)&tV850_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_LowTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_LowTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_LowTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_LowTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_LowTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_LowTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_LowTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_CriticalLow2LowTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_CriticalLow2LowTemp::dp_tclHeatCtrlDPV850_CriticalLow2LowTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_CriticalLow2LowTemp(-400)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_CriticalLow2LowTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CRITICALLOW2LOW_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_CriticalLow2LowTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_CriticalLow2LowTemp::u8GetData(tS16& tV850_CriticalLow2LowTempParam) {
   vUpdate();
   tV850_CriticalLow2LowTempParam = tV850_CriticalLow2LowTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_CriticalLow2LowTemp::tGetData() {
   vUpdate();
   return tV850_CriticalLow2LowTemp;
};

tU8 dp_tclHeatCtrlDPV850_CriticalLow2LowTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_CriticalLow2LowTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_CriticalLow2LowTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_CriticalLow2LowTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_CriticalLow2LowTemp_Develop",(tS32) 0x784c2ef7L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_CriticalLow2LowTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_CriticalLow2LowTemp_Develop", (tS32)0x784c2ef7L);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_CriticalLow2LowTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::tGetData() {
   vUpdate();
   return tV850_CriticalLow2LowTemp_Develop;
};
tS32 dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::s32GetData(tS16& tV850_CriticalLow2LowTemp_DevelopParam) { 
   vUpdate();
   tV850_CriticalLow2LowTemp_DevelopParam = tV850_CriticalLow2LowTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_CriticalLow2LowTemp_Develop", (tS32)0x784c2ef7L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::s32SetData(tS16 &tV850_CriticalLow2LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_CriticalLow2LowTemp_Develop,(tVoid*)&tV850_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::s32SetData(const tS16 &tV850_CriticalLow2LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_CriticalLow2LowTemp_Develop,(tVoid*)&tV850_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::u8GetData(tS16& tV850_CriticalLow2LowTemp_DevelopParam) {  
   vUpdate();
   tV850_CriticalLow2LowTemp_DevelopParam = tV850_CriticalLow2LowTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::vSetData(tS16 &tV850_CriticalLow2LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_CriticalLow2LowTemp_Develop,(tVoid*)&tV850_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::vSetData(const tS16 &tV850_CriticalLow2LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_CriticalLow2LowTemp_Develop,(tVoid*)&tV850_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_CriticalLow2LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_CriticalLow2LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_CriticalLow2LowTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_CriticalLow2LowTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_CriticalLow2LowTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_CriticalLowTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_CriticalLowTemp::dp_tclHeatCtrlDPV850_CriticalLowTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_CriticalLowTemp(-400)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_CriticalLowTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CRITICALLOW_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_CriticalLowTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_CriticalLowTemp::u8GetData(tS16& tV850_CriticalLowTempParam) {
   vUpdate();
   tV850_CriticalLowTempParam = tV850_CriticalLowTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_CriticalLowTemp::tGetData() {
   vUpdate();
   return tV850_CriticalLowTemp;
};

tU8 dp_tclHeatCtrlDPV850_CriticalLowTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_CriticalLowTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_CriticalLowTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_CriticalLowTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_CriticalLowTemp_Develop",(tS32) 0x87079c6fL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_CriticalLowTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_CriticalLowTemp_Develop", (tS32)0x87079c6fL);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_CriticalLowTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::tGetData() {
   vUpdate();
   return tV850_CriticalLowTemp_Develop;
};
tS32 dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::s32GetData(tS16& tV850_CriticalLowTemp_DevelopParam) { 
   vUpdate();
   tV850_CriticalLowTemp_DevelopParam = tV850_CriticalLowTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_CriticalLowTemp_Develop", (tS32)0x87079c6fL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::s32SetData(tS16 &tV850_CriticalLowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_CriticalLowTemp_Develop,(tVoid*)&tV850_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::s32SetData(const tS16 &tV850_CriticalLowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_CriticalLowTemp_Develop,(tVoid*)&tV850_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::u8GetData(tS16& tV850_CriticalLowTemp_DevelopParam) {  
   vUpdate();
   tV850_CriticalLowTemp_DevelopParam = tV850_CriticalLowTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::vSetData(tS16 &tV850_CriticalLowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_CriticalLowTemp_Develop,(tVoid*)&tV850_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::vSetData(const tS16 &tV850_CriticalLowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_CriticalLowTemp_Develop,(tVoid*)&tV850_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_CriticalLowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_CriticalLowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_CriticalLowTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_CriticalLowTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_CriticalLowTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_ATTENUATION_CYCLETIME"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME::dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_ATTENUATION_CYCLETIME(60)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CYCLETIME_ATTENUATION",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_ATTENUATION_CYCLETIME = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME::u8GetData(tU8& tV850_ATTENUATION_CYCLETIMEParam) {
   vUpdate();
   tV850_ATTENUATION_CYCLETIMEParam = tV850_ATTENUATION_CYCLETIME;
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME::tGetData() {
   vUpdate();
   return tV850_ATTENUATION_CYCLETIME;
};

tU8 dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_ATTENUATION_CYCLETIME_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_ATTENUATION_CYCLETIME_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_ATTENUATION_CYCLETIME_Develop",(tS32) 0x56a31d72L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tV850_ATTENUATION_CYCLETIME_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_ATTENUATION_CYCLETIME_Develop", (tS32)0x56a31d72L);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_ATTENUATION_CYCLETIME_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::tGetData() {
   vUpdate();
   return tV850_ATTENUATION_CYCLETIME_Develop;
};
tS32 dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::s32GetData(tU8& tV850_ATTENUATION_CYCLETIME_DevelopParam) { 
   vUpdate();
   tV850_ATTENUATION_CYCLETIME_DevelopParam = tV850_ATTENUATION_CYCLETIME_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_ATTENUATION_CYCLETIME_Develop", (tS32)0x56a31d72L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::s32SetData(tU8 &tV850_ATTENUATION_CYCLETIME_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tV850_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::s32SetData(const tU8 &tV850_ATTENUATION_CYCLETIME_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tV850_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::u8GetData(tU8& tV850_ATTENUATION_CYCLETIME_DevelopParam) {  
   vUpdate();
   tV850_ATTENUATION_CYCLETIME_DevelopParam = tV850_ATTENUATION_CYCLETIME_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::vSetData(tU8 &tV850_ATTENUATION_CYCLETIME_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tV850_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tV850_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::vSetData(const tU8 &tV850_ATTENUATION_CYCLETIME_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tV850_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tV850_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_ATTENUATION_CYCLETIME_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_ATTENUATION_CYCLETIME_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_ATTENUATION_CYCLETIME_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_ATTENUATION_CYCLETIME_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_ATTENUATION_CYCLETIME_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_FAN_SYSTEM_SPEED_000_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH::dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_000_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH::u8GetData(tS16& tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGHParam) {
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGHParam = tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH::tGetData() {
   vUpdate();
   return tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop",(tS32) 0x5c1447e8L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", (tS32)0x5c1447e8L);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32GetData(tS16& tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam = tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", (tS32)0x5c1447e8L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32SetData(tS16 &tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32SetData(const tS16 &tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::u8GetData(tS16& tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam = tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16 &tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(const tS16 &tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_FAN_SYSTEM_SPEED_025_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH::dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_025_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH::u8GetData(tS16& tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGHParam) {
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGHParam = tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH::tGetData() {
   vUpdate();
   return tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop",(tS32) 0x935fb9fL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", (tS32)0x935fb9fL);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32GetData(tS16& tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam = tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", (tS32)0x935fb9fL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32SetData(tS16 &tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32SetData(const tS16 &tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::u8GetData(tS16& tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam = tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16 &tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(const tS16 &tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_FAN_SYSTEM_SPEED_050_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH::dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_050_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH::u8GetData(tS16& tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGHParam) {
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGHParam = tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH::tGetData() {
   vUpdate();
   return tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop",(tS32) 0xd1f71e19L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", (tS32)0xd1f71e19L);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32GetData(tS16& tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam = tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", (tS32)0xd1f71e19L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32SetData(tS16 &tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32SetData(const tS16 &tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::u8GetData(tS16& tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam = tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16 &tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(const tS16 &tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_FAN_SYSTEM_SPEED_075_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH::dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_075_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH::u8GetData(tS16& tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGHParam) {
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGHParam = tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH::tGetData() {
   vUpdate();
   return tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop",(tS32) 0x7f18d1d0L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", (tS32)0x7f18d1d0L);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32GetData(tS16& tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam = tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", (tS32)0x7f18d1d0L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32SetData(tS16 &tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32SetData(const tS16 &tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::u8GetData(tS16& tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam = tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16 &tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(const tS16 &tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_MAX_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::u8GetData(tS16& tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGHParam) {
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGHParam = tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::tGetData() {
   vUpdate();
   return tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop",(tS32) 0x434ba6aL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", (tS32)0x434ba6aL);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32GetData(tS16& tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam = tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", (tS32)0x434ba6aL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32SetData(tS16 &tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32SetData(const tS16 &tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::u8GetData(tS16& tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam = tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16 &tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(const tS16 &tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_FAN_SYSTEM_SPEED_WARM_STATE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE::dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_FAN_SYSTEM_SPEED_WARM_STATE(0xFFFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_WARM_STATE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_FAN_SYSTEM_SPEED_WARM_STATE = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE::u8GetData(tU16& tV850_FAN_SYSTEM_SPEED_WARM_STATEParam) {
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_WARM_STATEParam = tV850_FAN_SYSTEM_SPEED_WARM_STATE;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE::tGetData() {
   vUpdate();
   return tV850_FAN_SYSTEM_SPEED_WARM_STATE;
};

tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_FAN_SYSTEM_SPEED_WARM_STATE_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_WARM_STATE_Develop",(tS32) 0xf08ec4afL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_WARM_STATE_Develop", (tS32)0xf08ec4afL);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::tGetData() {
   vUpdate();
   return tV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop;
};
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32GetData(tU16& tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) { 
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam = tV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_WARM_STATE_Develop", (tS32)0xf08ec4afL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32SetData(tU16 &tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32SetData(const tU16 &tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::u8GetData(tU16& tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) {  
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam = tV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16 &tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(const tU16 &tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_FAN_SYSTEM_SPEED_WARM_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_FAN_SYSTEM_SPEED_WARM_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_WARM_STATE_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_FAN_SYSTEM_SPEED_WARM_STATE_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_FAN_SYSTEM_SPEED_WARM_STATE_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_FAN_SYSTEM_SPEED_HIGH_STATE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE::dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tV850_FAN_SYSTEM_SPEED_HIGH_STATE(0xFFFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/V850SENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_HIGH_STATE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tV850_FAN_SYSTEM_SPEED_HIGH_STATE = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE::u8GetData(tU16& tV850_FAN_SYSTEM_SPEED_HIGH_STATEParam) {
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_HIGH_STATEParam = tV850_FAN_SYSTEM_SPEED_HIGH_STATE;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE::tGetData() {
   vUpdate();
   return tV850_FAN_SYSTEM_SPEED_HIGH_STATE;
};

tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop",(tS32) 0x5b3c1290L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", (tS32)0x5b3c1290L);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::tGetData() {
   vUpdate();
   return tV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop;
};
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32GetData(tU16& tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) { 
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam = tV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", (tS32)0x5b3c1290L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32SetData(tU16 &tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32SetData(const tU16 &tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::u8GetData(tU16& tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) {  
   vUpdate();
   tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam = tV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16 &tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(const tU16 &tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tV850_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_FAN_SYSTEM_SPEED_HIGH_STATE_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_Statistics_MinTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_Statistics_MinTemp::dp_tclHeatCtrlDPV850_Statistics_MinTemp(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_Statistics_MinTemp,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_Statistics_MinTemp::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_Statistics_MinTemp",(tS32) 0x267e899a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_Statistics_MinTemp = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_Statistics_MinTemp::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_Statistics_MinTemp", (tS32)0x267e899a);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_Statistics_MinTemp, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_Statistics_MinTemp::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_Statistics_MinTemp::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_Statistics_MinTemp::tGetData() {
   vUpdate();
   return tV850_Statistics_MinTemp;
};
tS32 dp_tclHeatCtrlDPV850_Statistics_MinTemp::s32GetData(tS16& tV850_Statistics_MinTempParam) { 
   vUpdate();
   tV850_Statistics_MinTempParam = tV850_Statistics_MinTemp;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_Statistics_MinTemp::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_Statistics_MinTemp", (tS32)0x267e899a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_Statistics_MinTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_Statistics_MinTemp::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_Statistics_MinTemp::s32SetData(tS16 &tV850_Statistics_MinTempParam) {
   //init parameter
   (tVoid)memcpy(&tV850_Statistics_MinTemp,(tVoid*)&tV850_Statistics_MinTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPV850_Statistics_MinTemp::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_Statistics_MinTemp::s32SetData(const tS16 &tV850_Statistics_MinTempParam) {
   //init parameter
   (tVoid)memcpy(&tV850_Statistics_MinTemp,(tVoid*)&tV850_Statistics_MinTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPV850_Statistics_MinTemp::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_Statistics_MinTemp::u8GetData(tS16& tV850_Statistics_MinTempParam) {  
   vUpdate();
   tV850_Statistics_MinTempParam = tV850_Statistics_MinTemp;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_Statistics_MinTemp::vSetData(tS16 &tV850_Statistics_MinTempParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_Statistics_MinTemp,(tVoid*)&tV850_Statistics_MinTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPV850_Statistics_MinTemp::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_Statistics_MinTemp::vSetData(const tS16 &tV850_Statistics_MinTempParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_Statistics_MinTemp,(tVoid*)&tV850_Statistics_MinTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPV850_Statistics_MinTemp::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_Statistics_MinTemp::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_Statistics_MinTemp::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_Statistics_MinTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_Statistics_MinTemp::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_Statistics_MinTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_Statistics_MinTemp::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_Statistics_MinTemp", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_Statistics_MinTemp has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "V850_Statistics_MaxTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPV850_Statistics_MaxTemp::dp_tclHeatCtrlDPV850_Statistics_MaxTemp(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tV850_Statistics_MaxTemp,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPV850_Statistics_MaxTemp::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("V850_Statistics_MaxTemp",(tS32) 0x267e405c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tV850_Statistics_MaxTemp = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPV850_Statistics_MaxTemp::vStore(tVoid) {
   dp_tclBaseElement myDpElem("V850_Statistics_MaxTemp", (tS32)0x267e405c);
   (tVoid)myDpElem.bFillData((tVoid*)&tV850_Statistics_MaxTemp, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPV850_Statistics_MaxTemp::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPV850_Statistics_MaxTemp::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPV850_Statistics_MaxTemp::tGetData() {
   vUpdate();
   return tV850_Statistics_MaxTemp;
};
tS32 dp_tclHeatCtrlDPV850_Statistics_MaxTemp::s32GetData(tS16& tV850_Statistics_MaxTempParam) { 
   vUpdate();
   tV850_Statistics_MaxTempParam = tV850_Statistics_MaxTemp;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPV850_Statistics_MaxTemp::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("V850_Statistics_MaxTemp", (tS32)0x267e405c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPV850_Statistics_MaxTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPV850_Statistics_MaxTemp::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPV850_Statistics_MaxTemp::s32SetData(tS16 &tV850_Statistics_MaxTempParam) {
   //init parameter
   (tVoid)memcpy(&tV850_Statistics_MaxTemp,(tVoid*)&tV850_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPV850_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPV850_Statistics_MaxTemp::s32SetData(const tS16 &tV850_Statistics_MaxTempParam) {
   //init parameter
   (tVoid)memcpy(&tV850_Statistics_MaxTemp,(tVoid*)&tV850_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tV850_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPV850_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPV850_Statistics_MaxTemp::u8GetData(tS16& tV850_Statistics_MaxTempParam) {  
   vUpdate();
   tV850_Statistics_MaxTempParam = tV850_Statistics_MaxTemp;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPV850_Statistics_MaxTemp::vSetData(tS16 &tV850_Statistics_MaxTempParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_Statistics_MaxTemp,(tVoid*)&tV850_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPV850_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPV850_Statistics_MaxTemp::vSetData(const tS16 &tV850_Statistics_MaxTempParam) { 
   //init parameter
   (tVoid)memcpy(&tV850_Statistics_MaxTemp,(tVoid*)&tV850_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tV850_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPV850_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPV850_Statistics_MaxTemp::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPV850_Statistics_MaxTemp::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_Statistics_MaxTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_Statistics_MaxTemp::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "V850_Statistics_MaxTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPV850_Statistics_MaxTemp::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: V850_Statistics_MaxTemp", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element V850_Statistics_MaxTemp has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_AVAIL"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_AVAIL::dp_tclHeatCtrlDPPANEL_AVAIL() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_AVAIL(TRUE)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_AVAIL::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("AVAIL",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_AVAIL = (tBool)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_AVAIL::u8GetData(tBool& tPANEL_AVAILParam) {
   vUpdate();
   tPANEL_AVAILParam = tPANEL_AVAIL;
   return _u8DataStatus;
}
tBool dp_tclHeatCtrlDPPANEL_AVAIL::tGetData() {
   vUpdate();
   return tPANEL_AVAIL;
};

tU8 dp_tclHeatCtrlDPPANEL_AVAIL::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_AVAIL::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_AVAIL_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_AVAIL_Develop::dp_tclHeatCtrlDPPANEL_AVAIL_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_AVAIL_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_AVAIL_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_AVAIL_Develop",(tS32) 0xd98d1d4a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPANEL_AVAIL_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_AVAIL_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_AVAIL_Develop", (tS32)0xd98d1d4a);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_AVAIL_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_AVAIL_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_AVAIL_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPPANEL_AVAIL_Develop::tGetData() {
   vUpdate();
   return tPANEL_AVAIL_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_AVAIL_Develop::s32GetData(tU8& tPANEL_AVAIL_DevelopParam) { 
   vUpdate();
   tPANEL_AVAIL_DevelopParam = tPANEL_AVAIL_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_AVAIL_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_AVAIL_Develop", (tS32)0xd98d1d4a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_AVAIL_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_AVAIL_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_AVAIL_Develop::s32SetData(tU8 &tPANEL_AVAIL_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_AVAIL_Develop,(tVoid*)&tPANEL_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_AVAIL_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_AVAIL_Develop::s32SetData(const tU8 &tPANEL_AVAIL_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_AVAIL_Develop,(tVoid*)&tPANEL_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_AVAIL_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_AVAIL_Develop::u8GetData(tU8& tPANEL_AVAIL_DevelopParam) {  
   vUpdate();
   tPANEL_AVAIL_DevelopParam = tPANEL_AVAIL_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_AVAIL_Develop::vSetData(tU8 &tPANEL_AVAIL_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_AVAIL_Develop,(tVoid*)&tPANEL_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPANEL_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_AVAIL_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_AVAIL_Develop::vSetData(const tU8 &tPANEL_AVAIL_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_AVAIL_Develop,(tVoid*)&tPANEL_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPANEL_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_AVAIL_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_AVAIL_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_AVAIL_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_AVAIL_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_AVAIL_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_AVAIL_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_AVAIL_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_AVAIL_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_AVAIL_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_MinTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_MinTemp::dp_tclHeatCtrlDPPANEL_MinTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_MinTemp(-460)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_MinTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MIN_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_MinTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_MinTemp::u8GetData(tS16& tPANEL_MinTempParam) {
   vUpdate();
   tPANEL_MinTempParam = tPANEL_MinTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_MinTemp::tGetData() {
   vUpdate();
   return tPANEL_MinTemp;
};

tU8 dp_tclHeatCtrlDPPANEL_MinTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_MinTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_MaxTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_MaxTemp::dp_tclHeatCtrlDPPANEL_MaxTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_MaxTemp(1310)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_MaxTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MAX_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_MaxTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_MaxTemp::u8GetData(tS16& tPANEL_MaxTempParam) {
   vUpdate();
   tPANEL_MaxTempParam = tPANEL_MaxTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_MaxTemp::tGetData() {
   vUpdate();
   return tPANEL_MaxTemp;
};

tU8 dp_tclHeatCtrlDPPANEL_MaxTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_MaxTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_EmergencyHighTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_EmergencyHighTemp::dp_tclHeatCtrlDPPANEL_EmergencyHighTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_EmergencyHighTemp(850)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_EmergencyHighTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("EMERGHIGH_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_EmergencyHighTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_EmergencyHighTemp::u8GetData(tS16& tPANEL_EmergencyHighTempParam) {
   vUpdate();
   tPANEL_EmergencyHighTempParam = tPANEL_EmergencyHighTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_EmergencyHighTemp::tGetData() {
   vUpdate();
   return tPANEL_EmergencyHighTemp;
};

tU8 dp_tclHeatCtrlDPPANEL_EmergencyHighTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_EmergencyHighTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_EmergencyHighTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_EmergencyHighTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_EmergencyHighTemp_Develop",(tS32) 0x951d5d82L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_EmergencyHighTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_EmergencyHighTemp_Develop", (tS32)0x951d5d82L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_EmergencyHighTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::tGetData() {
   vUpdate();
   return tPANEL_EmergencyHighTemp_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::s32GetData(tS16& tPANEL_EmergencyHighTemp_DevelopParam) { 
   vUpdate();
   tPANEL_EmergencyHighTemp_DevelopParam = tPANEL_EmergencyHighTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_EmergencyHighTemp_Develop", (tS32)0x951d5d82L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::s32SetData(tS16 &tPANEL_EmergencyHighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_EmergencyHighTemp_Develop,(tVoid*)&tPANEL_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::s32SetData(const tS16 &tPANEL_EmergencyHighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_EmergencyHighTemp_Develop,(tVoid*)&tPANEL_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::u8GetData(tS16& tPANEL_EmergencyHighTemp_DevelopParam) {  
   vUpdate();
   tPANEL_EmergencyHighTemp_DevelopParam = tPANEL_EmergencyHighTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::vSetData(tS16 &tPANEL_EmergencyHighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_EmergencyHighTemp_Develop,(tVoid*)&tPANEL_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::vSetData(const tS16 &tPANEL_EmergencyHighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_EmergencyHighTemp_Develop,(tVoid*)&tPANEL_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_EmergencyHighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_EmergencyHighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_EmergencyHighTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_EmergencyHighTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_EmergencyHighTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_EmergencyHigh2HighTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp::dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_EmergencyHigh2HighTemp(850)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("EMERGHIGH2HIGH_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_EmergencyHigh2HighTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp::u8GetData(tS16& tPANEL_EmergencyHigh2HighTempParam) {
   vUpdate();
   tPANEL_EmergencyHigh2HighTempParam = tPANEL_EmergencyHigh2HighTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp::tGetData() {
   vUpdate();
   return tPANEL_EmergencyHigh2HighTemp;
};

tU8 dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_EmergencyHigh2HighTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_EmergencyHigh2HighTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_EmergencyHigh2HighTemp_Develop",(tS32) 0xb7302ab0L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_EmergencyHigh2HighTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_EmergencyHigh2HighTemp_Develop", (tS32)0xb7302ab0L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_EmergencyHigh2HighTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::tGetData() {
   vUpdate();
   return tPANEL_EmergencyHigh2HighTemp_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::s32GetData(tS16& tPANEL_EmergencyHigh2HighTemp_DevelopParam) { 
   vUpdate();
   tPANEL_EmergencyHigh2HighTemp_DevelopParam = tPANEL_EmergencyHigh2HighTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_EmergencyHigh2HighTemp_Develop", (tS32)0xb7302ab0L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::s32SetData(tS16 &tPANEL_EmergencyHigh2HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_EmergencyHigh2HighTemp_Develop,(tVoid*)&tPANEL_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::s32SetData(const tS16 &tPANEL_EmergencyHigh2HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_EmergencyHigh2HighTemp_Develop,(tVoid*)&tPANEL_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::u8GetData(tS16& tPANEL_EmergencyHigh2HighTemp_DevelopParam) {  
   vUpdate();
   tPANEL_EmergencyHigh2HighTemp_DevelopParam = tPANEL_EmergencyHigh2HighTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::vSetData(tS16 &tPANEL_EmergencyHigh2HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_EmergencyHigh2HighTemp_Develop,(tVoid*)&tPANEL_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::vSetData(const tS16 &tPANEL_EmergencyHigh2HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_EmergencyHigh2HighTemp_Develop,(tVoid*)&tPANEL_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_EmergencyHigh2HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_EmergencyHigh2HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_EmergencyHigh2HighTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_EmergencyHigh2HighTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_EmergencyHigh2HighTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_HighTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_HighTemp::dp_tclHeatCtrlDPPANEL_HighTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_HighTemp(800)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_HighTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("HIGH_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_HighTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_HighTemp::u8GetData(tS16& tPANEL_HighTempParam) {
   vUpdate();
   tPANEL_HighTempParam = tPANEL_HighTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_HighTemp::tGetData() {
   vUpdate();
   return tPANEL_HighTemp;
};

tU8 dp_tclHeatCtrlDPPANEL_HighTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_HighTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_HighTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_HighTemp_Develop::dp_tclHeatCtrlDPPANEL_HighTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_HighTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_HighTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_HighTemp_Develop",(tS32) 0xa6a0d503);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_HighTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_HighTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_HighTemp_Develop", (tS32)0xa6a0d503);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_HighTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_HighTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_HighTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_HighTemp_Develop::tGetData() {
   vUpdate();
   return tPANEL_HighTemp_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_HighTemp_Develop::s32GetData(tS16& tPANEL_HighTemp_DevelopParam) { 
   vUpdate();
   tPANEL_HighTemp_DevelopParam = tPANEL_HighTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_HighTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_HighTemp_Develop", (tS32)0xa6a0d503);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_HighTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_HighTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_HighTemp_Develop::s32SetData(tS16 &tPANEL_HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_HighTemp_Develop,(tVoid*)&tPANEL_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_HighTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_HighTemp_Develop::s32SetData(const tS16 &tPANEL_HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_HighTemp_Develop,(tVoid*)&tPANEL_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_HighTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_HighTemp_Develop::u8GetData(tS16& tPANEL_HighTemp_DevelopParam) {  
   vUpdate();
   tPANEL_HighTemp_DevelopParam = tPANEL_HighTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_HighTemp_Develop::vSetData(tS16 &tPANEL_HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_HighTemp_Develop,(tVoid*)&tPANEL_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_HighTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_HighTemp_Develop::vSetData(const tS16 &tPANEL_HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_HighTemp_Develop,(tVoid*)&tPANEL_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_HighTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_HighTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_HighTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_HighTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_HighTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_HighTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_HighTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_High2WarmTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_High2WarmTemp::dp_tclHeatCtrlDPPANEL_High2WarmTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_High2WarmTemp(800)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_High2WarmTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("HIGH2WARM_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_High2WarmTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_High2WarmTemp::u8GetData(tS16& tPANEL_High2WarmTempParam) {
   vUpdate();
   tPANEL_High2WarmTempParam = tPANEL_High2WarmTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_High2WarmTemp::tGetData() {
   vUpdate();
   return tPANEL_High2WarmTemp;
};

tU8 dp_tclHeatCtrlDPPANEL_High2WarmTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_High2WarmTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_High2WarmTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_High2WarmTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_High2WarmTemp_Develop",(tS32) 0x20949f5cL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_High2WarmTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_High2WarmTemp_Develop", (tS32)0x20949f5cL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_High2WarmTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::tGetData() {
   vUpdate();
   return tPANEL_High2WarmTemp_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::s32GetData(tS16& tPANEL_High2WarmTemp_DevelopParam) { 
   vUpdate();
   tPANEL_High2WarmTemp_DevelopParam = tPANEL_High2WarmTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_High2WarmTemp_Develop", (tS32)0x20949f5cL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::s32SetData(tS16 &tPANEL_High2WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_High2WarmTemp_Develop,(tVoid*)&tPANEL_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::s32SetData(const tS16 &tPANEL_High2WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_High2WarmTemp_Develop,(tVoid*)&tPANEL_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::u8GetData(tS16& tPANEL_High2WarmTemp_DevelopParam) {  
   vUpdate();
   tPANEL_High2WarmTemp_DevelopParam = tPANEL_High2WarmTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::vSetData(tS16 &tPANEL_High2WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_High2WarmTemp_Develop,(tVoid*)&tPANEL_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::vSetData(const tS16 &tPANEL_High2WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_High2WarmTemp_Develop,(tVoid*)&tPANEL_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_High2WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_High2WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_High2WarmTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_High2WarmTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_High2WarmTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_WarmTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_WarmTemp::dp_tclHeatCtrlDPPANEL_WarmTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_WarmTemp(600)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_WarmTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("WARM_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_WarmTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_WarmTemp::u8GetData(tS16& tPANEL_WarmTempParam) {
   vUpdate();
   tPANEL_WarmTempParam = tPANEL_WarmTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_WarmTemp::tGetData() {
   vUpdate();
   return tPANEL_WarmTemp;
};

tU8 dp_tclHeatCtrlDPPANEL_WarmTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_WarmTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_WarmTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::dp_tclHeatCtrlDPPANEL_WarmTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_WarmTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_WarmTemp_Develop",(tS32) 0x46337ffa);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_WarmTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_WarmTemp_Develop", (tS32)0x46337ffa);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_WarmTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::tGetData() {
   vUpdate();
   return tPANEL_WarmTemp_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::s32GetData(tS16& tPANEL_WarmTemp_DevelopParam) { 
   vUpdate();
   tPANEL_WarmTemp_DevelopParam = tPANEL_WarmTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_WarmTemp_Develop", (tS32)0x46337ffa);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::s32SetData(tS16 &tPANEL_WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_WarmTemp_Develop,(tVoid*)&tPANEL_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::s32SetData(const tS16 &tPANEL_WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_WarmTemp_Develop,(tVoid*)&tPANEL_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::u8GetData(tS16& tPANEL_WarmTemp_DevelopParam) {  
   vUpdate();
   tPANEL_WarmTemp_DevelopParam = tPANEL_WarmTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::vSetData(tS16 &tPANEL_WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_WarmTemp_Develop,(tVoid*)&tPANEL_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::vSetData(const tS16 &tPANEL_WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_WarmTemp_Develop,(tVoid*)&tPANEL_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_WarmTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_WarmTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_WarmTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_Warm2NormalTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_Warm2NormalTemp::dp_tclHeatCtrlDPPANEL_Warm2NormalTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_Warm2NormalTemp(600)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_Warm2NormalTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("WARM2NORMAL_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_Warm2NormalTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_Warm2NormalTemp::u8GetData(tS16& tPANEL_Warm2NormalTempParam) {
   vUpdate();
   tPANEL_Warm2NormalTempParam = tPANEL_Warm2NormalTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_Warm2NormalTemp::tGetData() {
   vUpdate();
   return tPANEL_Warm2NormalTemp;
};

tU8 dp_tclHeatCtrlDPPANEL_Warm2NormalTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_Warm2NormalTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_Warm2NormalTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_Warm2NormalTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_Warm2NormalTemp_Develop",(tS32) 0x6cc82fa9L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_Warm2NormalTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_Warm2NormalTemp_Develop", (tS32)0x6cc82fa9L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_Warm2NormalTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::tGetData() {
   vUpdate();
   return tPANEL_Warm2NormalTemp_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::s32GetData(tS16& tPANEL_Warm2NormalTemp_DevelopParam) { 
   vUpdate();
   tPANEL_Warm2NormalTemp_DevelopParam = tPANEL_Warm2NormalTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_Warm2NormalTemp_Develop", (tS32)0x6cc82fa9L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::s32SetData(tS16 &tPANEL_Warm2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_Warm2NormalTemp_Develop,(tVoid*)&tPANEL_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::s32SetData(const tS16 &tPANEL_Warm2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_Warm2NormalTemp_Develop,(tVoid*)&tPANEL_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::u8GetData(tS16& tPANEL_Warm2NormalTemp_DevelopParam) {  
   vUpdate();
   tPANEL_Warm2NormalTemp_DevelopParam = tPANEL_Warm2NormalTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::vSetData(tS16 &tPANEL_Warm2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_Warm2NormalTemp_Develop,(tVoid*)&tPANEL_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::vSetData(const tS16 &tPANEL_Warm2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_Warm2NormalTemp_Develop,(tVoid*)&tPANEL_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_Warm2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_Warm2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_Warm2NormalTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_Warm2NormalTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_Warm2NormalTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_Cold2NormalTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_Cold2NormalTemp::dp_tclHeatCtrlDPPANEL_Cold2NormalTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_Cold2NormalTemp(-100)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_Cold2NormalTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("COLD2NORMAL_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_Cold2NormalTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_Cold2NormalTemp::u8GetData(tS16& tPANEL_Cold2NormalTempParam) {
   vUpdate();
   tPANEL_Cold2NormalTempParam = tPANEL_Cold2NormalTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_Cold2NormalTemp::tGetData() {
   vUpdate();
   return tPANEL_Cold2NormalTemp;
};

tU8 dp_tclHeatCtrlDPPANEL_Cold2NormalTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_Cold2NormalTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_Cold2NormalTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_Cold2NormalTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_Cold2NormalTemp_Develop",(tS32) 0x9f0e4910L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_Cold2NormalTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_Cold2NormalTemp_Develop", (tS32)0x9f0e4910L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_Cold2NormalTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::tGetData() {
   vUpdate();
   return tPANEL_Cold2NormalTemp_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::s32GetData(tS16& tPANEL_Cold2NormalTemp_DevelopParam) { 
   vUpdate();
   tPANEL_Cold2NormalTemp_DevelopParam = tPANEL_Cold2NormalTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_Cold2NormalTemp_Develop", (tS32)0x9f0e4910L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::s32SetData(tS16 &tPANEL_Cold2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_Cold2NormalTemp_Develop,(tVoid*)&tPANEL_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::s32SetData(const tS16 &tPANEL_Cold2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_Cold2NormalTemp_Develop,(tVoid*)&tPANEL_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::u8GetData(tS16& tPANEL_Cold2NormalTemp_DevelopParam) {  
   vUpdate();
   tPANEL_Cold2NormalTemp_DevelopParam = tPANEL_Cold2NormalTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::vSetData(tS16 &tPANEL_Cold2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_Cold2NormalTemp_Develop,(tVoid*)&tPANEL_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::vSetData(const tS16 &tPANEL_Cold2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_Cold2NormalTemp_Develop,(tVoid*)&tPANEL_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_Cold2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_Cold2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_Cold2NormalTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_Cold2NormalTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_Cold2NormalTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_ColdTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_ColdTemp::dp_tclHeatCtrlDPPANEL_ColdTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_ColdTemp(-100)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_ColdTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("COLD_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_ColdTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_ColdTemp::u8GetData(tS16& tPANEL_ColdTempParam) {
   vUpdate();
   tPANEL_ColdTempParam = tPANEL_ColdTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_ColdTemp::tGetData() {
   vUpdate();
   return tPANEL_ColdTemp;
};

tU8 dp_tclHeatCtrlDPPANEL_ColdTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_ColdTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_ColdTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::dp_tclHeatCtrlDPPANEL_ColdTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_ColdTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_ColdTemp_Develop",(tS32) 0xd80f095d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_ColdTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_ColdTemp_Develop", (tS32)0xd80f095d);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_ColdTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::tGetData() {
   vUpdate();
   return tPANEL_ColdTemp_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::s32GetData(tS16& tPANEL_ColdTemp_DevelopParam) { 
   vUpdate();
   tPANEL_ColdTemp_DevelopParam = tPANEL_ColdTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_ColdTemp_Develop", (tS32)0xd80f095d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::s32SetData(tS16 &tPANEL_ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_ColdTemp_Develop,(tVoid*)&tPANEL_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::s32SetData(const tS16 &tPANEL_ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_ColdTemp_Develop,(tVoid*)&tPANEL_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::u8GetData(tS16& tPANEL_ColdTemp_DevelopParam) {  
   vUpdate();
   tPANEL_ColdTemp_DevelopParam = tPANEL_ColdTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::vSetData(tS16 &tPANEL_ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_ColdTemp_Develop,(tVoid*)&tPANEL_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::vSetData(const tS16 &tPANEL_ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_ColdTemp_Develop,(tVoid*)&tPANEL_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_ColdTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_ColdTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_ColdTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_Low2ColdTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_Low2ColdTemp::dp_tclHeatCtrlDPPANEL_Low2ColdTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_Low2ColdTemp(-200)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_Low2ColdTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("LOW2COLD_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_Low2ColdTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_Low2ColdTemp::u8GetData(tS16& tPANEL_Low2ColdTempParam) {
   vUpdate();
   tPANEL_Low2ColdTempParam = tPANEL_Low2ColdTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_Low2ColdTemp::tGetData() {
   vUpdate();
   return tPANEL_Low2ColdTemp;
};

tU8 dp_tclHeatCtrlDPPANEL_Low2ColdTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_Low2ColdTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_Low2ColdTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_Low2ColdTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_Low2ColdTemp_Develop",(tS32) 0x8e897065L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_Low2ColdTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_Low2ColdTemp_Develop", (tS32)0x8e897065L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_Low2ColdTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::tGetData() {
   vUpdate();
   return tPANEL_Low2ColdTemp_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::s32GetData(tS16& tPANEL_Low2ColdTemp_DevelopParam) { 
   vUpdate();
   tPANEL_Low2ColdTemp_DevelopParam = tPANEL_Low2ColdTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_Low2ColdTemp_Develop", (tS32)0x8e897065L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::s32SetData(tS16 &tPANEL_Low2ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_Low2ColdTemp_Develop,(tVoid*)&tPANEL_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::s32SetData(const tS16 &tPANEL_Low2ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_Low2ColdTemp_Develop,(tVoid*)&tPANEL_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::u8GetData(tS16& tPANEL_Low2ColdTemp_DevelopParam) {  
   vUpdate();
   tPANEL_Low2ColdTemp_DevelopParam = tPANEL_Low2ColdTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::vSetData(tS16 &tPANEL_Low2ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_Low2ColdTemp_Develop,(tVoid*)&tPANEL_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::vSetData(const tS16 &tPANEL_Low2ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_Low2ColdTemp_Develop,(tVoid*)&tPANEL_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_Low2ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_Low2ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_Low2ColdTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_Low2ColdTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_Low2ColdTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_LowTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_LowTemp::dp_tclHeatCtrlDPPANEL_LowTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_LowTemp(-200)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_LowTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("LOW_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_LowTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_LowTemp::u8GetData(tS16& tPANEL_LowTempParam) {
   vUpdate();
   tPANEL_LowTempParam = tPANEL_LowTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_LowTemp::tGetData() {
   vUpdate();
   return tPANEL_LowTemp;
};

tU8 dp_tclHeatCtrlDPPANEL_LowTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_LowTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_LowTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_LowTemp_Develop::dp_tclHeatCtrlDPPANEL_LowTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_LowTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_LowTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_LowTemp_Develop",(tS32) 0x3e7f16d1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_LowTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_LowTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_LowTemp_Develop", (tS32)0x3e7f16d1);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_LowTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_LowTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_LowTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_LowTemp_Develop::tGetData() {
   vUpdate();
   return tPANEL_LowTemp_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_LowTemp_Develop::s32GetData(tS16& tPANEL_LowTemp_DevelopParam) { 
   vUpdate();
   tPANEL_LowTemp_DevelopParam = tPANEL_LowTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_LowTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_LowTemp_Develop", (tS32)0x3e7f16d1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_LowTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_LowTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_LowTemp_Develop::s32SetData(tS16 &tPANEL_LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_LowTemp_Develop,(tVoid*)&tPANEL_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_LowTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_LowTemp_Develop::s32SetData(const tS16 &tPANEL_LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_LowTemp_Develop,(tVoid*)&tPANEL_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_LowTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_LowTemp_Develop::u8GetData(tS16& tPANEL_LowTemp_DevelopParam) {  
   vUpdate();
   tPANEL_LowTemp_DevelopParam = tPANEL_LowTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_LowTemp_Develop::vSetData(tS16 &tPANEL_LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_LowTemp_Develop,(tVoid*)&tPANEL_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_LowTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_LowTemp_Develop::vSetData(const tS16 &tPANEL_LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_LowTemp_Develop,(tVoid*)&tPANEL_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_LowTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_LowTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_LowTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_LowTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_LowTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_LowTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_LowTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_CriticalLow2LowTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp::dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_CriticalLow2LowTemp(-300)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CRITICALLOW2LOW_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_CriticalLow2LowTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp::u8GetData(tS16& tPANEL_CriticalLow2LowTempParam) {
   vUpdate();
   tPANEL_CriticalLow2LowTempParam = tPANEL_CriticalLow2LowTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp::tGetData() {
   vUpdate();
   return tPANEL_CriticalLow2LowTemp;
};

tU8 dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_CriticalLow2LowTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_CriticalLow2LowTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_CriticalLow2LowTemp_Develop",(tS32) 0x58828aa8L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_CriticalLow2LowTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_CriticalLow2LowTemp_Develop", (tS32)0x58828aa8L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_CriticalLow2LowTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::tGetData() {
   vUpdate();
   return tPANEL_CriticalLow2LowTemp_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::s32GetData(tS16& tPANEL_CriticalLow2LowTemp_DevelopParam) { 
   vUpdate();
   tPANEL_CriticalLow2LowTemp_DevelopParam = tPANEL_CriticalLow2LowTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_CriticalLow2LowTemp_Develop", (tS32)0x58828aa8L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::s32SetData(tS16 &tPANEL_CriticalLow2LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_CriticalLow2LowTemp_Develop,(tVoid*)&tPANEL_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::s32SetData(const tS16 &tPANEL_CriticalLow2LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_CriticalLow2LowTemp_Develop,(tVoid*)&tPANEL_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::u8GetData(tS16& tPANEL_CriticalLow2LowTemp_DevelopParam) {  
   vUpdate();
   tPANEL_CriticalLow2LowTemp_DevelopParam = tPANEL_CriticalLow2LowTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::vSetData(tS16 &tPANEL_CriticalLow2LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_CriticalLow2LowTemp_Develop,(tVoid*)&tPANEL_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::vSetData(const tS16 &tPANEL_CriticalLow2LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_CriticalLow2LowTemp_Develop,(tVoid*)&tPANEL_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_CriticalLow2LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_CriticalLow2LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_CriticalLow2LowTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_CriticalLow2LowTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_CriticalLow2LowTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_CriticalLowTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_CriticalLowTemp::dp_tclHeatCtrlDPPANEL_CriticalLowTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_CriticalLowTemp(-300)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_CriticalLowTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CRITICALLOW_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_CriticalLowTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_CriticalLowTemp::u8GetData(tS16& tPANEL_CriticalLowTempParam) {
   vUpdate();
   tPANEL_CriticalLowTempParam = tPANEL_CriticalLowTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_CriticalLowTemp::tGetData() {
   vUpdate();
   return tPANEL_CriticalLowTemp;
};

tU8 dp_tclHeatCtrlDPPANEL_CriticalLowTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_CriticalLowTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_CriticalLowTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_CriticalLowTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_CriticalLowTemp_Develop",(tS32) 0x477da9b0L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_CriticalLowTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_CriticalLowTemp_Develop", (tS32)0x477da9b0L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_CriticalLowTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::tGetData() {
   vUpdate();
   return tPANEL_CriticalLowTemp_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::s32GetData(tS16& tPANEL_CriticalLowTemp_DevelopParam) { 
   vUpdate();
   tPANEL_CriticalLowTemp_DevelopParam = tPANEL_CriticalLowTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_CriticalLowTemp_Develop", (tS32)0x477da9b0L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::s32SetData(tS16 &tPANEL_CriticalLowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_CriticalLowTemp_Develop,(tVoid*)&tPANEL_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::s32SetData(const tS16 &tPANEL_CriticalLowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_CriticalLowTemp_Develop,(tVoid*)&tPANEL_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::u8GetData(tS16& tPANEL_CriticalLowTemp_DevelopParam) {  
   vUpdate();
   tPANEL_CriticalLowTemp_DevelopParam = tPANEL_CriticalLowTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::vSetData(tS16 &tPANEL_CriticalLowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_CriticalLowTemp_Develop,(tVoid*)&tPANEL_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::vSetData(const tS16 &tPANEL_CriticalLowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_CriticalLowTemp_Develop,(tVoid*)&tPANEL_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_CriticalLowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_CriticalLowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_CriticalLowTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_CriticalLowTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_CriticalLowTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_ATTENUATION_CYCLETIME"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME::dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_ATTENUATION_CYCLETIME(60)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CYCLETIME_ATTENUATION",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_ATTENUATION_CYCLETIME = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME::u8GetData(tU8& tPANEL_ATTENUATION_CYCLETIMEParam) {
   vUpdate();
   tPANEL_ATTENUATION_CYCLETIMEParam = tPANEL_ATTENUATION_CYCLETIME;
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME::tGetData() {
   vUpdate();
   return tPANEL_ATTENUATION_CYCLETIME;
};

tU8 dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_ATTENUATION_CYCLETIME_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_ATTENUATION_CYCLETIME_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_ATTENUATION_CYCLETIME_Develop",(tS32) 0x3bf211bbL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPANEL_ATTENUATION_CYCLETIME_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_ATTENUATION_CYCLETIME_Develop", (tS32)0x3bf211bbL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_ATTENUATION_CYCLETIME_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::tGetData() {
   vUpdate();
   return tPANEL_ATTENUATION_CYCLETIME_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::s32GetData(tU8& tPANEL_ATTENUATION_CYCLETIME_DevelopParam) { 
   vUpdate();
   tPANEL_ATTENUATION_CYCLETIME_DevelopParam = tPANEL_ATTENUATION_CYCLETIME_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_ATTENUATION_CYCLETIME_Develop", (tS32)0x3bf211bbL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::s32SetData(tU8 &tPANEL_ATTENUATION_CYCLETIME_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tPANEL_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::s32SetData(const tU8 &tPANEL_ATTENUATION_CYCLETIME_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tPANEL_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::u8GetData(tU8& tPANEL_ATTENUATION_CYCLETIME_DevelopParam) {  
   vUpdate();
   tPANEL_ATTENUATION_CYCLETIME_DevelopParam = tPANEL_ATTENUATION_CYCLETIME_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::vSetData(tU8 &tPANEL_ATTENUATION_CYCLETIME_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tPANEL_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPANEL_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::vSetData(const tU8 &tPANEL_ATTENUATION_CYCLETIME_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tPANEL_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPANEL_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_ATTENUATION_CYCLETIME_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_ATTENUATION_CYCLETIME_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_ATTENUATION_CYCLETIME_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_ATTENUATION_CYCLETIME_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_ATTENUATION_CYCLETIME_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH::dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_000_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH::u8GetData(tS16& tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGHParam) {
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGHParam = tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH::tGetData() {
   vUpdate();
   return tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop",(tS32) 0xba1e1db5L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", (tS32)0xba1e1db5L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32GetData(tS16& tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam = tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", (tS32)0xba1e1db5L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32SetData(tS16 &tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32SetData(const tS16 &tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::u8GetData(tS16& tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam = tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16 &tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(const tS16 &tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH::dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_025_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH::u8GetData(tS16& tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGHParam) {
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGHParam = tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH::tGetData() {
   vUpdate();
   return tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop",(tS32) 0x673fd16cL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", (tS32)0x673fd16cL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32GetData(tS16& tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam = tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", (tS32)0x673fd16cL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32SetData(tS16 &tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32SetData(const tS16 &tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::u8GetData(tS16& tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam = tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16 &tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(const tS16 &tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH::dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_050_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH::u8GetData(tS16& tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGHParam) {
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGHParam = tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH::tGetData() {
   vUpdate();
   return tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop",(tS32) 0x3000f3e6L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", (tS32)0x3000f3e6L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32GetData(tS16& tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam = tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", (tS32)0x3000f3e6L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32SetData(tS16 &tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32SetData(const tS16 &tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::u8GetData(tS16& tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam = tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16 &tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(const tS16 &tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH::dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_075_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH::u8GetData(tS16& tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGHParam) {
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGHParam = tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH::tGetData() {
   vUpdate();
   return tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop",(tS32) 0xdd22a79dL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", (tS32)0xdd22a79dL);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32GetData(tS16& tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam = tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", (tS32)0xdd22a79dL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32SetData(tS16 &tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32SetData(const tS16 &tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::u8GetData(tS16& tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam = tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16 &tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(const tS16 &tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_MAX_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::u8GetData(tS16& tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGHParam) {
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGHParam = tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::tGetData() {
   vUpdate();
   return tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop",(tS32) 0x623e9037L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", (tS32)0x623e9037L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32GetData(tS16& tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam = tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", (tS32)0x623e9037L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32SetData(tS16 &tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32SetData(const tS16 &tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::u8GetData(tS16& tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam = tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16 &tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(const tS16 &tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_FAN_SYSTEM_SPEED_WARM_STATE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE::dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_FAN_SYSTEM_SPEED_WARM_STATE(0xFFFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_WARM_STATE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_FAN_SYSTEM_SPEED_WARM_STATE = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE::u8GetData(tU16& tPANEL_FAN_SYSTEM_SPEED_WARM_STATEParam) {
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_WARM_STATEParam = tPANEL_FAN_SYSTEM_SPEED_WARM_STATE;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE::tGetData() {
   vUpdate();
   return tPANEL_FAN_SYSTEM_SPEED_WARM_STATE;
};

tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop",(tS32) 0xd08ac040L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop", (tS32)0xd08ac040L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::tGetData() {
   vUpdate();
   return tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32GetData(tU16& tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) { 
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam = tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop", (tS32)0xd08ac040L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32SetData(tU16 &tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32SetData(const tU16 &tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::u8GetData(tU16& tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) {  
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam = tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16 &tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(const tU16 &tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_FAN_SYSTEM_SPEED_WARM_STATE_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_FAN_SYSTEM_SPEED_HIGH_STATE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE::dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE(0xFFFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/PANELSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_HIGH_STATE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE::u8GetData(tU16& tPANEL_FAN_SYSTEM_SPEED_HIGH_STATEParam) {
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_HIGH_STATEParam = tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE::tGetData() {
   vUpdate();
   return tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE;
};

tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop",(tS32) 0x3b380e21L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", (tS32)0x3b380e21L);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::tGetData() {
   vUpdate();
   return tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop;
};
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32GetData(tU16& tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) { 
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam = tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", (tS32)0x3b380e21L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32SetData(tU16 &tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32SetData(const tU16 &tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::u8GetData(tU16& tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) {  
   vUpdate();
   tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam = tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16 &tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(const tU16 &tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_FAN_SYSTEM_SPEED_HIGH_STATE_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_Statistics_MinTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::dp_tclHeatCtrlDPPANEL_Statistics_MinTemp(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_Statistics_MinTemp,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_Statistics_MinTemp",(tS32) 0x51516ff7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_Statistics_MinTemp = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_Statistics_MinTemp", (tS32)0x51516ff7);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_Statistics_MinTemp, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::tGetData() {
   vUpdate();
   return tPANEL_Statistics_MinTemp;
};
tS32 dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::s32GetData(tS16& tPANEL_Statistics_MinTempParam) { 
   vUpdate();
   tPANEL_Statistics_MinTempParam = tPANEL_Statistics_MinTemp;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_Statistics_MinTemp", (tS32)0x51516ff7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::s32SetData(tS16 &tPANEL_Statistics_MinTempParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_Statistics_MinTemp,(tVoid*)&tPANEL_Statistics_MinTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::s32SetData(const tS16 &tPANEL_Statistics_MinTempParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_Statistics_MinTemp,(tVoid*)&tPANEL_Statistics_MinTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::u8GetData(tS16& tPANEL_Statistics_MinTempParam) {  
   vUpdate();
   tPANEL_Statistics_MinTempParam = tPANEL_Statistics_MinTemp;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::vSetData(tS16 &tPANEL_Statistics_MinTempParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_Statistics_MinTemp,(tVoid*)&tPANEL_Statistics_MinTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::vSetData(const tS16 &tPANEL_Statistics_MinTempParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_Statistics_MinTemp,(tVoid*)&tPANEL_Statistics_MinTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_Statistics_MinTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_Statistics_MinTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_Statistics_MinTemp::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_Statistics_MinTemp", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_Statistics_MinTemp has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PANEL_Statistics_MaxTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPANEL_Statistics_MaxTemp,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PANEL_Statistics_MaxTemp",(tS32) 0x515126b9);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tPANEL_Statistics_MaxTemp = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PANEL_Statistics_MaxTemp", (tS32)0x515126b9);
   (tVoid)myDpElem.bFillData((tVoid*)&tPANEL_Statistics_MaxTemp, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::tGetData() {
   vUpdate();
   return tPANEL_Statistics_MaxTemp;
};
tS32 dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::s32GetData(tS16& tPANEL_Statistics_MaxTempParam) { 
   vUpdate();
   tPANEL_Statistics_MaxTempParam = tPANEL_Statistics_MaxTemp;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PANEL_Statistics_MaxTemp", (tS32)0x515126b9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::s32SetData(tS16 &tPANEL_Statistics_MaxTempParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_Statistics_MaxTemp,(tVoid*)&tPANEL_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::s32SetData(const tS16 &tPANEL_Statistics_MaxTempParam) {
   //init parameter
   (tVoid)memcpy(&tPANEL_Statistics_MaxTemp,(tVoid*)&tPANEL_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPANEL_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::u8GetData(tS16& tPANEL_Statistics_MaxTempParam) {  
   vUpdate();
   tPANEL_Statistics_MaxTempParam = tPANEL_Statistics_MaxTemp;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::vSetData(tS16 &tPANEL_Statistics_MaxTempParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_Statistics_MaxTemp,(tVoid*)&tPANEL_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::vSetData(const tS16 &tPANEL_Statistics_MaxTempParam) { 
   //init parameter
   (tVoid)memcpy(&tPANEL_Statistics_MaxTemp,(tVoid*)&tPANEL_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tPANEL_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_Statistics_MaxTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "PANEL_Statistics_MaxTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPPANEL_Statistics_MaxTemp::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PANEL_Statistics_MaxTemp", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element PANEL_Statistics_MaxTemp has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_AVAIL"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_AVAIL::dp_tclHeatCtrlDPCD_AVAIL() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_AVAIL(TRUE)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_AVAIL::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("AVAIL",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_AVAIL = (tBool)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_AVAIL::u8GetData(tBool& tCD_AVAILParam) {
   vUpdate();
   tCD_AVAILParam = tCD_AVAIL;
   return _u8DataStatus;
}
tBool dp_tclHeatCtrlDPCD_AVAIL::tGetData() {
   vUpdate();
   return tCD_AVAIL;
};

tU8 dp_tclHeatCtrlDPCD_AVAIL::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_AVAIL::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_AVAIL_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_AVAIL_Develop::dp_tclHeatCtrlDPCD_AVAIL_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_AVAIL_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_AVAIL_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_AVAIL_Develop",(tS32) 0x8f817a45);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCD_AVAIL_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_AVAIL_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_AVAIL_Develop", (tS32)0x8f817a45);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_AVAIL_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_AVAIL_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_AVAIL_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPCD_AVAIL_Develop::tGetData() {
   vUpdate();
   return tCD_AVAIL_Develop;
};
tS32 dp_tclHeatCtrlDPCD_AVAIL_Develop::s32GetData(tU8& tCD_AVAIL_DevelopParam) { 
   vUpdate();
   tCD_AVAIL_DevelopParam = tCD_AVAIL_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_AVAIL_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_AVAIL_Develop", (tS32)0x8f817a45);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_AVAIL_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_AVAIL_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_AVAIL_Develop::s32SetData(tU8 &tCD_AVAIL_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_AVAIL_Develop,(tVoid*)&tCD_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPCD_AVAIL_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_AVAIL_Develop::s32SetData(const tU8 &tCD_AVAIL_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_AVAIL_Develop,(tVoid*)&tCD_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPCD_AVAIL_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_AVAIL_Develop::u8GetData(tU8& tCD_AVAIL_DevelopParam) {  
   vUpdate();
   tCD_AVAIL_DevelopParam = tCD_AVAIL_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_AVAIL_Develop::vSetData(tU8 &tCD_AVAIL_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_AVAIL_Develop,(tVoid*)&tCD_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCD_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPCD_AVAIL_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_AVAIL_Develop::vSetData(const tU8 &tCD_AVAIL_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_AVAIL_Develop,(tVoid*)&tCD_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCD_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPCD_AVAIL_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_AVAIL_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_AVAIL_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_AVAIL_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_AVAIL_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_AVAIL_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_AVAIL_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_AVAIL_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_AVAIL_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_MinTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_MinTemp::dp_tclHeatCtrlDPCD_MinTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_MinTemp(-400)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_MinTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MIN_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_MinTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_MinTemp::u8GetData(tS16& tCD_MinTempParam) {
   vUpdate();
   tCD_MinTempParam = tCD_MinTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_MinTemp::tGetData() {
   vUpdate();
   return tCD_MinTemp;
};

tU8 dp_tclHeatCtrlDPCD_MinTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_MinTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_MaxTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_MaxTemp::dp_tclHeatCtrlDPCD_MaxTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_MaxTemp(910)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_MaxTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MAX_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_MaxTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_MaxTemp::u8GetData(tS16& tCD_MaxTempParam) {
   vUpdate();
   tCD_MaxTempParam = tCD_MaxTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_MaxTemp::tGetData() {
   vUpdate();
   return tCD_MaxTemp;
};

tU8 dp_tclHeatCtrlDPCD_MaxTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_MaxTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_EmergencyHighTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_EmergencyHighTemp::dp_tclHeatCtrlDPCD_EmergencyHighTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_EmergencyHighTemp(900)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_EmergencyHighTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("EMERGHIGH_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_EmergencyHighTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_EmergencyHighTemp::u8GetData(tS16& tCD_EmergencyHighTempParam) {
   vUpdate();
   tCD_EmergencyHighTempParam = tCD_EmergencyHighTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_EmergencyHighTemp::tGetData() {
   vUpdate();
   return tCD_EmergencyHighTemp;
};

tU8 dp_tclHeatCtrlDPCD_EmergencyHighTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_EmergencyHighTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_EmergencyHighTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_EmergencyHighTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_EmergencyHighTemp_Develop",(tS32) 0xba8e56edL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_EmergencyHighTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_EmergencyHighTemp_Develop", (tS32)0xba8e56edL);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_EmergencyHighTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::tGetData() {
   vUpdate();
   return tCD_EmergencyHighTemp_Develop;
};
tS32 dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::s32GetData(tS16& tCD_EmergencyHighTemp_DevelopParam) { 
   vUpdate();
   tCD_EmergencyHighTemp_DevelopParam = tCD_EmergencyHighTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_EmergencyHighTemp_Develop", (tS32)0xba8e56edL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::s32SetData(tS16 &tCD_EmergencyHighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_EmergencyHighTemp_Develop,(tVoid*)&tCD_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::s32SetData(const tS16 &tCD_EmergencyHighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_EmergencyHighTemp_Develop,(tVoid*)&tCD_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::u8GetData(tS16& tCD_EmergencyHighTemp_DevelopParam) {  
   vUpdate();
   tCD_EmergencyHighTemp_DevelopParam = tCD_EmergencyHighTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::vSetData(tS16 &tCD_EmergencyHighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_EmergencyHighTemp_Develop,(tVoid*)&tCD_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::vSetData(const tS16 &tCD_EmergencyHighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_EmergencyHighTemp_Develop,(tVoid*)&tCD_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_EmergencyHighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_EmergencyHighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_EmergencyHighTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_EmergencyHighTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_EmergencyHighTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_EmergencyHigh2HighTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp::dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_EmergencyHigh2HighTemp(900)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("EMERGHIGH2HIGH_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_EmergencyHigh2HighTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp::u8GetData(tS16& tCD_EmergencyHigh2HighTempParam) {
   vUpdate();
   tCD_EmergencyHigh2HighTempParam = tCD_EmergencyHigh2HighTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp::tGetData() {
   vUpdate();
   return tCD_EmergencyHigh2HighTemp;
};

tU8 dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_EmergencyHigh2HighTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_EmergencyHigh2HighTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_EmergencyHigh2HighTemp_Develop",(tS32) 0xc344d1d7L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_EmergencyHigh2HighTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_EmergencyHigh2HighTemp_Develop", (tS32)0xc344d1d7L);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_EmergencyHigh2HighTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::tGetData() {
   vUpdate();
   return tCD_EmergencyHigh2HighTemp_Develop;
};
tS32 dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::s32GetData(tS16& tCD_EmergencyHigh2HighTemp_DevelopParam) { 
   vUpdate();
   tCD_EmergencyHigh2HighTemp_DevelopParam = tCD_EmergencyHigh2HighTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_EmergencyHigh2HighTemp_Develop", (tS32)0xc344d1d7L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::s32SetData(tS16 &tCD_EmergencyHigh2HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_EmergencyHigh2HighTemp_Develop,(tVoid*)&tCD_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::s32SetData(const tS16 &tCD_EmergencyHigh2HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_EmergencyHigh2HighTemp_Develop,(tVoid*)&tCD_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::u8GetData(tS16& tCD_EmergencyHigh2HighTemp_DevelopParam) {  
   vUpdate();
   tCD_EmergencyHigh2HighTemp_DevelopParam = tCD_EmergencyHigh2HighTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::vSetData(tS16 &tCD_EmergencyHigh2HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_EmergencyHigh2HighTemp_Develop,(tVoid*)&tCD_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::vSetData(const tS16 &tCD_EmergencyHigh2HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_EmergencyHigh2HighTemp_Develop,(tVoid*)&tCD_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_EmergencyHigh2HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_EmergencyHigh2HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_EmergencyHigh2HighTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_EmergencyHigh2HighTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_EmergencyHigh2HighTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_HighTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_HighTemp::dp_tclHeatCtrlDPCD_HighTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_HighTemp(800)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_HighTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("HIGH_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_HighTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_HighTemp::u8GetData(tS16& tCD_HighTempParam) {
   vUpdate();
   tCD_HighTempParam = tCD_HighTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_HighTemp::tGetData() {
   vUpdate();
   return tCD_HighTemp;
};

tU8 dp_tclHeatCtrlDPCD_HighTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_HighTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_HighTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_HighTemp_Develop::dp_tclHeatCtrlDPCD_HighTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_HighTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_HighTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_HighTemp_Develop",(tS32) 0x7ef23b92);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_HighTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_HighTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_HighTemp_Develop", (tS32)0x7ef23b92);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_HighTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_HighTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_HighTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_HighTemp_Develop::tGetData() {
   vUpdate();
   return tCD_HighTemp_Develop;
};
tS32 dp_tclHeatCtrlDPCD_HighTemp_Develop::s32GetData(tS16& tCD_HighTemp_DevelopParam) { 
   vUpdate();
   tCD_HighTemp_DevelopParam = tCD_HighTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_HighTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_HighTemp_Develop", (tS32)0x7ef23b92);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_HighTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_HighTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_HighTemp_Develop::s32SetData(tS16 &tCD_HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_HighTemp_Develop,(tVoid*)&tCD_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_HighTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_HighTemp_Develop::s32SetData(const tS16 &tCD_HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_HighTemp_Develop,(tVoid*)&tCD_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_HighTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_HighTemp_Develop::u8GetData(tS16& tCD_HighTemp_DevelopParam) {  
   vUpdate();
   tCD_HighTemp_DevelopParam = tCD_HighTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_HighTemp_Develop::vSetData(tS16 &tCD_HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_HighTemp_Develop,(tVoid*)&tCD_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_HighTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_HighTemp_Develop::vSetData(const tS16 &tCD_HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_HighTemp_Develop,(tVoid*)&tCD_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_HighTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_HighTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_HighTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_HighTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_HighTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_HighTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_HighTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_High2WarmTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_High2WarmTemp::dp_tclHeatCtrlDPCD_High2WarmTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_High2WarmTemp(800)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_High2WarmTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("HIGH2WARM_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_High2WarmTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_High2WarmTemp::u8GetData(tS16& tCD_High2WarmTempParam) {
   vUpdate();
   tCD_High2WarmTempParam = tCD_High2WarmTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_High2WarmTemp::tGetData() {
   vUpdate();
   return tCD_High2WarmTemp;
};

tU8 dp_tclHeatCtrlDPCD_High2WarmTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_High2WarmTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_High2WarmTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::dp_tclHeatCtrlDPCD_High2WarmTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_High2WarmTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_High2WarmTemp_Develop",(tS32) 0xba3d8ef7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_High2WarmTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_High2WarmTemp_Develop", (tS32)0xba3d8ef7);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_High2WarmTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::tGetData() {
   vUpdate();
   return tCD_High2WarmTemp_Develop;
};
tS32 dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::s32GetData(tS16& tCD_High2WarmTemp_DevelopParam) { 
   vUpdate();
   tCD_High2WarmTemp_DevelopParam = tCD_High2WarmTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_High2WarmTemp_Develop", (tS32)0xba3d8ef7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::s32SetData(tS16 &tCD_High2WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_High2WarmTemp_Develop,(tVoid*)&tCD_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::s32SetData(const tS16 &tCD_High2WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_High2WarmTemp_Develop,(tVoid*)&tCD_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::u8GetData(tS16& tCD_High2WarmTemp_DevelopParam) {  
   vUpdate();
   tCD_High2WarmTemp_DevelopParam = tCD_High2WarmTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::vSetData(tS16 &tCD_High2WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_High2WarmTemp_Develop,(tVoid*)&tCD_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::vSetData(const tS16 &tCD_High2WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_High2WarmTemp_Develop,(tVoid*)&tCD_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_High2WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_High2WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_High2WarmTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_High2WarmTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_High2WarmTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_WarmTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_WarmTemp::dp_tclHeatCtrlDPCD_WarmTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_WarmTemp(600)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_WarmTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("WARM_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_WarmTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_WarmTemp::u8GetData(tS16& tCD_WarmTempParam) {
   vUpdate();
   tCD_WarmTempParam = tCD_WarmTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_WarmTemp::tGetData() {
   vUpdate();
   return tCD_WarmTemp;
};

tU8 dp_tclHeatCtrlDPCD_WarmTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_WarmTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_WarmTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_WarmTemp_Develop::dp_tclHeatCtrlDPCD_WarmTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_WarmTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_WarmTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_WarmTemp_Develop",(tS32) 0x1e84e689);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_WarmTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_WarmTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_WarmTemp_Develop", (tS32)0x1e84e689);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_WarmTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_WarmTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_WarmTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_WarmTemp_Develop::tGetData() {
   vUpdate();
   return tCD_WarmTemp_Develop;
};
tS32 dp_tclHeatCtrlDPCD_WarmTemp_Develop::s32GetData(tS16& tCD_WarmTemp_DevelopParam) { 
   vUpdate();
   tCD_WarmTemp_DevelopParam = tCD_WarmTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_WarmTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_WarmTemp_Develop", (tS32)0x1e84e689);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_WarmTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_WarmTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_WarmTemp_Develop::s32SetData(tS16 &tCD_WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_WarmTemp_Develop,(tVoid*)&tCD_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_WarmTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_WarmTemp_Develop::s32SetData(const tS16 &tCD_WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_WarmTemp_Develop,(tVoid*)&tCD_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_WarmTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_WarmTemp_Develop::u8GetData(tS16& tCD_WarmTemp_DevelopParam) {  
   vUpdate();
   tCD_WarmTemp_DevelopParam = tCD_WarmTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_WarmTemp_Develop::vSetData(tS16 &tCD_WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_WarmTemp_Develop,(tVoid*)&tCD_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_WarmTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_WarmTemp_Develop::vSetData(const tS16 &tCD_WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_WarmTemp_Develop,(tVoid*)&tCD_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_WarmTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_WarmTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_WarmTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_WarmTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_WarmTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_WarmTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_WarmTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_Warm2NormalTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_Warm2NormalTemp::dp_tclHeatCtrlDPCD_Warm2NormalTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_Warm2NormalTemp(600)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_Warm2NormalTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("WARM2NORMAL_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_Warm2NormalTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_Warm2NormalTemp::u8GetData(tS16& tCD_Warm2NormalTempParam) {
   vUpdate();
   tCD_Warm2NormalTempParam = tCD_Warm2NormalTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_Warm2NormalTemp::tGetData() {
   vUpdate();
   return tCD_Warm2NormalTemp;
};

tU8 dp_tclHeatCtrlDPCD_Warm2NormalTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_Warm2NormalTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_Warm2NormalTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_Warm2NormalTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_Warm2NormalTemp_Develop",(tS32) 0x6e4795ccL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_Warm2NormalTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_Warm2NormalTemp_Develop", (tS32)0x6e4795ccL);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_Warm2NormalTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::tGetData() {
   vUpdate();
   return tCD_Warm2NormalTemp_Develop;
};
tS32 dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::s32GetData(tS16& tCD_Warm2NormalTemp_DevelopParam) { 
   vUpdate();
   tCD_Warm2NormalTemp_DevelopParam = tCD_Warm2NormalTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_Warm2NormalTemp_Develop", (tS32)0x6e4795ccL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::s32SetData(tS16 &tCD_Warm2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_Warm2NormalTemp_Develop,(tVoid*)&tCD_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::s32SetData(const tS16 &tCD_Warm2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_Warm2NormalTemp_Develop,(tVoid*)&tCD_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::u8GetData(tS16& tCD_Warm2NormalTemp_DevelopParam) {  
   vUpdate();
   tCD_Warm2NormalTemp_DevelopParam = tCD_Warm2NormalTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::vSetData(tS16 &tCD_Warm2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_Warm2NormalTemp_Develop,(tVoid*)&tCD_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::vSetData(const tS16 &tCD_Warm2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_Warm2NormalTemp_Develop,(tVoid*)&tCD_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_Warm2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_Warm2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_Warm2NormalTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_Warm2NormalTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_Warm2NormalTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_Cold2NormalTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_Cold2NormalTemp::dp_tclHeatCtrlDPCD_Cold2NormalTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_Cold2NormalTemp(-100)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_Cold2NormalTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("COLD2NORMAL_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_Cold2NormalTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_Cold2NormalTemp::u8GetData(tS16& tCD_Cold2NormalTempParam) {
   vUpdate();
   tCD_Cold2NormalTempParam = tCD_Cold2NormalTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_Cold2NormalTemp::tGetData() {
   vUpdate();
   return tCD_Cold2NormalTemp;
};

tU8 dp_tclHeatCtrlDPCD_Cold2NormalTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_Cold2NormalTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_Cold2NormalTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_Cold2NormalTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_Cold2NormalTemp_Develop",(tS32) 0xa08daf33L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_Cold2NormalTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_Cold2NormalTemp_Develop", (tS32)0xa08daf33L);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_Cold2NormalTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::tGetData() {
   vUpdate();
   return tCD_Cold2NormalTemp_Develop;
};
tS32 dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::s32GetData(tS16& tCD_Cold2NormalTemp_DevelopParam) { 
   vUpdate();
   tCD_Cold2NormalTemp_DevelopParam = tCD_Cold2NormalTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_Cold2NormalTemp_Develop", (tS32)0xa08daf33L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::s32SetData(tS16 &tCD_Cold2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_Cold2NormalTemp_Develop,(tVoid*)&tCD_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::s32SetData(const tS16 &tCD_Cold2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_Cold2NormalTemp_Develop,(tVoid*)&tCD_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::u8GetData(tS16& tCD_Cold2NormalTemp_DevelopParam) {  
   vUpdate();
   tCD_Cold2NormalTemp_DevelopParam = tCD_Cold2NormalTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::vSetData(tS16 &tCD_Cold2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_Cold2NormalTemp_Develop,(tVoid*)&tCD_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::vSetData(const tS16 &tCD_Cold2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_Cold2NormalTemp_Develop,(tVoid*)&tCD_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_Cold2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_Cold2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_Cold2NormalTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_Cold2NormalTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_Cold2NormalTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_ColdTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_ColdTemp::dp_tclHeatCtrlDPCD_ColdTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_ColdTemp(-100)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_ColdTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("COLD_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_ColdTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_ColdTemp::u8GetData(tS16& tCD_ColdTempParam) {
   vUpdate();
   tCD_ColdTempParam = tCD_ColdTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_ColdTemp::tGetData() {
   vUpdate();
   return tCD_ColdTemp;
};

tU8 dp_tclHeatCtrlDPCD_ColdTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_ColdTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_ColdTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_ColdTemp_Develop::dp_tclHeatCtrlDPCD_ColdTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_ColdTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_ColdTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_ColdTemp_Develop",(tS32) 0xb0606fec);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_ColdTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_ColdTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_ColdTemp_Develop", (tS32)0xb0606fec);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_ColdTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_ColdTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_ColdTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_ColdTemp_Develop::tGetData() {
   vUpdate();
   return tCD_ColdTemp_Develop;
};
tS32 dp_tclHeatCtrlDPCD_ColdTemp_Develop::s32GetData(tS16& tCD_ColdTemp_DevelopParam) { 
   vUpdate();
   tCD_ColdTemp_DevelopParam = tCD_ColdTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_ColdTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_ColdTemp_Develop", (tS32)0xb0606fec);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_ColdTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_ColdTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_ColdTemp_Develop::s32SetData(tS16 &tCD_ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_ColdTemp_Develop,(tVoid*)&tCD_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_ColdTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_ColdTemp_Develop::s32SetData(const tS16 &tCD_ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_ColdTemp_Develop,(tVoid*)&tCD_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_ColdTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_ColdTemp_Develop::u8GetData(tS16& tCD_ColdTemp_DevelopParam) {  
   vUpdate();
   tCD_ColdTemp_DevelopParam = tCD_ColdTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_ColdTemp_Develop::vSetData(tS16 &tCD_ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_ColdTemp_Develop,(tVoid*)&tCD_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_ColdTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_ColdTemp_Develop::vSetData(const tS16 &tCD_ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_ColdTemp_Develop,(tVoid*)&tCD_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_ColdTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_ColdTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_ColdTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_ColdTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_ColdTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_ColdTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_ColdTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_Low2ColdTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_Low2ColdTemp::dp_tclHeatCtrlDPCD_Low2ColdTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_Low2ColdTemp(-200)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_Low2ColdTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("LOW2COLD_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_Low2ColdTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_Low2ColdTemp::u8GetData(tS16& tCD_Low2ColdTempParam) {
   vUpdate();
   tCD_Low2ColdTempParam = tCD_Low2ColdTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_Low2ColdTemp::tGetData() {
   vUpdate();
   return tCD_Low2ColdTemp;
};

tU8 dp_tclHeatCtrlDPCD_Low2ColdTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_Low2ColdTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_Low2ColdTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_Low2ColdTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_Low2ColdTemp_Develop",(tS32) 0xad44d384);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_Low2ColdTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_Low2ColdTemp_Develop", (tS32)0xad44d384);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_Low2ColdTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::tGetData() {
   vUpdate();
   return tCD_Low2ColdTemp_Develop;
};
tS32 dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::s32GetData(tS16& tCD_Low2ColdTemp_DevelopParam) { 
   vUpdate();
   tCD_Low2ColdTemp_DevelopParam = tCD_Low2ColdTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_Low2ColdTemp_Develop", (tS32)0xad44d384);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::s32SetData(tS16 &tCD_Low2ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_Low2ColdTemp_Develop,(tVoid*)&tCD_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::s32SetData(const tS16 &tCD_Low2ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_Low2ColdTemp_Develop,(tVoid*)&tCD_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::u8GetData(tS16& tCD_Low2ColdTemp_DevelopParam) {  
   vUpdate();
   tCD_Low2ColdTemp_DevelopParam = tCD_Low2ColdTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::vSetData(tS16 &tCD_Low2ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_Low2ColdTemp_Develop,(tVoid*)&tCD_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::vSetData(const tS16 &tCD_Low2ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_Low2ColdTemp_Develop,(tVoid*)&tCD_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_Low2ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_Low2ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_Low2ColdTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_Low2ColdTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_Low2ColdTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_LowTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_LowTemp::dp_tclHeatCtrlDPCD_LowTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_LowTemp(-200)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_LowTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("LOW_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_LowTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_LowTemp::u8GetData(tS16& tCD_LowTempParam) {
   vUpdate();
   tCD_LowTempParam = tCD_LowTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_LowTemp::tGetData() {
   vUpdate();
   return tCD_LowTemp;
};

tU8 dp_tclHeatCtrlDPCD_LowTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_LowTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_LowTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_LowTemp_Develop::dp_tclHeatCtrlDPCD_LowTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_LowTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_LowTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_LowTemp_Develop",(tS32) 0x35c2b54);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_LowTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_LowTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_LowTemp_Develop", (tS32)0x35c2b54);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_LowTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_LowTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_LowTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_LowTemp_Develop::tGetData() {
   vUpdate();
   return tCD_LowTemp_Develop;
};
tS32 dp_tclHeatCtrlDPCD_LowTemp_Develop::s32GetData(tS16& tCD_LowTemp_DevelopParam) { 
   vUpdate();
   tCD_LowTemp_DevelopParam = tCD_LowTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_LowTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_LowTemp_Develop", (tS32)0x35c2b54);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_LowTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_LowTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_LowTemp_Develop::s32SetData(tS16 &tCD_LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_LowTemp_Develop,(tVoid*)&tCD_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_LowTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_LowTemp_Develop::s32SetData(const tS16 &tCD_LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_LowTemp_Develop,(tVoid*)&tCD_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_LowTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_LowTemp_Develop::u8GetData(tS16& tCD_LowTemp_DevelopParam) {  
   vUpdate();
   tCD_LowTemp_DevelopParam = tCD_LowTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_LowTemp_Develop::vSetData(tS16 &tCD_LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_LowTemp_Develop,(tVoid*)&tCD_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_LowTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_LowTemp_Develop::vSetData(const tS16 &tCD_LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_LowTemp_Develop,(tVoid*)&tCD_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_LowTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_LowTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_LowTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_LowTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_LowTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_LowTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_LowTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_CriticalLow2LowTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_CriticalLow2LowTemp::dp_tclHeatCtrlDPCD_CriticalLow2LowTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_CriticalLow2LowTemp(-300)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_CriticalLow2LowTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CRITICALLOW2LOW_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_CriticalLow2LowTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_CriticalLow2LowTemp::u8GetData(tS16& tCD_CriticalLow2LowTempParam) {
   vUpdate();
   tCD_CriticalLow2LowTempParam = tCD_CriticalLow2LowTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_CriticalLow2LowTemp::tGetData() {
   vUpdate();
   return tCD_CriticalLow2LowTemp;
};

tU8 dp_tclHeatCtrlDPCD_CriticalLow2LowTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_CriticalLow2LowTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_CriticalLow2LowTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_CriticalLow2LowTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_CriticalLow2LowTemp_Develop",(tS32) 0x8ae61bL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_CriticalLow2LowTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_CriticalLow2LowTemp_Develop", (tS32)0x8ae61bL);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_CriticalLow2LowTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::tGetData() {
   vUpdate();
   return tCD_CriticalLow2LowTemp_Develop;
};
tS32 dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::s32GetData(tS16& tCD_CriticalLow2LowTemp_DevelopParam) { 
   vUpdate();
   tCD_CriticalLow2LowTemp_DevelopParam = tCD_CriticalLow2LowTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_CriticalLow2LowTemp_Develop", (tS32)0x8ae61bL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::s32SetData(tS16 &tCD_CriticalLow2LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_CriticalLow2LowTemp_Develop,(tVoid*)&tCD_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::s32SetData(const tS16 &tCD_CriticalLow2LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_CriticalLow2LowTemp_Develop,(tVoid*)&tCD_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::u8GetData(tS16& tCD_CriticalLow2LowTemp_DevelopParam) {  
   vUpdate();
   tCD_CriticalLow2LowTemp_DevelopParam = tCD_CriticalLow2LowTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::vSetData(tS16 &tCD_CriticalLow2LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_CriticalLow2LowTemp_Develop,(tVoid*)&tCD_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::vSetData(const tS16 &tCD_CriticalLow2LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_CriticalLow2LowTemp_Develop,(tVoid*)&tCD_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_CriticalLow2LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_CriticalLow2LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_CriticalLow2LowTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_CriticalLow2LowTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_CriticalLow2LowTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_CriticalLowTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_CriticalLowTemp::dp_tclHeatCtrlDPCD_CriticalLowTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_CriticalLowTemp(-300)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_CriticalLowTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CRITICALLOW_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_CriticalLowTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_CriticalLowTemp::u8GetData(tS16& tCD_CriticalLowTempParam) {
   vUpdate();
   tCD_CriticalLowTempParam = tCD_CriticalLowTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_CriticalLowTemp::tGetData() {
   vUpdate();
   return tCD_CriticalLowTemp;
};

tU8 dp_tclHeatCtrlDPCD_CriticalLowTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_CriticalLowTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_CriticalLowTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_CriticalLowTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_CriticalLowTemp_Develop",(tS32) 0x48fd0fd3L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_CriticalLowTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_CriticalLowTemp_Develop", (tS32)0x48fd0fd3L);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_CriticalLowTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::tGetData() {
   vUpdate();
   return tCD_CriticalLowTemp_Develop;
};
tS32 dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::s32GetData(tS16& tCD_CriticalLowTemp_DevelopParam) { 
   vUpdate();
   tCD_CriticalLowTemp_DevelopParam = tCD_CriticalLowTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_CriticalLowTemp_Develop", (tS32)0x48fd0fd3L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::s32SetData(tS16 &tCD_CriticalLowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_CriticalLowTemp_Develop,(tVoid*)&tCD_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::s32SetData(const tS16 &tCD_CriticalLowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_CriticalLowTemp_Develop,(tVoid*)&tCD_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::u8GetData(tS16& tCD_CriticalLowTemp_DevelopParam) {  
   vUpdate();
   tCD_CriticalLowTemp_DevelopParam = tCD_CriticalLowTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::vSetData(tS16 &tCD_CriticalLowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_CriticalLowTemp_Develop,(tVoid*)&tCD_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::vSetData(const tS16 &tCD_CriticalLowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_CriticalLowTemp_Develop,(tVoid*)&tCD_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_CriticalLowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_CriticalLowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_CriticalLowTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_CriticalLowTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_CriticalLowTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_ATTENUATION_CYCLETIME"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME::dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_ATTENUATION_CYCLETIME(60)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CYCLETIME_ATTENUATION",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_ATTENUATION_CYCLETIME = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME::u8GetData(tU8& tCD_ATTENUATION_CYCLETIMEParam) {
   vUpdate();
   tCD_ATTENUATION_CYCLETIMEParam = tCD_ATTENUATION_CYCLETIME;
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME::tGetData() {
   vUpdate();
   return tCD_ATTENUATION_CYCLETIME;
};

tU8 dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_ATTENUATION_CYCLETIME_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_ATTENUATION_CYCLETIME_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_ATTENUATION_CYCLETIME_Develop",(tS32) 0xa4c2fff6L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCD_ATTENUATION_CYCLETIME_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_ATTENUATION_CYCLETIME_Develop", (tS32)0xa4c2fff6L);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_ATTENUATION_CYCLETIME_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::tGetData() {
   vUpdate();
   return tCD_ATTENUATION_CYCLETIME_Develop;
};
tS32 dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::s32GetData(tU8& tCD_ATTENUATION_CYCLETIME_DevelopParam) { 
   vUpdate();
   tCD_ATTENUATION_CYCLETIME_DevelopParam = tCD_ATTENUATION_CYCLETIME_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_ATTENUATION_CYCLETIME_Develop", (tS32)0xa4c2fff6L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::s32SetData(tU8 &tCD_ATTENUATION_CYCLETIME_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tCD_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::s32SetData(const tU8 &tCD_ATTENUATION_CYCLETIME_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tCD_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::u8GetData(tU8& tCD_ATTENUATION_CYCLETIME_DevelopParam) {  
   vUpdate();
   tCD_ATTENUATION_CYCLETIME_DevelopParam = tCD_ATTENUATION_CYCLETIME_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::vSetData(tU8 &tCD_ATTENUATION_CYCLETIME_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tCD_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCD_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::vSetData(const tU8 &tCD_ATTENUATION_CYCLETIME_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tCD_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCD_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_ATTENUATION_CYCLETIME_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_ATTENUATION_CYCLETIME_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_ATTENUATION_CYCLETIME_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_ATTENUATION_CYCLETIME_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_ATTENUATION_CYCLETIME_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_FAN_SYSTEM_SPEED_000_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH::dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_000_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH::u8GetData(tS16& tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGHParam) {
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGHParam = tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH::tGetData() {
   vUpdate();
   return tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop",(tS32) 0x600059fcL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", (tS32)0x600059fcL);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32GetData(tS16& tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam = tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", (tS32)0x600059fcL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32SetData(tS16 &tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32SetData(const tS16 &tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::u8GetData(tS16& tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam = tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16 &tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(const tS16 &tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_FAN_SYSTEM_SPEED_025_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH::dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_025_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH::u8GetData(tS16& tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGHParam) {
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGHParam = tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH::tGetData() {
   vUpdate();
   return tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop",(tS32) 0xd220db3L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", (tS32)0xd220db3L);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32GetData(tS16& tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam = tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", (tS32)0xd220db3L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32SetData(tS16 &tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32SetData(const tS16 &tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::u8GetData(tS16& tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam = tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16 &tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(const tS16 &tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_FAN_SYSTEM_SPEED_050_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH::dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_050_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH::u8GetData(tS16& tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGHParam) {
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGHParam = tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH::tGetData() {
   vUpdate();
   return tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop",(tS32) 0xd5e3302dL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", (tS32)0xd5e3302dL);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32GetData(tS16& tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam = tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", (tS32)0xd5e3302dL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32SetData(tS16 &tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32SetData(const tS16 &tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::u8GetData(tS16& tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam = tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16 &tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(const tS16 &tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_FAN_SYSTEM_SPEED_075_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH::dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_075_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH::u8GetData(tS16& tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGHParam) {
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGHParam = tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH::tGetData() {
   vUpdate();
   return tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop",(tS32) 0x8304e3e4L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", (tS32)0x8304e3e4L);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32GetData(tS16& tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam = tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", (tS32)0x8304e3e4L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32SetData(tS16 &tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32SetData(const tS16 &tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::u8GetData(tS16& tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam = tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16 &tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(const tS16 &tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_MAX_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::u8GetData(tS16& tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGHParam) {
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGHParam = tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::tGetData() {
   vUpdate();
   return tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop",(tS32) 0x820cc7eL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", (tS32)0x820cc7eL);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32GetData(tS16& tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam = tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", (tS32)0x820cc7eL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32SetData(tS16 &tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32SetData(const tS16 &tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::u8GetData(tS16& tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam = tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16 &tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(const tS16 &tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_FAN_SYSTEM_SPEED_WARM_STATE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE::dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_FAN_SYSTEM_SPEED_WARM_STATE(0xFFFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_WARM_STATE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_FAN_SYSTEM_SPEED_WARM_STATE = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE::u8GetData(tU16& tCD_FAN_SYSTEM_SPEED_WARM_STATEParam) {
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_WARM_STATEParam = tCD_FAN_SYSTEM_SPEED_WARM_STATE;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE::tGetData() {
   vUpdate();
   return tCD_FAN_SYSTEM_SPEED_WARM_STATE;
};

tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_FAN_SYSTEM_SPEED_WARM_STATE_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_WARM_STATE_Develop",(tS32) 0x48a72f53L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_WARM_STATE_Develop", (tS32)0x48a72f53L);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::tGetData() {
   vUpdate();
   return tCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop;
};
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32GetData(tU16& tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) { 
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam = tCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_WARM_STATE_Develop", (tS32)0x48a72f53L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32SetData(tU16 &tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32SetData(const tU16 &tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::u8GetData(tU16& tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) {  
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam = tCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16 &tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(const tU16 &tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_FAN_SYSTEM_SPEED_WARM_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_FAN_SYSTEM_SPEED_WARM_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_FAN_SYSTEM_SPEED_WARM_STATE_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_FAN_SYSTEM_SPEED_WARM_STATE_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_FAN_SYSTEM_SPEED_HIGH_STATE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE::dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCD_FAN_SYSTEM_SPEED_HIGH_STATE(0xFFFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/CDSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_HIGH_STATE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCD_FAN_SYSTEM_SPEED_HIGH_STATE = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE::u8GetData(tU16& tCD_FAN_SYSTEM_SPEED_HIGH_STATEParam) {
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_HIGH_STATEParam = tCD_FAN_SYSTEM_SPEED_HIGH_STATE;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE::tGetData() {
   vUpdate();
   return tCD_FAN_SYSTEM_SPEED_HIGH_STATE;
};

tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop",(tS32) 0xb3547d34L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", (tS32)0xb3547d34L);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::tGetData() {
   vUpdate();
   return tCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop;
};
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32GetData(tU16& tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) { 
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam = tCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", (tS32)0xb3547d34L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32SetData(tU16 &tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32SetData(const tU16 &tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::u8GetData(tU16& tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) {  
   vUpdate();
   tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam = tCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16 &tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(const tU16 &tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tCD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_Statistics_MinTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_Statistics_MinTemp::dp_tclHeatCtrlDPCD_Statistics_MinTemp(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_Statistics_MinTemp,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_Statistics_MinTemp::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_Statistics_MinTemp",(tS32) 0x714473ee);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_Statistics_MinTemp = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_Statistics_MinTemp::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_Statistics_MinTemp", (tS32)0x714473ee);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_Statistics_MinTemp, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_Statistics_MinTemp::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_Statistics_MinTemp::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_Statistics_MinTemp::tGetData() {
   vUpdate();
   return tCD_Statistics_MinTemp;
};
tS32 dp_tclHeatCtrlDPCD_Statistics_MinTemp::s32GetData(tS16& tCD_Statistics_MinTempParam) { 
   vUpdate();
   tCD_Statistics_MinTempParam = tCD_Statistics_MinTemp;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_Statistics_MinTemp::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_Statistics_MinTemp", (tS32)0x714473ee);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_Statistics_MinTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_Statistics_MinTemp::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_Statistics_MinTemp::s32SetData(tS16 &tCD_Statistics_MinTempParam) {
   //init parameter
   (tVoid)memcpy(&tCD_Statistics_MinTemp,(tVoid*)&tCD_Statistics_MinTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPCD_Statistics_MinTemp::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_Statistics_MinTemp::s32SetData(const tS16 &tCD_Statistics_MinTempParam) {
   //init parameter
   (tVoid)memcpy(&tCD_Statistics_MinTemp,(tVoid*)&tCD_Statistics_MinTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPCD_Statistics_MinTemp::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_Statistics_MinTemp::u8GetData(tS16& tCD_Statistics_MinTempParam) {  
   vUpdate();
   tCD_Statistics_MinTempParam = tCD_Statistics_MinTemp;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_Statistics_MinTemp::vSetData(tS16 &tCD_Statistics_MinTempParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_Statistics_MinTemp,(tVoid*)&tCD_Statistics_MinTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPCD_Statistics_MinTemp::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_Statistics_MinTemp::vSetData(const tS16 &tCD_Statistics_MinTempParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_Statistics_MinTemp,(tVoid*)&tCD_Statistics_MinTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPCD_Statistics_MinTemp::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_Statistics_MinTemp::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_Statistics_MinTemp::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_Statistics_MinTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_Statistics_MinTemp::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_Statistics_MinTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_Statistics_MinTemp::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_Statistics_MinTemp", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_Statistics_MinTemp has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CD_Statistics_MaxTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPCD_Statistics_MaxTemp::dp_tclHeatCtrlDPCD_Statistics_MaxTemp(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCD_Statistics_MaxTemp,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPCD_Statistics_MaxTemp::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CD_Statistics_MaxTemp",(tS32) 0x71442ab0);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCD_Statistics_MaxTemp = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPCD_Statistics_MaxTemp::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CD_Statistics_MaxTemp", (tS32)0x71442ab0);
   (tVoid)myDpElem.bFillData((tVoid*)&tCD_Statistics_MaxTemp, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPCD_Statistics_MaxTemp::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPCD_Statistics_MaxTemp::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPCD_Statistics_MaxTemp::tGetData() {
   vUpdate();
   return tCD_Statistics_MaxTemp;
};
tS32 dp_tclHeatCtrlDPCD_Statistics_MaxTemp::s32GetData(tS16& tCD_Statistics_MaxTempParam) { 
   vUpdate();
   tCD_Statistics_MaxTempParam = tCD_Statistics_MaxTemp;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPCD_Statistics_MaxTemp::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CD_Statistics_MaxTemp", (tS32)0x71442ab0);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPCD_Statistics_MaxTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPCD_Statistics_MaxTemp::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPCD_Statistics_MaxTemp::s32SetData(tS16 &tCD_Statistics_MaxTempParam) {
   //init parameter
   (tVoid)memcpy(&tCD_Statistics_MaxTemp,(tVoid*)&tCD_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPCD_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPCD_Statistics_MaxTemp::s32SetData(const tS16 &tCD_Statistics_MaxTempParam) {
   //init parameter
   (tVoid)memcpy(&tCD_Statistics_MaxTemp,(tVoid*)&tCD_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCD_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPCD_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPCD_Statistics_MaxTemp::u8GetData(tS16& tCD_Statistics_MaxTempParam) {  
   vUpdate();
   tCD_Statistics_MaxTempParam = tCD_Statistics_MaxTemp;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPCD_Statistics_MaxTemp::vSetData(tS16 &tCD_Statistics_MaxTempParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_Statistics_MaxTemp,(tVoid*)&tCD_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPCD_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPCD_Statistics_MaxTemp::vSetData(const tS16 &tCD_Statistics_MaxTempParam) { 
   //init parameter
   (tVoid)memcpy(&tCD_Statistics_MaxTemp,(tVoid*)&tCD_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCD_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPCD_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPCD_Statistics_MaxTemp::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPCD_Statistics_MaxTemp::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_Statistics_MaxTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_Statistics_MaxTemp::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "CD_Statistics_MaxTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPCD_Statistics_MaxTemp::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CD_Statistics_MaxTemp", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element CD_Statistics_MaxTemp has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_AVAIL"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_AVAIL::dp_tclHeatCtrlDPDVD_AVAIL() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_AVAIL(FALSE)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_AVAIL::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("AVAIL",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_AVAIL = (tBool)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_AVAIL::u8GetData(tBool& tDVD_AVAILParam) {
   vUpdate();
   tDVD_AVAILParam = tDVD_AVAIL;
   return _u8DataStatus;
}
tBool dp_tclHeatCtrlDPDVD_AVAIL::tGetData() {
   vUpdate();
   return tDVD_AVAIL;
};

tU8 dp_tclHeatCtrlDPDVD_AVAIL::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_AVAIL::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_AVAIL_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_AVAIL_Develop::dp_tclHeatCtrlDPDVD_AVAIL_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_AVAIL_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_AVAIL_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_AVAIL_Develop",(tS32) 0x68b39f00);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDVD_AVAIL_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_AVAIL_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_AVAIL_Develop", (tS32)0x68b39f00);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_AVAIL_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_AVAIL_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_AVAIL_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPDVD_AVAIL_Develop::tGetData() {
   vUpdate();
   return tDVD_AVAIL_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_AVAIL_Develop::s32GetData(tU8& tDVD_AVAIL_DevelopParam) { 
   vUpdate();
   tDVD_AVAIL_DevelopParam = tDVD_AVAIL_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_AVAIL_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_AVAIL_Develop", (tS32)0x68b39f00);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_AVAIL_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_AVAIL_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_AVAIL_Develop::s32SetData(tU8 &tDVD_AVAIL_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_AVAIL_Develop,(tVoid*)&tDVD_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_AVAIL_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_AVAIL_Develop::s32SetData(const tU8 &tDVD_AVAIL_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_AVAIL_Develop,(tVoid*)&tDVD_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_AVAIL_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_AVAIL_Develop::u8GetData(tU8& tDVD_AVAIL_DevelopParam) {  
   vUpdate();
   tDVD_AVAIL_DevelopParam = tDVD_AVAIL_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_AVAIL_Develop::vSetData(tU8 &tDVD_AVAIL_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_AVAIL_Develop,(tVoid*)&tDVD_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDVD_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_AVAIL_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_AVAIL_Develop::vSetData(const tU8 &tDVD_AVAIL_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_AVAIL_Develop,(tVoid*)&tDVD_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDVD_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_AVAIL_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_AVAIL_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_AVAIL_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_AVAIL_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_AVAIL_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_AVAIL_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_AVAIL_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_AVAIL_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_AVAIL_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_MinTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_MinTemp::dp_tclHeatCtrlDPDVD_MinTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_MinTemp(-400)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_MinTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MIN_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_MinTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_MinTemp::u8GetData(tS16& tDVD_MinTempParam) {
   vUpdate();
   tDVD_MinTempParam = tDVD_MinTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_MinTemp::tGetData() {
   vUpdate();
   return tDVD_MinTemp;
};

tU8 dp_tclHeatCtrlDPDVD_MinTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_MinTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_MaxTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_MaxTemp::dp_tclHeatCtrlDPDVD_MaxTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_MaxTemp(910)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_MaxTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MAX_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_MaxTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_MaxTemp::u8GetData(tS16& tDVD_MaxTempParam) {
   vUpdate();
   tDVD_MaxTempParam = tDVD_MaxTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_MaxTemp::tGetData() {
   vUpdate();
   return tDVD_MaxTemp;
};

tU8 dp_tclHeatCtrlDPDVD_MaxTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_MaxTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_EmergencyHighTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_EmergencyHighTemp::dp_tclHeatCtrlDPDVD_EmergencyHighTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_EmergencyHighTemp(900)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_EmergencyHighTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("EMERGHIGH_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_EmergencyHighTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_EmergencyHighTemp::u8GetData(tS16& tDVD_EmergencyHighTempParam) {
   vUpdate();
   tDVD_EmergencyHighTempParam = tDVD_EmergencyHighTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_EmergencyHighTemp::tGetData() {
   vUpdate();
   return tDVD_EmergencyHighTemp;
};

tU8 dp_tclHeatCtrlDPDVD_EmergencyHighTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_EmergencyHighTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_EmergencyHighTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_EmergencyHighTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_EmergencyHighTemp_Develop",(tS32) 0x67090418L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_EmergencyHighTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_EmergencyHighTemp_Develop", (tS32)0x67090418L);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_EmergencyHighTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::tGetData() {
   vUpdate();
   return tDVD_EmergencyHighTemp_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::s32GetData(tS16& tDVD_EmergencyHighTemp_DevelopParam) { 
   vUpdate();
   tDVD_EmergencyHighTemp_DevelopParam = tDVD_EmergencyHighTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_EmergencyHighTemp_Develop", (tS32)0x67090418L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::s32SetData(tS16 &tDVD_EmergencyHighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_EmergencyHighTemp_Develop,(tVoid*)&tDVD_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::s32SetData(const tS16 &tDVD_EmergencyHighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_EmergencyHighTemp_Develop,(tVoid*)&tDVD_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::u8GetData(tS16& tDVD_EmergencyHighTemp_DevelopParam) {  
   vUpdate();
   tDVD_EmergencyHighTemp_DevelopParam = tDVD_EmergencyHighTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::vSetData(tS16 &tDVD_EmergencyHighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_EmergencyHighTemp_Develop,(tVoid*)&tDVD_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::vSetData(const tS16 &tDVD_EmergencyHighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_EmergencyHighTemp_Develop,(tVoid*)&tDVD_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_EmergencyHighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_EmergencyHighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_EmergencyHighTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_EmergencyHighTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_EmergencyHighTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_EmergencyHigh2HighTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp::dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_EmergencyHigh2HighTemp(900)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("EMERGHIGH2HIGH_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_EmergencyHigh2HighTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp::u8GetData(tS16& tDVD_EmergencyHigh2HighTempParam) {
   vUpdate();
   tDVD_EmergencyHigh2HighTempParam = tDVD_EmergencyHigh2HighTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp::tGetData() {
   vUpdate();
   return tDVD_EmergencyHigh2HighTemp;
};

tU8 dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_EmergencyHigh2HighTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_EmergencyHigh2HighTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_EmergencyHigh2HighTemp_Develop",(tS32) 0x38c8afbeL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_EmergencyHigh2HighTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_EmergencyHigh2HighTemp_Develop", (tS32)0x38c8afbeL);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_EmergencyHigh2HighTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::tGetData() {
   vUpdate();
   return tDVD_EmergencyHigh2HighTemp_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::s32GetData(tS16& tDVD_EmergencyHigh2HighTemp_DevelopParam) { 
   vUpdate();
   tDVD_EmergencyHigh2HighTemp_DevelopParam = tDVD_EmergencyHigh2HighTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_EmergencyHigh2HighTemp_Develop", (tS32)0x38c8afbeL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::s32SetData(tS16 &tDVD_EmergencyHigh2HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_EmergencyHigh2HighTemp_Develop,(tVoid*)&tDVD_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::s32SetData(const tS16 &tDVD_EmergencyHigh2HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_EmergencyHigh2HighTemp_Develop,(tVoid*)&tDVD_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::u8GetData(tS16& tDVD_EmergencyHigh2HighTemp_DevelopParam) {  
   vUpdate();
   tDVD_EmergencyHigh2HighTemp_DevelopParam = tDVD_EmergencyHigh2HighTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::vSetData(tS16 &tDVD_EmergencyHigh2HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_EmergencyHigh2HighTemp_Develop,(tVoid*)&tDVD_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::vSetData(const tS16 &tDVD_EmergencyHigh2HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_EmergencyHigh2HighTemp_Develop,(tVoid*)&tDVD_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_EmergencyHigh2HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_EmergencyHigh2HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_EmergencyHigh2HighTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_EmergencyHigh2HighTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_EmergencyHigh2HighTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_HighTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_HighTemp::dp_tclHeatCtrlDPDVD_HighTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_HighTemp(800)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_HighTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("HIGH_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_HighTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_HighTemp::u8GetData(tS16& tDVD_HighTempParam) {
   vUpdate();
   tDVD_HighTempParam = tDVD_HighTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_HighTemp::tGetData() {
   vUpdate();
   return tDVD_HighTemp;
};

tU8 dp_tclHeatCtrlDPDVD_HighTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_HighTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_HighTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_HighTemp_Develop::dp_tclHeatCtrlDPDVD_HighTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_HighTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_HighTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_HighTemp_Develop",(tS32) 0x8c6e2ae1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_HighTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_HighTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_HighTemp_Develop", (tS32)0x8c6e2ae1);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_HighTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_HighTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_HighTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_HighTemp_Develop::tGetData() {
   vUpdate();
   return tDVD_HighTemp_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_HighTemp_Develop::s32GetData(tS16& tDVD_HighTemp_DevelopParam) { 
   vUpdate();
   tDVD_HighTemp_DevelopParam = tDVD_HighTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_HighTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_HighTemp_Develop", (tS32)0x8c6e2ae1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_HighTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_HighTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_HighTemp_Develop::s32SetData(tS16 &tDVD_HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_HighTemp_Develop,(tVoid*)&tDVD_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_HighTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_HighTemp_Develop::s32SetData(const tS16 &tDVD_HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_HighTemp_Develop,(tVoid*)&tDVD_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_HighTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_HighTemp_Develop::u8GetData(tS16& tDVD_HighTemp_DevelopParam) {  
   vUpdate();
   tDVD_HighTemp_DevelopParam = tDVD_HighTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_HighTemp_Develop::vSetData(tS16 &tDVD_HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_HighTemp_Develop,(tVoid*)&tDVD_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_HighTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_HighTemp_Develop::vSetData(const tS16 &tDVD_HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_HighTemp_Develop,(tVoid*)&tDVD_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_HighTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_HighTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_HighTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_HighTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_HighTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_HighTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_HighTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_High2WarmTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_High2WarmTemp::dp_tclHeatCtrlDPDVD_High2WarmTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_High2WarmTemp(800)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_High2WarmTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("HIGH2WARM_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_High2WarmTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_High2WarmTemp::u8GetData(tS16& tDVD_High2WarmTempParam) {
   vUpdate();
   tDVD_High2WarmTempParam = tDVD_High2WarmTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_High2WarmTemp::tGetData() {
   vUpdate();
   return tDVD_High2WarmTemp;
};

tU8 dp_tclHeatCtrlDPDVD_High2WarmTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_High2WarmTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_High2WarmTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_High2WarmTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_High2WarmTemp_Develop",(tS32) 0x541dce52);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_High2WarmTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_High2WarmTemp_Develop", (tS32)0x541dce52);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_High2WarmTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::tGetData() {
   vUpdate();
   return tDVD_High2WarmTemp_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::s32GetData(tS16& tDVD_High2WarmTemp_DevelopParam) { 
   vUpdate();
   tDVD_High2WarmTemp_DevelopParam = tDVD_High2WarmTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_High2WarmTemp_Develop", (tS32)0x541dce52);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::s32SetData(tS16 &tDVD_High2WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_High2WarmTemp_Develop,(tVoid*)&tDVD_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::s32SetData(const tS16 &tDVD_High2WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_High2WarmTemp_Develop,(tVoid*)&tDVD_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::u8GetData(tS16& tDVD_High2WarmTemp_DevelopParam) {  
   vUpdate();
   tDVD_High2WarmTemp_DevelopParam = tDVD_High2WarmTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::vSetData(tS16 &tDVD_High2WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_High2WarmTemp_Develop,(tVoid*)&tDVD_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::vSetData(const tS16 &tDVD_High2WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_High2WarmTemp_Develop,(tVoid*)&tDVD_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_High2WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_High2WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_High2WarmTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_High2WarmTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_High2WarmTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_WarmTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_WarmTemp::dp_tclHeatCtrlDPDVD_WarmTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_WarmTemp(600)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_WarmTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("WARM_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_WarmTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_WarmTemp::u8GetData(tS16& tDVD_WarmTempParam) {
   vUpdate();
   tDVD_WarmTempParam = tDVD_WarmTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_WarmTemp::tGetData() {
   vUpdate();
   return tDVD_WarmTemp;
};

tU8 dp_tclHeatCtrlDPDVD_WarmTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_WarmTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_WarmTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_WarmTemp_Develop::dp_tclHeatCtrlDPDVD_WarmTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_WarmTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_WarmTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_WarmTemp_Develop",(tS32) 0x2c00d5d8);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_WarmTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_WarmTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_WarmTemp_Develop", (tS32)0x2c00d5d8);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_WarmTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_WarmTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_WarmTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_WarmTemp_Develop::tGetData() {
   vUpdate();
   return tDVD_WarmTemp_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_WarmTemp_Develop::s32GetData(tS16& tDVD_WarmTemp_DevelopParam) { 
   vUpdate();
   tDVD_WarmTemp_DevelopParam = tDVD_WarmTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_WarmTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_WarmTemp_Develop", (tS32)0x2c00d5d8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_WarmTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_WarmTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_WarmTemp_Develop::s32SetData(tS16 &tDVD_WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_WarmTemp_Develop,(tVoid*)&tDVD_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_WarmTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_WarmTemp_Develop::s32SetData(const tS16 &tDVD_WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_WarmTemp_Develop,(tVoid*)&tDVD_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_WarmTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_WarmTemp_Develop::u8GetData(tS16& tDVD_WarmTemp_DevelopParam) {  
   vUpdate();
   tDVD_WarmTemp_DevelopParam = tDVD_WarmTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_WarmTemp_Develop::vSetData(tS16 &tDVD_WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_WarmTemp_Develop,(tVoid*)&tDVD_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_WarmTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_WarmTemp_Develop::vSetData(const tS16 &tDVD_WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_WarmTemp_Develop,(tVoid*)&tDVD_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_WarmTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_WarmTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_WarmTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_WarmTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_WarmTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_WarmTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_WarmTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_Warm2NormalTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_Warm2NormalTemp::dp_tclHeatCtrlDPDVD_Warm2NormalTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_Warm2NormalTemp(600)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_Warm2NormalTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("WARM2NORMAL_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_Warm2NormalTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_Warm2NormalTemp::u8GetData(tS16& tDVD_Warm2NormalTempParam) {
   vUpdate();
   tDVD_Warm2NormalTempParam = tDVD_Warm2NormalTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_Warm2NormalTemp::tGetData() {
   vUpdate();
   return tDVD_Warm2NormalTemp;
};

tU8 dp_tclHeatCtrlDPDVD_Warm2NormalTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_Warm2NormalTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_Warm2NormalTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_Warm2NormalTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_Warm2NormalTemp_Develop",(tS32) 0x752dc5afL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_Warm2NormalTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_Warm2NormalTemp_Develop", (tS32)0x752dc5afL);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_Warm2NormalTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::tGetData() {
   vUpdate();
   return tDVD_Warm2NormalTemp_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::s32GetData(tS16& tDVD_Warm2NormalTemp_DevelopParam) { 
   vUpdate();
   tDVD_Warm2NormalTemp_DevelopParam = tDVD_Warm2NormalTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_Warm2NormalTemp_Develop", (tS32)0x752dc5afL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::s32SetData(tS16 &tDVD_Warm2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_Warm2NormalTemp_Develop,(tVoid*)&tDVD_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::s32SetData(const tS16 &tDVD_Warm2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_Warm2NormalTemp_Develop,(tVoid*)&tDVD_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::u8GetData(tS16& tDVD_Warm2NormalTemp_DevelopParam) {  
   vUpdate();
   tDVD_Warm2NormalTemp_DevelopParam = tDVD_Warm2NormalTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::vSetData(tS16 &tDVD_Warm2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_Warm2NormalTemp_Develop,(tVoid*)&tDVD_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::vSetData(const tS16 &tDVD_Warm2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_Warm2NormalTemp_Develop,(tVoid*)&tDVD_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_Warm2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_Warm2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_Warm2NormalTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_Warm2NormalTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_Warm2NormalTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_Cold2NormalTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_Cold2NormalTemp::dp_tclHeatCtrlDPDVD_Cold2NormalTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_Cold2NormalTemp(-100)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_Cold2NormalTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("COLD2NORMAL_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_Cold2NormalTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_Cold2NormalTemp::u8GetData(tS16& tDVD_Cold2NormalTempParam) {
   vUpdate();
   tDVD_Cold2NormalTempParam = tDVD_Cold2NormalTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_Cold2NormalTemp::tGetData() {
   vUpdate();
   return tDVD_Cold2NormalTemp;
};

tU8 dp_tclHeatCtrlDPDVD_Cold2NormalTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_Cold2NormalTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_Cold2NormalTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_Cold2NormalTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_Cold2NormalTemp_Develop",(tS32) 0xa773df16L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_Cold2NormalTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_Cold2NormalTemp_Develop", (tS32)0xa773df16L);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_Cold2NormalTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::tGetData() {
   vUpdate();
   return tDVD_Cold2NormalTemp_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::s32GetData(tS16& tDVD_Cold2NormalTemp_DevelopParam) { 
   vUpdate();
   tDVD_Cold2NormalTemp_DevelopParam = tDVD_Cold2NormalTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_Cold2NormalTemp_Develop", (tS32)0xa773df16L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::s32SetData(tS16 &tDVD_Cold2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_Cold2NormalTemp_Develop,(tVoid*)&tDVD_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::s32SetData(const tS16 &tDVD_Cold2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_Cold2NormalTemp_Develop,(tVoid*)&tDVD_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::u8GetData(tS16& tDVD_Cold2NormalTemp_DevelopParam) {  
   vUpdate();
   tDVD_Cold2NormalTemp_DevelopParam = tDVD_Cold2NormalTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::vSetData(tS16 &tDVD_Cold2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_Cold2NormalTemp_Develop,(tVoid*)&tDVD_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::vSetData(const tS16 &tDVD_Cold2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_Cold2NormalTemp_Develop,(tVoid*)&tDVD_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_Cold2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_Cold2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_Cold2NormalTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_Cold2NormalTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_Cold2NormalTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_ColdTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_ColdTemp::dp_tclHeatCtrlDPDVD_ColdTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_ColdTemp(-100)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_ColdTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("COLD_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_ColdTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_ColdTemp::u8GetData(tS16& tDVD_ColdTempParam) {
   vUpdate();
   tDVD_ColdTempParam = tDVD_ColdTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_ColdTemp::tGetData() {
   vUpdate();
   return tDVD_ColdTemp;
};

tU8 dp_tclHeatCtrlDPDVD_ColdTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_ColdTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_ColdTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_ColdTemp_Develop::dp_tclHeatCtrlDPDVD_ColdTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_ColdTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_ColdTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_ColdTemp_Develop",(tS32) 0xbddc5f3b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_ColdTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_ColdTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_ColdTemp_Develop", (tS32)0xbddc5f3b);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_ColdTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_ColdTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_ColdTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_ColdTemp_Develop::tGetData() {
   vUpdate();
   return tDVD_ColdTemp_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_ColdTemp_Develop::s32GetData(tS16& tDVD_ColdTemp_DevelopParam) { 
   vUpdate();
   tDVD_ColdTemp_DevelopParam = tDVD_ColdTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_ColdTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_ColdTemp_Develop", (tS32)0xbddc5f3b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_ColdTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_ColdTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_ColdTemp_Develop::s32SetData(tS16 &tDVD_ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_ColdTemp_Develop,(tVoid*)&tDVD_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_ColdTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_ColdTemp_Develop::s32SetData(const tS16 &tDVD_ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_ColdTemp_Develop,(tVoid*)&tDVD_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_ColdTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_ColdTemp_Develop::u8GetData(tS16& tDVD_ColdTemp_DevelopParam) {  
   vUpdate();
   tDVD_ColdTemp_DevelopParam = tDVD_ColdTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_ColdTemp_Develop::vSetData(tS16 &tDVD_ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_ColdTemp_Develop,(tVoid*)&tDVD_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_ColdTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_ColdTemp_Develop::vSetData(const tS16 &tDVD_ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_ColdTemp_Develop,(tVoid*)&tDVD_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_ColdTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_ColdTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_ColdTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_ColdTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_ColdTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_ColdTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_ColdTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_Low2ColdTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_Low2ColdTemp::dp_tclHeatCtrlDPDVD_Low2ColdTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_Low2ColdTemp(-200)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_Low2ColdTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("LOW2COLD_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_Low2ColdTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_Low2ColdTemp::u8GetData(tS16& tDVD_Low2ColdTempParam) {
   vUpdate();
   tDVD_Low2ColdTempParam = tDVD_Low2ColdTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_Low2ColdTemp::tGetData() {
   vUpdate();
   return tDVD_Low2ColdTemp;
};

tU8 dp_tclHeatCtrlDPDVD_Low2ColdTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_Low2ColdTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_Low2ColdTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_Low2ColdTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_Low2ColdTemp_Develop",(tS32) 0x98d81363);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_Low2ColdTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_Low2ColdTemp_Develop", (tS32)0x98d81363);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_Low2ColdTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::tGetData() {
   vUpdate();
   return tDVD_Low2ColdTemp_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::s32GetData(tS16& tDVD_Low2ColdTemp_DevelopParam) { 
   vUpdate();
   tDVD_Low2ColdTemp_DevelopParam = tDVD_Low2ColdTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_Low2ColdTemp_Develop", (tS32)0x98d81363);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::s32SetData(tS16 &tDVD_Low2ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_Low2ColdTemp_Develop,(tVoid*)&tDVD_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::s32SetData(const tS16 &tDVD_Low2ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_Low2ColdTemp_Develop,(tVoid*)&tDVD_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::u8GetData(tS16& tDVD_Low2ColdTemp_DevelopParam) {  
   vUpdate();
   tDVD_Low2ColdTemp_DevelopParam = tDVD_Low2ColdTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::vSetData(tS16 &tDVD_Low2ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_Low2ColdTemp_Develop,(tVoid*)&tDVD_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::vSetData(const tS16 &tDVD_Low2ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_Low2ColdTemp_Develop,(tVoid*)&tDVD_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_Low2ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_Low2ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_Low2ColdTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_Low2ColdTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_Low2ColdTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_LowTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_LowTemp::dp_tclHeatCtrlDPDVD_LowTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_LowTemp(-200)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_LowTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("LOW_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_LowTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_LowTemp::u8GetData(tS16& tDVD_LowTempParam) {
   vUpdate();
   tDVD_LowTempParam = tDVD_LowTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_LowTemp::tGetData() {
   vUpdate();
   return tDVD_LowTemp;
};

tU8 dp_tclHeatCtrlDPDVD_LowTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_LowTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_LowTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_LowTemp_Develop::dp_tclHeatCtrlDPDVD_LowTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_LowTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_LowTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_LowTemp_Develop",(tS32) 0x3941c197);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_LowTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_LowTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_LowTemp_Develop", (tS32)0x3941c197);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_LowTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_LowTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_LowTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_LowTemp_Develop::tGetData() {
   vUpdate();
   return tDVD_LowTemp_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_LowTemp_Develop::s32GetData(tS16& tDVD_LowTemp_DevelopParam) { 
   vUpdate();
   tDVD_LowTemp_DevelopParam = tDVD_LowTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_LowTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_LowTemp_Develop", (tS32)0x3941c197);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_LowTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_LowTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_LowTemp_Develop::s32SetData(tS16 &tDVD_LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_LowTemp_Develop,(tVoid*)&tDVD_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_LowTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_LowTemp_Develop::s32SetData(const tS16 &tDVD_LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_LowTemp_Develop,(tVoid*)&tDVD_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_LowTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_LowTemp_Develop::u8GetData(tS16& tDVD_LowTemp_DevelopParam) {  
   vUpdate();
   tDVD_LowTemp_DevelopParam = tDVD_LowTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_LowTemp_Develop::vSetData(tS16 &tDVD_LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_LowTemp_Develop,(tVoid*)&tDVD_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_LowTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_LowTemp_Develop::vSetData(const tS16 &tDVD_LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_LowTemp_Develop,(tVoid*)&tDVD_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_LowTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_LowTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_LowTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_LowTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_LowTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_LowTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_LowTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_CriticalLow2LowTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp::dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_CriticalLow2LowTemp(-300)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CRITICALLOW2LOW_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_CriticalLow2LowTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp::u8GetData(tS16& tDVD_CriticalLow2LowTempParam) {
   vUpdate();
   tDVD_CriticalLow2LowTempParam = tDVD_CriticalLow2LowTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp::tGetData() {
   vUpdate();
   return tDVD_CriticalLow2LowTemp;
};

tU8 dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_CriticalLow2LowTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_CriticalLow2LowTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_CriticalLow2LowTemp_Develop",(tS32) 0xd885cf4eL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_CriticalLow2LowTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_CriticalLow2LowTemp_Develop", (tS32)0xd885cf4eL);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_CriticalLow2LowTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::tGetData() {
   vUpdate();
   return tDVD_CriticalLow2LowTemp_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::s32GetData(tS16& tDVD_CriticalLow2LowTemp_DevelopParam) { 
   vUpdate();
   tDVD_CriticalLow2LowTemp_DevelopParam = tDVD_CriticalLow2LowTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_CriticalLow2LowTemp_Develop", (tS32)0xd885cf4eL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::s32SetData(tS16 &tDVD_CriticalLow2LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_CriticalLow2LowTemp_Develop,(tVoid*)&tDVD_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::s32SetData(const tS16 &tDVD_CriticalLow2LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_CriticalLow2LowTemp_Develop,(tVoid*)&tDVD_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::u8GetData(tS16& tDVD_CriticalLow2LowTemp_DevelopParam) {  
   vUpdate();
   tDVD_CriticalLow2LowTemp_DevelopParam = tDVD_CriticalLow2LowTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::vSetData(tS16 &tDVD_CriticalLow2LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_CriticalLow2LowTemp_Develop,(tVoid*)&tDVD_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::vSetData(const tS16 &tDVD_CriticalLow2LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_CriticalLow2LowTemp_Develop,(tVoid*)&tDVD_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_CriticalLow2LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_CriticalLow2LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_CriticalLow2LowTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_CriticalLow2LowTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_CriticalLow2LowTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_CriticalLowTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_CriticalLowTemp::dp_tclHeatCtrlDPDVD_CriticalLowTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_CriticalLowTemp(-300)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_CriticalLowTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CRITICALLOW_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_CriticalLowTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_CriticalLowTemp::u8GetData(tS16& tDVD_CriticalLowTempParam) {
   vUpdate();
   tDVD_CriticalLowTempParam = tDVD_CriticalLowTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_CriticalLowTemp::tGetData() {
   vUpdate();
   return tDVD_CriticalLowTemp;
};

tU8 dp_tclHeatCtrlDPDVD_CriticalLowTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_CriticalLowTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_CriticalLowTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_CriticalLowTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_CriticalLowTemp_Develop",(tS32) 0x4fe33fb6L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_CriticalLowTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_CriticalLowTemp_Develop", (tS32)0x4fe33fb6L);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_CriticalLowTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::tGetData() {
   vUpdate();
   return tDVD_CriticalLowTemp_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::s32GetData(tS16& tDVD_CriticalLowTemp_DevelopParam) { 
   vUpdate();
   tDVD_CriticalLowTemp_DevelopParam = tDVD_CriticalLowTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_CriticalLowTemp_Develop", (tS32)0x4fe33fb6L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::s32SetData(tS16 &tDVD_CriticalLowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_CriticalLowTemp_Develop,(tVoid*)&tDVD_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::s32SetData(const tS16 &tDVD_CriticalLowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_CriticalLowTemp_Develop,(tVoid*)&tDVD_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::u8GetData(tS16& tDVD_CriticalLowTemp_DevelopParam) {  
   vUpdate();
   tDVD_CriticalLowTemp_DevelopParam = tDVD_CriticalLowTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::vSetData(tS16 &tDVD_CriticalLowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_CriticalLowTemp_Develop,(tVoid*)&tDVD_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::vSetData(const tS16 &tDVD_CriticalLowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_CriticalLowTemp_Develop,(tVoid*)&tDVD_CriticalLowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_CriticalLowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_CriticalLowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_CriticalLowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_CriticalLowTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_CriticalLowTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_CriticalLowTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_ATTENUATION_CYCLETIME"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME::dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_ATTENUATION_CYCLETIME(60)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CYCLETIME_ATTENUATION",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_ATTENUATION_CYCLETIME = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME::u8GetData(tU8& tDVD_ATTENUATION_CYCLETIMEParam) {
   vUpdate();
   tDVD_ATTENUATION_CYCLETIMEParam = tDVD_ATTENUATION_CYCLETIME;
   return _u8DataStatus;
}
tU8 dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME::tGetData() {
   vUpdate();
   return tDVD_ATTENUATION_CYCLETIME;
};

tU8 dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_ATTENUATION_CYCLETIME_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_ATTENUATION_CYCLETIME_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_ATTENUATION_CYCLETIME_Develop",(tS32) 0xbc43c5f1L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDVD_ATTENUATION_CYCLETIME_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_ATTENUATION_CYCLETIME_Develop", (tS32)0xbc43c5f1L);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_ATTENUATION_CYCLETIME_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::tGetData() {
   vUpdate();
   return tDVD_ATTENUATION_CYCLETIME_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::s32GetData(tU8& tDVD_ATTENUATION_CYCLETIME_DevelopParam) { 
   vUpdate();
   tDVD_ATTENUATION_CYCLETIME_DevelopParam = tDVD_ATTENUATION_CYCLETIME_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_ATTENUATION_CYCLETIME_Develop", (tS32)0xbc43c5f1L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::s32SetData(tU8 &tDVD_ATTENUATION_CYCLETIME_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tDVD_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::s32SetData(const tU8 &tDVD_ATTENUATION_CYCLETIME_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tDVD_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::u8GetData(tU8& tDVD_ATTENUATION_CYCLETIME_DevelopParam) {  
   vUpdate();
   tDVD_ATTENUATION_CYCLETIME_DevelopParam = tDVD_ATTENUATION_CYCLETIME_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::vSetData(tU8 &tDVD_ATTENUATION_CYCLETIME_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tDVD_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDVD_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::vSetData(const tU8 &tDVD_ATTENUATION_CYCLETIME_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_ATTENUATION_CYCLETIME_Develop,(tVoid*)&tDVD_ATTENUATION_CYCLETIME_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDVD_ATTENUATION_CYCLETIME_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_ATTENUATION_CYCLETIME_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_ATTENUATION_CYCLETIME_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_ATTENUATION_CYCLETIME_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_ATTENUATION_CYCLETIME_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_ATTENUATION_CYCLETIME_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH::dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_000_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH::u8GetData(tS16& tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGHParam) {
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGHParam = tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH::tGetData() {
   vUpdate();
   return tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop",(tS32) 0x31c77503L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", (tS32)0x31c77503L);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32GetData(tS16& tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam = tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", (tS32)0x31c77503L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32SetData(tS16 &tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::s32SetData(const tS16 &tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::u8GetData(tS16& tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam = tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16 &tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(const tS16 &tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_FAN_SYSTEM_SPEED_000_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH::dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_025_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH::u8GetData(tS16& tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGHParam) {
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGHParam = tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH::tGetData() {
   vUpdate();
   return tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop",(tS32) 0xdee928baL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", (tS32)0xdee928baL);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32GetData(tS16& tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam = tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", (tS32)0xdee928baL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32SetData(tS16 &tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::s32SetData(const tS16 &tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::u8GetData(tS16& tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam = tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16 &tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(const tS16 &tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_FAN_SYSTEM_SPEED_025_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH::dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_050_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH::u8GetData(tS16& tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGHParam) {
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGHParam = tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH::tGetData() {
   vUpdate();
   return tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop",(tS32) 0xa7aa4b34L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", (tS32)0xa7aa4b34L);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32GetData(tS16& tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam = tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", (tS32)0xa7aa4b34L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32SetData(tS16 &tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::s32SetData(const tS16 &tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::u8GetData(tS16& tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam = tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16 &tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(const tS16 &tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_FAN_SYSTEM_SPEED_050_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH::dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_075_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH::u8GetData(tS16& tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGHParam) {
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGHParam = tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH::tGetData() {
   vUpdate();
   return tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop",(tS32) 0x54cbfeebL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", (tS32)0x54cbfeebL);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32GetData(tS16& tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam = tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", (tS32)0x54cbfeebL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32SetData(tS16 &tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::s32SetData(const tS16 &tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::u8GetData(tS16& tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam = tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16 &tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(const tS16 &tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_FAN_SYSTEM_SPEED_075_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH(0x7FFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_MAX_TEMP_HIGH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::u8GetData(tS16& tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGHParam) {
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGHParam = tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::tGetData() {
   vUpdate();
   return tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH;
};

tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop",(tS32) 0xd9e7e785L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", (tS32)0xd9e7e785L);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::tGetData() {
   vUpdate();
   return tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32GetData(tS16& tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) { 
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam = tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", (tS32)0xd9e7e785L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32SetData(tS16 &tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::s32SetData(const tS16 &tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::u8GetData(tS16& tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) {  
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam = tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16 &tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(const tS16 &tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_FAN_SYSTEM_SPEED_MAX_TEMP_HIGH_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_FAN_SYSTEM_SPEED_WARM_STATE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE::dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_FAN_SYSTEM_SPEED_WARM_STATE(0xFFFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_WARM_STATE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_FAN_SYSTEM_SPEED_WARM_STATE = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE::u8GetData(tU16& tDVD_FAN_SYSTEM_SPEED_WARM_STATEParam) {
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_WARM_STATEParam = tDVD_FAN_SYSTEM_SPEED_WARM_STATE;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE::tGetData() {
   vUpdate();
   return tDVD_FAN_SYSTEM_SPEED_WARM_STATE;
};

tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop",(tS32) 0xcb5af426L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop", (tS32)0xcb5af426L);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::tGetData() {
   vUpdate();
   return tDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32GetData(tU16& tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) { 
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam = tDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop", (tS32)0xcb5af426L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32SetData(tU16 &tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::s32SetData(const tU16 &tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::u8GetData(tU16& tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) {  
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam = tDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16 &tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(const tU16 &tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_WARM_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::vSetData(tU16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_FAN_SYSTEM_SPEED_WARM_STATE_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_FAN_SYSTEM_SPEED_HIGH_STATE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE::dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDVD_FAN_SYSTEM_SPEED_HIGH_STATE(0xFFFF)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/DVDSENSOR/FAN/SYSTEM";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SPEED_HIGH_STATE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDVD_FAN_SYSTEM_SPEED_HIGH_STATE = (tU16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE::u8GetData(tU16& tDVD_FAN_SYSTEM_SPEED_HIGH_STATEParam) {
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_HIGH_STATEParam = tDVD_FAN_SYSTEM_SPEED_HIGH_STATE;
   return _u8DataStatus;
}
tU16 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE::tGetData() {
   vUpdate();
   return tDVD_FAN_SYSTEM_SPEED_HIGH_STATE;
};

tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop",(tS32) 0x36084207L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", (tS32)0x36084207L);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::tGetData() {
   vUpdate();
   return tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop;
};
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32GetData(tU16& tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) { 
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam = tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", (tS32)0x36084207L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32SetData(tU16 &tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::s32SetData(const tU16 &tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::u8GetData(tU16& tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) {  
   vUpdate();
   tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam = tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16 &tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(const tU16 &tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop,(tVoid*)&tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDVD_FAN_SYSTEM_SPEED_HIGH_STATE_DevelopParam' in function 'dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::vSetData(tU16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_FAN_SYSTEM_SPEED_HIGH_STATE_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_Statistics_MinTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_Statistics_MinTemp::dp_tclHeatCtrlDPDVD_Statistics_MinTemp(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_Statistics_MinTemp,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_Statistics_MinTemp::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_Statistics_MinTemp",(tS32) 0xc25ed2a5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_Statistics_MinTemp = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_Statistics_MinTemp::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_Statistics_MinTemp", (tS32)0xc25ed2a5);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_Statistics_MinTemp, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_Statistics_MinTemp::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_Statistics_MinTemp::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_Statistics_MinTemp::tGetData() {
   vUpdate();
   return tDVD_Statistics_MinTemp;
};
tS32 dp_tclHeatCtrlDPDVD_Statistics_MinTemp::s32GetData(tS16& tDVD_Statistics_MinTempParam) { 
   vUpdate();
   tDVD_Statistics_MinTempParam = tDVD_Statistics_MinTemp;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_Statistics_MinTemp::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_Statistics_MinTemp", (tS32)0xc25ed2a5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_Statistics_MinTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_Statistics_MinTemp::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_Statistics_MinTemp::s32SetData(tS16 &tDVD_Statistics_MinTempParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_Statistics_MinTemp,(tVoid*)&tDVD_Statistics_MinTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPDVD_Statistics_MinTemp::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_Statistics_MinTemp::s32SetData(const tS16 &tDVD_Statistics_MinTempParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_Statistics_MinTemp,(tVoid*)&tDVD_Statistics_MinTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPDVD_Statistics_MinTemp::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_Statistics_MinTemp::u8GetData(tS16& tDVD_Statistics_MinTempParam) {  
   vUpdate();
   tDVD_Statistics_MinTempParam = tDVD_Statistics_MinTemp;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_Statistics_MinTemp::vSetData(tS16 &tDVD_Statistics_MinTempParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_Statistics_MinTemp,(tVoid*)&tDVD_Statistics_MinTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPDVD_Statistics_MinTemp::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_Statistics_MinTemp::vSetData(const tS16 &tDVD_Statistics_MinTempParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_Statistics_MinTemp,(tVoid*)&tDVD_Statistics_MinTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_Statistics_MinTempParam' in function 'dp_tclHeatCtrlDPDVD_Statistics_MinTemp::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_Statistics_MinTemp::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_Statistics_MinTemp::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_Statistics_MinTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_Statistics_MinTemp::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_Statistics_MinTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_Statistics_MinTemp::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_Statistics_MinTemp", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_Statistics_MinTemp has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DVD_Statistics_MaxTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::dp_tclHeatCtrlDPDVD_Statistics_MaxTemp(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDVD_Statistics_MaxTemp,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DVD_Statistics_MaxTemp",(tS32) 0xc25e8967);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDVD_Statistics_MaxTemp = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DVD_Statistics_MaxTemp", (tS32)0xc25e8967);
   (tVoid)myDpElem.bFillData((tVoid*)&tDVD_Statistics_MaxTemp, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::tGetData() {
   vUpdate();
   return tDVD_Statistics_MaxTemp;
};
tS32 dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::s32GetData(tS16& tDVD_Statistics_MaxTempParam) { 
   vUpdate();
   tDVD_Statistics_MaxTempParam = tDVD_Statistics_MaxTemp;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DVD_Statistics_MaxTemp", (tS32)0xc25e8967);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::s32SetData(tS16 &tDVD_Statistics_MaxTempParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_Statistics_MaxTemp,(tVoid*)&tDVD_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::s32SetData(const tS16 &tDVD_Statistics_MaxTempParam) {
   //init parameter
   (tVoid)memcpy(&tDVD_Statistics_MaxTemp,(tVoid*)&tDVD_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDVD_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::u8GetData(tS16& tDVD_Statistics_MaxTempParam) {  
   vUpdate();
   tDVD_Statistics_MaxTempParam = tDVD_Statistics_MaxTemp;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::vSetData(tS16 &tDVD_Statistics_MaxTempParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_Statistics_MaxTemp,(tVoid*)&tDVD_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::vSetData(const tS16 &tDVD_Statistics_MaxTempParam) { 
   //init parameter
   (tVoid)memcpy(&tDVD_Statistics_MaxTemp,(tVoid*)&tDVD_Statistics_MaxTempParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDVD_Statistics_MaxTempParam' in function 'dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_Statistics_MaxTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "DVD_Statistics_MaxTemp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPDVD_Statistics_MaxTemp::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DVD_Statistics_MaxTemp", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element DVD_Statistics_MaxTemp has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_AVAIL"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPGPS_AVAIL::dp_tclHeatCtrlDPGPS_AVAIL() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGPS_AVAIL(FALSE)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPGPS_AVAIL::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/GPSSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("AVAIL",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGPS_AVAIL = (tBool)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPGPS_AVAIL::u8GetData(tBool& tGPS_AVAILParam) {
   vUpdate();
   tGPS_AVAILParam = tGPS_AVAIL;
   return _u8DataStatus;
}
tBool dp_tclHeatCtrlDPGPS_AVAIL::tGetData() {
   vUpdate();
   return tGPS_AVAIL;
};

tU8 dp_tclHeatCtrlDPGPS_AVAIL::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPGPS_AVAIL::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_AVAIL_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPGPS_AVAIL_Develop::dp_tclHeatCtrlDPGPS_AVAIL_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGPS_AVAIL_Develop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPGPS_AVAIL_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("GPS_AVAIL_Develop",(tS32) 0xac93119c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tGPS_AVAIL_Develop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPGPS_AVAIL_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("GPS_AVAIL_Develop", (tS32)0xac93119c);
   (tVoid)myDpElem.bFillData((tVoid*)&tGPS_AVAIL_Develop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPGPS_AVAIL_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPGPS_AVAIL_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclHeatCtrlDPGPS_AVAIL_Develop::tGetData() {
   vUpdate();
   return tGPS_AVAIL_Develop;
};
tS32 dp_tclHeatCtrlDPGPS_AVAIL_Develop::s32GetData(tU8& tGPS_AVAIL_DevelopParam) { 
   vUpdate();
   tGPS_AVAIL_DevelopParam = tGPS_AVAIL_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPGPS_AVAIL_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("GPS_AVAIL_Develop", (tS32)0xac93119c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPGPS_AVAIL_Develop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPGPS_AVAIL_Develop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPGPS_AVAIL_Develop::s32SetData(tU8 &tGPS_AVAIL_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_AVAIL_Develop,(tVoid*)&tGPS_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_AVAIL_Develop::vSetData(tU8)' could be made const reference
tS32 dp_tclHeatCtrlDPGPS_AVAIL_Develop::s32SetData(const tU8 &tGPS_AVAIL_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_AVAIL_Develop,(tVoid*)&tGPS_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_AVAIL_Develop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPGPS_AVAIL_Develop::u8GetData(tU8& tGPS_AVAIL_DevelopParam) {  
   vUpdate();
   tGPS_AVAIL_DevelopParam = tGPS_AVAIL_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPGPS_AVAIL_Develop::vSetData(tU8 &tGPS_AVAIL_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_AVAIL_Develop,(tVoid*)&tGPS_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tGPS_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_AVAIL_Develop::vSetData(tU8)' could be made const reference
tVoid dp_tclHeatCtrlDPGPS_AVAIL_Develop::vSetData(const tU8 &tGPS_AVAIL_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_AVAIL_Develop,(tVoid*)&tGPS_AVAIL_DevelopParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tGPS_AVAIL_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_AVAIL_Develop::vSetData(tU8)' could be made const reference
tU8   dp_tclHeatCtrlDPGPS_AVAIL_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPGPS_AVAIL_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_AVAIL_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_AVAIL_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_AVAIL_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_AVAIL_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: GPS_AVAIL_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element GPS_AVAIL_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_MinTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPGPS_MinTemp::dp_tclHeatCtrlDPGPS_MinTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGPS_MinTemp(-500)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPGPS_MinTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/GPSSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MIN_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGPS_MinTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPGPS_MinTemp::u8GetData(tS16& tGPS_MinTempParam) {
   vUpdate();
   tGPS_MinTempParam = tGPS_MinTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPGPS_MinTemp::tGetData() {
   vUpdate();
   return tGPS_MinTemp;
};

tU8 dp_tclHeatCtrlDPGPS_MinTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPGPS_MinTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_MaxTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPGPS_MaxTemp::dp_tclHeatCtrlDPGPS_MaxTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGPS_MaxTemp(870)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPGPS_MaxTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/GPSSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("MAX_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGPS_MaxTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPGPS_MaxTemp::u8GetData(tS16& tGPS_MaxTempParam) {
   vUpdate();
   tGPS_MaxTempParam = tGPS_MaxTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPGPS_MaxTemp::tGetData() {
   vUpdate();
   return tGPS_MaxTemp;
};

tU8 dp_tclHeatCtrlDPGPS_MaxTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPGPS_MaxTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_EmergencyHighTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPGPS_EmergencyHighTemp::dp_tclHeatCtrlDPGPS_EmergencyHighTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGPS_EmergencyHighTemp(850)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPGPS_EmergencyHighTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/GPSSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("EMERGHIGH_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGPS_EmergencyHighTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPGPS_EmergencyHighTemp::u8GetData(tS16& tGPS_EmergencyHighTempParam) {
   vUpdate();
   tGPS_EmergencyHighTempParam = tGPS_EmergencyHighTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPGPS_EmergencyHighTemp::tGetData() {
   vUpdate();
   return tGPS_EmergencyHighTemp;
};

tU8 dp_tclHeatCtrlDPGPS_EmergencyHighTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPGPS_EmergencyHighTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_EmergencyHighTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGPS_EmergencyHighTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("GPS_EmergencyHighTemp_Develop",(tS32) 0x1fc95f74L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tGPS_EmergencyHighTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("GPS_EmergencyHighTemp_Develop", (tS32)0x1fc95f74L);
   (tVoid)myDpElem.bFillData((tVoid*)&tGPS_EmergencyHighTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::tGetData() {
   vUpdate();
   return tGPS_EmergencyHighTemp_Develop;
};
tS32 dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::s32GetData(tS16& tGPS_EmergencyHighTemp_DevelopParam) { 
   vUpdate();
   tGPS_EmergencyHighTemp_DevelopParam = tGPS_EmergencyHighTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("GPS_EmergencyHighTemp_Develop", (tS32)0x1fc95f74L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::s32SetData(tS16 &tGPS_EmergencyHighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_EmergencyHighTemp_Develop,(tVoid*)&tGPS_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::s32SetData(const tS16 &tGPS_EmergencyHighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_EmergencyHighTemp_Develop,(tVoid*)&tGPS_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::u8GetData(tS16& tGPS_EmergencyHighTemp_DevelopParam) {  
   vUpdate();
   tGPS_EmergencyHighTemp_DevelopParam = tGPS_EmergencyHighTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::vSetData(tS16 &tGPS_EmergencyHighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_EmergencyHighTemp_Develop,(tVoid*)&tGPS_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::vSetData(const tS16 &tGPS_EmergencyHighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_EmergencyHighTemp_Develop,(tVoid*)&tGPS_EmergencyHighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_EmergencyHighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_EmergencyHighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_EmergencyHighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_EmergencyHighTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: GPS_EmergencyHighTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element GPS_EmergencyHighTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_EmergencyHigh2HighTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp::dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGPS_EmergencyHigh2HighTemp(850)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/GPSSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("EMERGHIGH2HIGH_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGPS_EmergencyHigh2HighTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp::u8GetData(tS16& tGPS_EmergencyHigh2HighTempParam) {
   vUpdate();
   tGPS_EmergencyHigh2HighTempParam = tGPS_EmergencyHigh2HighTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp::tGetData() {
   vUpdate();
   return tGPS_EmergencyHigh2HighTemp;
};

tU8 dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_EmergencyHigh2HighTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGPS_EmergencyHigh2HighTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("GPS_EmergencyHigh2HighTemp_Develop",(tS32) 0x7ce3e9caL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tGPS_EmergencyHigh2HighTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("GPS_EmergencyHigh2HighTemp_Develop", (tS32)0x7ce3e9caL);
   (tVoid)myDpElem.bFillData((tVoid*)&tGPS_EmergencyHigh2HighTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::tGetData() {
   vUpdate();
   return tGPS_EmergencyHigh2HighTemp_Develop;
};
tS32 dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::s32GetData(tS16& tGPS_EmergencyHigh2HighTemp_DevelopParam) { 
   vUpdate();
   tGPS_EmergencyHigh2HighTemp_DevelopParam = tGPS_EmergencyHigh2HighTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("GPS_EmergencyHigh2HighTemp_Develop", (tS32)0x7ce3e9caL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::s32SetData(tS16 &tGPS_EmergencyHigh2HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_EmergencyHigh2HighTemp_Develop,(tVoid*)&tGPS_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::s32SetData(const tS16 &tGPS_EmergencyHigh2HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_EmergencyHigh2HighTemp_Develop,(tVoid*)&tGPS_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::u8GetData(tS16& tGPS_EmergencyHigh2HighTemp_DevelopParam) {  
   vUpdate();
   tGPS_EmergencyHigh2HighTemp_DevelopParam = tGPS_EmergencyHigh2HighTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::vSetData(tS16 &tGPS_EmergencyHigh2HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_EmergencyHigh2HighTemp_Develop,(tVoid*)&tGPS_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::vSetData(const tS16 &tGPS_EmergencyHigh2HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_EmergencyHigh2HighTemp_Develop,(tVoid*)&tGPS_EmergencyHigh2HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_EmergencyHigh2HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_EmergencyHigh2HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_EmergencyHigh2HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_EmergencyHigh2HighTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: GPS_EmergencyHigh2HighTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element GPS_EmergencyHigh2HighTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_HighTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPGPS_HighTemp::dp_tclHeatCtrlDPGPS_HighTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGPS_HighTemp(800)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPGPS_HighTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/GPSSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("HIGH_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGPS_HighTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPGPS_HighTemp::u8GetData(tS16& tGPS_HighTempParam) {
   vUpdate();
   tGPS_HighTempParam = tGPS_HighTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPGPS_HighTemp::tGetData() {
   vUpdate();
   return tGPS_HighTemp;
};

tU8 dp_tclHeatCtrlDPGPS_HighTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPGPS_HighTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_HighTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPGPS_HighTemp_Develop::dp_tclHeatCtrlDPGPS_HighTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGPS_HighTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPGPS_HighTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("GPS_HighTemp_Develop",(tS32) 0xb089210d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tGPS_HighTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPGPS_HighTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("GPS_HighTemp_Develop", (tS32)0xb089210d);
   (tVoid)myDpElem.bFillData((tVoid*)&tGPS_HighTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPGPS_HighTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPGPS_HighTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPGPS_HighTemp_Develop::tGetData() {
   vUpdate();
   return tGPS_HighTemp_Develop;
};
tS32 dp_tclHeatCtrlDPGPS_HighTemp_Develop::s32GetData(tS16& tGPS_HighTemp_DevelopParam) { 
   vUpdate();
   tGPS_HighTemp_DevelopParam = tGPS_HighTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPGPS_HighTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("GPS_HighTemp_Develop", (tS32)0xb089210d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPGPS_HighTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPGPS_HighTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPGPS_HighTemp_Develop::s32SetData(tS16 &tGPS_HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_HighTemp_Develop,(tVoid*)&tGPS_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_HighTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPGPS_HighTemp_Develop::s32SetData(const tS16 &tGPS_HighTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_HighTemp_Develop,(tVoid*)&tGPS_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_HighTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPGPS_HighTemp_Develop::u8GetData(tS16& tGPS_HighTemp_DevelopParam) {  
   vUpdate();
   tGPS_HighTemp_DevelopParam = tGPS_HighTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPGPS_HighTemp_Develop::vSetData(tS16 &tGPS_HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_HighTemp_Develop,(tVoid*)&tGPS_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_HighTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPGPS_HighTemp_Develop::vSetData(const tS16 &tGPS_HighTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_HighTemp_Develop,(tVoid*)&tGPS_HighTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_HighTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_HighTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPGPS_HighTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPGPS_HighTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_HighTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_HighTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_HighTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: GPS_HighTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element GPS_HighTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_High2WarmTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPGPS_High2WarmTemp::dp_tclHeatCtrlDPGPS_High2WarmTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGPS_High2WarmTemp(800)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPGPS_High2WarmTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/GPSSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("HIGH2WARM_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGPS_High2WarmTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPGPS_High2WarmTemp::u8GetData(tS16& tGPS_High2WarmTempParam) {
   vUpdate();
   tGPS_High2WarmTempParam = tGPS_High2WarmTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPGPS_High2WarmTemp::tGetData() {
   vUpdate();
   return tGPS_High2WarmTemp;
};

tU8 dp_tclHeatCtrlDPGPS_High2WarmTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPGPS_High2WarmTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_High2WarmTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGPS_High2WarmTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("GPS_High2WarmTemp_Develop",(tS32) 0x113cd56e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tGPS_High2WarmTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("GPS_High2WarmTemp_Develop", (tS32)0x113cd56e);
   (tVoid)myDpElem.bFillData((tVoid*)&tGPS_High2WarmTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::tGetData() {
   vUpdate();
   return tGPS_High2WarmTemp_Develop;
};
tS32 dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::s32GetData(tS16& tGPS_High2WarmTemp_DevelopParam) { 
   vUpdate();
   tGPS_High2WarmTemp_DevelopParam = tGPS_High2WarmTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("GPS_High2WarmTemp_Develop", (tS32)0x113cd56e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::s32SetData(tS16 &tGPS_High2WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_High2WarmTemp_Develop,(tVoid*)&tGPS_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::s32SetData(const tS16 &tGPS_High2WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_High2WarmTemp_Develop,(tVoid*)&tGPS_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::u8GetData(tS16& tGPS_High2WarmTemp_DevelopParam) {  
   vUpdate();
   tGPS_High2WarmTemp_DevelopParam = tGPS_High2WarmTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::vSetData(tS16 &tGPS_High2WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_High2WarmTemp_Develop,(tVoid*)&tGPS_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::vSetData(const tS16 &tGPS_High2WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_High2WarmTemp_Develop,(tVoid*)&tGPS_High2WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_High2WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_High2WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_High2WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_High2WarmTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: GPS_High2WarmTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element GPS_High2WarmTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_WarmTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPGPS_WarmTemp::dp_tclHeatCtrlDPGPS_WarmTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGPS_WarmTemp(600)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPGPS_WarmTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/GPSSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("WARM_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGPS_WarmTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPGPS_WarmTemp::u8GetData(tS16& tGPS_WarmTempParam) {
   vUpdate();
   tGPS_WarmTempParam = tGPS_WarmTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPGPS_WarmTemp::tGetData() {
   vUpdate();
   return tGPS_WarmTemp;
};

tU8 dp_tclHeatCtrlDPGPS_WarmTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPGPS_WarmTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_WarmTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPGPS_WarmTemp_Develop::dp_tclHeatCtrlDPGPS_WarmTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGPS_WarmTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPGPS_WarmTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("GPS_WarmTemp_Develop",(tS32) 0x501bcc04);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tGPS_WarmTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPGPS_WarmTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("GPS_WarmTemp_Develop", (tS32)0x501bcc04);
   (tVoid)myDpElem.bFillData((tVoid*)&tGPS_WarmTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPGPS_WarmTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPGPS_WarmTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPGPS_WarmTemp_Develop::tGetData() {
   vUpdate();
   return tGPS_WarmTemp_Develop;
};
tS32 dp_tclHeatCtrlDPGPS_WarmTemp_Develop::s32GetData(tS16& tGPS_WarmTemp_DevelopParam) { 
   vUpdate();
   tGPS_WarmTemp_DevelopParam = tGPS_WarmTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPGPS_WarmTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("GPS_WarmTemp_Develop", (tS32)0x501bcc04);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPGPS_WarmTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPGPS_WarmTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPGPS_WarmTemp_Develop::s32SetData(tS16 &tGPS_WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_WarmTemp_Develop,(tVoid*)&tGPS_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_WarmTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPGPS_WarmTemp_Develop::s32SetData(const tS16 &tGPS_WarmTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_WarmTemp_Develop,(tVoid*)&tGPS_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_WarmTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPGPS_WarmTemp_Develop::u8GetData(tS16& tGPS_WarmTemp_DevelopParam) {  
   vUpdate();
   tGPS_WarmTemp_DevelopParam = tGPS_WarmTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPGPS_WarmTemp_Develop::vSetData(tS16 &tGPS_WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_WarmTemp_Develop,(tVoid*)&tGPS_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_WarmTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPGPS_WarmTemp_Develop::vSetData(const tS16 &tGPS_WarmTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_WarmTemp_Develop,(tVoid*)&tGPS_WarmTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_WarmTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_WarmTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPGPS_WarmTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPGPS_WarmTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_WarmTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_WarmTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_WarmTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: GPS_WarmTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element GPS_WarmTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_Warm2NormalTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPGPS_Warm2NormalTemp::dp_tclHeatCtrlDPGPS_Warm2NormalTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGPS_Warm2NormalTemp(600)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPGPS_Warm2NormalTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/GPSSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("WARM2NORMAL_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGPS_Warm2NormalTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPGPS_Warm2NormalTemp::u8GetData(tS16& tGPS_Warm2NormalTempParam) {
   vUpdate();
   tGPS_Warm2NormalTempParam = tGPS_Warm2NormalTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPGPS_Warm2NormalTemp::tGetData() {
   vUpdate();
   return tGPS_Warm2NormalTemp;
};

tU8 dp_tclHeatCtrlDPGPS_Warm2NormalTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPGPS_Warm2NormalTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_Warm2NormalTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGPS_Warm2NormalTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("GPS_Warm2NormalTemp_Develop",(tS32) 0xed35776bL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tGPS_Warm2NormalTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("GPS_Warm2NormalTemp_Develop", (tS32)0xed35776bL);
   (tVoid)myDpElem.bFillData((tVoid*)&tGPS_Warm2NormalTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::tGetData() {
   vUpdate();
   return tGPS_Warm2NormalTemp_Develop;
};
tS32 dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::s32GetData(tS16& tGPS_Warm2NormalTemp_DevelopParam) { 
   vUpdate();
   tGPS_Warm2NormalTemp_DevelopParam = tGPS_Warm2NormalTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("GPS_Warm2NormalTemp_Develop", (tS32)0xed35776bL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::s32SetData(tS16 &tGPS_Warm2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_Warm2NormalTemp_Develop,(tVoid*)&tGPS_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::s32SetData(const tS16 &tGPS_Warm2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_Warm2NormalTemp_Develop,(tVoid*)&tGPS_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::u8GetData(tS16& tGPS_Warm2NormalTemp_DevelopParam) {  
   vUpdate();
   tGPS_Warm2NormalTemp_DevelopParam = tGPS_Warm2NormalTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::vSetData(tS16 &tGPS_Warm2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_Warm2NormalTemp_Develop,(tVoid*)&tGPS_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::vSetData(const tS16 &tGPS_Warm2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_Warm2NormalTemp_Develop,(tVoid*)&tGPS_Warm2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_Warm2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_Warm2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_Warm2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_Warm2NormalTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: GPS_Warm2NormalTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element GPS_Warm2NormalTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_Cold2NormalTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPGPS_Cold2NormalTemp::dp_tclHeatCtrlDPGPS_Cold2NormalTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGPS_Cold2NormalTemp(-100)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPGPS_Cold2NormalTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/GPSSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("COLD2NORMAL_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGPS_Cold2NormalTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPGPS_Cold2NormalTemp::u8GetData(tS16& tGPS_Cold2NormalTempParam) {
   vUpdate();
   tGPS_Cold2NormalTempParam = tGPS_Cold2NormalTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPGPS_Cold2NormalTemp::tGetData() {
   vUpdate();
   return tGPS_Cold2NormalTemp;
};

tU8 dp_tclHeatCtrlDPGPS_Cold2NormalTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPGPS_Cold2NormalTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_Cold2NormalTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGPS_Cold2NormalTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("GPS_Cold2NormalTemp_Develop",(tS32) 0x1f7b90d2L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tGPS_Cold2NormalTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("GPS_Cold2NormalTemp_Develop", (tS32)0x1f7b90d2L);
   (tVoid)myDpElem.bFillData((tVoid*)&tGPS_Cold2NormalTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::tGetData() {
   vUpdate();
   return tGPS_Cold2NormalTemp_Develop;
};
tS32 dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::s32GetData(tS16& tGPS_Cold2NormalTemp_DevelopParam) { 
   vUpdate();
   tGPS_Cold2NormalTemp_DevelopParam = tGPS_Cold2NormalTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("GPS_Cold2NormalTemp_Develop", (tS32)0x1f7b90d2L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::s32SetData(tS16 &tGPS_Cold2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_Cold2NormalTemp_Develop,(tVoid*)&tGPS_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::s32SetData(const tS16 &tGPS_Cold2NormalTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_Cold2NormalTemp_Develop,(tVoid*)&tGPS_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::u8GetData(tS16& tGPS_Cold2NormalTemp_DevelopParam) {  
   vUpdate();
   tGPS_Cold2NormalTemp_DevelopParam = tGPS_Cold2NormalTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::vSetData(tS16 &tGPS_Cold2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_Cold2NormalTemp_Develop,(tVoid*)&tGPS_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::vSetData(const tS16 &tGPS_Cold2NormalTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_Cold2NormalTemp_Develop,(tVoid*)&tGPS_Cold2NormalTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_Cold2NormalTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_Cold2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_Cold2NormalTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_Cold2NormalTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: GPS_Cold2NormalTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element GPS_Cold2NormalTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_ColdTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPGPS_ColdTemp::dp_tclHeatCtrlDPGPS_ColdTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGPS_ColdTemp(-100)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPGPS_ColdTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/GPSSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("COLD_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGPS_ColdTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPGPS_ColdTemp::u8GetData(tS16& tGPS_ColdTempParam) {
   vUpdate();
   tGPS_ColdTempParam = tGPS_ColdTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPGPS_ColdTemp::tGetData() {
   vUpdate();
   return tGPS_ColdTemp;
};

tU8 dp_tclHeatCtrlDPGPS_ColdTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPGPS_ColdTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_ColdTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPGPS_ColdTemp_Develop::dp_tclHeatCtrlDPGPS_ColdTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGPS_ColdTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPGPS_ColdTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("GPS_ColdTemp_Develop",(tS32) 0xe1f75567);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tGPS_ColdTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPGPS_ColdTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("GPS_ColdTemp_Develop", (tS32)0xe1f75567);
   (tVoid)myDpElem.bFillData((tVoid*)&tGPS_ColdTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPGPS_ColdTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPGPS_ColdTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPGPS_ColdTemp_Develop::tGetData() {
   vUpdate();
   return tGPS_ColdTemp_Develop;
};
tS32 dp_tclHeatCtrlDPGPS_ColdTemp_Develop::s32GetData(tS16& tGPS_ColdTemp_DevelopParam) { 
   vUpdate();
   tGPS_ColdTemp_DevelopParam = tGPS_ColdTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPGPS_ColdTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("GPS_ColdTemp_Develop", (tS32)0xe1f75567);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPGPS_ColdTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPGPS_ColdTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPGPS_ColdTemp_Develop::s32SetData(tS16 &tGPS_ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_ColdTemp_Develop,(tVoid*)&tGPS_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_ColdTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPGPS_ColdTemp_Develop::s32SetData(const tS16 &tGPS_ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_ColdTemp_Develop,(tVoid*)&tGPS_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_ColdTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPGPS_ColdTemp_Develop::u8GetData(tS16& tGPS_ColdTemp_DevelopParam) {  
   vUpdate();
   tGPS_ColdTemp_DevelopParam = tGPS_ColdTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPGPS_ColdTemp_Develop::vSetData(tS16 &tGPS_ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_ColdTemp_Develop,(tVoid*)&tGPS_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_ColdTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPGPS_ColdTemp_Develop::vSetData(const tS16 &tGPS_ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_ColdTemp_Develop,(tVoid*)&tGPS_ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_ColdTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPGPS_ColdTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPGPS_ColdTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_ColdTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_ColdTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: GPS_ColdTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element GPS_ColdTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_Low2ColdTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPGPS_Low2ColdTemp::dp_tclHeatCtrlDPGPS_Low2ColdTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGPS_Low2ColdTemp(-200)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPGPS_Low2ColdTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/GPSSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("LOW2COLD_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGPS_Low2ColdTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPGPS_Low2ColdTemp::u8GetData(tS16& tGPS_Low2ColdTempParam) {
   vUpdate();
   tGPS_Low2ColdTempParam = tGPS_Low2ColdTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPGPS_Low2ColdTemp::tGetData() {
   vUpdate();
   return tGPS_Low2ColdTemp;
};

tU8 dp_tclHeatCtrlDPGPS_Low2ColdTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPGPS_Low2ColdTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_Low2ColdTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGPS_Low2ColdTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("GPS_Low2ColdTemp_Develop",(tS32) 0xbeab14cf);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tGPS_Low2ColdTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("GPS_Low2ColdTemp_Develop", (tS32)0xbeab14cf);
   (tVoid)myDpElem.bFillData((tVoid*)&tGPS_Low2ColdTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::tGetData() {
   vUpdate();
   return tGPS_Low2ColdTemp_Develop;
};
tS32 dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::s32GetData(tS16& tGPS_Low2ColdTemp_DevelopParam) { 
   vUpdate();
   tGPS_Low2ColdTemp_DevelopParam = tGPS_Low2ColdTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("GPS_Low2ColdTemp_Develop", (tS32)0xbeab14cf);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::s32SetData(tS16 &tGPS_Low2ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_Low2ColdTemp_Develop,(tVoid*)&tGPS_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::s32SetData(const tS16 &tGPS_Low2ColdTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_Low2ColdTemp_Develop,(tVoid*)&tGPS_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::u8GetData(tS16& tGPS_Low2ColdTemp_DevelopParam) {  
   vUpdate();
   tGPS_Low2ColdTemp_DevelopParam = tGPS_Low2ColdTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::vSetData(tS16 &tGPS_Low2ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_Low2ColdTemp_Develop,(tVoid*)&tGPS_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::vSetData(const tS16 &tGPS_Low2ColdTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_Low2ColdTemp_Develop,(tVoid*)&tGPS_Low2ColdTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_Low2ColdTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_Low2ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_Low2ColdTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_Low2ColdTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: GPS_Low2ColdTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element GPS_Low2ColdTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_LowTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPGPS_LowTemp::dp_tclHeatCtrlDPGPS_LowTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGPS_LowTemp(-200)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPGPS_LowTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/GPSSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("LOW_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGPS_LowTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPGPS_LowTemp::u8GetData(tS16& tGPS_LowTempParam) {
   vUpdate();
   tGPS_LowTempParam = tGPS_LowTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPGPS_LowTemp::tGetData() {
   vUpdate();
   return tGPS_LowTemp;
};

tU8 dp_tclHeatCtrlDPGPS_LowTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPGPS_LowTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_LowTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPGPS_LowTemp_Develop::dp_tclHeatCtrlDPGPS_LowTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGPS_LowTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPGPS_LowTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("GPS_LowTemp_Develop",(tS32) 0xda13f2d3);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tGPS_LowTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPGPS_LowTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("GPS_LowTemp_Develop", (tS32)0xda13f2d3);
   (tVoid)myDpElem.bFillData((tVoid*)&tGPS_LowTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPGPS_LowTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPGPS_LowTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPGPS_LowTemp_Develop::tGetData() {
   vUpdate();
   return tGPS_LowTemp_Develop;
};
tS32 dp_tclHeatCtrlDPGPS_LowTemp_Develop::s32GetData(tS16& tGPS_LowTemp_DevelopParam) { 
   vUpdate();
   tGPS_LowTemp_DevelopParam = tGPS_LowTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPGPS_LowTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("GPS_LowTemp_Develop", (tS32)0xda13f2d3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPGPS_LowTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPGPS_LowTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPGPS_LowTemp_Develop::s32SetData(tS16 &tGPS_LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_LowTemp_Develop,(tVoid*)&tGPS_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_LowTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPGPS_LowTemp_Develop::s32SetData(const tS16 &tGPS_LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_LowTemp_Develop,(tVoid*)&tGPS_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_LowTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPGPS_LowTemp_Develop::u8GetData(tS16& tGPS_LowTemp_DevelopParam) {  
   vUpdate();
   tGPS_LowTemp_DevelopParam = tGPS_LowTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPGPS_LowTemp_Develop::vSetData(tS16 &tGPS_LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_LowTemp_Develop,(tVoid*)&tGPS_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_LowTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPGPS_LowTemp_Develop::vSetData(const tS16 &tGPS_LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_LowTemp_Develop,(tVoid*)&tGPS_LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_LowTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPGPS_LowTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPGPS_LowTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_LowTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_LowTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: GPS_LowTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element GPS_LowTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_CriticalLow2LowTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp::dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGPS_CriticalLow2LowTemp(-400)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/GPSSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CRITICALLOW2LOW_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGPS_CriticalLow2LowTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp::u8GetData(tS16& tGPS_CriticalLow2LowTempParam) {
   vUpdate();
   tGPS_CriticalLow2LowTempParam = tGPS_CriticalLow2LowTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp::tGetData() {
   vUpdate();
   return tGPS_CriticalLow2LowTemp;
};

tU8 dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_CriticalLow2LowTemp_Develop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGPS_CriticalLow2LowTemp_Develop,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("GPS_CriticalLow2LowTemp_Develop",(tS32) 0xe34ebb4aL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tGPS_CriticalLow2LowTemp_Develop = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("GPS_CriticalLow2LowTemp_Develop", (tS32)0xe34ebb4aL);
   (tVoid)myDpElem.bFillData((tVoid*)&tGPS_CriticalLow2LowTemp_Develop, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::tGetData() {
   vUpdate();
   return tGPS_CriticalLow2LowTemp_Develop;
};
tS32 dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::s32GetData(tS16& tGPS_CriticalLow2LowTemp_DevelopParam) { 
   vUpdate();
   tGPS_CriticalLow2LowTemp_DevelopParam = tGPS_CriticalLow2LowTemp_Develop;
   return _s32Status;
}
tS32 dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("GPS_CriticalLow2LowTemp_Develop", (tS32)0xe34ebb4aL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_HEATCTRLDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::s32SetData(tS16 &tGPS_CriticalLow2LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_CriticalLow2LowTemp_Develop,(tVoid*)&tGPS_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
tS32 dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::s32SetData(const tS16 &tGPS_CriticalLow2LowTemp_DevelopParam) {
   //init parameter
   (tVoid)memcpy(&tGPS_CriticalLow2LowTemp_Develop,(tVoid*)&tGPS_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGPS_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::u8GetData(tS16& tGPS_CriticalLow2LowTemp_DevelopParam) {  
   vUpdate();
   tGPS_CriticalLow2LowTemp_DevelopParam = tGPS_CriticalLow2LowTemp_Develop;
   return _u8DataStatus;
}
tVoid dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::vSetData(tS16 &tGPS_CriticalLow2LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_CriticalLow2LowTemp_Develop,(tVoid*)&tGPS_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
tVoid dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::vSetData(const tS16 &tGPS_CriticalLow2LowTemp_DevelopParam) { 
   //init parameter
   (tVoid)memcpy(&tGPS_CriticalLow2LowTemp_Develop,(tVoid*)&tGPS_CriticalLow2LowTemp_DevelopParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tGPS_CriticalLow2LowTemp_DevelopParam' in function 'dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::vSetData(tS16)' could be made const reference
tU8   dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_CriticalLow2LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_HEATCTRLDP, "GPS_CriticalLow2LowTemp_Develop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclHeatCtrlDPGPS_CriticalLow2LowTemp_Develop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: GPS_CriticalLow2LowTemp_Develop", DP_U32_POOL_ID_HEATCTRLDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_HEATCTRLDP);
   }
   else
   {
      fprintf(stdout,"Element GPS_CriticalLow2LowTemp_Develop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_CriticalLowTemp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclHeatCtrlDPGPS_CriticalLowTemp::dp_tclHeatCtrlDPGPS_CriticalLowTemp() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGPS_CriticalLowTemp(-400)
{
   vUpdate();
}

tVoid dp_tclHeatCtrlDPGPS_CriticalLowTemp::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/PROCHC/FC_HEATCTRL/APP_CONFIG/TS/GPSSENSOR";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CRITICALLOW_TEMP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGPS_CriticalLowTemp = (tS16)u32TmpRegVal;
      }
   }
}

tU8 dp_tclHeatCtrlDPGPS_CriticalLowTemp::u8GetData(tS16& tGPS_CriticalLowTempParam) {
   vUpdate();
   tGPS_CriticalLowTempParam = tGPS_CriticalLowTemp;
   return _u8DataStatus;
}
tS16 dp_tclHeatCtrlDPGPS_CriticalLowTemp::tGetData() {
   vUpdate();
   return tGPS_CriticalLowTemp;
};

tU8 dp_tclHeatCtrlDPGPS_CriticalLowTemp::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclHeatCtrlDPGPS_CriticalLowTemp::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GPS_CriticalLowTemp_Develop"   -------------