#ifndef _DP_FI_DABTUNERUSRDP_H
#define _DP_FI_DABTUNERUSRDP_H

extern tVoid vInitDABTunerUsrDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclDABTunerUsrDPAnnoUserSetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tAnnoUserSetting;
   
public:
   dp_tclDABTunerUsrDPAnnoUserSetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDABTunerUsrDPAnnoUserSetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tAnnoUserSettingParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tAnnoUserSettingParam);
   tS32  s32SetData(const tU16 &tAnnoUserSettingParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tAnnoUserSettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tAnnoUserSettingParam);
   tVoid vSetData(const tU16& tAnnoUserSettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDABTunerUsrDPServiceLinkingMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tServiceLinkingMode;
   
public:
   dp_tclDABTunerUsrDPServiceLinkingMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDABTunerUsrDPServiceLinkingMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tServiceLinkingModeParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tServiceLinkingModeParam);
   tS32  s32SetData(const tU16 &tServiceLinkingModeParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tServiceLinkingModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tServiceLinkingModeParam);
   tVoid vSetData(const tU16& tServiceLinkingModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
