
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclDABTunerUsrDP.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AnnoUserSetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDABTunerUsrDPAnnoUserSetting::dp_tclDABTunerUsrDPAnnoUserSetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0666;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAnnoUserSetting,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDABTunerUsrDPAnnoUserSetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AnnoUserSetting",(tS32) 0x6806eb25);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tAnnoUserSetting = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDABTunerUsrDPAnnoUserSetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AnnoUserSetting", (tS32)0x6806eb25);
   (tVoid)myDpElem.bFillData((tVoid*)&tAnnoUserSetting, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DABTUNERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDABTunerUsrDPAnnoUserSetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDABTunerUsrDPAnnoUserSetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclDABTunerUsrDPAnnoUserSetting::tGetData() {
   vUpdate();
   return tAnnoUserSetting;
};
tS32 dp_tclDABTunerUsrDPAnnoUserSetting::s32GetData(tU16& tAnnoUserSettingParam) { 
   vUpdate();
   tAnnoUserSettingParam = tAnnoUserSetting;
   return _s32Status;
}
tS32 dp_tclDABTunerUsrDPAnnoUserSetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AnnoUserSetting", (tS32)0x6806eb25);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDABTunerUsrDPAnnoUserSetting::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDABTunerUsrDPAnnoUserSetting::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDABTunerUsrDPAnnoUserSetting::s32SetData(tU16 &tAnnoUserSettingParam) {
   //init parameter
   (tVoid)memcpy(&tAnnoUserSetting,(tVoid*)&tAnnoUserSettingParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAnnoUserSettingParam' in function 'dp_tclDABTunerUsrDPAnnoUserSetting::vSetData(tU16)' could be made const reference
tS32 dp_tclDABTunerUsrDPAnnoUserSetting::s32SetData(const tU16 &tAnnoUserSettingParam) {
   //init parameter
   (tVoid)memcpy(&tAnnoUserSetting,(tVoid*)&tAnnoUserSettingParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAnnoUserSettingParam' in function 'dp_tclDABTunerUsrDPAnnoUserSetting::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDABTunerUsrDPAnnoUserSetting::u8GetData(tU16& tAnnoUserSettingParam) {  
   vUpdate();
   tAnnoUserSettingParam = tAnnoUserSetting;
   return _u8DataStatus;
}
tVoid dp_tclDABTunerUsrDPAnnoUserSetting::vSetData(tU16 &tAnnoUserSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tAnnoUserSetting,(tVoid*)&tAnnoUserSettingParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tAnnoUserSettingParam' in function 'dp_tclDABTunerUsrDPAnnoUserSetting::vSetData(tU16)' could be made const reference
tVoid dp_tclDABTunerUsrDPAnnoUserSetting::vSetData(const tU16 &tAnnoUserSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tAnnoUserSetting,(tVoid*)&tAnnoUserSettingParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tAnnoUserSettingParam' in function 'dp_tclDABTunerUsrDPAnnoUserSetting::vSetData(tU16)' could be made const reference
tU8   dp_tclDABTunerUsrDPAnnoUserSetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDABTunerUsrDPAnnoUserSetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DABTUNERUSRDP, "AnnoUserSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerUsrDPAnnoUserSetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DABTUNERUSRDP, "AnnoUserSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerUsrDPAnnoUserSetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AnnoUserSetting", DP_U32_POOL_ID_DABTUNERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DABTUNERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element AnnoUserSetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ServiceLinkingMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDABTunerUsrDPServiceLinkingMode::dp_tclDABTunerUsrDPServiceLinkingMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0666;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tServiceLinkingMode,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDABTunerUsrDPServiceLinkingMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ServiceLinkingMode",(tS32) 0x8f973062);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tServiceLinkingMode = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDABTunerUsrDPServiceLinkingMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ServiceLinkingMode", (tS32)0x8f973062);
   (tVoid)myDpElem.bFillData((tVoid*)&tServiceLinkingMode, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DABTUNERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDABTunerUsrDPServiceLinkingMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDABTunerUsrDPServiceLinkingMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclDABTunerUsrDPServiceLinkingMode::tGetData() {
   vUpdate();
   return tServiceLinkingMode;
};
tS32 dp_tclDABTunerUsrDPServiceLinkingMode::s32GetData(tU16& tServiceLinkingModeParam) { 
   vUpdate();
   tServiceLinkingModeParam = tServiceLinkingMode;
   return _s32Status;
}
tS32 dp_tclDABTunerUsrDPServiceLinkingMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ServiceLinkingMode", (tS32)0x8f973062);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DABTUNERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDABTunerUsrDPServiceLinkingMode::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDABTunerUsrDPServiceLinkingMode::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDABTunerUsrDPServiceLinkingMode::s32SetData(tU16 &tServiceLinkingModeParam) {
   //init parameter
   (tVoid)memcpy(&tServiceLinkingMode,(tVoid*)&tServiceLinkingModeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tServiceLinkingModeParam' in function 'dp_tclDABTunerUsrDPServiceLinkingMode::vSetData(tU16)' could be made const reference
tS32 dp_tclDABTunerUsrDPServiceLinkingMode::s32SetData(const tU16 &tServiceLinkingModeParam) {
   //init parameter
   (tVoid)memcpy(&tServiceLinkingMode,(tVoid*)&tServiceLinkingModeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tServiceLinkingModeParam' in function 'dp_tclDABTunerUsrDPServiceLinkingMode::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDABTunerUsrDPServiceLinkingMode::u8GetData(tU16& tServiceLinkingModeParam) {  
   vUpdate();
   tServiceLinkingModeParam = tServiceLinkingMode;
   return _u8DataStatus;
}
tVoid dp_tclDABTunerUsrDPServiceLinkingMode::vSetData(tU16 &tServiceLinkingModeParam) { 
   //init parameter
   (tVoid)memcpy(&tServiceLinkingMode,(tVoid*)&tServiceLinkingModeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tServiceLinkingModeParam' in function 'dp_tclDABTunerUsrDPServiceLinkingMode::vSetData(tU16)' could be made const reference
tVoid dp_tclDABTunerUsrDPServiceLinkingMode::vSetData(const tU16 &tServiceLinkingModeParam) { 
   //init parameter
   (tVoid)memcpy(&tServiceLinkingMode,(tVoid*)&tServiceLinkingModeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tServiceLinkingModeParam' in function 'dp_tclDABTunerUsrDPServiceLinkingMode::vSetData(tU16)' could be made const reference
tU8   dp_tclDABTunerUsrDPServiceLinkingMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDABTunerUsrDPServiceLinkingMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DABTUNERUSRDP, "ServiceLinkingMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerUsrDPServiceLinkingMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DABTUNERUSRDP, "ServiceLinkingMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDABTunerUsrDPServiceLinkingMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ServiceLinkingMode", DP_U32_POOL_ID_DABTUNERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DABTUNERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element ServiceLinkingMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
