#ifndef _DP_FI_DABTUNERDP_H
#define _DP_FI_DABTUNERDP_H

extern tVoid vInitDABTunerDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclDABTunerDPAnnoUserSetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tAnnoUserSetting;
   
public:
   dp_tclDABTunerDPAnnoUserSetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDABTunerDPAnnoUserSetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tAnnoUserSettingParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tAnnoUserSettingParam);
   tS32  s32SetData(const tU16 &tAnnoUserSettingParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tAnnoUserSettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tAnnoUserSettingParam);
   tVoid vSetData(const tU16& tAnnoUserSettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDABTunerDPServiceLinkingMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tServiceLinkingMode;
   
public:
   dp_tclDABTunerDPServiceLinkingMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDABTunerDPServiceLinkingMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tServiceLinkingModeParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tServiceLinkingModeParam);
   tS32  s32SetData(const tU16 &tServiceLinkingModeParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tServiceLinkingModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tServiceLinkingModeParam);
   tVoid vSetData(const tU16& tServiceLinkingModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDABTunerDPMTCMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tMTCMode;
   
public:
   dp_tclDABTunerDPMTCMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDABTunerDPMTCMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tMTCModeParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tMTCModeParam);
   tS32  s32SetData(const tU16 &tMTCModeParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tMTCModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tMTCModeParam);
   tVoid vSetData(const tU16& tMTCModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDABTunerDPDABAvailability{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tDABAvailability;
   
public:
   dp_tclDABTunerDPDABAvailability(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDABTunerDPDABAvailability() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tDABAvailabilityParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tDABAvailabilityParam);
   tS32  s32SetData(const tBool &tDABAvailabilityParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tDABAvailabilityParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tDABAvailabilityParam);
   tVoid vSetData(const tBool& tDABAvailabilityParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDABTunerDPCountryZone{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tCountryZone;
   
public:
   dp_tclDABTunerDPCountryZone(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDABTunerDPCountryZone() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tCountryZoneParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tCountryZoneParam);
   tS32  s32SetData(const tU16 &tCountryZoneParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tCountryZoneParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tCountryZoneParam);
   tVoid vSetData(const tU16& tCountryZoneParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDABTunerDPRdsStatus{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tRdsStatus;
   
public:
   dp_tclDABTunerDPRdsStatus(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDABTunerDPRdsStatus() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tRdsStatusParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tRdsStatusParam);
   tS32  s32SetData(const tU8 &tRdsStatusParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tRdsStatusParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tRdsStatusParam);
   tVoid vSetData(const tU8& tRdsStatusParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
