
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclDpInternData.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrElements"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDpInternDataTrElements::dp_tclDpInternDataTrElements(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDpInternDataTrElements::s32SetData( tU32* tTrElementsParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("TrElements", (tS32)0xce0fe0f);
   (tVoid)myDpElem.bFillData((tVoid*)tTrElementsParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DPINTERNDATA, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDpInternDataTrElements::s32GetData(tU32* tTrElementsParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("TrElements", (tS32)0xce0fe0f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tTrElementsParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDpInternDataTrElements::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDpInternDataTrElements::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDpInternDataTrElements::u16GetData(tU32* tTrElementsParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tTrElementsParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDpInternDataTrElements::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DPINTERNDATA, "TrElements", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDpInternDataTrElements::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DPINTERNDATA, "TrElements", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDpInternDataTrElements::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrElements", DP_U32_POOL_ID_DPINTERNDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DPINTERNDATA);
		}
		else
		{
			fprintf(stdout,"Element TrElements has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrPools"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDpInternDataTrPools::dp_tclDpInternDataTrPools(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDpInternDataTrPools::s32SetData( tU32* tTrPoolsParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("TrPools", (tS32)0x1a7d77);
   (tVoid)myDpElem.bFillData((tVoid*)tTrPoolsParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DPINTERNDATA, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDpInternDataTrPools::s32GetData(tU32* tTrPoolsParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("TrPools", (tS32)0x1a7d77);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tTrPoolsParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDpInternDataTrPools::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDpInternDataTrPools::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDpInternDataTrPools::u16GetData(tU32* tTrPoolsParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tTrPoolsParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDpInternDataTrPools::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DPINTERNDATA, "TrPools", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDpInternDataTrPools::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DPINTERNDATA, "TrPools", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDpInternDataTrPools::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrPools", DP_U32_POOL_ID_DPINTERNDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DPINTERNDATA);
		}
		else
		{
			fprintf(stdout,"Element TrPools has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 

