
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclDpEndUserMode.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DpEndUserCurrent"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDpEndUserModeDpEndUserCurrent::dp_tclDpEndUserModeDpEndUserCurrent(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDpEndUserCurrent,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDpEndUserModeDpEndUserCurrent::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DpEndUserCurrent",(tS32) 0x96a35491);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DPENDUSERMODE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDpEndUserCurrent = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDpEndUserModeDpEndUserCurrent::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DpEndUserCurrent", (tS32)0x96a35491);
   (tVoid)myDpElem.bFillData((tVoid*)&tDpEndUserCurrent, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DPENDUSERMODE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDpEndUserModeDpEndUserCurrent::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDpEndUserModeDpEndUserCurrent::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDpEndUserModeDpEndUserCurrent::tGetData() {
   vUpdate();
   return tDpEndUserCurrent;
};
tS32 dp_tclDpEndUserModeDpEndUserCurrent::s32GetData(tU8& tDpEndUserCurrentParam) { 
   vUpdate();
   tDpEndUserCurrentParam = tDpEndUserCurrent;
   return _s32Status;
}
tS32 dp_tclDpEndUserModeDpEndUserCurrent::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DpEndUserCurrent", (tS32)0x96a35491);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DPENDUSERMODE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDpEndUserModeDpEndUserCurrent::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDpEndUserModeDpEndUserCurrent::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDpEndUserModeDpEndUserCurrent::s32SetData(tU8 &tDpEndUserCurrentParam) {
   //init parameter
   (tVoid)memcpy(&tDpEndUserCurrent,(tVoid*)&tDpEndUserCurrentParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDpEndUserCurrentParam' in function 'dp_tclDpEndUserModeDpEndUserCurrent::vSetData(tU8)' could be made const reference
tS32 dp_tclDpEndUserModeDpEndUserCurrent::s32SetData(const tU8 &tDpEndUserCurrentParam) {
   //init parameter
   (tVoid)memcpy(&tDpEndUserCurrent,(tVoid*)&tDpEndUserCurrentParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDpEndUserCurrentParam' in function 'dp_tclDpEndUserModeDpEndUserCurrent::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDpEndUserModeDpEndUserCurrent::u8GetData(tU8& tDpEndUserCurrentParam) {  
   vUpdate();
   tDpEndUserCurrentParam = tDpEndUserCurrent;
   return _u8DataStatus;
}
tVoid dp_tclDpEndUserModeDpEndUserCurrent::vSetData(tU8 &tDpEndUserCurrentParam) { 
   //init parameter
   (tVoid)memcpy(&tDpEndUserCurrent,(tVoid*)&tDpEndUserCurrentParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDpEndUserCurrentParam' in function 'dp_tclDpEndUserModeDpEndUserCurrent::vSetData(tU8)' could be made const reference
tVoid dp_tclDpEndUserModeDpEndUserCurrent::vSetData(const tU8 &tDpEndUserCurrentParam) { 
   //init parameter
   (tVoid)memcpy(&tDpEndUserCurrent,(tVoid*)&tDpEndUserCurrentParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDpEndUserCurrentParam' in function 'dp_tclDpEndUserModeDpEndUserCurrent::vSetData(tU8)' could be made const reference
tU8   dp_tclDpEndUserModeDpEndUserCurrent::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDpEndUserModeDpEndUserCurrent::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DPENDUSERMODE, "DpEndUserCurrent", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDpEndUserModeDpEndUserCurrent::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DPENDUSERMODE, "DpEndUserCurrent", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDpEndUserModeDpEndUserCurrent::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DpEndUserCurrent", DP_U32_POOL_ID_DPENDUSERMODE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DPENDUSERMODE);
   }
   else
   {
      fprintf(stdout,"Element DpEndUserCurrent has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DpEndUserUsed"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDpEndUserModeDpEndUserUsed::dp_tclDpEndUserModeDpEndUserUsed(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDpEndUserModeDpEndUserUsed::s32SetData( tU8* tDpEndUserUsedParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("DpEndUserUsed", (tS32)0x5b5135eb);
   (tVoid)myDpElem.bFillData((tVoid*)tDpEndUserUsedParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DPENDUSERMODE, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDpEndUserModeDpEndUserUsed::s32GetData(tU8* tDpEndUserUsedParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("DpEndUserUsed", (tS32)0x5b5135eb);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DPENDUSERMODE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tDpEndUserUsedParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDpEndUserModeDpEndUserUsed::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDpEndUserModeDpEndUserUsed::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDpEndUserModeDpEndUserUsed::u16GetData(tU8* tDpEndUserUsedParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tDpEndUserUsedParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDpEndUserModeDpEndUserUsed::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DPENDUSERMODE, "DpEndUserUsed", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDpEndUserModeDpEndUserUsed::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DPENDUSERMODE, "DpEndUserUsed", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDpEndUserModeDpEndUserUsed::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DpEndUserUsed", DP_U32_POOL_ID_DPENDUSERMODE);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DPENDUSERMODE);
		}
		else
		{
			fprintf(stdout,"Element DpEndUserUsed has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DpEndUserBank"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDpEndUserModeDpEndUserBank::dp_tclDpEndUserModeDpEndUserBank(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDpEndUserModeDpEndUserBank::s32SetData( tU8* tDpEndUserBankParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("DpEndUserBank", (tS32)0x5b512b16);
   (tVoid)myDpElem.bFillData((tVoid*)tDpEndUserBankParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DPENDUSERMODE, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDpEndUserModeDpEndUserBank::s32GetData(tU8* tDpEndUserBankParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("DpEndUserBank", (tS32)0x5b512b16);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DPENDUSERMODE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tDpEndUserBankParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDpEndUserModeDpEndUserBank::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDpEndUserModeDpEndUserBank::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDpEndUserModeDpEndUserBank::u16GetData(tU8* tDpEndUserBankParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tDpEndUserBankParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDpEndUserModeDpEndUserBank::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DPENDUSERMODE, "DpEndUserBank", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDpEndUserModeDpEndUserBank::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DPENDUSERMODE, "DpEndUserBank", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDpEndUserModeDpEndUserBank::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DpEndUserBank", DP_U32_POOL_ID_DPENDUSERMODE);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DPENDUSERMODE);
		}
		else
		{
			fprintf(stdout,"Element DpEndUserBank has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DpEndUserBankUsed"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDpEndUserModeDpEndUserBankUsed::dp_tclDpEndUserModeDpEndUserBankUsed(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDpEndUserModeDpEndUserBankUsed::s32SetData( tU8* tDpEndUserBankUsedParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("DpEndUserBankUsed", (tS32)0xf12a67cf);
   (tVoid)myDpElem.bFillData((tVoid*)tDpEndUserBankUsedParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DPENDUSERMODE, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDpEndUserModeDpEndUserBankUsed::s32GetData(tU8* tDpEndUserBankUsedParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("DpEndUserBankUsed", (tS32)0xf12a67cf);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DPENDUSERMODE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tDpEndUserBankUsedParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDpEndUserModeDpEndUserBankUsed::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDpEndUserModeDpEndUserBankUsed::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDpEndUserModeDpEndUserBankUsed::u16GetData(tU8* tDpEndUserBankUsedParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tDpEndUserBankUsedParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDpEndUserModeDpEndUserBankUsed::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DPENDUSERMODE, "DpEndUserBankUsed", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDpEndUserModeDpEndUserBankUsed::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DPENDUSERMODE, "DpEndUserBankUsed", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDpEndUserModeDpEndUserBankUsed::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DpEndUserBankUsed", DP_U32_POOL_ID_DPENDUSERMODE);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DPENDUSERMODE);
		}
		else
		{
			fprintf(stdout,"Element DpEndUserBankUsed has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 

