
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclCsmEarlyNorConfig.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CsmEarlyNorConfig"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::dp_tclCsmEarlyNorConfigCsmEarlyNorConfig(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0666;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCsmEarlyNorConfig,0,sizeof(TCSMEarlyNorConfiguration));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CsmEarlyNorConfig",(tS32) 0x12568c2d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMEARLYNORCONFIG, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TCSMEarlyNorConfiguration)) 
      {
         tCsmEarlyNorConfig = *((TCSMEarlyNorConfiguration*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CsmEarlyNorConfig", (tS32)0x12568c2d);
   (tVoid)myDpElem.bFillData((tVoid*)&tCsmEarlyNorConfig, (tU32)sizeof(TCSMEarlyNorConfiguration));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CSMEARLYNORCONFIG, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TCSMEarlyNorConfiguration dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::tGetData() {
   vUpdate();
   return tCsmEarlyNorConfig;
};
tS32 dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::s32GetData(TCSMEarlyNorConfiguration& tCsmEarlyNorConfigParam) { 
   vUpdate();
   tCsmEarlyNorConfigParam = tCsmEarlyNorConfig;
   return _s32Status;
}
tS32 dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CsmEarlyNorConfig", (tS32)0x12568c2d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CSMEARLYNORCONFIG, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::operator>>(TCSMEarlyNorConfiguration& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::operator<<(TCSMEarlyNorConfiguration oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::s32SetData(TCSMEarlyNorConfiguration &tCsmEarlyNorConfigParam) {
   //init parameter
   (tVoid)memcpy(&tCsmEarlyNorConfig,(tVoid*)&tCsmEarlyNorConfigParam, sizeof(TCSMEarlyNorConfiguration));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCsmEarlyNorConfigParam' in function 'dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::vSetData(TCSMEarlyNorConfiguration)' could be made const reference
tS32 dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::s32SetData(const TCSMEarlyNorConfiguration &tCsmEarlyNorConfigParam) {
   //init parameter
   (tVoid)memcpy(&tCsmEarlyNorConfig,(tVoid*)&tCsmEarlyNorConfigParam, sizeof(TCSMEarlyNorConfiguration));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCsmEarlyNorConfigParam' in function 'dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::vSetData(TCSMEarlyNorConfiguration)' could be made const reference
// do not use --> old interface
tU8 dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::u8GetData(TCSMEarlyNorConfiguration& tCsmEarlyNorConfigParam) {  
   vUpdate();
   tCsmEarlyNorConfigParam = tCsmEarlyNorConfig;
   return _u8DataStatus;
}
tVoid dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::vSetData(TCSMEarlyNorConfiguration &tCsmEarlyNorConfigParam) { 
   //init parameter
   (tVoid)memcpy(&tCsmEarlyNorConfig,(tVoid*)&tCsmEarlyNorConfigParam, sizeof(TCSMEarlyNorConfiguration));
   vStore();
}//lint !e1746: parameter 'tCsmEarlyNorConfigParam' in function 'dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::vSetData(TCSMEarlyNorConfiguration)' could be made const reference
tVoid dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::vSetData(const TCSMEarlyNorConfiguration &tCsmEarlyNorConfigParam) { 
   //init parameter
   (tVoid)memcpy(&tCsmEarlyNorConfig,(tVoid*)&tCsmEarlyNorConfigParam, sizeof(TCSMEarlyNorConfiguration));
   vStore();
}//lint !e1746: parameter 'tCsmEarlyNorConfigParam' in function 'dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::vSetData(TCSMEarlyNorConfiguration)' could be made const reference
tU8   dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CSMEARLYNORCONFIG, "CsmEarlyNorConfig", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CSMEARLYNORCONFIG, "CsmEarlyNorConfig", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCsmEarlyNorConfigCsmEarlyNorConfig::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CsmEarlyNorConfig", DP_U32_POOL_ID_CSMEARLYNORCONFIG);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CSMEARLYNORCONFIG);
   }
   else
   {
      fprintf(stdout,"Element CsmEarlyNorConfig has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
