#ifndef _DP_FI_AUDIOSTACKMULTIUSRDP_H
#define _DP_FI_AUDIOSTACKMULTIUSRDP_H

extern tVoid vInitAudioStackMultiUsrDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define AUDIOSTACK_S_IMPORT_INTERFACE_DP_AUDIOSTACK 
#include "AMMultiDomainController_if.h"
//lint +e750




class dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class() {};

   //read access for pool element 
   tS32  s32GetData(dpSourceName* tAudioStackMulti_LastSource_ClassParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(dpSourceName* tAudioStackMulti_LastSource_ClassParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(dpSourceName* tAudioStackMulti_LastSource_ClassParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID() {};

   //read access for pool element 
   tS32  s32GetData(tU16* tAudioStackMulti_LastSource_SubIDParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU16* tAudioStackMulti_LastSource_SubIDParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU16* tAudioStackMulti_LastSource_SubIDParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAudioStackMulti_PersistentMute;
   
public:
   dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAudioStackMulti_PersistentMuteParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAudioStackMulti_PersistentMuteParam);
   tS32  s32SetData(const tU8 &tAudioStackMulti_PersistentMuteParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAudioStackMulti_PersistentMuteParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAudioStackMulti_PersistentMuteParam);
   tVoid vSetData(const tU8& tAudioStackMulti_PersistentMuteParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioStackMultiUsrDPNumber_of_Sinks{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tNumber_of_Sinks;
   
public:
   dp_tclAudioStackMultiUsrDPNumber_of_Sinks(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPNumber_of_Sinks() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tNumber_of_SinksParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tNumber_of_SinksParam);
   tS32  s32SetData(const tU8 &tNumber_of_SinksParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tNumber_of_SinksParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tNumber_of_SinksParam);
   tVoid vSetData(const tU8& tNumber_of_SinksParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioStackMultiUsrDPTreble{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPTreble(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPTreble() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tTrebleParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tTrebleParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tTrebleParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPTrebleMic1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPTrebleMic1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPTrebleMic1() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tTrebleMic1Param, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tTrebleMic1Param, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tTrebleMic1Param, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPMixTrebleMic2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPMixTrebleMic2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPMixTrebleMic2() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tMixTrebleMic2Param, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tMixTrebleMic2Param, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tMixTrebleMic2Param, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPMixTrebleMic3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPMixTrebleMic3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPMixTrebleMic3() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tMixTrebleMic3Param, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tMixTrebleMic3Param, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tMixTrebleMic3Param, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPBass{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPBass(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPBass() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tBassParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tBassParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tBassParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPBassMic1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPBassMic1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPBassMic1() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tBassMic1Param, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tBassMic1Param, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tBassMic1Param, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPMixBassMic2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPMixBassMic2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPMixBassMic2() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tMixBassMic2Param, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tMixBassMic2Param, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tMixBassMic2Param, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPMixBassMic3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPMixBassMic3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPMixBassMic3() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tMixBassMic3Param, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tMixBassMic3Param, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tMixBassMic3Param, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPFader{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPFader(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPFader() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tFaderParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tFaderParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tFaderParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPBalance{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPBalance(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPBalance() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tBalanceParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tBalanceParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tBalanceParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPMidRange{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPMidRange(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPMidRange() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tMidRangeParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tMidRangeParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tMidRangeParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPAuxInLevel{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPAuxInLevel(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPAuxInLevel() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tAuxInLevelParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tAuxInLevelParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tAuxInLevelParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPBass_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPBass_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPBass_Max() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tBass_MaxParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tBass_MaxParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tBass_MaxParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPTreble_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPTreble_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPTreble_Max() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tTreble_MaxParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tTreble_MaxParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tTreble_MaxParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPFader_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPFader_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPFader_Max() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tFader_MaxParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tFader_MaxParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tFader_MaxParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPBalance_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPBalance_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPBalance_Max() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tBalance_MaxParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tBalance_MaxParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tBalance_MaxParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPMidRange_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPMidRange_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPMidRange_Max() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tMidRange_MaxParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tMidRange_MaxParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tMidRange_MaxParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPBass_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPBass_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPBass_Min() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tBass_MinParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tBass_MinParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tBass_MinParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPTreble_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPTreble_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPTreble_Min() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tTreble_MinParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tTreble_MinParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tTreble_MinParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPFader_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPFader_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPFader_Min() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tFader_MinParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tFader_MinParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tFader_MinParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPBalance_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPBalance_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPBalance_Min() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tBalance_MinParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tBalance_MinParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tBalance_MinParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiUsrDPMidRange_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiUsrDPMidRange_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiUsrDPMidRange_Min() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tMidRange_MinParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tMidRange_MinParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tMidRange_MinParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

#endif
