
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclAudioStackMultiUsrDP.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AudioStackMulti_LastSource_Class"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class::dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class::s32SetData( dpSourceName* tAudioStackMulti_LastSource_ClassParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("AudioStackMulti_LastSource_Class", (tS32)0xcf7149e0L);
   (tVoid)myDpElem.bFillData((tVoid*)tAudioStackMulti_LastSource_ClassParam, ((tU32)sizeof(dpSourceName))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class::s32GetData(dpSourceName* tAudioStackMulti_LastSource_ClassParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("AudioStackMulti_LastSource_Class", (tS32)0xcf7149e0L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(dpSourceName)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(dpSourceName));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tAudioStackMulti_LastSource_ClassParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(dpSourceName));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class::u16GetData(dpSourceName* tAudioStackMulti_LastSource_ClassParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tAudioStackMulti_LastSource_ClassParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "AudioStackMulti_LastSource_Class", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "AudioStackMulti_LastSource_Class", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_Class::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AudioStackMulti_LastSource_Class", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element AudioStackMulti_LastSource_Class has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AudioStackMulti_LastSource_SubID"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID::dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0446;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID::s32SetData( tU16* tAudioStackMulti_LastSource_SubIDParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("AudioStackMulti_LastSource_SubID", (tS32)0xcf71746dL);
   (tVoid)myDpElem.bFillData((tVoid*)tAudioStackMulti_LastSource_SubIDParam, ((tU32)sizeof(tU16))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID::s32GetData(tU16* tAudioStackMulti_LastSource_SubIDParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("AudioStackMulti_LastSource_SubID", (tS32)0xcf71746dL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU16)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU16));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tAudioStackMulti_LastSource_SubIDParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU16));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID::u16GetData(tU16* tAudioStackMulti_LastSource_SubIDParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tAudioStackMulti_LastSource_SubIDParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "AudioStackMulti_LastSource_SubID", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "AudioStackMulti_LastSource_SubID", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPAudioStackMulti_LastSource_SubID::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AudioStackMulti_LastSource_SubID", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element AudioStackMulti_LastSource_SubID has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AudioStackMulti_PersistentMute"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAudioStackMulti_PersistentMute,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AudioStackMulti_PersistentMute",(tS32) 0xe9cfaedaL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAudioStackMulti_PersistentMute = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AudioStackMulti_PersistentMute", (tS32)0xe9cfaedaL);
   (tVoid)myDpElem.bFillData((tVoid*)&tAudioStackMulti_PersistentMute, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::tGetData() {
   vUpdate();
   return tAudioStackMulti_PersistentMute;
};
tS32 dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::s32GetData(tU8& tAudioStackMulti_PersistentMuteParam) { 
   vUpdate();
   tAudioStackMulti_PersistentMuteParam = tAudioStackMulti_PersistentMute;
   return _s32Status;
}
tS32 dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AudioStackMulti_PersistentMute", (tS32)0xe9cfaedaL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::s32SetData(tU8 &tAudioStackMulti_PersistentMuteParam) {
   //init parameter
   (tVoid)memcpy(&tAudioStackMulti_PersistentMute,(tVoid*)&tAudioStackMulti_PersistentMuteParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioStackMulti_PersistentMuteParam' in function 'dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::s32SetData(const tU8 &tAudioStackMulti_PersistentMuteParam) {
   //init parameter
   (tVoid)memcpy(&tAudioStackMulti_PersistentMute,(tVoid*)&tAudioStackMulti_PersistentMuteParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioStackMulti_PersistentMuteParam' in function 'dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::u8GetData(tU8& tAudioStackMulti_PersistentMuteParam) {  
   vUpdate();
   tAudioStackMulti_PersistentMuteParam = tAudioStackMulti_PersistentMute;
   return _u8DataStatus;
}
tVoid dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::vSetData(tU8 &tAudioStackMulti_PersistentMuteParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioStackMulti_PersistentMute,(tVoid*)&tAudioStackMulti_PersistentMuteParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAudioStackMulti_PersistentMuteParam' in function 'dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::vSetData(const tU8 &tAudioStackMulti_PersistentMuteParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioStackMulti_PersistentMute,(tVoid*)&tAudioStackMulti_PersistentMuteParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAudioStackMulti_PersistentMuteParam' in function 'dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "AudioStackMulti_PersistentMute", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "AudioStackMulti_PersistentMute", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioStackMultiUsrDPAudioStackMulti_PersistentMute::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AudioStackMulti_PersistentMute", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
   }
   else
   {
      fprintf(stdout,"Element AudioStackMulti_PersistentMute has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Number_of_Sinks"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPNumber_of_Sinks::dp_tclAudioStackMultiUsrDPNumber_of_Sinks(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tNumber_of_Sinks,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioStackMultiUsrDPNumber_of_Sinks::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Number_of_Sinks",(tS32) 0xb36355d8);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tNumber_of_Sinks = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioStackMultiUsrDPNumber_of_Sinks::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Number_of_Sinks", (tS32)0xb36355d8);
   (tVoid)myDpElem.bFillData((tVoid*)&tNumber_of_Sinks, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioStackMultiUsrDPNumber_of_Sinks::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioStackMultiUsrDPNumber_of_Sinks::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioStackMultiUsrDPNumber_of_Sinks::tGetData() {
   vUpdate();
   return tNumber_of_Sinks;
};
tS32 dp_tclAudioStackMultiUsrDPNumber_of_Sinks::s32GetData(tU8& tNumber_of_SinksParam) { 
   vUpdate();
   tNumber_of_SinksParam = tNumber_of_Sinks;
   return _s32Status;
}
tS32 dp_tclAudioStackMultiUsrDPNumber_of_Sinks::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Number_of_Sinks", (tS32)0xb36355d8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioStackMultiUsrDPNumber_of_Sinks::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioStackMultiUsrDPNumber_of_Sinks::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioStackMultiUsrDPNumber_of_Sinks::s32SetData(tU8 &tNumber_of_SinksParam) {
   //init parameter
   (tVoid)memcpy(&tNumber_of_Sinks,(tVoid*)&tNumber_of_SinksParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNumber_of_SinksParam' in function 'dp_tclAudioStackMultiUsrDPNumber_of_Sinks::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioStackMultiUsrDPNumber_of_Sinks::s32SetData(const tU8 &tNumber_of_SinksParam) {
   //init parameter
   (tVoid)memcpy(&tNumber_of_Sinks,(tVoid*)&tNumber_of_SinksParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNumber_of_SinksParam' in function 'dp_tclAudioStackMultiUsrDPNumber_of_Sinks::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioStackMultiUsrDPNumber_of_Sinks::u8GetData(tU8& tNumber_of_SinksParam) {  
   vUpdate();
   tNumber_of_SinksParam = tNumber_of_Sinks;
   return _u8DataStatus;
}
tVoid dp_tclAudioStackMultiUsrDPNumber_of_Sinks::vSetData(tU8 &tNumber_of_SinksParam) { 
   //init parameter
   (tVoid)memcpy(&tNumber_of_Sinks,(tVoid*)&tNumber_of_SinksParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tNumber_of_SinksParam' in function 'dp_tclAudioStackMultiUsrDPNumber_of_Sinks::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioStackMultiUsrDPNumber_of_Sinks::vSetData(const tU8 &tNumber_of_SinksParam) { 
   //init parameter
   (tVoid)memcpy(&tNumber_of_Sinks,(tVoid*)&tNumber_of_SinksParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tNumber_of_SinksParam' in function 'dp_tclAudioStackMultiUsrDPNumber_of_Sinks::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioStackMultiUsrDPNumber_of_Sinks::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioStackMultiUsrDPNumber_of_Sinks::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Number_of_Sinks", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioStackMultiUsrDPNumber_of_Sinks::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Number_of_Sinks", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioStackMultiUsrDPNumber_of_Sinks::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Number_of_Sinks", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
   }
   else
   {
      fprintf(stdout,"Element Number_of_Sinks has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Treble"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPTreble::dp_tclAudioStackMultiUsrDPTreble(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPTreble::s32SetData( tS8* tTrebleParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Treble", (tS32)0x5551a);
   (tVoid)myDpElem.bFillData((tVoid*)tTrebleParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPTreble::s32GetData(tS8* tTrebleParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Treble", (tS32)0x5551a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tTrebleParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPTreble::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPTreble::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPTreble::u16GetData(tS8* tTrebleParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tTrebleParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPTreble::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Treble", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPTreble::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Treble", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPTreble::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Treble", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element Treble has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrebleMic1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPTrebleMic1::dp_tclAudioStackMultiUsrDPTrebleMic1(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPTrebleMic1::s32SetData( tS8* tTrebleMic1Param, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("TrebleMic1", (tS32)0xd04f674);
   (tVoid)myDpElem.bFillData((tVoid*)tTrebleMic1Param, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPTrebleMic1::s32GetData(tS8* tTrebleMic1Param, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("TrebleMic1", (tS32)0xd04f674);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tTrebleMic1Param, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPTrebleMic1::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPTrebleMic1::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPTrebleMic1::u16GetData(tS8* tTrebleMic1Param, tU32 u32ArraySize){
       return (tU16) s32GetData(tTrebleMic1Param, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPTrebleMic1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "TrebleMic1", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPTrebleMic1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "TrebleMic1", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPTrebleMic1::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrebleMic1", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element TrebleMic1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MixTrebleMic2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPMixTrebleMic2::dp_tclAudioStackMultiUsrDPMixTrebleMic2(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPMixTrebleMic2::s32SetData( tS8* tMixTrebleMic2Param, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("MixTrebleMic2", (tS32)0xe4f4ce2f);
   (tVoid)myDpElem.bFillData((tVoid*)tMixTrebleMic2Param, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPMixTrebleMic2::s32GetData(tS8* tMixTrebleMic2Param, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("MixTrebleMic2", (tS32)0xe4f4ce2f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tMixTrebleMic2Param, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPMixTrebleMic2::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPMixTrebleMic2::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPMixTrebleMic2::u16GetData(tS8* tMixTrebleMic2Param, tU32 u32ArraySize){
       return (tU16) s32GetData(tMixTrebleMic2Param, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPMixTrebleMic2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "MixTrebleMic2", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPMixTrebleMic2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "MixTrebleMic2", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPMixTrebleMic2::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MixTrebleMic2", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element MixTrebleMic2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MixTrebleMic3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPMixTrebleMic3::dp_tclAudioStackMultiUsrDPMixTrebleMic3(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPMixTrebleMic3::s32SetData( tS8* tMixTrebleMic3Param, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("MixTrebleMic3", (tS32)0xe4f4ce30);
   (tVoid)myDpElem.bFillData((tVoid*)tMixTrebleMic3Param, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPMixTrebleMic3::s32GetData(tS8* tMixTrebleMic3Param, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("MixTrebleMic3", (tS32)0xe4f4ce30);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tMixTrebleMic3Param, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPMixTrebleMic3::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPMixTrebleMic3::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPMixTrebleMic3::u16GetData(tS8* tMixTrebleMic3Param, tU32 u32ArraySize){
       return (tU16) s32GetData(tMixTrebleMic3Param, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPMixTrebleMic3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "MixTrebleMic3", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPMixTrebleMic3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "MixTrebleMic3", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPMixTrebleMic3::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MixTrebleMic3", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element MixTrebleMic3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Bass"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPBass::dp_tclAudioStackMultiUsrDPBass(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPBass::s32SetData( tS8* tBassParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Bass", (tS32)0x2c65);
   (tVoid)myDpElem.bFillData((tVoid*)tBassParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPBass::s32GetData(tS8* tBassParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Bass", (tS32)0x2c65);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBassParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPBass::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPBass::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPBass::u16GetData(tS8* tBassParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBassParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPBass::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Bass", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPBass::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Bass", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPBass::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Bass", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element Bass has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BassMic1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPBassMic1::dp_tclAudioStackMultiUsrDPBassMic1(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPBassMic1::s32SetData( tS8* tBassMic1Param, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("BassMic1", (tS32)0x6c948f);
   (tVoid)myDpElem.bFillData((tVoid*)tBassMic1Param, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPBassMic1::s32GetData(tS8* tBassMic1Param, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("BassMic1", (tS32)0x6c948f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBassMic1Param, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPBassMic1::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPBassMic1::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPBassMic1::u16GetData(tS8* tBassMic1Param, tU32 u32ArraySize){
       return (tU16) s32GetData(tBassMic1Param, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPBassMic1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "BassMic1", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPBassMic1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "BassMic1", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPBassMic1::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BassMic1", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element BassMic1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MixBassMic2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPMixBassMic2::dp_tclAudioStackMultiUsrDPMixBassMic2(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPMixBassMic2::s32SetData( tS8* tMixBassMic2Param, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("MixBassMic2", (tS32)0x3c42f95a);
   (tVoid)myDpElem.bFillData((tVoid*)tMixBassMic2Param, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPMixBassMic2::s32GetData(tS8* tMixBassMic2Param, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("MixBassMic2", (tS32)0x3c42f95a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tMixBassMic2Param, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPMixBassMic2::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPMixBassMic2::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPMixBassMic2::u16GetData(tS8* tMixBassMic2Param, tU32 u32ArraySize){
       return (tU16) s32GetData(tMixBassMic2Param, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPMixBassMic2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "MixBassMic2", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPMixBassMic2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "MixBassMic2", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPMixBassMic2::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MixBassMic2", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element MixBassMic2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MixBassMic3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPMixBassMic3::dp_tclAudioStackMultiUsrDPMixBassMic3(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPMixBassMic3::s32SetData( tS8* tMixBassMic3Param, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("MixBassMic3", (tS32)0x3c42f95b);
   (tVoid)myDpElem.bFillData((tVoid*)tMixBassMic3Param, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPMixBassMic3::s32GetData(tS8* tMixBassMic3Param, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("MixBassMic3", (tS32)0x3c42f95b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tMixBassMic3Param, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPMixBassMic3::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPMixBassMic3::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPMixBassMic3::u16GetData(tS8* tMixBassMic3Param, tU32 u32ArraySize){
       return (tU16) s32GetData(tMixBassMic3Param, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPMixBassMic3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "MixBassMic3", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPMixBassMic3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "MixBassMic3", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPMixBassMic3::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MixBassMic3", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element MixBassMic3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Fader"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPFader::dp_tclAudioStackMultiUsrDPFader(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPFader::s32SetData( tS8* tFaderParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Fader", (tS32)0xe672);
   (tVoid)myDpElem.bFillData((tVoid*)tFaderParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPFader::s32GetData(tS8* tFaderParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Fader", (tS32)0xe672);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tFaderParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPFader::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPFader::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPFader::u16GetData(tS8* tFaderParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tFaderParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPFader::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Fader", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPFader::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Fader", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPFader::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Fader", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element Fader has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Balance"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPBalance::dp_tclAudioStackMultiUsrDPBalance(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPBalance::s32SetData( tS8* tBalanceParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Balance", (tS32)0x15a082);
   (tVoid)myDpElem.bFillData((tVoid*)tBalanceParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPBalance::s32GetData(tS8* tBalanceParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Balance", (tS32)0x15a082);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBalanceParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPBalance::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPBalance::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPBalance::u16GetData(tS8* tBalanceParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBalanceParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPBalance::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Balance", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPBalance::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Balance", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPBalance::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Balance", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element Balance has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MidRange"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPMidRange::dp_tclAudioStackMultiUsrDPMidRange(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPMidRange::s32SetData( tS8* tMidRangeParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("MidRange", (tS32)0x7a9ca3);
   (tVoid)myDpElem.bFillData((tVoid*)tMidRangeParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPMidRange::s32GetData(tS8* tMidRangeParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("MidRange", (tS32)0x7a9ca3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tMidRangeParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPMidRange::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPMidRange::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPMidRange::u16GetData(tS8* tMidRangeParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tMidRangeParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPMidRange::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "MidRange", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPMidRange::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "MidRange", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPMidRange::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MidRange", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element MidRange has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AuxInLevel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPAuxInLevel::dp_tclAudioStackMultiUsrDPAuxInLevel(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPAuxInLevel::s32SetData( tU8* tAuxInLevelParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("AuxInLevel", (tS32)0xaf132b1);
   (tVoid)myDpElem.bFillData((tVoid*)tAuxInLevelParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPAuxInLevel::s32GetData(tU8* tAuxInLevelParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("AuxInLevel", (tS32)0xaf132b1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tAuxInLevelParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPAuxInLevel::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPAuxInLevel::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPAuxInLevel::u16GetData(tU8* tAuxInLevelParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tAuxInLevelParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPAuxInLevel::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "AuxInLevel", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPAuxInLevel::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "AuxInLevel", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPAuxInLevel::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AuxInLevel", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element AuxInLevel has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Bass_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPBass_Max::dp_tclAudioStackMultiUsrDPBass_Max(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPBass_Max::s32SetData( tS8* tBass_MaxParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Bass_Max", (tS32)0x6c9ada);
   (tVoid)myDpElem.bFillData((tVoid*)tBass_MaxParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPBass_Max::s32GetData(tS8* tBass_MaxParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Bass_Max", (tS32)0x6c9ada);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBass_MaxParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPBass_Max::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPBass_Max::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPBass_Max::u16GetData(tS8* tBass_MaxParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBass_MaxParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPBass_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Bass_Max", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPBass_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Bass_Max", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPBass_Max::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Bass_Max", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element Bass_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Treble_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPTreble_Max::dp_tclAudioStackMultiUsrDPTreble_Max(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPTreble_Max::s32SetData( tS8* tTreble_MaxParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Treble_Max", (tS32)0xd04fcbf);
   (tVoid)myDpElem.bFillData((tVoid*)tTreble_MaxParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPTreble_Max::s32GetData(tS8* tTreble_MaxParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Treble_Max", (tS32)0xd04fcbf);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tTreble_MaxParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPTreble_Max::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPTreble_Max::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPTreble_Max::u16GetData(tS8* tTreble_MaxParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tTreble_MaxParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPTreble_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Treble_Max", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPTreble_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Treble_Max", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPTreble_Max::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Treble_Max", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element Treble_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Fader_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPFader_Max::dp_tclAudioStackMultiUsrDPFader_Max(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPFader_Max::s32SetData( tS8* tFader_MaxParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Fader_Max", (tS32)0x232d497);
   (tVoid)myDpElem.bFillData((tVoid*)tFader_MaxParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPFader_Max::s32GetData(tS8* tFader_MaxParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Fader_Max", (tS32)0x232d497);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tFader_MaxParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPFader_Max::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPFader_Max::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPFader_Max::u16GetData(tS8* tFader_MaxParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tFader_MaxParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPFader_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Fader_Max", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPFader_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Fader_Max", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPFader_Max::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Fader_Max", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element Fader_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Balance_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPBalance_Max::dp_tclAudioStackMultiUsrDPBalance_Max(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPBalance_Max::s32SetData( tS8* tBalance_MaxParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Balance_Max", (tS32)0x34cd15a7);
   (tVoid)myDpElem.bFillData((tVoid*)tBalance_MaxParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPBalance_Max::s32GetData(tS8* tBalance_MaxParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Balance_Max", (tS32)0x34cd15a7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBalance_MaxParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPBalance_Max::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPBalance_Max::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPBalance_Max::u16GetData(tS8* tBalance_MaxParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBalance_MaxParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPBalance_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Balance_Max", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPBalance_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Balance_Max", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPBalance_Max::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Balance_Max", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element Balance_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MidRange_Max"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPMidRange_Max::dp_tclAudioStackMultiUsrDPMidRange_Max(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPMidRange_Max::s32SetData( tS8* tMidRange_MaxParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("MidRange_Max", (tS32)0x2b58a238);
   (tVoid)myDpElem.bFillData((tVoid*)tMidRange_MaxParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPMidRange_Max::s32GetData(tS8* tMidRange_MaxParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("MidRange_Max", (tS32)0x2b58a238);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tMidRange_MaxParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPMidRange_Max::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPMidRange_Max::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPMidRange_Max::u16GetData(tS8* tMidRange_MaxParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tMidRange_MaxParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPMidRange_Max::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "MidRange_Max", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPMidRange_Max::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "MidRange_Max", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPMidRange_Max::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MidRange_Max", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element MidRange_Max has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Bass_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPBass_Min::dp_tclAudioStackMultiUsrDPBass_Min(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPBass_Min::s32SetData( tS8* tBass_MinParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Bass_Min", (tS32)0x6c9af8);
   (tVoid)myDpElem.bFillData((tVoid*)tBass_MinParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPBass_Min::s32GetData(tS8* tBass_MinParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Bass_Min", (tS32)0x6c9af8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBass_MinParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPBass_Min::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPBass_Min::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPBass_Min::u16GetData(tS8* tBass_MinParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBass_MinParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPBass_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Bass_Min", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPBass_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Bass_Min", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPBass_Min::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Bass_Min", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element Bass_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Treble_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPTreble_Min::dp_tclAudioStackMultiUsrDPTreble_Min(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPTreble_Min::s32SetData( tS8* tTreble_MinParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Treble_Min", (tS32)0xd04fcdd);
   (tVoid)myDpElem.bFillData((tVoid*)tTreble_MinParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPTreble_Min::s32GetData(tS8* tTreble_MinParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Treble_Min", (tS32)0xd04fcdd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tTreble_MinParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPTreble_Min::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPTreble_Min::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPTreble_Min::u16GetData(tS8* tTreble_MinParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tTreble_MinParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPTreble_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Treble_Min", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPTreble_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Treble_Min", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPTreble_Min::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Treble_Min", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element Treble_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Fader_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPFader_Min::dp_tclAudioStackMultiUsrDPFader_Min(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPFader_Min::s32SetData( tS8* tFader_MinParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Fader_Min", (tS32)0x232d4b5);
   (tVoid)myDpElem.bFillData((tVoid*)tFader_MinParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPFader_Min::s32GetData(tS8* tFader_MinParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Fader_Min", (tS32)0x232d4b5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tFader_MinParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPFader_Min::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPFader_Min::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPFader_Min::u16GetData(tS8* tFader_MinParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tFader_MinParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPFader_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Fader_Min", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPFader_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Fader_Min", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPFader_Min::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Fader_Min", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element Fader_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Balance_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPBalance_Min::dp_tclAudioStackMultiUsrDPBalance_Min(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPBalance_Min::s32SetData( tS8* tBalance_MinParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("Balance_Min", (tS32)0x34cd15c5);
   (tVoid)myDpElem.bFillData((tVoid*)tBalance_MinParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPBalance_Min::s32GetData(tS8* tBalance_MinParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("Balance_Min", (tS32)0x34cd15c5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBalance_MinParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPBalance_Min::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPBalance_Min::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPBalance_Min::u16GetData(tS8* tBalance_MinParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBalance_MinParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPBalance_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Balance_Min", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPBalance_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "Balance_Min", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPBalance_Min::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Balance_Min", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element Balance_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MidRange_Min"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioStackMultiUsrDPMidRange_Min::dp_tclAudioStackMultiUsrDPMidRange_Min(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioStackMultiUsrDPMidRange_Min::s32SetData( tS8* tMidRange_MinParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("MidRange_Min", (tS32)0x2b58a256);
   (tVoid)myDpElem.bFillData((tVoid*)tMidRange_MinParam, ((tU32)sizeof(tS8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioStackMultiUsrDPMidRange_Min::s32GetData(tS8* tMidRange_MinParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("MidRange_Min", (tS32)0x2b58a256);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tS8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tS8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tMidRange_MinParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tS8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioStackMultiUsrDPMidRange_Min::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioStackMultiUsrDPMidRange_Min::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioStackMultiUsrDPMidRange_Min::u16GetData(tS8* tMidRange_MinParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tMidRange_MinParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioStackMultiUsrDPMidRange_Min::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "MidRange_Min", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioStackMultiUsrDPMidRange_Min::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP, "MidRange_Min", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioStackMultiUsrDPMidRange_Min::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MidRange_Min", DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOSTACKMULTIUSRDP);
		}
		else
		{
			fprintf(stdout,"Element MidRange_Min has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 

