#ifndef _DP_FI_AUDIOSTACKMULTIDP_H
#define _DP_FI_AUDIOSTACKMULTIDP_H

extern tVoid vInitAudioStackMultiDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define AUDIOSTACK_S_IMPORT_INTERFACE_DP_AUDIOSTACK 
#include "AMMultiDomainController_if.h"
//lint +e750




class dp_tclAudioStackMultiDPAudioStack_LastSource_Class{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPAudioStack_LastSource_Class(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPAudioStack_LastSource_Class() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tAudioStack_LastSource_ClassParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tAudioStack_LastSource_ClassParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tAudioStack_LastSource_ClassParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPAudioStack_LastSource_SubID{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPAudioStack_LastSource_SubID(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPAudioStack_LastSource_SubID() {};

   //read access for pool element 
   tS32  s32GetData(tU16* tAudioStack_LastSource_SubIDParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU16* tAudioStack_LastSource_SubIDParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU16* tAudioStack_LastSource_SubIDParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPAudioStack_PersistentMute{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAudioStack_PersistentMute;
   
public:
   dp_tclAudioStackMultiDPAudioStack_PersistentMute(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPAudioStack_PersistentMute() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAudioStack_PersistentMuteParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAudioStack_PersistentMuteParam);
   tS32  s32SetData(const tU8 &tAudioStack_PersistentMuteParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAudioStack_PersistentMuteParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAudioStack_PersistentMuteParam);
   tVoid vSetData(const tU8& tAudioStack_PersistentMuteParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioStackMultiDPPrivateMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tPrivateMode;
   
public:
   dp_tclAudioStackMultiDPPrivateMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPPrivateMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tPrivateModeParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tPrivateModeParam);
   tS32  s32SetData(const tU16 &tPrivateModeParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tPrivateModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tPrivateModeParam);
   tVoid vSetData(const tU16& tPrivateModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioStackMultiDPPrivateModeMixVolume{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPPrivateModeMixVolume(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPPrivateModeMixVolume() {};

   //read access for pool element 
   tS32  s32GetData(tU16* tPrivateModeMixVolumeParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU16* tPrivateModeMixVolumeParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU16* tPrivateModeMixVolumeParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPNumber_of_Sinks{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tNumber_of_Sinks;
   
public:
   dp_tclAudioStackMultiDPNumber_of_Sinks(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPNumber_of_Sinks() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tNumber_of_SinksParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tNumber_of_SinksParam);
   tS32  s32SetData(const tU8 &tNumber_of_SinksParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tNumber_of_SinksParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tNumber_of_SinksParam);
   tVoid vSetData(const tU8& tNumber_of_SinksParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioStackMultiDPTreble{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPTreble(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPTreble() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tTrebleParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tTrebleParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tTrebleParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPTrebleMic1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPTrebleMic1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPTrebleMic1() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tTrebleMic1Param, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tTrebleMic1Param, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tTrebleMic1Param, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPMixTrebleMic2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPMixTrebleMic2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPMixTrebleMic2() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tMixTrebleMic2Param, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tMixTrebleMic2Param, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tMixTrebleMic2Param, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPMixTrebleMic3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPMixTrebleMic3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPMixTrebleMic3() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tMixTrebleMic3Param, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tMixTrebleMic3Param, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tMixTrebleMic3Param, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPBass{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPBass(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPBass() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tBassParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tBassParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tBassParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPBassMic1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPBassMic1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPBassMic1() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tBassMic1Param, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tBassMic1Param, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tBassMic1Param, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPMixBassMic2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPMixBassMic2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPMixBassMic2() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tMixBassMic2Param, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tMixBassMic2Param, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tMixBassMic2Param, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPMixBassMic3{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPMixBassMic3(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPMixBassMic3() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tMixBassMic3Param, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tMixBassMic3Param, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tMixBassMic3Param, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPFader{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPFader(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPFader() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tFaderParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tFaderParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tFaderParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPBalance{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPBalance(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPBalance() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tBalanceParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tBalanceParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tBalanceParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPMidRange{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPMidRange(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPMidRange() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tMidRangeParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tMidRangeParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tMidRangeParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPAuxInLevel{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPAuxInLevel(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPAuxInLevel() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tAuxInLevelParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tAuxInLevelParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tAuxInLevelParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPBass_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPBass_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPBass_Max() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tBass_MaxParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tBass_MaxParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tBass_MaxParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPTreble_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPTreble_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPTreble_Max() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tTreble_MaxParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tTreble_MaxParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tTreble_MaxParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPFader_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPFader_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPFader_Max() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tFader_MaxParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tFader_MaxParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tFader_MaxParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPBalance_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPBalance_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPBalance_Max() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tBalance_MaxParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tBalance_MaxParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tBalance_MaxParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPMidRange_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPMidRange_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPMidRange_Max() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tMidRange_MaxParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tMidRange_MaxParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tMidRange_MaxParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPBass_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPBass_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPBass_Min() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tBass_MinParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tBass_MinParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tBass_MinParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPTreble_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPTreble_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPTreble_Min() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tTreble_MinParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tTreble_MinParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tTreble_MinParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPFader_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPFader_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPFader_Min() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tFader_MinParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tFader_MinParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tFader_MinParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPBalance_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPBalance_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPBalance_Min() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tBalance_MinParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tBalance_MinParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tBalance_MinParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPMidRange_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPMidRange_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPMidRange_Min() {};

   //read access for pool element 
   tS32  s32GetData(tS8* tMidRange_MinParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tS8* tMidRange_MinParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tS8* tMidRange_MinParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPOnVolume_Max{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPOnVolume_Max(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPOnVolume_Max() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tOnVolume_MaxParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tOnVolume_MaxParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tOnVolume_MaxParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPOnVolume_Min{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPOnVolume_Min(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPOnVolume_Min() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tOnVolume_MinParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tOnVolume_MinParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tOnVolume_MinParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPgroup_volume_list_for_amp_a{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPgroup_volume_list_for_amp_a(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPgroup_volume_list_for_amp_a() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tgroup_volume_list_for_amp_aParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tgroup_volume_list_for_amp_aParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tgroup_volume_list_for_amp_aParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioStackMultiDPgroup_volume_list_for_amp_b{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioStackMultiDPgroup_volume_list_for_amp_b(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackMultiDPgroup_volume_list_for_amp_b() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tgroup_volume_list_for_amp_bParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tgroup_volume_list_for_amp_bParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tgroup_volume_list_for_amp_bParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

#endif
