#ifndef _DP_FI_AUDIOSTACKDP_H
#define _DP_FI_AUDIOSTACKDP_H

extern tVoid vInitAudioStackDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclAudioStackDPAudioStack_LastSource_Class{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAudioStack_LastSource_Class;
   
public:
   dp_tclAudioStackDPAudioStack_LastSource_Class(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackDPAudioStack_LastSource_Class() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAudioStack_LastSource_ClassParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAudioStack_LastSource_ClassParam);
   tS32  s32SetData(const tU8 &tAudioStack_LastSource_ClassParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAudioStack_LastSource_ClassParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAudioStack_LastSource_ClassParam);
   tVoid vSetData(const tU8& tAudioStack_LastSource_ClassParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioStackDPAudioStack_LastSource_SubID{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tAudioStack_LastSource_SubID;
   
public:
   dp_tclAudioStackDPAudioStack_LastSource_SubID(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackDPAudioStack_LastSource_SubID() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tAudioStack_LastSource_SubIDParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tAudioStack_LastSource_SubIDParam);
   tS32  s32SetData(const tU16 &tAudioStack_LastSource_SubIDParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tAudioStack_LastSource_SubIDParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tAudioStack_LastSource_SubIDParam);
   tVoid vSetData(const tU16& tAudioStack_LastSource_SubIDParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioStackDPAudioStack_LastTunerSource_Class{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAudioStack_LastTunerSource_Class;
   
public:
   dp_tclAudioStackDPAudioStack_LastTunerSource_Class(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackDPAudioStack_LastTunerSource_Class() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAudioStack_LastTunerSource_ClassParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAudioStack_LastTunerSource_ClassParam);
   tS32  s32SetData(const tU8 &tAudioStack_LastTunerSource_ClassParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAudioStack_LastTunerSource_ClassParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAudioStack_LastTunerSource_ClassParam);
   tVoid vSetData(const tU8& tAudioStack_LastTunerSource_ClassParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioStackDPAudioStack_LastTunerSource_SubID{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tAudioStack_LastTunerSource_SubID;
   
public:
   dp_tclAudioStackDPAudioStack_LastTunerSource_SubID(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackDPAudioStack_LastTunerSource_SubID() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tAudioStack_LastTunerSource_SubIDParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tAudioStack_LastTunerSource_SubIDParam);
   tS32  s32SetData(const tU16 &tAudioStack_LastTunerSource_SubIDParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tAudioStack_LastTunerSource_SubIDParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tAudioStack_LastTunerSource_SubIDParam);
   tVoid vSetData(const tU16& tAudioStack_LastTunerSource_SubIDParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioStackDPAudioStack_PersistentMute{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAudioStack_PersistentMute;
   
public:
   dp_tclAudioStackDPAudioStack_PersistentMute(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioStackDPAudioStack_PersistentMute() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAudioStack_PersistentMuteParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAudioStack_PersistentMuteParam);
   tS32  s32SetData(const tU8 &tAudioStack_PersistentMuteParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAudioStack_PersistentMuteParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAudioStack_PersistentMuteParam);
   tVoid vSetData(const tU8& tAudioStack_PersistentMuteParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
