#ifndef _DP_FI_FC_STCDP_H
#define _DP_FI_FC_STCDP_H

extern tVoid vInitFC_STCDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclFC_STCDPSECURE_TIME{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU64 tSECURE_TIME;
   
public:
   dp_tclFC_STCDPSECURE_TIME(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFC_STCDPSECURE_TIME() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU64 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU64& tSECURE_TIMEParam);
   tVoid operator>>(tU64& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU64 &tSECURE_TIMEParam);
   tS32  s32SetData(const tU64 &tSECURE_TIMEParam);
   tVoid operator<<(tU64 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU64& tSECURE_TIMEParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU64& tSECURE_TIMEParam);
   tVoid vSetData(const tU64& tSECURE_TIMEParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclFC_STCDPCPT_TEMPOREL_TIME{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU64 tCPT_TEMPOREL_TIME;
   
public:
   dp_tclFC_STCDPCPT_TEMPOREL_TIME(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclFC_STCDPCPT_TEMPOREL_TIME() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU64 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU64& tCPT_TEMPOREL_TIMEParam);
   tVoid operator>>(tU64& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU64 &tCPT_TEMPOREL_TIMEParam);
   tS32  s32SetData(const tU64 &tCPT_TEMPOREL_TIMEParam);
   tVoid operator<<(tU64 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU64& tCPT_TEMPOREL_TIMEParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU64& tCPT_TEMPOREL_TIMEParam);
   tVoid vSetData(const tU64& tCPT_TEMPOREL_TIMEParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
