
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclFC_STCDP.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SECURE_TIME"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFC_STCDPSECURE_TIME::dp_tclFC_STCDPSECURE_TIME(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSECURE_TIME,0,sizeof(tU64));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFC_STCDPSECURE_TIME::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SECURE_TIME",(tS32) 0x3a64f1cd);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_STCDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU64)) 
      {
         tSECURE_TIME = *((tU64*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFC_STCDPSECURE_TIME::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SECURE_TIME", (tS32)0x3a64f1cd);
   (tVoid)myDpElem.bFillData((tVoid*)&tSECURE_TIME, (tU32)sizeof(tU64));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FC_STCDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFC_STCDPSECURE_TIME::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFC_STCDPSECURE_TIME::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU64 dp_tclFC_STCDPSECURE_TIME::tGetData() {
   vUpdate();
   return tSECURE_TIME;
};
tS32 dp_tclFC_STCDPSECURE_TIME::s32GetData(tU64& tSECURE_TIMEParam) { 
   vUpdate();
   tSECURE_TIMEParam = tSECURE_TIME;
   return _s32Status;
}
tS32 dp_tclFC_STCDPSECURE_TIME::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SECURE_TIME", (tS32)0x3a64f1cd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_STCDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFC_STCDPSECURE_TIME::operator>>(tU64& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFC_STCDPSECURE_TIME::operator<<(tU64 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFC_STCDPSECURE_TIME::s32SetData(tU64 &tSECURE_TIMEParam) {
   //init parameter
   (tVoid)memcpy(&tSECURE_TIME,(tVoid*)&tSECURE_TIMEParam, sizeof(tU64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSECURE_TIMEParam' in function 'dp_tclFC_STCDPSECURE_TIME::vSetData(tU64)' could be made const reference
tS32 dp_tclFC_STCDPSECURE_TIME::s32SetData(const tU64 &tSECURE_TIMEParam) {
   //init parameter
   (tVoid)memcpy(&tSECURE_TIME,(tVoid*)&tSECURE_TIMEParam, sizeof(tU64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSECURE_TIMEParam' in function 'dp_tclFC_STCDPSECURE_TIME::vSetData(tU64)' could be made const reference
// do not use --> old interface
tU8 dp_tclFC_STCDPSECURE_TIME::u8GetData(tU64& tSECURE_TIMEParam) {  
   vUpdate();
   tSECURE_TIMEParam = tSECURE_TIME;
   return _u8DataStatus;
}
tVoid dp_tclFC_STCDPSECURE_TIME::vSetData(tU64 &tSECURE_TIMEParam) { 
   //init parameter
   (tVoid)memcpy(&tSECURE_TIME,(tVoid*)&tSECURE_TIMEParam, sizeof(tU64));
   vStore();
}//lint !e1746: parameter 'tSECURE_TIMEParam' in function 'dp_tclFC_STCDPSECURE_TIME::vSetData(tU64)' could be made const reference
tVoid dp_tclFC_STCDPSECURE_TIME::vSetData(const tU64 &tSECURE_TIMEParam) { 
   //init parameter
   (tVoid)memcpy(&tSECURE_TIME,(tVoid*)&tSECURE_TIMEParam, sizeof(tU64));
   vStore();
}//lint !e1746: parameter 'tSECURE_TIMEParam' in function 'dp_tclFC_STCDPSECURE_TIME::vSetData(tU64)' could be made const reference
tU8   dp_tclFC_STCDPSECURE_TIME::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFC_STCDPSECURE_TIME::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FC_STCDP, "SECURE_TIME", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFC_STCDPSECURE_TIME::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FC_STCDP, "SECURE_TIME", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFC_STCDPSECURE_TIME::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SECURE_TIME", DP_U32_POOL_ID_FC_STCDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FC_STCDP);
   }
   else
   {
      fprintf(stdout,"Element SECURE_TIME has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CPT_TEMPOREL_TIME"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclFC_STCDPCPT_TEMPOREL_TIME::dp_tclFC_STCDPCPT_TEMPOREL_TIME(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCPT_TEMPOREL_TIME,0,sizeof(tU64));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclFC_STCDPCPT_TEMPOREL_TIME::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CPT_TEMPOREL_TIME",(tS32) 0xe76606c8);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_STCDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU64)) 
      {
         tCPT_TEMPOREL_TIME = *((tU64*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclFC_STCDPCPT_TEMPOREL_TIME::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CPT_TEMPOREL_TIME", (tS32)0xe76606c8);
   (tVoid)myDpElem.bFillData((tVoid*)&tCPT_TEMPOREL_TIME, (tU32)sizeof(tU64));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FC_STCDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclFC_STCDPCPT_TEMPOREL_TIME::s32GetStatus() const {return _s32Status;};
tU8   dp_tclFC_STCDPCPT_TEMPOREL_TIME::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU64 dp_tclFC_STCDPCPT_TEMPOREL_TIME::tGetData() {
   vUpdate();
   return tCPT_TEMPOREL_TIME;
};
tS32 dp_tclFC_STCDPCPT_TEMPOREL_TIME::s32GetData(tU64& tCPT_TEMPOREL_TIMEParam) { 
   vUpdate();
   tCPT_TEMPOREL_TIMEParam = tCPT_TEMPOREL_TIME;
   return _s32Status;
}
tS32 dp_tclFC_STCDPCPT_TEMPOREL_TIME::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CPT_TEMPOREL_TIME", (tS32)0xe76606c8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_STCDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclFC_STCDPCPT_TEMPOREL_TIME::operator>>(tU64& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclFC_STCDPCPT_TEMPOREL_TIME::operator<<(tU64 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclFC_STCDPCPT_TEMPOREL_TIME::s32SetData(tU64 &tCPT_TEMPOREL_TIMEParam) {
   //init parameter
   (tVoid)memcpy(&tCPT_TEMPOREL_TIME,(tVoid*)&tCPT_TEMPOREL_TIMEParam, sizeof(tU64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCPT_TEMPOREL_TIMEParam' in function 'dp_tclFC_STCDPCPT_TEMPOREL_TIME::vSetData(tU64)' could be made const reference
tS32 dp_tclFC_STCDPCPT_TEMPOREL_TIME::s32SetData(const tU64 &tCPT_TEMPOREL_TIMEParam) {
   //init parameter
   (tVoid)memcpy(&tCPT_TEMPOREL_TIME,(tVoid*)&tCPT_TEMPOREL_TIMEParam, sizeof(tU64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCPT_TEMPOREL_TIMEParam' in function 'dp_tclFC_STCDPCPT_TEMPOREL_TIME::vSetData(tU64)' could be made const reference
// do not use --> old interface
tU8 dp_tclFC_STCDPCPT_TEMPOREL_TIME::u8GetData(tU64& tCPT_TEMPOREL_TIMEParam) {  
   vUpdate();
   tCPT_TEMPOREL_TIMEParam = tCPT_TEMPOREL_TIME;
   return _u8DataStatus;
}
tVoid dp_tclFC_STCDPCPT_TEMPOREL_TIME::vSetData(tU64 &tCPT_TEMPOREL_TIMEParam) { 
   //init parameter
   (tVoid)memcpy(&tCPT_TEMPOREL_TIME,(tVoid*)&tCPT_TEMPOREL_TIMEParam, sizeof(tU64));
   vStore();
}//lint !e1746: parameter 'tCPT_TEMPOREL_TIMEParam' in function 'dp_tclFC_STCDPCPT_TEMPOREL_TIME::vSetData(tU64)' could be made const reference
tVoid dp_tclFC_STCDPCPT_TEMPOREL_TIME::vSetData(const tU64 &tCPT_TEMPOREL_TIMEParam) { 
   //init parameter
   (tVoid)memcpy(&tCPT_TEMPOREL_TIME,(tVoid*)&tCPT_TEMPOREL_TIMEParam, sizeof(tU64));
   vStore();
}//lint !e1746: parameter 'tCPT_TEMPOREL_TIMEParam' in function 'dp_tclFC_STCDPCPT_TEMPOREL_TIME::vSetData(tU64)' could be made const reference
tU8   dp_tclFC_STCDPCPT_TEMPOREL_TIME::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclFC_STCDPCPT_TEMPOREL_TIME::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FC_STCDP, "CPT_TEMPOREL_TIME", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFC_STCDPCPT_TEMPOREL_TIME::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FC_STCDP, "CPT_TEMPOREL_TIME", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclFC_STCDPCPT_TEMPOREL_TIME::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CPT_TEMPOREL_TIME", DP_U32_POOL_ID_FC_STCDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FC_STCDP);
   }
   else
   {
      fprintf(stdout,"Element CPT_TEMPOREL_TIME has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
