#ifndef _DP_FI_CONFIGMANAGERLOCALDATA_H
#define _DP_FI_CONFIGMANAGERLOCALDATA_H

extern tVoid vInitConfigManagerLocalData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define CFGMGR_S_IMPORT_INTERFACE_DP_CONFIGMANAGER 
#include "../../di_middleware_server/components/cfgmgr/config/datapool/cfgmgr_dpif.h"
//lint +e750




class dp_tclConfigManagerLocalDataURL{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   PublicItem_T tURL;
   
public:
   dp_tclConfigManagerLocalDataURL(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclConfigManagerLocalDataURL() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   PublicItem_T tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(PublicItem_T& tURLParam);
   tVoid operator>>(PublicItem_T& oParam);
   
   //write access for pool element 
   tS32  s32SetData(PublicItem_T &tURLParam);
   tS32  s32SetData(const PublicItem_T &tURLParam);
   tVoid operator<<(PublicItem_T oParam);
   
   // do not use --> old interface
   tU8   u8GetData(PublicItem_T& tURLParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(PublicItem_T& tURLParam);
   tVoid vSetData(const PublicItem_T& tURLParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclConfigManagerLocalDataPARTID{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   PublicItem_T tPARTID;
   
public:
   dp_tclConfigManagerLocalDataPARTID(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclConfigManagerLocalDataPARTID() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   PublicItem_T tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(PublicItem_T& tPARTIDParam);
   tVoid operator>>(PublicItem_T& oParam);
   
   //write access for pool element 
   tS32  s32SetData(PublicItem_T &tPARTIDParam);
   tS32  s32SetData(const PublicItem_T &tPARTIDParam);
   tVoid operator<<(PublicItem_T oParam);
   
   // do not use --> old interface
   tU8   u8GetData(PublicItem_T& tPARTIDParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(PublicItem_T& tPARTIDParam);
   tVoid vSetData(const PublicItem_T& tPARTIDParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
