
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclConfigManagerLocalData.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "URL"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclConfigManagerLocalDataURL::dp_tclConfigManagerLocalDataURL(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tURL,0,sizeof(PublicItem_T));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclConfigManagerLocalDataURL::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("URL",(tS32) 0xa33);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(PublicItem_T)) 
      {
         tURL = *((PublicItem_T*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclConfigManagerLocalDataURL::vStore(tVoid) {
   dp_tclBaseElement myDpElem("URL", (tS32)0xa33);
   (tVoid)myDpElem.bFillData((tVoid*)&tURL, (tU32)sizeof(PublicItem_T));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclConfigManagerLocalDataURL::s32GetStatus() const {return _s32Status;};
tU8   dp_tclConfigManagerLocalDataURL::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
PublicItem_T dp_tclConfigManagerLocalDataURL::tGetData() {
   vUpdate();
   return tURL;
};
tS32 dp_tclConfigManagerLocalDataURL::s32GetData(PublicItem_T& tURLParam) { 
   vUpdate();
   tURLParam = tURL;
   return _s32Status;
}
tS32 dp_tclConfigManagerLocalDataURL::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("URL", (tS32)0xa33);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclConfigManagerLocalDataURL::operator>>(PublicItem_T& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclConfigManagerLocalDataURL::operator<<(PublicItem_T oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclConfigManagerLocalDataURL::s32SetData(PublicItem_T &tURLParam) {
   //init parameter
   (tVoid)memcpy(&tURL,(tVoid*)&tURLParam, sizeof(PublicItem_T));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tURLParam' in function 'dp_tclConfigManagerLocalDataURL::vSetData(PublicItem_T)' could be made const reference
tS32 dp_tclConfigManagerLocalDataURL::s32SetData(const PublicItem_T &tURLParam) {
   //init parameter
   (tVoid)memcpy(&tURL,(tVoid*)&tURLParam, sizeof(PublicItem_T));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tURLParam' in function 'dp_tclConfigManagerLocalDataURL::vSetData(PublicItem_T)' could be made const reference
// do not use --> old interface
tU8 dp_tclConfigManagerLocalDataURL::u8GetData(PublicItem_T& tURLParam) {  
   vUpdate();
   tURLParam = tURL;
   return _u8DataStatus;
}
tVoid dp_tclConfigManagerLocalDataURL::vSetData(PublicItem_T &tURLParam) { 
   //init parameter
   (tVoid)memcpy(&tURL,(tVoid*)&tURLParam, sizeof(PublicItem_T));
   vStore();
}//lint !e1746: parameter 'tURLParam' in function 'dp_tclConfigManagerLocalDataURL::vSetData(PublicItem_T)' could be made const reference
tVoid dp_tclConfigManagerLocalDataURL::vSetData(const PublicItem_T &tURLParam) { 
   //init parameter
   (tVoid)memcpy(&tURL,(tVoid*)&tURLParam, sizeof(PublicItem_T));
   vStore();
}//lint !e1746: parameter 'tURLParam' in function 'dp_tclConfigManagerLocalDataURL::vSetData(PublicItem_T)' could be made const reference
tU8   dp_tclConfigManagerLocalDataURL::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclConfigManagerLocalDataURL::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA, "URL", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclConfigManagerLocalDataURL::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA, "URL", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclConfigManagerLocalDataURL::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: URL", DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA);
   }
   else
   {
      fprintf(stdout,"Element URL has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PARTID"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclConfigManagerLocalDataPARTID::dp_tclConfigManagerLocalDataPARTID(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPARTID,0,sizeof(PublicItem_T));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclConfigManagerLocalDataPARTID::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PARTID",(tS32) 0x4a130);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(PublicItem_T)) 
      {
         tPARTID = *((PublicItem_T*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclConfigManagerLocalDataPARTID::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PARTID", (tS32)0x4a130);
   (tVoid)myDpElem.bFillData((tVoid*)&tPARTID, (tU32)sizeof(PublicItem_T));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclConfigManagerLocalDataPARTID::s32GetStatus() const {return _s32Status;};
tU8   dp_tclConfigManagerLocalDataPARTID::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
PublicItem_T dp_tclConfigManagerLocalDataPARTID::tGetData() {
   vUpdate();
   return tPARTID;
};
tS32 dp_tclConfigManagerLocalDataPARTID::s32GetData(PublicItem_T& tPARTIDParam) { 
   vUpdate();
   tPARTIDParam = tPARTID;
   return _s32Status;
}
tS32 dp_tclConfigManagerLocalDataPARTID::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PARTID", (tS32)0x4a130);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclConfigManagerLocalDataPARTID::operator>>(PublicItem_T& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclConfigManagerLocalDataPARTID::operator<<(PublicItem_T oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclConfigManagerLocalDataPARTID::s32SetData(PublicItem_T &tPARTIDParam) {
   //init parameter
   (tVoid)memcpy(&tPARTID,(tVoid*)&tPARTIDParam, sizeof(PublicItem_T));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPARTIDParam' in function 'dp_tclConfigManagerLocalDataPARTID::vSetData(PublicItem_T)' could be made const reference
tS32 dp_tclConfigManagerLocalDataPARTID::s32SetData(const PublicItem_T &tPARTIDParam) {
   //init parameter
   (tVoid)memcpy(&tPARTID,(tVoid*)&tPARTIDParam, sizeof(PublicItem_T));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPARTIDParam' in function 'dp_tclConfigManagerLocalDataPARTID::vSetData(PublicItem_T)' could be made const reference
// do not use --> old interface
tU8 dp_tclConfigManagerLocalDataPARTID::u8GetData(PublicItem_T& tPARTIDParam) {  
   vUpdate();
   tPARTIDParam = tPARTID;
   return _u8DataStatus;
}
tVoid dp_tclConfigManagerLocalDataPARTID::vSetData(PublicItem_T &tPARTIDParam) { 
   //init parameter
   (tVoid)memcpy(&tPARTID,(tVoid*)&tPARTIDParam, sizeof(PublicItem_T));
   vStore();
}//lint !e1746: parameter 'tPARTIDParam' in function 'dp_tclConfigManagerLocalDataPARTID::vSetData(PublicItem_T)' could be made const reference
tVoid dp_tclConfigManagerLocalDataPARTID::vSetData(const PublicItem_T &tPARTIDParam) { 
   //init parameter
   (tVoid)memcpy(&tPARTID,(tVoid*)&tPARTIDParam, sizeof(PublicItem_T));
   vStore();
}//lint !e1746: parameter 'tPARTIDParam' in function 'dp_tclConfigManagerLocalDataPARTID::vSetData(PublicItem_T)' could be made const reference
tU8   dp_tclConfigManagerLocalDataPARTID::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclConfigManagerLocalDataPARTID::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA, "PARTID", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclConfigManagerLocalDataPARTID::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA, "PARTID", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclConfigManagerLocalDataPARTID::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PARTID", DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CONFIGMANAGERLOCALDATA);
   }
   else
   {
      fprintf(stdout,"Element PARTID has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
