#ifndef _DP_FI_CONFIGMANAGERDATAPOOLDATA_H
#define _DP_FI_CONFIGMANAGERDATAPOOLDATA_H

extern tVoid vInitConfigManagerDatapoolData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define CFGMGR_S_IMPORT_INTERFACE_DP_CONFIGMANAGER 
#include "../../di_middleware_server/components/cfgmgr/config/datapool/cfgmgr_dpif.h"
//lint +e750




class dp_tclConfigManagerDatapoolDataCSA{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   PublicItem_T tCSA;
   
public:
   dp_tclConfigManagerDatapoolDataCSA(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclConfigManagerDatapoolDataCSA() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   PublicItem_T tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(PublicItem_T& tCSAParam);
   tVoid operator>>(PublicItem_T& oParam);
   
   //write access for pool element 
   tS32  s32SetData(PublicItem_T &tCSAParam);
   tS32  s32SetData(const PublicItem_T &tCSAParam);
   tVoid operator<<(PublicItem_T oParam);
   
   // do not use --> old interface
   tU8   u8GetData(PublicItem_T& tCSAParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(PublicItem_T& tCSAParam);
   tVoid vSetData(const PublicItem_T& tCSAParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
