
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclEarlyConfigTwoTouchDriver.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrTouchDriverName"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName::dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName::s32SetData(tString &tTrTouchDriverNameParam) {
   tU32 u32Len = (tU32)strlen(tTrTouchDriverNameParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchDriverName", (tS32)0x461b89c2);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchDriverNameParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName::s32SetData(const tString &tTrTouchDriverNameParam) {
   tU32 u32Len = (tU32)strlen(tTrTouchDriverNameParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchDriverName", (tS32)0x461b89c2);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchDriverNameParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName::s32GetData(tString &tTrTouchDriverNameParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchDriverName", (tS32)0x461b89c2);
   (tVoid)memset(tTrTouchDriverNameParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchDriverNameParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName::s32GetData(const tString &tTrTouchDriverNameParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchDriverName", (tS32)0x461b89c2);
   (tVoid)memset(tTrTouchDriverNameParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchDriverNameParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName::u32GetData(tString &tTrTouchDriverNameParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchDriverNameParam, u32StringBufLen);
   };
    tU32  dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName::u32GetData(const tString &tTrTouchDriverNameParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchDriverNameParam, u32StringBufLen);
   };
   tVoid dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName::vSetData(tString &tTrTouchDriverNameParam){(tVoid)s32SetData(tTrTouchDriverNameParam);};
   tVoid dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName::vSetData(const tString &tTrTouchDriverNameParam){(tVoid)s32SetData(tTrTouchDriverNameParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, "TrTouchDriverName", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, "TrTouchDriverName", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrTouchDriverName", DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER);
		}
		else
		{
			fprintf(stdout,"Element TrTouchDriverName has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrTouchDriverName2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName2::dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName2(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName2::s32SetData(tString &tTrTouchDriverName2Param) {
   tU32 u32Len = (tU32)strlen(tTrTouchDriverName2Param);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchDriverName2", (tS32)0x5e89b0fc);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchDriverName2Param, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName2::s32SetData(const tString &tTrTouchDriverName2Param) {
   tU32 u32Len = (tU32)strlen(tTrTouchDriverName2Param);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchDriverName2", (tS32)0x5e89b0fc);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchDriverName2Param, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName2::s32GetData(tString &tTrTouchDriverName2Param, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchDriverName2", (tS32)0x5e89b0fc);
   (tVoid)memset(tTrTouchDriverName2Param, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchDriverName2Param, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName2::s32GetData(const tString &tTrTouchDriverName2Param, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchDriverName2", (tS32)0x5e89b0fc);
   (tVoid)memset(tTrTouchDriverName2Param, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchDriverName2Param, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName2::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName2::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName2::u32GetData(tString &tTrTouchDriverName2Param, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchDriverName2Param, u32StringBufLen);
   };
    tU32  dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName2::u32GetData(const tString &tTrTouchDriverName2Param, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchDriverName2Param, u32StringBufLen);
   };
   tVoid dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName2::vSetData(tString &tTrTouchDriverName2Param){(tVoid)s32SetData(tTrTouchDriverName2Param);};
   tVoid dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName2::vSetData(const tString &tTrTouchDriverName2Param){(tVoid)s32SetData(tTrTouchDriverName2Param);};
   
   //notification handling not over processes only for application
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, "TrTouchDriverName2", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, "TrTouchDriverName2", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchDriverName2::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrTouchDriverName2", DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER);
		}
		else
		{
			fprintf(stdout,"Element TrTouchDriverName2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrTouchConfigFileName"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName::dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName::s32SetData(tString &tTrTouchConfigFileNameParam) {
   tU32 u32Len = (tU32)strlen(tTrTouchConfigFileNameParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchConfigFileName", (tS32)0xba3c4484);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchConfigFileNameParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName::s32SetData(const tString &tTrTouchConfigFileNameParam) {
   tU32 u32Len = (tU32)strlen(tTrTouchConfigFileNameParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchConfigFileName", (tS32)0xba3c4484);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchConfigFileNameParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName::s32GetData(tString &tTrTouchConfigFileNameParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchConfigFileName", (tS32)0xba3c4484);
   (tVoid)memset(tTrTouchConfigFileNameParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchConfigFileNameParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName::s32GetData(const tString &tTrTouchConfigFileNameParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchConfigFileName", (tS32)0xba3c4484);
   (tVoid)memset(tTrTouchConfigFileNameParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchConfigFileNameParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName::u32GetData(tString &tTrTouchConfigFileNameParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchConfigFileNameParam, u32StringBufLen);
   };
    tU32  dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName::u32GetData(const tString &tTrTouchConfigFileNameParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchConfigFileNameParam, u32StringBufLen);
   };
   tVoid dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName::vSetData(tString &tTrTouchConfigFileNameParam){(tVoid)s32SetData(tTrTouchConfigFileNameParam);};
   tVoid dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName::vSetData(const tString &tTrTouchConfigFileNameParam){(tVoid)s32SetData(tTrTouchConfigFileNameParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, "TrTouchConfigFileName", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, "TrTouchConfigFileName", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrTouchConfigFileName", DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER);
		}
		else
		{
			fprintf(stdout,"Element TrTouchConfigFileName has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrTouchConfigFileName2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName2::dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName2(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName2::s32SetData(tString &tTrTouchConfigFileName2Param) {
   tU32 u32Len = (tU32)strlen(tTrTouchConfigFileName2Param);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchConfigFileName2", (tS32)0xa32d56c6);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchConfigFileName2Param, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName2::s32SetData(const tString &tTrTouchConfigFileName2Param) {
   tU32 u32Len = (tU32)strlen(tTrTouchConfigFileName2Param);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchConfigFileName2", (tS32)0xa32d56c6);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchConfigFileName2Param, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName2::s32GetData(tString &tTrTouchConfigFileName2Param, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchConfigFileName2", (tS32)0xa32d56c6);
   (tVoid)memset(tTrTouchConfigFileName2Param, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchConfigFileName2Param, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName2::s32GetData(const tString &tTrTouchConfigFileName2Param, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchConfigFileName2", (tS32)0xa32d56c6);
   (tVoid)memset(tTrTouchConfigFileName2Param, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchConfigFileName2Param, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName2::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName2::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName2::u32GetData(tString &tTrTouchConfigFileName2Param, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchConfigFileName2Param, u32StringBufLen);
   };
    tU32  dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName2::u32GetData(const tString &tTrTouchConfigFileName2Param, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchConfigFileName2Param, u32StringBufLen);
   };
   tVoid dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName2::vSetData(tString &tTrTouchConfigFileName2Param){(tVoid)s32SetData(tTrTouchConfigFileName2Param);};
   tVoid dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName2::vSetData(const tString &tTrTouchConfigFileName2Param){(tVoid)s32SetData(tTrTouchConfigFileName2Param);};
   
   //notification handling not over processes only for application
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, "TrTouchConfigFileName2", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, "TrTouchConfigFileName2", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchConfigFileName2::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrTouchConfigFileName2", DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER);
		}
		else
		{
			fprintf(stdout,"Element TrTouchConfigFileName2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrTouchI2CAddr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr::dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr::s32SetData(tString &tTrTouchI2CAddrParam) {
   tU32 u32Len = (tU32)strlen(tTrTouchI2CAddrParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchI2CAddr", (tS32)0xa04bb84a);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchI2CAddrParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr::s32SetData(const tString &tTrTouchI2CAddrParam) {
   tU32 u32Len = (tU32)strlen(tTrTouchI2CAddrParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchI2CAddr", (tS32)0xa04bb84a);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchI2CAddrParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr::s32GetData(tString &tTrTouchI2CAddrParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchI2CAddr", (tS32)0xa04bb84a);
   (tVoid)memset(tTrTouchI2CAddrParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchI2CAddrParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr::s32GetData(const tString &tTrTouchI2CAddrParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchI2CAddr", (tS32)0xa04bb84a);
   (tVoid)memset(tTrTouchI2CAddrParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchI2CAddrParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr::u32GetData(tString &tTrTouchI2CAddrParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchI2CAddrParam, u32StringBufLen);
   };
    tU32  dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr::u32GetData(const tString &tTrTouchI2CAddrParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchI2CAddrParam, u32StringBufLen);
   };
   tVoid dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr::vSetData(tString &tTrTouchI2CAddrParam){(tVoid)s32SetData(tTrTouchI2CAddrParam);};
   tVoid dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr::vSetData(const tString &tTrTouchI2CAddrParam){(tVoid)s32SetData(tTrTouchI2CAddrParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, "TrTouchI2CAddr", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, "TrTouchI2CAddr", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrTouchI2CAddr", DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER);
		}
		else
		{
			fprintf(stdout,"Element TrTouchI2CAddr has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrTouchI2CAddr2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr2::dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr2(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr2::s32SetData(tString &tTrTouchI2CAddr2Param) {
   tU32 u32Len = (tU32)strlen(tTrTouchI2CAddr2Param);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchI2CAddr2", (tS32)0x217a99a4);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchI2CAddr2Param, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr2::s32SetData(const tString &tTrTouchI2CAddr2Param) {
   tU32 u32Len = (tU32)strlen(tTrTouchI2CAddr2Param);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchI2CAddr2", (tS32)0x217a99a4);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchI2CAddr2Param, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr2::s32GetData(tString &tTrTouchI2CAddr2Param, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchI2CAddr2", (tS32)0x217a99a4);
   (tVoid)memset(tTrTouchI2CAddr2Param, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchI2CAddr2Param, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr2::s32GetData(const tString &tTrTouchI2CAddr2Param, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchI2CAddr2", (tS32)0x217a99a4);
   (tVoid)memset(tTrTouchI2CAddr2Param, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchI2CAddr2Param, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr2::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr2::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr2::u32GetData(tString &tTrTouchI2CAddr2Param, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchI2CAddr2Param, u32StringBufLen);
   };
    tU32  dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr2::u32GetData(const tString &tTrTouchI2CAddr2Param, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchI2CAddr2Param, u32StringBufLen);
   };
   tVoid dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr2::vSetData(tString &tTrTouchI2CAddr2Param){(tVoid)s32SetData(tTrTouchI2CAddr2Param);};
   tVoid dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr2::vSetData(const tString &tTrTouchI2CAddr2Param){(tVoid)s32SetData(tTrTouchI2CAddr2Param);};
   
   //notification handling not over processes only for application
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, "TrTouchI2CAddr2", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER, "TrTouchI2CAddr2", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoTouchDriverTrTouchI2CAddr2::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrTouchI2CAddr2", DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGTWOTOUCHDRIVER);
		}
		else
		{
			fprintf(stdout,"Element TrTouchI2CAddr2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 

