#ifndef _DP_FI_EARLYCONFIGTWODISPLAYS_H
#define _DP_FI_EARLYCONFIGTWODISPLAYS_H

extern tVoid vInitEarlyConfigTwoDisplays(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1() {};

   //read access for pool element 
   tS32  s32GetData(tString &tTrTimingLVDS1Param, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tTrTimingLVDS1Param, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tTrTimingLVDS1Param);
   tS32 s32SetData(const tString &tTrTimingLVDS1Param);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tTrTimingLVDS1Param, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tTrTimingLVDS1Param, tU32 u32StringBufLen);
   tVoid vSetData(tString &tTrTimingLVDS1Param);
   tVoid vSetData(const tString &tTrTimingLVDS1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2() {};

   //read access for pool element 
   tS32  s32GetData(tString &tTrTimingLVDS2Param, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tTrTimingLVDS2Param, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tTrTimingLVDS2Param);
   tS32 s32SetData(const tString &tTrTimingLVDS2Param);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tTrTimingLVDS2Param, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tTrTimingLVDS2Param, tU32 u32StringBufLen);
   tVoid vSetData(tString &tTrTimingLVDS2Param);
   tVoid vSetData(const tString &tTrTimingLVDS2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS32 tTrClockEdgeSelectLVDS1;
   
public:
   dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS32& tTrClockEdgeSelectLVDS1Param);
   tVoid operator>>(tS32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS32 &tTrClockEdgeSelectLVDS1Param);
   tS32  s32SetData(const tS32 &tTrClockEdgeSelectLVDS1Param);
   tVoid operator<<(tS32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS32& tTrClockEdgeSelectLVDS1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS32& tTrClockEdgeSelectLVDS1Param);
   tVoid vSetData(const tS32& tTrClockEdgeSelectLVDS1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS32 tTrClockEdgeSelectLVDS2;
   
public:
   dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS32& tTrClockEdgeSelectLVDS2Param);
   tVoid operator>>(tS32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS32 &tTrClockEdgeSelectLVDS2Param);
   tS32  s32SetData(const tS32 &tTrClockEdgeSelectLVDS2Param);
   tVoid operator<<(tS32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS32& tTrClockEdgeSelectLVDS2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS32& tTrClockEdgeSelectLVDS2Param);
   tVoid vSetData(const tS32& tTrClockEdgeSelectLVDS2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS32 tTrSpreadSpectrumClockGenerationLVDS1;
   
public:
   dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS32& tTrSpreadSpectrumClockGenerationLVDS1Param);
   tVoid operator>>(tS32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS32 &tTrSpreadSpectrumClockGenerationLVDS1Param);
   tS32  s32SetData(const tS32 &tTrSpreadSpectrumClockGenerationLVDS1Param);
   tVoid operator<<(tS32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS32& tTrSpreadSpectrumClockGenerationLVDS1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS32& tTrSpreadSpectrumClockGenerationLVDS1Param);
   tVoid vSetData(const tS32& tTrSpreadSpectrumClockGenerationLVDS1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS32 tTrSpreadSpectrumClockGenerationLVDS2;
   
public:
   dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS32& tTrSpreadSpectrumClockGenerationLVDS2Param);
   tVoid operator>>(tS32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS32 &tTrSpreadSpectrumClockGenerationLVDS2Param);
   tS32  s32SetData(const tS32 &tTrSpreadSpectrumClockGenerationLVDS2Param);
   tVoid operator<<(tS32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS32& tTrSpreadSpectrumClockGenerationLVDS2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS32& tTrSpreadSpectrumClockGenerationLVDS2Param);
   tVoid vSetData(const tS32& tTrSpreadSpectrumClockGenerationLVDS2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
