
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclEarlyConfigTwoDisplays.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrTimingLVDS1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1::dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1::s32SetData(tString &tTrTimingLVDS1Param) {
   tU32 u32Len = (tU32)strlen(tTrTimingLVDS1Param);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTimingLVDS1", (tS32)0x526a2490);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTimingLVDS1Param, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1::s32SetData(const tString &tTrTimingLVDS1Param) {
   tU32 u32Len = (tU32)strlen(tTrTimingLVDS1Param);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTimingLVDS1", (tS32)0x526a2490);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTimingLVDS1Param, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1::s32GetData(tString &tTrTimingLVDS1Param, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTimingLVDS1", (tS32)0x526a2490);
   (tVoid)memset(tTrTimingLVDS1Param, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTimingLVDS1Param, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1::s32GetData(const tString &tTrTimingLVDS1Param, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTimingLVDS1", (tS32)0x526a2490);
   (tVoid)memset(tTrTimingLVDS1Param, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTimingLVDS1Param, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1::u32GetData(tString &tTrTimingLVDS1Param, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTimingLVDS1Param, u32StringBufLen);
   };
    tU32  dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1::u32GetData(const tString &tTrTimingLVDS1Param, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTimingLVDS1Param, u32StringBufLen);
   };
   tVoid dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1::vSetData(tString &tTrTimingLVDS1Param){(tVoid)s32SetData(tTrTimingLVDS1Param);};
   tVoid dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1::vSetData(const tString &tTrTimingLVDS1Param){(tVoid)s32SetData(tTrTimingLVDS1Param);};
   
   //notification handling not over processes only for application
   tBool dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, "TrTimingLVDS1", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, "TrTimingLVDS1", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoDisplaysTrTimingLVDS1::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrTimingLVDS1", DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS);
		}
		else
		{
			fprintf(stdout,"Element TrTimingLVDS1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrTimingLVDS2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2::dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2::s32SetData(tString &tTrTimingLVDS2Param) {
   tU32 u32Len = (tU32)strlen(tTrTimingLVDS2Param);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTimingLVDS2", (tS32)0x526a2491);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTimingLVDS2Param, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2::s32SetData(const tString &tTrTimingLVDS2Param) {
   tU32 u32Len = (tU32)strlen(tTrTimingLVDS2Param);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTimingLVDS2", (tS32)0x526a2491);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTimingLVDS2Param, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2::s32GetData(tString &tTrTimingLVDS2Param, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTimingLVDS2", (tS32)0x526a2491);
   (tVoid)memset(tTrTimingLVDS2Param, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTimingLVDS2Param, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2::s32GetData(const tString &tTrTimingLVDS2Param, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTimingLVDS2", (tS32)0x526a2491);
   (tVoid)memset(tTrTimingLVDS2Param, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTimingLVDS2Param, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2::u32GetData(tString &tTrTimingLVDS2Param, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTimingLVDS2Param, u32StringBufLen);
   };
    tU32  dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2::u32GetData(const tString &tTrTimingLVDS2Param, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTimingLVDS2Param, u32StringBufLen);
   };
   tVoid dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2::vSetData(tString &tTrTimingLVDS2Param){(tVoid)s32SetData(tTrTimingLVDS2Param);};
   tVoid dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2::vSetData(const tString &tTrTimingLVDS2Param){(tVoid)s32SetData(tTrTimingLVDS2Param);};
   
   //notification handling not over processes only for application
   tBool dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, "TrTimingLVDS2", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, "TrTimingLVDS2", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTwoDisplaysTrTimingLVDS2::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrTimingLVDS2", DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS);
		}
		else
		{
			fprintf(stdout,"Element TrTimingLVDS2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrClockEdgeSelectLVDS1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrClockEdgeSelectLVDS1,0,sizeof(tS32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrClockEdgeSelectLVDS1",(tS32) 0xb2958f3d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS32)) 
      {
         tTrClockEdgeSelectLVDS1 = *((tS32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrClockEdgeSelectLVDS1", (tS32)0xb2958f3d);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrClockEdgeSelectLVDS1, (tU32)sizeof(tS32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS32 dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::tGetData() {
   vUpdate();
   return tTrClockEdgeSelectLVDS1;
};
tS32 dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::s32GetData(tS32& tTrClockEdgeSelectLVDS1Param) { 
   vUpdate();
   tTrClockEdgeSelectLVDS1Param = tTrClockEdgeSelectLVDS1;
   return _s32Status;
}
tS32 dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrClockEdgeSelectLVDS1", (tS32)0xb2958f3d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::operator>>(tS32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::operator<<(tS32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::s32SetData(tS32 &tTrClockEdgeSelectLVDS1Param) {
   //init parameter
   (tVoid)memcpy(&tTrClockEdgeSelectLVDS1,(tVoid*)&tTrClockEdgeSelectLVDS1Param, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrClockEdgeSelectLVDS1Param' in function 'dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::vSetData(tS32)' could be made const reference
tS32 dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::s32SetData(const tS32 &tTrClockEdgeSelectLVDS1Param) {
   //init parameter
   (tVoid)memcpy(&tTrClockEdgeSelectLVDS1,(tVoid*)&tTrClockEdgeSelectLVDS1Param, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrClockEdgeSelectLVDS1Param' in function 'dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::vSetData(tS32)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::u8GetData(tS32& tTrClockEdgeSelectLVDS1Param) {  
   vUpdate();
   tTrClockEdgeSelectLVDS1Param = tTrClockEdgeSelectLVDS1;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::vSetData(tS32 &tTrClockEdgeSelectLVDS1Param) { 
   //init parameter
   (tVoid)memcpy(&tTrClockEdgeSelectLVDS1,(tVoid*)&tTrClockEdgeSelectLVDS1Param, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tTrClockEdgeSelectLVDS1Param' in function 'dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::vSetData(tS32)' could be made const reference
tVoid dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::vSetData(const tS32 &tTrClockEdgeSelectLVDS1Param) { 
   //init parameter
   (tVoid)memcpy(&tTrClockEdgeSelectLVDS1,(tVoid*)&tTrClockEdgeSelectLVDS1Param, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tTrClockEdgeSelectLVDS1Param' in function 'dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::vSetData(tS32)' could be made const reference
tU8   dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, "TrClockEdgeSelectLVDS1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, "TrClockEdgeSelectLVDS1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrClockEdgeSelectLVDS1", DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS);
   }
   else
   {
      fprintf(stdout,"Element TrClockEdgeSelectLVDS1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrClockEdgeSelectLVDS2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrClockEdgeSelectLVDS2,0,sizeof(tS32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrClockEdgeSelectLVDS2",(tS32) 0xb2958f3e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS32)) 
      {
         tTrClockEdgeSelectLVDS2 = *((tS32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrClockEdgeSelectLVDS2", (tS32)0xb2958f3e);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrClockEdgeSelectLVDS2, (tU32)sizeof(tS32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS32 dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::tGetData() {
   vUpdate();
   return tTrClockEdgeSelectLVDS2;
};
tS32 dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::s32GetData(tS32& tTrClockEdgeSelectLVDS2Param) { 
   vUpdate();
   tTrClockEdgeSelectLVDS2Param = tTrClockEdgeSelectLVDS2;
   return _s32Status;
}
tS32 dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrClockEdgeSelectLVDS2", (tS32)0xb2958f3e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::operator>>(tS32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::operator<<(tS32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::s32SetData(tS32 &tTrClockEdgeSelectLVDS2Param) {
   //init parameter
   (tVoid)memcpy(&tTrClockEdgeSelectLVDS2,(tVoid*)&tTrClockEdgeSelectLVDS2Param, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrClockEdgeSelectLVDS2Param' in function 'dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::vSetData(tS32)' could be made const reference
tS32 dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::s32SetData(const tS32 &tTrClockEdgeSelectLVDS2Param) {
   //init parameter
   (tVoid)memcpy(&tTrClockEdgeSelectLVDS2,(tVoid*)&tTrClockEdgeSelectLVDS2Param, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrClockEdgeSelectLVDS2Param' in function 'dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::vSetData(tS32)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::u8GetData(tS32& tTrClockEdgeSelectLVDS2Param) {  
   vUpdate();
   tTrClockEdgeSelectLVDS2Param = tTrClockEdgeSelectLVDS2;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::vSetData(tS32 &tTrClockEdgeSelectLVDS2Param) { 
   //init parameter
   (tVoid)memcpy(&tTrClockEdgeSelectLVDS2,(tVoid*)&tTrClockEdgeSelectLVDS2Param, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tTrClockEdgeSelectLVDS2Param' in function 'dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::vSetData(tS32)' could be made const reference
tVoid dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::vSetData(const tS32 &tTrClockEdgeSelectLVDS2Param) { 
   //init parameter
   (tVoid)memcpy(&tTrClockEdgeSelectLVDS2,(tVoid*)&tTrClockEdgeSelectLVDS2Param, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tTrClockEdgeSelectLVDS2Param' in function 'dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::vSetData(tS32)' could be made const reference
tU8   dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, "TrClockEdgeSelectLVDS2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, "TrClockEdgeSelectLVDS2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigTwoDisplaysTrClockEdgeSelectLVDS2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrClockEdgeSelectLVDS2", DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS);
   }
   else
   {
      fprintf(stdout,"Element TrClockEdgeSelectLVDS2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrSpreadSpectrumClockGenerationLVDS1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrSpreadSpectrumClockGenerationLVDS1,0,sizeof(tS32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrSpreadSpectrumClockGenerationLVDS1",(tS32) 0x66617516L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS32)) 
      {
         tTrSpreadSpectrumClockGenerationLVDS1 = *((tS32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrSpreadSpectrumClockGenerationLVDS1", (tS32)0x66617516L);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrSpreadSpectrumClockGenerationLVDS1, (tU32)sizeof(tS32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS32 dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::tGetData() {
   vUpdate();
   return tTrSpreadSpectrumClockGenerationLVDS1;
};
tS32 dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::s32GetData(tS32& tTrSpreadSpectrumClockGenerationLVDS1Param) { 
   vUpdate();
   tTrSpreadSpectrumClockGenerationLVDS1Param = tTrSpreadSpectrumClockGenerationLVDS1;
   return _s32Status;
}
tS32 dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrSpreadSpectrumClockGenerationLVDS1", (tS32)0x66617516L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::operator>>(tS32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::operator<<(tS32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::s32SetData(tS32 &tTrSpreadSpectrumClockGenerationLVDS1Param) {
   //init parameter
   (tVoid)memcpy(&tTrSpreadSpectrumClockGenerationLVDS1,(tVoid*)&tTrSpreadSpectrumClockGenerationLVDS1Param, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrSpreadSpectrumClockGenerationLVDS1Param' in function 'dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::vSetData(tS32)' could be made const reference
tS32 dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::s32SetData(const tS32 &tTrSpreadSpectrumClockGenerationLVDS1Param) {
   //init parameter
   (tVoid)memcpy(&tTrSpreadSpectrumClockGenerationLVDS1,(tVoid*)&tTrSpreadSpectrumClockGenerationLVDS1Param, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrSpreadSpectrumClockGenerationLVDS1Param' in function 'dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::vSetData(tS32)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::u8GetData(tS32& tTrSpreadSpectrumClockGenerationLVDS1Param) {  
   vUpdate();
   tTrSpreadSpectrumClockGenerationLVDS1Param = tTrSpreadSpectrumClockGenerationLVDS1;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::vSetData(tS32 &tTrSpreadSpectrumClockGenerationLVDS1Param) { 
   //init parameter
   (tVoid)memcpy(&tTrSpreadSpectrumClockGenerationLVDS1,(tVoid*)&tTrSpreadSpectrumClockGenerationLVDS1Param, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tTrSpreadSpectrumClockGenerationLVDS1Param' in function 'dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::vSetData(tS32)' could be made const reference
tVoid dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::vSetData(const tS32 &tTrSpreadSpectrumClockGenerationLVDS1Param) { 
   //init parameter
   (tVoid)memcpy(&tTrSpreadSpectrumClockGenerationLVDS1,(tVoid*)&tTrSpreadSpectrumClockGenerationLVDS1Param, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tTrSpreadSpectrumClockGenerationLVDS1Param' in function 'dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::vSetData(tS32)' could be made const reference
tU8   dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, "TrSpreadSpectrumClockGenerationLVDS1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, "TrSpreadSpectrumClockGenerationLVDS1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrSpreadSpectrumClockGenerationLVDS1", DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS);
   }
   else
   {
      fprintf(stdout,"Element TrSpreadSpectrumClockGenerationLVDS1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrSpreadSpectrumClockGenerationLVDS2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrSpreadSpectrumClockGenerationLVDS2,0,sizeof(tS32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrSpreadSpectrumClockGenerationLVDS2",(tS32) 0x66617517L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS32)) 
      {
         tTrSpreadSpectrumClockGenerationLVDS2 = *((tS32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrSpreadSpectrumClockGenerationLVDS2", (tS32)0x66617517L);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrSpreadSpectrumClockGenerationLVDS2, (tU32)sizeof(tS32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS32 dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::tGetData() {
   vUpdate();
   return tTrSpreadSpectrumClockGenerationLVDS2;
};
tS32 dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::s32GetData(tS32& tTrSpreadSpectrumClockGenerationLVDS2Param) { 
   vUpdate();
   tTrSpreadSpectrumClockGenerationLVDS2Param = tTrSpreadSpectrumClockGenerationLVDS2;
   return _s32Status;
}
tS32 dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrSpreadSpectrumClockGenerationLVDS2", (tS32)0x66617517L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::operator>>(tS32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::operator<<(tS32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::s32SetData(tS32 &tTrSpreadSpectrumClockGenerationLVDS2Param) {
   //init parameter
   (tVoid)memcpy(&tTrSpreadSpectrumClockGenerationLVDS2,(tVoid*)&tTrSpreadSpectrumClockGenerationLVDS2Param, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrSpreadSpectrumClockGenerationLVDS2Param' in function 'dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::vSetData(tS32)' could be made const reference
tS32 dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::s32SetData(const tS32 &tTrSpreadSpectrumClockGenerationLVDS2Param) {
   //init parameter
   (tVoid)memcpy(&tTrSpreadSpectrumClockGenerationLVDS2,(tVoid*)&tTrSpreadSpectrumClockGenerationLVDS2Param, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrSpreadSpectrumClockGenerationLVDS2Param' in function 'dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::vSetData(tS32)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::u8GetData(tS32& tTrSpreadSpectrumClockGenerationLVDS2Param) {  
   vUpdate();
   tTrSpreadSpectrumClockGenerationLVDS2Param = tTrSpreadSpectrumClockGenerationLVDS2;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::vSetData(tS32 &tTrSpreadSpectrumClockGenerationLVDS2Param) { 
   //init parameter
   (tVoid)memcpy(&tTrSpreadSpectrumClockGenerationLVDS2,(tVoid*)&tTrSpreadSpectrumClockGenerationLVDS2Param, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tTrSpreadSpectrumClockGenerationLVDS2Param' in function 'dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::vSetData(tS32)' could be made const reference
tVoid dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::vSetData(const tS32 &tTrSpreadSpectrumClockGenerationLVDS2Param) { 
   //init parameter
   (tVoid)memcpy(&tTrSpreadSpectrumClockGenerationLVDS2,(tVoid*)&tTrSpreadSpectrumClockGenerationLVDS2Param, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tTrSpreadSpectrumClockGenerationLVDS2Param' in function 'dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::vSetData(tS32)' could be made const reference
tU8   dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, "TrSpreadSpectrumClockGenerationLVDS2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS, "TrSpreadSpectrumClockGenerationLVDS2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigTwoDisplaysTrSpreadSpectrumClockGenerationLVDS2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrSpreadSpectrumClockGenerationLVDS2", DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGTWODISPLAYS);
   }
   else
   {
      fprintf(stdout,"Element TrSpreadSpectrumClockGenerationLVDS2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
