
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclEarlyConfigTouchDriver.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrTouchDriverName"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigTouchDriverTrTouchDriverName::dp_tclEarlyConfigTouchDriverTrTouchDriverName(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclEarlyConfigTouchDriverTrTouchDriverName::s32SetData(tString &tTrTouchDriverNameParam) {
   tU32 u32Len = (tU32)strlen(tTrTouchDriverNameParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchDriverName", (tS32)0x461b89c2);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchDriverNameParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTouchDriverTrTouchDriverName::s32SetData(const tString &tTrTouchDriverNameParam) {
   tU32 u32Len = (tU32)strlen(tTrTouchDriverNameParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchDriverName", (tS32)0x461b89c2);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchDriverNameParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTouchDriverTrTouchDriverName::s32GetData(tString &tTrTouchDriverNameParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchDriverName", (tS32)0x461b89c2);
   (tVoid)memset(tTrTouchDriverNameParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchDriverNameParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTouchDriverTrTouchDriverName::s32GetData(const tString &tTrTouchDriverNameParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchDriverName", (tS32)0x461b89c2);
   (tVoid)memset(tTrTouchDriverNameParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchDriverNameParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclEarlyConfigTouchDriverTrTouchDriverName::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclEarlyConfigTouchDriverTrTouchDriverName::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclEarlyConfigTouchDriverTrTouchDriverName::u32GetData(tString &tTrTouchDriverNameParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchDriverNameParam, u32StringBufLen);
   };
    tU32  dp_tclEarlyConfigTouchDriverTrTouchDriverName::u32GetData(const tString &tTrTouchDriverNameParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchDriverNameParam, u32StringBufLen);
   };
   tVoid dp_tclEarlyConfigTouchDriverTrTouchDriverName::vSetData(tString &tTrTouchDriverNameParam){(tVoid)s32SetData(tTrTouchDriverNameParam);};
   tVoid dp_tclEarlyConfigTouchDriverTrTouchDriverName::vSetData(const tString &tTrTouchDriverNameParam){(tVoid)s32SetData(tTrTouchDriverNameParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclEarlyConfigTouchDriverTrTouchDriverName::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, "TrTouchDriverName", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTouchDriverTrTouchDriverName::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, "TrTouchDriverName", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTouchDriverTrTouchDriverName::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrTouchDriverName", DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER);
		}
		else
		{
			fprintf(stdout,"Element TrTouchDriverName has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrTouchConfigFileName"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigTouchDriverTrTouchConfigFileName::dp_tclEarlyConfigTouchDriverTrTouchConfigFileName(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclEarlyConfigTouchDriverTrTouchConfigFileName::s32SetData(tString &tTrTouchConfigFileNameParam) {
   tU32 u32Len = (tU32)strlen(tTrTouchConfigFileNameParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchConfigFileName", (tS32)0xba3c4484);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchConfigFileNameParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTouchDriverTrTouchConfigFileName::s32SetData(const tString &tTrTouchConfigFileNameParam) {
   tU32 u32Len = (tU32)strlen(tTrTouchConfigFileNameParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchConfigFileName", (tS32)0xba3c4484);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchConfigFileNameParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTouchDriverTrTouchConfigFileName::s32GetData(tString &tTrTouchConfigFileNameParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchConfigFileName", (tS32)0xba3c4484);
   (tVoid)memset(tTrTouchConfigFileNameParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchConfigFileNameParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTouchDriverTrTouchConfigFileName::s32GetData(const tString &tTrTouchConfigFileNameParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchConfigFileName", (tS32)0xba3c4484);
   (tVoid)memset(tTrTouchConfigFileNameParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchConfigFileNameParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclEarlyConfigTouchDriverTrTouchConfigFileName::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclEarlyConfigTouchDriverTrTouchConfigFileName::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclEarlyConfigTouchDriverTrTouchConfigFileName::u32GetData(tString &tTrTouchConfigFileNameParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchConfigFileNameParam, u32StringBufLen);
   };
    tU32  dp_tclEarlyConfigTouchDriverTrTouchConfigFileName::u32GetData(const tString &tTrTouchConfigFileNameParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchConfigFileNameParam, u32StringBufLen);
   };
   tVoid dp_tclEarlyConfigTouchDriverTrTouchConfigFileName::vSetData(tString &tTrTouchConfigFileNameParam){(tVoid)s32SetData(tTrTouchConfigFileNameParam);};
   tVoid dp_tclEarlyConfigTouchDriverTrTouchConfigFileName::vSetData(const tString &tTrTouchConfigFileNameParam){(tVoid)s32SetData(tTrTouchConfigFileNameParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclEarlyConfigTouchDriverTrTouchConfigFileName::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, "TrTouchConfigFileName", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTouchDriverTrTouchConfigFileName::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, "TrTouchConfigFileName", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTouchDriverTrTouchConfigFileName::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrTouchConfigFileName", DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER);
		}
		else
		{
			fprintf(stdout,"Element TrTouchConfigFileName has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrTouchI2CAddr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigTouchDriverTrTouchI2CAddr::dp_tclEarlyConfigTouchDriverTrTouchI2CAddr(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclEarlyConfigTouchDriverTrTouchI2CAddr::s32SetData(tString &tTrTouchI2CAddrParam) {
   tU32 u32Len = (tU32)strlen(tTrTouchI2CAddrParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchI2CAddr", (tS32)0xa04bb84a);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchI2CAddrParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTouchDriverTrTouchI2CAddr::s32SetData(const tString &tTrTouchI2CAddrParam) {
   tU32 u32Len = (tU32)strlen(tTrTouchI2CAddrParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrTouchI2CAddr", (tS32)0xa04bb84a);
      (tVoid)myDpElem.bFillData((tVoid*)tTrTouchI2CAddrParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTouchDriverTrTouchI2CAddr::s32GetData(tString &tTrTouchI2CAddrParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchI2CAddr", (tS32)0xa04bb84a);
   (tVoid)memset(tTrTouchI2CAddrParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchI2CAddrParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigTouchDriverTrTouchI2CAddr::s32GetData(const tString &tTrTouchI2CAddrParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrTouchI2CAddr", (tS32)0xa04bb84a);
   (tVoid)memset(tTrTouchI2CAddrParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrTouchI2CAddrParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclEarlyConfigTouchDriverTrTouchI2CAddr::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclEarlyConfigTouchDriverTrTouchI2CAddr::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclEarlyConfigTouchDriverTrTouchI2CAddr::u32GetData(tString &tTrTouchI2CAddrParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchI2CAddrParam, u32StringBufLen);
   };
    tU32  dp_tclEarlyConfigTouchDriverTrTouchI2CAddr::u32GetData(const tString &tTrTouchI2CAddrParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrTouchI2CAddrParam, u32StringBufLen);
   };
   tVoid dp_tclEarlyConfigTouchDriverTrTouchI2CAddr::vSetData(tString &tTrTouchI2CAddrParam){(tVoid)s32SetData(tTrTouchI2CAddrParam);};
   tVoid dp_tclEarlyConfigTouchDriverTrTouchI2CAddr::vSetData(const tString &tTrTouchI2CAddrParam){(tVoid)s32SetData(tTrTouchI2CAddrParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclEarlyConfigTouchDriverTrTouchI2CAddr::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, "TrTouchI2CAddr", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTouchDriverTrTouchI2CAddr::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER, "TrTouchI2CAddr", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigTouchDriverTrTouchI2CAddr::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrTouchI2CAddr", DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGTOUCHDRIVER);
		}
		else
		{
			fprintf(stdout,"Element TrTouchI2CAddr has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 

