
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclEarlyConfigLayerManager.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrDisplayOrder"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigLayerManagerTrDisplayOrder::dp_tclEarlyConfigLayerManagerTrDisplayOrder(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0666;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclEarlyConfigLayerManagerTrDisplayOrder::s32SetData( tU8* tTrDisplayOrderParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("TrDisplayOrder", (tS32)0x6e5cafc4);
   (tVoid)myDpElem.bFillData((tVoid*)tTrDisplayOrderParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclEarlyConfigLayerManagerTrDisplayOrder::s32GetData(tU8* tTrDisplayOrderParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("TrDisplayOrder", (tS32)0x6e5cafc4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tTrDisplayOrderParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclEarlyConfigLayerManagerTrDisplayOrder::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclEarlyConfigLayerManagerTrDisplayOrder::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclEarlyConfigLayerManagerTrDisplayOrder::u16GetData(tU8* tTrDisplayOrderParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tTrDisplayOrderParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclEarlyConfigLayerManagerTrDisplayOrder::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER, "TrDisplayOrder", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigLayerManagerTrDisplayOrder::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER, "TrDisplayOrder", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclEarlyConfigLayerManagerTrDisplayOrder::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrDisplayOrder", DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER);
		}
		else
		{
			fprintf(stdout,"Element TrDisplayOrder has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrFlushDesignConfigFile"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigLayerManagerTrFlushDesignConfigFile::dp_tclEarlyConfigLayerManagerTrFlushDesignConfigFile(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0666;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclEarlyConfigLayerManagerTrFlushDesignConfigFile::s32SetData(tString &tTrFlushDesignConfigFileParam) {
   tU32 u32Len = (tU32)strlen(tTrFlushDesignConfigFileParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrFlushDesignConfigFile", (tS32)0xb6a243c4);
      (tVoid)myDpElem.bFillData((tVoid*)tTrFlushDesignConfigFileParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigLayerManagerTrFlushDesignConfigFile::s32SetData(const tString &tTrFlushDesignConfigFileParam) {
   tU32 u32Len = (tU32)strlen(tTrFlushDesignConfigFileParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("TrFlushDesignConfigFile", (tS32)0xb6a243c4);
      (tVoid)myDpElem.bFillData((tVoid*)tTrFlushDesignConfigFileParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigLayerManagerTrFlushDesignConfigFile::s32GetData(tString &tTrFlushDesignConfigFileParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrFlushDesignConfigFile", (tS32)0xb6a243c4);
   (tVoid)memset(tTrFlushDesignConfigFileParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrFlushDesignConfigFileParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclEarlyConfigLayerManagerTrFlushDesignConfigFile::s32GetData(const tString &tTrFlushDesignConfigFileParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("TrFlushDesignConfigFile", (tS32)0xb6a243c4);
   (tVoid)memset(tTrFlushDesignConfigFileParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tTrFlushDesignConfigFileParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclEarlyConfigLayerManagerTrFlushDesignConfigFile::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclEarlyConfigLayerManagerTrFlushDesignConfigFile::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclEarlyConfigLayerManagerTrFlushDesignConfigFile::u32GetData(tString &tTrFlushDesignConfigFileParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrFlushDesignConfigFileParam, u32StringBufLen);
   };
    tU32  dp_tclEarlyConfigLayerManagerTrFlushDesignConfigFile::u32GetData(const tString &tTrFlushDesignConfigFileParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tTrFlushDesignConfigFileParam, u32StringBufLen);
   };
   tVoid dp_tclEarlyConfigLayerManagerTrFlushDesignConfigFile::vSetData(tString &tTrFlushDesignConfigFileParam){(tVoid)s32SetData(tTrFlushDesignConfigFileParam);};
   tVoid dp_tclEarlyConfigLayerManagerTrFlushDesignConfigFile::vSetData(const tString &tTrFlushDesignConfigFileParam){(tVoid)s32SetData(tTrFlushDesignConfigFileParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclEarlyConfigLayerManagerTrFlushDesignConfigFile::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER, "TrFlushDesignConfigFile", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigLayerManagerTrFlushDesignConfigFile::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER, "TrFlushDesignConfigFile", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclEarlyConfigLayerManagerTrFlushDesignConfigFile::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrFlushDesignConfigFile", DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGLAYERMANAGER);
		}
		else
		{
			fprintf(stdout,"Element TrFlushDesignConfigFile has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 

