
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclEarlyConfigCSC.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrCurrentProfile"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigCSCTrCurrentProfile::dp_tclEarlyConfigCSCTrCurrentProfile(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrCurrentProfile,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigCSCTrCurrentProfile::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrCurrentProfile",(tS32) 0x2aa26c3a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tTrCurrentProfile = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigCSCTrCurrentProfile::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrCurrentProfile", (tS32)0x2aa26c3a);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrCurrentProfile, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigCSCTrCurrentProfile::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigCSCTrCurrentProfile::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclEarlyConfigCSCTrCurrentProfile::tGetData() {
   vUpdate();
   return tTrCurrentProfile;
};
tS32 dp_tclEarlyConfigCSCTrCurrentProfile::s32GetData(tU8& tTrCurrentProfileParam) { 
   vUpdate();
   tTrCurrentProfileParam = tTrCurrentProfile;
   return _s32Status;
}
tS32 dp_tclEarlyConfigCSCTrCurrentProfile::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrCurrentProfile", (tS32)0x2aa26c3a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigCSCTrCurrentProfile::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigCSCTrCurrentProfile::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigCSCTrCurrentProfile::s32SetData(tU8 &tTrCurrentProfileParam) {
   //init parameter
   (tVoid)memcpy(&tTrCurrentProfile,(tVoid*)&tTrCurrentProfileParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrCurrentProfileParam' in function 'dp_tclEarlyConfigCSCTrCurrentProfile::vSetData(tU8)' could be made const reference
tS32 dp_tclEarlyConfigCSCTrCurrentProfile::s32SetData(const tU8 &tTrCurrentProfileParam) {
   //init parameter
   (tVoid)memcpy(&tTrCurrentProfile,(tVoid*)&tTrCurrentProfileParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrCurrentProfileParam' in function 'dp_tclEarlyConfigCSCTrCurrentProfile::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigCSCTrCurrentProfile::u8GetData(tU8& tTrCurrentProfileParam) {  
   vUpdate();
   tTrCurrentProfileParam = tTrCurrentProfile;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigCSCTrCurrentProfile::vSetData(tU8 &tTrCurrentProfileParam) { 
   //init parameter
   (tVoid)memcpy(&tTrCurrentProfile,(tVoid*)&tTrCurrentProfileParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTrCurrentProfileParam' in function 'dp_tclEarlyConfigCSCTrCurrentProfile::vSetData(tU8)' could be made const reference
tVoid dp_tclEarlyConfigCSCTrCurrentProfile::vSetData(const tU8 &tTrCurrentProfileParam) { 
   //init parameter
   (tVoid)memcpy(&tTrCurrentProfile,(tVoid*)&tTrCurrentProfileParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTrCurrentProfileParam' in function 'dp_tclEarlyConfigCSCTrCurrentProfile::vSetData(tU8)' could be made const reference
tU8   dp_tclEarlyConfigCSCTrCurrentProfile::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigCSCTrCurrentProfile::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrCurrentProfile", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrCurrentProfile::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrCurrentProfile", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrCurrentProfile::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrCurrentProfile", DP_U32_POOL_ID_EARLYCONFIGCSC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGCSC);
   }
   else
   {
      fprintf(stdout,"Element TrCurrentProfile has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrHueValue"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigCSCTrHueValue::dp_tclEarlyConfigCSCTrHueValue(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrHueValue,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigCSCTrHueValue::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrHueValue",(tS32) 0xce67c91);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tTrHueValue = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigCSCTrHueValue::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrHueValue", (tS32)0xce67c91);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrHueValue, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigCSCTrHueValue::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigCSCTrHueValue::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclEarlyConfigCSCTrHueValue::tGetData() {
   vUpdate();
   return tTrHueValue;
};
tS32 dp_tclEarlyConfigCSCTrHueValue::s32GetData(tS16& tTrHueValueParam) { 
   vUpdate();
   tTrHueValueParam = tTrHueValue;
   return _s32Status;
}
tS32 dp_tclEarlyConfigCSCTrHueValue::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrHueValue", (tS32)0xce67c91);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigCSCTrHueValue::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigCSCTrHueValue::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigCSCTrHueValue::s32SetData(tS16 &tTrHueValueParam) {
   //init parameter
   (tVoid)memcpy(&tTrHueValue,(tVoid*)&tTrHueValueParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrHueValueParam' in function 'dp_tclEarlyConfigCSCTrHueValue::vSetData(tS16)' could be made const reference
tS32 dp_tclEarlyConfigCSCTrHueValue::s32SetData(const tS16 &tTrHueValueParam) {
   //init parameter
   (tVoid)memcpy(&tTrHueValue,(tVoid*)&tTrHueValueParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrHueValueParam' in function 'dp_tclEarlyConfigCSCTrHueValue::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigCSCTrHueValue::u8GetData(tS16& tTrHueValueParam) {  
   vUpdate();
   tTrHueValueParam = tTrHueValue;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigCSCTrHueValue::vSetData(tS16 &tTrHueValueParam) { 
   //init parameter
   (tVoid)memcpy(&tTrHueValue,(tVoid*)&tTrHueValueParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tTrHueValueParam' in function 'dp_tclEarlyConfigCSCTrHueValue::vSetData(tS16)' could be made const reference
tVoid dp_tclEarlyConfigCSCTrHueValue::vSetData(const tS16 &tTrHueValueParam) { 
   //init parameter
   (tVoid)memcpy(&tTrHueValue,(tVoid*)&tTrHueValueParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tTrHueValueParam' in function 'dp_tclEarlyConfigCSCTrHueValue::vSetData(tS16)' could be made const reference
tU8   dp_tclEarlyConfigCSCTrHueValue::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigCSCTrHueValue::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrHueValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrHueValue::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrHueValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrHueValue::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrHueValue", DP_U32_POOL_ID_EARLYCONFIGCSC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGCSC);
   }
   else
   {
      fprintf(stdout,"Element TrHueValue has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrContrastValue"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigCSCTrContrastValue::dp_tclEarlyConfigCSCTrContrastValue(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrContrastValue,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigCSCTrContrastValue::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrContrastValue",(tS32) 0x286a7871);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tTrContrastValue = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigCSCTrContrastValue::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrContrastValue", (tS32)0x286a7871);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrContrastValue, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigCSCTrContrastValue::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigCSCTrContrastValue::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclEarlyConfigCSCTrContrastValue::tGetData() {
   vUpdate();
   return tTrContrastValue;
};
tS32 dp_tclEarlyConfigCSCTrContrastValue::s32GetData(tS16& tTrContrastValueParam) { 
   vUpdate();
   tTrContrastValueParam = tTrContrastValue;
   return _s32Status;
}
tS32 dp_tclEarlyConfigCSCTrContrastValue::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrContrastValue", (tS32)0x286a7871);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigCSCTrContrastValue::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigCSCTrContrastValue::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigCSCTrContrastValue::s32SetData(tS16 &tTrContrastValueParam) {
   //init parameter
   (tVoid)memcpy(&tTrContrastValue,(tVoid*)&tTrContrastValueParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrContrastValueParam' in function 'dp_tclEarlyConfigCSCTrContrastValue::vSetData(tS16)' could be made const reference
tS32 dp_tclEarlyConfigCSCTrContrastValue::s32SetData(const tS16 &tTrContrastValueParam) {
   //init parameter
   (tVoid)memcpy(&tTrContrastValue,(tVoid*)&tTrContrastValueParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrContrastValueParam' in function 'dp_tclEarlyConfigCSCTrContrastValue::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigCSCTrContrastValue::u8GetData(tS16& tTrContrastValueParam) {  
   vUpdate();
   tTrContrastValueParam = tTrContrastValue;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigCSCTrContrastValue::vSetData(tS16 &tTrContrastValueParam) { 
   //init parameter
   (tVoid)memcpy(&tTrContrastValue,(tVoid*)&tTrContrastValueParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tTrContrastValueParam' in function 'dp_tclEarlyConfigCSCTrContrastValue::vSetData(tS16)' could be made const reference
tVoid dp_tclEarlyConfigCSCTrContrastValue::vSetData(const tS16 &tTrContrastValueParam) { 
   //init parameter
   (tVoid)memcpy(&tTrContrastValue,(tVoid*)&tTrContrastValueParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tTrContrastValueParam' in function 'dp_tclEarlyConfigCSCTrContrastValue::vSetData(tS16)' could be made const reference
tU8   dp_tclEarlyConfigCSCTrContrastValue::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigCSCTrContrastValue::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrContrastValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrContrastValue::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrContrastValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrContrastValue::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrContrastValue", DP_U32_POOL_ID_EARLYCONFIGCSC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGCSC);
   }
   else
   {
      fprintf(stdout,"Element TrContrastValue has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrSaturationValue"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigCSCTrSaturationValue::dp_tclEarlyConfigCSCTrSaturationValue(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrSaturationValue,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigCSCTrSaturationValue::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrSaturationValue",(tS32) 0xebf8d9d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tTrSaturationValue = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigCSCTrSaturationValue::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrSaturationValue", (tS32)0xebf8d9d);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrSaturationValue, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigCSCTrSaturationValue::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigCSCTrSaturationValue::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclEarlyConfigCSCTrSaturationValue::tGetData() {
   vUpdate();
   return tTrSaturationValue;
};
tS32 dp_tclEarlyConfigCSCTrSaturationValue::s32GetData(tS16& tTrSaturationValueParam) { 
   vUpdate();
   tTrSaturationValueParam = tTrSaturationValue;
   return _s32Status;
}
tS32 dp_tclEarlyConfigCSCTrSaturationValue::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrSaturationValue", (tS32)0xebf8d9d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigCSCTrSaturationValue::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigCSCTrSaturationValue::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigCSCTrSaturationValue::s32SetData(tS16 &tTrSaturationValueParam) {
   //init parameter
   (tVoid)memcpy(&tTrSaturationValue,(tVoid*)&tTrSaturationValueParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrSaturationValueParam' in function 'dp_tclEarlyConfigCSCTrSaturationValue::vSetData(tS16)' could be made const reference
tS32 dp_tclEarlyConfigCSCTrSaturationValue::s32SetData(const tS16 &tTrSaturationValueParam) {
   //init parameter
   (tVoid)memcpy(&tTrSaturationValue,(tVoid*)&tTrSaturationValueParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrSaturationValueParam' in function 'dp_tclEarlyConfigCSCTrSaturationValue::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigCSCTrSaturationValue::u8GetData(tS16& tTrSaturationValueParam) {  
   vUpdate();
   tTrSaturationValueParam = tTrSaturationValue;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigCSCTrSaturationValue::vSetData(tS16 &tTrSaturationValueParam) { 
   //init parameter
   (tVoid)memcpy(&tTrSaturationValue,(tVoid*)&tTrSaturationValueParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tTrSaturationValueParam' in function 'dp_tclEarlyConfigCSCTrSaturationValue::vSetData(tS16)' could be made const reference
tVoid dp_tclEarlyConfigCSCTrSaturationValue::vSetData(const tS16 &tTrSaturationValueParam) { 
   //init parameter
   (tVoid)memcpy(&tTrSaturationValue,(tVoid*)&tTrSaturationValueParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tTrSaturationValueParam' in function 'dp_tclEarlyConfigCSCTrSaturationValue::vSetData(tS16)' could be made const reference
tU8   dp_tclEarlyConfigCSCTrSaturationValue::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigCSCTrSaturationValue::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrSaturationValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrSaturationValue::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrSaturationValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrSaturationValue::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrSaturationValue", DP_U32_POOL_ID_EARLYCONFIGCSC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGCSC);
   }
   else
   {
      fprintf(stdout,"Element TrSaturationValue has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrBrightnessValue"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigCSCTrBrightnessValue::dp_tclEarlyConfigCSCTrBrightnessValue(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrBrightnessValue,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigCSCTrBrightnessValue::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrBrightnessValue",(tS32) 0xee84a270);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tTrBrightnessValue = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigCSCTrBrightnessValue::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrBrightnessValue", (tS32)0xee84a270);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrBrightnessValue, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigCSCTrBrightnessValue::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigCSCTrBrightnessValue::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclEarlyConfigCSCTrBrightnessValue::tGetData() {
   vUpdate();
   return tTrBrightnessValue;
};
tS32 dp_tclEarlyConfigCSCTrBrightnessValue::s32GetData(tS16& tTrBrightnessValueParam) { 
   vUpdate();
   tTrBrightnessValueParam = tTrBrightnessValue;
   return _s32Status;
}
tS32 dp_tclEarlyConfigCSCTrBrightnessValue::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrBrightnessValue", (tS32)0xee84a270);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigCSCTrBrightnessValue::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigCSCTrBrightnessValue::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigCSCTrBrightnessValue::s32SetData(tS16 &tTrBrightnessValueParam) {
   //init parameter
   (tVoid)memcpy(&tTrBrightnessValue,(tVoid*)&tTrBrightnessValueParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrBrightnessValueParam' in function 'dp_tclEarlyConfigCSCTrBrightnessValue::vSetData(tS16)' could be made const reference
tS32 dp_tclEarlyConfigCSCTrBrightnessValue::s32SetData(const tS16 &tTrBrightnessValueParam) {
   //init parameter
   (tVoid)memcpy(&tTrBrightnessValue,(tVoid*)&tTrBrightnessValueParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrBrightnessValueParam' in function 'dp_tclEarlyConfigCSCTrBrightnessValue::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigCSCTrBrightnessValue::u8GetData(tS16& tTrBrightnessValueParam) {  
   vUpdate();
   tTrBrightnessValueParam = tTrBrightnessValue;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigCSCTrBrightnessValue::vSetData(tS16 &tTrBrightnessValueParam) { 
   //init parameter
   (tVoid)memcpy(&tTrBrightnessValue,(tVoid*)&tTrBrightnessValueParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tTrBrightnessValueParam' in function 'dp_tclEarlyConfigCSCTrBrightnessValue::vSetData(tS16)' could be made const reference
tVoid dp_tclEarlyConfigCSCTrBrightnessValue::vSetData(const tS16 &tTrBrightnessValueParam) { 
   //init parameter
   (tVoid)memcpy(&tTrBrightnessValue,(tVoid*)&tTrBrightnessValueParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tTrBrightnessValueParam' in function 'dp_tclEarlyConfigCSCTrBrightnessValue::vSetData(tS16)' could be made const reference
tU8   dp_tclEarlyConfigCSCTrBrightnessValue::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigCSCTrBrightnessValue::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrBrightnessValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrBrightnessValue::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrBrightnessValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrBrightnessValue::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrBrightnessValue", DP_U32_POOL_ID_EARLYCONFIGCSC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGCSC);
   }
   else
   {
      fprintf(stdout,"Element TrBrightnessValue has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrHueOffsetValue"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigCSCTrHueOffsetValue::dp_tclEarlyConfigCSCTrHueOffsetValue(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrHueOffsetValue,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigCSCTrHueOffsetValue::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrHueOffsetValue",(tS32) 0x5c2b4d34);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tTrHueOffsetValue = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigCSCTrHueOffsetValue::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrHueOffsetValue", (tS32)0x5c2b4d34);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrHueOffsetValue, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigCSCTrHueOffsetValue::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigCSCTrHueOffsetValue::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclEarlyConfigCSCTrHueOffsetValue::tGetData() {
   vUpdate();
   return tTrHueOffsetValue;
};
tS32 dp_tclEarlyConfigCSCTrHueOffsetValue::s32GetData(tS16& tTrHueOffsetValueParam) { 
   vUpdate();
   tTrHueOffsetValueParam = tTrHueOffsetValue;
   return _s32Status;
}
tS32 dp_tclEarlyConfigCSCTrHueOffsetValue::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrHueOffsetValue", (tS32)0x5c2b4d34);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigCSCTrHueOffsetValue::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigCSCTrHueOffsetValue::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigCSCTrHueOffsetValue::s32SetData(tS16 &tTrHueOffsetValueParam) {
   //init parameter
   (tVoid)memcpy(&tTrHueOffsetValue,(tVoid*)&tTrHueOffsetValueParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrHueOffsetValueParam' in function 'dp_tclEarlyConfigCSCTrHueOffsetValue::vSetData(tS16)' could be made const reference
tS32 dp_tclEarlyConfigCSCTrHueOffsetValue::s32SetData(const tS16 &tTrHueOffsetValueParam) {
   //init parameter
   (tVoid)memcpy(&tTrHueOffsetValue,(tVoid*)&tTrHueOffsetValueParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrHueOffsetValueParam' in function 'dp_tclEarlyConfigCSCTrHueOffsetValue::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigCSCTrHueOffsetValue::u8GetData(tS16& tTrHueOffsetValueParam) {  
   vUpdate();
   tTrHueOffsetValueParam = tTrHueOffsetValue;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigCSCTrHueOffsetValue::vSetData(tS16 &tTrHueOffsetValueParam) { 
   //init parameter
   (tVoid)memcpy(&tTrHueOffsetValue,(tVoid*)&tTrHueOffsetValueParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tTrHueOffsetValueParam' in function 'dp_tclEarlyConfigCSCTrHueOffsetValue::vSetData(tS16)' could be made const reference
tVoid dp_tclEarlyConfigCSCTrHueOffsetValue::vSetData(const tS16 &tTrHueOffsetValueParam) { 
   //init parameter
   (tVoid)memcpy(&tTrHueOffsetValue,(tVoid*)&tTrHueOffsetValueParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tTrHueOffsetValueParam' in function 'dp_tclEarlyConfigCSCTrHueOffsetValue::vSetData(tS16)' could be made const reference
tU8   dp_tclEarlyConfigCSCTrHueOffsetValue::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigCSCTrHueOffsetValue::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrHueOffsetValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrHueOffsetValue::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrHueOffsetValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrHueOffsetValue::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrHueOffsetValue", DP_U32_POOL_ID_EARLYCONFIGCSC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGCSC);
   }
   else
   {
      fprintf(stdout,"Element TrHueOffsetValue has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrSaturationOffsetValue"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigCSCTrSaturationOffsetValue::dp_tclEarlyConfigCSCTrSaturationOffsetValue(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrSaturationOffsetValue,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigCSCTrSaturationOffsetValue::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrSaturationOffsetValue",(tS32) 0x25dcc2a0);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tTrSaturationOffsetValue = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigCSCTrSaturationOffsetValue::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrSaturationOffsetValue", (tS32)0x25dcc2a0);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrSaturationOffsetValue, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigCSCTrSaturationOffsetValue::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigCSCTrSaturationOffsetValue::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclEarlyConfigCSCTrSaturationOffsetValue::tGetData() {
   vUpdate();
   return tTrSaturationOffsetValue;
};
tS32 dp_tclEarlyConfigCSCTrSaturationOffsetValue::s32GetData(tS16& tTrSaturationOffsetValueParam) { 
   vUpdate();
   tTrSaturationOffsetValueParam = tTrSaturationOffsetValue;
   return _s32Status;
}
tS32 dp_tclEarlyConfigCSCTrSaturationOffsetValue::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrSaturationOffsetValue", (tS32)0x25dcc2a0);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigCSCTrSaturationOffsetValue::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigCSCTrSaturationOffsetValue::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigCSCTrSaturationOffsetValue::s32SetData(tS16 &tTrSaturationOffsetValueParam) {
   //init parameter
   (tVoid)memcpy(&tTrSaturationOffsetValue,(tVoid*)&tTrSaturationOffsetValueParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrSaturationOffsetValueParam' in function 'dp_tclEarlyConfigCSCTrSaturationOffsetValue::vSetData(tS16)' could be made const reference
tS32 dp_tclEarlyConfigCSCTrSaturationOffsetValue::s32SetData(const tS16 &tTrSaturationOffsetValueParam) {
   //init parameter
   (tVoid)memcpy(&tTrSaturationOffsetValue,(tVoid*)&tTrSaturationOffsetValueParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrSaturationOffsetValueParam' in function 'dp_tclEarlyConfigCSCTrSaturationOffsetValue::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigCSCTrSaturationOffsetValue::u8GetData(tS16& tTrSaturationOffsetValueParam) {  
   vUpdate();
   tTrSaturationOffsetValueParam = tTrSaturationOffsetValue;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigCSCTrSaturationOffsetValue::vSetData(tS16 &tTrSaturationOffsetValueParam) { 
   //init parameter
   (tVoid)memcpy(&tTrSaturationOffsetValue,(tVoid*)&tTrSaturationOffsetValueParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tTrSaturationOffsetValueParam' in function 'dp_tclEarlyConfigCSCTrSaturationOffsetValue::vSetData(tS16)' could be made const reference
tVoid dp_tclEarlyConfigCSCTrSaturationOffsetValue::vSetData(const tS16 &tTrSaturationOffsetValueParam) { 
   //init parameter
   (tVoid)memcpy(&tTrSaturationOffsetValue,(tVoid*)&tTrSaturationOffsetValueParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tTrSaturationOffsetValueParam' in function 'dp_tclEarlyConfigCSCTrSaturationOffsetValue::vSetData(tS16)' could be made const reference
tU8   dp_tclEarlyConfigCSCTrSaturationOffsetValue::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigCSCTrSaturationOffsetValue::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrSaturationOffsetValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrSaturationOffsetValue::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrSaturationOffsetValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrSaturationOffsetValue::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrSaturationOffsetValue", DP_U32_POOL_ID_EARLYCONFIGCSC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGCSC);
   }
   else
   {
      fprintf(stdout,"Element TrSaturationOffsetValue has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrBrightnessOffsetValue"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigCSCTrBrightnessOffsetValue::dp_tclEarlyConfigCSCTrBrightnessOffsetValue(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrBrightnessOffsetValue,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigCSCTrBrightnessOffsetValue::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrBrightnessOffsetValue",(tS32) 0xf9c0c50b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tTrBrightnessOffsetValue = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigCSCTrBrightnessOffsetValue::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrBrightnessOffsetValue", (tS32)0xf9c0c50b);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrBrightnessOffsetValue, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigCSCTrBrightnessOffsetValue::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigCSCTrBrightnessOffsetValue::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclEarlyConfigCSCTrBrightnessOffsetValue::tGetData() {
   vUpdate();
   return tTrBrightnessOffsetValue;
};
tS32 dp_tclEarlyConfigCSCTrBrightnessOffsetValue::s32GetData(tS16& tTrBrightnessOffsetValueParam) { 
   vUpdate();
   tTrBrightnessOffsetValueParam = tTrBrightnessOffsetValue;
   return _s32Status;
}
tS32 dp_tclEarlyConfigCSCTrBrightnessOffsetValue::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrBrightnessOffsetValue", (tS32)0xf9c0c50b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigCSCTrBrightnessOffsetValue::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigCSCTrBrightnessOffsetValue::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigCSCTrBrightnessOffsetValue::s32SetData(tS16 &tTrBrightnessOffsetValueParam) {
   //init parameter
   (tVoid)memcpy(&tTrBrightnessOffsetValue,(tVoid*)&tTrBrightnessOffsetValueParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrBrightnessOffsetValueParam' in function 'dp_tclEarlyConfigCSCTrBrightnessOffsetValue::vSetData(tS16)' could be made const reference
tS32 dp_tclEarlyConfigCSCTrBrightnessOffsetValue::s32SetData(const tS16 &tTrBrightnessOffsetValueParam) {
   //init parameter
   (tVoid)memcpy(&tTrBrightnessOffsetValue,(tVoid*)&tTrBrightnessOffsetValueParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrBrightnessOffsetValueParam' in function 'dp_tclEarlyConfigCSCTrBrightnessOffsetValue::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigCSCTrBrightnessOffsetValue::u8GetData(tS16& tTrBrightnessOffsetValueParam) {  
   vUpdate();
   tTrBrightnessOffsetValueParam = tTrBrightnessOffsetValue;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigCSCTrBrightnessOffsetValue::vSetData(tS16 &tTrBrightnessOffsetValueParam) { 
   //init parameter
   (tVoid)memcpy(&tTrBrightnessOffsetValue,(tVoid*)&tTrBrightnessOffsetValueParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tTrBrightnessOffsetValueParam' in function 'dp_tclEarlyConfigCSCTrBrightnessOffsetValue::vSetData(tS16)' could be made const reference
tVoid dp_tclEarlyConfigCSCTrBrightnessOffsetValue::vSetData(const tS16 &tTrBrightnessOffsetValueParam) { 
   //init parameter
   (tVoid)memcpy(&tTrBrightnessOffsetValue,(tVoid*)&tTrBrightnessOffsetValueParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tTrBrightnessOffsetValueParam' in function 'dp_tclEarlyConfigCSCTrBrightnessOffsetValue::vSetData(tS16)' could be made const reference
tU8   dp_tclEarlyConfigCSCTrBrightnessOffsetValue::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigCSCTrBrightnessOffsetValue::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrBrightnessOffsetValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrBrightnessOffsetValue::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrBrightnessOffsetValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrBrightnessOffsetValue::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrBrightnessOffsetValue", DP_U32_POOL_ID_EARLYCONFIGCSC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGCSC);
   }
   else
   {
      fprintf(stdout,"Element TrBrightnessOffsetValue has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TrGammaFactor"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclEarlyConfigCSCTrGammaFactor::dp_tclEarlyConfigCSCTrGammaFactor(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTrGammaFactor,0,sizeof(tF64));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclEarlyConfigCSCTrGammaFactor::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TrGammaFactor",(tS32) 0x49eaea48);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tF64)) 
      {
         tTrGammaFactor = *((tF64*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclEarlyConfigCSCTrGammaFactor::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TrGammaFactor", (tS32)0x49eaea48);
   (tVoid)myDpElem.bFillData((tVoid*)&tTrGammaFactor, (tU32)sizeof(tF64));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclEarlyConfigCSCTrGammaFactor::s32GetStatus() const {return _s32Status;};
tU8   dp_tclEarlyConfigCSCTrGammaFactor::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tF64 dp_tclEarlyConfigCSCTrGammaFactor::tGetData() {
   vUpdate();
   return tTrGammaFactor;
};
tS32 dp_tclEarlyConfigCSCTrGammaFactor::s32GetData(tF64& tTrGammaFactorParam) { 
   vUpdate();
   tTrGammaFactorParam = tTrGammaFactor;
   return _s32Status;
}
tS32 dp_tclEarlyConfigCSCTrGammaFactor::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TrGammaFactor", (tS32)0x49eaea48);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_EARLYCONFIGCSC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclEarlyConfigCSCTrGammaFactor::operator>>(tF64& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclEarlyConfigCSCTrGammaFactor::operator<<(tF64 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclEarlyConfigCSCTrGammaFactor::s32SetData(tF64 &tTrGammaFactorParam) {
   //init parameter
   (tVoid)memcpy(&tTrGammaFactor,(tVoid*)&tTrGammaFactorParam, sizeof(tF64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrGammaFactorParam' in function 'dp_tclEarlyConfigCSCTrGammaFactor::vSetData(tF64)' could be made const reference
tS32 dp_tclEarlyConfigCSCTrGammaFactor::s32SetData(const tF64 &tTrGammaFactorParam) {
   //init parameter
   (tVoid)memcpy(&tTrGammaFactor,(tVoid*)&tTrGammaFactorParam, sizeof(tF64));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTrGammaFactorParam' in function 'dp_tclEarlyConfigCSCTrGammaFactor::vSetData(tF64)' could be made const reference
// do not use --> old interface
tU8 dp_tclEarlyConfigCSCTrGammaFactor::u8GetData(tF64& tTrGammaFactorParam) {  
   vUpdate();
   tTrGammaFactorParam = tTrGammaFactor;
   return _u8DataStatus;
}
tVoid dp_tclEarlyConfigCSCTrGammaFactor::vSetData(tF64 &tTrGammaFactorParam) { 
   //init parameter
   (tVoid)memcpy(&tTrGammaFactor,(tVoid*)&tTrGammaFactorParam, sizeof(tF64));
   vStore();
}//lint !e1746: parameter 'tTrGammaFactorParam' in function 'dp_tclEarlyConfigCSCTrGammaFactor::vSetData(tF64)' could be made const reference
tVoid dp_tclEarlyConfigCSCTrGammaFactor::vSetData(const tF64 &tTrGammaFactorParam) { 
   //init parameter
   (tVoid)memcpy(&tTrGammaFactor,(tVoid*)&tTrGammaFactorParam, sizeof(tF64));
   vStore();
}//lint !e1746: parameter 'tTrGammaFactorParam' in function 'dp_tclEarlyConfigCSCTrGammaFactor::vSetData(tF64)' could be made const reference
tU8   dp_tclEarlyConfigCSCTrGammaFactor::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclEarlyConfigCSCTrGammaFactor::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrGammaFactor", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrGammaFactor::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_EARLYCONFIGCSC, "TrGammaFactor", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclEarlyConfigCSCTrGammaFactor::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TrGammaFactor", DP_U32_POOL_ID_EARLYCONFIGCSC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_EARLYCONFIGCSC);
   }
   else
   {
      fprintf(stdout,"Element TrGammaFactor has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
