#ifndef _DP_FI_DIMMINGDPPDD_H
#define _DP_FI_DIMMINGDPPDD_H

extern tVoid vInitDimmingDpPDD(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define DISPVIDCTRL_S_IMPORT_INTERFACE_DP_DIMMING_PDD 
#include "../../di_cfc/components/DisplayVideoController/interfaces/dispvidmgr_dp_if.h"
//lint +e750




class dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_NIGHT{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_NIGHT(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_NIGHT() {};

   //read access for pool element 
   tS32  s32GetData(tU16* tBRIGTHNESS_CURVE_HMI_NIGHTParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU16* tBRIGTHNESS_CURVE_HMI_NIGHTParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU16* tBRIGTHNESS_CURVE_HMI_NIGHTParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_DAY{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_DAY(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_DAY() {};

   //read access for pool element 
   tS32  s32GetData(tU16* tBRIGTHNESS_CURVE_HMI_DAYParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU16* tBRIGTHNESS_CURVE_HMI_DAYParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU16* tBRIGTHNESS_CURVE_HMI_DAYParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY;
   
public:
   dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam);
   tS32  s32SetData(const tU16 &tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam);
   tVoid vSetData(const tU16& tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY;
   
public:
   dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam);
   tS32  s32SetData(const tU16 &tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam);
   tVoid vSetData(const tU16& tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tBRIGTHNESS_NO_OF_HMI_OFFSET;
   
public:
   dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tBRIGTHNESS_NO_OF_HMI_OFFSETParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tBRIGTHNESS_NO_OF_HMI_OFFSETParam);
   tS32  s32SetData(const tU8 &tBRIGTHNESS_NO_OF_HMI_OFFSETParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tBRIGTHNESS_NO_OF_HMI_OFFSETParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tBRIGTHNESS_NO_OF_HMI_OFFSETParam);
   tVoid vSetData(const tU8& tBRIGTHNESS_NO_OF_HMI_OFFSETParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDNUMBER_OF_KEYS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tNUMBER_OF_KEYS;
   
public:
   dp_tclDimmingDpPDDNUMBER_OF_KEYS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDNUMBER_OF_KEYS() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tNUMBER_OF_KEYSParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tNUMBER_OF_KEYSParam);
   tS32  s32SetData(const tU8 &tNUMBER_OF_KEYSParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tNUMBER_OF_KEYSParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tNUMBER_OF_KEYSParam);
   tVoid vSetData(const tU8& tNUMBER_OF_KEYSParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDHIGH_TEMPERATURE{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tHIGH_TEMPERATURE;
   
public:
   dp_tclDimmingDpPDDHIGH_TEMPERATURE(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDHIGH_TEMPERATURE() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tHIGH_TEMPERATUREParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tHIGH_TEMPERATUREParam);
   tS32  s32SetData(const tU8 &tHIGH_TEMPERATUREParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tHIGH_TEMPERATUREParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tHIGH_TEMPERATUREParam);
   tVoid vSetData(const tU8& tHIGH_TEMPERATUREParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDCRITICAL_TEMPERATURE{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tCRITICAL_TEMPERATURE;
   
public:
   dp_tclDimmingDpPDDCRITICAL_TEMPERATURE(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDCRITICAL_TEMPERATURE() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tCRITICAL_TEMPERATUREParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tCRITICAL_TEMPERATUREParam);
   tS32  s32SetData(const tU8 &tCRITICAL_TEMPERATUREParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tCRITICAL_TEMPERATUREParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tCRITICAL_TEMPERATUREParam);
   tVoid vSetData(const tU8& tCRITICAL_TEMPERATUREParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDLOW_TEMPERATURE{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tLOW_TEMPERATURE;
   
public:
   dp_tclDimmingDpPDDLOW_TEMPERATURE(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDLOW_TEMPERATURE() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tLOW_TEMPERATUREParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tLOW_TEMPERATUREParam);
   tS32  s32SetData(const tS8 &tLOW_TEMPERATUREParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tLOW_TEMPERATUREParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tLOW_TEMPERATUREParam);
   tVoid vSetData(const tS8& tLOW_TEMPERATUREParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDTEMP_HYSTERESIS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tTEMP_HYSTERESIS;
   
public:
   dp_tclDimmingDpPDDTEMP_HYSTERESIS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDTEMP_HYSTERESIS() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tTEMP_HYSTERESISParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tTEMP_HYSTERESISParam);
   tS32  s32SetData(const tU8 &tTEMP_HYSTERESISParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tTEMP_HYSTERESISParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tTEMP_HYSTERESISParam);
   tVoid vSetData(const tU8& tTEMP_HYSTERESISParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tTEMP_COMPENSATION_PWM_MIN;
   
public:
   dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tTEMP_COMPENSATION_PWM_MINParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tTEMP_COMPENSATION_PWM_MINParam);
   tS32  s32SetData(const tU8 &tTEMP_COMPENSATION_PWM_MINParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tTEMP_COMPENSATION_PWM_MINParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tTEMP_COMPENSATION_PWM_MINParam);
   tVoid vSetData(const tU8& tTEMP_COMPENSATION_PWM_MINParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDKEYB_LED_CALIBRATION_VALUE{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDimmingDpPDDKEYB_LED_CALIBRATION_VALUE(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDKEYB_LED_CALIBRATION_VALUE() {};

   //read access for pool element 
   tS32  s32GetData(tU16* tKEYB_LED_CALIBRATION_VALUEParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU16* tKEYB_LED_CALIBRATION_VALUEParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU16* tKEYB_LED_CALIBRATION_VALUEParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDimmingDpPDDBRANDNAME{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tBRANDNAME;
   
public:
   dp_tclDimmingDpPDDBRANDNAME(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDBRANDNAME() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tBRANDNAMEParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tBRANDNAMEParam);
   tS32  s32SetData(const tU8 &tBRANDNAMEParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tBRANDNAMEParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tBRANDNAMEParam);
   tVoid vSetData(const tU8& tBRANDNAMEParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDDISPLAY_TYPE{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDISPLAY_TYPE;
   
public:
   dp_tclDimmingDpPDDDISPLAY_TYPE(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDDISPLAY_TYPE() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDISPLAY_TYPEParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDISPLAY_TYPEParam);
   tS32  s32SetData(const tU8 &tDISPLAY_TYPEParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDISPLAY_TYPEParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDISPLAY_TYPEParam);
   tVoid vSetData(const tU8& tDISPLAY_TYPEParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDIMMING_COCKPIT_STRATEGY;
   
public:
   dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDIMMING_COCKPIT_STRATEGYParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDIMMING_COCKPIT_STRATEGYParam);
   tS32  s32SetData(const tU8 &tDIMMING_COCKPIT_STRATEGYParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDIMMING_COCKPIT_STRATEGYParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDIMMING_COCKPIT_STRATEGYParam);
   tVoid vSetData(const tU8& tDIMMING_COCKPIT_STRATEGYParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tKEY_BRIGHTNESS_NUMOF_OFFSETS;
   
public:
   dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tKEY_BRIGHTNESS_NUMOF_OFFSETSParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tKEY_BRIGHTNESS_NUMOF_OFFSETSParam);
   tS32  s32SetData(const tU8 &tKEY_BRIGHTNESS_NUMOF_OFFSETSParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tKEY_BRIGHTNESS_NUMOF_OFFSETSParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tKEY_BRIGHTNESS_NUMOF_OFFSETSParam);
   tVoid vSetData(const tU8& tKEY_BRIGHTNESS_NUMOF_OFFSETSParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDDAMPING_STRATEGY{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDAMPING_STRATEGY;
   
public:
   dp_tclDimmingDpPDDDAMPING_STRATEGY(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDDAMPING_STRATEGY() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDAMPING_STRATEGYParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDAMPING_STRATEGYParam);
   tS32  s32SetData(const tU8 &tDAMPING_STRATEGYParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDAMPING_STRATEGYParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDAMPING_STRATEGYParam);
   tVoid vSetData(const tU8& tDAMPING_STRATEGYParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDAMPING_SAMPLING_TIMETE;
   
public:
   dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDAMPING_SAMPLING_TIMETEParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDAMPING_SAMPLING_TIMETEParam);
   tS32  s32SetData(const tU8 &tDAMPING_SAMPLING_TIMETEParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDAMPING_SAMPLING_TIMETEParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDAMPING_SAMPLING_TIMETEParam);
   tVoid vSetData(const tU8& tDAMPING_SAMPLING_TIMETEParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDDAMPING_CONSTANTK{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDAMPING_CONSTANTK;
   
public:
   dp_tclDimmingDpPDDDAMPING_CONSTANTK(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDDAMPING_CONSTANTK() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDAMPING_CONSTANTKParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDAMPING_CONSTANTKParam);
   tS32  s32SetData(const tU8 &tDAMPING_CONSTANTKParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDAMPING_CONSTANTKParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDAMPING_CONSTANTKParam);
   tVoid vSetData(const tU8& tDAMPING_CONSTANTKParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDDAMPING_CONSTANTJ{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDAMPING_CONSTANTJ;
   
public:
   dp_tclDimmingDpPDDDAMPING_CONSTANTJ(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDDAMPING_CONSTANTJ() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDAMPING_CONSTANTJParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDAMPING_CONSTANTJParam);
   tS32  s32SetData(const tU8 &tDAMPING_CONSTANTJParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDAMPING_CONSTANTJParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDAMPING_CONSTANTJParam);
   tVoid vSetData(const tU8& tDAMPING_CONSTANTJParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY;
   
public:
   dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam);
   tS32  s32SetData(const tU16 &tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam);
   tVoid vSetData(const tU16& tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT;
   
public:
   dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam);
   tS32  s32SetData(const tU16 &tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam);
   tVoid vSetData(const tU16& tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT;
   
public:
   dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam);
   tS32  s32SetData(const tU16 &tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam);
   tVoid vSetData(const tU16& tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON;
   
public:
   dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam);
   tS32  s32SetData(const tU16 &tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam);
   tVoid vSetData(const tU16& tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF;
   
public:
   dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam);
   tS32  s32SetData(const tU16 &tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam);
   tVoid vSetData(const tU16& tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON() {};

   //read access for pool element 
   tS32  s32GetData(tU16* tBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ONParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU16* tBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ONParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU16* tBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ONParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDimmingDpPDDDAY_NIGHT_DELAY{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tDAY_NIGHT_DELAY;
   
public:
   dp_tclDimmingDpPDDDAY_NIGHT_DELAY(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDDAY_NIGHT_DELAY() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tDAY_NIGHT_DELAYParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tDAY_NIGHT_DELAYParam);
   tS32  s32SetData(const tU16 &tDAY_NIGHT_DELAYParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tDAY_NIGHT_DELAYParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tDAY_NIGHT_DELAYParam);
   tVoid vSetData(const tU16& tDAY_NIGHT_DELAYParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDpPDDDIMMING_ARCHITECTURE{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDIMMING_ARCHITECTURE;
   
public:
   dp_tclDimmingDpPDDDIMMING_ARCHITECTURE(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDpPDDDIMMING_ARCHITECTURE() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDIMMING_ARCHITECTUREParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDIMMING_ARCHITECTUREParam);
   tS32  s32SetData(const tU8 &tDIMMING_ARCHITECTUREParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDIMMING_ARCHITECTUREParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDIMMING_ARCHITECTUREParam);
   tVoid vSetData(const tU8& tDIMMING_ARCHITECTUREParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
