
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclDimmingDpPDD.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BRIGTHNESS_CURVE_HMI_NIGHT"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_NIGHT::dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_NIGHT(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_NIGHT::s32SetData( tU16* tBRIGTHNESS_CURVE_HMI_NIGHTParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("BRIGTHNESS_CURVE_HMI_NIGHT", (tS32)0x64982a7bL);
   (tVoid)myDpElem.bFillData((tVoid*)tBRIGTHNESS_CURVE_HMI_NIGHTParam, ((tU32)sizeof(tU16))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_NIGHT::s32GetData(tU16* tBRIGTHNESS_CURVE_HMI_NIGHTParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("BRIGTHNESS_CURVE_HMI_NIGHT", (tS32)0x64982a7bL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU16)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU16));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBRIGTHNESS_CURVE_HMI_NIGHTParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU16));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_NIGHT::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_NIGHT::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_NIGHT::u16GetData(tU16* tBRIGTHNESS_CURVE_HMI_NIGHTParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBRIGTHNESS_CURVE_HMI_NIGHTParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_NIGHT::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_CURVE_HMI_NIGHT", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_NIGHT::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_CURVE_HMI_NIGHT", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_NIGHT::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BRIGTHNESS_CURVE_HMI_NIGHT", DP_U32_POOL_ID_DIMMINGDPPDD);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
		}
		else
		{
			fprintf(stdout,"Element BRIGTHNESS_CURVE_HMI_NIGHT has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BRIGTHNESS_CURVE_HMI_DAY"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_DAY::dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_DAY(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_DAY::s32SetData( tU16* tBRIGTHNESS_CURVE_HMI_DAYParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("BRIGTHNESS_CURVE_HMI_DAY", (tS32)0x4bb42987);
   (tVoid)myDpElem.bFillData((tVoid*)tBRIGTHNESS_CURVE_HMI_DAYParam, ((tU32)sizeof(tU16))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_DAY::s32GetData(tU16* tBRIGTHNESS_CURVE_HMI_DAYParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("BRIGTHNESS_CURVE_HMI_DAY", (tS32)0x4bb42987);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU16)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU16));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBRIGTHNESS_CURVE_HMI_DAYParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU16));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_DAY::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_DAY::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_DAY::u16GetData(tU16* tBRIGTHNESS_CURVE_HMI_DAYParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBRIGTHNESS_CURVE_HMI_DAYParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_DAY::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_CURVE_HMI_DAY", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_DAY::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_CURVE_HMI_DAY", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDimmingDpPDDBRIGTHNESS_CURVE_HMI_DAY::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BRIGTHNESS_CURVE_HMI_DAY", DP_U32_POOL_ID_DIMMINGDPPDD);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
		}
		else
		{
			fprintf(stdout,"Element BRIGTHNESS_CURVE_HMI_DAY has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISPLAY_ILLUMINATION_OUTPUT_FREQUENCY"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISPLAY_ILLUMINATION_OUTPUT_FREQUENCY",(tS32) 0xd65454efL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISPLAY_ILLUMINATION_OUTPUT_FREQUENCY", (tS32)0xd65454efL);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::tGetData() {
   vUpdate();
   return tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY;
};
tS32 dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::s32GetData(tU16& tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam) { 
   vUpdate();
   tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam = tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISPLAY_ILLUMINATION_OUTPUT_FREQUENCY", (tS32)0xd65454efL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::s32SetData(tU16 &tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam) {
   //init parameter
   (tVoid)memcpy(&tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY,(tVoid*)&tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam' in function 'dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::vSetData(tU16)' could be made const reference
tS32 dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::s32SetData(const tU16 &tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam) {
   //init parameter
   (tVoid)memcpy(&tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY,(tVoid*)&tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam' in function 'dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::u8GetData(tU16& tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam) {  
   vUpdate();
   tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam = tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::vSetData(tU16 &tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam) { 
   //init parameter
   (tVoid)memcpy(&tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY,(tVoid*)&tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam' in function 'dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::vSetData(tU16)' could be made const reference
tVoid dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::vSetData(const tU16 &tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam) { 
   //init parameter
   (tVoid)memcpy(&tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY,(tVoid*)&tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDISPLAY_ILLUMINATION_OUTPUT_FREQUENCYParam' in function 'dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::vSetData(tU16)' could be made const reference
tU8   dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DISPLAY_ILLUMINATION_OUTPUT_FREQUENCY", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DISPLAY_ILLUMINATION_OUTPUT_FREQUENCY", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDISPLAY_ILLUMINATION_OUTPUT_FREQUENCY::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISPLAY_ILLUMINATION_OUTPUT_FREQUENCY", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element DISPLAY_ILLUMINATION_OUTPUT_FREQUENCY has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "KEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("KEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY",(tS32) 0x148dea40L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::vStore(tVoid) {
   dp_tclBaseElement myDpElem("KEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY", (tS32)0x148dea40L);
   (tVoid)myDpElem.bFillData((tVoid*)&tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::tGetData() {
   vUpdate();
   return tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY;
};
tS32 dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::s32GetData(tU16& tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam) { 
   vUpdate();
   tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam = tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("KEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY", (tS32)0x148dea40L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::s32SetData(tU16 &tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam) {
   //init parameter
   (tVoid)memcpy(&tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY,(tVoid*)&tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam' in function 'dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::vSetData(tU16)' could be made const reference
tS32 dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::s32SetData(const tU16 &tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam) {
   //init parameter
   (tVoid)memcpy(&tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY,(tVoid*)&tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam' in function 'dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::u8GetData(tU16& tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam) {  
   vUpdate();
   tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam = tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::vSetData(tU16 &tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam) { 
   //init parameter
   (tVoid)memcpy(&tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY,(tVoid*)&tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam' in function 'dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::vSetData(tU16)' could be made const reference
tVoid dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::vSetData(const tU16 &tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam) { 
   //init parameter
   (tVoid)memcpy(&tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY,(tVoid*)&tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCYParam' in function 'dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::vSetData(tU16)' could be made const reference
tU8   dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "KEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "KEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDKEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: KEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element KEYS_ENCODER_ILLUMINATION_OUTPUT_FREQUENCY has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BRIGTHNESS_NO_OF_HMI_OFFSET"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBRIGTHNESS_NO_OF_HMI_OFFSET,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("BRIGTHNESS_NO_OF_HMI_OFFSET",(tS32) 0xe7fd5cb8L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tBRIGTHNESS_NO_OF_HMI_OFFSET = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::vStore(tVoid) {
   dp_tclBaseElement myDpElem("BRIGTHNESS_NO_OF_HMI_OFFSET", (tS32)0xe7fd5cb8L);
   (tVoid)myDpElem.bFillData((tVoid*)&tBRIGTHNESS_NO_OF_HMI_OFFSET, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::tGetData() {
   vUpdate();
   return tBRIGTHNESS_NO_OF_HMI_OFFSET;
};
tS32 dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::s32GetData(tU8& tBRIGTHNESS_NO_OF_HMI_OFFSETParam) { 
   vUpdate();
   tBRIGTHNESS_NO_OF_HMI_OFFSETParam = tBRIGTHNESS_NO_OF_HMI_OFFSET;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("BRIGTHNESS_NO_OF_HMI_OFFSET", (tS32)0xe7fd5cb8L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::s32SetData(tU8 &tBRIGTHNESS_NO_OF_HMI_OFFSETParam) {
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_NO_OF_HMI_OFFSET,(tVoid*)&tBRIGTHNESS_NO_OF_HMI_OFFSETParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBRIGTHNESS_NO_OF_HMI_OFFSETParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::s32SetData(const tU8 &tBRIGTHNESS_NO_OF_HMI_OFFSETParam) {
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_NO_OF_HMI_OFFSET,(tVoid*)&tBRIGTHNESS_NO_OF_HMI_OFFSETParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBRIGTHNESS_NO_OF_HMI_OFFSETParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::u8GetData(tU8& tBRIGTHNESS_NO_OF_HMI_OFFSETParam) {  
   vUpdate();
   tBRIGTHNESS_NO_OF_HMI_OFFSETParam = tBRIGTHNESS_NO_OF_HMI_OFFSET;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::vSetData(tU8 &tBRIGTHNESS_NO_OF_HMI_OFFSETParam) { 
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_NO_OF_HMI_OFFSET,(tVoid*)&tBRIGTHNESS_NO_OF_HMI_OFFSETParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tBRIGTHNESS_NO_OF_HMI_OFFSETParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::vSetData(const tU8 &tBRIGTHNESS_NO_OF_HMI_OFFSETParam) { 
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_NO_OF_HMI_OFFSET,(tVoid*)&tBRIGTHNESS_NO_OF_HMI_OFFSETParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tBRIGTHNESS_NO_OF_HMI_OFFSETParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_NO_OF_HMI_OFFSET", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_NO_OF_HMI_OFFSET", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDBRIGTHNESS_NO_OF_HMI_OFFSET::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BRIGTHNESS_NO_OF_HMI_OFFSET", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element BRIGTHNESS_NO_OF_HMI_OFFSET has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "NUMBER_OF_KEYS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDNUMBER_OF_KEYS::dp_tclDimmingDpPDDNUMBER_OF_KEYS(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tNUMBER_OF_KEYS,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDNUMBER_OF_KEYS::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("NUMBER_OF_KEYS",(tS32) 0x1126c094);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tNUMBER_OF_KEYS = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDNUMBER_OF_KEYS::vStore(tVoid) {
   dp_tclBaseElement myDpElem("NUMBER_OF_KEYS", (tS32)0x1126c094);
   (tVoid)myDpElem.bFillData((tVoid*)&tNUMBER_OF_KEYS, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDNUMBER_OF_KEYS::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDNUMBER_OF_KEYS::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDpPDDNUMBER_OF_KEYS::tGetData() {
   vUpdate();
   return tNUMBER_OF_KEYS;
};
tS32 dp_tclDimmingDpPDDNUMBER_OF_KEYS::s32GetData(tU8& tNUMBER_OF_KEYSParam) { 
   vUpdate();
   tNUMBER_OF_KEYSParam = tNUMBER_OF_KEYS;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDNUMBER_OF_KEYS::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("NUMBER_OF_KEYS", (tS32)0x1126c094);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDNUMBER_OF_KEYS::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDNUMBER_OF_KEYS::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDNUMBER_OF_KEYS::s32SetData(tU8 &tNUMBER_OF_KEYSParam) {
   //init parameter
   (tVoid)memcpy(&tNUMBER_OF_KEYS,(tVoid*)&tNUMBER_OF_KEYSParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNUMBER_OF_KEYSParam' in function 'dp_tclDimmingDpPDDNUMBER_OF_KEYS::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDpPDDNUMBER_OF_KEYS::s32SetData(const tU8 &tNUMBER_OF_KEYSParam) {
   //init parameter
   (tVoid)memcpy(&tNUMBER_OF_KEYS,(tVoid*)&tNUMBER_OF_KEYSParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNUMBER_OF_KEYSParam' in function 'dp_tclDimmingDpPDDNUMBER_OF_KEYS::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDNUMBER_OF_KEYS::u8GetData(tU8& tNUMBER_OF_KEYSParam) {  
   vUpdate();
   tNUMBER_OF_KEYSParam = tNUMBER_OF_KEYS;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDNUMBER_OF_KEYS::vSetData(tU8 &tNUMBER_OF_KEYSParam) { 
   //init parameter
   (tVoid)memcpy(&tNUMBER_OF_KEYS,(tVoid*)&tNUMBER_OF_KEYSParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tNUMBER_OF_KEYSParam' in function 'dp_tclDimmingDpPDDNUMBER_OF_KEYS::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDpPDDNUMBER_OF_KEYS::vSetData(const tU8 &tNUMBER_OF_KEYSParam) { 
   //init parameter
   (tVoid)memcpy(&tNUMBER_OF_KEYS,(tVoid*)&tNUMBER_OF_KEYSParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tNUMBER_OF_KEYSParam' in function 'dp_tclDimmingDpPDDNUMBER_OF_KEYS::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDpPDDNUMBER_OF_KEYS::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDNUMBER_OF_KEYS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "NUMBER_OF_KEYS", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDNUMBER_OF_KEYS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "NUMBER_OF_KEYS", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDNUMBER_OF_KEYS::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: NUMBER_OF_KEYS", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element NUMBER_OF_KEYS has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "HIGH_TEMPERATURE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDHIGH_TEMPERATURE::dp_tclDimmingDpPDDHIGH_TEMPERATURE(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tHIGH_TEMPERATURE,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDHIGH_TEMPERATURE::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("HIGH_TEMPERATURE",(tS32) 0xe9cfcb29);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tHIGH_TEMPERATURE = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDHIGH_TEMPERATURE::vStore(tVoid) {
   dp_tclBaseElement myDpElem("HIGH_TEMPERATURE", (tS32)0xe9cfcb29);
   (tVoid)myDpElem.bFillData((tVoid*)&tHIGH_TEMPERATURE, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDHIGH_TEMPERATURE::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDHIGH_TEMPERATURE::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDpPDDHIGH_TEMPERATURE::tGetData() {
   vUpdate();
   return tHIGH_TEMPERATURE;
};
tS32 dp_tclDimmingDpPDDHIGH_TEMPERATURE::s32GetData(tU8& tHIGH_TEMPERATUREParam) { 
   vUpdate();
   tHIGH_TEMPERATUREParam = tHIGH_TEMPERATURE;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDHIGH_TEMPERATURE::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("HIGH_TEMPERATURE", (tS32)0xe9cfcb29);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDHIGH_TEMPERATURE::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDHIGH_TEMPERATURE::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDHIGH_TEMPERATURE::s32SetData(tU8 &tHIGH_TEMPERATUREParam) {
   //init parameter
   (tVoid)memcpy(&tHIGH_TEMPERATURE,(tVoid*)&tHIGH_TEMPERATUREParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tHIGH_TEMPERATUREParam' in function 'dp_tclDimmingDpPDDHIGH_TEMPERATURE::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDpPDDHIGH_TEMPERATURE::s32SetData(const tU8 &tHIGH_TEMPERATUREParam) {
   //init parameter
   (tVoid)memcpy(&tHIGH_TEMPERATURE,(tVoid*)&tHIGH_TEMPERATUREParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tHIGH_TEMPERATUREParam' in function 'dp_tclDimmingDpPDDHIGH_TEMPERATURE::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDHIGH_TEMPERATURE::u8GetData(tU8& tHIGH_TEMPERATUREParam) {  
   vUpdate();
   tHIGH_TEMPERATUREParam = tHIGH_TEMPERATURE;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDHIGH_TEMPERATURE::vSetData(tU8 &tHIGH_TEMPERATUREParam) { 
   //init parameter
   (tVoid)memcpy(&tHIGH_TEMPERATURE,(tVoid*)&tHIGH_TEMPERATUREParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tHIGH_TEMPERATUREParam' in function 'dp_tclDimmingDpPDDHIGH_TEMPERATURE::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDpPDDHIGH_TEMPERATURE::vSetData(const tU8 &tHIGH_TEMPERATUREParam) { 
   //init parameter
   (tVoid)memcpy(&tHIGH_TEMPERATURE,(tVoid*)&tHIGH_TEMPERATUREParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tHIGH_TEMPERATUREParam' in function 'dp_tclDimmingDpPDDHIGH_TEMPERATURE::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDpPDDHIGH_TEMPERATURE::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDHIGH_TEMPERATURE::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "HIGH_TEMPERATURE", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDHIGH_TEMPERATURE::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "HIGH_TEMPERATURE", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDHIGH_TEMPERATURE::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: HIGH_TEMPERATURE", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element HIGH_TEMPERATURE has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CRITICAL_TEMPERATURE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::dp_tclDimmingDpPDDCRITICAL_TEMPERATURE(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCRITICAL_TEMPERATURE,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CRITICAL_TEMPERATURE",(tS32) 0x1988e900);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCRITICAL_TEMPERATURE = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CRITICAL_TEMPERATURE", (tS32)0x1988e900);
   (tVoid)myDpElem.bFillData((tVoid*)&tCRITICAL_TEMPERATURE, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::tGetData() {
   vUpdate();
   return tCRITICAL_TEMPERATURE;
};
tS32 dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::s32GetData(tU8& tCRITICAL_TEMPERATUREParam) { 
   vUpdate();
   tCRITICAL_TEMPERATUREParam = tCRITICAL_TEMPERATURE;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CRITICAL_TEMPERATURE", (tS32)0x1988e900);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::s32SetData(tU8 &tCRITICAL_TEMPERATUREParam) {
   //init parameter
   (tVoid)memcpy(&tCRITICAL_TEMPERATURE,(tVoid*)&tCRITICAL_TEMPERATUREParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCRITICAL_TEMPERATUREParam' in function 'dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::s32SetData(const tU8 &tCRITICAL_TEMPERATUREParam) {
   //init parameter
   (tVoid)memcpy(&tCRITICAL_TEMPERATURE,(tVoid*)&tCRITICAL_TEMPERATUREParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCRITICAL_TEMPERATUREParam' in function 'dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::u8GetData(tU8& tCRITICAL_TEMPERATUREParam) {  
   vUpdate();
   tCRITICAL_TEMPERATUREParam = tCRITICAL_TEMPERATURE;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::vSetData(tU8 &tCRITICAL_TEMPERATUREParam) { 
   //init parameter
   (tVoid)memcpy(&tCRITICAL_TEMPERATURE,(tVoid*)&tCRITICAL_TEMPERATUREParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCRITICAL_TEMPERATUREParam' in function 'dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::vSetData(const tU8 &tCRITICAL_TEMPERATUREParam) { 
   //init parameter
   (tVoid)memcpy(&tCRITICAL_TEMPERATURE,(tVoid*)&tCRITICAL_TEMPERATUREParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCRITICAL_TEMPERATUREParam' in function 'dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "CRITICAL_TEMPERATURE", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "CRITICAL_TEMPERATURE", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDCRITICAL_TEMPERATURE::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CRITICAL_TEMPERATURE", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element CRITICAL_TEMPERATURE has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LOW_TEMPERATURE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDLOW_TEMPERATURE::dp_tclDimmingDpPDDLOW_TEMPERATURE(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLOW_TEMPERATURE,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDLOW_TEMPERATURE::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LOW_TEMPERATURE",(tS32) 0xb652d8a3);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tLOW_TEMPERATURE = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDLOW_TEMPERATURE::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LOW_TEMPERATURE", (tS32)0xb652d8a3);
   (tVoid)myDpElem.bFillData((tVoid*)&tLOW_TEMPERATURE, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDLOW_TEMPERATURE::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDLOW_TEMPERATURE::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclDimmingDpPDDLOW_TEMPERATURE::tGetData() {
   vUpdate();
   return tLOW_TEMPERATURE;
};
tS32 dp_tclDimmingDpPDDLOW_TEMPERATURE::s32GetData(tS8& tLOW_TEMPERATUREParam) { 
   vUpdate();
   tLOW_TEMPERATUREParam = tLOW_TEMPERATURE;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDLOW_TEMPERATURE::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LOW_TEMPERATURE", (tS32)0xb652d8a3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDLOW_TEMPERATURE::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDLOW_TEMPERATURE::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDLOW_TEMPERATURE::s32SetData(tS8 &tLOW_TEMPERATUREParam) {
   //init parameter
   (tVoid)memcpy(&tLOW_TEMPERATURE,(tVoid*)&tLOW_TEMPERATUREParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLOW_TEMPERATUREParam' in function 'dp_tclDimmingDpPDDLOW_TEMPERATURE::vSetData(tS8)' could be made const reference
tS32 dp_tclDimmingDpPDDLOW_TEMPERATURE::s32SetData(const tS8 &tLOW_TEMPERATUREParam) {
   //init parameter
   (tVoid)memcpy(&tLOW_TEMPERATURE,(tVoid*)&tLOW_TEMPERATUREParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLOW_TEMPERATUREParam' in function 'dp_tclDimmingDpPDDLOW_TEMPERATURE::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDLOW_TEMPERATURE::u8GetData(tS8& tLOW_TEMPERATUREParam) {  
   vUpdate();
   tLOW_TEMPERATUREParam = tLOW_TEMPERATURE;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDLOW_TEMPERATURE::vSetData(tS8 &tLOW_TEMPERATUREParam) { 
   //init parameter
   (tVoid)memcpy(&tLOW_TEMPERATURE,(tVoid*)&tLOW_TEMPERATUREParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tLOW_TEMPERATUREParam' in function 'dp_tclDimmingDpPDDLOW_TEMPERATURE::vSetData(tS8)' could be made const reference
tVoid dp_tclDimmingDpPDDLOW_TEMPERATURE::vSetData(const tS8 &tLOW_TEMPERATUREParam) { 
   //init parameter
   (tVoid)memcpy(&tLOW_TEMPERATURE,(tVoid*)&tLOW_TEMPERATUREParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tLOW_TEMPERATUREParam' in function 'dp_tclDimmingDpPDDLOW_TEMPERATURE::vSetData(tS8)' could be made const reference
tU8   dp_tclDimmingDpPDDLOW_TEMPERATURE::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDLOW_TEMPERATURE::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "LOW_TEMPERATURE", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDLOW_TEMPERATURE::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "LOW_TEMPERATURE", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDLOW_TEMPERATURE::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LOW_TEMPERATURE", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element LOW_TEMPERATURE has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TEMP_HYSTERESIS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDTEMP_HYSTERESIS::dp_tclDimmingDpPDDTEMP_HYSTERESIS(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTEMP_HYSTERESIS,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDTEMP_HYSTERESIS::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TEMP_HYSTERESIS",(tS32) 0x86fe57a4);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tTEMP_HYSTERESIS = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDTEMP_HYSTERESIS::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TEMP_HYSTERESIS", (tS32)0x86fe57a4);
   (tVoid)myDpElem.bFillData((tVoid*)&tTEMP_HYSTERESIS, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDTEMP_HYSTERESIS::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDTEMP_HYSTERESIS::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDpPDDTEMP_HYSTERESIS::tGetData() {
   vUpdate();
   return tTEMP_HYSTERESIS;
};
tS32 dp_tclDimmingDpPDDTEMP_HYSTERESIS::s32GetData(tU8& tTEMP_HYSTERESISParam) { 
   vUpdate();
   tTEMP_HYSTERESISParam = tTEMP_HYSTERESIS;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDTEMP_HYSTERESIS::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TEMP_HYSTERESIS", (tS32)0x86fe57a4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDTEMP_HYSTERESIS::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDTEMP_HYSTERESIS::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDTEMP_HYSTERESIS::s32SetData(tU8 &tTEMP_HYSTERESISParam) {
   //init parameter
   (tVoid)memcpy(&tTEMP_HYSTERESIS,(tVoid*)&tTEMP_HYSTERESISParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTEMP_HYSTERESISParam' in function 'dp_tclDimmingDpPDDTEMP_HYSTERESIS::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDpPDDTEMP_HYSTERESIS::s32SetData(const tU8 &tTEMP_HYSTERESISParam) {
   //init parameter
   (tVoid)memcpy(&tTEMP_HYSTERESIS,(tVoid*)&tTEMP_HYSTERESISParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTEMP_HYSTERESISParam' in function 'dp_tclDimmingDpPDDTEMP_HYSTERESIS::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDTEMP_HYSTERESIS::u8GetData(tU8& tTEMP_HYSTERESISParam) {  
   vUpdate();
   tTEMP_HYSTERESISParam = tTEMP_HYSTERESIS;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDTEMP_HYSTERESIS::vSetData(tU8 &tTEMP_HYSTERESISParam) { 
   //init parameter
   (tVoid)memcpy(&tTEMP_HYSTERESIS,(tVoid*)&tTEMP_HYSTERESISParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTEMP_HYSTERESISParam' in function 'dp_tclDimmingDpPDDTEMP_HYSTERESIS::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDpPDDTEMP_HYSTERESIS::vSetData(const tU8 &tTEMP_HYSTERESISParam) { 
   //init parameter
   (tVoid)memcpy(&tTEMP_HYSTERESIS,(tVoid*)&tTEMP_HYSTERESISParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTEMP_HYSTERESISParam' in function 'dp_tclDimmingDpPDDTEMP_HYSTERESIS::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDpPDDTEMP_HYSTERESIS::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDTEMP_HYSTERESIS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "TEMP_HYSTERESIS", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDTEMP_HYSTERESIS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "TEMP_HYSTERESIS", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDTEMP_HYSTERESIS::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TEMP_HYSTERESIS", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element TEMP_HYSTERESIS has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TEMP_COMPENSATION_PWM_MIN"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTEMP_COMPENSATION_PWM_MIN,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TEMP_COMPENSATION_PWM_MIN",(tS32) 0x8cf005ab);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tTEMP_COMPENSATION_PWM_MIN = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TEMP_COMPENSATION_PWM_MIN", (tS32)0x8cf005ab);
   (tVoid)myDpElem.bFillData((tVoid*)&tTEMP_COMPENSATION_PWM_MIN, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::tGetData() {
   vUpdate();
   return tTEMP_COMPENSATION_PWM_MIN;
};
tS32 dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::s32GetData(tU8& tTEMP_COMPENSATION_PWM_MINParam) { 
   vUpdate();
   tTEMP_COMPENSATION_PWM_MINParam = tTEMP_COMPENSATION_PWM_MIN;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TEMP_COMPENSATION_PWM_MIN", (tS32)0x8cf005ab);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::s32SetData(tU8 &tTEMP_COMPENSATION_PWM_MINParam) {
   //init parameter
   (tVoid)memcpy(&tTEMP_COMPENSATION_PWM_MIN,(tVoid*)&tTEMP_COMPENSATION_PWM_MINParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTEMP_COMPENSATION_PWM_MINParam' in function 'dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::s32SetData(const tU8 &tTEMP_COMPENSATION_PWM_MINParam) {
   //init parameter
   (tVoid)memcpy(&tTEMP_COMPENSATION_PWM_MIN,(tVoid*)&tTEMP_COMPENSATION_PWM_MINParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTEMP_COMPENSATION_PWM_MINParam' in function 'dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::u8GetData(tU8& tTEMP_COMPENSATION_PWM_MINParam) {  
   vUpdate();
   tTEMP_COMPENSATION_PWM_MINParam = tTEMP_COMPENSATION_PWM_MIN;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::vSetData(tU8 &tTEMP_COMPENSATION_PWM_MINParam) { 
   //init parameter
   (tVoid)memcpy(&tTEMP_COMPENSATION_PWM_MIN,(tVoid*)&tTEMP_COMPENSATION_PWM_MINParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTEMP_COMPENSATION_PWM_MINParam' in function 'dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::vSetData(const tU8 &tTEMP_COMPENSATION_PWM_MINParam) { 
   //init parameter
   (tVoid)memcpy(&tTEMP_COMPENSATION_PWM_MIN,(tVoid*)&tTEMP_COMPENSATION_PWM_MINParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTEMP_COMPENSATION_PWM_MINParam' in function 'dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "TEMP_COMPENSATION_PWM_MIN", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "TEMP_COMPENSATION_PWM_MIN", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDTEMP_COMPENSATION_PWM_MIN::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TEMP_COMPENSATION_PWM_MIN", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element TEMP_COMPENSATION_PWM_MIN has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "KEYB_LED_CALIBRATION_VALUE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDKEYB_LED_CALIBRATION_VALUE::dp_tclDimmingDpPDDKEYB_LED_CALIBRATION_VALUE(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDimmingDpPDDKEYB_LED_CALIBRATION_VALUE::s32SetData( tU16* tKEYB_LED_CALIBRATION_VALUEParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("KEYB_LED_CALIBRATION_VALUE", (tS32)0x11d4569eL);
   (tVoid)myDpElem.bFillData((tVoid*)tKEYB_LED_CALIBRATION_VALUEParam, ((tU32)sizeof(tU16))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDimmingDpPDDKEYB_LED_CALIBRATION_VALUE::s32GetData(tU16* tKEYB_LED_CALIBRATION_VALUEParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("KEYB_LED_CALIBRATION_VALUE", (tS32)0x11d4569eL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU16)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU16));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tKEYB_LED_CALIBRATION_VALUEParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU16));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDimmingDpPDDKEYB_LED_CALIBRATION_VALUE::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDpPDDKEYB_LED_CALIBRATION_VALUE::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDimmingDpPDDKEYB_LED_CALIBRATION_VALUE::u16GetData(tU16* tKEYB_LED_CALIBRATION_VALUEParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tKEYB_LED_CALIBRATION_VALUEParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDpPDDKEYB_LED_CALIBRATION_VALUE::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "KEYB_LED_CALIBRATION_VALUE", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDpPDDKEYB_LED_CALIBRATION_VALUE::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "KEYB_LED_CALIBRATION_VALUE", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDimmingDpPDDKEYB_LED_CALIBRATION_VALUE::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: KEYB_LED_CALIBRATION_VALUE", DP_U32_POOL_ID_DIMMINGDPPDD);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
		}
		else
		{
			fprintf(stdout,"Element KEYB_LED_CALIBRATION_VALUE has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BRANDNAME"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDBRANDNAME::dp_tclDimmingDpPDDBRANDNAME(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBRANDNAME,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDBRANDNAME::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("BRANDNAME",(tS32) 0x1ff3014);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tBRANDNAME = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDBRANDNAME::vStore(tVoid) {
   dp_tclBaseElement myDpElem("BRANDNAME", (tS32)0x1ff3014);
   (tVoid)myDpElem.bFillData((tVoid*)&tBRANDNAME, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDBRANDNAME::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDBRANDNAME::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDpPDDBRANDNAME::tGetData() {
   vUpdate();
   return tBRANDNAME;
};
tS32 dp_tclDimmingDpPDDBRANDNAME::s32GetData(tU8& tBRANDNAMEParam) { 
   vUpdate();
   tBRANDNAMEParam = tBRANDNAME;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDBRANDNAME::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("BRANDNAME", (tS32)0x1ff3014);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDBRANDNAME::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDBRANDNAME::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDBRANDNAME::s32SetData(tU8 &tBRANDNAMEParam) {
   //init parameter
   (tVoid)memcpy(&tBRANDNAME,(tVoid*)&tBRANDNAMEParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBRANDNAMEParam' in function 'dp_tclDimmingDpPDDBRANDNAME::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDpPDDBRANDNAME::s32SetData(const tU8 &tBRANDNAMEParam) {
   //init parameter
   (tVoid)memcpy(&tBRANDNAME,(tVoid*)&tBRANDNAMEParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBRANDNAMEParam' in function 'dp_tclDimmingDpPDDBRANDNAME::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDBRANDNAME::u8GetData(tU8& tBRANDNAMEParam) {  
   vUpdate();
   tBRANDNAMEParam = tBRANDNAME;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDBRANDNAME::vSetData(tU8 &tBRANDNAMEParam) { 
   //init parameter
   (tVoid)memcpy(&tBRANDNAME,(tVoid*)&tBRANDNAMEParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tBRANDNAMEParam' in function 'dp_tclDimmingDpPDDBRANDNAME::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDpPDDBRANDNAME::vSetData(const tU8 &tBRANDNAMEParam) { 
   //init parameter
   (tVoid)memcpy(&tBRANDNAME,(tVoid*)&tBRANDNAMEParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tBRANDNAMEParam' in function 'dp_tclDimmingDpPDDBRANDNAME::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDpPDDBRANDNAME::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDBRANDNAME::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRANDNAME", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDBRANDNAME::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRANDNAME", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDBRANDNAME::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BRANDNAME", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element BRANDNAME has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISPLAY_TYPE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDDISPLAY_TYPE::dp_tclDimmingDpPDDDISPLAY_TYPE(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISPLAY_TYPE,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDDISPLAY_TYPE::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISPLAY_TYPE",(tS32) 0xfc5bac4f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDISPLAY_TYPE = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDDISPLAY_TYPE::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISPLAY_TYPE", (tS32)0xfc5bac4f);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISPLAY_TYPE, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDDISPLAY_TYPE::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDDISPLAY_TYPE::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDpPDDDISPLAY_TYPE::tGetData() {
   vUpdate();
   return tDISPLAY_TYPE;
};
tS32 dp_tclDimmingDpPDDDISPLAY_TYPE::s32GetData(tU8& tDISPLAY_TYPEParam) { 
   vUpdate();
   tDISPLAY_TYPEParam = tDISPLAY_TYPE;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDDISPLAY_TYPE::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISPLAY_TYPE", (tS32)0xfc5bac4f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDDISPLAY_TYPE::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDDISPLAY_TYPE::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDDISPLAY_TYPE::s32SetData(tU8 &tDISPLAY_TYPEParam) {
   //init parameter
   (tVoid)memcpy(&tDISPLAY_TYPE,(tVoid*)&tDISPLAY_TYPEParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISPLAY_TYPEParam' in function 'dp_tclDimmingDpPDDDISPLAY_TYPE::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDpPDDDISPLAY_TYPE::s32SetData(const tU8 &tDISPLAY_TYPEParam) {
   //init parameter
   (tVoid)memcpy(&tDISPLAY_TYPE,(tVoid*)&tDISPLAY_TYPEParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISPLAY_TYPEParam' in function 'dp_tclDimmingDpPDDDISPLAY_TYPE::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDDISPLAY_TYPE::u8GetData(tU8& tDISPLAY_TYPEParam) {  
   vUpdate();
   tDISPLAY_TYPEParam = tDISPLAY_TYPE;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDDISPLAY_TYPE::vSetData(tU8 &tDISPLAY_TYPEParam) { 
   //init parameter
   (tVoid)memcpy(&tDISPLAY_TYPE,(tVoid*)&tDISPLAY_TYPEParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISPLAY_TYPEParam' in function 'dp_tclDimmingDpPDDDISPLAY_TYPE::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDpPDDDISPLAY_TYPE::vSetData(const tU8 &tDISPLAY_TYPEParam) { 
   //init parameter
   (tVoid)memcpy(&tDISPLAY_TYPE,(tVoid*)&tDISPLAY_TYPEParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISPLAY_TYPEParam' in function 'dp_tclDimmingDpPDDDISPLAY_TYPE::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDpPDDDISPLAY_TYPE::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDDISPLAY_TYPE::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DISPLAY_TYPE", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDISPLAY_TYPE::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DISPLAY_TYPE", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDISPLAY_TYPE::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISPLAY_TYPE", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element DISPLAY_TYPE has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DIMMING_COCKPIT_STRATEGY"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDIMMING_COCKPIT_STRATEGY,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DIMMING_COCKPIT_STRATEGY",(tS32) 0x57efde67);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDIMMING_COCKPIT_STRATEGY = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DIMMING_COCKPIT_STRATEGY", (tS32)0x57efde67);
   (tVoid)myDpElem.bFillData((tVoid*)&tDIMMING_COCKPIT_STRATEGY, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::tGetData() {
   vUpdate();
   return tDIMMING_COCKPIT_STRATEGY;
};
tS32 dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::s32GetData(tU8& tDIMMING_COCKPIT_STRATEGYParam) { 
   vUpdate();
   tDIMMING_COCKPIT_STRATEGYParam = tDIMMING_COCKPIT_STRATEGY;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DIMMING_COCKPIT_STRATEGY", (tS32)0x57efde67);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::s32SetData(tU8 &tDIMMING_COCKPIT_STRATEGYParam) {
   //init parameter
   (tVoid)memcpy(&tDIMMING_COCKPIT_STRATEGY,(tVoid*)&tDIMMING_COCKPIT_STRATEGYParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDIMMING_COCKPIT_STRATEGYParam' in function 'dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::s32SetData(const tU8 &tDIMMING_COCKPIT_STRATEGYParam) {
   //init parameter
   (tVoid)memcpy(&tDIMMING_COCKPIT_STRATEGY,(tVoid*)&tDIMMING_COCKPIT_STRATEGYParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDIMMING_COCKPIT_STRATEGYParam' in function 'dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::u8GetData(tU8& tDIMMING_COCKPIT_STRATEGYParam) {  
   vUpdate();
   tDIMMING_COCKPIT_STRATEGYParam = tDIMMING_COCKPIT_STRATEGY;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::vSetData(tU8 &tDIMMING_COCKPIT_STRATEGYParam) { 
   //init parameter
   (tVoid)memcpy(&tDIMMING_COCKPIT_STRATEGY,(tVoid*)&tDIMMING_COCKPIT_STRATEGYParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDIMMING_COCKPIT_STRATEGYParam' in function 'dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::vSetData(const tU8 &tDIMMING_COCKPIT_STRATEGYParam) { 
   //init parameter
   (tVoid)memcpy(&tDIMMING_COCKPIT_STRATEGY,(tVoid*)&tDIMMING_COCKPIT_STRATEGYParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDIMMING_COCKPIT_STRATEGYParam' in function 'dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DIMMING_COCKPIT_STRATEGY", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DIMMING_COCKPIT_STRATEGY", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDIMMING_COCKPIT_STRATEGY::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DIMMING_COCKPIT_STRATEGY", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element DIMMING_COCKPIT_STRATEGY has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "KEY_BRIGHTNESS_NUMOF_OFFSETS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tKEY_BRIGHTNESS_NUMOF_OFFSETS,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("KEY_BRIGHTNESS_NUMOF_OFFSETS",(tS32) 0x4d7cc51aL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tKEY_BRIGHTNESS_NUMOF_OFFSETS = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::vStore(tVoid) {
   dp_tclBaseElement myDpElem("KEY_BRIGHTNESS_NUMOF_OFFSETS", (tS32)0x4d7cc51aL);
   (tVoid)myDpElem.bFillData((tVoid*)&tKEY_BRIGHTNESS_NUMOF_OFFSETS, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::tGetData() {
   vUpdate();
   return tKEY_BRIGHTNESS_NUMOF_OFFSETS;
};
tS32 dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::s32GetData(tU8& tKEY_BRIGHTNESS_NUMOF_OFFSETSParam) { 
   vUpdate();
   tKEY_BRIGHTNESS_NUMOF_OFFSETSParam = tKEY_BRIGHTNESS_NUMOF_OFFSETS;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("KEY_BRIGHTNESS_NUMOF_OFFSETS", (tS32)0x4d7cc51aL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::s32SetData(tU8 &tKEY_BRIGHTNESS_NUMOF_OFFSETSParam) {
   //init parameter
   (tVoid)memcpy(&tKEY_BRIGHTNESS_NUMOF_OFFSETS,(tVoid*)&tKEY_BRIGHTNESS_NUMOF_OFFSETSParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tKEY_BRIGHTNESS_NUMOF_OFFSETSParam' in function 'dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::s32SetData(const tU8 &tKEY_BRIGHTNESS_NUMOF_OFFSETSParam) {
   //init parameter
   (tVoid)memcpy(&tKEY_BRIGHTNESS_NUMOF_OFFSETS,(tVoid*)&tKEY_BRIGHTNESS_NUMOF_OFFSETSParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tKEY_BRIGHTNESS_NUMOF_OFFSETSParam' in function 'dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::u8GetData(tU8& tKEY_BRIGHTNESS_NUMOF_OFFSETSParam) {  
   vUpdate();
   tKEY_BRIGHTNESS_NUMOF_OFFSETSParam = tKEY_BRIGHTNESS_NUMOF_OFFSETS;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::vSetData(tU8 &tKEY_BRIGHTNESS_NUMOF_OFFSETSParam) { 
   //init parameter
   (tVoid)memcpy(&tKEY_BRIGHTNESS_NUMOF_OFFSETS,(tVoid*)&tKEY_BRIGHTNESS_NUMOF_OFFSETSParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tKEY_BRIGHTNESS_NUMOF_OFFSETSParam' in function 'dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::vSetData(const tU8 &tKEY_BRIGHTNESS_NUMOF_OFFSETSParam) { 
   //init parameter
   (tVoid)memcpy(&tKEY_BRIGHTNESS_NUMOF_OFFSETS,(tVoid*)&tKEY_BRIGHTNESS_NUMOF_OFFSETSParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tKEY_BRIGHTNESS_NUMOF_OFFSETSParam' in function 'dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "KEY_BRIGHTNESS_NUMOF_OFFSETS", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "KEY_BRIGHTNESS_NUMOF_OFFSETS", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDKEY_BRIGHTNESS_NUMOF_OFFSETS::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: KEY_BRIGHTNESS_NUMOF_OFFSETS", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element KEY_BRIGHTNESS_NUMOF_OFFSETS has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DAMPING_STRATEGY"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDDAMPING_STRATEGY::dp_tclDimmingDpPDDDAMPING_STRATEGY(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDAMPING_STRATEGY,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDDAMPING_STRATEGY::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DAMPING_STRATEGY",(tS32) 0x59a4ed6);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDAMPING_STRATEGY = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDDAMPING_STRATEGY::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DAMPING_STRATEGY", (tS32)0x59a4ed6);
   (tVoid)myDpElem.bFillData((tVoid*)&tDAMPING_STRATEGY, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDDAMPING_STRATEGY::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDDAMPING_STRATEGY::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDpPDDDAMPING_STRATEGY::tGetData() {
   vUpdate();
   return tDAMPING_STRATEGY;
};
tS32 dp_tclDimmingDpPDDDAMPING_STRATEGY::s32GetData(tU8& tDAMPING_STRATEGYParam) { 
   vUpdate();
   tDAMPING_STRATEGYParam = tDAMPING_STRATEGY;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDDAMPING_STRATEGY::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DAMPING_STRATEGY", (tS32)0x59a4ed6);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDDAMPING_STRATEGY::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDDAMPING_STRATEGY::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDDAMPING_STRATEGY::s32SetData(tU8 &tDAMPING_STRATEGYParam) {
   //init parameter
   (tVoid)memcpy(&tDAMPING_STRATEGY,(tVoid*)&tDAMPING_STRATEGYParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAMPING_STRATEGYParam' in function 'dp_tclDimmingDpPDDDAMPING_STRATEGY::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDpPDDDAMPING_STRATEGY::s32SetData(const tU8 &tDAMPING_STRATEGYParam) {
   //init parameter
   (tVoid)memcpy(&tDAMPING_STRATEGY,(tVoid*)&tDAMPING_STRATEGYParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAMPING_STRATEGYParam' in function 'dp_tclDimmingDpPDDDAMPING_STRATEGY::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDDAMPING_STRATEGY::u8GetData(tU8& tDAMPING_STRATEGYParam) {  
   vUpdate();
   tDAMPING_STRATEGYParam = tDAMPING_STRATEGY;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDDAMPING_STRATEGY::vSetData(tU8 &tDAMPING_STRATEGYParam) { 
   //init parameter
   (tVoid)memcpy(&tDAMPING_STRATEGY,(tVoid*)&tDAMPING_STRATEGYParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAMPING_STRATEGYParam' in function 'dp_tclDimmingDpPDDDAMPING_STRATEGY::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDpPDDDAMPING_STRATEGY::vSetData(const tU8 &tDAMPING_STRATEGYParam) { 
   //init parameter
   (tVoid)memcpy(&tDAMPING_STRATEGY,(tVoid*)&tDAMPING_STRATEGYParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAMPING_STRATEGYParam' in function 'dp_tclDimmingDpPDDDAMPING_STRATEGY::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDpPDDDAMPING_STRATEGY::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDDAMPING_STRATEGY::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DAMPING_STRATEGY", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDAMPING_STRATEGY::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DAMPING_STRATEGY", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDAMPING_STRATEGY::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DAMPING_STRATEGY", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element DAMPING_STRATEGY has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DAMPING_SAMPLING_TIMETE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDAMPING_SAMPLING_TIMETE,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DAMPING_SAMPLING_TIMETE",(tS32) 0x4c8292e9);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDAMPING_SAMPLING_TIMETE = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DAMPING_SAMPLING_TIMETE", (tS32)0x4c8292e9);
   (tVoid)myDpElem.bFillData((tVoid*)&tDAMPING_SAMPLING_TIMETE, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::tGetData() {
   vUpdate();
   return tDAMPING_SAMPLING_TIMETE;
};
tS32 dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::s32GetData(tU8& tDAMPING_SAMPLING_TIMETEParam) { 
   vUpdate();
   tDAMPING_SAMPLING_TIMETEParam = tDAMPING_SAMPLING_TIMETE;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DAMPING_SAMPLING_TIMETE", (tS32)0x4c8292e9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::s32SetData(tU8 &tDAMPING_SAMPLING_TIMETEParam) {
   //init parameter
   (tVoid)memcpy(&tDAMPING_SAMPLING_TIMETE,(tVoid*)&tDAMPING_SAMPLING_TIMETEParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAMPING_SAMPLING_TIMETEParam' in function 'dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::s32SetData(const tU8 &tDAMPING_SAMPLING_TIMETEParam) {
   //init parameter
   (tVoid)memcpy(&tDAMPING_SAMPLING_TIMETE,(tVoid*)&tDAMPING_SAMPLING_TIMETEParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAMPING_SAMPLING_TIMETEParam' in function 'dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::u8GetData(tU8& tDAMPING_SAMPLING_TIMETEParam) {  
   vUpdate();
   tDAMPING_SAMPLING_TIMETEParam = tDAMPING_SAMPLING_TIMETE;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::vSetData(tU8 &tDAMPING_SAMPLING_TIMETEParam) { 
   //init parameter
   (tVoid)memcpy(&tDAMPING_SAMPLING_TIMETE,(tVoid*)&tDAMPING_SAMPLING_TIMETEParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAMPING_SAMPLING_TIMETEParam' in function 'dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::vSetData(const tU8 &tDAMPING_SAMPLING_TIMETEParam) { 
   //init parameter
   (tVoid)memcpy(&tDAMPING_SAMPLING_TIMETE,(tVoid*)&tDAMPING_SAMPLING_TIMETEParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAMPING_SAMPLING_TIMETEParam' in function 'dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DAMPING_SAMPLING_TIMETE", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DAMPING_SAMPLING_TIMETE", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDAMPING_SAMPLING_TIMETE::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DAMPING_SAMPLING_TIMETE", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element DAMPING_SAMPLING_TIMETE has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DAMPING_CONSTANTK"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDDAMPING_CONSTANTK::dp_tclDimmingDpPDDDAMPING_CONSTANTK(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDAMPING_CONSTANTK,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDDAMPING_CONSTANTK::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DAMPING_CONSTANTK",(tS32) 0x1b9e1cc0);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDAMPING_CONSTANTK = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDDAMPING_CONSTANTK::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DAMPING_CONSTANTK", (tS32)0x1b9e1cc0);
   (tVoid)myDpElem.bFillData((tVoid*)&tDAMPING_CONSTANTK, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDDAMPING_CONSTANTK::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDDAMPING_CONSTANTK::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDpPDDDAMPING_CONSTANTK::tGetData() {
   vUpdate();
   return tDAMPING_CONSTANTK;
};
tS32 dp_tclDimmingDpPDDDAMPING_CONSTANTK::s32GetData(tU8& tDAMPING_CONSTANTKParam) { 
   vUpdate();
   tDAMPING_CONSTANTKParam = tDAMPING_CONSTANTK;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDDAMPING_CONSTANTK::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DAMPING_CONSTANTK", (tS32)0x1b9e1cc0);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDDAMPING_CONSTANTK::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDDAMPING_CONSTANTK::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDDAMPING_CONSTANTK::s32SetData(tU8 &tDAMPING_CONSTANTKParam) {
   //init parameter
   (tVoid)memcpy(&tDAMPING_CONSTANTK,(tVoid*)&tDAMPING_CONSTANTKParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAMPING_CONSTANTKParam' in function 'dp_tclDimmingDpPDDDAMPING_CONSTANTK::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDpPDDDAMPING_CONSTANTK::s32SetData(const tU8 &tDAMPING_CONSTANTKParam) {
   //init parameter
   (tVoid)memcpy(&tDAMPING_CONSTANTK,(tVoid*)&tDAMPING_CONSTANTKParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAMPING_CONSTANTKParam' in function 'dp_tclDimmingDpPDDDAMPING_CONSTANTK::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDDAMPING_CONSTANTK::u8GetData(tU8& tDAMPING_CONSTANTKParam) {  
   vUpdate();
   tDAMPING_CONSTANTKParam = tDAMPING_CONSTANTK;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDDAMPING_CONSTANTK::vSetData(tU8 &tDAMPING_CONSTANTKParam) { 
   //init parameter
   (tVoid)memcpy(&tDAMPING_CONSTANTK,(tVoid*)&tDAMPING_CONSTANTKParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAMPING_CONSTANTKParam' in function 'dp_tclDimmingDpPDDDAMPING_CONSTANTK::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDpPDDDAMPING_CONSTANTK::vSetData(const tU8 &tDAMPING_CONSTANTKParam) { 
   //init parameter
   (tVoid)memcpy(&tDAMPING_CONSTANTK,(tVoid*)&tDAMPING_CONSTANTKParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAMPING_CONSTANTKParam' in function 'dp_tclDimmingDpPDDDAMPING_CONSTANTK::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDpPDDDAMPING_CONSTANTK::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDDAMPING_CONSTANTK::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DAMPING_CONSTANTK", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDAMPING_CONSTANTK::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DAMPING_CONSTANTK", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDAMPING_CONSTANTK::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DAMPING_CONSTANTK", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element DAMPING_CONSTANTK has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DAMPING_CONSTANTJ"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDDAMPING_CONSTANTJ::dp_tclDimmingDpPDDDAMPING_CONSTANTJ(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDAMPING_CONSTANTJ,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDDAMPING_CONSTANTJ::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DAMPING_CONSTANTJ",(tS32) 0x1b9e1cbf);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDAMPING_CONSTANTJ = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDDAMPING_CONSTANTJ::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DAMPING_CONSTANTJ", (tS32)0x1b9e1cbf);
   (tVoid)myDpElem.bFillData((tVoid*)&tDAMPING_CONSTANTJ, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDDAMPING_CONSTANTJ::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDDAMPING_CONSTANTJ::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDpPDDDAMPING_CONSTANTJ::tGetData() {
   vUpdate();
   return tDAMPING_CONSTANTJ;
};
tS32 dp_tclDimmingDpPDDDAMPING_CONSTANTJ::s32GetData(tU8& tDAMPING_CONSTANTJParam) { 
   vUpdate();
   tDAMPING_CONSTANTJParam = tDAMPING_CONSTANTJ;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDDAMPING_CONSTANTJ::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DAMPING_CONSTANTJ", (tS32)0x1b9e1cbf);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDDAMPING_CONSTANTJ::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDDAMPING_CONSTANTJ::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDDAMPING_CONSTANTJ::s32SetData(tU8 &tDAMPING_CONSTANTJParam) {
   //init parameter
   (tVoid)memcpy(&tDAMPING_CONSTANTJ,(tVoid*)&tDAMPING_CONSTANTJParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAMPING_CONSTANTJParam' in function 'dp_tclDimmingDpPDDDAMPING_CONSTANTJ::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDpPDDDAMPING_CONSTANTJ::s32SetData(const tU8 &tDAMPING_CONSTANTJParam) {
   //init parameter
   (tVoid)memcpy(&tDAMPING_CONSTANTJ,(tVoid*)&tDAMPING_CONSTANTJParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAMPING_CONSTANTJParam' in function 'dp_tclDimmingDpPDDDAMPING_CONSTANTJ::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDDAMPING_CONSTANTJ::u8GetData(tU8& tDAMPING_CONSTANTJParam) {  
   vUpdate();
   tDAMPING_CONSTANTJParam = tDAMPING_CONSTANTJ;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDDAMPING_CONSTANTJ::vSetData(tU8 &tDAMPING_CONSTANTJParam) { 
   //init parameter
   (tVoid)memcpy(&tDAMPING_CONSTANTJ,(tVoid*)&tDAMPING_CONSTANTJParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAMPING_CONSTANTJParam' in function 'dp_tclDimmingDpPDDDAMPING_CONSTANTJ::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDpPDDDAMPING_CONSTANTJ::vSetData(const tU8 &tDAMPING_CONSTANTJParam) { 
   //init parameter
   (tVoid)memcpy(&tDAMPING_CONSTANTJ,(tVoid*)&tDAMPING_CONSTANTJParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAMPING_CONSTANTJParam' in function 'dp_tclDimmingDpPDDDAMPING_CONSTANTJ::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDpPDDDAMPING_CONSTANTJ::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDDAMPING_CONSTANTJ::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DAMPING_CONSTANTJ", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDAMPING_CONSTANTJ::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DAMPING_CONSTANTJ", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDAMPING_CONSTANTJ::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DAMPING_CONSTANTJ", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element DAMPING_CONSTANTJ has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY",(tS32) 0x8d8df381L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::vStore(tVoid) {
   dp_tclBaseElement myDpElem("BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY", (tS32)0x8d8df381L);
   (tVoid)myDpElem.bFillData((tVoid*)&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::tGetData() {
   vUpdate();
   return tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY;
};
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::s32GetData(tU16& tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam) { 
   vUpdate();
   tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam = tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY", (tS32)0x8d8df381L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::s32SetData(tU16 &tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam) {
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY,(tVoid*)&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::vSetData(tU16)' could be made const reference
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::s32SetData(const tU16 &tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam) {
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY,(tVoid*)&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::u8GetData(tU16& tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam) {  
   vUpdate();
   tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam = tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::vSetData(tU16 &tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam) { 
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY,(tVoid*)&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::vSetData(tU16)' could be made const reference
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::vSetData(const tU16 &tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam) { 
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY,(tVoid*)&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAYParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::vSetData(tU16)' could be made const reference
tU8   dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_DAY has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT",(tS32) 0xd2dce3e5L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::vStore(tVoid) {
   dp_tclBaseElement myDpElem("BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT", (tS32)0xd2dce3e5L);
   (tVoid)myDpElem.bFillData((tVoid*)&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::tGetData() {
   vUpdate();
   return tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT;
};
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::s32GetData(tU16& tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam) { 
   vUpdate();
   tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam = tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT", (tS32)0xd2dce3e5L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::s32SetData(tU16 &tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam) {
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT,(tVoid*)&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::vSetData(tU16)' could be made const reference
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::s32SetData(const tU16 &tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam) {
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT,(tVoid*)&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::u8GetData(tU16& tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam) {  
   vUpdate();
   tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam = tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::vSetData(tU16 &tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam) { 
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT,(tVoid*)&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::vSetData(tU16)' could be made const reference
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::vSetData(const tU16 &tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam) { 
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT,(tVoid*)&tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHTParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::vSetData(tU16)' could be made const reference
tU8   dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element BRIGTHNESS_BACKLIGHT_DAY_BUTTONS_NIGHT has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("BRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT",(tS32) 0xf8c871a1L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::vStore(tVoid) {
   dp_tclBaseElement myDpElem("BRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT", (tS32)0xf8c871a1L);
   (tVoid)myDpElem.bFillData((tVoid*)&tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::tGetData() {
   vUpdate();
   return tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT;
};
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::s32GetData(tU16& tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam) { 
   vUpdate();
   tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam = tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("BRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT", (tS32)0xf8c871a1L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::s32SetData(tU16 &tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam) {
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT,(tVoid*)&tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::vSetData(tU16)' could be made const reference
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::s32SetData(const tU16 &tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam) {
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT,(tVoid*)&tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::u8GetData(tU16& tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam) {  
   vUpdate();
   tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam = tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::vSetData(tU16 &tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam) { 
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT,(tVoid*)&tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::vSetData(tU16)' could be made const reference
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::vSetData(const tU16 &tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam) { 
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT,(tVoid*)&tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHTParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::vSetData(tU16)' could be made const reference
tU8   dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element BRIGTHNESS_BACKLIGHT_NIGHT_BUTTONS_NIGHT has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BRIGTHNESSBACKLIGHT_DAYBUTTONS_ON"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("BRIGTHNESSBACKLIGHT_DAYBUTTONS_ON",(tS32) 0xa3a5ad26L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::vStore(tVoid) {
   dp_tclBaseElement myDpElem("BRIGTHNESSBACKLIGHT_DAYBUTTONS_ON", (tS32)0xa3a5ad26L);
   (tVoid)myDpElem.bFillData((tVoid*)&tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::tGetData() {
   vUpdate();
   return tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON;
};
tS32 dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::s32GetData(tU16& tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam) { 
   vUpdate();
   tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam = tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("BRIGTHNESSBACKLIGHT_DAYBUTTONS_ON", (tS32)0xa3a5ad26L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::s32SetData(tU16 &tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam) {
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON,(tVoid*)&tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam' in function 'dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::vSetData(tU16)' could be made const reference
tS32 dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::s32SetData(const tU16 &tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam) {
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON,(tVoid*)&tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam' in function 'dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::u8GetData(tU16& tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam) {  
   vUpdate();
   tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam = tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::vSetData(tU16 &tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam) { 
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON,(tVoid*)&tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam' in function 'dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::vSetData(tU16)' could be made const reference
tVoid dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::vSetData(const tU16 &tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam) { 
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON,(tVoid*)&tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tBRIGTHNESSBACKLIGHT_DAYBUTTONS_ONParam' in function 'dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::vSetData(tU16)' could be made const reference
tU8   dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESSBACKLIGHT_DAYBUTTONS_ON", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESSBACKLIGHT_DAYBUTTONS_ON", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDBRIGTHNESSBACKLIGHT_DAYBUTTONS_ON::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BRIGTHNESSBACKLIGHT_DAYBUTTONS_ON", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element BRIGTHNESSBACKLIGHT_DAYBUTTONS_ON has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("BRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF",(tS32) 0xd9d5c9fL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::vStore(tVoid) {
   dp_tclBaseElement myDpElem("BRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF", (tS32)0xd9d5c9fL);
   (tVoid)myDpElem.bFillData((tVoid*)&tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::tGetData() {
   vUpdate();
   return tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF;
};
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::s32GetData(tU16& tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam) { 
   vUpdate();
   tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam = tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("BRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF", (tS32)0xd9d5c9fL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::s32SetData(tU16 &tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam) {
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF,(tVoid*)&tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::vSetData(tU16)' could be made const reference
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::s32SetData(const tU16 &tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam) {
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF,(tVoid*)&tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::u8GetData(tU16& tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam) {  
   vUpdate();
   tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam = tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::vSetData(tU16 &tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam) { 
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF,(tVoid*)&tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::vSetData(tU16)' could be made const reference
tVoid dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::vSetData(const tU16 &tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam) { 
   //init parameter
   (tVoid)memcpy(&tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF,(tVoid*)&tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFFParam' in function 'dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::vSetData(tU16)' could be made const reference
tU8   dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element BRIGTHNESS_BACKLIGHT_DAYBUTTONS_OFF has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON::dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON::s32SetData( tU16* tBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ONParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON", (tS32)0xc907aec9L);
   (tVoid)myDpElem.bFillData((tVoid*)tBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ONParam, ((tU32)sizeof(tU16))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON::s32GetData(tU16* tBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ONParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON", (tS32)0xc907aec9L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU16)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU16));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ONParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU16));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON::u16GetData(tU16* tBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ONParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ONParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDimmingDpPDDBRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON", DP_U32_POOL_ID_DIMMINGDPPDD);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
		}
		else
		{
			fprintf(stdout,"Element BRIGTHNESS_BACKLIGHT_NIGHTBUTTONS_ON has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DAY_NIGHT_DELAY"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDDAY_NIGHT_DELAY::dp_tclDimmingDpPDDDAY_NIGHT_DELAY(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDAY_NIGHT_DELAY,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDDAY_NIGHT_DELAY::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DAY_NIGHT_DELAY",(tS32) 0x773913fd);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tDAY_NIGHT_DELAY = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDDAY_NIGHT_DELAY::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DAY_NIGHT_DELAY", (tS32)0x773913fd);
   (tVoid)myDpElem.bFillData((tVoid*)&tDAY_NIGHT_DELAY, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDDAY_NIGHT_DELAY::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDDAY_NIGHT_DELAY::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclDimmingDpPDDDAY_NIGHT_DELAY::tGetData() {
   vUpdate();
   return tDAY_NIGHT_DELAY;
};
tS32 dp_tclDimmingDpPDDDAY_NIGHT_DELAY::s32GetData(tU16& tDAY_NIGHT_DELAYParam) { 
   vUpdate();
   tDAY_NIGHT_DELAYParam = tDAY_NIGHT_DELAY;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDDAY_NIGHT_DELAY::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DAY_NIGHT_DELAY", (tS32)0x773913fd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDDAY_NIGHT_DELAY::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDDAY_NIGHT_DELAY::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDDAY_NIGHT_DELAY::s32SetData(tU16 &tDAY_NIGHT_DELAYParam) {
   //init parameter
   (tVoid)memcpy(&tDAY_NIGHT_DELAY,(tVoid*)&tDAY_NIGHT_DELAYParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAY_NIGHT_DELAYParam' in function 'dp_tclDimmingDpPDDDAY_NIGHT_DELAY::vSetData(tU16)' could be made const reference
tS32 dp_tclDimmingDpPDDDAY_NIGHT_DELAY::s32SetData(const tU16 &tDAY_NIGHT_DELAYParam) {
   //init parameter
   (tVoid)memcpy(&tDAY_NIGHT_DELAY,(tVoid*)&tDAY_NIGHT_DELAYParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAY_NIGHT_DELAYParam' in function 'dp_tclDimmingDpPDDDAY_NIGHT_DELAY::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDDAY_NIGHT_DELAY::u8GetData(tU16& tDAY_NIGHT_DELAYParam) {  
   vUpdate();
   tDAY_NIGHT_DELAYParam = tDAY_NIGHT_DELAY;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDDAY_NIGHT_DELAY::vSetData(tU16 &tDAY_NIGHT_DELAYParam) { 
   //init parameter
   (tVoid)memcpy(&tDAY_NIGHT_DELAY,(tVoid*)&tDAY_NIGHT_DELAYParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDAY_NIGHT_DELAYParam' in function 'dp_tclDimmingDpPDDDAY_NIGHT_DELAY::vSetData(tU16)' could be made const reference
tVoid dp_tclDimmingDpPDDDAY_NIGHT_DELAY::vSetData(const tU16 &tDAY_NIGHT_DELAYParam) { 
   //init parameter
   (tVoid)memcpy(&tDAY_NIGHT_DELAY,(tVoid*)&tDAY_NIGHT_DELAYParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDAY_NIGHT_DELAYParam' in function 'dp_tclDimmingDpPDDDAY_NIGHT_DELAY::vSetData(tU16)' could be made const reference
tU8   dp_tclDimmingDpPDDDAY_NIGHT_DELAY::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDDAY_NIGHT_DELAY::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DAY_NIGHT_DELAY", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDAY_NIGHT_DELAY::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DAY_NIGHT_DELAY", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDAY_NIGHT_DELAY::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DAY_NIGHT_DELAY", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element DAY_NIGHT_DELAY has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DIMMING_ARCHITECTURE"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::dp_tclDimmingDpPDDDIMMING_ARCHITECTURE(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDIMMING_ARCHITECTURE,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DIMMING_ARCHITECTURE",(tS32) 0x4f1e7263);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDIMMING_ARCHITECTURE = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DIMMING_ARCHITECTURE", (tS32)0x4f1e7263);
   (tVoid)myDpElem.bFillData((tVoid*)&tDIMMING_ARCHITECTURE, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::tGetData() {
   vUpdate();
   return tDIMMING_ARCHITECTURE;
};
tS32 dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::s32GetData(tU8& tDIMMING_ARCHITECTUREParam) { 
   vUpdate();
   tDIMMING_ARCHITECTUREParam = tDIMMING_ARCHITECTURE;
   return _s32Status;
}
tS32 dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DIMMING_ARCHITECTURE", (tS32)0x4f1e7263);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDPPDD, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::s32SetData(tU8 &tDIMMING_ARCHITECTUREParam) {
   //init parameter
   (tVoid)memcpy(&tDIMMING_ARCHITECTURE,(tVoid*)&tDIMMING_ARCHITECTUREParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDIMMING_ARCHITECTUREParam' in function 'dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::s32SetData(const tU8 &tDIMMING_ARCHITECTUREParam) {
   //init parameter
   (tVoid)memcpy(&tDIMMING_ARCHITECTURE,(tVoid*)&tDIMMING_ARCHITECTUREParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDIMMING_ARCHITECTUREParam' in function 'dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::u8GetData(tU8& tDIMMING_ARCHITECTUREParam) {  
   vUpdate();
   tDIMMING_ARCHITECTUREParam = tDIMMING_ARCHITECTURE;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::vSetData(tU8 &tDIMMING_ARCHITECTUREParam) { 
   //init parameter
   (tVoid)memcpy(&tDIMMING_ARCHITECTURE,(tVoid*)&tDIMMING_ARCHITECTUREParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDIMMING_ARCHITECTUREParam' in function 'dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::vSetData(const tU8 &tDIMMING_ARCHITECTUREParam) { 
   //init parameter
   (tVoid)memcpy(&tDIMMING_ARCHITECTURE,(tVoid*)&tDIMMING_ARCHITECTUREParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDIMMING_ARCHITECTUREParam' in function 'dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DIMMING_ARCHITECTURE", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDPPDD, "DIMMING_ARCHITECTURE", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDpPDDDIMMING_ARCHITECTURE::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DIMMING_ARCHITECTURE", DP_U32_POOL_ID_DIMMINGDPPDD);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDPPDD);
   }
   else
   {
      fprintf(stdout,"Element DIMMING_ARCHITECTURE has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
