#ifndef _DP_FI_DIMMINGDP_H
#define _DP_FI_DIMMINGDP_H

extern tVoid vInitDimmingDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually() {};

   //read access for pool element 
   tS32  s32GetData(tString &tEarlyConfig_DisplayResulution_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tEarlyConfig_DisplayResulution_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tEarlyConfig_DisplayResulution_ManuallyParam);
   tS32 s32SetData(const tString &tEarlyConfig_DisplayResulution_ManuallyParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tEarlyConfig_DisplayResulution_ManuallyParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tEarlyConfig_DisplayResulution_ManuallyParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tEarlyConfig_DisplayResulution_ManuallyParam);
   tVoid vSetData(const tString &tEarlyConfig_DisplayResulution_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS32 tEarlyConfig_DisplayBackwardComp_Manually;
   
public:
   dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS32& tEarlyConfig_DisplayBackwardComp_ManuallyParam);
   tVoid operator>>(tS32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS32 &tEarlyConfig_DisplayBackwardComp_ManuallyParam);
   tS32  s32SetData(const tS32 &tEarlyConfig_DisplayBackwardComp_ManuallyParam);
   tVoid operator<<(tS32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS32& tEarlyConfig_DisplayBackwardComp_ManuallyParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS32& tEarlyConfig_DisplayBackwardComp_ManuallyParam);
   tVoid vSetData(const tS32& tEarlyConfig_DisplayBackwardComp_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS32 tEarlyConfig_DisplayLowFrequency_Manually;
   
public:
   dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS32& tEarlyConfig_DisplayLowFrequency_ManuallyParam);
   tVoid operator>>(tS32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS32 &tEarlyConfig_DisplayLowFrequency_ManuallyParam);
   tS32  s32SetData(const tS32 &tEarlyConfig_DisplayLowFrequency_ManuallyParam);
   tVoid operator<<(tS32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS32& tEarlyConfig_DisplayLowFrequency_ManuallyParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS32& tEarlyConfig_DisplayLowFrequency_ManuallyParam);
   tVoid vSetData(const tS32& tEarlyConfig_DisplayLowFrequency_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually() {};

   //read access for pool element 
   tS32  s32GetData(tString &tEarlyConfig_RTCDriverName_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tEarlyConfig_RTCDriverName_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tEarlyConfig_RTCDriverName_ManuallyParam);
   tS32 s32SetData(const tString &tEarlyConfig_RTCDriverName_ManuallyParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tEarlyConfig_RTCDriverName_ManuallyParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tEarlyConfig_RTCDriverName_ManuallyParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tEarlyConfig_RTCDriverName_ManuallyParam);
   tVoid vSetData(const tString &tEarlyConfig_RTCDriverName_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually() {};

   //read access for pool element 
   tS32  s32GetData(tString &tEarlyConfig_TouchDriverName_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tEarlyConfig_TouchDriverName_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tEarlyConfig_TouchDriverName_ManuallyParam);
   tS32 s32SetData(const tString &tEarlyConfig_TouchDriverName_ManuallyParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tEarlyConfig_TouchDriverName_ManuallyParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tEarlyConfig_TouchDriverName_ManuallyParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tEarlyConfig_TouchDriverName_ManuallyParam);
   tVoid vSetData(const tString &tEarlyConfig_TouchDriverName_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually() {};

   //read access for pool element 
   tS32  s32GetData(tString &tEarlyConfig_TouchConfigFile_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tEarlyConfig_TouchConfigFile_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tEarlyConfig_TouchConfigFile_ManuallyParam);
   tS32 s32SetData(const tString &tEarlyConfig_TouchConfigFile_ManuallyParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tEarlyConfig_TouchConfigFile_ManuallyParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tEarlyConfig_TouchConfigFile_ManuallyParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tEarlyConfig_TouchConfigFile_ManuallyParam);
   tVoid vSetData(const tString &tEarlyConfig_TouchConfigFile_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually() {};

   //read access for pool element 
   tS32  s32GetData(tString &tEarlyConfig_TouchI2CAddress_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tEarlyConfig_TouchI2CAddress_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tEarlyConfig_TouchI2CAddress_ManuallyParam);
   tS32 s32SetData(const tString &tEarlyConfig_TouchI2CAddress_ManuallyParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tEarlyConfig_TouchI2CAddress_ManuallyParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tEarlyConfig_TouchI2CAddress_ManuallyParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tEarlyConfig_TouchI2CAddress_ManuallyParam);
   tVoid vSetData(const tString &tEarlyConfig_TouchI2CAddress_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually() {};

   //read access for pool element 
   tS32  s32GetData(tString &tEarlyConfig_TouchDriverName2_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tEarlyConfig_TouchDriverName2_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tEarlyConfig_TouchDriverName2_ManuallyParam);
   tS32 s32SetData(const tString &tEarlyConfig_TouchDriverName2_ManuallyParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tEarlyConfig_TouchDriverName2_ManuallyParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tEarlyConfig_TouchDriverName2_ManuallyParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tEarlyConfig_TouchDriverName2_ManuallyParam);
   tVoid vSetData(const tString &tEarlyConfig_TouchDriverName2_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually() {};

   //read access for pool element 
   tS32  s32GetData(tString &tEarlyConfig_TouchConfigFile2_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tEarlyConfig_TouchConfigFile2_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tEarlyConfig_TouchConfigFile2_ManuallyParam);
   tS32 s32SetData(const tString &tEarlyConfig_TouchConfigFile2_ManuallyParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tEarlyConfig_TouchConfigFile2_ManuallyParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tEarlyConfig_TouchConfigFile2_ManuallyParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tEarlyConfig_TouchConfigFile2_ManuallyParam);
   tVoid vSetData(const tString &tEarlyConfig_TouchConfigFile2_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually() {};

   //read access for pool element 
   tS32  s32GetData(tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam);
   tS32 s32SetData(const tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam);
   tVoid vSetData(const tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually() {};

   //read access for pool element 
   tS32  s32GetData(tString &tEarlyConfig_TimingLvds1_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tEarlyConfig_TimingLvds1_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tEarlyConfig_TimingLvds1_ManuallyParam);
   tS32 s32SetData(const tString &tEarlyConfig_TimingLvds1_ManuallyParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tEarlyConfig_TimingLvds1_ManuallyParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tEarlyConfig_TimingLvds1_ManuallyParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tEarlyConfig_TimingLvds1_ManuallyParam);
   tVoid vSetData(const tString &tEarlyConfig_TimingLvds1_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS32 tEarlyConfig_ClockEdgeLvds1_Manually;
   
public:
   dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS32& tEarlyConfig_ClockEdgeLvds1_ManuallyParam);
   tVoid operator>>(tS32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS32 &tEarlyConfig_ClockEdgeLvds1_ManuallyParam);
   tS32  s32SetData(const tS32 &tEarlyConfig_ClockEdgeLvds1_ManuallyParam);
   tVoid operator<<(tS32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS32& tEarlyConfig_ClockEdgeLvds1_ManuallyParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS32& tEarlyConfig_ClockEdgeLvds1_ManuallyParam);
   tVoid vSetData(const tS32& tEarlyConfig_ClockEdgeLvds1_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS32 tEarlyConfig_ClockGenerationLvds1_Manually;
   
public:
   dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS32& tEarlyConfig_ClockGenerationLvds1_ManuallyParam);
   tVoid operator>>(tS32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS32 &tEarlyConfig_ClockGenerationLvds1_ManuallyParam);
   tS32  s32SetData(const tS32 &tEarlyConfig_ClockGenerationLvds1_ManuallyParam);
   tVoid operator<<(tS32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS32& tEarlyConfig_ClockGenerationLvds1_ManuallyParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS32& tEarlyConfig_ClockGenerationLvds1_ManuallyParam);
   tVoid vSetData(const tS32& tEarlyConfig_ClockGenerationLvds1_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually() {};

   //read access for pool element 
   tS32  s32GetData(tString &tEarlyConfig_TimingLvds2_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tEarlyConfig_TimingLvds2_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tEarlyConfig_TimingLvds2_ManuallyParam);
   tS32 s32SetData(const tString &tEarlyConfig_TimingLvds2_ManuallyParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tEarlyConfig_TimingLvds2_ManuallyParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tEarlyConfig_TimingLvds2_ManuallyParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tEarlyConfig_TimingLvds2_ManuallyParam);
   tVoid vSetData(const tString &tEarlyConfig_TimingLvds2_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS32 tEarlyConfig_ClockEdgeLvds2_Manually;
   
public:
   dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS32& tEarlyConfig_ClockEdgeLvds2_ManuallyParam);
   tVoid operator>>(tS32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS32 &tEarlyConfig_ClockEdgeLvds2_ManuallyParam);
   tS32  s32SetData(const tS32 &tEarlyConfig_ClockEdgeLvds2_ManuallyParam);
   tVoid operator<<(tS32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS32& tEarlyConfig_ClockEdgeLvds2_ManuallyParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS32& tEarlyConfig_ClockEdgeLvds2_ManuallyParam);
   tVoid vSetData(const tS32& tEarlyConfig_ClockEdgeLvds2_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS32 tEarlyConfig_ClockGenerationLvds2_Manually;
   
public:
   dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS32& tEarlyConfig_ClockGenerationLvds2_ManuallyParam);
   tVoid operator>>(tS32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS32 &tEarlyConfig_ClockGenerationLvds2_ManuallyParam);
   tS32  s32SetData(const tS32 &tEarlyConfig_ClockGenerationLvds2_ManuallyParam);
   tVoid operator<<(tS32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS32& tEarlyConfig_ClockGenerationLvds2_ManuallyParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS32& tEarlyConfig_ClockGenerationLvds2_ManuallyParam);
   tVoid vSetData(const tS32& tEarlyConfig_ClockGenerationLvds2_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_Display_Type{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tEarlyConfig_Display_Type;
   
public:
   dp_tclDimmingDPEarlyConfig_Display_Type(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_Display_Type() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tEarlyConfig_Display_TypeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tEarlyConfig_Display_TypeParam);
   tS32  s32SetData(const tU8 &tEarlyConfig_Display_TypeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tEarlyConfig_Display_TypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tEarlyConfig_Display_TypeParam);
   tVoid vSetData(const tU8& tEarlyConfig_Display_TypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPEarlyConfig_DisplayOrder_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDimmingDPEarlyConfig_DisplayOrder_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_DisplayOrder_Manually() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tEarlyConfig_DisplayOrder_ManuallyParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tEarlyConfig_DisplayOrder_ManuallyParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tEarlyConfig_DisplayOrder_ManuallyParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually() {};

   //read access for pool element 
   tS32  s32GetData(tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam);
   tS32 s32SetData(const tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam);
   tVoid vSetData(const tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_BrightnessLevelExtended_Day{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDISP_BrightnessLevelExtended_Day;
   
public:
   dp_tclDimmingDPDISP_BrightnessLevelExtended_Day(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_BrightnessLevelExtended_Day() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDISP_BrightnessLevelExtended_DayParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDISP_BrightnessLevelExtended_DayParam);
   tS32  s32SetData(const tU8 &tDISP_BrightnessLevelExtended_DayParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDISP_BrightnessLevelExtended_DayParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDISP_BrightnessLevelExtended_DayParam);
   tVoid vSetData(const tU8& tDISP_BrightnessLevelExtended_DayParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_BrightnessLevelExtended_Night{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDISP_BrightnessLevelExtended_Night;
   
public:
   dp_tclDimmingDPDISP_BrightnessLevelExtended_Night(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_BrightnessLevelExtended_Night() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDISP_BrightnessLevelExtended_NightParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDISP_BrightnessLevelExtended_NightParam);
   tS32  s32SetData(const tU8 &tDISP_BrightnessLevelExtended_NightParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDISP_BrightnessLevelExtended_NightParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDISP_BrightnessLevelExtended_NightParam);
   tVoid vSetData(const tU8& tDISP_BrightnessLevelExtended_NightParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPINFO_DimmingModeConfig{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tINFO_DimmingModeConfig;
   
public:
   dp_tclDimmingDPINFO_DimmingModeConfig(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPINFO_DimmingModeConfig() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tINFO_DimmingModeConfigParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tINFO_DimmingModeConfigParam);
   tS32  s32SetData(const tU8 &tINFO_DimmingModeConfigParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tINFO_DimmingModeConfigParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tINFO_DimmingModeConfigParam);
   tVoid vSetData(const tU8& tINFO_DimmingModeConfigParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_CSCContrastLevel{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDISP_CSCContrastLevel;
   
public:
   dp_tclDimmingDPDISP_CSCContrastLevel(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_CSCContrastLevel() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDISP_CSCContrastLevelParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDISP_CSCContrastLevelParam);
   tS32  s32SetData(const tU8 &tDISP_CSCContrastLevelParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDISP_CSCContrastLevelParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDISP_CSCContrastLevelParam);
   tVoid vSetData(const tU8& tDISP_CSCContrastLevelParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_CSCContrast{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tDISP_CSCContrast;
   
public:
   dp_tclDimmingDPDISP_CSCContrast(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_CSCContrast() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tDISP_CSCContrastParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tDISP_CSCContrastParam);
   tS32  s32SetData(const tS16 &tDISP_CSCContrastParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tDISP_CSCContrastParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tDISP_CSCContrastParam);
   tVoid vSetData(const tS16& tDISP_CSCContrastParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_CSCSaturationLevel{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDISP_CSCSaturationLevel;
   
public:
   dp_tclDimmingDPDISP_CSCSaturationLevel(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_CSCSaturationLevel() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDISP_CSCSaturationLevelParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDISP_CSCSaturationLevelParam);
   tS32  s32SetData(const tU8 &tDISP_CSCSaturationLevelParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDISP_CSCSaturationLevelParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDISP_CSCSaturationLevelParam);
   tVoid vSetData(const tU8& tDISP_CSCSaturationLevelParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_CSCSaturation{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tDISP_CSCSaturation;
   
public:
   dp_tclDimmingDPDISP_CSCSaturation(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_CSCSaturation() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tDISP_CSCSaturationParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tDISP_CSCSaturationParam);
   tS32  s32SetData(const tS16 &tDISP_CSCSaturationParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tDISP_CSCSaturationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tDISP_CSCSaturationParam);
   tVoid vSetData(const tS16& tDISP_CSCSaturationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_CSCSaturationOffset{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tDISP_CSCSaturationOffset;
   
public:
   dp_tclDimmingDPDISP_CSCSaturationOffset(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_CSCSaturationOffset() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tDISP_CSCSaturationOffsetParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tDISP_CSCSaturationOffsetParam);
   tS32  s32SetData(const tS16 &tDISP_CSCSaturationOffsetParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tDISP_CSCSaturationOffsetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tDISP_CSCSaturationOffsetParam);
   tVoid vSetData(const tS16& tDISP_CSCSaturationOffsetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_CSCColorLevel{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDISP_CSCColorLevel;
   
public:
   dp_tclDimmingDPDISP_CSCColorLevel(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_CSCColorLevel() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDISP_CSCColorLevelParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDISP_CSCColorLevelParam);
   tS32  s32SetData(const tU8 &tDISP_CSCColorLevelParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDISP_CSCColorLevelParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDISP_CSCColorLevelParam);
   tVoid vSetData(const tU8& tDISP_CSCColorLevelParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_CSCColor{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tDISP_CSCColor;
   
public:
   dp_tclDimmingDPDISP_CSCColor(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_CSCColor() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tDISP_CSCColorParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tDISP_CSCColorParam);
   tS32  s32SetData(const tS16 &tDISP_CSCColorParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tDISP_CSCColorParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tDISP_CSCColorParam);
   tVoid vSetData(const tS16& tDISP_CSCColorParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_CSCColorOffset{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tDISP_CSCColorOffset;
   
public:
   dp_tclDimmingDPDISP_CSCColorOffset(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_CSCColorOffset() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tDISP_CSCColorOffsetParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tDISP_CSCColorOffsetParam);
   tS32  s32SetData(const tS16 &tDISP_CSCColorOffsetParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tDISP_CSCColorOffsetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tDISP_CSCColorOffsetParam);
   tVoid vSetData(const tS16& tDISP_CSCColorOffsetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_CSCBrigthness{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tDISP_CSCBrigthness;
   
public:
   dp_tclDimmingDPDISP_CSCBrigthness(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_CSCBrigthness() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tDISP_CSCBrigthnessParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tDISP_CSCBrigthnessParam);
   tS32  s32SetData(const tS16 &tDISP_CSCBrigthnessParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tDISP_CSCBrigthnessParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tDISP_CSCBrigthnessParam);
   tVoid vSetData(const tS16& tDISP_CSCBrigthnessParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_CSCBrigthnessOffset{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tDISP_CSCBrigthnessOffset;
   
public:
   dp_tclDimmingDPDISP_CSCBrigthnessOffset(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_CSCBrigthnessOffset() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tDISP_CSCBrigthnessOffsetParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tDISP_CSCBrigthnessOffsetParam);
   tS32  s32SetData(const tS16 &tDISP_CSCBrigthnessOffsetParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tDISP_CSCBrigthnessOffsetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tDISP_CSCBrigthnessOffsetParam);
   tVoid vSetData(const tS16& tDISP_CSCBrigthnessOffsetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_CSCBlackLevel{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDISP_CSCBlackLevel;
   
public:
   dp_tclDimmingDPDISP_CSCBlackLevel(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_CSCBlackLevel() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDISP_CSCBlackLevelParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDISP_CSCBlackLevelParam);
   tS32  s32SetData(const tU8 &tDISP_CSCBlackLevelParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDISP_CSCBlackLevelParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDISP_CSCBlackLevelParam);
   tVoid vSetData(const tU8& tDISP_CSCBlackLevelParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_CSCGammaLevel{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDISP_CSCGammaLevel;
   
public:
   dp_tclDimmingDPDISP_CSCGammaLevel(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_CSCGammaLevel() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDISP_CSCGammaLevelParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDISP_CSCGammaLevelParam);
   tS32  s32SetData(const tU8 &tDISP_CSCGammaLevelParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDISP_CSCGammaLevelParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDISP_CSCGammaLevelParam);
   tVoid vSetData(const tU8& tDISP_CSCGammaLevelParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_CSCGamma{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tDISP_CSCGamma;
   
public:
   dp_tclDimmingDPDISP_CSCGamma(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_CSCGamma() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tDISP_CSCGammaParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tDISP_CSCGammaParam);
   tS32  s32SetData(const tU16 &tDISP_CSCGammaParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tDISP_CSCGammaParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tDISP_CSCGammaParam);
   tVoid vSetData(const tU16& tDISP_CSCGammaParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPINFO_DimmingModeCar{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tINFO_DimmingModeCar;
   
public:
   dp_tclDimmingDPINFO_DimmingModeCar(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPINFO_DimmingModeCar() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tINFO_DimmingModeCarParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tINFO_DimmingModeCarParam);
   tS32  s32SetData(const tU8 &tINFO_DimmingModeCarParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tINFO_DimmingModeCarParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tINFO_DimmingModeCarParam);
   tVoid vSetData(const tU8& tINFO_DimmingModeCarParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPINFO_DimmingModeStatus{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tINFO_DimmingModeStatus;
   
public:
   dp_tclDimmingDPINFO_DimmingModeStatus(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPINFO_DimmingModeStatus() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tINFO_DimmingModeStatusParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tINFO_DimmingModeStatusParam);
   tS32  s32SetData(const tU8 &tINFO_DimmingModeStatusParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tINFO_DimmingModeStatusParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tINFO_DimmingModeStatusParam);
   tVoid vSetData(const tU8& tINFO_DimmingModeStatusParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPINFO_EmulationModeSet{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tINFO_EmulationModeSet;
   
public:
   dp_tclDimmingDPINFO_EmulationModeSet(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPINFO_EmulationModeSet() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tINFO_EmulationModeSetParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tINFO_EmulationModeSetParam);
   tS32  s32SetData(const tU8 &tINFO_EmulationModeSetParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tINFO_EmulationModeSetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tINFO_EmulationModeSetParam);
   tVoid vSetData(const tU8& tINFO_EmulationModeSetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tCALIBRATION_BrightnessMatrix_Selection;
   
public:
   dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tCALIBRATION_BrightnessMatrix_SelectionParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tCALIBRATION_BrightnessMatrix_SelectionParam);
   tS32  s32SetData(const tU8 &tCALIBRATION_BrightnessMatrix_SelectionParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tCALIBRATION_BrightnessMatrix_SelectionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tCALIBRATION_BrightnessMatrix_SelectionParam);
   tVoid vSetData(const tU8& tCALIBRATION_BrightnessMatrix_SelectionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPDISP_Brightness_Calibration_Day_Set{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDimmingDPDISP_Brightness_Calibration_Day_Set(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_Brightness_Calibration_Day_Set() {};

   //read access for pool element 
   tS32  s32GetData(tU16* tDISP_Brightness_Calibration_Day_SetParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU16* tDISP_Brightness_Calibration_Day_SetParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU16* tDISP_Brightness_Calibration_Day_SetParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDimmingDPDISP_Brightness_Calibration_Night_Set{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDimmingDPDISP_Brightness_Calibration_Night_Set(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPDISP_Brightness_Calibration_Night_Set() {};

   //read access for pool element 
   tS32  s32GetData(tU16* tDISP_Brightness_Calibration_Night_SetParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU16* tDISP_Brightness_Calibration_Night_SetParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU16* tDISP_Brightness_Calibration_Night_SetParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSLIDER_Screen_DAY_Luminosity_OFFSET;
   
public:
   dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSLIDER_Screen_DAY_Luminosity_OFFSETParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSLIDER_Screen_DAY_Luminosity_OFFSETParam);
   tS32  s32SetData(const tU8 &tSLIDER_Screen_DAY_Luminosity_OFFSETParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSLIDER_Screen_DAY_Luminosity_OFFSETParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSLIDER_Screen_DAY_Luminosity_OFFSETParam);
   tVoid vSetData(const tU8& tSLIDER_Screen_DAY_Luminosity_OFFSETParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSLIDER_COCKPIT_Brightness_OFFSET;
   
public:
   dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSLIDER_COCKPIT_Brightness_OFFSETParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSLIDER_COCKPIT_Brightness_OFFSETParam);
   tS32  s32SetData(const tU8 &tSLIDER_COCKPIT_Brightness_OFFSETParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSLIDER_COCKPIT_Brightness_OFFSETParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSLIDER_COCKPIT_Brightness_OFFSETParam);
   tVoid vSetData(const tU8& tSLIDER_COCKPIT_Brightness_OFFSETParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSLIDER_Screen_NIGHT_Luminosity_OFFSET;
   
public:
   dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam);
   tS32  s32SetData(const tU8 &tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam);
   tVoid vSetData(const tU8& tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
