
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclDimmingDP.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_DisplayResulution_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually::dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually::s32SetData(tString &tEarlyConfig_DisplayResulution_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_DisplayResulution_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_DisplayResulution_Manually", (tS32)0x6e294e74L);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_DisplayResulution_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually::s32SetData(const tString &tEarlyConfig_DisplayResulution_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_DisplayResulution_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_DisplayResulution_Manually", (tS32)0x6e294e74L);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_DisplayResulution_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually::s32GetData(tString &tEarlyConfig_DisplayResulution_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_DisplayResulution_Manually", (tS32)0x6e294e74L);
   (tVoid)memset(tEarlyConfig_DisplayResulution_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_DisplayResulution_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually::s32GetData(const tString &tEarlyConfig_DisplayResulution_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_DisplayResulution_Manually", (tS32)0x6e294e74L);
   (tVoid)memset(tEarlyConfig_DisplayResulution_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_DisplayResulution_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually::u32GetData(tString &tEarlyConfig_DisplayResulution_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_DisplayResulution_ManuallyParam, u32StringBufLen);
   };
    tU32  dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually::u32GetData(const tString &tEarlyConfig_DisplayResulution_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_DisplayResulution_ManuallyParam, u32StringBufLen);
   };
   tVoid dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually::vSetData(tString &tEarlyConfig_DisplayResulution_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_DisplayResulution_ManuallyParam);};
   tVoid dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually::vSetData(const tString &tEarlyConfig_DisplayResulution_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_DisplayResulution_ManuallyParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_DisplayResulution_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_DisplayResulution_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_DisplayResulution_Manually::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_DisplayResulution_Manually", DP_U32_POOL_ID_DIMMINGDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
		}
		else
		{
			fprintf(stdout,"Element EarlyConfig_DisplayResulution_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_DisplayBackwardComp_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEarlyConfig_DisplayBackwardComp_Manually,0,sizeof(tS32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_DisplayBackwardComp_Manually",(tS32) 0x980f0950L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS32)) 
      {
         tEarlyConfig_DisplayBackwardComp_Manually = *((tS32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EarlyConfig_DisplayBackwardComp_Manually", (tS32)0x980f0950L);
   (tVoid)myDpElem.bFillData((tVoid*)&tEarlyConfig_DisplayBackwardComp_Manually, (tU32)sizeof(tS32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS32 dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::tGetData() {
   vUpdate();
   return tEarlyConfig_DisplayBackwardComp_Manually;
};
tS32 dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::s32GetData(tS32& tEarlyConfig_DisplayBackwardComp_ManuallyParam) { 
   vUpdate();
   tEarlyConfig_DisplayBackwardComp_ManuallyParam = tEarlyConfig_DisplayBackwardComp_Manually;
   return _s32Status;
}
tS32 dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EarlyConfig_DisplayBackwardComp_Manually", (tS32)0x980f0950L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::operator>>(tS32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::operator<<(tS32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::s32SetData(tS32 &tEarlyConfig_DisplayBackwardComp_ManuallyParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_DisplayBackwardComp_Manually,(tVoid*)&tEarlyConfig_DisplayBackwardComp_ManuallyParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyConfig_DisplayBackwardComp_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::vSetData(tS32)' could be made const reference
tS32 dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::s32SetData(const tS32 &tEarlyConfig_DisplayBackwardComp_ManuallyParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_DisplayBackwardComp_Manually,(tVoid*)&tEarlyConfig_DisplayBackwardComp_ManuallyParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyConfig_DisplayBackwardComp_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::vSetData(tS32)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::u8GetData(tS32& tEarlyConfig_DisplayBackwardComp_ManuallyParam) {  
   vUpdate();
   tEarlyConfig_DisplayBackwardComp_ManuallyParam = tEarlyConfig_DisplayBackwardComp_Manually;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::vSetData(tS32 &tEarlyConfig_DisplayBackwardComp_ManuallyParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_DisplayBackwardComp_Manually,(tVoid*)&tEarlyConfig_DisplayBackwardComp_ManuallyParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tEarlyConfig_DisplayBackwardComp_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::vSetData(tS32)' could be made const reference
tVoid dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::vSetData(const tS32 &tEarlyConfig_DisplayBackwardComp_ManuallyParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_DisplayBackwardComp_Manually,(tVoid*)&tEarlyConfig_DisplayBackwardComp_ManuallyParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tEarlyConfig_DisplayBackwardComp_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::vSetData(tS32)' could be made const reference
tU8   dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_DisplayBackwardComp_Manually", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_DisplayBackwardComp_Manually", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPEarlyConfig_DisplayBackwardComp_Manually::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_DisplayBackwardComp_Manually", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element EarlyConfig_DisplayBackwardComp_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_DisplayLowFrequency_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEarlyConfig_DisplayLowFrequency_Manually,0,sizeof(tS32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_DisplayLowFrequency_Manually",(tS32) 0xd5ee282eL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS32)) 
      {
         tEarlyConfig_DisplayLowFrequency_Manually = *((tS32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EarlyConfig_DisplayLowFrequency_Manually", (tS32)0xd5ee282eL);
   (tVoid)myDpElem.bFillData((tVoid*)&tEarlyConfig_DisplayLowFrequency_Manually, (tU32)sizeof(tS32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS32 dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::tGetData() {
   vUpdate();
   return tEarlyConfig_DisplayLowFrequency_Manually;
};
tS32 dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::s32GetData(tS32& tEarlyConfig_DisplayLowFrequency_ManuallyParam) { 
   vUpdate();
   tEarlyConfig_DisplayLowFrequency_ManuallyParam = tEarlyConfig_DisplayLowFrequency_Manually;
   return _s32Status;
}
tS32 dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EarlyConfig_DisplayLowFrequency_Manually", (tS32)0xd5ee282eL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::operator>>(tS32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::operator<<(tS32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::s32SetData(tS32 &tEarlyConfig_DisplayLowFrequency_ManuallyParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_DisplayLowFrequency_Manually,(tVoid*)&tEarlyConfig_DisplayLowFrequency_ManuallyParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyConfig_DisplayLowFrequency_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::vSetData(tS32)' could be made const reference
tS32 dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::s32SetData(const tS32 &tEarlyConfig_DisplayLowFrequency_ManuallyParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_DisplayLowFrequency_Manually,(tVoid*)&tEarlyConfig_DisplayLowFrequency_ManuallyParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyConfig_DisplayLowFrequency_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::vSetData(tS32)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::u8GetData(tS32& tEarlyConfig_DisplayLowFrequency_ManuallyParam) {  
   vUpdate();
   tEarlyConfig_DisplayLowFrequency_ManuallyParam = tEarlyConfig_DisplayLowFrequency_Manually;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::vSetData(tS32 &tEarlyConfig_DisplayLowFrequency_ManuallyParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_DisplayLowFrequency_Manually,(tVoid*)&tEarlyConfig_DisplayLowFrequency_ManuallyParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tEarlyConfig_DisplayLowFrequency_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::vSetData(tS32)' could be made const reference
tVoid dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::vSetData(const tS32 &tEarlyConfig_DisplayLowFrequency_ManuallyParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_DisplayLowFrequency_Manually,(tVoid*)&tEarlyConfig_DisplayLowFrequency_ManuallyParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tEarlyConfig_DisplayLowFrequency_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::vSetData(tS32)' could be made const reference
tU8   dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_DisplayLowFrequency_Manually", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_DisplayLowFrequency_Manually", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPEarlyConfig_DisplayLowFrequency_Manually::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_DisplayLowFrequency_Manually", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element EarlyConfig_DisplayLowFrequency_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_RTCDriverName_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually::dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually::s32SetData(tString &tEarlyConfig_RTCDriverName_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_RTCDriverName_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_RTCDriverName_Manually", (tS32)0xeb66f32eL);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_RTCDriverName_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually::s32SetData(const tString &tEarlyConfig_RTCDriverName_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_RTCDriverName_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_RTCDriverName_Manually", (tS32)0xeb66f32eL);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_RTCDriverName_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually::s32GetData(tString &tEarlyConfig_RTCDriverName_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_RTCDriverName_Manually", (tS32)0xeb66f32eL);
   (tVoid)memset(tEarlyConfig_RTCDriverName_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_RTCDriverName_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually::s32GetData(const tString &tEarlyConfig_RTCDriverName_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_RTCDriverName_Manually", (tS32)0xeb66f32eL);
   (tVoid)memset(tEarlyConfig_RTCDriverName_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_RTCDriverName_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually::u32GetData(tString &tEarlyConfig_RTCDriverName_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_RTCDriverName_ManuallyParam, u32StringBufLen);
   };
    tU32  dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually::u32GetData(const tString &tEarlyConfig_RTCDriverName_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_RTCDriverName_ManuallyParam, u32StringBufLen);
   };
   tVoid dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually::vSetData(tString &tEarlyConfig_RTCDriverName_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_RTCDriverName_ManuallyParam);};
   tVoid dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually::vSetData(const tString &tEarlyConfig_RTCDriverName_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_RTCDriverName_ManuallyParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_RTCDriverName_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_RTCDriverName_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_RTCDriverName_Manually::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_RTCDriverName_Manually", DP_U32_POOL_ID_DIMMINGDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
		}
		else
		{
			fprintf(stdout,"Element EarlyConfig_RTCDriverName_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_TouchDriverName_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually::dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually::s32SetData(tString &tEarlyConfig_TouchDriverName_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TouchDriverName_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TouchDriverName_Manually", (tS32)0x8ef2edb8L);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TouchDriverName_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually::s32SetData(const tString &tEarlyConfig_TouchDriverName_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TouchDriverName_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TouchDriverName_Manually", (tS32)0x8ef2edb8L);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TouchDriverName_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually::s32GetData(tString &tEarlyConfig_TouchDriverName_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TouchDriverName_Manually", (tS32)0x8ef2edb8L);
   (tVoid)memset(tEarlyConfig_TouchDriverName_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TouchDriverName_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually::s32GetData(const tString &tEarlyConfig_TouchDriverName_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TouchDriverName_Manually", (tS32)0x8ef2edb8L);
   (tVoid)memset(tEarlyConfig_TouchDriverName_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TouchDriverName_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually::u32GetData(tString &tEarlyConfig_TouchDriverName_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TouchDriverName_ManuallyParam, u32StringBufLen);
   };
    tU32  dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually::u32GetData(const tString &tEarlyConfig_TouchDriverName_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TouchDriverName_ManuallyParam, u32StringBufLen);
   };
   tVoid dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually::vSetData(tString &tEarlyConfig_TouchDriverName_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TouchDriverName_ManuallyParam);};
   tVoid dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually::vSetData(const tString &tEarlyConfig_TouchDriverName_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TouchDriverName_ManuallyParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TouchDriverName_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TouchDriverName_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TouchDriverName_Manually::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_TouchDriverName_Manually", DP_U32_POOL_ID_DIMMINGDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
		}
		else
		{
			fprintf(stdout,"Element EarlyConfig_TouchDriverName_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_TouchConfigFile_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually::dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually::s32SetData(tString &tEarlyConfig_TouchConfigFile_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TouchConfigFile_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TouchConfigFile_Manually", (tS32)0x9d183f29L);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TouchConfigFile_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually::s32SetData(const tString &tEarlyConfig_TouchConfigFile_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TouchConfigFile_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TouchConfigFile_Manually", (tS32)0x9d183f29L);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TouchConfigFile_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually::s32GetData(tString &tEarlyConfig_TouchConfigFile_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TouchConfigFile_Manually", (tS32)0x9d183f29L);
   (tVoid)memset(tEarlyConfig_TouchConfigFile_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TouchConfigFile_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually::s32GetData(const tString &tEarlyConfig_TouchConfigFile_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TouchConfigFile_Manually", (tS32)0x9d183f29L);
   (tVoid)memset(tEarlyConfig_TouchConfigFile_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TouchConfigFile_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually::u32GetData(tString &tEarlyConfig_TouchConfigFile_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TouchConfigFile_ManuallyParam, u32StringBufLen);
   };
    tU32  dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually::u32GetData(const tString &tEarlyConfig_TouchConfigFile_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TouchConfigFile_ManuallyParam, u32StringBufLen);
   };
   tVoid dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually::vSetData(tString &tEarlyConfig_TouchConfigFile_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TouchConfigFile_ManuallyParam);};
   tVoid dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually::vSetData(const tString &tEarlyConfig_TouchConfigFile_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TouchConfigFile_ManuallyParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TouchConfigFile_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TouchConfigFile_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TouchConfigFile_Manually::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_TouchConfigFile_Manually", DP_U32_POOL_ID_DIMMINGDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
		}
		else
		{
			fprintf(stdout,"Element EarlyConfig_TouchConfigFile_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_TouchI2CAddress_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually::dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually::s32SetData(tString &tEarlyConfig_TouchI2CAddress_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TouchI2CAddress_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TouchI2CAddress_Manually", (tS32)0xdc0e6503L);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TouchI2CAddress_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually::s32SetData(const tString &tEarlyConfig_TouchI2CAddress_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TouchI2CAddress_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TouchI2CAddress_Manually", (tS32)0xdc0e6503L);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TouchI2CAddress_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually::s32GetData(tString &tEarlyConfig_TouchI2CAddress_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TouchI2CAddress_Manually", (tS32)0xdc0e6503L);
   (tVoid)memset(tEarlyConfig_TouchI2CAddress_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TouchI2CAddress_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually::s32GetData(const tString &tEarlyConfig_TouchI2CAddress_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TouchI2CAddress_Manually", (tS32)0xdc0e6503L);
   (tVoid)memset(tEarlyConfig_TouchI2CAddress_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TouchI2CAddress_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually::u32GetData(tString &tEarlyConfig_TouchI2CAddress_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TouchI2CAddress_ManuallyParam, u32StringBufLen);
   };
    tU32  dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually::u32GetData(const tString &tEarlyConfig_TouchI2CAddress_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TouchI2CAddress_ManuallyParam, u32StringBufLen);
   };
   tVoid dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually::vSetData(tString &tEarlyConfig_TouchI2CAddress_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TouchI2CAddress_ManuallyParam);};
   tVoid dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually::vSetData(const tString &tEarlyConfig_TouchI2CAddress_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TouchI2CAddress_ManuallyParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TouchI2CAddress_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TouchI2CAddress_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TouchI2CAddress_Manually::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_TouchI2CAddress_Manually", DP_U32_POOL_ID_DIMMINGDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
		}
		else
		{
			fprintf(stdout,"Element EarlyConfig_TouchI2CAddress_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_TouchDriverName2_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually::dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually::s32SetData(tString &tEarlyConfig_TouchDriverName2_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TouchDriverName2_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TouchDriverName2_Manually", (tS32)0xc5d1b8eaL);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TouchDriverName2_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually::s32SetData(const tString &tEarlyConfig_TouchDriverName2_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TouchDriverName2_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TouchDriverName2_Manually", (tS32)0xc5d1b8eaL);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TouchDriverName2_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually::s32GetData(tString &tEarlyConfig_TouchDriverName2_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TouchDriverName2_Manually", (tS32)0xc5d1b8eaL);
   (tVoid)memset(tEarlyConfig_TouchDriverName2_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TouchDriverName2_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually::s32GetData(const tString &tEarlyConfig_TouchDriverName2_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TouchDriverName2_Manually", (tS32)0xc5d1b8eaL);
   (tVoid)memset(tEarlyConfig_TouchDriverName2_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TouchDriverName2_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually::u32GetData(tString &tEarlyConfig_TouchDriverName2_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TouchDriverName2_ManuallyParam, u32StringBufLen);
   };
    tU32  dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually::u32GetData(const tString &tEarlyConfig_TouchDriverName2_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TouchDriverName2_ManuallyParam, u32StringBufLen);
   };
   tVoid dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually::vSetData(tString &tEarlyConfig_TouchDriverName2_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TouchDriverName2_ManuallyParam);};
   tVoid dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually::vSetData(const tString &tEarlyConfig_TouchDriverName2_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TouchDriverName2_ManuallyParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TouchDriverName2_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TouchDriverName2_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TouchDriverName2_Manually::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_TouchDriverName2_Manually", DP_U32_POOL_ID_DIMMINGDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
		}
		else
		{
			fprintf(stdout,"Element EarlyConfig_TouchDriverName2_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_TouchConfigFile2_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually::dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually::s32SetData(tString &tEarlyConfig_TouchConfigFile2_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TouchConfigFile2_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TouchConfigFile2_Manually", (tS32)0xc8c501fL);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TouchConfigFile2_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually::s32SetData(const tString &tEarlyConfig_TouchConfigFile2_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TouchConfigFile2_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TouchConfigFile2_Manually", (tS32)0xc8c501fL);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TouchConfigFile2_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually::s32GetData(tString &tEarlyConfig_TouchConfigFile2_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TouchConfigFile2_Manually", (tS32)0xc8c501fL);
   (tVoid)memset(tEarlyConfig_TouchConfigFile2_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TouchConfigFile2_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually::s32GetData(const tString &tEarlyConfig_TouchConfigFile2_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TouchConfigFile2_Manually", (tS32)0xc8c501fL);
   (tVoid)memset(tEarlyConfig_TouchConfigFile2_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TouchConfigFile2_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually::u32GetData(tString &tEarlyConfig_TouchConfigFile2_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TouchConfigFile2_ManuallyParam, u32StringBufLen);
   };
    tU32  dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually::u32GetData(const tString &tEarlyConfig_TouchConfigFile2_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TouchConfigFile2_ManuallyParam, u32StringBufLen);
   };
   tVoid dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually::vSetData(tString &tEarlyConfig_TouchConfigFile2_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TouchConfigFile2_ManuallyParam);};
   tVoid dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually::vSetData(const tString &tEarlyConfig_TouchConfigFile2_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TouchConfigFile2_ManuallyParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TouchConfigFile2_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TouchConfigFile2_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TouchConfigFile2_Manually::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_TouchConfigFile2_Manually", DP_U32_POOL_ID_DIMMINGDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
		}
		else
		{
			fprintf(stdout,"Element EarlyConfig_TouchConfigFile2_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_TouchI2CAddress2_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually::dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually::s32SetData(tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TouchI2CAddress2_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TouchI2CAddress2_Manually", (tS32)0x475b0d61L);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TouchI2CAddress2_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually::s32SetData(const tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TouchI2CAddress2_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TouchI2CAddress2_Manually", (tS32)0x475b0d61L);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TouchI2CAddress2_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually::s32GetData(tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TouchI2CAddress2_Manually", (tS32)0x475b0d61L);
   (tVoid)memset(tEarlyConfig_TouchI2CAddress2_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TouchI2CAddress2_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually::s32GetData(const tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TouchI2CAddress2_Manually", (tS32)0x475b0d61L);
   (tVoid)memset(tEarlyConfig_TouchI2CAddress2_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TouchI2CAddress2_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually::u32GetData(tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TouchI2CAddress2_ManuallyParam, u32StringBufLen);
   };
    tU32  dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually::u32GetData(const tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TouchI2CAddress2_ManuallyParam, u32StringBufLen);
   };
   tVoid dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually::vSetData(tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TouchI2CAddress2_ManuallyParam);};
   tVoid dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually::vSetData(const tString &tEarlyConfig_TouchI2CAddress2_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TouchI2CAddress2_ManuallyParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TouchI2CAddress2_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TouchI2CAddress2_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TouchI2CAddress2_Manually::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_TouchI2CAddress2_Manually", DP_U32_POOL_ID_DIMMINGDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
		}
		else
		{
			fprintf(stdout,"Element EarlyConfig_TouchI2CAddress2_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_TimingLvds1_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually::dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually::s32SetData(tString &tEarlyConfig_TimingLvds1_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TimingLvds1_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TimingLvds1_Manually", (tS32)0x6ff83b1eL);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TimingLvds1_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually::s32SetData(const tString &tEarlyConfig_TimingLvds1_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TimingLvds1_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TimingLvds1_Manually", (tS32)0x6ff83b1eL);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TimingLvds1_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually::s32GetData(tString &tEarlyConfig_TimingLvds1_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TimingLvds1_Manually", (tS32)0x6ff83b1eL);
   (tVoid)memset(tEarlyConfig_TimingLvds1_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TimingLvds1_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually::s32GetData(const tString &tEarlyConfig_TimingLvds1_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TimingLvds1_Manually", (tS32)0x6ff83b1eL);
   (tVoid)memset(tEarlyConfig_TimingLvds1_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TimingLvds1_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually::u32GetData(tString &tEarlyConfig_TimingLvds1_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TimingLvds1_ManuallyParam, u32StringBufLen);
   };
    tU32  dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually::u32GetData(const tString &tEarlyConfig_TimingLvds1_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TimingLvds1_ManuallyParam, u32StringBufLen);
   };
   tVoid dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually::vSetData(tString &tEarlyConfig_TimingLvds1_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TimingLvds1_ManuallyParam);};
   tVoid dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually::vSetData(const tString &tEarlyConfig_TimingLvds1_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TimingLvds1_ManuallyParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TimingLvds1_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TimingLvds1_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TimingLvds1_Manually::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_TimingLvds1_Manually", DP_U32_POOL_ID_DIMMINGDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
		}
		else
		{
			fprintf(stdout,"Element EarlyConfig_TimingLvds1_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_ClockEdgeLvds1_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEarlyConfig_ClockEdgeLvds1_Manually,0,sizeof(tS32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_ClockEdgeLvds1_Manually",(tS32) 0xbd184e37L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS32)) 
      {
         tEarlyConfig_ClockEdgeLvds1_Manually = *((tS32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EarlyConfig_ClockEdgeLvds1_Manually", (tS32)0xbd184e37L);
   (tVoid)myDpElem.bFillData((tVoid*)&tEarlyConfig_ClockEdgeLvds1_Manually, (tU32)sizeof(tS32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS32 dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::tGetData() {
   vUpdate();
   return tEarlyConfig_ClockEdgeLvds1_Manually;
};
tS32 dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::s32GetData(tS32& tEarlyConfig_ClockEdgeLvds1_ManuallyParam) { 
   vUpdate();
   tEarlyConfig_ClockEdgeLvds1_ManuallyParam = tEarlyConfig_ClockEdgeLvds1_Manually;
   return _s32Status;
}
tS32 dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EarlyConfig_ClockEdgeLvds1_Manually", (tS32)0xbd184e37L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::operator>>(tS32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::operator<<(tS32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::s32SetData(tS32 &tEarlyConfig_ClockEdgeLvds1_ManuallyParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockEdgeLvds1_Manually,(tVoid*)&tEarlyConfig_ClockEdgeLvds1_ManuallyParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyConfig_ClockEdgeLvds1_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::vSetData(tS32)' could be made const reference
tS32 dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::s32SetData(const tS32 &tEarlyConfig_ClockEdgeLvds1_ManuallyParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockEdgeLvds1_Manually,(tVoid*)&tEarlyConfig_ClockEdgeLvds1_ManuallyParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyConfig_ClockEdgeLvds1_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::vSetData(tS32)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::u8GetData(tS32& tEarlyConfig_ClockEdgeLvds1_ManuallyParam) {  
   vUpdate();
   tEarlyConfig_ClockEdgeLvds1_ManuallyParam = tEarlyConfig_ClockEdgeLvds1_Manually;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::vSetData(tS32 &tEarlyConfig_ClockEdgeLvds1_ManuallyParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockEdgeLvds1_Manually,(tVoid*)&tEarlyConfig_ClockEdgeLvds1_ManuallyParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tEarlyConfig_ClockEdgeLvds1_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::vSetData(tS32)' could be made const reference
tVoid dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::vSetData(const tS32 &tEarlyConfig_ClockEdgeLvds1_ManuallyParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockEdgeLvds1_Manually,(tVoid*)&tEarlyConfig_ClockEdgeLvds1_ManuallyParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tEarlyConfig_ClockEdgeLvds1_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::vSetData(tS32)' could be made const reference
tU8   dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_ClockEdgeLvds1_Manually", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_ClockEdgeLvds1_Manually", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPEarlyConfig_ClockEdgeLvds1_Manually::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_ClockEdgeLvds1_Manually", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element EarlyConfig_ClockEdgeLvds1_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_ClockGenerationLvds1_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEarlyConfig_ClockGenerationLvds1_Manually,0,sizeof(tS32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_ClockGenerationLvds1_Manually",(tS32) 0xdd75ccd6L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS32)) 
      {
         tEarlyConfig_ClockGenerationLvds1_Manually = *((tS32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EarlyConfig_ClockGenerationLvds1_Manually", (tS32)0xdd75ccd6L);
   (tVoid)myDpElem.bFillData((tVoid*)&tEarlyConfig_ClockGenerationLvds1_Manually, (tU32)sizeof(tS32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS32 dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::tGetData() {
   vUpdate();
   return tEarlyConfig_ClockGenerationLvds1_Manually;
};
tS32 dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::s32GetData(tS32& tEarlyConfig_ClockGenerationLvds1_ManuallyParam) { 
   vUpdate();
   tEarlyConfig_ClockGenerationLvds1_ManuallyParam = tEarlyConfig_ClockGenerationLvds1_Manually;
   return _s32Status;
}
tS32 dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EarlyConfig_ClockGenerationLvds1_Manually", (tS32)0xdd75ccd6L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::operator>>(tS32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::operator<<(tS32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::s32SetData(tS32 &tEarlyConfig_ClockGenerationLvds1_ManuallyParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockGenerationLvds1_Manually,(tVoid*)&tEarlyConfig_ClockGenerationLvds1_ManuallyParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyConfig_ClockGenerationLvds1_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::vSetData(tS32)' could be made const reference
tS32 dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::s32SetData(const tS32 &tEarlyConfig_ClockGenerationLvds1_ManuallyParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockGenerationLvds1_Manually,(tVoid*)&tEarlyConfig_ClockGenerationLvds1_ManuallyParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyConfig_ClockGenerationLvds1_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::vSetData(tS32)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::u8GetData(tS32& tEarlyConfig_ClockGenerationLvds1_ManuallyParam) {  
   vUpdate();
   tEarlyConfig_ClockGenerationLvds1_ManuallyParam = tEarlyConfig_ClockGenerationLvds1_Manually;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::vSetData(tS32 &tEarlyConfig_ClockGenerationLvds1_ManuallyParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockGenerationLvds1_Manually,(tVoid*)&tEarlyConfig_ClockGenerationLvds1_ManuallyParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tEarlyConfig_ClockGenerationLvds1_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::vSetData(tS32)' could be made const reference
tVoid dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::vSetData(const tS32 &tEarlyConfig_ClockGenerationLvds1_ManuallyParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockGenerationLvds1_Manually,(tVoid*)&tEarlyConfig_ClockGenerationLvds1_ManuallyParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tEarlyConfig_ClockGenerationLvds1_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::vSetData(tS32)' could be made const reference
tU8   dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_ClockGenerationLvds1_Manually", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_ClockGenerationLvds1_Manually", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPEarlyConfig_ClockGenerationLvds1_Manually::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_ClockGenerationLvds1_Manually", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element EarlyConfig_ClockGenerationLvds1_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_TimingLvds2_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually::dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually::s32SetData(tString &tEarlyConfig_TimingLvds2_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TimingLvds2_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TimingLvds2_Manually", (tS32)0x70160883L);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TimingLvds2_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually::s32SetData(const tString &tEarlyConfig_TimingLvds2_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_TimingLvds2_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_TimingLvds2_Manually", (tS32)0x70160883L);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_TimingLvds2_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually::s32GetData(tString &tEarlyConfig_TimingLvds2_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TimingLvds2_Manually", (tS32)0x70160883L);
   (tVoid)memset(tEarlyConfig_TimingLvds2_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TimingLvds2_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually::s32GetData(const tString &tEarlyConfig_TimingLvds2_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_TimingLvds2_Manually", (tS32)0x70160883L);
   (tVoid)memset(tEarlyConfig_TimingLvds2_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_TimingLvds2_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually::u32GetData(tString &tEarlyConfig_TimingLvds2_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TimingLvds2_ManuallyParam, u32StringBufLen);
   };
    tU32  dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually::u32GetData(const tString &tEarlyConfig_TimingLvds2_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_TimingLvds2_ManuallyParam, u32StringBufLen);
   };
   tVoid dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually::vSetData(tString &tEarlyConfig_TimingLvds2_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TimingLvds2_ManuallyParam);};
   tVoid dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually::vSetData(const tString &tEarlyConfig_TimingLvds2_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_TimingLvds2_ManuallyParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TimingLvds2_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_TimingLvds2_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_TimingLvds2_Manually::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_TimingLvds2_Manually", DP_U32_POOL_ID_DIMMINGDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
		}
		else
		{
			fprintf(stdout,"Element EarlyConfig_TimingLvds2_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_ClockEdgeLvds2_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEarlyConfig_ClockEdgeLvds2_Manually,0,sizeof(tS32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_ClockEdgeLvds2_Manually",(tS32) 0xbd361b9cL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS32)) 
      {
         tEarlyConfig_ClockEdgeLvds2_Manually = *((tS32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EarlyConfig_ClockEdgeLvds2_Manually", (tS32)0xbd361b9cL);
   (tVoid)myDpElem.bFillData((tVoid*)&tEarlyConfig_ClockEdgeLvds2_Manually, (tU32)sizeof(tS32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS32 dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::tGetData() {
   vUpdate();
   return tEarlyConfig_ClockEdgeLvds2_Manually;
};
tS32 dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::s32GetData(tS32& tEarlyConfig_ClockEdgeLvds2_ManuallyParam) { 
   vUpdate();
   tEarlyConfig_ClockEdgeLvds2_ManuallyParam = tEarlyConfig_ClockEdgeLvds2_Manually;
   return _s32Status;
}
tS32 dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EarlyConfig_ClockEdgeLvds2_Manually", (tS32)0xbd361b9cL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::operator>>(tS32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::operator<<(tS32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::s32SetData(tS32 &tEarlyConfig_ClockEdgeLvds2_ManuallyParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockEdgeLvds2_Manually,(tVoid*)&tEarlyConfig_ClockEdgeLvds2_ManuallyParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyConfig_ClockEdgeLvds2_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::vSetData(tS32)' could be made const reference
tS32 dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::s32SetData(const tS32 &tEarlyConfig_ClockEdgeLvds2_ManuallyParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockEdgeLvds2_Manually,(tVoid*)&tEarlyConfig_ClockEdgeLvds2_ManuallyParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyConfig_ClockEdgeLvds2_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::vSetData(tS32)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::u8GetData(tS32& tEarlyConfig_ClockEdgeLvds2_ManuallyParam) {  
   vUpdate();
   tEarlyConfig_ClockEdgeLvds2_ManuallyParam = tEarlyConfig_ClockEdgeLvds2_Manually;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::vSetData(tS32 &tEarlyConfig_ClockEdgeLvds2_ManuallyParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockEdgeLvds2_Manually,(tVoid*)&tEarlyConfig_ClockEdgeLvds2_ManuallyParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tEarlyConfig_ClockEdgeLvds2_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::vSetData(tS32)' could be made const reference
tVoid dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::vSetData(const tS32 &tEarlyConfig_ClockEdgeLvds2_ManuallyParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockEdgeLvds2_Manually,(tVoid*)&tEarlyConfig_ClockEdgeLvds2_ManuallyParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tEarlyConfig_ClockEdgeLvds2_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::vSetData(tS32)' could be made const reference
tU8   dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_ClockEdgeLvds2_Manually", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_ClockEdgeLvds2_Manually", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPEarlyConfig_ClockEdgeLvds2_Manually::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_ClockEdgeLvds2_Manually", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element EarlyConfig_ClockEdgeLvds2_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_ClockGenerationLvds2_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEarlyConfig_ClockGenerationLvds2_Manually,0,sizeof(tS32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_ClockGenerationLvds2_Manually",(tS32) 0xdd939a3bL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS32)) 
      {
         tEarlyConfig_ClockGenerationLvds2_Manually = *((tS32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EarlyConfig_ClockGenerationLvds2_Manually", (tS32)0xdd939a3bL);
   (tVoid)myDpElem.bFillData((tVoid*)&tEarlyConfig_ClockGenerationLvds2_Manually, (tU32)sizeof(tS32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS32 dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::tGetData() {
   vUpdate();
   return tEarlyConfig_ClockGenerationLvds2_Manually;
};
tS32 dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::s32GetData(tS32& tEarlyConfig_ClockGenerationLvds2_ManuallyParam) { 
   vUpdate();
   tEarlyConfig_ClockGenerationLvds2_ManuallyParam = tEarlyConfig_ClockGenerationLvds2_Manually;
   return _s32Status;
}
tS32 dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EarlyConfig_ClockGenerationLvds2_Manually", (tS32)0xdd939a3bL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::operator>>(tS32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::operator<<(tS32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::s32SetData(tS32 &tEarlyConfig_ClockGenerationLvds2_ManuallyParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockGenerationLvds2_Manually,(tVoid*)&tEarlyConfig_ClockGenerationLvds2_ManuallyParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyConfig_ClockGenerationLvds2_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::vSetData(tS32)' could be made const reference
tS32 dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::s32SetData(const tS32 &tEarlyConfig_ClockGenerationLvds2_ManuallyParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockGenerationLvds2_Manually,(tVoid*)&tEarlyConfig_ClockGenerationLvds2_ManuallyParam, sizeof(tS32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyConfig_ClockGenerationLvds2_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::vSetData(tS32)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::u8GetData(tS32& tEarlyConfig_ClockGenerationLvds2_ManuallyParam) {  
   vUpdate();
   tEarlyConfig_ClockGenerationLvds2_ManuallyParam = tEarlyConfig_ClockGenerationLvds2_Manually;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::vSetData(tS32 &tEarlyConfig_ClockGenerationLvds2_ManuallyParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockGenerationLvds2_Manually,(tVoid*)&tEarlyConfig_ClockGenerationLvds2_ManuallyParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tEarlyConfig_ClockGenerationLvds2_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::vSetData(tS32)' could be made const reference
tVoid dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::vSetData(const tS32 &tEarlyConfig_ClockGenerationLvds2_ManuallyParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_ClockGenerationLvds2_Manually,(tVoid*)&tEarlyConfig_ClockGenerationLvds2_ManuallyParam, sizeof(tS32));
   vStore();
}//lint !e1746: parameter 'tEarlyConfig_ClockGenerationLvds2_ManuallyParam' in function 'dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::vSetData(tS32)' could be made const reference
tU8   dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_ClockGenerationLvds2_Manually", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_ClockGenerationLvds2_Manually", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPEarlyConfig_ClockGenerationLvds2_Manually::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_ClockGenerationLvds2_Manually", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element EarlyConfig_ClockGenerationLvds2_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_Display_Type"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_Display_Type::dp_tclDimmingDPEarlyConfig_Display_Type(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEarlyConfig_Display_Type,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPEarlyConfig_Display_Type::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_Display_Type",(tS32) 0xd19ffbf9);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tEarlyConfig_Display_Type = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPEarlyConfig_Display_Type::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EarlyConfig_Display_Type", (tS32)0xd19ffbf9);
   (tVoid)myDpElem.bFillData((tVoid*)&tEarlyConfig_Display_Type, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPEarlyConfig_Display_Type::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPEarlyConfig_Display_Type::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPEarlyConfig_Display_Type::tGetData() {
   vUpdate();
   return tEarlyConfig_Display_Type;
};
tS32 dp_tclDimmingDPEarlyConfig_Display_Type::s32GetData(tU8& tEarlyConfig_Display_TypeParam) { 
   vUpdate();
   tEarlyConfig_Display_TypeParam = tEarlyConfig_Display_Type;
   return _s32Status;
}
tS32 dp_tclDimmingDPEarlyConfig_Display_Type::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EarlyConfig_Display_Type", (tS32)0xd19ffbf9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPEarlyConfig_Display_Type::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPEarlyConfig_Display_Type::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPEarlyConfig_Display_Type::s32SetData(tU8 &tEarlyConfig_Display_TypeParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_Display_Type,(tVoid*)&tEarlyConfig_Display_TypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyConfig_Display_TypeParam' in function 'dp_tclDimmingDPEarlyConfig_Display_Type::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPEarlyConfig_Display_Type::s32SetData(const tU8 &tEarlyConfig_Display_TypeParam) {
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_Display_Type,(tVoid*)&tEarlyConfig_Display_TypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEarlyConfig_Display_TypeParam' in function 'dp_tclDimmingDPEarlyConfig_Display_Type::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPEarlyConfig_Display_Type::u8GetData(tU8& tEarlyConfig_Display_TypeParam) {  
   vUpdate();
   tEarlyConfig_Display_TypeParam = tEarlyConfig_Display_Type;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPEarlyConfig_Display_Type::vSetData(tU8 &tEarlyConfig_Display_TypeParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_Display_Type,(tVoid*)&tEarlyConfig_Display_TypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tEarlyConfig_Display_TypeParam' in function 'dp_tclDimmingDPEarlyConfig_Display_Type::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPEarlyConfig_Display_Type::vSetData(const tU8 &tEarlyConfig_Display_TypeParam) { 
   //init parameter
   (tVoid)memcpy(&tEarlyConfig_Display_Type,(tVoid*)&tEarlyConfig_Display_TypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tEarlyConfig_Display_TypeParam' in function 'dp_tclDimmingDPEarlyConfig_Display_Type::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPEarlyConfig_Display_Type::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPEarlyConfig_Display_Type::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_Display_Type", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPEarlyConfig_Display_Type::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_Display_Type", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPEarlyConfig_Display_Type::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_Display_Type", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element EarlyConfig_Display_Type has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_DisplayOrder_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_DisplayOrder_Manually::dp_tclDimmingDPEarlyConfig_DisplayOrder_Manually(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDimmingDPEarlyConfig_DisplayOrder_Manually::s32SetData( tU8* tEarlyConfig_DisplayOrder_ManuallyParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("EarlyConfig_DisplayOrder_Manually", (tS32)0x452f2212L);
   (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_DisplayOrder_ManuallyParam, ((tU32)sizeof(tU8))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_DisplayOrder_Manually::s32GetData(tU8* tEarlyConfig_DisplayOrder_ManuallyParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_DisplayOrder_Manually", (tS32)0x452f2212L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU8)) == 0)  //lint !e587: Predicate '==' can be pre-determined and always evaluates to True
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU8));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tEarlyConfig_DisplayOrder_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU8));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDimmingDPEarlyConfig_DisplayOrder_Manually::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDPEarlyConfig_DisplayOrder_Manually::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDimmingDPEarlyConfig_DisplayOrder_Manually::u16GetData(tU8* tEarlyConfig_DisplayOrder_ManuallyParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tEarlyConfig_DisplayOrder_ManuallyParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDPEarlyConfig_DisplayOrder_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_DisplayOrder_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_DisplayOrder_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_DisplayOrder_Manually", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDimmingDPEarlyConfig_DisplayOrder_Manually::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_DisplayOrder_Manually", DP_U32_POOL_ID_DIMMINGDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
		}
		else
		{
			fprintf(stdout,"Element EarlyConfig_DisplayOrder_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EarlyConfig_FlushDesignConfigFile_Manually"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually::dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually::s32SetData(tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_FlushDesignConfigFile_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_FlushDesignConfigFile_Manually", (tS32)0x4db12d22L);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_FlushDesignConfigFile_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually::s32SetData(const tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam) {
   tU32 u32Len = (tU32)strlen(tEarlyConfig_FlushDesignConfigFile_ManuallyParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("EarlyConfig_FlushDesignConfigFile_Manually", (tS32)0x4db12d22L);
      (tVoid)myDpElem.bFillData((tVoid*)tEarlyConfig_FlushDesignConfigFile_ManuallyParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually::s32GetData(tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_FlushDesignConfigFile_Manually", (tS32)0x4db12d22L);
   (tVoid)memset(tEarlyConfig_FlushDesignConfigFile_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_FlushDesignConfigFile_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually::s32GetData(const tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("EarlyConfig_FlushDesignConfigFile_Manually", (tS32)0x4db12d22L);
   (tVoid)memset(tEarlyConfig_FlushDesignConfigFile_ManuallyParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tEarlyConfig_FlushDesignConfigFile_ManuallyParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually::u32GetData(tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_FlushDesignConfigFile_ManuallyParam, u32StringBufLen);
   };
    tU32  dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually::u32GetData(const tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tEarlyConfig_FlushDesignConfigFile_ManuallyParam, u32StringBufLen);
   };
   tVoid dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually::vSetData(tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_FlushDesignConfigFile_ManuallyParam);};
   tVoid dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually::vSetData(const tString &tEarlyConfig_FlushDesignConfigFile_ManuallyParam){(tVoid)s32SetData(tEarlyConfig_FlushDesignConfigFile_ManuallyParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_FlushDesignConfigFile_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "EarlyConfig_FlushDesignConfigFile_Manually", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPEarlyConfig_FlushDesignConfigFile_Manually::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EarlyConfig_FlushDesignConfigFile_Manually", DP_U32_POOL_ID_DIMMINGDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
		}
		else
		{
			fprintf(stdout,"Element EarlyConfig_FlushDesignConfigFile_Manually has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_BrightnessLevelExtended_Day"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::dp_tclDimmingDPDISP_BrightnessLevelExtended_Day(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISP_BrightnessLevelExtended_Day,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISP_BrightnessLevelExtended_Day",(tS32) 0x2dfb3782L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDISP_BrightnessLevelExtended_Day = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISP_BrightnessLevelExtended_Day", (tS32)0x2dfb3782L);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISP_BrightnessLevelExtended_Day, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::tGetData() {
   vUpdate();
   return tDISP_BrightnessLevelExtended_Day;
};
tS32 dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::s32GetData(tU8& tDISP_BrightnessLevelExtended_DayParam) { 
   vUpdate();
   tDISP_BrightnessLevelExtended_DayParam = tDISP_BrightnessLevelExtended_Day;
   return _s32Status;
}
tS32 dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISP_BrightnessLevelExtended_Day", (tS32)0x2dfb3782L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::s32SetData(tU8 &tDISP_BrightnessLevelExtended_DayParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_BrightnessLevelExtended_Day,(tVoid*)&tDISP_BrightnessLevelExtended_DayParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_BrightnessLevelExtended_DayParam' in function 'dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::s32SetData(const tU8 &tDISP_BrightnessLevelExtended_DayParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_BrightnessLevelExtended_Day,(tVoid*)&tDISP_BrightnessLevelExtended_DayParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_BrightnessLevelExtended_DayParam' in function 'dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::u8GetData(tU8& tDISP_BrightnessLevelExtended_DayParam) {  
   vUpdate();
   tDISP_BrightnessLevelExtended_DayParam = tDISP_BrightnessLevelExtended_Day;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::vSetData(tU8 &tDISP_BrightnessLevelExtended_DayParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_BrightnessLevelExtended_Day,(tVoid*)&tDISP_BrightnessLevelExtended_DayParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISP_BrightnessLevelExtended_DayParam' in function 'dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::vSetData(const tU8 &tDISP_BrightnessLevelExtended_DayParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_BrightnessLevelExtended_Day,(tVoid*)&tDISP_BrightnessLevelExtended_DayParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISP_BrightnessLevelExtended_DayParam' in function 'dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_BrightnessLevelExtended_Day", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_BrightnessLevelExtended_Day", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_BrightnessLevelExtended_Day::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_BrightnessLevelExtended_Day", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element DISP_BrightnessLevelExtended_Day has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_BrightnessLevelExtended_Night"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::dp_tclDimmingDPDISP_BrightnessLevelExtended_Night(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISP_BrightnessLevelExtended_Night,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISP_BrightnessLevelExtended_Night",(tS32) 0x7d8888beL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDISP_BrightnessLevelExtended_Night = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISP_BrightnessLevelExtended_Night", (tS32)0x7d8888beL);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISP_BrightnessLevelExtended_Night, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::tGetData() {
   vUpdate();
   return tDISP_BrightnessLevelExtended_Night;
};
tS32 dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::s32GetData(tU8& tDISP_BrightnessLevelExtended_NightParam) { 
   vUpdate();
   tDISP_BrightnessLevelExtended_NightParam = tDISP_BrightnessLevelExtended_Night;
   return _s32Status;
}
tS32 dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISP_BrightnessLevelExtended_Night", (tS32)0x7d8888beL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::s32SetData(tU8 &tDISP_BrightnessLevelExtended_NightParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_BrightnessLevelExtended_Night,(tVoid*)&tDISP_BrightnessLevelExtended_NightParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_BrightnessLevelExtended_NightParam' in function 'dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::s32SetData(const tU8 &tDISP_BrightnessLevelExtended_NightParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_BrightnessLevelExtended_Night,(tVoid*)&tDISP_BrightnessLevelExtended_NightParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_BrightnessLevelExtended_NightParam' in function 'dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::u8GetData(tU8& tDISP_BrightnessLevelExtended_NightParam) {  
   vUpdate();
   tDISP_BrightnessLevelExtended_NightParam = tDISP_BrightnessLevelExtended_Night;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::vSetData(tU8 &tDISP_BrightnessLevelExtended_NightParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_BrightnessLevelExtended_Night,(tVoid*)&tDISP_BrightnessLevelExtended_NightParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISP_BrightnessLevelExtended_NightParam' in function 'dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::vSetData(const tU8 &tDISP_BrightnessLevelExtended_NightParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_BrightnessLevelExtended_Night,(tVoid*)&tDISP_BrightnessLevelExtended_NightParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISP_BrightnessLevelExtended_NightParam' in function 'dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_BrightnessLevelExtended_Night", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_BrightnessLevelExtended_Night", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_BrightnessLevelExtended_Night::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_BrightnessLevelExtended_Night", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element DISP_BrightnessLevelExtended_Night has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "INFO_DimmingModeConfig"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPINFO_DimmingModeConfig::dp_tclDimmingDPINFO_DimmingModeConfig(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tINFO_DimmingModeConfig,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPINFO_DimmingModeConfig::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("INFO_DimmingModeConfig",(tS32) 0x395a44b7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tINFO_DimmingModeConfig = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPINFO_DimmingModeConfig::vStore(tVoid) {
   dp_tclBaseElement myDpElem("INFO_DimmingModeConfig", (tS32)0x395a44b7);
   (tVoid)myDpElem.bFillData((tVoid*)&tINFO_DimmingModeConfig, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPINFO_DimmingModeConfig::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPINFO_DimmingModeConfig::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPINFO_DimmingModeConfig::tGetData() {
   vUpdate();
   return tINFO_DimmingModeConfig;
};
tS32 dp_tclDimmingDPINFO_DimmingModeConfig::s32GetData(tU8& tINFO_DimmingModeConfigParam) { 
   vUpdate();
   tINFO_DimmingModeConfigParam = tINFO_DimmingModeConfig;
   return _s32Status;
}
tS32 dp_tclDimmingDPINFO_DimmingModeConfig::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("INFO_DimmingModeConfig", (tS32)0x395a44b7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPINFO_DimmingModeConfig::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPINFO_DimmingModeConfig::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPINFO_DimmingModeConfig::s32SetData(tU8 &tINFO_DimmingModeConfigParam) {
   //init parameter
   (tVoid)memcpy(&tINFO_DimmingModeConfig,(tVoid*)&tINFO_DimmingModeConfigParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tINFO_DimmingModeConfigParam' in function 'dp_tclDimmingDPINFO_DimmingModeConfig::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPINFO_DimmingModeConfig::s32SetData(const tU8 &tINFO_DimmingModeConfigParam) {
   //init parameter
   (tVoid)memcpy(&tINFO_DimmingModeConfig,(tVoid*)&tINFO_DimmingModeConfigParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tINFO_DimmingModeConfigParam' in function 'dp_tclDimmingDPINFO_DimmingModeConfig::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPINFO_DimmingModeConfig::u8GetData(tU8& tINFO_DimmingModeConfigParam) {  
   vUpdate();
   tINFO_DimmingModeConfigParam = tINFO_DimmingModeConfig;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPINFO_DimmingModeConfig::vSetData(tU8 &tINFO_DimmingModeConfigParam) { 
   //init parameter
   (tVoid)memcpy(&tINFO_DimmingModeConfig,(tVoid*)&tINFO_DimmingModeConfigParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tINFO_DimmingModeConfigParam' in function 'dp_tclDimmingDPINFO_DimmingModeConfig::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPINFO_DimmingModeConfig::vSetData(const tU8 &tINFO_DimmingModeConfigParam) { 
   //init parameter
   (tVoid)memcpy(&tINFO_DimmingModeConfig,(tVoid*)&tINFO_DimmingModeConfigParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tINFO_DimmingModeConfigParam' in function 'dp_tclDimmingDPINFO_DimmingModeConfig::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPINFO_DimmingModeConfig::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPINFO_DimmingModeConfig::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "INFO_DimmingModeConfig", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPINFO_DimmingModeConfig::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "INFO_DimmingModeConfig", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPINFO_DimmingModeConfig::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: INFO_DimmingModeConfig", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element INFO_DimmingModeConfig has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_CSCContrastLevel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_CSCContrastLevel::dp_tclDimmingDPDISP_CSCContrastLevel(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISP_CSCContrastLevel,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPDISP_CSCContrastLevel::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISP_CSCContrastLevel",(tS32) 0x9ed55f42);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDISP_CSCContrastLevel = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPDISP_CSCContrastLevel::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISP_CSCContrastLevel", (tS32)0x9ed55f42);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISP_CSCContrastLevel, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPDISP_CSCContrastLevel::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPDISP_CSCContrastLevel::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPDISP_CSCContrastLevel::tGetData() {
   vUpdate();
   return tDISP_CSCContrastLevel;
};
tS32 dp_tclDimmingDPDISP_CSCContrastLevel::s32GetData(tU8& tDISP_CSCContrastLevelParam) { 
   vUpdate();
   tDISP_CSCContrastLevelParam = tDISP_CSCContrastLevel;
   return _s32Status;
}
tS32 dp_tclDimmingDPDISP_CSCContrastLevel::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISP_CSCContrastLevel", (tS32)0x9ed55f42);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPDISP_CSCContrastLevel::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPDISP_CSCContrastLevel::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPDISP_CSCContrastLevel::s32SetData(tU8 &tDISP_CSCContrastLevelParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCContrastLevel,(tVoid*)&tDISP_CSCContrastLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCContrastLevelParam' in function 'dp_tclDimmingDPDISP_CSCContrastLevel::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPDISP_CSCContrastLevel::s32SetData(const tU8 &tDISP_CSCContrastLevelParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCContrastLevel,(tVoid*)&tDISP_CSCContrastLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCContrastLevelParam' in function 'dp_tclDimmingDPDISP_CSCContrastLevel::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPDISP_CSCContrastLevel::u8GetData(tU8& tDISP_CSCContrastLevelParam) {  
   vUpdate();
   tDISP_CSCContrastLevelParam = tDISP_CSCContrastLevel;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPDISP_CSCContrastLevel::vSetData(tU8 &tDISP_CSCContrastLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCContrastLevel,(tVoid*)&tDISP_CSCContrastLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCContrastLevelParam' in function 'dp_tclDimmingDPDISP_CSCContrastLevel::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPDISP_CSCContrastLevel::vSetData(const tU8 &tDISP_CSCContrastLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCContrastLevel,(tVoid*)&tDISP_CSCContrastLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCContrastLevelParam' in function 'dp_tclDimmingDPDISP_CSCContrastLevel::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPDISP_CSCContrastLevel::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPDISP_CSCContrastLevel::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCContrastLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCContrastLevel::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCContrastLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCContrastLevel::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_CSCContrastLevel", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element DISP_CSCContrastLevel has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_CSCContrast"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_CSCContrast::dp_tclDimmingDPDISP_CSCContrast(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISP_CSCContrast,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPDISP_CSCContrast::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISP_CSCContrast",(tS32) 0x52df37d2);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDISP_CSCContrast = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPDISP_CSCContrast::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISP_CSCContrast", (tS32)0x52df37d2);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISP_CSCContrast, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPDISP_CSCContrast::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPDISP_CSCContrast::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclDimmingDPDISP_CSCContrast::tGetData() {
   vUpdate();
   return tDISP_CSCContrast;
};
tS32 dp_tclDimmingDPDISP_CSCContrast::s32GetData(tS16& tDISP_CSCContrastParam) { 
   vUpdate();
   tDISP_CSCContrastParam = tDISP_CSCContrast;
   return _s32Status;
}
tS32 dp_tclDimmingDPDISP_CSCContrast::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISP_CSCContrast", (tS32)0x52df37d2);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPDISP_CSCContrast::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPDISP_CSCContrast::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPDISP_CSCContrast::s32SetData(tS16 &tDISP_CSCContrastParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCContrast,(tVoid*)&tDISP_CSCContrastParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCContrastParam' in function 'dp_tclDimmingDPDISP_CSCContrast::vSetData(tS16)' could be made const reference
tS32 dp_tclDimmingDPDISP_CSCContrast::s32SetData(const tS16 &tDISP_CSCContrastParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCContrast,(tVoid*)&tDISP_CSCContrastParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCContrastParam' in function 'dp_tclDimmingDPDISP_CSCContrast::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPDISP_CSCContrast::u8GetData(tS16& tDISP_CSCContrastParam) {  
   vUpdate();
   tDISP_CSCContrastParam = tDISP_CSCContrast;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPDISP_CSCContrast::vSetData(tS16 &tDISP_CSCContrastParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCContrast,(tVoid*)&tDISP_CSCContrastParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCContrastParam' in function 'dp_tclDimmingDPDISP_CSCContrast::vSetData(tS16)' could be made const reference
tVoid dp_tclDimmingDPDISP_CSCContrast::vSetData(const tS16 &tDISP_CSCContrastParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCContrast,(tVoid*)&tDISP_CSCContrastParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCContrastParam' in function 'dp_tclDimmingDPDISP_CSCContrast::vSetData(tS16)' could be made const reference
tU8   dp_tclDimmingDPDISP_CSCContrast::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPDISP_CSCContrast::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCContrast", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCContrast::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCContrast", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCContrast::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_CSCContrast", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element DISP_CSCContrast has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_CSCSaturationLevel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_CSCSaturationLevel::dp_tclDimmingDPDISP_CSCSaturationLevel(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISP_CSCSaturationLevel,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPDISP_CSCSaturationLevel::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISP_CSCSaturationLevel",(tS32) 0x9f32227e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDISP_CSCSaturationLevel = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPDISP_CSCSaturationLevel::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISP_CSCSaturationLevel", (tS32)0x9f32227e);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISP_CSCSaturationLevel, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPDISP_CSCSaturationLevel::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPDISP_CSCSaturationLevel::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPDISP_CSCSaturationLevel::tGetData() {
   vUpdate();
   return tDISP_CSCSaturationLevel;
};
tS32 dp_tclDimmingDPDISP_CSCSaturationLevel::s32GetData(tU8& tDISP_CSCSaturationLevelParam) { 
   vUpdate();
   tDISP_CSCSaturationLevelParam = tDISP_CSCSaturationLevel;
   return _s32Status;
}
tS32 dp_tclDimmingDPDISP_CSCSaturationLevel::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISP_CSCSaturationLevel", (tS32)0x9f32227e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPDISP_CSCSaturationLevel::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPDISP_CSCSaturationLevel::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPDISP_CSCSaturationLevel::s32SetData(tU8 &tDISP_CSCSaturationLevelParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCSaturationLevel,(tVoid*)&tDISP_CSCSaturationLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCSaturationLevelParam' in function 'dp_tclDimmingDPDISP_CSCSaturationLevel::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPDISP_CSCSaturationLevel::s32SetData(const tU8 &tDISP_CSCSaturationLevelParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCSaturationLevel,(tVoid*)&tDISP_CSCSaturationLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCSaturationLevelParam' in function 'dp_tclDimmingDPDISP_CSCSaturationLevel::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPDISP_CSCSaturationLevel::u8GetData(tU8& tDISP_CSCSaturationLevelParam) {  
   vUpdate();
   tDISP_CSCSaturationLevelParam = tDISP_CSCSaturationLevel;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPDISP_CSCSaturationLevel::vSetData(tU8 &tDISP_CSCSaturationLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCSaturationLevel,(tVoid*)&tDISP_CSCSaturationLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCSaturationLevelParam' in function 'dp_tclDimmingDPDISP_CSCSaturationLevel::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPDISP_CSCSaturationLevel::vSetData(const tU8 &tDISP_CSCSaturationLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCSaturationLevel,(tVoid*)&tDISP_CSCSaturationLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCSaturationLevelParam' in function 'dp_tclDimmingDPDISP_CSCSaturationLevel::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPDISP_CSCSaturationLevel::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPDISP_CSCSaturationLevel::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCSaturationLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCSaturationLevel::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCSaturationLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCSaturationLevel::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_CSCSaturationLevel", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element DISP_CSCSaturationLevel has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_CSCSaturation"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_CSCSaturation::dp_tclDimmingDPDISP_CSCSaturation(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISP_CSCSaturation,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPDISP_CSCSaturation::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISP_CSCSaturation",(tS32) 0x195d3d9e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDISP_CSCSaturation = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPDISP_CSCSaturation::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISP_CSCSaturation", (tS32)0x195d3d9e);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISP_CSCSaturation, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPDISP_CSCSaturation::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPDISP_CSCSaturation::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclDimmingDPDISP_CSCSaturation::tGetData() {
   vUpdate();
   return tDISP_CSCSaturation;
};
tS32 dp_tclDimmingDPDISP_CSCSaturation::s32GetData(tS16& tDISP_CSCSaturationParam) { 
   vUpdate();
   tDISP_CSCSaturationParam = tDISP_CSCSaturation;
   return _s32Status;
}
tS32 dp_tclDimmingDPDISP_CSCSaturation::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISP_CSCSaturation", (tS32)0x195d3d9e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPDISP_CSCSaturation::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPDISP_CSCSaturation::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPDISP_CSCSaturation::s32SetData(tS16 &tDISP_CSCSaturationParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCSaturation,(tVoid*)&tDISP_CSCSaturationParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCSaturationParam' in function 'dp_tclDimmingDPDISP_CSCSaturation::vSetData(tS16)' could be made const reference
tS32 dp_tclDimmingDPDISP_CSCSaturation::s32SetData(const tS16 &tDISP_CSCSaturationParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCSaturation,(tVoid*)&tDISP_CSCSaturationParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCSaturationParam' in function 'dp_tclDimmingDPDISP_CSCSaturation::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPDISP_CSCSaturation::u8GetData(tS16& tDISP_CSCSaturationParam) {  
   vUpdate();
   tDISP_CSCSaturationParam = tDISP_CSCSaturation;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPDISP_CSCSaturation::vSetData(tS16 &tDISP_CSCSaturationParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCSaturation,(tVoid*)&tDISP_CSCSaturationParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCSaturationParam' in function 'dp_tclDimmingDPDISP_CSCSaturation::vSetData(tS16)' could be made const reference
tVoid dp_tclDimmingDPDISP_CSCSaturation::vSetData(const tS16 &tDISP_CSCSaturationParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCSaturation,(tVoid*)&tDISP_CSCSaturationParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCSaturationParam' in function 'dp_tclDimmingDPDISP_CSCSaturation::vSetData(tS16)' could be made const reference
tU8   dp_tclDimmingDPDISP_CSCSaturation::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPDISP_CSCSaturation::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCSaturation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCSaturation::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCSaturation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCSaturation::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_CSCSaturation", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element DISP_CSCSaturation has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_CSCSaturationOffset"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_CSCSaturationOffset::dp_tclDimmingDPDISP_CSCSaturationOffset(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISP_CSCSaturationOffset,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPDISP_CSCSaturationOffset::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISP_CSCSaturationOffset",(tS32) 0x1bfacd65);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDISP_CSCSaturationOffset = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPDISP_CSCSaturationOffset::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISP_CSCSaturationOffset", (tS32)0x1bfacd65);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISP_CSCSaturationOffset, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPDISP_CSCSaturationOffset::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPDISP_CSCSaturationOffset::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclDimmingDPDISP_CSCSaturationOffset::tGetData() {
   vUpdate();
   return tDISP_CSCSaturationOffset;
};
tS32 dp_tclDimmingDPDISP_CSCSaturationOffset::s32GetData(tS16& tDISP_CSCSaturationOffsetParam) { 
   vUpdate();
   tDISP_CSCSaturationOffsetParam = tDISP_CSCSaturationOffset;
   return _s32Status;
}
tS32 dp_tclDimmingDPDISP_CSCSaturationOffset::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISP_CSCSaturationOffset", (tS32)0x1bfacd65);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPDISP_CSCSaturationOffset::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPDISP_CSCSaturationOffset::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPDISP_CSCSaturationOffset::s32SetData(tS16 &tDISP_CSCSaturationOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCSaturationOffset,(tVoid*)&tDISP_CSCSaturationOffsetParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCSaturationOffsetParam' in function 'dp_tclDimmingDPDISP_CSCSaturationOffset::vSetData(tS16)' could be made const reference
tS32 dp_tclDimmingDPDISP_CSCSaturationOffset::s32SetData(const tS16 &tDISP_CSCSaturationOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCSaturationOffset,(tVoid*)&tDISP_CSCSaturationOffsetParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCSaturationOffsetParam' in function 'dp_tclDimmingDPDISP_CSCSaturationOffset::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPDISP_CSCSaturationOffset::u8GetData(tS16& tDISP_CSCSaturationOffsetParam) {  
   vUpdate();
   tDISP_CSCSaturationOffsetParam = tDISP_CSCSaturationOffset;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPDISP_CSCSaturationOffset::vSetData(tS16 &tDISP_CSCSaturationOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCSaturationOffset,(tVoid*)&tDISP_CSCSaturationOffsetParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCSaturationOffsetParam' in function 'dp_tclDimmingDPDISP_CSCSaturationOffset::vSetData(tS16)' could be made const reference
tVoid dp_tclDimmingDPDISP_CSCSaturationOffset::vSetData(const tS16 &tDISP_CSCSaturationOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCSaturationOffset,(tVoid*)&tDISP_CSCSaturationOffsetParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCSaturationOffsetParam' in function 'dp_tclDimmingDPDISP_CSCSaturationOffset::vSetData(tS16)' could be made const reference
tU8   dp_tclDimmingDPDISP_CSCSaturationOffset::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPDISP_CSCSaturationOffset::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCSaturationOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCSaturationOffset::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCSaturationOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCSaturationOffset::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_CSCSaturationOffset", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element DISP_CSCSaturationOffset has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_CSCColorLevel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_CSCColorLevel::dp_tclDimmingDPDISP_CSCColorLevel(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISP_CSCColorLevel,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPDISP_CSCColorLevel::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISP_CSCColorLevel",(tS32) 0x17c8a877);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDISP_CSCColorLevel = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPDISP_CSCColorLevel::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISP_CSCColorLevel", (tS32)0x17c8a877);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISP_CSCColorLevel, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPDISP_CSCColorLevel::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPDISP_CSCColorLevel::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPDISP_CSCColorLevel::tGetData() {
   vUpdate();
   return tDISP_CSCColorLevel;
};
tS32 dp_tclDimmingDPDISP_CSCColorLevel::s32GetData(tU8& tDISP_CSCColorLevelParam) { 
   vUpdate();
   tDISP_CSCColorLevelParam = tDISP_CSCColorLevel;
   return _s32Status;
}
tS32 dp_tclDimmingDPDISP_CSCColorLevel::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISP_CSCColorLevel", (tS32)0x17c8a877);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPDISP_CSCColorLevel::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPDISP_CSCColorLevel::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPDISP_CSCColorLevel::s32SetData(tU8 &tDISP_CSCColorLevelParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCColorLevel,(tVoid*)&tDISP_CSCColorLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCColorLevelParam' in function 'dp_tclDimmingDPDISP_CSCColorLevel::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPDISP_CSCColorLevel::s32SetData(const tU8 &tDISP_CSCColorLevelParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCColorLevel,(tVoid*)&tDISP_CSCColorLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCColorLevelParam' in function 'dp_tclDimmingDPDISP_CSCColorLevel::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPDISP_CSCColorLevel::u8GetData(tU8& tDISP_CSCColorLevelParam) {  
   vUpdate();
   tDISP_CSCColorLevelParam = tDISP_CSCColorLevel;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPDISP_CSCColorLevel::vSetData(tU8 &tDISP_CSCColorLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCColorLevel,(tVoid*)&tDISP_CSCColorLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCColorLevelParam' in function 'dp_tclDimmingDPDISP_CSCColorLevel::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPDISP_CSCColorLevel::vSetData(const tU8 &tDISP_CSCColorLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCColorLevel,(tVoid*)&tDISP_CSCColorLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCColorLevelParam' in function 'dp_tclDimmingDPDISP_CSCColorLevel::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPDISP_CSCColorLevel::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPDISP_CSCColorLevel::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCColorLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCColorLevel::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCColorLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCColorLevel::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_CSCColorLevel", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element DISP_CSCColorLevel has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_CSCColor"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_CSCColor::dp_tclDimmingDPDISP_CSCColor(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISP_CSCColor,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPDISP_CSCColor::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISP_CSCColor",(tS32) 0xee3b20d3);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDISP_CSCColor = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPDISP_CSCColor::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISP_CSCColor", (tS32)0xee3b20d3);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISP_CSCColor, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPDISP_CSCColor::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPDISP_CSCColor::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclDimmingDPDISP_CSCColor::tGetData() {
   vUpdate();
   return tDISP_CSCColor;
};
tS32 dp_tclDimmingDPDISP_CSCColor::s32GetData(tS16& tDISP_CSCColorParam) { 
   vUpdate();
   tDISP_CSCColorParam = tDISP_CSCColor;
   return _s32Status;
}
tS32 dp_tclDimmingDPDISP_CSCColor::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISP_CSCColor", (tS32)0xee3b20d3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPDISP_CSCColor::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPDISP_CSCColor::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPDISP_CSCColor::s32SetData(tS16 &tDISP_CSCColorParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCColor,(tVoid*)&tDISP_CSCColorParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCColorParam' in function 'dp_tclDimmingDPDISP_CSCColor::vSetData(tS16)' could be made const reference
tS32 dp_tclDimmingDPDISP_CSCColor::s32SetData(const tS16 &tDISP_CSCColorParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCColor,(tVoid*)&tDISP_CSCColorParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCColorParam' in function 'dp_tclDimmingDPDISP_CSCColor::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPDISP_CSCColor::u8GetData(tS16& tDISP_CSCColorParam) {  
   vUpdate();
   tDISP_CSCColorParam = tDISP_CSCColor;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPDISP_CSCColor::vSetData(tS16 &tDISP_CSCColorParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCColor,(tVoid*)&tDISP_CSCColorParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCColorParam' in function 'dp_tclDimmingDPDISP_CSCColor::vSetData(tS16)' could be made const reference
tVoid dp_tclDimmingDPDISP_CSCColor::vSetData(const tS16 &tDISP_CSCColorParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCColor,(tVoid*)&tDISP_CSCColorParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCColorParam' in function 'dp_tclDimmingDPDISP_CSCColor::vSetData(tS16)' could be made const reference
tU8   dp_tclDimmingDPDISP_CSCColor::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPDISP_CSCColor::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCColor", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCColor::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCColor", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCColor::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_CSCColor", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element DISP_CSCColor has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_CSCColorOffset"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_CSCColorOffset::dp_tclDimmingDPDISP_CSCColorOffset(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISP_CSCColorOffset,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPDISP_CSCColorOffset::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISP_CSCColorOffset",(tS32) 0x76eb6b42);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDISP_CSCColorOffset = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPDISP_CSCColorOffset::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISP_CSCColorOffset", (tS32)0x76eb6b42);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISP_CSCColorOffset, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPDISP_CSCColorOffset::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPDISP_CSCColorOffset::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclDimmingDPDISP_CSCColorOffset::tGetData() {
   vUpdate();
   return tDISP_CSCColorOffset;
};
tS32 dp_tclDimmingDPDISP_CSCColorOffset::s32GetData(tS16& tDISP_CSCColorOffsetParam) { 
   vUpdate();
   tDISP_CSCColorOffsetParam = tDISP_CSCColorOffset;
   return _s32Status;
}
tS32 dp_tclDimmingDPDISP_CSCColorOffset::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISP_CSCColorOffset", (tS32)0x76eb6b42);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPDISP_CSCColorOffset::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPDISP_CSCColorOffset::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPDISP_CSCColorOffset::s32SetData(tS16 &tDISP_CSCColorOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCColorOffset,(tVoid*)&tDISP_CSCColorOffsetParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCColorOffsetParam' in function 'dp_tclDimmingDPDISP_CSCColorOffset::vSetData(tS16)' could be made const reference
tS32 dp_tclDimmingDPDISP_CSCColorOffset::s32SetData(const tS16 &tDISP_CSCColorOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCColorOffset,(tVoid*)&tDISP_CSCColorOffsetParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCColorOffsetParam' in function 'dp_tclDimmingDPDISP_CSCColorOffset::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPDISP_CSCColorOffset::u8GetData(tS16& tDISP_CSCColorOffsetParam) {  
   vUpdate();
   tDISP_CSCColorOffsetParam = tDISP_CSCColorOffset;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPDISP_CSCColorOffset::vSetData(tS16 &tDISP_CSCColorOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCColorOffset,(tVoid*)&tDISP_CSCColorOffsetParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCColorOffsetParam' in function 'dp_tclDimmingDPDISP_CSCColorOffset::vSetData(tS16)' could be made const reference
tVoid dp_tclDimmingDPDISP_CSCColorOffset::vSetData(const tS16 &tDISP_CSCColorOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCColorOffset,(tVoid*)&tDISP_CSCColorOffsetParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCColorOffsetParam' in function 'dp_tclDimmingDPDISP_CSCColorOffset::vSetData(tS16)' could be made const reference
tU8   dp_tclDimmingDPDISP_CSCColorOffset::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPDISP_CSCColorOffset::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCColorOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCColorOffset::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCColorOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCColorOffset::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_CSCColorOffset", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element DISP_CSCColorOffset has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_CSCBrigthness"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_CSCBrigthness::dp_tclDimmingDPDISP_CSCBrigthness(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISP_CSCBrigthness,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPDISP_CSCBrigthness::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISP_CSCBrigthness",(tS32) 0x17b7a0b5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDISP_CSCBrigthness = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPDISP_CSCBrigthness::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISP_CSCBrigthness", (tS32)0x17b7a0b5);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISP_CSCBrigthness, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPDISP_CSCBrigthness::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPDISP_CSCBrigthness::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclDimmingDPDISP_CSCBrigthness::tGetData() {
   vUpdate();
   return tDISP_CSCBrigthness;
};
tS32 dp_tclDimmingDPDISP_CSCBrigthness::s32GetData(tS16& tDISP_CSCBrigthnessParam) { 
   vUpdate();
   tDISP_CSCBrigthnessParam = tDISP_CSCBrigthness;
   return _s32Status;
}
tS32 dp_tclDimmingDPDISP_CSCBrigthness::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISP_CSCBrigthness", (tS32)0x17b7a0b5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPDISP_CSCBrigthness::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPDISP_CSCBrigthness::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPDISP_CSCBrigthness::s32SetData(tS16 &tDISP_CSCBrigthnessParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCBrigthness,(tVoid*)&tDISP_CSCBrigthnessParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCBrigthnessParam' in function 'dp_tclDimmingDPDISP_CSCBrigthness::vSetData(tS16)' could be made const reference
tS32 dp_tclDimmingDPDISP_CSCBrigthness::s32SetData(const tS16 &tDISP_CSCBrigthnessParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCBrigthness,(tVoid*)&tDISP_CSCBrigthnessParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCBrigthnessParam' in function 'dp_tclDimmingDPDISP_CSCBrigthness::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPDISP_CSCBrigthness::u8GetData(tS16& tDISP_CSCBrigthnessParam) {  
   vUpdate();
   tDISP_CSCBrigthnessParam = tDISP_CSCBrigthness;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPDISP_CSCBrigthness::vSetData(tS16 &tDISP_CSCBrigthnessParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCBrigthness,(tVoid*)&tDISP_CSCBrigthnessParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCBrigthnessParam' in function 'dp_tclDimmingDPDISP_CSCBrigthness::vSetData(tS16)' could be made const reference
tVoid dp_tclDimmingDPDISP_CSCBrigthness::vSetData(const tS16 &tDISP_CSCBrigthnessParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCBrigthness,(tVoid*)&tDISP_CSCBrigthnessParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCBrigthnessParam' in function 'dp_tclDimmingDPDISP_CSCBrigthness::vSetData(tS16)' could be made const reference
tU8   dp_tclDimmingDPDISP_CSCBrigthness::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPDISP_CSCBrigthness::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCBrigthness", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCBrigthness::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCBrigthness", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCBrigthness::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_CSCBrigthness", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element DISP_CSCBrigthness has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_CSCBrigthnessOffset"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_CSCBrigthnessOffset::dp_tclDimmingDPDISP_CSCBrigthnessOffset(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISP_CSCBrigthnessOffset,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPDISP_CSCBrigthnessOffset::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISP_CSCBrigthnessOffset",(tS32) 0x96c4c434);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tDISP_CSCBrigthnessOffset = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPDISP_CSCBrigthnessOffset::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISP_CSCBrigthnessOffset", (tS32)0x96c4c434);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISP_CSCBrigthnessOffset, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPDISP_CSCBrigthnessOffset::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPDISP_CSCBrigthnessOffset::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclDimmingDPDISP_CSCBrigthnessOffset::tGetData() {
   vUpdate();
   return tDISP_CSCBrigthnessOffset;
};
tS32 dp_tclDimmingDPDISP_CSCBrigthnessOffset::s32GetData(tS16& tDISP_CSCBrigthnessOffsetParam) { 
   vUpdate();
   tDISP_CSCBrigthnessOffsetParam = tDISP_CSCBrigthnessOffset;
   return _s32Status;
}
tS32 dp_tclDimmingDPDISP_CSCBrigthnessOffset::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISP_CSCBrigthnessOffset", (tS32)0x96c4c434);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPDISP_CSCBrigthnessOffset::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPDISP_CSCBrigthnessOffset::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPDISP_CSCBrigthnessOffset::s32SetData(tS16 &tDISP_CSCBrigthnessOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCBrigthnessOffset,(tVoid*)&tDISP_CSCBrigthnessOffsetParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCBrigthnessOffsetParam' in function 'dp_tclDimmingDPDISP_CSCBrigthnessOffset::vSetData(tS16)' could be made const reference
tS32 dp_tclDimmingDPDISP_CSCBrigthnessOffset::s32SetData(const tS16 &tDISP_CSCBrigthnessOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCBrigthnessOffset,(tVoid*)&tDISP_CSCBrigthnessOffsetParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCBrigthnessOffsetParam' in function 'dp_tclDimmingDPDISP_CSCBrigthnessOffset::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPDISP_CSCBrigthnessOffset::u8GetData(tS16& tDISP_CSCBrigthnessOffsetParam) {  
   vUpdate();
   tDISP_CSCBrigthnessOffsetParam = tDISP_CSCBrigthnessOffset;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPDISP_CSCBrigthnessOffset::vSetData(tS16 &tDISP_CSCBrigthnessOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCBrigthnessOffset,(tVoid*)&tDISP_CSCBrigthnessOffsetParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCBrigthnessOffsetParam' in function 'dp_tclDimmingDPDISP_CSCBrigthnessOffset::vSetData(tS16)' could be made const reference
tVoid dp_tclDimmingDPDISP_CSCBrigthnessOffset::vSetData(const tS16 &tDISP_CSCBrigthnessOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCBrigthnessOffset,(tVoid*)&tDISP_CSCBrigthnessOffsetParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCBrigthnessOffsetParam' in function 'dp_tclDimmingDPDISP_CSCBrigthnessOffset::vSetData(tS16)' could be made const reference
tU8   dp_tclDimmingDPDISP_CSCBrigthnessOffset::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPDISP_CSCBrigthnessOffset::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCBrigthnessOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCBrigthnessOffset::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCBrigthnessOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCBrigthnessOffset::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_CSCBrigthnessOffset", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element DISP_CSCBrigthnessOffset has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_CSCBlackLevel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_CSCBlackLevel::dp_tclDimmingDPDISP_CSCBlackLevel(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISP_CSCBlackLevel,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPDISP_CSCBlackLevel::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISP_CSCBlackLevel",(tS32) 0x1788aaa1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDISP_CSCBlackLevel = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPDISP_CSCBlackLevel::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISP_CSCBlackLevel", (tS32)0x1788aaa1);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISP_CSCBlackLevel, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPDISP_CSCBlackLevel::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPDISP_CSCBlackLevel::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPDISP_CSCBlackLevel::tGetData() {
   vUpdate();
   return tDISP_CSCBlackLevel;
};
tS32 dp_tclDimmingDPDISP_CSCBlackLevel::s32GetData(tU8& tDISP_CSCBlackLevelParam) { 
   vUpdate();
   tDISP_CSCBlackLevelParam = tDISP_CSCBlackLevel;
   return _s32Status;
}
tS32 dp_tclDimmingDPDISP_CSCBlackLevel::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISP_CSCBlackLevel", (tS32)0x1788aaa1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPDISP_CSCBlackLevel::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPDISP_CSCBlackLevel::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPDISP_CSCBlackLevel::s32SetData(tU8 &tDISP_CSCBlackLevelParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCBlackLevel,(tVoid*)&tDISP_CSCBlackLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCBlackLevelParam' in function 'dp_tclDimmingDPDISP_CSCBlackLevel::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPDISP_CSCBlackLevel::s32SetData(const tU8 &tDISP_CSCBlackLevelParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCBlackLevel,(tVoid*)&tDISP_CSCBlackLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCBlackLevelParam' in function 'dp_tclDimmingDPDISP_CSCBlackLevel::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPDISP_CSCBlackLevel::u8GetData(tU8& tDISP_CSCBlackLevelParam) {  
   vUpdate();
   tDISP_CSCBlackLevelParam = tDISP_CSCBlackLevel;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPDISP_CSCBlackLevel::vSetData(tU8 &tDISP_CSCBlackLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCBlackLevel,(tVoid*)&tDISP_CSCBlackLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCBlackLevelParam' in function 'dp_tclDimmingDPDISP_CSCBlackLevel::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPDISP_CSCBlackLevel::vSetData(const tU8 &tDISP_CSCBlackLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCBlackLevel,(tVoid*)&tDISP_CSCBlackLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCBlackLevelParam' in function 'dp_tclDimmingDPDISP_CSCBlackLevel::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPDISP_CSCBlackLevel::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPDISP_CSCBlackLevel::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCBlackLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCBlackLevel::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCBlackLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCBlackLevel::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_CSCBlackLevel", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element DISP_CSCBlackLevel has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_CSCGammaLevel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_CSCGammaLevel::dp_tclDimmingDPDISP_CSCGammaLevel(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISP_CSCGammaLevel,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPDISP_CSCGammaLevel::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISP_CSCGammaLevel",(tS32) 0x17ec5353);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDISP_CSCGammaLevel = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPDISP_CSCGammaLevel::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISP_CSCGammaLevel", (tS32)0x17ec5353);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISP_CSCGammaLevel, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPDISP_CSCGammaLevel::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPDISP_CSCGammaLevel::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPDISP_CSCGammaLevel::tGetData() {
   vUpdate();
   return tDISP_CSCGammaLevel;
};
tS32 dp_tclDimmingDPDISP_CSCGammaLevel::s32GetData(tU8& tDISP_CSCGammaLevelParam) { 
   vUpdate();
   tDISP_CSCGammaLevelParam = tDISP_CSCGammaLevel;
   return _s32Status;
}
tS32 dp_tclDimmingDPDISP_CSCGammaLevel::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISP_CSCGammaLevel", (tS32)0x17ec5353);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPDISP_CSCGammaLevel::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPDISP_CSCGammaLevel::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPDISP_CSCGammaLevel::s32SetData(tU8 &tDISP_CSCGammaLevelParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCGammaLevel,(tVoid*)&tDISP_CSCGammaLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCGammaLevelParam' in function 'dp_tclDimmingDPDISP_CSCGammaLevel::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPDISP_CSCGammaLevel::s32SetData(const tU8 &tDISP_CSCGammaLevelParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCGammaLevel,(tVoid*)&tDISP_CSCGammaLevelParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCGammaLevelParam' in function 'dp_tclDimmingDPDISP_CSCGammaLevel::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPDISP_CSCGammaLevel::u8GetData(tU8& tDISP_CSCGammaLevelParam) {  
   vUpdate();
   tDISP_CSCGammaLevelParam = tDISP_CSCGammaLevel;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPDISP_CSCGammaLevel::vSetData(tU8 &tDISP_CSCGammaLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCGammaLevel,(tVoid*)&tDISP_CSCGammaLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCGammaLevelParam' in function 'dp_tclDimmingDPDISP_CSCGammaLevel::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPDISP_CSCGammaLevel::vSetData(const tU8 &tDISP_CSCGammaLevelParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCGammaLevel,(tVoid*)&tDISP_CSCGammaLevelParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCGammaLevelParam' in function 'dp_tclDimmingDPDISP_CSCGammaLevel::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPDISP_CSCGammaLevel::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPDISP_CSCGammaLevel::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCGammaLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCGammaLevel::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCGammaLevel", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCGammaLevel::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_CSCGammaLevel", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element DISP_CSCGammaLevel has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_CSCGamma"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_CSCGamma::dp_tclDimmingDPDISP_CSCGamma(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDISP_CSCGamma,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPDISP_CSCGamma::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DISP_CSCGamma",(tS32) 0xee3b23bf);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tDISP_CSCGamma = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPDISP_CSCGamma::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DISP_CSCGamma", (tS32)0xee3b23bf);
   (tVoid)myDpElem.bFillData((tVoid*)&tDISP_CSCGamma, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPDISP_CSCGamma::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPDISP_CSCGamma::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclDimmingDPDISP_CSCGamma::tGetData() {
   vUpdate();
   return tDISP_CSCGamma;
};
tS32 dp_tclDimmingDPDISP_CSCGamma::s32GetData(tU16& tDISP_CSCGammaParam) { 
   vUpdate();
   tDISP_CSCGammaParam = tDISP_CSCGamma;
   return _s32Status;
}
tS32 dp_tclDimmingDPDISP_CSCGamma::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DISP_CSCGamma", (tS32)0xee3b23bf);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPDISP_CSCGamma::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPDISP_CSCGamma::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPDISP_CSCGamma::s32SetData(tU16 &tDISP_CSCGammaParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCGamma,(tVoid*)&tDISP_CSCGammaParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCGammaParam' in function 'dp_tclDimmingDPDISP_CSCGamma::vSetData(tU16)' could be made const reference
tS32 dp_tclDimmingDPDISP_CSCGamma::s32SetData(const tU16 &tDISP_CSCGammaParam) {
   //init parameter
   (tVoid)memcpy(&tDISP_CSCGamma,(tVoid*)&tDISP_CSCGammaParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDISP_CSCGammaParam' in function 'dp_tclDimmingDPDISP_CSCGamma::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPDISP_CSCGamma::u8GetData(tU16& tDISP_CSCGammaParam) {  
   vUpdate();
   tDISP_CSCGammaParam = tDISP_CSCGamma;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPDISP_CSCGamma::vSetData(tU16 &tDISP_CSCGammaParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCGamma,(tVoid*)&tDISP_CSCGammaParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCGammaParam' in function 'dp_tclDimmingDPDISP_CSCGamma::vSetData(tU16)' could be made const reference
tVoid dp_tclDimmingDPDISP_CSCGamma::vSetData(const tU16 &tDISP_CSCGammaParam) { 
   //init parameter
   (tVoid)memcpy(&tDISP_CSCGamma,(tVoid*)&tDISP_CSCGammaParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDISP_CSCGammaParam' in function 'dp_tclDimmingDPDISP_CSCGamma::vSetData(tU16)' could be made const reference
tU8   dp_tclDimmingDPDISP_CSCGamma::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPDISP_CSCGamma::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCGamma", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCGamma::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_CSCGamma", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPDISP_CSCGamma::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_CSCGamma", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element DISP_CSCGamma has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "INFO_DimmingModeCar"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPINFO_DimmingModeCar::dp_tclDimmingDPINFO_DimmingModeCar(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tINFO_DimmingModeCar,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPINFO_DimmingModeCar::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("INFO_DimmingModeCar",(tS32) 0xae89efcf);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tINFO_DimmingModeCar = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPINFO_DimmingModeCar::vStore(tVoid) {
   dp_tclBaseElement myDpElem("INFO_DimmingModeCar", (tS32)0xae89efcf);
   (tVoid)myDpElem.bFillData((tVoid*)&tINFO_DimmingModeCar, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPINFO_DimmingModeCar::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPINFO_DimmingModeCar::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPINFO_DimmingModeCar::tGetData() {
   vUpdate();
   return tINFO_DimmingModeCar;
};
tS32 dp_tclDimmingDPINFO_DimmingModeCar::s32GetData(tU8& tINFO_DimmingModeCarParam) { 
   vUpdate();
   tINFO_DimmingModeCarParam = tINFO_DimmingModeCar;
   return _s32Status;
}
tS32 dp_tclDimmingDPINFO_DimmingModeCar::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("INFO_DimmingModeCar", (tS32)0xae89efcf);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPINFO_DimmingModeCar::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPINFO_DimmingModeCar::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPINFO_DimmingModeCar::s32SetData(tU8 &tINFO_DimmingModeCarParam) {
   //init parameter
   (tVoid)memcpy(&tINFO_DimmingModeCar,(tVoid*)&tINFO_DimmingModeCarParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tINFO_DimmingModeCarParam' in function 'dp_tclDimmingDPINFO_DimmingModeCar::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPINFO_DimmingModeCar::s32SetData(const tU8 &tINFO_DimmingModeCarParam) {
   //init parameter
   (tVoid)memcpy(&tINFO_DimmingModeCar,(tVoid*)&tINFO_DimmingModeCarParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tINFO_DimmingModeCarParam' in function 'dp_tclDimmingDPINFO_DimmingModeCar::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPINFO_DimmingModeCar::u8GetData(tU8& tINFO_DimmingModeCarParam) {  
   vUpdate();
   tINFO_DimmingModeCarParam = tINFO_DimmingModeCar;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPINFO_DimmingModeCar::vSetData(tU8 &tINFO_DimmingModeCarParam) { 
   //init parameter
   (tVoid)memcpy(&tINFO_DimmingModeCar,(tVoid*)&tINFO_DimmingModeCarParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tINFO_DimmingModeCarParam' in function 'dp_tclDimmingDPINFO_DimmingModeCar::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPINFO_DimmingModeCar::vSetData(const tU8 &tINFO_DimmingModeCarParam) { 
   //init parameter
   (tVoid)memcpy(&tINFO_DimmingModeCar,(tVoid*)&tINFO_DimmingModeCarParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tINFO_DimmingModeCarParam' in function 'dp_tclDimmingDPINFO_DimmingModeCar::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPINFO_DimmingModeCar::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPINFO_DimmingModeCar::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "INFO_DimmingModeCar", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPINFO_DimmingModeCar::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "INFO_DimmingModeCar", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPINFO_DimmingModeCar::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: INFO_DimmingModeCar", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element INFO_DimmingModeCar has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "INFO_DimmingModeStatus"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPINFO_DimmingModeStatus::dp_tclDimmingDPINFO_DimmingModeStatus(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tINFO_DimmingModeStatus,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPINFO_DimmingModeStatus::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("INFO_DimmingModeStatus",(tS32) 0x395b0f89);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tINFO_DimmingModeStatus = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPINFO_DimmingModeStatus::vStore(tVoid) {
   dp_tclBaseElement myDpElem("INFO_DimmingModeStatus", (tS32)0x395b0f89);
   (tVoid)myDpElem.bFillData((tVoid*)&tINFO_DimmingModeStatus, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPINFO_DimmingModeStatus::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPINFO_DimmingModeStatus::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPINFO_DimmingModeStatus::tGetData() {
   vUpdate();
   return tINFO_DimmingModeStatus;
};
tS32 dp_tclDimmingDPINFO_DimmingModeStatus::s32GetData(tU8& tINFO_DimmingModeStatusParam) { 
   vUpdate();
   tINFO_DimmingModeStatusParam = tINFO_DimmingModeStatus;
   return _s32Status;
}
tS32 dp_tclDimmingDPINFO_DimmingModeStatus::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("INFO_DimmingModeStatus", (tS32)0x395b0f89);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPINFO_DimmingModeStatus::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPINFO_DimmingModeStatus::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPINFO_DimmingModeStatus::s32SetData(tU8 &tINFO_DimmingModeStatusParam) {
   //init parameter
   (tVoid)memcpy(&tINFO_DimmingModeStatus,(tVoid*)&tINFO_DimmingModeStatusParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tINFO_DimmingModeStatusParam' in function 'dp_tclDimmingDPINFO_DimmingModeStatus::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPINFO_DimmingModeStatus::s32SetData(const tU8 &tINFO_DimmingModeStatusParam) {
   //init parameter
   (tVoid)memcpy(&tINFO_DimmingModeStatus,(tVoid*)&tINFO_DimmingModeStatusParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tINFO_DimmingModeStatusParam' in function 'dp_tclDimmingDPINFO_DimmingModeStatus::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPINFO_DimmingModeStatus::u8GetData(tU8& tINFO_DimmingModeStatusParam) {  
   vUpdate();
   tINFO_DimmingModeStatusParam = tINFO_DimmingModeStatus;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPINFO_DimmingModeStatus::vSetData(tU8 &tINFO_DimmingModeStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tINFO_DimmingModeStatus,(tVoid*)&tINFO_DimmingModeStatusParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tINFO_DimmingModeStatusParam' in function 'dp_tclDimmingDPINFO_DimmingModeStatus::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPINFO_DimmingModeStatus::vSetData(const tU8 &tINFO_DimmingModeStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tINFO_DimmingModeStatus,(tVoid*)&tINFO_DimmingModeStatusParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tINFO_DimmingModeStatusParam' in function 'dp_tclDimmingDPINFO_DimmingModeStatus::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPINFO_DimmingModeStatus::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPINFO_DimmingModeStatus::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "INFO_DimmingModeStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPINFO_DimmingModeStatus::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "INFO_DimmingModeStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPINFO_DimmingModeStatus::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: INFO_DimmingModeStatus", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element INFO_DimmingModeStatus has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "INFO_EmulationModeSet"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPINFO_EmulationModeSet::dp_tclDimmingDPINFO_EmulationModeSet(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tINFO_EmulationModeSet,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPINFO_EmulationModeSet::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("INFO_EmulationModeSet",(tS32) 0xfa630b5a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tINFO_EmulationModeSet = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPINFO_EmulationModeSet::vStore(tVoid) {
   dp_tclBaseElement myDpElem("INFO_EmulationModeSet", (tS32)0xfa630b5a);
   (tVoid)myDpElem.bFillData((tVoid*)&tINFO_EmulationModeSet, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPINFO_EmulationModeSet::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPINFO_EmulationModeSet::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPINFO_EmulationModeSet::tGetData() {
   vUpdate();
   return tINFO_EmulationModeSet;
};
tS32 dp_tclDimmingDPINFO_EmulationModeSet::s32GetData(tU8& tINFO_EmulationModeSetParam) { 
   vUpdate();
   tINFO_EmulationModeSetParam = tINFO_EmulationModeSet;
   return _s32Status;
}
tS32 dp_tclDimmingDPINFO_EmulationModeSet::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("INFO_EmulationModeSet", (tS32)0xfa630b5a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPINFO_EmulationModeSet::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPINFO_EmulationModeSet::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPINFO_EmulationModeSet::s32SetData(tU8 &tINFO_EmulationModeSetParam) {
   //init parameter
   (tVoid)memcpy(&tINFO_EmulationModeSet,(tVoid*)&tINFO_EmulationModeSetParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tINFO_EmulationModeSetParam' in function 'dp_tclDimmingDPINFO_EmulationModeSet::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPINFO_EmulationModeSet::s32SetData(const tU8 &tINFO_EmulationModeSetParam) {
   //init parameter
   (tVoid)memcpy(&tINFO_EmulationModeSet,(tVoid*)&tINFO_EmulationModeSetParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tINFO_EmulationModeSetParam' in function 'dp_tclDimmingDPINFO_EmulationModeSet::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPINFO_EmulationModeSet::u8GetData(tU8& tINFO_EmulationModeSetParam) {  
   vUpdate();
   tINFO_EmulationModeSetParam = tINFO_EmulationModeSet;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPINFO_EmulationModeSet::vSetData(tU8 &tINFO_EmulationModeSetParam) { 
   //init parameter
   (tVoid)memcpy(&tINFO_EmulationModeSet,(tVoid*)&tINFO_EmulationModeSetParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tINFO_EmulationModeSetParam' in function 'dp_tclDimmingDPINFO_EmulationModeSet::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPINFO_EmulationModeSet::vSetData(const tU8 &tINFO_EmulationModeSetParam) { 
   //init parameter
   (tVoid)memcpy(&tINFO_EmulationModeSet,(tVoid*)&tINFO_EmulationModeSetParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tINFO_EmulationModeSetParam' in function 'dp_tclDimmingDPINFO_EmulationModeSet::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPINFO_EmulationModeSet::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPINFO_EmulationModeSet::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "INFO_EmulationModeSet", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPINFO_EmulationModeSet::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "INFO_EmulationModeSet", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPINFO_EmulationModeSet::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: INFO_EmulationModeSet", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element INFO_EmulationModeSet has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CALIBRATION_BrightnessMatrix_Selection"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCALIBRATION_BrightnessMatrix_Selection,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CALIBRATION_BrightnessMatrix_Selection",(tS32) 0xd3a2d6aeL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCALIBRATION_BrightnessMatrix_Selection = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CALIBRATION_BrightnessMatrix_Selection", (tS32)0xd3a2d6aeL);
   (tVoid)myDpElem.bFillData((tVoid*)&tCALIBRATION_BrightnessMatrix_Selection, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::tGetData() {
   vUpdate();
   return tCALIBRATION_BrightnessMatrix_Selection;
};
tS32 dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::s32GetData(tU8& tCALIBRATION_BrightnessMatrix_SelectionParam) { 
   vUpdate();
   tCALIBRATION_BrightnessMatrix_SelectionParam = tCALIBRATION_BrightnessMatrix_Selection;
   return _s32Status;
}
tS32 dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CALIBRATION_BrightnessMatrix_Selection", (tS32)0xd3a2d6aeL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::s32SetData(tU8 &tCALIBRATION_BrightnessMatrix_SelectionParam) {
   //init parameter
   (tVoid)memcpy(&tCALIBRATION_BrightnessMatrix_Selection,(tVoid*)&tCALIBRATION_BrightnessMatrix_SelectionParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCALIBRATION_BrightnessMatrix_SelectionParam' in function 'dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::s32SetData(const tU8 &tCALIBRATION_BrightnessMatrix_SelectionParam) {
   //init parameter
   (tVoid)memcpy(&tCALIBRATION_BrightnessMatrix_Selection,(tVoid*)&tCALIBRATION_BrightnessMatrix_SelectionParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCALIBRATION_BrightnessMatrix_SelectionParam' in function 'dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::u8GetData(tU8& tCALIBRATION_BrightnessMatrix_SelectionParam) {  
   vUpdate();
   tCALIBRATION_BrightnessMatrix_SelectionParam = tCALIBRATION_BrightnessMatrix_Selection;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::vSetData(tU8 &tCALIBRATION_BrightnessMatrix_SelectionParam) { 
   //init parameter
   (tVoid)memcpy(&tCALIBRATION_BrightnessMatrix_Selection,(tVoid*)&tCALIBRATION_BrightnessMatrix_SelectionParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCALIBRATION_BrightnessMatrix_SelectionParam' in function 'dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::vSetData(const tU8 &tCALIBRATION_BrightnessMatrix_SelectionParam) { 
   //init parameter
   (tVoid)memcpy(&tCALIBRATION_BrightnessMatrix_Selection,(tVoid*)&tCALIBRATION_BrightnessMatrix_SelectionParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCALIBRATION_BrightnessMatrix_SelectionParam' in function 'dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "CALIBRATION_BrightnessMatrix_Selection", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "CALIBRATION_BrightnessMatrix_Selection", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPCALIBRATION_BrightnessMatrix_Selection::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CALIBRATION_BrightnessMatrix_Selection", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element CALIBRATION_BrightnessMatrix_Selection has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_Brightness_Calibration_Day_Set"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_Brightness_Calibration_Day_Set::dp_tclDimmingDPDISP_Brightness_Calibration_Day_Set(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDimmingDPDISP_Brightness_Calibration_Day_Set::s32SetData( tU16* tDISP_Brightness_Calibration_Day_SetParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("DISP_Brightness_Calibration_Day_Set", (tS32)0xf360e97bL);
   (tVoid)myDpElem.bFillData((tVoid*)tDISP_Brightness_Calibration_Day_SetParam, ((tU32)sizeof(tU16))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDimmingDPDISP_Brightness_Calibration_Day_Set::s32GetData(tU16* tDISP_Brightness_Calibration_Day_SetParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("DISP_Brightness_Calibration_Day_Set", (tS32)0xf360e97bL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU16)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU16));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tDISP_Brightness_Calibration_Day_SetParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU16));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDimmingDPDISP_Brightness_Calibration_Day_Set::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDPDISP_Brightness_Calibration_Day_Set::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDimmingDPDISP_Brightness_Calibration_Day_Set::u16GetData(tU16* tDISP_Brightness_Calibration_Day_SetParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tDISP_Brightness_Calibration_Day_SetParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDPDISP_Brightness_Calibration_Day_Set::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_Brightness_Calibration_Day_Set", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPDISP_Brightness_Calibration_Day_Set::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_Brightness_Calibration_Day_Set", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDimmingDPDISP_Brightness_Calibration_Day_Set::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_Brightness_Calibration_Day_Set", DP_U32_POOL_ID_DIMMINGDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
		}
		else
		{
			fprintf(stdout,"Element DISP_Brightness_Calibration_Day_Set has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DISP_Brightness_Calibration_Night_Set"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPDISP_Brightness_Calibration_Night_Set::dp_tclDimmingDPDISP_Brightness_Calibration_Night_Set(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclDimmingDPDISP_Brightness_Calibration_Night_Set::s32SetData( tU16* tDISP_Brightness_Calibration_Night_SetParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("DISP_Brightness_Calibration_Night_Set", (tS32)0xc4b86147L);
   (tVoid)myDpElem.bFillData((tVoid*)tDISP_Brightness_Calibration_Night_SetParam, ((tU32)sizeof(tU16))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclDimmingDPDISP_Brightness_Calibration_Night_Set::s32GetData(tU16* tDISP_Brightness_Calibration_Night_SetParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("DISP_Brightness_Calibration_Night_Set", (tS32)0xc4b86147L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU16)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU16));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tDISP_Brightness_Calibration_Night_SetParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU16));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclDimmingDPDISP_Brightness_Calibration_Night_Set::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclDimmingDPDISP_Brightness_Calibration_Night_Set::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclDimmingDPDISP_Brightness_Calibration_Night_Set::u16GetData(tU16* tDISP_Brightness_Calibration_Night_SetParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tDISP_Brightness_Calibration_Night_SetParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclDimmingDPDISP_Brightness_Calibration_Night_Set::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_Brightness_Calibration_Night_Set", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclDimmingDPDISP_Brightness_Calibration_Night_Set::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "DISP_Brightness_Calibration_Night_Set", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclDimmingDPDISP_Brightness_Calibration_Night_Set::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DISP_Brightness_Calibration_Night_Set", DP_U32_POOL_ID_DIMMINGDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
		}
		else
		{
			fprintf(stdout,"Element DISP_Brightness_Calibration_Night_Set has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SLIDER_Screen_DAY_Luminosity_OFFSET"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSLIDER_Screen_DAY_Luminosity_OFFSET,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SLIDER_Screen_DAY_Luminosity_OFFSET",(tS32) 0x8e865771L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSLIDER_Screen_DAY_Luminosity_OFFSET = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SLIDER_Screen_DAY_Luminosity_OFFSET", (tS32)0x8e865771L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSLIDER_Screen_DAY_Luminosity_OFFSET, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::tGetData() {
   vUpdate();
   return tSLIDER_Screen_DAY_Luminosity_OFFSET;
};
tS32 dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::s32GetData(tU8& tSLIDER_Screen_DAY_Luminosity_OFFSETParam) { 
   vUpdate();
   tSLIDER_Screen_DAY_Luminosity_OFFSETParam = tSLIDER_Screen_DAY_Luminosity_OFFSET;
   return _s32Status;
}
tS32 dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SLIDER_Screen_DAY_Luminosity_OFFSET", (tS32)0x8e865771L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::s32SetData(tU8 &tSLIDER_Screen_DAY_Luminosity_OFFSETParam) {
   //init parameter
   (tVoid)memcpy(&tSLIDER_Screen_DAY_Luminosity_OFFSET,(tVoid*)&tSLIDER_Screen_DAY_Luminosity_OFFSETParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSLIDER_Screen_DAY_Luminosity_OFFSETParam' in function 'dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::s32SetData(const tU8 &tSLIDER_Screen_DAY_Luminosity_OFFSETParam) {
   //init parameter
   (tVoid)memcpy(&tSLIDER_Screen_DAY_Luminosity_OFFSET,(tVoid*)&tSLIDER_Screen_DAY_Luminosity_OFFSETParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSLIDER_Screen_DAY_Luminosity_OFFSETParam' in function 'dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::u8GetData(tU8& tSLIDER_Screen_DAY_Luminosity_OFFSETParam) {  
   vUpdate();
   tSLIDER_Screen_DAY_Luminosity_OFFSETParam = tSLIDER_Screen_DAY_Luminosity_OFFSET;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::vSetData(tU8 &tSLIDER_Screen_DAY_Luminosity_OFFSETParam) { 
   //init parameter
   (tVoid)memcpy(&tSLIDER_Screen_DAY_Luminosity_OFFSET,(tVoid*)&tSLIDER_Screen_DAY_Luminosity_OFFSETParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSLIDER_Screen_DAY_Luminosity_OFFSETParam' in function 'dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::vSetData(const tU8 &tSLIDER_Screen_DAY_Luminosity_OFFSETParam) { 
   //init parameter
   (tVoid)memcpy(&tSLIDER_Screen_DAY_Luminosity_OFFSET,(tVoid*)&tSLIDER_Screen_DAY_Luminosity_OFFSETParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSLIDER_Screen_DAY_Luminosity_OFFSETParam' in function 'dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "SLIDER_Screen_DAY_Luminosity_OFFSET", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "SLIDER_Screen_DAY_Luminosity_OFFSET", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPSLIDER_Screen_DAY_Luminosity_OFFSET::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SLIDER_Screen_DAY_Luminosity_OFFSET", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element SLIDER_Screen_DAY_Luminosity_OFFSET has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SLIDER_COCKPIT_Brightness_OFFSET"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSLIDER_COCKPIT_Brightness_OFFSET,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SLIDER_COCKPIT_Brightness_OFFSET",(tS32) 0x20c6bba9L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSLIDER_COCKPIT_Brightness_OFFSET = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SLIDER_COCKPIT_Brightness_OFFSET", (tS32)0x20c6bba9L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSLIDER_COCKPIT_Brightness_OFFSET, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::tGetData() {
   vUpdate();
   return tSLIDER_COCKPIT_Brightness_OFFSET;
};
tS32 dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::s32GetData(tU8& tSLIDER_COCKPIT_Brightness_OFFSETParam) { 
   vUpdate();
   tSLIDER_COCKPIT_Brightness_OFFSETParam = tSLIDER_COCKPIT_Brightness_OFFSET;
   return _s32Status;
}
tS32 dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SLIDER_COCKPIT_Brightness_OFFSET", (tS32)0x20c6bba9L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::s32SetData(tU8 &tSLIDER_COCKPIT_Brightness_OFFSETParam) {
   //init parameter
   (tVoid)memcpy(&tSLIDER_COCKPIT_Brightness_OFFSET,(tVoid*)&tSLIDER_COCKPIT_Brightness_OFFSETParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSLIDER_COCKPIT_Brightness_OFFSETParam' in function 'dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::s32SetData(const tU8 &tSLIDER_COCKPIT_Brightness_OFFSETParam) {
   //init parameter
   (tVoid)memcpy(&tSLIDER_COCKPIT_Brightness_OFFSET,(tVoid*)&tSLIDER_COCKPIT_Brightness_OFFSETParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSLIDER_COCKPIT_Brightness_OFFSETParam' in function 'dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::u8GetData(tU8& tSLIDER_COCKPIT_Brightness_OFFSETParam) {  
   vUpdate();
   tSLIDER_COCKPIT_Brightness_OFFSETParam = tSLIDER_COCKPIT_Brightness_OFFSET;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::vSetData(tU8 &tSLIDER_COCKPIT_Brightness_OFFSETParam) { 
   //init parameter
   (tVoid)memcpy(&tSLIDER_COCKPIT_Brightness_OFFSET,(tVoid*)&tSLIDER_COCKPIT_Brightness_OFFSETParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSLIDER_COCKPIT_Brightness_OFFSETParam' in function 'dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::vSetData(const tU8 &tSLIDER_COCKPIT_Brightness_OFFSETParam) { 
   //init parameter
   (tVoid)memcpy(&tSLIDER_COCKPIT_Brightness_OFFSET,(tVoid*)&tSLIDER_COCKPIT_Brightness_OFFSETParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSLIDER_COCKPIT_Brightness_OFFSETParam' in function 'dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "SLIDER_COCKPIT_Brightness_OFFSET", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "SLIDER_COCKPIT_Brightness_OFFSET", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPSLIDER_COCKPIT_Brightness_OFFSET::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SLIDER_COCKPIT_Brightness_OFFSET", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element SLIDER_COCKPIT_Brightness_OFFSET has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SLIDER_Screen_NIGHT_Luminosity_OFFSET"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSLIDER_Screen_NIGHT_Luminosity_OFFSET,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SLIDER_Screen_NIGHT_Luminosity_OFFSET",(tS32) 0x9debfe05L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSLIDER_Screen_NIGHT_Luminosity_OFFSET = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SLIDER_Screen_NIGHT_Luminosity_OFFSET", (tS32)0x9debfe05L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSLIDER_Screen_NIGHT_Luminosity_OFFSET, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::s32GetStatus() const {return _s32Status;};
tU8   dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::tGetData() {
   vUpdate();
   return tSLIDER_Screen_NIGHT_Luminosity_OFFSET;
};
tS32 dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::s32GetData(tU8& tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam) { 
   vUpdate();
   tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam = tSLIDER_Screen_NIGHT_Luminosity_OFFSET;
   return _s32Status;
}
tS32 dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SLIDER_Screen_NIGHT_Luminosity_OFFSET", (tS32)0x9debfe05L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_DIMMINGDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::s32SetData(tU8 &tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam) {
   //init parameter
   (tVoid)memcpy(&tSLIDER_Screen_NIGHT_Luminosity_OFFSET,(tVoid*)&tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam' in function 'dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::vSetData(tU8)' could be made const reference
tS32 dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::s32SetData(const tU8 &tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam) {
   //init parameter
   (tVoid)memcpy(&tSLIDER_Screen_NIGHT_Luminosity_OFFSET,(tVoid*)&tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam' in function 'dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::u8GetData(tU8& tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam) {  
   vUpdate();
   tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam = tSLIDER_Screen_NIGHT_Luminosity_OFFSET;
   return _u8DataStatus;
}
tVoid dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::vSetData(tU8 &tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam) { 
   //init parameter
   (tVoid)memcpy(&tSLIDER_Screen_NIGHT_Luminosity_OFFSET,(tVoid*)&tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam' in function 'dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::vSetData(tU8)' could be made const reference
tVoid dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::vSetData(const tU8 &tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam) { 
   //init parameter
   (tVoid)memcpy(&tSLIDER_Screen_NIGHT_Luminosity_OFFSET,(tVoid*)&tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSLIDER_Screen_NIGHT_Luminosity_OFFSETParam' in function 'dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::vSetData(tU8)' could be made const reference
tU8   dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_DIMMINGDP, "SLIDER_Screen_NIGHT_Luminosity_OFFSET", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_DIMMINGDP, "SLIDER_Screen_NIGHT_Luminosity_OFFSET", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclDimmingDPSLIDER_Screen_NIGHT_Luminosity_OFFSET::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SLIDER_Screen_NIGHT_Luminosity_OFFSET", DP_U32_POOL_ID_DIMMINGDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_DIMMINGDP);
   }
   else
   {
      fprintf(stdout,"Element SLIDER_Screen_NIGHT_Luminosity_OFFSET has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
