#ifndef _DP_FI_DPPDDKERNEL_H
#define _DP_FI_DPPDDKERNEL_H

extern tVoid vInitDpPddKernel(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclDpPddKernelSynergyDriver{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tSynergyDriver;
   
public:
   dp_tclDpPddKernelSynergyDriver(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDpPddKernelSynergyDriver() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tSynergyDriverParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tSynergyDriverParam);
   tS32  s32SetData(const tU32 &tSynergyDriverParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tSynergyDriverParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tSynergyDriverParam);
   tVoid vSetData(const tU32& tSynergyDriverParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclDpPddKernelDisplayTiming{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclDpPddKernelDisplayTiming(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclDpPddKernelDisplayTiming() {};

   //read access for pool element 
   tS32  s32GetData(tU8* tDisplayTimingParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU8* tDisplayTimingParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU8* tDisplayTimingParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

#endif
