#ifndef _DP_FI_APPHMI_SYSTEM_H
#define _DP_FI_APPHMI_SYSTEM_H

extern tVoid vInitAppHmi_System(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define DUMMY 
#include "../../ai_inf4cv_hmi/products/INF4CV/Apps/AppHmi_System/App/datapool/apphmi_system_datapool_if.h"
//lint +e750




class dp_tclAppHmi_SystemRVC_BrightnessValue{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tRVC_BrightnessValue;
   
public:
   dp_tclAppHmi_SystemRVC_BrightnessValue(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SystemRVC_BrightnessValue() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tRVC_BrightnessValueParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tRVC_BrightnessValueParam);
   tS32  s32SetData(const tU8 &tRVC_BrightnessValueParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tRVC_BrightnessValueParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tRVC_BrightnessValueParam);
   tVoid vSetData(const tU8& tRVC_BrightnessValueParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_SystemRVC_ContrastValue{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tRVC_ContrastValue;
   
public:
   dp_tclAppHmi_SystemRVC_ContrastValue(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SystemRVC_ContrastValue() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tRVC_ContrastValueParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tRVC_ContrastValueParam);
   tS32  s32SetData(const tU8 &tRVC_ContrastValueParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tRVC_ContrastValueParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tRVC_ContrastValueParam);
   tVoid vSetData(const tU8& tRVC_ContrastValueParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_SystemCAA_MicBeepVolValue{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tCAA_MicBeepVolValue;
   
public:
   dp_tclAppHmi_SystemCAA_MicBeepVolValue(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SystemCAA_MicBeepVolValue() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tCAA_MicBeepVolValueParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tCAA_MicBeepVolValueParam);
   tS32  s32SetData(const tU8 &tCAA_MicBeepVolValueParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tCAA_MicBeepVolValueParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tCAA_MicBeepVolValueParam);
   tVoid vSetData(const tU8& tCAA_MicBeepVolValueParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_SystemSWUpdateTypeValue{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSWUpdateTypeValue;
   
public:
   dp_tclAppHmi_SystemSWUpdateTypeValue(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SystemSWUpdateTypeValue() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSWUpdateTypeValueParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSWUpdateTypeValueParam);
   tS32  s32SetData(const tU8 &tSWUpdateTypeValueParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSWUpdateTypeValueParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSWUpdateTypeValueParam);
   tVoid vSetData(const tU8& tSWUpdateTypeValueParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_SystemETAStatus{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tETAStatus;
   
public:
   dp_tclAppHmi_SystemETAStatus(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SystemETAStatus() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tETAStatusParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tETAStatusParam);
   tS32  s32SetData(const tU8 &tETAStatusParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tETAStatusParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tETAStatusParam);
   tVoid vSetData(const tU8& tETAStatusParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
