#ifndef _DP_FI_ENGINESOUNDSETTINGSDP_H
#define _DP_FI_ENGINESOUNDSETTINGSDP_H

extern tVoid vInitEngineSoundSettingsDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define FC_AUDIOMANAGER_S_IMPORT_INTERFACE_DP_FC_AUDIOMANAGER 
#include "fc_audiomanager_if.h"
//lint +e750




class dp_tclEngineSoundSettingsDPESESoundTypeEco{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESESoundTypeEco;
   
public:
   dp_tclEngineSoundSettingsDPESESoundTypeEco(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESESoundTypeEco() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESESoundTypeEcoParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESESoundTypeEcoParam);
   tS32  s32SetData(const tU8 &tESESoundTypeEcoParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESESoundTypeEcoParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESESoundTypeEcoParam);
   tVoid vSetData(const tU8& tESESoundTypeEcoParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESESoundTypeComfort{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESESoundTypeComfort;
   
public:
   dp_tclEngineSoundSettingsDPESESoundTypeComfort(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESESoundTypeComfort() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESESoundTypeComfortParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESESoundTypeComfortParam);
   tS32  s32SetData(const tU8 &tESESoundTypeComfortParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESESoundTypeComfortParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESESoundTypeComfortParam);
   tVoid vSetData(const tU8& tESESoundTypeComfortParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESESoundTypeNormal{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESESoundTypeNormal;
   
public:
   dp_tclEngineSoundSettingsDPESESoundTypeNormal(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESESoundTypeNormal() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESESoundTypeNormalParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESESoundTypeNormalParam);
   tS32  s32SetData(const tU8 &tESESoundTypeNormalParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESESoundTypeNormalParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESESoundTypeNormalParam);
   tVoid vSetData(const tU8& tESESoundTypeNormalParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESESoundTypeDynamic{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESESoundTypeDynamic;
   
public:
   dp_tclEngineSoundSettingsDPESESoundTypeDynamic(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESESoundTypeDynamic() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESESoundTypeDynamicParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESESoundTypeDynamicParam);
   tS32  s32SetData(const tU8 &tESESoundTypeDynamicParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESESoundTypeDynamicParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESESoundTypeDynamicParam);
   tVoid vSetData(const tU8& tESESoundTypeDynamicParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESESoundTypePerso{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESESoundTypePerso;
   
public:
   dp_tclEngineSoundSettingsDPESESoundTypePerso(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESESoundTypePerso() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESESoundTypePersoParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESESoundTypePersoParam);
   tS32  s32SetData(const tU8 &tESESoundTypePersoParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESESoundTypePersoParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESESoundTypePersoParam);
   tVoid vSetData(const tU8& tESESoundTypePersoParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEVolumeEcoNeutral;
   
public:
   dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEVolumeEcoNeutral() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEVolumeEcoNeutralParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEVolumeEcoNeutralParam);
   tS32  s32SetData(const tU8 &tESEVolumeEcoNeutralParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEVolumeEcoNeutralParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEVolumeEcoNeutralParam);
   tVoid vSetData(const tU8& tESEVolumeEcoNeutralParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEVolumeEcoSound1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEVolumeEcoSound1;
   
public:
   dp_tclEngineSoundSettingsDPESEVolumeEcoSound1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEVolumeEcoSound1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEVolumeEcoSound1Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEVolumeEcoSound1Param);
   tS32  s32SetData(const tU8 &tESEVolumeEcoSound1Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEVolumeEcoSound1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEVolumeEcoSound1Param);
   tVoid vSetData(const tU8& tESEVolumeEcoSound1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEVolumeEcoSound2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEVolumeEcoSound2;
   
public:
   dp_tclEngineSoundSettingsDPESEVolumeEcoSound2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEVolumeEcoSound2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEVolumeEcoSound2Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEVolumeEcoSound2Param);
   tS32  s32SetData(const tU8 &tESEVolumeEcoSound2Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEVolumeEcoSound2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEVolumeEcoSound2Param);
   tVoid vSetData(const tU8& tESEVolumeEcoSound2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEVolumeComfortNeutral;
   
public:
   dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEVolumeComfortNeutral() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEVolumeComfortNeutralParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEVolumeComfortNeutralParam);
   tS32  s32SetData(const tU8 &tESEVolumeComfortNeutralParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEVolumeComfortNeutralParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEVolumeComfortNeutralParam);
   tVoid vSetData(const tU8& tESEVolumeComfortNeutralParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEVolumeComfortSound1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEVolumeComfortSound1;
   
public:
   dp_tclEngineSoundSettingsDPESEVolumeComfortSound1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEVolumeComfortSound1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEVolumeComfortSound1Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEVolumeComfortSound1Param);
   tS32  s32SetData(const tU8 &tESEVolumeComfortSound1Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEVolumeComfortSound1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEVolumeComfortSound1Param);
   tVoid vSetData(const tU8& tESEVolumeComfortSound1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEVolumeComfortSound2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEVolumeComfortSound2;
   
public:
   dp_tclEngineSoundSettingsDPESEVolumeComfortSound2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEVolumeComfortSound2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEVolumeComfortSound2Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEVolumeComfortSound2Param);
   tS32  s32SetData(const tU8 &tESEVolumeComfortSound2Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEVolumeComfortSound2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEVolumeComfortSound2Param);
   tVoid vSetData(const tU8& tESEVolumeComfortSound2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEVolumeNormalNeutral;
   
public:
   dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEVolumeNormalNeutral() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEVolumeNormalNeutralParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEVolumeNormalNeutralParam);
   tS32  s32SetData(const tU8 &tESEVolumeNormalNeutralParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEVolumeNormalNeutralParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEVolumeNormalNeutralParam);
   tVoid vSetData(const tU8& tESEVolumeNormalNeutralParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEVolumeNormalSound1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEVolumeNormalSound1;
   
public:
   dp_tclEngineSoundSettingsDPESEVolumeNormalSound1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEVolumeNormalSound1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEVolumeNormalSound1Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEVolumeNormalSound1Param);
   tS32  s32SetData(const tU8 &tESEVolumeNormalSound1Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEVolumeNormalSound1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEVolumeNormalSound1Param);
   tVoid vSetData(const tU8& tESEVolumeNormalSound1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEVolumeNormalSound2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEVolumeNormalSound2;
   
public:
   dp_tclEngineSoundSettingsDPESEVolumeNormalSound2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEVolumeNormalSound2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEVolumeNormalSound2Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEVolumeNormalSound2Param);
   tS32  s32SetData(const tU8 &tESEVolumeNormalSound2Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEVolumeNormalSound2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEVolumeNormalSound2Param);
   tVoid vSetData(const tU8& tESEVolumeNormalSound2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEVolumeDynamicNeutral;
   
public:
   dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEVolumeDynamicNeutral() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEVolumeDynamicNeutralParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEVolumeDynamicNeutralParam);
   tS32  s32SetData(const tU8 &tESEVolumeDynamicNeutralParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEVolumeDynamicNeutralParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEVolumeDynamicNeutralParam);
   tVoid vSetData(const tU8& tESEVolumeDynamicNeutralParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEVolumeDynamicSound1;
   
public:
   dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEVolumeDynamicSound1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEVolumeDynamicSound1Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEVolumeDynamicSound1Param);
   tS32  s32SetData(const tU8 &tESEVolumeDynamicSound1Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEVolumeDynamicSound1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEVolumeDynamicSound1Param);
   tVoid vSetData(const tU8& tESEVolumeDynamicSound1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEVolumeDynamicSound2;
   
public:
   dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEVolumeDynamicSound2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEVolumeDynamicSound2Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEVolumeDynamicSound2Param);
   tS32  s32SetData(const tU8 &tESEVolumeDynamicSound2Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEVolumeDynamicSound2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEVolumeDynamicSound2Param);
   tVoid vSetData(const tU8& tESEVolumeDynamicSound2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEVolumePersoNeutral{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEVolumePersoNeutral;
   
public:
   dp_tclEngineSoundSettingsDPESEVolumePersoNeutral(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEVolumePersoNeutral() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEVolumePersoNeutralParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEVolumePersoNeutralParam);
   tS32  s32SetData(const tU8 &tESEVolumePersoNeutralParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEVolumePersoNeutralParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEVolumePersoNeutralParam);
   tVoid vSetData(const tU8& tESEVolumePersoNeutralParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEVolumePersoSound1{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEVolumePersoSound1;
   
public:
   dp_tclEngineSoundSettingsDPESEVolumePersoSound1(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEVolumePersoSound1() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEVolumePersoSound1Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEVolumePersoSound1Param);
   tS32  s32SetData(const tU8 &tESEVolumePersoSound1Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEVolumePersoSound1Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEVolumePersoSound1Param);
   tVoid vSetData(const tU8& tESEVolumePersoSound1Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEVolumePersoSound2{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEVolumePersoSound2;
   
public:
   dp_tclEngineSoundSettingsDPESEVolumePersoSound2(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEVolumePersoSound2() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEVolumePersoSound2Param);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEVolumePersoSound2Param);
   tS32  s32SetData(const tU8 &tESEVolumePersoSound2Param);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEVolumePersoSound2Param);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEVolumePersoSound2Param);
   tVoid vSetData(const tU8& tESEVolumePersoSound2Param);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPESEDriveMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tESEDriveMode;
   
public:
   dp_tclEngineSoundSettingsDPESEDriveMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPESEDriveMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tESEDriveModeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tESEDriveModeParam);
   tS32  s32SetData(const tU8 &tESEDriveModeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tESEDriveModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tESEDriveModeParam);
   tVoid vSetData(const tU8& tESEDriveModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPRSoundOnOff{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tRSoundOnOff;
   
public:
   dp_tclEngineSoundSettingsDPRSoundOnOff(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPRSoundOnOff() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tRSoundOnOffParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tRSoundOnOffParam);
   tS32  s32SetData(const tBool &tRSoundOnOffParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tRSoundOnOffParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tRSoundOnOffParam);
   tVoid vSetData(const tBool& tRSoundOnOffParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPRSoundType{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tRSoundType;
   
public:
   dp_tclEngineSoundSettingsDPRSoundType(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPRSoundType() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tRSoundTypeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tRSoundTypeParam);
   tS32  s32SetData(const tU8 &tRSoundTypeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tRSoundTypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tRSoundTypeParam);
   tVoid vSetData(const tU8& tRSoundTypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPRSoundVolume{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tRSoundVolume;
   
public:
   dp_tclEngineSoundSettingsDPRSoundVolume(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPRSoundVolume() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tRSoundVolumeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tRSoundVolumeParam);
   tS32  s32SetData(const tU8 &tRSoundVolumeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tRSoundVolumeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tRSoundVolumeParam);
   tVoid vSetData(const tU8& tRSoundVolumeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclEngineSoundSettingsDPRSoundActivation{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tRSoundActivation;
   
public:
   dp_tclEngineSoundSettingsDPRSoundActivation(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclEngineSoundSettingsDPRSoundActivation() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tRSoundActivationParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tRSoundActivationParam);
   tS32  s32SetData(const tBool &tRSoundActivationParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tRSoundActivationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tRSoundActivationParam);
   tVoid vSetData(const tBool& tRSoundActivationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
