#ifndef _DP_FI_AUDIOMANAGERUSRDP_H
#define _DP_FI_AUDIOMANAGERUSRDP_H

extern tVoid vInitAudioManagerUsrDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define FC_AUDIOMANAGER_S_IMPORT_INTERFACE_DP_FC_AUDIOMANAGER 
#include "fc_audiomanager_if.h"
//lint +e750




class dp_tclAudioManagerUsrDPBass_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tBass_Multi;
   
public:
   dp_tclAudioManagerUsrDPBass_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPBass_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tBass_MultiParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tBass_MultiParam);
   tS32  s32SetData(const tS8 &tBass_MultiParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tBass_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tBass_MultiParam);
   tVoid vSetData(const tS8& tBass_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPTreble_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tTreble_Multi;
   
public:
   dp_tclAudioManagerUsrDPTreble_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPTreble_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tTreble_MultiParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tTreble_MultiParam);
   tS32  s32SetData(const tS8 &tTreble_MultiParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tTreble_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tTreble_MultiParam);
   tVoid vSetData(const tS8& tTreble_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPMidRange_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tMidRange_Multi;
   
public:
   dp_tclAudioManagerUsrDPMidRange_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPMidRange_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tMidRange_MultiParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tMidRange_MultiParam);
   tS32  s32SetData(const tS8 &tMidRange_MultiParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tMidRange_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tMidRange_MultiParam);
   tVoid vSetData(const tS8& tMidRange_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPFader_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tFader_Multi;
   
public:
   dp_tclAudioManagerUsrDPFader_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPFader_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tFader_MultiParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tFader_MultiParam);
   tS32  s32SetData(const tS8 &tFader_MultiParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tFader_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tFader_MultiParam);
   tVoid vSetData(const tS8& tFader_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPBalance_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS8 tBalance_Multi;
   
public:
   dp_tclAudioManagerUsrDPBalance_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPBalance_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS8& tBalance_MultiParam);
   tVoid operator>>(tS8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS8 &tBalance_MultiParam);
   tS32  s32SetData(const tS8 &tBalance_MultiParam);
   tVoid operator<<(tS8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS8& tBalance_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS8& tBalance_MultiParam);
   tVoid vSetData(const tS8& tBalance_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPCenterGain_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tCenterGain_Multi;
   
public:
   dp_tclAudioManagerUsrDPCenterGain_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPCenterGain_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tCenterGain_MultiParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tCenterGain_MultiParam);
   tS32  s32SetData(const tS16 &tCenterGain_MultiParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tCenterGain_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tCenterGain_MultiParam);
   tVoid vSetData(const tS16& tCenterGain_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPVolumesMulti{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclAudioManagerUsrDPVolumesMulti(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPVolumesMulti() {};

   //read access for pool element 
   tS32  s32GetData(VolumeManager::tVolumelistEntry* tVolumesMultiParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(VolumeManager::tVolumelistEntry* tVolumesMultiParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(VolumeManager::tVolumelistEntry* tVolumesMultiParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclAudioManagerUsrDPSubWoofer_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS16 tSubWoofer_Multi;
   
public:
   dp_tclAudioManagerUsrDPSubWoofer_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPSubWoofer_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS16& tSubWoofer_MultiParam);
   tVoid operator>>(tS16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS16 &tSubWoofer_MultiParam);
   tS32  s32SetData(const tS16 &tSubWoofer_MultiParam);
   tVoid operator<<(tS16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS16& tSubWoofer_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS16& tSubWoofer_MultiParam);
   tVoid vSetData(const tS16& tSubWoofer_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPSurroundLevel_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSurroundLevel_Multi;
   
public:
   dp_tclAudioManagerUsrDPSurroundLevel_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPSurroundLevel_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSurroundLevel_MultiParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSurroundLevel_MultiParam);
   tS32  s32SetData(const tU8 &tSurroundLevel_MultiParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSurroundLevel_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSurroundLevel_MultiParam);
   tVoid vSetData(const tU8& tSurroundLevel_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPBeepLevel_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tBeepLevel_Multi;
   
public:
   dp_tclAudioManagerUsrDPBeepLevel_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPBeepLevel_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tBeepLevel_MultiParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tBeepLevel_MultiParam);
   tS32  s32SetData(const tU8 &tBeepLevel_MultiParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tBeepLevel_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tBeepLevel_MultiParam);
   tVoid vSetData(const tU8& tBeepLevel_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPEquPreset_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tEquPreset_Multi;
   
public:
   dp_tclAudioManagerUsrDPEquPreset_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPEquPreset_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tEquPreset_MultiParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tEquPreset_MultiParam);
   tS32  s32SetData(const tU8 &tEquPreset_MultiParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tEquPreset_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tEquPreset_MultiParam);
   tVoid vSetData(const tU8& tEquPreset_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPOptimization_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tOptimization_Multi;
   
public:
   dp_tclAudioManagerUsrDPOptimization_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPOptimization_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tOptimization_MultiParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tOptimization_MultiParam);
   tS32  s32SetData(const tU8 &tOptimization_MultiParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tOptimization_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tOptimization_MultiParam);
   tVoid vSetData(const tU8& tOptimization_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPGala_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tGala_Multi;
   
public:
   dp_tclAudioManagerUsrDPGala_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPGala_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tGala_MultiParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tGala_MultiParam);
   tS32  s32SetData(const tU8 &tGala_MultiParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tGala_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tGala_MultiParam);
   tVoid vSetData(const tU8& tGala_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tArkamys_AutomaticGainControl_Multi;
   
public:
   dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tArkamys_AutomaticGainControl_MultiParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tArkamys_AutomaticGainControl_MultiParam);
   tS32  s32SetData(const tBool &tArkamys_AutomaticGainControl_MultiParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tArkamys_AutomaticGainControl_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tArkamys_AutomaticGainControl_MultiParam);
   tVoid vSetData(const tBool& tArkamys_AutomaticGainControl_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPRoomEffect_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tRoomEffect_Multi;
   
public:
   dp_tclAudioManagerUsrDPRoomEffect_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPRoomEffect_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tRoomEffect_MultiParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tRoomEffect_MultiParam);
   tS32  s32SetData(const tU8 &tRoomEffect_MultiParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tRoomEffect_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tRoomEffect_MultiParam);
   tVoid vSetData(const tU8& tRoomEffect_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPSoundStaging_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSoundStaging_Multi;
   
public:
   dp_tclAudioManagerUsrDPSoundStaging_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPSoundStaging_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSoundStaging_MultiParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSoundStaging_MultiParam);
   tS32  s32SetData(const tU8 &tSoundStaging_MultiParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSoundStaging_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSoundStaging_MultiParam);
   tVoid vSetData(const tU8& tSoundStaging_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPGeometryMode_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tGeometryMode_Multi;
   
public:
   dp_tclAudioManagerUsrDPGeometryMode_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPGeometryMode_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tGeometryMode_MultiParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tGeometryMode_MultiParam);
   tS32  s32SetData(const tU8 &tGeometryMode_MultiParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tGeometryMode_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tGeometryMode_MultiParam);
   tVoid vSetData(const tU8& tGeometryMode_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPDAN_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDAN_Multi;
   
public:
   dp_tclAudioManagerUsrDPDAN_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPDAN_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDAN_MultiParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDAN_MultiParam);
   tS32  s32SetData(const tU8 &tDAN_MultiParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDAN_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDAN_MultiParam);
   tVoid vSetData(const tU8& tDAN_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAdas_ParkAssitVol_Multi;
   
public:
   dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAdas_ParkAssitVol_MultiParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAdas_ParkAssitVol_MultiParam);
   tS32  s32SetData(const tU8 &tAdas_ParkAssitVol_MultiParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAdas_ParkAssitVol_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAdas_ParkAssitVol_MultiParam);
   tVoid vSetData(const tU8& tAdas_ParkAssitVol_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAdas_LDWUSerVol_Multi;
   
public:
   dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAdas_LDWUSerVol_MultiParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAdas_LDWUSerVol_MultiParam);
   tS32  s32SetData(const tU8 &tAdas_LDWUSerVol_MultiParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAdas_LDWUSerVol_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAdas_LDWUSerVol_MultiParam);
   tVoid vSetData(const tU8& tAdas_LDWUSerVol_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPAudioPilotMode_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tAudioPilotMode_Multi;
   
public:
   dp_tclAudioManagerUsrDPAudioPilotMode_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPAudioPilotMode_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tAudioPilotMode_MultiParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tAudioPilotMode_MultiParam);
   tS32  s32SetData(const tBool &tAudioPilotMode_MultiParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tAudioPilotMode_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tAudioPilotMode_MultiParam);
   tVoid vSetData(const tBool& tAudioPilotMode_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAudioPilotIntensity_Multi;
   
public:
   dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAudioPilotIntensity_MultiParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAudioPilotIntensity_MultiParam);
   tS32  s32SetData(const tU8 &tAudioPilotIntensity_MultiParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAudioPilotIntensity_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAudioPilotIntensity_MultiParam);
   tVoid vSetData(const tU8& tAudioPilotIntensity_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAdas_UPASoundtype_Multi;
   
public:
   dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAdas_UPASoundtype_MultiParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAdas_UPASoundtype_MultiParam);
   tS32  s32SetData(const tU8 &tAdas_UPASoundtype_MultiParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAdas_UPASoundtype_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAdas_UPASoundtype_MultiParam);
   tVoid vSetData(const tU8& tAdas_UPASoundtype_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAdas_SRSoundState_Multi;
   
public:
   dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAdas_SRSoundState_MultiParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAdas_SRSoundState_MultiParam);
   tS32  s32SetData(const tU8 &tAdas_SRSoundState_MultiParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAdas_SRSoundState_MultiParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAdas_SRSoundState_MultiParam);
   tVoid vSetData(const tU8& tAdas_SRSoundState_MultiParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
