
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclAudioManagerUsrDP.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Bass_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPBass_Multi::dp_tclAudioManagerUsrDPBass_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBass_Multi,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPBass_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Bass_Multi",(tS32) 0xa9b2a8f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tBass_Multi = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPBass_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Bass_Multi", (tS32)0xa9b2a8f);
   (tVoid)myDpElem.bFillData((tVoid*)&tBass_Multi, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPBass_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPBass_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerUsrDPBass_Multi::tGetData() {
   vUpdate();
   return tBass_Multi;
};
tS32 dp_tclAudioManagerUsrDPBass_Multi::s32GetData(tS8& tBass_MultiParam) { 
   vUpdate();
   tBass_MultiParam = tBass_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPBass_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Bass_Multi", (tS32)0xa9b2a8f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPBass_Multi::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPBass_Multi::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPBass_Multi::s32SetData(tS8 &tBass_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tBass_Multi,(tVoid*)&tBass_MultiParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBass_MultiParam' in function 'dp_tclAudioManagerUsrDPBass_Multi::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPBass_Multi::s32SetData(const tS8 &tBass_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tBass_Multi,(tVoid*)&tBass_MultiParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBass_MultiParam' in function 'dp_tclAudioManagerUsrDPBass_Multi::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPBass_Multi::u8GetData(tS8& tBass_MultiParam) {  
   vUpdate();
   tBass_MultiParam = tBass_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPBass_Multi::vSetData(tS8 &tBass_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tBass_Multi,(tVoid*)&tBass_MultiParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBass_MultiParam' in function 'dp_tclAudioManagerUsrDPBass_Multi::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPBass_Multi::vSetData(const tS8 &tBass_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tBass_Multi,(tVoid*)&tBass_MultiParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBass_MultiParam' in function 'dp_tclAudioManagerUsrDPBass_Multi::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPBass_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPBass_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Bass_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPBass_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Bass_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPBass_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Bass_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element Bass_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Treble_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPTreble_Multi::dp_tclAudioManagerUsrDPTreble_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTreble_Multi,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPTreble_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Treble_Multi",(tS32) 0x457cb9ec);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tTreble_Multi = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPTreble_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Treble_Multi", (tS32)0x457cb9ec);
   (tVoid)myDpElem.bFillData((tVoid*)&tTreble_Multi, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPTreble_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPTreble_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerUsrDPTreble_Multi::tGetData() {
   vUpdate();
   return tTreble_Multi;
};
tS32 dp_tclAudioManagerUsrDPTreble_Multi::s32GetData(tS8& tTreble_MultiParam) { 
   vUpdate();
   tTreble_MultiParam = tTreble_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPTreble_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Treble_Multi", (tS32)0x457cb9ec);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPTreble_Multi::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPTreble_Multi::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPTreble_Multi::s32SetData(tS8 &tTreble_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tTreble_Multi,(tVoid*)&tTreble_MultiParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTreble_MultiParam' in function 'dp_tclAudioManagerUsrDPTreble_Multi::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPTreble_Multi::s32SetData(const tS8 &tTreble_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tTreble_Multi,(tVoid*)&tTreble_MultiParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTreble_MultiParam' in function 'dp_tclAudioManagerUsrDPTreble_Multi::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPTreble_Multi::u8GetData(tS8& tTreble_MultiParam) {  
   vUpdate();
   tTreble_MultiParam = tTreble_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPTreble_Multi::vSetData(tS8 &tTreble_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tTreble_Multi,(tVoid*)&tTreble_MultiParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tTreble_MultiParam' in function 'dp_tclAudioManagerUsrDPTreble_Multi::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPTreble_Multi::vSetData(const tS8 &tTreble_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tTreble_Multi,(tVoid*)&tTreble_MultiParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tTreble_MultiParam' in function 'dp_tclAudioManagerUsrDPTreble_Multi::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPTreble_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPTreble_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Treble_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPTreble_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Treble_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPTreble_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Treble_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element Treble_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MidRange_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPMidRange_Multi::dp_tclAudioManagerUsrDPMidRange_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMidRange_Multi,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPMidRange_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MidRange_Multi",(tS32) 0x3ba7e2bd);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tMidRange_Multi = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPMidRange_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MidRange_Multi", (tS32)0x3ba7e2bd);
   (tVoid)myDpElem.bFillData((tVoid*)&tMidRange_Multi, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPMidRange_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPMidRange_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerUsrDPMidRange_Multi::tGetData() {
   vUpdate();
   return tMidRange_Multi;
};
tS32 dp_tclAudioManagerUsrDPMidRange_Multi::s32GetData(tS8& tMidRange_MultiParam) { 
   vUpdate();
   tMidRange_MultiParam = tMidRange_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPMidRange_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MidRange_Multi", (tS32)0x3ba7e2bd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPMidRange_Multi::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPMidRange_Multi::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPMidRange_Multi::s32SetData(tS8 &tMidRange_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tMidRange_Multi,(tVoid*)&tMidRange_MultiParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMidRange_MultiParam' in function 'dp_tclAudioManagerUsrDPMidRange_Multi::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPMidRange_Multi::s32SetData(const tS8 &tMidRange_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tMidRange_Multi,(tVoid*)&tMidRange_MultiParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMidRange_MultiParam' in function 'dp_tclAudioManagerUsrDPMidRange_Multi::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPMidRange_Multi::u8GetData(tS8& tMidRange_MultiParam) {  
   vUpdate();
   tMidRange_MultiParam = tMidRange_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPMidRange_Multi::vSetData(tS8 &tMidRange_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tMidRange_Multi,(tVoid*)&tMidRange_MultiParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tMidRange_MultiParam' in function 'dp_tclAudioManagerUsrDPMidRange_Multi::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPMidRange_Multi::vSetData(const tS8 &tMidRange_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tMidRange_Multi,(tVoid*)&tMidRange_MultiParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tMidRange_MultiParam' in function 'dp_tclAudioManagerUsrDPMidRange_Multi::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPMidRange_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPMidRange_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "MidRange_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPMidRange_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "MidRange_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPMidRange_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MidRange_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element MidRange_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Fader_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPFader_Multi::dp_tclAudioManagerUsrDPFader_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFader_Multi,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPFader_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Fader_Multi",(tS32) 0x36f6ce04);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tFader_Multi = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPFader_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Fader_Multi", (tS32)0x36f6ce04);
   (tVoid)myDpElem.bFillData((tVoid*)&tFader_Multi, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPFader_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPFader_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerUsrDPFader_Multi::tGetData() {
   vUpdate();
   return tFader_Multi;
};
tS32 dp_tclAudioManagerUsrDPFader_Multi::s32GetData(tS8& tFader_MultiParam) { 
   vUpdate();
   tFader_MultiParam = tFader_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPFader_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Fader_Multi", (tS32)0x36f6ce04);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPFader_Multi::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPFader_Multi::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPFader_Multi::s32SetData(tS8 &tFader_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tFader_Multi,(tVoid*)&tFader_MultiParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFader_MultiParam' in function 'dp_tclAudioManagerUsrDPFader_Multi::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPFader_Multi::s32SetData(const tS8 &tFader_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tFader_Multi,(tVoid*)&tFader_MultiParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFader_MultiParam' in function 'dp_tclAudioManagerUsrDPFader_Multi::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPFader_Multi::u8GetData(tS8& tFader_MultiParam) {  
   vUpdate();
   tFader_MultiParam = tFader_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPFader_Multi::vSetData(tS8 &tFader_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tFader_Multi,(tVoid*)&tFader_MultiParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tFader_MultiParam' in function 'dp_tclAudioManagerUsrDPFader_Multi::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPFader_Multi::vSetData(const tS8 &tFader_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tFader_Multi,(tVoid*)&tFader_MultiParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tFader_MultiParam' in function 'dp_tclAudioManagerUsrDPFader_Multi::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPFader_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPFader_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Fader_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPFader_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Fader_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPFader_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Fader_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element Fader_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Balance_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPBalance_Multi::dp_tclAudioManagerUsrDPBalance_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBalance_Multi,0,sizeof(tS8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPBalance_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Balance_Multi",(tS32) 0x28072894);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS8)) 
      {
         tBalance_Multi = *((tS8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPBalance_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Balance_Multi", (tS32)0x28072894);
   (tVoid)myDpElem.bFillData((tVoid*)&tBalance_Multi, (tU32)sizeof(tS8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPBalance_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPBalance_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS8 dp_tclAudioManagerUsrDPBalance_Multi::tGetData() {
   vUpdate();
   return tBalance_Multi;
};
tS32 dp_tclAudioManagerUsrDPBalance_Multi::s32GetData(tS8& tBalance_MultiParam) { 
   vUpdate();
   tBalance_MultiParam = tBalance_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPBalance_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Balance_Multi", (tS32)0x28072894);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPBalance_Multi::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPBalance_Multi::operator<<(tS8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPBalance_Multi::s32SetData(tS8 &tBalance_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tBalance_Multi,(tVoid*)&tBalance_MultiParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBalance_MultiParam' in function 'dp_tclAudioManagerUsrDPBalance_Multi::vSetData(tS8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPBalance_Multi::s32SetData(const tS8 &tBalance_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tBalance_Multi,(tVoid*)&tBalance_MultiParam, sizeof(tS8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBalance_MultiParam' in function 'dp_tclAudioManagerUsrDPBalance_Multi::vSetData(tS8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPBalance_Multi::u8GetData(tS8& tBalance_MultiParam) {  
   vUpdate();
   tBalance_MultiParam = tBalance_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPBalance_Multi::vSetData(tS8 &tBalance_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tBalance_Multi,(tVoid*)&tBalance_MultiParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBalance_MultiParam' in function 'dp_tclAudioManagerUsrDPBalance_Multi::vSetData(tS8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPBalance_Multi::vSetData(const tS8 &tBalance_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tBalance_Multi,(tVoid*)&tBalance_MultiParam, sizeof(tS8));
   vStore();
}//lint !e1746: parameter 'tBalance_MultiParam' in function 'dp_tclAudioManagerUsrDPBalance_Multi::vSetData(tS8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPBalance_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPBalance_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Balance_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPBalance_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Balance_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPBalance_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Balance_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element Balance_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CenterGain_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPCenterGain_Multi::dp_tclAudioManagerUsrDPCenterGain_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCenterGain_Multi,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPCenterGain_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CenterGain_Multi",(tS32) 0xe6e4d83a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tCenterGain_Multi = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPCenterGain_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CenterGain_Multi", (tS32)0xe6e4d83a);
   (tVoid)myDpElem.bFillData((tVoid*)&tCenterGain_Multi, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPCenterGain_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPCenterGain_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclAudioManagerUsrDPCenterGain_Multi::tGetData() {
   vUpdate();
   return tCenterGain_Multi;
};
tS32 dp_tclAudioManagerUsrDPCenterGain_Multi::s32GetData(tS16& tCenterGain_MultiParam) { 
   vUpdate();
   tCenterGain_MultiParam = tCenterGain_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPCenterGain_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CenterGain_Multi", (tS32)0xe6e4d83a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPCenterGain_Multi::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPCenterGain_Multi::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPCenterGain_Multi::s32SetData(tS16 &tCenterGain_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tCenterGain_Multi,(tVoid*)&tCenterGain_MultiParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCenterGain_MultiParam' in function 'dp_tclAudioManagerUsrDPCenterGain_Multi::vSetData(tS16)' could be made const reference
tS32 dp_tclAudioManagerUsrDPCenterGain_Multi::s32SetData(const tS16 &tCenterGain_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tCenterGain_Multi,(tVoid*)&tCenterGain_MultiParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCenterGain_MultiParam' in function 'dp_tclAudioManagerUsrDPCenterGain_Multi::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPCenterGain_Multi::u8GetData(tS16& tCenterGain_MultiParam) {  
   vUpdate();
   tCenterGain_MultiParam = tCenterGain_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPCenterGain_Multi::vSetData(tS16 &tCenterGain_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tCenterGain_Multi,(tVoid*)&tCenterGain_MultiParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCenterGain_MultiParam' in function 'dp_tclAudioManagerUsrDPCenterGain_Multi::vSetData(tS16)' could be made const reference
tVoid dp_tclAudioManagerUsrDPCenterGain_Multi::vSetData(const tS16 &tCenterGain_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tCenterGain_Multi,(tVoid*)&tCenterGain_MultiParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tCenterGain_MultiParam' in function 'dp_tclAudioManagerUsrDPCenterGain_Multi::vSetData(tS16)' could be made const reference
tU8   dp_tclAudioManagerUsrDPCenterGain_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPCenterGain_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "CenterGain_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPCenterGain_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "CenterGain_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPCenterGain_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CenterGain_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element CenterGain_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VolumesMulti"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPVolumesMulti::dp_tclAudioManagerUsrDPVolumesMulti(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclAudioManagerUsrDPVolumesMulti::s32SetData( VolumeManager::tVolumelistEntry* tVolumesMultiParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("VolumesMulti", (tS32)0x4ad3d182);
   (tVoid)myDpElem.bFillData((tVoid*)tVolumesMultiParam, ((tU32)sizeof(VolumeManager::tVolumelistEntry))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclAudioManagerUsrDPVolumesMulti::s32GetData(VolumeManager::tVolumelistEntry* tVolumesMultiParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("VolumesMulti", (tS32)0x4ad3d182);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(VolumeManager::tVolumelistEntry)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(VolumeManager::tVolumelistEntry));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tVolumesMultiParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(VolumeManager::tVolumelistEntry));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclAudioManagerUsrDPVolumesMulti::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAudioManagerUsrDPVolumesMulti::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclAudioManagerUsrDPVolumesMulti::u16GetData(VolumeManager::tVolumelistEntry* tVolumesMultiParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tVolumesMultiParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclAudioManagerUsrDPVolumesMulti::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "VolumesMulti", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAudioManagerUsrDPVolumesMulti::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "VolumesMulti", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclAudioManagerUsrDPVolumesMulti::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VolumesMulti", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
		}
		else
		{
			fprintf(stdout,"Element VolumesMulti has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SubWoofer_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPSubWoofer_Multi::dp_tclAudioManagerUsrDPSubWoofer_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSubWoofer_Multi,0,sizeof(tS16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPSubWoofer_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SubWoofer_Multi",(tS32) 0x13e420ee);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tS16)) 
      {
         tSubWoofer_Multi = *((tS16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPSubWoofer_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SubWoofer_Multi", (tS32)0x13e420ee);
   (tVoid)myDpElem.bFillData((tVoid*)&tSubWoofer_Multi, (tU32)sizeof(tS16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPSubWoofer_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPSubWoofer_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tS16 dp_tclAudioManagerUsrDPSubWoofer_Multi::tGetData() {
   vUpdate();
   return tSubWoofer_Multi;
};
tS32 dp_tclAudioManagerUsrDPSubWoofer_Multi::s32GetData(tS16& tSubWoofer_MultiParam) { 
   vUpdate();
   tSubWoofer_MultiParam = tSubWoofer_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPSubWoofer_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SubWoofer_Multi", (tS32)0x13e420ee);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPSubWoofer_Multi::operator>>(tS16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPSubWoofer_Multi::operator<<(tS16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPSubWoofer_Multi::s32SetData(tS16 &tSubWoofer_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tSubWoofer_Multi,(tVoid*)&tSubWoofer_MultiParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSubWoofer_MultiParam' in function 'dp_tclAudioManagerUsrDPSubWoofer_Multi::vSetData(tS16)' could be made const reference
tS32 dp_tclAudioManagerUsrDPSubWoofer_Multi::s32SetData(const tS16 &tSubWoofer_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tSubWoofer_Multi,(tVoid*)&tSubWoofer_MultiParam, sizeof(tS16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSubWoofer_MultiParam' in function 'dp_tclAudioManagerUsrDPSubWoofer_Multi::vSetData(tS16)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPSubWoofer_Multi::u8GetData(tS16& tSubWoofer_MultiParam) {  
   vUpdate();
   tSubWoofer_MultiParam = tSubWoofer_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPSubWoofer_Multi::vSetData(tS16 &tSubWoofer_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tSubWoofer_Multi,(tVoid*)&tSubWoofer_MultiParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tSubWoofer_MultiParam' in function 'dp_tclAudioManagerUsrDPSubWoofer_Multi::vSetData(tS16)' could be made const reference
tVoid dp_tclAudioManagerUsrDPSubWoofer_Multi::vSetData(const tS16 &tSubWoofer_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tSubWoofer_Multi,(tVoid*)&tSubWoofer_MultiParam, sizeof(tS16));
   vStore();
}//lint !e1746: parameter 'tSubWoofer_MultiParam' in function 'dp_tclAudioManagerUsrDPSubWoofer_Multi::vSetData(tS16)' could be made const reference
tU8   dp_tclAudioManagerUsrDPSubWoofer_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPSubWoofer_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "SubWoofer_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPSubWoofer_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "SubWoofer_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPSubWoofer_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SubWoofer_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element SubWoofer_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SurroundLevel_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPSurroundLevel_Multi::dp_tclAudioManagerUsrDPSurroundLevel_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSurroundLevel_Multi,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPSurroundLevel_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SurroundLevel_Multi",(tS32) 0xe956cb6c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSurroundLevel_Multi = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPSurroundLevel_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SurroundLevel_Multi", (tS32)0xe956cb6c);
   (tVoid)myDpElem.bFillData((tVoid*)&tSurroundLevel_Multi, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPSurroundLevel_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPSurroundLevel_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerUsrDPSurroundLevel_Multi::tGetData() {
   vUpdate();
   return tSurroundLevel_Multi;
};
tS32 dp_tclAudioManagerUsrDPSurroundLevel_Multi::s32GetData(tU8& tSurroundLevel_MultiParam) { 
   vUpdate();
   tSurroundLevel_MultiParam = tSurroundLevel_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPSurroundLevel_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SurroundLevel_Multi", (tS32)0xe956cb6c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPSurroundLevel_Multi::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPSurroundLevel_Multi::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPSurroundLevel_Multi::s32SetData(tU8 &tSurroundLevel_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tSurroundLevel_Multi,(tVoid*)&tSurroundLevel_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSurroundLevel_MultiParam' in function 'dp_tclAudioManagerUsrDPSurroundLevel_Multi::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPSurroundLevel_Multi::s32SetData(const tU8 &tSurroundLevel_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tSurroundLevel_Multi,(tVoid*)&tSurroundLevel_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSurroundLevel_MultiParam' in function 'dp_tclAudioManagerUsrDPSurroundLevel_Multi::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPSurroundLevel_Multi::u8GetData(tU8& tSurroundLevel_MultiParam) {  
   vUpdate();
   tSurroundLevel_MultiParam = tSurroundLevel_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPSurroundLevel_Multi::vSetData(tU8 &tSurroundLevel_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tSurroundLevel_Multi,(tVoid*)&tSurroundLevel_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSurroundLevel_MultiParam' in function 'dp_tclAudioManagerUsrDPSurroundLevel_Multi::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPSurroundLevel_Multi::vSetData(const tU8 &tSurroundLevel_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tSurroundLevel_Multi,(tVoid*)&tSurroundLevel_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSurroundLevel_MultiParam' in function 'dp_tclAudioManagerUsrDPSurroundLevel_Multi::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPSurroundLevel_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPSurroundLevel_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "SurroundLevel_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPSurroundLevel_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "SurroundLevel_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPSurroundLevel_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SurroundLevel_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element SurroundLevel_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BeepLevel_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPBeepLevel_Multi::dp_tclAudioManagerUsrDPBeepLevel_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBeepLevel_Multi,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPBeepLevel_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("BeepLevel_Multi",(tS32) 0xbe6b5b8a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tBeepLevel_Multi = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPBeepLevel_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("BeepLevel_Multi", (tS32)0xbe6b5b8a);
   (tVoid)myDpElem.bFillData((tVoid*)&tBeepLevel_Multi, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPBeepLevel_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPBeepLevel_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerUsrDPBeepLevel_Multi::tGetData() {
   vUpdate();
   return tBeepLevel_Multi;
};
tS32 dp_tclAudioManagerUsrDPBeepLevel_Multi::s32GetData(tU8& tBeepLevel_MultiParam) { 
   vUpdate();
   tBeepLevel_MultiParam = tBeepLevel_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPBeepLevel_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("BeepLevel_Multi", (tS32)0xbe6b5b8a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPBeepLevel_Multi::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPBeepLevel_Multi::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPBeepLevel_Multi::s32SetData(tU8 &tBeepLevel_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tBeepLevel_Multi,(tVoid*)&tBeepLevel_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBeepLevel_MultiParam' in function 'dp_tclAudioManagerUsrDPBeepLevel_Multi::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPBeepLevel_Multi::s32SetData(const tU8 &tBeepLevel_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tBeepLevel_Multi,(tVoid*)&tBeepLevel_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBeepLevel_MultiParam' in function 'dp_tclAudioManagerUsrDPBeepLevel_Multi::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPBeepLevel_Multi::u8GetData(tU8& tBeepLevel_MultiParam) {  
   vUpdate();
   tBeepLevel_MultiParam = tBeepLevel_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPBeepLevel_Multi::vSetData(tU8 &tBeepLevel_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tBeepLevel_Multi,(tVoid*)&tBeepLevel_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tBeepLevel_MultiParam' in function 'dp_tclAudioManagerUsrDPBeepLevel_Multi::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPBeepLevel_Multi::vSetData(const tU8 &tBeepLevel_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tBeepLevel_Multi,(tVoid*)&tBeepLevel_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tBeepLevel_MultiParam' in function 'dp_tclAudioManagerUsrDPBeepLevel_Multi::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPBeepLevel_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPBeepLevel_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "BeepLevel_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPBeepLevel_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "BeepLevel_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPBeepLevel_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BeepLevel_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element BeepLevel_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EquPreset_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPEquPreset_Multi::dp_tclAudioManagerUsrDPEquPreset_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEquPreset_Multi,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPEquPreset_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EquPreset_Multi",(tS32) 0xcaecd4c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tEquPreset_Multi = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPEquPreset_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EquPreset_Multi", (tS32)0xcaecd4c);
   (tVoid)myDpElem.bFillData((tVoid*)&tEquPreset_Multi, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPEquPreset_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPEquPreset_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerUsrDPEquPreset_Multi::tGetData() {
   vUpdate();
   return tEquPreset_Multi;
};
tS32 dp_tclAudioManagerUsrDPEquPreset_Multi::s32GetData(tU8& tEquPreset_MultiParam) { 
   vUpdate();
   tEquPreset_MultiParam = tEquPreset_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPEquPreset_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EquPreset_Multi", (tS32)0xcaecd4c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPEquPreset_Multi::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPEquPreset_Multi::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPEquPreset_Multi::s32SetData(tU8 &tEquPreset_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tEquPreset_Multi,(tVoid*)&tEquPreset_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEquPreset_MultiParam' in function 'dp_tclAudioManagerUsrDPEquPreset_Multi::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPEquPreset_Multi::s32SetData(const tU8 &tEquPreset_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tEquPreset_Multi,(tVoid*)&tEquPreset_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEquPreset_MultiParam' in function 'dp_tclAudioManagerUsrDPEquPreset_Multi::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPEquPreset_Multi::u8GetData(tU8& tEquPreset_MultiParam) {  
   vUpdate();
   tEquPreset_MultiParam = tEquPreset_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPEquPreset_Multi::vSetData(tU8 &tEquPreset_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tEquPreset_Multi,(tVoid*)&tEquPreset_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tEquPreset_MultiParam' in function 'dp_tclAudioManagerUsrDPEquPreset_Multi::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPEquPreset_Multi::vSetData(const tU8 &tEquPreset_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tEquPreset_Multi,(tVoid*)&tEquPreset_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tEquPreset_MultiParam' in function 'dp_tclAudioManagerUsrDPEquPreset_Multi::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPEquPreset_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPEquPreset_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "EquPreset_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPEquPreset_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "EquPreset_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPEquPreset_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EquPreset_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element EquPreset_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Optimization_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPOptimization_Multi::dp_tclAudioManagerUsrDPOptimization_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tOptimization_Multi,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPOptimization_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Optimization_Multi",(tS32) 0x528c9875);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tOptimization_Multi = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPOptimization_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Optimization_Multi", (tS32)0x528c9875);
   (tVoid)myDpElem.bFillData((tVoid*)&tOptimization_Multi, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPOptimization_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPOptimization_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerUsrDPOptimization_Multi::tGetData() {
   vUpdate();
   return tOptimization_Multi;
};
tS32 dp_tclAudioManagerUsrDPOptimization_Multi::s32GetData(tU8& tOptimization_MultiParam) { 
   vUpdate();
   tOptimization_MultiParam = tOptimization_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPOptimization_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Optimization_Multi", (tS32)0x528c9875);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPOptimization_Multi::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPOptimization_Multi::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPOptimization_Multi::s32SetData(tU8 &tOptimization_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tOptimization_Multi,(tVoid*)&tOptimization_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tOptimization_MultiParam' in function 'dp_tclAudioManagerUsrDPOptimization_Multi::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPOptimization_Multi::s32SetData(const tU8 &tOptimization_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tOptimization_Multi,(tVoid*)&tOptimization_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tOptimization_MultiParam' in function 'dp_tclAudioManagerUsrDPOptimization_Multi::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPOptimization_Multi::u8GetData(tU8& tOptimization_MultiParam) {  
   vUpdate();
   tOptimization_MultiParam = tOptimization_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPOptimization_Multi::vSetData(tU8 &tOptimization_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tOptimization_Multi,(tVoid*)&tOptimization_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tOptimization_MultiParam' in function 'dp_tclAudioManagerUsrDPOptimization_Multi::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPOptimization_Multi::vSetData(const tU8 &tOptimization_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tOptimization_Multi,(tVoid*)&tOptimization_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tOptimization_MultiParam' in function 'dp_tclAudioManagerUsrDPOptimization_Multi::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPOptimization_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPOptimization_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Optimization_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPOptimization_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Optimization_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPOptimization_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Optimization_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element Optimization_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Gala_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPGala_Multi::dp_tclAudioManagerUsrDPGala_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGala_Multi,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPGala_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Gala_Multi",(tS32) 0xb238aab);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tGala_Multi = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPGala_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Gala_Multi", (tS32)0xb238aab);
   (tVoid)myDpElem.bFillData((tVoid*)&tGala_Multi, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPGala_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPGala_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerUsrDPGala_Multi::tGetData() {
   vUpdate();
   return tGala_Multi;
};
tS32 dp_tclAudioManagerUsrDPGala_Multi::s32GetData(tU8& tGala_MultiParam) { 
   vUpdate();
   tGala_MultiParam = tGala_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPGala_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Gala_Multi", (tS32)0xb238aab);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPGala_Multi::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPGala_Multi::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPGala_Multi::s32SetData(tU8 &tGala_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tGala_Multi,(tVoid*)&tGala_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGala_MultiParam' in function 'dp_tclAudioManagerUsrDPGala_Multi::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPGala_Multi::s32SetData(const tU8 &tGala_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tGala_Multi,(tVoid*)&tGala_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGala_MultiParam' in function 'dp_tclAudioManagerUsrDPGala_Multi::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPGala_Multi::u8GetData(tU8& tGala_MultiParam) {  
   vUpdate();
   tGala_MultiParam = tGala_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPGala_Multi::vSetData(tU8 &tGala_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tGala_Multi,(tVoid*)&tGala_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tGala_MultiParam' in function 'dp_tclAudioManagerUsrDPGala_Multi::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPGala_Multi::vSetData(const tU8 &tGala_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tGala_Multi,(tVoid*)&tGala_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tGala_MultiParam' in function 'dp_tclAudioManagerUsrDPGala_Multi::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPGala_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPGala_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Gala_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPGala_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Gala_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPGala_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Gala_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element Gala_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Arkamys_AutomaticGainControl_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tArkamys_AutomaticGainControl_Multi,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Arkamys_AutomaticGainControl_Multi",(tS32) 0x4b806e8L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tArkamys_AutomaticGainControl_Multi = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Arkamys_AutomaticGainControl_Multi", (tS32)0x4b806e8L);
   (tVoid)myDpElem.bFillData((tVoid*)&tArkamys_AutomaticGainControl_Multi, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::tGetData() {
   vUpdate();
   return tArkamys_AutomaticGainControl_Multi;
};
tS32 dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::s32GetData(tBool& tArkamys_AutomaticGainControl_MultiParam) { 
   vUpdate();
   tArkamys_AutomaticGainControl_MultiParam = tArkamys_AutomaticGainControl_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Arkamys_AutomaticGainControl_Multi", (tS32)0x4b806e8L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::s32SetData(tBool &tArkamys_AutomaticGainControl_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tArkamys_AutomaticGainControl_Multi,(tVoid*)&tArkamys_AutomaticGainControl_MultiParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tArkamys_AutomaticGainControl_MultiParam' in function 'dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::vSetData(tBool)' could be made const reference
tS32 dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::s32SetData(const tBool &tArkamys_AutomaticGainControl_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tArkamys_AutomaticGainControl_Multi,(tVoid*)&tArkamys_AutomaticGainControl_MultiParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tArkamys_AutomaticGainControl_MultiParam' in function 'dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::u8GetData(tBool& tArkamys_AutomaticGainControl_MultiParam) {  
   vUpdate();
   tArkamys_AutomaticGainControl_MultiParam = tArkamys_AutomaticGainControl_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::vSetData(tBool &tArkamys_AutomaticGainControl_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tArkamys_AutomaticGainControl_Multi,(tVoid*)&tArkamys_AutomaticGainControl_MultiParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tArkamys_AutomaticGainControl_MultiParam' in function 'dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::vSetData(tBool)' could be made const reference
tVoid dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::vSetData(const tBool &tArkamys_AutomaticGainControl_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tArkamys_AutomaticGainControl_Multi,(tVoid*)&tArkamys_AutomaticGainControl_MultiParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tArkamys_AutomaticGainControl_MultiParam' in function 'dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::vSetData(tBool)' could be made const reference
tU8   dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Arkamys_AutomaticGainControl_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Arkamys_AutomaticGainControl_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPArkamys_AutomaticGainControl_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Arkamys_AutomaticGainControl_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element Arkamys_AutomaticGainControl_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RoomEffect_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPRoomEffect_Multi::dp_tclAudioManagerUsrDPRoomEffect_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRoomEffect_Multi,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPRoomEffect_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RoomEffect_Multi",(tS32) 0x342c2490);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tRoomEffect_Multi = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPRoomEffect_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RoomEffect_Multi", (tS32)0x342c2490);
   (tVoid)myDpElem.bFillData((tVoid*)&tRoomEffect_Multi, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPRoomEffect_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPRoomEffect_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerUsrDPRoomEffect_Multi::tGetData() {
   vUpdate();
   return tRoomEffect_Multi;
};
tS32 dp_tclAudioManagerUsrDPRoomEffect_Multi::s32GetData(tU8& tRoomEffect_MultiParam) { 
   vUpdate();
   tRoomEffect_MultiParam = tRoomEffect_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPRoomEffect_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RoomEffect_Multi", (tS32)0x342c2490);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPRoomEffect_Multi::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPRoomEffect_Multi::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPRoomEffect_Multi::s32SetData(tU8 &tRoomEffect_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tRoomEffect_Multi,(tVoid*)&tRoomEffect_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRoomEffect_MultiParam' in function 'dp_tclAudioManagerUsrDPRoomEffect_Multi::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPRoomEffect_Multi::s32SetData(const tU8 &tRoomEffect_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tRoomEffect_Multi,(tVoid*)&tRoomEffect_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRoomEffect_MultiParam' in function 'dp_tclAudioManagerUsrDPRoomEffect_Multi::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPRoomEffect_Multi::u8GetData(tU8& tRoomEffect_MultiParam) {  
   vUpdate();
   tRoomEffect_MultiParam = tRoomEffect_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPRoomEffect_Multi::vSetData(tU8 &tRoomEffect_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tRoomEffect_Multi,(tVoid*)&tRoomEffect_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRoomEffect_MultiParam' in function 'dp_tclAudioManagerUsrDPRoomEffect_Multi::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPRoomEffect_Multi::vSetData(const tU8 &tRoomEffect_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tRoomEffect_Multi,(tVoid*)&tRoomEffect_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tRoomEffect_MultiParam' in function 'dp_tclAudioManagerUsrDPRoomEffect_Multi::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPRoomEffect_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPRoomEffect_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "RoomEffect_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPRoomEffect_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "RoomEffect_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPRoomEffect_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RoomEffect_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element RoomEffect_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SoundStaging_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPSoundStaging_Multi::dp_tclAudioManagerUsrDPSoundStaging_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSoundStaging_Multi,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPSoundStaging_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SoundStaging_Multi",(tS32) 0xaa8e5ff4);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSoundStaging_Multi = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPSoundStaging_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SoundStaging_Multi", (tS32)0xaa8e5ff4);
   (tVoid)myDpElem.bFillData((tVoid*)&tSoundStaging_Multi, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPSoundStaging_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPSoundStaging_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerUsrDPSoundStaging_Multi::tGetData() {
   vUpdate();
   return tSoundStaging_Multi;
};
tS32 dp_tclAudioManagerUsrDPSoundStaging_Multi::s32GetData(tU8& tSoundStaging_MultiParam) { 
   vUpdate();
   tSoundStaging_MultiParam = tSoundStaging_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPSoundStaging_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SoundStaging_Multi", (tS32)0xaa8e5ff4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPSoundStaging_Multi::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPSoundStaging_Multi::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPSoundStaging_Multi::s32SetData(tU8 &tSoundStaging_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tSoundStaging_Multi,(tVoid*)&tSoundStaging_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSoundStaging_MultiParam' in function 'dp_tclAudioManagerUsrDPSoundStaging_Multi::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPSoundStaging_Multi::s32SetData(const tU8 &tSoundStaging_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tSoundStaging_Multi,(tVoid*)&tSoundStaging_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSoundStaging_MultiParam' in function 'dp_tclAudioManagerUsrDPSoundStaging_Multi::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPSoundStaging_Multi::u8GetData(tU8& tSoundStaging_MultiParam) {  
   vUpdate();
   tSoundStaging_MultiParam = tSoundStaging_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPSoundStaging_Multi::vSetData(tU8 &tSoundStaging_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tSoundStaging_Multi,(tVoid*)&tSoundStaging_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSoundStaging_MultiParam' in function 'dp_tclAudioManagerUsrDPSoundStaging_Multi::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPSoundStaging_Multi::vSetData(const tU8 &tSoundStaging_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tSoundStaging_Multi,(tVoid*)&tSoundStaging_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSoundStaging_MultiParam' in function 'dp_tclAudioManagerUsrDPSoundStaging_Multi::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPSoundStaging_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPSoundStaging_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "SoundStaging_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPSoundStaging_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "SoundStaging_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPSoundStaging_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SoundStaging_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element SoundStaging_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GeometryMode_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPGeometryMode_Multi::dp_tclAudioManagerUsrDPGeometryMode_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tGeometryMode_Multi,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPGeometryMode_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("GeometryMode_Multi",(tS32) 0xe4b788cb);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tGeometryMode_Multi = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPGeometryMode_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("GeometryMode_Multi", (tS32)0xe4b788cb);
   (tVoid)myDpElem.bFillData((tVoid*)&tGeometryMode_Multi, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPGeometryMode_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPGeometryMode_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerUsrDPGeometryMode_Multi::tGetData() {
   vUpdate();
   return tGeometryMode_Multi;
};
tS32 dp_tclAudioManagerUsrDPGeometryMode_Multi::s32GetData(tU8& tGeometryMode_MultiParam) { 
   vUpdate();
   tGeometryMode_MultiParam = tGeometryMode_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPGeometryMode_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("GeometryMode_Multi", (tS32)0xe4b788cb);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPGeometryMode_Multi::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPGeometryMode_Multi::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPGeometryMode_Multi::s32SetData(tU8 &tGeometryMode_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tGeometryMode_Multi,(tVoid*)&tGeometryMode_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGeometryMode_MultiParam' in function 'dp_tclAudioManagerUsrDPGeometryMode_Multi::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPGeometryMode_Multi::s32SetData(const tU8 &tGeometryMode_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tGeometryMode_Multi,(tVoid*)&tGeometryMode_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tGeometryMode_MultiParam' in function 'dp_tclAudioManagerUsrDPGeometryMode_Multi::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPGeometryMode_Multi::u8GetData(tU8& tGeometryMode_MultiParam) {  
   vUpdate();
   tGeometryMode_MultiParam = tGeometryMode_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPGeometryMode_Multi::vSetData(tU8 &tGeometryMode_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tGeometryMode_Multi,(tVoid*)&tGeometryMode_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tGeometryMode_MultiParam' in function 'dp_tclAudioManagerUsrDPGeometryMode_Multi::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPGeometryMode_Multi::vSetData(const tU8 &tGeometryMode_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tGeometryMode_Multi,(tVoid*)&tGeometryMode_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tGeometryMode_MultiParam' in function 'dp_tclAudioManagerUsrDPGeometryMode_Multi::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPGeometryMode_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPGeometryMode_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "GeometryMode_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPGeometryMode_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "GeometryMode_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPGeometryMode_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: GeometryMode_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element GeometryMode_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DAN_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPDAN_Multi::dp_tclAudioManagerUsrDPDAN_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDAN_Multi,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPDAN_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DAN_Multi",(tS32) 0x1faeef1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDAN_Multi = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPDAN_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DAN_Multi", (tS32)0x1faeef1);
   (tVoid)myDpElem.bFillData((tVoid*)&tDAN_Multi, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPDAN_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPDAN_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerUsrDPDAN_Multi::tGetData() {
   vUpdate();
   return tDAN_Multi;
};
tS32 dp_tclAudioManagerUsrDPDAN_Multi::s32GetData(tU8& tDAN_MultiParam) { 
   vUpdate();
   tDAN_MultiParam = tDAN_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPDAN_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DAN_Multi", (tS32)0x1faeef1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPDAN_Multi::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPDAN_Multi::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPDAN_Multi::s32SetData(tU8 &tDAN_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tDAN_Multi,(tVoid*)&tDAN_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAN_MultiParam' in function 'dp_tclAudioManagerUsrDPDAN_Multi::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPDAN_Multi::s32SetData(const tU8 &tDAN_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tDAN_Multi,(tVoid*)&tDAN_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDAN_MultiParam' in function 'dp_tclAudioManagerUsrDPDAN_Multi::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPDAN_Multi::u8GetData(tU8& tDAN_MultiParam) {  
   vUpdate();
   tDAN_MultiParam = tDAN_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPDAN_Multi::vSetData(tU8 &tDAN_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tDAN_Multi,(tVoid*)&tDAN_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAN_MultiParam' in function 'dp_tclAudioManagerUsrDPDAN_Multi::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPDAN_Multi::vSetData(const tU8 &tDAN_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tDAN_Multi,(tVoid*)&tDAN_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDAN_MultiParam' in function 'dp_tclAudioManagerUsrDPDAN_Multi::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPDAN_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPDAN_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "DAN_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPDAN_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "DAN_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPDAN_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DAN_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element DAN_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Adas_ParkAssitVol_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAdas_ParkAssitVol_Multi,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Adas_ParkAssitVol_Multi",(tS32) 0x700d4e65);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAdas_ParkAssitVol_Multi = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Adas_ParkAssitVol_Multi", (tS32)0x700d4e65);
   (tVoid)myDpElem.bFillData((tVoid*)&tAdas_ParkAssitVol_Multi, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::tGetData() {
   vUpdate();
   return tAdas_ParkAssitVol_Multi;
};
tS32 dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::s32GetData(tU8& tAdas_ParkAssitVol_MultiParam) { 
   vUpdate();
   tAdas_ParkAssitVol_MultiParam = tAdas_ParkAssitVol_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Adas_ParkAssitVol_Multi", (tS32)0x700d4e65);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::s32SetData(tU8 &tAdas_ParkAssitVol_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_ParkAssitVol_Multi,(tVoid*)&tAdas_ParkAssitVol_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_ParkAssitVol_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::s32SetData(const tU8 &tAdas_ParkAssitVol_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_ParkAssitVol_Multi,(tVoid*)&tAdas_ParkAssitVol_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_ParkAssitVol_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::u8GetData(tU8& tAdas_ParkAssitVol_MultiParam) {  
   vUpdate();
   tAdas_ParkAssitVol_MultiParam = tAdas_ParkAssitVol_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::vSetData(tU8 &tAdas_ParkAssitVol_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_ParkAssitVol_Multi,(tVoid*)&tAdas_ParkAssitVol_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_ParkAssitVol_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::vSetData(const tU8 &tAdas_ParkAssitVol_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_ParkAssitVol_Multi,(tVoid*)&tAdas_ParkAssitVol_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_ParkAssitVol_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Adas_ParkAssitVol_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Adas_ParkAssitVol_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPAdas_ParkAssitVol_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Adas_ParkAssitVol_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element Adas_ParkAssitVol_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Adas_LDWUSerVol_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAdas_LDWUSerVol_Multi,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Adas_LDWUSerVol_Multi",(tS32) 0x120c2ba9);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAdas_LDWUSerVol_Multi = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Adas_LDWUSerVol_Multi", (tS32)0x120c2ba9);
   (tVoid)myDpElem.bFillData((tVoid*)&tAdas_LDWUSerVol_Multi, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::tGetData() {
   vUpdate();
   return tAdas_LDWUSerVol_Multi;
};
tS32 dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::s32GetData(tU8& tAdas_LDWUSerVol_MultiParam) { 
   vUpdate();
   tAdas_LDWUSerVol_MultiParam = tAdas_LDWUSerVol_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Adas_LDWUSerVol_Multi", (tS32)0x120c2ba9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::s32SetData(tU8 &tAdas_LDWUSerVol_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_LDWUSerVol_Multi,(tVoid*)&tAdas_LDWUSerVol_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_LDWUSerVol_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::s32SetData(const tU8 &tAdas_LDWUSerVol_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_LDWUSerVol_Multi,(tVoid*)&tAdas_LDWUSerVol_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_LDWUSerVol_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::u8GetData(tU8& tAdas_LDWUSerVol_MultiParam) {  
   vUpdate();
   tAdas_LDWUSerVol_MultiParam = tAdas_LDWUSerVol_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::vSetData(tU8 &tAdas_LDWUSerVol_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_LDWUSerVol_Multi,(tVoid*)&tAdas_LDWUSerVol_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_LDWUSerVol_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::vSetData(const tU8 &tAdas_LDWUSerVol_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_LDWUSerVol_Multi,(tVoid*)&tAdas_LDWUSerVol_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_LDWUSerVol_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Adas_LDWUSerVol_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Adas_LDWUSerVol_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPAdas_LDWUSerVol_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Adas_LDWUSerVol_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element Adas_LDWUSerVol_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AudioPilotMode_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPAudioPilotMode_Multi::dp_tclAudioManagerUsrDPAudioPilotMode_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAudioPilotMode_Multi,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPAudioPilotMode_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AudioPilotMode_Multi",(tS32) 0xb9361dbd);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tAudioPilotMode_Multi = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPAudioPilotMode_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AudioPilotMode_Multi", (tS32)0xb9361dbd);
   (tVoid)myDpElem.bFillData((tVoid*)&tAudioPilotMode_Multi, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPAudioPilotMode_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPAudioPilotMode_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclAudioManagerUsrDPAudioPilotMode_Multi::tGetData() {
   vUpdate();
   return tAudioPilotMode_Multi;
};
tS32 dp_tclAudioManagerUsrDPAudioPilotMode_Multi::s32GetData(tBool& tAudioPilotMode_MultiParam) { 
   vUpdate();
   tAudioPilotMode_MultiParam = tAudioPilotMode_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPAudioPilotMode_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AudioPilotMode_Multi", (tS32)0xb9361dbd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPAudioPilotMode_Multi::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPAudioPilotMode_Multi::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPAudioPilotMode_Multi::s32SetData(tBool &tAudioPilotMode_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tAudioPilotMode_Multi,(tVoid*)&tAudioPilotMode_MultiParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioPilotMode_MultiParam' in function 'dp_tclAudioManagerUsrDPAudioPilotMode_Multi::vSetData(tBool)' could be made const reference
tS32 dp_tclAudioManagerUsrDPAudioPilotMode_Multi::s32SetData(const tBool &tAudioPilotMode_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tAudioPilotMode_Multi,(tVoid*)&tAudioPilotMode_MultiParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioPilotMode_MultiParam' in function 'dp_tclAudioManagerUsrDPAudioPilotMode_Multi::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPAudioPilotMode_Multi::u8GetData(tBool& tAudioPilotMode_MultiParam) {  
   vUpdate();
   tAudioPilotMode_MultiParam = tAudioPilotMode_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPAudioPilotMode_Multi::vSetData(tBool &tAudioPilotMode_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioPilotMode_Multi,(tVoid*)&tAudioPilotMode_MultiParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tAudioPilotMode_MultiParam' in function 'dp_tclAudioManagerUsrDPAudioPilotMode_Multi::vSetData(tBool)' could be made const reference
tVoid dp_tclAudioManagerUsrDPAudioPilotMode_Multi::vSetData(const tBool &tAudioPilotMode_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioPilotMode_Multi,(tVoid*)&tAudioPilotMode_MultiParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tAudioPilotMode_MultiParam' in function 'dp_tclAudioManagerUsrDPAudioPilotMode_Multi::vSetData(tBool)' could be made const reference
tU8   dp_tclAudioManagerUsrDPAudioPilotMode_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPAudioPilotMode_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "AudioPilotMode_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPAudioPilotMode_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "AudioPilotMode_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPAudioPilotMode_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AudioPilotMode_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element AudioPilotMode_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AudioPilotIntensity_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAudioPilotIntensity_Multi,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AudioPilotIntensity_Multi",(tS32) 0xdf6593db);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAudioPilotIntensity_Multi = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AudioPilotIntensity_Multi", (tS32)0xdf6593db);
   (tVoid)myDpElem.bFillData((tVoid*)&tAudioPilotIntensity_Multi, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::tGetData() {
   vUpdate();
   return tAudioPilotIntensity_Multi;
};
tS32 dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::s32GetData(tU8& tAudioPilotIntensity_MultiParam) { 
   vUpdate();
   tAudioPilotIntensity_MultiParam = tAudioPilotIntensity_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AudioPilotIntensity_Multi", (tS32)0xdf6593db);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::s32SetData(tU8 &tAudioPilotIntensity_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tAudioPilotIntensity_Multi,(tVoid*)&tAudioPilotIntensity_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioPilotIntensity_MultiParam' in function 'dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::s32SetData(const tU8 &tAudioPilotIntensity_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tAudioPilotIntensity_Multi,(tVoid*)&tAudioPilotIntensity_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioPilotIntensity_MultiParam' in function 'dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::u8GetData(tU8& tAudioPilotIntensity_MultiParam) {  
   vUpdate();
   tAudioPilotIntensity_MultiParam = tAudioPilotIntensity_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::vSetData(tU8 &tAudioPilotIntensity_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioPilotIntensity_Multi,(tVoid*)&tAudioPilotIntensity_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAudioPilotIntensity_MultiParam' in function 'dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::vSetData(const tU8 &tAudioPilotIntensity_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioPilotIntensity_Multi,(tVoid*)&tAudioPilotIntensity_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAudioPilotIntensity_MultiParam' in function 'dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "AudioPilotIntensity_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "AudioPilotIntensity_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPAudioPilotIntensity_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AudioPilotIntensity_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element AudioPilotIntensity_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Adas_UPASoundtype_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAdas_UPASoundtype_Multi,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Adas_UPASoundtype_Multi",(tS32) 0x8164ae83);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAdas_UPASoundtype_Multi = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Adas_UPASoundtype_Multi", (tS32)0x8164ae83);
   (tVoid)myDpElem.bFillData((tVoid*)&tAdas_UPASoundtype_Multi, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::tGetData() {
   vUpdate();
   return tAdas_UPASoundtype_Multi;
};
tS32 dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::s32GetData(tU8& tAdas_UPASoundtype_MultiParam) { 
   vUpdate();
   tAdas_UPASoundtype_MultiParam = tAdas_UPASoundtype_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Adas_UPASoundtype_Multi", (tS32)0x8164ae83);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::s32SetData(tU8 &tAdas_UPASoundtype_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_UPASoundtype_Multi,(tVoid*)&tAdas_UPASoundtype_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_UPASoundtype_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::s32SetData(const tU8 &tAdas_UPASoundtype_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_UPASoundtype_Multi,(tVoid*)&tAdas_UPASoundtype_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_UPASoundtype_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::u8GetData(tU8& tAdas_UPASoundtype_MultiParam) {  
   vUpdate();
   tAdas_UPASoundtype_MultiParam = tAdas_UPASoundtype_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::vSetData(tU8 &tAdas_UPASoundtype_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_UPASoundtype_Multi,(tVoid*)&tAdas_UPASoundtype_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_UPASoundtype_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::vSetData(const tU8 &tAdas_UPASoundtype_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_UPASoundtype_Multi,(tVoid*)&tAdas_UPASoundtype_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_UPASoundtype_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Adas_UPASoundtype_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Adas_UPASoundtype_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPAdas_UPASoundtype_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Adas_UPASoundtype_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element Adas_UPASoundtype_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Adas_SRSoundState_Multi"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAdas_SRSoundState_Multi,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Adas_SRSoundState_Multi",(tS32) 0x211f2f99);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAdas_SRSoundState_Multi = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Adas_SRSoundState_Multi", (tS32)0x211f2f99);
   (tVoid)myDpElem.bFillData((tVoid*)&tAdas_SRSoundState_Multi, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::tGetData() {
   vUpdate();
   return tAdas_SRSoundState_Multi;
};
tS32 dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::s32GetData(tU8& tAdas_SRSoundState_MultiParam) { 
   vUpdate();
   tAdas_SRSoundState_MultiParam = tAdas_SRSoundState_Multi;
   return _s32Status;
}
tS32 dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Adas_SRSoundState_Multi", (tS32)0x211f2f99);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::s32SetData(tU8 &tAdas_SRSoundState_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_SRSoundState_Multi,(tVoid*)&tAdas_SRSoundState_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_SRSoundState_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::vSetData(tU8)' could be made const reference
tS32 dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::s32SetData(const tU8 &tAdas_SRSoundState_MultiParam) {
   //init parameter
   (tVoid)memcpy(&tAdas_SRSoundState_Multi,(tVoid*)&tAdas_SRSoundState_MultiParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdas_SRSoundState_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::u8GetData(tU8& tAdas_SRSoundState_MultiParam) {  
   vUpdate();
   tAdas_SRSoundState_MultiParam = tAdas_SRSoundState_Multi;
   return _u8DataStatus;
}
tVoid dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::vSetData(tU8 &tAdas_SRSoundState_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_SRSoundState_Multi,(tVoid*)&tAdas_SRSoundState_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_SRSoundState_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::vSetData(tU8)' could be made const reference
tVoid dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::vSetData(const tU8 &tAdas_SRSoundState_MultiParam) { 
   //init parameter
   (tVoid)memcpy(&tAdas_SRSoundState_Multi,(tVoid*)&tAdas_SRSoundState_MultiParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdas_SRSoundState_MultiParam' in function 'dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::vSetData(tU8)' could be made const reference
tU8   dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Adas_SRSoundState_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_AUDIOMANAGERUSRDP, "Adas_SRSoundState_Multi", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAudioManagerUsrDPAdas_SRSoundState_Multi::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Adas_SRSoundState_Multi", DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_AUDIOMANAGERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element Adas_SRSoundState_Multi has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
