#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"


//lint -e750
#define FC_AUDIOMANAGER_S_IMPORT_INTERFACE_DP_FC_AUDIOMANAGER 
#include "fc_audiomanager_if.h"
//lint +e750


#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"

tVoid vInitAudioManagerDP(tU8 u8Bank)
{
   dp_tclDatapool* pDp = dp_tclDatapool::pGetInstance();
   u8Bank=DP_U8_NO_BANK_ACTION;
   if (pDp) pDp->vInitDp(DP_U32_POOL_ID_AUDIOMANAGERDP, "AudioManagerDP",0x0001,eDpLocation_FILE_SYSTEM,u8Bank,eDpModeEndUserNo);  

   {
      dp_tclBaseElement myADR3_ConfBalanceElem("ADR3_ConfBalance", (tU8)ADRCONFIG_BalanceDataVersion, (tS32)0xfc873ba5, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfBalance[]={ADRCONFIG_Balance};     
     tVoid*   vptADR3_ConfBalance=(tVoid*)&tADR3_ConfBalance[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfBalance)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfBalanceElem.bSetDefaultData(vptADR3_ConfBalance, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfBalanceElem.bFillData(vptADR3_ConfBalance, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfBalanceElem);
   }

   {
      dp_tclBaseElement myADR3_ConfBassElem("ADR3_ConfBass", (tU8)ADRCONFIG_BassDataVersion, (tS32)0xb019a884, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfBass[]={ADRCONFIG_Bass};     
     tVoid*   vptADR3_ConfBass=(tVoid*)&tADR3_ConfBass[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfBass)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfBassElem.bSetDefaultData(vptADR3_ConfBass, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfBassElem.bFillData(vptADR3_ConfBass, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfBassElem);
   }

   {
      dp_tclBaseElement myADR3_Conf_SD_BassElem("ADR3_Conf_SD_Bass", (tU8)ADRCONFIG_SDBassDataVersion, (tS32)0xeec163b5, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_Conf_SD_Bass[]={ADRCONFIG_SDBass};     
     tVoid*   vptADR3_Conf_SD_Bass=(tVoid*)&tADR3_Conf_SD_Bass[0]; 
      tU32     u16ArraySize = sizeof(tADR3_Conf_SD_Bass)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_Conf_SD_BassElem.bSetDefaultData(vptADR3_Conf_SD_Bass, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_Conf_SD_BassElem.bFillData(vptADR3_Conf_SD_Bass, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_Conf_SD_BassElem);
   }

   {
      dp_tclBaseElement myADR3_ConfMidRangeElem("ADR3_ConfMidRange", (tU8)ADRCONFIG_MidrangeDataVersion, (tS32)0xeeb2a452, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfMidRange[]={ADRCONFIG_Midrange};     
     tVoid*   vptADR3_ConfMidRange=(tVoid*)&tADR3_ConfMidRange[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfMidRange)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfMidRangeElem.bSetDefaultData(vptADR3_ConfMidRange, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfMidRangeElem.bFillData(vptADR3_ConfMidRange, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfMidRangeElem);
   }

   {
      dp_tclBaseElement myADR3_ConfFaderElem("ADR3_ConfFader", (tU8)ADRCONFIG_FaderDataVersion, (tS32)0x7080530d, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfFader[]={ADRCONFIG_Fader};     
     tVoid*   vptADR3_ConfFader=(tVoid*)&tADR3_ConfFader[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfFader)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfFaderElem.bSetDefaultData(vptADR3_ConfFader, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfFaderElem.bFillData(vptADR3_ConfFader, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfFaderElem);
   }

   {
      dp_tclBaseElement myADR3_ConfLoudnessElem("ADR3_ConfLoudness", (tU8)ADRCONFIG_LoudnessDataVersion, (tS32)0xeeb3e294, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfLoudness[]={ADRCONFIG_Loudness};     
     tVoid*   vptADR3_ConfLoudness=(tVoid*)&tADR3_ConfLoudness[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfLoudness)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfLoudnessElem.bSetDefaultData(vptADR3_ConfLoudness, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfLoudnessElem.bFillData(vptADR3_ConfLoudness, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfLoudnessElem);
   }

   {
      dp_tclBaseElement myADR3_ConfTrebleElem("ADR3_ConfTreble", (tU8)ADRCONFIG_TrebleDataVersion, (tS32)0x32827421, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfTreble[]={ADRCONFIG_Treble};     
     tVoid*   vptADR3_ConfTreble=(tVoid*)&tADR3_ConfTreble[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfTreble)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfTrebleElem.bSetDefaultData(vptADR3_ConfTreble, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfTrebleElem.bFillData(vptADR3_ConfTreble, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfTrebleElem);
   }

   {
      dp_tclBaseElement myADR3_Conf_SD_TrebleElem("ADR3_Conf_SD_Treble", (tU8)ADRCONFIG_SDTrebleDataVersion, (tS32)0x50e3bbea, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_Conf_SD_Treble[]={ADRCONFIG_SDTreble};     
     tVoid*   vptADR3_Conf_SD_Treble=(tVoid*)&tADR3_Conf_SD_Treble[0]; 
      tU32     u16ArraySize = sizeof(tADR3_Conf_SD_Treble)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_Conf_SD_TrebleElem.bSetDefaultData(vptADR3_Conf_SD_Treble, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_Conf_SD_TrebleElem.bFillData(vptADR3_Conf_SD_Treble, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_Conf_SD_TrebleElem);
   }

   {
      dp_tclBaseElement myADR3_ConfSrcOffsetElem("ADR3_ConfSrcOffset", (tU8)ADRCONFIG_srcoffsetDataVersion, (tS32)0xa9ab5bba, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfSrcOffset[]={ADRCONFIG_srcoffset};     
     tVoid*   vptADR3_ConfSrcOffset=(tVoid*)&tADR3_ConfSrcOffset[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfSrcOffset)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfSrcOffsetElem.bSetDefaultData(vptADR3_ConfSrcOffset, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfSrcOffsetElem.bFillData(vptADR3_ConfSrcOffset, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfSrcOffsetElem);
   }

   {
      dp_tclBaseElement myADR3_ConfDelayElem("ADR3_ConfDelay", (tU8)DelayDataVersion, (tS32)0x708050da, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfDelay[]={Delay};     
     tVoid*   vptADR3_ConfDelay=(tVoid*)&tADR3_ConfDelay[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfDelay)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfDelayElem.bSetDefaultData(vptADR3_ConfDelay, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfDelayElem.bFillData(vptADR3_ConfDelay, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfDelayElem);
   }

   {
      dp_tclBaseElement myADR3_ConfEquElem("ADR3_ConfEqu", (tU8)EqualizerDataVersion, (tS32)0xf005223a, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfEqu[]={Equalizer};     
     tVoid*   vptADR3_ConfEqu=(tVoid*)&tADR3_ConfEqu[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfEqu)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfEquElem.bSetDefaultData(vptADR3_ConfEqu, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfEquElem.bFillData(vptADR3_ConfEqu, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfEquElem);
   }

   {
      dp_tclBaseElement myEngineeringDataElem("EngineeringData", (tU8)0x01, (tS32)0xacd614f5, sizeof(tS32), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tS32     tEngineeringData[]={Inputgainoffset};     
     tVoid*   vptEngineeringData=(tVoid*)&tEngineeringData[0]; 
      tU32     u16ArraySize = sizeof(tEngineeringData)/sizeof(tS32);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myEngineeringDataElem.bSetDefaultData(vptEngineeringData, ((tU32)sizeof(tS32))*u16ArraySize);
          (tVoid)myEngineeringDataElem.bFillData(vptEngineeringData, ((tU32)sizeof(tS32))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myEngineeringDataElem);
   }

   {      
      dp_tclBaseElement mySoundToolFlagElem("SoundToolFlag", (tU8)0x01, (tS32)0x4e9e4e85, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tSoundToolFlag = {0};
      
         
      (tVoid)mySoundToolFlagElem.bSetDefaultData((tVoid*)&tSoundToolFlag, (tU32)sizeof(tU8));
      (tVoid)mySoundToolFlagElem.bFillData((tVoid*)&tSoundToolFlag, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &mySoundToolFlagElem);
   }

   {
      dp_tclBaseElement myADR3_ConfSddcElem("ADR3_ConfSddc", (tU8)ADRCONFIG_sddcDataVersion, (tS32)0xb019b0c1, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfSddc[]={ADRCONFIG_sddc};     
     tVoid*   vptADR3_ConfSddc=(tVoid*)&tADR3_ConfSddc[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfSddc)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfSddcElem.bSetDefaultData(vptADR3_ConfSddc, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfSddcElem.bFillData(vptADR3_ConfSddc, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfSddcElem);
   }

   {
      dp_tclBaseElement myADR3_ConfSdvcElem("ADR3_ConfSdvc", (tU8)ADRCONFIG_sdvcDataVersion, (tS32)0xb019b11b, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfSdvc[]={ADRCONFIG_sdvc};     
     tVoid*   vptADR3_ConfSdvc=(tVoid*)&tADR3_ConfSdvc[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfSdvc)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfSdvcElem.bSetDefaultData(vptADR3_ConfSdvc, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfSdvcElem.bFillData(vptADR3_ConfSdvc, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfSdvcElem);
   }

   {
      dp_tclBaseElement myADR3_ConfSrcOffsetInElem("ADR3_ConfSrcOffsetIn", (tU8)ADRCONFIG_srcoffsetinDataVersion, (tS32)0x91bbf705, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfSrcOffsetIn[]={ADRCONFIG_srcoffsetin};     
     tVoid*   vptADR3_ConfSrcOffsetIn=(tVoid*)&tADR3_ConfSrcOffsetIn[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfSrcOffsetIn)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfSrcOffsetInElem.bSetDefaultData(vptADR3_ConfSrcOffsetIn, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfSrcOffsetInElem.bFillData(vptADR3_ConfSrcOffsetIn, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfSrcOffsetInElem);
   }

   {
      dp_tclBaseElement myADR3_ConfSrcOffsetOutElem("ADR3_ConfSrcOffsetOut", (tU8)ADRCONFIG_srcoffsetoutDataVersion, (tS32)0xd8abd446, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfSrcOffsetOut[]={ADRCONFIG_srcoffsetout};     
     tVoid*   vptADR3_ConfSrcOffsetOut=(tVoid*)&tADR3_ConfSrcOffsetOut[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfSrcOffsetOut)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfSrcOffsetOutElem.bSetDefaultData(vptADR3_ConfSrcOffsetOut, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfSrcOffsetOutElem.bFillData(vptADR3_ConfSrcOffsetOut, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfSrcOffsetOutElem);
   }

   {
      dp_tclBaseElement myADR3_ConfLoudnessHighElem("ADR3_ConfLoudnessHigh", (tU8)ADRCONFIG_LoudnessHighDataVersion, (tS32)0xc52c5b28, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfLoudnessHigh[]={ADRCONFIG_LoudnessHigh};     
     tVoid*   vptADR3_ConfLoudnessHigh=(tVoid*)&tADR3_ConfLoudnessHigh[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfLoudnessHigh)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfLoudnessHighElem.bSetDefaultData(vptADR3_ConfLoudnessHigh, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfLoudnessHighElem.bFillData(vptADR3_ConfLoudnessHigh, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfLoudnessHighElem);
   }

   {
      dp_tclBaseElement myADR3_ConfPreMixElem("ADR3_ConfPreMix", (tU8)ADRCONFIG_PreMixDataVersion, (tS32)0x32824144, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfPreMix[]={ADRCONFIG_PreMix};     
     tVoid*   vptADR3_ConfPreMix=(tVoid*)&tADR3_ConfPreMix[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfPreMix)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfPreMixElem.bSetDefaultData(vptADR3_ConfPreMix, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfPreMixElem.bFillData(vptADR3_ConfPreMix, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfPreMixElem);
   }

   {
      dp_tclBaseElement myADR3_ConfSDFCElem("ADR3_ConfSDFC", (tU8)ADRCONFIG_SDFCDataVersion, (tS32)0xb019aceb, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfSDFC[]={ADRCONFIG_SDFC};     
     tVoid*   vptADR3_ConfSDFC=(tVoid*)&tADR3_ConfSDFC[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfSDFC)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfSDFCElem.bSetDefaultData(vptADR3_ConfSDFC, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfSDFCElem.bFillData(vptADR3_ConfSDFC, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfSDFCElem);
   }

   {
      dp_tclBaseElement myADR3_ConfOutputPhaseElem("ADR3_ConfOutputPhase", (tU8)ADRCONFIG_OutputPhaseDataVersion, (tS32)0x9051e76d, sizeof(tU8), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    tU8     tADR3_ConfOutputPhase[]={ADRCONFIG_OutputPhase};     
     tVoid*   vptADR3_ConfOutputPhase=(tVoid*)&tADR3_ConfOutputPhase[0]; 
      tU32     u16ArraySize = sizeof(tADR3_ConfOutputPhase)/sizeof(tU8);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myADR3_ConfOutputPhaseElem.bSetDefaultData(vptADR3_ConfOutputPhase, ((tU32)sizeof(tU8))*u16ArraySize);
          (tVoid)myADR3_ConfOutputPhaseElem.bFillData(vptADR3_ConfOutputPhase, ((tU32)sizeof(tU8))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myADR3_ConfOutputPhaseElem);
   }

   {      
      dp_tclBaseElement myTrebleElem("Treble", (tU8)0x01, (tS32)0x5551a, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tTreble = {TrebleDefault_Value};
      
         
      (tVoid)myTrebleElem.bSetDefaultData((tVoid*)&tTreble, (tU32)sizeof(tS8));
      (tVoid)myTrebleElem.bFillData((tVoid*)&tTreble, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myTrebleElem);
   }

   {      
      dp_tclBaseElement myBassElem("Bass", (tU8)0x01, (tS32)0x2c65, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tBass = {BassDefault_Value};
      
         
      (tVoid)myBassElem.bSetDefaultData((tVoid*)&tBass, (tU32)sizeof(tS8));
      (tVoid)myBassElem.bFillData((tVoid*)&tBass, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myBassElem);
   }

   {      
      dp_tclBaseElement myMidRangeElem("MidRange", (tU8)0x01, (tS32)0x7a9ca3, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tMidRange = {MidRangeDefault_Value};
      
         
      (tVoid)myMidRangeElem.bSetDefaultData((tVoid*)&tMidRange, (tU32)sizeof(tS8));
      (tVoid)myMidRangeElem.bFillData((tVoid*)&tMidRange, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myMidRangeElem);
   }

   {      
      dp_tclBaseElement myFaderElem("Fader", (tU8)0x01, (tS32)0xe672, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tFader = {FaderDefault_Value};
      
         
      (tVoid)myFaderElem.bSetDefaultData((tVoid*)&tFader, (tU32)sizeof(tS8));
      (tVoid)myFaderElem.bFillData((tVoid*)&tFader, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myFaderElem);
   }

   {      
      dp_tclBaseElement myBalanceElem("Balance", (tU8)0x01, (tS32)0x15a082, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tBalance = {BalanceDefault_Value};
      
         
      (tVoid)myBalanceElem.bSetDefaultData((tVoid*)&tBalance, (tU32)sizeof(tS8));
      (tVoid)myBalanceElem.bFillData((tVoid*)&tBalance, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myBalanceElem);
   }

   {      
      dp_tclBaseElement myGalaElem("Gala", (tU8)GalaDef_Version, (tS32)0x2ea1, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tGala = {GalaDefault_Value};
      
      DP_s32GetConfigItem("SystemConfiguration1","SpeedCurve",(tU8*)&tGala, sizeof(tU8),FALSE);   
      (tVoid)myGalaElem.bSetDefaultData((tVoid*)&tGala, (tU32)sizeof(tU8));
      (tVoid)myGalaElem.bFillData((tVoid*)&tGala, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myGalaElem);
   }

   {      
      dp_tclBaseElement myPSA_GalaElem("PSA_Gala", (tU8)GalaDef_Version, (tS32)0x775800, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_TEF);      
      
     tU8 tPSA_Gala = {GalaDefault_Value};
      
         
      (tVoid)myPSA_GalaElem.bSetDefaultData((tVoid*)&tPSA_Gala, (tU32)sizeof(tU8));
      (tVoid)myPSA_GalaElem.bFillData((tVoid*)&tPSA_Gala, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myPSA_GalaElem);
   }

   {      
      dp_tclBaseElement myAuxInLevelElem("AuxInLevel", (tU8)0x01, (tS32)0xaf132b1, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tAuxInLevel = {AuxInLevelDefault_Value};
      
         
      (tVoid)myAuxInLevelElem.bSetDefaultData((tVoid*)&tAuxInLevel, (tU32)sizeof(tU8));
      (tVoid)myAuxInLevelElem.bFillData((tVoid*)&tAuxInLevel, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myAuxInLevelElem);
   }

   {      
      dp_tclBaseElement myBeepLevelElem("BeepLevel", (tU8)0x01, (tS32)0x2202f48, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tBeepLevel = {BeepLevelDefault};
      
         
      (tVoid)myBeepLevelElem.bSetDefaultData((tVoid*)&tBeepLevel, (tU32)sizeof(tU8));
      (tVoid)myBeepLevelElem.bFillData((tVoid*)&tBeepLevel, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myBeepLevelElem);
   }

   {      
      dp_tclBaseElement myRearMuteElem("RearMute", (tU8)0x01, (tS32)0x7fbf0d, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tRearMute = {0xff};
      
         
      (tVoid)myRearMuteElem.bSetDefaultData((tVoid*)&tRearMute, (tU32)sizeof(tU8));
      (tVoid)myRearMuteElem.bFillData((tVoid*)&tRearMute, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myRearMuteElem);
   }

   {      
      dp_tclBaseElement myEntOnVolumeSetElem("EntOnVolumeSet", (tU8)0x01, (tS32)0x6c29846c, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tEntOnVolumeSet = {EntVolumeDefault};
      
         
      (tVoid)myEntOnVolumeSetElem.bSetDefaultData((tVoid*)&tEntOnVolumeSet, (tU32)sizeof(tU8));
      (tVoid)myEntOnVolumeSetElem.bFillData((tVoid*)&tEntOnVolumeSet, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myEntOnVolumeSetElem);
   }

   {      
      dp_tclBaseElement myMinimumOnVolLimitElem("MinimumOnVolLimit", (tU8)0x01, (tS32)0xa4bc5ad1, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tMinimumOnVolLimit = {MinimumOnVolLimit};
      
         
      (tVoid)myMinimumOnVolLimitElem.bSetDefaultData((tVoid*)&tMinimumOnVolLimit, (tU32)sizeof(tU8));
      (tVoid)myMinimumOnVolLimitElem.bFillData((tVoid*)&tMinimumOnVolLimit, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myMinimumOnVolLimitElem);
   }

   {      
      dp_tclBaseElement myGeometryModeElem("GeometryMode", (tU8)0x01, (tS32)0x197de3c1, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tGeometryMode = {0x00};
      
         
      (tVoid)myGeometryModeElem.bSetDefaultData((tVoid*)&tGeometryMode, (tU32)sizeof(tU8));
      (tVoid)myGeometryModeElem.bFillData((tVoid*)&tGeometryMode, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myGeometryModeElem);
   }

   {      
      dp_tclBaseElement myLoudnessElem("Loudness", (tU8)0x01, (tS32)0x7bdae5, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tLoudness = {LoudnessDefault_Value};
      
         
      (tVoid)myLoudnessElem.bSetDefaultData((tVoid*)&tLoudness, (tU32)sizeof(tU8));
      (tVoid)myLoudnessElem.bFillData((tVoid*)&tLoudness, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myLoudnessElem);
   }

   {      
      dp_tclBaseElement myLoudness_TEFElem("Loudness_TEF", (tU8)0x01, (tS32)0x2e61a14b, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tLoudness_TEF = {LoudnessDefault_Value};
      
         
      (tVoid)myLoudness_TEFElem.bSetDefaultData((tVoid*)&tLoudness_TEF, (tU32)sizeof(tU8));
      (tVoid)myLoudness_TEFElem.bFillData((tVoid*)&tLoudness_TEF, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myLoudness_TEFElem);
   }

   {      
      dp_tclBaseElement myDynCompressionElem("DynCompression", (tU8)0x01, (tS32)0xabaf9df5, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tDynCompression = {DynCompressionDefault_Value};
      
         
      (tVoid)myDynCompressionElem.bSetDefaultData((tVoid*)&tDynCompression, (tU32)sizeof(tU8));
      (tVoid)myDynCompressionElem.bFillData((tVoid*)&tDynCompression, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDynCompressionElem);
   }

   {      
      dp_tclBaseElement myEquPresetElem("EquPreset", (tU8)0x01, (tS32)0x243057a, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tEquPreset = {EquPresetDefault_Value};
      
         
      (tVoid)myEquPresetElem.bSetDefaultData((tVoid*)&tEquPreset, (tU32)sizeof(tU8));
      (tVoid)myEquPresetElem.bFillData((tVoid*)&tEquPreset, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myEquPresetElem);
   }

   {      
      dp_tclBaseElement myOptimizationElem("Optimization", (tU8)0x01, (tS32)0x37b1ca9b, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tOptimization = {OptimizationDefault_Value};
      
         
      (tVoid)myOptimizationElem.bSetDefaultData((tVoid*)&tOptimization, (tU32)sizeof(tU8));
      (tVoid)myOptimizationElem.bFillData((tVoid*)&tOptimization, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myOptimizationElem);
   }

   {      
      dp_tclBaseElement myRoomEffectElem("RoomEffect", (tU8)0x01, (tS32)0xcc4379e, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tRoomEffect = {RoomEffectDefault_Value};
      
         
      (tVoid)myRoomEffectElem.bSetDefaultData((tVoid*)&tRoomEffect, (tU32)sizeof(tU8));
      (tVoid)myRoomEffectElem.bFillData((tVoid*)&tRoomEffect, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myRoomEffectElem);
   }

   {      
      dp_tclBaseElement mySoundStagingElem("SoundStaging", (tU8)0x01, (tS32)0x42ec54e2, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tSoundStaging = {0};
      
         
      (tVoid)mySoundStagingElem.bSetDefaultData((tVoid*)&tSoundStaging, (tU32)sizeof(tU8));
      (tVoid)mySoundStagingElem.bFillData((tVoid*)&tSoundStaging, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &mySoundStagingElem);
   }

   {      
      dp_tclBaseElement myAdas_UPASoundtypeElem("Adas_UPASoundtype", (tU8)0x02, (tS32)0xecc601b9, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tAdas_UPASoundtype = {1};
      
         
      (tVoid)myAdas_UPASoundtypeElem.bSetDefaultData((tVoid*)&tAdas_UPASoundtype, (tU32)sizeof(tU8));
      (tVoid)myAdas_UPASoundtypeElem.bFillData((tVoid*)&tAdas_UPASoundtype, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myAdas_UPASoundtypeElem);
   }

   {      
      dp_tclBaseElement myAdas_ParkAssitVolElem("Adas_ParkAssitVol", (tU8)0x02, (tS32)0xee2a3d0b, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tAdas_ParkAssitVol = {3};
      
         
      (tVoid)myAdas_ParkAssitVolElem.bSetDefaultData((tVoid*)&tAdas_ParkAssitVol, (tU32)sizeof(tU8));
      (tVoid)myAdas_ParkAssitVolElem.bFillData((tVoid*)&tAdas_ParkAssitVol, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myAdas_ParkAssitVolElem);
   }

   {      
      dp_tclBaseElement myAdas_UPAMuteElem("Adas_UPAMute", (tU8)0x01, (tS32)0x5e45d59, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tAdas_UPAMute = {0};
      
         
      (tVoid)myAdas_UPAMuteElem.bSetDefaultData((tVoid*)&tAdas_UPAMute, (tU32)sizeof(tU8));
      (tVoid)myAdas_UPAMuteElem.bFillData((tVoid*)&tAdas_UPAMute, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myAdas_UPAMuteElem);
   }

   {      
      dp_tclBaseElement myAdas_LDWUSerVolElem("Adas_LDWUSerVol", (tU8)0x01, (tS32)0xdf48452f, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tAdas_LDWUSerVol = {3};
      
         
      (tVoid)myAdas_LDWUSerVolElem.bSetDefaultData((tVoid*)&tAdas_LDWUSerVol, (tU32)sizeof(tU8));
      (tVoid)myAdas_LDWUSerVolElem.bFillData((tVoid*)&tAdas_LDWUSerVol, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myAdas_LDWUSerVolElem);
   }

   {      
      dp_tclBaseElement myAdas_SRSoundStateElem("Adas_SRSoundState", (tU8)0x01, (tS32)0xeae2159f, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tAdas_SRSoundState = {1};
      
         
      (tVoid)myAdas_SRSoundStateElem.bSetDefaultData((tVoid*)&tAdas_SRSoundState, (tU32)sizeof(tU8));
      (tVoid)myAdas_SRSoundStateElem.bFillData((tVoid*)&tAdas_SRSoundState, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myAdas_SRSoundStateElem);
   }

   {      
      dp_tclBaseElement myBass_MaxElem("Bass_Max", (tU8)0x01, (tS32)0x6c9ada, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tBass_Max = {BassMax_Value};
      
         
      (tVoid)myBass_MaxElem.bSetDefaultData((tVoid*)&tBass_Max, (tU32)sizeof(tS8));
      (tVoid)myBass_MaxElem.bFillData((tVoid*)&tBass_Max, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myBass_MaxElem);
   }

   {      
      dp_tclBaseElement myCenter_MaxElem("Center_Max", (tU8)0x01, (tS32)0xacbac1e, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tCenter_Max = {CentrMax_Value};
      
         
      (tVoid)myCenter_MaxElem.bSetDefaultData((tVoid*)&tCenter_Max, (tU32)sizeof(tS8));
      (tVoid)myCenter_MaxElem.bFillData((tVoid*)&tCenter_Max, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myCenter_MaxElem);
   }

   {      
      dp_tclBaseElement mySubWoofer_MaxElem("SubWoofer_Max", (tU8)0x01, (tS32)0x52b73411, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tSubWoofer_Max = {SubWoofrMax_Value};
      
         
      (tVoid)mySubWoofer_MaxElem.bSetDefaultData((tVoid*)&tSubWoofer_Max, (tU32)sizeof(tS8));
      (tVoid)mySubWoofer_MaxElem.bFillData((tVoid*)&tSubWoofer_Max, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &mySubWoofer_MaxElem);
   }

   {      
      dp_tclBaseElement myTreble_MaxElem("Treble_Max", (tU8)0x01, (tS32)0xd04fcbf, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tTreble_Max = {TrebleMax_Value};
      
         
      (tVoid)myTreble_MaxElem.bSetDefaultData((tVoid*)&tTreble_Max, (tU32)sizeof(tS8));
      (tVoid)myTreble_MaxElem.bFillData((tVoid*)&tTreble_Max, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myTreble_MaxElem);
   }

   {      
      dp_tclBaseElement myMidRange_MaxElem("MidRange_Max", (tU8)0x01, (tS32)0x2b58a238, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tMidRange_Max = {MidRangeMax_Value};
      
         
      (tVoid)myMidRange_MaxElem.bSetDefaultData((tVoid*)&tMidRange_Max, (tU32)sizeof(tS8));
      (tVoid)myMidRange_MaxElem.bFillData((tVoid*)&tMidRange_Max, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myMidRange_MaxElem);
   }

   {      
      dp_tclBaseElement myFader_MaxElem("Fader_Max", (tU8)0x01, (tS32)0x232d497, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tFader_Max = {FaderMax_Value};
      
         
      (tVoid)myFader_MaxElem.bSetDefaultData((tVoid*)&tFader_Max, (tU32)sizeof(tS8));
      (tVoid)myFader_MaxElem.bFillData((tVoid*)&tFader_Max, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myFader_MaxElem);
   }

   {      
      dp_tclBaseElement myBalance_MaxElem("Balance_Max", (tU8)0x01, (tS32)0x34cd15a7, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tBalance_Max = {BalanceMax_Value};
      
         
      (tVoid)myBalance_MaxElem.bSetDefaultData((tVoid*)&tBalance_Max, (tU32)sizeof(tS8));
      (tVoid)myBalance_MaxElem.bFillData((tVoid*)&tBalance_Max, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myBalance_MaxElem);
   }

   {      
      dp_tclBaseElement myGala_MaxElem("Gala_Max", (tU8)0x01, (tS32)0x720f56, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tGala_Max = {GalaMax_Value};
      
         
      (tVoid)myGala_MaxElem.bSetDefaultData((tVoid*)&tGala_Max, (tU32)sizeof(tS8));
      (tVoid)myGala_MaxElem.bFillData((tVoid*)&tGala_Max, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myGala_MaxElem);
   }

   {      
      dp_tclBaseElement myLoudness_MaxElem("Loudness_Max", (tU8)0x01, (tS32)0x2e61a15a, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tLoudness_Max = {LoudnessMax_Value};
      
         
      (tVoid)myLoudness_MaxElem.bSetDefaultData((tVoid*)&tLoudness_Max, (tU32)sizeof(tS8));
      (tVoid)myLoudness_MaxElem.bFillData((tVoid*)&tLoudness_Max, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myLoudness_MaxElem);
   }

   {      
      dp_tclBaseElement myDynCompression_MaxElem("DynCompression_Max", (tU8)0x01, (tS32)0x27c0db6a, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tDynCompression_Max = {DynCompressionMax_Value};
      
         
      (tVoid)myDynCompression_MaxElem.bSetDefaultData((tVoid*)&tDynCompression_Max, (tU32)sizeof(tS8));
      (tVoid)myDynCompression_MaxElem.bFillData((tVoid*)&tDynCompression_Max, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myDynCompression_MaxElem);
   }

   {      
      dp_tclBaseElement myEquPreset_MaxElem("EquPreset_Max", (tU8)0x01, (tS32)0x85a0971f, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tEquPreset_Max = {EquPresetMax_Value};
      
         
      (tVoid)myEquPreset_MaxElem.bSetDefaultData((tVoid*)&tEquPreset_Max, (tU32)sizeof(tS8));
      (tVoid)myEquPreset_MaxElem.bFillData((tVoid*)&tEquPreset_Max, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myEquPreset_MaxElem);
   }

   {      
      dp_tclBaseElement myOptimization_MaxElem("Optimization_Max", (tU8)0x01, (tS32)0xf90fdcb0, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tOptimization_Max = {OptimizationMax_Value};
      
         
      (tVoid)myOptimization_MaxElem.bSetDefaultData((tVoid*)&tOptimization_Max, (tU32)sizeof(tS8));
      (tVoid)myOptimization_MaxElem.bFillData((tVoid*)&tOptimization_Max, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myOptimization_MaxElem);
   }

   {      
      dp_tclBaseElement myRoomEffect_MaxElem("RoomEffect_Max", (tU8)0x01, (tS32)0x2b0c0103, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tRoomEffect_Max = {RoomEffectMax_Value};
      
         
      (tVoid)myRoomEffect_MaxElem.bSetDefaultData((tVoid*)&tRoomEffect_Max, (tU32)sizeof(tS8));
      (tVoid)myRoomEffect_MaxElem.bFillData((tVoid*)&tRoomEffect_Max, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myRoomEffect_MaxElem);
   }

   {      
      dp_tclBaseElement myBass_MinElem("Bass_Min", (tU8)0x01, (tS32)0x6c9af8, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tBass_Min = {BassMin_Value};
      
         
      (tVoid)myBass_MinElem.bSetDefaultData((tVoid*)&tBass_Min, (tU32)sizeof(tS8));
      (tVoid)myBass_MinElem.bFillData((tVoid*)&tBass_Min, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myBass_MinElem);
   }

   {      
      dp_tclBaseElement myCenter_MinElem("Center_Min", (tU8)0x01, (tS32)0xacbac3c, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tCenter_Min = {CentrMin_Value};
      
         
      (tVoid)myCenter_MinElem.bSetDefaultData((tVoid*)&tCenter_Min, (tU32)sizeof(tS8));
      (tVoid)myCenter_MinElem.bFillData((tVoid*)&tCenter_Min, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myCenter_MinElem);
   }

   {      
      dp_tclBaseElement mySubWoofer_MinElem("SubWoofer_Min", (tU8)0x01, (tS32)0x52b7342f, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tSubWoofer_Min = {SubWoofrMin_Value};
      
         
      (tVoid)mySubWoofer_MinElem.bSetDefaultData((tVoid*)&tSubWoofer_Min, (tU32)sizeof(tS8));
      (tVoid)mySubWoofer_MinElem.bFillData((tVoid*)&tSubWoofer_Min, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &mySubWoofer_MinElem);
   }

   {      
      dp_tclBaseElement myTreble_MinElem("Treble_Min", (tU8)0x01, (tS32)0xd04fcdd, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tTreble_Min = {TrebleMin_Value};
      
         
      (tVoid)myTreble_MinElem.bSetDefaultData((tVoid*)&tTreble_Min, (tU32)sizeof(tS8));
      (tVoid)myTreble_MinElem.bFillData((tVoid*)&tTreble_Min, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myTreble_MinElem);
   }

   {      
      dp_tclBaseElement myMidRange_MinElem("MidRange_Min", (tU8)0x01, (tS32)0x2b58a256, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tMidRange_Min = {MidRangeMin_Value};
      
         
      (tVoid)myMidRange_MinElem.bSetDefaultData((tVoid*)&tMidRange_Min, (tU32)sizeof(tS8));
      (tVoid)myMidRange_MinElem.bFillData((tVoid*)&tMidRange_Min, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myMidRange_MinElem);
   }

   {      
      dp_tclBaseElement myFader_MinElem("Fader_Min", (tU8)0x01, (tS32)0x232d4b5, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tFader_Min = {FaderMin_Value};
      
         
      (tVoid)myFader_MinElem.bSetDefaultData((tVoid*)&tFader_Min, (tU32)sizeof(tS8));
      (tVoid)myFader_MinElem.bFillData((tVoid*)&tFader_Min, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myFader_MinElem);
   }

   {      
      dp_tclBaseElement myBalance_MinElem("Balance_Min", (tU8)0x01, (tS32)0x34cd15c5, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tBalance_Min = {BalanceMin_Value};
      
         
      (tVoid)myBalance_MinElem.bSetDefaultData((tVoid*)&tBalance_Min, (tU32)sizeof(tS8));
      (tVoid)myBalance_MinElem.bFillData((tVoid*)&tBalance_Min, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myBalance_MinElem);
   }

   {      
      dp_tclBaseElement myLoudness_MinElem("Loudness_Min", (tU8)0x01, (tS32)0x2e61a178, sizeof(tS8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS8 tLoudness_Min = {LoudnessMin_Value};
      
         
      (tVoid)myLoudness_MinElem.bSetDefaultData((tVoid*)&tLoudness_Min, (tU32)sizeof(tS8));
      (tVoid)myLoudness_MinElem.bFillData((tVoid*)&tLoudness_Min, (tU32)sizeof(tS8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myLoudness_MinElem);
   }

   {
      dp_tclBaseElement myVolumesElem("Volumes", (tU8)VolumeManager::VolumeListEntryVersion, (tS32)0x1b19df, sizeof(VolumeManager::tVolumelistEntry), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    VolumeManager::tVolumelistEntry     tVolumes[]={/* empty */};     
     tVoid*   vptVolumes=(tVoid*)&tVolumes[0]; 
      tU32     u16ArraySize = sizeof(tVolumes)/sizeof(VolumeManager::tVolumelistEntry);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myVolumesElem.bSetDefaultData(vptVolumes, ((tU32)sizeof(VolumeManager::tVolumelistEntry))*u16ArraySize);
          (tVoid)myVolumesElem.bFillData(vptVolumes, ((tU32)sizeof(VolumeManager::tVolumelistEntry))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myVolumesElem);
   }

   {
      dp_tclBaseElement myVolumes_Sink2Elem("Volumes_Sink2", (tU8)VolumeManager::VolumeListEntryVersion, (tS32)0x76239e71, sizeof(VolumeManager::tVolumelistEntry), 
      TRUE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeImmediately,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);
                  
      
    VolumeManager::tVolumelistEntry     tVolumes_Sink2[]={/* empty */};     
     tVoid*   vptVolumes_Sink2=(tVoid*)&tVolumes_Sink2[0]; 
      tU32     u16ArraySize = sizeof(tVolumes_Sink2)/sizeof(VolumeManager::tVolumelistEntry);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myVolumes_Sink2Elem.bSetDefaultData(vptVolumes_Sink2, ((tU32)sizeof(VolumeManager::tVolumelistEntry))*u16ArraySize);
          (tVoid)myVolumes_Sink2Elem.bFillData(vptVolumes_Sink2, ((tU32)sizeof(VolumeManager::tVolumelistEntry))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myVolumes_Sink2Elem);
   }

   {      
      dp_tclBaseElement myPDCSetup_VolumeElem("PDCSetup_Volume", (tU8)0x02, (tS32)0xfabc497, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tPDCSetup_Volume = {PdcSetupVolumeDefault};
      
         
      (tVoid)myPDCSetup_VolumeElem.bSetDefaultData((tVoid*)&tPDCSetup_Volume, (tU32)sizeof(tU8));
      (tVoid)myPDCSetup_VolumeElem.bFillData((tVoid*)&tPDCSetup_Volume, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myPDCSetup_VolumeElem);
   }

   {      
      dp_tclBaseElement myCenterGainElem("CenterGain", (tU8)0x01, (tS32)0xacba278, sizeof(tS16), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U16,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS16 tCenterGain = {CentrGainDefault_value};
      
         
      (tVoid)myCenterGainElem.bSetDefaultData((tVoid*)&tCenterGain, (tU32)sizeof(tS16));
      (tVoid)myCenterGainElem.bFillData((tVoid*)&tCenterGain, (tU32)sizeof(tS16));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myCenterGainElem);
   }

   {      
      dp_tclBaseElement mySubWooferElem("SubWoofer", (tU8)0x01, (tS32)0x297068c, sizeof(tS16), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U16,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tS16 tSubWoofer = {SubWooferDefault_Value};
      
         
      (tVoid)mySubWooferElem.bSetDefaultData((tVoid*)&tSubWoofer, (tU32)sizeof(tS16));
      (tVoid)mySubWooferElem.bFillData((tVoid*)&tSubWoofer, (tU32)sizeof(tS16));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &mySubWooferElem);
   }

   {      
      dp_tclBaseElement mySurroundLevelElem("SurroundLevel", (tU8)0x01, (tS32)0x5f34ba9a, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tSurroundLevel = {0};
      
         
      (tVoid)mySurroundLevelElem.bSetDefaultData((tVoid*)&tSurroundLevel, (tU32)sizeof(tU8));
      (tVoid)mySurroundLevelElem.bFillData((tVoid*)&tSurroundLevel, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &mySurroundLevelElem);
   }

   {
      dp_tclBaseElement myArkamys_AvcFlatConfigElem("Arkamys_AvcFlatConfig", (tU8)Arkamys_AvcDataVersion, (tS32)0x5432ef1e, sizeof(tU32), 
      TRUE, 
      0x0444, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_CUSTOMER|DP_DEFSET_TEF);
                  
      
    tU32     tArkamys_AvcFlatConfig[]={Arkamys_AvcFlatConfig};     
     tVoid*   vptArkamys_AvcFlatConfig=(tVoid*)&tArkamys_AvcFlatConfig[0]; 
      tU32     u16ArraySize = sizeof(tArkamys_AvcFlatConfig)/sizeof(tU32);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myArkamys_AvcFlatConfigElem.bSetDefaultData(vptArkamys_AvcFlatConfig, ((tU32)sizeof(tU32))*u16ArraySize);
          (tVoid)myArkamys_AvcFlatConfigElem.bFillData(vptArkamys_AvcFlatConfig, ((tU32)sizeof(tU32))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myArkamys_AvcFlatConfigElem);
   }

   {
      dp_tclBaseElement myArkamys_SSS4FlatConfigElem("Arkamys_SSS4FlatConfig", (tU8)Arkamys_SSS4DataVersion, (tS32)0x8816891d, sizeof(tU32), 
      TRUE, 
      0x0444, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_CUSTOMER|DP_DEFSET_TEF);
                  
      
    tU32     tArkamys_SSS4FlatConfig[]={Arkamys_SSS4FlatConfig};     
     tVoid*   vptArkamys_SSS4FlatConfig=(tVoid*)&tArkamys_SSS4FlatConfig[0]; 
      tU32     u16ArraySize = sizeof(tArkamys_SSS4FlatConfig)/sizeof(tU32);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myArkamys_SSS4FlatConfigElem.bSetDefaultData(vptArkamys_SSS4FlatConfig, ((tU32)sizeof(tU32))*u16ArraySize);
          (tVoid)myArkamys_SSS4FlatConfigElem.bFillData(vptArkamys_SSS4FlatConfig, ((tU32)sizeof(tU32))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myArkamys_SSS4FlatConfigElem);
   }

   {
      dp_tclBaseElement myArkamys_VirtualSubwooferFlatConfigElem("Arkamys_VirtualSubwooferFlatConfig", (tU8)Arkamys_VirtualSubwooferDataVersion, (tS32)0x9c1223a7L, sizeof(tU32), 
      TRUE, 
      0x0444, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed,
      0, 
      FALSE, 
      DP_TYPE_STRUCT,
      DP_DEFSET_USER|DP_DEFSET_CUSTOMER|DP_DEFSET_TEF);
                  
      
    tU32     tArkamys_VirtualSubwooferFlatConfig[]={Arkamys_VirtualSubwooferFlatConfig};     
     tVoid*   vptArkamys_VirtualSubwooferFlatConfig=(tVoid*)&tArkamys_VirtualSubwooferFlatConfig[0]; 
      tU32     u16ArraySize = sizeof(tArkamys_VirtualSubwooferFlatConfig)/sizeof(tU32);     
             
      if (u16ArraySize > 0) //lint !e774: Boolean within 'if' always evaluates to True --> generated code -> check will be done even if sizeof init value > 0 
      {
          (tVoid)myArkamys_VirtualSubwooferFlatConfigElem.bSetDefaultData(vptArkamys_VirtualSubwooferFlatConfig, ((tU32)sizeof(tU32))*u16ArraySize);
          (tVoid)myArkamys_VirtualSubwooferFlatConfigElem.bFillData(vptArkamys_VirtualSubwooferFlatConfig, ((tU32)sizeof(tU32))*u16ArraySize);
      }
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myArkamys_VirtualSubwooferFlatConfigElem);
   }

   {      
      dp_tclBaseElement myArkamys_SteeringRightElem("Arkamys_SteeringRight", (tU8)1, (tS32)0x59433d12, sizeof(tBool), 
      FALSE, 
      0x0446, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_CUSTOMER|DP_DEFSET_TEF);      
      
     tBool tArkamys_SteeringRight = {0};
      
         
      (tVoid)myArkamys_SteeringRightElem.bSetDefaultData((tVoid*)&tArkamys_SteeringRight, (tU32)sizeof(tBool));
      (tVoid)myArkamys_SteeringRightElem.bFillData((tVoid*)&tArkamys_SteeringRight, (tU32)sizeof(tBool));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myArkamys_SteeringRightElem);
   }

   {      
      dp_tclBaseElement myArkamys_SoundStagingModeElem("Arkamys_SoundStagingMode", (tU8)1, (tS32)0x5511afda, sizeof(tU16), 
      FALSE, 
      0x0446, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U16,
      DP_DEFSET_USER|DP_DEFSET_CUSTOMER|DP_DEFSET_TEF);      
      
     tU16 tArkamys_SoundStagingMode = {0};
      
         
      (tVoid)myArkamys_SoundStagingModeElem.bSetDefaultData((tVoid*)&tArkamys_SoundStagingMode, (tU32)sizeof(tU16));
      (tVoid)myArkamys_SoundStagingModeElem.bFillData((tVoid*)&tArkamys_SoundStagingMode, (tU32)sizeof(tU16));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myArkamys_SoundStagingModeElem);
   }

   {      
      dp_tclBaseElement myArkamys_AmbianceElem("Arkamys_Ambiance", (tU8)1, (tS32)0x5bc51f83, sizeof(tU16), 
      FALSE, 
      0x0446, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U16,
      DP_DEFSET_USER|DP_DEFSET_CUSTOMER|DP_DEFSET_TEF);      
      
     tU16 tArkamys_Ambiance = {0};
      
         
      (tVoid)myArkamys_AmbianceElem.bSetDefaultData((tVoid*)&tArkamys_Ambiance, (tU32)sizeof(tU16));
      (tVoid)myArkamys_AmbianceElem.bFillData((tVoid*)&tArkamys_Ambiance, (tU32)sizeof(tU16));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myArkamys_AmbianceElem);
   }

   {      
      dp_tclBaseElement myArkamys_AutomaticGainControlElem("Arkamys_AutomaticGainControl", (tU8)0x01, (tS32)0xc35cf536L, sizeof(tBool), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tBool tArkamys_AutomaticGainControl = {0};
      
         
      (tVoid)myArkamys_AutomaticGainControlElem.bSetDefaultData((tVoid*)&tArkamys_AutomaticGainControl, (tU32)sizeof(tBool));
      (tVoid)myArkamys_AutomaticGainControlElem.bFillData((tVoid*)&tArkamys_AutomaticGainControl, (tU32)sizeof(tBool));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myArkamys_AutomaticGainControlElem);
   }

   {      
      dp_tclBaseElement myCenter_GainPerStepElem("Center_GainPerStep", (tU8)0x01, (tS32)0xc215d3fe, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tCenter_GainPerStep = {2};
      
         
      (tVoid)myCenter_GainPerStepElem.bSetDefaultData((tVoid*)&tCenter_GainPerStep, (tU32)sizeof(tU8));
      (tVoid)myCenter_GainPerStepElem.bFillData((tVoid*)&tCenter_GainPerStep, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myCenter_GainPerStepElem);
   }

   {      
      dp_tclBaseElement mySubWoofer_GainPerStepElem("SubWoofer_GainPerStep", (tU8)0x01, (tS32)0x8f2df91, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tSubWoofer_GainPerStep = {2};
      
         
      (tVoid)mySubWoofer_GainPerStepElem.bSetDefaultData((tVoid*)&tSubWoofer_GainPerStep, (tU32)sizeof(tU8));
      (tVoid)mySubWoofer_GainPerStepElem.bFillData((tVoid*)&tSubWoofer_GainPerStep, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &mySubWoofer_GainPerStepElem);
   }

   {      
      dp_tclBaseElement myAudioPilotModeElem("AudioPilotMode", (tU8)0x02, (tS32)0x8f80bfa3, sizeof(tBool), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tBool tAudioPilotMode = {1};
      
         
      (tVoid)myAudioPilotModeElem.bSetDefaultData((tVoid*)&tAudioPilotMode, (tU32)sizeof(tBool));
      (tVoid)myAudioPilotModeElem.bFillData((tVoid*)&tAudioPilotMode, (tU32)sizeof(tBool));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myAudioPilotModeElem);
   }

   {      
      dp_tclBaseElement myAudioPilotIntensityElem("AudioPilotIntensity", (tU8)0x01, (tS32)0xbe8f6a51, sizeof(tU8), 
      FALSE, 
      0x0006, 
      dp_tclBaseElement::eDpElementTypePersistent, 
      dp_tclBaseElement::eDpStoringTypeDelayed , 
      0, 
      FALSE, 
      DP_TYPE_U8,
      DP_DEFSET_USER|DP_DEFSET_TEF|DP_DEFSET_CUSTOMER);      
      
     tU8 tAudioPilotIntensity = {2};
      
         
      (tVoid)myAudioPilotIntensityElem.bSetDefaultData((tVoid*)&tAudioPilotIntensity, (tU32)sizeof(tU8));
      (tVoid)myAudioPilotIntensityElem.bFillData((tVoid*)&tAudioPilotIntensity, (tU32)sizeof(tU8));      
            if (pDp) pDp->vInitElement(DP_U32_POOL_ID_AUDIOMANAGERDP, &myAudioPilotIntensityElem);
   }
   if (pDp) pDp->vInitUnknownCodingElements(DP_U32_POOL_ID_AUDIOMANAGERDP);
}
