
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_REG_FI
#include "dp_reg_if.h"

#include "dp_tclregVersions.h"



tU8 dp_tclregVersionsBoardCfgName::u8GetData(tString &tBoardCfgNameParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BOARD_NAME", tBoardCfgNameParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsBoardCfgName::u8GetData(const tString &tBoardCfgNameParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BOARD_NAME", tBoardCfgNameParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsBoardCfgName::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsBoardCfgName::vSetData(tString &tBoardCfgNameParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgNameParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BOARD_NAME", tBoardCfgNameParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgName::vSetData(const tString &tBoardCfgNameParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgNameParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BOARD_NAME", tBoardCfgNameParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgName::vSetData(tString &tBoardCfgNameParam, tU16 u16Len) 
{
    vSetData(tBoardCfgNameParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsBoardCfgName::vSetData(const tString &tBoardCfgNameParam, tU16 u16Len) 
{
    vSetData(tBoardCfgNameParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsBoardCfgBuildVersion::u8GetData(tString &tBoardCfgBuildVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BUILDVERSION_LABEL", tBoardCfgBuildVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsBoardCfgBuildVersion::u8GetData(const tString &tBoardCfgBuildVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BUILDVERSION_LABEL", tBoardCfgBuildVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsBoardCfgBuildVersion::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsBoardCfgBuildVersion::vSetData(tString &tBoardCfgBuildVersionParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgBuildVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BUILDVERSION_LABEL", tBoardCfgBuildVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgBuildVersion::vSetData(const tString &tBoardCfgBuildVersionParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgBuildVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BUILDVERSION_LABEL", tBoardCfgBuildVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgBuildVersion::vSetData(tString &tBoardCfgBuildVersionParam, tU16 u16Len) 
{
    vSetData(tBoardCfgBuildVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsBoardCfgBuildVersion::vSetData(const tString &tBoardCfgBuildVersionParam, tU16 u16Len) 
{
    vSetData(tBoardCfgBuildVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsBoardCfgCustomerVersion::u8GetData(tString &tBoardCfgCustomerVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BUILDVERSION_CUSTVERSTRING", tBoardCfgCustomerVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsBoardCfgCustomerVersion::u8GetData(const tString &tBoardCfgCustomerVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BUILDVERSION_CUSTVERSTRING", tBoardCfgCustomerVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsBoardCfgCustomerVersion::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsBoardCfgCustomerVersion::vSetData(tString &tBoardCfgCustomerVersionParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgCustomerVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BUILDVERSION_CUSTVERSTRING", tBoardCfgCustomerVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgCustomerVersion::vSetData(const tString &tBoardCfgCustomerVersionParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgCustomerVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BUILDVERSION_CUSTVERSTRING", tBoardCfgCustomerVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgCustomerVersion::vSetData(tString &tBoardCfgCustomerVersionParam, tU16 u16Len) 
{
    vSetData(tBoardCfgCustomerVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsBoardCfgCustomerVersion::vSetData(const tString &tBoardCfgCustomerVersionParam, tU16 u16Len) 
{
    vSetData(tBoardCfgCustomerVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsBoardCfgBuildType::u8GetData(tString &tBoardCfgBuildTypeParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BUILDVERSION_BUILDTYPE", tBoardCfgBuildTypeParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsBoardCfgBuildType::u8GetData(const tString &tBoardCfgBuildTypeParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BUILDVERSION_BUILDTYPE", tBoardCfgBuildTypeParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsBoardCfgBuildType::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsBoardCfgBuildType::vSetData(tString &tBoardCfgBuildTypeParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgBuildTypeParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BUILDVERSION_BUILDTYPE", tBoardCfgBuildTypeParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgBuildType::vSetData(const tString &tBoardCfgBuildTypeParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgBuildTypeParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BUILDVERSION_BUILDTYPE", tBoardCfgBuildTypeParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgBuildType::vSetData(tString &tBoardCfgBuildTypeParam, tU16 u16Len) 
{
    vSetData(tBoardCfgBuildTypeParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsBoardCfgBuildType::vSetData(const tString &tBoardCfgBuildTypeParam, tU16 u16Len) 
{
    vSetData(tBoardCfgBuildTypeParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsBoardCfgBuildTime::u8GetData(tString &tBoardCfgBuildTimeParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BUILDVERSION_TIMESTAMP", tBoardCfgBuildTimeParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsBoardCfgBuildTime::u8GetData(const tString &tBoardCfgBuildTimeParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BUILDVERSION_TIMESTAMP", tBoardCfgBuildTimeParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsBoardCfgBuildTime::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsBoardCfgBuildTime::vSetData(tString &tBoardCfgBuildTimeParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgBuildTimeParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BUILDVERSION_TIMESTAMP", tBoardCfgBuildTimeParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgBuildTime::vSetData(const tString &tBoardCfgBuildTimeParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgBuildTimeParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BUILDVERSION_TIMESTAMP", tBoardCfgBuildTimeParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgBuildTime::vSetData(tString &tBoardCfgBuildTimeParam, tU16 u16Len) 
{
    vSetData(tBoardCfgBuildTimeParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsBoardCfgBuildTime::vSetData(const tString &tBoardCfgBuildTimeParam, tU16 u16Len) 
{
    vSetData(tBoardCfgBuildTimeParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsBoardCfgBuildUsr::u8GetData(tString &tBoardCfgBuildUsrParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BUILDVERSION_BUILDUSER", tBoardCfgBuildUsrParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsBoardCfgBuildUsr::u8GetData(const tString &tBoardCfgBuildUsrParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BUILDVERSION_BUILDUSER", tBoardCfgBuildUsrParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsBoardCfgBuildUsr::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsBoardCfgBuildUsr::vSetData(tString &tBoardCfgBuildUsrParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgBuildUsrParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BUILDVERSION_BUILDUSER", tBoardCfgBuildUsrParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgBuildUsr::vSetData(const tString &tBoardCfgBuildUsrParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgBuildUsrParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BUILDVERSION_BUILDUSER", tBoardCfgBuildUsrParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgBuildUsr::vSetData(tString &tBoardCfgBuildUsrParam, tU16 u16Len) 
{
    vSetData(tBoardCfgBuildUsrParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsBoardCfgBuildUsr::vSetData(const tString &tBoardCfgBuildUsrParam, tU16 u16Len) 
{
    vSetData(tBoardCfgBuildUsrParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsBoardCfgSccAppVersion::u8GetData(tString &tBoardCfgSccAppVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_APP_LABEL", tBoardCfgSccAppVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsBoardCfgSccAppVersion::u8GetData(const tString &tBoardCfgSccAppVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_APP_LABEL", tBoardCfgSccAppVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsBoardCfgSccAppVersion::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsBoardCfgSccAppVersion::vSetData(tString &tBoardCfgSccAppVersionParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgSccAppVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_APP_LABEL", tBoardCfgSccAppVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgSccAppVersion::vSetData(const tString &tBoardCfgSccAppVersionParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgSccAppVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_APP_LABEL", tBoardCfgSccAppVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgSccAppVersion::vSetData(tString &tBoardCfgSccAppVersionParam, tU16 u16Len) 
{
    vSetData(tBoardCfgSccAppVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsBoardCfgSccAppVersion::vSetData(const tString &tBoardCfgSccAppVersionParam, tU16 u16Len) 
{
    vSetData(tBoardCfgSccAppVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsBoardCfgSccBmVersion::u8GetData(tString &tBoardCfgSccBmVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_BM_LABEL", tBoardCfgSccBmVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsBoardCfgSccBmVersion::u8GetData(const tString &tBoardCfgSccBmVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_BM_LABEL", tBoardCfgSccBmVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsBoardCfgSccBmVersion::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsBoardCfgSccBmVersion::vSetData(tString &tBoardCfgSccBmVersionParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgSccBmVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_BM_LABEL", tBoardCfgSccBmVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgSccBmVersion::vSetData(const tString &tBoardCfgSccBmVersionParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgSccBmVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_BM_LABEL", tBoardCfgSccBmVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgSccBmVersion::vSetData(tString &tBoardCfgSccBmVersionParam, tU16 u16Len) 
{
    vSetData(tBoardCfgSccBmVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsBoardCfgSccBmVersion::vSetData(const tString &tBoardCfgSccBmVersionParam, tU16 u16Len) 
{
    vSetData(tBoardCfgSccBmVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsBoardCfgSccBlVersion::u8GetData(tString &tBoardCfgSccBlVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_BL_LABEL", tBoardCfgSccBlVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsBoardCfgSccBlVersion::u8GetData(const tString &tBoardCfgSccBlVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_BL_LABEL", tBoardCfgSccBlVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsBoardCfgSccBlVersion::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsBoardCfgSccBlVersion::vSetData(tString &tBoardCfgSccBlVersionParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgSccBlVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_BL_LABEL", tBoardCfgSccBlVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgSccBlVersion::vSetData(const tString &tBoardCfgSccBlVersionParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgSccBlVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_BL_LABEL", tBoardCfgSccBlVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgSccBlVersion::vSetData(tString &tBoardCfgSccBlVersionParam, tU16 u16Len) 
{
    vSetData(tBoardCfgSccBlVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsBoardCfgSccBlVersion::vSetData(const tString &tBoardCfgSccBlVersionParam, tU16 u16Len) 
{
    vSetData(tBoardCfgSccBlVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsPrjTargetVersion::u8GetData(tString &tPrjTargetVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("PRJ_TARGET", tPrjTargetVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsPrjTargetVersion::u8GetData(const tString &tPrjTargetVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("PRJ_TARGET", tPrjTargetVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsPrjTargetVersion::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsPrjTargetVersion::vSetData(tString &tPrjTargetVersionParam) {
   tU32 u32Len = (tU32)strlen(tPrjTargetVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("PRJ_TARGET", tPrjTargetVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsPrjTargetVersion::vSetData(const tString &tPrjTargetVersionParam) {
   tU32 u32Len = (tU32)strlen(tPrjTargetVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("PRJ_TARGET", tPrjTargetVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsPrjTargetVersion::vSetData(tString &tPrjTargetVersionParam, tU16 u16Len) 
{
    vSetData(tPrjTargetVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsPrjTargetVersion::vSetData(const tString &tPrjTargetVersionParam, tU16 u16Len) 
{
    vSetData(tPrjTargetVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsPrjVariantVersion::u8GetData(tString &tPrjVariantVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("PRJ_VARIANT", tPrjVariantVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsPrjVariantVersion::u8GetData(const tString &tPrjVariantVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("PRJ_VARIANT", tPrjVariantVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsPrjVariantVersion::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsPrjVariantVersion::vSetData(tString &tPrjVariantVersionParam) {
   tU32 u32Len = (tU32)strlen(tPrjVariantVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("PRJ_VARIANT", tPrjVariantVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsPrjVariantVersion::vSetData(const tString &tPrjVariantVersionParam) {
   tU32 u32Len = (tU32)strlen(tPrjVariantVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("PRJ_VARIANT", tPrjVariantVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsPrjVariantVersion::vSetData(tString &tPrjVariantVersionParam, tU16 u16Len) 
{
    vSetData(tPrjVariantVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsPrjVariantVersion::vSetData(const tString &tPrjVariantVersionParam, tU16 u16Len) 
{
    vSetData(tPrjVariantVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsBoardCfgType::u8GetData(tString &tBoardCfgTypeParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BOARD_TYP", tBoardCfgTypeParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsBoardCfgType::u8GetData(const tString &tBoardCfgTypeParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BOARD_TYP", tBoardCfgTypeParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsBoardCfgType::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsBoardCfgType::vSetData(tString &tBoardCfgTypeParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgTypeParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BOARD_TYP", tBoardCfgTypeParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgType::vSetData(const tString &tBoardCfgTypeParam) {
   tU32 u32Len = (tU32)strlen(tBoardCfgTypeParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("BOARD_TYP", tBoardCfgTypeParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgType::vSetData(tString &tBoardCfgTypeParam, tU16 u16Len) 
{
    vSetData(tBoardCfgTypeParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsBoardCfgType::vSetData(const tString &tBoardCfgTypeParam, tU16 u16Len) 
{
    vSetData(tBoardCfgTypeParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BoardCfgRamSize"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsBoardCfgRamSize::dp_tclregVersionsBoardCfgRamSize() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tBoardCfgRamSize(0)
{
   vUpdate();
}

tVoid dp_tclregVersionsBoardCfgRamSize::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("SDRAM_SIZE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tBoardCfgRamSize = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsBoardCfgRamSize::u8GetData(tU32& tBoardCfgRamSizeParam) {
   vUpdate();
   tBoardCfgRamSizeParam = tBoardCfgRamSize;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsBoardCfgRamSize::tGetData() {
   vUpdate();
   return tBoardCfgRamSize;
};

tU8 dp_tclregVersionsBoardCfgRamSize::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsBoardCfgRamSize::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclregVersionsBoardCfgRamSize::vSetData(tU32 &tBoardCfgRamSizeParam) const {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bSetU32("SDRAM_SIZE", tBoardCfgRamSizeParam)) {
      }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgRamSize::vSetData(const tU32 &tBoardCfgRamSizeParam) const {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bSetU32("SDRAM_SIZE", tBoardCfgRamSizeParam)) {
      }
   }
   return;
}
tVoid dp_tclregVersionsBoardCfgRamSize::operator<<(tU32 oParam) {return vSetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioReverse"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioReverse::dp_tclregVersionsGpioReverse() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioReverse(0x407)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioReverse::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_REVERSE",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioReverse = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioReverse::u8GetData(tU32& tGpioReverseParam) {
   vUpdate();
   tGpioReverseParam = tGpioReverse;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioReverse::tGetData() {
   vUpdate();
   return tGpioReverse;
};

tU8 dp_tclregVersionsGpioReverse::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioReverse::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioIgnition"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioIgnition::dp_tclregVersionsGpioIgnition() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioIgnition(0x406)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioIgnition::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_IGNITION",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioIgnition = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioIgnition::u8GetData(tU32& tGpioIgnitionParam) {
   vUpdate();
   tGpioIgnitionParam = tGpioIgnition;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioIgnition::tGetData() {
   vUpdate();
   return tGpioIgnition;
};

tU8 dp_tclregVersionsGpioIgnition::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioIgnition::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioIllumination"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioIllumination::dp_tclregVersionsGpioIllumination() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioIllumination(0x405)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioIllumination::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_ILLUMINATION",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioIllumination = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioIllumination::u8GetData(tU32& tGpioIlluminationParam) {
   vUpdate();
   tGpioIlluminationParam = tGpioIllumination;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioIllumination::tGetData() {
   vUpdate();
   return tGpioIllumination;
};

tU8 dp_tclregVersionsGpioIllumination::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioIllumination::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioOnTipper"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioOnTipper::dp_tclregVersionsGpioOnTipper() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioOnTipper(0x401)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioOnTipper::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_ON_TIPPER",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioOnTipper = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioOnTipper::u8GetData(tU32& tGpioOnTipperParam) {
   vUpdate();
   tGpioOnTipperParam = tGpioOnTipper;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioOnTipper::tGetData() {
   vUpdate();
   return tGpioOnTipper;
};

tU8 dp_tclregVersionsGpioOnTipper::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioOnTipper::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioEject"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioEject::dp_tclregVersionsGpioEject() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioEject(0x402)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioEject::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_EJECT",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioEject = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioEject::u8GetData(tU32& tGpioEjectParam) {
   vUpdate();
   tGpioEjectParam = tGpioEject;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioEject::tGetData() {
   vUpdate();
   return tGpioEject;
};

tU8 dp_tclregVersionsGpioEject::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioEject::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioCdInsert"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioCdInsert::dp_tclregVersionsGpioCdInsert() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioCdInsert(0x403)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioCdInsert::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_CD_WAKEUP",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioCdInsert = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioCdInsert::u8GetData(tU32& tGpioCdInsertParam) {
   vUpdate();
   tGpioCdInsertParam = tGpioCdInsert;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioCdInsert::tGetData() {
   vUpdate();
   return tGpioCdInsert;
};

tU8 dp_tclregVersionsGpioCdInsert::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioCdInsert::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioAcc"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioAcc::dp_tclregVersionsGpioAcc() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioAcc(0x404)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioAcc::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_ACC",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioAcc = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioAcc::u8GetData(tU32& tGpioAccParam) {
   vUpdate();
   tGpioAccParam = tGpioAcc;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioAcc::tGetData() {
   vUpdate();
   return tGpioAcc;
};

tU8 dp_tclregVersionsGpioAcc::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioAcc::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioBacklight"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioBacklight::dp_tclregVersionsGpioBacklight() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioBacklight(0x428)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioBacklight::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_BACKLIGHT_PWR_ON",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioBacklight = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioBacklight::u8GetData(tU32& tGpioBacklightParam) {
   vUpdate();
   tGpioBacklightParam = tGpioBacklight;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioBacklight::tGetData() {
   vUpdate();
   return tGpioBacklight;
};

tU8 dp_tclregVersionsGpioBacklight::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioBacklight::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioCameraVcc"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioCameraVcc::dp_tclregVersionsGpioCameraVcc() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioCameraVcc(0x42f)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioCameraVcc::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_CAMERA_VCC_ON",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioCameraVcc = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioCameraVcc::u8GetData(tU32& tGpioCameraVccParam) {
   vUpdate();
   tGpioCameraVccParam = tGpioCameraVcc;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioCameraVcc::tGetData() {
   vUpdate();
   return tGpioCameraVcc;
};

tU8 dp_tclregVersionsGpioCameraVcc::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioCameraVcc::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioDayNightSwitch"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioDayNightSwitch::dp_tclregVersionsGpioDayNightSwitch() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioDayNightSwitch(0x19d)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioDayNightSwitch::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_DAY_NIGHT_SWITCH",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioDayNightSwitch = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioDayNightSwitch::u8GetData(tU32& tGpioDayNightSwitchParam) {
   vUpdate();
   tGpioDayNightSwitchParam = tGpioDayNightSwitch;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioDayNightSwitch::tGetData() {
   vUpdate();
   return tGpioDayNightSwitch;
};

tU8 dp_tclregVersionsGpioDayNightSwitch::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioDayNightSwitch::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioMicVccOn"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioMicVccOn::dp_tclregVersionsGpioMicVccOn() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioMicVccOn(0x42e)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioMicVccOn::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_MIC_VCC_ON",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioMicVccOn = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioMicVccOn::u8GetData(tU32& tGpioMicVccOnParam) {
   vUpdate();
   tGpioMicVccOnParam = tGpioMicVccOn;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioMicVccOn::tGetData() {
   vUpdate();
   return tGpioMicVccOn;
};

tU8 dp_tclregVersionsGpioMicVccOn::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioMicVccOn::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioAudioPwrOn"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioAudioPwrOn::dp_tclregVersionsGpioAudioPwrOn() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioAudioPwrOn(0x421)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioAudioPwrOn::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_AUDIO_PWR_ON",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioAudioPwrOn = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioAudioPwrOn::u8GetData(tU32& tGpioAudioPwrOnParam) {
   vUpdate();
   tGpioAudioPwrOnParam = tGpioAudioPwrOn;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioAudioPwrOn::tGetData() {
   vUpdate();
   return tGpioAudioPwrOn;
};

tU8 dp_tclregVersionsGpioAudioPwrOn::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioAudioPwrOn::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioFmAntOn"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioFmAntOn::dp_tclregVersionsGpioFmAntOn() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioFmAntOn(0x422)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioFmAntOn::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_FM_ANT_ON",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioFmAntOn = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioFmAntOn::u8GetData(tU32& tGpioFmAntOnParam) {
   vUpdate();
   tGpioFmAntOnParam = tGpioFmAntOn;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioFmAntOn::tGetData() {
   vUpdate();
   return tGpioFmAntOn;
};

tU8 dp_tclregVersionsGpioFmAntOn::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioFmAntOn::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioXmDabAntPwrOn"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioXmDabAntPwrOn::dp_tclregVersionsGpioXmDabAntPwrOn() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioXmDabAntPwrOn(0x423)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioXmDabAntPwrOn::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_XM_DAB_ANT_PWR_ON",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioXmDabAntPwrOn = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioXmDabAntPwrOn::u8GetData(tU32& tGpioXmDabAntPwrOnParam) {
   vUpdate();
   tGpioXmDabAntPwrOnParam = tGpioXmDabAntPwrOn;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioXmDabAntPwrOn::tGetData() {
   vUpdate();
   return tGpioXmDabAntPwrOn;
};

tU8 dp_tclregVersionsGpioXmDabAntPwrOn::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioXmDabAntPwrOn::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioPhantomOn"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioPhantomOn::dp_tclregVersionsGpioPhantomOn() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioPhantomOn(0x424)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioPhantomOn::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_REAL_PHANTOM_ON",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioPhantomOn = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioPhantomOn::u8GetData(tU32& tGpioPhantomOnParam) {
   vUpdate();
   tGpioPhantomOnParam = tGpioPhantomOn;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioPhantomOn::tGetData() {
   vUpdate();
   return tGpioPhantomOn;
};

tU8 dp_tclregVersionsGpioPhantomOn::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioPhantomOn::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioFmAntErr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioFmAntErr::dp_tclregVersionsGpioFmAntErr() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioFmAntErr(0x40b)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioFmAntErr::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_FM_ANT_ERR",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioFmAntErr = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioFmAntErr::u8GetData(tU32& tGpioFmAntErrParam) {
   vUpdate();
   tGpioFmAntErrParam = tGpioFmAntErr;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioFmAntErr::tGetData() {
   vUpdate();
   return tGpioFmAntErr;
};

tU8 dp_tclregVersionsGpioFmAntErr::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioFmAntErr::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioXmDabAntErr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioXmDabAntErr::dp_tclregVersionsGpioXmDabAntErr() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioXmDabAntErr(0x40c)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioXmDabAntErr::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_XM_DAB_ANT_ERR",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioXmDabAntErr = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioXmDabAntErr::u8GetData(tU32& tGpioXmDabAntErrParam) {
   vUpdate();
   tGpioXmDabAntErrParam = tGpioXmDabAntErr;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioXmDabAntErr::tGetData() {
   vUpdate();
   return tGpioXmDabAntErr;
};

tU8 dp_tclregVersionsGpioXmDabAntErr::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioXmDabAntErr::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioCameraVccErr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioCameraVccErr::dp_tclregVersionsGpioCameraVccErr() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioCameraVccErr(0x40f)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioCameraVccErr::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_CAMERA_VCC_ERR",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioCameraVccErr = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioCameraVccErr::u8GetData(tU32& tGpioCameraVccErrParam) {
   vUpdate();
   tGpioCameraVccErrParam = tGpioCameraVccErr;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioCameraVccErr::tGetData() {
   vUpdate();
   return tGpioCameraVccErr;
};

tU8 dp_tclregVersionsGpioCameraVccErr::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioCameraVccErr::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "GpioMicVccErr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsGpioMicVccErr::dp_tclregVersionsGpioMicVccErr() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tGpioMicVccErr(0x40e)
{
   vUpdate();
}

tVoid dp_tclregVersionsGpioMicVccErr::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS/BOARDCFG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("GPIO_MIC_VCC_ERR",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tGpioMicVccErr = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsGpioMicVccErr::u8GetData(tU32& tGpioMicVccErrParam) {
   vUpdate();
   tGpioMicVccErrParam = tGpioMicVccErr;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsGpioMicVccErr::tGetData() {
   vUpdate();
   return tGpioMicVccErr;
};

tU8 dp_tclregVersionsGpioMicVccErr::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsGpioMicVccErr::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


tU8 dp_tclregVersionsCpldVer::u8GetData(tString &tCpldVerParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("CPLD_VERSION", tCpldVerParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsCpldVer::u8GetData(const tString &tCpldVerParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("CPLD_VERSION", tCpldVerParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsCpldVer::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsCpldVer::vSetData(tString &tCpldVerParam) {
   tU32 u32Len = (tU32)strlen(tCpldVerParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("CPLD_VERSION", tCpldVerParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsCpldVer::vSetData(const tString &tCpldVerParam) {
   tU32 u32Len = (tU32)strlen(tCpldVerParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("CPLD_VERSION", tCpldVerParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsCpldVer::vSetData(tString &tCpldVerParam, tU16 u16Len) 
{
    vSetData(tCpldVerParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsCpldVer::vSetData(const tString &tCpldVerParam, tU16 u16Len) 
{
    vSetData(tCpldVerParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsAdrHwVersion::u8GetData(tString &tAdrHwVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("ADR_HW_Version", tAdrHwVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsAdrHwVersion::u8GetData(const tString &tAdrHwVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("ADR_HW_Version", tAdrHwVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsAdrHwVersion::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsAdrHwVersion::vSetData(tString &tAdrHwVersionParam) {
   tU32 u32Len = (tU32)strlen(tAdrHwVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("ADR_HW_Version", tAdrHwVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsAdrHwVersion::vSetData(const tString &tAdrHwVersionParam) {
   tU32 u32Len = (tU32)strlen(tAdrHwVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("ADR_HW_Version", tAdrHwVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsAdrHwVersion::vSetData(tString &tAdrHwVersionParam, tU16 u16Len) 
{
    vSetData(tAdrHwVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsAdrHwVersion::vSetData(const tString &tAdrHwVersionParam, tU16 u16Len) 
{
    vSetData(tAdrHwVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsAdrSwVersion::u8GetData(tString &tAdrSwVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("ADR_SW_Version", tAdrSwVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsAdrSwVersion::u8GetData(const tString &tAdrSwVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("ADR_SW_Version", tAdrSwVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsAdrSwVersion::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsAdrSwVersion::vSetData(tString &tAdrSwVersionParam) {
   tU32 u32Len = (tU32)strlen(tAdrSwVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("ADR_SW_Version", tAdrSwVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsAdrSwVersion::vSetData(const tString &tAdrSwVersionParam) {
   tU32 u32Len = (tU32)strlen(tAdrSwVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("ADR_SW_Version", tAdrSwVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsAdrSwVersion::vSetData(tString &tAdrSwVersionParam, tU16 u16Len) 
{
    vSetData(tAdrSwVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsAdrSwVersion::vSetData(const tString &tAdrSwVersionParam, tU16 u16Len) 
{
    vSetData(tAdrSwVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsAdrSwVersionCustomer::u8GetData(tString &tAdrSwVersionCustomerParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("ADR_SW_VersionCustomer", tAdrSwVersionCustomerParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsAdrSwVersionCustomer::u8GetData(const tString &tAdrSwVersionCustomerParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("ADR_SW_VersionCustomer", tAdrSwVersionCustomerParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsAdrSwVersionCustomer::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsAdrSwVersionCustomer::vSetData(tString &tAdrSwVersionCustomerParam) {
   tU32 u32Len = (tU32)strlen(tAdrSwVersionCustomerParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("ADR_SW_VersionCustomer", tAdrSwVersionCustomerParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsAdrSwVersionCustomer::vSetData(const tString &tAdrSwVersionCustomerParam) {
   tU32 u32Len = (tU32)strlen(tAdrSwVersionCustomerParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("ADR_SW_VersionCustomer", tAdrSwVersionCustomerParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsAdrSwVersionCustomer::vSetData(tString &tAdrSwVersionCustomerParam, tU16 u16Len) 
{
    vSetData(tAdrSwVersionCustomerParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsAdrSwVersionCustomer::vSetData(const tString &tAdrSwVersionCustomerParam, tU16 u16Len) 
{
    vSetData(tAdrSwVersionCustomerParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsSccAppVersion::u8GetData(tString &tSccAppVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_APP_VERSION", tSccAppVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsSccAppVersion::u8GetData(const tString &tSccAppVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_APP_VERSION", tSccAppVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsSccAppVersion::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsSccAppVersion::vSetData(tString &tSccAppVersionParam) {
   tU32 u32Len = (tU32)strlen(tSccAppVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_APP_VERSION", tSccAppVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsSccAppVersion::vSetData(const tString &tSccAppVersionParam) {
   tU32 u32Len = (tU32)strlen(tSccAppVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_APP_VERSION", tSccAppVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsSccAppVersion::vSetData(tString &tSccAppVersionParam, tU16 u16Len) 
{
    vSetData(tSccAppVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsSccAppVersion::vSetData(const tString &tSccAppVersionParam, tU16 u16Len) 
{
    vSetData(tSccAppVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsSccBLVersion::u8GetData(tString &tSccBLVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_BL_VERSION", tSccBLVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsSccBLVersion::u8GetData(const tString &tSccBLVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_BL_VERSION", tSccBLVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsSccBLVersion::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsSccBLVersion::vSetData(tString &tSccBLVersionParam) {
   tU32 u32Len = (tU32)strlen(tSccBLVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_BL_VERSION", tSccBLVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsSccBLVersion::vSetData(const tString &tSccBLVersionParam) {
   tU32 u32Len = (tU32)strlen(tSccBLVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_BL_VERSION", tSccBLVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsSccBLVersion::vSetData(tString &tSccBLVersionParam, tU16 u16Len) 
{
    vSetData(tSccBLVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsSccBLVersion::vSetData(const tString &tSccBLVersionParam, tU16 u16Len) 
{
    vSetData(tSccBLVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsSccBMVersion::u8GetData(tString &tSccBMVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_BM_VERSION", tSccBMVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsSccBMVersion::u8GetData(const tString &tSccBMVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_BM_VERSION", tSccBMVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsSccBMVersion::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsSccBMVersion::vSetData(tString &tSccBMVersionParam) {
   tU32 u32Len = (tU32)strlen(tSccBMVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_BM_VERSION", tSccBMVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsSccBMVersion::vSetData(const tString &tSccBMVersionParam) {
   tU32 u32Len = (tU32)strlen(tSccBMVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_BM_VERSION", tSccBMVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsSccBMVersion::vSetData(tString &tSccBMVersionParam, tU16 u16Len) 
{
    vSetData(tSccBMVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsSccBMVersion::vSetData(const tString &tSccBMVersionParam, tU16 u16Len) 
{
    vSetData(tSccBMVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsTeseoFwVersion::u8GetData(tString &tTeseoFwVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("TESEO_FW_VERSION", tTeseoFwVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsTeseoFwVersion::u8GetData(const tString &tTeseoFwVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("TESEO_FW_VERSION", tTeseoFwVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsTeseoFwVersion::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsTeseoFwVersion::vSetData(tString &tTeseoFwVersionParam) {
   tU32 u32Len = (tU32)strlen(tTeseoFwVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("TESEO_FW_VERSION", tTeseoFwVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsTeseoFwVersion::vSetData(const tString &tTeseoFwVersionParam) {
   tU32 u32Len = (tU32)strlen(tTeseoFwVersionParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("TESEO_FW_VERSION", tTeseoFwVersionParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsTeseoFwVersion::vSetData(tString &tTeseoFwVersionParam, tU16 u16Len) 
{
    vSetData(tTeseoFwVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsTeseoFwVersion::vSetData(const tString &tTeseoFwVersionParam, tU16 u16Len) 
{
    vSetData(tTeseoFwVersionParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsSccAppLabel::u8GetData(tString &tSccAppLabelParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_APP_LABEL", tSccAppLabelParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsSccAppLabel::u8GetData(const tString &tSccAppLabelParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_APP_LABEL", tSccAppLabelParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsSccAppLabel::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsSccAppLabel::vSetData(tString &tSccAppLabelParam) {
   tU32 u32Len = (tU32)strlen(tSccAppLabelParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_APP_LABEL", tSccAppLabelParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsSccAppLabel::vSetData(const tString &tSccAppLabelParam) {
   tU32 u32Len = (tU32)strlen(tSccAppLabelParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_APP_LABEL", tSccAppLabelParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsSccAppLabel::vSetData(tString &tSccAppLabelParam, tU16 u16Len) 
{
    vSetData(tSccAppLabelParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsSccAppLabel::vSetData(const tString &tSccAppLabelParam, tU16 u16Len) 
{
    vSetData(tSccAppLabelParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsSccBLLabel::u8GetData(tString &tSccBLLabelParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_BL_LABEL", tSccBLLabelParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsSccBLLabel::u8GetData(const tString &tSccBLLabelParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_BL_LABEL", tSccBLLabelParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsSccBLLabel::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsSccBLLabel::vSetData(tString &tSccBLLabelParam) {
   tU32 u32Len = (tU32)strlen(tSccBLLabelParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_BL_LABEL", tSccBLLabelParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsSccBLLabel::vSetData(const tString &tSccBLLabelParam) {
   tU32 u32Len = (tU32)strlen(tSccBLLabelParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_BL_LABEL", tSccBLLabelParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsSccBLLabel::vSetData(tString &tSccBLLabelParam, tU16 u16Len) 
{
    vSetData(tSccBLLabelParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsSccBLLabel::vSetData(const tString &tSccBLLabelParam, tU16 u16Len) 
{
    vSetData(tSccBLLabelParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsSccBMLabel::u8GetData(tString &tSccBMLabelParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_BM_LABEL", tSccBMLabelParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsSccBMLabel::u8GetData(const tString &tSccBMLabelParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("SCC_BM_LABEL", tSccBMLabelParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsSccBMLabel::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsSccBMLabel::vSetData(tString &tSccBMLabelParam) {
   tU32 u32Len = (tU32)strlen(tSccBMLabelParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_BM_LABEL", tSccBMLabelParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsSccBMLabel::vSetData(const tString &tSccBMLabelParam) {
   tU32 u32Len = (tU32)strlen(tSccBMLabelParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("SCC_BM_LABEL", tSccBMLabelParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsSccBMLabel::vSetData(tString &tSccBMLabelParam, tU16 u16Len) 
{
    vSetData(tSccBMLabelParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsSccBMLabel::vSetData(const tString &tSccBMLabelParam, tU16 u16Len) 
{
    vSetData(tSccBMLabelParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsAdrHDFirmwareVer::u8GetData(tString &tAdrHDFirmwareVerParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("ADR_HD_FIRMWAREVER", tAdrHDFirmwareVerParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsAdrHDFirmwareVer::u8GetData(const tString &tAdrHDFirmwareVerParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("ADR_HD_FIRMWAREVER", tAdrHDFirmwareVerParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsAdrHDFirmwareVer::u8DataValid() const {return _u8DataStatus;};


tVoid dp_tclregVersionsAdrHDFirmwareVer::vSetData(tString &tAdrHDFirmwareVerParam) {
   tU32 u32Len = (tU32)strlen(tAdrHDFirmwareVerParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("ADR_HD_FIRMWAREVER", tAdrHDFirmwareVerParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsAdrHDFirmwareVer::vSetData(const tString &tAdrHDFirmwareVerParam) {
   tU32 u32Len = (tU32)strlen(tAdrHDFirmwareVerParam);
   if (u32Len < 255) {
       reg_tclRegKey  oReg;
       _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
       tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
       if( oReg.bOpen(cRegKeyPath)) {
          if (oReg.bSetString("ADR_HD_FIRMWAREVER", tAdrHDFirmwareVerParam, u32Len)) {
          }
       }
   }
   return;
}
tVoid dp_tclregVersionsAdrHDFirmwareVer::vSetData(tString &tAdrHDFirmwareVerParam, tU16 u16Len) 
{
    vSetData(tAdrHDFirmwareVerParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced
tVoid dp_tclregVersionsAdrHDFirmwareVer::vSetData(const tString &tAdrHDFirmwareVerParam, tU16 u16Len) 
{
    vSetData(tAdrHDFirmwareVerParam);
    (void)(u16Len);
}; //lint !e715: Symbol 'u16Len' (line 560) not referenced


tU8 dp_tclregVersionsCustomerConfigFingerprint::u8GetData(tString &tCustomerConfigFingerprintParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("CUSTOMER_CONFIG_FINGERPRINT", tCustomerConfigFingerprintParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsCustomerConfigFingerprint::u8GetData(const tString &tCustomerConfigFingerprintParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("CUSTOMER_CONFIG_FINGERPRINT", tCustomerConfigFingerprintParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsCustomerConfigFingerprint::u8DataValid() const {return _u8DataStatus;};



tU8 dp_tclregVersionsCustomerConfigPartNumber::u8GetData(tString &tCustomerConfigPartNumberParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("CUSTOMER_CONFIG_PART_NUMBER", tCustomerConfigPartNumberParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsCustomerConfigPartNumber::u8GetData(const tString &tCustomerConfigPartNumberParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("CUSTOMER_CONFIG_PART_NUMBER", tCustomerConfigPartNumberParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsCustomerConfigPartNumber::u8DataValid() const {return _u8DataStatus;};



tU8 dp_tclregVersionsBoschConfigurationID::u8GetData(tString &tBoschConfigurationIDParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BOSCH_CONFIGURATION_ID", tBoschConfigurationIDParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsBoschConfigurationID::u8GetData(const tString &tBoschConfigurationIDParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("BOSCH_CONFIGURATION_ID", tBoschConfigurationIDParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsBoschConfigurationID::u8DataValid() const {return _u8DataStatus;};



tU8 dp_tclregVersionsCustomerDefaultConfigID::u8GetData(tString &tCustomerDefaultConfigIDParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("CUSTOMER_DEFAULT_CONFIG_ID", tCustomerDefaultConfigIDParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsCustomerDefaultConfigID::u8GetData(const tString &tCustomerDefaultConfigIDParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("CUSTOMER_DEFAULT_CONFIG_ID", tCustomerDefaultConfigIDParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsCustomerDefaultConfigID::u8DataValid() const {return _u8DataStatus;};



tU8 dp_tclregVersionsCustomerVersion::u8GetData(tString &tCustomerVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("CUSTOMERVERSION", tCustomerVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8 dp_tclregVersionsCustomerVersion::u8GetData(const tString &tCustomerVersionParam, tU32 u32StringBufLen) {
   reg_tclRegKey  oReg;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bQueryString("CUSTOMERVERSION", tCustomerVersionParam, u32StringBufLen)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return _u8DataStatus;
}
tU8   dp_tclregVersionsCustomerVersion::u8DataValid() const {return _u8DataStatus;};



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AdrConfigCRC"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclregVersionsAdrConfigCRC::dp_tclregVersionsAdrConfigCRC() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tAdrConfigCRC(0)
{
   vUpdate();
}

tVoid dp_tclregVersionsAdrConfigCRC::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("ADRCONFIGCRC",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tAdrConfigCRC = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclregVersionsAdrConfigCRC::u8GetData(tU32& tAdrConfigCRCParam) {
   vUpdate();
   tAdrConfigCRCParam = tAdrConfigCRC;
   return _u8DataStatus;
}
tU32 dp_tclregVersionsAdrConfigCRC::tGetData() {
   vUpdate();
   return tAdrConfigCRC;
};

tU8 dp_tclregVersionsAdrConfigCRC::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclregVersionsAdrConfigCRC::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclregVersionsAdrConfigCRC::vSetData(tU32 &tAdrConfigCRCParam) const {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bSetU32("ADRCONFIGCRC", tAdrConfigCRCParam)) {
      }
   }
   return;
}
tVoid dp_tclregVersionsAdrConfigCRC::vSetData(const tU32 &tAdrConfigCRCParam) const {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""VERSIONS";
   if( oReg.bOpen(cRegKeyPath)) {
      if (oReg.bSetU32("ADRCONFIGCRC", tAdrConfigCRCParam)) {
      }
   }
   return;
}
tVoid dp_tclregVersionsAdrConfigCRC::operator<<(tU32 oParam) {return vSetData(oParam);};

