
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define DP_S_IMPORT_INTERFACE_KDS_FI
#include "dp_kds_if.h"
   
#include "dp_tclKdsCm.h"


//##########################################################
//#######  AIVIVariantCoding  (Key: 0xA114)          
//##########################################################

dp_tclKdsAIVIVariantCoding::dp_tclKdsAIVIVariantCoding() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_AIVIVARIANTCODING_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsAIVIVariantCoding::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsAIVIVariantCoding::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA114, 0x20, pu8CurPos)) {
      pu8CurPos += 0x20;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsAIVIVariantCoding::u8GetAIVIVariantCoding(tU8* pu8Data, tU16 u16BufLen) {
   if (0x20<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_AIVIVARIANTCODING_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsAIVIVariantCoding::u8DataValid() const {return _u8DataStatus;};
//Key 'VariantSelection':  [0,0] -> [0,3] (Bitlen: 4)
tU8 dp_tclKdsAIVIVariantCoding::u8GetVariantSelection(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'ActiveConfigurationSet':  [0,4] -> [0,7] (Bitlen: 4)
tU8 dp_tclKdsAIVIVariantCoding::u8GetActiveConfigurationSet(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'DisplayOutput':  [1,0] -> [1,0] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetDisplayOutput(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisplayOrientation':  [1,1] -> [1,1] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetDisplayOrientation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'DisplayAspectRatio':  [1,2] -> [1,3] (Bitlen: 2)
tU8 dp_tclKdsAIVIVariantCoding::u8GetDisplayAspectRatio(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0xc)>>2);
   }
   return _u8DataStatus;
}

//Key 'DispTrClockEdgeSelectLVDS1':  [1,4] -> [1,5] (Bitlen: 2)
tU8 dp_tclKdsAIVIVariantCoding::u8GetDispTrClockEdgeSelectLVDS1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x30)>>4);
   }
   return _u8DataStatus;
}

//Key 'DispTrClockEdgeSelectLVDS2':  [1,6] -> [1,7] (Bitlen: 2)
tU8 dp_tclKdsAIVIVariantCoding::u8GetDispTrClockEdgeSelectLVDS2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0xc0)>>6);
   }
   return _u8DataStatus;
}

//Key 'FM':  [2,0] -> [2,0] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'DAB':  [2,1] -> [2,1] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetDAB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'DRM':  [2,2] -> [2,2] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetDRM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'AM':  [2,3] -> [2,3] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetAM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'DTVType':  [2,4] -> [2,6] (Bitlen: 3)
tU8 dp_tclKdsAIVIVariantCoding::u8GetDTVType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x70)>>4);
   }
   return _u8DataStatus;
}

//Key 'ExtendedDTVMountInformation':  [2,7] -> [2,7] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetExtendedDTVMountInformation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'Sigma':  [3,0] -> [3,0] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetSigma(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'SecurityAccessKeySelector':  [3,1] -> [3,1] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetSecurityAccessKeySelector(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'ConsistencyCheckSupport':  [3,2] -> [3,2] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetConsistencyCheckSupport(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'HDMI':  [4,0] -> [4,3] (Bitlen: 4)
tU8 dp_tclKdsAIVIVariantCoding::u8GetHDMI(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'LVDS1':  [4,4] -> [4,7] (Bitlen: 4)
tU8 dp_tclKdsAIVIVariantCoding::u8GetLVDS1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'LVDS2':  [5,0] -> [5,3] (Bitlen: 4)
tU8 dp_tclKdsAIVIVariantCoding::u8GetLVDS2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'VGA':  [5,4] -> [5,7] (Bitlen: 4)
tU8 dp_tclKdsAIVIVariantCoding::u8GetVGA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'SoftkeysConfiguration':  [6,0] -> [6,3] (Bitlen: 4)
tU8 dp_tclKdsAIVIVariantCoding::u8GetSoftkeysConfiguration(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'DualDisplaySupport':  [6,4] -> [6,4] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetDualDisplaySupport(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'EncoderMirroring':  [6,5] -> [6,5] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetEncoderMirroring(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key '2ndEncoderMissing':  [6,6] -> [6,6] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8Get2ndEncoderMissing(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'ManagedApp':  [7,0] -> [7,0] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetManagedApp(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[7]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'SystemTypeSelector':  [7,1] -> [7,4] (Bitlen: 4)
tU8 dp_tclKdsAIVIVariantCoding::u8GetSystemTypeSelector(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[7]&0x1e)>>1);
   }
   return _u8DataStatus;
}

//Key 'BeaconSupport':  [7,5] -> [7,5] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetBeaconSupport(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[7]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'ExtendedDVDMountInformation':  [7,6] -> [7,6] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetExtendedDVDMountInformation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[7]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'HDMIApp':  [7,7] -> [7,7] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetHDMIApp(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[7]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'VDIAG':  [8,0] -> [8,7] (Bitlen: 8)
tU8 dp_tclKdsAIVIVariantCoding::u8GetVDIAG(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CVBS':  [9,0] -> [9,0] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetCVBS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[9]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'LVDS':  [9,1] -> [9,1] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetLVDS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[9]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'Ethernet':  [9,2] -> [9,2] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetEthernet(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[9]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'TouchI2CAddress':  [10,0] -> [11,7] (Bitlen: 16)
tU8 dp_tclKdsAIVIVariantCoding::u8GetTouchI2CAddress(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[10], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SpreadSpectrumClockGenerationLVDS':  [12,0] -> [13,7] (Bitlen: 16)
tU8 dp_tclKdsAIVIVariantCoding::u8GetSpreadSpectrumClockGenerationLVDS(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[12], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'VRProcessStartAllowed':  [14,0] -> [14,0] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetVRProcessStartAllowed(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'TTSProcessStartAllowed':  [14,1] -> [14,1] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetTTSProcessStartAllowed(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'HourLogicEnabled':  [15,0] -> [15,7] (Bitlen: 8)
tU8 dp_tclKdsAIVIVariantCoding::u8GetHourLogicEnabled(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'HourLogicTimeRange':  [16,0] -> [16,7] (Bitlen: 8)
tU8 dp_tclKdsAIVIVariantCoding::u8GetHourLogicTimeRange(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[16]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MFICertified':  [17,0] -> [17,0] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetMFICertified(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'IOSMySpin':  [17,2] -> [17,2] (Bitlen: 1)
tU8 dp_tclKdsAIVIVariantCoding::u8GetIOSMySpin(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'StandbyTimeout':  [18,0] -> [19,7] (Bitlen: 16)
tU8 dp_tclKdsAIVIVariantCoding::u8GetStandbyTimeout(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[18], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  SensorConfigACC  (Key: 0x0780)          
//##########################################################

dp_tclKdsSensorConfigACC::dp_tclKdsSensorConfigACC() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_SENSORCONFIGACC_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsSensorConfigACC::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsSensorConfigACC::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x0780, 0xcb, pu8CurPos)) {
      pu8CurPos += 0xcb;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsSensorConfigACC::u8GetSensorConfigACC(tU8* pu8Data, tU16 u16BufLen) {
   if (0xcb<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_SENSORCONFIGACC_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsSensorConfigACC::u8DataValid() const {return _u8DataStatus;};
//Key 'Tag':  [0,0] -> [7,7] (Bitlen: 64)
tU8 dp_tclKdsSensorConfigACC::u8GetTag(tU8* pu8Data, tU16 u16BufLen) {
   if (8<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 8);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MajorVersion':  [8,0] -> [8,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMajorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinorVersion':  [9,0] -> [10,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[9], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'ACCAngRX':  [11,0] -> [11,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetACCAngRX(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ACCAngRY':  [12,0] -> [12,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetACCAngRY(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ACCAngRZ':  [13,0] -> [13,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetACCAngRZ(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ACCAngSX':  [14,0] -> [14,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetACCAngSX(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ACCAngSY':  [15,0] -> [15,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetACCAngSY(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ACCAngSZ':  [16,0] -> [16,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetACCAngSZ(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[16]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ACCAngTX':  [17,0] -> [17,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetACCAngTX(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ACCAngTY':  [18,0] -> [18,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetACCAngTY(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ACCAngTZ':  [19,0] -> [19,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetACCAngTZ(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[19]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AdcRangeMin':  [20,0] -> [23,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigACC::u8GetAdcRangeMin(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[20], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'AdcRangeMax':  [24,0] -> [27,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigACC::u8GetAdcRangeMax(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[24], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SampleMin':  [28,0] -> [31,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigACC::u8GetSampleMin(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[28], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SampleMax':  [32,0] -> [35,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigACC::u8GetSampleMax(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[32], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinNoiseValueM':  [36,0] -> [37,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMinNoiseValueM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[36], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinNoiseValueE':  [38,0] -> [38,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMinNoiseValueE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[38]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EstimOffsetM':  [39,0] -> [40,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetEstimOffsetM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[39], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'EstimOffsetE':  [41,0] -> [41,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetEstimOffsetE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[41]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinOffsetM':  [42,0] -> [43,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMinOffsetM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[42], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinOffsetE':  [44,0] -> [44,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMinOffsetE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[44]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxOffsetM':  [45,0] -> [46,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxOffsetM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[45], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxOffsetE':  [47,0] -> [47,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxOffsetE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[47]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetM':  [48,0] -> [49,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftOffsetM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[48], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetE':  [50,0] -> [50,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftOffsetE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[50]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadOffsetM':  [51,0] -> [52,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxUnsteadOffsetM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[51], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadOffsetE':  [53,0] -> [53,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxUnsteadOffsetE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[53]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BestCalibOffsetM':  [54,0] -> [55,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetBestCalibOffsetM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[54], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BestCalibOffsetE':  [56,0] -> [56,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetBestCalibOffsetE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[56]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EstimScaleFactorM':  [57,0] -> [58,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetEstimScaleFactorM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[57], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'EstimScaleFactorE':  [59,0] -> [59,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetEstimScaleFactorE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[59]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinScaleFactorM':  [60,0] -> [61,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMinScaleFactorM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[60], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinScaleFactorE':  [62,0] -> [62,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMinScaleFactorE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[62]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxScaleFactorM':  [63,0] -> [64,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxScaleFactorM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[63], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxScaleFactorE':  [65,0] -> [65,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxScaleFactorE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[65]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorM':  [66,0] -> [67,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftScaleFactorM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[66], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorE':  [68,0] -> [68,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftScaleFactorE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[68]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadScaleFactorM':  [69,0] -> [70,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxUnsteadScaleFactorM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[69], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadScaleFactorE':  [71,0] -> [71,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxUnsteadScaleFactorE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[71]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BestCalibScaleFactorM':  [72,0] -> [73,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetBestCalibScaleFactorM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[72], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BestCalibScaleFactorE':  [74,0] -> [74,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetBestCalibScaleFactorE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[74]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetTimeM':  [75,0] -> [76,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftOffsetTimeM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[75], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetTimeE':  [77,0] -> [77,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftOffsetTimeE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[77]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorTimeM':  [78,0] -> [79,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftScaleFactorTimeM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[78], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorTimeE':  [80,0] -> [80,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftScaleFactorTimeE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[80]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AdcRangeMin2':  [81,0] -> [84,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigACC::u8GetAdcRangeMin2(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[81], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'AdcRangeMax2':  [85,0] -> [88,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigACC::u8GetAdcRangeMax2(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[85], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SampleMin2':  [89,0] -> [92,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigACC::u8GetSampleMin2(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[89], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SampleMax2':  [93,0] -> [96,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigACC::u8GetSampleMax2(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[93], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinNoiseValueM2':  [97,0] -> [98,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMinNoiseValueM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[97], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinNoiseValueE2':  [99,0] -> [99,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMinNoiseValueE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[99]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EstimOffsetM2':  [100,0] -> [101,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetEstimOffsetM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[100], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'EstimOffsetE2':  [102,0] -> [102,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetEstimOffsetE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[102]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinOffsetM2':  [103,0] -> [104,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMinOffsetM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[103], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinOffsetE2':  [105,0] -> [105,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMinOffsetE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[105]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxOffsetM2':  [106,0] -> [107,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxOffsetM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[106], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxOffsetE2':  [108,0] -> [108,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxOffsetE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[108]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetM2':  [109,0] -> [110,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftOffsetM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[109], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetE2':  [111,0] -> [111,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftOffsetE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[111]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadOffsetM2':  [112,0] -> [113,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxUnsteadOffsetM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[112], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadOffsetE2':  [114,0] -> [114,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxUnsteadOffsetE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[114]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BestCalibOffsetM2':  [115,0] -> [116,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetBestCalibOffsetM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[115], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BestCalibOffsetE2':  [117,0] -> [117,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetBestCalibOffsetE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[117]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EstimScaleFactorM2':  [118,0] -> [119,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetEstimScaleFactorM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[118], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'EstimScaleFactorE2':  [120,0] -> [120,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetEstimScaleFactorE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[120]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinScaleFactorM2':  [121,0] -> [122,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMinScaleFactorM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[121], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinScaleFactorE2':  [123,0] -> [123,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMinScaleFactorE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[123]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxScaleFactorM2':  [124,0] -> [125,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxScaleFactorM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[124], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxScaleFactorE2':  [126,0] -> [126,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxScaleFactorE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[126]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorM2':  [127,0] -> [128,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftScaleFactorM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[127], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorE2':  [129,0] -> [129,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftScaleFactorE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[129]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadScaleFactorM2':  [130,0] -> [131,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxUnsteadScaleFactorM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[130], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadScaleFactorE2':  [132,0] -> [132,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxUnsteadScaleFactorE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[132]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BestCalibScaleFactorM2':  [133,0] -> [134,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetBestCalibScaleFactorM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[133], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BestCalibScaleFactorE2':  [135,0] -> [135,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetBestCalibScaleFactorE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[135]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetTimeM2':  [136,0] -> [137,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftOffsetTimeM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[136], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetTimeE2':  [138,0] -> [138,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftOffsetTimeE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[138]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorTimeM2':  [139,0] -> [140,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftScaleFactorTimeM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[139], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorTimeE2':  [141,0] -> [141,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftScaleFactorTimeE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[141]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AdcRangeMin3':  [142,0] -> [145,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigACC::u8GetAdcRangeMin3(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[142], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'AdcRangeMax3':  [146,0] -> [149,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigACC::u8GetAdcRangeMax3(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[146], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SampleMin3':  [150,0] -> [153,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigACC::u8GetSampleMin3(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[150], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SampleMax3':  [154,0] -> [157,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigACC::u8GetSampleMax3(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[154], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinNoiseValueM3':  [158,0] -> [159,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMinNoiseValueM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[158], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinNoiseValueE3':  [160,0] -> [160,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMinNoiseValueE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[160]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EstimOffsetM3':  [161,0] -> [162,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetEstimOffsetM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[161], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'EstimOffsetE3':  [163,0] -> [163,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetEstimOffsetE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[163]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinOffsetM3':  [164,0] -> [165,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMinOffsetM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[164], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinOffsetE3':  [166,0] -> [166,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMinOffsetE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[166]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxOffsetM3':  [167,0] -> [168,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxOffsetM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[167], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxOffsetE3':  [169,0] -> [169,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxOffsetE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[169]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetM3':  [170,0] -> [171,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftOffsetM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[170], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetE3':  [172,0] -> [172,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftOffsetE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[172]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadOffsetM3':  [173,0] -> [174,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxUnsteadOffsetM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[173], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadOffsetE3':  [175,0] -> [175,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxUnsteadOffsetE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[175]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BestCalibOffsetM3':  [176,0] -> [177,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetBestCalibOffsetM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[176], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BestCalibOffsetE3':  [178,0] -> [178,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetBestCalibOffsetE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[178]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EstimScaleFactorM3':  [179,0] -> [180,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetEstimScaleFactorM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[179], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'EstimScaleFactorE3':  [181,0] -> [181,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetEstimScaleFactorE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[181]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinScaleFactorM3':  [182,0] -> [183,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMinScaleFactorM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[182], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinScaleFactorE3':  [184,0] -> [184,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMinScaleFactorE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[184]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxScaleFactorM3':  [185,0] -> [186,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxScaleFactorM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[185], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxScaleFactorE3':  [187,0] -> [187,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxScaleFactorE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[187]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorM3':  [188,0] -> [189,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftScaleFactorM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[188], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorE3':  [190,0] -> [190,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftScaleFactorE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[190]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadScaleFactorM3':  [191,0] -> [192,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxUnsteadScaleFactorM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[191], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadScaleFactorE3':  [193,0] -> [193,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetMaxUnsteadScaleFactorE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[193]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BestCalibScaleFactorM3':  [194,0] -> [195,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetBestCalibScaleFactorM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[194], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BestCalibScaleFactorE3':  [196,0] -> [196,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetBestCalibScaleFactorE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[196]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetTimeM3':  [197,0] -> [198,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftOffsetTimeM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[197], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetTimeE3':  [199,0] -> [199,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftOffsetTimeE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[199]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorTimeM3':  [200,0] -> [201,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftScaleFactorTimeM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[200], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorTimeE3':  [202,0] -> [202,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigACC::u8GetDriftScaleFactorTimeE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[202]&0xff)>>0);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  SensorConfigGNSS  (Key: 0x0530)          
//##########################################################

dp_tclKdsSensorConfigGNSS::dp_tclKdsSensorConfigGNSS() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_SENSORCONFIGGNSS_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsSensorConfigGNSS::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsSensorConfigGNSS::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x0530, 0xc, pu8CurPos)) {
      pu8CurPos += 0xc;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsSensorConfigGNSS::u8GetSensorConfigGNSS(tU8* pu8Data, tU16 u16BufLen) {
   if (0xc<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_SENSORCONFIGGNSS_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsSensorConfigGNSS::u8DataValid() const {return _u8DataStatus;};
//Key 'Tag':  [0,0] -> [7,7] (Bitlen: 64)
tU8 dp_tclKdsSensorConfigGNSS::u8GetTag(tU8* pu8Data, tU16 u16BufLen) {
   if (8<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 8);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MajorVersion':  [8,0] -> [8,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGNSS::u8GetMajorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinorVersion':  [9,0] -> [10,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGNSS::u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[9], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'GPS':  [11,0] -> [11,0] (Bitlen: 1)
tU8 dp_tclKdsSensorConfigGNSS::u8GetGPS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'GLONASS':  [11,1] -> [11,1] (Bitlen: 1)
tU8 dp_tclKdsSensorConfigGNSS::u8GetGLONASS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'GALILEO':  [11,2] -> [11,2] (Bitlen: 1)
tU8 dp_tclKdsSensorConfigGNSS::u8GetGALILEO(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'COMPASS':  [11,3] -> [11,3] (Bitlen: 1)
tU8 dp_tclKdsSensorConfigGNSS::u8GetCOMPASS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'SBAS':  [11,4] -> [11,4] (Bitlen: 1)
tU8 dp_tclKdsSensorConfigGNSS::u8GetSBAS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'QZSS':  [11,5] -> [11,5] (Bitlen: 1)
tU8 dp_tclKdsSensorConfigGNSS::u8GetQZSS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x20)>>5);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  SensorConfigGyro  (Key: 0x0700)          
//##########################################################

dp_tclKdsSensorConfigGyro::dp_tclKdsSensorConfigGyro() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_SENSORCONFIGGYRO_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsSensorConfigGyro::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsSensorConfigGyro::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x0700, 0xcb, pu8CurPos)) {
      pu8CurPos += 0xcb;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsSensorConfigGyro::u8GetSensorConfigGyro(tU8* pu8Data, tU16 u16BufLen) {
   if (0xcb<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_SENSORCONFIGGYRO_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsSensorConfigGyro::u8DataValid() const {return _u8DataStatus;};
//Key 'Tag':  [0,0] -> [7,7] (Bitlen: 64)
tU8 dp_tclKdsSensorConfigGyro::u8GetTag(tU8* pu8Data, tU16 u16BufLen) {
   if (8<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 8);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MajorVersion':  [8,0] -> [8,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMajorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinorVersion':  [9,0] -> [10,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[9], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'GyroAngRX':  [11,0] -> [11,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetGyroAngRX(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'GyroAngRY':  [12,0] -> [12,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetGyroAngRY(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'GyroAngRZ':  [13,0] -> [13,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetGyroAngRZ(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'GyroAngSX':  [14,0] -> [14,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetGyroAngSX(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'GyroAngSY':  [15,0] -> [15,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetGyroAngSY(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'GyroAngSZ':  [16,0] -> [16,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetGyroAngSZ(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[16]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'GyroAngTX':  [17,0] -> [17,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetGyroAngTX(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'GyroAngTY':  [18,0] -> [18,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetGyroAngTY(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'GyroAngTZ':  [19,0] -> [19,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetGyroAngTZ(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[19]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AdcRangeMin':  [20,0] -> [23,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigGyro::u8GetAdcRangeMin(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[20], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'AdcRangeMax':  [24,0] -> [27,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigGyro::u8GetAdcRangeMax(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[24], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SampleMin':  [28,0] -> [31,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigGyro::u8GetSampleMin(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[28], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SampleMax':  [32,0] -> [35,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigGyro::u8GetSampleMax(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[32], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinNoiseValueM':  [36,0] -> [37,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinNoiseValueM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[36], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinNoiseValueE':  [38,0] -> [38,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinNoiseValueE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[38]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EstimOffsetM':  [39,0] -> [40,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetEstimOffsetM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[39], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'EstimOffsetE':  [41,0] -> [41,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetEstimOffsetE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[41]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinOffsetM':  [42,0] -> [43,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinOffsetM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[42], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinOffsetE':  [44,0] -> [44,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinOffsetE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[44]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxOffsetM':  [45,0] -> [46,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxOffsetM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[45], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxOffsetE':  [47,0] -> [47,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxOffsetE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[47]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetM':  [48,0] -> [49,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftOffsetM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[48], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetE':  [50,0] -> [50,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftOffsetE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[50]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadOffsetM':  [51,0] -> [52,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxUnsteadOffsetM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[51], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadOffsetE':  [53,0] -> [53,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxUnsteadOffsetE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[53]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BestCalibOffsetM':  [54,0] -> [55,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetBestCalibOffsetM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[54], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BestCalibOffsetE':  [56,0] -> [56,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetBestCalibOffsetE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[56]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EstimScaleFactorM':  [57,0] -> [58,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetEstimScaleFactorM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[57], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'EstimScaleFactorE':  [59,0] -> [59,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetEstimScaleFactorE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[59]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinScaleFactorM':  [60,0] -> [61,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinScaleFactorM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[60], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinScaleFactorE':  [62,0] -> [62,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinScaleFactorE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[62]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxScaleFactorM':  [63,0] -> [64,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxScaleFactorM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[63], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxScaleFactorE':  [65,0] -> [65,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxScaleFactorE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[65]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorM':  [66,0] -> [67,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftScaleFactorM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[66], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorE':  [68,0] -> [68,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftScaleFactorE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[68]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadScaleFactorM':  [69,0] -> [70,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxUnsteadScaleFactorM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[69], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadScaleFactorE':  [71,0] -> [71,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxUnsteadScaleFactorE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[71]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BestCalibScaleFactorM':  [72,0] -> [73,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetBestCalibScaleFactorM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[72], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BestCalibScaleFactorE':  [74,0] -> [74,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetBestCalibScaleFactorE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[74]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetTimeM':  [75,0] -> [76,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftOffsetTimeM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[75], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetTimeE':  [77,0] -> [77,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftOffsetTimeE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[77]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorTimeM':  [78,0] -> [79,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftScaleFactorTimeM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[78], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorTimeE':  [80,0] -> [80,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftScaleFactorTimeE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[80]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AdcRangeMin2':  [81,0] -> [84,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigGyro::u8GetAdcRangeMin2(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[81], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'AdcRangeMax2':  [85,0] -> [88,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigGyro::u8GetAdcRangeMax2(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[85], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SampleMin2':  [89,0] -> [92,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigGyro::u8GetSampleMin2(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[89], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SampleMax2':  [93,0] -> [96,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigGyro::u8GetSampleMax2(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[93], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinNoiseValueM2':  [97,0] -> [98,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinNoiseValueM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[97], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinNoiseValueE2':  [99,0] -> [99,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinNoiseValueE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[99]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EstimOffsetM2':  [100,0] -> [101,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetEstimOffsetM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[100], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'EstimOffsetE2':  [102,0] -> [102,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetEstimOffsetE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[102]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinOffsetM2':  [103,0] -> [104,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinOffsetM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[103], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinOffsetE2':  [105,0] -> [105,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinOffsetE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[105]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxOffsetM2':  [106,0] -> [107,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxOffsetM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[106], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxOffsetE2':  [108,0] -> [108,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxOffsetE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[108]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetM2':  [109,0] -> [110,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftOffsetM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[109], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetE2':  [111,0] -> [111,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftOffsetE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[111]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadOffsetM2':  [112,0] -> [113,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxUnsteadOffsetM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[112], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadOffsetE2':  [114,0] -> [114,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxUnsteadOffsetE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[114]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BestCalibOffsetM2':  [115,0] -> [116,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetBestCalibOffsetM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[115], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BestCalibOffsetE2':  [117,0] -> [117,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetBestCalibOffsetE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[117]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EstimScaleFactorM2':  [118,0] -> [119,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetEstimScaleFactorM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[118], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'EstimScaleFactorE2':  [120,0] -> [120,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetEstimScaleFactorE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[120]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinScaleFactorM2':  [121,0] -> [122,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinScaleFactorM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[121], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinScaleFactorE2':  [123,0] -> [123,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinScaleFactorE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[123]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxScaleFactorM2':  [124,0] -> [125,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxScaleFactorM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[124], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxScaleFactorE2':  [126,0] -> [126,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxScaleFactorE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[126]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorM2':  [127,0] -> [128,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftScaleFactorM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[127], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorE2':  [129,0] -> [129,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftScaleFactorE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[129]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadScaleFactorM2':  [130,0] -> [131,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxUnsteadScaleFactorM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[130], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadScaleFactorE2':  [132,0] -> [132,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxUnsteadScaleFactorE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[132]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BestCalibScaleFactorM2':  [133,0] -> [134,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetBestCalibScaleFactorM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[133], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BestCalibScaleFactorE2':  [135,0] -> [135,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetBestCalibScaleFactorE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[135]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetTimeM2':  [136,0] -> [137,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftOffsetTimeM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[136], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetTimeE2':  [138,0] -> [138,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftOffsetTimeE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[138]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorTimeM2':  [139,0] -> [140,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftScaleFactorTimeM2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[139], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorTimeE2':  [141,0] -> [141,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftScaleFactorTimeE2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[141]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AdcRangeMin3':  [142,0] -> [145,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigGyro::u8GetAdcRangeMin3(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[142], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'AdcRangeMax3':  [146,0] -> [149,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigGyro::u8GetAdcRangeMax3(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[146], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SampleMin3':  [150,0] -> [153,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigGyro::u8GetSampleMin3(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[150], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SampleMax3':  [154,0] -> [157,7] (Bitlen: 32)
tU8 dp_tclKdsSensorConfigGyro::u8GetSampleMax3(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[154], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinNoiseValueM3':  [158,0] -> [159,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinNoiseValueM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[158], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinNoiseValueE3':  [160,0] -> [160,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinNoiseValueE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[160]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EstimOffsetM3':  [161,0] -> [162,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetEstimOffsetM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[161], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'EstimOffsetE3':  [163,0] -> [163,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetEstimOffsetE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[163]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinOffsetM3':  [164,0] -> [165,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinOffsetM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[164], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinOffsetE3':  [166,0] -> [166,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinOffsetE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[166]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxOffsetM3':  [167,0] -> [168,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxOffsetM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[167], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxOffsetE3':  [169,0] -> [169,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxOffsetE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[169]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetM3':  [170,0] -> [171,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftOffsetM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[170], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetE3':  [172,0] -> [172,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftOffsetE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[172]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadOffsetM3':  [173,0] -> [174,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxUnsteadOffsetM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[173], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadOffsetE3':  [175,0] -> [175,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxUnsteadOffsetE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[175]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BestCalibOffsetM3':  [176,0] -> [177,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetBestCalibOffsetM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[176], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BestCalibOffsetE3':  [178,0] -> [178,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetBestCalibOffsetE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[178]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EstimScaleFactorM3':  [179,0] -> [180,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetEstimScaleFactorM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[179], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'EstimScaleFactorE3':  [181,0] -> [181,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetEstimScaleFactorE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[181]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinScaleFactorM3':  [182,0] -> [183,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinScaleFactorM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[182], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinScaleFactorE3':  [184,0] -> [184,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMinScaleFactorE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[184]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxScaleFactorM3':  [185,0] -> [186,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxScaleFactorM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[185], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxScaleFactorE3':  [187,0] -> [187,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxScaleFactorE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[187]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorM3':  [188,0] -> [189,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftScaleFactorM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[188], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorE3':  [190,0] -> [190,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftScaleFactorE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[190]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadScaleFactorM3':  [191,0] -> [192,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxUnsteadScaleFactorM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[191], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxUnsteadScaleFactorE3':  [193,0] -> [193,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetMaxUnsteadScaleFactorE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[193]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BestCalibScaleFactorM3':  [194,0] -> [195,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetBestCalibScaleFactorM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[194], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BestCalibScaleFactorE3':  [196,0] -> [196,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetBestCalibScaleFactorE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[196]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetTimeM3':  [197,0] -> [198,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftOffsetTimeM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[197], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftOffsetTimeE3':  [199,0] -> [199,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftOffsetTimeE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[199]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorTimeM3':  [200,0] -> [201,7] (Bitlen: 16)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftScaleFactorTimeM3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[200], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DriftScaleFactorTimeE3':  [202,0] -> [202,7] (Bitlen: 8)
tU8 dp_tclKdsSensorConfigGyro::u8GetDriftScaleFactorTimeE3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[202]&0xff)>>0);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  GenericTunerParameter  (Key: 0x0421)          
//##########################################################

dp_tclKdsGenericTunerParameter::dp_tclKdsGenericTunerParameter() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_GENERICTUNERPARAMETER_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsGenericTunerParameter::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsGenericTunerParameter::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x0420, 0xe6, pu8CurPos)) {
      pu8CurPos += 0xe6;//lint !e416 Likely creation of out-of-bounds pointer
      if (bReadEntry(0x0421, 0xbb, pu8CurPos)) {
         pu8CurPos += 0xbb;//lint !e416 Likely creation of out-of-bounds pointer
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsGenericTunerParameter::u8GetGenericTunerParameter(tU8* pu8Data, tU16 u16BufLen) {
   if (0xbb<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_GENERICTUNERPARAMETER_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsGenericTunerParameter::u8DataValid() const {return _u8DataStatus;};
//Key 'Tag':  [0,0] -> [7,7] (Bitlen: 64)
tU8 dp_tclKdsGenericTunerParameter::u8GetTag(tU8* pu8Data, tU16 u16BufLen) {
   if (8<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 8);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MajorVersion':  [8,0] -> [8,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetMajorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinorVersion':  [9,0] -> [10,7] (Bitlen: 16)
tU8 dp_tclKdsGenericTunerParameter::u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[9], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'FM1List':  [11,0] -> [11,0] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetFM1List(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'FM2List':  [11,1] -> [11,1] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetFM2List(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'FM3List':  [11,2] -> [11,2] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetFM3List(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'FMASTList':  [11,3] -> [11,3] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetFMASTList(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'AMMW1List':  [11,4] -> [11,4] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetAMMW1List(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'AMMW2List':  [11,5] -> [11,5] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetAMMW2List(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'AMMW3List':  [11,6] -> [11,6] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetAMMW3List(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'AMMWASTList':  [11,7] -> [11,7] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetAMMWASTList(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'AMLW1List':  [12,0] -> [12,0] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetAMLW1List(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'AMLW2List':  [12,1] -> [12,1] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetAMLW2List(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'AMLW3List':  [12,2] -> [12,2] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetAMLW3List(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'AMLWASTList':  [12,3] -> [12,3] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetAMLWASTList(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'DAB1List':  [12,4] -> [12,4] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetDAB1List(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'DAB2List':  [12,5] -> [12,5] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetDAB2List(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'DAB3List':  [12,6] -> [12,6] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetDAB3List(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'DABASTList':  [12,7] -> [12,7] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetDABASTList(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'MIX1List':  [13,0] -> [13,0] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetMIX1List(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'MIX2List':  [13,1] -> [13,1] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetMIX2List(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'MIX3List':  [13,2] -> [13,2] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetMIX3List(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'MIXASTList':  [13,3] -> [13,3] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetMIXASTList(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'AutostoreUnusedPresetParameter':  [15,0] -> [15,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAutostoreUnusedPresetParameter(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'InitialAutostoreNoOfStations':  [16,0] -> [16,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetInitialAutostoreNoOfStations(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[16]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'UserAutostoreNoOfStations':  [17,0] -> [17,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetUserAutostoreNoOfStations(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AutostoreSortingCriteriaFM':  [18,0] -> [18,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAutostoreSortingCriteriaFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AutostoreSortingCriteriaAM':  [19,0] -> [19,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAutostoreSortingCriteriaAM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[19]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AutostoreSortingCriteriaDAB':  [20,0] -> [20,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAutostoreSortingCriteriaDAB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[20]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ShowFrequencyUpdates':  [21,0] -> [21,0] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetShowFrequencyUpdates(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[21]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'NoLearnSeek':  [21,1] -> [21,1] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetNoLearnSeek(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[21]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'TunnelCheck':  [21,2] -> [21,2] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetTunnelCheck(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[21]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'InitialAutostoreBehavior':  [22,0] -> [22,0] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetInitialAutostoreBehavior(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[22]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'DefaultBandAfterInitialAutostore':  [22,4] -> [22,7] (Bitlen: 4)
tU8 dp_tclKdsGenericTunerParameter::u8GetDefaultBandAfterInitialAutostore(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[22]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'UserAutostoreBehavior':  [23,0] -> [23,0] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetUserAutostoreBehavior(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[23]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'DefaultBandAfterUserAutostore':  [23,4] -> [23,7] (Bitlen: 4)
tU8 dp_tclKdsGenericTunerParameter::u8GetDefaultBandAfterUserAutostore(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[23]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'MuteOrAttenuationForAbsoluteStationChangeAMFM':  [40,0] -> [40,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetMuteOrAttenuationForAbsoluteStationChangeAMFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[40]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MuteOrAttenuationForSeekAMFM':  [41,0] -> [41,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetMuteOrAttenuationForSeekAMFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[41]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MuteOrAttenuationForManualTuningAMFM':  [42,0] -> [42,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetMuteOrAttenuationForManualTuningAMFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimeToReleaseAttenuationAMFM':  [43,0] -> [43,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetTimeToReleaseAttenuationAMFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[43]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ConsiderLevelCompensationForPresetLoad':  [47,0] -> [47,0] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetConsiderLevelCompensationForPresetLoad(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[47]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'ConsiderLevelCompensationForListLoad':  [47,1] -> [47,1] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetConsiderLevelCompensationForListLoad(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[47]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'MonitorFMTAInAMWithTuner2':  [54,0] -> [54,0] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetMonitorFMTAInAMWithTuner2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[54]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMTAMonitorTuner2':  [54,1] -> [54,2] (Bitlen: 2)
tU8 dp_tclKdsGenericTunerParameter::u8GetFMTAMonitorTuner2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[54]&0x6)>>1);
   }
   return _u8DataStatus;
}

//Key 'AudioTunerTPSeek':  [55,0] -> [55,0] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetAudioTunerTPSeek(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[55]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementRequestHandling':  [56,0] -> [56,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementRequestHandling(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[56]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMTPseekStrategy':  [57,0] -> [57,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetFMTPseekStrategy(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[57]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimeDelayFMTPStationAfterVolumeZero':  [58,0] -> [58,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetTimeDelayFMTPStationAfterVolumeZero(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimeDelayNoFMTPStationFound':  [59,0] -> [59,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetTimeDelayNoFMTPStationFound(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[59]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimeDelayFMTPStationSelectAfterRDSLost':  [60,0] -> [60,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetTimeDelayFMTPStationSelectAfterRDSLost(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[60]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimeFMTAEndAfterRDSLost':  [61,0] -> [61,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetTimeFMTAEndAfterRDSLost(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[61]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BackgroundTA':  [62,0] -> [62,0] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetBackgroundTA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[62]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMTAInDABIfNoDABTA':  [63,0] -> [63,0] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetFMTAInDABIfNoDABTA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[63]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'DABTAInFMIfNoFMTA':  [63,1] -> [63,1] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetDABTAInFMIfNoFMTA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[63]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'PreferedTASource':  [63,2] -> [63,2] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreferedTASource(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[63]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioFMTA':  [64,0] -> [64,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioFMTA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[64]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioFMPTY31':  [65,0] -> [65,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioFMPTY31(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[65]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioFMNEWS':  [66,0] -> [66,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioFMNEWS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[66]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABAlarm':  [67,0] -> [67,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABAlarm(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[67]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABRoadTrafficFlash':  [68,0] -> [68,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABRoadTrafficFlash(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[68]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABTransportFlash':  [69,0] -> [69,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABTransportFlash(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[69]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABWarningService':  [70,0] -> [70,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABWarningService(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[70]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABNewsFlash':  [71,0] -> [71,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABNewsFlash(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[71]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABAreaWeatherFlash':  [72,0] -> [72,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABAreaWeatherFlash(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[72]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABEventAnnouncement':  [73,0] -> [73,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABEventAnnouncement(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[73]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABSpecialEvent':  [74,0] -> [74,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABSpecialEvent(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[74]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABProgramInformation':  [75,0] -> [75,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABProgramInformation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[75]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABSportReport':  [76,0] -> [76,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABSportReport(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[76]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABFinantialReport':  [77,0] -> [77,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABFinantialReport(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[77]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABReserved1':  [78,0] -> [78,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABReserved1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[78]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABReserved2':  [79,0] -> [79,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABReserved2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[79]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABReserved3':  [80,0] -> [80,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABReserved3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[80]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABReserved4':  [81,0] -> [81,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABReserved4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[81]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnnouncementPrioDABReserved5':  [82,0] -> [82,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetAnnouncementPrioDABReserved5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[82]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimeDelayNoDABTPStationFound':  [83,0] -> [83,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetTimeDelayNoDABTPStationFound(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[83]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimeDABAnnoEndAfterReceptionLost':  [84,0] -> [84,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetTimeDABAnnoEndAfterReceptionLost(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[84]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FM':  [93,0] -> [93,0] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[93]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'DAB':  [93,1] -> [93,1] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetDAB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[93]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'XM':  [93,2] -> [93,2] (Bitlen: 1)
tU8 dp_tclKdsGenericTunerParameter::u8GetXM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[93]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'NumberOfPresetListSXM':  [128,0] -> [128,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfPresetListSXM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[128]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfPresetsPerBankSXM':  [129,0] -> [129,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfPresetsPerBankSXM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[129]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'PresetListType':  [134,0] -> [134,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetPresetListType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[134]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfPresetListFM':  [135,0] -> [135,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfPresetListFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[135]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfBanksHmiFM':  [136,0] -> [136,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfBanksHmiFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[136]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfPresetsPerBankFM':  [137,0] -> [137,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfPresetsPerBankFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[137]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfPresetListMW':  [139,0] -> [139,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfPresetListMW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[139]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfBanksHmiMW':  [140,0] -> [140,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfBanksHmiMW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[140]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfPresetsPerBankMW':  [141,0] -> [141,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfPresetsPerBankMW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[141]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfPresetListLW':  [143,0] -> [143,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfPresetListLW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[143]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfBanksHmiLW':  [144,0] -> [144,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfBanksHmiLW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[144]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfPresetsPerBankLW':  [145,0] -> [145,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfPresetsPerBankLW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[145]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfPresetListDAB':  [147,0] -> [147,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfPresetListDAB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[147]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfBanksHmiDAB':  [148,0] -> [148,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfBanksHmiDAB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[148]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfPresetsPerBankDAB':  [149,0] -> [149,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfPresetsPerBankDAB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[149]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfPresetListForMixedAllBands':  [151,0] -> [151,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfPresetListForMixedAllBands(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[151]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfBanksHmiForMixedAllBands':  [152,0] -> [152,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfBanksHmiForMixedAllBands(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[152]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfPresetsPerBankForMixedAllBands':  [153,0] -> [153,7] (Bitlen: 8)
tU8 dp_tclKdsGenericTunerParameter::u8GetNumberOfPresetsPerBankForMixedAllBands(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[153]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'Preset0':  [171,0] -> [174,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset0(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[171], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset1':  [175,0] -> [178,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset1(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[175], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset2':  [179,0] -> [182,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset2(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[179], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset3':  [183,0] -> [186,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset3(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[183], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset4':  [187,0] -> [190,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset4(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[187], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset5':  [191,0] -> [194,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset5(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[191], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset6':  [195,0] -> [198,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset6(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[195], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset7':  [199,0] -> [202,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset7(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[199], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset8':  [203,0] -> [206,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset8(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[203], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset9':  [207,0] -> [210,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset9(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[207], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset10':  [211,0] -> [214,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset10(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[211], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset11':  [215,0] -> [218,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset11(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[215], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset12':  [219,0] -> [222,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset12(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[219], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset13':  [223,0] -> [226,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset13(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[223], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset14':  [227,0] -> [230,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset14(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[227], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset15':  [231,0] -> [234,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset15(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[231], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset16':  [235,0] -> [238,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset16(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[235], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset17':  [239,0] -> [242,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset17(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[239], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset18':  [243,0] -> [246,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset18(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[243], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset19':  [247,0] -> [250,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset19(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[247], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset20':  [251,0] -> [254,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset20(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[251], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset21':  [255,0] -> [258,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset21(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[255], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset22':  [259,0] -> [262,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset22(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[259], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset23':  [263,0] -> [266,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset23(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[263], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset24':  [267,0] -> [270,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset24(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[267], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset25':  [271,0] -> [274,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset25(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[271], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset26':  [275,0] -> [278,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset26(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[275], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset27':  [279,0] -> [282,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset27(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[279], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset28':  [283,0] -> [286,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset28(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[283], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset29':  [287,0] -> [290,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset29(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[287], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset30':  [291,0] -> [294,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset30(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[291], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset2031':  [295,0] -> [298,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset2031(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[295], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset32':  [299,0] -> [302,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset32(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[299], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset33':  [303,0] -> [306,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset33(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[303], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset34':  [307,0] -> [310,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset34(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[307], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset35':  [311,0] -> [314,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset35(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[311], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset36':  [315,0] -> [318,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset36(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[315], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset37':  [319,0] -> [322,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset37(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[319], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset38':  [323,0] -> [326,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset38(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[323], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset39':  [327,0] -> [330,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset39(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[327], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset40':  [331,0] -> [334,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset40(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[331], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset41':  [335,0] -> [338,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset41(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[335], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset42':  [339,0] -> [342,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset42(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[339], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset43':  [343,0] -> [346,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset43(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[343], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset44':  [347,0] -> [350,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset44(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[347], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset45':  [351,0] -> [354,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset45(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[351], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset46':  [355,0] -> [358,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset46(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[355], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset47':  [359,0] -> [362,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset47(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[359], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset48':  [363,0] -> [366,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset48(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[363], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset49':  [367,0] -> [370,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset49(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[367], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset50':  [371,0] -> [374,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset50(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[371], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset51':  [375,0] -> [378,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset51(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[375], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset52':  [379,0] -> [382,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset52(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[379], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset53':  [383,0] -> [386,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset53(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[383], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset54':  [387,0] -> [390,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset54(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[387], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset55':  [391,0] -> [394,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset55(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[391], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset56':  [395,0] -> [398,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset56(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[395], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset57':  [399,0] -> [402,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset57(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[399], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset58':  [403,0] -> [406,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset58(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[403], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset59':  [407,0] -> [410,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset59(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[407], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Preset60':  [411,0] -> [414,7] (Bitlen: 32)
tU8 dp_tclKdsGenericTunerParameter::u8GetPreset60(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[411], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  AMFMTunerParameter  (Key: 0x0411)          
//##########################################################

dp_tclKdsAMFMTunerParameter::dp_tclKdsAMFMTunerParameter() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_AMFMTUNERPARAMETER_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsAMFMTunerParameter::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsAMFMTunerParameter::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x0410, 0xe6, pu8CurPos)) {
      pu8CurPos += 0xe6;//lint !e416 Likely creation of out-of-bounds pointer
      if (bReadEntry(0x0411, 0x3a, pu8CurPos)) {
         pu8CurPos += 0x3a;//lint !e416 Likely creation of out-of-bounds pointer
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      }
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsAMFMTunerParameter::u8GetAMFMTunerParameter(tU8* pu8Data, tU16 u16BufLen) {
   if (0x3a<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_AMFMTUNERPARAMETER_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsAMFMTunerParameter::u8DataValid() const {return _u8DataStatus;};
//Key 'Tag':  [0,0] -> [7,7] (Bitlen: 64)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTag(tU8* pu8Data, tU16 u16BufLen) {
   if (8<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 8);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MajorVersion':  [8,0] -> [8,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetMajorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinorVersion':  [9,0] -> [10,7] (Bitlen: 16)
tU8 dp_tclKdsAMFMTunerParameter::u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[9], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LowFM':  [12,0] -> [15,7] (Bitlen: 32)
tU8 dp_tclKdsAMFMTunerParameter::u8GetLowFM(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[12], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'HighFM':  [16,0] -> [19,7] (Bitlen: 32)
tU8 dp_tclKdsAMFMTunerParameter::u8GetHighFM(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[16], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'StepSizeFM':  [20,0] -> [20,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetStepSizeFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[20]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ManualStepSizeFM':  [21,0] -> [21,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetManualStepSizeFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[21]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LowMW':  [22,0] -> [25,7] (Bitlen: 32)
tU8 dp_tclKdsAMFMTunerParameter::u8GetLowMW(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[22], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'HighMW':  [26,0] -> [29,7] (Bitlen: 32)
tU8 dp_tclKdsAMFMTunerParameter::u8GetHighMW(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[26], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'StepSizeMW':  [30,0] -> [30,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetStepSizeMW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[30]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ManualStepSizeMW':  [31,0] -> [31,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetManualStepSizeMW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[31]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LowLW':  [32,0] -> [35,7] (Bitlen: 32)
tU8 dp_tclKdsAMFMTunerParameter::u8GetLowLW(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[32], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'HighLW':  [36,0] -> [39,7] (Bitlen: 32)
tU8 dp_tclKdsAMFMTunerParameter::u8GetHighLW(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[36], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'StepSizeLW':  [40,0] -> [40,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetStepSizeLW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[40]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ManualStepSizeLW':  [41,0] -> [41,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetManualStepSizeLW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[41]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RDS':  [42,0] -> [42,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetRDS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'AF':  [42,1] -> [42,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAF(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'REG':  [42,2] -> [42,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetREG(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'PS':  [42,3] -> [42,3] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetPS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'Radiotext':  [42,4] -> [42,4] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetRadiotext(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'DDA':  [42,5] -> [42,5] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDDA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'DDS':  [42,6] -> [42,6] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDDS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'Datascan':  [42,7] -> [42,7] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDatascan(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'TA':  [43,0] -> [43,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[43]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'PTY31':  [43,1] -> [43,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetPTY31(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[43]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'AFTemporaryONOFF':  [43,2] -> [43,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAFTemporaryONOFF(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[43]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'FMLSM':  [44,0] -> [47,7] (Bitlen: 32)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFMLSM(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[44], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MWLSM':  [48,0] -> [51,7] (Bitlen: 32)
tU8 dp_tclKdsAMFMTunerParameter::u8GetMWLSM(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[48], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LWLSM':  [52,0] -> [55,7] (Bitlen: 32)
tU8 dp_tclKdsAMFMTunerParameter::u8GetLWLSM(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[52], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'ShowTextWaitingForRadioText':  [56,0] -> [56,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetShowTextWaitingForRadioText(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[56]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'ShowTextNoRadioTextAvailable1':  [56,1] -> [56,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetShowTextNoRadioTextAvailable1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[56]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'ShowTextWaitingForRadioTextWithRDSTimeout':  [56,2] -> [56,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetShowTextWaitingForRadioTextWithRDSTimeout(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[56]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'TRadioTextNotAvailable':  [57,0] -> [57,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTRadioTextNotAvailable(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[57]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TTimeoutStatusRT':  [58,0] -> [58,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTTimeoutStatusRT(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TShowTextMin':  [59,0] -> [59,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTShowTextMin(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[59]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TMinimumDisplayDurationPerRadiotextPage':  [60,0] -> [61,7] (Bitlen: 16)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTMinimumDisplayDurationPerRadiotextPage(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[60], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RadioTextMinimumLength':  [62,0] -> [62,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetRadioTextMinimumLength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[62]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RadioTextSpeedThreshold':  [63,0] -> [63,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetRadioTextSpeedThreshold(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[63]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RadioTextSpeedThresholdHysteresis':  [64,0] -> [64,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetRadioTextSpeedThresholdHysteresis(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[64]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EmergenySeekScanNumberOfStations':  [67,0] -> [67,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetEmergenySeekScanNumberOfStations(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[67]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ShowFrequencyDuringFrequencyScan':  [68,0] -> [68,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetShowFrequencyDuringFrequencyScan(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[68]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeekMode':  [69,0] -> [69,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSeekMode(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[69]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfSeekPeriods':  [70,0] -> [70,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetNumberOfSeekPeriods(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[70]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ScanTime':  [71,0] -> [71,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetScanTime(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[71]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AFBestDelayTimeAfterManualTuning':  [72,0] -> [72,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAFBestDelayTimeAfterManualTuning(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[72]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AFBestDisplayFreezeAfterManualTuning':  [73,0] -> [73,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAFBestDisplayFreezeAfterManualTuning(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[73]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AutoSeekStepDelay':  [74,0] -> [75,7] (Bitlen: 16)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAutoSeekStepDelay(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[74], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PermanentManualStepDelay':  [76,0] -> [77,7] (Bitlen: 16)
tU8 dp_tclKdsAMFMTunerParameter::u8GetPermanentManualStepDelay(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[76], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'WrongPiAcceptDelayAfterStationSelection':  [78,0] -> [78,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetWrongPiAcceptDelayAfterStationSelection(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[78]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'WrongPiAcceptAfterStationLost':  [79,0] -> [79,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetWrongPiAcceptAfterStationLost(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[79]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MultiManualStepsWithIntermediateFrequencies':  [80,0] -> [80,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetMultiManualStepsWithIntermediateFrequencies(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[80]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'StationListsFM':  [81,0] -> [81,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetStationListsFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[81]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'StationListsMW':  [81,1] -> [81,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetStationListsMW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[81]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'StationListsLW':  [81,2] -> [81,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetStationListsLW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[81]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'StationListsMWLW':  [81,3] -> [81,3] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetStationListsMWLW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[81]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'FMListSortingDefault':  [82,0] -> [82,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFMListSortingDefault(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[82]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AMListSortingDefault':  [83,0] -> [83,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAMListSortingDefault(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[83]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TInhibitListSortAfterSkip':  [84,0] -> [84,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTInhibitListSortAfterSkip(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[84]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TCursorDelayAfterStationSelect':  [85,0] -> [85,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTCursorDelayAfterStationSelect(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[85]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TIMEAMMINTUNELISTREMOVE':  [86,0] -> [86,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTIMEAMMINTUNELISTREMOVE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[86]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TIMEAMSTATIONREMOVEAFTERDESELECT':  [87,0] -> [87,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTIMEAMSTATIONREMOVEAFTERDESELECT(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[87]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AMStationListUpdateStrategy':  [88,0] -> [88,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAMStationListUpdateStrategy(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[88]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TestmodeUpdateCycle':  [93,0] -> [93,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTestmodeUpdateCycle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[93]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AFListUpdateCycle':  [94,0] -> [94,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAFListUpdateCycle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[94]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ResortingOfAFList':  [95,0] -> [95,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetResortingOfAFList(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[95]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AFlistReleaseBehavior':  [96,0] -> [96,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAFlistReleaseBehavior(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[96]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FM2':  [97,0] -> [97,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFM2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[97]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'MW2':  [97,1] -> [97,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetMW2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[97]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'LW2':  [97,2] -> [97,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetLW2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[97]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'MWLWCombined':  [97,3] -> [97,3] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetMWLWCombined(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[97]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'StartPISeek':  [98,0] -> [98,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetStartPISeek(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[98]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'LastPassedFrequency':  [98,1] -> [98,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetLastPassedFrequency(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[98]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'ADRFMChannelSeparation':  [99,0] -> [99,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRFMChannelSeparation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[99]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADRFMLimitation':  [100,0] -> [100,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRFMLimitation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[100]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADRFMMultipath':  [101,0] -> [101,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRFMMultipath(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[101]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADRFMHighcut':  [102,0] -> [102,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRFMHighcut(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[102]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADRFMSoftmute':  [103,0] -> [103,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRFMSoftmute(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[103]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADRAMSoftmute':  [104,0] -> [104,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRAMSoftmute(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[104]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADRFMDeemphasis':  [105,0] -> [105,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRFMDeemphasis(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[105]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADRFMFrequencyResponse':  [106,0] -> [106,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRFMFrequencyResponse(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[106]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADRAMFrequencyResponse':  [107,0] -> [107,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRAMFrequencyResponse(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[107]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADRFMMisc':  [108,0] -> [108,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRFMMisc(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[108]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADRAMMisc':  [109,0] -> [109,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRAMMisc(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[109]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADRFMAntennaAttenuation':  [110,0] -> [110,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRFMAntennaAttenuation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[110]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADRAMAntennaAnttenuation':  [111,0] -> [111,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRAMAntennaAnttenuation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[111]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADRAMHicutConfiguration':  [112,0] -> [112,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRAMHicutConfiguration(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[112]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADRAMDeemphasis':  [113,0] -> [113,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRAMDeemphasis(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[113]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MuteRamp1':  [114,0] -> [115,7] (Bitlen: 16)
tU8 dp_tclKdsAMFMTunerParameter::u8GetMuteRamp1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[114], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DemuteRamp1':  [116,0] -> [117,7] (Bitlen: 16)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDemuteRamp1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[116], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MuteRamp2':  [118,0] -> [119,7] (Bitlen: 16)
tU8 dp_tclKdsAMFMTunerParameter::u8GetMuteRamp2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[118], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DemuteRamp2':  [120,0] -> [121,7] (Bitlen: 16)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDemuteRamp2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[120], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'TriggerNotificationOnFieldstrenghtQualityChange':  [122,0] -> [122,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTriggerNotificationOnFieldstrenghtQualityChange(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[122]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeekLevelFMRDSFieldstrength':  [123,0] -> [123,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSeekLevelFMRDSFieldstrength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[123]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeekLevelFMRDSQuality':  [124,0] -> [124,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSeekLevelFMRDSQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[124]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeekLevelFMNonRDSFieldstrength':  [125,0] -> [125,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSeekLevelFMNonRDSFieldstrength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[125]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeekLevelFMNonRDSQuality':  [126,0] -> [126,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSeekLevelFMNonRDSQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[126]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeekLevelLWFieldstrength':  [127,0] -> [127,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSeekLevelLWFieldstrength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[127]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeekLevelLWQuality':  [128,0] -> [128,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSeekLevelLWQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[128]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeekLevelMWFieldstrength':  [129,0] -> [129,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSeekLevelMWFieldstrength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[129]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeekLevelMWQuality':  [130,0] -> [130,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSeekLevelMWQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[130]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeekLevelSWFieldstrength':  [131,0] -> [131,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSeekLevelSWFieldstrength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[131]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeekLevelSWQuality':  [132,0] -> [132,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSeekLevelSWQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[132]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeekLevelTRFFieldstrength':  [133,0] -> [133,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSeekLevelTRFFieldstrength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[133]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeekLevelTRFQuality':  [134,0] -> [134,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSeekLevelTRFQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[134]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeekLevelWBFieldstrength':  [135,0] -> [135,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSeekLevelWBFieldstrength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[135]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeekLevelWBQuality':  [136,0] -> [136,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSeekLevelWBQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[136]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ListLevelFMRDSFieldstrength':  [137,0] -> [137,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetListLevelFMRDSFieldstrength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[137]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ListLevelFMRDSQualify':  [138,0] -> [138,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetListLevelFMRDSQualify(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[138]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ListLevelFMNonRDSFieldstrength':  [139,0] -> [139,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetListLevelFMNonRDSFieldstrength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[139]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ListLevelFMNonRDSQuality':  [140,0] -> [140,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetListLevelFMNonRDSQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[140]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ListLevelLWFieldstrength':  [141,0] -> [141,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetListLevelLWFieldstrength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[141]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ListLevelLWQuality':  [142,0] -> [142,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetListLevelLWQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[142]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ListLevelMWFieldstrength':  [143,0] -> [143,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetListLevelMWFieldstrength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[143]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ListLevelMWQuality':  [144,0] -> [144,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetListLevelMWQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[144]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ListLevelSWFieldstrength':  [145,0] -> [145,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetListLevelSWFieldstrength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[145]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ListLevelSWQuality':  [146,0] -> [146,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetListLevelSWQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[146]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ListLevelTRFFieldstrength':  [147,0] -> [147,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetListLevelTRFFieldstrength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[147]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ListLevelTRFQuality':  [148,0] -> [148,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetListLevelTRFQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[148]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ListLevelWBFieldstrength':  [149,0] -> [149,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetListLevelWBFieldstrength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[149]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ListLevelWBQuality':  [150,0] -> [150,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetListLevelWBQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[150]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SharxFM':  [151,0] -> [151,3] (Bitlen: 4)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSharxFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[151]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'SharxAM':  [151,4] -> [151,7] (Bitlen: 4)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSharxAM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[151]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'HicutFM':  [152,0] -> [152,3] (Bitlen: 4)
tU8 dp_tclKdsAMFMTunerParameter::u8GetHicutFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[152]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'HicutAM':  [152,4] -> [152,7] (Bitlen: 4)
tU8 dp_tclKdsAMFMTunerParameter::u8GetHicutAM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[152]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsFM':  [156,0] -> [156,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[156]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsLW':  [156,1] -> [156,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsLW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[156]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsMW':  [156,2] -> [156,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsMW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[156]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsWB':  [156,3] -> [156,3] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsWB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[156]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsTRF':  [156,4] -> [156,4] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsTRF(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[156]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsSW1':  [156,5] -> [156,5] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsSW1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[156]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsSW2':  [156,6] -> [156,6] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsSW2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[156]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsSW3':  [156,7] -> [156,7] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsSW3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[156]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsSW4':  [155,0] -> [155,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsSW4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[155]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsSW5':  [155,1] -> [155,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsSW5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[155]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsSW6':  [155,2] -> [155,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsSW6(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[155]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsSW7':  [155,3] -> [155,3] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsSW7(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[155]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsSW8':  [155,4] -> [155,4] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsSW8(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[155]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsSW9':  [155,5] -> [155,5] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsSW9(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[155]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsSW10':  [155,6] -> [155,6] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsSW10(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[155]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsSW11':  [155,7] -> [155,7] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsSW11(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[155]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsSW12':  [154,0] -> [154,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsSW12(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[154]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsSW13':  [154,1] -> [154,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsSW13(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[154]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'AvailableBandsSW14':  [154,2] -> [154,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAvailableBandsSW14(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[154]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationFM':  [160,0] -> [160,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[160]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationLW':  [160,1] -> [160,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationLW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[160]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationMW':  [160,2] -> [160,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationMW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[160]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationWB':  [160,3] -> [160,3] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationWB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[160]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationTRF':  [160,4] -> [160,4] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationTRF(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[160]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationSW1':  [160,5] -> [160,5] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationSW1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[160]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationSW2':  [160,6] -> [160,6] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationSW2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[160]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationSW3':  [160,7] -> [160,7] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationSW3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[160]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationSW4':  [159,0] -> [159,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationSW4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[159]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationSW5':  [159,1] -> [159,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationSW5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[159]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationSW6':  [159,2] -> [159,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationSW6(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[159]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationSW7':  [159,3] -> [159,3] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationSW7(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[159]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationSW8':  [159,4] -> [159,4] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationSW8(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[159]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationSW9':  [159,5] -> [159,5] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationSW9(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[159]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationSW10':  [159,6] -> [159,6] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationSW10(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[159]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationSW11':  [159,7] -> [159,7] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationSW11(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[159]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationSW12':  [158,0] -> [158,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationSW12(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[158]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationSW13':  [158,1] -> [158,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationSW13(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[158]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationSW14':  [158,2] -> [158,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationSW14(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[158]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationCB1':  [158,4] -> [158,4] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationCB1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[158]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationFMAndAMSwitchEnabled':  [157,4] -> [157,4] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationFMAndAMSwitchEnabled(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[157]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationFMHDSwitchEnabled':  [157,5] -> [157,5] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationFMHDSwitchEnabled(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[157]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationAMHDSwitchEnabled':  [157,6] -> [157,6] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationAMHDSwitchEnabled(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[157]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CombiBandConfigurationDRMSwitchEnabled':  [157,7] -> [157,7] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetCombiBandConfigurationDRMSwitchEnabled(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[157]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'TPAudioTuner1':  [161,0] -> [161,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTPAudioTuner1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[161]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'TPAudioTuner2':  [161,1] -> [161,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTPAudioTuner2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[161]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'AFAudioTuner1':  [161,2] -> [161,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAFAudioTuner1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[161]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'AFAudioTuner2':  [161,3] -> [161,3] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAFAudioTuner2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[161]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'DDAAudioTuner1':  [161,4] -> [161,5] (Bitlen: 2)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDDAAudioTuner1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[161]&0x30)>>4);
   }
   return _u8DataStatus;
}

//Key 'DDAAudioTuner2':  [161,6] -> [161,7] (Bitlen: 2)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDDAAudioTuner2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[161]&0xc0)>>6);
   }
   return _u8DataStatus;
}

//Key 'RDSAudioTuner1':  [162,0] -> [162,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetRDSAudioTuner1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[162]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'RDSAudioTuner2':  [162,1] -> [162,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetRDSAudioTuner2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[162]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'PSFixAudioTuner1':  [162,2] -> [162,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetPSFixAudioTuner1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[162]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'PSFixAudioTuner2':  [162,3] -> [162,3] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetPSFixAudioTuner2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[162]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'StereoAudioTuner1':  [162,4] -> [162,4] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetStereoAudioTuner1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[162]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'StereoAudioTuner2':  [162,5] -> [162,5] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetStereoAudioTuner2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[162]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'REGAudioTuner1':  [163,0] -> [163,2] (Bitlen: 3)
tU8 dp_tclKdsAMFMTunerParameter::u8GetREGAudioTuner1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[163]&0x7)>>0);
   }
   return _u8DataStatus;
}

//Key 'REGAudioTuner2':  [163,3] -> [163,5] (Bitlen: 3)
tU8 dp_tclKdsAMFMTunerParameter::u8GetREGAudioTuner2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[163]&0x38)>>3);
   }
   return _u8DataStatus;
}

//Key 'PTY31ForAudioTuner1':  [164,0] -> [164,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetPTY31ForAudioTuner1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[164]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'PTY31ForAudioTuner2':  [164,1] -> [164,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetPTY31ForAudioTuner2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[164]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'DDSAudioTuner1':  [164,2] -> [164,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDDSAudioTuner1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[164]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'DDSAudioTuner2':  [164,3] -> [164,3] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDDSAudioTuner2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[164]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'DMQAudioTuner1':  [164,4] -> [164,4] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDMQAudioTuner1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[164]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'DMQAudioTuner2':  [164,5] -> [164,5] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDMQAudioTuner2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[164]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'ADRPhysicalTunerConfigId':  [165,0] -> [165,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRPhysicalTunerConfigId(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[165]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADRAntennaConfigId':  [166,0] -> [166,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetADRAntennaConfigId(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[166]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ExchangeAntennaLevel':  [167,0] -> [167,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetExchangeAntennaLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[167]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'PITestLevel':  [168,0] -> [168,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetPITestLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[168]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NRDSLevel':  [169,0] -> [169,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetNRDSLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[169]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EONLevel':  [170,0] -> [170,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetEONLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[170]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMMemoLevel':  [171,0] -> [171,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFMMemoLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[171]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'PanicFieldstLevel':  [172,0] -> [172,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetPanicFieldstLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[172]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ParamRDSLevel':  [173,0] -> [173,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetParamRDSLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[173]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RDSDataAccept':  [174,0] -> [174,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetRDSDataAccept(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[174]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'PIStepLevel':  [175,0] -> [175,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetPIStepLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[175]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DDAAntennaDistLevel':  [176,0] -> [176,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDDAAntennaDistLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[176]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RDSSynDelayCounter':  [177,0] -> [177,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetRDSSynDelayCounter(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[177]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MPMeasureLevel':  [178,0] -> [178,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetMPMeasureLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[178]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MPRestrictionLevel':  [179,0] -> [179,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetMPRestrictionLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[179]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MPVeryBadLevel':  [180,0] -> [180,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetMPVeryBadLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[180]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MPMediumLevel':  [181,0] -> [181,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetMPMediumLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[181]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RDSBadLevel':  [182,0] -> [182,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetRDSBadLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[182]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'IllegalAF':  [183,0] -> [183,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetIllegalAF(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[183]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AFSaveLevel':  [184,0] -> [184,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAFSaveLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[184]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FirstRundum':  [185,0] -> [185,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFirstRundum(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[185]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SecondRundum':  [186,0] -> [186,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSecondRundum(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[186]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ThirdRundum':  [187,0] -> [187,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetThirdRundum(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[187]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'PIStepWithNoPICheck':  [188,0] -> [188,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetPIStepWithNoPICheck(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[188]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AudioOffScanMode':  [189,0] -> [189,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAudioOffScanMode(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[189]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AMLearnCycle':  [190,0] -> [190,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAMLearnCycle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[190]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'PIIgnore':  [191,0] -> [191,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetPIIgnore(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[191]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'PISearchTime':  [192,0] -> [192,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetPISearchTime(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[192]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisableSeamlessBlending':  [193,0] -> [193,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDisableSeamlessBlending(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[193]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SLAdjThreshold':  [194,0] -> [194,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSLAdjThreshold(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[194]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SLMpThreshold':  [195,0] -> [195,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSLMpThreshold(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[195]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SpecialFmStartFrequency':  [196,0] -> [196,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetSpecialFmStartFrequency(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[196]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMSharxLimit':  [197,0] -> [197,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFMSharxLimit(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[197]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'HDScanEveryFrequency':  [198,0] -> [198,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetHDScanEveryFrequency(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[198]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'HWSubConfig':  [199,0] -> [199,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetHWSubConfig(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[199]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FM2DABDelayTime':  [200,0] -> [200,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFM2DABDelayTime(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[200]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'WeatherBandLSM':  [201,0] -> [204,7] (Bitlen: 32)
tU8 dp_tclKdsAMFMTunerParameter::u8GetWeatherBandLSM(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[201], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'AMFMHicutExtender':  [209,0] -> [209,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAMFMHicutExtender(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[209]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMSoftmuteTiming':  [210,0] -> [210,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFMSoftmuteTiming(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[210]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AMFMMisscellaneous2':  [211,0] -> [211,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAMFMMisscellaneous2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[211]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMHicutExtenderFieldstrengthThreshold':  [212,0] -> [212,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFMHicutExtenderFieldstrengthThreshold(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[212]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMHicutExtenderFilterOffset':  [213,0] -> [213,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFMHicutExtenderFilterOffset(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[213]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMChannelSeparationMaximum':  [214,0] -> [214,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFMChannelSeparationMaximum(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[214]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMChannelSeparationTiming':  [215,0] -> [215,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFMChannelSeparationTiming(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[215]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMHicutFieldstrengthThreshold':  [216,0] -> [216,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFMHicutFieldstrengthThreshold(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[216]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMHicutTiming':  [217,0] -> [217,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFMHicutTiming(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[217]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMDMQSensitivity':  [218,0] -> [218,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFMDMQSensitivity(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[218]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMDeviationAdaption':  [219,0] -> [219,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetFMDeviationAdaption(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[219]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AMNoiseBlanker228KHzSensitivity':  [220,0] -> [220,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAMNoiseBlanker228KHzSensitivity(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[220]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AMNoiseBlanker456KHzSensitivity':  [221,0] -> [221,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAMNoiseBlanker456KHzSensitivity(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[221]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AMHicutExtenderFieldstrengthThreshold':  [222,0] -> [222,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAMHicutExtenderFieldstrengthThreshold(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[222]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AMHicutExtenderFilterOffset':  [223,0] -> [223,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetAMHicutExtenderFilterOffset(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[223]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DemodAudioTuner1FMAM':  [232,0] -> [232,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDemodAudioTuner1FMAM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[232]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'DemodAudioTuner1FMHD':  [232,1] -> [232,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDemodAudioTuner1FMHD(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[232]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'DemodAudioTuner1AMHD':  [232,2] -> [232,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDemodAudioTuner1AMHD(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[232]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'DemodAudioTuner1DRM':  [232,3] -> [232,3] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDemodAudioTuner1DRM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[232]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'DemodAudioTuner2FMAM':  [233,0] -> [233,0] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDemodAudioTuner2FMAM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[233]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'DemodAudioTuner2FMHD':  [233,1] -> [233,1] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDemodAudioTuner2FMHD(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[233]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'DemodAudioTuner2AMHD':  [233,2] -> [233,2] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDemodAudioTuner2AMHD(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[233]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'DemodAudioTuner2DRM':  [233,3] -> [233,3] (Bitlen: 1)
tU8 dp_tclKdsAMFMTunerParameter::u8GetDemodAudioTuner2DRM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[233]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'TimeNonRdsDetect':  [237,0] -> [237,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTimeNonRdsDetect(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[237]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimePsDeleteAfterRdsLost':  [238,0] -> [238,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTimePsDeleteAfterRdsLost(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[238]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimeScrollPsDetect':  [239,0] -> [239,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTimeScrollPsDetect(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[239]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TSpeedTuneTrigger':  [240,0] -> [240,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTSpeedTuneTrigger(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[240]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NSpeedTuneTrigger':  [241,0] -> [241,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetNSpeedTuneTrigger(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[241]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NSpeedTuneMultipierFM':  [242,0] -> [242,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetNSpeedTuneMultipierFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[242]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NSpeedTuneMultipierAM':  [243,0] -> [243,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetNSpeedTuneMultipierAM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[243]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfPsChangesForScrollDetect':  [244,0] -> [244,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetNumberOfPsChangesForScrollDetect(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[244]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimePTYHold':  [245,0] -> [245,7] (Bitlen: 8)
tU8 dp_tclKdsAMFMTunerParameter::u8GetTimePTYHold(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[245]&0xff)>>0);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  HDRadioParameterSet  (Key: 0x0450)          
//##########################################################

dp_tclKdsHDRadioParameterSet::dp_tclKdsHDRadioParameterSet() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_HDRADIOPARAMETERSET_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsHDRadioParameterSet::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsHDRadioParameterSet::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x0450, 0x40, pu8CurPos)) {
      pu8CurPos += 0x40;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsHDRadioParameterSet::u8GetHDRadioParameterSet(tU8* pu8Data, tU16 u16BufLen) {
   if (0x40<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_HDRADIOPARAMETERSET_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsHDRadioParameterSet::u8DataValid() const {return _u8DataStatus;};
//Key 'Tag':  [0,0] -> [7,7] (Bitlen: 64)
tU8 dp_tclKdsHDRadioParameterSet::u8GetTag(tU8* pu8Data, tU16 u16BufLen) {
   if (8<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 8);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MajorVersion':  [8,0] -> [8,7] (Bitlen: 8)
tU8 dp_tclKdsHDRadioParameterSet::u8GetMajorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinorVersion':  [9,0] -> [10,7] (Bitlen: 16)
tU8 dp_tclKdsHDRadioParameterSet::u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[9], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BlendThresholdFMHybrid':  [11,0] -> [11,7] (Bitlen: 8)
tU8 dp_tclKdsHDRadioParameterSet::u8GetBlendThresholdFMHybrid(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DigitalAudioScalingForFMHybrid':  [12,0] -> [13,7] (Bitlen: 16)
tU8 dp_tclKdsHDRadioParameterSet::u8GetDigitalAudioScalingForFMHybrid(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[12], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DigitalAudioDelayForFMHybridPrimaryBBRate':  [14,0] -> [15,7] (Bitlen: 16)
tU8 dp_tclKdsHDRadioParameterSet::u8GetDigitalAudioDelayForFMHybridPrimaryBBRate(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[14], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BlendRateFMHybrid':  [16,0] -> [16,7] (Bitlen: 8)
tU8 dp_tclKdsHDRadioParameterSet::u8GetBlendRateFMHybrid(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[16]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BlendThresholdAMHybrid':  [17,0] -> [17,7] (Bitlen: 8)
tU8 dp_tclKdsHDRadioParameterSet::u8GetBlendThresholdAMHybrid(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AMMPSAudioScaling':  [18,0] -> [19,7] (Bitlen: 16)
tU8 dp_tclKdsHDRadioParameterSet::u8GetAMMPSAudioScaling(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[18], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'AMMPSBlendRate':  [20,0] -> [20,7] (Bitlen: 8)
tU8 dp_tclKdsHDRadioParameterSet::u8GetAMMPSBlendRate(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[20]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DigitalAudioDelayForAMMPSPrimaryBBRate':  [21,0] -> [22,7] (Bitlen: 16)
tU8 dp_tclKdsHDRadioParameterSet::u8GetDigitalAudioDelayForAMMPSPrimaryBBRate(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[21], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DigitalAudioPhaseInversion':  [23,0] -> [23,7] (Bitlen: 8)
tU8 dp_tclKdsHDRadioParameterSet::u8GetDigitalAudioPhaseInversion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[23]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BlendDecision':  [24,0] -> [24,7] (Bitlen: 8)
tU8 dp_tclKdsHDRadioParameterSet::u8GetBlendDecision(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[24]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMCdN0BlendDecision':  [25,0] -> [25,7] (Bitlen: 8)
tU8 dp_tclKdsHDRadioParameterSet::u8GetFMCdN0BlendDecision(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[25]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AMCdN0BlendDecision':  [26,0] -> [26,7] (Bitlen: 8)
tU8 dp_tclKdsHDRadioParameterSet::u8GetAMCdN0BlendDecision(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[26]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'Timer1':  [27,0] -> [27,7] (Bitlen: 8)
tU8 dp_tclKdsHDRadioParameterSet::u8GetTimer1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[27]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'Timer2':  [28,0] -> [28,7] (Bitlen: 8)
tU8 dp_tclKdsHDRadioParameterSet::u8GetTimer2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[28]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'Timer3':  [29,0] -> [29,7] (Bitlen: 8)
tU8 dp_tclKdsHDRadioParameterSet::u8GetTimer3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[29]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'Timer4':  [30,0] -> [30,7] (Bitlen: 8)
tU8 dp_tclKdsHDRadioParameterSet::u8GetTimer4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[30]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'Timer5':  [31,0] -> [31,7] (Bitlen: 8)
tU8 dp_tclKdsHDRadioParameterSet::u8GetTimer5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[31]&0xff)>>0);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  DABParameterSet  (Key: 0x0440)          
//##########################################################

dp_tclKdsDABParameterSet::dp_tclKdsDABParameterSet() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_DABPARAMETERSET_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsDABParameterSet::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsDABParameterSet::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x0440, 0xe6, pu8CurPos)) {
      pu8CurPos += 0xe6;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsDABParameterSet::u8GetDABParameterSet(tU8* pu8Data, tU16 u16BufLen) {
   if (0xe6<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_DABPARAMETERSET_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsDABParameterSet::u8DataValid() const {return _u8DataStatus;};
//Key 'Tag':  [0,0] -> [7,7] (Bitlen: 64)
tU8 dp_tclKdsDABParameterSet::u8GetTag(tU8* pu8Data, tU16 u16BufLen) {
   if (8<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 8);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MajorVersion':  [8,0] -> [8,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetMajorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinorVersion':  [9,0] -> [10,7] (Bitlen: 16)
tU8 dp_tclKdsDABParameterSet::u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[9], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SFDABDAB':  [11,0] -> [11,0] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetSFDABDAB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'SFDABFM':  [11,1] -> [11,1] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetSFDABFM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'SFFMDAB':  [11,2] -> [11,2] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetSFFMDAB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'DMBA':  [11,7] -> [11,7] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetDMBA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'TPEG':  [12,0] -> [12,0] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetTPEG(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'EPG':  [12,1] -> [12,1] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetEPG(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'SLS':  [12,2] -> [12,2] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetSLS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'BWS':  [12,3] -> [12,3] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetBWS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'Intellitext':  [12,4] -> [12,4] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetIntellitext(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'Journaline':  [12,5] -> [12,5] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetJournaline(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'SFAlternativeFrequency':  [13,0] -> [13,0] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetSFAlternativeFrequency(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'SFAlternativeEnsemble':  [13,1] -> [13,1] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetSFAlternativeEnsemble(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'SFHardLinking':  [13,2] -> [13,2] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetSFHardLinking(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'SFSearch':  [13,3] -> [13,3] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetSFSearch(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'SFStickyComponent':  [13,5] -> [13,5] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetSFStickyComponent(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'ConcealmentLevel':  [14,0] -> [14,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetConcealmentLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TSUMatrixDABFM':  [15,0] -> [46,7] (Bitlen: 256)
tU8 dp_tclKdsDABParameterSet::u8GetTSUMatrixDABFM(tU8* pu8Data, tU16 u16BufLen) {
   if (32<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[15], 32);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'TSUMatrixFMDAB':  [47,0] -> [78,7] (Bitlen: 256)
tU8 dp_tclKdsDABParameterSet::u8GetTSUMatrixFMDAB(tU8* pu8Data, tU16 u16BufLen) {
   if (32<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[47], 32);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DABFMLinkingSwitchBackDelay':  [79,0] -> [79,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetDABFMLinkingSwitchBackDelay(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[79]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DABFMLinkingSmoothingTUp':  [80,0] -> [80,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetDABFMLinkingSmoothingTUp(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[80]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DABFMLinkingSmoothingTDown':  [81,0] -> [81,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetDABFMLinkingSmoothingTDown(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[81]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DABFMLinkingComparisonDelay':  [82,0] -> [82,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetDABFMLinkingComparisonDelay(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[82]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DABFMLinkingSmoothingTLong':  [83,0] -> [83,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetDABFMLinkingSmoothingTLong(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[83]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DABFMLinkingFMQualityThreshold':  [84,0] -> [84,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetDABFMLinkingFMQualityThreshold(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[84]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMDABLinkingSwitchBackDelay':  [85,0] -> [85,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetFMDABLinkingSwitchBackDelay(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[85]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMDABLinkingSmoothingTUp':  [86,0] -> [86,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetFMDABLinkingSmoothingTUp(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[86]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMDABLinkingSmoothingTDown':  [87,0] -> [87,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetFMDABLinkingSmoothingTDown(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[87]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMDABLinkingPSIDChangedDelay':  [88,0] -> [88,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetFMDABLinkingPSIDChangedDelay(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[88]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMDABLinkingSmoothingTLong':  [89,0] -> [89,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetFMDABLinkingSmoothingTLong(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[89]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMDABLinkingDABQualityThreshold':  [90,0] -> [90,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetFMDABLinkingDABQualityThreshold(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[90]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RDMQualityConfigQualityDecreaseSpeedFactor':  [94,0] -> [94,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetRDMQualityConfigQualityDecreaseSpeedFactor(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[94]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RDMQualityConfigMode':  [95,0] -> [95,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetRDMQualityConfigMode(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[95]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RDMQualityConfigCount':  [96,0] -> [96,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetRDMQualityConfigCount(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[96]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EnsembleRecIndicator':  [97,0] -> [97,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetEnsembleRecIndicator(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[97]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EnsembleRecIndicatorSyncDelay':  [98,0] -> [98,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetEnsembleRecIndicatorSyncDelay(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[98]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EnsembleVerificationAlgorithmTimeTickDivider':  [99,0] -> [99,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetEnsembleVerificationAlgorithmTimeTickDivider(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[99]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EnsembleVerificationAlgorithmTimePeriod':  [100,0] -> [100,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetEnsembleVerificationAlgorithmTimePeriod(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[100]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EnsembleVerificationAlgorithmMinGoodFICBERTime':  [101,0] -> [101,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetEnsembleVerificationAlgorithmMinGoodFICBERTime(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[101]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EnsembleVerificationAlgorithmMinGoodFICBERLevel':  [102,0] -> [102,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetEnsembleVerificationAlgorithmMinGoodFICBERLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[102]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EnsembleVerificationAlgorithmTargetCounterValue':  [103,0] -> [103,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetEnsembleVerificationAlgorithmTargetCounterValue(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[103]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EnsembleQualityAlgorithmMinGoodFICBERTime':  [104,0] -> [104,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetEnsembleQualityAlgorithmMinGoodFICBERTime(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[104]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EnsembleQualityAlgorithmMinGoodFICBERLevel':  [105,0] -> [105,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetEnsembleQualityAlgorithmMinGoodFICBERLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[105]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'Enable':  [106,0] -> [106,0] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetEnable(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[106]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'QuickHideEnsemble':  [106,1] -> [106,1] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetQuickHideEnsemble(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[106]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'RealUnlearnEnsemble':  [106,2] -> [106,2] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetRealUnlearnEnsemble(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[106]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'UseForShowingNotReceiveableIndicator':  [106,3] -> [106,3] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetUseForShowingNotReceiveableIndicator(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[106]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'UseForClearingNotReceiveableIndicator':  [106,4] -> [106,4] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetUseForClearingNotReceiveableIndicator(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[106]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'BackgroundSnooping2':  [107,0] -> [107,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetBackgroundSnooping2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[107]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BackgroundSnoopingUnlearnFieldstrength':  [108,0] -> [108,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetBackgroundSnoopingUnlearnFieldstrength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[108]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BackgroundSnoopingLearnCounterMaxValue':  [109,0] -> [109,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetBackgroundSnoopingLearnCounterMaxValue(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[109]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BackgroundSnoopingLearnCounterValue':  [110,0] -> [110,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetBackgroundSnoopingLearnCounterValue(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[110]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BackgroundSnoopingUnlearnCounterValue':  [111,0] -> [111,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetBackgroundSnoopingUnlearnCounterValue(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[111]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BackgroundSnoopingUnlearnCounterMinValue':  [112,0] -> [112,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetBackgroundSnoopingUnlearnCounterMinValue(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[112]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ResumeInterruptedAnnouncement':  [118,0] -> [118,0] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetResumeInterruptedAnnouncement(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[118]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'SearchUpScan':  [122,0] -> [122,0] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetSearchUpScan(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[122]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'ScanStationList':  [122,1] -> [122,1] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetScanStationList(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[122]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'SupressDoubleServices':  [122,2] -> [122,2] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetSupressDoubleServices(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[122]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'UseMinSignalQuality':  [122,3] -> [122,3] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetUseMinSignalQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[122]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'UseMinAudioQuality':  [122,4] -> [122,4] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetUseMinAudioQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[122]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'UseMinPlayDuration':  [122,5] -> [122,5] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetUseMinPlayDuration(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[122]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'ScanForever':  [122,6] -> [122,6] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetScanForever(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[122]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'SelectLastScannedServiceWhenLSMIsNotAvailable1':  [122,7] -> [122,7] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetSelectLastScannedServiceWhenLSMIsNotAvailable1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[122]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'ScanMinSignalQuality':  [123,0] -> [123,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetScanMinSignalQuality(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[123]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ScanAudioThreshold':  [124,0] -> [124,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetScanAudioThreshold(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[124]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'PlayDuration':  [125,0] -> [125,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetPlayDuration(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[125]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'EnsembleListSorting':  [144,0] -> [144,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetEnsembleListSorting(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[144]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ServiceListSorting':  [145,0] -> [145,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetServiceListSorting(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[145]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ComponentListSorting':  [146,0] -> [146,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetComponentListSorting(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[146]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaximumNumberOfStation':  [147,0] -> [148,7] (Bitlen: 16)
tU8 dp_tclKdsDABParameterSet::u8GetMaximumNumberOfStation(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[147], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'ComponentsIncludedInStationList':  [149,0] -> [149,0] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8GetComponentsIncludedInStationList(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[149]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key '32x32':  [153,0] -> [153,0] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8Get32x32(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[153]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key '112x32':  [153,1] -> [153,1] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8Get112x32(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[153]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key '128x128':  [153,2] -> [153,2] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8Get128x128(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[153]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key '320x240':  [153,3] -> [153,3] (Bitlen: 1)
tU8 dp_tclKdsDABParameterSet::u8Get320x240(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[153]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'TimerConfigTFMDABSWITCHMUTEDABMs':  [154,0] -> [154,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetTimerConfigTFMDABSWITCHMUTEDABMs(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[154]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimerConfigTFMDABSWITCHMUTEDABPLUSMs':  [155,0] -> [155,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetTimerConfigTFMDABSWITCHMUTEDABPLUSMs(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[155]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimerConfigTFMDABSWITCHMUTEDMBAMs':  [156,0] -> [156,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetTimerConfigTFMDABSWITCHMUTEDMBAMs(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[156]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimerConfigTBGLEARNSTARTS':  [157,0] -> [157,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetTimerConfigTBGLEARNSTARTS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[157]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimerConfigTLEARNSTARTSFOFFS':  [158,0] -> [158,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetTimerConfigTLEARNSTARTSFOFFS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[158]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimerConfigTMANMODESFOFFS':  [159,0] -> [159,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetTimerConfigTMANMODESFOFFS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[159]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimerConfigTSTATIONSELECTSFOFFS':  [160,0] -> [160,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetTimerConfigTSTATIONSELECTSFOFFS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[160]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimerConfigTSLSSIGNALLOSTS':  [161,0] -> [161,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetTimerConfigTSLSSIGNALLOSTS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[161]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimerConfigTCLEARRTDELAYS':  [162,0] -> [162,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetTimerConfigTCLEARRTDELAYS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[162]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TimerConfigTCLEARRTAFTERSYNCLOSTS':  [163,0] -> [163,7] (Bitlen: 8)
tU8 dp_tclKdsDABParameterSet::u8GetTimerConfigTCLEARRTAFTERSYNCLOSTS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[163]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LSMConfigEID':  [164,0] -> [165,7] (Bitlen: 16)
tU8 dp_tclKdsDABParameterSet::u8GetLSMConfigEID(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[164], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LSMConfigEnsembleLabel':  [166,0] -> [181,7] (Bitlen: 128)
tU8 dp_tclKdsDABParameterSet::u8GetLSMConfigEnsembleLabel(tU8* pu8Data, tU16 u16BufLen) {
   if (16<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[166], 16);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LSMConfigEnsembleShortLabelMask':  [182,0] -> [183,7] (Bitlen: 16)
tU8 dp_tclKdsDABParameterSet::u8GetLSMConfigEnsembleShortLabelMask(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[182], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LSMConfigSID':  [184,0] -> [185,7] (Bitlen: 16)
tU8 dp_tclKdsDABParameterSet::u8GetLSMConfigSID(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[184], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LSMConfigServiceLabel':  [186,0] -> [201,7] (Bitlen: 128)
tU8 dp_tclKdsDABParameterSet::u8GetLSMConfigServiceLabel(tU8* pu8Data, tU16 u16BufLen) {
   if (16<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[186], 16);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LSMConfigServiceShortLabelMask':  [202,0] -> [203,7] (Bitlen: 16)
tU8 dp_tclKdsDABParameterSet::u8GetLSMConfigServiceShortLabelMask(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[202], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LSMConfigComponentID':  [204,0] -> [205,7] (Bitlen: 16)
tU8 dp_tclKdsDABParameterSet::u8GetLSMConfigComponentID(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[204], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LSMConfigComponentLabel':  [206,0] -> [221,7] (Bitlen: 128)
tU8 dp_tclKdsDABParameterSet::u8GetLSMConfigComponentLabel(tU8* pu8Data, tU16 u16BufLen) {
   if (16<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[206], 16);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LSMConfigComponentShortLabelMask':  [222,0] -> [223,7] (Bitlen: 16)
tU8 dp_tclKdsDABParameterSet::u8GetLSMConfigComponentShortLabelMask(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[222], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LSMConfigChannel':  [224,0] -> [226,7] (Bitlen: 24)
tU8 dp_tclKdsDABParameterSet::u8GetLSMConfigChannel(tU8* pu8Data, tU16 u16BufLen) {
   if (3<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[224], 3);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'TunerBand1':  [227,0] -> [227,3] (Bitlen: 4)
tU8 dp_tclKdsDABParameterSet::u8GetTunerBand1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[227]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'TunerBand2':  [227,4] -> [227,7] (Bitlen: 4)
tU8 dp_tclKdsDABParameterSet::u8GetTunerBand2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[227]&0xf0)>>4);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  AntennaParameter  (Key: 0x0430)          
//##########################################################

dp_tclKdsAntennaParameter::dp_tclKdsAntennaParameter() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_ANTENNAPARAMETER_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsAntennaParameter::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsAntennaParameter::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x0430, 0x83, pu8CurPos)) {
      pu8CurPos += 0x83;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsAntennaParameter::u8GetAntennaParameter(tU8* pu8Data, tU16 u16BufLen) {
   if (0x83<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_ANTENNAPARAMETER_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsAntennaParameter::u8DataValid() const {return _u8DataStatus;};
//Key 'Tag':  [0,0] -> [7,7] (Bitlen: 64)
tU8 dp_tclKdsAntennaParameter::u8GetTag(tU8* pu8Data, tU16 u16BufLen) {
   if (8<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 8);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MajorVersion':  [8,0] -> [8,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetMajorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinorVersion':  [9,0] -> [10,7] (Bitlen: 16)
tU8 dp_tclKdsAntennaParameter::u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[9], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1Type':  [11,0] -> [11,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1Type(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1Open':  [12,0] -> [12,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1Open(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1OpenClear':  [13,0] -> [13,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1OpenClear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1ConsiderVoltageForOpen':  [14,0] -> [14,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1ConsiderVoltageForOpen(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1ConsiderIgnitionForOpen':  [15,0] -> [15,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1ConsiderIgnitionForOpen(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1OpenAmplifier':  [16,0] -> [16,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1OpenAmplifier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[16]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1OpenAmplifierClearLow':  [17,0] -> [17,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1OpenAmplifierClearLow(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1OpenAmplifierClearHigh':  [18,0] -> [18,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1OpenAmplifierClearHigh(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1ConsiderVoltageForOpenAmplidier':  [19,0] -> [19,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1ConsiderVoltageForOpenAmplidier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[19]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1ConsiderIgnitionForOpenAmplifier':  [20,0] -> [20,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1ConsiderIgnitionForOpenAmplifier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[20]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1Short':  [21,0] -> [21,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1Short(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[21]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1ShortClear':  [22,0] -> [22,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1ShortClear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[22]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1ConsiderVoltageForShort':  [23,0] -> [23,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1ConsiderVoltageForShort(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[23]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1ConsiderIgnitionForShort':  [24,0] -> [24,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1ConsiderIgnitionForShort(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[24]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1MonitorCycle':  [25,0] -> [25,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1MonitorCycle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[25]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1NoOfMonitorCycle':  [26,0] -> [26,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1NoOfMonitorCycle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[26]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1ShortCircuitWait':  [27,0] -> [27,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1ShortCircuitWait(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[27]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM1ConsiderCriticalHighVoltage':  [28,0] -> [28,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM1ConsiderCriticalHighVoltage(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[28]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2Type':  [31,0] -> [31,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2Type(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[31]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2Open':  [32,0] -> [32,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2Open(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[32]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2OpenClear':  [33,0] -> [33,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2OpenClear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[33]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2ConsiderVoltageForOpen':  [34,0] -> [34,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2ConsiderVoltageForOpen(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[34]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2ConsiderIgnitionForOpen':  [35,0] -> [35,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2ConsiderIgnitionForOpen(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[35]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2OpenAmplifier':  [36,0] -> [36,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2OpenAmplifier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[36]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2OpenAmplifierClearLow':  [37,0] -> [37,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2OpenAmplifierClearLow(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[37]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2OpenAmplifierClearHigh':  [38,0] -> [38,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2OpenAmplifierClearHigh(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[38]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2ConsiderVoltageForOpenAmplidier':  [39,0] -> [39,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2ConsiderVoltageForOpenAmplidier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[39]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2ConsiderIgnitionForOpenAmplifier':  [40,0] -> [40,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2ConsiderIgnitionForOpenAmplifier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[40]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2Short':  [41,0] -> [41,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2Short(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[41]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2ShortClear':  [42,0] -> [42,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2ShortClear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2ConsiderVoltageForShort':  [43,0] -> [43,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2ConsiderVoltageForShort(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[43]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2ConsiderIgnitionForShort':  [44,0] -> [44,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2ConsiderIgnitionForShort(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[44]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2MonitorCycle':  [45,0] -> [45,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2MonitorCycle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[45]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2NoOfMonitorCycle':  [46,0] -> [46,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2NoOfMonitorCycle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[46]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2ShortCircuitWait':  [47,0] -> [47,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2ShortCircuitWait(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[47]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaFM2ConsiderCriticalHighVoltage':  [48,0] -> [48,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaFM2ConsiderCriticalHighVoltage(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[48]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1Type':  [51,0] -> [51,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1Type(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[51]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1Open':  [52,0] -> [52,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1Open(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[52]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1OpenClear':  [53,0] -> [53,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1OpenClear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[53]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1ConsiderVoltageForOpen':  [54,0] -> [54,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1ConsiderVoltageForOpen(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[54]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1ConsiderIgnitionForOpen':  [55,0] -> [55,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1ConsiderIgnitionForOpen(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[55]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1OpenAmplifier':  [56,0] -> [56,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1OpenAmplifier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[56]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1OpenAmplifierClearLow':  [57,0] -> [57,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1OpenAmplifierClearLow(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[57]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1OpenAmplifierClearHigh':  [58,0] -> [58,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1OpenAmplifierClearHigh(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1ConsiderVoltageForOpenAmplidier':  [59,0] -> [59,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1ConsiderVoltageForOpenAmplidier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[59]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1ConsiderIgnitionForOpenAmplifier':  [60,0] -> [60,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1ConsiderIgnitionForOpenAmplifier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[60]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1Short':  [61,0] -> [61,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1Short(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[61]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1ShortClear':  [62,0] -> [62,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1ShortClear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[62]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1ConsiderVoltageForShort':  [63,0] -> [63,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1ConsiderVoltageForShort(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[63]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1ConsiderIgnitionForShort':  [64,0] -> [64,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1ConsiderIgnitionForShort(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[64]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1MonitorCycle':  [65,0] -> [65,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1MonitorCycle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[65]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1NoOfMonitorCycle':  [66,0] -> [66,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1NoOfMonitorCycle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[66]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1ShortCircuitWait':  [67,0] -> [67,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1ShortCircuitWait(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[67]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaDAB1ConsiderCriticalHighVoltage':  [68,0] -> [68,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaDAB1ConsiderCriticalHighVoltage(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[68]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSType':  [71,0] -> [71,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[71]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSOpen':  [72,0] -> [72,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSOpen(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[72]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSOpenClear':  [73,0] -> [73,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSOpenClear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[73]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSConsiderVoltageForOpen':  [74,0] -> [74,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSConsiderVoltageForOpen(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[74]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSConsiderIgnitionForOpen':  [75,0] -> [75,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSConsiderIgnitionForOpen(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[75]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSOpenAmplifier':  [76,0] -> [76,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSOpenAmplifier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[76]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSOpenAmplifierClearLow':  [77,0] -> [77,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSOpenAmplifierClearLow(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[77]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSOpenAmplifierClearHigh':  [78,0] -> [78,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSOpenAmplifierClearHigh(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[78]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSConsiderVoltageForOpenAmplidier':  [79,0] -> [79,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSConsiderVoltageForOpenAmplidier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[79]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSConsiderIgnitionForOpenAmplifier':  [80,0] -> [80,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSConsiderIgnitionForOpenAmplifier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[80]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSShort':  [81,0] -> [81,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSShort(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[81]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSShortClear':  [82,0] -> [82,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSShortClear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[82]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSConsiderVoltageForShort':  [83,0] -> [83,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSConsiderVoltageForShort(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[83]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSConsiderIgnitionForShort':  [84,0] -> [84,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSConsiderIgnitionForShort(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[84]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSMonitorCycle':  [85,0] -> [85,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSMonitorCycle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[85]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSNoOfMonitorCycle':  [86,0] -> [86,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSNoOfMonitorCycle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[86]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSShortCircuitWait':  [87,0] -> [87,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSShortCircuitWait(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[87]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaGPSConsiderCriticalHighVoltage':  [88,0] -> [88,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaGPSConsiderCriticalHighVoltage(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[88]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12Type':  [91,0] -> [91,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12Type(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[91]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12Open':  [92,0] -> [92,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12Open(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[92]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12OpenClear':  [93,0] -> [93,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12OpenClear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[93]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12ConsiderVoltageForOpen':  [94,0] -> [94,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12ConsiderVoltageForOpen(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[94]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12ConsiderIgnitionForOpen':  [95,0] -> [95,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12ConsiderIgnitionForOpen(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[95]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12OpenAmplifier':  [96,0] -> [96,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12OpenAmplifier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[96]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12OpenAmplifierClearLow':  [97,0] -> [97,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12OpenAmplifierClearLow(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[97]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12OpenAmplifierClearHigh':  [98,0] -> [98,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12OpenAmplifierClearHigh(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[98]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12ConsiderVoltageForOpenAmplifier':  [99,0] -> [99,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12ConsiderVoltageForOpenAmplifier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[99]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12ConsiderIgnitionForOpenAmplifier':  [100,0] -> [100,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12ConsiderIgnitionForOpenAmplifier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[100]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12Short':  [101,0] -> [101,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12Short(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[101]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12ShortClear':  [102,0] -> [102,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12ShortClear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[102]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12ConsiderVoltageForShort':  [103,0] -> [103,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12ConsiderVoltageForShort(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[103]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12ConsiderIgnitionForShort':  [104,0] -> [104,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12ConsiderIgnitionForShort(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[104]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12MonitorCycle':  [105,0] -> [105,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12MonitorCycle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[105]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12NoOfMonitorCycle':  [106,0] -> [106,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12NoOfMonitorCycle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[106]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12ShortCircuitWait':  [107,0] -> [107,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12ShortCircuitWait(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[107]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV12ConsiderCriticalHighVoltage':  [108,0] -> [108,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV12ConsiderCriticalHighVoltage(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[108]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34Type':  [111,0] -> [111,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34Type(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[111]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34Open':  [112,0] -> [112,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34Open(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[112]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34OpenClear':  [113,0] -> [113,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34OpenClear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[113]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34ConsiderVoltageForOpen':  [114,0] -> [114,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34ConsiderVoltageForOpen(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[114]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34ConsiderIgnitionForOpen':  [115,0] -> [115,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34ConsiderIgnitionForOpen(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[115]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34OpenAmplifier':  [116,0] -> [116,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34OpenAmplifier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[116]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34OpenAmplifierClearLow':  [117,0] -> [117,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34OpenAmplifierClearLow(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[117]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34OpenAmplifierClearHigh':  [118,0] -> [118,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34OpenAmplifierClearHigh(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[118]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34ConsiderVoltageForOpenAmplifier':  [119,0] -> [119,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34ConsiderVoltageForOpenAmplifier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[119]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34ConsiderIgnitionForOpenAmplifier':  [120,0] -> [120,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34ConsiderIgnitionForOpenAmplifier(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[120]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34Short':  [121,0] -> [121,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34Short(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[121]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34ShortClear':  [122,0] -> [122,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34ShortClear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[122]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34ConsiderVoltageForShort':  [123,0] -> [123,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34ConsiderVoltageForShort(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[123]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34ConsiderIgnitionForShort':  [124,0] -> [124,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34ConsiderIgnitionForShort(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[124]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34MonitorCycle':  [125,0] -> [125,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34MonitorCycle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[125]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34NoOfMonitorCycle':  [126,0] -> [126,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34NoOfMonitorCycle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[126]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34ShortCircuitWait':  [127,0] -> [127,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34ShortCircuitWait(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[127]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AntennaTV34ConsiderCriticalHighVoltage':  [128,0] -> [128,7] (Bitlen: 8)
tU8 dp_tclKdsAntennaParameter::u8GetAntennaTV34ConsiderCriticalHighVoltage(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[128]&0xff)>>0);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  SystemConfiguration1  (Key: 0xA110)          
//##########################################################

dp_tclKdsSystemConfiguration1::dp_tclKdsSystemConfiguration1() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_SYSTEMCONFIGURATION1_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsSystemConfiguration1::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsSystemConfiguration1::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA110, 0x40, pu8CurPos)) {
      pu8CurPos += 0x40;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsSystemConfiguration1::u8GetSystemConfiguration1(tU8* pu8Data, tU16 u16BufLen) {
   if (0x40<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_SYSTEMCONFIGURATION1_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsSystemConfiguration1::u8DataValid() const {return _u8DataStatus;};
//Key 'UCANUpdateMethod':  [0,0] -> [0,1] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetUCANUpdateMethod(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'SupportedDistanceUnits':  [1,0] -> [1,2] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetSupportedDistanceUnits(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x7)>>0);
   }
   return _u8DataStatus;
}

//Key 'DefaultDistanceUnits':  [1,3] -> [1,4] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetDefaultDistanceUnits(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x18)>>3);
   }
   return _u8DataStatus;
}

//Key 'SupportedTemperatureUnit':  [1,5] -> [1,6] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetSupportedTemperatureUnit(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x60)>>5);
   }
   return _u8DataStatus;
}

//Key 'DefaultTemperatureUnit':  [1,7] -> [1,7] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetDefaultTemperatureUnit(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'DefaultLanguage':  [2,0] -> [2,7] (Bitlen: 8)
tU8 dp_tclKdsSystemConfiguration1::u8GetDefaultLanguage(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ShowClock':  [3,0] -> [3,0] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetShowClock(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'Clock1224h':  [3,1] -> [3,1] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetClock1224h(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'MeterClockSynchronisation':  [3,2] -> [3,2] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetMeterClockSynchronisation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'ClockSynchronisationSource':  [3,3] -> [3,3] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetClockSynchronisationSource(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'EcoScoreDisplay':  [3,4] -> [3,4] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetEcoScoreDisplay(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'OffRoadInformation':  [3,5] -> [3,5] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetOffRoadInformation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'Brand':  [4,0] -> [4,2] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetBrand(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0x7)>>0);
   }
   return _u8DataStatus;
}

//Key 'OpeningAnimation':  [4,3] -> [4,6] (Bitlen: 4)
tU8 dp_tclKdsSystemConfiguration1::u8GetOpeningAnimation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0x78)>>3);
   }
   return _u8DataStatus;
}

//Key 'HEVInformationFunction':  [5,0] -> [5,0] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetHEVInformationFunction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'HEVDriveType':  [5,1] -> [5,3] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetHEVDriveType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0xe)>>1);
   }
   return _u8DataStatus;
}

//Key 'SoundOnEncoderPress':  [6,0] -> [6,0] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetSoundOnEncoderPress(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'EcoChallenge':  [6,1] -> [6,1] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetEcoChallenge(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'EcoFunction':  [6,2] -> [6,2] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetEcoFunction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'SpeedLockRestrictions':  [6,3] -> [6,3] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetSpeedLockRestrictions(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'SpeedLockMinThresholdForUseRestrictionKmH':  [7,0] -> [7,7] (Bitlen: 8)
tU8 dp_tclKdsSystemConfiguration1::u8GetSpeedLockMinThresholdForUseRestrictionKmH(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[7]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SpeedLockMaxThresholdForUseRestrictionKmH':  [8,0] -> [8,7] (Bitlen: 8)
tU8 dp_tclKdsSystemConfiguration1::u8GetSpeedLockMaxThresholdForUseRestrictionKmH(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TyrePressureResetRestriction':  [9,0] -> [9,0] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetTyrePressureResetRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[9]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeatRestriction':  [9,1] -> [9,1] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetSeatRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[9]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'DisplayActivation':  [9,2] -> [9,2] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetDisplayActivation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[9]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'ExtTempDisplayCfg':  [9,3] -> [9,3] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetExtTempDisplayCfg(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[9]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'PORT':  [10,0] -> [11,7] (Bitlen: 16)
tU8 dp_tclKdsSystemConfiguration1::u8GetPORT(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[10], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'ANCActivation':  [24,4] -> [24,4] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetANCActivation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[24]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'ESEActivation':  [24,6] -> [24,7] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetESEActivation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[24]&0xc0)>>6);
   }
   return _u8DataStatus;
}

//Key 'VoiceRecognition':  [25,0] -> [25,1] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetVoiceRecognition(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[25]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'VRBeepOnly':  [25,2] -> [25,2] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetVRBeepOnly(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[25]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'VRShortPrompts':  [25,3] -> [25,3] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetVRShortPrompts(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[25]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'TTS':  [25,4] -> [25,4] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetTTS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[25]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'AutoBargeIn':  [26,0] -> [26,1] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetAutoBargeIn(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[26]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'OutputInformation':  [26,2] -> [26,5] (Bitlen: 4)
tU8 dp_tclKdsSystemConfiguration1::u8GetOutputInformation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[26]&0x3c)>>2);
   }
   return _u8DataStatus;
}

//Key 'TweeterSetup':  [26,6] -> [26,7] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetTweeterSetup(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[26]&0xc0)>>6);
   }
   return _u8DataStatus;
}

//Key 'SonarVolume':  [27,0] -> [27,2] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetSonarVolume(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[27]&0x7)>>0);
   }
   return _u8DataStatus;
}

//Key 'SpeedCurve':  [27,3] -> [27,5] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetSpeedCurve(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[27]&0x38)>>3);
   }
   return _u8DataStatus;
}

//Key 'AudioConfiguration':  [27,6] -> [27,7] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetAudioConfiguration(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[27]&0xc0)>>6);
   }
   return _u8DataStatus;
}

//Key 'DVDRegionCode':  [28,0] -> [28,2] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetDVDRegionCode(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[28]&0x7)>>0);
   }
   return _u8DataStatus;
}

//Key 'BDRegionCode':  [28,3] -> [28,4] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetBDRegionCode(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[28]&0x18)>>3);
   }
   return _u8DataStatus;
}

//Key 'AUX':  [29,0] -> [29,1] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetAUX(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[29]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'MCH1MountInformation':  [29,2] -> [29,3] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetMCH1MountInformation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[29]&0xc)>>2);
   }
   return _u8DataStatus;
}

//Key 'AMTunerActivation':  [29,4] -> [29,5] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetAMTunerActivation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[29]&0x30)>>4);
   }
   return _u8DataStatus;
}

//Key 'DAB':  [30,0] -> [30,0] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetDAB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[30]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CMFSupportForETC':  [31,0] -> [31,0] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetCMFSupportForETC(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[31]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'WifiFunction':  [32,0] -> [32,0] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetWifiFunction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[32]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'BluetoothFunction':  [32,1] -> [32,1] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetBluetoothFunction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[32]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'WiFiIVCTethering':  [32,2] -> [32,2] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetWiFiIVCTethering(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[32]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CarPlay':  [32,3] -> [32,3] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetCarPlay(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[32]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'AndroidAuto':  [32,4] -> [32,4] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetAndroidAuto(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[32]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'MySPIN':  [32,5] -> [32,5] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetMySPIN(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[32]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'ATbox':  [32,6] -> [32,7] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetATbox(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[32]&0xc0)>>6);
   }
   return _u8DataStatus;
}

//Key 'ModelYear':  [33,0] -> [33,4] (Bitlen: 5)
tU8 dp_tclKdsSystemConfiguration1::u8GetModelYear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[33]&0x1f)>>0);
   }
   return _u8DataStatus;
}

//Key 'Wifi5GHZSupport':  [33,5] -> [33,5] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetWifi5GHZSupport(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[33]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'OnCar':  [33,6] -> [33,6] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetOnCar(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[33]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'TruckLCVRoute':  [34,0] -> [34,0] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetTruckLCVRoute(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[34]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'VehicleFleet':  [34,1] -> [34,3] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetVehicleFleet(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[34]&0xe)>>1);
   }
   return _u8DataStatus;
}

//Key 'MinimizeUnpavedRoads':  [34,4] -> [34,4] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetMinimizeUnpavedRoads(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[34]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'KindOfDestinationEntry':  [35,0] -> [35,3] (Bitlen: 4)
tU8 dp_tclKdsSystemConfiguration1::u8GetKindOfDestinationEntry(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[35]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'Disclaimer':  [35,4] -> [35,4] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetDisclaimer(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[35]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'MapZoom':  [35,5] -> [35,5] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetMapZoom(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[35]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'MQTTPayloadCompression':  [35,7] -> [35,7] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetMQTTPayloadCompression(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[35]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'AutomaticPhoneBookTransfer':  [36,0] -> [36,0] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetAutomaticPhoneBookTransfer(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[36]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'VA':  [36,1] -> [36,1] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetVA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[36]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'BTVR':  [36,2] -> [36,2] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetBTVR(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[36]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'WBS':  [36,3] -> [36,3] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetWBS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[36]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'VAOnShortpress':  [36,4] -> [36,4] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetVAOnShortpress(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[36]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'MQTTSessionType':  [37,0] -> [37,7] (Bitlen: 8)
tU8 dp_tclKdsSystemConfiguration1::u8GetMQTTSessionType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[37]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CNFCHGSTNFIND':  [39,0] -> [39,0] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetCNFCHGSTNFIND(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[39]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CNFCHGSTNSORT':  [39,1] -> [39,1] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetCNFCHGSTNSORT(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[39]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'CNFLOWBATALT':  [39,2] -> [39,2] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetCNFLOWBATALT(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[39]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CNFGUARDANG':  [39,3] -> [39,3] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetCNFGUARDANG(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[39]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CNFCHGTIMEFORECAST':  [39,4] -> [39,4] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetCNFCHGTIMEFORECAST(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[39]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'CNFPSOC':  [39,5] -> [39,5] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetCNFPSOC(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[39]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'CNFREROUTEALT':  [39,6] -> [39,6] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetCNFREROUTEALT(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[39]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CNFREACHAREA':  [39,7] -> [39,7] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetCNFREACHAREA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[39]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'InfoFromMeterLimitedPower':  [40,1] -> [40,1] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetInfoFromMeterLimitedPower(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[40]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'InfoFromMeterDCDCCaution':  [40,2] -> [40,2] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetInfoFromMeterDCDCCaution(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[40]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'TIMERCHARGING':  [40,3] -> [40,3] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetTIMERCHARGING(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[40]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'TIMERPREAIRCONDITIONING':  [40,4] -> [40,4] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetTIMERPREAIRCONDITIONING(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[40]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'EnergyHistoryConsumption':  [40,5] -> [40,5] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetEnergyHistoryConsumption(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[40]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'RemoteApplicationSupport':  [40,6] -> [40,6] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetRemoteApplicationSupport(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[40]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'EVPHEVRealTimeEnergyFlowDisplay':  [41,0] -> [41,0] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetEVPHEVRealTimeEnergyFlowDisplay(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[41]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'EVPHEVEnergyFlow15mnHistoricalGraph':  [41,1] -> [41,1] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetEVPHEVEnergyFlow15mnHistoricalGraph(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[41]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'EnergyInformation':  [41,2] -> [41,2] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetEnergyInformation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[41]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'PowerConsumptionInformation':  [41,3] -> [41,3] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetPowerConsumptionInformation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[41]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'PreConditioningDurationVehicleNotPlugged':  [42,0] -> [42,7] (Bitlen: 8)
tU8 dp_tclKdsSystemConfiguration1::u8GetPreConditioningDurationVehicleNotPlugged(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'PreConditioningMedianTemperatureRequest':  [43,0] -> [43,7] (Bitlen: 8)
tU8 dp_tclKdsSystemConfiguration1::u8GetPreConditioningMedianTemperatureRequest(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[43]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SkinChoiceComfort1':  [44,1] -> [44,3] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetSkinChoiceComfort1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[44]&0xe)>>1);
   }
   return _u8DataStatus;
}

//Key 'CarType':  [44,5] -> [44,7] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetCarType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[44]&0xe0)>>5);
   }
   return _u8DataStatus;
}

//Key 'SkinChoiceComfort12':  [45,2] -> [45,4] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetSkinChoiceComfort12(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[45]&0x1c)>>2);
   }
   return _u8DataStatus;
}

//Key 'SkinChoiceEco1':  [45,5] -> [45,7] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetSkinChoiceEco1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[45]&0xe0)>>5);
   }
   return _u8DataStatus;
}

//Key 'SkinChoiceDynamic1':  [46,2] -> [46,4] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetSkinChoiceDynamic1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[46]&0x1c)>>2);
   }
   return _u8DataStatus;
}

//Key 'SkinChoiceNormal1':  [46,5] -> [46,7] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetSkinChoiceNormal1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[46]&0xe0)>>5);
   }
   return _u8DataStatus;
}

//Key 'SkinChoicePerso1':  [47,5] -> [47,7] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetSkinChoicePerso1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[47]&0xe0)>>5);
   }
   return _u8DataStatus;
}

//Key 'MexSwitchIntensityWithoutAmbientLighting':  [48,0] -> [48,7] (Bitlen: 8)
tU8 dp_tclKdsSystemConfiguration1::u8GetMexSwitchIntensityWithoutAmbientLighting(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[48]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'PreferentialMode2':  [49,0] -> [49,2] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetPreferentialMode2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[49]&0x7)>>0);
   }
   return _u8DataStatus;
}

//Key 'PreferentialMode1':  [49,3] -> [49,5] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetPreferentialMode1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[49]&0x38)>>3);
   }
   return _u8DataStatus;
}

//Key 'DualModeMgt':  [49,6] -> [49,6] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetDualModeMgt(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[49]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'ESESoundVolumeComfort':  [50,2] -> [50,4] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESoundVolumeComfort(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[50]&0x1c)>>2);
   }
   return _u8DataStatus;
}

//Key 'ESESoundVolumeEco1':  [50,5] -> [50,7] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESoundVolumeEco1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[50]&0xe0)>>5);
   }
   return _u8DataStatus;
}

//Key 'ESESoundVolumeDynamic1':  [51,2] -> [51,4] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESoundVolumeDynamic1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[51]&0x1c)>>2);
   }
   return _u8DataStatus;
}

//Key 'ESESoundVolumeNormal':  [51,5] -> [51,7] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESoundVolumeNormal(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[51]&0xe0)>>5);
   }
   return _u8DataStatus;
}

//Key 'ESESoundTypeEco1':  [52,1] -> [52,2] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESoundTypeEco1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[52]&0x6)>>1);
   }
   return _u8DataStatus;
}

//Key 'ESESoundVolumePerso1':  [52,3] -> [52,5] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESoundVolumePerso1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[52]&0x38)>>3);
   }
   return _u8DataStatus;
}

//Key 'ESESoundTypePerso1':  [53,0] -> [53,1] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESoundTypePerso1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[53]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'ESESoundTypeDynamic1':  [53,2] -> [53,3] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESoundTypeDynamic1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[53]&0xc)>>2);
   }
   return _u8DataStatus;
}

//Key 'ESESoundTypeNormal1':  [53,4] -> [53,5] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESoundTypeNormal1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[53]&0x30)>>4);
   }
   return _u8DataStatus;
}

//Key 'ESESoundTypeComfort1':  [53,6] -> [53,7] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESoundTypeComfort1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[53]&0xc0)>>6);
   }
   return _u8DataStatus;
}

//Key 'ESESound1Name':  [54,0] -> [54,2] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESound1Name(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[54]&0x7)>>0);
   }
   return _u8DataStatus;
}

//Key 'ESESound2Name':  [54,3] -> [54,5] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESound2Name(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[54]&0x38)>>3);
   }
   return _u8DataStatus;
}

//Key 'ESESound1VolumeHMI':  [54,6] -> [54,6] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESound1VolumeHMI(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[54]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'ESESound2VolumeHMI':  [54,7] -> [54,7] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESound2VolumeHMI(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[54]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'ESESoundVolumeRace':  [55,3] -> [55,5] (Bitlen: 3)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESoundVolumeRace(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[55]&0x38)>>3);
   }
   return _u8DataStatus;
}

//Key 'ESEHMI':  [55,6] -> [55,7] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetESEHMI(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[55]&0xc0)>>6);
   }
   return _u8DataStatus;
}

//Key 'WirelessAndroidAutoFunction':  [56,0] -> [56,0] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetWirelessAndroidAutoFunction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[56]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CNFVPA':  [56,6] -> [56,7] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetCNFVPA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[56]&0xc0)>>6);
   }
   return _u8DataStatus;
}

//Key 'ESESoundTypeRace1':  [57,0] -> [57,1] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetESESoundTypeRace1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[57]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'TouchScreenConfiguration':  [57,4] -> [57,7] (Bitlen: 4)
tU8 dp_tclKdsSystemConfiguration1::u8GetTouchScreenConfiguration(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[57]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'BaiduCarLifeFunction':  [58,0] -> [58,0] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetBaiduCarLifeFunction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'WirelessCarPlayFunction':  [58,1] -> [58,1] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetWirelessCarPlayFunction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'HVACType':  [58,2] -> [58,3] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetHVACType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0xc)>>2);
   }
   return _u8DataStatus;
}

//Key 'MaintenanceInfoFunction':  [58,4] -> [58,4] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetMaintenanceInfoFunction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'VDCSetting':  [58,5] -> [58,5] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetVDCSetting(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'VehicleSetting':  [58,6] -> [58,6] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetVehicleSetting(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'DigitalAssistant':  [58,7] -> [58,7] (Bitlen: 1)
tU8 dp_tclKdsSystemConfiguration1::u8GetDigitalAssistant(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'HVACTemperature':  [59,0] -> [59,1] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetHVACTemperature(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[59]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'FOTABearer':  [59,2] -> [59,3] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetFOTABearer(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[59]&0xc)>>2);
   }
   return _u8DataStatus;
}

//Key 'DisplayType':  [59,4] -> [59,5] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetDisplayType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[59]&0x30)>>4);
   }
   return _u8DataStatus;
}

//Key 'MassageBehaviorInPowerState':  [59,6] -> [59,7] (Bitlen: 2)
tU8 dp_tclKdsSystemConfiguration1::u8GetMassageBehaviorInPowerState(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[59]&0xc0)>>6);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  ThermalManagmentTemperatureThresholds  (Key: 0x1310)          
//##########################################################

dp_tclKdsThermalManagmentTemperatureThresholds::dp_tclKdsThermalManagmentTemperatureThresholds() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsThermalManagmentTemperatureThresholds::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsThermalManagmentTemperatureThresholds::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x1310, 0x7e, pu8CurPos)) {
      pu8CurPos += 0x7e;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetThermalManagmentTemperatureThresholds(tU8* pu8Data, tU16 u16BufLen) {
   if (0x7e<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_THERMALMANAGMENTTEMPERATURETHRESHOLDS_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8DataValid() const {return _u8DataStatus;};
//Key 'Version':  [0,0] -> [0,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SensorID1':  [1,0] -> [1,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetSensorID1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaximumTemperature1':  [2,0] -> [3,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetMaximumTemperature1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[2], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinimumTemperature1':  [4,0] -> [5,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetMinimumTemperature1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[4], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalHighTemperature1':  [6,0] -> [7,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalHighTemperature1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[6], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalHighTemperatureHysteresis1':  [8,0] -> [8,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalHighTemperatureHysteresis1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CriticalHighTemperatureTimeDelay1':  [9,0] -> [10,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalHighTemperatureTimeDelay1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[9], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'HighTemperature1':  [11,0] -> [12,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetHighTemperature1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[11], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'HighTemperatureHysteresis1':  [13,0] -> [13,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetHighTemperatureHysteresis1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'HighTemperatureTimeDelay1':  [14,0] -> [15,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetHighTemperatureTimeDelay1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[14], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LowTemperature1':  [16,0] -> [17,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetLowTemperature1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[16], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LowTemperatureHysteresis1':  [18,0] -> [18,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetLowTemperatureHysteresis1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LowTemperatureTimeDelay1':  [19,0] -> [20,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetLowTemperatureTimeDelay1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[19], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalLowTemperature1':  [21,0] -> [22,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalLowTemperature1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[21], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalLowTemperatureHysteresis1':  [23,0] -> [23,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalLowTemperatureHysteresis1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[23]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CriticalLowTemperatureTimeDelay1':  [24,0] -> [25,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalLowTemperatureTimeDelay1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[24], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SensorID2':  [26,0] -> [26,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetSensorID2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[26]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaximumTemperature2':  [27,0] -> [28,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetMaximumTemperature2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[27], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinimumTemperature2':  [29,0] -> [30,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetMinimumTemperature2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[29], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalHighTemperature2':  [31,0] -> [32,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalHighTemperature2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[31], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalHighTemperatureHysteresis2':  [33,0] -> [33,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalHighTemperatureHysteresis2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[33]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CriticalHighTemperatureTimeDelay2':  [34,0] -> [35,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalHighTemperatureTimeDelay2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[34], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'HighTemperature2':  [36,0] -> [37,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetHighTemperature2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[36], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'HighTemperatureHysteresis2':  [38,0] -> [38,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetHighTemperatureHysteresis2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[38]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'HighTemperatureTimeDelay2':  [39,0] -> [40,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetHighTemperatureTimeDelay2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[39], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LowTemperature2':  [41,0] -> [42,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetLowTemperature2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[41], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LowTemperatureHysteresis2':  [43,0] -> [43,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetLowTemperatureHysteresis2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[43]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LowTemperatureTimeDelay2':  [44,0] -> [45,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetLowTemperatureTimeDelay2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[44], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalLowTemperature2':  [46,0] -> [47,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalLowTemperature2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[46], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalLowTemperatureHysteresis2':  [48,0] -> [48,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalLowTemperatureHysteresis2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[48]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CriticalLowTemperatureTimeDelay2':  [49,0] -> [50,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalLowTemperatureTimeDelay2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[49], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SensorID3':  [51,0] -> [51,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetSensorID3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[51]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaximumTemperature3':  [52,0] -> [53,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetMaximumTemperature3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[52], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinimumTemperature3':  [54,0] -> [55,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetMinimumTemperature3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[54], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalHighTemperature3':  [56,0] -> [57,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalHighTemperature3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[56], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalHighTemperatureHysteresis3':  [58,0] -> [58,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalHighTemperatureHysteresis3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CriticalHighTemperatureTimeDelay3':  [59,0] -> [60,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalHighTemperatureTimeDelay3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[59], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'HighTemperature3':  [61,0] -> [62,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetHighTemperature3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[61], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'HighTemperatureHysteresis3':  [63,0] -> [63,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetHighTemperatureHysteresis3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[63]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'HighTemperatureTimeDelay3':  [64,0] -> [65,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetHighTemperatureTimeDelay3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[64], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LowTemperature3':  [66,0] -> [67,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetLowTemperature3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[66], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LowTemperatureHysteresis3':  [68,0] -> [68,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetLowTemperatureHysteresis3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[68]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LowTemperatureTimeDelay3':  [69,0] -> [70,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetLowTemperatureTimeDelay3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[69], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalLowTemperature3':  [71,0] -> [72,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalLowTemperature3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[71], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalLowTemperatureHysteresis3':  [73,0] -> [73,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalLowTemperatureHysteresis3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[73]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CriticalLowTemperatureTimeDelay3':  [74,0] -> [75,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalLowTemperatureTimeDelay3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[74], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SensorID4':  [76,0] -> [76,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetSensorID4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[76]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaximumTemperature4':  [77,0] -> [78,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetMaximumTemperature4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[77], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinimumTemperature4':  [79,0] -> [80,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetMinimumTemperature4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[79], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalHighTemperature4':  [81,0] -> [82,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalHighTemperature4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[81], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalHighTemperatureHysteresis4':  [83,0] -> [83,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalHighTemperatureHysteresis4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[83]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CriticalHighTemperatureTimeDelay4':  [84,0] -> [85,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalHighTemperatureTimeDelay4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[84], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'HighTemperature4':  [86,0] -> [87,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetHighTemperature4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[86], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'HighTemperatureHysteresis4':  [88,0] -> [88,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetHighTemperatureHysteresis4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[88]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'HighTemperatureTimeDelay4':  [89,0] -> [90,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetHighTemperatureTimeDelay4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[89], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LowTemperature4':  [91,0] -> [92,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetLowTemperature4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[91], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LowTemperatureHysteresis4':  [93,0] -> [93,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetLowTemperatureHysteresis4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[93]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LowTemperatureTimeDelay4':  [94,0] -> [95,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetLowTemperatureTimeDelay4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[94], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalLowTemperature4':  [96,0] -> [97,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalLowTemperature4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[96], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalLowTemperatureHysteresis4':  [98,0] -> [98,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalLowTemperatureHysteresis4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[98]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CriticalLowTemperatureTimeDelay4':  [99,0] -> [100,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalLowTemperatureTimeDelay4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[99], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SensorID5':  [101,0] -> [101,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetSensorID5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[101]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaximumTemperature5':  [102,0] -> [103,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetMaximumTemperature5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[102], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MinimumTemperature5':  [104,0] -> [105,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetMinimumTemperature5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[104], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalHighTemperature5':  [106,0] -> [107,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalHighTemperature5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[106], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalHighTemperatureHysteresis5':  [108,0] -> [108,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalHighTemperatureHysteresis5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[108]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CriticalHighTemperatureTimeDelay5':  [109,0] -> [110,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalHighTemperatureTimeDelay5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[109], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'HighTemperature5':  [111,0] -> [112,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetHighTemperature5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[111], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'HighTemperatureHysteresis5':  [113,0] -> [113,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetHighTemperatureHysteresis5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[113]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'HighTemperatureTimeDelay5':  [114,0] -> [115,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetHighTemperatureTimeDelay5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[114], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LowTemperature5':  [116,0] -> [117,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetLowTemperature5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[116], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LowTemperatureHysteresis5':  [118,0] -> [118,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetLowTemperatureHysteresis5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[118]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LowTemperatureTimeDelay5':  [119,0] -> [120,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetLowTemperatureTimeDelay5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[119], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalLowTemperature5':  [121,0] -> [122,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalLowTemperature5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[121], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CriticalLowTemperatureHysteresis5':  [123,0] -> [123,7] (Bitlen: 8)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalLowTemperatureHysteresis5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[123]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CriticalLowTemperatureTimeDelay5':  [124,0] -> [125,7] (Bitlen: 16)
tU8 dp_tclKdsThermalManagmentTemperatureThresholds::u8GetCriticalLowTemperatureTimeDelay5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[124], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  DimmingParameter  (Key: 0x0D08)          
//##########################################################

dp_tclKdsDimmingParameter::dp_tclKdsDimmingParameter() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_DIMMINGPARAMETER_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsDimmingParameter::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsDimmingParameter::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x0D08, 0xe6, pu8CurPos)) {
      pu8CurPos += 0xe6;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsDimmingParameter::u8GetDimmingParameter(tU8* pu8Data, tU16 u16BufLen) {
   if (0xe6<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_DIMMINGPARAMETER_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsDimmingParameter::u8DataValid() const {return _u8DataStatus;};
//Key 'MajorVersion':  [0,0] -> [0,7] (Bitlen: 8)
tU8 dp_tclKdsDimmingParameter::u8GetMajorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinorVersion':  [1,0] -> [1,7] (Bitlen: 8)
tU8 dp_tclKdsDimmingParameter::u8GetMinorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC1':  [2,0] -> [3,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[2], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC2':  [4,0] -> [5,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[4], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC3':  [6,0] -> [7,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[6], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC4':  [8,0] -> [9,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[8], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC5':  [10,0] -> [11,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[10], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC6':  [12,0] -> [13,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC6(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[12], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC7':  [14,0] -> [15,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC7(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[14], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC8':  [16,0] -> [17,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC8(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[16], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC9':  [18,0] -> [19,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC9(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[18], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC10':  [20,0] -> [21,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC10(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[20], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC11':  [22,0] -> [23,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC11(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[22], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC12':  [24,0] -> [25,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC12(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[24], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC13':  [26,0] -> [27,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC13(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[26], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC14':  [28,0] -> [29,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC14(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[28], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC15':  [30,0] -> [31,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC15(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[30], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC16':  [32,0] -> [33,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC16(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[32], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC17':  [34,0] -> [35,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC17(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[34], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC18':  [36,0] -> [37,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC18(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[36], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC19':  [38,0] -> [39,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC19(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[38], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC20':  [40,0] -> [41,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC20(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[40], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC21':  [42,0] -> [43,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC21(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[42], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC22':  [44,0] -> [45,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC22(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[44], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC23':  [46,0] -> [47,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC23(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[46], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC24':  [48,0] -> [49,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC24(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[48], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC25':  [50,0] -> [51,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC25(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[50], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC26':  [52,0] -> [53,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC26(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[52], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC27':  [54,0] -> [55,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC27(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[54], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC28':  [56,0] -> [57,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC28(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[56], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC29':  [58,0] -> [59,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC29(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[58], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC30':  [60,0] -> [61,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC30(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[60], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC31':  [62,0] -> [63,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC31(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[62], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC32':  [64,0] -> [65,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC32(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[64], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMINIGHTC33':  [66,0] -> [67,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMINIGHTC33(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[66], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC1':  [68,0] -> [69,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[68], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC2':  [70,0] -> [71,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[70], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC3':  [72,0] -> [73,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[72], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC4':  [74,0] -> [75,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[74], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC5':  [76,0] -> [77,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[76], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC6':  [78,0] -> [79,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC6(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[78], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC7':  [80,0] -> [81,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC7(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[80], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC8':  [82,0] -> [83,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC8(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[82], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC9':  [84,0] -> [85,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC9(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[84], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC10':  [86,0] -> [87,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC10(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[86], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC11':  [88,0] -> [89,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC11(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[88], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC12':  [90,0] -> [91,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC12(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[90], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC13':  [92,0] -> [93,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC13(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[92], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC14':  [94,0] -> [95,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC14(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[94], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC15':  [96,0] -> [97,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC15(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[96], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC16':  [98,0] -> [99,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC16(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[98], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC17':  [100,0] -> [101,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC17(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[100], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC18':  [102,0] -> [103,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC18(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[102], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC19':  [104,0] -> [105,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC19(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[104], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC20':  [106,0] -> [107,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC20(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[106], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC21':  [108,0] -> [109,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC21(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[108], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC22':  [110,0] -> [111,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC22(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[110], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC23':  [112,0] -> [113,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC23(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[112], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC24':  [114,0] -> [115,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC24(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[114], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC25':  [116,0] -> [117,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC25(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[116], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC26':  [118,0] -> [119,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC26(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[118], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC27':  [120,0] -> [121,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC27(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[120], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC28':  [122,0] -> [123,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC28(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[122], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC29':  [124,0] -> [125,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC29(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[124], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC30':  [126,0] -> [127,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC30(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[126], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC31':  [128,0] -> [129,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC31(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[128], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC32':  [130,0] -> [131,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC32(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[130], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSCURVEHMIDAYC33':  [132,0] -> [133,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSCURVEHMIDAYC33(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[132], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DISPLAYILLUMINATIONOUTPUTFREQUENCY':  [134,0] -> [135,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetDISPLAYILLUMINATIONOUTPUTFREQUENCY(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[134], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'KEYSENCODERILLUMINATIONOUTPUTFREQUENCY':  [136,0] -> [137,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetKEYSENCODERILLUMINATIONOUTPUTFREQUENCY(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[136], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'TEMPCOMPENSATIONPWMMIN':  [138,0] -> [139,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetTEMPCOMPENSATIONPWMMIN(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[138], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'NUMBEROFKEYS':  [140,0] -> [140,7] (Bitlen: 8)
tU8 dp_tclKdsDimmingParameter::u8GetNUMBEROFKEYS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[140]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'HIGHTEMPERATURE':  [141,0] -> [142,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetHIGHTEMPERATURE(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[141], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CRITICALTEMPERATURE':  [143,0] -> [144,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetCRITICALTEMPERATURE(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[143], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LOWTEMPERATURE':  [145,0] -> [146,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetLOWTEMPERATURE(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[145], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSNOOFHMIOFFSET':  [147,0] -> [147,7] (Bitlen: 8)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSNOOFHMIOFFSET(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[147]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TEMPHYSTERESIS':  [148,0] -> [148,7] (Bitlen: 8)
tU8 dp_tclKdsDimmingParameter::u8GetTEMPHYSTERESIS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[148]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LIGHTNINGTIMINGDELAY':  [149,0] -> [150,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetLIGHTNINGTIMINGDELAY(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[149], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'KEYBRIGHTNESSNUMOFOFFSETS':  [151,0] -> [151,7] (Bitlen: 8)
tU8 dp_tclKdsDimmingParameter::u8GetKEYBRIGHTNESSNUMOFOFFSETS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[151]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SOFTDIMMINGENABLED':  [152,0] -> [152,7] (Bitlen: 8)
tU8 dp_tclKdsDimmingParameter::u8GetSOFTDIMMINGENABLED(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[152]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SOFTDIMMINGSAMPLINGTIME':  [153,0] -> [153,7] (Bitlen: 8)
tU8 dp_tclKdsDimmingParameter::u8GetSOFTDIMMINGSAMPLINGTIME(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[153]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SOFTDIMMINGCONSTANTK':  [154,0] -> [154,7] (Bitlen: 8)
tU8 dp_tclKdsDimmingParameter::u8GetSOFTDIMMINGCONSTANTK(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[154]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SOFTDIMMINGCONSTANTJ':  [155,0] -> [155,7] (Bitlen: 8)
tU8 dp_tclKdsDimmingParameter::u8GetSOFTDIMMINGCONSTANTJ(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[155]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSBACKLIGHTDAYBUTTONSDAY1':  [156,0] -> [157,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSBACKLIGHTDAYBUTTONSDAY1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[156], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSBACKLIGHTDAYBUTTONSNIGHT1':  [158,0] -> [159,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSBACKLIGHTDAYBUTTONSNIGHT1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[158], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSBACKLIGHTNIGHTBUTTONSNIGHT1':  [160,0] -> [161,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSBACKLIGHTNIGHTBUTTONSNIGHT1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[160], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSBACKLIGHTDAYBUTTONSON':  [162,0] -> [163,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSBACKLIGHTDAYBUTTONSON(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[162], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSBACKLIGHTDAYBUTTONSOFF1':  [164,0] -> [165,7] (Bitlen: 16)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSBACKLIGHTDAYBUTTONSOFF1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[164], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BRIGTHNESSBACKLIGHTNIGHTBUTTONSON21':  [166,0] -> [207,7] (Bitlen: 336)
tU8 dp_tclKdsDimmingParameter::u8GetBRIGTHNESSBACKLIGHTNIGHTBUTTONSON21(tU8* pu8Data, tU16 u16BufLen) {
   if (42<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[166], 42);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'KEYILLUMINATIONMODE':  [208,0] -> [208,7] (Bitlen: 8)
tU8 dp_tclKdsDimmingParameter::u8GetKEYILLUMINATIONMODE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[208]&0xff)>>0);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  InputKeyMappingTable_1  (Key: 0xA080)          
//##########################################################

dp_tclKdsInputKeyMappingTable_1::dp_tclKdsInputKeyMappingTable_1() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsInputKeyMappingTable_1::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsInputKeyMappingTable_1::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA080, 0xe6, pu8CurPos)) {
      pu8CurPos += 0xe6;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsInputKeyMappingTable_1::u8GetInputKeyMappingTable_1(tU8* pu8Data, tU16 u16BufLen) {
   if (0xe6<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_1_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsInputKeyMappingTable_1::u8DataValid() const {return _u8DataStatus;};
//Key 'MajorVersion':  [0,0] -> [0,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetMajorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinorVersion':  [1,0] -> [2,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[1], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'NrOfEntries':  [5,0] -> [5,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetNrOfEntries(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RawKeyID':  [6,0] -> [6,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID':  [8,0] -> [9,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[8], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID2':  [10,0] -> [10,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[10]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID2':  [12,0] -> [13,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[12], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID3':  [14,0] -> [14,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID3':  [16,0] -> [17,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[16], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID4':  [18,0] -> [18,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID4':  [20,0] -> [21,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[20], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID5':  [22,0] -> [22,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[22]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID5':  [24,0] -> [25,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[24], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID6':  [26,0] -> [26,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID6(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[26]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID6':  [28,0] -> [29,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID6(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[28], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID7':  [30,0] -> [30,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID7(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[30]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID7':  [32,0] -> [33,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID7(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[32], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID8':  [34,0] -> [34,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID8(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[34]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID8':  [36,0] -> [37,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID8(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[36], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID9':  [38,0] -> [38,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID9(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[38]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID9':  [40,0] -> [41,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID9(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[40], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID10':  [42,0] -> [42,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID10(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID10':  [44,0] -> [45,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID10(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[44], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID11':  [46,0] -> [46,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID11(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[46]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID11':  [48,0] -> [49,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID11(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[48], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID12':  [50,0] -> [50,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID12(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[50]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID12':  [52,0] -> [53,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID12(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[52], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID13':  [54,0] -> [54,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID13(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[54]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID13':  [56,0] -> [57,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID13(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[56], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID14':  [58,0] -> [58,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID14(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID14':  [60,0] -> [61,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID14(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[60], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID15':  [62,0] -> [62,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID15(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[62]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID15':  [64,0] -> [65,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID15(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[64], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID16':  [66,0] -> [66,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID16(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[66]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID16':  [68,0] -> [69,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID16(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[68], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID17':  [70,0] -> [70,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID17(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[70]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID17':  [72,0] -> [73,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID17(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[72], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID18':  [74,0] -> [74,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID18(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[74]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID18':  [76,0] -> [77,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID18(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[76], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID19':  [78,0] -> [78,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID19(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[78]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID19':  [80,0] -> [81,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID19(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[80], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID20':  [82,0] -> [82,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID20(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[82]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID20':  [84,0] -> [85,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID20(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[84], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID21':  [86,0] -> [86,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID21(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[86]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID21':  [88,0] -> [89,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID21(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[88], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID22':  [90,0] -> [90,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID22(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[90]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID22':  [92,0] -> [93,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID22(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[92], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID23':  [94,0] -> [94,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID23(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[94]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID23':  [96,0] -> [97,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID23(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[96], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID24':  [98,0] -> [98,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID24(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[98]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID24':  [100,0] -> [101,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID24(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[100], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID25':  [102,0] -> [102,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID25(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[102]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID25':  [104,0] -> [105,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID25(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[104], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID26':  [106,0] -> [106,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID26(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[106]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID26':  [108,0] -> [109,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID26(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[108], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID27':  [110,0] -> [110,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID27(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[110]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID27':  [112,0] -> [113,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID27(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[112], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID28':  [114,0] -> [114,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID28(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[114]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID28':  [116,0] -> [117,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID28(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[116], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID29':  [118,0] -> [118,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID29(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[118]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID29':  [120,0] -> [121,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID29(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[120], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID30':  [122,0] -> [122,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID30(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[122]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID30':  [124,0] -> [125,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID30(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[124], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID31':  [126,0] -> [126,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID31(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[126]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID31':  [128,0] -> [129,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID31(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[128], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID32':  [130,0] -> [130,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetRawKeyID32(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[130]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID32':  [132,0] -> [133,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_1::u8GetLogicalKeyID32(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[132], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  CMVariantCoding  (Key: 0x0DF4)          
//##########################################################

dp_tclKdsCMVariantCoding::dp_tclKdsCMVariantCoding() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_CMVARIANTCODING_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsCMVariantCoding::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsCMVariantCoding::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x0DF4, 0x20, pu8CurPos)) {
      pu8CurPos += 0x20;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsCMVariantCoding::u8GetCMVariantCoding(tU8* pu8Data, tU16 u16BufLen) {
   if (0x20<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_CMVARIANTCODING_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsCMVariantCoding::u8DataValid() const {return _u8DataStatus;};
//Key 'DiagnosisExtendedDataConsistencyCheck':  [0,0] -> [0,0] (Bitlen: 1)
tU8 dp_tclKdsCMVariantCoding::u8GetDiagnosisExtendedDataConsistencyCheck(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'InterfaceLock':  [0,1] -> [0,1] (Bitlen: 1)
tU8 dp_tclKdsCMVariantCoding::u8GetInterfaceLock(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'OEMType':  [3,0] -> [3,7] (Bitlen: 8)
tU8 dp_tclKdsCMVariantCoding::u8GetOEMType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'Bluetooth':  [4,1] -> [4,1] (Bitlen: 1)
tU8 dp_tclKdsCMVariantCoding::u8GetBluetooth(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'RVC':  [4,2] -> [4,2] (Bitlen: 1)
tU8 dp_tclKdsCMVariantCoding::u8GetRVC(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CD':  [4,3] -> [4,3] (Bitlen: 1)
tU8 dp_tclKdsCMVariantCoding::u8GetCD(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'XMTuner':  [4,4] -> [4,4] (Bitlen: 1)
tU8 dp_tclKdsCMVariantCoding::u8GetXMTuner(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'DAB':  [4,5] -> [4,5] (Bitlen: 1)
tU8 dp_tclKdsCMVariantCoding::u8GetDAB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'HDRadio':  [4,6] -> [4,6] (Bitlen: 1)
tU8 dp_tclKdsCMVariantCoding::u8GetHDRadio(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'DVD':  [4,7] -> [4,7] (Bitlen: 1)
tU8 dp_tclKdsCMVariantCoding::u8GetDVD(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'ADR3VariantInfo':  [5,0] -> [5,7] (Bitlen: 8)
tU8 dp_tclKdsCMVariantCoding::u8GetADR3VariantInfo(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADR3FlashVariantInfo':  [6,0] -> [6,7] (Bitlen: 8)
tU8 dp_tclKdsCMVariantCoding::u8GetADR3FlashVariantInfo(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'USBInfo':  [8,0] -> [8,7] (Bitlen: 8)
tU8 dp_tclKdsCMVariantCoding::u8GetUSBInfo(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AUXInfo':  [9,0] -> [9,7] (Bitlen: 8)
tU8 dp_tclKdsCMVariantCoding::u8GetAUXInfo(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[9]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMAntenna1Info':  [10,0] -> [10,3] (Bitlen: 4)
tU8 dp_tclKdsCMVariantCoding::u8GetFMAntenna1Info(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[10]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'FMAntenna2Info':  [10,4] -> [10,7] (Bitlen: 4)
tU8 dp_tclKdsCMVariantCoding::u8GetFMAntenna2Info(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[10]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'DABAntenna1Info':  [11,0] -> [11,3] (Bitlen: 4)
tU8 dp_tclKdsCMVariantCoding::u8GetDABAntenna1Info(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'DABAntenna2Info':  [11,4] -> [11,7] (Bitlen: 4)
tU8 dp_tclKdsCMVariantCoding::u8GetDABAntenna2Info(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'GPSAntenna1Info':  [12,0] -> [12,3] (Bitlen: 4)
tU8 dp_tclKdsCMVariantCoding::u8GetGPSAntenna1Info(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB1ExtendedInfo':  [13,0] -> [13,1] (Bitlen: 2)
tU8 dp_tclKdsCMVariantCoding::u8GetUSB1ExtendedInfo(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB2ExtendedInfo':  [13,2] -> [13,3] (Bitlen: 2)
tU8 dp_tclKdsCMVariantCoding::u8GetUSB2ExtendedInfo(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0xc)>>2);
   }
   return _u8DataStatus;
}

//Key 'FAN':  [14,0] -> [14,1] (Bitlen: 2)
tU8 dp_tclKdsCMVariantCoding::u8GetFAN(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'GNSS':  [14,2] -> [14,3] (Bitlen: 2)
tU8 dp_tclKdsCMVariantCoding::u8GetGNSS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0xc)>>2);
   }
   return _u8DataStatus;
}

//Key 'GYRO':  [14,4] -> [14,5] (Bitlen: 2)
tU8 dp_tclKdsCMVariantCoding::u8GetGYRO(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0x30)>>4);
   }
   return _u8DataStatus;
}

//Key 'ACC':  [14,6] -> [14,7] (Bitlen: 2)
tU8 dp_tclKdsCMVariantCoding::u8GetACC(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0xc0)>>6);
   }
   return _u8DataStatus;
}

//Key 'BDDrive':  [15,0] -> [15,1] (Bitlen: 2)
tU8 dp_tclKdsCMVariantCoding::u8GetBDDrive(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'DRM':  [15,2] -> [15,3] (Bitlen: 2)
tU8 dp_tclKdsCMVariantCoding::u8GetDRM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0xc)>>2);
   }
   return _u8DataStatus;
}

//Key 'RTC':  [15,4] -> [15,7] (Bitlen: 4)
tU8 dp_tclKdsCMVariantCoding::u8GetRTC(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'WIFI':  [16,0] -> [16,1] (Bitlen: 2)
tU8 dp_tclKdsCMVariantCoding::u8GetWIFI(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[16]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'DTV':  [16,2] -> [16,3] (Bitlen: 2)
tU8 dp_tclKdsCMVariantCoding::u8GetDTV(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[16]&0xc)>>2);
   }
   return _u8DataStatus;
}

//Key 'ArkamysClassicSupport':  [17,0] -> [17,0] (Bitlen: 1)
tU8 dp_tclKdsCMVariantCoding::u8GetArkamysClassicSupport(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'ArkamysAuditoriumSupport':  [17,1] -> [17,1] (Bitlen: 1)
tU8 dp_tclKdsCMVariantCoding::u8GetArkamysAuditoriumSupport(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'ESESupport':  [17,2] -> [17,2] (Bitlen: 1)
tU8 dp_tclKdsCMVariantCoding::u8GetESESupport(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'SensorGyroSource':  [18,0] -> [18,7] (Bitlen: 8)
tU8 dp_tclKdsCMVariantCoding::u8GetSensorGyroSource(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SensorACCSource':  [19,0] -> [19,7] (Bitlen: 8)
tU8 dp_tclKdsCMVariantCoding::u8GetSensorACCSource(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[19]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TVAntenna1Info':  [20,0] -> [20,3] (Bitlen: 4)
tU8 dp_tclKdsCMVariantCoding::u8GetTVAntenna1Info(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[20]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'TVAntenna2Info':  [20,4] -> [20,7] (Bitlen: 4)
tU8 dp_tclKdsCMVariantCoding::u8GetTVAntenna2Info(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[20]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'TVAntenna3Info':  [21,0] -> [21,3] (Bitlen: 4)
tU8 dp_tclKdsCMVariantCoding::u8GetTVAntenna3Info(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[21]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'TVAntenna4Info':  [21,4] -> [21,7] (Bitlen: 4)
tU8 dp_tclKdsCMVariantCoding::u8GetTVAntenna4Info(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[21]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'SensorOdoSource':  [22,0] -> [22,7] (Bitlen: 8)
tU8 dp_tclKdsCMVariantCoding::u8GetSensorOdoSource(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[22]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SensorReverseSource':  [23,0] -> [23,7] (Bitlen: 8)
tU8 dp_tclKdsCMVariantCoding::u8GetSensorReverseSource(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[23]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SensorGnssSource':  [24,0] -> [24,7] (Bitlen: 8)
tU8 dp_tclKdsCMVariantCoding::u8GetSensorGnssSource(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[24]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DVDRegionCode':  [25,0] -> [25,3] (Bitlen: 4)
tU8 dp_tclKdsCMVariantCoding::u8GetDVDRegionCode(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[25]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'BDRegionCode':  [25,4] -> [25,5] (Bitlen: 2)
tU8 dp_tclKdsCMVariantCoding::u8GetBDRegionCode(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[25]&0x30)>>4);
   }
   return _u8DataStatus;
}

//Key 'WIFIFCCType':  [25,6] -> [25,6] (Bitlen: 1)
tU8 dp_tclKdsCMVariantCoding::u8GetWIFIFCCType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[25]&0x40)>>6);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  NavDefaultPos  (Key: 0x0D05)          
//##########################################################

dp_tclKdsNavDefaultPos::dp_tclKdsNavDefaultPos() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_NAVDEFAULTPOS_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsNavDefaultPos::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsNavDefaultPos::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x0D05, 0x9, pu8CurPos)) {
      pu8CurPos += 0x9;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsNavDefaultPos::u8GetNavDefaultPos(tU8* pu8Data, tU16 u16BufLen) {
   if (0x9<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_NAVDEFAULTPOS_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsNavDefaultPos::u8DataValid() const {return _u8DataStatus;};
//Key 'Longitude':  [0,0] -> [3,7] (Bitlen: 32)
tU8 dp_tclKdsNavDefaultPos::u8GetLongitude(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Latitude':  [4,0] -> [7,7] (Bitlen: 32)
tU8 dp_tclKdsNavDefaultPos::u8GetLatitude(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[4], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Heading':  [8,0] -> [8,7] (Bitlen: 8)
tU8 dp_tclKdsNavDefaultPos::u8GetHeading(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0xff)>>0);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  NavigationDataCopyProtectionSecurityECCKey  (Key: 0x1214)          
//##########################################################

dp_tclKdsNavigationDataCopyProtectionSecurityECCKey::dp_tclKdsNavigationDataCopyProtectionSecurityECCKey() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_NAVIGATIONDATACOPYPROTECTIONSECURITYECCKEY_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsNavigationDataCopyProtectionSecurityECCKey::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsNavigationDataCopyProtectionSecurityECCKey::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x1214, 0x28, pu8CurPos)) {
      pu8CurPos += 0x28;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsNavigationDataCopyProtectionSecurityECCKey::u8GetNavigationDataCopyProtectionSecurityECCKey(tU8* pu8Data, tU16 u16BufLen) {
   if (0x28<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_NAVIGATIONDATACOPYPROTECTIONSECURITYECCKEY_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsNavigationDataCopyProtectionSecurityECCKey::u8DataValid() const {return _u8DataStatus;};
//Key 'Key':  [0,0] -> [39,7] (Bitlen: 320)
tU8 dp_tclKdsNavigationDataCopyProtectionSecurityECCKey::u8GetKey(tU8* pu8Data, tU16 u16BufLen) {
   if (40<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 40);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  SWUPD_VariantInfo  (Key: 0xA070)          
//##########################################################

dp_tclKdsSWUPD_VariantInfo::dp_tclKdsSWUPD_VariantInfo() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_SWUPD_VARIANTINFO_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsSWUPD_VariantInfo::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsSWUPD_VariantInfo::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA070, 0x10, pu8CurPos)) {
      pu8CurPos += 0x10;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsSWUPD_VariantInfo::u8GetSWUPD_VariantInfo(tU8* pu8Data, tU16 u16BufLen) {
   if (0x10<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_SWUPD_VARIANTINFO_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsSWUPD_VariantInfo::u8DataValid() const {return _u8DataStatus;};
//Key 'ConfigurationVersion':  [0,0] -> [0,7] (Bitlen: 8)
tU8 dp_tclKdsSWUPD_VariantInfo::u8GetConfigurationVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SoftwareVariantTag':  [1,0] -> [4,7] (Bitlen: 32)
tU8 dp_tclKdsSWUPD_VariantInfo::u8GetSoftwareVariantTag(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[1], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  DeviceManager  (Key: 0xA0B0)          
//##########################################################

dp_tclKdsDeviceManager::dp_tclKdsDeviceManager() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_DEVICEMANAGER_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsDeviceManager::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsDeviceManager::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA0B0, 0x5c, pu8CurPos)) {
      pu8CurPos += 0x5c;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsDeviceManager::u8GetDeviceManager(tU8* pu8Data, tU16 u16BufLen) {
   if (0x5c<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_DEVICEMANAGER_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsDeviceManager::u8DataValid() const {return _u8DataStatus;};
//Key 'Tag':  [0,0] -> [7,7] (Bitlen: 64)
tU8 dp_tclKdsDeviceManager::u8GetTag(tU8* pu8Data, tU16 u16BufLen) {
   if (8<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 8);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MajorVersion':  [8,0] -> [8,7] (Bitlen: 8)
tU8 dp_tclKdsDeviceManager::u8GetMajorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinorVersion':  [9,0] -> [10,7] (Bitlen: 16)
tU8 dp_tclKdsDeviceManager::u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[9], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Subvariant':  [11,0] -> [42,7] (Bitlen: 256)
tU8 dp_tclKdsDeviceManager::u8GetSubvariant(tU8* pu8Data, tU16 u16BufLen) {
   if (32<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[11], 32);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'IndividualSettingsFollows':  [43,0] -> [43,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetIndividualSettingsFollows(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[43]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'ChipConnector1':  [45,0] -> [45,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetChipConnector1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[45]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'ChipConnector2':  [45,4] -> [45,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetChipConnector2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[45]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'ChipConnector3':  [44,0] -> [44,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetChipConnector3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[44]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'ChipConnector4':  [44,4] -> [44,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetChipConnector4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[44]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'HwUSB1':  [47,0] -> [47,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetHwUSB1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[47]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'HwUSB2':  [47,4] -> [47,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetHwUSB2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[47]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'HwUSB3':  [46,0] -> [46,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetHwUSB3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[46]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'HwUSB4':  [46,4] -> [46,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetHwUSB4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[46]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'USB1':  [49,0] -> [49,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[49]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB2':  [49,4] -> [49,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[49]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'USB3':  [48,0] -> [48,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[48]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB4':  [48,4] -> [48,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[48]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'ChipConnector1AllowHub':  [51,0] -> [51,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetChipConnector1AllowHub(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[51]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'ChipConnector2AllowHub':  [51,4] -> [51,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetChipConnector2AllowHub(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[51]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'ChipConnector3AllowHub':  [50,0] -> [50,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetChipConnector3AllowHub(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[50]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'ChipConnector4AllowHub':  [50,4] -> [50,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetChipConnector4AllowHub(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[50]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'USB12':  [53,0] -> [53,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB12(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[53]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB22':  [53,4] -> [53,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB22(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[53]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'USB32':  [52,0] -> [52,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB32(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[52]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB42':  [52,4] -> [52,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB42(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[52]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'USB13':  [55,0] -> [55,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB13(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[55]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB23':  [55,4] -> [55,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB23(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[55]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'USB33':  [54,0] -> [54,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB33(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[54]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB43':  [54,4] -> [54,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB43(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[54]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'USB14':  [57,0] -> [57,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB14(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[57]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB24':  [57,4] -> [57,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB24(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[57]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'USB34':  [56,0] -> [56,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB34(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[56]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB44':  [56,4] -> [56,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB44(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[56]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'USB15':  [60,0] -> [60,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB15(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[60]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB25':  [60,4] -> [60,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB25(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[60]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'USB35':  [59,0] -> [59,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB35(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[59]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB45':  [59,4] -> [59,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB45(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[59]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'Monitoring':  [58,0] -> [58,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetMonitoring(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB16':  [62,0] -> [62,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB16(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[62]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB26':  [62,4] -> [62,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB26(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[62]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'USB36':  [61,0] -> [61,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB36(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[61]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB46':  [61,4] -> [61,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB46(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[61]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'USB17':  [64,0] -> [64,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB17(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[64]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB27':  [64,4] -> [64,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB27(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[64]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'USB37':  [63,0] -> [63,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB37(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[63]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'USB47':  [63,4] -> [63,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUSB47(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[63]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'FAT':  [68,0] -> [68,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetFAT(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[68]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'NTFS':  [68,4] -> [68,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetNTFS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[68]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'EXTFAT':  [67,0] -> [67,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetEXTFAT(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[67]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'HFSPlus':  [67,4] -> [67,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetHFSPlus(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[67]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'Ext34FS':  [66,0] -> [66,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetExt34FS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[66]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'ISO9660':  [66,4] -> [66,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetISO9660(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[66]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'UDF':  [65,0] -> [65,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUDF(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[65]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'UnsupportedDeviceType':  [71,0] -> [71,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUnsupportedDeviceType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[71]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'UnsupportedFileSystem':  [71,4] -> [71,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUnsupportedFileSystem(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[71]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'UnsupportedHub':  [70,0] -> [70,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetUnsupportedHub(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[70]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'AllPartitions':  [70,4] -> [70,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetAllPartitions(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[70]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'MSDBiggestPartition':  [69,0] -> [69,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetMSDBiggestPartition(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[69]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'SortAllPartitions':  [69,4] -> [69,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetSortAllPartitions(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[69]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'ExternalSD':  [75,0] -> [75,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetExternalSD(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[75]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'ExternalUSB':  [75,4] -> [75,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetExternalUSB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[75]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'ExternalMTP':  [74,0] -> [74,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetExternalMTP(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[74]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'ExternalIPOD':  [74,4] -> [74,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetExternalIPOD(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[74]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'ExternalIPAD':  [73,0] -> [73,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetExternalIPAD(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[73]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'ExternalIPHONE':  [73,4] -> [73,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetExternalIPHONE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[73]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'InternalCDROM':  [72,0] -> [72,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetInternalCDROM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[72]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'InternalCDDA':  [72,4] -> [72,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetInternalCDDA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[72]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'InternalSDCARD':  [77,0] -> [77,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetInternalSDCARD(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[77]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'ExternalDIGIAUX':  [77,4] -> [77,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetExternalDIGIAUX(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[77]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'ExternalBTA':  [76,0] -> [76,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetExternalBTA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[76]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'ExternalUnsupported':  [76,4] -> [76,7] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetExternalUnsupported(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[76]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'ChargeAppledevs':  [78,0] -> [78,3] (Bitlen: 4)
tU8 dp_tclKdsDeviceManager::u8GetChargeAppledevs(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[78]&0xf)>>0);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  MediaPlayer  (Key: 0xA0C1)          
//##########################################################

dp_tclKdsMediaPlayer::dp_tclKdsMediaPlayer() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_MEDIAPLAYER_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsMediaPlayer::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsMediaPlayer::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA0C1, 0x20, pu8CurPos)) {
      pu8CurPos += 0x20;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsMediaPlayer::u8GetMediaPlayer(tU8* pu8Data, tU16 u16BufLen) {
   if (0x20<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_MEDIAPLAYER_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsMediaPlayer::u8DataValid() const {return _u8DataStatus;};
//Key 'RegistryFile':  [0,0] -> [31,7] (Bitlen: 256)
tU8 dp_tclKdsMediaPlayer::u8GetRegistryFile(tU8* pu8Data, tU16 u16BufLen) {
   if (32<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 32);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  Display  (Key: 0xA0C2)          
//##########################################################

dp_tclKdsDisplay::dp_tclKdsDisplay() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_DISPLAY_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsDisplay::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsDisplay::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA0C2, 0xa0, pu8CurPos)) {
      pu8CurPos += 0xa0;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsDisplay::u8GetDisplay(tU8* pu8Data, tU16 u16BufLen) {
   if (0xa0<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_DISPLAY_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsDisplay::u8DataValid() const {return _u8DataStatus;};
//Key 'DisplayType':  [3,0] -> [3,7] (Bitlen: 8)
tU8 dp_tclKdsDisplay::u8GetDisplayType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisplayOrientation':  [2,0] -> [2,0] (Bitlen: 1)
tU8 dp_tclKdsDisplay::u8GetDisplayOrientation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumOfPixelsX':  [4,0] -> [5,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetNumOfPixelsX(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[4], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'NumOfPixelsY':  [6,0] -> [7,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetNumOfPixelsY(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[6], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PixelSizeX':  [8,0] -> [9,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetPixelSizeX(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[8], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PixelSizeY':  [10,0] -> [11,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetPixelSizeY(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[10], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DisplaySizeX':  [12,0] -> [13,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetDisplaySizeX(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[12], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DisplaySizeY':  [14,0] -> [15,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetDisplaySizeY(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[14], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DisplayTouchTechnology':  [16,0] -> [16,7] (Bitlen: 8)
tU8 dp_tclKdsDisplay::u8GetDisplayTouchTechnology(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[16]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisplayTouchFeature':  [17,0] -> [17,7] (Bitlen: 8)
tU8 dp_tclKdsDisplay::u8GetDisplayTouchFeature(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisplayType2':  [35,0] -> [35,7] (Bitlen: 8)
tU8 dp_tclKdsDisplay::u8GetDisplayType2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[35]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisplayOrientation2':  [34,0] -> [34,0] (Bitlen: 1)
tU8 dp_tclKdsDisplay::u8GetDisplayOrientation2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[34]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumOfPixelsX2':  [36,0] -> [37,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetNumOfPixelsX2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[36], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'NumOfPixelsY2':  [38,0] -> [39,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetNumOfPixelsY2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[38], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PixelSizeX2':  [40,0] -> [41,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetPixelSizeX2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[40], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PixelSizeY2':  [42,0] -> [43,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetPixelSizeY2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[42], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DisplaySizeX2':  [44,0] -> [45,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetDisplaySizeX2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[44], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DisplaySizeY2':  [46,0] -> [47,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetDisplaySizeY2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[46], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DisplayTouchTechnology2':  [48,0] -> [48,7] (Bitlen: 8)
tU8 dp_tclKdsDisplay::u8GetDisplayTouchTechnology2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[48]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisplayTouchFeature2':  [49,0] -> [49,7] (Bitlen: 8)
tU8 dp_tclKdsDisplay::u8GetDisplayTouchFeature2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[49]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisplayType3':  [67,0] -> [67,7] (Bitlen: 8)
tU8 dp_tclKdsDisplay::u8GetDisplayType3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[67]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisplayOrientation3':  [66,0] -> [66,0] (Bitlen: 1)
tU8 dp_tclKdsDisplay::u8GetDisplayOrientation3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[66]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumOfPixelsX3':  [68,0] -> [69,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetNumOfPixelsX3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[68], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'NumOfPixelsY3':  [70,0] -> [71,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetNumOfPixelsY3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[70], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PixelSizeX3':  [72,0] -> [73,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetPixelSizeX3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[72], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PixelSizeY3':  [74,0] -> [75,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetPixelSizeY3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[74], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DisplaySizeX3':  [76,0] -> [77,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetDisplaySizeX3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[76], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DisplaySizeY3':  [78,0] -> [79,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetDisplaySizeY3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[78], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DisplayTouchTechnology3':  [80,0] -> [80,7] (Bitlen: 8)
tU8 dp_tclKdsDisplay::u8GetDisplayTouchTechnology3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[80]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisplayTouchFeature3':  [81,0] -> [81,7] (Bitlen: 8)
tU8 dp_tclKdsDisplay::u8GetDisplayTouchFeature3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[81]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisplayType4':  [99,0] -> [99,7] (Bitlen: 8)
tU8 dp_tclKdsDisplay::u8GetDisplayType4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[99]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisplayOrientation4':  [98,0] -> [98,0] (Bitlen: 1)
tU8 dp_tclKdsDisplay::u8GetDisplayOrientation4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[98]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumOfPixelsX4':  [100,0] -> [101,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetNumOfPixelsX4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[100], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'NumOfPixelsY4':  [102,0] -> [103,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetNumOfPixelsY4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[102], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PixelSizeX4':  [104,0] -> [105,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetPixelSizeX4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[104], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PixelSizeY4':  [106,0] -> [107,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetPixelSizeY4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[106], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DisplaySizeX4':  [108,0] -> [109,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetDisplaySizeX4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[108], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DisplaySizeY4':  [110,0] -> [111,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetDisplaySizeY4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[110], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DisplayTouchTechnology4':  [112,0] -> [112,7] (Bitlen: 8)
tU8 dp_tclKdsDisplay::u8GetDisplayTouchTechnology4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[112]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisplayTouchFeature4':  [113,0] -> [113,7] (Bitlen: 8)
tU8 dp_tclKdsDisplay::u8GetDisplayTouchFeature4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[113]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisplayType5':  [131,0] -> [131,7] (Bitlen: 8)
tU8 dp_tclKdsDisplay::u8GetDisplayType5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[131]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisplayOrientation5':  [130,0] -> [130,0] (Bitlen: 1)
tU8 dp_tclKdsDisplay::u8GetDisplayOrientation5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[130]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumOfPixelsX5':  [132,0] -> [133,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetNumOfPixelsX5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[132], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'NumOfPixelsY5':  [134,0] -> [135,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetNumOfPixelsY5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[134], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PixelSizeX5':  [136,0] -> [137,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetPixelSizeX5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[136], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PixelSizeY5':  [138,0] -> [139,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetPixelSizeY5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[138], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DisplaySizeX5':  [140,0] -> [141,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetDisplaySizeX5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[140], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DisplaySizeY5':  [142,0] -> [143,7] (Bitlen: 16)
tU8 dp_tclKdsDisplay::u8GetDisplaySizeY5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[142], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'DisplayTouchTechnology5':  [144,0] -> [144,7] (Bitlen: 8)
tU8 dp_tclKdsDisplay::u8GetDisplayTouchTechnology5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[144]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DisplayTouchFeature5':  [145,0] -> [145,7] (Bitlen: 8)
tU8 dp_tclKdsDisplay::u8GetDisplayTouchFeature5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[145]&0xff)>>0);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  CameraSystem  (Key: 0xA111)          
//##########################################################

dp_tclKdsCameraSystem::dp_tclKdsCameraSystem() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_CAMERASYSTEM_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsCameraSystem::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsCameraSystem::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA111, 0x58, pu8CurPos)) {
      pu8CurPos += 0x58;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsCameraSystem::u8GetCameraSystem(tU8* pu8Data, tU16 u16BufLen) {
   if (0x58<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_CAMERASYSTEM_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsCameraSystem::u8DataValid() const {return _u8DataStatus;};
//Key 'ConfigStringVersionMajor':  [0,0] -> [0,3] (Bitlen: 4)
tU8 dp_tclKdsCameraSystem::u8GetConfigStringVersionMajor(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'ConfigStringVersionMinor':  [0,4] -> [0,7] (Bitlen: 4)
tU8 dp_tclKdsCameraSystem::u8GetConfigStringVersionMinor(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'VehicleWidth':  [1,0] -> [2,7] (Bitlen: 16)
tU8 dp_tclKdsCameraSystem::u8GetVehicleWidth(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[1], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'WheelBase':  [3,0] -> [4,7] (Bitlen: 16)
tU8 dp_tclKdsCameraSystem::u8GetWheelBase(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[3], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RearOverhang':  [5,0] -> [6,7] (Bitlen: 16)
tU8 dp_tclKdsCameraSystem::u8GetRearOverhang(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[5], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SteerWheelCalibF1':  [7,0] -> [8,7] (Bitlen: 16)
tU8 dp_tclKdsCameraSystem::u8GetSteerWheelCalibF1(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[7], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'SteerWheelCalibF3':  [9,0] -> [10,7] (Bitlen: 16)
tU8 dp_tclKdsCameraSystem::u8GetSteerWheelCalibF3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[9], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxSteerWheelAngle':  [11,0] -> [12,7] (Bitlen: 16)
tU8 dp_tclKdsCameraSystem::u8GetMaxSteerWheelAngle(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[11], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxRearWheelAngle':  [13,0] -> [14,7] (Bitlen: 16)
tU8 dp_tclKdsCameraSystem::u8GetMaxRearWheelAngle(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[13], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RadiusTuningFact':  [15,0] -> [16,7] (Bitlen: 16)
tU8 dp_tclKdsCameraSystem::u8GetRadiusTuningFact(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[15], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'FourWheelSteering':  [17,0] -> [17,0] (Bitlen: 1)
tU8 dp_tclKdsCameraSystem::u8GetFourWheelSteering(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'TireAngleTurnSense':  [17,1] -> [17,1] (Bitlen: 1)
tU8 dp_tclKdsCameraSystem::u8GetTireAngleTurnSense(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'TireAngleReferencePoint':  [17,2] -> [17,3] (Bitlen: 2)
tU8 dp_tclKdsCameraSystem::u8GetTireAngleReferencePoint(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0xc)>>2);
   }
   return _u8DataStatus;
}

//Key 'GuidelineStyle':  [17,4] -> [17,6] (Bitlen: 3)
tU8 dp_tclKdsCameraSystem::u8GetGuidelineStyle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x70)>>4);
   }
   return _u8DataStatus;
}

//Key 'TestConfigOnlyFlag':  [17,7] -> [17,7] (Bitlen: 1)
tU8 dp_tclKdsCameraSystem::u8GetTestConfigOnlyFlag(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'CamXOffset':  [18,0] -> [19,7] (Bitlen: 16)
tU8 dp_tclKdsCameraSystem::u8GetCamXOffset(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[18], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CamYOffset':  [20,0] -> [21,7] (Bitlen: 16)
tU8 dp_tclKdsCameraSystem::u8GetCamYOffset(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[20], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CamZOffset':  [22,0] -> [23,7] (Bitlen: 16)
tU8 dp_tclKdsCameraSystem::u8GetCamZOffset(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[22], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CamYaw':  [24,0] -> [25,7] (Bitlen: 16)
tU8 dp_tclKdsCameraSystem::u8GetCamYaw(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[24], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CamPitch':  [26,0] -> [27,7] (Bitlen: 16)
tU8 dp_tclKdsCameraSystem::u8GetCamPitch(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[26], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CamRoll':  [28,0] -> [29,7] (Bitlen: 16)
tU8 dp_tclKdsCameraSystem::u8GetCamRoll(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[28], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'FrontTireThresh':  [30,0] -> [30,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetFrontTireThresh(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[30]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinFrontTireChange':  [31,0] -> [31,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetMinFrontTireChange(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[31]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RearTireThresh':  [32,0] -> [32,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRearTireThresh(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[32]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinRearTireChange':  [33,0] -> [33,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetMinRearTireChange(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[33]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'GuidelineStartDistance':  [34,0] -> [34,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetGuidelineStartDistance(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[34]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'GuidelineSideMargin':  [35,0] -> [35,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetGuidelineSideMargin(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[35]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RgbColorStaticSideNearR':  [36,0] -> [36,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRgbColorStaticSideNearR(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[36]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RgbColorStaticSideNearG':  [37,0] -> [37,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRgbColorStaticSideNearG(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[37]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RgbColorStaticSideNearB':  [38,0] -> [38,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRgbColorStaticSideNearB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[38]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RgbColorStaticSideMidR':  [39,0] -> [39,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRgbColorStaticSideMidR(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[39]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RgbColorStaticSideMidG':  [40,0] -> [40,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRgbColorStaticSideMidG(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[40]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RgbColorStaticSideMidB':  [41,0] -> [41,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRgbColorStaticSideMidB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[41]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RgbColorStaticSideFarR':  [42,0] -> [42,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRgbColorStaticSideFarR(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RgbColorStaticSideFarG':  [43,0] -> [43,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRgbColorStaticSideFarG(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[43]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RgbColorStaticSideFarB':  [44,0] -> [44,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRgbColorStaticSideFarB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[44]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RgbColorStaticCenterR':  [45,0] -> [45,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRgbColorStaticCenterR(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[45]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RgbColorStaticCenterG':  [46,0] -> [46,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRgbColorStaticCenterG(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[46]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RgbColorStaticCenterB':  [47,0] -> [47,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRgbColorStaticCenterB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[47]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RgbColorDynamicR':  [48,0] -> [48,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRgbColorDynamicR(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[48]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RgbColorDynamicG':  [49,0] -> [49,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRgbColorDynamicG(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[49]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RgbColorDynamicB':  [50,0] -> [50,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRgbColorDynamicB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[50]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LineWidthStaticSideNear':  [51,0] -> [51,3] (Bitlen: 4)
tU8 dp_tclKdsCameraSystem::u8GetLineWidthStaticSideNear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[51]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'LineWidthStaticSideFar':  [51,4] -> [51,7] (Bitlen: 4)
tU8 dp_tclKdsCameraSystem::u8GetLineWidthStaticSideFar(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[51]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'LineWidthDynamicNear':  [52,0] -> [52,3] (Bitlen: 4)
tU8 dp_tclKdsCameraSystem::u8GetLineWidthDynamicNear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[52]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'LineWidthDynamicFar':  [52,4] -> [52,7] (Bitlen: 4)
tU8 dp_tclKdsCameraSystem::u8GetLineWidthDynamicFar(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[52]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'LineWidthStaticCenterNear':  [53,0] -> [53,3] (Bitlen: 4)
tU8 dp_tclKdsCameraSystem::u8GetLineWidthStaticCenterNear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[53]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'LineWidthStaticCenterFar':  [53,4] -> [53,7] (Bitlen: 4)
tU8 dp_tclKdsCameraSystem::u8GetLineWidthStaticCenterFar(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[53]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'StaticLineLengthNear':  [54,0] -> [54,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetStaticLineLengthNear(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[54]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'StaticLineLengthMid':  [55,0] -> [55,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetStaticLineLengthMid(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[55]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'StaticLineLengthFar1':  [56,0] -> [56,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetStaticLineLengthFar1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[56]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'StaticLineLengthFar2':  [57,0] -> [57,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetStaticLineLengthFar2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[57]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'StaticHorizLineLength':  [58,0] -> [58,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetStaticHorizLineLength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LineWidthFactorNearHLine':  [59,0] -> [59,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetLineWidthFactorNearHLine(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[59]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TuningStringVersion':  [60,0] -> [60,3] (Bitlen: 4)
tU8 dp_tclKdsCameraSystem::u8GetTuningStringVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[60]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'TuningMethod':  [60,4] -> [60,7] (Bitlen: 4)
tU8 dp_tclKdsCameraSystem::u8GetTuningMethod(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[60]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'TuningDeltaCamYaw':  [61,0] -> [61,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetTuningDeltaCamYaw(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[61]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TuningDeltaCamPitch':  [62,0] -> [62,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetTuningDeltaCamPitch(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[62]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TuningDeltaCamRoll':  [63,0] -> [63,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetTuningDeltaCamRoll(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[63]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TuningDeltaXNearLeft':  [64,0] -> [64,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetTuningDeltaXNearLeft(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[64]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TuningDeltaYNearLeft':  [65,0] -> [65,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetTuningDeltaYNearLeft(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[65]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TuningDeltaXFarLeft':  [66,0] -> [66,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetTuningDeltaXFarLeft(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[66]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TuningDeltaXNearRight':  [67,0] -> [67,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetTuningDeltaXNearRight(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[67]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TuningDeltaYNearRight':  [68,0] -> [68,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetTuningDeltaYNearRight(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[68]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TuningDeltaXFarRight':  [69,0] -> [69,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetTuningDeltaXFarRight(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[69]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TuningNearLineLengthLeft':  [70,0] -> [70,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetTuningNearLineLengthLeft(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[70]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TuningNearLineLengthRight':  [71,0] -> [71,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetTuningNearLineLengthRight(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[71]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TuningSwaZeroPointOffset':  [72,0] -> [72,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetTuningSwaZeroPointOffset(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[72]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TuningRwaZeroPointOffset':  [73,0] -> [73,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetTuningRwaZeroPointOffset(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[73]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'AnticipatoryLine':  [80,0] -> [80,0] (Bitlen: 1)
tU8 dp_tclKdsCameraSystem::u8GetAnticipatoryLine(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[80]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CameraSystem':  [80,1] -> [80,3] (Bitlen: 3)
tU8 dp_tclKdsCameraSystem::u8GetCameraSystem(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[80]&0xe)>>1);
   }
   return _u8DataStatus;
}

//Key 'CameraConnection':  [80,4] -> [80,6] (Bitlen: 3)
tU8 dp_tclKdsCameraSystem::u8GetCameraConnection(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[80]&0x70)>>4);
   }
   return _u8DataStatus;
}

//Key 'SonarSystemAvailability':  [81,0] -> [81,0] (Bitlen: 1)
tU8 dp_tclKdsCameraSystem::u8GetSonarSystemAvailability(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[81]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'SonarSwitchDisplay':  [81,1] -> [81,1] (Bitlen: 1)
tU8 dp_tclKdsCameraSystem::u8GetSonarSwitchDisplay(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[81]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'SonarMenu':  [81,2] -> [81,4] (Bitlen: 3)
tU8 dp_tclKdsCameraSystem::u8GetSonarMenu(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[81]&0x1c)>>2);
   }
   return _u8DataStatus;
}

//Key 'SonarType':  [81,5] -> [81,6] (Bitlen: 2)
tU8 dp_tclKdsCameraSystem::u8GetSonarType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[81]&0x60)>>5);
   }
   return _u8DataStatus;
}

//Key 'SonarAVM':  [81,7] -> [81,7] (Bitlen: 1)
tU8 dp_tclKdsCameraSystem::u8GetSonarAVM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[81]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'SonarDisplay':  [82,0] -> [82,0] (Bitlen: 1)
tU8 dp_tclKdsCameraSystem::u8GetSonarDisplay(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[82]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'SonarSound':  [82,1] -> [82,1] (Bitlen: 1)
tU8 dp_tclKdsCameraSystem::u8GetSonarSound(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[82]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'SonarFKP':  [82,2] -> [82,2] (Bitlen: 1)
tU8 dp_tclKdsCameraSystem::u8GetSonarFKP(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[82]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'SonarVehicleImage':  [83,0] -> [83,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetSonarVehicleImage(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[83]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CameraBrightnessDay':  [84,0] -> [84,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetCameraBrightnessDay(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[84]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CameraBrightnessNight':  [85,0] -> [85,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetCameraBrightnessNight(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[85]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CameraSteeringMessage':  [86,0] -> [86,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetCameraSteeringMessage(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[86]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RVCLensParameter':  [87,0] -> [87,7] (Bitlen: 8)
tU8 dp_tclKdsCameraSystem::u8GetRVCLensParameter(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[87]&0xff)>>0);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  VehicleInformation  (Key: 0xA112)          
//##########################################################

dp_tclKdsVehicleInformation::dp_tclKdsVehicleInformation() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_VEHICLEINFORMATION_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsVehicleInformation::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsVehicleInformation::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA112, 0x40, pu8CurPos)) {
      pu8CurPos += 0x40;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsVehicleInformation::u8GetVehicleInformation(tU8* pu8Data, tU16 u16BufLen) {
   if (0x40<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_VEHICLEINFORMATION_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsVehicleInformation::u8DataValid() const {return _u8DataStatus;};
//Key 'DestinationRegion1':  [0,3] -> [0,7] (Bitlen: 5)
tU8 dp_tclKdsVehicleInformation::u8GetDestinationRegion1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0xf8)>>3);
   }
   return _u8DataStatus;
}

//Key 'VehicleType':  [1,0] -> [2,7] (Bitlen: 16)
tU8 dp_tclKdsVehicleInformation::u8GetVehicleType(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[1], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'WeightOfVehicle':  [3,0] -> [4,7] (Bitlen: 16)
tU8 dp_tclKdsVehicleInformation::u8GetWeightOfVehicle(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[3], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'WidthOfVehicle':  [5,0] -> [6,7] (Bitlen: 16)
tU8 dp_tclKdsVehicleInformation::u8GetWidthOfVehicle(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[5], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'HeightOfVehicle':  [7,0] -> [8,7] (Bitlen: 16)
tU8 dp_tclKdsVehicleInformation::u8GetHeightOfVehicle(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[7], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LengthOfVehicle':  [9,0] -> [10,7] (Bitlen: 16)
tU8 dp_tclKdsVehicleInformation::u8GetLengthOfVehicle(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[9], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'VehicleBodyShape':  [11,0] -> [11,7] (Bitlen: 8)
tU8 dp_tclKdsVehicleInformation::u8GetVehicleBodyShape(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SteeringPosition':  [12,0] -> [12,0] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetSteeringPosition(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'DrivingType':  [12,1] -> [12,2] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetDrivingType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x6)>>1);
   }
   return _u8DataStatus;
}

//Key 'TPMS':  [12,3] -> [12,4] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetTPMS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x18)>>3);
   }
   return _u8DataStatus;
}

//Key 'FuelType':  [13,0] -> [13,2] (Bitlen: 3)
tU8 dp_tclKdsVehicleInformation::u8GetFuelType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0x7)>>0);
   }
   return _u8DataStatus;
}

//Key 'PetrolType':  [13,3] -> [13,4] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetPetrolType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0x18)>>3);
   }
   return _u8DataStatus;
}

//Key 'PowerPlatform':  [14,0] -> [14,2] (Bitlen: 3)
tU8 dp_tclKdsVehicleInformation::u8GetPowerPlatform(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0x7)>>0);
   }
   return _u8DataStatus;
}

//Key 'VCANSupervision':  [14,3] -> [14,3] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetVCANSupervision(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'TypeOfMeter':  [14,4] -> [14,6] (Bitlen: 3)
tU8 dp_tclKdsVehicleInformation::u8GetTypeOfMeter(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0x70)>>4);
   }
   return _u8DataStatus;
}

//Key 'VCANMCANGatewayForANCASC':  [14,7] -> [14,7] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetVCANMCANGatewayForANCASC(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'VCANDiversity':  [15,0] -> [15,7] (Bitlen: 8)
tU8 dp_tclKdsVehicleInformation::u8GetVCANDiversity(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SteeringSW':  [16,0] -> [16,2] (Bitlen: 3)
tU8 dp_tclKdsVehicleInformation::u8GetSteeringSW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[16]&0x7)>>0);
   }
   return _u8DataStatus;
}

//Key 'IntelligentSpeedAssist':  [16,3] -> [16,3] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetIntelligentSpeedAssist(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[16]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'IPAHFP':  [16,4] -> [16,6] (Bitlen: 3)
tU8 dp_tclKdsVehicleInformation::u8GetIPAHFP(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[16]&0x70)>>4);
   }
   return _u8DataStatus;
}

//Key 'CANActivationC1A':  [16,7] -> [16,7] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetCANActivationC1A(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[16]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'RCSRearArmrestSwitch':  [17,0] -> [17,2] (Bitlen: 3)
tU8 dp_tclKdsVehicleInformation::u8GetRCSRearArmrestSwitch(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x7)>>0);
   }
   return _u8DataStatus;
}

//Key 'Microphone':  [17,3] -> [17,5] (Bitlen: 3)
tU8 dp_tclKdsVehicleInformation::u8GetMicrophone(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x38)>>3);
   }
   return _u8DataStatus;
}

//Key 'TrafficSignRecognition':  [17,6] -> [17,6] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetTrafficSignRecognition(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'ITCommanderCentralSwitch':  [18,0] -> [18,2] (Bitlen: 3)
tU8 dp_tclKdsVehicleInformation::u8GetITCommanderCentralSwitch(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0x7)>>0);
   }
   return _u8DataStatus;
}

//Key 'ExternalCDDrive':  [18,5] -> [18,6] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetExternalCDDrive(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0x60)>>5);
   }
   return _u8DataStatus;
}

//Key 'ETC20':  [18,7] -> [18,7] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetETC20(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'MediaPlayerExternalBDDVDCDPlayer':  [19,0] -> [19,1] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetMediaPlayerExternalBDDVDCDPlayer(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[19]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'RSE':  [19,2] -> [19,3] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetRSE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[19]&0xc)>>2);
   }
   return _u8DataStatus;
}

//Key 'TCU':  [19,4] -> [19,6] (Bitlen: 3)
tU8 dp_tclKdsVehicleInformation::u8GetTCU(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[19]&0x70)>>4);
   }
   return _u8DataStatus;
}

//Key 'EVHVAC':  [20,0] -> [20,1] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetEVHVAC(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[20]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'HEVShapeOfBody':  [20,2] -> [20,4] (Bitlen: 3)
tU8 dp_tclKdsVehicleInformation::u8GetHEVShapeOfBody(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[20]&0x1c)>>2);
   }
   return _u8DataStatus;
}

//Key 'CPWakeUpStrategy':  [20,5] -> [20,6] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetCPWakeUpStrategy(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[20]&0x60)>>5);
   }
   return _u8DataStatus;
}

//Key 'MotorEfficiency':  [21,0] -> [22,7] (Bitlen: 16)
tU8 dp_tclKdsVehicleInformation::u8GetMotorEfficiency(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[21], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'ReductionGearEfficiency':  [23,0] -> [24,7] (Bitlen: 16)
tU8 dp_tclKdsVehicleInformation::u8GetReductionGearEfficiency(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[23], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CdValue':  [25,0] -> [26,7] (Bitlen: 16)
tU8 dp_tclKdsVehicleInformation::u8GetCdValue(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[25], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'ChargingCableConnector':  [27,0] -> [27,7] (Bitlen: 8)
tU8 dp_tclKdsVehicleInformation::u8GetChargingCableConnector(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[27]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'ChargingCableSpotSidePlug':  [28,0] -> [28,7] (Bitlen: 8)
tU8 dp_tclKdsVehicleInformation::u8GetChargingCableSpotSidePlug(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[28]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'VehicleInlet':  [29,0] -> [29,7] (Bitlen: 8)
tU8 dp_tclKdsVehicleInformation::u8GetVehicleInlet(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[29]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CNFCHGFACTYPE':  [30,0] -> [30,3] (Bitlen: 4)
tU8 dp_tclKdsVehicleInformation::u8GetCNFCHGFACTYPE(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[30]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxMotorPowerOutput':  [30,4] -> [30,5] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetMaxMotorPowerOutput(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[30]&0x30)>>4);
   }
   return _u8DataStatus;
}

//Key 'MaxMotorRegenerativePower':  [30,6] -> [30,7] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetMaxMotorRegenerativePower(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[30]&0xc0)>>6);
   }
   return _u8DataStatus;
}

//Key 'BlowerReductionRequest':  [31,0] -> [31,0] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetBlowerReductionRequest(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[31]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'EthernetInterface':  [32,0] -> [32,0] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetEthernetInterface(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[32]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'RADIOSATELLITESWITCH':  [32,3] -> [32,5] (Bitlen: 3)
tU8 dp_tclKdsVehicleInformation::u8GetRADIOSATELLITESWITCH(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[32]&0x38)>>3);
   }
   return _u8DataStatus;
}

//Key 'HUD':  [32,6] -> [32,6] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetHUD(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[32]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'InductiveCharger':  [32,7] -> [32,7] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetInductiveCharger(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[32]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'FuelConsumptionInfo':  [33,0] -> [33,1] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetFuelConsumptionInfo(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[33]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'HUDSetting':  [33,2] -> [33,2] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetHUDSetting(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[33]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'NaviAvailableSettingHUD':  [33,3] -> [33,3] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetNaviAvailableSettingHUD(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[33]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'LearningParkFunction':  [33,4] -> [33,5] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetLearningParkFunction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[33]&0x30)>>4);
   }
   return _u8DataStatus;
}

//Key 'RemoteParkFunction':  [33,6] -> [33,7] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetRemoteParkFunction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[33]&0xc0)>>6);
   }
   return _u8DataStatus;
}

//Key 'TransmissionType':  [34,0] -> [34,1] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetTransmissionType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[34]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'MeterSeetingIcon':  [34,2] -> [34,2] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetMeterSeetingIcon(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[34]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'SendingCountryInformation':  [34,3] -> [34,3] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetSendingCountryInformation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[34]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'SmartCharging':  [34,4] -> [34,4] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetSmartCharging(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[34]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'ChargingCableGrouping':  [35,0] -> [35,7] (Bitlen: 8)
tU8 dp_tclKdsVehicleInformation::u8GetChargingCableGrouping(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[35]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'UnballastWarningTime':  [36,0] -> [36,7] (Bitlen: 8)
tU8 dp_tclKdsVehicleInformation::u8GetUnballastWarningTime(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[36]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinTimeBeforeUnballast':  [37,0] -> [37,5] (Bitlen: 6)
tU8 dp_tclKdsVehicleInformation::u8GetMinTimeBeforeUnballast(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[37]&0x3f)>>0);
   }
   return _u8DataStatus;
}

//Key 'UnballastCounter':  [37,6] -> [37,6] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetUnballastCounter(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[37]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'ADFunction':  [38,0] -> [38,1] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetADFunction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[38]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'CameraPictureColor':  [38,2] -> [38,6] (Bitlen: 5)
tU8 dp_tclKdsVehicleInformation::u8GetCameraPictureColor(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[38]&0x7c)>>2);
   }
   return _u8DataStatus;
}

//Key 'DynamicLength':  [39,0] -> [39,7] (Bitlen: 8)
tU8 dp_tclKdsVehicleInformation::u8GetDynamicLength(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[39]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'TuningDeltaXFarLeftDyn':  [40,0] -> [40,6] (Bitlen: 7)
tU8 dp_tclKdsVehicleInformation::u8GetTuningDeltaXFarLeftDyn(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[40]&0x7f)>>0);
   }
   return _u8DataStatus;
}

//Key 'WarningTextPos':  [40,7] -> [40,7] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetWarningTextPos(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[40]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'TuningDeltaXFarRightDyn':  [41,0] -> [41,6] (Bitlen: 7)
tU8 dp_tclKdsVehicleInformation::u8GetTuningDeltaXFarRightDyn(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[41]&0x7f)>>0);
   }
   return _u8DataStatus;
}

//Key 'RearCameraActivation':  [41,7] -> [41,7] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetRearCameraActivation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[41]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'CropUp':  [42,0] -> [42,6] (Bitlen: 7)
tU8 dp_tclKdsVehicleInformation::u8GetCropUp(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0x7f)>>0);
   }
   return _u8DataStatus;
}

//Key 'AdditionalRVCConfigurationItems':  [42,7] -> [42,7] (Bitlen: 1)
tU8 dp_tclKdsVehicleInformation::u8GetAdditionalRVCConfigurationItems(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'CropDown':  [43,0] -> [43,6] (Bitlen: 7)
tU8 dp_tclKdsVehicleInformation::u8GetCropDown(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[43]&0x7f)>>0);
   }
   return _u8DataStatus;
}

//Key 'CropLeft':  [44,0] -> [44,6] (Bitlen: 7)
tU8 dp_tclKdsVehicleInformation::u8GetCropLeft(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[44]&0x7f)>>0);
   }
   return _u8DataStatus;
}

//Key 'CropRight':  [45,0] -> [45,6] (Bitlen: 7)
tU8 dp_tclKdsVehicleInformation::u8GetCropRight(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[45]&0x7f)>>0);
   }
   return _u8DataStatus;
}

//Key 'ReverseGearDebouncing':  [46,0] -> [46,3] (Bitlen: 4)
tU8 dp_tclKdsVehicleInformation::u8GetReverseGearDebouncing(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[46]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'CameraPictureHoldingTime':  [46,5] -> [46,7] (Bitlen: 3)
tU8 dp_tclKdsVehicleInformation::u8GetCameraPictureHoldingTime(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[46]&0xe0)>>5);
   }
   return _u8DataStatus;
}

//Key 'CameraPictureContrast':  [47,0] -> [47,4] (Bitlen: 5)
tU8 dp_tclKdsVehicleInformation::u8GetCameraPictureContrast(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[47]&0x1f)>>0);
   }
   return _u8DataStatus;
}

//Key 'CameraRearTrunkBehaviour':  [47,5] -> [47,7] (Bitlen: 3)
tU8 dp_tclKdsVehicleInformation::u8GetCameraRearTrunkBehaviour(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[47]&0xe0)>>5);
   }
   return _u8DataStatus;
}

//Key 'CameraPictureTint':  [48,0] -> [48,4] (Bitlen: 5)
tU8 dp_tclKdsVehicleInformation::u8GetCameraPictureTint(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[48]&0x1f)>>0);
   }
   return _u8DataStatus;
}

//Key 'VehicleSpeedTooHigh':  [49,0] -> [49,4] (Bitlen: 5)
tU8 dp_tclKdsVehicleInformation::u8GetVehicleSpeedTooHigh(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[49]&0x1f)>>0);
   }
   return _u8DataStatus;
}

//Key 'CameraImageMirror':  [49,5] -> [49,6] (Bitlen: 2)
tU8 dp_tclKdsVehicleInformation::u8GetCameraImageMirror(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[49]&0x60)>>5);
   }
   return _u8DataStatus;
}

//Key 'CameraPictureBlackLevelDay':  [50,0] -> [50,4] (Bitlen: 5)
tU8 dp_tclKdsVehicleInformation::u8GetCameraPictureBlackLevelDay(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[50]&0x1f)>>0);
   }
   return _u8DataStatus;
}

//Key 'CameraPictureBlackLevelNight':  [51,0] -> [51,4] (Bitlen: 5)
tU8 dp_tclKdsVehicleInformation::u8GetCameraPictureBlackLevelNight(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[51]&0x1f)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeatGuidanceDR':  [52,0] -> [52,2] (Bitlen: 3)
tU8 dp_tclKdsVehicleInformation::u8GetSeatGuidanceDR(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[52]&0x7)>>0);
   }
   return _u8DataStatus;
}

//Key 'SeatGuidancePS':  [52,3] -> [52,5] (Bitlen: 3)
tU8 dp_tclKdsVehicleInformation::u8GetSeatGuidancePS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[52]&0x38)>>3);
   }
   return _u8DataStatus;
}

//Key 'TrailerType':  [53,0] -> [53,3] (Bitlen: 4)
tU8 dp_tclKdsVehicleInformation::u8GetTrailerType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[53]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'NumberOfAxes':  [53,4] -> [53,7] (Bitlen: 4)
tU8 dp_tclKdsVehicleInformation::u8GetNumberOfAxes(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[53]&0xf0)>>4);
   }
   return _u8DataStatus;
}

//Key 'MaximumLoadPerAxle':  [54,0] -> [55,7] (Bitlen: 16)
tU8 dp_tclKdsVehicleInformation::u8GetMaximumLoadPerAxle(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[54], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  SoundVolumeConfig  (Key: 0xA12B)          
//##########################################################

dp_tclKdsSoundVolumeConfig::dp_tclKdsSoundVolumeConfig() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_SOUNDVOLUMECONFIG_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsSoundVolumeConfig::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsSoundVolumeConfig::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA12B, 0x11, pu8CurPos)) {
      pu8CurPos += 0x11;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsSoundVolumeConfig::u8GetSoundVolumeConfig(tU8* pu8Data, tU16 u16BufLen) {
   if (0x11<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_SOUNDVOLUMECONFIG_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsSoundVolumeConfig::u8DataValid() const {return _u8DataStatus;};
//Key 'CptMinVolMinVal':  [0,0] -> [0,5] (Bitlen: 6)
tU8 dp_tclKdsSoundVolumeConfig::u8GetCptMinVolMinVal(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x3f)>>0);
   }
   return _u8DataStatus;
}

//Key 'CptMinVolMaxVal':  [1,0] -> [1,5] (Bitlen: 6)
tU8 dp_tclKdsSoundVolumeConfig::u8GetCptMinVolMaxVal(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x3f)>>0);
   }
   return _u8DataStatus;
}

//Key 'CptMaxVolMinVal':  [2,0] -> [2,5] (Bitlen: 6)
tU8 dp_tclKdsSoundVolumeConfig::u8GetCptMaxVolMinVal(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x3f)>>0);
   }
   return _u8DataStatus;
}

//Key 'CptMaxVolMaxVal':  [3,0] -> [3,5] (Bitlen: 6)
tU8 dp_tclKdsSoundVolumeConfig::u8GetCptMaxVolMaxVal(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x3f)>>0);
   }
   return _u8DataStatus;
}

//Key 'CabMinVolMinVal':  [4,0] -> [4,5] (Bitlen: 6)
tU8 dp_tclKdsSoundVolumeConfig::u8GetCabMinVolMinVal(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0x3f)>>0);
   }
   return _u8DataStatus;
}

//Key 'CabMinVolMaxVal':  [5,0] -> [5,5] (Bitlen: 6)
tU8 dp_tclKdsSoundVolumeConfig::u8GetCabMinVolMaxVal(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0x3f)>>0);
   }
   return _u8DataStatus;
}

//Key 'CabMaxVolMinVal':  [6,0] -> [6,5] (Bitlen: 6)
tU8 dp_tclKdsSoundVolumeConfig::u8GetCabMaxVolMinVal(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x3f)>>0);
   }
   return _u8DataStatus;
}

//Key 'CabMaxVolMaxVal':  [7,0] -> [7,5] (Bitlen: 6)
tU8 dp_tclKdsSoundVolumeConfig::u8GetCabMaxVolMaxVal(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[7]&0x3f)>>0);
   }
   return _u8DataStatus;
}

//Key 'Loudness':  [12,2] -> [12,2] (Bitlen: 1)
tU8 dp_tclKdsSoundVolumeConfig::u8GetLoudness(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'BeepClicLevel':  [12,3] -> [12,7] (Bitlen: 5)
tU8 dp_tclKdsSoundVolumeConfig::u8GetBeepClicLevel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0xf8)>>3);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  HMIConfig  (Key: 0xA12A)          
//##########################################################

dp_tclKdsHMIConfig::dp_tclKdsHMIConfig() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_HMICONFIG_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsHMIConfig::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsHMIConfig::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA12A, 0x19, pu8CurPos)) {
      pu8CurPos += 0x19;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsHMIConfig::u8GetHMIConfig(tU8* pu8Data, tU16 u16BufLen) {
   if (0x19<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_HMICONFIG_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsHMIConfig::u8DataValid() const {return _u8DataStatus;};
//Key 'CFGClusterStyle':  [0,0] -> [0,0] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGClusterStyle(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFGColorSelection':  [0,1] -> [0,1] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGColorSelection(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'CFGDualzoneMonozone':  [0,2] -> [0,2] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGDualzoneMonozone(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CFGRearClim':  [0,3] -> [0,3] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGRearClim(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CFGHeatedWindscreen':  [0,4] -> [0,4] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGHeatedWindscreen(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'AIRFRESHNERCF':  [0,5] -> [0,5] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetAIRFRESHNERCF(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'CFGSailingSettings':  [0,6] -> [0,6] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGSailingSettings(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CFGDSISettings':  [0,7] -> [0,7] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGDSISettings(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'CFGSynchronize':  [1,0] -> [1,0] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGSynchronize(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFGRVCFixedGuidelines':  [1,1] -> [1,1] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGRVCFixedGuidelines(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'CFGRVCDynamicGuidelines':  [1,2] -> [1,2] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGRVCDynamicGuidelines(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CFGHMD':  [1,3] -> [1,3] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGHMD(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CFGHeatedVentilatedSeats':  [1,4] -> [1,5] (Bitlen: 2)
tU8 dp_tclKdsHMIConfig::u8GetCFGHeatedVentilatedSeats(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x30)>>4);
   }
   return _u8DataStatus;
}

//Key 'CFGSeatMassage':  [1,6] -> [1,7] (Bitlen: 2)
tU8 dp_tclKdsHMIConfig::u8GetCFGSeatMassage(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0xc0)>>6);
   }
   return _u8DataStatus;
}

//Key 'CFGMagicFolding':  [2,0] -> [2,2] (Bitlen: 3)
tU8 dp_tclKdsHMIConfig::u8GetCFGMagicFolding(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x7)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFGMemoSeat':  [2,3] -> [2,3] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGMemoSeat(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CFGFLOWSEDACTIVATION':  [2,4] -> [2,4] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGFLOWSEDACTIVATION(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'CFGIonizer':  [2,5] -> [2,5] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGIonizer(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'CFGFragance':  [2,6] -> [2,6] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGFragance(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CFGAQSHistogram':  [2,7] -> [2,7] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGAQSHistogram(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'CFGAmbientLighting':  [3,0] -> [3,0] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGAmbientLighting(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFGRemoteEngineStart':  [3,1] -> [3,2] (Bitlen: 2)
tU8 dp_tclKdsHMIConfig::u8GetCFGRemoteEngineStart(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x6)>>1);
   }
   return _u8DataStatus;
}

//Key 'CFGDimmingStrategy':  [3,3] -> [3,3] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGDimmingStrategy(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CFGOffBoardConsulting':  [3,4] -> [3,4] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGOffBoardConsulting(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'CFGEcoMode':  [3,5] -> [3,5] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGEcoMode(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'CFGSS':  [3,6] -> [3,6] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGSS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CFGVehicleMode':  [4,0] -> [4,2] (Bitlen: 3)
tU8 dp_tclKdsHMIConfig::u8GetCFGVehicleMode(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0x7)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFGDRIVECO':  [4,3] -> [4,3] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGDRIVECO(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CfMPURearWiper':  [4,4] -> [4,4] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPURearWiper(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'CfMPUAutoFrontWiper':  [4,5] -> [4,5] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUAutoFrontWiper(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'CfMPUFlashersVolumeSelection':  [4,6] -> [4,6] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUFlashersVolumeSelection(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[4]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CfMPUMotorwayFlashersNb':  [5,0] -> [5,0] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUMotorwayFlashersNb(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CfMPUFRWiperDrop':  [5,1] -> [5,1] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUFRWiperDrop(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'CfMPUSingleDoorOpening':  [5,2] -> [5,2] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUSingleDoorOpening(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CfMPUAutoLockUp':  [5,3] -> [5,3] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUAutoLockUp(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CfMPUHandFreeLockUnlock':  [5,4] -> [5,4] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUHandFreeLockUnlock(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'CfMPUWACSilentMode':  [5,5] -> [5,5] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUWACSilentMode(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'CfMPUWACAPRUN':  [5,6] -> [5,6] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUWACAPRUN(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CfMPUMirrorsFolding':  [5,7] -> [5,7] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUMirrorsFolding(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'CfMPUAutoRelock':  [6,0] -> [6,0] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUAutoRelock(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CfMPUAutoFMH':  [6,1] -> [6,1] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUAutoFMH(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'CfMPUWGS':  [6,2] -> [6,2] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUWGS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CfMPUDrivingSide':  [6,3] -> [6,3] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUDrivingSide(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CfMPUAFS':  [6,4] -> [6,4] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUAFS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'CfMPUADB':  [6,5] -> [6,5] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUADB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'CfMPUAHLFunction':  [6,6] -> [6,6] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUAHLFunction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CfMPUALSThreshold':  [6,7] -> [6,7] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCfMPUALSThreshold(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'TPMSMMICF':  [7,0] -> [7,1] (Bitlen: 2)
tU8 dp_tclKdsHMIConfig::u8GetTPMSMMICF(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[7]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFG4WDHMI':  [7,2] -> [7,3] (Bitlen: 2)
tU8 dp_tclKdsHMIConfig::u8GetCFG4WDHMI(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[7]&0xc)>>2);
   }
   return _u8DataStatus;
}

//Key 'ADASSR':  [7,4] -> [7,4] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetADASSR(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[7]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'ADASUTA':  [7,5] -> [7,5] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetADASUTA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[7]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'ADASDW':  [7,6] -> [7,6] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetADASDW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[7]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'ADASDangerousArea':  [7,7] -> [7,7] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetADASDangerousArea(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[7]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'ADASAEB':  [8,0] -> [8,1] (Bitlen: 2)
tU8 dp_tclKdsHMIConfig::u8GetADASAEB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADASOSP':  [8,2] -> [8,2] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetADASOSP(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'ADASLKA':  [8,3] -> [8,3] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetADASLKA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'ADASLDW':  [8,4] -> [8,5] (Bitlen: 2)
tU8 dp_tclKdsHMIConfig::u8GetADASLDW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0x30)>>4);
   }
   return _u8DataStatus;
}

//Key 'ADASBSW':  [8,6] -> [8,6] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetADASBSW(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'ADASPSM':  [8,7] -> [8,7] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetADASPSM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'CFGADASAPA':  [9,0] -> [9,1] (Bitlen: 2)
tU8 dp_tclKdsHMIConfig::u8GetCFGADASAPA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[9]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'ADASFKP':  [9,2] -> [9,2] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetADASFKP(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[9]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'ADASUPAAudio':  [9,3] -> [9,4] (Bitlen: 2)
tU8 dp_tclKdsHMIConfig::u8GetADASUPAAudio(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[9]&0x18)>>3);
   }
   return _u8DataStatus;
}

//Key 'DisplayFormat':  [9,5] -> [9,5] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetDisplayFormat(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[9]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'ADASUPAVisual':  [9,6] -> [9,7] (Bitlen: 2)
tU8 dp_tclKdsHMIConfig::u8GetADASUPAVisual(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[9]&0xc0)>>6);
   }
   return _u8DataStatus;
}

//Key 'CFGAM':  [10,0] -> [10,7] (Bitlen: 8)
tU8 dp_tclKdsHMIConfig::u8GetCFGAM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[10]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'VolumePopupPosition':  [11,0] -> [11,0] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetVolumePopupPosition(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFGAUDIOSpeakers':  [11,1] -> [11,1] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGAUDIOSpeakers(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'TyrePressureUnitCF':  [11,2] -> [11,2] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetTyrePressureUnitCF(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CFGSMARTINTLIGHT':  [11,3] -> [11,3] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGSMARTINTLIGHT(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CFGHMIDATEDISPLAY':  [11,4] -> [11,5] (Bitlen: 2)
tU8 dp_tclKdsHMIConfig::u8GetCFGHMIDATEDISPLAY(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x30)>>4);
   }
   return _u8DataStatus;
}

//Key 'CFGSPVR':  [11,6] -> [11,6] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGSPVR(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CFGAM2':  [11,7] -> [11,7] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGAM2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[11]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'CFGForgotPhonePopup':  [12,0] -> [12,0] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGForgotPhonePopup(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFGDRECOSALING':  [12,1] -> [12,1] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGDRECOSALING(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'CFGDRECOSTOPANDSTART':  [12,2] -> [12,2] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGDRECOSTOPANDSTART(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CFGDRECOECOMode':  [12,3] -> [12,3] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGDRECOECOMode(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CFGDRECOTTS':  [12,4] -> [12,4] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGDRECOTTS(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'CFGClim':  [12,5] -> [12,5] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGClim(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'CFGSeatCourtesy':  [12,6] -> [12,6] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGSeatCourtesy(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'REMOTESTART2HOURSCF':  [12,7] -> [12,7] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetREMOTESTART2HOURSCF(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[12]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'CFGADASUPAMute':  [13,0] -> [13,7] (Bitlen: 8)
tU8 dp_tclKdsHMIConfig::u8GetCFGADASUPAMute(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[13]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFGEasyAccess':  [14,0] -> [14,1] (Bitlen: 2)
tU8 dp_tclKdsHMIConfig::u8GetCFGEasyAccess(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0x3)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFGTIMEAUTO':  [14,2] -> [14,2] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGTIMEAUTO(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'TPMSAutolocCF':  [14,3] -> [14,3] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetTPMSAutolocCF(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CFGHome':  [14,4] -> [14,5] (Bitlen: 2)
tU8 dp_tclKdsHMIConfig::u8GetCFGHome(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0x30)>>4);
   }
   return _u8DataStatus;
}

//Key 'CFGEditHome':  [14,6] -> [14,6] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGEditHome(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CFGFavorite':  [14,7] -> [14,7] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGFavorite(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'CFGEnergyInfo':  [15,0] -> [15,0] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGEnergyInfo(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFGGSICONTACTBREAKERBUZZERRST':  [15,1] -> [15,1] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGGSICONTACTBREAKERBUZZERRST(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'CFGDRECODistanceWoAccel':  [15,2] -> [15,2] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGDRECODistanceWoAccel(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CFGDRECORangeIncrease':  [15,3] -> [15,3] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGDRECORangeIncrease(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CFGDRECOCMI':  [15,4] -> [15,4] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGDRECOCMI(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'CFGDRECOEcoNav':  [15,5] -> [15,5] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGDRECOEcoNav(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'CFGDRECOResetType':  [15,6] -> [15,6] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGDRECOResetType(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CFGDRECODistanceWoCons':  [15,7] -> [15,7] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGDRECODistanceWoCons(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'CFGELFNOTIFNUMBER':  [16,0] -> [16,7] (Bitlen: 8)
tU8 dp_tclKdsHMIConfig::u8GetCFGELFNOTIFNUMBER(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[16]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFGALDynamicPattern':  [17,0] -> [17,0] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALDynamicPattern(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFGALAREA1':  [17,1] -> [17,1] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALAREA1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'CFGALAREA2':  [17,2] -> [17,2] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALAREA2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CFGALAREA3':  [17,3] -> [17,3] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALAREA3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CFGALCOL1':  [17,4] -> [17,4] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALCOL1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'CFGALCOL2':  [17,5] -> [17,5] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALCOL2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'CFGALCOL3':  [17,6] -> [17,6] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALCOL3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CFGALCOL4':  [17,7] -> [17,7] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALCOL4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[17]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'CFGALCOL5':  [18,0] -> [18,0] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALCOL5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFGALCOL6':  [18,1] -> [18,1] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALCOL6(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'CFGALCOL7':  [18,2] -> [18,2] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALCOL7(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CFGALCOL8':  [18,3] -> [18,3] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALCOL8(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CFGALCOL9':  [18,4] -> [18,4] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALCOL9(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'CFGALCOL10':  [18,5] -> [18,5] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALCOL10(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'CFGALCOL11':  [18,6] -> [18,6] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALCOL11(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CFGALCOL12':  [18,7] -> [18,7] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALCOL12(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'CFGALCOL13':  [19,0] -> [19,0] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALCOL13(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[19]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFGALCOL14':  [19,1] -> [19,1] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALCOL14(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[19]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'CFGALCOL15':  [19,2] -> [19,2] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGALCOL15(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[19]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'CFGFLOWPHEVACTIVATION':  [19,3] -> [19,3] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGFLOWPHEVACTIVATION(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[19]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CFGUserProfile':  [19,4] -> [19,5] (Bitlen: 2)
tU8 dp_tclKdsHMIConfig::u8GetCFGUserProfile(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[19]&0x30)>>4);
   }
   return _u8DataStatus;
}

//Key 'CFGAQSClim':  [19,6] -> [19,6] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGAQSClim(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[19]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'CFGDualSyncClim':  [19,7] -> [19,7] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGDualSyncClim(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[19]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'WelcomeSequence':  [20,0] -> [20,3] (Bitlen: 4)
tU8 dp_tclKdsHMIConfig::u8GetWelcomeSequence(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[20]&0xf)>>0);
   }
   return _u8DataStatus;
}

//Key 'CFGHeatedSteeringWheelClim':  [20,4] -> [20,4] (Bitlen: 1)
tU8 dp_tclKdsHMIConfig::u8GetCFGHeatedSteeringWheelClim(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[20]&0x10)>>4);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  ConfigPartNumber  (Key: 0xA116)          
//##########################################################

dp_tclKdsConfigPartNumber::dp_tclKdsConfigPartNumber() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_CONFIGPARTNUMBER_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsConfigPartNumber::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsConfigPartNumber::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA116, 0xa, pu8CurPos)) {
      pu8CurPos += 0xa;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsConfigPartNumber::u8GetConfigPartNumber(tU8* pu8Data, tU16 u16BufLen) {
   if (0xa<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_CONFIGPARTNUMBER_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsConfigPartNumber::u8DataValid() const {return _u8DataStatus;};
//Key 'DataRecord':  [0,0] -> [9,7] (Bitlen: 80)
tU8 dp_tclKdsConfigPartNumber::u8GetDataRecord(tU8* pu8Data, tU16 u16BufLen) {
   if (10<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 10);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  CustomerECUPartNumber  (Key: 0xA124)          
//##########################################################

dp_tclKdsCustomerECUPartNumber::dp_tclKdsCustomerECUPartNumber() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_CUSTOMERECUPARTNUMBER_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsCustomerECUPartNumber::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsCustomerECUPartNumber::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA124, 0xa, pu8CurPos)) {
      pu8CurPos += 0xa;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsCustomerECUPartNumber::u8GetCustomerECUPartNumber(tU8* pu8Data, tU16 u16BufLen) {
   if (0xa<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_CUSTOMERECUPARTNUMBER_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsCustomerECUPartNumber::u8DataValid() const {return _u8DataStatus;};
//Key 'ECUPartNumber':  [0,0] -> [9,7] (Bitlen: 80)
tU8 dp_tclKdsCustomerECUPartNumber::u8GetECUPartNumber(tU8* pu8Data, tU16 u16BufLen) {
   if (10<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 10);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  EarlyConfig_Display  (Key: 0xA090)          
//##########################################################

dp_tclKdsEarlyConfig_Display::dp_tclKdsEarlyConfig_Display() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_EARLYCONFIG_DISPLAY_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsEarlyConfig_Display::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsEarlyConfig_Display::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA090, 0x28, pu8CurPos)) {
      pu8CurPos += 0x28;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsEarlyConfig_Display::u8GetEarlyConfig_Display(tU8* pu8Data, tU16 u16BufLen) {
   if (0x28<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_EARLYCONFIG_DISPLAY_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsEarlyConfig_Display::u8DataValid() const {return _u8DataStatus;};
//Key 'Resolution':  [0,0] -> [31,7] (Bitlen: 256)
tU8 dp_tclKdsEarlyConfig_Display::u8GetResolution(tU8* pu8Data, tU16 u16BufLen) {
   if (32<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 32);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'BackwardCompatibility':  [32,0] -> [35,7] (Bitlen: 32)
tU8 dp_tclKdsEarlyConfig_Display::u8GetBackwardCompatibility(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[32], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'LowFrequency':  [36,0] -> [39,7] (Bitlen: 32)
tU8 dp_tclKdsEarlyConfig_Display::u8GetLowFrequency(tU8* pu8Data, tU16 u16BufLen) {
   if (4<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[36], 4);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  EarlyConfig2Displays  (Key: 0xA092)          
//##########################################################

dp_tclKdsEarlyConfig2Displays::dp_tclKdsEarlyConfig2Displays() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsEarlyConfig2Displays::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsEarlyConfig2Displays::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA092, 0x40, pu8CurPos)) {
      pu8CurPos += 0x40;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsEarlyConfig2Displays::u8GetEarlyConfig2Displays(tU8* pu8Data, tU16 u16BufLen) {
   if (0x40<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_EARLYCONFIG2DISPLAYS_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsEarlyConfig2Displays::u8DataValid() const {return _u8DataStatus;};
//Key 'TrTimingLVDS1':  [0,0] -> [31,7] (Bitlen: 256)
tU8 dp_tclKdsEarlyConfig2Displays::u8GetTrTimingLVDS1(tU8* pu8Data, tU16 u16BufLen) {
   if (32<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 32);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'TrTimingLVDS2':  [32,0] -> [63,7] (Bitlen: 256)
tU8 dp_tclKdsEarlyConfig2Displays::u8GetTrTimingLVDS2(tU8* pu8Data, tU16 u16BufLen) {
   if (32<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[32], 32);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  EarlyConfig_Touch  (Key: 0xA091)          
//##########################################################

dp_tclKdsEarlyConfig_Touch::dp_tclKdsEarlyConfig_Touch() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_EARLYCONFIG_TOUCH_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsEarlyConfig_Touch::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsEarlyConfig_Touch::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA091, 0x80, pu8CurPos)) {
      pu8CurPos += 0x80;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsEarlyConfig_Touch::u8GetEarlyConfig_Touch(tU8* pu8Data, tU16 u16BufLen) {
   if (0x80<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_EARLYCONFIG_TOUCH_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsEarlyConfig_Touch::u8DataValid() const {return _u8DataStatus;};
//Key 'TouchDriverName':  [0,0] -> [63,7] (Bitlen: 512)
tU8 dp_tclKdsEarlyConfig_Touch::u8GetTouchDriverName(tU8* pu8Data, tU16 u16BufLen) {
   if (64<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 64);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'TouchConfigFileName':  [64,0] -> [127,7] (Bitlen: 512)
tU8 dp_tclKdsEarlyConfig_Touch::u8GetTouchConfigFileName(tU8* pu8Data, tU16 u16BufLen) {
   if (64<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[64], 64);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  InputKeyMappingTable_2  (Key: 0xA081)          
//##########################################################

dp_tclKdsInputKeyMappingTable_2::dp_tclKdsInputKeyMappingTable_2() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_2_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsInputKeyMappingTable_2::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsInputKeyMappingTable_2::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA081, 0xe6, pu8CurPos)) {
      pu8CurPos += 0xe6;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsInputKeyMappingTable_2::u8GetInputKeyMappingTable_2(tU8* pu8Data, tU16 u16BufLen) {
   if (0xe6<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_2_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsInputKeyMappingTable_2::u8DataValid() const {return _u8DataStatus;};
//Key 'MajorVersion':  [0,0] -> [0,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_2::u8GetMajorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinorVersion':  [1,0] -> [2,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_2::u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[1], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'NrOfEntries1':  [5,0] -> [5,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_2::u8GetNrOfEntries1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RawKeyID':  [6,0] -> [6,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_2::u8GetRawKeyID(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID':  [8,0] -> [9,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_2::u8GetLogicalKeyID(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[8], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID2':  [10,0] -> [10,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_2::u8GetRawKeyID2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[10]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID2':  [12,0] -> [13,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_2::u8GetLogicalKeyID2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[12], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID3':  [14,0] -> [14,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_2::u8GetRawKeyID3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID3':  [16,0] -> [17,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_2::u8GetLogicalKeyID3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[16], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID4':  [18,0] -> [18,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_2::u8GetRawKeyID4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID4':  [20,0] -> [21,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_2::u8GetLogicalKeyID4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[20], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  InputKeyMappingTable_3  (Key: 0xA082)          
//##########################################################

dp_tclKdsInputKeyMappingTable_3::dp_tclKdsInputKeyMappingTable_3() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsInputKeyMappingTable_3::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsInputKeyMappingTable_3::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA082, 0xe6, pu8CurPos)) {
      pu8CurPos += 0xe6;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsInputKeyMappingTable_3::u8GetInputKeyMappingTable_3(tU8* pu8Data, tU16 u16BufLen) {
   if (0xe6<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_3_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsInputKeyMappingTable_3::u8DataValid() const {return _u8DataStatus;};
//Key 'MajorVersion':  [0,0] -> [0,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetMajorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinorVersion':  [1,0] -> [2,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[1], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'NrOfEntries':  [5,0] -> [5,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetNrOfEntries(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RawKeyID':  [6,0] -> [6,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID':  [8,0] -> [9,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[8], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID2':  [10,0] -> [10,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[10]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID2':  [12,0] -> [13,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[12], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID3':  [14,0] -> [14,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID3':  [16,0] -> [17,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[16], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID4':  [18,0] -> [18,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID4':  [20,0] -> [21,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[20], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID5':  [22,0] -> [22,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[22]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID5':  [24,0] -> [25,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[24], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID6':  [26,0] -> [26,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID6(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[26]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID6':  [28,0] -> [29,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID6(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[28], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID7':  [30,0] -> [30,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID7(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[30]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID7':  [32,0] -> [33,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID7(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[32], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID8':  [34,0] -> [34,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID8(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[34]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID8':  [36,0] -> [37,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID8(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[36], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID9':  [38,0] -> [38,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID9(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[38]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID9':  [40,0] -> [41,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID9(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[40], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID10':  [42,0] -> [42,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID10(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID10':  [44,0] -> [45,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID10(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[44], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID11':  [46,0] -> [46,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID11(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[46]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID11':  [48,0] -> [49,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID11(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[48], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID12':  [50,0] -> [50,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID12(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[50]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID12':  [52,0] -> [53,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID12(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[52], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID13':  [54,0] -> [54,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID13(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[54]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID13':  [56,0] -> [57,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID13(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[56], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID14':  [58,0] -> [58,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID14(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID14':  [60,0] -> [61,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID14(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[60], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID15':  [62,0] -> [62,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID15(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[62]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID15':  [64,0] -> [65,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID15(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[64], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID16':  [66,0] -> [66,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID16(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[66]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID16':  [68,0] -> [69,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID16(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[68], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID17':  [70,0] -> [70,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID17(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[70]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID17':  [72,0] -> [73,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID17(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[72], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID18':  [74,0] -> [74,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID18(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[74]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID18':  [76,0] -> [77,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID18(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[76], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID19':  [78,0] -> [78,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID19(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[78]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID19':  [80,0] -> [81,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID19(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[80], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID20':  [82,0] -> [82,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID20(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[82]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID20':  [84,0] -> [85,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID20(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[84], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID21':  [86,0] -> [86,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID21(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[86]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID21':  [88,0] -> [89,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID21(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[88], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID22':  [90,0] -> [90,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID22(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[90]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID22':  [92,0] -> [93,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID22(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[92], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID23':  [94,0] -> [94,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID23(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[94]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID23':  [96,0] -> [97,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID23(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[96], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID24':  [98,0] -> [98,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID24(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[98]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID24':  [100,0] -> [101,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID24(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[100], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID25':  [102,0] -> [102,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID25(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[102]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID25':  [104,0] -> [105,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID25(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[104], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID26':  [106,0] -> [106,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID26(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[106]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID26':  [108,0] -> [109,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID26(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[108], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID27':  [110,0] -> [110,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID27(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[110]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID27':  [112,0] -> [113,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID27(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[112], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID28':  [114,0] -> [114,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID28(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[114]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID28':  [116,0] -> [117,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID28(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[116], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID29':  [118,0] -> [118,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID29(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[118]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID29':  [120,0] -> [121,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID29(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[120], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID30':  [122,0] -> [122,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID30(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[122]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID30':  [124,0] -> [125,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID30(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[124], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID31':  [126,0] -> [126,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID31(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[126]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID31':  [128,0] -> [129,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID31(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[128], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID32':  [130,0] -> [130,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetRawKeyID32(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[130]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID32':  [132,0] -> [133,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_3::u8GetLogicalKeyID32(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[132], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  InputKeyMappingTable_4  (Key: 0xA083)          
//##########################################################

dp_tclKdsInputKeyMappingTable_4::dp_tclKdsInputKeyMappingTable_4() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsInputKeyMappingTable_4::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsInputKeyMappingTable_4::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA083, 0xe6, pu8CurPos)) {
      pu8CurPos += 0xe6;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsInputKeyMappingTable_4::u8GetInputKeyMappingTable_4(tU8* pu8Data, tU16 u16BufLen) {
   if (0xe6<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_INPUTKEYMAPPINGTABLE_4_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsInputKeyMappingTable_4::u8DataValid() const {return _u8DataStatus;};
//Key 'MajorVersion':  [0,0] -> [0,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetMajorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinorVersion':  [1,0] -> [2,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[1], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'NrOfEntries':  [5,0] -> [5,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetNrOfEntries(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[5]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RawKeyID':  [6,0] -> [6,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetRawKeyID(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[6]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID':  [8,0] -> [9,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetLogicalKeyID(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[8], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID2':  [10,0] -> [10,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetRawKeyID2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[10]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID2':  [12,0] -> [13,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetLogicalKeyID2(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[12], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID3':  [14,0] -> [14,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetRawKeyID3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID3':  [16,0] -> [17,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetLogicalKeyID3(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[16], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID4':  [18,0] -> [18,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetRawKeyID4(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[18]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID4':  [20,0] -> [21,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetLogicalKeyID4(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[20], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID5':  [22,0] -> [22,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetRawKeyID5(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[22]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID5':  [24,0] -> [25,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetLogicalKeyID5(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[24], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID6':  [26,0] -> [26,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetRawKeyID6(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[26]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID6':  [28,0] -> [29,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetLogicalKeyID6(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[28], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID7':  [30,0] -> [30,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetRawKeyID7(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[30]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID7':  [32,0] -> [33,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetLogicalKeyID7(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[32], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID8':  [34,0] -> [34,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetRawKeyID8(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[34]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID8':  [36,0] -> [37,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetLogicalKeyID8(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[36], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID9':  [38,0] -> [38,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetRawKeyID9(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[38]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID9':  [40,0] -> [41,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetLogicalKeyID9(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[40], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID10':  [42,0] -> [42,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetRawKeyID10(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[42]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID10':  [44,0] -> [45,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetLogicalKeyID10(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[44], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID11':  [46,0] -> [46,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetRawKeyID11(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[46]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID11':  [48,0] -> [49,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetLogicalKeyID11(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[48], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID12':  [50,0] -> [50,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetRawKeyID12(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[50]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID12':  [52,0] -> [53,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetLogicalKeyID12(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[52], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID13':  [54,0] -> [54,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetRawKeyID13(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[54]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID13':  [56,0] -> [57,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetLogicalKeyID13(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[56], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'RawKeyID14':  [58,0] -> [58,7] (Bitlen: 8)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetRawKeyID14(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[58]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'LogicalKeyID14':  [60,0] -> [61,7] (Bitlen: 16)
tU8 dp_tclKdsInputKeyMappingTable_4::u8GetLogicalKeyID14(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[60], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  Lockout  (Key: 0xA0C0)          
//##########################################################

dp_tclKdsLockout::dp_tclKdsLockout() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_LOCKOUT_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsLockout::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsLockout::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA0C0, 0x5, pu8CurPos)) {
      pu8CurPos += 0x5;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsLockout::u8GetLockout(tU8* pu8Data, tU16 u16BufLen) {
   if (0x5<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_LOCKOUT_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsLockout::u8DataValid() const {return _u8DataStatus;};
//Key 'VideoPlayingRestriction':  [0,0] -> [0,0] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetVideoPlayingRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'PictureSlideshowRestriction':  [0,1] -> [0,1] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetPictureSlideshowRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'SMSTextInputRestriction':  [0,2] -> [0,2] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetSMSTextInputRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'FeaturesTutorialsRestriction':  [0,3] -> [0,3] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetFeaturesTutorialsRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'SystemUserHandbookRestriction':  [0,4] -> [0,4] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetSystemUserHandbookRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'TextInputRestriction':  [0,5] -> [0,5] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetTextInputRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'PhoneDialInputRestriction':  [0,6] -> [0,6] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetPhoneDialInputRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'NavigationDestinationInputRestriction':  [0,7] -> [0,7] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetNavigationDestinationInputRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'MusicRadioCoverDsplayRestriction':  [1,0] -> [1,0] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetMusicRadioCoverDsplayRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'GeneralHMIRestriction':  [1,1] -> [1,1] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetGeneralHMIRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'ServiceActivationRestriction':  [1,2] -> [1,2] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetServiceActivationRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'DisplayedTextLenghtRestriction':  [1,3] -> [1,3] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetDisplayedTextLenghtRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'HMIAnimationsRestriction':  [1,4] -> [1,4] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetHMIAnimationsRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'StationaryPictureIndictionRestriction':  [1,5] -> [1,5] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetStationaryPictureIndictionRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'OneByOneLineOperationNonMusicListScrollRestriction':  [1,6] -> [1,6] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetOneByOneLineOperationNonMusicListScrollRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'SmoothMapScroolOperationRestriction':  [1,7] -> [1,7] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetSmoothMapScroolOperationRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'DraggingOperationRestriction':  [2,0] -> [2,0] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetDraggingOperationRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'PinchInOutOperationRestriction':  [2,1] -> [2,1] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetPinchInOutOperationRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'UserProfileRestriction':  [2,2] -> [2,2] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetUserProfileRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'HomeMenuEditionRestriction':  [2,3] -> [2,3] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetHomeMenuEditionRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'CameraSettingsRestriction':  [2,4] -> [2,4] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetCameraSettingsRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'MapRotationRestriction':  [2,5] -> [2,5] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetMapRotationRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'PictureTextBackgroundDisplayRestriction':  [2,6] -> [2,6] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetPictureTextBackgroundDisplayRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x40)>>6);
   }
   return _u8DataStatus;
}

//Key 'Nissan5OperationCountRestriction':  [2,7] -> [2,7] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetNissan5OperationCountRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0x80)>>7);
   }
   return _u8DataStatus;
}

//Key 'Nissan8OperationCountRestriction':  [3,0] -> [3,0] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetNissan8OperationCountRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'Renault5OperationCountRestriction':  [3,1] -> [3,1] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetRenault5OperationCountRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'Renault8OperationCountRestriction':  [3,2] -> [3,2] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetRenault8OperationCountRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'AudioPlayAutomaticallyRestriction':  [3,3] -> [3,3] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetAudioPlayAutomaticallyRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x8)>>3);
   }
   return _u8DataStatus;
}

//Key 'SystemUpdateRestriction':  [3,4] -> [3,4] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetSystemUpdateRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x10)>>4);
   }
   return _u8DataStatus;
}

//Key 'SXMStock':  [3,5] -> [3,5] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetSXMStock(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x20)>>5);
   }
   return _u8DataStatus;
}

//Key 'OneByOneLineOperationMusicListScrollRestriction':  [3,6] -> [3,6] (Bitlen: 1)
tU8 dp_tclKdsLockout::u8GetOneByOneLineOperationMusicListScrollRestriction(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0x40)>>6);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  BlockingTestMode  (Key: 0xA1D4)          
//##########################################################

dp_tclKdsBlockingTestMode::dp_tclKdsBlockingTestMode() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_BLOCKINGTESTMODE_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsBlockingTestMode::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsBlockingTestMode::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA1D4, 0x1, pu8CurPos)) {
      pu8CurPos += 0x1;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsBlockingTestMode::u8GetBlockingTestMode(tU8* pu8Data, tU16 u16BufLen) {
   if (0x1<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_BLOCKINGTESTMODE_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsBlockingTestMode::u8DataValid() const {return _u8DataStatus;};
//Key 'BlockingTestModeApplicationSwitch':  [0,0] -> [0,0] (Bitlen: 1)
tU8 dp_tclKdsBlockingTestMode::u8GetBlockingTestModeApplicationSwitch(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x1)>>0);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  Audio_Parameter_Set  (Key: 0xA182)          
//##########################################################

dp_tclKdsAudio_Parameter_Set::dp_tclKdsAudio_Parameter_Set() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_AUDIO_PARAMETER_SET_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsAudio_Parameter_Set::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsAudio_Parameter_Set::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA182, 0xe6, pu8CurPos)) {
      pu8CurPos += 0xe6;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsAudio_Parameter_Set::u8GetAudio_Parameter_Set(tU8* pu8Data, tU16 u16BufLen) {
   if (0xe6<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_AUDIO_PARAMETER_SET_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsAudio_Parameter_Set::u8DataValid() const {return _u8DataStatus;};
//Key 'Tag':  [0,0] -> [7,7] (Bitlen: 64)
tU8 dp_tclKdsAudio_Parameter_Set::u8GetTag(tU8* pu8Data, tU16 u16BufLen) {
   if (8<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 8);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MajorVersion':  [8,0] -> [8,7] (Bitlen: 8)
tU8 dp_tclKdsAudio_Parameter_Set::u8GetMajorVersion(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[8]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinorVersion':  [9,0] -> [10,7] (Bitlen: 16)
tU8 dp_tclKdsAudio_Parameter_Set::u8GetMinorVersion(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[9], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'Parameter1':  [11,0] -> [227,7] (Bitlen: 1736)
tU8 dp_tclKdsAudio_Parameter_Set::u8GetParameter1(tU8* pu8Data, tU16 u16BufLen) {
   if (217<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[11], 217);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CRC':  [228,0] -> [229,7] (Bitlen: 16)
tU8 dp_tclKdsAudio_Parameter_Set::u8GetCRC(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[228], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  NVM_Configuration  (Key: 0xA1D5)          
//##########################################################

dp_tclKdsNVM_Configuration::dp_tclKdsNVM_Configuration() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_NVM_CONFIGURATION_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsNVM_Configuration::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsNVM_Configuration::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA1D5, 0x8, pu8CurPos)) {
      pu8CurPos += 0x8;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsNVM_Configuration::u8GetNVM_Configuration(tU8* pu8Data, tU16 u16BufLen) {
   if (0x8<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_NVM_CONFIGURATION_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsNVM_Configuration::u8DataValid() const {return _u8DataStatus;};
//Key 'PNMGroup10Switch':  [0,0] -> [0,0] (Bitlen: 1)
tU8 dp_tclKdsNVM_Configuration::u8GetPNMGroup10Switch(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'VCANBaudrate':  [1,0] -> [1,7] (Bitlen: 8)
tU8 dp_tclKdsNVM_Configuration::u8GetVCANBaudrate(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MCANBaudrate':  [2,0] -> [2,7] (Bitlen: 8)
tU8 dp_tclKdsNVM_Configuration::u8GetMCANBaudrate(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'PrimaryWakeup':  [3,0] -> [3,7] (Bitlen: 8)
tU8 dp_tclKdsNVM_Configuration::u8GetPrimaryWakeup(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0xff)>>0);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  AVDECC_Config  (Key: 0xA1D6)          
//##########################################################

dp_tclKdsAVDECC_Config::dp_tclKdsAVDECC_Config() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_AVDECC_CONFIG_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsAVDECC_Config::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsAVDECC_Config::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA1D6, 0x20, pu8CurPos)) {
      pu8CurPos += 0x20;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsAVDECC_Config::u8GetAVDECC_Config(tU8* pu8Data, tU16 u16BufLen) {
   if (0x20<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_AVDECC_CONFIG_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsAVDECC_Config::u8DataValid() const {return _u8DataStatus;};
//Key 'PresentationTimeGlassUSBVideo':  [0,0] -> [1,7] (Bitlen: 16)
tU8 dp_tclKdsAVDECC_Config::u8GetPresentationTimeGlassUSBVideo(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PresentationTimeGlassHDMI':  [2,0] -> [3,7] (Bitlen: 16)
tU8 dp_tclKdsAVDECC_Config::u8GetPresentationTimeGlassHDMI(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[2], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PresentationTimeGlassAnalogueCamera':  [4,0] -> [5,7] (Bitlen: 16)
tU8 dp_tclKdsAVDECC_Config::u8GetPresentationTimeGlassAnalogueCamera(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[4], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PresentationTimeGlassIPCamera':  [6,0] -> [7,7] (Bitlen: 16)
tU8 dp_tclKdsAVDECC_Config::u8GetPresentationTimeGlassIPCamera(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[6], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PresentationTimeAmplifierUSBVideo':  [8,0] -> [9,7] (Bitlen: 16)
tU8 dp_tclKdsAVDECC_Config::u8GetPresentationTimeAmplifierUSBVideo(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[8], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PresentationTimeAmplifierHDMI':  [10,0] -> [11,7] (Bitlen: 16)
tU8 dp_tclKdsAVDECC_Config::u8GetPresentationTimeAmplifierHDMI(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[10], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PresentationTimeAmplifierAudio':  [12,0] -> [13,7] (Bitlen: 16)
tU8 dp_tclKdsAVDECC_Config::u8GetPresentationTimeAmplifierAudio(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[12], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'MaxTransitTimeCamportStream1AVBHDMI':  [14,0] -> [14,7] (Bitlen: 8)
tU8 dp_tclKdsAVDECC_Config::u8GetMaxTransitTimeCamportStream1AVBHDMI(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[14]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxTransitTimeCamportStream2IPCAM':  [15,0] -> [15,7] (Bitlen: 8)
tU8 dp_tclKdsAVDECC_Config::u8GetMaxTransitTimeCamportStream2IPCAM(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[15]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxTransitTimeCamportStream3AUDIO':  [16,0] -> [16,7] (Bitlen: 8)
tU8 dp_tclKdsAVDECC_Config::u8GetMaxTransitTimeCamportStream3AUDIO(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[16]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'PresentationTimeGlassCMRDRM':  [17,0] -> [18,7] (Bitlen: 16)
tU8 dp_tclKdsAVDECC_Config::u8GetPresentationTimeGlassCMRDRM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[17], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PresentationTimeAmplifierCMRDRM':  [19,0] -> [20,7] (Bitlen: 16)
tU8 dp_tclKdsAVDECC_Config::u8GetPresentationTimeAmplifierCMRDRM(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[19], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'PresentationTimeAmplifierCMRAudio':  [21,0] -> [22,7] (Bitlen: 16)
tU8 dp_tclKdsAVDECC_Config::u8GetPresentationTimeAmplifierCMRAudio(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[21], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}



//##########################################################
//#######  CIS_Configuration  (Key: 0xA1D7)          
//##########################################################

dp_tclKdsCIS_Configuration::dp_tclKdsCIS_Configuration() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_CIS_CONFIGURATION_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsCIS_Configuration::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsCIS_Configuration::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0xA1D7, 0xe6, pu8CurPos)) {
      pu8CurPos += 0xe6;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsCIS_Configuration::u8GetCIS_Configuration(tU8* pu8Data, tU16 u16BufLen) {
   if (0xe6<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_CIS_CONFIGURATION_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsCIS_Configuration::u8DataValid() const {return _u8DataStatus;};
//Key 'ControlPanelAvailability':  [0,1] -> [0,1] (Bitlen: 1)
tU8 dp_tclKdsCIS_Configuration::u8GetControlPanelAvailability(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x2)>>1);
   }
   return _u8DataStatus;
}

//Key 'IPCameraAvailablitiy':  [0,2] -> [0,2] (Bitlen: 1)
tU8 dp_tclKdsCIS_Configuration::u8GetIPCameraAvailablitiy(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x4)>>2);
   }
   return _u8DataStatus;
}

//Key 'MinOnVolumeCockpit':  [20,0] -> [20,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetMinOnVolumeCockpit(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[20]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxOnVolumeCockpit':  [21,0] -> [21,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetMaxOnVolumeCockpit(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[21]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinOnVolumeCabinA':  [22,0] -> [22,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetMinOnVolumeCabinA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[22]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxOnVolumeCabinA':  [23,0] -> [23,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetMaxOnVolumeCabinA(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[23]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinOnVolumeCabinB':  [24,0] -> [24,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetMinOnVolumeCabinB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[24]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxOnVolumeCabinB':  [25,0] -> [25,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetMaxOnVolumeCabinB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[25]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinOnVolumeMIC1':  [26,0] -> [26,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetMinOnVolumeMIC1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[26]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxOnVolumeMIC1':  [27,0] -> [27,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetMaxOnVolumeMIC1(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[27]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinOnVolumeMIC2':  [28,0] -> [28,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetMinOnVolumeMIC2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[28]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxOnVolumeMIC2':  [29,0] -> [29,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetMaxOnVolumeMIC2(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[29]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MinOnVolumeMIC3':  [30,0] -> [30,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetMinOnVolumeMIC3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[30]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MaxOnVolumeMIC3':  [31,0] -> [31,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetMaxOnVolumeMIC3(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[31]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'DoorUnlockTime':  [120,0] -> [120,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetDoorUnlockTime(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[120]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'HealthcareEnabled':  [121,0] -> [121,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetHealthcareEnabled(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[121]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'HealthcareMessageInterval':  [122,0] -> [123,7] (Bitlen: 16)
tU8 dp_tclKdsCIS_Configuration::u8GetHealthcareMessageInterval(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[122], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'HealthcareMessageCount':  [124,0] -> [124,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetHealthcareMessageCount(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[124]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CameraTileInCabinHomescreen':  [125,0] -> [125,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetCameraTileInCabinHomescreen(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[125]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CameraportUSB':  [126,0] -> [126,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetCameraportUSB(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[126]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'HourLogicEnabled':  [127,0] -> [127,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetHourLogicEnabled(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[127]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'HourLogicTimeRange':  [128,0] -> [128,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetHourLogicTimeRange(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[128]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'HealthcareDTCPopupSeverity':  [140,0] -> [140,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetHealthcareDTCPopupSeverity(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[140]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'SafeShutdownTimer':  [141,0] -> [141,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetSafeShutdownTimer(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[141]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CameraActivation':  [142,0] -> [142,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetCameraActivation(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[142]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'RVCTextPosition':  [143,0] -> [143,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetRVCTextPosition(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[143]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'PrivateModeSpeakerAvailability':  [144,0] -> [144,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetPrivateModeSpeakerAvailability(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[144]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'CameraBlackScreenTime':  [145,0] -> [146,7] (Bitlen: 16)
tU8 dp_tclKdsCIS_Configuration::u8GetCameraBlackScreenTime(tU8* pu8Data, tU16 u16BufLen) {
   if (2<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[145], 2);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

//Key 'CameraBlackScreenFeature':  [147,0] -> [147,7] (Bitlen: 8)
tU8 dp_tclKdsCIS_Configuration::u8GetCameraBlackScreenFeature(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[147]&0xff)>>0);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  dev_NVM_Configuration  (Key: 0x0DC4)          
//##########################################################

dp_tclKdsdev_NVM_Configuration::dp_tclKdsdev_NVM_Configuration() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_DEV_NVM_CONFIGURATION_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsdev_NVM_Configuration::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsdev_NVM_Configuration::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x0DC4, 0x8, pu8CurPos)) {
      pu8CurPos += 0x8;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsdev_NVM_Configuration::u8Getdev_NVM_Configuration(tU8* pu8Data, tU16 u16BufLen) {
   if (0x8<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_DEV_NVM_CONFIGURATION_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsdev_NVM_Configuration::u8DataValid() const {return _u8DataStatus;};
//Key 'PNMGroup10Switch':  [0,0] -> [0,0] (Bitlen: 1)
tU8 dp_tclKdsdev_NVM_Configuration::u8GetPNMGroup10Switch(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[0]&0x1)>>0);
   }
   return _u8DataStatus;
}

//Key 'VCANBaudrate':  [1,0] -> [1,7] (Bitlen: 8)
tU8 dp_tclKdsdev_NVM_Configuration::u8GetVCANBaudrate(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[1]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'MCANBaudrate':  [2,0] -> [2,7] (Bitlen: 8)
tU8 dp_tclKdsdev_NVM_Configuration::u8GetMCANBaudrate(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[2]&0xff)>>0);
   }
   return _u8DataStatus;
}

//Key 'PrimaryWakeup':  [3,0] -> [3,7] (Bitlen: 8)
tU8 dp_tclKdsdev_NVM_Configuration::u8GetPrimaryWakeup(tU8& ru8Data) {
   vUpdate();
   if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
   {
      ru8Data = (tU8)((_au8data[3]&0xff)>>0);
   }
   return _u8DataStatus;
}



//##########################################################
//#######  CMConfigurationInformation  (Key: 0x0D30)          
//##########################################################

dp_tclKdsCMConfigurationInformation::dp_tclKdsCMConfigurationInformation() {
   _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
   (tVoid)memset(_au8data,0,DP_U8_KDSLEN_CMCONFIGURATIONINFORMATION_COMPLETE);
   vUpdate();
}

tBool dp_tclKdsCMConfigurationInformation::bReadEntry(tU16 u16KdsKey, tU16 u16Len, tU8* u8Buf) const {
    tBool bRet = FALSE;
    OSAL_tIODescriptor tIoKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
    if ( OSAL_ERROR != tIoKdsHandle) {
       tsKDSEntry sKDSEntryData;
       sKDSEntryData.u16Entry = u16KdsKey;
       sKDSEntryData.u16EntryLength = u16Len;
       sKDSEntryData.u16EntryFlags=M_KDS_ENTRY_FLAG_NONE;
       sKDSEntryData.au8EntryData[0]=0;

       tS32 s32NbElements = OSAL_s32IORead(tIoKdsHandle,(tPS8)&sKDSEntryData,(sizeof(sKDSEntryData)) );
       if (OSAL_ERROR != s32NbElements) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDSEntryData.au8EntryData, u16Len);
          bRet = TRUE;
       }
       (tVoid)OSAL_s32IOClose(tIoKdsHandle);
    }
    return bRet;
}

tVoid dp_tclKdsCMConfigurationInformation::vUpdate() {
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;

   // Read Data from KDS
   tU8* pu8CurPos = _au8data;
   if (bReadEntry(0x0D30, 0x14, pu8CurPos)) {
      pu8CurPos += 0x14;//lint !e416 Likely creation of out-of-bounds pointer
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
   }
   return; //lint !e438: Last value assigned to variable 'pu8CurPos' (defined at line x) not used
}

tU8 dp_tclKdsCMConfigurationInformation::u8GetCMConfigurationInformation(tU8* pu8Data, tU16 u16BufLen) {
   if (0x14<=u16BufLen) 
   {      
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
        (tVoid)memcpy(pu8Data, &_au8data[0], DP_U8_KDSLEN_CMCONFIGURATIONINFORMATION_COMPLETE);
      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}
tU8 dp_tclKdsCMConfigurationInformation::u8DataValid() const {return _u8DataStatus;};
//Key 'ConfigurationHash':  [0,0] -> [19,7] (Bitlen: 160)
tU8 dp_tclKdsCMConfigurationInformation::u8GetConfigurationHash(tU8* pu8Data, tU16 u16BufLen) {
   if (20<=u16BufLen) 
   {
      vUpdate();
      if (_u8DataStatus == DP_U8_ELEM_STATUS_VALID) 
      {
         (tVoid)memcpy(pu8Data, &_au8data[0], 20);

      }
   } 
   else 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_LEN_ERR;
   }
   return _u8DataStatus;
}

