#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define DP_S_IMPORT_INTERFACE_BASE
#include "dp_if.h"

#define DP_S_IMPORT_INTERFACE_KDS_FI
#include "dp_kds_if.h"

#define DP_KDS_ELEMENT_TRACE_CLASS              (tU16)(TR_COMP_DATAPOOL + 0x08) 

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS DP_KDS_ELEMENT_TRACE_CLASS
#include "trcGenProj/Header/dpIfKdsKeyValueAccess.cpp.trc.h"
#endif

DP_API_EXPORT tS32 DP_s32GetConfigItem(const tChar* strConfigElement, const tChar* strConfigItem, tU8* pau8Data, tU16 u16Len,tBool bNormalAssertIfElemNotExist) 
{
  tS32   Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT;
  // check parameter
  if((strConfigElement==NULL)||(strConfigItem==NULL)||(pau8Data==NULL))
  {
    Vs32ReturnCode=DP_S32_ERR_WRONG_PARAM;
  }
  else
  {

    if (strcmp(strConfigElement, "AesSecurityKey") == 0) 
    {
        dp_tclKdsAesSecurityKey oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAesSecurityKey(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "DimmingCalibrationParameterSet") == 0) 
    {
        dp_tclKdsDimmingCalibrationParameterSet oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDimmingCalibrationParameterSet(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "KEYBLED0CALIBRATIONVALUE") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetKEYBLED0CALIBRATIONVALUE(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "KEYBLED1CALIBRATIONVALUE") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetKEYBLED1CALIBRATIONVALUE(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "KEYBLED2CALIBRATIONVALUE") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetKEYBLED2CALIBRATIONVALUE(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "KEYBLED3CALIBRATIONVALUE") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetKEYBLED3CALIBRATIONVALUE(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "KEYBLED4CALIBRATIONVALUE") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetKEYBLED4CALIBRATIONVALUE(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "ECUSerialNumber") == 0) 
    {
        dp_tclKdsECUSerialNumber oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetECUSerialNumber(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "NavUnitID") == 0) 
    {
        dp_tclKdsNavUnitID oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNavUnitID(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "Vin") == 0) 
    {
        dp_tclKdsVin oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVin(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "AIVIVariantCoding") == 0) 
    {
        dp_tclKdsAIVIVariantCoding oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAIVIVariantCoding(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VariantSelection") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVariantSelection(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ActiveConfigurationSet") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetActiveConfigurationSet(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayOutput") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayOutput(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayOrientation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayOrientation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayAspectRatio") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayAspectRatio(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DispTrClockEdgeSelectLVDS1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDispTrClockEdgeSelectLVDS1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DispTrClockEdgeSelectLVDS2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDispTrClockEdgeSelectLVDS2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DAB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDAB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DRM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDRM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DTVType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDTVType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ExtendedDTVMountInformation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetExtendedDTVMountInformation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Sigma") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSigma(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SecurityAccessKeySelector") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSecurityAccessKeySelector(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ConsistencyCheckSupport") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetConsistencyCheckSupport(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HDMI") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHDMI(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LVDS1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLVDS1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LVDS2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLVDS2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VGA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVGA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SoftkeysConfiguration") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSoftkeysConfiguration(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DualDisplaySupport") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDualDisplaySupport(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EncoderMirroring") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEncoderMirroring(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "2ndEncoderMissing") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8Get2ndEncoderMissing(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ManagedApp") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetManagedApp(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SystemTypeSelector") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSystemTypeSelector(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BeaconSupport") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBeaconSupport(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ExtendedDVDMountInformation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetExtendedDVDMountInformation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HDMIApp") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHDMIApp(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VDIAG") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVDIAG(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CVBS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCVBS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LVDS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLVDS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Ethernet") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEthernet(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TouchI2CAddress") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTouchI2CAddress(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SpreadSpectrumClockGenerationLVDS") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSpreadSpectrumClockGenerationLVDS(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VRProcessStartAllowed") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVRProcessStartAllowed(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TTSProcessStartAllowed") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTTSProcessStartAllowed(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HourLogicEnabled") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHourLogicEnabled(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HourLogicTimeRange") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHourLogicTimeRange(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MFICertified") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMFICertified(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "IOSMySpin") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetIOSMySpin(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StandbyTimeout") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStandbyTimeout(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "SensorConfigACC") == 0) 
    {
        dp_tclKdsSensorConfigACC oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSensorConfigACC(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Tag") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTag(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MajorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMajorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinorVersion") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinorVersion(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ACCAngRX") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetACCAngRX(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ACCAngRY") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetACCAngRY(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ACCAngRZ") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetACCAngRZ(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ACCAngSX") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetACCAngSX(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ACCAngSY") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetACCAngSY(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ACCAngSZ") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetACCAngSZ(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ACCAngTX") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetACCAngTX(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ACCAngTY") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetACCAngTY(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ACCAngTZ") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetACCAngTZ(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AdcRangeMin") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAdcRangeMin(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AdcRangeMax") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAdcRangeMax(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SampleMin") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSampleMin(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SampleMax") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSampleMax(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinNoiseValueM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinNoiseValueM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinNoiseValueE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinNoiseValueE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimOffsetM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimOffsetM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimOffsetE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimOffsetE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOffsetM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOffsetM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOffsetE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOffsetE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOffsetM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOffsetM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOffsetE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOffsetE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadOffsetM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadOffsetM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadOffsetE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadOffsetE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibOffsetM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibOffsetM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibOffsetE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibOffsetE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimScaleFactorM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimScaleFactorM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimScaleFactorE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimScaleFactorE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinScaleFactorM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinScaleFactorM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinScaleFactorE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinScaleFactorE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxScaleFactorM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxScaleFactorM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxScaleFactorE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxScaleFactorE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadScaleFactorM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadScaleFactorM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadScaleFactorE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadScaleFactorE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibScaleFactorM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibScaleFactorM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibScaleFactorE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibScaleFactorE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetTimeM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetTimeM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetTimeE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetTimeE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorTimeM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorTimeM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorTimeE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorTimeE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AdcRangeMin2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAdcRangeMin2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AdcRangeMax2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAdcRangeMax2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SampleMin2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSampleMin2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SampleMax2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSampleMax2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinNoiseValueM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinNoiseValueM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinNoiseValueE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinNoiseValueE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimOffsetM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimOffsetM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimOffsetE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimOffsetE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOffsetM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOffsetM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOffsetE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOffsetE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOffsetM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOffsetM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOffsetE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOffsetE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadOffsetM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadOffsetM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadOffsetE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadOffsetE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibOffsetM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibOffsetM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibOffsetE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibOffsetE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimScaleFactorM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimScaleFactorM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimScaleFactorE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimScaleFactorE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinScaleFactorM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinScaleFactorM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinScaleFactorE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinScaleFactorE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxScaleFactorM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxScaleFactorM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxScaleFactorE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxScaleFactorE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadScaleFactorM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadScaleFactorM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadScaleFactorE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadScaleFactorE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibScaleFactorM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibScaleFactorM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibScaleFactorE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibScaleFactorE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetTimeM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetTimeM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetTimeE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetTimeE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorTimeM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorTimeM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorTimeE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorTimeE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AdcRangeMin3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAdcRangeMin3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AdcRangeMax3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAdcRangeMax3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SampleMin3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSampleMin3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SampleMax3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSampleMax3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinNoiseValueM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinNoiseValueM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinNoiseValueE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinNoiseValueE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimOffsetM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimOffsetM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimOffsetE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimOffsetE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOffsetM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOffsetM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOffsetE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOffsetE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOffsetM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOffsetM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOffsetE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOffsetE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadOffsetM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadOffsetM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadOffsetE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadOffsetE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibOffsetM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibOffsetM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibOffsetE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibOffsetE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimScaleFactorM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimScaleFactorM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimScaleFactorE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimScaleFactorE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinScaleFactorM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinScaleFactorM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinScaleFactorE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinScaleFactorE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxScaleFactorM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxScaleFactorM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxScaleFactorE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxScaleFactorE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadScaleFactorM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadScaleFactorM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadScaleFactorE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadScaleFactorE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibScaleFactorM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibScaleFactorM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibScaleFactorE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibScaleFactorE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetTimeM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetTimeM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetTimeE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetTimeE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorTimeM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorTimeM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorTimeE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorTimeE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "SensorConfigGNSS") == 0) 
    {
        dp_tclKdsSensorConfigGNSS oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSensorConfigGNSS(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Tag") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTag(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MajorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMajorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinorVersion") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinorVersion(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GPS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGPS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GLONASS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGLONASS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GALILEO") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGALILEO(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "COMPASS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCOMPASS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SBAS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSBAS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "QZSS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetQZSS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "SensorConfigGyro") == 0) 
    {
        dp_tclKdsSensorConfigGyro oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSensorConfigGyro(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Tag") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTag(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MajorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMajorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinorVersion") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinorVersion(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GyroAngRX") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGyroAngRX(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GyroAngRY") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGyroAngRY(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GyroAngRZ") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGyroAngRZ(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GyroAngSX") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGyroAngSX(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GyroAngSY") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGyroAngSY(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GyroAngSZ") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGyroAngSZ(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GyroAngTX") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGyroAngTX(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GyroAngTY") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGyroAngTY(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GyroAngTZ") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGyroAngTZ(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AdcRangeMin") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAdcRangeMin(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AdcRangeMax") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAdcRangeMax(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SampleMin") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSampleMin(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SampleMax") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSampleMax(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinNoiseValueM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinNoiseValueM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinNoiseValueE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinNoiseValueE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimOffsetM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimOffsetM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimOffsetE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimOffsetE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOffsetM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOffsetM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOffsetE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOffsetE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOffsetM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOffsetM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOffsetE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOffsetE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadOffsetM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadOffsetM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadOffsetE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadOffsetE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibOffsetM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibOffsetM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibOffsetE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibOffsetE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimScaleFactorM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimScaleFactorM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimScaleFactorE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimScaleFactorE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinScaleFactorM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinScaleFactorM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinScaleFactorE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinScaleFactorE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxScaleFactorM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxScaleFactorM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxScaleFactorE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxScaleFactorE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadScaleFactorM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadScaleFactorM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadScaleFactorE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadScaleFactorE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibScaleFactorM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibScaleFactorM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibScaleFactorE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibScaleFactorE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetTimeM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetTimeM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetTimeE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetTimeE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorTimeM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorTimeM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorTimeE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorTimeE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AdcRangeMin2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAdcRangeMin2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AdcRangeMax2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAdcRangeMax2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SampleMin2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSampleMin2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SampleMax2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSampleMax2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinNoiseValueM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinNoiseValueM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinNoiseValueE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinNoiseValueE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimOffsetM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimOffsetM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimOffsetE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimOffsetE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOffsetM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOffsetM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOffsetE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOffsetE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOffsetM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOffsetM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOffsetE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOffsetE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadOffsetM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadOffsetM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadOffsetE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadOffsetE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibOffsetM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibOffsetM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibOffsetE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibOffsetE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimScaleFactorM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimScaleFactorM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimScaleFactorE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimScaleFactorE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinScaleFactorM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinScaleFactorM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinScaleFactorE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinScaleFactorE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxScaleFactorM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxScaleFactorM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxScaleFactorE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxScaleFactorE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadScaleFactorM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadScaleFactorM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadScaleFactorE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadScaleFactorE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibScaleFactorM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibScaleFactorM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibScaleFactorE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibScaleFactorE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetTimeM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetTimeM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetTimeE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetTimeE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorTimeM2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorTimeM2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorTimeE2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorTimeE2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AdcRangeMin3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAdcRangeMin3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AdcRangeMax3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAdcRangeMax3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SampleMin3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSampleMin3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SampleMax3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSampleMax3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinNoiseValueM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinNoiseValueM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinNoiseValueE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinNoiseValueE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimOffsetM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimOffsetM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimOffsetE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimOffsetE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOffsetM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOffsetM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOffsetE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOffsetE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOffsetM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOffsetM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOffsetE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOffsetE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadOffsetM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadOffsetM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadOffsetE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadOffsetE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibOffsetM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibOffsetM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibOffsetE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibOffsetE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimScaleFactorM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimScaleFactorM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EstimScaleFactorE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEstimScaleFactorE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinScaleFactorM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinScaleFactorM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinScaleFactorE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinScaleFactorE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxScaleFactorM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxScaleFactorM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxScaleFactorE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxScaleFactorE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadScaleFactorM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadScaleFactorM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxUnsteadScaleFactorE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxUnsteadScaleFactorE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibScaleFactorM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibScaleFactorM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BestCalibScaleFactorE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBestCalibScaleFactorE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetTimeM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetTimeM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftOffsetTimeE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftOffsetTimeE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorTimeM3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorTimeM3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DriftScaleFactorTimeE3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDriftScaleFactorTimeE3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "GenericTunerParameter") == 0) 
    {
        dp_tclKdsGenericTunerParameter oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGenericTunerParameter(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Tag") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTag(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MajorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMajorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinorVersion") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinorVersion(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FM1List") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFM1List(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FM2List") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFM2List(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FM3List") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFM3List(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMASTList") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMASTList(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMMW1List") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMMW1List(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMMW2List") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMMW2List(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMMW3List") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMMW3List(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMMWASTList") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMMWASTList(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMLW1List") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMLW1List(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMLW2List") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMLW2List(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMLW3List") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMLW3List(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMLWASTList") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMLWASTList(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DAB1List") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDAB1List(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DAB2List") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDAB2List(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DAB3List") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDAB3List(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DABASTList") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDABASTList(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MIX1List") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMIX1List(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MIX2List") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMIX2List(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MIX3List") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMIX3List(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MIXASTList") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMIXASTList(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AutostoreUnusedPresetParameter") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAutostoreUnusedPresetParameter(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "InitialAutostoreNoOfStations") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetInitialAutostoreNoOfStations(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "UserAutostoreNoOfStations") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUserAutostoreNoOfStations(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AutostoreSortingCriteriaFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAutostoreSortingCriteriaFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AutostoreSortingCriteriaAM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAutostoreSortingCriteriaAM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AutostoreSortingCriteriaDAB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAutostoreSortingCriteriaDAB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ShowFrequencyUpdates") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetShowFrequencyUpdates(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NoLearnSeek") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNoLearnSeek(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TunnelCheck") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTunnelCheck(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "InitialAutostoreBehavior") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetInitialAutostoreBehavior(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DefaultBandAfterInitialAutostore") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDefaultBandAfterInitialAutostore(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "UserAutostoreBehavior") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUserAutostoreBehavior(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DefaultBandAfterUserAutostore") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDefaultBandAfterUserAutostore(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MuteOrAttenuationForAbsoluteStationChangeAMFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMuteOrAttenuationForAbsoluteStationChangeAMFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MuteOrAttenuationForSeekAMFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMuteOrAttenuationForSeekAMFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MuteOrAttenuationForManualTuningAMFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMuteOrAttenuationForManualTuningAMFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimeToReleaseAttenuationAMFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimeToReleaseAttenuationAMFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ConsiderLevelCompensationForPresetLoad") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetConsiderLevelCompensationForPresetLoad(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ConsiderLevelCompensationForListLoad") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetConsiderLevelCompensationForListLoad(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MonitorFMTAInAMWithTuner2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMonitorFMTAInAMWithTuner2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMTAMonitorTuner2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMTAMonitorTuner2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AudioTunerTPSeek") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAudioTunerTPSeek(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementRequestHandling") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementRequestHandling(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMTPseekStrategy") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMTPseekStrategy(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimeDelayFMTPStationAfterVolumeZero") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimeDelayFMTPStationAfterVolumeZero(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimeDelayNoFMTPStationFound") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimeDelayNoFMTPStationFound(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimeDelayFMTPStationSelectAfterRDSLost") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimeDelayFMTPStationSelectAfterRDSLost(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimeFMTAEndAfterRDSLost") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimeFMTAEndAfterRDSLost(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BackgroundTA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBackgroundTA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMTAInDABIfNoDABTA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMTAInDABIfNoDABTA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DABTAInFMIfNoFMTA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDABTAInFMIfNoFMTA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PreferedTASource") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreferedTASource(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioFMTA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioFMTA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioFMPTY31") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioFMPTY31(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioFMNEWS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioFMNEWS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABAlarm") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABAlarm(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABRoadTrafficFlash") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABRoadTrafficFlash(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABTransportFlash") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABTransportFlash(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABWarningService") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABWarningService(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABNewsFlash") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABNewsFlash(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABAreaWeatherFlash") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABAreaWeatherFlash(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABEventAnnouncement") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABEventAnnouncement(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABSpecialEvent") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABSpecialEvent(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABProgramInformation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABProgramInformation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABSportReport") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABSportReport(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABFinantialReport") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABFinantialReport(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABReserved1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABReserved1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABReserved2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABReserved2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABReserved3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABReserved3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABReserved4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABReserved4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnnouncementPrioDABReserved5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnnouncementPrioDABReserved5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimeDelayNoDABTPStationFound") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimeDelayNoDABTPStationFound(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimeDABAnnoEndAfterReceptionLost") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimeDABAnnoEndAfterReceptionLost(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DAB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDAB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "XM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetXM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfPresetListSXM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfPresetListSXM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfPresetsPerBankSXM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfPresetsPerBankSXM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PresetListType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPresetListType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfPresetListFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfPresetListFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfBanksHmiFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfBanksHmiFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfPresetsPerBankFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfPresetsPerBankFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfPresetListMW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfPresetListMW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfBanksHmiMW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfBanksHmiMW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfPresetsPerBankMW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfPresetsPerBankMW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfPresetListLW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfPresetListLW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfBanksHmiLW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfBanksHmiLW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfPresetsPerBankLW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfPresetsPerBankLW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfPresetListDAB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfPresetListDAB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfBanksHmiDAB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfBanksHmiDAB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfPresetsPerBankDAB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfPresetsPerBankDAB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfPresetListForMixedAllBands") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfPresetListForMixedAllBands(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfBanksHmiForMixedAllBands") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfBanksHmiForMixedAllBands(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfPresetsPerBankForMixedAllBands") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfPresetsPerBankForMixedAllBands(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset0") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset0(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset6") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset6(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset7") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset7(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset8") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset8(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset9") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset9(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset10") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset10(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset11") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset11(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset12") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset12(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset13") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset13(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset14") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset14(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset15") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset15(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset16") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset16(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset17") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset17(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset18") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset18(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset19") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset19(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset20") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset20(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset21") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset21(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset22") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset22(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset23") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset23(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset24") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset24(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset25") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset25(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset26") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset26(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset27") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset27(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset28") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset28(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset29") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset29(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset30") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset30(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset2031") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset2031(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset32") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset32(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset33") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset33(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset34") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset34(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset35") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset35(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset36") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset36(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset37") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset37(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset38") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset38(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset39") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset39(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset40") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset40(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset41") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset41(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset42") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset42(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset43") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset43(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset44") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset44(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset45") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset45(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset46") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset46(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset47") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset47(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset48") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset48(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset49") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset49(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset50") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset50(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset51") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset51(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset52") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset52(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset53") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset53(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset54") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset54(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset55") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset55(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset56") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset56(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset57") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset57(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset58") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset58(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset59") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset59(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Preset60") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreset60(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "AMFMTunerParameter") == 0) 
    {
        dp_tclKdsAMFMTunerParameter oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMFMTunerParameter(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Tag") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTag(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MajorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMajorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinorVersion") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinorVersion(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowFM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowFM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighFM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighFM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StepSizeFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStepSizeFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ManualStepSizeFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetManualStepSizeFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowMW") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowMW(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighMW") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighMW(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StepSizeMW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStepSizeMW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ManualStepSizeMW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetManualStepSizeMW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowLW") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowLW(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighLW") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighLW(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StepSizeLW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStepSizeLW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ManualStepSizeLW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetManualStepSizeLW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RDS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRDS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AF") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAF(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "REG") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetREG(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Radiotext") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRadiotext(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DDA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDDA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DDS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDDS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Datascan") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDatascan(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PTY31") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPTY31(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AFTemporaryONOFF") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAFTemporaryONOFF(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMLSM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMLSM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MWLSM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMWLSM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LWLSM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLWLSM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ShowTextWaitingForRadioText") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetShowTextWaitingForRadioText(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ShowTextNoRadioTextAvailable1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetShowTextNoRadioTextAvailable1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ShowTextWaitingForRadioTextWithRDSTimeout") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetShowTextWaitingForRadioTextWithRDSTimeout(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TRadioTextNotAvailable") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTRadioTextNotAvailable(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TTimeoutStatusRT") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTTimeoutStatusRT(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TShowTextMin") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTShowTextMin(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TMinimumDisplayDurationPerRadiotextPage") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTMinimumDisplayDurationPerRadiotextPage(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RadioTextMinimumLength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRadioTextMinimumLength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RadioTextSpeedThreshold") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRadioTextSpeedThreshold(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RadioTextSpeedThresholdHysteresis") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRadioTextSpeedThresholdHysteresis(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EmergenySeekScanNumberOfStations") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEmergenySeekScanNumberOfStations(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ShowFrequencyDuringFrequencyScan") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetShowFrequencyDuringFrequencyScan(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeekMode") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeekMode(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfSeekPeriods") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfSeekPeriods(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ScanTime") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetScanTime(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AFBestDelayTimeAfterManualTuning") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAFBestDelayTimeAfterManualTuning(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AFBestDisplayFreezeAfterManualTuning") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAFBestDisplayFreezeAfterManualTuning(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AutoSeekStepDelay") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAutoSeekStepDelay(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PermanentManualStepDelay") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPermanentManualStepDelay(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "WrongPiAcceptDelayAfterStationSelection") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWrongPiAcceptDelayAfterStationSelection(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "WrongPiAcceptAfterStationLost") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWrongPiAcceptAfterStationLost(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MultiManualStepsWithIntermediateFrequencies") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMultiManualStepsWithIntermediateFrequencies(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StationListsFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStationListsFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StationListsMW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStationListsMW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StationListsLW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStationListsLW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StationListsMWLW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStationListsMWLW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMListSortingDefault") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMListSortingDefault(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMListSortingDefault") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMListSortingDefault(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TInhibitListSortAfterSkip") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTInhibitListSortAfterSkip(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TCursorDelayAfterStationSelect") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTCursorDelayAfterStationSelect(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TIMEAMMINTUNELISTREMOVE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTIMEAMMINTUNELISTREMOVE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TIMEAMSTATIONREMOVEAFTERDESELECT") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTIMEAMSTATIONREMOVEAFTERDESELECT(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMStationListUpdateStrategy") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMStationListUpdateStrategy(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TestmodeUpdateCycle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTestmodeUpdateCycle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AFListUpdateCycle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAFListUpdateCycle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ResortingOfAFList") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetResortingOfAFList(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AFlistReleaseBehavior") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAFlistReleaseBehavior(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FM2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFM2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MW2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMW2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LW2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLW2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MWLWCombined") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMWLWCombined(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StartPISeek") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStartPISeek(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LastPassedFrequency") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLastPassedFrequency(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRFMChannelSeparation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRFMChannelSeparation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRFMLimitation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRFMLimitation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRFMMultipath") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRFMMultipath(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRFMHighcut") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRFMHighcut(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRFMSoftmute") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRFMSoftmute(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRAMSoftmute") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRAMSoftmute(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRFMDeemphasis") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRFMDeemphasis(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRFMFrequencyResponse") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRFMFrequencyResponse(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRAMFrequencyResponse") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRAMFrequencyResponse(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRFMMisc") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRFMMisc(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRAMMisc") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRAMMisc(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRFMAntennaAttenuation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRFMAntennaAttenuation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRAMAntennaAnttenuation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRAMAntennaAnttenuation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRAMHicutConfiguration") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRAMHicutConfiguration(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRAMDeemphasis") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRAMDeemphasis(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MuteRamp1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMuteRamp1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DemuteRamp1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDemuteRamp1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MuteRamp2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMuteRamp2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DemuteRamp2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDemuteRamp2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TriggerNotificationOnFieldstrenghtQualityChange") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTriggerNotificationOnFieldstrenghtQualityChange(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeekLevelFMRDSFieldstrength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeekLevelFMRDSFieldstrength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeekLevelFMRDSQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeekLevelFMRDSQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeekLevelFMNonRDSFieldstrength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeekLevelFMNonRDSFieldstrength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeekLevelFMNonRDSQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeekLevelFMNonRDSQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeekLevelLWFieldstrength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeekLevelLWFieldstrength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeekLevelLWQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeekLevelLWQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeekLevelMWFieldstrength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeekLevelMWFieldstrength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeekLevelMWQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeekLevelMWQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeekLevelSWFieldstrength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeekLevelSWFieldstrength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeekLevelSWQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeekLevelSWQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeekLevelTRFFieldstrength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeekLevelTRFFieldstrength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeekLevelTRFQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeekLevelTRFQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeekLevelWBFieldstrength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeekLevelWBFieldstrength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeekLevelWBQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeekLevelWBQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ListLevelFMRDSFieldstrength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetListLevelFMRDSFieldstrength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ListLevelFMRDSQualify") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetListLevelFMRDSQualify(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ListLevelFMNonRDSFieldstrength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetListLevelFMNonRDSFieldstrength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ListLevelFMNonRDSQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetListLevelFMNonRDSQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ListLevelLWFieldstrength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetListLevelLWFieldstrength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ListLevelLWQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetListLevelLWQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ListLevelMWFieldstrength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetListLevelMWFieldstrength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ListLevelMWQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetListLevelMWQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ListLevelSWFieldstrength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetListLevelSWFieldstrength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ListLevelSWQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetListLevelSWQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ListLevelTRFFieldstrength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetListLevelTRFFieldstrength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ListLevelTRFQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetListLevelTRFQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ListLevelWBFieldstrength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetListLevelWBFieldstrength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ListLevelWBQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetListLevelWBQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SharxFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSharxFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SharxAM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSharxAM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HicutFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHicutFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HicutAM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHicutAM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsLW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsLW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsMW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsMW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsWB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsWB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsTRF") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsTRF(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsSW1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsSW1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsSW2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsSW2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsSW3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsSW3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsSW4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsSW4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsSW5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsSW5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsSW6") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsSW6(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsSW7") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsSW7(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsSW8") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsSW8(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsSW9") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsSW9(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsSW10") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsSW10(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsSW11") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsSW11(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsSW12") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsSW12(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsSW13") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsSW13(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AvailableBandsSW14") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAvailableBandsSW14(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationLW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationLW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationMW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationMW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationWB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationWB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationTRF") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationTRF(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationSW1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationSW1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationSW2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationSW2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationSW3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationSW3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationSW4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationSW4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationSW5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationSW5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationSW6") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationSW6(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationSW7") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationSW7(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationSW8") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationSW8(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationSW9") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationSW9(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationSW10") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationSW10(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationSW11") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationSW11(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationSW12") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationSW12(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationSW13") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationSW13(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationSW14") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationSW14(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationCB1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationCB1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationFMAndAMSwitchEnabled") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationFMAndAMSwitchEnabled(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationFMHDSwitchEnabled") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationFMHDSwitchEnabled(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationAMHDSwitchEnabled") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationAMHDSwitchEnabled(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CombiBandConfigurationDRMSwitchEnabled") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCombiBandConfigurationDRMSwitchEnabled(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TPAudioTuner1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTPAudioTuner1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TPAudioTuner2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTPAudioTuner2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AFAudioTuner1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAFAudioTuner1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AFAudioTuner2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAFAudioTuner2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DDAAudioTuner1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDDAAudioTuner1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DDAAudioTuner2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDDAAudioTuner2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RDSAudioTuner1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRDSAudioTuner1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RDSAudioTuner2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRDSAudioTuner2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PSFixAudioTuner1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPSFixAudioTuner1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PSFixAudioTuner2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPSFixAudioTuner2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StereoAudioTuner1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStereoAudioTuner1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StereoAudioTuner2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStereoAudioTuner2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "REGAudioTuner1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetREGAudioTuner1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "REGAudioTuner2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetREGAudioTuner2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PTY31ForAudioTuner1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPTY31ForAudioTuner1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PTY31ForAudioTuner2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPTY31ForAudioTuner2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DDSAudioTuner1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDDSAudioTuner1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DDSAudioTuner2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDDSAudioTuner2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DMQAudioTuner1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDMQAudioTuner1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DMQAudioTuner2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDMQAudioTuner2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRPhysicalTunerConfigId") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRPhysicalTunerConfigId(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADRAntennaConfigId") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADRAntennaConfigId(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ExchangeAntennaLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetExchangeAntennaLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PITestLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPITestLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NRDSLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNRDSLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EONLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEONLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMMemoLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMMemoLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PanicFieldstLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPanicFieldstLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ParamRDSLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetParamRDSLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RDSDataAccept") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRDSDataAccept(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PIStepLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPIStepLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DDAAntennaDistLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDDAAntennaDistLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RDSSynDelayCounter") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRDSSynDelayCounter(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MPMeasureLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMPMeasureLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MPRestrictionLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMPRestrictionLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MPVeryBadLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMPVeryBadLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MPMediumLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMPMediumLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RDSBadLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRDSBadLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "IllegalAF") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetIllegalAF(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AFSaveLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAFSaveLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FirstRundum") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFirstRundum(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SecondRundum") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSecondRundum(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ThirdRundum") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetThirdRundum(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PIStepWithNoPICheck") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPIStepWithNoPICheck(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AudioOffScanMode") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAudioOffScanMode(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMLearnCycle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMLearnCycle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PIIgnore") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPIIgnore(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PISearchTime") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPISearchTime(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisableSeamlessBlending") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisableSeamlessBlending(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SLAdjThreshold") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSLAdjThreshold(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SLMpThreshold") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSLMpThreshold(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SpecialFmStartFrequency") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSpecialFmStartFrequency(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMSharxLimit") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMSharxLimit(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HDScanEveryFrequency") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHDScanEveryFrequency(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HWSubConfig") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHWSubConfig(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FM2DABDelayTime") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFM2DABDelayTime(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "WeatherBandLSM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWeatherBandLSM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMFMHicutExtender") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMFMHicutExtender(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMSoftmuteTiming") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMSoftmuteTiming(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMFMMisscellaneous2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMFMMisscellaneous2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMHicutExtenderFieldstrengthThreshold") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMHicutExtenderFieldstrengthThreshold(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMHicutExtenderFilterOffset") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMHicutExtenderFilterOffset(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMChannelSeparationMaximum") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMChannelSeparationMaximum(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMChannelSeparationTiming") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMChannelSeparationTiming(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMHicutFieldstrengthThreshold") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMHicutFieldstrengthThreshold(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMHicutTiming") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMHicutTiming(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMDMQSensitivity") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMDMQSensitivity(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMDeviationAdaption") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMDeviationAdaption(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMNoiseBlanker228KHzSensitivity") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMNoiseBlanker228KHzSensitivity(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMNoiseBlanker456KHzSensitivity") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMNoiseBlanker456KHzSensitivity(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMHicutExtenderFieldstrengthThreshold") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMHicutExtenderFieldstrengthThreshold(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMHicutExtenderFilterOffset") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMHicutExtenderFilterOffset(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DemodAudioTuner1FMAM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDemodAudioTuner1FMAM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DemodAudioTuner1FMHD") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDemodAudioTuner1FMHD(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DemodAudioTuner1AMHD") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDemodAudioTuner1AMHD(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DemodAudioTuner1DRM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDemodAudioTuner1DRM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DemodAudioTuner2FMAM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDemodAudioTuner2FMAM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DemodAudioTuner2FMHD") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDemodAudioTuner2FMHD(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DemodAudioTuner2AMHD") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDemodAudioTuner2AMHD(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DemodAudioTuner2DRM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDemodAudioTuner2DRM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimeNonRdsDetect") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimeNonRdsDetect(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimePsDeleteAfterRdsLost") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimePsDeleteAfterRdsLost(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimeScrollPsDetect") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimeScrollPsDetect(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TSpeedTuneTrigger") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTSpeedTuneTrigger(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NSpeedTuneTrigger") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNSpeedTuneTrigger(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NSpeedTuneMultipierFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNSpeedTuneMultipierFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NSpeedTuneMultipierAM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNSpeedTuneMultipierAM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfPsChangesForScrollDetect") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfPsChangesForScrollDetect(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimePTYHold") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimePTYHold(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "HDRadioParameterSet") == 0) 
    {
        dp_tclKdsHDRadioParameterSet oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHDRadioParameterSet(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Tag") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTag(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MajorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMajorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinorVersion") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinorVersion(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BlendThresholdFMHybrid") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBlendThresholdFMHybrid(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DigitalAudioScalingForFMHybrid") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDigitalAudioScalingForFMHybrid(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DigitalAudioDelayForFMHybridPrimaryBBRate") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDigitalAudioDelayForFMHybridPrimaryBBRate(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BlendRateFMHybrid") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBlendRateFMHybrid(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BlendThresholdAMHybrid") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBlendThresholdAMHybrid(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMMPSAudioScaling") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMMPSAudioScaling(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMMPSBlendRate") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMMPSBlendRate(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DigitalAudioDelayForAMMPSPrimaryBBRate") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDigitalAudioDelayForAMMPSPrimaryBBRate(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DigitalAudioPhaseInversion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDigitalAudioPhaseInversion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BlendDecision") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBlendDecision(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMCdN0BlendDecision") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMCdN0BlendDecision(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMCdN0BlendDecision") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMCdN0BlendDecision(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Timer1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimer1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Timer2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimer2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Timer3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimer3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Timer4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimer4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Timer5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimer5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "DABParameterSet") == 0) 
    {
        dp_tclKdsDABParameterSet oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDABParameterSet(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Tag") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTag(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MajorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMajorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinorVersion") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinorVersion(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SFDABDAB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSFDABDAB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SFDABFM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSFDABFM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SFFMDAB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSFFMDAB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DMBA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDMBA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TPEG") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTPEG(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EPG") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEPG(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SLS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSLS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BWS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBWS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Intellitext") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetIntellitext(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Journaline") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetJournaline(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SFAlternativeFrequency") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSFAlternativeFrequency(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SFAlternativeEnsemble") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSFAlternativeEnsemble(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SFHardLinking") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSFHardLinking(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SFSearch") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSFSearch(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SFStickyComponent") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSFStickyComponent(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ConcealmentLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetConcealmentLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TSUMatrixDABFM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTSUMatrixDABFM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TSUMatrixFMDAB") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTSUMatrixFMDAB(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DABFMLinkingSwitchBackDelay") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDABFMLinkingSwitchBackDelay(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DABFMLinkingSmoothingTUp") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDABFMLinkingSmoothingTUp(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DABFMLinkingSmoothingTDown") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDABFMLinkingSmoothingTDown(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DABFMLinkingComparisonDelay") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDABFMLinkingComparisonDelay(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DABFMLinkingSmoothingTLong") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDABFMLinkingSmoothingTLong(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DABFMLinkingFMQualityThreshold") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDABFMLinkingFMQualityThreshold(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMDABLinkingSwitchBackDelay") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMDABLinkingSwitchBackDelay(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMDABLinkingSmoothingTUp") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMDABLinkingSmoothingTUp(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMDABLinkingSmoothingTDown") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMDABLinkingSmoothingTDown(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMDABLinkingPSIDChangedDelay") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMDABLinkingPSIDChangedDelay(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMDABLinkingSmoothingTLong") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMDABLinkingSmoothingTLong(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMDABLinkingDABQualityThreshold") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMDABLinkingDABQualityThreshold(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RDMQualityConfigQualityDecreaseSpeedFactor") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRDMQualityConfigQualityDecreaseSpeedFactor(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RDMQualityConfigMode") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRDMQualityConfigMode(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RDMQualityConfigCount") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRDMQualityConfigCount(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EnsembleRecIndicator") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEnsembleRecIndicator(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EnsembleRecIndicatorSyncDelay") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEnsembleRecIndicatorSyncDelay(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EnsembleVerificationAlgorithmTimeTickDivider") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEnsembleVerificationAlgorithmTimeTickDivider(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EnsembleVerificationAlgorithmTimePeriod") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEnsembleVerificationAlgorithmTimePeriod(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EnsembleVerificationAlgorithmMinGoodFICBERTime") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEnsembleVerificationAlgorithmMinGoodFICBERTime(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EnsembleVerificationAlgorithmMinGoodFICBERLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEnsembleVerificationAlgorithmMinGoodFICBERLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EnsembleVerificationAlgorithmTargetCounterValue") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEnsembleVerificationAlgorithmTargetCounterValue(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EnsembleQualityAlgorithmMinGoodFICBERTime") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEnsembleQualityAlgorithmMinGoodFICBERTime(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EnsembleQualityAlgorithmMinGoodFICBERLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEnsembleQualityAlgorithmMinGoodFICBERLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Enable") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEnable(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "QuickHideEnsemble") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetQuickHideEnsemble(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RealUnlearnEnsemble") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRealUnlearnEnsemble(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "UseForShowingNotReceiveableIndicator") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUseForShowingNotReceiveableIndicator(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "UseForClearingNotReceiveableIndicator") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUseForClearingNotReceiveableIndicator(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BackgroundSnooping2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBackgroundSnooping2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BackgroundSnoopingUnlearnFieldstrength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBackgroundSnoopingUnlearnFieldstrength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BackgroundSnoopingLearnCounterMaxValue") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBackgroundSnoopingLearnCounterMaxValue(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BackgroundSnoopingLearnCounterValue") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBackgroundSnoopingLearnCounterValue(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BackgroundSnoopingUnlearnCounterValue") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBackgroundSnoopingUnlearnCounterValue(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BackgroundSnoopingUnlearnCounterMinValue") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBackgroundSnoopingUnlearnCounterMinValue(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ResumeInterruptedAnnouncement") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetResumeInterruptedAnnouncement(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SearchUpScan") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSearchUpScan(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ScanStationList") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetScanStationList(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SupressDoubleServices") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSupressDoubleServices(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "UseMinSignalQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUseMinSignalQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "UseMinAudioQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUseMinAudioQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "UseMinPlayDuration") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUseMinPlayDuration(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ScanForever") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetScanForever(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SelectLastScannedServiceWhenLSMIsNotAvailable1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSelectLastScannedServiceWhenLSMIsNotAvailable1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ScanMinSignalQuality") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetScanMinSignalQuality(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ScanAudioThreshold") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetScanAudioThreshold(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PlayDuration") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPlayDuration(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EnsembleListSorting") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEnsembleListSorting(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ServiceListSorting") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetServiceListSorting(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ComponentListSorting") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetComponentListSorting(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaximumNumberOfStation") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaximumNumberOfStation(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ComponentsIncludedInStationList") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetComponentsIncludedInStationList(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "32x32") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8Get32x32(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "112x32") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8Get112x32(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "128x128") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8Get128x128(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "320x240") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8Get320x240(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimerConfigTFMDABSWITCHMUTEDABMs") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimerConfigTFMDABSWITCHMUTEDABMs(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimerConfigTFMDABSWITCHMUTEDABPLUSMs") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimerConfigTFMDABSWITCHMUTEDABPLUSMs(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimerConfigTFMDABSWITCHMUTEDMBAMs") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimerConfigTFMDABSWITCHMUTEDMBAMs(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimerConfigTBGLEARNSTARTS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimerConfigTBGLEARNSTARTS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimerConfigTLEARNSTARTSFOFFS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimerConfigTLEARNSTARTSFOFFS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimerConfigTMANMODESFOFFS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimerConfigTMANMODESFOFFS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimerConfigTSTATIONSELECTSFOFFS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimerConfigTSTATIONSELECTSFOFFS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimerConfigTSLSSIGNALLOSTS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimerConfigTSLSSIGNALLOSTS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimerConfigTCLEARRTDELAYS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimerConfigTCLEARRTDELAYS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TimerConfigTCLEARRTAFTERSYNCLOSTS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTimerConfigTCLEARRTAFTERSYNCLOSTS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LSMConfigEID") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLSMConfigEID(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LSMConfigEnsembleLabel") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLSMConfigEnsembleLabel(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LSMConfigEnsembleShortLabelMask") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLSMConfigEnsembleShortLabelMask(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LSMConfigSID") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLSMConfigSID(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LSMConfigServiceLabel") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLSMConfigServiceLabel(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LSMConfigServiceShortLabelMask") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLSMConfigServiceShortLabelMask(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LSMConfigComponentID") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLSMConfigComponentID(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LSMConfigComponentLabel") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLSMConfigComponentLabel(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LSMConfigComponentShortLabelMask") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLSMConfigComponentShortLabelMask(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LSMConfigChannel") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLSMConfigChannel(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TunerBand1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTunerBand1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TunerBand2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTunerBand2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "AntennaParameter") == 0) 
    {
        dp_tclKdsAntennaParameter oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaParameter(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Tag") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTag(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MajorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMajorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinorVersion") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinorVersion(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1Type") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1Type(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1Open") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1Open(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1OpenClear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1OpenClear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1ConsiderVoltageForOpen") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1ConsiderVoltageForOpen(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1ConsiderIgnitionForOpen") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1ConsiderIgnitionForOpen(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1OpenAmplifier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1OpenAmplifier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1OpenAmplifierClearLow") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1OpenAmplifierClearLow(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1OpenAmplifierClearHigh") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1OpenAmplifierClearHigh(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1ConsiderVoltageForOpenAmplidier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1ConsiderVoltageForOpenAmplidier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1ConsiderIgnitionForOpenAmplifier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1ConsiderIgnitionForOpenAmplifier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1Short") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1Short(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1ShortClear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1ShortClear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1ConsiderVoltageForShort") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1ConsiderVoltageForShort(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1ConsiderIgnitionForShort") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1ConsiderIgnitionForShort(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1MonitorCycle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1MonitorCycle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1NoOfMonitorCycle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1NoOfMonitorCycle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1ShortCircuitWait") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1ShortCircuitWait(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM1ConsiderCriticalHighVoltage") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM1ConsiderCriticalHighVoltage(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2Type") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2Type(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2Open") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2Open(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2OpenClear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2OpenClear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2ConsiderVoltageForOpen") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2ConsiderVoltageForOpen(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2ConsiderIgnitionForOpen") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2ConsiderIgnitionForOpen(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2OpenAmplifier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2OpenAmplifier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2OpenAmplifierClearLow") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2OpenAmplifierClearLow(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2OpenAmplifierClearHigh") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2OpenAmplifierClearHigh(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2ConsiderVoltageForOpenAmplidier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2ConsiderVoltageForOpenAmplidier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2ConsiderIgnitionForOpenAmplifier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2ConsiderIgnitionForOpenAmplifier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2Short") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2Short(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2ShortClear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2ShortClear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2ConsiderVoltageForShort") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2ConsiderVoltageForShort(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2ConsiderIgnitionForShort") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2ConsiderIgnitionForShort(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2MonitorCycle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2MonitorCycle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2NoOfMonitorCycle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2NoOfMonitorCycle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2ShortCircuitWait") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2ShortCircuitWait(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaFM2ConsiderCriticalHighVoltage") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaFM2ConsiderCriticalHighVoltage(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1Type") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1Type(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1Open") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1Open(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1OpenClear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1OpenClear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1ConsiderVoltageForOpen") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1ConsiderVoltageForOpen(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1ConsiderIgnitionForOpen") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1ConsiderIgnitionForOpen(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1OpenAmplifier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1OpenAmplifier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1OpenAmplifierClearLow") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1OpenAmplifierClearLow(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1OpenAmplifierClearHigh") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1OpenAmplifierClearHigh(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1ConsiderVoltageForOpenAmplidier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1ConsiderVoltageForOpenAmplidier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1ConsiderIgnitionForOpenAmplifier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1ConsiderIgnitionForOpenAmplifier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1Short") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1Short(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1ShortClear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1ShortClear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1ConsiderVoltageForShort") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1ConsiderVoltageForShort(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1ConsiderIgnitionForShort") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1ConsiderIgnitionForShort(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1MonitorCycle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1MonitorCycle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1NoOfMonitorCycle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1NoOfMonitorCycle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1ShortCircuitWait") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1ShortCircuitWait(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaDAB1ConsiderCriticalHighVoltage") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaDAB1ConsiderCriticalHighVoltage(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSOpen") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSOpen(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSOpenClear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSOpenClear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSConsiderVoltageForOpen") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSConsiderVoltageForOpen(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSConsiderIgnitionForOpen") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSConsiderIgnitionForOpen(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSOpenAmplifier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSOpenAmplifier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSOpenAmplifierClearLow") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSOpenAmplifierClearLow(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSOpenAmplifierClearHigh") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSOpenAmplifierClearHigh(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSConsiderVoltageForOpenAmplidier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSConsiderVoltageForOpenAmplidier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSConsiderIgnitionForOpenAmplifier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSConsiderIgnitionForOpenAmplifier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSShort") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSShort(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSShortClear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSShortClear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSConsiderVoltageForShort") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSConsiderVoltageForShort(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSConsiderIgnitionForShort") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSConsiderIgnitionForShort(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSMonitorCycle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSMonitorCycle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSNoOfMonitorCycle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSNoOfMonitorCycle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSShortCircuitWait") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSShortCircuitWait(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaGPSConsiderCriticalHighVoltage") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaGPSConsiderCriticalHighVoltage(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12Type") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12Type(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12Open") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12Open(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12OpenClear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12OpenClear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12ConsiderVoltageForOpen") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12ConsiderVoltageForOpen(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12ConsiderIgnitionForOpen") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12ConsiderIgnitionForOpen(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12OpenAmplifier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12OpenAmplifier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12OpenAmplifierClearLow") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12OpenAmplifierClearLow(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12OpenAmplifierClearHigh") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12OpenAmplifierClearHigh(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12ConsiderVoltageForOpenAmplifier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12ConsiderVoltageForOpenAmplifier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12ConsiderIgnitionForOpenAmplifier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12ConsiderIgnitionForOpenAmplifier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12Short") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12Short(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12ShortClear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12ShortClear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12ConsiderVoltageForShort") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12ConsiderVoltageForShort(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12ConsiderIgnitionForShort") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12ConsiderIgnitionForShort(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12MonitorCycle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12MonitorCycle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12NoOfMonitorCycle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12NoOfMonitorCycle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12ShortCircuitWait") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12ShortCircuitWait(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV12ConsiderCriticalHighVoltage") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV12ConsiderCriticalHighVoltage(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34Type") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34Type(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34Open") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34Open(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34OpenClear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34OpenClear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34ConsiderVoltageForOpen") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34ConsiderVoltageForOpen(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34ConsiderIgnitionForOpen") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34ConsiderIgnitionForOpen(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34OpenAmplifier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34OpenAmplifier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34OpenAmplifierClearLow") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34OpenAmplifierClearLow(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34OpenAmplifierClearHigh") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34OpenAmplifierClearHigh(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34ConsiderVoltageForOpenAmplifier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34ConsiderVoltageForOpenAmplifier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34ConsiderIgnitionForOpenAmplifier") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34ConsiderIgnitionForOpenAmplifier(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34Short") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34Short(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34ShortClear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34ShortClear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34ConsiderVoltageForShort") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34ConsiderVoltageForShort(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34ConsiderIgnitionForShort") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34ConsiderIgnitionForShort(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34MonitorCycle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34MonitorCycle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34NoOfMonitorCycle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34NoOfMonitorCycle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34ShortCircuitWait") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34ShortCircuitWait(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AntennaTV34ConsiderCriticalHighVoltage") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAntennaTV34ConsiderCriticalHighVoltage(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "SystemConfiguration1") == 0) 
    {
        dp_tclKdsSystemConfiguration1 oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSystemConfiguration1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "UCANUpdateMethod") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUCANUpdateMethod(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SupportedDistanceUnits") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSupportedDistanceUnits(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DefaultDistanceUnits") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDefaultDistanceUnits(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SupportedTemperatureUnit") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSupportedTemperatureUnit(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DefaultTemperatureUnit") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDefaultTemperatureUnit(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DefaultLanguage") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDefaultLanguage(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ShowClock") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetShowClock(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Clock1224h") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetClock1224h(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MeterClockSynchronisation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMeterClockSynchronisation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ClockSynchronisationSource") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetClockSynchronisationSource(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EcoScoreDisplay") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEcoScoreDisplay(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "OffRoadInformation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetOffRoadInformation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Brand") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBrand(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "OpeningAnimation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetOpeningAnimation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HEVInformationFunction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHEVInformationFunction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HEVDriveType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHEVDriveType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SoundOnEncoderPress") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSoundOnEncoderPress(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EcoChallenge") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEcoChallenge(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EcoFunction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEcoFunction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SpeedLockRestrictions") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSpeedLockRestrictions(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SpeedLockMinThresholdForUseRestrictionKmH") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSpeedLockMinThresholdForUseRestrictionKmH(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SpeedLockMaxThresholdForUseRestrictionKmH") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSpeedLockMaxThresholdForUseRestrictionKmH(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TyrePressureResetRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTyrePressureResetRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeatRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeatRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayActivation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayActivation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ExtTempDisplayCfg") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetExtTempDisplayCfg(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PORT") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPORT(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ANCActivation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetANCActivation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESEActivation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESEActivation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VoiceRecognition") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVoiceRecognition(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VRBeepOnly") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVRBeepOnly(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VRShortPrompts") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVRShortPrompts(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TTS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTTS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AutoBargeIn") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAutoBargeIn(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "OutputInformation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetOutputInformation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TweeterSetup") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTweeterSetup(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SonarVolume") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSonarVolume(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SpeedCurve") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSpeedCurve(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AudioConfiguration") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAudioConfiguration(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DVDRegionCode") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDVDRegionCode(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BDRegionCode") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBDRegionCode(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AUX") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAUX(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MCH1MountInformation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMCH1MountInformation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AMTunerActivation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAMTunerActivation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DAB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDAB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CMFSupportForETC") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCMFSupportForETC(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "WifiFunction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWifiFunction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BluetoothFunction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBluetoothFunction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "WiFiIVCTethering") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWiFiIVCTethering(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CarPlay") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCarPlay(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AndroidAuto") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAndroidAuto(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MySPIN") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMySPIN(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ATbox") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetATbox(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ModelYear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetModelYear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Wifi5GHZSupport") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWifi5GHZSupport(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "OnCar") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetOnCar(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TruckLCVRoute") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTruckLCVRoute(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VehicleFleet") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVehicleFleet(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinimizeUnpavedRoads") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinimizeUnpavedRoads(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "KindOfDestinationEntry") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetKindOfDestinationEntry(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Disclaimer") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisclaimer(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MapZoom") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMapZoom(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MQTTPayloadCompression") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMQTTPayloadCompression(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AutomaticPhoneBookTransfer") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAutomaticPhoneBookTransfer(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BTVR") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBTVR(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "WBS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWBS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VAOnShortpress") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVAOnShortpress(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MQTTSessionType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMQTTSessionType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CNFCHGSTNFIND") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCNFCHGSTNFIND(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CNFCHGSTNSORT") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCNFCHGSTNSORT(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CNFLOWBATALT") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCNFLOWBATALT(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CNFGUARDANG") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCNFGUARDANG(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CNFCHGTIMEFORECAST") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCNFCHGTIMEFORECAST(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CNFPSOC") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCNFPSOC(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CNFREROUTEALT") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCNFREROUTEALT(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CNFREACHAREA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCNFREACHAREA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "InfoFromMeterLimitedPower") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetInfoFromMeterLimitedPower(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "InfoFromMeterDCDCCaution") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetInfoFromMeterDCDCCaution(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TIMERCHARGING") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTIMERCHARGING(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TIMERPREAIRCONDITIONING") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTIMERPREAIRCONDITIONING(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EnergyHistoryConsumption") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEnergyHistoryConsumption(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RemoteApplicationSupport") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRemoteApplicationSupport(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EVPHEVRealTimeEnergyFlowDisplay") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEVPHEVRealTimeEnergyFlowDisplay(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EVPHEVEnergyFlow15mnHistoricalGraph") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEVPHEVEnergyFlow15mnHistoricalGraph(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EnergyInformation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEnergyInformation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PowerConsumptionInformation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPowerConsumptionInformation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PreConditioningDurationVehicleNotPlugged") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreConditioningDurationVehicleNotPlugged(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PreConditioningMedianTemperatureRequest") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreConditioningMedianTemperatureRequest(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SkinChoiceComfort1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSkinChoiceComfort1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CarType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCarType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SkinChoiceComfort12") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSkinChoiceComfort12(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SkinChoiceEco1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSkinChoiceEco1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SkinChoiceDynamic1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSkinChoiceDynamic1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SkinChoiceNormal1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSkinChoiceNormal1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SkinChoicePerso1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSkinChoicePerso1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MexSwitchIntensityWithoutAmbientLighting") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMexSwitchIntensityWithoutAmbientLighting(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PreferentialMode2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreferentialMode2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PreferentialMode1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPreferentialMode1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DualModeMgt") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDualModeMgt(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESoundVolumeComfort") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESoundVolumeComfort(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESoundVolumeEco1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESoundVolumeEco1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESoundVolumeDynamic1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESoundVolumeDynamic1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESoundVolumeNormal") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESoundVolumeNormal(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESoundTypeEco1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESoundTypeEco1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESoundVolumePerso1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESoundVolumePerso1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESoundTypePerso1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESoundTypePerso1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESoundTypeDynamic1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESoundTypeDynamic1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESoundTypeNormal1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESoundTypeNormal1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESoundTypeComfort1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESoundTypeComfort1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESound1Name") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESound1Name(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESound2Name") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESound2Name(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESound1VolumeHMI") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESound1VolumeHMI(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESound2VolumeHMI") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESound2VolumeHMI(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESoundVolumeRace") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESoundVolumeRace(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESEHMI") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESEHMI(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "WirelessAndroidAutoFunction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWirelessAndroidAutoFunction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CNFVPA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCNFVPA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESoundTypeRace1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESoundTypeRace1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TouchScreenConfiguration") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTouchScreenConfiguration(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BaiduCarLifeFunction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBaiduCarLifeFunction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "WirelessCarPlayFunction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWirelessCarPlayFunction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HVACType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHVACType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaintenanceInfoFunction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaintenanceInfoFunction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VDCSetting") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVDCSetting(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VehicleSetting") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVehicleSetting(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DigitalAssistant") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDigitalAssistant(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HVACTemperature") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHVACTemperature(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FOTABearer") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFOTABearer(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MassageBehaviorInPowerState") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMassageBehaviorInPowerState(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "ThermalManagmentTemperatureThresholds") == 0) 
    {
        dp_tclKdsThermalManagmentTemperatureThresholds oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetThermalManagmentTemperatureThresholds(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Version") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SensorID1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSensorID1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaximumTemperature1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaximumTemperature1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinimumTemperature1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinimumTemperature1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalHighTemperature1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalHighTemperature1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalHighTemperatureHysteresis1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalHighTemperatureHysteresis1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalHighTemperatureTimeDelay1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalHighTemperatureTimeDelay1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighTemperature1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighTemperature1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighTemperatureHysteresis1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighTemperatureHysteresis1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighTemperatureTimeDelay1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighTemperatureTimeDelay1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowTemperature1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowTemperature1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowTemperatureHysteresis1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowTemperatureHysteresis1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowTemperatureTimeDelay1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowTemperatureTimeDelay1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalLowTemperature1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalLowTemperature1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalLowTemperatureHysteresis1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalLowTemperatureHysteresis1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalLowTemperatureTimeDelay1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalLowTemperatureTimeDelay1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SensorID2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSensorID2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaximumTemperature2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaximumTemperature2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinimumTemperature2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinimumTemperature2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalHighTemperature2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalHighTemperature2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalHighTemperatureHysteresis2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalHighTemperatureHysteresis2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalHighTemperatureTimeDelay2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalHighTemperatureTimeDelay2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighTemperature2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighTemperature2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighTemperatureHysteresis2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighTemperatureHysteresis2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighTemperatureTimeDelay2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighTemperatureTimeDelay2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowTemperature2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowTemperature2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowTemperatureHysteresis2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowTemperatureHysteresis2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowTemperatureTimeDelay2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowTemperatureTimeDelay2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalLowTemperature2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalLowTemperature2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalLowTemperatureHysteresis2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalLowTemperatureHysteresis2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalLowTemperatureTimeDelay2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalLowTemperatureTimeDelay2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SensorID3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSensorID3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaximumTemperature3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaximumTemperature3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinimumTemperature3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinimumTemperature3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalHighTemperature3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalHighTemperature3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalHighTemperatureHysteresis3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalHighTemperatureHysteresis3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalHighTemperatureTimeDelay3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalHighTemperatureTimeDelay3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighTemperature3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighTemperature3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighTemperatureHysteresis3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighTemperatureHysteresis3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighTemperatureTimeDelay3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighTemperatureTimeDelay3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowTemperature3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowTemperature3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowTemperatureHysteresis3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowTemperatureHysteresis3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowTemperatureTimeDelay3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowTemperatureTimeDelay3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalLowTemperature3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalLowTemperature3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalLowTemperatureHysteresis3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalLowTemperatureHysteresis3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalLowTemperatureTimeDelay3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalLowTemperatureTimeDelay3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SensorID4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSensorID4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaximumTemperature4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaximumTemperature4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinimumTemperature4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinimumTemperature4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalHighTemperature4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalHighTemperature4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalHighTemperatureHysteresis4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalHighTemperatureHysteresis4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalHighTemperatureTimeDelay4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalHighTemperatureTimeDelay4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighTemperature4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighTemperature4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighTemperatureHysteresis4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighTemperatureHysteresis4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighTemperatureTimeDelay4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighTemperatureTimeDelay4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowTemperature4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowTemperature4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowTemperatureHysteresis4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowTemperatureHysteresis4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowTemperatureTimeDelay4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowTemperatureTimeDelay4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalLowTemperature4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalLowTemperature4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalLowTemperatureHysteresis4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalLowTemperatureHysteresis4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalLowTemperatureTimeDelay4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalLowTemperatureTimeDelay4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SensorID5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSensorID5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaximumTemperature5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaximumTemperature5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinimumTemperature5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinimumTemperature5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalHighTemperature5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalHighTemperature5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalHighTemperatureHysteresis5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalHighTemperatureHysteresis5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalHighTemperatureTimeDelay5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalHighTemperatureTimeDelay5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighTemperature5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighTemperature5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighTemperatureHysteresis5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighTemperatureHysteresis5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HighTemperatureTimeDelay5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHighTemperatureTimeDelay5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowTemperature5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowTemperature5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowTemperatureHysteresis5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowTemperatureHysteresis5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowTemperatureTimeDelay5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowTemperatureTimeDelay5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalLowTemperature5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalLowTemperature5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalLowTemperatureHysteresis5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalLowTemperatureHysteresis5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CriticalLowTemperatureTimeDelay5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCriticalLowTemperatureTimeDelay5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "DimmingParameter") == 0) 
    {
        dp_tclKdsDimmingParameter oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDimmingParameter(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MajorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMajorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC6") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC6(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC7") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC7(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC8") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC8(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC9") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC9(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC10") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC10(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC11") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC11(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC12") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC12(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC13") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC13(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC14") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC14(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC15") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC15(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC16") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC16(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC17") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC17(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC18") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC18(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC19") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC19(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC20") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC20(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC21") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC21(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC22") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC22(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC23") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC23(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC24") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC24(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC25") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC25(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC26") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC26(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC27") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC27(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC28") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC28(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC29") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC29(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC30") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC30(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC31") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC31(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC32") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC32(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMINIGHTC33") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMINIGHTC33(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC6") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC6(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC7") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC7(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC8") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC8(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC9") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC9(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC10") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC10(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC11") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC11(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC12") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC12(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC13") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC13(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC14") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC14(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC15") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC15(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC16") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC16(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC17") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC17(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC18") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC18(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC19") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC19(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC20") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC20(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC21") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC21(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC22") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC22(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC23") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC23(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC24") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC24(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC25") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC25(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC26") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC26(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC27") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC27(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC28") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC28(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC29") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC29(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC30") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC30(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC31") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC31(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC32") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC32(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSCURVEHMIDAYC33") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSCURVEHMIDAYC33(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DISPLAYILLUMINATIONOUTPUTFREQUENCY") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDISPLAYILLUMINATIONOUTPUTFREQUENCY(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "KEYSENCODERILLUMINATIONOUTPUTFREQUENCY") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetKEYSENCODERILLUMINATIONOUTPUTFREQUENCY(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TEMPCOMPENSATIONPWMMIN") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTEMPCOMPENSATIONPWMMIN(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NUMBEROFKEYS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNUMBEROFKEYS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HIGHTEMPERATURE") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHIGHTEMPERATURE(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CRITICALTEMPERATURE") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCRITICALTEMPERATURE(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LOWTEMPERATURE") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLOWTEMPERATURE(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSNOOFHMIOFFSET") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSNOOFHMIOFFSET(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TEMPHYSTERESIS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTEMPHYSTERESIS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LIGHTNINGTIMINGDELAY") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLIGHTNINGTIMINGDELAY(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "KEYBRIGHTNESSNUMOFOFFSETS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetKEYBRIGHTNESSNUMOFOFFSETS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SOFTDIMMINGENABLED") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSOFTDIMMINGENABLED(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SOFTDIMMINGSAMPLINGTIME") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSOFTDIMMINGSAMPLINGTIME(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SOFTDIMMINGCONSTANTK") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSOFTDIMMINGCONSTANTK(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SOFTDIMMINGCONSTANTJ") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSOFTDIMMINGCONSTANTJ(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSBACKLIGHTDAYBUTTONSDAY1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSBACKLIGHTDAYBUTTONSDAY1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSBACKLIGHTDAYBUTTONSNIGHT1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSBACKLIGHTDAYBUTTONSNIGHT1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSBACKLIGHTNIGHTBUTTONSNIGHT1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSBACKLIGHTNIGHTBUTTONSNIGHT1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSBACKLIGHTDAYBUTTONSON") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSBACKLIGHTDAYBUTTONSON(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSBACKLIGHTDAYBUTTONSOFF1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSBACKLIGHTDAYBUTTONSOFF1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BRIGTHNESSBACKLIGHTNIGHTBUTTONSON21") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBRIGTHNESSBACKLIGHTNIGHTBUTTONSON21(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "KEYILLUMINATIONMODE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetKEYILLUMINATIONMODE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "InputKeyMappingTable_1") == 0) 
    {
        dp_tclKdsInputKeyMappingTable_1 oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetInputKeyMappingTable_1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MajorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMajorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinorVersion") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinorVersion(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NrOfEntries") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNrOfEntries(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID6") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID6(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID6") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID6(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID7") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID7(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID7") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID7(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID8") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID8(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID8") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID8(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID9") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID9(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID9") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID9(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID10") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID10(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID10") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID10(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID11") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID11(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID11") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID11(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID12") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID12(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID12") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID12(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID13") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID13(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID13") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID13(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID14") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID14(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID14") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID14(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID15") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID15(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID15") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID15(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID16") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID16(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID16") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID16(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID17") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID17(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID17") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID17(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID18") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID18(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID18") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID18(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID19") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID19(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID19") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID19(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID20") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID20(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID20") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID20(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID21") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID21(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID21") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID21(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID22") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID22(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID22") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID22(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID23") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID23(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID23") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID23(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID24") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID24(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID24") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID24(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID25") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID25(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID25") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID25(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID26") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID26(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID26") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID26(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID27") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID27(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID27") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID27(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID28") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID28(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID28") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID28(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID29") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID29(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID29") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID29(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID30") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID30(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID30") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID30(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID31") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID31(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID31") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID31(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID32") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID32(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID32") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID32(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "CMVariantCoding") == 0) 
    {
        dp_tclKdsCMVariantCoding oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCMVariantCoding(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DiagnosisExtendedDataConsistencyCheck") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDiagnosisExtendedDataConsistencyCheck(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "InterfaceLock") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetInterfaceLock(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "OEMType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetOEMType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Bluetooth") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBluetooth(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RVC") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRVC(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CD") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCD(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "XMTuner") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetXMTuner(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DAB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDAB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HDRadio") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHDRadio(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DVD") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDVD(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADR3VariantInfo") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADR3VariantInfo(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADR3FlashVariantInfo") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADR3FlashVariantInfo(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USBInfo") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSBInfo(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AUXInfo") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAUXInfo(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMAntenna1Info") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMAntenna1Info(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FMAntenna2Info") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFMAntenna2Info(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DABAntenna1Info") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDABAntenna1Info(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DABAntenna2Info") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDABAntenna2Info(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GPSAntenna1Info") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGPSAntenna1Info(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB1ExtendedInfo") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB1ExtendedInfo(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB2ExtendedInfo") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB2ExtendedInfo(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FAN") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFAN(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GNSS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGNSS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GYRO") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGYRO(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ACC") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetACC(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BDDrive") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBDDrive(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DRM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDRM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RTC") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRTC(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "WIFI") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWIFI(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DTV") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDTV(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ArkamysClassicSupport") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetArkamysClassicSupport(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ArkamysAuditoriumSupport") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetArkamysAuditoriumSupport(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ESESupport") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetESESupport(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SensorGyroSource") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSensorGyroSource(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SensorACCSource") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSensorACCSource(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TVAntenna1Info") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTVAntenna1Info(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TVAntenna2Info") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTVAntenna2Info(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TVAntenna3Info") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTVAntenna3Info(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TVAntenna4Info") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTVAntenna4Info(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SensorOdoSource") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSensorOdoSource(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SensorReverseSource") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSensorReverseSource(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SensorGnssSource") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSensorGnssSource(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DVDRegionCode") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDVDRegionCode(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BDRegionCode") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBDRegionCode(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "WIFIFCCType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWIFIFCCType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "NavDefaultPos") == 0) 
    {
        dp_tclKdsNavDefaultPos oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNavDefaultPos(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Longitude") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLongitude(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Latitude") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLatitude(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Heading") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHeading(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "NavigationDataCopyProtectionSecurityECCKey") == 0) 
    {
        dp_tclKdsNavigationDataCopyProtectionSecurityECCKey oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNavigationDataCopyProtectionSecurityECCKey(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Key") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetKey(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "SWUPD_VariantInfo") == 0) 
    {
        dp_tclKdsSWUPD_VariantInfo oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSWUPD_VariantInfo(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ConfigurationVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetConfigurationVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SoftwareVariantTag") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSoftwareVariantTag(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "DeviceManager") == 0) 
    {
        dp_tclKdsDeviceManager oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDeviceManager(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Tag") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTag(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MajorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMajorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinorVersion") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinorVersion(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Subvariant") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSubvariant(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "IndividualSettingsFollows") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetIndividualSettingsFollows(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ChipConnector1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetChipConnector1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ChipConnector2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetChipConnector2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ChipConnector3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetChipConnector3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ChipConnector4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetChipConnector4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HwUSB1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHwUSB1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HwUSB2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHwUSB2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HwUSB3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHwUSB3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HwUSB4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHwUSB4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ChipConnector1AllowHub") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetChipConnector1AllowHub(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ChipConnector2AllowHub") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetChipConnector2AllowHub(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ChipConnector3AllowHub") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetChipConnector3AllowHub(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ChipConnector4AllowHub") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetChipConnector4AllowHub(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB12") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB12(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB22") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB22(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB32") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB32(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB42") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB42(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB13") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB13(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB23") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB23(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB33") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB33(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB43") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB43(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB14") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB14(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB24") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB24(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB34") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB34(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB44") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB44(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB15") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB15(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB25") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB25(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB35") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB35(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB45") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB45(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Monitoring") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMonitoring(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB16") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB16(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB26") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB26(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB36") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB36(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB46") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB46(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB17") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB17(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB27") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB27(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB37") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB37(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "USB47") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUSB47(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FAT") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFAT(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NTFS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNTFS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EXTFAT") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEXTFAT(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HFSPlus") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHFSPlus(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Ext34FS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetExt34FS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ISO9660") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetISO9660(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "UDF") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUDF(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "UnsupportedDeviceType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUnsupportedDeviceType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "UnsupportedFileSystem") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUnsupportedFileSystem(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "UnsupportedHub") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUnsupportedHub(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AllPartitions") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAllPartitions(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MSDBiggestPartition") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMSDBiggestPartition(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SortAllPartitions") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSortAllPartitions(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ExternalSD") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetExternalSD(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ExternalUSB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetExternalUSB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ExternalMTP") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetExternalMTP(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ExternalIPOD") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetExternalIPOD(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ExternalIPAD") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetExternalIPAD(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ExternalIPHONE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetExternalIPHONE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "InternalCDROM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetInternalCDROM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "InternalCDDA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetInternalCDDA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "InternalSDCARD") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetInternalSDCARD(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ExternalDIGIAUX") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetExternalDIGIAUX(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ExternalBTA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetExternalBTA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ExternalUnsupported") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetExternalUnsupported(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ChargeAppledevs") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetChargeAppledevs(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "MediaPlayer") == 0) 
    {
        dp_tclKdsMediaPlayer oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMediaPlayer(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RegistryFile") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRegistryFile(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "Display") == 0) 
    {
        dp_tclKdsDisplay oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplay(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayOrientation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayOrientation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumOfPixelsX") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumOfPixelsX(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumOfPixelsY") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumOfPixelsY(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PixelSizeX") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPixelSizeX(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PixelSizeY") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPixelSizeY(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplaySizeX") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplaySizeX(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplaySizeY") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplaySizeY(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayTouchTechnology") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayTouchTechnology(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayTouchFeature") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayTouchFeature(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayType2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayType2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayOrientation2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayOrientation2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumOfPixelsX2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumOfPixelsX2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumOfPixelsY2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumOfPixelsY2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PixelSizeX2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPixelSizeX2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PixelSizeY2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPixelSizeY2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplaySizeX2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplaySizeX2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplaySizeY2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplaySizeY2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayTouchTechnology2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayTouchTechnology2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayTouchFeature2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayTouchFeature2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayType3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayType3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayOrientation3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayOrientation3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumOfPixelsX3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumOfPixelsX3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumOfPixelsY3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumOfPixelsY3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PixelSizeX3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPixelSizeX3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PixelSizeY3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPixelSizeY3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplaySizeX3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplaySizeX3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplaySizeY3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplaySizeY3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayTouchTechnology3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayTouchTechnology3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayTouchFeature3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayTouchFeature3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayType4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayType4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayOrientation4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayOrientation4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumOfPixelsX4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumOfPixelsX4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumOfPixelsY4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumOfPixelsY4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PixelSizeX4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPixelSizeX4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PixelSizeY4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPixelSizeY4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplaySizeX4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplaySizeX4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplaySizeY4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplaySizeY4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayTouchTechnology4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayTouchTechnology4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayTouchFeature4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayTouchFeature4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayType5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayType5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayOrientation5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayOrientation5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumOfPixelsX5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumOfPixelsX5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumOfPixelsY5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumOfPixelsY5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PixelSizeX5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPixelSizeX5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PixelSizeY5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPixelSizeY5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplaySizeX5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplaySizeX5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplaySizeY5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplaySizeY5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayTouchTechnology5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayTouchTechnology5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayTouchFeature5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayTouchFeature5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "CameraSystem") == 0) 
    {
        dp_tclKdsCameraSystem oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraSystem(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ConfigStringVersionMajor") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetConfigStringVersionMajor(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ConfigStringVersionMinor") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetConfigStringVersionMinor(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VehicleWidth") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVehicleWidth(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "WheelBase") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWheelBase(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RearOverhang") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRearOverhang(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SteerWheelCalibF1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSteerWheelCalibF1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SteerWheelCalibF3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSteerWheelCalibF3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxSteerWheelAngle") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxSteerWheelAngle(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxRearWheelAngle") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxRearWheelAngle(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RadiusTuningFact") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRadiusTuningFact(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FourWheelSteering") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFourWheelSteering(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TireAngleTurnSense") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTireAngleTurnSense(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TireAngleReferencePoint") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTireAngleReferencePoint(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GuidelineStyle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGuidelineStyle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TestConfigOnlyFlag") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTestConfigOnlyFlag(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CamXOffset") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCamXOffset(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CamYOffset") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCamYOffset(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CamZOffset") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCamZOffset(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CamYaw") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCamYaw(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CamPitch") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCamPitch(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CamRoll") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCamRoll(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FrontTireThresh") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFrontTireThresh(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinFrontTireChange") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinFrontTireChange(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RearTireThresh") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRearTireThresh(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinRearTireChange") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinRearTireChange(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GuidelineStartDistance") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGuidelineStartDistance(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GuidelineSideMargin") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGuidelineSideMargin(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RgbColorStaticSideNearR") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRgbColorStaticSideNearR(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RgbColorStaticSideNearG") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRgbColorStaticSideNearG(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RgbColorStaticSideNearB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRgbColorStaticSideNearB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RgbColorStaticSideMidR") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRgbColorStaticSideMidR(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RgbColorStaticSideMidG") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRgbColorStaticSideMidG(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RgbColorStaticSideMidB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRgbColorStaticSideMidB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RgbColorStaticSideFarR") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRgbColorStaticSideFarR(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RgbColorStaticSideFarG") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRgbColorStaticSideFarG(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RgbColorStaticSideFarB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRgbColorStaticSideFarB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RgbColorStaticCenterR") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRgbColorStaticCenterR(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RgbColorStaticCenterG") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRgbColorStaticCenterG(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RgbColorStaticCenterB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRgbColorStaticCenterB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RgbColorDynamicR") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRgbColorDynamicR(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RgbColorDynamicG") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRgbColorDynamicG(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RgbColorDynamicB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRgbColorDynamicB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LineWidthStaticSideNear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLineWidthStaticSideNear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LineWidthStaticSideFar") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLineWidthStaticSideFar(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LineWidthDynamicNear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLineWidthDynamicNear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LineWidthDynamicFar") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLineWidthDynamicFar(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LineWidthStaticCenterNear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLineWidthStaticCenterNear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LineWidthStaticCenterFar") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLineWidthStaticCenterFar(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StaticLineLengthNear") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStaticLineLengthNear(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StaticLineLengthMid") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStaticLineLengthMid(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StaticLineLengthFar1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStaticLineLengthFar1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StaticLineLengthFar2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStaticLineLengthFar2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StaticHorizLineLength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStaticHorizLineLength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LineWidthFactorNearHLine") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLineWidthFactorNearHLine(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningStringVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningStringVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningMethod") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningMethod(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningDeltaCamYaw") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningDeltaCamYaw(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningDeltaCamPitch") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningDeltaCamPitch(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningDeltaCamRoll") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningDeltaCamRoll(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningDeltaXNearLeft") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningDeltaXNearLeft(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningDeltaYNearLeft") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningDeltaYNearLeft(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningDeltaXFarLeft") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningDeltaXFarLeft(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningDeltaXNearRight") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningDeltaXNearRight(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningDeltaYNearRight") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningDeltaYNearRight(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningDeltaXFarRight") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningDeltaXFarRight(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningNearLineLengthLeft") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningNearLineLengthLeft(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningNearLineLengthRight") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningNearLineLengthRight(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningSwaZeroPointOffset") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningSwaZeroPointOffset(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningRwaZeroPointOffset") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningRwaZeroPointOffset(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AnticipatoryLine") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAnticipatoryLine(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraSystem") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraSystem(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraConnection") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraConnection(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SonarSystemAvailability") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSonarSystemAvailability(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SonarSwitchDisplay") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSonarSwitchDisplay(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SonarMenu") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSonarMenu(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SonarType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSonarType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SonarAVM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSonarAVM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SonarDisplay") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSonarDisplay(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SonarSound") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSonarSound(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SonarFKP") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSonarFKP(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SonarVehicleImage") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSonarVehicleImage(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraBrightnessDay") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraBrightnessDay(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraBrightnessNight") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraBrightnessNight(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraSteeringMessage") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraSteeringMessage(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RVCLensParameter") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRVCLensParameter(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "VehicleInformation") == 0) 
    {
        dp_tclKdsVehicleInformation oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVehicleInformation(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DestinationRegion1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDestinationRegion1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VehicleType") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVehicleType(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "WeightOfVehicle") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWeightOfVehicle(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "WidthOfVehicle") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWidthOfVehicle(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HeightOfVehicle") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHeightOfVehicle(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LengthOfVehicle") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLengthOfVehicle(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VehicleBodyShape") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVehicleBodyShape(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SteeringPosition") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSteeringPosition(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DrivingType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDrivingType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TPMS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTPMS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FuelType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFuelType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PetrolType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPetrolType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PowerPlatform") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPowerPlatform(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VCANSupervision") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVCANSupervision(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TypeOfMeter") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTypeOfMeter(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VCANMCANGatewayForANCASC") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVCANMCANGatewayForANCASC(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VCANDiversity") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVCANDiversity(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SteeringSW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSteeringSW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "IntelligentSpeedAssist") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetIntelligentSpeedAssist(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "IPAHFP") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetIPAHFP(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CANActivationC1A") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCANActivationC1A(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RCSRearArmrestSwitch") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRCSRearArmrestSwitch(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Microphone") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMicrophone(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TrafficSignRecognition") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTrafficSignRecognition(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ITCommanderCentralSwitch") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetITCommanderCentralSwitch(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ExternalCDDrive") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetExternalCDDrive(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ETC20") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetETC20(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MediaPlayerExternalBDDVDCDPlayer") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMediaPlayerExternalBDDVDCDPlayer(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RSE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRSE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TCU") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTCU(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EVHVAC") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEVHVAC(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HEVShapeOfBody") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHEVShapeOfBody(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CPWakeUpStrategy") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCPWakeUpStrategy(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MotorEfficiency") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMotorEfficiency(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ReductionGearEfficiency") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetReductionGearEfficiency(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CdValue") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCdValue(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ChargingCableConnector") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetChargingCableConnector(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ChargingCableSpotSidePlug") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetChargingCableSpotSidePlug(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VehicleInlet") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVehicleInlet(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CNFCHGFACTYPE") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCNFCHGFACTYPE(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxMotorPowerOutput") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxMotorPowerOutput(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxMotorRegenerativePower") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxMotorRegenerativePower(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BlowerReductionRequest") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBlowerReductionRequest(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "EthernetInterface") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEthernetInterface(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RADIOSATELLITESWITCH") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRADIOSATELLITESWITCH(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HUD") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHUD(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "InductiveCharger") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetInductiveCharger(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FuelConsumptionInfo") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFuelConsumptionInfo(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HUDSetting") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHUDSetting(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NaviAvailableSettingHUD") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNaviAvailableSettingHUD(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LearningParkFunction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLearningParkFunction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RemoteParkFunction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRemoteParkFunction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TransmissionType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTransmissionType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MeterSeetingIcon") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMeterSeetingIcon(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SendingCountryInformation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSendingCountryInformation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SmartCharging") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSmartCharging(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ChargingCableGrouping") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetChargingCableGrouping(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "UnballastWarningTime") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUnballastWarningTime(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinTimeBeforeUnballast") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinTimeBeforeUnballast(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "UnballastCounter") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUnballastCounter(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADFunction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADFunction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraPictureColor") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraPictureColor(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DynamicLength") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDynamicLength(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningDeltaXFarLeftDyn") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningDeltaXFarLeftDyn(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "WarningTextPos") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWarningTextPos(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TuningDeltaXFarRightDyn") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTuningDeltaXFarRightDyn(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RearCameraActivation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRearCameraActivation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CropUp") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCropUp(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AdditionalRVCConfigurationItems") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAdditionalRVCConfigurationItems(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CropDown") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCropDown(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CropLeft") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCropLeft(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CropRight") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCropRight(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ReverseGearDebouncing") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetReverseGearDebouncing(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraPictureHoldingTime") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraPictureHoldingTime(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraPictureContrast") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraPictureContrast(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraRearTrunkBehaviour") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraRearTrunkBehaviour(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraPictureTint") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraPictureTint(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VehicleSpeedTooHigh") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVehicleSpeedTooHigh(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraImageMirror") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraImageMirror(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraPictureBlackLevelDay") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraPictureBlackLevelDay(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraPictureBlackLevelNight") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraPictureBlackLevelNight(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeatGuidanceDR") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeatGuidanceDR(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SeatGuidancePS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSeatGuidancePS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TrailerType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTrailerType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NumberOfAxes") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNumberOfAxes(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaximumLoadPerAxle") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaximumLoadPerAxle(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "SoundVolumeConfig") == 0) 
    {
        dp_tclKdsSoundVolumeConfig oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSoundVolumeConfig(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CptMinVolMinVal") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCptMinVolMinVal(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CptMinVolMaxVal") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCptMinVolMaxVal(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CptMaxVolMinVal") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCptMaxVolMinVal(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CptMaxVolMaxVal") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCptMaxVolMaxVal(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CabMinVolMinVal") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCabMinVolMinVal(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CabMinVolMaxVal") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCabMinVolMaxVal(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CabMaxVolMinVal") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCabMaxVolMinVal(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CabMaxVolMaxVal") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCabMaxVolMaxVal(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Loudness") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLoudness(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BeepClicLevel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBeepClicLevel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "HMIConfig") == 0) 
    {
        dp_tclKdsHMIConfig oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHMIConfig(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGClusterStyle") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGClusterStyle(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGColorSelection") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGColorSelection(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGDualzoneMonozone") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGDualzoneMonozone(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGRearClim") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGRearClim(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGHeatedWindscreen") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGHeatedWindscreen(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AIRFRESHNERCF") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAIRFRESHNERCF(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGSailingSettings") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGSailingSettings(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGDSISettings") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGDSISettings(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGSynchronize") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGSynchronize(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGRVCFixedGuidelines") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGRVCFixedGuidelines(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGRVCDynamicGuidelines") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGRVCDynamicGuidelines(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGHMD") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGHMD(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGHeatedVentilatedSeats") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGHeatedVentilatedSeats(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGSeatMassage") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGSeatMassage(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGMagicFolding") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGMagicFolding(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGMemoSeat") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGMemoSeat(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGFLOWSEDACTIVATION") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGFLOWSEDACTIVATION(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGIonizer") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGIonizer(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGFragance") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGFragance(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGAQSHistogram") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGAQSHistogram(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGAmbientLighting") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGAmbientLighting(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGRemoteEngineStart") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGRemoteEngineStart(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGDimmingStrategy") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGDimmingStrategy(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGOffBoardConsulting") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGOffBoardConsulting(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGEcoMode") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGEcoMode(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGSS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGSS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGVehicleMode") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGVehicleMode(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGDRIVECO") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGDRIVECO(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPURearWiper") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPURearWiper(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUAutoFrontWiper") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUAutoFrontWiper(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUFlashersVolumeSelection") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUFlashersVolumeSelection(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUMotorwayFlashersNb") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUMotorwayFlashersNb(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUFRWiperDrop") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUFRWiperDrop(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUSingleDoorOpening") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUSingleDoorOpening(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUAutoLockUp") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUAutoLockUp(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUHandFreeLockUnlock") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUHandFreeLockUnlock(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUWACSilentMode") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUWACSilentMode(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUWACAPRUN") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUWACAPRUN(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUMirrorsFolding") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUMirrorsFolding(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUAutoRelock") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUAutoRelock(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUAutoFMH") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUAutoFMH(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUWGS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUWGS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUDrivingSide") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUDrivingSide(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUAFS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUAFS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUADB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUADB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUAHLFunction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUAHLFunction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CfMPUALSThreshold") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCfMPUALSThreshold(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TPMSMMICF") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTPMSMMICF(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFG4WDHMI") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFG4WDHMI(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADASSR") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADASSR(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADASUTA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADASUTA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADASDW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADASDW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADASDangerousArea") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADASDangerousArea(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADASAEB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADASAEB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADASOSP") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADASOSP(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADASLKA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADASLKA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADASLDW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADASLDW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADASBSW") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADASBSW(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADASPSM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADASPSM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGADASAPA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGADASAPA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADASFKP") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADASFKP(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADASUPAAudio") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADASUPAAudio(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayFormat") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayFormat(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ADASUPAVisual") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetADASUPAVisual(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGAM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGAM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VolumePopupPosition") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVolumePopupPosition(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGAUDIOSpeakers") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGAUDIOSpeakers(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TyrePressureUnitCF") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTyrePressureUnitCF(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGSMARTINTLIGHT") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGSMARTINTLIGHT(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGHMIDATEDISPLAY") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGHMIDATEDISPLAY(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGSPVR") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGSPVR(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGAM2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGAM2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGForgotPhonePopup") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGForgotPhonePopup(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGDRECOSALING") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGDRECOSALING(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGDRECOSTOPANDSTART") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGDRECOSTOPANDSTART(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGDRECOECOMode") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGDRECOECOMode(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGDRECOTTS") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGDRECOTTS(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGClim") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGClim(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGSeatCourtesy") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGSeatCourtesy(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "REMOTESTART2HOURSCF") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetREMOTESTART2HOURSCF(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGADASUPAMute") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGADASUPAMute(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGEasyAccess") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGEasyAccess(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGTIMEAUTO") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGTIMEAUTO(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TPMSAutolocCF") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTPMSAutolocCF(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGHome") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGHome(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGEditHome") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGEditHome(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGFavorite") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGFavorite(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGEnergyInfo") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGEnergyInfo(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGGSICONTACTBREAKERBUZZERRST") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGGSICONTACTBREAKERBUZZERRST(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGDRECODistanceWoAccel") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGDRECODistanceWoAccel(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGDRECORangeIncrease") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGDRECORangeIncrease(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGDRECOCMI") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGDRECOCMI(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGDRECOEcoNav") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGDRECOEcoNav(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGDRECOResetType") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGDRECOResetType(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGDRECODistanceWoCons") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGDRECODistanceWoCons(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGELFNOTIFNUMBER") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGELFNOTIFNUMBER(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALDynamicPattern") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALDynamicPattern(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALAREA1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALAREA1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALAREA2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALAREA2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALAREA3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALAREA3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALCOL1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALCOL1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALCOL2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALCOL2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALCOL3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALCOL3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALCOL4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALCOL4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALCOL5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALCOL5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALCOL6") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALCOL6(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALCOL7") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALCOL7(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALCOL8") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALCOL8(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALCOL9") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALCOL9(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALCOL10") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALCOL10(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALCOL11") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALCOL11(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALCOL12") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALCOL12(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALCOL13") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALCOL13(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALCOL14") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALCOL14(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGALCOL15") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGALCOL15(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGFLOWPHEVACTIVATION") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGFLOWPHEVACTIVATION(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGUserProfile") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGUserProfile(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGAQSClim") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGAQSClim(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGDualSyncClim") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGDualSyncClim(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "WelcomeSequence") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetWelcomeSequence(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CFGHeatedSteeringWheelClim") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCFGHeatedSteeringWheelClim(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "ConfigPartNumber") == 0) 
    {
        dp_tclKdsConfigPartNumber oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetConfigPartNumber(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DataRecord") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDataRecord(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "CustomerECUPartNumber") == 0) 
    {
        dp_tclKdsCustomerECUPartNumber oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCustomerECUPartNumber(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ECUPartNumber") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetECUPartNumber(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "EarlyConfig_Display") == 0) 
    {
        dp_tclKdsEarlyConfig_Display oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEarlyConfig_Display(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Resolution") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetResolution(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BackwardCompatibility") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBackwardCompatibility(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LowFrequency") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLowFrequency(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "EarlyConfig2Displays") == 0) 
    {
        dp_tclKdsEarlyConfig2Displays oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEarlyConfig2Displays(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TrTimingLVDS1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTrTimingLVDS1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TrTimingLVDS2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTrTimingLVDS2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "EarlyConfig_Touch") == 0) 
    {
        dp_tclKdsEarlyConfig_Touch oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetEarlyConfig_Touch(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TouchDriverName") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTouchDriverName(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TouchConfigFileName") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTouchConfigFileName(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "InputKeyMappingTable_2") == 0) 
    {
        dp_tclKdsInputKeyMappingTable_2 oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetInputKeyMappingTable_2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MajorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMajorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinorVersion") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinorVersion(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NrOfEntries1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNrOfEntries1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "InputKeyMappingTable_3") == 0) 
    {
        dp_tclKdsInputKeyMappingTable_3 oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetInputKeyMappingTable_3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MajorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMajorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinorVersion") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinorVersion(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NrOfEntries") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNrOfEntries(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID6") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID6(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID6") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID6(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID7") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID7(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID7") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID7(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID8") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID8(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID8") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID8(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID9") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID9(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID9") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID9(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID10") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID10(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID10") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID10(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID11") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID11(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID11") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID11(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID12") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID12(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID12") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID12(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID13") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID13(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID13") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID13(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID14") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID14(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID14") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID14(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID15") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID15(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID15") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID15(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID16") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID16(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID16") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID16(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID17") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID17(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID17") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID17(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID18") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID18(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID18") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID18(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID19") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID19(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID19") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID19(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID20") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID20(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID20") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID20(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID21") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID21(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID21") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID21(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID22") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID22(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID22") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID22(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID23") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID23(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID23") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID23(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID24") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID24(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID24") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID24(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID25") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID25(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID25") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID25(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID26") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID26(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID26") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID26(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID27") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID27(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID27") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID27(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID28") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID28(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID28") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID28(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID29") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID29(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID29") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID29(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID30") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID30(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID30") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID30(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID31") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID31(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID31") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID31(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID32") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID32(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID32") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID32(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "InputKeyMappingTable_4") == 0) 
    {
        dp_tclKdsInputKeyMappingTable_4 oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetInputKeyMappingTable_4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MajorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMajorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinorVersion") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinorVersion(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NrOfEntries") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNrOfEntries(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID2") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID2(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID3") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID3(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID4") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID4(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID4") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID4(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID5") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID5(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID5") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID5(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID6") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID6(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID6") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID6(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID7") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID7(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID7") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID7(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID8") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID8(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID8") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID8(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID9") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID9(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID9") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID9(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID10") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID10(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID10") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID10(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID11") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID11(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID11") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID11(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID12") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID12(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID12") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID12(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID13") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID13(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID13") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID13(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RawKeyID14") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRawKeyID14(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "LogicalKeyID14") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLogicalKeyID14(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "Lockout") == 0) 
    {
        dp_tclKdsLockout oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetLockout(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VideoPlayingRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVideoPlayingRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PictureSlideshowRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPictureSlideshowRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SMSTextInputRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSMSTextInputRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "FeaturesTutorialsRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetFeaturesTutorialsRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SystemUserHandbookRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSystemUserHandbookRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "TextInputRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTextInputRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PhoneDialInputRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPhoneDialInputRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "NavigationDestinationInputRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNavigationDestinationInputRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MusicRadioCoverDsplayRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMusicRadioCoverDsplayRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "GeneralHMIRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetGeneralHMIRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ServiceActivationRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetServiceActivationRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DisplayedTextLenghtRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDisplayedTextLenghtRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HMIAnimationsRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHMIAnimationsRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "StationaryPictureIndictionRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetStationaryPictureIndictionRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "OneByOneLineOperationNonMusicListScrollRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetOneByOneLineOperationNonMusicListScrollRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SmoothMapScroolOperationRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSmoothMapScroolOperationRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DraggingOperationRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDraggingOperationRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PinchInOutOperationRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPinchInOutOperationRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "UserProfileRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetUserProfileRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HomeMenuEditionRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHomeMenuEditionRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraSettingsRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraSettingsRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MapRotationRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMapRotationRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PictureTextBackgroundDisplayRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPictureTextBackgroundDisplayRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Nissan5OperationCountRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNissan5OperationCountRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Nissan8OperationCountRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNissan8OperationCountRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Renault5OperationCountRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRenault5OperationCountRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Renault8OperationCountRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRenault8OperationCountRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "AudioPlayAutomaticallyRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAudioPlayAutomaticallyRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SystemUpdateRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSystemUpdateRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SXMStock") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSXMStock(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "OneByOneLineOperationMusicListScrollRestriction") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetOneByOneLineOperationMusicListScrollRestriction(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "BlockingTestMode") == 0) 
    {
        dp_tclKdsBlockingTestMode oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBlockingTestMode(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "BlockingTestModeApplicationSwitch") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetBlockingTestModeApplicationSwitch(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "Audio_Parameter_Set") == 0) 
    {
        dp_tclKdsAudio_Parameter_Set oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAudio_Parameter_Set(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Tag") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetTag(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MajorVersion") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMajorVersion(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinorVersion") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinorVersion(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "Parameter1") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetParameter1(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CRC") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCRC(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "NVM_Configuration") == 0) 
    {
        dp_tclKdsNVM_Configuration oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetNVM_Configuration(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PNMGroup10Switch") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPNMGroup10Switch(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VCANBaudrate") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVCANBaudrate(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MCANBaudrate") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMCANBaudrate(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PrimaryWakeup") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPrimaryWakeup(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "AVDECC_Config") == 0) 
    {
        dp_tclKdsAVDECC_Config oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetAVDECC_Config(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PresentationTimeGlassUSBVideo") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPresentationTimeGlassUSBVideo(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PresentationTimeGlassHDMI") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPresentationTimeGlassHDMI(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PresentationTimeGlassAnalogueCamera") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPresentationTimeGlassAnalogueCamera(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PresentationTimeGlassIPCamera") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPresentationTimeGlassIPCamera(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PresentationTimeAmplifierUSBVideo") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPresentationTimeAmplifierUSBVideo(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PresentationTimeAmplifierHDMI") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPresentationTimeAmplifierHDMI(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PresentationTimeAmplifierAudio") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPresentationTimeAmplifierAudio(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxTransitTimeCamportStream1AVBHDMI") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxTransitTimeCamportStream1AVBHDMI(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxTransitTimeCamportStream2IPCAM") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxTransitTimeCamportStream2IPCAM(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxTransitTimeCamportStream3AUDIO") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxTransitTimeCamportStream3AUDIO(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PresentationTimeGlassCMRDRM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPresentationTimeGlassCMRDRM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PresentationTimeAmplifierCMRDRM") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPresentationTimeAmplifierCMRDRM(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PresentationTimeAmplifierCMRAudio") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPresentationTimeAmplifierCMRAudio(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "CIS_Configuration") == 0) 
    {
        dp_tclKdsCIS_Configuration oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCIS_Configuration(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ControlPanelAvailability") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetControlPanelAvailability(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "IPCameraAvailablitiy") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetIPCameraAvailablitiy(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOnVolumeCockpit") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOnVolumeCockpit(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOnVolumeCockpit") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOnVolumeCockpit(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOnVolumeCabinA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOnVolumeCabinA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOnVolumeCabinA") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOnVolumeCabinA(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOnVolumeCabinB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOnVolumeCabinB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOnVolumeCabinB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOnVolumeCabinB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOnVolumeMIC1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOnVolumeMIC1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOnVolumeMIC1") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOnVolumeMIC1(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOnVolumeMIC2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOnVolumeMIC2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOnVolumeMIC2") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOnVolumeMIC2(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MinOnVolumeMIC3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMinOnVolumeMIC3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MaxOnVolumeMIC3") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMaxOnVolumeMIC3(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "DoorUnlockTime") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetDoorUnlockTime(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HealthcareEnabled") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHealthcareEnabled(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HealthcareMessageInterval") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHealthcareMessageInterval(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HealthcareMessageCount") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHealthcareMessageCount(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraTileInCabinHomescreen") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraTileInCabinHomescreen(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraportUSB") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraportUSB(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HourLogicEnabled") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHourLogicEnabled(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HourLogicTimeRange") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHourLogicTimeRange(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "HealthcareDTCPopupSeverity") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetHealthcareDTCPopupSeverity(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "SafeShutdownTimer") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetSafeShutdownTimer(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraActivation") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraActivation(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "RVCTextPosition") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetRVCTextPosition(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PrivateModeSpeakerAvailability") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPrivateModeSpeakerAvailability(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraBlackScreenTime") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraBlackScreenTime(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "CameraBlackScreenFeature") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCameraBlackScreenFeature(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "dev_NVM_Configuration") == 0) 
    {
        dp_tclKdsdev_NVM_Configuration oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8Getdev_NVM_Configuration(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PNMGroup10Switch") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPNMGroup10Switch(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "VCANBaudrate") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetVCANBaudrate(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "MCANBaudrate") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetMCANBaudrate(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "PrimaryWakeup") == 0) 
        {
            tU8    u8Data = 0; 
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetPrimaryWakeup(u8Data) )
            {
                *pau8Data = u8Data;
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }

    if (strcmp(strConfigElement, "CMConfigurationInformation") == 0) 
    {
        dp_tclKdsCMConfigurationInformation oKdsElement;
        if (strcmp(strConfigItem, "") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetCMConfigurationInformation(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
        if (strcmp(strConfigItem, "ConfigurationHash") == 0) 
        {
            Vs32ReturnCode=DP_S32_ERR_NO_ELEMENT_READ;
            if (DP_U8_ELEM_STATUS_VALID == oKdsElement.u8GetConfigurationHash(pau8Data, u16Len) )
            {
                Vs32ReturnCode=DP_S32_NO_ERR;
            }
        }
    }
    if(Vs32ReturnCode==DP_S32_ERR_NO_ELEMENT)
    {     
      tChar   VstrElementItem[255]={0};
      snprintf(VstrElementItem,sizeof(VstrElementItem),"%s_%s",strConfigElement,strConfigItem);
      ETG_TRACE_USR4(("DP_s32GetConfigItem(): KDS element '%s' not defined  !!! ",VstrElementItem));
      if(bNormalAssertIfElemNotExist==TRUE)
      {             
        ETG_TRACE_ERRMEM(("TR_CLASS_DATAPOOL_KDS_ELEMENT:DP_s32GetConfigItem(): KDS element '%s' not defined  !!! ",VstrElementItem));
        NORMAL_M_ASSERT_ALWAYS();
      }
    }
  }
  return(Vs32ReturnCode);
}

