#ifndef _DP_UNDEF_ELEMENT
#define _DP_UNDEF_ELEMENT

#define SYSTEM_S_IMPORT_INTERFACE_LIST
#include "stl_pif.h"

#include <semaphore.h>

#define TRACE_S_IMPORT_INTERFACE_TYPES
#include "trace_if.h"

#define DP_S_IMPORT_INTERFACE_DPELEM
#define DP_S_IMPORT_INTERFACE_DPMASTER
#include "dp_if.h"

/*PSARCC30-2027: Needed by datapool To Clear the Old Datapool which is undefined in Current Software
If the undef pool was defined in old software then to remove the same we need some definitions*/
/*structure pool property*/
typedef struct tDpUndefPoolProperty
{
   tBool                                     bValid;  
   tChar                                     strPoolName[DP_MAX_LEN_NAME_UNDEFINED_POOLS]; 
   tChar                                     strUserName[DP_MAX_LEN_NAME_USER]; 
   tChar                                     strProcessNameLocated[DP_MAX_LEN_NAME_PROCESS]; 
   tChar                                     strProcessNameCreated[DP_MAX_LEN_NAME_PROCESS]; 
   tU32                                      u32PoolId;
   tU32		                                   u32PoolVersion;
   eDpLocation                               eLocation;
   tU16                                      u16Access;
}tDpUndefPoolProperty;

/*structure for shared memory hash table*/
typedef struct tDpShmHashTable
{
  tU8	u8State;  
  tU32	u32Offset;	
}tDpShmHashTable;

/* defines for file and pool property*/
#define DP_UNDEF_FILE_NAME_POOL_PROPERTIES     "DP_UndefPoolProperties"
#define DP_UNDEF_FILE_NAME_ELEMENT_PROPERTIES  "DP_UndefElementProperties"
#define DP_UNDEF_VERSION_FILE_PROPERTIES             0   

/* max number of pools*/
#define DP_MAX_NUMBER_POOLS_UNDEF_ELEMENT                   449  //use prime   
#define DP_SIZE_HASH_TABLE                                  (sizeof(tDpShmHashTable)*DP_MAX_NUMBER_POOLS_UNDEF_ELEMENT)
#define DP_SIZE_ALL_PROPERTY_TOOL                           (sizeof(tDpUndefPoolProperty)*DP_MAX_NUMBER_POOLS_UNDEF_ELEMENT) 


#ifdef DP_FEATURE_UNDEF_ELEMENT
#define DP_POOL_VERSION_UNDEF                                      0x0001

//defines for default element property
#define DP_UNDEF_ELEMENT_DEFAULT_PROPERTY_VERSION                  0x01
#define DP_UNDEF_ELEMENT_DEFAULT_PROPERTY_VAR_SIZE                 FALSE
#define DP_UNDEF_ELEMENT_DEFAULT_PROPERTY_ACCESSS_TYPE             0x0006
#define DP_UNDEF_ELEMENT_DEFAULT_PROPERTY_ELEMENT_TYPE             dp_tclBaseElement::eDpElementTypePersistent
#define DP_UNDEF_ELEMENT_DEFAULT_PROPERTY_STORING_TYPE             dp_tclBaseElement::eDpStoringTypeImmediately
#define DP_UNDEF_ELEMENT_DEFAULT_PROPERTY_DEF_SET_MODE             DP_DEFSET_USER

#define DP_UNDEF_ELEMENT_NAME_SHARED_MAX_LEN                       255



/*structure element property*/
typedef struct tDpUndefElementProperty
{
  tChar                               strElementName[DP_MAX_LEN_NAME_ELEMENT];
  tU8                                 u8Version;
  tU32                                u32DataLength;
  tBool                               bVarSize;
  tU16                                u16AccessType;		
  dp_tclBaseElement::EDpElementTypes  tElemType;
  dp_tclBaseElement::EDpStoringTypes  tStoringType;
  tU32                                u32StoringIntervall;
  tU32                                u32DefSetMode;  
}tDpUndefElementProperty;

class dp_tclDpUndef
{
  private:
    // *****************************************************************************
    // ********   static class variable 
    // *****************************************************************************  
    static dp_tclDpUndef* _poInstance;

  protected:
   
    /*structure for shared memory management*/
    typedef struct tDpShmManage
    {
      sem_t semShmProperty; 
	    sem_t semShmElements;
	    tS32  s32SizeFile;  
    }tDpShmManage;

    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::list<tU32> TListPoolId;
    #else
    typedef std::list<tU32> TListPoolId;
    #endif

    typedef struct tDpShmElement
    {
      tChar  strPoolElementName[DP_UNDEF_ELEMENT_NAME_SHARED_MAX_LEN];
      tU32   u32ProcessAccess;
	    tS32   s32ShmId;
	    void*  vpAdrShmElement;
	    tU32   u32SizeShmElement;
    }tDpShmElement;
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::map<tS32, tDpShmElement> tDpUndefSharedElement;
    #else
    typedef std::map<tS32, tDpShmElement> tDpUndefSharedElement;
    #endif
    tDpUndefSharedElement _tListSharedUndefElements;

    // *****************************************************************************
    // ********   internal member variable 
    // *****************************************************************************  
    tU32                   _u32OffsetPool;		                        //creator
    dp_tclDpPersMemAccess* _poPersMemAccessHdl;                       //vInitInstance
    void*			             _pvShmProperty;		                        //vInitInstance                
    tU32                   _u32ShmLength;                             //vInitInstance
 
  public:
    typedef enum {
      eDpUndefInit,
      eDpUndefSet,
      eDpUndefGet,
      eDpUndefDelete,
	    eDpUndefShared,
	    eDpUndefPerformDefSet
    }EDpUndefCall;

    // *****************************************************************************
    // ********   initialization part 
    // *****************************************************************************   
    dp_tclDpUndef(); 
    virtual ~dp_tclDpUndef(); 

    static dp_tclDpUndef* pGetInstance();//  singleton method
    virtual void  vInitInstance(dp_tclDpPersMemAccess* poPersMem);

    // *****************************************************************************
    // ********   access part 
    // *****************************************************************************
    virtual tS32    s32GetPoolProperty(tDpUndefPoolProperty* PpPoolProperty,EDpUndefCall PeFunctionCall,dp_tclBaseElement* PpDpElement);     
    virtual tS32    s32DeletePoolProperty(tDpUndefPoolProperty* PpPoolProperty);
    virtual tBool   bGetPoolNameFromId(tDpUndefPoolProperty* PpPoolProperty);

    virtual tS32    s32SaveElementProperty(tU32 Pu32PoolId,tDpUndefElementProperty* PtElementProperty,eDpLocation PeLocation);
    virtual tS32    s32DeleteElementProperty(tU32 Pu32PoolId,tDpUndefElementProperty* PtElementProperty,eDpLocation PeLocation);
    virtual tS32    s32GetElementProperties(tU32 Pu32PoolId,eDpLocation PeLocation,tDpUndefElementProperty **PpListUndefElementProperty);
 
    // *****************************************************************************
    // ********    methods for shm elements 
    // *****************************************************************************
    //if call this function lock semaphore 
    virtual void    vLockSemShmElement(void);
    virtual void    vUnLockSemShmElement(void);
    virtual tS32    s32CreateShmElement(const tChar* PpstrPoolName,const tChar* PpstrElementName,tU32 Pu32ElemetSize,tVoid* PpvData);
    virtual tS32    s32SetShmElement(const tChar* PpstrPoolName,const tChar* PpstrElementName,tU32 Pu32ElemetSize,tVoid* PpvData);
    virtual tS32    s32GetShmElement(const tChar* PpstrPoolName,const tChar* PpstrElementName,tU32 Pu32ElemetSize,tVoid* PpvData);
    virtual tS32    s32DecAccessCountAndGetDataShmElement(const tChar* PpstrPoolName,const tChar* PpstrElementName,tU8 **Pu8Data);
    virtual tBool   bDeleteShmElement(const tChar* PpstrPoolName,const tChar* PpstrElementName);
 
  #ifndef DP_DATAPOOL_UNIT_TEST
  private:
  #endif
    // *****************************************************************************
    // ********     load/save  pool properties
    // *****************************************************************************
    virtual tS32     s32LoadPoolProperties(void); 
    virtual tS32     s32SavePoolProperties(void); 	
  private:
    // *****************************************************************************
    // ********    methods hash function  
    // *****************************************************************************
    virtual tS32     s32GetHash(const tChar* PtsPoolName); 
    virtual tS32     s32InsertHash(const tChar* PtsPoolName,tU32 Pu32Offset); 
    virtual tU16     u16CalcHashPool(const tChar*);  

    // *****************************************************************************
    // ********    methods for get pointer or offset in shm  
    // *****************************************************************************
    virtual tDpShmManage*         ptGetPointerShmManage() {return (tDpShmManage*) _pvShmProperty;};          
    virtual tDpShmHashTable*      ptGetPointerShmHashTable() {return (tDpShmHashTable*) (void*)(((tU8*)_pvShmProperty)+sizeof(tDpShmManage));};                                      
    virtual tDpUndefPoolProperty* ptGetPointerShmPoolProperty(tU32 Pu32Offset);

    // *****************************************************************************
    // ********      
    // *****************************************************************************
    virtual tU32                  u32PushBackProperty(tDpUndefPoolProperty* PpPoolProperty);
    virtual tU32                  u32GetFreePoolId(void); 
    virtual void                  vPreparePoolProperties(void); 
    virtual tBool                 bCheckElementShouldBeShared(tDpUndefPoolProperty* ,EDpUndefCall ,dp_tclBaseElement* ); 
    virtual tS32                  s32CalcHash(tChar* str); 
};

#endif
#endif

//EOF
