#ifndef _DPMASTER_H
#define _DPMASTER_H

#define SYSTEM_S_IMPORT_INTERFACE_MAP
#define SYSTEM_S_IMPORT_INTERFACE_LIST
#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define TRACE_S_IMPORT_INTERFACE_TYPES
#include "trace_if.h"

#define DP_S_IMPORT_INTERFACE_DPPERSACCESS
#include "dp_if.h"

#define DP_MASTER_TRACE_CLASS              (tU16)(TR_COMP_DATAPOOL + 0x01) 

#define DP_STR_MASTER_NAME "DpMaster"
#define DP_MASTER_MAILBOX_MAX_MESSAGE_COUNT 100

#define DP_MASTER_HASH_COUNT      			5

#define DP_U32_CHECK_MASTER_SYNC_PERS_DATA_DELAY         5000

class dp_tclDatapoolMaster 
{
public:
   typedef enum 
   {  //messages from client to master
      eRegisterClient = 0,
      eStoreAllPools,
      eTracePools,
      eTraceElement,
      eTraceHistory,
      eLockPool,
      eUnlockPool,
      eDefSet,
      eErrBusy,
      eErrAlreadyLocked,
      eErrParamType,
      eCalcHash,
      eHashValue,
      ePoolChanged,
	    eBankAction,
	    eUnregisterClient,
      eEndUserCopy,
      //messages from master to client
      eClientStorePool = 100,
      eClientTracePool,
      eClientTraceElement,
      eClientTraceHistory,
      eClientAllPoolsStored,
      eClientLockPool,
      eClientUnlockPool,
      eClientAllPoolsLocked,
      eClientAllPoolsUnlocked,
      eClientDefSet,
      eClientAllDefSetsReady,
      eClientCalcHash,
      eClientHashReady,
      eClientUpdatePool,
	    eClientAllUpdatePoolReady,
	    eClientBankAction,
	    eClientAllBankActionsReady,
      eClientEndUserCopy,
      eClientAllEndUserCopyReady,
      //ack messages from client to master
      eAckPoolStored = 200,
      eAckPoolLocked,
      eAckPoolUnlocked,
      eAckDefSet,
      eAckHashCalc,
	    eAckUpdatePool,
	    eAckBankAction,
      eAckEndUserCopy,
      //message to own client
      eElementChanged = 300,
      eStopWaitThread,
	    //message for shared undef elements over processes
      eUndefElementShareCreate = 400,  //send client process,who wants to set or get an element located in another process
	    eUndefElementShareDelete,             //send client process,who wants to delete an element located in another process
	    eUndefElementSharedCreated,      //send from process loacted the element
	    eUndefElementSharedAccessDone,   //send client process,who set or get done
	    eUndefElementSharedDeleteDone,   //send from process loacted the element
      eMaxTypes
   }ECmdTypes;

   typedef struct 
   {
	   tU32 u32Hash[DP_MASTER_HASH_COUNT];
   }tHashVal;

   typedef struct TDpPoolMsg
   {
     ECmdTypes  eCmd;
     union 
     {
       tU32  u32Data;
       tU32  au32Data[2];
       tChar strData[DP_MAX_LEN_NAME_ELEMENT];
       struct 
       {
         tChar 		  strFile[DP_MAX_LEN_FILE];
         tHashVal  	tValue;
       }tHash;
       #ifdef DP_FEATURE_UNDEF_ELEMENT
			 struct 
       {
         tChar       strElement[DP_MAX_LEN_NAME_ELEMENT];
         tChar       strPool[DP_MAX_LEN_NAME_UNDEFINED_POOLS];
				 tChar       strProcess[DP_MAX_LEN_NAME_PROCESS];
       }tUndef;
       #endif
			 struct 
			 {
         tChar            strProzess[DP_MAX_LEN_NAME_PROCESS];
         OSAL_tProcessID  tPid;			
       }tRegMaster;      
     }u;
   }TDpPoolMsg;

protected:
    typedef struct 
    {
      OSAL_tMQueueHandle _hQueueHandle;
	    OSAL_tProcessID    _tPid;
	    tBool              _bValid;
    }TDpClient;

	  #ifdef SYSTEM_S_USE_BPSTL
	  typedef bpstl::map<bpstl::string, TDpClient> TMapDpClient;
	  typedef bpstl::map<bpstl::string, tHashVal> TMapDpHash;
    #else
	  typedef std::map<std::string, TDpClient> TMapDpClient;
	  typedef std::map<std::string, tHashVal> TMapDpHash;
    #endif
    TMapDpClient oDpClients;
    TMapDpHash oDpHash;
    
    static dp_tclDatapoolMaster*  _poInstance; //pointer to singleton object

    static tVoid vDpMainThread(tVoid *pvArg);
    OSAL_tThreadID _hThreadId;
    tBool _bTerminate;

    dp_tclDpPersMemAccess* _poPersMemAccessHdl;

    OSAL_tMQueueHandle _hMasterQueueHandle;
    tBool bPostClientMessage(TDpPoolMsg* pMsg, OSAL_tMQueueHandle hQueueHandle) const;
    tBool bBroardcastMsg(TDpPoolMsg* pMsg, tBool bSync=FALSE);
	  tBool bCheckProcessExist(const char* PpStrProzess,OSAL_tProcessID PtPid);

    tU32 _u32ClientAckCounter;
    tU32 _u32LockState;
    tU32 _u32LockOwner;

    tVoid vStoreDpReg();
    tVoid vLoadDpReg();

public:
    dp_tclDatapoolMaster(); 
    virtual ~dp_tclDatapoolMaster(); 

    virtual tVoid vInitInstance(dp_tclDpPersMemAccess* poPersMem);

    static dp_tclDatapoolMaster* pGetInstance(); //  singleton method
};

#endif //_DPMASTER_H

//EOF
