#ifndef _DPIFDEF
#define _DPIFDEF

#define DP_MAX_LEN_NAME_PROCESS                             64
#define DP_MAX_LEN_NAME_RESOURCE                            32
#define DP_MAX_LEN_NAME_ELEMENT                             200
#define DP_MAX_LEN_NAME_UNDEFINED_POOLS                     100
#define DP_MAX_LEN_NAME_USER                                100
#define DP_MAX_LEN_FILE                                     200

#define DP_U32_LOCK_MODE_NONE                               0x00000000
#define DP_U32_LOCK_MODE_SETDEF                             0x00000001
#define DP_U32_LOCK_MODE_MASTER                             0x00000002
#define DP_U32_LOCK_MODE_END_USER                           0x00000004

#define DP_DEFSET_NONE                                      0x00000000
#define DP_DEFSET_USER                                      0x00000001
#define DP_DEFSET_TEF                                       0x00000002
#define DP_DEFSET_CUSTOMER                                  0x00000004
#define DP_DEFSET_END_USER                                  0x00000008
#define DP_DEFSET_END_USER_BANK                             0x00000010

#define DP_S32_NO_ERR                                       0
#define DP_S32_ERR_ACCESS_RIGHT                            -1
#define DP_S32_ERR_ACCESS_POOL_LOCKED                      -2
#define DP_S32_ERR_RD_BUF_LEN                              -3
#define DP_S32_ERR_WR_BUF_LEN                              -4
#define DP_S32_ERR_NO_ELEMENT                              -5
#define DP_S32_ERR_IDLE                                    -6
#define DP_S32_ERR_NO_CONVERSION                           -7
#define DP_S32_ERR_TIMEOUT                                 -8
#define DP_S32_ERR_BUSY                                    -9
#define DP_S32_ERR_UNKNOWN                                 -10
#define DP_S32_ERR_TYPE                                    -11
#define DP_S32_ERR_ALREADY_LOCKED                          -12
#define DP_S32_ERR_WRONG_PARAM                             -14
#define DP_S32_ERR_NO_POOL                                 -15
#define DP_S32_ERR_WRONG_SIZE                              -16
#define DP_S32_ERR_DIFFERENT_LOCATION                      -17
#define DP_S32_ERR_EQUAL_HASH                              -18
#define DP_S32_ERR_NOT_SUPPORTED                           -19
#define DP_S32_ERR_NO_ELEMENT_READ                         -20
#define DP_S32_ERR_NOT_ALLOWED                             -21
#define DP_S32_ERR_IO                                      -22

#define DP_U8_ELEM_STATUS_INVALID                           0
#define DP_U8_ELEM_STATUS_VALID                             1
#define DP_U8_ELEM_STATUS_INITVAL                           2
#define DP_U8_ELEM_STATUS_DEFVAL                            3
#define DP_U8_ELEM_STATUS_LEN_ERR                           254
#define DP_U8_ELEM_STATUS_NOT_READ                          255

typedef enum 
{
   eDpLocation_FILE_SYSTEM,
   eDpLocation_FILE_SYSTEM_SECURE,
   eDpLocation_RAW_NOR,
   eDpLocation_V850,
   eDpLocation_PDD_KERNEL,
   eDpLocation_RAW_EMMC,
}eDpLocation;

typedef enum 
{
   eDpModeEndUserNo,            //no end user pool, default mode
   eDpModeEndUserMulti,         //pool for multi end user
   eDpModeEndUserMultiBank      //pool for multi end user with several banks
}eDpModeEndUser;

typedef void (*DP_tpvInitPoolCallback) (tU8 u8Bank);
#endif
//EOF
