#ifndef DATAPOOL_SUBSYSTEM_HEADER
#define DATAPOOL_SUBSYSTEM_HEADER

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define DP_S_IMPORT_INTERFACE_BASE
#define DP_S_IMPORT_INTERFACE_DPELEM
#include "dp_if.h"

#define DP_API_EXPORT

/* [BEGIN SYSCALLS] */
DP_API_EXPORT tVoid DP_vCreateDatapool(tVoid);
DP_API_EXPORT tVoid DP_vDestroyDatapool(tU32* pData);

DP_API_EXPORT tVoid DP_vSetPoolInitCallback(DP_tpvInitPoolCallback pInitCallback, tU32 u32PoolId);

DP_API_EXPORT tS32 DP_s32SetElement(tU32 u32PoolId, dp_tclBaseElement* tDpElement, tU16 u16AccessId);
DP_API_EXPORT tS32 DP_s32GetElement(tU32 u32PoolId, dp_tclBaseElement* pDpElement, tU16 u16AccessId);

DP_API_EXPORT tBool DP_bAddNotification(tU32 u32PoolId, const tChar* strElementName, tVoid* pvCallback, tU32 u32Event, tU16 u16AccessId);
DP_API_EXPORT tBool DP_bRemoveNotification(tU32 u32PoolId, const tChar* strElementName, tVoid* pvCallback, tU32 u32Event, tU16 u16AccessId);

DP_API_EXPORT tS32  DP_s32GetConfigItem(const tChar* strConfigElement, const tChar* strConfigItem, tU8* pau8Data, tU16 u16Len, tBool bNormalAssertIfElemNotExist = TRUE);

DP_API_EXPORT tVoid DP_vTracePoolElement(tU32 u32PoolId);
DP_API_EXPORT tVoid DP_vTracePoolElementByName(const tChar* pcName);
DP_API_EXPORT tVoid DP_vTracePoolHistory(tVoid);
DP_API_EXPORT tBool DP_bReloadPool(tU32 u32PoolId);

DP_API_EXPORT tVoid DP_vEnableElementForTrace(const tChar* pcName);

DP_API_EXPORT tS32  DP_s32StoreNow(tU32 u32AccessId, tU32 u32Timeout);
DP_API_EXPORT tS32  DP_s32SetDefault(tU32 u32AccessId, tU32 u32DefType, tU32 u32Timeout);
DP_API_EXPORT tS32  DP_s32SetConfig(tU32 u32PoolId, tU32 u32AccessId, tU32 u32Timeout);

DP_API_EXPORT tS32  DP_s32Lock(tU32 u32AccessId, tU32 u32LockType, tU32 u32Timeout);
DP_API_EXPORT tS32  DP_s32Unlock(tU32 u32AccessId, tU32 u32Timeout);

DP_API_EXPORT tS32  DP_s32CalcHash(tU32* pu32Data, tU32 u32DataLen, tU32 u32AccessId, tU32 u32Timeout);

//store pool now
DP_API_EXPORT tS32 DP_s32StorePoolNow(tU32 u32PoolId, tU32 u32AccessId);

/*for undefined element*/
DP_API_EXPORT tS32  DP_s32InitUndefElement(const tChar* cUserName, const tChar* cPoolName, eDpLocation peLocation, dp_tclBaseElement* pDpElement);
DP_API_EXPORT tS32  DP_s32SetUndefElement(const tChar* cUserName, const tChar* cPoolName, const tChar* pcElementName, tU8* pu8WriteBuffer, tS32 s32Size);
DP_API_EXPORT tS32  DP_s32GetUndefElement(const tChar* cUserName, const tChar* cPoolName, const tChar* pcElementName, tU8* pu8ReadBuffer, tS32 s32Size);
DP_API_EXPORT tS32  DP_s32DeleteUndefElement(const tChar* cUserName, const tChar* cPoolName, const tChar* pcElementName);

/*for end user*/
DP_API_EXPORT tS32  DP_s32SetEndUser(tU8 u8EndUser, tU16 u16AccessId);
DP_API_EXPORT tS32  DP_s32GetEndUser(tU8& u8EndUser);
DP_API_EXPORT tS32  DP_s32CopyEndUser(tU8 u8EndUserFrom, tU8 u8EndUserTo, tU16 Pu16AccessId, tU32 Pu32Timeout);
DP_API_EXPORT tS32  DP_s32GetElementEndUser(tU8 u8EndUser, tU32 u32PoolId, const tChar* VcPoolName, eDpLocation PeLocation, tU32 Pu32Version, dp_tclBaseElement* pDpElement, tU16 u16AccessId);
DP_API_EXPORT tS32  DP_s32LoadBankToCurrentEndUser(tU8 Pu8Bank, tU16 Pu16AccessId, tU32 Pu32Timeout);
DP_API_EXPORT tS32  DP_s32SaveCurrentEndUserToBank(tU8 Pu8Bank, tU16 Pu16AccessId, tU32 Pu32Timeout);
DP_API_EXPORT tS32  DP_s32GetBank(tU8& u8Bank);
DP_API_EXPORT tS32  DP_s32SetEndUserDefault(tU8 Pu8EndUser, tU16 u16AccessId, tU32 u32Timeout);
DP_API_EXPORT tS32  DP_s32SetBankDefault(tU8 Pu8Bank, tU16 u16AccessId, tU32 u32Timeout);

/*only for oedt test*/
#ifdef DP_U32_POOL_ID_PDDDPTESTENDUSER
DP_API_EXPORT tVoid  DP_vEnableReloadEndUserSharedMemory(tVoid);
#endif

/* [END SYSCALLS] */

#else
//#error dpIfFunctions.h included several times
#endif

//******************************** END OF FILE *******************************/
