/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#if !defined(FI_S_NO_STRING_ACCESS_METHODS) || !defined(FI_S_UTFMODE_TRANSPARENT)
   #define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
   #include "utf_if.h"
#endif

#define CMB_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "cmb_fi_gen_if.h"
// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& cmb_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u8Value);
  return oIn;
}

tU32 cmb_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& cmb_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s8Value);
  return oIn;
}

tU32 cmb_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& cmb_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u16Value);
  return oIn;
}

tU32 cmb_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& cmb_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s16Value);
  return oIn;
}

tU32 cmb_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& cmb_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u24Value);
  return oIn;
}

tU32 cmb_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& cmb_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s24Value);
  return oIn;
}

tU32 cmb_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& cmb_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u32Value);
  return oIn;
}

tU32 cmb_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& cmb_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u64Value);
  return oIn;
}

tU32 cmb_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& cmb_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s32Value);
  return oIn;
}

tU32 cmb_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& cmb_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s64Value);
  return oIn;
}

tU32 cmb_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& cmb_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f32Value);
  return oIn;
}

tU32 cmb_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& cmb_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f64Value);
  return oIn;
}

tU32 cmb_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& cmb_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(bValue);
  return oIn;
}

tU32 cmb_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid cmb_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tclString::~cmb_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

cmb_fi_tclString& cmb_fi_tclString::operator=(const cmb_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

cmb_fi_tclString::cmb_fi_tclString(const cmb_fi_tclString& coRef):cmb_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& cmb_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool cmb_fi_tclString::operator==(const cmb_fi_tclString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 cmb_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
cmb_fi_tclString& cmb_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
cmb_fi_tclString::cmb_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool cmb_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

cmb_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

cmb_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool cmb_fi_tclString::operator!=(intptr_t iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar cmb_FI_C_U8_NULLCHAR = '\0';

tChar* cmb_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* cmb_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* cmb_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& cmb_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return cmb_FI_C_U8_NULLCHAR;
}

tChar& cmb_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return cmb_FI_C_U8_NULLCHAR;
}

tChar& cmb_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return cmb_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool cmb_fi_tclString::bSet(const cmb_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool cmb_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString cmb_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   (tVoid) oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& cmb_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  (tVoid) oIn.oRead(u32ListSize);
  return oIn;
}

tBool cmb_fi_tclList::operator==(const cmb_fi_tclList& roRef) const
{
   return roRef.u32ListSize == u32ListSize;
}

tU32 cmb_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& cmb_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid cmb_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tclMultiLanguageString::~cmb_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

cmb_fi_tclMultiLanguageString& cmb_fi_tclMultiLanguageString::operator=(const cmb_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

cmb_fi_tclMultiLanguageString::cmb_fi_tclMultiLanguageString(const cmb_fi_tclMultiLanguageString& coRef):cmb_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& cmb_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool cmb_fi_tclMultiLanguageString::operator==(const cmb_fi_tclMultiLanguageString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 cmb_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
cmb_fi_tclMultiLanguageString& cmb_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
cmb_fi_tclMultiLanguageString::cmb_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool cmb_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

cmb_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

cmb_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool cmb_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* cmb_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* cmb_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* cmb_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& cmb_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return cmb_FI_C_U8_NULLCHAR;
}

tChar& cmb_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return cmb_FI_C_U8_NULLCHAR;
}

tChar& cmb_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return cmb_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool cmb_fi_tclMultiLanguageString::bSet(const cmb_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool cmb_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString cmb_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_BinContainer::cmb_fi_tcl_BinContainer(const cmb_fi_tcl_BinContainer& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
cmb_fi_tcl_BinContainer& cmb_fi_tcl_BinContainer::operator=(const cmb_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_BinContainer::vDestroy()
{
   {
   ContainerDataList.clear();
   }
}

cmb_fi_tcl_BinContainer::cmb_fi_tcl_BinContainer()

 {}

tS32 cmb_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_BINCONTAINER;
}


cmb_fi_tcl_BinContainer::~cmb_fi_tcl_BinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ContainerDataList.size()*1);
}

fi_tclInContext& cmb_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool cmb_fi_tcl_BinContainer::operator==(const cmb_fi_tcl_BinContainer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == roRef.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == roRef.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_AudioChannelAdvice::cmb_fi_tcl_e8_AudioChannelAdvice():enType(FI_EN_START) {}

tS32 cmb_fi_tcl_e8_AudioChannelAdvice::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_AUDIOCHANNELADVICE;
}


cmb_fi_tcl_e8_AudioChannelAdvice::~cmb_fi_tcl_e8_AudioChannelAdvice()
{}

tU32 cmb_fi_tcl_e8_AudioChannelAdvice::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_AudioChannelAdvice::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_AudioChannelAdvice::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VoiceCategory::cmb_fi_tcl_e8_VoiceCategory():enType(FI_EN_DRIVINGRECOMMENDATION) {}

tS32 cmb_fi_tcl_e8_VoiceCategory::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VOICECATEGORY;
}


cmb_fi_tcl_e8_VoiceCategory::~cmb_fi_tcl_e8_VoiceCategory()
{}

tU32 cmb_fi_tcl_e8_VoiceCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VoiceCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VoiceCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_CatStatus::cmb_fi_tcl_e8_CatStatus():enType(FI_EN_SILENT) {}

tS32 cmb_fi_tcl_e8_CatStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_CATSTATUS;
}


cmb_fi_tcl_e8_CatStatus::~cmb_fi_tcl_e8_CatStatus()
{}

tU32 cmb_fi_tcl_e8_CatStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_CatStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_CatStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_AudioChannelAdvice::cmb_fi_tcl_AudioChannelAdvice(const cmb_fi_tcl_AudioChannelAdvice& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   ChannelAdvice = coRef.ChannelAdvice;
   Index = coRef.Index;
   Device = coRef.Device;
}
cmb_fi_tcl_AudioChannelAdvice& cmb_fi_tcl_AudioChannelAdvice::operator=(const cmb_fi_tcl_AudioChannelAdvice& coRef)
{
   if (this == &coRef) return *this;
   ChannelAdvice = coRef.ChannelAdvice;
   Index = coRef.Index;
   Device = coRef.Device;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_AudioChannelAdvice::vDestroy()
{
   Device.vDestroy();
}

cmb_fi_tcl_AudioChannelAdvice::cmb_fi_tcl_AudioChannelAdvice()
:ChannelAdvice()
,Index(0)
,Device()
 {}

tS32 cmb_fi_tcl_AudioChannelAdvice::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_AUDIOCHANNELADVICE;
}


cmb_fi_tcl_AudioChannelAdvice::~cmb_fi_tcl_AudioChannelAdvice()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_AudioChannelAdvice::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+Device.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cmb_fi_tcl_AudioChannelAdvice::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ChannelAdvice);
   (tVoid) (oIn >> Index);
   (tVoid) (oIn >> Device);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_AudioChannelAdvice::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ChannelAdvice);
   (tVoid) (oOut << Index);
   (tVoid) (oOut << Device);
   return oOut;
}

tBool cmb_fi_tcl_AudioChannelAdvice::operator==(const cmb_fi_tcl_AudioChannelAdvice& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ChannelAdvice == roRef.ChannelAdvice);
   bResult = bResult && (Index == roRef.Index);
   bResult = bResult && (Device == roRef.Device);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b8_AudioOutputLocation::cmb_fi_tcl_b8_AudioOutputLocation():u8Value(0)
{}

tS32 cmb_fi_tcl_b8_AudioOutputLocation::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B8_AUDIOOUTPUTLOCATION;
}


cmb_fi_tcl_b8_AudioOutputLocation::~cmb_fi_tcl_b8_AudioOutputLocation()
{}

tU32 cmb_fi_tcl_b8_AudioOutputLocation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_b8_AudioOutputLocation::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& cmb_fi_tcl_b8_AudioOutputLocation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b8_AudioFormat::cmb_fi_tcl_b8_AudioFormat():u8Value(0)
{}

tS32 cmb_fi_tcl_b8_AudioFormat::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B8_AUDIOFORMAT;
}


cmb_fi_tcl_b8_AudioFormat::~cmb_fi_tcl_b8_AudioFormat()
{}

tU32 cmb_fi_tcl_b8_AudioFormat::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_b8_AudioFormat::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& cmb_fi_tcl_b8_AudioFormat::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_InstancesPerCategory::cmb_fi_tcl_InstancesPerCategory(const cmb_fi_tcl_InstancesPerCategory& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   VoiceCategory = coRef.VoiceCategory;
   NumberOfInstances = coRef.NumberOfInstances;
}
cmb_fi_tcl_InstancesPerCategory& cmb_fi_tcl_InstancesPerCategory::operator=(const cmb_fi_tcl_InstancesPerCategory& coRef)
{
   if (this == &coRef) return *this;
   VoiceCategory = coRef.VoiceCategory;
   NumberOfInstances = coRef.NumberOfInstances;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_InstancesPerCategory::cmb_fi_tcl_InstancesPerCategory()
:VoiceCategory()
,NumberOfInstances(0)
 {}

tS32 cmb_fi_tcl_InstancesPerCategory::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_INSTANCESPERCATEGORY;
}


cmb_fi_tcl_InstancesPerCategory::~cmb_fi_tcl_InstancesPerCategory()
{}

tU32 cmb_fi_tcl_InstancesPerCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_InstancesPerCategory::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> VoiceCategory);
   (tVoid) (oIn >> NumberOfInstances);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_InstancesPerCategory::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << VoiceCategory);
   (tVoid) (oOut << NumberOfInstances);
   return oOut;
}

tBool cmb_fi_tcl_InstancesPerCategory::operator==(const cmb_fi_tcl_InstancesPerCategory& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (VoiceCategory == roRef.VoiceCategory);
   bResult = bResult && (NumberOfInstances == roRef.NumberOfInstances);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_InstancesPerCategoryList::cmb_fi_tcl_InstancesPerCategoryList(const cmb_fi_tcl_InstancesPerCategoryList& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   InstancesPerCategory = coRef.InstancesPerCategory;
   MaxAmountInstances = coRef.MaxAmountInstances;
}
cmb_fi_tcl_InstancesPerCategoryList& cmb_fi_tcl_InstancesPerCategoryList::operator=(const cmb_fi_tcl_InstancesPerCategoryList& coRef)
{
   if (this == &coRef) return *this;
   InstancesPerCategory = coRef.InstancesPerCategory;
   MaxAmountInstances = coRef.MaxAmountInstances;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_InstancesPerCategoryList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < InstancesPerCategory.size(); ++u32Idx)
         InstancesPerCategory[u32Idx].vDestroy();
   InstancesPerCategory.clear();
   }
}

cmb_fi_tcl_InstancesPerCategoryList::cmb_fi_tcl_InstancesPerCategoryList()

:MaxAmountInstances(0)
 {}

tS32 cmb_fi_tcl_InstancesPerCategoryList::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_INSTANCESPERCATEGORYLIST;
}


cmb_fi_tcl_InstancesPerCategoryList::~cmb_fi_tcl_InstancesPerCategoryList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_InstancesPerCategoryList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(InstancesPerCategory.size()*2);
}

fi_tclInContext& cmb_fi_tcl_InstancesPerCategoryList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < InstancesPerCategory.size(); ++u32Idx)
      {
         InstancesPerCategory[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      InstancesPerCategory.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> InstancesPerCategory[u32Idx]);
      }
   }
   (tVoid) (oIn >> MaxAmountInstances);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_InstancesPerCategoryList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)InstancesPerCategory.size());
   {
      for (tU32 u32Idx = 0; u32Idx < InstancesPerCategory.size(); ++u32Idx)
         (tVoid) (oOut << InstancesPerCategory[u32Idx]);
   }
   (tVoid) (oOut << MaxAmountInstances);
   return oOut;
}

tBool cmb_fi_tcl_InstancesPerCategoryList::operator==(const cmb_fi_tcl_InstancesPerCategoryList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (InstancesPerCategory.size() == roRef.InstancesPerCategory.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < InstancesPerCategory.size()); ++u32Idx)
            bResult = bResult && (InstancesPerCategory[u32Idx] == roRef.InstancesPerCategory[u32Idx]);
      }
   bResult = bResult && (MaxAmountInstances == roRef.MaxAmountInstances);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b16_RequestAddInfo::cmb_fi_tcl_b16_RequestAddInfo():u16Value(0)
{}

tS32 cmb_fi_tcl_b16_RequestAddInfo::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B16_REQUESTADDINFO;
}


cmb_fi_tcl_b16_RequestAddInfo::~cmb_fi_tcl_b16_RequestAddInfo()
{}

tU32 cmb_fi_tcl_b16_RequestAddInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_b16_RequestAddInfo::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cmb_fi_tcl_b16_RequestAddInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_ChannelRequestStatus::cmb_fi_tcl_ChannelRequestStatus(const cmb_fi_tcl_ChannelRequestStatus& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Category = coRef.Category;
   Index = coRef.Index;
   Status = coRef.Status;
   AudioFormat = coRef.AudioFormat;
   AudioOutputLocation = coRef.AudioOutputLocation;
   RequestAddInfo = coRef.RequestAddInfo;
}
cmb_fi_tcl_ChannelRequestStatus& cmb_fi_tcl_ChannelRequestStatus::operator=(const cmb_fi_tcl_ChannelRequestStatus& coRef)
{
   if (this == &coRef) return *this;
   Category = coRef.Category;
   Index = coRef.Index;
   Status = coRef.Status;
   AudioFormat = coRef.AudioFormat;
   AudioOutputLocation = coRef.AudioOutputLocation;
   RequestAddInfo = coRef.RequestAddInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_ChannelRequestStatus::cmb_fi_tcl_ChannelRequestStatus()
:Category()
,Index(0)
,Status()
,AudioFormat()
,AudioOutputLocation()
,RequestAddInfo()
 {}

tS32 cmb_fi_tcl_ChannelRequestStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_CHANNELREQUESTSTATUS;
}


cmb_fi_tcl_ChannelRequestStatus::~cmb_fi_tcl_ChannelRequestStatus()
{}

tU32 cmb_fi_tcl_ChannelRequestStatus::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (2 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+5;
}

fi_tclInContext& cmb_fi_tcl_ChannelRequestStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Category);
   (tVoid) (oIn >> Index);
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> AudioFormat);
   (tVoid) (oIn >> AudioOutputLocation);
   if (2 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> RequestAddInfo);
   }
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_ChannelRequestStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Category);
   (tVoid) (oOut << Index);
   (tVoid) (oOut << Status);
   (tVoid) (oOut << AudioFormat);
   (tVoid) (oOut << AudioOutputLocation);
   if (2 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << RequestAddInfo);
   }
   return oOut;
}

tBool cmb_fi_tcl_ChannelRequestStatus::operator==(const cmb_fi_tcl_ChannelRequestStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Category == roRef.Category);
   bResult = bResult && (Index == roRef.Index);
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (AudioFormat == roRef.AudioFormat);
   bResult = bResult && (AudioOutputLocation == roRef.AudioOutputLocation);
   bResult = bResult && (RequestAddInfo == roRef.RequestAddInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_ChannelRequestStatusList::cmb_fi_tcl_ChannelRequestStatusList(const cmb_fi_tcl_ChannelRequestStatusList& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   ChannelRequestStatusList = coRef.ChannelRequestStatusList;
}
cmb_fi_tcl_ChannelRequestStatusList& cmb_fi_tcl_ChannelRequestStatusList::operator=(const cmb_fi_tcl_ChannelRequestStatusList& coRef)
{
   if (this == &coRef) return *this;
   ChannelRequestStatusList = coRef.ChannelRequestStatusList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_ChannelRequestStatusList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelRequestStatusList.size(); ++u32Idx)
         ChannelRequestStatusList[u32Idx].vDestroy();
   ChannelRequestStatusList.clear();
   }
}

cmb_fi_tcl_ChannelRequestStatusList::cmb_fi_tcl_ChannelRequestStatusList()

 {}

tS32 cmb_fi_tcl_ChannelRequestStatusList::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_CHANNELREQUESTSTATUSLIST;
}


cmb_fi_tcl_ChannelRequestStatusList::~cmb_fi_tcl_ChannelRequestStatusList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_ChannelRequestStatusList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < ChannelRequestStatusList.size(); ++u32ListIdx)
      u32DynamicSize += ChannelRequestStatusList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& cmb_fi_tcl_ChannelRequestStatusList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ChannelRequestStatusList.size(); ++u32Idx)
      {
         ChannelRequestStatusList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ChannelRequestStatusList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ChannelRequestStatusList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_ChannelRequestStatusList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ChannelRequestStatusList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ChannelRequestStatusList.size(); ++u32Idx)
         (tVoid) (oOut << ChannelRequestStatusList[u32Idx]);
   }
   return oOut;
}

tBool cmb_fi_tcl_ChannelRequestStatusList::operator==(const cmb_fi_tcl_ChannelRequestStatusList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ChannelRequestStatusList.size() == roRef.ChannelRequestStatusList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ChannelRequestStatusList.size()); ++u32Idx)
            bResult = bResult && (ChannelRequestStatusList[u32Idx] == roRef.ChannelRequestStatusList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_OdometerStatus::cmb_fi_tcl_e8_OdometerStatus():enType(FI_EN_ODOMSTATE_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_OdometerStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_ODOMETERSTATUS;
}


cmb_fi_tcl_e8_OdometerStatus::~cmb_fi_tcl_e8_OdometerStatus()
{}

tU32 cmb_fi_tcl_e8_OdometerStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_OdometerStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_OdometerStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_OdometerDirection::cmb_fi_tcl_e8_OdometerDirection():enType(FI_EN_ODOMDIR_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_OdometerDirection::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_ODOMETERDIRECTION;
}


cmb_fi_tcl_e8_OdometerDirection::~cmb_fi_tcl_e8_OdometerDirection()
{}

tU32 cmb_fi_tcl_e8_OdometerDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_OdometerDirection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_OdometerDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_GyroError::cmb_fi_tcl_e8_GyroError():enType(FI_EN_GYRO_ERROR_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_GyroError::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_GYROERROR;
}


cmb_fi_tcl_e8_GyroError::~cmb_fi_tcl_e8_GyroError()
{}

tU32 cmb_fi_tcl_e8_GyroError::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_GyroError::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_GyroError::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_GpsManufacturer::cmb_fi_tcl_e8_GpsManufacturer():enType(FI_EN_GPS_MAN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_GpsManufacturer::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_GPSMANUFACTURER;
}


cmb_fi_tcl_e8_GpsManufacturer::~cmb_fi_tcl_e8_GpsManufacturer()
{}

tU32 cmb_fi_tcl_e8_GpsManufacturer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_GpsManufacturer::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_GpsManufacturer::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_GpsHardwareVersion::cmb_fi_tcl_e8_GpsHardwareVersion():enType(FI_EN_GPS_HW_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_GpsHardwareVersion::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_GPSHARDWAREVERSION;
}


cmb_fi_tcl_e8_GpsHardwareVersion::~cmb_fi_tcl_e8_GpsHardwareVersion()
{}

tU32 cmb_fi_tcl_e8_GpsHardwareVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_GpsHardwareVersion::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_GpsHardwareVersion::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_GpsAntennaStatus::cmb_fi_tcl_e8_GpsAntennaStatus():enType(FI_EN_GPS_ANTENNA_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_GpsAntennaStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_GPSANTENNASTATUS;
}


cmb_fi_tcl_e8_GpsAntennaStatus::~cmb_fi_tcl_e8_GpsAntennaStatus()
{}

tU32 cmb_fi_tcl_e8_GpsAntennaStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_GpsAntennaStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_GpsAntennaStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_GpsFrontEndStatus::cmb_fi_tcl_e8_GpsFrontEndStatus():enType(FI_EN_GPS_FRONT_END_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_GpsFrontEndStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_GPSFRONTENDSTATUS;
}


cmb_fi_tcl_e8_GpsFrontEndStatus::~cmb_fi_tcl_e8_GpsFrontEndStatus()
{}

tU32 cmb_fi_tcl_e8_GpsFrontEndStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_GpsFrontEndStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_GpsFrontEndStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_GpsFrontEndDataPattern::cmb_fi_tcl_e8_GpsFrontEndDataPattern():enType(FI_EN_GPS_DATA_PATTERN_OFF) {}

tS32 cmb_fi_tcl_e8_GpsFrontEndDataPattern::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_GPSFRONTENDDATAPATTERN;
}


cmb_fi_tcl_e8_GpsFrontEndDataPattern::~cmb_fi_tcl_e8_GpsFrontEndDataPattern()
{}

tU32 cmb_fi_tcl_e8_GpsFrontEndDataPattern::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_GpsFrontEndDataPattern::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_GpsFrontEndDataPattern::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b8_GpsFixStatus::cmb_fi_tcl_b8_GpsFixStatus():u8Value(0)
{}

tS32 cmb_fi_tcl_b8_GpsFixStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B8_GPSFIXSTATUS;
}


cmb_fi_tcl_b8_GpsFixStatus::~cmb_fi_tcl_b8_GpsFixStatus()
{}

tU32 cmb_fi_tcl_b8_GpsFixStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_b8_GpsFixStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& cmb_fi_tcl_b8_GpsFixStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b8_GnssSatSys::cmb_fi_tcl_b8_GnssSatSys():u8Value(0)
{}

tS32 cmb_fi_tcl_b8_GnssSatSys::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B8_GNSSSATSYS;
}


cmb_fi_tcl_b8_GnssSatSys::~cmb_fi_tcl_b8_GnssSatSys()
{}

tU32 cmb_fi_tcl_b8_GnssSatSys::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_b8_GnssSatSys::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& cmb_fi_tcl_b8_GnssSatSys::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_CovarianceMatrixUpperTriangle::cmb_fi_tcl_CovarianceMatrixUpperTriangle(const cmb_fi_tcl_CovarianceMatrixUpperTriangle& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Elem0 = coRef.Elem0;
   Elem4 = coRef.Elem4;
   Elem5 = coRef.Elem5;
   Elem8 = coRef.Elem8;
   Elem9 = coRef.Elem9;
   Elem10 = coRef.Elem10;
}
cmb_fi_tcl_CovarianceMatrixUpperTriangle& cmb_fi_tcl_CovarianceMatrixUpperTriangle::operator=(const cmb_fi_tcl_CovarianceMatrixUpperTriangle& coRef)
{
   if (this == &coRef) return *this;
   Elem0 = coRef.Elem0;
   Elem4 = coRef.Elem4;
   Elem5 = coRef.Elem5;
   Elem8 = coRef.Elem8;
   Elem9 = coRef.Elem9;
   Elem10 = coRef.Elem10;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_CovarianceMatrixUpperTriangle::cmb_fi_tcl_CovarianceMatrixUpperTriangle()
:Elem0(0)
,Elem4(0)
,Elem5(0)
,Elem8(0)
,Elem9(0)
,Elem10(0)
 {}

tS32 cmb_fi_tcl_CovarianceMatrixUpperTriangle::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_COVARIANCEMATRIXUPPERTRIANGLE;
}


cmb_fi_tcl_CovarianceMatrixUpperTriangle::~cmb_fi_tcl_CovarianceMatrixUpperTriangle()
{}

tU32 cmb_fi_tcl_CovarianceMatrixUpperTriangle::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 24;
}

fi_tclInContext& cmb_fi_tcl_CovarianceMatrixUpperTriangle::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Elem0);
   (tVoid) (oIn >> Elem4);
   (tVoid) (oIn >> Elem5);
   (tVoid) (oIn >> Elem8);
   (tVoid) (oIn >> Elem9);
   (tVoid) (oIn >> Elem10);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_CovarianceMatrixUpperTriangle::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Elem0);
   (tVoid) (oOut << Elem4);
   (tVoid) (oOut << Elem5);
   (tVoid) (oOut << Elem8);
   (tVoid) (oOut << Elem9);
   (tVoid) (oOut << Elem10);
   return oOut;
}

tBool cmb_fi_tcl_CovarianceMatrixUpperTriangle::operator==(const cmb_fi_tcl_CovarianceMatrixUpperTriangle& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Elem0 == roRef.Elem0);
   bResult = bResult && (Elem4 == roRef.Elem4);
   bResult = bResult && (Elem5 == roRef.Elem5);
   bResult = bResult && (Elem8 == roRef.Elem8);
   bResult = bResult && (Elem9 == roRef.Elem9);
   bResult = bResult && (Elem10 == roRef.Elem10);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_OdometerData::cmb_fi_tcl_OdometerData(const cmb_fi_tcl_OdometerData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Timestamp = coRef.Timestamp;
   OdometerCount = coRef.OdometerCount;
   OdometerStatus = coRef.OdometerStatus;
   OdometerCount_Direction = coRef.OdometerCount_Direction;
}
cmb_fi_tcl_OdometerData& cmb_fi_tcl_OdometerData::operator=(const cmb_fi_tcl_OdometerData& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   OdometerCount = coRef.OdometerCount;
   OdometerStatus = coRef.OdometerStatus;
   OdometerCount_Direction = coRef.OdometerCount_Direction;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_OdometerData::cmb_fi_tcl_OdometerData()
:Timestamp(0)
,OdometerCount(0)
,OdometerStatus()
,OdometerCount_Direction()
 {}

tS32 cmb_fi_tcl_OdometerData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_ODOMETERDATA;
}


cmb_fi_tcl_OdometerData::~cmb_fi_tcl_OdometerData()
{}

tU32 cmb_fi_tcl_OdometerData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cmb_fi_tcl_OdometerData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> OdometerCount);
   (tVoid) (oIn >> OdometerStatus);
   (tVoid) (oIn >> OdometerCount_Direction);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_OdometerData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << OdometerCount);
   (tVoid) (oOut << OdometerStatus);
   (tVoid) (oOut << OdometerCount_Direction);
   return oOut;
}

tBool cmb_fi_tcl_OdometerData::operator==(const cmb_fi_tcl_OdometerData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (OdometerCount == roRef.OdometerCount);
   bResult = bResult && (OdometerStatus == roRef.OdometerStatus);
   bResult = bResult && (OdometerCount_Direction == roRef.OdometerCount_Direction);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e16_GyroStatus::cmb_fi_tcl_e16_GyroStatus():enType(FI_EN_GYROSTATE_CONNECTED_NORMAL) {}

tS32 cmb_fi_tcl_e16_GyroStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E16_GYROSTATUS;
}


cmb_fi_tcl_e16_GyroStatus::~cmb_fi_tcl_e16_GyroStatus()
{}

tU32 cmb_fi_tcl_e16_GyroStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_e16_GyroStatus::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e16_GyroStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e16_AccStatus::cmb_fi_tcl_e16_AccStatus():enType(FI_EN_ACCSTATE_CONNECTED_NORMAL) {}

tS32 cmb_fi_tcl_e16_AccStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E16_ACCSTATUS;
}


cmb_fi_tcl_e16_AccStatus::~cmb_fi_tcl_e16_AccStatus()
{}

tU32 cmb_fi_tcl_e16_AccStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_e16_AccStatus::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e16_AccStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_GyroData::cmb_fi_tcl_GyroData(const cmb_fi_tcl_GyroData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Timestamp = coRef.Timestamp;
   GyroValue = coRef.GyroValue;
   GyroStatus = coRef.GyroStatus;
}
cmb_fi_tcl_GyroData& cmb_fi_tcl_GyroData::operator=(const cmb_fi_tcl_GyroData& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   GyroValue = coRef.GyroValue;
   GyroStatus = coRef.GyroStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_GyroData::cmb_fi_tcl_GyroData()
:Timestamp(0)
,GyroValue(0)
,GyroStatus()
 {}

tS32 cmb_fi_tcl_GyroData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_GYRODATA;
}


cmb_fi_tcl_GyroData::~cmb_fi_tcl_GyroData()
{}

tU32 cmb_fi_tcl_GyroData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& cmb_fi_tcl_GyroData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> GyroValue);
   (tVoid) (oIn >> GyroStatus);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_GyroData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << GyroValue);
   (tVoid) (oOut << GyroStatus);
   return oOut;
}

tBool cmb_fi_tcl_GyroData::operator==(const cmb_fi_tcl_GyroData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (GyroValue == roRef.GyroValue);
   bResult = bResult && (GyroStatus == roRef.GyroStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b16_GpsChannelStatus::cmb_fi_tcl_b16_GpsChannelStatus():u16Value(0)
{}

tS32 cmb_fi_tcl_b16_GpsChannelStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B16_GPSCHANNELSTATUS;
}


cmb_fi_tcl_b16_GpsChannelStatus::~cmb_fi_tcl_b16_GpsChannelStatus()
{}

tU32 cmb_fi_tcl_b16_GpsChannelStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_b16_GpsChannelStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cmb_fi_tcl_b16_GpsChannelStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_GpsTestAdditionalData::cmb_fi_tcl_GpsTestAdditionalData(const cmb_fi_tcl_GpsTestAdditionalData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   AuxclockTimeStamp = coRef.AuxclockTimeStamp;
   PinToggle = coRef.PinToggle;
   OscillatorFrequencyOffset = coRef.OscillatorFrequencyOffset;
}
cmb_fi_tcl_GpsTestAdditionalData& cmb_fi_tcl_GpsTestAdditionalData::operator=(const cmb_fi_tcl_GpsTestAdditionalData& coRef)
{
   if (this == &coRef) return *this;
   AuxclockTimeStamp = coRef.AuxclockTimeStamp;
   PinToggle = coRef.PinToggle;
   OscillatorFrequencyOffset = coRef.OscillatorFrequencyOffset;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_GpsTestAdditionalData::cmb_fi_tcl_GpsTestAdditionalData()
:AuxclockTimeStamp(0)
,PinToggle(0)
,OscillatorFrequencyOffset(0)
 {}

tS32 cmb_fi_tcl_GpsTestAdditionalData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_GPSTESTADDITIONALDATA;
}


cmb_fi_tcl_GpsTestAdditionalData::~cmb_fi_tcl_GpsTestAdditionalData()
{}

tU32 cmb_fi_tcl_GpsTestAdditionalData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& cmb_fi_tcl_GpsTestAdditionalData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AuxclockTimeStamp);
   (tVoid) (oIn >> PinToggle);
   (tVoid) (oIn >> OscillatorFrequencyOffset);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_GpsTestAdditionalData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AuxclockTimeStamp);
   (tVoid) (oOut << PinToggle);
   (tVoid) (oOut << OscillatorFrequencyOffset);
   return oOut;
}

tBool cmb_fi_tcl_GpsTestAdditionalData::operator==(const cmb_fi_tcl_GpsTestAdditionalData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AuxclockTimeStamp == roRef.AuxclockTimeStamp);
   bResult = bResult && (PinToggle == roRef.PinToggle);
   bResult = bResult && (OscillatorFrequencyOffset == roRef.OscillatorFrequencyOffset);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_GpsBigConstData::cmb_fi_tcl_GpsBigConstData(const cmb_fi_tcl_GpsBigConstData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Version = coRef.Version;
   Year = coRef.Year;
   Month = coRef.Month;
   Day = coRef.Day;
   Hour = coRef.Hour;
   Minute = coRef.Minute;
   Second = coRef.Second;
   HundredthSecond = coRef.HundredthSecond;
   Manufacturer = coRef.Manufacturer;
   HardwareVersion = coRef.HardwareVersion;
   SoftwareVersion = coRef.SoftwareVersion;
   Latitude = coRef.Latitude;
   Longitude = coRef.Longitude;
   AltitudeWGS84 = coRef.AltitudeWGS84;
   AltitudeAboveSealevel = coRef.AltitudeAboveSealevel;
   Speed = coRef.Speed;
   Heading = coRef.Heading;
   PDOP = coRef.PDOP;
   HDOP = coRef.HDOP;
   EstAccuracyPlane = coRef.EstAccuracyPlane;
   EstAccuracyHeight = coRef.EstAccuracyHeight;
   SatellitesHealthy = coRef.SatellitesHealthy;
   SatellitesVisible = coRef.SatellitesVisible;
   SatellitesReceived = coRef.SatellitesReceived;
   SatellitesUsed = coRef.SatellitesUsed;
   ReceivedAlmanac = coRef.ReceivedAlmanac;
   ReceivedEphemeris = coRef.ReceivedEphemeris;
   UpdatesSameConstellation = coRef.UpdatesSameConstellation;
   FixStatus = coRef.FixStatus;
   AntennaStatus = coRef.AntennaStatus;
   UpdateFrequency = coRef.UpdateFrequency;
   NumberOfChannels = coRef.NumberOfChannels;
   EstAccuracySpeed = coRef.EstAccuracySpeed;
   EstAccuracyCourse = coRef.EstAccuracyCourse;
}
cmb_fi_tcl_GpsBigConstData& cmb_fi_tcl_GpsBigConstData::operator=(const cmb_fi_tcl_GpsBigConstData& coRef)
{
   if (this == &coRef) return *this;
   Version = coRef.Version;
   Year = coRef.Year;
   Month = coRef.Month;
   Day = coRef.Day;
   Hour = coRef.Hour;
   Minute = coRef.Minute;
   Second = coRef.Second;
   HundredthSecond = coRef.HundredthSecond;
   Manufacturer = coRef.Manufacturer;
   HardwareVersion = coRef.HardwareVersion;
   SoftwareVersion = coRef.SoftwareVersion;
   Latitude = coRef.Latitude;
   Longitude = coRef.Longitude;
   AltitudeWGS84 = coRef.AltitudeWGS84;
   AltitudeAboveSealevel = coRef.AltitudeAboveSealevel;
   Speed = coRef.Speed;
   Heading = coRef.Heading;
   PDOP = coRef.PDOP;
   HDOP = coRef.HDOP;
   EstAccuracyPlane = coRef.EstAccuracyPlane;
   EstAccuracyHeight = coRef.EstAccuracyHeight;
   SatellitesHealthy = coRef.SatellitesHealthy;
   SatellitesVisible = coRef.SatellitesVisible;
   SatellitesReceived = coRef.SatellitesReceived;
   SatellitesUsed = coRef.SatellitesUsed;
   ReceivedAlmanac = coRef.ReceivedAlmanac;
   ReceivedEphemeris = coRef.ReceivedEphemeris;
   UpdatesSameConstellation = coRef.UpdatesSameConstellation;
   FixStatus = coRef.FixStatus;
   AntennaStatus = coRef.AntennaStatus;
   UpdateFrequency = coRef.UpdateFrequency;
   NumberOfChannels = coRef.NumberOfChannels;
   EstAccuracySpeed = coRef.EstAccuracySpeed;
   EstAccuracyCourse = coRef.EstAccuracyCourse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_GpsBigConstData::cmb_fi_tcl_GpsBigConstData()
:Version(0)
,Year(0)
,Month(0)
,Day(0)
,Hour(0)
,Minute(0)
,Second(0)
,HundredthSecond(0)
,Manufacturer(0)
,HardwareVersion(0)
,SoftwareVersion(0)
,Latitude(0)
,Longitude(0)
,AltitudeWGS84(0)
,AltitudeAboveSealevel(0)
,Speed(0)
,Heading(0)
,PDOP(0)
,HDOP(0)
,EstAccuracyPlane(0)
,EstAccuracyHeight(0)
,SatellitesHealthy(0)
,SatellitesVisible(0)
,SatellitesReceived(0)
,SatellitesUsed(0)
,ReceivedAlmanac(0)
,ReceivedEphemeris(0)
,UpdatesSameConstellation(0)
,FixStatus(0)
,AntennaStatus(0)
,UpdateFrequency(0)
,NumberOfChannels(0)
,EstAccuracySpeed(0)
,EstAccuracyCourse(0)
 {}

tS32 cmb_fi_tcl_GpsBigConstData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_GPSBIGCONSTDATA;
}


cmb_fi_tcl_GpsBigConstData::~cmb_fi_tcl_GpsBigConstData()
{}

tU32 cmb_fi_tcl_GpsBigConstData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 92;
}

fi_tclInContext& cmb_fi_tcl_GpsBigConstData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Version);
   (tVoid) (oIn >> Year);
   (tVoid) (oIn >> Month);
   (tVoid) (oIn >> Day);
   (tVoid) (oIn >> Hour);
   (tVoid) (oIn >> Minute);
   (tVoid) (oIn >> Second);
   (tVoid) (oIn >> HundredthSecond);
   (tVoid) (oIn >> Manufacturer);
   (tVoid) (oIn >> HardwareVersion);
   (tVoid) (oIn >> SoftwareVersion);
   (tVoid) (oIn >> Latitude);
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> AltitudeWGS84);
   (tVoid) (oIn >> AltitudeAboveSealevel);
   (tVoid) (oIn >> Speed);
   (tVoid) (oIn >> Heading);
   (tVoid) (oIn >> PDOP);
   (tVoid) (oIn >> HDOP);
   (tVoid) (oIn >> EstAccuracyPlane);
   (tVoid) (oIn >> EstAccuracyHeight);
   (tVoid) (oIn >> SatellitesHealthy);
   (tVoid) (oIn >> SatellitesVisible);
   (tVoid) (oIn >> SatellitesReceived);
   (tVoid) (oIn >> SatellitesUsed);
   (tVoid) (oIn >> ReceivedAlmanac);
   (tVoid) (oIn >> ReceivedEphemeris);
   (tVoid) (oIn >> UpdatesSameConstellation);
   (tVoid) (oIn >> FixStatus);
   (tVoid) (oIn >> AntennaStatus);
   (tVoid) (oIn >> UpdateFrequency);
   (tVoid) (oIn >> NumberOfChannels);
   (tVoid) (oIn >> EstAccuracySpeed);
   (tVoid) (oIn >> EstAccuracyCourse);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_GpsBigConstData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Version);
   (tVoid) (oOut << Year);
   (tVoid) (oOut << Month);
   (tVoid) (oOut << Day);
   (tVoid) (oOut << Hour);
   (tVoid) (oOut << Minute);
   (tVoid) (oOut << Second);
   (tVoid) (oOut << HundredthSecond);
   (tVoid) (oOut << Manufacturer);
   (tVoid) (oOut << HardwareVersion);
   (tVoid) (oOut << SoftwareVersion);
   (tVoid) (oOut << Latitude);
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << AltitudeWGS84);
   (tVoid) (oOut << AltitudeAboveSealevel);
   (tVoid) (oOut << Speed);
   (tVoid) (oOut << Heading);
   (tVoid) (oOut << PDOP);
   (tVoid) (oOut << HDOP);
   (tVoid) (oOut << EstAccuracyPlane);
   (tVoid) (oOut << EstAccuracyHeight);
   (tVoid) (oOut << SatellitesHealthy);
   (tVoid) (oOut << SatellitesVisible);
   (tVoid) (oOut << SatellitesReceived);
   (tVoid) (oOut << SatellitesUsed);
   (tVoid) (oOut << ReceivedAlmanac);
   (tVoid) (oOut << ReceivedEphemeris);
   (tVoid) (oOut << UpdatesSameConstellation);
   (tVoid) (oOut << FixStatus);
   (tVoid) (oOut << AntennaStatus);
   (tVoid) (oOut << UpdateFrequency);
   (tVoid) (oOut << NumberOfChannels);
   (tVoid) (oOut << EstAccuracySpeed);
   (tVoid) (oOut << EstAccuracyCourse);
   return oOut;
}

tBool cmb_fi_tcl_GpsBigConstData::operator==(const cmb_fi_tcl_GpsBigConstData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Version == roRef.Version);
   bResult = bResult && (Year == roRef.Year);
   bResult = bResult && (Month == roRef.Month);
   bResult = bResult && (Day == roRef.Day);
   bResult = bResult && (Hour == roRef.Hour);
   bResult = bResult && (Minute == roRef.Minute);
   bResult = bResult && (Second == roRef.Second);
   bResult = bResult && (HundredthSecond == roRef.HundredthSecond);
   bResult = bResult && (Manufacturer == roRef.Manufacturer);
   bResult = bResult && (HardwareVersion == roRef.HardwareVersion);
   bResult = bResult && (SoftwareVersion == roRef.SoftwareVersion);
   bResult = bResult && (Latitude == roRef.Latitude);
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (AltitudeWGS84 == roRef.AltitudeWGS84);
   bResult = bResult && (AltitudeAboveSealevel == roRef.AltitudeAboveSealevel);
   bResult = bResult && (Speed == roRef.Speed);
   bResult = bResult && (Heading == roRef.Heading);
   bResult = bResult && (PDOP == roRef.PDOP);
   bResult = bResult && (HDOP == roRef.HDOP);
   bResult = bResult && (EstAccuracyPlane == roRef.EstAccuracyPlane);
   bResult = bResult && (EstAccuracyHeight == roRef.EstAccuracyHeight);
   bResult = bResult && (SatellitesHealthy == roRef.SatellitesHealthy);
   bResult = bResult && (SatellitesVisible == roRef.SatellitesVisible);
   bResult = bResult && (SatellitesReceived == roRef.SatellitesReceived);
   bResult = bResult && (SatellitesUsed == roRef.SatellitesUsed);
   bResult = bResult && (ReceivedAlmanac == roRef.ReceivedAlmanac);
   bResult = bResult && (ReceivedEphemeris == roRef.ReceivedEphemeris);
   bResult = bResult && (UpdatesSameConstellation == roRef.UpdatesSameConstellation);
   bResult = bResult && (FixStatus == roRef.FixStatus);
   bResult = bResult && (AntennaStatus == roRef.AntennaStatus);
   bResult = bResult && (UpdateFrequency == roRef.UpdateFrequency);
   bResult = bResult && (NumberOfChannels == roRef.NumberOfChannels);
   bResult = bResult && (EstAccuracySpeed == roRef.EstAccuracySpeed);
   bResult = bResult && (EstAccuracyCourse == roRef.EstAccuracyCourse);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b32_GpsValidFlags::cmb_fi_tcl_b32_GpsValidFlags():u32Value(0)
{}

tS32 cmb_fi_tcl_b32_GpsValidFlags::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B32_GPSVALIDFLAGS;
}


cmb_fi_tcl_b32_GpsValidFlags::~cmb_fi_tcl_b32_GpsValidFlags()
{}

tU32 cmb_fi_tcl_b32_GpsValidFlags::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_b32_GpsValidFlags::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& cmb_fi_tcl_b32_GpsValidFlags::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_GpsExtBigConstData::cmb_fi_tcl_GpsExtBigConstData(const cmb_fi_tcl_GpsExtBigConstData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Version = coRef.Version;
   Year = coRef.Year;
   Month = coRef.Month;
   Day = coRef.Day;
   Hour = coRef.Hour;
   Minute = coRef.Minute;
   Second = coRef.Second;
   HundredthSecond = coRef.HundredthSecond;
   Manufacturer = coRef.Manufacturer;
   HardwareVersion = coRef.HardwareVersion;
   SoftwareVersion = coRef.SoftwareVersion;
   Latitude = coRef.Latitude;
   Longitude = coRef.Longitude;
   AltitudeWGS84 = coRef.AltitudeWGS84;
   LatitudeFiltered = coRef.LatitudeFiltered;
   LongitudeFiltered = coRef.LongitudeFiltered;
   AltitudeWGS84Filtered = coRef.AltitudeWGS84Filtered;
   GeoidalSeparation = coRef.GeoidalSeparation;
   VelocityNorth = coRef.VelocityNorth;
   VelocityEast = coRef.VelocityEast;
   VelocityUp = coRef.VelocityUp;
   VelocityNorthFiltered = coRef.VelocityNorthFiltered;
   VelocityEastFiltered = coRef.VelocityEastFiltered;
   VelocityUpFiltered = coRef.VelocityUpFiltered;
   PositionCovarianceMatrix = coRef.PositionCovarianceMatrix;
   VelocityCovarianceMatrix = coRef.VelocityCovarianceMatrix;
   PositionRangeResidualMax = coRef.PositionRangeResidualMax;
   VelocityRangeResidualMax = coRef.VelocityRangeResidualMax;
   ValidFlags = coRef.ValidFlags;
   PDOP = coRef.PDOP;
   HDOP = coRef.HDOP;
   SatellitesHealthy = coRef.SatellitesHealthy;
   SatellitesVisible = coRef.SatellitesVisible;
   SatellitesReceived = coRef.SatellitesReceived;
   SatellitesUsed = coRef.SatellitesUsed;
   ReceivedAlmanac = coRef.ReceivedAlmanac;
   ReceivedEphemeris = coRef.ReceivedEphemeris;
   UpdatesSameConstellation = coRef.UpdatesSameConstellation;
   FixStatus = coRef.FixStatus;
   AntennaStatus = coRef.AntennaStatus;
   UpdateFrequency = coRef.UpdateFrequency;
   NumberOfChannels = coRef.NumberOfChannels;
}
cmb_fi_tcl_GpsExtBigConstData& cmb_fi_tcl_GpsExtBigConstData::operator=(const cmb_fi_tcl_GpsExtBigConstData& coRef)
{
   if (this == &coRef) return *this;
   Version = coRef.Version;
   Year = coRef.Year;
   Month = coRef.Month;
   Day = coRef.Day;
   Hour = coRef.Hour;
   Minute = coRef.Minute;
   Second = coRef.Second;
   HundredthSecond = coRef.HundredthSecond;
   Manufacturer = coRef.Manufacturer;
   HardwareVersion = coRef.HardwareVersion;
   SoftwareVersion = coRef.SoftwareVersion;
   Latitude = coRef.Latitude;
   Longitude = coRef.Longitude;
   AltitudeWGS84 = coRef.AltitudeWGS84;
   LatitudeFiltered = coRef.LatitudeFiltered;
   LongitudeFiltered = coRef.LongitudeFiltered;
   AltitudeWGS84Filtered = coRef.AltitudeWGS84Filtered;
   GeoidalSeparation = coRef.GeoidalSeparation;
   VelocityNorth = coRef.VelocityNorth;
   VelocityEast = coRef.VelocityEast;
   VelocityUp = coRef.VelocityUp;
   VelocityNorthFiltered = coRef.VelocityNorthFiltered;
   VelocityEastFiltered = coRef.VelocityEastFiltered;
   VelocityUpFiltered = coRef.VelocityUpFiltered;
   PositionCovarianceMatrix = coRef.PositionCovarianceMatrix;
   VelocityCovarianceMatrix = coRef.VelocityCovarianceMatrix;
   PositionRangeResidualMax = coRef.PositionRangeResidualMax;
   VelocityRangeResidualMax = coRef.VelocityRangeResidualMax;
   ValidFlags = coRef.ValidFlags;
   PDOP = coRef.PDOP;
   HDOP = coRef.HDOP;
   SatellitesHealthy = coRef.SatellitesHealthy;
   SatellitesVisible = coRef.SatellitesVisible;
   SatellitesReceived = coRef.SatellitesReceived;
   SatellitesUsed = coRef.SatellitesUsed;
   ReceivedAlmanac = coRef.ReceivedAlmanac;
   ReceivedEphemeris = coRef.ReceivedEphemeris;
   UpdatesSameConstellation = coRef.UpdatesSameConstellation;
   FixStatus = coRef.FixStatus;
   AntennaStatus = coRef.AntennaStatus;
   UpdateFrequency = coRef.UpdateFrequency;
   NumberOfChannels = coRef.NumberOfChannels;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_GpsExtBigConstData::cmb_fi_tcl_GpsExtBigConstData()
:Version(0)
,Year(0)
,Month(0)
,Day(0)
,Hour(0)
,Minute(0)
,Second(0)
,HundredthSecond(0)
,Manufacturer()
,HardwareVersion()
,SoftwareVersion(0)
,Latitude(0)
,Longitude(0)
,AltitudeWGS84(0)
,LatitudeFiltered(0)
,LongitudeFiltered(0)
,AltitudeWGS84Filtered(0)
,GeoidalSeparation(0)
,VelocityNorth(0)
,VelocityEast(0)
,VelocityUp(0)
,VelocityNorthFiltered(0)
,VelocityEastFiltered(0)
,VelocityUpFiltered(0)
,PositionCovarianceMatrix()
,VelocityCovarianceMatrix()
,PositionRangeResidualMax(0)
,VelocityRangeResidualMax(0)
,ValidFlags()
,PDOP(0)
,HDOP(0)
,SatellitesHealthy(0)
,SatellitesVisible(0)
,SatellitesReceived(0)
,SatellitesUsed(0)
,ReceivedAlmanac(0)
,ReceivedEphemeris(0)
,UpdatesSameConstellation(0)
,FixStatus()
,AntennaStatus()
,UpdateFrequency(0)
,NumberOfChannels(0)
 {}

tS32 cmb_fi_tcl_GpsExtBigConstData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_GPSEXTBIGCONSTDATA;
}


cmb_fi_tcl_GpsExtBigConstData::~cmb_fi_tcl_GpsExtBigConstData()
{}

tU32 cmb_fi_tcl_GpsExtBigConstData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 172;
}

fi_tclInContext& cmb_fi_tcl_GpsExtBigConstData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Version);
   (tVoid) (oIn >> Year);
   (tVoid) (oIn >> Month);
   (tVoid) (oIn >> Day);
   (tVoid) (oIn >> Hour);
   (tVoid) (oIn >> Minute);
   (tVoid) (oIn >> Second);
   (tVoid) (oIn >> HundredthSecond);
   (tVoid) (oIn >> Manufacturer);
   (tVoid) (oIn >> HardwareVersion);
   (tVoid) (oIn >> SoftwareVersion);
   (tVoid) (oIn >> Latitude);
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> AltitudeWGS84);
   (tVoid) (oIn >> LatitudeFiltered);
   (tVoid) (oIn >> LongitudeFiltered);
   (tVoid) (oIn >> AltitudeWGS84Filtered);
   (tVoid) (oIn >> GeoidalSeparation);
   (tVoid) (oIn >> VelocityNorth);
   (tVoid) (oIn >> VelocityEast);
   (tVoid) (oIn >> VelocityUp);
   (tVoid) (oIn >> VelocityNorthFiltered);
   (tVoid) (oIn >> VelocityEastFiltered);
   (tVoid) (oIn >> VelocityUpFiltered);
   (tVoid) (oIn >> PositionCovarianceMatrix);
   (tVoid) (oIn >> VelocityCovarianceMatrix);
   (tVoid) (oIn >> PositionRangeResidualMax);
   (tVoid) (oIn >> VelocityRangeResidualMax);
   (tVoid) (oIn >> ValidFlags);
   (tVoid) (oIn >> PDOP);
   (tVoid) (oIn >> HDOP);
   (tVoid) (oIn >> SatellitesHealthy);
   (tVoid) (oIn >> SatellitesVisible);
   (tVoid) (oIn >> SatellitesReceived);
   (tVoid) (oIn >> SatellitesUsed);
   (tVoid) (oIn >> ReceivedAlmanac);
   (tVoid) (oIn >> ReceivedEphemeris);
   (tVoid) (oIn >> UpdatesSameConstellation);
   (tVoid) (oIn >> FixStatus);
   (tVoid) (oIn >> AntennaStatus);
   (tVoid) (oIn >> UpdateFrequency);
   (tVoid) (oIn >> NumberOfChannels);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_GpsExtBigConstData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Version);
   (tVoid) (oOut << Year);
   (tVoid) (oOut << Month);
   (tVoid) (oOut << Day);
   (tVoid) (oOut << Hour);
   (tVoid) (oOut << Minute);
   (tVoid) (oOut << Second);
   (tVoid) (oOut << HundredthSecond);
   (tVoid) (oOut << Manufacturer);
   (tVoid) (oOut << HardwareVersion);
   (tVoid) (oOut << SoftwareVersion);
   (tVoid) (oOut << Latitude);
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << AltitudeWGS84);
   (tVoid) (oOut << LatitudeFiltered);
   (tVoid) (oOut << LongitudeFiltered);
   (tVoid) (oOut << AltitudeWGS84Filtered);
   (tVoid) (oOut << GeoidalSeparation);
   (tVoid) (oOut << VelocityNorth);
   (tVoid) (oOut << VelocityEast);
   (tVoid) (oOut << VelocityUp);
   (tVoid) (oOut << VelocityNorthFiltered);
   (tVoid) (oOut << VelocityEastFiltered);
   (tVoid) (oOut << VelocityUpFiltered);
   (tVoid) (oOut << PositionCovarianceMatrix);
   (tVoid) (oOut << VelocityCovarianceMatrix);
   (tVoid) (oOut << PositionRangeResidualMax);
   (tVoid) (oOut << VelocityRangeResidualMax);
   (tVoid) (oOut << ValidFlags);
   (tVoid) (oOut << PDOP);
   (tVoid) (oOut << HDOP);
   (tVoid) (oOut << SatellitesHealthy);
   (tVoid) (oOut << SatellitesVisible);
   (tVoid) (oOut << SatellitesReceived);
   (tVoid) (oOut << SatellitesUsed);
   (tVoid) (oOut << ReceivedAlmanac);
   (tVoid) (oOut << ReceivedEphemeris);
   (tVoid) (oOut << UpdatesSameConstellation);
   (tVoid) (oOut << FixStatus);
   (tVoid) (oOut << AntennaStatus);
   (tVoid) (oOut << UpdateFrequency);
   (tVoid) (oOut << NumberOfChannels);
   return oOut;
}

tBool cmb_fi_tcl_GpsExtBigConstData::operator==(const cmb_fi_tcl_GpsExtBigConstData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Version == roRef.Version);
   bResult = bResult && (Year == roRef.Year);
   bResult = bResult && (Month == roRef.Month);
   bResult = bResult && (Day == roRef.Day);
   bResult = bResult && (Hour == roRef.Hour);
   bResult = bResult && (Minute == roRef.Minute);
   bResult = bResult && (Second == roRef.Second);
   bResult = bResult && (HundredthSecond == roRef.HundredthSecond);
   bResult = bResult && (Manufacturer == roRef.Manufacturer);
   bResult = bResult && (HardwareVersion == roRef.HardwareVersion);
   bResult = bResult && (SoftwareVersion == roRef.SoftwareVersion);
   bResult = bResult && (Latitude == roRef.Latitude);
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (AltitudeWGS84 == roRef.AltitudeWGS84);
   bResult = bResult && (LatitudeFiltered == roRef.LatitudeFiltered);
   bResult = bResult && (LongitudeFiltered == roRef.LongitudeFiltered);
   bResult = bResult && (AltitudeWGS84Filtered == roRef.AltitudeWGS84Filtered);
   bResult = bResult && (GeoidalSeparation == roRef.GeoidalSeparation);
   bResult = bResult && (VelocityNorth == roRef.VelocityNorth);
   bResult = bResult && (VelocityEast == roRef.VelocityEast);
   bResult = bResult && (VelocityUp == roRef.VelocityUp);
   bResult = bResult && (VelocityNorthFiltered == roRef.VelocityNorthFiltered);
   bResult = bResult && (VelocityEastFiltered == roRef.VelocityEastFiltered);
   bResult = bResult && (VelocityUpFiltered == roRef.VelocityUpFiltered);
   bResult = bResult && (PositionCovarianceMatrix == roRef.PositionCovarianceMatrix);
   bResult = bResult && (VelocityCovarianceMatrix == roRef.VelocityCovarianceMatrix);
   bResult = bResult && (PositionRangeResidualMax == roRef.PositionRangeResidualMax);
   bResult = bResult && (VelocityRangeResidualMax == roRef.VelocityRangeResidualMax);
   bResult = bResult && (ValidFlags == roRef.ValidFlags);
   bResult = bResult && (PDOP == roRef.PDOP);
   bResult = bResult && (HDOP == roRef.HDOP);
   bResult = bResult && (SatellitesHealthy == roRef.SatellitesHealthy);
   bResult = bResult && (SatellitesVisible == roRef.SatellitesVisible);
   bResult = bResult && (SatellitesReceived == roRef.SatellitesReceived);
   bResult = bResult && (SatellitesUsed == roRef.SatellitesUsed);
   bResult = bResult && (ReceivedAlmanac == roRef.ReceivedAlmanac);
   bResult = bResult && (ReceivedEphemeris == roRef.ReceivedEphemeris);
   bResult = bResult && (UpdatesSameConstellation == roRef.UpdatesSameConstellation);
   bResult = bResult && (FixStatus == roRef.FixStatus);
   bResult = bResult && (AntennaStatus == roRef.AntennaStatus);
   bResult = bResult && (UpdateFrequency == roRef.UpdateFrequency);
   bResult = bResult && (NumberOfChannels == roRef.NumberOfChannels);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b32_MapMatchingHint::cmb_fi_tcl_b32_MapMatchingHint():u32Value(0)
{}

tS32 cmb_fi_tcl_b32_MapMatchingHint::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B32_MAPMATCHINGHINT;
}


cmb_fi_tcl_b32_MapMatchingHint::~cmb_fi_tcl_b32_MapMatchingHint()
{}

tU32 cmb_fi_tcl_b32_MapMatchingHint::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_b32_MapMatchingHint::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& cmb_fi_tcl_b32_MapMatchingHint::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_GpsBigVarData::cmb_fi_tcl_GpsBigVarData(const cmb_fi_tcl_GpsBigVarData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   SatId = coRef.SatId;
   ChannelStatus = coRef.ChannelStatus;
   ExtendedStatus = coRef.ExtendedStatus;
   Azimuth = coRef.Azimuth;
   Elevation = coRef.Elevation;
   CarrierToNoiseRatio = coRef.CarrierToNoiseRatio;
}
cmb_fi_tcl_GpsBigVarData& cmb_fi_tcl_GpsBigVarData::operator=(const cmb_fi_tcl_GpsBigVarData& coRef)
{
   if (this == &coRef) return *this;
   SatId = coRef.SatId;
   ChannelStatus = coRef.ChannelStatus;
   ExtendedStatus = coRef.ExtendedStatus;
   Azimuth = coRef.Azimuth;
   Elevation = coRef.Elevation;
   CarrierToNoiseRatio = coRef.CarrierToNoiseRatio;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_GpsBigVarData::cmb_fi_tcl_GpsBigVarData()
:SatId(0)
,ChannelStatus(0)
,ExtendedStatus(0)
,Azimuth(0)
,Elevation(0)
,CarrierToNoiseRatio(0)
 {}

tS32 cmb_fi_tcl_GpsBigVarData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_GPSBIGVARDATA;
}


cmb_fi_tcl_GpsBigVarData::~cmb_fi_tcl_GpsBigVarData()
{}

tU32 cmb_fi_tcl_GpsBigVarData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& cmb_fi_tcl_GpsBigVarData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SatId);
   (tVoid) (oIn >> ChannelStatus);
   (tVoid) (oIn >> ExtendedStatus);
   (tVoid) (oIn >> Azimuth);
   (tVoid) (oIn >> Elevation);
   (tVoid) (oIn >> CarrierToNoiseRatio);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_GpsBigVarData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SatId);
   (tVoid) (oOut << ChannelStatus);
   (tVoid) (oOut << ExtendedStatus);
   (tVoid) (oOut << Azimuth);
   (tVoid) (oOut << Elevation);
   (tVoid) (oOut << CarrierToNoiseRatio);
   return oOut;
}

tBool cmb_fi_tcl_GpsBigVarData::operator==(const cmb_fi_tcl_GpsBigVarData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SatId == roRef.SatId);
   bResult = bResult && (ChannelStatus == roRef.ChannelStatus);
   bResult = bResult && (ExtendedStatus == roRef.ExtendedStatus);
   bResult = bResult && (Azimuth == roRef.Azimuth);
   bResult = bResult && (Elevation == roRef.Elevation);
   bResult = bResult && (CarrierToNoiseRatio == roRef.CarrierToNoiseRatio);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_GpsBigdata::cmb_fi_tcl_GpsBigdata(const cmb_fi_tcl_GpsBigdata& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Timestamp = coRef.Timestamp;
   GpsBigConstData = coRef.GpsBigConstData;
   GpsBigVarData = coRef.GpsBigVarData;
}
cmb_fi_tcl_GpsBigdata& cmb_fi_tcl_GpsBigdata::operator=(const cmb_fi_tcl_GpsBigdata& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   GpsBigConstData = coRef.GpsBigConstData;
   GpsBigVarData = coRef.GpsBigVarData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_GpsBigdata::vDestroy()
{
   GpsBigConstData.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < GpsBigVarData.size(); ++u32Idx)
         GpsBigVarData[u32Idx].vDestroy();
   GpsBigVarData.clear();
   }
}

cmb_fi_tcl_GpsBigdata::cmb_fi_tcl_GpsBigdata()
:Timestamp(0)
,GpsBigConstData()

 {}

tS32 cmb_fi_tcl_GpsBigdata::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_GPSBIGDATA;
}


cmb_fi_tcl_GpsBigdata::~cmb_fi_tcl_GpsBigdata()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_GpsBigdata::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 100+ static_cast<tU32>(GpsBigVarData.size()*16);
}

fi_tclInContext& cmb_fi_tcl_GpsBigdata::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> GpsBigConstData);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < GpsBigVarData.size(); ++u32Idx)
      {
         GpsBigVarData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      GpsBigVarData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> GpsBigVarData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_GpsBigdata::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << GpsBigConstData);
   (tVoid) (oOut << (tU32)GpsBigVarData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < GpsBigVarData.size(); ++u32Idx)
         (tVoid) (oOut << GpsBigVarData[u32Idx]);
   }
   return oOut;
}

tBool cmb_fi_tcl_GpsBigdata::operator==(const cmb_fi_tcl_GpsBigdata& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (GpsBigConstData == roRef.GpsBigConstData);
      bResult = bResult && (GpsBigVarData.size() == roRef.GpsBigVarData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < GpsBigVarData.size()); ++u32Idx)
            bResult = bResult && (GpsBigVarData[u32Idx] == roRef.GpsBigVarData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_GpsExtBigData::cmb_fi_tcl_GpsExtBigData(const cmb_fi_tcl_GpsExtBigData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Timestamp = coRef.Timestamp;
   GpsExtBigConstData = coRef.GpsExtBigConstData;
   GpsBigVarData = coRef.GpsBigVarData;
}
cmb_fi_tcl_GpsExtBigData& cmb_fi_tcl_GpsExtBigData::operator=(const cmb_fi_tcl_GpsExtBigData& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   GpsExtBigConstData = coRef.GpsExtBigConstData;
   GpsBigVarData = coRef.GpsBigVarData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_GpsExtBigData::vDestroy()
{
   GpsExtBigConstData.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < GpsBigVarData.size(); ++u32Idx)
         GpsBigVarData[u32Idx].vDestroy();
   GpsBigVarData.clear();
   }
}

cmb_fi_tcl_GpsExtBigData::cmb_fi_tcl_GpsExtBigData()
:Timestamp(0)
,GpsExtBigConstData()

 {}

tS32 cmb_fi_tcl_GpsExtBigData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_GPSEXTBIGDATA;
}


cmb_fi_tcl_GpsExtBigData::~cmb_fi_tcl_GpsExtBigData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_GpsExtBigData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 180+ static_cast<tU32>(GpsBigVarData.size()*16);
}

fi_tclInContext& cmb_fi_tcl_GpsExtBigData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> GpsExtBigConstData);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < GpsBigVarData.size(); ++u32Idx)
      {
         GpsBigVarData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      GpsBigVarData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> GpsBigVarData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_GpsExtBigData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << GpsExtBigConstData);
   (tVoid) (oOut << (tU32)GpsBigVarData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < GpsBigVarData.size(); ++u32Idx)
         (tVoid) (oOut << GpsBigVarData[u32Idx]);
   }
   return oOut;
}

tBool cmb_fi_tcl_GpsExtBigData::operator==(const cmb_fi_tcl_GpsExtBigData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (GpsExtBigConstData == roRef.GpsExtBigConstData);
      bResult = bResult && (GpsBigVarData.size() == roRef.GpsBigVarData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < GpsBigVarData.size()); ++u32Idx)
            bResult = bResult && (GpsBigVarData[u32Idx] == roRef.GpsBigVarData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_GpsCommunicationProtocol::cmb_fi_tcl_GpsCommunicationProtocol(const cmb_fi_tcl_GpsCommunicationProtocol& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   GpsProtocol = coRef.GpsProtocol;
   CommBaudrate = coRef.CommBaudrate;
   CommParity = coRef.CommParity;
   CommStopBits = coRef.CommStopBits;
}
cmb_fi_tcl_GpsCommunicationProtocol& cmb_fi_tcl_GpsCommunicationProtocol::operator=(const cmb_fi_tcl_GpsCommunicationProtocol& coRef)
{
   if (this == &coRef) return *this;
   GpsProtocol = coRef.GpsProtocol;
   CommBaudrate = coRef.CommBaudrate;
   CommParity = coRef.CommParity;
   CommStopBits = coRef.CommStopBits;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_GpsCommunicationProtocol::cmb_fi_tcl_GpsCommunicationProtocol()
:GpsProtocol(0)
,CommBaudrate(0)
,CommParity(0)
,CommStopBits(0)
 {}

tS32 cmb_fi_tcl_GpsCommunicationProtocol::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_GPSCOMMUNICATIONPROTOCOL;
}


cmb_fi_tcl_GpsCommunicationProtocol::~cmb_fi_tcl_GpsCommunicationProtocol()
{}

tU32 cmb_fi_tcl_GpsCommunicationProtocol::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_GpsCommunicationProtocol::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> GpsProtocol);
   (tVoid) (oIn >> CommBaudrate);
   (tVoid) (oIn >> CommParity);
   (tVoid) (oIn >> CommStopBits);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_GpsCommunicationProtocol::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << GpsProtocol);
   (tVoid) (oOut << CommBaudrate);
   (tVoid) (oOut << CommParity);
   (tVoid) (oOut << CommStopBits);
   return oOut;
}

tBool cmb_fi_tcl_GpsCommunicationProtocol::operator==(const cmb_fi_tcl_GpsCommunicationProtocol& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (GpsProtocol == roRef.GpsProtocol);
   bResult = bResult && (CommBaudrate == roRef.CommBaudrate);
   bResult = bResult && (CommParity == roRef.CommParity);
   bResult = bResult && (CommStopBits == roRef.CommStopBits);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_SetData::cmb_fi_tcl_SetData(const cmb_fi_tcl_SetData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   ClkOffset = coRef.ClkOffset;
   SvId = coRef.SvId;
   NoPasses = coRef.NoPasses;
}
cmb_fi_tcl_SetData& cmb_fi_tcl_SetData::operator=(const cmb_fi_tcl_SetData& coRef)
{
   if (this == &coRef) return *this;
   ClkOffset = coRef.ClkOffset;
   SvId = coRef.SvId;
   NoPasses = coRef.NoPasses;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_SetData::cmb_fi_tcl_SetData()
:ClkOffset(0)
,SvId(0)
,NoPasses(0)
 {}

tS32 cmb_fi_tcl_SetData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_SETDATA;
}


cmb_fi_tcl_SetData::~cmb_fi_tcl_SetData()
{}

tU32 cmb_fi_tcl_SetData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& cmb_fi_tcl_SetData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ClkOffset);
   (tVoid) (oIn >> SvId);
   (tVoid) (oIn >> NoPasses);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_SetData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ClkOffset);
   (tVoid) (oOut << SvId);
   (tVoid) (oOut << NoPasses);
   return oOut;
}

tBool cmb_fi_tcl_SetData::operator==(const cmb_fi_tcl_SetData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ClkOffset == roRef.ClkOffset);
   bResult = bResult && (SvId == roRef.SvId);
   bResult = bResult && (NoPasses == roRef.NoPasses);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_TestModeData::cmb_fi_tcl_TestModeData(const cmb_fi_tcl_TestModeData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   ClkOffset = coRef.ClkOffset;
   ClkDrift = coRef.ClkDrift;
   TimeToBitSync = coRef.TimeToBitSync;
   ISignal = coRef.ISignal;
   QSignal = coRef.QSignal;
   PoorStatusCount = coRef.PoorStatusCount;
   BadBitCount = coRef.BadBitCount;
   CNoMean = coRef.CNoMean;
   CNoSigma = coRef.CNoSigma;
   CNoEffective = coRef.CNoEffective;
   SvId = coRef.SvId;
}
cmb_fi_tcl_TestModeData& cmb_fi_tcl_TestModeData::operator=(const cmb_fi_tcl_TestModeData& coRef)
{
   if (this == &coRef) return *this;
   ClkOffset = coRef.ClkOffset;
   ClkDrift = coRef.ClkDrift;
   TimeToBitSync = coRef.TimeToBitSync;
   ISignal = coRef.ISignal;
   QSignal = coRef.QSignal;
   PoorStatusCount = coRef.PoorStatusCount;
   BadBitCount = coRef.BadBitCount;
   CNoMean = coRef.CNoMean;
   CNoSigma = coRef.CNoSigma;
   CNoEffective = coRef.CNoEffective;
   SvId = coRef.SvId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_TestModeData::cmb_fi_tcl_TestModeData()
:ClkOffset(0)
,ClkDrift(0)
,TimeToBitSync(0)
,ISignal(0)
,QSignal(0)
,PoorStatusCount(0)
,BadBitCount(0)
,CNoMean(0)
,CNoSigma(0)
,CNoEffective(0)
,SvId(0)
 {}

tS32 cmb_fi_tcl_TestModeData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_TESTMODEDATA;
}


cmb_fi_tcl_TestModeData::~cmb_fi_tcl_TestModeData()
{}

tU32 cmb_fi_tcl_TestModeData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 31;
}

fi_tclInContext& cmb_fi_tcl_TestModeData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ClkOffset);
   (tVoid) (oIn >> ClkDrift);
   (tVoid) (oIn >> TimeToBitSync);
   (tVoid) (oIn >> ISignal);
   (tVoid) (oIn >> QSignal);
   (tVoid) (oIn >> PoorStatusCount);
   (tVoid) (oIn >> BadBitCount);
   (tVoid) (oIn >> CNoMean);
   (tVoid) (oIn >> CNoSigma);
   (tVoid) (oIn >> CNoEffective);
   (tVoid) (oIn >> SvId);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_TestModeData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ClkOffset);
   (tVoid) (oOut << ClkDrift);
   (tVoid) (oOut << TimeToBitSync);
   (tVoid) (oOut << ISignal);
   (tVoid) (oOut << QSignal);
   (tVoid) (oOut << PoorStatusCount);
   (tVoid) (oOut << BadBitCount);
   (tVoid) (oOut << CNoMean);
   (tVoid) (oOut << CNoSigma);
   (tVoid) (oOut << CNoEffective);
   (tVoid) (oOut << SvId);
   return oOut;
}

tBool cmb_fi_tcl_TestModeData::operator==(const cmb_fi_tcl_TestModeData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ClkOffset == roRef.ClkOffset);
   bResult = bResult && (ClkDrift == roRef.ClkDrift);
   bResult = bResult && (TimeToBitSync == roRef.TimeToBitSync);
   bResult = bResult && (ISignal == roRef.ISignal);
   bResult = bResult && (QSignal == roRef.QSignal);
   bResult = bResult && (PoorStatusCount == roRef.PoorStatusCount);
   bResult = bResult && (BadBitCount == roRef.BadBitCount);
   bResult = bResult && (CNoMean == roRef.CNoMean);
   bResult = bResult && (CNoSigma == roRef.CNoSigma);
   bResult = bResult && (CNoEffective == roRef.CNoEffective);
   bResult = bResult && (SvId == roRef.SvId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_XoCompensation::cmb_fi_tcl_XoCompensation(const cmb_fi_tcl_XoCompensation& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Tow = coRef.Tow;
   Temperature = coRef.Temperature;
   C0 = coRef.C0;
   C1 = coRef.C1;
   C2 = coRef.C2;
   C3 = coRef.C3;
   Week = coRef.Week;
}
cmb_fi_tcl_XoCompensation& cmb_fi_tcl_XoCompensation::operator=(const cmb_fi_tcl_XoCompensation& coRef)
{
   if (this == &coRef) return *this;
   Tow = coRef.Tow;
   Temperature = coRef.Temperature;
   C0 = coRef.C0;
   C1 = coRef.C1;
   C2 = coRef.C2;
   C3 = coRef.C3;
   Week = coRef.Week;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_XoCompensation::cmb_fi_tcl_XoCompensation()
:Tow(0)
,Temperature(0)
,C0(0)
,C1(0)
,C2(0)
,C3(0)
,Week(0)
 {}

tS32 cmb_fi_tcl_XoCompensation::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_XOCOMPENSATION;
}


cmb_fi_tcl_XoCompensation::~cmb_fi_tcl_XoCompensation()
{}

tU32 cmb_fi_tcl_XoCompensation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 26;
}

fi_tclInContext& cmb_fi_tcl_XoCompensation::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Tow);
   (tVoid) (oIn >> Temperature);
   (tVoid) (oIn >> C0);
   (tVoid) (oIn >> C1);
   (tVoid) (oIn >> C2);
   (tVoid) (oIn >> C3);
   (tVoid) (oIn >> Week);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_XoCompensation::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Tow);
   (tVoid) (oOut << Temperature);
   (tVoid) (oOut << C0);
   (tVoid) (oOut << C1);
   (tVoid) (oOut << C2);
   (tVoid) (oOut << C3);
   (tVoid) (oOut << Week);
   return oOut;
}

tBool cmb_fi_tcl_XoCompensation::operator==(const cmb_fi_tcl_XoCompensation& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Tow == roRef.Tow);
   bResult = bResult && (Temperature == roRef.Temperature);
   bResult = bResult && (C0 == roRef.C0);
   bResult = bResult && (C1 == roRef.C1);
   bResult = bResult && (C2 == roRef.C2);
   bResult = bResult && (C3 == roRef.C3);
   bResult = bResult && (Week == roRef.Week);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VectorLLA::cmb_fi_tcl_VectorLLA(const cmb_fi_tcl_VectorLLA& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Latitude = coRef.Latitude;
   Longitude = coRef.Longitude;
   Altitude = coRef.Altitude;
}
cmb_fi_tcl_VectorLLA& cmb_fi_tcl_VectorLLA::operator=(const cmb_fi_tcl_VectorLLA& coRef)
{
   if (this == &coRef) return *this;
   Latitude = coRef.Latitude;
   Longitude = coRef.Longitude;
   Altitude = coRef.Altitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_VectorLLA::cmb_fi_tcl_VectorLLA()
:Latitude(0)
,Longitude(0)
,Altitude(0)
 {}

tS32 cmb_fi_tcl_VectorLLA::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VECTORLLA;
}


cmb_fi_tcl_VectorLLA::~cmb_fi_tcl_VectorLLA()
{}

tU32 cmb_fi_tcl_VectorLLA::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 24;
}

fi_tclInContext& cmb_fi_tcl_VectorLLA::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Latitude);
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Altitude);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VectorLLA::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Latitude);
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Altitude);
   return oOut;
}

tBool cmb_fi_tcl_VectorLLA::operator==(const cmb_fi_tcl_VectorLLA& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Latitude == roRef.Latitude);
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (Altitude == roRef.Altitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VectorNEU::cmb_fi_tcl_VectorNEU(const cmb_fi_tcl_VectorNEU& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   North = coRef.North;
   East = coRef.East;
   Up = coRef.Up;
}
cmb_fi_tcl_VectorNEU& cmb_fi_tcl_VectorNEU::operator=(const cmb_fi_tcl_VectorNEU& coRef)
{
   if (this == &coRef) return *this;
   North = coRef.North;
   East = coRef.East;
   Up = coRef.Up;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_VectorNEU::cmb_fi_tcl_VectorNEU()
:North(0)
,East(0)
,Up(0)
 {}

tS32 cmb_fi_tcl_VectorNEU::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VECTORNEU;
}


cmb_fi_tcl_VectorNEU::~cmb_fi_tcl_VectorNEU()
{}

tU32 cmb_fi_tcl_VectorNEU::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& cmb_fi_tcl_VectorNEU::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> North);
   (tVoid) (oIn >> East);
   (tVoid) (oIn >> Up);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VectorNEU::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << North);
   (tVoid) (oOut << East);
   (tVoid) (oOut << Up);
   return oOut;
}

tBool cmb_fi_tcl_VectorNEU::operator==(const cmb_fi_tcl_VectorNEU& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (North == roRef.North);
   bResult = bResult && (East == roRef.East);
   bResult = bResult && (Up == roRef.Up);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_CovarianceMatrixDiag::cmb_fi_tcl_CovarianceMatrixDiag(const cmb_fi_tcl_CovarianceMatrixDiag& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Elem11 = coRef.Elem11;
   Elem22 = coRef.Elem22;
   Elem33 = coRef.Elem33;
}
cmb_fi_tcl_CovarianceMatrixDiag& cmb_fi_tcl_CovarianceMatrixDiag::operator=(const cmb_fi_tcl_CovarianceMatrixDiag& coRef)
{
   if (this == &coRef) return *this;
   Elem11 = coRef.Elem11;
   Elem22 = coRef.Elem22;
   Elem33 = coRef.Elem33;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_CovarianceMatrixDiag::cmb_fi_tcl_CovarianceMatrixDiag()
:Elem11(0)
,Elem22(0)
,Elem33(0)
 {}

tS32 cmb_fi_tcl_CovarianceMatrixDiag::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_COVARIANCEMATRIXDIAG;
}


cmb_fi_tcl_CovarianceMatrixDiag::~cmb_fi_tcl_CovarianceMatrixDiag()
{}

tU32 cmb_fi_tcl_CovarianceMatrixDiag::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& cmb_fi_tcl_CovarianceMatrixDiag::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Elem11);
   (tVoid) (oIn >> Elem22);
   (tVoid) (oIn >> Elem33);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_CovarianceMatrixDiag::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Elem11);
   (tVoid) (oOut << Elem22);
   (tVoid) (oOut << Elem33);
   return oOut;
}

tBool cmb_fi_tcl_CovarianceMatrixDiag::operator==(const cmb_fi_tcl_CovarianceMatrixDiag& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Elem11 == roRef.Elem11);
   bResult = bResult && (Elem22 == roRef.Elem22);
   bResult = bResult && (Elem33 == roRef.Elem33);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_GpsHints::cmb_fi_tcl_GpsHints(const cmb_fi_tcl_GpsHints& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   ForwardPosition = coRef.ForwardPosition;
   BackwardPosition = coRef.BackwardPosition;
   ForwardVelocity = coRef.ForwardVelocity;
   BackwardVelocity = coRef.BackwardVelocity;
   PositionCovariances = coRef.PositionCovariances;
   VelocityCovariances = coRef.VelocityCovariances;
   Flags = coRef.Flags;
}
cmb_fi_tcl_GpsHints& cmb_fi_tcl_GpsHints::operator=(const cmb_fi_tcl_GpsHints& coRef)
{
   if (this == &coRef) return *this;
   ForwardPosition = coRef.ForwardPosition;
   BackwardPosition = coRef.BackwardPosition;
   ForwardVelocity = coRef.ForwardVelocity;
   BackwardVelocity = coRef.BackwardVelocity;
   PositionCovariances = coRef.PositionCovariances;
   VelocityCovariances = coRef.VelocityCovariances;
   Flags = coRef.Flags;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_GpsHints::cmb_fi_tcl_GpsHints()
:ForwardPosition()
,BackwardPosition()
,ForwardVelocity()
,BackwardVelocity()
,PositionCovariances()
,VelocityCovariances()
,Flags()
 {}

tS32 cmb_fi_tcl_GpsHints::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_GPSHINTS;
}


cmb_fi_tcl_GpsHints::~cmb_fi_tcl_GpsHints()
{}

tU32 cmb_fi_tcl_GpsHints::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 100;
}

fi_tclInContext& cmb_fi_tcl_GpsHints::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ForwardPosition);
   (tVoid) (oIn >> BackwardPosition);
   (tVoid) (oIn >> ForwardVelocity);
   (tVoid) (oIn >> BackwardVelocity);
   (tVoid) (oIn >> PositionCovariances);
   (tVoid) (oIn >> VelocityCovariances);
   (tVoid) (oIn >> Flags);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_GpsHints::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ForwardPosition);
   (tVoid) (oOut << BackwardPosition);
   (tVoid) (oOut << ForwardVelocity);
   (tVoid) (oOut << BackwardVelocity);
   (tVoid) (oOut << PositionCovariances);
   (tVoid) (oOut << VelocityCovariances);
   (tVoid) (oOut << Flags);
   return oOut;
}

tBool cmb_fi_tcl_GpsHints::operator==(const cmb_fi_tcl_GpsHints& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ForwardPosition == roRef.ForwardPosition);
   bResult = bResult && (BackwardPosition == roRef.BackwardPosition);
   bResult = bResult && (ForwardVelocity == roRef.ForwardVelocity);
   bResult = bResult && (BackwardVelocity == roRef.BackwardVelocity);
   bResult = bResult && (PositionCovariances == roRef.PositionCovariances);
   bResult = bResult && (VelocityCovariances == roRef.VelocityCovariances);
   bResult = bResult && (Flags == roRef.Flags);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_GpsExtHints::cmb_fi_tcl_GpsExtHints(const cmb_fi_tcl_GpsExtHints& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   ForwardPosition = coRef.ForwardPosition;
   BackwardPosition = coRef.BackwardPosition;
   ForwardVelocity = coRef.ForwardVelocity;
   BackwardVelocity = coRef.BackwardVelocity;
   ForwardPositionCovariances = coRef.ForwardPositionCovariances;
   BackwardPositionCovariances = coRef.BackwardPositionCovariances;
   ForwardVelocityCovariances = coRef.ForwardVelocityCovariances;
   BackwardVelocityCovariances = coRef.BackwardVelocityCovariances;
   Flags = coRef.Flags;
   Year = coRef.Year;
   Month = coRef.Month;
   Day = coRef.Day;
   Hour = coRef.Hour;
   Minute = coRef.Minute;
   Second = coRef.Second;
   HundredthSecond = coRef.HundredthSecond;
}
cmb_fi_tcl_GpsExtHints& cmb_fi_tcl_GpsExtHints::operator=(const cmb_fi_tcl_GpsExtHints& coRef)
{
   if (this == &coRef) return *this;
   ForwardPosition = coRef.ForwardPosition;
   BackwardPosition = coRef.BackwardPosition;
   ForwardVelocity = coRef.ForwardVelocity;
   BackwardVelocity = coRef.BackwardVelocity;
   ForwardPositionCovariances = coRef.ForwardPositionCovariances;
   BackwardPositionCovariances = coRef.BackwardPositionCovariances;
   ForwardVelocityCovariances = coRef.ForwardVelocityCovariances;
   BackwardVelocityCovariances = coRef.BackwardVelocityCovariances;
   Flags = coRef.Flags;
   Year = coRef.Year;
   Month = coRef.Month;
   Day = coRef.Day;
   Hour = coRef.Hour;
   Minute = coRef.Minute;
   Second = coRef.Second;
   HundredthSecond = coRef.HundredthSecond;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_GpsExtHints::cmb_fi_tcl_GpsExtHints()
:ForwardPosition()
,BackwardPosition()
,ForwardVelocity()
,BackwardVelocity()
,ForwardPositionCovariances()
,BackwardPositionCovariances()
,ForwardVelocityCovariances()
,BackwardVelocityCovariances()
,Flags()
,Year(0)
,Month(0)
,Day(0)
,Hour(0)
,Minute(0)
,Second(0)
,HundredthSecond(0)
 {}

tS32 cmb_fi_tcl_GpsExtHints::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_GPSEXTHINTS;
}


cmb_fi_tcl_GpsExtHints::~cmb_fi_tcl_GpsExtHints()
{}

tU32 cmb_fi_tcl_GpsExtHints::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 132;
}

fi_tclInContext& cmb_fi_tcl_GpsExtHints::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ForwardPosition);
   (tVoid) (oIn >> BackwardPosition);
   (tVoid) (oIn >> ForwardVelocity);
   (tVoid) (oIn >> BackwardVelocity);
   (tVoid) (oIn >> ForwardPositionCovariances);
   (tVoid) (oIn >> BackwardPositionCovariances);
   (tVoid) (oIn >> ForwardVelocityCovariances);
   (tVoid) (oIn >> BackwardVelocityCovariances);
   (tVoid) (oIn >> Flags);
   (tVoid) (oIn >> Year);
   (tVoid) (oIn >> Month);
   (tVoid) (oIn >> Day);
   (tVoid) (oIn >> Hour);
   (tVoid) (oIn >> Minute);
   (tVoid) (oIn >> Second);
   (tVoid) (oIn >> HundredthSecond);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_GpsExtHints::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ForwardPosition);
   (tVoid) (oOut << BackwardPosition);
   (tVoid) (oOut << ForwardVelocity);
   (tVoid) (oOut << BackwardVelocity);
   (tVoid) (oOut << ForwardPositionCovariances);
   (tVoid) (oOut << BackwardPositionCovariances);
   (tVoid) (oOut << ForwardVelocityCovariances);
   (tVoid) (oOut << BackwardVelocityCovariances);
   (tVoid) (oOut << Flags);
   (tVoid) (oOut << Year);
   (tVoid) (oOut << Month);
   (tVoid) (oOut << Day);
   (tVoid) (oOut << Hour);
   (tVoid) (oOut << Minute);
   (tVoid) (oOut << Second);
   (tVoid) (oOut << HundredthSecond);
   return oOut;
}

tBool cmb_fi_tcl_GpsExtHints::operator==(const cmb_fi_tcl_GpsExtHints& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ForwardPosition == roRef.ForwardPosition);
   bResult = bResult && (BackwardPosition == roRef.BackwardPosition);
   bResult = bResult && (ForwardVelocity == roRef.ForwardVelocity);
   bResult = bResult && (BackwardVelocity == roRef.BackwardVelocity);
   bResult = bResult && (ForwardPositionCovariances == roRef.ForwardPositionCovariances);
   bResult = bResult && (BackwardPositionCovariances == roRef.BackwardPositionCovariances);
   bResult = bResult && (ForwardVelocityCovariances == roRef.ForwardVelocityCovariances);
   bResult = bResult && (BackwardVelocityCovariances == roRef.BackwardVelocityCovariances);
   bResult = bResult && (Flags == roRef.Flags);
   bResult = bResult && (Year == roRef.Year);
   bResult = bResult && (Month == roRef.Month);
   bResult = bResult && (Day == roRef.Day);
   bResult = bResult && (Hour == roRef.Hour);
   bResult = bResult && (Minute == roRef.Minute);
   bResult = bResult && (Second == roRef.Second);
   bResult = bResult && (HundredthSecond == roRef.HundredthSecond);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_GpsTightCouplingChannelData::cmb_fi_tcl_GpsTightCouplingChannelData(const cmb_fi_tcl_GpsTightCouplingChannelData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   SatPosX = coRef.SatPosX;
   SatPosY = coRef.SatPosY;
   SatPosZ = coRef.SatPosZ;
   SatVelX = coRef.SatVelX;
   SatVelY = coRef.SatVelY;
   SatVelZ = coRef.SatVelZ;
   SatAccX = coRef.SatAccX;
   SatAccY = coRef.SatAccY;
   SatAccZ = coRef.SatAccZ;
   TimeSentCorr = coRef.TimeSentCorr;
   TimeSentUncorr = coRef.TimeSentUncorr;
   CarrierPhaseDiff = coRef.CarrierPhaseDiff;
   PseudoRange = coRef.PseudoRange;
   DeltaPseudoRange = coRef.DeltaPseudoRange;
   VarPseudoRange = coRef.VarPseudoRange;
   VarDeltaPseudoRange = coRef.VarDeltaPseudoRange;
   PropTimeCorrection = coRef.PropTimeCorrection;
   ChannelStatus = coRef.ChannelStatus;
}
cmb_fi_tcl_GpsTightCouplingChannelData& cmb_fi_tcl_GpsTightCouplingChannelData::operator=(const cmb_fi_tcl_GpsTightCouplingChannelData& coRef)
{
   if (this == &coRef) return *this;
   SatPosX = coRef.SatPosX;
   SatPosY = coRef.SatPosY;
   SatPosZ = coRef.SatPosZ;
   SatVelX = coRef.SatVelX;
   SatVelY = coRef.SatVelY;
   SatVelZ = coRef.SatVelZ;
   SatAccX = coRef.SatAccX;
   SatAccY = coRef.SatAccY;
   SatAccZ = coRef.SatAccZ;
   TimeSentCorr = coRef.TimeSentCorr;
   TimeSentUncorr = coRef.TimeSentUncorr;
   CarrierPhaseDiff = coRef.CarrierPhaseDiff;
   PseudoRange = coRef.PseudoRange;
   DeltaPseudoRange = coRef.DeltaPseudoRange;
   VarPseudoRange = coRef.VarPseudoRange;
   VarDeltaPseudoRange = coRef.VarDeltaPseudoRange;
   PropTimeCorrection = coRef.PropTimeCorrection;
   ChannelStatus = coRef.ChannelStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_GpsTightCouplingChannelData::cmb_fi_tcl_GpsTightCouplingChannelData()
:SatPosX(0)
,SatPosY(0)
,SatPosZ(0)
,SatVelX(0)
,SatVelY(0)
,SatVelZ(0)
,SatAccX(0)
,SatAccY(0)
,SatAccZ(0)
,TimeSentCorr(0)
,TimeSentUncorr(0)
,CarrierPhaseDiff(0)
,PseudoRange(0)
,DeltaPseudoRange(0)
,VarPseudoRange(0)
,VarDeltaPseudoRange(0)
,PropTimeCorrection(0)
,ChannelStatus(0)
 {}

tS32 cmb_fi_tcl_GpsTightCouplingChannelData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_GPSTIGHTCOUPLINGCHANNELDATA;
}


cmb_fi_tcl_GpsTightCouplingChannelData::~cmb_fi_tcl_GpsTightCouplingChannelData()
{}

tU32 cmb_fi_tcl_GpsTightCouplingChannelData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 128;
}

fi_tclInContext& cmb_fi_tcl_GpsTightCouplingChannelData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SatPosX);
   (tVoid) (oIn >> SatPosY);
   (tVoid) (oIn >> SatPosZ);
   (tVoid) (oIn >> SatVelX);
   (tVoid) (oIn >> SatVelY);
   (tVoid) (oIn >> SatVelZ);
   (tVoid) (oIn >> SatAccX);
   (tVoid) (oIn >> SatAccY);
   (tVoid) (oIn >> SatAccZ);
   (tVoid) (oIn >> TimeSentCorr);
   (tVoid) (oIn >> TimeSentUncorr);
   (tVoid) (oIn >> CarrierPhaseDiff);
   (tVoid) (oIn >> PseudoRange);
   (tVoid) (oIn >> DeltaPseudoRange);
   (tVoid) (oIn >> VarPseudoRange);
   (tVoid) (oIn >> VarDeltaPseudoRange);
   (tVoid) (oIn >> PropTimeCorrection);
   (tVoid) (oIn >> ChannelStatus);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_GpsTightCouplingChannelData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SatPosX);
   (tVoid) (oOut << SatPosY);
   (tVoid) (oOut << SatPosZ);
   (tVoid) (oOut << SatVelX);
   (tVoid) (oOut << SatVelY);
   (tVoid) (oOut << SatVelZ);
   (tVoid) (oOut << SatAccX);
   (tVoid) (oOut << SatAccY);
   (tVoid) (oOut << SatAccZ);
   (tVoid) (oOut << TimeSentCorr);
   (tVoid) (oOut << TimeSentUncorr);
   (tVoid) (oOut << CarrierPhaseDiff);
   (tVoid) (oOut << PseudoRange);
   (tVoid) (oOut << DeltaPseudoRange);
   (tVoid) (oOut << VarPseudoRange);
   (tVoid) (oOut << VarDeltaPseudoRange);
   (tVoid) (oOut << PropTimeCorrection);
   (tVoid) (oOut << ChannelStatus);
   return oOut;
}

tBool cmb_fi_tcl_GpsTightCouplingChannelData::operator==(const cmb_fi_tcl_GpsTightCouplingChannelData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SatPosX == roRef.SatPosX);
   bResult = bResult && (SatPosY == roRef.SatPosY);
   bResult = bResult && (SatPosZ == roRef.SatPosZ);
   bResult = bResult && (SatVelX == roRef.SatVelX);
   bResult = bResult && (SatVelY == roRef.SatVelY);
   bResult = bResult && (SatVelZ == roRef.SatVelZ);
   bResult = bResult && (SatAccX == roRef.SatAccX);
   bResult = bResult && (SatAccY == roRef.SatAccY);
   bResult = bResult && (SatAccZ == roRef.SatAccZ);
   bResult = bResult && (TimeSentCorr == roRef.TimeSentCorr);
   bResult = bResult && (TimeSentUncorr == roRef.TimeSentUncorr);
   bResult = bResult && (CarrierPhaseDiff == roRef.CarrierPhaseDiff);
   bResult = bResult && (PseudoRange == roRef.PseudoRange);
   bResult = bResult && (DeltaPseudoRange == roRef.DeltaPseudoRange);
   bResult = bResult && (VarPseudoRange == roRef.VarPseudoRange);
   bResult = bResult && (VarDeltaPseudoRange == roRef.VarDeltaPseudoRange);
   bResult = bResult && (PropTimeCorrection == roRef.PropTimeCorrection);
   bResult = bResult && (ChannelStatus == roRef.ChannelStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_GpsTightCouplingCommonData::cmb_fi_tcl_GpsTightCouplingCommonData(const cmb_fi_tcl_GpsTightCouplingCommonData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   TimeStampTC = coRef.TimeStampTC;
   SampleRate = coRef.SampleRate;
   TimeOfWeek = coRef.TimeOfWeek;
   OscFreq = coRef.OscFreq;
   FreqMixFactor = coRef.FreqMixFactor;
   CalcInterval = coRef.CalcInterval;
}
cmb_fi_tcl_GpsTightCouplingCommonData& cmb_fi_tcl_GpsTightCouplingCommonData::operator=(const cmb_fi_tcl_GpsTightCouplingCommonData& coRef)
{
   if (this == &coRef) return *this;
   TimeStampTC = coRef.TimeStampTC;
   SampleRate = coRef.SampleRate;
   TimeOfWeek = coRef.TimeOfWeek;
   OscFreq = coRef.OscFreq;
   FreqMixFactor = coRef.FreqMixFactor;
   CalcInterval = coRef.CalcInterval;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_GpsTightCouplingCommonData::cmb_fi_tcl_GpsTightCouplingCommonData()
:TimeStampTC(0)
,SampleRate(0)
,TimeOfWeek(0)
,OscFreq(0)
,FreqMixFactor(0)
,CalcInterval(0)
 {}

tS32 cmb_fi_tcl_GpsTightCouplingCommonData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_GPSTIGHTCOUPLINGCOMMONDATA;
}


cmb_fi_tcl_GpsTightCouplingCommonData::~cmb_fi_tcl_GpsTightCouplingCommonData()
{}

tU32 cmb_fi_tcl_GpsTightCouplingCommonData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 32;
}

fi_tclInContext& cmb_fi_tcl_GpsTightCouplingCommonData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TimeStampTC);
   (tVoid) (oIn >> SampleRate);
   (tVoid) (oIn >> TimeOfWeek);
   (tVoid) (oIn >> OscFreq);
   (tVoid) (oIn >> FreqMixFactor);
   (tVoid) (oIn >> CalcInterval);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_GpsTightCouplingCommonData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TimeStampTC);
   (tVoid) (oOut << SampleRate);
   (tVoid) (oOut << TimeOfWeek);
   (tVoid) (oOut << OscFreq);
   (tVoid) (oOut << FreqMixFactor);
   (tVoid) (oOut << CalcInterval);
   return oOut;
}

tBool cmb_fi_tcl_GpsTightCouplingCommonData::operator==(const cmb_fi_tcl_GpsTightCouplingCommonData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TimeStampTC == roRef.TimeStampTC);
   bResult = bResult && (SampleRate == roRef.SampleRate);
   bResult = bResult && (TimeOfWeek == roRef.TimeOfWeek);
   bResult = bResult && (OscFreq == roRef.OscFreq);
   bResult = bResult && (FreqMixFactor == roRef.FreqMixFactor);
   bResult = bResult && (CalcInterval == roRef.CalcInterval);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_GpsTightCouplingData::cmb_fi_tcl_GpsTightCouplingData(const cmb_fi_tcl_GpsTightCouplingData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Common = coRef.Common;
   Channel = coRef.Channel;
}
cmb_fi_tcl_GpsTightCouplingData& cmb_fi_tcl_GpsTightCouplingData::operator=(const cmb_fi_tcl_GpsTightCouplingData& coRef)
{
   if (this == &coRef) return *this;
   Common = coRef.Common;
   Channel = coRef.Channel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_GpsTightCouplingData::vDestroy()
{
   Common.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < Channel.size(); ++u32Idx)
         Channel[u32Idx].vDestroy();
   Channel.clear();
   }
}

cmb_fi_tcl_GpsTightCouplingData::cmb_fi_tcl_GpsTightCouplingData()
:Common()

 {}

tS32 cmb_fi_tcl_GpsTightCouplingData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_GPSTIGHTCOUPLINGDATA;
}


cmb_fi_tcl_GpsTightCouplingData::~cmb_fi_tcl_GpsTightCouplingData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_GpsTightCouplingData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 36+ static_cast<tU32>(Channel.size()*128);
}

fi_tclInContext& cmb_fi_tcl_GpsTightCouplingData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Common);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Channel.size(); ++u32Idx)
      {
         Channel[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Channel.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Channel[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_GpsTightCouplingData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Common);
   (tVoid) (oOut << (tU32)Channel.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Channel.size(); ++u32Idx)
         (tVoid) (oOut << Channel[u32Idx]);
   }
   return oOut;
}

tBool cmb_fi_tcl_GpsTightCouplingData::operator==(const cmb_fi_tcl_GpsTightCouplingData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Common == roRef.Common);
      bResult = bResult && (Channel.size() == roRef.Channel.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Channel.size()); ++u32Idx)
            bResult = bResult && (Channel[u32Idx] == roRef.Channel[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_AbsStatus::cmb_fi_tcl_e8_AbsStatus():enType(FI_EN_ABS_STATUS_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_AbsStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_ABSSTATUS;
}


cmb_fi_tcl_e8_AbsStatus::~cmb_fi_tcl_e8_AbsStatus()
{}

tU32 cmb_fi_tcl_e8_AbsStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_AbsStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_AbsStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_AbsDirection::cmb_fi_tcl_e8_AbsDirection():enType(FI_EN_ABS_DIRECTION_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_AbsDirection::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_ABSDIRECTION;
}


cmb_fi_tcl_e8_AbsDirection::~cmb_fi_tcl_e8_AbsDirection()
{}

tU32 cmb_fi_tcl_e8_AbsDirection::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_AbsDirection::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_AbsDirection::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_AbsData::cmb_fi_tcl_AbsData(const cmb_fi_tcl_AbsData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   AbsTimeStamp = coRef.AbsTimeStamp;
   WheelCounterFrontLeft = coRef.WheelCounterFrontLeft;
   WheelCounterFrontRight = coRef.WheelCounterFrontRight;
   WheelCounterRearLeft = coRef.WheelCounterRearLeft;
   WheelCounterRearRight = coRef.WheelCounterRearRight;
   StatusFrontLeft = coRef.StatusFrontLeft;
   StatusFrontRight = coRef.StatusFrontRight;
   StatusRearLeft = coRef.StatusRearLeft;
   StatusRearRight = coRef.StatusRearRight;
   DirectionFrontLeft = coRef.DirectionFrontLeft;
   DirectionFrontRight = coRef.DirectionFrontRight;
   DirectionRearLeft = coRef.DirectionRearLeft;
   DirectionRearRight = coRef.DirectionRearRight;
}
cmb_fi_tcl_AbsData& cmb_fi_tcl_AbsData::operator=(const cmb_fi_tcl_AbsData& coRef)
{
   if (this == &coRef) return *this;
   AbsTimeStamp = coRef.AbsTimeStamp;
   WheelCounterFrontLeft = coRef.WheelCounterFrontLeft;
   WheelCounterFrontRight = coRef.WheelCounterFrontRight;
   WheelCounterRearLeft = coRef.WheelCounterRearLeft;
   WheelCounterRearRight = coRef.WheelCounterRearRight;
   StatusFrontLeft = coRef.StatusFrontLeft;
   StatusFrontRight = coRef.StatusFrontRight;
   StatusRearLeft = coRef.StatusRearLeft;
   StatusRearRight = coRef.StatusRearRight;
   DirectionFrontLeft = coRef.DirectionFrontLeft;
   DirectionFrontRight = coRef.DirectionFrontRight;
   DirectionRearLeft = coRef.DirectionRearLeft;
   DirectionRearRight = coRef.DirectionRearRight;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_AbsData::cmb_fi_tcl_AbsData()
:AbsTimeStamp(0)
,WheelCounterFrontLeft(0)
,WheelCounterFrontRight(0)
,WheelCounterRearLeft(0)
,WheelCounterRearRight(0)
,StatusFrontLeft()
,StatusFrontRight()
,StatusRearLeft()
,StatusRearRight()
,DirectionFrontLeft()
,DirectionFrontRight()
,DirectionRearLeft()
,DirectionRearRight()
 {}

tS32 cmb_fi_tcl_AbsData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_ABSDATA;
}


cmb_fi_tcl_AbsData::~cmb_fi_tcl_AbsData()
{}

tU32 cmb_fi_tcl_AbsData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 20;
}

fi_tclInContext& cmb_fi_tcl_AbsData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AbsTimeStamp);
   (tVoid) (oIn >> WheelCounterFrontLeft);
   (tVoid) (oIn >> WheelCounterFrontRight);
   (tVoid) (oIn >> WheelCounterRearLeft);
   (tVoid) (oIn >> WheelCounterRearRight);
   (tVoid) (oIn >> StatusFrontLeft);
   (tVoid) (oIn >> StatusFrontRight);
   (tVoid) (oIn >> StatusRearLeft);
   (tVoid) (oIn >> StatusRearRight);
   (tVoid) (oIn >> DirectionFrontLeft);
   (tVoid) (oIn >> DirectionFrontRight);
   (tVoid) (oIn >> DirectionRearLeft);
   (tVoid) (oIn >> DirectionRearRight);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_AbsData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AbsTimeStamp);
   (tVoid) (oOut << WheelCounterFrontLeft);
   (tVoid) (oOut << WheelCounterFrontRight);
   (tVoid) (oOut << WheelCounterRearLeft);
   (tVoid) (oOut << WheelCounterRearRight);
   (tVoid) (oOut << StatusFrontLeft);
   (tVoid) (oOut << StatusFrontRight);
   (tVoid) (oOut << StatusRearLeft);
   (tVoid) (oOut << StatusRearRight);
   (tVoid) (oOut << DirectionFrontLeft);
   (tVoid) (oOut << DirectionFrontRight);
   (tVoid) (oOut << DirectionRearLeft);
   (tVoid) (oOut << DirectionRearRight);
   return oOut;
}

tBool cmb_fi_tcl_AbsData::operator==(const cmb_fi_tcl_AbsData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AbsTimeStamp == roRef.AbsTimeStamp);
   bResult = bResult && (WheelCounterFrontLeft == roRef.WheelCounterFrontLeft);
   bResult = bResult && (WheelCounterFrontRight == roRef.WheelCounterFrontRight);
   bResult = bResult && (WheelCounterRearLeft == roRef.WheelCounterRearLeft);
   bResult = bResult && (WheelCounterRearRight == roRef.WheelCounterRearRight);
   bResult = bResult && (StatusFrontLeft == roRef.StatusFrontLeft);
   bResult = bResult && (StatusFrontRight == roRef.StatusFrontRight);
   bResult = bResult && (StatusRearLeft == roRef.StatusRearLeft);
   bResult = bResult && (StatusRearRight == roRef.StatusRearRight);
   bResult = bResult && (DirectionFrontLeft == roRef.DirectionFrontLeft);
   bResult = bResult && (DirectionFrontRight == roRef.DirectionFrontRight);
   bResult = bResult && (DirectionRearLeft == roRef.DirectionRearLeft);
   bResult = bResult && (DirectionRearRight == roRef.DirectionRearRight);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_SteeringStatus::cmb_fi_tcl_e8_SteeringStatus():enType(FI_EN_STEERING_STATUS_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_SteeringStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_STEERINGSTATUS;
}


cmb_fi_tcl_e8_SteeringStatus::~cmb_fi_tcl_e8_SteeringStatus()
{}

tU32 cmb_fi_tcl_e8_SteeringStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_SteeringStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_SteeringStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_SteeringData::cmb_fi_tcl_SteeringData(const cmb_fi_tcl_SteeringData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   SteeringTimeStamp = coRef.SteeringTimeStamp;
   WheelAngle = coRef.WheelAngle;
   WheelRate = coRef.WheelRate;
   StatusWheelAngle = coRef.StatusWheelAngle;
   StatusWheelRate = coRef.StatusWheelRate;
}
cmb_fi_tcl_SteeringData& cmb_fi_tcl_SteeringData::operator=(const cmb_fi_tcl_SteeringData& coRef)
{
   if (this == &coRef) return *this;
   SteeringTimeStamp = coRef.SteeringTimeStamp;
   WheelAngle = coRef.WheelAngle;
   WheelRate = coRef.WheelRate;
   StatusWheelAngle = coRef.StatusWheelAngle;
   StatusWheelRate = coRef.StatusWheelRate;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_SteeringData::cmb_fi_tcl_SteeringData()
:SteeringTimeStamp(0)
,WheelAngle(0)
,WheelRate(0)
,StatusWheelAngle()
,StatusWheelRate()
 {}

tS32 cmb_fi_tcl_SteeringData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_STEERINGDATA;
}


cmb_fi_tcl_SteeringData::~cmb_fi_tcl_SteeringData()
{}

tU32 cmb_fi_tcl_SteeringData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& cmb_fi_tcl_SteeringData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SteeringTimeStamp);
   (tVoid) (oIn >> WheelAngle);
   (tVoid) (oIn >> WheelRate);
   (tVoid) (oIn >> StatusWheelAngle);
   (tVoid) (oIn >> StatusWheelRate);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_SteeringData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SteeringTimeStamp);
   (tVoid) (oOut << WheelAngle);
   (tVoid) (oOut << WheelRate);
   (tVoid) (oOut << StatusWheelAngle);
   (tVoid) (oOut << StatusWheelRate);
   return oOut;
}

tBool cmb_fi_tcl_SteeringData::operator==(const cmb_fi_tcl_SteeringData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SteeringTimeStamp == roRef.SteeringTimeStamp);
   bResult = bResult && (WheelAngle == roRef.WheelAngle);
   bResult = bResult && (WheelRate == roRef.WheelRate);
   bResult = bResult && (StatusWheelAngle == roRef.StatusWheelAngle);
   bResult = bResult && (StatusWheelRate == roRef.StatusWheelRate);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_OdometerRangeStatus::cmb_fi_tcl_e8_OdometerRangeStatus():enType(FI_EN_ODOMRANGE_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_OdometerRangeStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_ODOMETERRANGESTATUS;
}


cmb_fi_tcl_e8_OdometerRangeStatus::~cmb_fi_tcl_e8_OdometerRangeStatus()
{}

tU32 cmb_fi_tcl_e8_OdometerRangeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_OdometerRangeStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_OdometerRangeStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_GpsExtTestmodeStart::cmb_fi_tcl_GpsExtTestmodeStart(const cmb_fi_tcl_GpsExtTestmodeStart& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   SvId = coRef.SvId;
   GpsSearchMask = coRef.GpsSearchMask;
}
cmb_fi_tcl_GpsExtTestmodeStart& cmb_fi_tcl_GpsExtTestmodeStart::operator=(const cmb_fi_tcl_GpsExtTestmodeStart& coRef)
{
   if (this == &coRef) return *this;
   SvId = coRef.SvId;
   GpsSearchMask = coRef.GpsSearchMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_GpsExtTestmodeStart::cmb_fi_tcl_GpsExtTestmodeStart()
:SvId(0)
,GpsSearchMask(0)
 {}

tS32 cmb_fi_tcl_GpsExtTestmodeStart::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_GPSEXTTESTMODESTART;
}


cmb_fi_tcl_GpsExtTestmodeStart::~cmb_fi_tcl_GpsExtTestmodeStart()
{}

tU32 cmb_fi_tcl_GpsExtTestmodeStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& cmb_fi_tcl_GpsExtTestmodeStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SvId);
   (tVoid) (oIn >> GpsSearchMask);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_GpsExtTestmodeStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SvId);
   (tVoid) (oOut << GpsSearchMask);
   return oOut;
}

tBool cmb_fi_tcl_GpsExtTestmodeStart::operator==(const cmb_fi_tcl_GpsExtTestmodeStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SvId == roRef.SvId);
   bResult = bResult && (GpsSearchMask == roRef.GpsSearchMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_GpsExtTestmodeResult::cmb_fi_tcl_GpsExtTestmodeResult(const cmb_fi_tcl_GpsExtTestmodeResult& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   CurrentClkOffset = coRef.CurrentClkOffset;
   CurrentClkValue = coRef.CurrentClkValue;
   GpsDebugChanStatusA = coRef.GpsDebugChanStatusA;
   GpsDebugChanStatusB = coRef.GpsDebugChanStatusB;
   GpsDebugChanStatusC = coRef.GpsDebugChanStatusC;
   GpsDebugChanStatusD = coRef.GpsDebugChanStatusD;
   CalcTestResult = coRef.CalcTestResult;
   TestResult = coRef.TestResult;
   GpsAverageChannelSNR = coRef.GpsAverageChannelSNR;
   GpsActualChannelPower = coRef.GpsActualChannelPower;
   GpsActualChannelSNR = coRef.GpsActualChannelSNR;
}
cmb_fi_tcl_GpsExtTestmodeResult& cmb_fi_tcl_GpsExtTestmodeResult::operator=(const cmb_fi_tcl_GpsExtTestmodeResult& coRef)
{
   if (this == &coRef) return *this;
   CurrentClkOffset = coRef.CurrentClkOffset;
   CurrentClkValue = coRef.CurrentClkValue;
   GpsDebugChanStatusA = coRef.GpsDebugChanStatusA;
   GpsDebugChanStatusB = coRef.GpsDebugChanStatusB;
   GpsDebugChanStatusC = coRef.GpsDebugChanStatusC;
   GpsDebugChanStatusD = coRef.GpsDebugChanStatusD;
   CalcTestResult = coRef.CalcTestResult;
   TestResult = coRef.TestResult;
   GpsAverageChannelSNR = coRef.GpsAverageChannelSNR;
   GpsActualChannelPower = coRef.GpsActualChannelPower;
   GpsActualChannelSNR = coRef.GpsActualChannelSNR;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_GpsExtTestmodeResult::vDestroy()
{
   {
   GpsActualChannelSNR.clear();
   }
}

cmb_fi_tcl_GpsExtTestmodeResult::cmb_fi_tcl_GpsExtTestmodeResult()
:CurrentClkOffset(0)
,CurrentClkValue(0)
,GpsDebugChanStatusA(0)
,GpsDebugChanStatusB(0)
,GpsDebugChanStatusC(0)
,GpsDebugChanStatusD(0)
,CalcTestResult(0)
,TestResult(0)
,GpsAverageChannelSNR(0)
,GpsActualChannelPower(0)

 {}

tS32 cmb_fi_tcl_GpsExtTestmodeResult::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_GPSEXTTESTMODERESULT;
}


cmb_fi_tcl_GpsExtTestmodeResult::~cmb_fi_tcl_GpsExtTestmodeResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_GpsExtTestmodeResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 34+ static_cast<tU32>(GpsActualChannelSNR.size()*2);
}

fi_tclInContext& cmb_fi_tcl_GpsExtTestmodeResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CurrentClkOffset);
   (tVoid) (oIn >> CurrentClkValue);
   (tVoid) (oIn >> GpsDebugChanStatusA);
   (tVoid) (oIn >> GpsDebugChanStatusB);
   (tVoid) (oIn >> GpsDebugChanStatusC);
   (tVoid) (oIn >> GpsDebugChanStatusD);
   (tVoid) (oIn >> CalcTestResult);
   (tVoid) (oIn >> TestResult);
   (tVoid) (oIn >> GpsAverageChannelSNR);
   (tVoid) (oIn >> GpsActualChannelPower);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      GpsActualChannelSNR.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> GpsActualChannelSNR[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_GpsExtTestmodeResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CurrentClkOffset);
   (tVoid) (oOut << CurrentClkValue);
   (tVoid) (oOut << GpsDebugChanStatusA);
   (tVoid) (oOut << GpsDebugChanStatusB);
   (tVoid) (oOut << GpsDebugChanStatusC);
   (tVoid) (oOut << GpsDebugChanStatusD);
   (tVoid) (oOut << CalcTestResult);
   (tVoid) (oOut << TestResult);
   (tVoid) (oOut << GpsAverageChannelSNR);
   (tVoid) (oOut << GpsActualChannelPower);
   (tVoid) (oOut << (tU32)GpsActualChannelSNR.size());
   {
      for (tU32 u32Idx = 0; u32Idx < GpsActualChannelSNR.size(); ++u32Idx)
         (tVoid) (oOut << GpsActualChannelSNR[u32Idx]);
   }
   return oOut;
}

tBool cmb_fi_tcl_GpsExtTestmodeResult::operator==(const cmb_fi_tcl_GpsExtTestmodeResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CurrentClkOffset == roRef.CurrentClkOffset);
   bResult = bResult && (CurrentClkValue == roRef.CurrentClkValue);
   bResult = bResult && (GpsDebugChanStatusA == roRef.GpsDebugChanStatusA);
   bResult = bResult && (GpsDebugChanStatusB == roRef.GpsDebugChanStatusB);
   bResult = bResult && (GpsDebugChanStatusC == roRef.GpsDebugChanStatusC);
   bResult = bResult && (GpsDebugChanStatusD == roRef.GpsDebugChanStatusD);
   bResult = bResult && (CalcTestResult == roRef.CalcTestResult);
   bResult = bResult && (TestResult == roRef.TestResult);
   bResult = bResult && (GpsAverageChannelSNR == roRef.GpsAverageChannelSNR);
   bResult = bResult && (GpsActualChannelPower == roRef.GpsActualChannelPower);
      bResult = bResult && (GpsActualChannelSNR.size() == roRef.GpsActualChannelSNR.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < GpsActualChannelSNR.size()); ++u32Idx)
            bResult = bResult && (GpsActualChannelSNR[u32Idx] == roRef.GpsActualChannelSNR[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_DefSetGroups::cmb_fi_tcl_e8_DefSetGroups():enType(FI_EN_DEFSET_GROUP_MAINTENANCE) {}

tS32 cmb_fi_tcl_e8_DefSetGroups::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_DEFSETGROUPS;
}


cmb_fi_tcl_e8_DefSetGroups::~cmb_fi_tcl_e8_DefSetGroups()
{}

tU32 cmb_fi_tcl_e8_DefSetGroups::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_DefSetGroups::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_DefSetGroups::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_DefSetMode::cmb_fi_tcl_e8_DefSetMode():enType(FI_EN_DEFSET_SRC_CODING) {}

tS32 cmb_fi_tcl_e8_DefSetMode::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_DEFSETMODE;
}


cmb_fi_tcl_e8_DefSetMode::~cmb_fi_tcl_e8_DefSetMode()
{}

tU32 cmb_fi_tcl_e8_DefSetMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_DefSetMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_DefSetMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_SensorHwInfo::cmb_fi_tcl_SensorHwInfo(const cmb_fi_tcl_SensorHwInfo& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   AdcRangeMin = coRef.AdcRangeMin;
   AdcRangeMax = coRef.AdcRangeMax;
   SampleMin = coRef.SampleMin;
   SampleMax = coRef.SampleMax;
   MinNoiseValue = coRef.MinNoiseValue;
   EstimOffset = coRef.EstimOffset;
   MinOffset = coRef.MinOffset;
   MaxOffset = coRef.MaxOffset;
   DriftOffset = coRef.DriftOffset;
   MaxUnsteadOffset  = coRef.MaxUnsteadOffset ;
   BestCalibOffset = coRef.BestCalibOffset;
   EstimScaleFactor = coRef.EstimScaleFactor;
   MinScaleFactor = coRef.MinScaleFactor;
   MaxScaleFactor = coRef.MaxScaleFactor;
   DriftScaleFactor = coRef.DriftScaleFactor;
   MaxUnsteadScaleFactor  = coRef.MaxUnsteadScaleFactor ;
   BestCalibScaleFactor = coRef.BestCalibScaleFactor;
}
cmb_fi_tcl_SensorHwInfo& cmb_fi_tcl_SensorHwInfo::operator=(const cmb_fi_tcl_SensorHwInfo& coRef)
{
   if (this == &coRef) return *this;
   AdcRangeMin = coRef.AdcRangeMin;
   AdcRangeMax = coRef.AdcRangeMax;
   SampleMin = coRef.SampleMin;
   SampleMax = coRef.SampleMax;
   MinNoiseValue = coRef.MinNoiseValue;
   EstimOffset = coRef.EstimOffset;
   MinOffset = coRef.MinOffset;
   MaxOffset = coRef.MaxOffset;
   DriftOffset = coRef.DriftOffset;
   MaxUnsteadOffset  = coRef.MaxUnsteadOffset ;
   BestCalibOffset = coRef.BestCalibOffset;
   EstimScaleFactor = coRef.EstimScaleFactor;
   MinScaleFactor = coRef.MinScaleFactor;
   MaxScaleFactor = coRef.MaxScaleFactor;
   DriftScaleFactor = coRef.DriftScaleFactor;
   MaxUnsteadScaleFactor  = coRef.MaxUnsteadScaleFactor ;
   BestCalibScaleFactor = coRef.BestCalibScaleFactor;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_SensorHwInfo::cmb_fi_tcl_SensorHwInfo()
:AdcRangeMin(0)
,AdcRangeMax(0)
,SampleMin(0)
,SampleMax(0)
,MinNoiseValue(0)
,EstimOffset(0)
,MinOffset(0)
,MaxOffset(0)
,DriftOffset(0)
,MaxUnsteadOffset (0)
,BestCalibOffset(0)
,EstimScaleFactor(0)
,MinScaleFactor(0)
,MaxScaleFactor(0)
,DriftScaleFactor(0)
,MaxUnsteadScaleFactor (0)
,BestCalibScaleFactor(0)
 {}

tS32 cmb_fi_tcl_SensorHwInfo::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_SENSORHWINFO;
}


cmb_fi_tcl_SensorHwInfo::~cmb_fi_tcl_SensorHwInfo()
{}

tU32 cmb_fi_tcl_SensorHwInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 68;
}

fi_tclInContext& cmb_fi_tcl_SensorHwInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AdcRangeMin);
   (tVoid) (oIn >> AdcRangeMax);
   (tVoid) (oIn >> SampleMin);
   (tVoid) (oIn >> SampleMax);
   (tVoid) (oIn >> MinNoiseValue);
   (tVoid) (oIn >> EstimOffset);
   (tVoid) (oIn >> MinOffset);
   (tVoid) (oIn >> MaxOffset);
   (tVoid) (oIn >> DriftOffset);
   (tVoid) (oIn >> MaxUnsteadOffset );
   (tVoid) (oIn >> BestCalibOffset);
   (tVoid) (oIn >> EstimScaleFactor);
   (tVoid) (oIn >> MinScaleFactor);
   (tVoid) (oIn >> MaxScaleFactor);
   (tVoid) (oIn >> DriftScaleFactor);
   (tVoid) (oIn >> MaxUnsteadScaleFactor );
   (tVoid) (oIn >> BestCalibScaleFactor);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_SensorHwInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AdcRangeMin);
   (tVoid) (oOut << AdcRangeMax);
   (tVoid) (oOut << SampleMin);
   (tVoid) (oOut << SampleMax);
   (tVoid) (oOut << MinNoiseValue);
   (tVoid) (oOut << EstimOffset);
   (tVoid) (oOut << MinOffset);
   (tVoid) (oOut << MaxOffset);
   (tVoid) (oOut << DriftOffset);
   (tVoid) (oOut << MaxUnsteadOffset );
   (tVoid) (oOut << BestCalibOffset);
   (tVoid) (oOut << EstimScaleFactor);
   (tVoid) (oOut << MinScaleFactor);
   (tVoid) (oOut << MaxScaleFactor);
   (tVoid) (oOut << DriftScaleFactor);
   (tVoid) (oOut << MaxUnsteadScaleFactor );
   (tVoid) (oOut << BestCalibScaleFactor);
   return oOut;
}

tBool cmb_fi_tcl_SensorHwInfo::operator==(const cmb_fi_tcl_SensorHwInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AdcRangeMin == roRef.AdcRangeMin);
   bResult = bResult && (AdcRangeMax == roRef.AdcRangeMax);
   bResult = bResult && (SampleMin == roRef.SampleMin);
   bResult = bResult && (SampleMax == roRef.SampleMax);
   bResult = bResult && (MinNoiseValue == roRef.MinNoiseValue);
   bResult = bResult && (EstimOffset == roRef.EstimOffset);
   bResult = bResult && (MinOffset == roRef.MinOffset);
   bResult = bResult && (MaxOffset == roRef.MaxOffset);
   bResult = bResult && (DriftOffset == roRef.DriftOffset);
   bResult = bResult && (MaxUnsteadOffset  == roRef.MaxUnsteadOffset );
   bResult = bResult && (BestCalibOffset == roRef.BestCalibOffset);
   bResult = bResult && (EstimScaleFactor == roRef.EstimScaleFactor);
   bResult = bResult && (MinScaleFactor == roRef.MinScaleFactor);
   bResult = bResult && (MaxScaleFactor == roRef.MaxScaleFactor);
   bResult = bResult && (DriftScaleFactor == roRef.DriftScaleFactor);
   bResult = bResult && (MaxUnsteadScaleFactor  == roRef.MaxUnsteadScaleFactor );
   bResult = bResult && (BestCalibScaleFactor == roRef.BestCalibScaleFactor);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_3dMountAngles::cmb_fi_tcl_3dMountAngles(const cmb_fi_tcl_3dMountAngles& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   AngRX = coRef.AngRX;
   AngRY = coRef.AngRY;
   AngRZ = coRef.AngRZ;
   AngSX = coRef.AngSX;
   AngSY = coRef.AngSY;
   AngSZ = coRef.AngSZ;
   AngTX = coRef.AngTX;
   AngTY = coRef.AngTY;
   AngTZ = coRef.AngTZ;
}
cmb_fi_tcl_3dMountAngles& cmb_fi_tcl_3dMountAngles::operator=(const cmb_fi_tcl_3dMountAngles& coRef)
{
   if (this == &coRef) return *this;
   AngRX = coRef.AngRX;
   AngRY = coRef.AngRY;
   AngRZ = coRef.AngRZ;
   AngSX = coRef.AngSX;
   AngSY = coRef.AngSY;
   AngSZ = coRef.AngSZ;
   AngTX = coRef.AngTX;
   AngTY = coRef.AngTY;
   AngTZ = coRef.AngTZ;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_3dMountAngles::cmb_fi_tcl_3dMountAngles()
:AngRX(0)
,AngRY(0)
,AngRZ(0)
,AngSX(0)
,AngSY(0)
,AngSZ(0)
,AngTX(0)
,AngTY(0)
,AngTZ(0)
 {}

tS32 cmb_fi_tcl_3dMountAngles::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_3DMOUNTANGLES;
}


cmb_fi_tcl_3dMountAngles::~cmb_fi_tcl_3dMountAngles()
{}

tU32 cmb_fi_tcl_3dMountAngles::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 9;
}

fi_tclInContext& cmb_fi_tcl_3dMountAngles::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AngRX);
   (tVoid) (oIn >> AngRY);
   (tVoid) (oIn >> AngRZ);
   (tVoid) (oIn >> AngSX);
   (tVoid) (oIn >> AngSY);
   (tVoid) (oIn >> AngSZ);
   (tVoid) (oIn >> AngTX);
   (tVoid) (oIn >> AngTY);
   (tVoid) (oIn >> AngTZ);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_3dMountAngles::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AngRX);
   (tVoid) (oOut << AngRY);
   (tVoid) (oOut << AngRZ);
   (tVoid) (oOut << AngSX);
   (tVoid) (oOut << AngSY);
   (tVoid) (oOut << AngSZ);
   (tVoid) (oOut << AngTX);
   (tVoid) (oOut << AngTY);
   (tVoid) (oOut << AngTZ);
   return oOut;
}

tBool cmb_fi_tcl_3dMountAngles::operator==(const cmb_fi_tcl_3dMountAngles& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AngRX == roRef.AngRX);
   bResult = bResult && (AngRY == roRef.AngRY);
   bResult = bResult && (AngRZ == roRef.AngRZ);
   bResult = bResult && (AngSX == roRef.AngSX);
   bResult = bResult && (AngSY == roRef.AngSY);
   bResult = bResult && (AngSZ == roRef.AngSZ);
   bResult = bResult && (AngTX == roRef.AngTX);
   bResult = bResult && (AngTY == roRef.AngTY);
   bResult = bResult && (AngTZ == roRef.AngTZ);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_3dGyroHwInfo::cmb_fi_tcl_3dGyroHwInfo(const cmb_fi_tcl_3dGyroHwInfo& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   SampleRate = coRef.SampleRate;
   MountAngles = coRef.MountAngles;
   RAxes = coRef.RAxes;
   SAxes = coRef.SAxes;
   TAxes = coRef.TAxes;
}
cmb_fi_tcl_3dGyroHwInfo& cmb_fi_tcl_3dGyroHwInfo::operator=(const cmb_fi_tcl_3dGyroHwInfo& coRef)
{
   if (this == &coRef) return *this;
   SampleRate = coRef.SampleRate;
   MountAngles = coRef.MountAngles;
   RAxes = coRef.RAxes;
   SAxes = coRef.SAxes;
   TAxes = coRef.TAxes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_3dGyroHwInfo::cmb_fi_tcl_3dGyroHwInfo()
:SampleRate(0)
,MountAngles()
,RAxes()
,SAxes()
,TAxes()
 {}

tS32 cmb_fi_tcl_3dGyroHwInfo::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_3DGYROHWINFO;
}


cmb_fi_tcl_3dGyroHwInfo::~cmb_fi_tcl_3dGyroHwInfo()
{}

tU32 cmb_fi_tcl_3dGyroHwInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 217;
}

fi_tclInContext& cmb_fi_tcl_3dGyroHwInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SampleRate);
   (tVoid) (oIn >> MountAngles);
   (tVoid) (oIn >> RAxes);
   (tVoid) (oIn >> SAxes);
   (tVoid) (oIn >> TAxes);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_3dGyroHwInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SampleRate);
   (tVoid) (oOut << MountAngles);
   (tVoid) (oOut << RAxes);
   (tVoid) (oOut << SAxes);
   (tVoid) (oOut << TAxes);
   return oOut;
}

tBool cmb_fi_tcl_3dGyroHwInfo::operator==(const cmb_fi_tcl_3dGyroHwInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SampleRate == roRef.SampleRate);
   bResult = bResult && (MountAngles == roRef.MountAngles);
   bResult = bResult && (RAxes == roRef.RAxes);
   bResult = bResult && (SAxes == roRef.SAxes);
   bResult = bResult && (TAxes == roRef.TAxes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_3dAccHwInfo::cmb_fi_tcl_3dAccHwInfo(const cmb_fi_tcl_3dAccHwInfo& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   SampleRate = coRef.SampleRate;
   MountAngles = coRef.MountAngles;
   RAxes = coRef.RAxes;
   SAxes = coRef.SAxes;
   TAxes = coRef.TAxes;
}
cmb_fi_tcl_3dAccHwInfo& cmb_fi_tcl_3dAccHwInfo::operator=(const cmb_fi_tcl_3dAccHwInfo& coRef)
{
   if (this == &coRef) return *this;
   SampleRate = coRef.SampleRate;
   MountAngles = coRef.MountAngles;
   RAxes = coRef.RAxes;
   SAxes = coRef.SAxes;
   TAxes = coRef.TAxes;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_3dAccHwInfo::cmb_fi_tcl_3dAccHwInfo()
:SampleRate(0)
,MountAngles()
,RAxes()
,SAxes()
,TAxes()
 {}

tS32 cmb_fi_tcl_3dAccHwInfo::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_3DACCHWINFO;
}


cmb_fi_tcl_3dAccHwInfo::~cmb_fi_tcl_3dAccHwInfo()
{}

tU32 cmb_fi_tcl_3dAccHwInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 217;
}

fi_tclInContext& cmb_fi_tcl_3dAccHwInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SampleRate);
   (tVoid) (oIn >> MountAngles);
   (tVoid) (oIn >> RAxes);
   (tVoid) (oIn >> SAxes);
   (tVoid) (oIn >> TAxes);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_3dAccHwInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SampleRate);
   (tVoid) (oOut << MountAngles);
   (tVoid) (oOut << RAxes);
   (tVoid) (oOut << SAxes);
   (tVoid) (oOut << TAxes);
   return oOut;
}

tBool cmb_fi_tcl_3dAccHwInfo::operator==(const cmb_fi_tcl_3dAccHwInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SampleRate == roRef.SampleRate);
   bResult = bResult && (MountAngles == roRef.MountAngles);
   bResult = bResult && (RAxes == roRef.RAxes);
   bResult = bResult && (SAxes == roRef.SAxes);
   bResult = bResult && (TAxes == roRef.TAxes);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_3dGyroData::cmb_fi_tcl_3dGyroData(const cmb_fi_tcl_3dGyroData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   TimeStamp3dGyro = coRef.TimeStamp3dGyro;
   RVal = coRef.RVal;
   SVal = coRef.SVal;
   TVal = coRef.TVal;
   RStatus = coRef.RStatus;
   SStatus = coRef.SStatus;
   TStatus = coRef.TStatus;
}
cmb_fi_tcl_3dGyroData& cmb_fi_tcl_3dGyroData::operator=(const cmb_fi_tcl_3dGyroData& coRef)
{
   if (this == &coRef) return *this;
   TimeStamp3dGyro = coRef.TimeStamp3dGyro;
   RVal = coRef.RVal;
   SVal = coRef.SVal;
   TVal = coRef.TVal;
   RStatus = coRef.RStatus;
   SStatus = coRef.SStatus;
   TStatus = coRef.TStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_3dGyroData::cmb_fi_tcl_3dGyroData()
:TimeStamp3dGyro(0)
,RVal(0)
,SVal(0)
,TVal(0)
,RStatus()
,SStatus()
,TStatus()
 {}

tS32 cmb_fi_tcl_3dGyroData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_3DGYRODATA;
}


cmb_fi_tcl_3dGyroData::~cmb_fi_tcl_3dGyroData()
{}

tU32 cmb_fi_tcl_3dGyroData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 22;
}

fi_tclInContext& cmb_fi_tcl_3dGyroData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TimeStamp3dGyro);
   (tVoid) (oIn >> RVal);
   (tVoid) (oIn >> SVal);
   (tVoid) (oIn >> TVal);
   (tVoid) (oIn >> RStatus);
   (tVoid) (oIn >> SStatus);
   (tVoid) (oIn >> TStatus);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_3dGyroData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TimeStamp3dGyro);
   (tVoid) (oOut << RVal);
   (tVoid) (oOut << SVal);
   (tVoid) (oOut << TVal);
   (tVoid) (oOut << RStatus);
   (tVoid) (oOut << SStatus);
   (tVoid) (oOut << TStatus);
   return oOut;
}

tBool cmb_fi_tcl_3dGyroData::operator==(const cmb_fi_tcl_3dGyroData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TimeStamp3dGyro == roRef.TimeStamp3dGyro);
   bResult = bResult && (RVal == roRef.RVal);
   bResult = bResult && (SVal == roRef.SVal);
   bResult = bResult && (TVal == roRef.TVal);
   bResult = bResult && (RStatus == roRef.RStatus);
   bResult = bResult && (SStatus == roRef.SStatus);
   bResult = bResult && (TStatus == roRef.TStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_3dAccData::cmb_fi_tcl_3dAccData(const cmb_fi_tcl_3dAccData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   TimeStamp3dAcc = coRef.TimeStamp3dAcc;
   RVal = coRef.RVal;
   SVal = coRef.SVal;
   TVal = coRef.TVal;
   RStatus = coRef.RStatus;
   SStatus = coRef.SStatus;
   TStatus = coRef.TStatus;
}
cmb_fi_tcl_3dAccData& cmb_fi_tcl_3dAccData::operator=(const cmb_fi_tcl_3dAccData& coRef)
{
   if (this == &coRef) return *this;
   TimeStamp3dAcc = coRef.TimeStamp3dAcc;
   RVal = coRef.RVal;
   SVal = coRef.SVal;
   TVal = coRef.TVal;
   RStatus = coRef.RStatus;
   SStatus = coRef.SStatus;
   TStatus = coRef.TStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_3dAccData::cmb_fi_tcl_3dAccData()
:TimeStamp3dAcc(0)
,RVal(0)
,SVal(0)
,TVal(0)
,RStatus()
,SStatus()
,TStatus()
 {}

tS32 cmb_fi_tcl_3dAccData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_3DACCDATA;
}


cmb_fi_tcl_3dAccData::~cmb_fi_tcl_3dAccData()
{}

tU32 cmb_fi_tcl_3dAccData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 22;
}

fi_tclInContext& cmb_fi_tcl_3dAccData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TimeStamp3dAcc);
   (tVoid) (oIn >> RVal);
   (tVoid) (oIn >> SVal);
   (tVoid) (oIn >> TVal);
   (tVoid) (oIn >> RStatus);
   (tVoid) (oIn >> SStatus);
   (tVoid) (oIn >> TStatus);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_3dAccData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TimeStamp3dAcc);
   (tVoid) (oOut << RVal);
   (tVoid) (oOut << SVal);
   (tVoid) (oOut << TVal);
   (tVoid) (oOut << RStatus);
   (tVoid) (oOut << SStatus);
   (tVoid) (oOut << TStatus);
   return oOut;
}

tBool cmb_fi_tcl_3dAccData::operator==(const cmb_fi_tcl_3dAccData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TimeStamp3dAcc == roRef.TimeStamp3dAcc);
   bResult = bResult && (RVal == roRef.RVal);
   bResult = bResult && (SVal == roRef.SVal);
   bResult = bResult && (TVal == roRef.TVal);
   bResult = bResult && (RStatus == roRef.RStatus);
   bResult = bResult && (SStatus == roRef.SStatus);
   bResult = bResult && (TStatus == roRef.TStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_TimeDate::cmb_fi_tcl_TimeDate(const cmb_fi_tcl_TimeDate& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   td_year = coRef.td_year;
   td_month = coRef.td_month;
   td_day = coRef.td_day;
   td_hour = coRef.td_hour;
   td_minute = coRef.td_minute;
   td_second = coRef.td_second;
   td_milliSeconds = coRef.td_milliSeconds;
}
cmb_fi_tcl_TimeDate& cmb_fi_tcl_TimeDate::operator=(const cmb_fi_tcl_TimeDate& coRef)
{
   if (this == &coRef) return *this;
   td_year = coRef.td_year;
   td_month = coRef.td_month;
   td_day = coRef.td_day;
   td_hour = coRef.td_hour;
   td_minute = coRef.td_minute;
   td_second = coRef.td_second;
   td_milliSeconds = coRef.td_milliSeconds;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_TimeDate::cmb_fi_tcl_TimeDate()
:td_year(0)
,td_month(0)
,td_day(0)
,td_hour(0)
,td_minute(0)
,td_second(0)
,td_milliSeconds(0)
 {}

tS32 cmb_fi_tcl_TimeDate::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_TIMEDATE;
}


cmb_fi_tcl_TimeDate::~cmb_fi_tcl_TimeDate()
{}

tU32 cmb_fi_tcl_TimeDate::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cmb_fi_tcl_TimeDate::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> td_year);
   (tVoid) (oIn >> td_month);
   (tVoid) (oIn >> td_day);
   (tVoid) (oIn >> td_hour);
   (tVoid) (oIn >> td_minute);
   (tVoid) (oIn >> td_second);
   (tVoid) (oIn >> td_milliSeconds);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_TimeDate::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << td_year);
   (tVoid) (oOut << td_month);
   (tVoid) (oOut << td_day);
   (tVoid) (oOut << td_hour);
   (tVoid) (oOut << td_minute);
   (tVoid) (oOut << td_second);
   (tVoid) (oOut << td_milliSeconds);
   return oOut;
}

tBool cmb_fi_tcl_TimeDate::operator==(const cmb_fi_tcl_TimeDate& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (td_year == roRef.td_year);
   bResult = bResult && (td_month == roRef.td_month);
   bResult = bResult && (td_day == roRef.td_day);
   bResult = bResult && (td_hour == roRef.td_hour);
   bResult = bResult && (td_minute == roRef.td_minute);
   bResult = bResult && (td_second == roRef.td_second);
   bResult = bResult && (td_milliSeconds == roRef.td_milliSeconds);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_timeMode::cmb_fi_tcl_e8_timeMode():enType(FI_EN_TIMEMODE_DEFAULT) {}

tS32 cmb_fi_tcl_e8_timeMode::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_TIMEMODE;
}


cmb_fi_tcl_e8_timeMode::~cmb_fi_tcl_e8_timeMode()
{}

tU32 cmb_fi_tcl_e8_timeMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_timeMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_timeMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

cmb_fi_tcl_Reserved::cmb_fi_tcl_Reserved()
 {}

tS32 cmb_fi_tcl_Reserved::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_RESERVED;
}


cmb_fi_tcl_Reserved::~cmb_fi_tcl_Reserved()
{}

tU32 cmb_fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& cmb_fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s16_PerThousand::cmb_fi_tcl_s16_PerThousand(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cmb_fi_tcl_s16_PerThousand::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S16_PERTHOUSAND;
}


cmb_fi_tcl_s16_PerThousand::~cmb_fi_tcl_s16_PerThousand()
{}

tU32 cmb_fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cmb_fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s32_Pascal::cmb_fi_tcl_s32_Pascal(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cmb_fi_tcl_s32_Pascal::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S32_PASCAL;
}


cmb_fi_tcl_s32_Pascal::~cmb_fi_tcl_s32_Pascal()
{}

tU32 cmb_fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cmb_fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_u8_Percent::cmb_fi_tcl_u8_Percent(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 cmb_fi_tcl_u8_Percent::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_U8_PERCENT;
}


cmb_fi_tcl_u8_Percent::~cmb_fi_tcl_u8_Percent()
{}

tU32 cmb_fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& cmb_fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s32_Centimeter::cmb_fi_tcl_s32_Centimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cmb_fi_tcl_s32_Centimeter::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S32_CENTIMETER;
}


cmb_fi_tcl_s32_Centimeter::~cmb_fi_tcl_s32_Centimeter()
{}

tU32 cmb_fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cmb_fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s16_CentiDegree::cmb_fi_tcl_s16_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cmb_fi_tcl_s16_CentiDegree::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S16_CENTIDEGREE;
}


cmb_fi_tcl_s16_CentiDegree::~cmb_fi_tcl_s16_CentiDegree()
{}

tU32 cmb_fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cmb_fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s16_KmPerHour::cmb_fi_tcl_s16_KmPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cmb_fi_tcl_s16_KmPerHour::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S16_KMPERHOUR;
}


cmb_fi_tcl_s16_KmPerHour::~cmb_fi_tcl_s16_KmPerHour()
{}

tU32 cmb_fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cmb_fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_u16_RPM::cmb_fi_tcl_u16_RPM(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 cmb_fi_tcl_u16_RPM::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_U16_RPM;
}


cmb_fi_tcl_u16_RPM::~cmb_fi_tcl_u16_RPM()
{}

tU32 cmb_fi_tcl_u16_RPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_u16_RPM::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cmb_fi_tcl_u16_RPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s16_CentimeterSecond::cmb_fi_tcl_s16_CentimeterSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cmb_fi_tcl_s16_CentimeterSecond::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S16_CENTIMETERSECOND;
}


cmb_fi_tcl_s16_CentimeterSecond::~cmb_fi_tcl_s16_CentimeterSecond()
{}

tU32 cmb_fi_tcl_s16_CentimeterSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_s16_CentimeterSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cmb_fi_tcl_s16_CentimeterSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s16_Meter::cmb_fi_tcl_s16_Meter(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cmb_fi_tcl_s16_Meter::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S16_METER;
}


cmb_fi_tcl_s16_Meter::~cmb_fi_tcl_s16_Meter()
{}

tU32 cmb_fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cmb_fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s32_Meter::cmb_fi_tcl_s32_Meter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cmb_fi_tcl_s32_Meter::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S32_METER;
}


cmb_fi_tcl_s32_Meter::~cmb_fi_tcl_s32_Meter()
{}

tU32 cmb_fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cmb_fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s32_Yards::cmb_fi_tcl_s32_Yards(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cmb_fi_tcl_s32_Yards::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S32_YARDS;
}


cmb_fi_tcl_s32_Yards::~cmb_fi_tcl_s32_Yards()
{}

tU32 cmb_fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cmb_fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s32_Inch::cmb_fi_tcl_s32_Inch(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cmb_fi_tcl_s32_Inch::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S32_INCH;
}


cmb_fi_tcl_s32_Inch::~cmb_fi_tcl_s32_Inch()
{}

tU32 cmb_fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cmb_fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s32_Kilogram::cmb_fi_tcl_s32_Kilogram(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cmb_fi_tcl_s32_Kilogram::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S32_KILOGRAM;
}


cmb_fi_tcl_s32_Kilogram::~cmb_fi_tcl_s32_Kilogram()
{}

tU32 cmb_fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cmb_fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s16_DirectionRelative_CentiDegree::cmb_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cmb_fi_tcl_s16_DirectionRelative_CentiDegree::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;
}


cmb_fi_tcl_s16_DirectionRelative_CentiDegree::~cmb_fi_tcl_s16_DirectionRelative_CentiDegree()
{}

tU32 cmb_fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cmb_fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_u16_MilliSecond::cmb_fi_tcl_u16_MilliSecond(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 cmb_fi_tcl_u16_MilliSecond::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_U16_MILLISECOND;
}


cmb_fi_tcl_u16_MilliSecond::~cmb_fi_tcl_u16_MilliSecond()
{}

tU32 cmb_fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cmb_fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s32_MilliSecond::cmb_fi_tcl_s32_MilliSecond(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cmb_fi_tcl_s32_MilliSecond::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S32_MILLISECOND;
}


cmb_fi_tcl_s32_MilliSecond::~cmb_fi_tcl_s32_MilliSecond()
{}

tU32 cmb_fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cmb_fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s32_Longitude::cmb_fi_tcl_s32_Longitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cmb_fi_tcl_s32_Longitude::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S32_LONGITUDE;
}


cmb_fi_tcl_s32_Longitude::~cmb_fi_tcl_s32_Longitude()
{}

tU32 cmb_fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cmb_fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s32_Latitude::cmb_fi_tcl_s32_Latitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cmb_fi_tcl_s32_Latitude::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S32_LATITUDE;
}


cmb_fi_tcl_s32_Latitude::~cmb_fi_tcl_s32_Latitude()
{}

tU32 cmb_fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cmb_fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_PositionWGS84::cmb_fi_tcl_PositionWGS84(const cmb_fi_tcl_PositionWGS84& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}
cmb_fi_tcl_PositionWGS84& cmb_fi_tcl_PositionWGS84::operator=(const cmb_fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_PositionWGS84::cmb_fi_tcl_PositionWGS84()
:Longitude()
,Latitude()
 {}

tS32 cmb_fi_tcl_PositionWGS84::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_POSITIONWGS84;
}


cmb_fi_tcl_PositionWGS84::~cmb_fi_tcl_PositionWGS84()
{}

tU32 cmb_fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& cmb_fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Latitude);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Latitude);
   return oOut;
}

tBool cmb_fi_tcl_PositionWGS84::operator==(const cmb_fi_tcl_PositionWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (Latitude == roRef.Latitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s16_MilesPerHour::cmb_fi_tcl_s16_MilesPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cmb_fi_tcl_s16_MilesPerHour::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S16_MILESPERHOUR;
}


cmb_fi_tcl_s16_MilesPerHour::~cmb_fi_tcl_s16_MilesPerHour()
{}

tU32 cmb_fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cmb_fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s32_Pound::cmb_fi_tcl_s32_Pound(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cmb_fi_tcl_s32_Pound::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S32_POUND;
}


cmb_fi_tcl_s32_Pound::~cmb_fi_tcl_s32_Pound()
{}

tU32 cmb_fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cmb_fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s16_DeciKelvin::cmb_fi_tcl_s16_DeciKelvin(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cmb_fi_tcl_s16_DeciKelvin::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S16_DECIKELVIN;
}


cmb_fi_tcl_s16_DeciKelvin::~cmb_fi_tcl_s16_DeciKelvin()
{}

tU32 cmb_fi_tcl_s16_DeciKelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_s16_DeciKelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cmb_fi_tcl_s16_DeciKelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s16_CentiDegreeSecond::cmb_fi_tcl_s16_CentiDegreeSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cmb_fi_tcl_s16_CentiDegreeSecond::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S16_CENTIDEGREESECOND;
}


cmb_fi_tcl_s16_CentiDegreeSecond::~cmb_fi_tcl_s16_CentiDegreeSecond()
{}

tU32 cmb_fi_tcl_s16_CentiDegreeSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_s16_CentiDegreeSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cmb_fi_tcl_s16_CentiDegreeSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_u32_MilliLux::cmb_fi_tcl_u32_MilliLux(tU32 _u32Value)
: u32Value(_u32Value
) {} 

tS32 cmb_fi_tcl_u32_MilliLux::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_U32_MILLILUX;
}


cmb_fi_tcl_u32_MilliLux::~cmb_fi_tcl_u32_MilliLux()
{}

tU32 cmb_fi_tcl_u32_MilliLux::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_u32_MilliLux::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& cmb_fi_tcl_u32_MilliLux::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_u32_Microliter::cmb_fi_tcl_u32_Microliter(tU32 _u32Value)
: u32Value(_u32Value
) {} 

tS32 cmb_fi_tcl_u32_Microliter::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_U32_MICROLITER;
}


cmb_fi_tcl_u32_Microliter::~cmb_fi_tcl_u32_Microliter()
{}

tU32 cmb_fi_tcl_u32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_u32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& cmb_fi_tcl_u32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s16_CentimeterSquareSecond::cmb_fi_tcl_s16_CentimeterSquareSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cmb_fi_tcl_s16_CentimeterSquareSecond::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S16_CENTIMETERSQUARESECOND;
}


cmb_fi_tcl_s16_CentimeterSquareSecond::~cmb_fi_tcl_s16_CentimeterSquareSecond()
{}

tU32 cmb_fi_tcl_s16_CentimeterSquareSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_s16_CentimeterSquareSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cmb_fi_tcl_s16_CentimeterSquareSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s16_CurvatureValue::cmb_fi_tcl_s16_CurvatureValue(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cmb_fi_tcl_s16_CurvatureValue::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S16_CURVATUREVALUE;
}


cmb_fi_tcl_s16_CurvatureValue::~cmb_fi_tcl_s16_CurvatureValue()
{}

tU32 cmb_fi_tcl_s16_CurvatureValue::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_s16_CurvatureValue::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cmb_fi_tcl_s16_CurvatureValue::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s32_CurvatureChange::cmb_fi_tcl_s32_CurvatureChange(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cmb_fi_tcl_s32_CurvatureChange::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S32_CURVATURECHANGE;
}


cmb_fi_tcl_s32_CurvatureChange::~cmb_fi_tcl_s32_CurvatureChange()
{}

tU32 cmb_fi_tcl_s32_CurvatureChange::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_s32_CurvatureChange::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cmb_fi_tcl_s32_CurvatureChange::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e16_BaseTrafficSign::cmb_fi_tcl_e16_BaseTrafficSign():enType(FI_EN_UNSPECIFIED) {}

tS32 cmb_fi_tcl_e16_BaseTrafficSign::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E16_BASETRAFFICSIGN;
}


cmb_fi_tcl_e16_BaseTrafficSign::~cmb_fi_tcl_e16_BaseTrafficSign()
{}

tU32 cmb_fi_tcl_e16_BaseTrafficSign::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_e16_BaseTrafficSign::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e16_BaseTrafficSign::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_BaseTrafficSignCategory::cmb_fi_tcl_e8_BaseTrafficSignCategory():enType(FI_EN_T_RESERVED) {}

tS32 cmb_fi_tcl_e8_BaseTrafficSignCategory::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_BASETRAFFICSIGNCATEGORY;
}


cmb_fi_tcl_e8_BaseTrafficSignCategory::~cmb_fi_tcl_e8_BaseTrafficSignCategory()
{}

tU32 cmb_fi_tcl_e8_BaseTrafficSignCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_BaseTrafficSignCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_BaseTrafficSignCategory::oWrite(fi_tclOutContext& oOut) const
{
   cmb_fi_tcl_e8_BaseTrafficSignCategory::tenType enData = enType;
   if ((enData == FI_EN_T_E16_REGULATORYSIGN) && !(7 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_SpeedSign::cmb_fi_tcl_e8_SpeedSign():enType(FI_EN_UNSPECIFIED) {}

tS32 cmb_fi_tcl_e8_SpeedSign::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_SPEEDSIGN;
}


cmb_fi_tcl_e8_SpeedSign::~cmb_fi_tcl_e8_SpeedSign()
{}

tU32 cmb_fi_tcl_e8_SpeedSign::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_SpeedSign::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_SpeedSign::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e16_WarningSign::cmb_fi_tcl_e16_WarningSign():enType(FI_EN_UNSPECIFIED) {}

tS32 cmb_fi_tcl_e16_WarningSign::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E16_WARNINGSIGN;
}


cmb_fi_tcl_e16_WarningSign::~cmb_fi_tcl_e16_WarningSign()
{}

tU32 cmb_fi_tcl_e16_WarningSign::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_e16_WarningSign::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e16_WarningSign::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e16_RegulatorySign::cmb_fi_tcl_e16_RegulatorySign():enType(FI_EN_UNSPECIFIED) {}

tS32 cmb_fi_tcl_e16_RegulatorySign::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E16_REGULATORYSIGN;
}


cmb_fi_tcl_e16_RegulatorySign::~cmb_fi_tcl_e16_RegulatorySign()
{}

tU32 cmb_fi_tcl_e16_RegulatorySign::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_e16_RegulatorySign::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e16_RegulatorySign::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e16_AdditionalTrafficSign::cmb_fi_tcl_e16_AdditionalTrafficSign():enType(FI_EN_UNSPECIFIED) {}

tS32 cmb_fi_tcl_e16_AdditionalTrafficSign::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E16_ADDITIONALTRAFFICSIGN;
}


cmb_fi_tcl_e16_AdditionalTrafficSign::~cmb_fi_tcl_e16_AdditionalTrafficSign()
{}

tU32 cmb_fi_tcl_e16_AdditionalTrafficSign::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_e16_AdditionalTrafficSign::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e16_AdditionalTrafficSign::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_TimeDependentString::vDestroy()
{
   szValue.vDestroy();
}

cmb_fi_tcl_TimeDependentString::cmb_fi_tcl_TimeDependentString(tString _szValue)
: szValue(_szValue
) {} 

tS32 cmb_fi_tcl_TimeDependentString::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_TIMEDEPENDENTSTRING;
}


cmb_fi_tcl_TimeDependentString::~cmb_fi_tcl_TimeDependentString()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_TimeDependentString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0+ szValue.u32GetSize(0);
}

fi_tclInContext& cmb_fi_tcl_TimeDependentString::oRead(fi_tclInContext& oIn)
{
   return oIn >> szValue;
}

fi_tclOutContext& cmb_fi_tcl_TimeDependentString::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << szValue;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b8_LaneDependentValidity::cmb_fi_tcl_b8_LaneDependentValidity():u8Value(0)
{}

tS32 cmb_fi_tcl_b8_LaneDependentValidity::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B8_LANEDEPENDENTVALIDITY;
}


cmb_fi_tcl_b8_LaneDependentValidity::~cmb_fi_tcl_b8_LaneDependentValidity()
{}

tU32 cmb_fi_tcl_b8_LaneDependentValidity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_b8_LaneDependentValidity::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& cmb_fi_tcl_b8_LaneDependentValidity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_TrafficSignQuantifier::cmb_fi_tcl_e8_TrafficSignQuantifier():enType(FI_EN_T_RESERVED) {}

tS32 cmb_fi_tcl_e8_TrafficSignQuantifier::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_TRAFFICSIGNQUANTIFIER;
}


cmb_fi_tcl_e8_TrafficSignQuantifier::~cmb_fi_tcl_e8_TrafficSignQuantifier()
{}

tU32 cmb_fi_tcl_e8_TrafficSignQuantifier::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_TrafficSignQuantifier::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_TrafficSignQuantifier::oWrite(fi_tclOutContext& oOut) const
{
   cmb_fi_tcl_e8_TrafficSignQuantifier::tenType enData = enType;
   if ((enData == FI_EN_T_S32_POUND) && !(7 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_S32_KILOGRAM) && !(7 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_S32_INCH) && !(7 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   if ((enData == FI_EN_T_S32_CENTIMETER) && !(7 <= oOut.u16GetMajorVersion()))
   {
      enData = FI_EN_T_RESERVED;
   }
   return oOut.oWrite((tU8)enData);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_AdditionalTrafficSign::cmb_fi_tcl_AdditionalTrafficSign(const cmb_fi_tcl_AdditionalTrafficSign& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   AdditionalSign = coRef.AdditionalSign;
   QuantifierOfAddSignType = coRef.QuantifierOfAddSignType;
   if  (coRef.poQuantifierOfAddSignData)
   {
      switch(QuantifierOfAddSignType.enType)
      {
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_Reserved((const cmb_fi_tcl_Reserved&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s16_KmPerHour((const cmb_fi_tcl_s16_KmPerHour&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s16_MilesPerHour((const cmb_fi_tcl_s16_MilesPerHour&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tclString((const cmb_fi_tclString&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_u8_Percent((const cmb_fi_tcl_u8_Percent&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_b8_LaneDependentValidity((const cmb_fi_tcl_b8_LaneDependentValidity&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_TimeDependentString((const cmb_fi_tcl_TimeDependentString&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Meter((const cmb_fi_tcl_s32_Meter&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Yards((const cmb_fi_tcl_s32_Yards&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tclMultiLanguageString((const cmb_fi_tclMultiLanguageString&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Centimeter((const cmb_fi_tcl_s32_Centimeter&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Inch((const cmb_fi_tcl_s32_Inch&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Kilogram((const cmb_fi_tcl_s32_Kilogram&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Pound((const cmb_fi_tcl_s32_Pound&)*coRef.poQuantifierOfAddSignData);
         break;
      default:
         poQuantifierOfAddSignData = OSAL_NULL;
      }
   }
   else
   {
      poQuantifierOfAddSignData = OSAL_NULL;
   }
}
cmb_fi_tcl_AdditionalTrafficSign& cmb_fi_tcl_AdditionalTrafficSign::operator=(const cmb_fi_tcl_AdditionalTrafficSign& coRef)
{
   if (this == &coRef) return *this;
   AdditionalSign = coRef.AdditionalSign;
   OSAL_DELETE poQuantifierOfAddSignData;
   QuantifierOfAddSignType = coRef.QuantifierOfAddSignType;
   if  (coRef.poQuantifierOfAddSignData)
   {
      switch(QuantifierOfAddSignType.enType)
      {
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_Reserved((const cmb_fi_tcl_Reserved&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s16_KmPerHour((const cmb_fi_tcl_s16_KmPerHour&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s16_MilesPerHour((const cmb_fi_tcl_s16_MilesPerHour&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tclString((const cmb_fi_tclString&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_u8_Percent((const cmb_fi_tcl_u8_Percent&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_b8_LaneDependentValidity((const cmb_fi_tcl_b8_LaneDependentValidity&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_TimeDependentString((const cmb_fi_tcl_TimeDependentString&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Meter((const cmb_fi_tcl_s32_Meter&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Yards((const cmb_fi_tcl_s32_Yards&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tclMultiLanguageString((const cmb_fi_tclMultiLanguageString&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Centimeter((const cmb_fi_tcl_s32_Centimeter&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Inch((const cmb_fi_tcl_s32_Inch&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Kilogram((const cmb_fi_tcl_s32_Kilogram&)*coRef.poQuantifierOfAddSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Pound((const cmb_fi_tcl_s32_Pound&)*coRef.poQuantifierOfAddSignData);
         break;
      default:
         poQuantifierOfAddSignData = OSAL_NULL;
      }
   }
   else
   {
      poQuantifierOfAddSignData = OSAL_NULL;
   }
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_AdditionalTrafficSign::vDestroy()
{
   if (poQuantifierOfAddSignData)
   {
      poQuantifierOfAddSignData->vDestroy();
      OSAL_DELETE poQuantifierOfAddSignData;
      poQuantifierOfAddSignData = OSAL_NULL;
   }
}

cmb_fi_tcl_AdditionalTrafficSign::cmb_fi_tcl_AdditionalTrafficSign()
:AdditionalSign()
,poQuantifierOfAddSignData(0)
 {}

tS32 cmb_fi_tcl_AdditionalTrafficSign::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_ADDITIONALTRAFFICSIGN;
}


cmb_fi_tcl_AdditionalTrafficSign::~cmb_fi_tcl_AdditionalTrafficSign()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_AdditionalTrafficSign::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING)
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if ((QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER) &&
       (7 <= u16MajorVersion))
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if ((QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH) &&
       (7 <= u16MajorVersion))
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if ((QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM) &&
       (7 <= u16MajorVersion))
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   if ((QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND) &&
       (7 <= u16MajorVersion))
      u32DynamicSize += (poQuantifierOfAddSignData?poQuantifierOfAddSignData->u32GetSize(u16MajorVersion):0);
   return u32DynamicSize+3;
}

fi_tclInContext& cmb_fi_tcl_AdditionalTrafficSign::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> AdditionalSign);
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poQuantifierOfAddSignData;
#else
   if (poQuantifierOfAddSignData)
   {
      poQuantifierOfAddSignData->vDestroy();
      OSAL_DELETE poQuantifierOfAddSignData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   (tVoid) (oIn >> QuantifierOfAddSignType);
   switch(QuantifierOfAddSignType.enType)
   {
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
      poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_Reserved;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
      poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s16_KmPerHour;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
      poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s16_MilesPerHour;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
      poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tclString;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
      poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_u8_Percent;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
      poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_b8_LaneDependentValidity;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
      poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_TimeDependentString;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
      poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Meter;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
      poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Yards;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
      poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tclMultiLanguageString;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
      poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Centimeter;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
      poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Inch;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
      poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Kilogram;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
      poQuantifierOfAddSignData = OSAL_NEW cmb_fi_tcl_s32_Pound;
      break;
   default:
      oIn.Invalidate();
      poQuantifierOfAddSignData = OSAL_NULL;
   }
   if (poQuantifierOfAddSignData && oIn.bIsValid())
      poQuantifierOfAddSignData->oRead(oIn);
   else
      oIn.Invalidate();
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_AdditionalTrafficSign::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << AdditionalSign);
   (tVoid) (oOut << QuantifierOfAddSignType);
   if (poQuantifierOfAddSignData)
   {
      if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING)
      {
         poQuantifierOfAddSignData->oWrite(oOut);
      }
      if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER)
      {
         if (!(7 <= oOut.u16GetMajorVersion()))
         {
            cmb_fi_tcl_Reserved oDefault;
            (tVoid) (oOut << oDefault);
         }
         else
         {
            poQuantifierOfAddSignData->oWrite(oOut);
         }
      }
      if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH)
      {
         if (!(7 <= oOut.u16GetMajorVersion()))
         {
            cmb_fi_tcl_Reserved oDefault;
            (tVoid) (oOut << oDefault);
         }
         else
         {
            poQuantifierOfAddSignData->oWrite(oOut);
         }
      }
      if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM)
      {
         if (!(7 <= oOut.u16GetMajorVersion()))
         {
            cmb_fi_tcl_Reserved oDefault;
            (tVoid) (oOut << oDefault);
         }
         else
         {
            poQuantifierOfAddSignData->oWrite(oOut);
         }
      }
      if (QuantifierOfAddSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND)
      {
         if (!(7 <= oOut.u16GetMajorVersion()))
         {
            cmb_fi_tcl_Reserved oDefault;
            (tVoid) (oOut << oDefault);
         }
         else
         {
            poQuantifierOfAddSignData->oWrite(oOut);
         }
      }
   }
   else
   {
      oOut.Invalidate();
   }
   return oOut;
}

tBool cmb_fi_tcl_AdditionalTrafficSign::operator==(const cmb_fi_tcl_AdditionalTrafficSign& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (AdditionalSign == roRef.AdditionalSign);
   bResult = bResult && (QuantifierOfAddSignType == roRef.QuantifierOfAddSignType);
   if (bResult && poQuantifierOfAddSignData && roRef.poQuantifierOfAddSignData) 
   {
      switch (QuantifierOfAddSignType.enType)
      {
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         bResult = bResult && (*(const cmb_fi_tcl_Reserved*)poQuantifierOfAddSignData == *(const cmb_fi_tcl_Reserved*)roRef.poQuantifierOfAddSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         bResult = bResult && (*(const cmb_fi_tcl_s16_KmPerHour*)poQuantifierOfAddSignData == *(const cmb_fi_tcl_s16_KmPerHour*)roRef.poQuantifierOfAddSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         bResult = bResult && (*(const cmb_fi_tcl_s16_MilesPerHour*)poQuantifierOfAddSignData == *(const cmb_fi_tcl_s16_MilesPerHour*)roRef.poQuantifierOfAddSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         bResult = bResult && (*(const cmb_fi_tclString*)poQuantifierOfAddSignData == *(const cmb_fi_tclString*)roRef.poQuantifierOfAddSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         bResult = bResult && (*(const cmb_fi_tcl_u8_Percent*)poQuantifierOfAddSignData == *(const cmb_fi_tcl_u8_Percent*)roRef.poQuantifierOfAddSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         bResult = bResult && (*(const cmb_fi_tcl_b8_LaneDependentValidity*)poQuantifierOfAddSignData == *(const cmb_fi_tcl_b8_LaneDependentValidity*)roRef.poQuantifierOfAddSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         bResult = bResult && (*(const cmb_fi_tcl_TimeDependentString*)poQuantifierOfAddSignData == *(const cmb_fi_tcl_TimeDependentString*)roRef.poQuantifierOfAddSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         bResult = bResult && (*(const cmb_fi_tcl_s32_Meter*)poQuantifierOfAddSignData == *(const cmb_fi_tcl_s32_Meter*)roRef.poQuantifierOfAddSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         bResult = bResult && (*(const cmb_fi_tcl_s32_Yards*)poQuantifierOfAddSignData == *(const cmb_fi_tcl_s32_Yards*)roRef.poQuantifierOfAddSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         bResult = bResult && (*(const cmb_fi_tclMultiLanguageString*)poQuantifierOfAddSignData == *(const cmb_fi_tclMultiLanguageString*)roRef.poQuantifierOfAddSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         bResult = bResult && (*(const cmb_fi_tcl_s32_Centimeter*)poQuantifierOfAddSignData == *(const cmb_fi_tcl_s32_Centimeter*)roRef.poQuantifierOfAddSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         bResult = bResult && (*(const cmb_fi_tcl_s32_Inch*)poQuantifierOfAddSignData == *(const cmb_fi_tcl_s32_Inch*)roRef.poQuantifierOfAddSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         bResult = bResult && (*(const cmb_fi_tcl_s32_Kilogram*)poQuantifierOfAddSignData == *(const cmb_fi_tcl_s32_Kilogram*)roRef.poQuantifierOfAddSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         bResult = bResult && (*(const cmb_fi_tcl_s32_Pound*)poQuantifierOfAddSignData == *(const cmb_fi_tcl_s32_Pound*)roRef.poQuantifierOfAddSignData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poQuantifierOfAddSignData == roRef.poQuantifierOfAddSignData);
   }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_TrafficSignElement::cmb_fi_tcl_TrafficSignElement(const cmb_fi_tcl_TrafficSignElement& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   DynamicTrafficSign = coRef.DynamicTrafficSign;
   VirtualTrafficSign = coRef.VirtualTrafficSign;
   BaseSignUnionType = coRef.BaseSignUnionType;
   if  (coRef.poBaseSignUnionData)
   {
      switch(BaseSignUnionType.enType)
      {
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED:
         poBaseSignUnionData = OSAL_NEW cmb_fi_tcl_Reserved((const cmb_fi_tcl_Reserved&)*coRef.poBaseSignUnionData);
         break;
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E8_SPEEDSIGN:
         poBaseSignUnionData = OSAL_NEW cmb_fi_tcl_e8_SpeedSign((const cmb_fi_tcl_e8_SpeedSign&)*coRef.poBaseSignUnionData);
         break;
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_WARNINGSIGN:
         poBaseSignUnionData = OSAL_NEW cmb_fi_tcl_e16_WarningSign((const cmb_fi_tcl_e16_WarningSign&)*coRef.poBaseSignUnionData);
         break;
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN:
         poBaseSignUnionData = OSAL_NEW cmb_fi_tcl_e16_RegulatorySign((const cmb_fi_tcl_e16_RegulatorySign&)*coRef.poBaseSignUnionData);
         break;
      default:
         poBaseSignUnionData = OSAL_NULL;
      }
   }
   else
   {
      poBaseSignUnionData = OSAL_NULL;
   }
   QuantifierOfBaseSignType = coRef.QuantifierOfBaseSignType;
   if  (coRef.poQuantifierOfBaseSignData)
   {
      switch(QuantifierOfBaseSignType.enType)
      {
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_Reserved((const cmb_fi_tcl_Reserved&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s16_KmPerHour((const cmb_fi_tcl_s16_KmPerHour&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s16_MilesPerHour((const cmb_fi_tcl_s16_MilesPerHour&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tclString((const cmb_fi_tclString&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_u8_Percent((const cmb_fi_tcl_u8_Percent&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_b8_LaneDependentValidity((const cmb_fi_tcl_b8_LaneDependentValidity&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_TimeDependentString((const cmb_fi_tcl_TimeDependentString&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Meter((const cmb_fi_tcl_s32_Meter&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Yards((const cmb_fi_tcl_s32_Yards&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tclMultiLanguageString((const cmb_fi_tclMultiLanguageString&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Centimeter((const cmb_fi_tcl_s32_Centimeter&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Inch((const cmb_fi_tcl_s32_Inch&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Kilogram((const cmb_fi_tcl_s32_Kilogram&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Pound((const cmb_fi_tcl_s32_Pound&)*coRef.poQuantifierOfBaseSignData);
         break;
      default:
         poQuantifierOfBaseSignData = OSAL_NULL;
      }
   }
   else
   {
      poQuantifierOfBaseSignData = OSAL_NULL;
   }
   AdditionalSignList = coRef.AdditionalSignList;
}
cmb_fi_tcl_TrafficSignElement& cmb_fi_tcl_TrafficSignElement::operator=(const cmb_fi_tcl_TrafficSignElement& coRef)
{
   if (this == &coRef) return *this;
   DynamicTrafficSign = coRef.DynamicTrafficSign;
   VirtualTrafficSign = coRef.VirtualTrafficSign;
   OSAL_DELETE poBaseSignUnionData;
   BaseSignUnionType = coRef.BaseSignUnionType;
   if  (coRef.poBaseSignUnionData)
   {
      switch(BaseSignUnionType.enType)
      {
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED:
         poBaseSignUnionData = OSAL_NEW cmb_fi_tcl_Reserved((const cmb_fi_tcl_Reserved&)*coRef.poBaseSignUnionData);
         break;
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E8_SPEEDSIGN:
         poBaseSignUnionData = OSAL_NEW cmb_fi_tcl_e8_SpeedSign((const cmb_fi_tcl_e8_SpeedSign&)*coRef.poBaseSignUnionData);
         break;
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_WARNINGSIGN:
         poBaseSignUnionData = OSAL_NEW cmb_fi_tcl_e16_WarningSign((const cmb_fi_tcl_e16_WarningSign&)*coRef.poBaseSignUnionData);
         break;
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN:
         poBaseSignUnionData = OSAL_NEW cmb_fi_tcl_e16_RegulatorySign((const cmb_fi_tcl_e16_RegulatorySign&)*coRef.poBaseSignUnionData);
         break;
      default:
         poBaseSignUnionData = OSAL_NULL;
      }
   }
   else
   {
      poBaseSignUnionData = OSAL_NULL;
   }
   OSAL_DELETE poQuantifierOfBaseSignData;
   QuantifierOfBaseSignType = coRef.QuantifierOfBaseSignType;
   if  (coRef.poQuantifierOfBaseSignData)
   {
      switch(QuantifierOfBaseSignType.enType)
      {
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_Reserved((const cmb_fi_tcl_Reserved&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s16_KmPerHour((const cmb_fi_tcl_s16_KmPerHour&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s16_MilesPerHour((const cmb_fi_tcl_s16_MilesPerHour&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tclString((const cmb_fi_tclString&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_u8_Percent((const cmb_fi_tcl_u8_Percent&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_b8_LaneDependentValidity((const cmb_fi_tcl_b8_LaneDependentValidity&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_TimeDependentString((const cmb_fi_tcl_TimeDependentString&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Meter((const cmb_fi_tcl_s32_Meter&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Yards((const cmb_fi_tcl_s32_Yards&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tclMultiLanguageString((const cmb_fi_tclMultiLanguageString&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Centimeter((const cmb_fi_tcl_s32_Centimeter&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Inch((const cmb_fi_tcl_s32_Inch&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Kilogram((const cmb_fi_tcl_s32_Kilogram&)*coRef.poQuantifierOfBaseSignData);
         break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Pound((const cmb_fi_tcl_s32_Pound&)*coRef.poQuantifierOfBaseSignData);
         break;
      default:
         poQuantifierOfBaseSignData = OSAL_NULL;
      }
   }
   else
   {
      poQuantifierOfBaseSignData = OSAL_NULL;
   }
   AdditionalSignList = coRef.AdditionalSignList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_TrafficSignElement::vDestroy()
{
   if (poBaseSignUnionData)
   {
      poBaseSignUnionData->vDestroy();
      OSAL_DELETE poBaseSignUnionData;
      poBaseSignUnionData = OSAL_NULL;
   }
   if (poQuantifierOfBaseSignData)
   {
      poQuantifierOfBaseSignData->vDestroy();
      OSAL_DELETE poQuantifierOfBaseSignData;
      poQuantifierOfBaseSignData = OSAL_NULL;
   }
   {
      for (tU32 u32Idx = 0; u32Idx < AdditionalSignList.size(); ++u32Idx)
         AdditionalSignList[u32Idx].vDestroy();
   AdditionalSignList.clear();
   }
}

cmb_fi_tcl_TrafficSignElement::cmb_fi_tcl_TrafficSignElement()
:DynamicTrafficSign(0)
,VirtualTrafficSign(0)
,poBaseSignUnionData(0)
,poQuantifierOfBaseSignData(0)

 {}

tS32 cmb_fi_tcl_TrafficSignElement::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_TRAFFICSIGNELEMENT;
}


cmb_fi_tcl_TrafficSignElement::~cmb_fi_tcl_TrafficSignElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_TrafficSignElement::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (BaseSignUnionType.enType == cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED)
      u32DynamicSize += (poBaseSignUnionData?poBaseSignUnionData->u32GetSize(u16MajorVersion):0);
   if (BaseSignUnionType.enType == cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E8_SPEEDSIGN)
      u32DynamicSize += (poBaseSignUnionData?poBaseSignUnionData->u32GetSize(u16MajorVersion):0);
   if (BaseSignUnionType.enType == cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_WARNINGSIGN)
      u32DynamicSize += (poBaseSignUnionData?poBaseSignUnionData->u32GetSize(u16MajorVersion):0);
   if ((BaseSignUnionType.enType == cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN) &&
       (7 <= u16MajorVersion))
      u32DynamicSize += (poBaseSignUnionData?poBaseSignUnionData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED)
      u32DynamicSize += (poQuantifierOfBaseSignData?poQuantifierOfBaseSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR)
      u32DynamicSize += (poQuantifierOfBaseSignData?poQuantifierOfBaseSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR)
      u32DynamicSize += (poQuantifierOfBaseSignData?poQuantifierOfBaseSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING)
      u32DynamicSize += (poQuantifierOfBaseSignData?poQuantifierOfBaseSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT)
      u32DynamicSize += (poQuantifierOfBaseSignData?poQuantifierOfBaseSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY)
      u32DynamicSize += (poQuantifierOfBaseSignData?poQuantifierOfBaseSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING)
      u32DynamicSize += (poQuantifierOfBaseSignData?poQuantifierOfBaseSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER)
      u32DynamicSize += (poQuantifierOfBaseSignData?poQuantifierOfBaseSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS)
      u32DynamicSize += (poQuantifierOfBaseSignData?poQuantifierOfBaseSignData->u32GetSize(u16MajorVersion):0);
   if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING)
      u32DynamicSize += (poQuantifierOfBaseSignData?poQuantifierOfBaseSignData->u32GetSize(u16MajorVersion):0);
   if ((QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER) &&
       (7 <= u16MajorVersion))
      u32DynamicSize += (poQuantifierOfBaseSignData?poQuantifierOfBaseSignData->u32GetSize(u16MajorVersion):0);
   if ((QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH) &&
       (7 <= u16MajorVersion))
      u32DynamicSize += (poQuantifierOfBaseSignData?poQuantifierOfBaseSignData->u32GetSize(u16MajorVersion):0);
   if ((QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM) &&
       (7 <= u16MajorVersion))
      u32DynamicSize += (poQuantifierOfBaseSignData?poQuantifierOfBaseSignData->u32GetSize(u16MajorVersion):0);
   if ((QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND) &&
       (7 <= u16MajorVersion))
      u32DynamicSize += (poQuantifierOfBaseSignData?poQuantifierOfBaseSignData->u32GetSize(u16MajorVersion):0);
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < AdditionalSignList.size(); ++u32ListIdx)
      u32DynamicSize += AdditionalSignList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+8;
}

fi_tclInContext& cmb_fi_tcl_TrafficSignElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DynamicTrafficSign);
   (tVoid) (oIn >> VirtualTrafficSign);
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poBaseSignUnionData;
#else
   if (poBaseSignUnionData)
   {
      poBaseSignUnionData->vDestroy();
      OSAL_DELETE poBaseSignUnionData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   (tVoid) (oIn >> BaseSignUnionType);
   switch(BaseSignUnionType.enType)
   {
   case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED:
      poBaseSignUnionData = OSAL_NEW cmb_fi_tcl_Reserved;
      break;
   case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E8_SPEEDSIGN:
      poBaseSignUnionData = OSAL_NEW cmb_fi_tcl_e8_SpeedSign;
      break;
   case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_WARNINGSIGN:
      poBaseSignUnionData = OSAL_NEW cmb_fi_tcl_e16_WarningSign;
      break;
   case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN:
      poBaseSignUnionData = OSAL_NEW cmb_fi_tcl_e16_RegulatorySign;
      break;
   default:
      oIn.Invalidate();
      poBaseSignUnionData = OSAL_NULL;
   }
   if (poBaseSignUnionData && oIn.bIsValid())
      poBaseSignUnionData->oRead(oIn);
   else
      oIn.Invalidate();
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   OSAL_DELETE poQuantifierOfBaseSignData;
#else
   if (poQuantifierOfBaseSignData)
   {
      poQuantifierOfBaseSignData->vDestroy();
      OSAL_DELETE poQuantifierOfBaseSignData;
   }
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
   (tVoid) (oIn >> QuantifierOfBaseSignType);
   switch(QuantifierOfBaseSignType.enType)
   {
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
      poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_Reserved;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
      poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s16_KmPerHour;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
      poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s16_MilesPerHour;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
      poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tclString;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
      poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_u8_Percent;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
      poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_b8_LaneDependentValidity;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
      poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_TimeDependentString;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
      poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Meter;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
      poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Yards;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
      poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tclMultiLanguageString;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
      poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Centimeter;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
      poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Inch;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
      poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Kilogram;
      break;
   case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
      poQuantifierOfBaseSignData = OSAL_NEW cmb_fi_tcl_s32_Pound;
      break;
   default:
      oIn.Invalidate();
      poQuantifierOfBaseSignData = OSAL_NULL;
   }
   if (poQuantifierOfBaseSignData && oIn.bIsValid())
      poQuantifierOfBaseSignData->oRead(oIn);
   else
      oIn.Invalidate();
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AdditionalSignList.size(); ++u32Idx)
      {
         AdditionalSignList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AdditionalSignList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AdditionalSignList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_TrafficSignElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DynamicTrafficSign);
   (tVoid) (oOut << VirtualTrafficSign);
   (tVoid) (oOut << BaseSignUnionType);
   if (poBaseSignUnionData)
   {
      if (BaseSignUnionType.enType == cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED)
      {
         poBaseSignUnionData->oWrite(oOut);
      }
      if (BaseSignUnionType.enType == cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E8_SPEEDSIGN)
      {
         poBaseSignUnionData->oWrite(oOut);
      }
      if (BaseSignUnionType.enType == cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_WARNINGSIGN)
      {
         poBaseSignUnionData->oWrite(oOut);
      }
      if (BaseSignUnionType.enType == cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN)
      {
         if (!(7 <= oOut.u16GetMajorVersion()))
         {
            cmb_fi_tcl_Reserved oDefault;
            (tVoid) (oOut << oDefault);
         }
         else
         {
            poBaseSignUnionData->oWrite(oOut);
         }
      }
   }
   else
   {
      oOut.Invalidate();
   }
   (tVoid) (oOut << QuantifierOfBaseSignType);
   if (poQuantifierOfBaseSignData)
   {
      if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED)
      {
         poQuantifierOfBaseSignData->oWrite(oOut);
      }
      if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR)
      {
         poQuantifierOfBaseSignData->oWrite(oOut);
      }
      if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR)
      {
         poQuantifierOfBaseSignData->oWrite(oOut);
      }
      if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING)
      {
         poQuantifierOfBaseSignData->oWrite(oOut);
      }
      if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT)
      {
         poQuantifierOfBaseSignData->oWrite(oOut);
      }
      if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY)
      {
         poQuantifierOfBaseSignData->oWrite(oOut);
      }
      if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING)
      {
         poQuantifierOfBaseSignData->oWrite(oOut);
      }
      if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER)
      {
         poQuantifierOfBaseSignData->oWrite(oOut);
      }
      if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS)
      {
         poQuantifierOfBaseSignData->oWrite(oOut);
      }
      if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING)
      {
         poQuantifierOfBaseSignData->oWrite(oOut);
      }
      if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER)
      {
         if (!(7 <= oOut.u16GetMajorVersion()))
         {
            cmb_fi_tcl_Reserved oDefault;
            (tVoid) (oOut << oDefault);
         }
         else
         {
            poQuantifierOfBaseSignData->oWrite(oOut);
         }
      }
      if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH)
      {
         if (!(7 <= oOut.u16GetMajorVersion()))
         {
            cmb_fi_tcl_Reserved oDefault;
            (tVoid) (oOut << oDefault);
         }
         else
         {
            poQuantifierOfBaseSignData->oWrite(oOut);
         }
      }
      if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM)
      {
         if (!(7 <= oOut.u16GetMajorVersion()))
         {
            cmb_fi_tcl_Reserved oDefault;
            (tVoid) (oOut << oDefault);
         }
         else
         {
            poQuantifierOfBaseSignData->oWrite(oOut);
         }
      }
      if (QuantifierOfBaseSignType.enType == cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND)
      {
         if (!(7 <= oOut.u16GetMajorVersion()))
         {
            cmb_fi_tcl_Reserved oDefault;
            (tVoid) (oOut << oDefault);
         }
         else
         {
            poQuantifierOfBaseSignData->oWrite(oOut);
         }
      }
   }
   else
   {
      oOut.Invalidate();
   }
   (tVoid) (oOut << (tU32)AdditionalSignList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AdditionalSignList.size(); ++u32Idx)
         (tVoid) (oOut << AdditionalSignList[u32Idx]);
   }
   return oOut;
}

tBool cmb_fi_tcl_TrafficSignElement::operator==(const cmb_fi_tcl_TrafficSignElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DynamicTrafficSign == roRef.DynamicTrafficSign);
   bResult = bResult && (VirtualTrafficSign == roRef.VirtualTrafficSign);
   bResult = bResult && (BaseSignUnionType == roRef.BaseSignUnionType);
   if (bResult && poBaseSignUnionData && roRef.poBaseSignUnionData) 
   {
      switch (BaseSignUnionType.enType)
      {
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_RESERVED:
         bResult = bResult && (*(const cmb_fi_tcl_Reserved*)poBaseSignUnionData == *(const cmb_fi_tcl_Reserved*)roRef.poBaseSignUnionData); //lint !e826
      break;
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E8_SPEEDSIGN:
         bResult = bResult && (*(const cmb_fi_tcl_e8_SpeedSign*)poBaseSignUnionData == *(const cmb_fi_tcl_e8_SpeedSign*)roRef.poBaseSignUnionData); //lint !e826
      break;
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_WARNINGSIGN:
         bResult = bResult && (*(const cmb_fi_tcl_e16_WarningSign*)poBaseSignUnionData == *(const cmb_fi_tcl_e16_WarningSign*)roRef.poBaseSignUnionData); //lint !e826
      break;
      case cmb_fi_tcl_e8_BaseTrafficSignCategory::FI_EN_T_E16_REGULATORYSIGN:
         bResult = bResult && (*(const cmb_fi_tcl_e16_RegulatorySign*)poBaseSignUnionData == *(const cmb_fi_tcl_e16_RegulatorySign*)roRef.poBaseSignUnionData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poBaseSignUnionData == roRef.poBaseSignUnionData);
   }
   bResult = bResult && (QuantifierOfBaseSignType == roRef.QuantifierOfBaseSignType);
   if (bResult && poQuantifierOfBaseSignData && roRef.poQuantifierOfBaseSignData) 
   {
      switch (QuantifierOfBaseSignType.enType)
      {
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_RESERVED:
         bResult = bResult && (*(const cmb_fi_tcl_Reserved*)poQuantifierOfBaseSignData == *(const cmb_fi_tcl_Reserved*)roRef.poQuantifierOfBaseSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_KMPERHOUR:
         bResult = bResult && (*(const cmb_fi_tcl_s16_KmPerHour*)poQuantifierOfBaseSignData == *(const cmb_fi_tcl_s16_KmPerHour*)roRef.poQuantifierOfBaseSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S16_MILESPERHOUR:
         bResult = bResult && (*(const cmb_fi_tcl_s16_MilesPerHour*)poQuantifierOfBaseSignData == *(const cmb_fi_tcl_s16_MilesPerHour*)roRef.poQuantifierOfBaseSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TSTRING:
         bResult = bResult && (*(const cmb_fi_tclString*)poQuantifierOfBaseSignData == *(const cmb_fi_tclString*)roRef.poQuantifierOfBaseSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_U8_PERCENT:
         bResult = bResult && (*(const cmb_fi_tcl_u8_Percent*)poQuantifierOfBaseSignData == *(const cmb_fi_tcl_u8_Percent*)roRef.poQuantifierOfBaseSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_B8_LANEDEPENDENTVALIDITY:
         bResult = bResult && (*(const cmb_fi_tcl_b8_LaneDependentValidity*)poQuantifierOfBaseSignData == *(const cmb_fi_tcl_b8_LaneDependentValidity*)roRef.poQuantifierOfBaseSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_TIMEDEPENDENTSTRING:
         bResult = bResult && (*(const cmb_fi_tcl_TimeDependentString*)poQuantifierOfBaseSignData == *(const cmb_fi_tcl_TimeDependentString*)roRef.poQuantifierOfBaseSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_METER:
         bResult = bResult && (*(const cmb_fi_tcl_s32_Meter*)poQuantifierOfBaseSignData == *(const cmb_fi_tcl_s32_Meter*)roRef.poQuantifierOfBaseSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_YARDS:
         bResult = bResult && (*(const cmb_fi_tcl_s32_Yards*)poQuantifierOfBaseSignData == *(const cmb_fi_tcl_s32_Yards*)roRef.poQuantifierOfBaseSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_TMULTILANGUAGESTRING:
         bResult = bResult && (*(const cmb_fi_tclMultiLanguageString*)poQuantifierOfBaseSignData == *(const cmb_fi_tclMultiLanguageString*)roRef.poQuantifierOfBaseSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_CENTIMETER:
         bResult = bResult && (*(const cmb_fi_tcl_s32_Centimeter*)poQuantifierOfBaseSignData == *(const cmb_fi_tcl_s32_Centimeter*)roRef.poQuantifierOfBaseSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_INCH:
         bResult = bResult && (*(const cmb_fi_tcl_s32_Inch*)poQuantifierOfBaseSignData == *(const cmb_fi_tcl_s32_Inch*)roRef.poQuantifierOfBaseSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_KILOGRAM:
         bResult = bResult && (*(const cmb_fi_tcl_s32_Kilogram*)poQuantifierOfBaseSignData == *(const cmb_fi_tcl_s32_Kilogram*)roRef.poQuantifierOfBaseSignData); //lint !e826
      break;
      case cmb_fi_tcl_e8_TrafficSignQuantifier::FI_EN_T_S32_POUND:
         bResult = bResult && (*(const cmb_fi_tcl_s32_Pound*)poQuantifierOfBaseSignData == *(const cmb_fi_tcl_s32_Pound*)roRef.poQuantifierOfBaseSignData); //lint !e826
      break;
      }
   }
   else
   {
      bResult = bResult && (poQuantifierOfBaseSignData == roRef.poQuantifierOfBaseSignData);
   }
      bResult = bResult && (AdditionalSignList.size() == roRef.AdditionalSignList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AdditionalSignList.size()); ++u32Idx)
            bResult = bResult && (AdditionalSignList[u32Idx] == roRef.AdditionalSignList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VeSe_WheelSlip::cmb_fi_tcl_VeSe_WheelSlip(const cmb_fi_tcl_VeSe_WheelSlip& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Axle = coRef.Axle;
   PosOnAxle = coRef.PosOnAxle;
   Slip = coRef.Slip;
}
cmb_fi_tcl_VeSe_WheelSlip& cmb_fi_tcl_VeSe_WheelSlip::operator=(const cmb_fi_tcl_VeSe_WheelSlip& coRef)
{
   if (this == &coRef) return *this;
   Axle = coRef.Axle;
   PosOnAxle = coRef.PosOnAxle;
   Slip = coRef.Slip;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_VeSe_WheelSlip::cmb_fi_tcl_VeSe_WheelSlip()
:Axle(0)
,PosOnAxle(0)
,Slip()
 {}

tS32 cmb_fi_tcl_VeSe_WheelSlip::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VESE_WHEELSLIP;
}


cmb_fi_tcl_VeSe_WheelSlip::~cmb_fi_tcl_VeSe_WheelSlip()
{}

tU32 cmb_fi_tcl_VeSe_WheelSlip::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_VeSe_WheelSlip::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Axle);
   (tVoid) (oIn >> PosOnAxle);
   (tVoid) (oIn >> Slip);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VeSe_WheelSlip::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Axle);
   (tVoid) (oOut << PosOnAxle);
   (tVoid) (oOut << Slip);
   return oOut;
}

tBool cmb_fi_tcl_VeSe_WheelSlip::operator==(const cmb_fi_tcl_VeSe_WheelSlip& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Axle == roRef.Axle);
   bResult = bResult && (PosOnAxle == roRef.PosOnAxle);
   bResult = bResult && (Slip == roRef.Slip);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VeSe_WheelBrakePressure::cmb_fi_tcl_VeSe_WheelBrakePressure(const cmb_fi_tcl_VeSe_WheelBrakePressure& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Axle = coRef.Axle;
   PosOnAxle = coRef.PosOnAxle;
   BrakePressure = coRef.BrakePressure;
}
cmb_fi_tcl_VeSe_WheelBrakePressure& cmb_fi_tcl_VeSe_WheelBrakePressure::operator=(const cmb_fi_tcl_VeSe_WheelBrakePressure& coRef)
{
   if (this == &coRef) return *this;
   Axle = coRef.Axle;
   PosOnAxle = coRef.PosOnAxle;
   BrakePressure = coRef.BrakePressure;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_VeSe_WheelBrakePressure::cmb_fi_tcl_VeSe_WheelBrakePressure()
:Axle(0)
,PosOnAxle(0)
,BrakePressure()
 {}

tS32 cmb_fi_tcl_VeSe_WheelBrakePressure::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VESE_WHEELBRAKEPRESSURE;
}


cmb_fi_tcl_VeSe_WheelBrakePressure::~cmb_fi_tcl_VeSe_WheelBrakePressure()
{}

tU32 cmb_fi_tcl_VeSe_WheelBrakePressure::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& cmb_fi_tcl_VeSe_WheelBrakePressure::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Axle);
   (tVoid) (oIn >> PosOnAxle);
   (tVoid) (oIn >> BrakePressure);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VeSe_WheelBrakePressure::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Axle);
   (tVoid) (oOut << PosOnAxle);
   (tVoid) (oOut << BrakePressure);
   return oOut;
}

tBool cmb_fi_tcl_VeSe_WheelBrakePressure::operator==(const cmb_fi_tcl_VeSe_WheelBrakePressure& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Axle == roRef.Axle);
   bResult = bResult && (PosOnAxle == roRef.PosOnAxle);
   bResult = bResult && (BrakePressure == roRef.BrakePressure);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VeSe_WheelAirPressure::cmb_fi_tcl_VeSe_WheelAirPressure(const cmb_fi_tcl_VeSe_WheelAirPressure& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Axle = coRef.Axle;
   PosOnAxle = coRef.PosOnAxle;
   AirPressure = coRef.AirPressure;
}
cmb_fi_tcl_VeSe_WheelAirPressure& cmb_fi_tcl_VeSe_WheelAirPressure::operator=(const cmb_fi_tcl_VeSe_WheelAirPressure& coRef)
{
   if (this == &coRef) return *this;
   Axle = coRef.Axle;
   PosOnAxle = coRef.PosOnAxle;
   AirPressure = coRef.AirPressure;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_VeSe_WheelAirPressure::cmb_fi_tcl_VeSe_WheelAirPressure()
:Axle(0)
,PosOnAxle(0)
,AirPressure()
 {}

tS32 cmb_fi_tcl_VeSe_WheelAirPressure::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VESE_WHEELAIRPRESSURE;
}


cmb_fi_tcl_VeSe_WheelAirPressure::~cmb_fi_tcl_VeSe_WheelAirPressure()
{}

tU32 cmb_fi_tcl_VeSe_WheelAirPressure::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& cmb_fi_tcl_VeSe_WheelAirPressure::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Axle);
   (tVoid) (oIn >> PosOnAxle);
   (tVoid) (oIn >> AirPressure);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VeSe_WheelAirPressure::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Axle);
   (tVoid) (oOut << PosOnAxle);
   (tVoid) (oOut << AirPressure);
   return oOut;
}

tBool cmb_fi_tcl_VeSe_WheelAirPressure::operator==(const cmb_fi_tcl_VeSe_WheelAirPressure& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Axle == roRef.Axle);
   bResult = bResult && (PosOnAxle == roRef.PosOnAxle);
   bResult = bResult && (AirPressure == roRef.AirPressure);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_Activation::cmb_fi_tcl_e8_VeSe_Activation():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_Activation::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_ACTIVATION;
}


cmb_fi_tcl_e8_VeSe_Activation::~cmb_fi_tcl_e8_VeSe_Activation()
{}

tU32 cmb_fi_tcl_e8_VeSe_Activation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_Activation::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_Activation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_DoorType::cmb_fi_tcl_e8_VeSe_DoorType():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_DoorType::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_DOORTYPE;
}


cmb_fi_tcl_e8_VeSe_DoorType::~cmb_fi_tcl_e8_VeSe_DoorType()
{}

tU32 cmb_fi_tcl_e8_VeSe_DoorType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_DoorType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_DoorType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_WindowType::cmb_fi_tcl_e8_VeSe_WindowType():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_WindowType::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_WINDOWTYPE;
}


cmb_fi_tcl_e8_VeSe_WindowType::~cmb_fi_tcl_e8_VeSe_WindowType()
{}

tU32 cmb_fi_tcl_e8_VeSe_WindowType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_WindowType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_WindowType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_LineColor::cmb_fi_tcl_e8_VeSe_LineColor():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_LineColor::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_LINECOLOR;
}


cmb_fi_tcl_e8_VeSe_LineColor::~cmb_fi_tcl_e8_VeSe_LineColor()
{}

tU32 cmb_fi_tcl_e8_VeSe_LineColor::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_LineColor::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_LineColor::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VeSe_DoorStatus::cmb_fi_tcl_VeSe_DoorStatus(const cmb_fi_tcl_VeSe_DoorStatus& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   XPosition = coRef.XPosition;
   YPosition = coRef.YPosition;
   Closed = coRef.Closed;
   DoorType = coRef.DoorType;
}
cmb_fi_tcl_VeSe_DoorStatus& cmb_fi_tcl_VeSe_DoorStatus::operator=(const cmb_fi_tcl_VeSe_DoorStatus& coRef)
{
   if (this == &coRef) return *this;
   XPosition = coRef.XPosition;
   YPosition = coRef.YPosition;
   Closed = coRef.Closed;
   DoorType = coRef.DoorType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_VeSe_DoorStatus::cmb_fi_tcl_VeSe_DoorStatus()
:XPosition(0)
,YPosition(0)
,Closed()
,DoorType()
 {}

tS32 cmb_fi_tcl_VeSe_DoorStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VESE_DOORSTATUS;
}


cmb_fi_tcl_VeSe_DoorStatus::~cmb_fi_tcl_VeSe_DoorStatus()
{}

tU32 cmb_fi_tcl_VeSe_DoorStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_VeSe_DoorStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> XPosition);
   (tVoid) (oIn >> YPosition);
   (tVoid) (oIn >> Closed);
   (tVoid) (oIn >> DoorType);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VeSe_DoorStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << XPosition);
   (tVoid) (oOut << YPosition);
   (tVoid) (oOut << Closed);
   (tVoid) (oOut << DoorType);
   return oOut;
}

tBool cmb_fi_tcl_VeSe_DoorStatus::operator==(const cmb_fi_tcl_VeSe_DoorStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (XPosition == roRef.XPosition);
   bResult = bResult && (YPosition == roRef.YPosition);
   bResult = bResult && (Closed == roRef.Closed);
   bResult = bResult && (DoorType == roRef.DoorType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VeSe_WindowStatus::cmb_fi_tcl_VeSe_WindowStatus(const cmb_fi_tcl_VeSe_WindowStatus& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   XPosition = coRef.XPosition;
   YPosition = coRef.YPosition;
   OpeningLevel = coRef.OpeningLevel;
   WindowType = coRef.WindowType;
}
cmb_fi_tcl_VeSe_WindowStatus& cmb_fi_tcl_VeSe_WindowStatus::operator=(const cmb_fi_tcl_VeSe_WindowStatus& coRef)
{
   if (this == &coRef) return *this;
   XPosition = coRef.XPosition;
   YPosition = coRef.YPosition;
   OpeningLevel = coRef.OpeningLevel;
   WindowType = coRef.WindowType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_VeSe_WindowStatus::cmb_fi_tcl_VeSe_WindowStatus()
:XPosition(0)
,YPosition(0)
,OpeningLevel()
,WindowType()
 {}

tS32 cmb_fi_tcl_VeSe_WindowStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VESE_WINDOWSTATUS;
}


cmb_fi_tcl_VeSe_WindowStatus::~cmb_fi_tcl_VeSe_WindowStatus()
{}

tU32 cmb_fi_tcl_VeSe_WindowStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_VeSe_WindowStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> XPosition);
   (tVoid) (oIn >> YPosition);
   (tVoid) (oIn >> OpeningLevel);
   (tVoid) (oIn >> WindowType);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VeSe_WindowStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << XPosition);
   (tVoid) (oOut << YPosition);
   (tVoid) (oOut << OpeningLevel);
   (tVoid) (oOut << WindowType);
   return oOut;
}

tBool cmb_fi_tcl_VeSe_WindowStatus::operator==(const cmb_fi_tcl_VeSe_WindowStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (XPosition == roRef.XPosition);
   bResult = bResult && (YPosition == roRef.YPosition);
   bResult = bResult && (OpeningLevel == roRef.OpeningLevel);
   bResult = bResult && (WindowType == roRef.WindowType);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_SeatOccupation::cmb_fi_tcl_e8_VeSe_SeatOccupation():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_SeatOccupation::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_SEATOCCUPATION;
}


cmb_fi_tcl_e8_VeSe_SeatOccupation::~cmb_fi_tcl_e8_VeSe_SeatOccupation()
{}

tU32 cmb_fi_tcl_e8_VeSe_SeatOccupation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_SeatOccupation::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_SeatOccupation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_DirectionIndicator::cmb_fi_tcl_e8_VeSe_DirectionIndicator():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_DirectionIndicator::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_DIRECTIONINDICATOR;
}


cmb_fi_tcl_e8_VeSe_DirectionIndicator::~cmb_fi_tcl_e8_VeSe_DirectionIndicator()
{}

tU32 cmb_fi_tcl_e8_VeSe_DirectionIndicator::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_DirectionIndicator::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_DirectionIndicator::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_GearNum::cmb_fi_tcl_e8_VeSe_GearNum():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_GearNum::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_GEARNUM;
}


cmb_fi_tcl_e8_VeSe_GearNum::~cmb_fi_tcl_e8_VeSe_GearNum()
{}

tU32 cmb_fi_tcl_e8_VeSe_GearNum::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_GearNum::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_GearNum::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b8_VeSe_GearBoxState::cmb_fi_tcl_b8_VeSe_GearBoxState():u8Value(0)
{}

tS32 cmb_fi_tcl_b8_VeSe_GearBoxState::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B8_VESE_GEARBOXSTATE;
}


cmb_fi_tcl_b8_VeSe_GearBoxState::~cmb_fi_tcl_b8_VeSe_GearBoxState()
{}

tU32 cmb_fi_tcl_b8_VeSe_GearBoxState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_b8_VeSe_GearBoxState::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& cmb_fi_tcl_b8_VeSe_GearBoxState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_CCType::cmb_fi_tcl_e8_VeSe_CCType():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_CCType::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_CCTYPE;
}


cmb_fi_tcl_e8_VeSe_CCType::~cmb_fi_tcl_e8_VeSe_CCType()
{}

tU32 cmb_fi_tcl_e8_VeSe_CCType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_CCType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_CCType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_CCState::cmb_fi_tcl_e8_VeSe_CCState():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_CCState::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_CCSTATE;
}


cmb_fi_tcl_e8_VeSe_CCState::~cmb_fi_tcl_e8_VeSe_CCState()
{}

tU32 cmb_fi_tcl_e8_VeSe_CCState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_CCState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_CCState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_Ignition::cmb_fi_tcl_e8_VeSe_Ignition():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_Ignition::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_IGNITION;
}


cmb_fi_tcl_e8_VeSe_Ignition::~cmb_fi_tcl_e8_VeSe_Ignition()
{}

tU32 cmb_fi_tcl_e8_VeSe_Ignition::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_Ignition::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_Ignition::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b32_VeSe_BrakeControlMode::cmb_fi_tcl_b32_VeSe_BrakeControlMode():u32Value(0)
{}

tS32 cmb_fi_tcl_b32_VeSe_BrakeControlMode::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B32_VESE_BRAKECONTROLMODE;
}


cmb_fi_tcl_b32_VeSe_BrakeControlMode::~cmb_fi_tcl_b32_VeSe_BrakeControlMode()
{}

tU32 cmb_fi_tcl_b32_VeSe_BrakeControlMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_b32_VeSe_BrakeControlMode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& cmb_fi_tcl_b32_VeSe_BrakeControlMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b16_VeSe_CentralLocking::cmb_fi_tcl_b16_VeSe_CentralLocking():u16Value(0)
{}

tS32 cmb_fi_tcl_b16_VeSe_CentralLocking::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B16_VESE_CENTRALLOCKING;
}


cmb_fi_tcl_b16_VeSe_CentralLocking::~cmb_fi_tcl_b16_VeSe_CentralLocking()
{}

tU32 cmb_fi_tcl_b16_VeSe_CentralLocking::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_b16_VeSe_CentralLocking::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cmb_fi_tcl_b16_VeSe_CentralLocking::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_RotationIrregularity::cmb_fi_tcl_e8_VeSe_RotationIrregularity():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_RotationIrregularity::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_ROTATIONIRREGULARITY;
}


cmb_fi_tcl_e8_VeSe_RotationIrregularity::~cmb_fi_tcl_e8_VeSe_RotationIrregularity()
{}

tU32 cmb_fi_tcl_e8_VeSe_RotationIrregularity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_RotationIrregularity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_RotationIrregularity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_OverrunFuelShutoff::cmb_fi_tcl_e8_VeSe_OverrunFuelShutoff():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_OverrunFuelShutoff::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_OVERRUNFUELSHUTOFF;
}


cmb_fi_tcl_e8_VeSe_OverrunFuelShutoff::~cmb_fi_tcl_e8_VeSe_OverrunFuelShutoff()
{}

tU32 cmb_fi_tcl_e8_VeSe_OverrunFuelShutoff::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_OverrunFuelShutoff::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_OverrunFuelShutoff::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_ConverterClutch::cmb_fi_tcl_e8_VeSe_ConverterClutch():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_ConverterClutch::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_CONVERTERCLUTCH;
}


cmb_fi_tcl_e8_VeSe_ConverterClutch::~cmb_fi_tcl_e8_VeSe_ConverterClutch()
{}

tU32 cmb_fi_tcl_e8_VeSe_ConverterClutch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_ConverterClutch::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_ConverterClutch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_GearboxSportSwitch::cmb_fi_tcl_e8_VeSe_GearboxSportSwitch():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_GearboxSportSwitch::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_GEARBOXSPORTSWITCH;
}


cmb_fi_tcl_e8_VeSe_GearboxSportSwitch::~cmb_fi_tcl_e8_VeSe_GearboxSportSwitch()
{}

tU32 cmb_fi_tcl_e8_VeSe_GearboxSportSwitch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_GearboxSportSwitch::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_GearboxSportSwitch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_HeadLights::cmb_fi_tcl_e8_VeSe_HeadLights():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_HeadLights::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_HEADLIGHTS;
}


cmb_fi_tcl_e8_VeSe_HeadLights::~cmb_fi_tcl_e8_VeSe_HeadLights()
{}

tU32 cmb_fi_tcl_e8_VeSe_HeadLights::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_HeadLights::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_HeadLights::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VeSe_SeatStatus::cmb_fi_tcl_VeSe_SeatStatus(const cmb_fi_tcl_VeSe_SeatStatus& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Row = coRef.Row;
   PlaceInRow = coRef.PlaceInRow;
   Occupation = coRef.Occupation;
   SeatBeltLock = coRef.SeatBeltLock;
   SeatClimate = coRef.SeatClimate;
   RealTemperature = coRef.RealTemperature;
   SeatHeater = coRef.SeatHeater;
   NeckHeater = coRef.NeckHeater;
   StratSeatHeater = coRef.StratSeatHeater;
}
cmb_fi_tcl_VeSe_SeatStatus& cmb_fi_tcl_VeSe_SeatStatus::operator=(const cmb_fi_tcl_VeSe_SeatStatus& coRef)
{
   if (this == &coRef) return *this;
   Row = coRef.Row;
   PlaceInRow = coRef.PlaceInRow;
   Occupation = coRef.Occupation;
   SeatBeltLock = coRef.SeatBeltLock;
   SeatClimate = coRef.SeatClimate;
   RealTemperature = coRef.RealTemperature;
   SeatHeater = coRef.SeatHeater;
   NeckHeater = coRef.NeckHeater;
   StratSeatHeater = coRef.StratSeatHeater;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_VeSe_SeatStatus::cmb_fi_tcl_VeSe_SeatStatus()
:Row(0)
,PlaceInRow(0)
,Occupation()
,SeatBeltLock()
,SeatClimate()
,RealTemperature()
,SeatHeater()
,NeckHeater()
,StratSeatHeater()
 {}

tS32 cmb_fi_tcl_VeSe_SeatStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VESE_SEATSTATUS;
}


cmb_fi_tcl_VeSe_SeatStatus::~cmb_fi_tcl_VeSe_SeatStatus()
{}

tU32 cmb_fi_tcl_VeSe_SeatStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 11;
}

fi_tclInContext& cmb_fi_tcl_VeSe_SeatStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Row);
   (tVoid) (oIn >> PlaceInRow);
   (tVoid) (oIn >> Occupation);
   (tVoid) (oIn >> SeatBeltLock);
   (tVoid) (oIn >> SeatClimate);
   (tVoid) (oIn >> RealTemperature);
   (tVoid) (oIn >> SeatHeater);
   (tVoid) (oIn >> NeckHeater);
   (tVoid) (oIn >> StratSeatHeater);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VeSe_SeatStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Row);
   (tVoid) (oOut << PlaceInRow);
   (tVoid) (oOut << Occupation);
   (tVoid) (oOut << SeatBeltLock);
   (tVoid) (oOut << SeatClimate);
   (tVoid) (oOut << RealTemperature);
   (tVoid) (oOut << SeatHeater);
   (tVoid) (oOut << NeckHeater);
   (tVoid) (oOut << StratSeatHeater);
   return oOut;
}

tBool cmb_fi_tcl_VeSe_SeatStatus::operator==(const cmb_fi_tcl_VeSe_SeatStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Row == roRef.Row);
   bResult = bResult && (PlaceInRow == roRef.PlaceInRow);
   bResult = bResult && (Occupation == roRef.Occupation);
   bResult = bResult && (SeatBeltLock == roRef.SeatBeltLock);
   bResult = bResult && (SeatClimate == roRef.SeatClimate);
   bResult = bResult && (RealTemperature == roRef.RealTemperature);
   bResult = bResult && (SeatHeater == roRef.SeatHeater);
   bResult = bResult && (NeckHeater == roRef.NeckHeater);
   bResult = bResult && (StratSeatHeater == roRef.StratSeatHeater);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_VehicleDrivingCondition::cmb_fi_tcl_e8_VeSe_VehicleDrivingCondition():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_VehicleDrivingCondition::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_VEHICLEDRIVINGCONDITION;
}


cmb_fi_tcl_e8_VeSe_VehicleDrivingCondition::~cmb_fi_tcl_e8_VeSe_VehicleDrivingCondition()
{}

tU32 cmb_fi_tcl_e8_VeSe_VehicleDrivingCondition::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_VehicleDrivingCondition::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_VehicleDrivingCondition::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_KeyValidity::cmb_fi_tcl_e8_VeSe_KeyValidity():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_KeyValidity::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_KEYVALIDITY;
}


cmb_fi_tcl_e8_VeSe_KeyValidity::~cmb_fi_tcl_e8_VeSe_KeyValidity()
{}

tU32 cmb_fi_tcl_e8_VeSe_KeyValidity::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_KeyValidity::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_KeyValidity::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_KeyType::cmb_fi_tcl_e8_VeSe_KeyType():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_KeyType::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_KEYTYPE;
}


cmb_fi_tcl_e8_VeSe_KeyType::~cmb_fi_tcl_e8_VeSe_KeyType()
{}

tU32 cmb_fi_tcl_e8_VeSe_KeyType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_KeyType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_KeyType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b16_VeSe_KeyLocation::cmb_fi_tcl_b16_VeSe_KeyLocation():u16Value(0)
{}

tS32 cmb_fi_tcl_b16_VeSe_KeyLocation::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B16_VESE_KEYLOCATION;
}


cmb_fi_tcl_b16_VeSe_KeyLocation::~cmb_fi_tcl_b16_VeSe_KeyLocation()
{}

tU32 cmb_fi_tcl_b16_VeSe_KeyLocation::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_b16_VeSe_KeyLocation::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cmb_fi_tcl_b16_VeSe_KeyLocation::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b16_VeSe_EngineStatus::cmb_fi_tcl_b16_VeSe_EngineStatus():u16Value(0)
{}

tS32 cmb_fi_tcl_b16_VeSe_EngineStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B16_VESE_ENGINESTATUS;
}


cmb_fi_tcl_b16_VeSe_EngineStatus::~cmb_fi_tcl_b16_VeSe_EngineStatus()
{}

tU32 cmb_fi_tcl_b16_VeSe_EngineStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_b16_VeSe_EngineStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cmb_fi_tcl_b16_VeSe_EngineStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_ReductionRPM::cmb_fi_tcl_e8_VeSe_ReductionRPM():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_ReductionRPM::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_REDUCTIONRPM;
}


cmb_fi_tcl_e8_VeSe_ReductionRPM::~cmb_fi_tcl_e8_VeSe_ReductionRPM()
{}

tU32 cmb_fi_tcl_e8_VeSe_ReductionRPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_ReductionRPM::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_ReductionRPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b16_VeSe_ActiveSeats::cmb_fi_tcl_b16_VeSe_ActiveSeats():u16Value(0)
{}

tS32 cmb_fi_tcl_b16_VeSe_ActiveSeats::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B16_VESE_ACTIVESEATS;
}


cmb_fi_tcl_b16_VeSe_ActiveSeats::~cmb_fi_tcl_b16_VeSe_ActiveSeats()
{}

tU32 cmb_fi_tcl_b16_VeSe_ActiveSeats::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_b16_VeSe_ActiveSeats::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cmb_fi_tcl_b16_VeSe_ActiveSeats::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_SideIndicator::cmb_fi_tcl_e8_VeSe_SideIndicator():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_SideIndicator::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_SIDEINDICATOR;
}


cmb_fi_tcl_e8_VeSe_SideIndicator::~cmb_fi_tcl_e8_VeSe_SideIndicator()
{}

tU32 cmb_fi_tcl_e8_VeSe_SideIndicator::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_SideIndicator::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_SideIndicator::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VeSe_LineInfo::cmb_fi_tcl_VeSe_LineInfo(const cmb_fi_tcl_VeSe_LineInfo& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   LineID = coRef.LineID;
   Probability = coRef.Probability;
   Linecolor = coRef.Linecolor;
   LateralDistance = coRef.LateralDistance;
   AngleToBegin = coRef.AngleToBegin;
   HorCurvature = coRef.HorCurvature;
   HorCurvatureChange = coRef.HorCurvatureChange;
}
cmb_fi_tcl_VeSe_LineInfo& cmb_fi_tcl_VeSe_LineInfo::operator=(const cmb_fi_tcl_VeSe_LineInfo& coRef)
{
   if (this == &coRef) return *this;
   LineID = coRef.LineID;
   Probability = coRef.Probability;
   Linecolor = coRef.Linecolor;
   LateralDistance = coRef.LateralDistance;
   AngleToBegin = coRef.AngleToBegin;
   HorCurvature = coRef.HorCurvature;
   HorCurvatureChange = coRef.HorCurvatureChange;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_VeSe_LineInfo::cmb_fi_tcl_VeSe_LineInfo()
:LineID(0)
,Probability()
,Linecolor()
,LateralDistance()
,AngleToBegin()
,HorCurvature()
,HorCurvatureChange()
 {}

tS32 cmb_fi_tcl_VeSe_LineInfo::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VESE_LINEINFO;
}


cmb_fi_tcl_VeSe_LineInfo::~cmb_fi_tcl_VeSe_LineInfo()
{}

tU32 cmb_fi_tcl_VeSe_LineInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& cmb_fi_tcl_VeSe_LineInfo::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LineID);
   (tVoid) (oIn >> Probability);
   (tVoid) (oIn >> Linecolor);
   (tVoid) (oIn >> LateralDistance);
   (tVoid) (oIn >> AngleToBegin);
   (tVoid) (oIn >> HorCurvature);
   (tVoid) (oIn >> HorCurvatureChange);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VeSe_LineInfo::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LineID);
   (tVoid) (oOut << Probability);
   (tVoid) (oOut << Linecolor);
   (tVoid) (oOut << LateralDistance);
   (tVoid) (oOut << AngleToBegin);
   (tVoid) (oOut << HorCurvature);
   (tVoid) (oOut << HorCurvatureChange);
   return oOut;
}

tBool cmb_fi_tcl_VeSe_LineInfo::operator==(const cmb_fi_tcl_VeSe_LineInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LineID == roRef.LineID);
   bResult = bResult && (Probability == roRef.Probability);
   bResult = bResult && (Linecolor == roRef.Linecolor);
   bResult = bResult && (LateralDistance == roRef.LateralDistance);
   bResult = bResult && (AngleToBegin == roRef.AngleToBegin);
   bResult = bResult && (HorCurvature == roRef.HorCurvature);
   bResult = bResult && (HorCurvatureChange == roRef.HorCurvatureChange);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_ObjectType::cmb_fi_tcl_e8_VeSe_ObjectType():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_ObjectType::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_OBJECTTYPE;
}


cmb_fi_tcl_e8_VeSe_ObjectType::~cmb_fi_tcl_e8_VeSe_ObjectType()
{}

tU32 cmb_fi_tcl_e8_VeSe_ObjectType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_ObjectType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_ObjectType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s16_VeSe_Torque::cmb_fi_tcl_s16_VeSe_Torque(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 cmb_fi_tcl_s16_VeSe_Torque::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S16_VESE_TORQUE;
}


cmb_fi_tcl_s16_VeSe_Torque::~cmb_fi_tcl_s16_VeSe_Torque()
{}

tU32 cmb_fi_tcl_s16_VeSe_Torque::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_s16_VeSe_Torque::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& cmb_fi_tcl_s16_VeSe_Torque::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VeSe_DetectedObject::cmb_fi_tcl_VeSe_DetectedObject(const cmb_fi_tcl_VeSe_DetectedObject& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   ObjectID = coRef.ObjectID;
   ObjectType = coRef.ObjectType;
   ObjectMeasured = coRef.ObjectMeasured;
   ExistProbability = coRef.ExistProbability;
   LongitudinalDistance = coRef.LongitudinalDistance;
   LateralOffset = coRef.LateralOffset;
   ObjectWidth = coRef.ObjectWidth;
   DeviationLongitudinalDistance = coRef.DeviationLongitudinalDistance;
   DeviationLateralOffset = coRef.DeviationLateralOffset;
   DeviationWidth = coRef.DeviationWidth;
}
cmb_fi_tcl_VeSe_DetectedObject& cmb_fi_tcl_VeSe_DetectedObject::operator=(const cmb_fi_tcl_VeSe_DetectedObject& coRef)
{
   if (this == &coRef) return *this;
   ObjectID = coRef.ObjectID;
   ObjectType = coRef.ObjectType;
   ObjectMeasured = coRef.ObjectMeasured;
   ExistProbability = coRef.ExistProbability;
   LongitudinalDistance = coRef.LongitudinalDistance;
   LateralOffset = coRef.LateralOffset;
   ObjectWidth = coRef.ObjectWidth;
   DeviationLongitudinalDistance = coRef.DeviationLongitudinalDistance;
   DeviationLateralOffset = coRef.DeviationLateralOffset;
   DeviationWidth = coRef.DeviationWidth;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_VeSe_DetectedObject::cmb_fi_tcl_VeSe_DetectedObject()
:ObjectID(0)
,ObjectType()
,ObjectMeasured()
,ExistProbability()
,LongitudinalDistance()
,LateralOffset()
,ObjectWidth()
,DeviationLongitudinalDistance()
,DeviationLateralOffset()
,DeviationWidth()
 {}

tS32 cmb_fi_tcl_VeSe_DetectedObject::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VESE_DETECTEDOBJECT;
}


cmb_fi_tcl_VeSe_DetectedObject::~cmb_fi_tcl_VeSe_DetectedObject()
{}

tU32 cmb_fi_tcl_VeSe_DetectedObject::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 29;
}

fi_tclInContext& cmb_fi_tcl_VeSe_DetectedObject::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ObjectID);
   (tVoid) (oIn >> ObjectType);
   (tVoid) (oIn >> ObjectMeasured);
   (tVoid) (oIn >> ExistProbability);
   (tVoid) (oIn >> LongitudinalDistance);
   (tVoid) (oIn >> LateralOffset);
   (tVoid) (oIn >> ObjectWidth);
   (tVoid) (oIn >> DeviationLongitudinalDistance);
   (tVoid) (oIn >> DeviationLateralOffset);
   (tVoid) (oIn >> DeviationWidth);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VeSe_DetectedObject::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ObjectID);
   (tVoid) (oOut << ObjectType);
   (tVoid) (oOut << ObjectMeasured);
   (tVoid) (oOut << ExistProbability);
   (tVoid) (oOut << LongitudinalDistance);
   (tVoid) (oOut << LateralOffset);
   (tVoid) (oOut << ObjectWidth);
   (tVoid) (oOut << DeviationLongitudinalDistance);
   (tVoid) (oOut << DeviationLateralOffset);
   (tVoid) (oOut << DeviationWidth);
   return oOut;
}

tBool cmb_fi_tcl_VeSe_DetectedObject::operator==(const cmb_fi_tcl_VeSe_DetectedObject& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ObjectID == roRef.ObjectID);
   bResult = bResult && (ObjectType == roRef.ObjectType);
   bResult = bResult && (ObjectMeasured == roRef.ObjectMeasured);
   bResult = bResult && (ExistProbability == roRef.ExistProbability);
   bResult = bResult && (LongitudinalDistance == roRef.LongitudinalDistance);
   bResult = bResult && (LateralOffset == roRef.LateralOffset);
   bResult = bResult && (ObjectWidth == roRef.ObjectWidth);
   bResult = bResult && (DeviationLongitudinalDistance == roRef.DeviationLongitudinalDistance);
   bResult = bResult && (DeviationLateralOffset == roRef.DeviationLateralOffset);
   bResult = bResult && (DeviationWidth == roRef.DeviationWidth);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VeSe_TSClassificationQuality::cmb_fi_tcl_VeSe_TSClassificationQuality(const cmb_fi_tcl_VeSe_TSClassificationQuality& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   TSQuality = coRef.TSQuality;
   TSQuantifierQuality = coRef.TSQuantifierQuality;
}
cmb_fi_tcl_VeSe_TSClassificationQuality& cmb_fi_tcl_VeSe_TSClassificationQuality::operator=(const cmb_fi_tcl_VeSe_TSClassificationQuality& coRef)
{
   if (this == &coRef) return *this;
   TSQuality = coRef.TSQuality;
   TSQuantifierQuality = coRef.TSQuantifierQuality;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_VeSe_TSClassificationQuality::cmb_fi_tcl_VeSe_TSClassificationQuality()
:TSQuality()
,TSQuantifierQuality()
 {}

tS32 cmb_fi_tcl_VeSe_TSClassificationQuality::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VESE_TSCLASSIFICATIONQUALITY;
}


cmb_fi_tcl_VeSe_TSClassificationQuality::~cmb_fi_tcl_VeSe_TSClassificationQuality()
{}

tU32 cmb_fi_tcl_VeSe_TSClassificationQuality::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_VeSe_TSClassificationQuality::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TSQuality);
   (tVoid) (oIn >> TSQuantifierQuality);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VeSe_TSClassificationQuality::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TSQuality);
   (tVoid) (oOut << TSQuantifierQuality);
   return oOut;
}

tBool cmb_fi_tcl_VeSe_TSClassificationQuality::operator==(const cmb_fi_tcl_VeSe_TSClassificationQuality& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TSQuality == roRef.TSQuality);
   bResult = bResult && (TSQuantifierQuality == roRef.TSQuantifierQuality);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VeSe_TSQuality::cmb_fi_tcl_VeSe_TSQuality(const cmb_fi_tcl_VeSe_TSQuality& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   TSQuality = coRef.TSQuality;
   AdditionalTSQualityList = coRef.AdditionalTSQualityList;
}
cmb_fi_tcl_VeSe_TSQuality& cmb_fi_tcl_VeSe_TSQuality::operator=(const cmb_fi_tcl_VeSe_TSQuality& coRef)
{
   if (this == &coRef) return *this;
   TSQuality = coRef.TSQuality;
   AdditionalTSQualityList = coRef.AdditionalTSQualityList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_VeSe_TSQuality::vDestroy()
{
   TSQuality.vDestroy(); 
   {
      for (tU32 u32Idx = 0; u32Idx < AdditionalTSQualityList.size(); ++u32Idx)
         AdditionalTSQualityList[u32Idx].vDestroy();
   AdditionalTSQualityList.clear();
   }
}

cmb_fi_tcl_VeSe_TSQuality::cmb_fi_tcl_VeSe_TSQuality()
:TSQuality()

 {}

tS32 cmb_fi_tcl_VeSe_TSQuality::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VESE_TSQUALITY;
}


cmb_fi_tcl_VeSe_TSQuality::~cmb_fi_tcl_VeSe_TSQuality()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_VeSe_TSQuality::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+ static_cast<tU32>(AdditionalTSQualityList.size()*2);
}

fi_tclInContext& cmb_fi_tcl_VeSe_TSQuality::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TSQuality);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < AdditionalTSQualityList.size(); ++u32Idx)
      {
         AdditionalTSQualityList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      AdditionalTSQualityList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> AdditionalTSQualityList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VeSe_TSQuality::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TSQuality);
   (tVoid) (oOut << (tU32)AdditionalTSQualityList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < AdditionalTSQualityList.size(); ++u32Idx)
         (tVoid) (oOut << AdditionalTSQualityList[u32Idx]);
   }
   return oOut;
}

tBool cmb_fi_tcl_VeSe_TSQuality::operator==(const cmb_fi_tcl_VeSe_TSQuality& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TSQuality == roRef.TSQuality);
      bResult = bResult && (AdditionalTSQualityList.size() == roRef.AdditionalTSQualityList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < AdditionalTSQualityList.size()); ++u32Idx)
            bResult = bResult && (AdditionalTSQualityList[u32Idx] == roRef.AdditionalTSQualityList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VeSe_DetectedTrafficSign::cmb_fi_tcl_VeSe_DetectedTrafficSign(const cmb_fi_tcl_VeSe_DetectedTrafficSign& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   TrafficSignID = coRef.TrafficSignID;
   IDOfTrafficSignAbove = coRef.IDOfTrafficSignAbove;
   TrafficSign = coRef.TrafficSign;
   TSLongitudinalDistance = coRef.TSLongitudinalDistance;
   TSLateralOffset = coRef.TSLateralOffset;
   TSHeight = coRef.TSHeight;
   TSQuality = coRef.TSQuality;
}
cmb_fi_tcl_VeSe_DetectedTrafficSign& cmb_fi_tcl_VeSe_DetectedTrafficSign::operator=(const cmb_fi_tcl_VeSe_DetectedTrafficSign& coRef)
{
   if (this == &coRef) return *this;
   TrafficSignID = coRef.TrafficSignID;
   IDOfTrafficSignAbove = coRef.IDOfTrafficSignAbove;
   TrafficSign = coRef.TrafficSign;
   TSLongitudinalDistance = coRef.TSLongitudinalDistance;
   TSLateralOffset = coRef.TSLateralOffset;
   TSHeight = coRef.TSHeight;
   TSQuality = coRef.TSQuality;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_VeSe_DetectedTrafficSign::vDestroy()
{
   TrafficSign.vDestroy(); 
   TSQuality.vDestroy(); 
}

cmb_fi_tcl_VeSe_DetectedTrafficSign::cmb_fi_tcl_VeSe_DetectedTrafficSign()
:TrafficSignID(0)
,IDOfTrafficSignAbove(0)
,TrafficSign()
,TSLongitudinalDistance()
,TSLateralOffset()
,TSHeight()
,TSQuality()
 {}

tS32 cmb_fi_tcl_VeSe_DetectedTrafficSign::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VESE_DETECTEDTRAFFICSIGN;
}


cmb_fi_tcl_VeSe_DetectedTrafficSign::~cmb_fi_tcl_VeSe_DetectedTrafficSign()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_VeSe_DetectedTrafficSign::u32GetSize(tU16 u16MajorVersion) const
{
   return 14+TrafficSign.u32GetSize(u16MajorVersion)+TSQuality.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cmb_fi_tcl_VeSe_DetectedTrafficSign::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TrafficSignID);
   (tVoid) (oIn >> IDOfTrafficSignAbove);
   (tVoid) (oIn >> TrafficSign);
   (tVoid) (oIn >> TSLongitudinalDistance);
   (tVoid) (oIn >> TSLateralOffset);
   (tVoid) (oIn >> TSHeight);
   (tVoid) (oIn >> TSQuality);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VeSe_DetectedTrafficSign::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TrafficSignID);
   (tVoid) (oOut << IDOfTrafficSignAbove);
   (tVoid) (oOut << TrafficSign);
   (tVoid) (oOut << TSLongitudinalDistance);
   (tVoid) (oOut << TSLateralOffset);
   (tVoid) (oOut << TSHeight);
   (tVoid) (oOut << TSQuality);
   return oOut;
}

tBool cmb_fi_tcl_VeSe_DetectedTrafficSign::operator==(const cmb_fi_tcl_VeSe_DetectedTrafficSign& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TrafficSignID == roRef.TrafficSignID);
   bResult = bResult && (IDOfTrafficSignAbove == roRef.IDOfTrafficSignAbove);
   bResult = bResult && (TrafficSign == roRef.TrafficSign);
   bResult = bResult && (TSLongitudinalDistance == roRef.TSLongitudinalDistance);
   bResult = bResult && (TSLateralOffset == roRef.TSLateralOffset);
   bResult = bResult && (TSHeight == roRef.TSHeight);
   bResult = bResult && (TSQuality == roRef.TSQuality);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s32_Ws::cmb_fi_tcl_s32_Ws(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cmb_fi_tcl_s32_Ws::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S32_WS;
}


cmb_fi_tcl_s32_Ws::~cmb_fi_tcl_s32_Ws()
{}

tU32 cmb_fi_tcl_s32_Ws::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_s32_Ws::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cmb_fi_tcl_s32_Ws::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_u32_Ws::cmb_fi_tcl_u32_Ws(tU32 _u32Value)
: u32Value(_u32Value
) {} 

tS32 cmb_fi_tcl_u32_Ws::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_U32_WS;
}


cmb_fi_tcl_u32_Ws::~cmb_fi_tcl_u32_Ws()
{}

tU32 cmb_fi_tcl_u32_Ws::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_u32_Ws::oRead(fi_tclInContext& oIn)
{
   return oIn >> u32Value;
}

fi_tclOutContext& cmb_fi_tcl_u32_Ws::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_u16_W::cmb_fi_tcl_u16_W(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 cmb_fi_tcl_u16_W::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_U16_W;
}


cmb_fi_tcl_u16_W::~cmb_fi_tcl_u16_W()
{}

tU32 cmb_fi_tcl_u16_W::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_u16_W::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cmb_fi_tcl_u16_W::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s32_MilliVolt::cmb_fi_tcl_s32_MilliVolt(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cmb_fi_tcl_s32_MilliVolt::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S32_MILLIVOLT;
}


cmb_fi_tcl_s32_MilliVolt::~cmb_fi_tcl_s32_MilliVolt()
{}

tU32 cmb_fi_tcl_s32_MilliVolt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_s32_MilliVolt::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cmb_fi_tcl_s32_MilliVolt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_s32_MilliAmpere::cmb_fi_tcl_s32_MilliAmpere(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 cmb_fi_tcl_s32_MilliAmpere::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_S32_MILLIAMPERE;
}


cmb_fi_tcl_s32_MilliAmpere::~cmb_fi_tcl_s32_MilliAmpere()
{}

tU32 cmb_fi_tcl_s32_MilliAmpere::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_s32_MilliAmpere::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& cmb_fi_tcl_s32_MilliAmpere::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_u16_min::cmb_fi_tcl_u16_min(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 cmb_fi_tcl_u16_min::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_U16_MIN;
}


cmb_fi_tcl_u16_min::~cmb_fi_tcl_u16_min()
{}

tU32 cmb_fi_tcl_u16_min::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_u16_min::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cmb_fi_tcl_u16_min::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_EOperationMode::cmb_fi_tcl_e8_EOperationMode():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_EOperationMode::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_EOPERATIONMODE;
}


cmb_fi_tcl_e8_EOperationMode::~cmb_fi_tcl_e8_EOperationMode()
{}

tU32 cmb_fi_tcl_e8_EOperationMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_EOperationMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_EOperationMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b8_CouplingMode::cmb_fi_tcl_b8_CouplingMode():u8Value(0)
{}

tS32 cmb_fi_tcl_b8_CouplingMode::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B8_COUPLINGMODE;
}


cmb_fi_tcl_b8_CouplingMode::~cmb_fi_tcl_b8_CouplingMode()
{}

tU32 cmb_fi_tcl_b8_CouplingMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_b8_CouplingMode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& cmb_fi_tcl_b8_CouplingMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_EnergyConsumption::cmb_fi_tcl_EnergyConsumption(const cmb_fi_tcl_EnergyConsumption& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   PowerDemand = coRef.PowerDemand;
   Duration = coRef.Duration;
}
cmb_fi_tcl_EnergyConsumption& cmb_fi_tcl_EnergyConsumption::operator=(const cmb_fi_tcl_EnergyConsumption& coRef)
{
   if (this == &coRef) return *this;
   PowerDemand = coRef.PowerDemand;
   Duration = coRef.Duration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_EnergyConsumption::cmb_fi_tcl_EnergyConsumption()
:PowerDemand()
,Duration()
 {}

tS32 cmb_fi_tcl_EnergyConsumption::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_ENERGYCONSUMPTION;
}


cmb_fi_tcl_EnergyConsumption::~cmb_fi_tcl_EnergyConsumption()
{}

tU32 cmb_fi_tcl_EnergyConsumption::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_EnergyConsumption::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PowerDemand);
   (tVoid) (oIn >> Duration);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_EnergyConsumption::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PowerDemand);
   (tVoid) (oOut << Duration);
   return oOut;
}

tBool cmb_fi_tcl_EnergyConsumption::operator==(const cmb_fi_tcl_EnergyConsumption& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PowerDemand == roRef.PowerDemand);
   bResult = bResult && (Duration == roRef.Duration);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_PowerDemandAtSpeed::cmb_fi_tcl_PowerDemandAtSpeed(const cmb_fi_tcl_PowerDemandAtSpeed& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   ValidVehicleSpeed = coRef.ValidVehicleSpeed;
   PowerDemand = coRef.PowerDemand;
}
cmb_fi_tcl_PowerDemandAtSpeed& cmb_fi_tcl_PowerDemandAtSpeed::operator=(const cmb_fi_tcl_PowerDemandAtSpeed& coRef)
{
   if (this == &coRef) return *this;
   ValidVehicleSpeed = coRef.ValidVehicleSpeed;
   PowerDemand = coRef.PowerDemand;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_PowerDemandAtSpeed::cmb_fi_tcl_PowerDemandAtSpeed()
:ValidVehicleSpeed()
,PowerDemand()
 {}

tS32 cmb_fi_tcl_PowerDemandAtSpeed::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_POWERDEMANDATSPEED;
}


cmb_fi_tcl_PowerDemandAtSpeed::~cmb_fi_tcl_PowerDemandAtSpeed()
{}

tU32 cmb_fi_tcl_PowerDemandAtSpeed::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_PowerDemandAtSpeed::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ValidVehicleSpeed);
   (tVoid) (oIn >> PowerDemand);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_PowerDemandAtSpeed::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ValidVehicleSpeed);
   (tVoid) (oOut << PowerDemand);
   return oOut;
}

tBool cmb_fi_tcl_PowerDemandAtSpeed::operator==(const cmb_fi_tcl_PowerDemandAtSpeed& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ValidVehicleSpeed == roRef.ValidVehicleSpeed);
   bResult = bResult && (PowerDemand == roRef.PowerDemand);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_ElectricalMachine::cmb_fi_tcl_ElectricalMachine(const cmb_fi_tcl_ElectricalMachine& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Timestamp = coRef.Timestamp;
   EnergyConsumption = coRef.EnergyConsumption;
   TotalEnergyConsumption = coRef.TotalEnergyConsumption;
   EngineSpeed = coRef.EngineSpeed;
   EngineTorque = coRef.EngineTorque;
   MaxAllowedEngineTorqueNext2Sec = coRef.MaxAllowedEngineTorqueNext2Sec;
   MinAllowedEngineTorqueNext2Sec = coRef.MinAllowedEngineTorqueNext2Sec;
   MaxAllowedEngineTorqueNext10Sec = coRef.MaxAllowedEngineTorqueNext10Sec;
   MinAllowedEngineTorqueNext10Sec = coRef.MinAllowedEngineTorqueNext10Sec;
   OperationMode = coRef.OperationMode;
   CouplingMode = coRef.CouplingMode;
}
cmb_fi_tcl_ElectricalMachine& cmb_fi_tcl_ElectricalMachine::operator=(const cmb_fi_tcl_ElectricalMachine& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   EnergyConsumption = coRef.EnergyConsumption;
   TotalEnergyConsumption = coRef.TotalEnergyConsumption;
   EngineSpeed = coRef.EngineSpeed;
   EngineTorque = coRef.EngineTorque;
   MaxAllowedEngineTorqueNext2Sec = coRef.MaxAllowedEngineTorqueNext2Sec;
   MinAllowedEngineTorqueNext2Sec = coRef.MinAllowedEngineTorqueNext2Sec;
   MaxAllowedEngineTorqueNext10Sec = coRef.MaxAllowedEngineTorqueNext10Sec;
   MinAllowedEngineTorqueNext10Sec = coRef.MinAllowedEngineTorqueNext10Sec;
   OperationMode = coRef.OperationMode;
   CouplingMode = coRef.CouplingMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_ElectricalMachine::cmb_fi_tcl_ElectricalMachine()
:Timestamp(0)
,EnergyConsumption()
,TotalEnergyConsumption()
,EngineSpeed()
,EngineTorque()
,MaxAllowedEngineTorqueNext2Sec()
,MinAllowedEngineTorqueNext2Sec()
,MaxAllowedEngineTorqueNext10Sec()
,MinAllowedEngineTorqueNext10Sec()
,OperationMode()
,CouplingMode()
 {}

tS32 cmb_fi_tcl_ElectricalMachine::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_ELECTRICALMACHINE;
}


cmb_fi_tcl_ElectricalMachine::~cmb_fi_tcl_ElectricalMachine()
{}

tU32 cmb_fi_tcl_ElectricalMachine::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   if (9 <= u16MajorVersion)
   {
      u32DynamicSize += 2;
   }
   return u32DynamicSize+18;
}

fi_tclInContext& cmb_fi_tcl_ElectricalMachine::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> EnergyConsumption);
   (tVoid) (oIn >> TotalEnergyConsumption);
   (tVoid) (oIn >> EngineSpeed);
   (tVoid) (oIn >> EngineTorque);
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> MaxAllowedEngineTorqueNext2Sec);
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> MinAllowedEngineTorqueNext2Sec);
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> MaxAllowedEngineTorqueNext10Sec);
   }
   if (9 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> MinAllowedEngineTorqueNext10Sec);
   }
   (tVoid) (oIn >> OperationMode);
   (tVoid) (oIn >> CouplingMode);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_ElectricalMachine::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << EnergyConsumption);
   (tVoid) (oOut << TotalEnergyConsumption);
   (tVoid) (oOut << EngineSpeed);
   (tVoid) (oOut << EngineTorque);
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << MaxAllowedEngineTorqueNext2Sec);
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << MinAllowedEngineTorqueNext2Sec);
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << MaxAllowedEngineTorqueNext10Sec);
   }
   if (9 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << MinAllowedEngineTorqueNext10Sec);
   }
   (tVoid) (oOut << OperationMode);
   (tVoid) (oOut << CouplingMode);
   return oOut;
}

tBool cmb_fi_tcl_ElectricalMachine::operator==(const cmb_fi_tcl_ElectricalMachine& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (EnergyConsumption == roRef.EnergyConsumption);
   bResult = bResult && (TotalEnergyConsumption == roRef.TotalEnergyConsumption);
   bResult = bResult && (EngineSpeed == roRef.EngineSpeed);
   bResult = bResult && (EngineTorque == roRef.EngineTorque);
   bResult = bResult && (MaxAllowedEngineTorqueNext2Sec == roRef.MaxAllowedEngineTorqueNext2Sec);
   bResult = bResult && (MinAllowedEngineTorqueNext2Sec == roRef.MinAllowedEngineTorqueNext2Sec);
   bResult = bResult && (MaxAllowedEngineTorqueNext10Sec == roRef.MaxAllowedEngineTorqueNext10Sec);
   bResult = bResult && (MinAllowedEngineTorqueNext10Sec == roRef.MinAllowedEngineTorqueNext10Sec);
   bResult = bResult && (OperationMode == roRef.OperationMode);
   bResult = bResult && (CouplingMode == roRef.CouplingMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_VeSe_K0Status::cmb_fi_tcl_e8_VeSe_K0Status():enType(FI_EN_UNKNOWN) {}

tS32 cmb_fi_tcl_e8_VeSe_K0Status::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_VESE_K0STATUS;
}


cmb_fi_tcl_e8_VeSe_K0Status::~cmb_fi_tcl_e8_VeSe_K0Status()
{}

tU32 cmb_fi_tcl_e8_VeSe_K0Status::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_VeSe_K0Status::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_VeSe_K0Status::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VeSe_VoltageParams::cmb_fi_tcl_VeSe_VoltageParams(const cmb_fi_tcl_VeSe_VoltageParams& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   CurrentVoltage = coRef.CurrentVoltage;
   MinAllowedChargingVoltageFor10Sec = coRef.MinAllowedChargingVoltageFor10Sec;
   MinAllowedDischargingVoltageFor10Sec = coRef.MinAllowedDischargingVoltageFor10Sec;
}
cmb_fi_tcl_VeSe_VoltageParams& cmb_fi_tcl_VeSe_VoltageParams::operator=(const cmb_fi_tcl_VeSe_VoltageParams& coRef)
{
   if (this == &coRef) return *this;
   CurrentVoltage = coRef.CurrentVoltage;
   MinAllowedChargingVoltageFor10Sec = coRef.MinAllowedChargingVoltageFor10Sec;
   MinAllowedDischargingVoltageFor10Sec = coRef.MinAllowedDischargingVoltageFor10Sec;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_VeSe_VoltageParams::cmb_fi_tcl_VeSe_VoltageParams()
:CurrentVoltage()
,MinAllowedChargingVoltageFor10Sec()
,MinAllowedDischargingVoltageFor10Sec()
 {}

tS32 cmb_fi_tcl_VeSe_VoltageParams::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VESE_VOLTAGEPARAMS;
}


cmb_fi_tcl_VeSe_VoltageParams::~cmb_fi_tcl_VeSe_VoltageParams()
{}

tU32 cmb_fi_tcl_VeSe_VoltageParams::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& cmb_fi_tcl_VeSe_VoltageParams::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CurrentVoltage);
   (tVoid) (oIn >> MinAllowedChargingVoltageFor10Sec);
   (tVoid) (oIn >> MinAllowedDischargingVoltageFor10Sec);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VeSe_VoltageParams::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CurrentVoltage);
   (tVoid) (oOut << MinAllowedChargingVoltageFor10Sec);
   (tVoid) (oOut << MinAllowedDischargingVoltageFor10Sec);
   return oOut;
}

tBool cmb_fi_tcl_VeSe_VoltageParams::operator==(const cmb_fi_tcl_VeSe_VoltageParams& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CurrentVoltage == roRef.CurrentVoltage);
   bResult = bResult && (MinAllowedChargingVoltageFor10Sec == roRef.MinAllowedChargingVoltageFor10Sec);
   bResult = bResult && (MinAllowedDischargingVoltageFor10Sec == roRef.MinAllowedDischargingVoltageFor10Sec);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VeSe_CurrentParams::cmb_fi_tcl_VeSe_CurrentParams(const cmb_fi_tcl_VeSe_CurrentParams& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   CurrentCurrent = coRef.CurrentCurrent;
   MaxAllowedChargingCurrentFor10Sec = coRef.MaxAllowedChargingCurrentFor10Sec;
   MaxAllowedDischargingCurrentFor10Sec = coRef.MaxAllowedDischargingCurrentFor10Sec;
}
cmb_fi_tcl_VeSe_CurrentParams& cmb_fi_tcl_VeSe_CurrentParams::operator=(const cmb_fi_tcl_VeSe_CurrentParams& coRef)
{
   if (this == &coRef) return *this;
   CurrentCurrent = coRef.CurrentCurrent;
   MaxAllowedChargingCurrentFor10Sec = coRef.MaxAllowedChargingCurrentFor10Sec;
   MaxAllowedDischargingCurrentFor10Sec = coRef.MaxAllowedDischargingCurrentFor10Sec;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_VeSe_CurrentParams::cmb_fi_tcl_VeSe_CurrentParams()
:CurrentCurrent()
,MaxAllowedChargingCurrentFor10Sec()
,MaxAllowedDischargingCurrentFor10Sec()
 {}

tS32 cmb_fi_tcl_VeSe_CurrentParams::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VESE_CURRENTPARAMS;
}


cmb_fi_tcl_VeSe_CurrentParams::~cmb_fi_tcl_VeSe_CurrentParams()
{}

tU32 cmb_fi_tcl_VeSe_CurrentParams::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& cmb_fi_tcl_VeSe_CurrentParams::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CurrentCurrent);
   (tVoid) (oIn >> MaxAllowedChargingCurrentFor10Sec);
   (tVoid) (oIn >> MaxAllowedDischargingCurrentFor10Sec);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VeSe_CurrentParams::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CurrentCurrent);
   (tVoid) (oOut << MaxAllowedChargingCurrentFor10Sec);
   (tVoid) (oOut << MaxAllowedDischargingCurrentFor10Sec);
   return oOut;
}

tBool cmb_fi_tcl_VeSe_CurrentParams::operator==(const cmb_fi_tcl_VeSe_CurrentParams& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CurrentCurrent == roRef.CurrentCurrent);
   bResult = bResult && (MaxAllowedChargingCurrentFor10Sec == roRef.MaxAllowedChargingCurrentFor10Sec);
   bResult = bResult && (MaxAllowedDischargingCurrentFor10Sec == roRef.MaxAllowedDischargingCurrentFor10Sec);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b16_VeSe_Environment::cmb_fi_tcl_b16_VeSe_Environment():u16Value(0)
{}

tS32 cmb_fi_tcl_b16_VeSe_Environment::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B16_VESE_ENVIRONMENT;
}


cmb_fi_tcl_b16_VeSe_Environment::~cmb_fi_tcl_b16_VeSe_Environment()
{}

tU32 cmb_fi_tcl_b16_VeSe_Environment::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_b16_VeSe_Environment::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cmb_fi_tcl_b16_VeSe_Environment::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_VeSe_IPPCPlusData::cmb_fi_tcl_VeSe_IPPCPlusData(const cmb_fi_tcl_VeSe_IPPCPlusData& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Timestamp = coRef.Timestamp;
   Slope = coRef.Slope;
   SlopeConfidence = coRef.SlopeConfidence;
   DrivenCurvature = coRef.DrivenCurvature;
   DrivenCurvatureConfidence = coRef.DrivenCurvatureConfidence;
   VehicleSpeed = coRef.VehicleSpeed;
   Environment = coRef.Environment;
}
cmb_fi_tcl_VeSe_IPPCPlusData& cmb_fi_tcl_VeSe_IPPCPlusData::operator=(const cmb_fi_tcl_VeSe_IPPCPlusData& coRef)
{
   if (this == &coRef) return *this;
   Timestamp = coRef.Timestamp;
   Slope = coRef.Slope;
   SlopeConfidence = coRef.SlopeConfidence;
   DrivenCurvature = coRef.DrivenCurvature;
   DrivenCurvatureConfidence = coRef.DrivenCurvatureConfidence;
   VehicleSpeed = coRef.VehicleSpeed;
   Environment = coRef.Environment;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_VeSe_IPPCPlusData::cmb_fi_tcl_VeSe_IPPCPlusData()
:Timestamp(0)
,Slope()
,SlopeConfidence()
,DrivenCurvature()
,DrivenCurvatureConfidence()
,VehicleSpeed()
,Environment()
 {}

tS32 cmb_fi_tcl_VeSe_IPPCPlusData::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_VESE_IPPCPLUSDATA;
}


cmb_fi_tcl_VeSe_IPPCPlusData::~cmb_fi_tcl_VeSe_IPPCPlusData()
{}

tU32 cmb_fi_tcl_VeSe_IPPCPlusData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& cmb_fi_tcl_VeSe_IPPCPlusData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Timestamp);
   (tVoid) (oIn >> Slope);
   (tVoid) (oIn >> SlopeConfidence);
   (tVoid) (oIn >> DrivenCurvature);
   (tVoid) (oIn >> DrivenCurvatureConfidence);
   (tVoid) (oIn >> VehicleSpeed);
   (tVoid) (oIn >> Environment);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_VeSe_IPPCPlusData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Timestamp);
   (tVoid) (oOut << Slope);
   (tVoid) (oOut << SlopeConfidence);
   (tVoid) (oOut << DrivenCurvature);
   (tVoid) (oOut << DrivenCurvatureConfidence);
   (tVoid) (oOut << VehicleSpeed);
   (tVoid) (oOut << Environment);
   return oOut;
}

tBool cmb_fi_tcl_VeSe_IPPCPlusData::operator==(const cmb_fi_tcl_VeSe_IPPCPlusData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Timestamp == roRef.Timestamp);
   bResult = bResult && (Slope == roRef.Slope);
   bResult = bResult && (SlopeConfidence == roRef.SlopeConfidence);
   bResult = bResult && (DrivenCurvature == roRef.DrivenCurvature);
   bResult = bResult && (DrivenCurvatureConfidence == roRef.DrivenCurvatureConfidence);
   bResult = bResult && (VehicleSpeed == roRef.VehicleSpeed);
   bResult = bResult && (Environment == roRef.Environment);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_u8_SD_PackageID::cmb_fi_tcl_u8_SD_PackageID(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 cmb_fi_tcl_u8_SD_PackageID::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_U8_SD_PACKAGEID;
}


cmb_fi_tcl_u8_SD_PackageID::~cmb_fi_tcl_u8_SD_PackageID()
{}

tU32 cmb_fi_tcl_u8_SD_PackageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_u8_SD_PackageID::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& cmb_fi_tcl_u8_SD_PackageID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_SD_Package::cmb_fi_tcl_SD_Package(const cmb_fi_tcl_SD_Package& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   PackageID = coRef.PackageID;
   SD_Package = coRef.SD_Package;
   SD_Path = coRef.SD_Path;
}
cmb_fi_tcl_SD_Package& cmb_fi_tcl_SD_Package::operator=(const cmb_fi_tcl_SD_Package& coRef)
{
   if (this == &coRef) return *this;
   PackageID = coRef.PackageID;
   SD_Package = coRef.SD_Package;
   SD_Path = coRef.SD_Path;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_SD_Package::vDestroy()
{
   SD_Package.vDestroy();
   SD_Path.vDestroy();
}

cmb_fi_tcl_SD_Package::cmb_fi_tcl_SD_Package()
:PackageID()
,SD_Package()
,SD_Path()
 {}

tS32 cmb_fi_tcl_SD_Package::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_SD_PACKAGE;
}


cmb_fi_tcl_SD_Package::~cmb_fi_tcl_SD_Package()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_SD_Package::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+SD_Package.u32GetSize(u16MajorVersion)+SD_Path.u32GetSize(u16MajorVersion);
}

fi_tclInContext& cmb_fi_tcl_SD_Package::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PackageID);
   (tVoid) (oIn >> SD_Package);
   (tVoid) (oIn >> SD_Path);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_SD_Package::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PackageID);
   (tVoid) (oOut << SD_Package);
   (tVoid) (oOut << SD_Path);
   return oOut;
}

tBool cmb_fi_tcl_SD_Package::operator==(const cmb_fi_tcl_SD_Package& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PackageID == roRef.PackageID);
   bResult = bResult && (SD_Package == roRef.SD_Package);
   bResult = bResult && (SD_Path == roRef.SD_Path);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_DownloadStatus::cmb_fi_tcl_e8_DownloadStatus():enType(FI_EN_NOTAVAILABLE) {}

tS32 cmb_fi_tcl_e8_DownloadStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_DOWNLOADSTATUS;
}


cmb_fi_tcl_e8_DownloadStatus::~cmb_fi_tcl_e8_DownloadStatus()
{}

tU32 cmb_fi_tcl_e8_DownloadStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_DownloadStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_DownloadStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_SD_PackageLoadStatus::cmb_fi_tcl_SD_PackageLoadStatus(const cmb_fi_tcl_SD_PackageLoadStatus& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   PackageID = coRef.PackageID;
   DownloadStatus = coRef.DownloadStatus;
}
cmb_fi_tcl_SD_PackageLoadStatus& cmb_fi_tcl_SD_PackageLoadStatus::operator=(const cmb_fi_tcl_SD_PackageLoadStatus& coRef)
{
   if (this == &coRef) return *this;
   PackageID = coRef.PackageID;
   DownloadStatus = coRef.DownloadStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_SD_PackageLoadStatus::cmb_fi_tcl_SD_PackageLoadStatus()
:PackageID()
,DownloadStatus()
 {}

tS32 cmb_fi_tcl_SD_PackageLoadStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_SD_PACKAGELOADSTATUS;
}


cmb_fi_tcl_SD_PackageLoadStatus::~cmb_fi_tcl_SD_PackageLoadStatus()
{}

tU32 cmb_fi_tcl_SD_PackageLoadStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_SD_PackageLoadStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PackageID);
   (tVoid) (oIn >> DownloadStatus);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_SD_PackageLoadStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PackageID);
   (tVoid) (oOut << DownloadStatus);
   return oOut;
}

tBool cmb_fi_tcl_SD_PackageLoadStatus::operator==(const cmb_fi_tcl_SD_PackageLoadStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PackageID == roRef.PackageID);
   bResult = bResult && (DownloadStatus == roRef.DownloadStatus);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_SD_Damage::cmb_fi_tcl_e8_SD_Damage():enType(FI_EN_NODAMAGE) {}

tS32 cmb_fi_tcl_e8_SD_Damage::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_SD_DAMAGE;
}


cmb_fi_tcl_e8_SD_Damage::~cmb_fi_tcl_e8_SD_Damage()
{}

tU32 cmb_fi_tcl_e8_SD_Damage::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_SD_Damage::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_SD_Damage::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_SD_Format::cmb_fi_tcl_e8_SD_Format():enType(FI_EN_TYPE_OKI_ADPCM) {}

tS32 cmb_fi_tcl_e8_SD_Format::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_SD_FORMAT;
}


cmb_fi_tcl_e8_SD_Format::~cmb_fi_tcl_e8_SD_Format()
{}

tU32 cmb_fi_tcl_e8_SD_Format::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_SD_Format::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_SD_Format::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_SpeechCategory::cmb_fi_tcl_e8_SpeechCategory():enType(FI_EN_DRIVINGRECOMMENDATION) {}

tS32 cmb_fi_tcl_e8_SpeechCategory::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_SPEECHCATEGORY;
}


cmb_fi_tcl_e8_SpeechCategory::~cmb_fi_tcl_e8_SpeechCategory()
{}

tU32 cmb_fi_tcl_e8_SpeechCategory::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_SpeechCategory::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_SpeechCategory::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b16_CategoryAddInfo::cmb_fi_tcl_b16_CategoryAddInfo():u16Value(0)
{}

tS32 cmb_fi_tcl_b16_CategoryAddInfo::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B16_CATEGORYADDINFO;
}


cmb_fi_tcl_b16_CategoryAddInfo::~cmb_fi_tcl_b16_CategoryAddInfo()
{}

tU32 cmb_fi_tcl_b16_CategoryAddInfo::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_b16_CategoryAddInfo::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cmb_fi_tcl_b16_CategoryAddInfo::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_SpeechSequence::cmb_fi_tcl_e8_SpeechSequence():enType(FI_EN_IMMEDIATELY) {}

tS32 cmb_fi_tcl_e8_SpeechSequence::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_SPEECHSEQUENCE;
}


cmb_fi_tcl_e8_SpeechSequence::~cmb_fi_tcl_e8_SpeechSequence()
{}

tU32 cmb_fi_tcl_e8_SpeechSequence::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_SpeechSequence::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_SpeechSequence::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_SD_Phrase::cmb_fi_tcl_SD_Phrase(const cmb_fi_tcl_SD_Phrase& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   PackageID = coRef.PackageID;
   PhraseNumber = coRef.PhraseNumber;
}
cmb_fi_tcl_SD_Phrase& cmb_fi_tcl_SD_Phrase::operator=(const cmb_fi_tcl_SD_Phrase& coRef)
{
   if (this == &coRef) return *this;
   PackageID = coRef.PackageID;
   PhraseNumber = coRef.PhraseNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_SD_Phrase::cmb_fi_tcl_SD_Phrase()
:PackageID()
,PhraseNumber(0)
 {}

tS32 cmb_fi_tcl_SD_Phrase::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_SD_PHRASE;
}


cmb_fi_tcl_SD_Phrase::~cmb_fi_tcl_SD_Phrase()
{}

tU32 cmb_fi_tcl_SD_Phrase::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& cmb_fi_tcl_SD_Phrase::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> PackageID);
   (tVoid) (oIn >> PhraseNumber);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_SD_Phrase::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << PackageID);
   (tVoid) (oOut << PhraseNumber);
   return oOut;
}

tBool cmb_fi_tcl_SD_Phrase::operator==(const cmb_fi_tcl_SD_Phrase& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PackageID == roRef.PackageID);
   bResult = bResult && (PhraseNumber == roRef.PhraseNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_SD_Sentence::cmb_fi_tcl_SD_Sentence(const cmb_fi_tcl_SD_Sentence& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   SpeechSequence = coRef.SpeechSequence;
   Phrases = coRef.Phrases;
}
cmb_fi_tcl_SD_Sentence& cmb_fi_tcl_SD_Sentence::operator=(const cmb_fi_tcl_SD_Sentence& coRef)
{
   if (this == &coRef) return *this;
   SpeechSequence = coRef.SpeechSequence;
   Phrases = coRef.Phrases;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_SD_Sentence::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Phrases.size(); ++u32Idx)
         Phrases[u32Idx].vDestroy();
   Phrases.clear();
   }
}

cmb_fi_tcl_SD_Sentence::cmb_fi_tcl_SD_Sentence()
:SpeechSequence()

 {}

tS32 cmb_fi_tcl_SD_Sentence::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_SD_SENTENCE;
}


cmb_fi_tcl_SD_Sentence::~cmb_fi_tcl_SD_Sentence()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_SD_Sentence::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(Phrases.size()*3);
}

fi_tclInContext& cmb_fi_tcl_SD_Sentence::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpeechSequence);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Phrases.size(); ++u32Idx)
      {
         Phrases[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Phrases.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Phrases[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_SD_Sentence::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpeechSequence);
   (tVoid) (oOut << (tU32)Phrases.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Phrases.size(); ++u32Idx)
         (tVoid) (oOut << Phrases[u32Idx]);
   }
   return oOut;
}

tBool cmb_fi_tcl_SD_Sentence::operator==(const cmb_fi_tcl_SD_Sentence& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpeechSequence == roRef.SpeechSequence);
      bResult = bResult && (Phrases.size() == roRef.Phrases.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Phrases.size()); ++u32Idx)
            bResult = bResult && (Phrases[u32Idx] == roRef.Phrases[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_SD_SentenceAndParam::cmb_fi_tcl_SD_SentenceAndParam(const cmb_fi_tcl_SD_SentenceAndParam& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   Phrases = coRef.Phrases;
   SentenceText = coRef.SentenceText;
   Category = coRef.Category;
   Timeout = coRef.Timeout;
   RequestAddInfo = coRef.RequestAddInfo;
}
cmb_fi_tcl_SD_SentenceAndParam& cmb_fi_tcl_SD_SentenceAndParam::operator=(const cmb_fi_tcl_SD_SentenceAndParam& coRef)
{
   if (this == &coRef) return *this;
   Phrases = coRef.Phrases;
   SentenceText = coRef.SentenceText;
   Category = coRef.Category;
   Timeout = coRef.Timeout;
   RequestAddInfo = coRef.RequestAddInfo;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid cmb_fi_tcl_SD_SentenceAndParam::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < Phrases.size(); ++u32Idx)
         Phrases[u32Idx].vDestroy();
   Phrases.clear();
   }
   SentenceText.vDestroy();
}

cmb_fi_tcl_SD_SentenceAndParam::cmb_fi_tcl_SD_SentenceAndParam()

:SentenceText()
,Category()
,Timeout(0)
,RequestAddInfo()
 {}

tS32 cmb_fi_tcl_SD_SentenceAndParam::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_SD_SENTENCEANDPARAM;
}


cmb_fi_tcl_SD_SentenceAndParam::~cmb_fi_tcl_SD_SentenceAndParam()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 cmb_fi_tcl_SD_SentenceAndParam::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (5 <= u16MajorVersion)
   {
      u32DynamicSize += SentenceText.u32GetSize(u16MajorVersion);
   }
   return u32DynamicSize+11+ static_cast<tU32>(Phrases.size()*3);
}

fi_tclInContext& cmb_fi_tcl_SD_SentenceAndParam::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < Phrases.size(); ++u32Idx)
      {
         Phrases[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      Phrases.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Phrases[u32Idx]);
      }
   }
   if (5 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> SentenceText);
   }
   (tVoid) (oIn >> Category);
   (tVoid) (oIn >> Timeout);
   (tVoid) (oIn >> RequestAddInfo);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_SD_SentenceAndParam::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Phrases.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Phrases.size(); ++u32Idx)
         (tVoid) (oOut << Phrases[u32Idx]);
   }
   if (5 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << SentenceText);
   }
   (tVoid) (oOut << Category);
   (tVoid) (oOut << Timeout);
   (tVoid) (oOut << RequestAddInfo);
   return oOut;
}

tBool cmb_fi_tcl_SD_SentenceAndParam::operator==(const cmb_fi_tcl_SD_SentenceAndParam& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Phrases.size() == roRef.Phrases.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Phrases.size()); ++u32Idx)
            bResult = bResult && (Phrases[u32Idx] == roRef.Phrases[u32Idx]);
      }
   bResult = bResult && (SentenceText == roRef.SentenceText);
   bResult = bResult && (Category == roRef.Category);
   bResult = bResult && (Timeout == roRef.Timeout);
   bResult = bResult && (RequestAddInfo == roRef.RequestAddInfo);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_u16_SD_SampleFrequency::cmb_fi_tcl_u16_SD_SampleFrequency(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 cmb_fi_tcl_u16_SD_SampleFrequency::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_U16_SD_SAMPLEFREQUENCY;
}


cmb_fi_tcl_u16_SD_SampleFrequency::~cmb_fi_tcl_u16_SD_SampleFrequency()
{}

tU32 cmb_fi_tcl_u16_SD_SampleFrequency::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& cmb_fi_tcl_u16_SD_SampleFrequency::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& cmb_fi_tcl_u16_SD_SampleFrequency::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_SD_Settings::cmb_fi_tcl_SD_Settings(const cmb_fi_tcl_SD_Settings& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   SpeechDataFormat = coRef.SpeechDataFormat;
   SampleFrequency = coRef.SampleFrequency;
   Resolution = coRef.Resolution;
   Mono = coRef.Mono;
}
cmb_fi_tcl_SD_Settings& cmb_fi_tcl_SD_Settings::operator=(const cmb_fi_tcl_SD_Settings& coRef)
{
   if (this == &coRef) return *this;
   SpeechDataFormat = coRef.SpeechDataFormat;
   SampleFrequency = coRef.SampleFrequency;
   Resolution = coRef.Resolution;
   Mono = coRef.Mono;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_SD_Settings::cmb_fi_tcl_SD_Settings()
:SpeechDataFormat()
,SampleFrequency()
,Resolution(0)
,Mono(0)
 {}

tS32 cmb_fi_tcl_SD_Settings::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_SD_SETTINGS;
}


cmb_fi_tcl_SD_Settings::~cmb_fi_tcl_SD_Settings()
{}

tU32 cmb_fi_tcl_SD_Settings::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& cmb_fi_tcl_SD_Settings::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SpeechDataFormat);
   (tVoid) (oIn >> SampleFrequency);
   (tVoid) (oIn >> Resolution);
   (tVoid) (oIn >> Mono);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_SD_Settings::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SpeechDataFormat);
   (tVoid) (oOut << SampleFrequency);
   (tVoid) (oOut << Resolution);
   (tVoid) (oOut << Mono);
   return oOut;
}

tBool cmb_fi_tcl_SD_Settings::operator==(const cmb_fi_tcl_SD_Settings& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SpeechDataFormat == roRef.SpeechDataFormat);
   bResult = bResult && (SampleFrequency == roRef.SampleFrequency);
   bResult = bResult && (Resolution == roRef.Resolution);
   bResult = bResult && (Mono == roRef.Mono);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_u8_SD_Size::cmb_fi_tcl_u8_SD_Size(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 cmb_fi_tcl_u8_SD_Size::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_U8_SD_SIZE;
}


cmb_fi_tcl_u8_SD_Size::~cmb_fi_tcl_u8_SD_Size()
{}

tU32 cmb_fi_tcl_u8_SD_Size::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_u8_SD_Size::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& cmb_fi_tcl_u8_SD_Size::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_SD_Reference::cmb_fi_tcl_SD_Reference(const cmb_fi_tcl_SD_Reference& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   HeaderSize = coRef.HeaderSize;
   PhraseNoSize = coRef.PhraseNoSize;
   StartAddSize = coRef.StartAddSize;
   StopAddSize = coRef.StopAddSize;
}
cmb_fi_tcl_SD_Reference& cmb_fi_tcl_SD_Reference::operator=(const cmb_fi_tcl_SD_Reference& coRef)
{
   if (this == &coRef) return *this;
   HeaderSize = coRef.HeaderSize;
   PhraseNoSize = coRef.PhraseNoSize;
   StartAddSize = coRef.StartAddSize;
   StopAddSize = coRef.StopAddSize;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_SD_Reference::cmb_fi_tcl_SD_Reference()
:HeaderSize()
,PhraseNoSize()
,StartAddSize()
,StopAddSize()
 {}

tS32 cmb_fi_tcl_SD_Reference::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_SD_REFERENCE;
}


cmb_fi_tcl_SD_Reference::~cmb_fi_tcl_SD_Reference()
{}

tU32 cmb_fi_tcl_SD_Reference::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& cmb_fi_tcl_SD_Reference::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> HeaderSize);
   (tVoid) (oIn >> PhraseNoSize);
   (tVoid) (oIn >> StartAddSize);
   (tVoid) (oIn >> StopAddSize);
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_SD_Reference::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << HeaderSize);
   (tVoid) (oOut << PhraseNoSize);
   (tVoid) (oOut << StartAddSize);
   (tVoid) (oOut << StopAddSize);
   return oOut;
}

tBool cmb_fi_tcl_SD_Reference::operator==(const cmb_fi_tcl_SD_Reference& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (HeaderSize == roRef.HeaderSize);
   bResult = bResult && (PhraseNoSize == roRef.PhraseNoSize);
   bResult = bResult && (StartAddSize == roRef.StartAddSize);
   bResult = bResult && (StopAddSize == roRef.StopAddSize);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_e8_StopVOPriority::cmb_fi_tcl_e8_StopVOPriority():enType(FI_EN_AFTERCURRENTSENTENCE) {}

tS32 cmb_fi_tcl_e8_StopVOPriority::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_E8_STOPVOPRIORITY;
}


cmb_fi_tcl_e8_StopVOPriority::~cmb_fi_tcl_e8_StopVOPriority()
{}

tU32 cmb_fi_tcl_e8_StopVOPriority::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_e8_StopVOPriority::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_e8_StopVOPriority::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_b8_PhraseStatus::cmb_fi_tcl_b8_PhraseStatus():u8Value(0)
{}

tS32 cmb_fi_tcl_b8_PhraseStatus::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_B8_PHRASESTATUS;
}


cmb_fi_tcl_b8_PhraseStatus::~cmb_fi_tcl_b8_PhraseStatus()
{}

tU32 cmb_fi_tcl_b8_PhraseStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& cmb_fi_tcl_b8_PhraseStatus::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& cmb_fi_tcl_b8_PhraseStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
cmb_fi_tcl_TTSPhraseInfo::cmb_fi_tcl_TTSPhraseInfo(const cmb_fi_tcl_TTSPhraseInfo& coRef)
   : cmb_fi_tclVisitableTypeBase(coRef)
{
   PhraseNumber = coRef.PhraseNumber;
   Phrase = coRef.Phrase;
   PhraseLength = coRef.PhraseLength;
   PhraseSize = coRef.PhraseSize;
   Speakable = coRef.Speakable;
   PhraseStatus = coRef.PhraseStatus;
}
cmb_fi_tcl_TTSPhraseInfo& cmb_fi_tcl_TTSPhraseInfo::operator=(const cmb_fi_tcl_TTSPhraseInfo& coRef)
{
   if (this == &coRef) return *this;
   PhraseNumber = coRef.PhraseNumber;
   Phrase = coRef.Phrase;
   PhraseLength = coRef.PhraseLength;
   PhraseSize = coRef.PhraseSize;
   Speakable = coRef.Speakable;
   PhraseStatus = coRef.PhraseStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

cmb_fi_tcl_TTSPhraseInfo::cmb_fi_tcl_TTSPhraseInfo()
:PhraseNumber(0)
,Phrase()
,PhraseLength(0)
,PhraseSize(0)
,Speakable(0)
,PhraseStatus()
 {}

tS32 cmb_fi_tcl_TTSPhraseInfo::s32GetTypeId() const
{
   return (tS32) cmb_typesfi_tclToken::EN_TTSPHRASEINFO;
}


cmb_fi_tcl_TTSPhraseInfo::~cmb_fi_tcl_TTSPhraseInfo()
{}

tU32 cmb_fi_tcl_TTSPhraseInfo::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   if (u16MajorVersion <= 3)
   {
      u32DynamicSize += 2;
   }
   if (4 <= u16MajorVersion)
   {
      u32DynamicSize += 3;
   }
   if (u16MajorVersion <= 4)
   {
      u32DynamicSize += 1;
   }
   if (5 <= u16MajorVersion)
   {
      u32DynamicSize += 1;
   }
   return u32DynamicSize+6;
}

fi_tclInContext& cmb_fi_tcl_TTSPhraseInfo::oRead(fi_tclInContext& oIn)
{
   if (oIn.u16GetMajorVersion() <= 3)
   {
      (tVoid) (oIn >> PhraseNumber);
   }
   if (4 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> Phrase);
   }
   (tVoid) (oIn >> PhraseLength);
   (tVoid) (oIn >> PhraseSize);
   if (oIn.u16GetMajorVersion() <= 4)
   {
      (tVoid) (oIn >> Speakable);
   }
   if (5 <= oIn.u16GetMajorVersion())
   {
      (tVoid) (oIn >> PhraseStatus);
   }
   return oIn;
}

fi_tclOutContext& cmb_fi_tcl_TTSPhraseInfo::oWrite(fi_tclOutContext& oOut) const
{
   if (oOut.u16GetMajorVersion() <= 3)
   {
      (tVoid) (oOut << PhraseNumber);
   }
   if (4 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << Phrase);
   }
   (tVoid) (oOut << PhraseLength);
   (tVoid) (oOut << PhraseSize);
   if (oOut.u16GetMajorVersion() <= 4)
   {
      (tVoid) (oOut << Speakable);
   }
   if (5 <= oOut.u16GetMajorVersion())
   {
      (tVoid) (oOut << PhraseStatus);
   }
   return oOut;
}

tBool cmb_fi_tcl_TTSPhraseInfo::operator==(const cmb_fi_tcl_TTSPhraseInfo& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (PhraseNumber == roRef.PhraseNumber);
   bResult = bResult && (Phrase == roRef.Phrase);
   bResult = bResult && (PhraseLength == roRef.PhraseLength);
   bResult = bResult && (PhraseSize == roRef.PhraseSize);
   bResult = bResult && (Speakable == roRef.Speakable);
   bResult = bResult && (PhraseStatus == roRef.PhraseStatus);
   return bResult;
}

